/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRSINK_H_
#define _VRSINK_H_

#include <VrSigProc.h>

template<class iType> 
class VrSink : public VrSigProc {
private:
  unsigned int optimalSize;

public: 
  virtual const char *name() { return "VrSink"; }

  //set this if you want the sink to use smaller chunks
  //  than the maxLatency would dictate
  void setOptimalSize(unsigned int s) { optimalSize = s;} 

  virtual void setup();
  void setup_upstream(); 

  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]) {
    return work3 (output, inputs, i);
  };

  virtual int work3(VrSampleRange output, 
		    VrSampleRange inputs[], void *i[]) = 0; 

  VrSink() : VrSigProc(0, sizeof(iType), 0),
	     optimalSize(0x70000000){ }
};

template <class iType> void
VrSink<iType>::setup()
{
  VrSink<iType>::setup_upstream();
}

template <class iType> void
VrSink<iType>::setup_upstream()
{
  float m = memoryTouched(); //returns memory accesses / second of chain

  //Compute a globally optimal size to run on for the whole chain
  //(every input and output stays in cache for entire length of chain)
  unsigned int cachedSize = (int) (cacheSize * (getSamplingFrequency() / m));

  fprintf(stderr,"%s cachedSize = %d\n",name(),cachedSize);
  if(cachedSize/getSamplingFrequency() > maxLatency) {
    fprintf(stderr,"   reducing latency from %f",cachedSize/getSamplingFrequency());
    cachedSize = (unsigned int) (getSamplingFrequency() * maxLatency);
    fprintf(stderr," to %f seconds\n",cachedSize/getSamplingFrequency());
  }
  if(optimalSize < cachedSize) {
    fprintf(stderr,"   manually specified optimalSize of %d (%f sec)\n",optimalSize,optimalSize/getSamplingFrequency());
    cachedSize=optimalSize;
  }
  //round down
  if((cachedSize % getOutputSize()) != 0) {
    cachedSize = (cachedSize/getOutputSize()) * getOutputSize();
  }
  if(cachedSize==0) cachedSize=getOutputSize(); 
  maxDSReadSize=optimalSize=cachedSize;

  VrSigProc::setup_upstream(); 
}

#endif

