/* -*- Mode: c++ -*-  */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _VRBITS2SYMBOLS_H_
#define _VRBITS2SYMBOLS_H_

#include <VrSigProc.h>


class VrBits2Symbols : public VrSigProc {
protected:
  int valid_bits, output_bits;
  u_char current_data;
public:
  VrBits2Symbols(int);

  virtual void setOutputBits(int b){
    // bug here -> doesn't deal with state properly
    output_bits = b;
    current_data = 0x0;
    valid_bits =0;
  };
  virtual int work(VrSampleRange output, void *o[], VrSampleRange inputs[], void *i[]);
};

int VrBits2Symbols::work(VrSampleRange output, void *ao[],
				VrSampleRange inputs[], void *ai[])
{
  char **i = (char **)ai;
  char **o = (char **)ao;
  int size = output.size, bits_done;
  u_char out;


  while(size-- > 0) {


    bits_done = 0;
    out = 0x00;

    while (bits_done < output_bits){
    
      if (valid_bits == 0) {
      
	current_data = *i[0]++;
	//	printf("\n %x ", current_data);
	valid_bits = 8;
      }
    
      out = (out<<1) + (current_data>>7);  /* msb from current_data becomes lsb of output */
      current_data = current_data << 1;
      valid_bits--;
      bits_done++;    
    }

    //printf(" %x ", out);
    //if (out > 16) printf("***** Bad result here: size = %d\n", size);
    *o[0]++ = out;
  }
  return output.size;
}

VrBits2Symbols::VrBits2Symbols(int bits)
  : VrSigProc(1, sizeof(char), sizeof(char))
{
  output_bits = bits;
  valid_bits = 0;
}


#endif







