/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 *  Created by Sunil K. Rao, January 18th, 2000
 *
 * Allows one input to be connected to the output with no copying overhead.
 */

#ifndef _VRMUX_H_
#define _VRMUX_H_

#include <VrSigProc.h>


template<class T> class VrMUXBuffer;
template<class T> 
class VrMUX : public VrSigProc {
  friend class VrMUXBuffer<T>;
protected:
  unsigned int selectedInput;
public: 
  virtual const char *name() { return "VrMUX"; }
  /*
  virtual int forecast(VrSampleRange output,
		       VrSampleRange inputs[]);
  */
  virtual int work(VrSampleRange output, void *ao[],
		VrSampleRange inputs[], void *ai[]);
  virtual int input(int n) {
  	selectedInput = n;
  	return 0;
	}
  VrMUX(): VrSigProc(1,sizeof(T),sizeof(T)) { input(0); }
  virtual ~VrMUX() {}
};

#if 0
template<class T> int
VrMUX<T>::forecast(VrSampleRange output,
		   VrSampleRange inputs[]) {
  printf("numberInputs is %d\n", numberInputs);
  for(unsigned int i=0;i<numberInputs;i++) {
    if(i==selectedInput) {
      inputs[i].index=output.index;
      inputs[i].size=output.size;
    } else {
      inputs[i].index=output.index; //skip data on other inputs
      inputs[i].size=0;
    }
  }
  return 0;
} 
#endif

template<class T>  int
VrMUX<T>::work(VrSampleRange output, void *ao[],VrSampleRange inputs[], void *ai[])
{
    T **i = (T **)ai;
    T **o = (T **)ao;
    int size = output.size;
  
    while(size-- > 0) { 
	*o[0]++ = (oType)*i[selectedInput]++;
      }
    return output.size;
};
#endif
