/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#include <VrGUI.h>
#include <VrFileSink.h>
#include <VrSigSource.h>
#include <VrScopeSink.h>
#include <VrAudioSink.h>
#include <VrFFTSink.h>
#include <VrNullSink.h>
// #include <VrGuppiSource.h>
// #include <VrFakeGuppiSource.h>
#include <VrRealFIRfilter.h>
#include <VrComplexFIRfilter.h>
#include <VrQuadratureDemod.h>
#include <VrConnect.h>
#include <VrComplex.h>
#include <VrPerfGraph.h>
#include <VrNop.h>
#include <VrMultiTask.h>

int main(int argc, char **argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *main_layout = guimain->top->horizontal();

  int gupRate;
  int CFIRdecimate;
  int quadRate;
  int RFIRdecimate;
  int audioRate;
  int cTaps;
  //  double chanfreq = 10700000.0-4561333.333333; //relative freq of walkie-talke (?)
  double chanfreq = 10700000.0;

  double seconds = 20;
  //  cacheSize=2048;
  maxLatency=.05;

  int threads = 0;
  if (argc > 1)
    threads = atoi(argv[1]);

  if(argc > 2) {
    cTaps = atoi(argv[2]);
    if(cTaps <1 || cTaps > 2000) cTaps =100;
  } else
  cTaps = 100;

  gupRate = 33000000;
  CFIRdecimate = 825;
  quadRate = gupRate / CFIRdecimate;
  RFIRdecimate = 5;
  audioRate = quadRate / RFIRdecimate;

  cerr << "GuPPI Sampling Rate: " << gupRate << endl;
  cerr << "Complex FIR ("<<cTaps<<" taps) decimation factor: " << CFIRdecimate << endl;
  cerr << "QuadDemod Sampling Rate: " << quadRate << endl;
  cerr << "Real FIR decimation factor: " << RFIRdecimate << endl;
  cerr << "Audio Sampling Rate: " << audioRate << endl;

  // Create Modules
  //jca VrGuppiSource<char>* source = new VrGuppiSource<char>();
  //VrFakeGuppiSource<char>* source = new VrFakeGuppiSource<char>(gupRate);
  VrSigSource<char>* source = new VrSigSource<char>(gupRate, VR_SQUARE_WAVE,10700001,100);
  VrFFTSink<char>* wsink = new VrFFTSink<char>(main_layout, 0, 200, 1024); //.511

  VrComplexFIRfilter<char>* channel_filter = 
    new VrComplexFIRfilter<char>(CFIRdecimate,cTaps, chanfreq,2.0);
  VrFFTSink<complex>* csink = new VrFFTSink<complex>(main_layout, 0, 200, 1024); //.2

  VrQuadratureDemod<float>* demod = new  VrQuadratureDemod<float>(5000.0);
  VrRealFIRfilter<float,short>* if_filter = new VrRealFIRfilter<float,short>(RFIRdecimate,4000.0,20,5.0);
  
  VrScopeSink<short>* psink = new VrScopeSink<short>(main_layout, 0.126, -65000, 65000, 1024);
  //VrAudioSink<short>* sink = new VrAudioSink<short>();
  //VrFFTSink<short>* sink = new VrFFTSink<short>(1024,.2); //,-20000,+20000,0,300);
  VrFileSink<short>* sink = new VrFileSink<short>();
  
  // Connect Modules

  CONNECT(wsink, source, gupRate, 8);
  CONNECT(csink, channel_filter, quadRate, 64);
  
  CONNECT(psink, if_filter, audioRate, 16);
  CONNECT(sink, if_filter, audioRate, 16);
  CONNECT(if_filter, demod, quadRate, 32);
  CONNECT(demod, channel_filter, quadRate, 64);
  CONNECT(channel_filter, source, gupRate, 8);

#ifdef THREADS
  VrMultiTask *m;

  if(threads) {
    cerr<<threads<<" threads."<<endl;
    m = new VrMultiTask(threads);
  } else
    m = new VrMultiTask();
#else
  VrMultiTask *m = new VrMultiTask();
#endif
  m->add(sink);  
  m->add(wsink);  
  m->add(csink);  
  m->add(psink);  

  // Start System
  m->start();
  guimain->start();
  while(m->elapsedTime() < seconds) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
  m->stop();

  cerr<<"WP: "<<(sink->getWP())<<endl;
  cerr<<"time source: "<<(source->getWP()/source->getSamplingFrequency())<<endl;
  cerr<<"time sink: "<<(sink->getWP()/sink->getSamplingFrequency())<<endl;

#ifdef PERFMON
  m->print_stats();
#endif

  cerr << endl << "Running time: "<<seconds<<endl;

#ifdef PERFMON
  VrPerfGraph *g=m->getGraph();
  g->setTitle("Single channel FM audio receive");
  g->outputGraph(seconds);
#endif
}
