/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 *    Created Oct 19, 1999 Matt Welborn
 */
#define FOUR  1
#define EIGHT 0
#define SYNC_VERSION        1
#define PULSE_VERSION       0

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrDigMod.h"
#include "VrFFTSink.h"
#include "VrSyncFilter.h"
#include "VrCorr.h"
#include "VrComplexPlotSink.h"
#include "VrUDPSource.h"
#include "VrFileSink.h"
#include "VrScopeSink.h"
#include "VrAWGN.h"
#include "VrMultiTask.h"
#include "VrGUI.h"

#define DEFAULT_TPD	2600.0
int process_one = 1;
int persistent = 0;

VrSyncFilter<char>* filter2;
VrScopeSink<int> *scopesink;
VrCorr<VrComplex, int>* corr; 

int center_freq_mult = 4; //jca 4;
int out_rate = 400000; //400000;
int symbol_rate = 2000; //2000; 
int corr_rate = 2000 * 10;

void set_clear()
{
  scopesink->clear();
}
void set_corr(double f)
{
  printf ("set Corr period %f\n", f);
  corr -> setCorr_Period((int)f);
}
void set_my_scale(double f) {
printf ("set Sync period %f\n", f);
//scopesink->setScale(f);
  scopesink->clear();
  corr -> setSync_Period((int)f);
}
void set_persistent()
{
	persistent = 1 - persistent;
	scopesink->set_persistent(persistent);
}

int main(int argc,char** argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  int dec_corr = out_rate/corr_rate;
  VrUDPSource<char>* source = new VrUDPSource<char>(out_rate, 5001);

  filter2 = new VrSyncFilter<char>(dec_corr,50,(float)((center_freq_mult) * symbol_rate),1.0/800.0);
  corr = new VrCorr<VrComplex,int>(1, 10, 2, 4);
 
  (void) VrGUISpace(guimain->top, 10);
  (void) VrGUILabel(guimain->top, "Correlation result", 0, 30);
  VrGUILayout *scopelay_main = guimain->top->horizontal();
  VrGUILayout *scopelay = scopelay_main->vertical();
  scopesink = new VrScopeSink<int>(scopelay, DEFAULT_TPD/2, -300, 300, 500, 1);
  scopesink -> setSkip(5,0);

  VrGUILayout *scopelay2 = scopelay_main->vertical();
  VrGUILayout *scopelay_slider1 = scopelay2->vertical();
  VrGUILayout *scopelay_slider2 = scopelay2->vertical();
  (void) new VrGUIButton(scopelay2, "Store", set_persistent);
  (void) new VrGUIButton(scopelay2, "Clear", set_clear);
  (void) new VrGUISlider(scopelay_slider1, set_my_scale, "Time", DEFAULT_TPD/100, DEFAULT_TPD);
  (void) new VrGUISlider(scopelay_slider2, set_corr, "Correlation", DEFAULT_TPD/100, DEFAULT_TPD);
  (void) VrGUISpace(scopelay2, 120);

  VrGUILayout *scopelay2_main = guimain->top->horizontal();
  VrGUILayout *scopelay2b = scopelay2_main->vertical();
  (void) VrGUISpace(scopelay2b, 100);


  CONNECT(scopesink, corr, out_rate/dec_corr, 32);
  CONNECT(corr, filter2, out_rate / dec_corr, 64);
  CONNECT(filter2, source, out_rate, 8);


  VrMultiTask *m = new VrMultiTask();
  m->add(scopesink);  
  m->start(); 
  guimain->start();

   while(1) {
     guimain->processEvents(10 /*ms*/);
     if (1 || process_one) {
       process_one = 0;
       m->process(); 
       usleep(100000);
     }
   } /* while(1) */
}










