#!/usr/bin/env python

from gnuradio import gr, eng_notation
from gnuradio import audio, blks
from gnuradio import usrp
from gnuradio.eng_option import eng_option
from gnuradio import dbs_rx
from optparse import OptionParser
import sys
import math

from gnuradio.wxgui import stdgui, fftsink
import wx

class nbfm_rx_graph (stdgui.gui_flow_graph):
    def __init__(self,frame,panel,vbox,argv):
        stdgui.gui_flow_graph.__init__ (self,frame,panel,vbox,argv)

        ########################################################
        # Set up basic constants and parameters
        adc_rate = 64e6                              # 64 MS/s
        usrp_decim = 125
        
        IF_rate = adc_rate / usrp_decim               # 256 kS/s
        IF_decim = 8
        quad_rate = IF_rate / IF_decim                # 64 kS/s
        audio_decimation = 4
        audio_rate = quad_rate / audio_decimation     # 16 kS/s

        max_dev = 5e3
        fm_demod_gain = quad_rate/(2*math.pi*max_dev*3)   # *3  for headroom
        volume = 1.0

        #########################################################
        # Set up USRP, dboard, and frequencies

        src = usrp.source_c (0, usrp_decim)      # Set up USRP, set decim rate
        
        dbs = dbs_rx.dbs_rx (src, 0)
        dbs.turn_on()
        dbs._set_ade(1)
        dbs.set_bw(4e6)

        dbs.set_gain(104)
        self.dbs = dbs
        
        RF_freq = parseargs(argv[1:])
        actual_RF_freq = dbs.set_freq(RF_freq)

        IF1_freq = RF_freq - actual_RF_freq
        IF2_freq = 50e3
        print "RF,actual_RF,IF1,IF2 Freq",RF_freq,actual_RF_freq,IF1_freq,IF2_freq
        
        # usrp is data source
        #src = usrp.source_c (0, usrp_decim)      # Set up USRP, set decim rate
        src.set_rx_freq (0, IF2_freq - IF1_freq)          # Tune it to correct freq

        IF_freq = IF2_freq + src.rx_freq(0)     # compute actual IF freq

        ########################################################
        # Instantiate Blocks
        
        # Create filter to get actual channel we want
        chan_coeffs = gr.firdes.low_pass (1.0,                # gain
                                          IF_rate,            # sampling rate
                                          17e3,               # low pass cutoff freq
                                          4e3,                # width of trans. band
                                          gr.firdes.WIN_HANN) # filter type 

        print len(chan_coeffs)
        # Decimating Channel filter with frequency translation
        # complex in and out, float taps
        ddc = gr.freq_xlating_fir_filter_ccf (IF_decim,       # decimation rate
                                              chan_coeffs,    # taps
                                              -IF_freq+10e3,       # frequency translation amount
                                              IF_rate)        # input sample rate

        # squelch input: complex; output: complex
        squelch_threshold = 50        # dB
        squelch = gr.simple_squelch_cc (squelch_threshold, 0.001)

        # FM Demodulator   input: complex; output: float
        fm_demod = gr.quadrature_demod_cf (volume*fm_demod_gain)

        # FM Deemphasis IIR filter
        deemph = blks.fm_deemph (self, quad_rate)

        # compute FIR filter taps for audio filter
        audio_coeffs = gr.firdes.low_pass (1.0,            # gain
                                           quad_rate,      # sampling rate
                                           4.5e3,          # Audio LPF cutoff
                                           2.5e3,          # Transition band
                                           gr.firdes.WIN_HAMMING)  # filter type
        print len(audio_coeffs)
        
        # Decimating Audio filter
        # input: float; output: float; taps: float
        audio_filter = gr.fir_filter_fff (audio_decimation, audio_coeffs)

        # sound card as final sink
        audio_sink = audio.sink (int (audio_rate))
        
        # now wire it all together
        self.connect (src, ddc)
        self.connect (ddc, squelch)
        self.connect (squelch, fm_demod)
        #self.connect (ddc, fm_demod)
        self.connect (fm_demod, deemph)
        self.connect (deemph, audio_filter)
        self.connect (audio_filter, (audio_sink, 0))

        # FFT Displays
        if 1:
            usrp_fft, fft_win1 = fftsink.make_fft_sink_c (self, panel, "USRP Output", 512, IF_rate,50,150)
            self.connect (src, usrp_fft)
            vbox.Add (fft_win1, 1, wx.EXPAND)

        if 1:
            pre_demod, fft_win2 = fftsink.make_fft_sink_c (self, panel, "Pre - Demodulation", 512, quad_rate,0,140)
            self.connect (ddc, pre_demod)
            vbox.Add (fft_win2, 1, wx.EXPAND)

        if 0:
            post_deemph, fft_win3 = fftsink.make_fft_sink_f (self, panel, "With Deemph", 512, IF_rate,-60,40)
            self.connect (deemph,post_deemph)
            vbox.Add (fft_win3, 1, wx.EXPAND)

        if 0:
            post_filt, fft_win4 = fftsink.make_fft_sink_f (self, panel, "Post Filter", 512, audio_rate,-60,40)
            self.connect (audio_filter,post_filt)
            vbox.Add (fft_win4, 1, wx.EXPAND)
        
def parseargs (args):
    nargs = len (args)
    if nargs == 1:
        return( float (args[0]))
    else:
        sys.stderr.write ('usage: nbfm_rcv freq\n')
        sys.exit (1)

if __name__ == '__main__':
    app = stdgui.stdapp (nbfm_rx_graph, "NBFM RX")
    app.MainLoop ()

