/* -*- c++ -*- */
/*
 * Copyright 2004,2005 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

%feature("autodoc", "1");		// generate python docstrings

%include "exception.i"
%import "gnuradio.i"				// the common stuff (FIXME gnuradio-core.i)

%{
#include "gnuradio_swig_bug_workaround.h"	// mandatory bug fix
#include "mc4020_source.h"
#include "mc4020_bitmask.h"
#include <stdexcept>
%}

%include "mc4020_bitmask.h"			// defines for MCC_* constants


GR_SWIG_BLOCK_MAGIC(mc4020,source)


// public shared_ptr constructor

mc4020_source_sptr
mc4020_make_source (double sampling_freq = 20e6,
		    unsigned long config_bitmask = MCC_CH0_EN | MCC_ALL_5V,
		    const std::string dev = "/dev/mc4020_0") throw (std::runtime_error);

/*!
 * \brief high speed A/D source using Measurement Computing PCI-DAS4020/12
 */
class mc4020_source : public gr_sync_block {
 private:
  mc4020_source (double sampling_freq,
		 unsigned long config_bitmask, const std::string dev);

 public:
  ~mc4020_source ();
};
