

module halfband_decim
  (input clock, input reset, input enable, input strobe_in, input strobe_out,
   input wire [15:0] data_in, output wire [15:0] data_out);

   reg [2:0] coeff_addr;
   reg [3:0] rd_addr1;
   reg [3:0] rd_addr2;

   wire [15:0] mac_out;
   wire [15:0] middle_data;

   wire [15:0] rd_data1, rd_data2, coeff;

   wire        clear = 1'b0;

   reg [3:0]   base_addr;
   always @(posedge clock)
     if(reset)
       base_addr <= #1 0;
     else if(strobe_out)
       base_addr <= #1 base_addr + 1;
   
   reg [3:0]   phase;
   always @(posedge clock)
     if(reset)
       phase <= #1 0;
     else if(strobe_out)
       phase <= #1 1;
     else if(phase == 8)
       phase <= #1 0;
     else if(phase != 0)
       phase <= #1 phase + 1;

   always @*
     case(phase)
       4'd0 : begin rd_addr1 = base_addr + 0; rd_addr2 = base_addr + 15; coeff_addr = phase; end
       4'd1 : begin rd_addr1 = base_addr + 1; rd_addr2 = base_addr + 14; coeff_addr = phase; end
       4'd2 : begin rd_addr1 = base_addr + 2; rd_addr2 = base_addr + 13; coeff_addr = phase; end
       4'd3 : begin rd_addr1 = base_addr + 3; rd_addr2 = base_addr + 12; coeff_addr = phase; end
       4'd4 : begin rd_addr1 = base_addr + 4; rd_addr2 = base_addr + 11; coeff_addr = phase; end
       4'd5 : begin rd_addr1 = base_addr + 5; rd_addr2 = base_addr + 10; coeff_addr = phase; end
       4'd6 : begin rd_addr1 = base_addr + 6; rd_addr2 = base_addr + 9; coeff_addr = phase; end
       4'd7 : begin rd_addr1 = base_addr + 7; rd_addr2 = base_addr + 8; coeff_addr = phase; end
       4'd8 : begin rd_addr1 = base_addr + 8; rd_addr2 = base_addr + 7; coeff_addr = phase; end
       default: begin rd_addr1 = base_addr + 0; rd_addr2 = base_addr + 15; coeff_addr = phase; end
     endcase // case(phase)
   
   coeff_rom coeff_rom (.clock(clock),.addr(coeff_addr),.data(coeff));
   
   ram16_2port ram16_even (.clock(clock),.write(strobe_in & ~strobe_out),
			   .wr_addr(base_addr),.wr_data(data_in),
			   .rd_addr1(rd_addr1),.rd_data1(rd_data1),
			   .rd_addr2(rd_addr2),.rd_data2(rd_data2));

   ram16 ram16_odd (.clock(clock),.write(strobe_in & strobe_out),  // Holds middle items
		    .wr_addr(base_addr),.wr_data(data_in),
		    .rd_addr(base_addr+4'd8),.rd_data(middle_data));
   
   mac mac(.clock(clock),.reset(reset),.enable(enable),.clear(clear),
	   .x(rd_data1 + rd_data2),.y(coeff),.shift(8'd8),.z(mac_out));

   assign      data_out = mac_out + middle_data;                  // FIXME should scale this
       
endmodule // halfband_decim
