/*
 * Copyright (C) 2009, 2010 Free Software Foundation, Inc.
 *
 * Author: Simon Josefsson
 *
 * This file is part of GnuTLS.
 *
 * GnuTLS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GnuTLS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GnuTLS; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
 * Small code to reproduce the CVE-2009-1416 bad DSA key problem.
 *
 * Build it using:
 *
 *  gcc -o cve-2009-1416 cve-2009-1416.c -lgnutls
 *
 * If your gnutls library is OK then running it will print 'success!'.
 *
 * If your gnutls library is buggy then running it will print 'buggy'.
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include <gcrypt.h>
#include <gnutls/gnutls.h>
#include <gnutls/x509.h>

int
main (void)
{
  gnutls_x509_privkey_t key;
  gnutls_datum_t p, q, g, y, x;
  int ret;

  gnutls_global_init ();

  ret = gnutls_x509_privkey_init (&key);
  if (ret < 0)
    return 1;

  ret = gnutls_x509_privkey_generate (key, GNUTLS_PK_DSA, 512, 0);
  if (ret < 0)
    return 1;

  ret = gnutls_x509_privkey_export_dsa_raw (key, &p, &q, &g, &y, &x);
  if (ret < 0)
    return 1;

  if (q.size == 3 && memcmp (q.data, "\x01\x00\x01", 3) == 0)
    {
      printf ("buggy\n");
      return 1;
    }
  else
    printf ("success!\n");

  gnutls_free (p.data);
  gnutls_free (q.data);
  gnutls_free (g.data);
  gnutls_free (y.data);
  gnutls_free (x.data);

  gnutls_x509_privkey_deinit (key);
  gnutls_global_deinit ();

  return 0;
}
