/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#include <ctype.h>

#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "support.h"
#include "recipe_win.h"
#include "nutrgoal_io.h"
#include "nutr_goal_dlg.h"

/* Display nutrient goal dialog. */
void
on_mw_nutr_goal_released( GtkButton *button,
                          gpointer   user_data)
{
	GladeXML *xml = gnutr_ret_xml();
	GtkWidget *widget, *entry;
	Recipe_t *recipe = gnutr_ret_recipe();
	gchar *text;

	/* set the text entries. */

	/* macro-nutrients. */
	entry = glade_xml_get_widget( xml, "protein_gdlg_entry");
	text = ftoa( recipe->nutr->goal[0]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_gdlg_entry");
	text = ftoa( recipe->nutr->goal[1]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "sat_fat_gdlg_entry");
	text = ftoa( recipe->nutr->goal[52]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mono_fat_gdlg_entry");
	text = ftoa( recipe->nutr->goal[76]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "poly_fat_gdlg_entry");
	text = ftoa( recipe->nutr->goal[77]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "carb_gdlg_entry");
	text = ftoa( recipe->nutr->goal[2]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "chol_gdlg_entry");
	text = ftoa( recipe->nutr->goal[51]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fiber_gdlg_entry");
	text = ftoa( recipe->nutr->goal[11]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "kj_gdlg_entry");
	text = ftoa( recipe->nutr->goal[9]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "kcal_gdlg_entry");
	text = ftoa( recipe->nutr->goal[4]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* micro-nutrients. */
	entry = glade_xml_get_widget( xml, "vita_gdlg_entry");
	text = ftoa( recipe->nutr->goal[22]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vite_gdlg_entry");
	text = ftoa( recipe->nutr->goal[24]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitc_gdlg_entry");
	text = ftoa( recipe->nutr->goal[25]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "thia_gdlg_entry");
	text = ftoa( recipe->nutr->goal[26]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "ribo_gdlg_entry");
	text = ftoa( recipe->nutr->goal[27]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "nia_gdlg_entry");
	text = ftoa( recipe->nutr->goal[28]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "panto_gdlg_entry");
	text = ftoa( recipe->nutr->goal[29]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitb6_gdlg_entry");
	text = ftoa( recipe->nutr->goal[30]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fol_gdlg_entry");
	text = ftoa( recipe->nutr->goal[31]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitb12_gdlg_entry");
	text = ftoa( recipe->nutr->goal[32]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "ca_gdlg_entry");
	text = ftoa( recipe->nutr->goal[12]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fe_gdlg_entry");
	text = ftoa( recipe->nutr->goal[13]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mg_gdlg_entry");
	text = ftoa( recipe->nutr->goal[14]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "p_gdlg_entry");
	text = ftoa( recipe->nutr->goal[15]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "k_gdlg_entry");
	text = ftoa( recipe->nutr->goal[16]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "na_gdlg_entry");
	text = ftoa( recipe->nutr->goal[17]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "zn_gdlg_entry");
	text = ftoa( recipe->nutr->goal[18]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "cu_gdlg_entry");
	text = ftoa( recipe->nutr->goal[19]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mn_gdlg_entry");
	text = ftoa( recipe->nutr->goal[20]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "se_gdlg_entry");
	text = ftoa( recipe->nutr->goal[21]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* proteins */
	entry = glade_xml_get_widget( xml, "tryp_gdlg_entry");
	text = ftoa( recipe->nutr->goal[33]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "thre_gdlg_entry");
	text = ftoa( recipe->nutr->goal[34]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "isol_gdlg_entry");
	text = ftoa( recipe->nutr->goal[35]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "leuc_gdlg_entry");
	text = ftoa( recipe->nutr->goal[36]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "lysi_gdlg_entry");
	text = ftoa( recipe->nutr->goal[37]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "meth_gdlg_entry");
	text = ftoa( recipe->nutr->goal[38]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "cyst_gdlg_entry");
	text = ftoa( recipe->nutr->goal[39]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "phen_gdlg_entry");
	text = ftoa( recipe->nutr->goal[40]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "tyro_gdlg_entry");
	text = ftoa( recipe->nutr->goal[41]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vali_gdlg_entry");
	text = ftoa( recipe->nutr->goal[42]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "argi_gdlg_entry");
	text = ftoa( recipe->nutr->goal[43]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "hist_gdlg_entry");
	text = ftoa( recipe->nutr->goal[44]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "alan_gdlg_entry");
	text = ftoa( recipe->nutr->goal[45]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "aspa_gdlg_entry");
	text = ftoa( recipe->nutr->goal[46]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "glut_gdlg_entry");
	text = ftoa( recipe->nutr->goal[47]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "glyc_gdlg_entry");
	text = ftoa( recipe->nutr->goal[48]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "prol_gdlg_entry");
	text = ftoa( recipe->nutr->goal[49]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "seri_gdlg_entry");
	text = ftoa( recipe->nutr->goal[50]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* fats */
	entry = glade_xml_get_widget( xml, "fat_4d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[53]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_6d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[54]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_8d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[55]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_10d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[56]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_12d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[57]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_14d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[58]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_16d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[59]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[60]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[61]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d1_gdlg_entry");
	text = ftoa( recipe->nutr->goal[62]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d2_gdlg_entry");
	text = ftoa( recipe->nutr->goal[63]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d3_gdlg_entry");
	text = ftoa( recipe->nutr->goal[64]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d4_gdlg_entry");
	text = ftoa( recipe->nutr->goal[65]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d6_gdlg_entry");
	text = ftoa( recipe->nutr->goal[66]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[67]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_14d1_gdlg_entry");
	text = ftoa( recipe->nutr->goal[68]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_16d1_gdlg_entry");
	text = ftoa( recipe->nutr->goal[69]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d4_gdlg_entry");
	text = ftoa( recipe->nutr->goal[70]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d1_gdlg_entry");
	text = ftoa( recipe->nutr->goal[71]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d5_gdlg_entry");
	text = ftoa( recipe->nutr->goal[72]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d1_gdlg_entry");
	text = ftoa( recipe->nutr->goal[73]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d5_gdlg_entry");
	text = ftoa( recipe->nutr->goal[74]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_15d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[78]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_17d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[79]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_24d0_gdlg_entry");
	text = ftoa( recipe->nutr->goal[80]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* miscelaneous */
	entry = glade_xml_get_widget( xml, "ash_gdlg_entry");
	text = ftoa( recipe->nutr->goal[3]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "alco_gdlg_entry");
	text = ftoa( recipe->nutr->goal[5]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "water_gdlg_entry");
	text = ftoa( recipe->nutr->goal[6]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "phyto_gdlg_entry");
	text = ftoa( recipe->nutr->goal[75]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "theob_gdlg_entry");
	text = ftoa( recipe->nutr->goal[8]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "caff_gdlg_entry");
	text = ftoa( recipe->nutr->goal[7]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "sugar_gdlg_entry");
	text = ftoa( recipe->nutr->goal[10]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* display the dialog. */
	widget = glade_xml_get_widget( xml, "nutr_goal_dlg");
	gtk_widget_show( widget);
}

/* get the values from the nutrient goal dialog so that they can be saved
 * to file. */
void
get_changed_nutr_goal() 
{
	GtkWidget *entry;
	GladeXML *xml = NULL;
	Recipe_t *recipe = NULL;

	xml = gnutr_ret_xml();
	recipe = gnutr_ret_recipe();

	/* FIXME: At some stage I need to check that the text returned
	 * from the entry makes sense as a number before I change it to
	 * a float. If not, call a warning. */

	/* macro-nutrients. */
	entry = glade_xml_get_widget( xml, "protein_gdlg_entry");
	recipe->nutr->goal[0] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_gdlg_entry");
	recipe->nutr->goal[1] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "sat_fat_gdlg_entry");
	recipe->nutr->goal[52] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "mono_fat_gdlg_entry");
	recipe->nutr->goal[76] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "poly_fat_gdlg_entry");
	recipe->nutr->goal[77] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "carb_gdlg_entry");
	recipe->nutr->goal[2] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "chol_gdlg_entry");
	recipe->nutr->goal[51] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fiber_gdlg_entry");
	recipe->nutr->goal[11] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "kj_gdlg_entry");
	recipe->nutr->goal[9] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "kcal_gdlg_entry");
	recipe->nutr->goal[4] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	/* micro-nutrients. */
	entry = glade_xml_get_widget( xml, "vita_gdlg_entry");
	recipe->nutr->goal[22] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "vite_gdlg_entry");
	recipe->nutr->goal[24] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "vitc_gdlg_entry");
	recipe->nutr->goal[25] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "thia_gdlg_entry");
	recipe->nutr->goal[26] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "ribo_gdlg_entry");
	recipe->nutr->goal[27] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "nia_gdlg_entry");
	recipe->nutr->goal[28] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "panto_gdlg_entry");
	recipe->nutr->goal[29] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "vitb6_gdlg_entry");
	recipe->nutr->goal[30] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fol_gdlg_entry");
	recipe->nutr->goal[31] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "vitb12_gdlg_entry");
	recipe->nutr->goal[32] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "ca_gdlg_entry");
	recipe->nutr->goal[12] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fe_gdlg_entry");
	recipe->nutr->goal[13] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "mg_gdlg_entry");
	recipe->nutr->goal[14] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "p_gdlg_entry");
	recipe->nutr->goal[15] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "k_gdlg_entry");
	recipe->nutr->goal[16] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "na_gdlg_entry");
	recipe->nutr->goal[17] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "zn_gdlg_entry");
	recipe->nutr->goal[18] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "cu_gdlg_entry");
	recipe->nutr->goal[19] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "mn_gdlg_entry");
	recipe->nutr->goal[20] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "se_gdlg_entry");
	recipe->nutr->goal[21] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	/* proteins */
	entry = glade_xml_get_widget( xml, "tryp_gdlg_entry");
	recipe->nutr->goal[33] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "thre_gdlg_entry");
	recipe->nutr->goal[34] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "isol_gdlg_entry");
	recipe->nutr->goal[35] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "leuc_gdlg_entry");
	recipe->nutr->goal[36] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "lysi_gdlg_entry");
	recipe->nutr->goal[37] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "meth_gdlg_entry");
	recipe->nutr->goal[38] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "cyst_gdlg_entry");
	recipe->nutr->goal[39] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "phen_gdlg_entry");
	recipe->nutr->goal[40] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "tyro_gdlg_entry");
	recipe->nutr->goal[41] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "vali_gdlg_entry");
	recipe->nutr->goal[42] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "argi_gdlg_entry");
	recipe->nutr->goal[43] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "hist_gdlg_entry");
	recipe->nutr->goal[44] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "alan_gdlg_entry");
	recipe->nutr->goal[45] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "aspa_gdlg_entry");
	recipe->nutr->goal[46] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "glut_gdlg_entry");
	recipe->nutr->goal[47] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "glyc_gdlg_entry");
	recipe->nutr->goal[48] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "prol_gdlg_entry");
	recipe->nutr->goal[49] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "seri_gdlg_entry");
	recipe->nutr->goal[50] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	/* fats */
	entry = glade_xml_get_widget( xml, "fat_4d0_gdlg_entry");
	recipe->nutr->goal[53] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_6d0_gdlg_entry");
	recipe->nutr->goal[54] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_8d0_gdlg_entry");
	recipe->nutr->goal[55] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_10d0_gdlg_entry");
	recipe->nutr->goal[56] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_12d0_gdlg_entry");
	recipe->nutr->goal[57] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_14d0_gdlg_entry");
	recipe->nutr->goal[58] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_16d0_gdlg_entry");
	recipe->nutr->goal[59] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_18d0_gdlg_entry");
	recipe->nutr->goal[60] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_20d0_gdlg_entry");
	recipe->nutr->goal[61] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_18d1_gdlg_entry");
	recipe->nutr->goal[62] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_18d2_gdlg_entry");
	recipe->nutr->goal[63] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_18d3_gdlg_entry");
	recipe->nutr->goal[64] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_20d4_gdlg_entry");
	recipe->nutr->goal[65] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_22d6_gdlg_entry");
	recipe->nutr->goal[66] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_22d0_gdlg_entry");
	recipe->nutr->goal[67] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_14d1_gdlg_entry");
	recipe->nutr->goal[68] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_16d1_gdlg_entry");
	recipe->nutr->goal[69] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_18d4_gdlg_entry");
	recipe->nutr->goal[70] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_20d1_gdlg_entry");
	recipe->nutr->goal[71] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_20d5_gdlg_entry");
	recipe->nutr->goal[72] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_22d1_gdlg_entry");
	recipe->nutr->goal[73] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_22d5_gdlg_entry");
	recipe->nutr->goal[74] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_15d0_gdlg_entry");
	recipe->nutr->goal[78] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_17d0_gdlg_entry");
	recipe->nutr->goal[79] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "fat_24d0_gdlg_entry");
	recipe->nutr->goal[80] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	/* miscelaneous */
	entry = glade_xml_get_widget( xml, "ash_gdlg_entry");
	recipe->nutr->goal[3] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "alco_gdlg_entry");
	recipe->nutr->goal[5] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "water_gdlg_entry");
	recipe->nutr->goal[6] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "phyto_gdlg_entry");
	recipe->nutr->goal[75] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "theob_gdlg_entry");
	recipe->nutr->goal[8] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "caff_gdlg_entry");
	recipe->nutr->goal[7] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

	entry = glade_xml_get_widget( xml, "sugar_gdlg_entry");
	recipe->nutr->goal[10] = atof( gtk_entry_get_text( GTK_ENTRY( entry)));

}

/* When The "OK" button is released in the nutrient goal dialog - save 
 * the nutrient goals and hide the dialog. */
void
on_ok_gdlg_button_released( GtkButton *button,
                            gpointer   user_data)
{
	GladeXML *xml = gnutr_ret_xml();
	Recipe_t *recipe = gnutr_ret_recipe();
	GtkWidget *widget = glade_xml_get_widget( xml, "nutr_goal_dlg");

	get_changed_nutr_goal();
	gnutr_write_nutr_goal( recipe->nutr);

	gtk_widget_hide( widget);
}

/* When the "Cancel" button is released in the nutrient goal dialog - hide 
 * the nutrient goal dialog. */
void
on_cancel_gdlg_button_released( GtkButton *button,
                                gpointer   user_data)
{
	GladeXML *xml = gnutr_ret_xml();
	GtkWidget *widget = glade_xml_get_widget( xml, "nutr_goal_dlg");
	gtk_widget_hide( widget);
}

/* When the "Apply" button released in the nutrient goal dialog - save the 
 * nutrient goals to file. */
void
on_apply_gdlg_button_released( GtkButton *button,
                               gpointer   user_data)
{
	Recipe_t *recipe = gnutr_ret_recipe();
	get_changed_nutr_goal();
	gnutr_write_nutr_goal( recipe->nutr);
}
