/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright( C) 2000, 2001 Edgar Denny( e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * ( at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <ctype.h>

#include "support.h"
#include "food.h"
#include "recipe.h"
#include "recipe_srch_dlg.h"
#include "recipe_srch_res.h"
#include "wrap_mysql.h"

static void load_xml( void);
static void connect_signals( void);
static void initialize_dlg( void);

static GladeXML *xml;

/* the callbacks. */
static void on_search_button_released( GtkButton *, gpointer);
static void on_cancel_button_released( GtkButton *, gpointer);

/* connect the signals. */
static void
connect_signals()
{
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget( xml, "search_button")),
		"released", GTK_SIGNAL_FUNC( on_search_button_released), NULL);
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget( xml, "cancel_button")),
		"released", GTK_SIGNAL_FUNC( on_cancel_button_released), NULL);
}

/* initialize the dialog. */
static void
initialize_dlg()
{
	GtkWidget *combo;
	GList *cat_list = NULL;

	cat_list = get_cat_desc_list();
	cat_list = g_list_prepend( cat_list,( gpointer)"All"); 

	combo = glade_xml_get_widget( xml, "combo");
	gtk_combo_set_popdown_strings( GTK_COMBO( combo), cat_list);
}

/* load the glade xml if not already loaded. */
static void
load_xml()
{
	static gboolean loaded_xml = FALSE;

	/* load the glade interface. */
	if (  !loaded_xml) {
		xml = glade_xml_new( 
			GNUTRITION_GLADEDIR "/recipe_srch_dlg.glade", NULL);
		loaded_xml = TRUE;

		if ( xml) {
			connect_signals();
		} else {
			g_log( "Gnutrition", G_LOG_LEVEL_ERROR,
				"cannot load file: recipe_srch_dlg.glade\n");
			return;
		}
		initialize_dlg();
	}
}

/* show the dialog. */
void
gnutr_show_recipe_srch_dlg()
{
	GtkWidget *dlg;
	if ( !xml) load_xml();
	dlg = glade_xml_get_widget( xml, "recipe_srch_dlg");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* find matching recipes. */
GList *
gnutr_recipe_srch()
{
	GtkEntry *combo_entry;
	GtkEntry *srch_entry;
	char *category_desc;
	char *text_to_match = NULL;
	GList *ret_list = NULL;
	char *query;

	if ( !xml) load_xml();

	combo_entry = GTK_ENTRY( glade_xml_get_widget(  xml, "combo_entry"));
	category_desc = gtk_entry_get_text( combo_entry);

	srch_entry = GTK_ENTRY( glade_xml_get_widget( xml, "entry"));
	text_to_match = gtk_entry_get_text( srch_entry);
	if ( !text_to_match || strcmp( text_to_match, "") == 0) {
		return NULL;
	}

	if ( strcmp( category_desc, "All") == 0) {
		query = g_strconcat( "SELECT recipe_no, recipe_name FROM "
			"recipe WHERE recipe_name REGEXP "
			"'", text_to_match, "'", NULL);
		ret_list = rows_glist_ret_val_query_db( query);
		g_free( query);
	} else {
		GHashTable *htbl;
		char *category_no;

		htbl = get_htbl_cat_desc_cat_no();
		category_no = g_hash_table_lookup( htbl, (gpointer)
			category_desc);

		query = g_strconcat( "SELECT recipe_no, recipe_name FROM "
			"recipe WHERE category_no ='", category_no, "' ",
			"AND recipe_name REGEXP '", text_to_match, "'", NULL);
		ret_list = rows_glist_ret_val_query_db( query);
		g_free( query);
	}

	return ret_list;
}

/* when the "Search" button is released. */
static void
on_search_button_released( GtkButton *button,
                           gpointer user_data)
{
	GList *list = NULL;
	enum { PLAN_VIEW, RECIPE_VIEW, FOOD_VIEW};

	
	list = gnutr_recipe_srch();
	if (!list) {
		GtkWidget *warn_dlg;
		char *text;
		text = g_strdup( "No recipe found.");
		warn_dlg = gnome_warning_dialog( text);
		gtk_widget_show( warn_dlg);
		g_free( text);
		return;
	}
	gnutr_show_recipe_res_dlg( list, RECIPE_VIEW);
}

/* when the "Cancel" button is released. */
static void
on_cancel_button_released( GtkButton *button,
                           gpointer user_data)
{
	gtk_widget_hide( glade_xml_get_widget( xml, "recipe_srch_dlg")); 
}

/* hide dialog. */
void
gnutr_hide_recipe_srch_dlg()
{
	gtk_widget_hide( glade_xml_get_widget( xml, "recipe_srch_dlg")); 
}

/* return the table. */
GtkWidget *
gnutr_get_recipe_srch_table()
{
	if ( !xml) load_xml();
	return glade_xml_get_widget( xml, "table");
}

/* return the container. */
GtkWidget *
gnutr_get_recipe_srch_container()
{
	if ( !xml) load_xml();
	return glade_xml_get_widget( xml, "container");
}
