/* cairo - a vector graphics library with display and print output
 *
 * Copyright © 2002 University of Southern California
 *
 * This library is free software; you can redistribute it and/or
 * modify it either under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * (the "LGPL") or, at your option, under the terms of the Mozilla
 * Public License Version 1.1 (the "MPL"). If you do not alter this
 * notice, a recipient may use your version of this file under either
 * the MPL or the LGPL.
 *
 * You should have received a copy of the LGPL along with this library
 * in the file COPYING-LGPL-2.1; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA
 * You should have received a copy of the MPL along with this library
 * in the file COPYING-MPL-1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY
 * OF ANY KIND, either express or implied. See the LGPL or the MPL for
 * the specific language governing rights and limitations.
 *
 * The Original Code is the cairo graphics library.
 *
 * The Initial Developer of the Original Code is University of Southern
 * California.
 *
 * Contributor(s):
 *	Carl D. Worth <cworth@cworth.org>
 */

#ifndef CAIRO_SKIA_H
#define CAIRO_SKIA_H

#include "cairo.h"

#if CAIRO_HAS_SKIA_SURFACE

CAIRO_BEGIN_DECLS

cairo_public cairo_surface_t *
cairo_skia_surface_create (cairo_format_t format,
			   int width,
			   int height);

cairo_public cairo_surface_t *
cairo_skia_surface_create_for_data (unsigned char *data,
				    cairo_format_t format,
				    int width,
				    int height,
				    int stride);

cairo_public unsigned char *
cairo_skia_surface_get_data (cairo_surface_t *surface);

cairo_public cairo_format_t
cairo_skia_surface_get_format (cairo_surface_t *surface);

cairo_public int
cairo_skia_surface_get_width (cairo_surface_t *surface);

cairo_public int
cairo_skia_surface_get_height (cairo_surface_t *surface);

cairo_public int
cairo_skia_surface_get_stride (cairo_surface_t *surface);

cairo_public cairo_surface_t *
cairo_skia_surface_get_image (cairo_surface_t *surface);

CAIRO_END_DECLS

#else

# error Cairo was not compiled with support for the Skia backend

#endif

#endif
