/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef GMPVideoi420FrameImpl_h_
#define GMPVideoi420FrameImpl_h_

#include "gmp-video-frame-i420.h"
#include "mozilla/ipc/Shmem.h"
#include "GMPVideoPlaneImpl.h"

namespace mozilla {
namespace gmp {

class GMPVideoi420FrameData;

class GMPVideoi420FrameImpl : public GMPVideoi420Frame
{
  friend struct IPC::ParamTraits<mozilla::gmp::GMPVideoi420FrameImpl>;
public:
  explicit GMPVideoi420FrameImpl(GMPVideoHostImpl* aHost);
  GMPVideoi420FrameImpl(const GMPVideoi420FrameData& aFrameData, GMPVideoHostImpl* aHost);
  virtual ~GMPVideoi420FrameImpl();

  static bool CheckFrameData(const GMPVideoi420FrameData& aFrameData);

  bool InitFrameData(GMPVideoi420FrameData& aFrameData);
  const GMPPlaneImpl* GetPlane(GMPPlaneType aType) const;
  GMPPlaneImpl* GetPlane(GMPPlaneType aType);

  // GMPVideoFrame
  virtual GMPVideoFrameFormat GetFrameFormat() override;
  virtual void Destroy() override;

  // GMPVideoi420Frame
  virtual GMPErr CreateEmptyFrame(int32_t aWidth,
                                  int32_t aHeight,
                                  int32_t aStride_y,
                                  int32_t aStride_u,
                                  int32_t aStride_v) override;
  virtual GMPErr CreateFrame(int32_t aSize_y, const uint8_t* aBuffer_y,
                             int32_t aSize_u, const uint8_t* aBuffer_u,
                             int32_t aSize_v, const uint8_t* aBuffer_v,
                             int32_t aWidth,
                             int32_t aHeight,
                             int32_t aStride_y,
                             int32_t aStride_u,
                             int32_t aStride_v) override;
  virtual GMPErr CopyFrame(const GMPVideoi420Frame& aFrame) override;
  virtual void SwapFrame(GMPVideoi420Frame* aFrame) override;
  virtual uint8_t* Buffer(GMPPlaneType aType) override;
  virtual const uint8_t* Buffer(GMPPlaneType aType) const override;
  virtual int32_t AllocatedSize(GMPPlaneType aType) const override;
  virtual int32_t Stride(GMPPlaneType aType) const override;
  virtual GMPErr SetWidth(int32_t aWidth) override;
  virtual GMPErr SetHeight(int32_t aHeight) override;
  virtual int32_t Width() const override;
  virtual int32_t Height() const override;
  virtual void SetTimestamp(uint64_t aTimestamp) override;
  virtual uint64_t Timestamp() const override;
  virtual void SetDuration(uint64_t aDuration) override;
  virtual uint64_t Duration() const override;
  virtual bool IsZeroSize() const override;
  virtual void ResetSize() override;

private:
  bool CheckDimensions(int32_t aWidth, int32_t aHeight,
                       int32_t aStride_y, int32_t aStride_u, int32_t aStride_v);

  GMPPlaneImpl mYPlane;
  GMPPlaneImpl mUPlane;
  GMPPlaneImpl mVPlane;
  int32_t mWidth;
  int32_t mHeight;
  uint64_t mTimestamp;
  uint64_t mDuration;
};

} // namespace gmp

} // namespace mozilla

#endif // GMPVideoi420FrameImpl_h_
