.TH pdfroff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
pdfroff \- construct files in Portable Document Format using
.I groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2005-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_pdfroff_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY pdfroff
.RI [ groff-option ]
.RB [ \-\-emit\-ps ]
.RB [ \-\-no\-toc\-relocation ]
.RB [ \-\-no\-kill\-null\-pages ]
.RB [ \-\-stylesheet=\c
.IR name ]
.RB [ \-\-no\-pdf\-output ]
.RB [ \-\-pdf\-output=\c
.IR name ]
.RB [ \-\-no\-reference\-dictionary ]
.RB [ \-\-reference\-dictionary=\c
.IR  name ]
.RB [ \-\-report\-progress ]
.RB [ \-\-keep\-temporary\-files ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY pdfroff
.B \-h
.
.SY pdfroff
.B \-\-help
.YS
.
.
.SY pdfroff
.B \-v
.RI [ groff-option
\&.\|.\|.\&]
.
.SY pdfroff
.B \-\-version
.RI [ groff-option
\&.\|.\|.\&]
.YS
.
.
.P
.I groff-option
is any short option supported by
.MR groff @MAN1EXT@
except for
.BR \-h ,
.BR \-T ,
and
.BR \-v ;
see section \[lq]Usage\[rq] below.
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I pdfroff
is a wrapper program for the GNU text processing system,
.IR groff .
.
It transparently handles the mechanics of multiple pass
.I groff
processing,
when applied to suitably marked up
.I groff
source files,
such that tables of contents and body text are formatted separately,
and are subsequently combined in the correct order,
for final publication as a single PDF document.
.
A further optional \[lq]style sheet\[rq] capability is provided;
this allows for the definition of content which is required to precede
the table of contents,
in the published document.
.
.
.P
For each invocation of
.IR pdfroff ,
the ultimate
.I groff
output stream is post-processed by the Ghostscript
.MR gs 1
interpreter to produce a finished PDF document.
.
.
.P
.I pdfroff
makes no assumptions about,
and imposes no restrictions on,
the use of any
.I groff
macro packages which the user may choose to employ,
in order to achieve a desired document format;
however,
it
.I does
include specific built in support for the
.I \%pdfmark
macro package,
should the user choose to employ it.
.
Specifically,
if the
.I pdfhref
macro,
defined in the
.I \%pdfmark.tmac
package,
is used to define public reference marks,
or dynamic links to such reference marks,
then
.I pdfroff
performs as many preformatting
.I groff
passes as required,
up to a maximum limit of
.IR four ,
in order to compile a document reference dictionary,
to resolve
references,
and to expand the dynamically defined content of links.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The command line is parsed in accordance with normal GNU conventions,
but with one exception\(emwhen specifying any short form option
(i.e.,
a single character option introduced by a single hyphen),
and if that option expects an argument,
then it
.I must
be specified independently
(i.e.,
it may
.I not
be appended to any group of other single character short form options).
.
.
.P
Long form option names
(i.e.,
those introduced by a double hyphen)
may
be abbreviated to their minimum length unambiguous initial substring.
.
.
.P
Otherwise,
.I pdfroff
usage closely mirrors that of
.I groff
itself.
.
Indeed,
with the exception of the
.BR \-h ,
.BR \-v ,
and
.BI \-T \ dev
short form options,
and all long form options,
which are parsed
internally by
.IR pdfroff ,
all options and file name arguments specified on the command line are
passed on to
.IR groff ,
to control the formatting of the PDF document.
.
Consequently,
.I pdfroff
accepts all options and arguments,
as specified in
.MR groff @MAN1EXT@ ,
which may also be considered as the definitive reference for all
standard
.I pdfroff
options and argument usage.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.I pdfroff
accepts all of the short form options
(i.e.,
those introduced by a
single hyphen),
which are available with
.I groff
itself.
.
In most cases,
these are simply passed transparently to
.IR groff ;
the following,
however,
are handled specially by
.IR pdfroff .
.
.
.TP
.B \-h
Same as
.BR \-\-help ;
see below.
.
.
.TP
.B \-i
Process standard input,
after all other specified input files.
.
This is passed transparently to
.IR groff ,
but,
if grouped with other options,
it
.I must
be the first in the group.
.
Hiding it within a group breaks standard input processing,
in the multiple-pass
.I groff
processing context of
.IR pdfroff .
.
.
.TP
.BI \-T \ dev
Only
.B \-T\ ps
is supported by
.IR pdfroff .
.
Attempting to specify any other device causes
.I pdfroff
to abort.
.
.
.TP
.B \-v
Same as
.BR \-\-version ;
see below.
.
.
.P
See
.MR groff @MAN1EXT@
for a description of all other short form options,
which are
transparently passed through
.I pdfroff
to
.IR groff .
.
.
.P
All long form options
(i.e.,
those introduced by a double hyphen)
are interpreted locally by
.IR pdfroff ;
they are
.I not
passed on to
.IR groff ,
unless otherwise stated below.
.
.
.TP
.B \-\-help
Causes
.I pdfroff
to display a summary of the its usage syntax,
and supported options,
and then exit.
.
.
.TP
.B \-\-emit\-ps
Suppresses the final output conversion step,
causing
.I pdfroff
to emit PostScript output instead of PDF.
.
This may be useful to capture intermediate PostScript output when using
a specialised postprocessor,
such as
.I gpresent
for example,
in place of the default Ghostscript PDF writer.
.
.
.TP
.B \-\-keep\-temporary\-files
Suppresses the deletion of temporary files,
which normally occurs
after
.I pdfroff
has completed PDF document formatting;
this may be useful when debugging formatting problems.
.
.
.IP
See section \[lq]Files\[rq] below for a description of the temporary
files used by
.IR pdfroff .
.
.
.TP
.B \-\-no\-pdf\-output
May be used with the
.BI \%\-\-reference\-dictionary= name
option
(described below)
to eliminate the overhead of PDF formatting when running
.I pdfroff
to create a reference dictionary for use in a different document.
.
.
.TP
.B \-\-no\-reference\-dictionary
May be used to eliminate the overhead of creating a reference
dictionary,
when it is known that the target PDF document contains no public
references,
created by the
.B pdfhref
macro.
.
.
.TP
.B \-\-no\-toc\-relocation
May be used to eliminate the extra
.I groff
processing pass,
which is required to generate a table of contents,
and relocate it to the start of the PDF document,
when processing any document which lacks an automatically
generated table of contents.
.
.
.TP
.B \-\-no\-kill\-null\-pages
While preparing for simulation of the manual collation step,
which is traditionally required to relocate a
.I "table of contents"
to the start of a document,
.I pdfroff
accumulates a number of empty page descriptions
into the intermediate PostScript output stream.
.
During the final collation step,
these empty pages are normally discarded from the finished document;
this option forces
.I pdfroff
to leave them in place.
.
.
.TP
.BI \-\-pdf\-output= name
Specifies the name to be used for the resultant PDF document;
if unspecified,
the PDF output is written to standard output.
.
A future version of
.I pdfroff
may use this option,
to encode the document name in a generated reference dictionary.
.
.
.TP
.BI \-\-reference\-dictionary= name
Specifies the name to be used for the generated reference dictionary
file;
if unspecified,
the reference dictionary is created in a temporary file,
which is deleted when
.I pdfroff
completes processing of the current document.
.
This option
.I must
be specified,
if it is desired to save the reference dictionary,
for use in references placed in other PDF documents.
.
.
.TP
.B \-\-report\-progress
Causes
.I pdfroff
to display an informational message on standard error,
at the start of each
.I groff
processing pass.
.
.
.TP
.BI \-\-stylesheet= name
Specifies the name of an
.IR "input file" ,
to be used as a style sheet for formatting of content,
which is to be placed
.I before
the table of contents,
in the formatted PDF document.
.
.
.TP
.B \-\-version
Causes
.I pdfroff
to display a version identification message.
.
The entire command line is then passed transparently to
.IR groff ,
in a
.I one
pass operation
.IR only ,
in order to display the associated
.I groff
version information,
before exiting.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
The following environment variables may be set,
and exported,
to modify the behaviour of
.IR pdfroff .
.
.
.TP
.I PDFROFF_COLLATE
Specifies the program to be used
for collation of the finished PDF document.
.
.
.IP
This collation step may be required to move
.I tables of contents
to the start of the finished PDF document,
when formatting with traditional macro packages,
which print them at the end.
.
However,
users should not normally need to specify
.IR \%PDFROFF_COLLATE ,
(and indeed,
are not encouraged to do so).
.
If unspecified,
.I pdfroff
uses
.MR sed @MAN1EXT@
by default,
which normally suffices.
.
.
.IP
If
.I \%PDFROFF_COLLATE
.I is
specified,
then it must act as a filter,
accepting a list of file name arguments,
and write its output to the standard output stream,
whence it is piped to the
.IR \%PDFROFF_POSTPROCESSOR_COMMAND ,
to produce the finished PDF output.
.
.
.IP
When specifying
.IR \%PDFROFF_COLLATE ,
it is normally necessary to also specify
.IR \%PDFROFF_KILL_NULL_PAGES .
.
.
.IP
.I \%PDFROFF_COLLATE
is ignored,
if
.I pdfroff
is invoked with the
.B \%\-\-no\-kill\-null\-pages
option.
.
.
.TP
.I PDFROFF_KILL_NULL_PAGES
Specifies options to be passed to the
.I \%PDFROFF_COLLATE
program.
.
.
.IP
It should not normally be necessary to specify
.IR \%PDFROFF_KILL_NULL_PAGES .
.
The internal default is a
.MR sed @MAN1EXT@
script,
which is intended to remove completely blank pages
from the collated output stream,
and which should be appropriate in most applications of
.IR pdfroff .
.
However,
if any alternative to
.MR sed @MAN1EXT@
is specified for
.IR \%PDFROFF_COLLATE ,
then it is likely that a corresponding alternative specification for
.I \%PDFROFF_KILL_NULL_PAGES
is required.
.
.
.IP
As in the case of
.IR \%PDFROFF_COLLATE ,
.I \%PDFROFF_KILL_NULL_PAGES
is ignored,
if
.I pdfroff
is invoked with the
.B \%\-\-no\-kill\-null\-pages
option.
.
.
.TP
.I PDFROFF_POSTPROCESSOR_COMMAND
Specifies the command to be used for the final document conversion
from PostScript intermediate output to PDF.
.
It must behave as a filter,
writing its output to the standard output stream,
and must accept an arbitrary number of
.I files .\|.\|.\&
arguments,
with the special case of
.RB \[lq] \- \[rq]
representing the standard input stream.
.
.
.IP
If unspecified,
.I \%PDFROFF_POSTPROCESSOR_COMMAND
defaults to
.
.RS 12n
.EX
gs \-dBATCH \-dQUIET \-dNOPAUSE \-dSAFER \-sDEVICE=pdfwrite \e
	\-sOutputFile=\-
.EE
.RE
.
.
.TP
.I GROFF_TMPDIR
Identifies the directory in which
.I pdfroff
should create temporary files.
.
If
.I \%GROFF_TMPDIR
is
.I not
specified,
then the variables
.IR TMPDIR ,
.I TMP
and
.I TEMP
are considered in turn as possible temporary file repositories.
.
If none of these are set,
then temporary files are created
in the current directory.
.
.
.TP
.I GROFF_GHOSTSCRIPT_INTERPRETER
Specifies the program to be invoked when
.I pdfroff
converts
.I groff
PostScript output to PDF.
.
If
.I \%PDFROFF_POSTPROCESSOR_COMMAND
is specified,
then the command name it specifies is
.I implicitly
assigned to
.IR \%GROFF_GHOSTSCRIPT_INTERPRETER ,
overriding any explicit setting specified in the environment.
.
If
.I \%GROFF_GHOSTSCRIPT_INTERPRETER
is not specified,
then
.I pdfroff
searches the process
.IR PATH ,
looking for a program with any of the well known names
for the Ghostscript interpreter;
if no Ghostscript interpreter can be found,
.I pdfroff
aborts.
.
.
.TP
.I GROFF_AWK_INTERPRETER
Specifies the program to be invoked when
.I pdfroff
is extracting reference dictionary entries from a
.I groff
intermediate message stream.
.
If
.I \%GROFF_AWK_INTERPRETER
is not specified,
then
.I pdfroff
searches the process
.IR PATH ,
looking for any of the preferred programs,
.IR gawk ,
.IR mawk ,
.IR nawk ,
and
.IR awk ,
in that order;
if none of these are found,
.I pdfroff
issues a warning message,
and continue processing;
however,
in this case,
no reference dictionary is created.
.
.
.TP
.I OSTYPE
Typically defined automatically by the operating system,
.I \%OSTYPE
is used on Microsoft Win32/MS-DOS platforms
.IR only ,
to infer the default
.I \%PATH_SEPARATOR
character,
which is used when parsing the process
.I PATH
to search for external helper programs.
.
.
.TP
.I PATH_SEPARATOR
If set,
.I \%PATH_SEPARATOR
overrides the default separator character,
(\[oq]:\[cq] on POSIX/Unix systems,
inferred from
.I \%OSTYPE
on Microsoft Win32/MS-DOS),
which is used when parsing the process
.I PATH
to search for external helper programs.
.
.
.TP
.I SHOW_PROGRESS
If this is set to a non-empty value,
then
.I pdfroff
always behaves as if the
.B \%\-\-report\-progress
option is specified on the command line.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
Input and output files for
.I pdfroff
may be named according to any convention of the user's choice.
.
Typically,
input files may be named according to the choice of the principal
normatting macro package,
e.g.,
.RI file .ms
might be an input file for formatting using the
.I ms
macros
.RI ( s.tmac );
normally,
the final output file should be named
.RI file .pdf .
.
.
.P
Temporary files created by
.I pdfroff
are placed in the file system hierarchy,
in or below the directory specified by environment variables
(see section \[lq]Environment\[rq] above).
.
If
.MR mktemp @MAN1EXT@
is available,
it is invoked to create a private subdirectory of
the nominated temporary files directory,
(with subdirectory name derived from the template
.IR pdfroff\-XXXXXXXXXX );
if this subdirectory is successfully created,
the temporary files will be placed within it,
otherwise they will be placed directly in the directory
nominated in the environment.
.
.
.P
All temporary files themselves
are named according to the convention
.IR pdf $$ . *,
where
.I $$
is the standard shell variable representing the process identifier of
the
.I pdfroff
process itself,
and
.I *
represents any of the extensions used by
.I pdfroff
to identify the following temporary and intermediate files.
.
.
.TP
.IR pdf $$ .tmp
A scratch pad file,
used to capture reference data emitted by
.IR groff ,
during the
.I reference dictionary
compilation phase.
.
.
.TP
.IR pdf $$ .ref
The
.IR "reference dictionary" ,
as compiled in the last but one pass of the
.I reference dictionary
compilation phase;
(at the start of the first pass,
this file is created empty;
in successive passes,
it contains the
.I reference dictionary
entries,
as collected in the preceding pass).
.
.
.IP
If the
.BR \%\-\-reference\-dictionary =\c
.I name
option is specified,
this intermediate file becomes permanent,
and is named
.IR name ,
rather than
.IR pdf $$ .ref .
.
.
.TP
.IR pdf $$ .cmp
Used to collect
.I reference dictionary
entries during the active pass of the
.I reference dictionary
compilation phase.
.
At the end of any pass,
when the content of
.IR pdf $$ .cmp
compares as identical to
.IR pdf $$ .ref ,
(or the corresponding file named by the
.BR \%\-\-reference\-dictionary =\c
.I name
option),
then
.I reference dictionary
compilation is terminated,
and the
.I document reference map
is appended to this intermediate file,
for inclusion in the final formatting passes.
.
.
.TP
.IR pdf $$ .tc
An intermediate
.I PostScript
file,
in which \[lq]Table of Contents\[rq] entries are collected,
to facilitate relocation before the body text,
on ultimate output to the
.I Ghostscript
postprocessor.
.
.
.TP
.IR pdf $$ .ps
An intermediate
.I PostScript
file,
in which the body text is collected prior to ultimate output to the
.I Ghostscript
postprocessor,
in the proper sequence,
.I after
.IR pdf $$ .tc .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I pdfroff
was written by
.MT keith\:.d\:.marshall@\:ntlworld\:.com
Keith Marshall
.ME ,
who maintains it at
.UR https://\:osdn\:.net/\:users/\:keith/\:pf/\:\%groff-pdfmark/\
\:wiki/\:\%FrontPage
his
.I groff-pdfmark
OSDN site
.UE .
.
.IR groff 's
version may be withdrawn in a future release.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.P
Since
.I pdfroff
provides a superset of all
.I groff
capabilities,
the above manual,
or its terser reference page,
.MR groff @MAN7EXT@
may also be considered definitive references to all
.I standard
capabilities of
.IR pdfroff ,
with this document providing the reference to
.IR pdfroff 's
extended features.
.
.
.P
While
.I pdfroff
imposes neither any restriction on,
nor any requirement for,
the use of any specific
.I groff
macro package,
a number of supplied macro packages,
and in particular those associated with the package
.IR \%pdfmark.tmac ,
are best suited for use with
.I pdfroff
as the preferred formatter.
.
.
.TP
.I @PDFDOCDIR@/\:\%pdfmark.pdf
\[lq]Portable Document Format Publishing with GNU
.IR Troff \[rq],
by Keith Marshall,
offers detailed documentation on the use of these packages.
.
This file,
together with its source,
.IR \%pdfmark.ms ,
is part of the
.I groff
distribution.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pdfroff_1_man_C]
.do rr *groff_pdfroff_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
