/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Fragment;
import android.os.SystemClock;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.By;
import com.jayway.android.robotium.solo.Condition;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.Timeout;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.WebElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Waiter {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Searcher searcher;
    private final Scroller scroller;
    private final Sleeper sleeper;
    private final int MINISLEEP = 50;

    public Waiter(ActivityUtils activityUtils, ViewFetcher viewFetcher, Searcher searcher, Scroller scroller, Sleeper sleeper) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.searcher = searcher;
        this.scroller = scroller;
        this.sleeper = sleeper;
    }

    public boolean waitForActivity(String name) {
        return this.waitForActivity(name, Timeout.getSmallTimeout());
    }

    public boolean waitForActivity(String name, int timeout) {
        Activity currentActivity = this.activityUtils.getCurrentActivity(false, false);
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            if (currentActivity != null && currentActivity.getClass().getSimpleName().equals(name)) {
                return true;
            }
            this.sleeper.sleep(50);
            currentActivity = this.activityUtils.getCurrentActivity(false, false);
        }
        return false;
    }

    public boolean waitForActivity(Class<? extends Activity> activityClass) {
        return this.waitForActivity(activityClass, Timeout.getSmallTimeout());
    }

    public boolean waitForActivity(Class<? extends Activity> activityClass, int timeout) {
        Activity currentActivity = this.activityUtils.getCurrentActivity(false, false);
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            if (currentActivity != null && currentActivity.getClass().equals(activityClass)) {
                return true;
            }
            this.sleeper.sleep(50);
            currentActivity = this.activityUtils.getCurrentActivity(false, false);
        }
        return false;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, boolean sleep, boolean scroll) {
        HashSet uniqueViews = new HashSet();
        do {
            boolean foundMatchingView;
            if (sleep) {
                this.sleeper.sleep();
            }
            if (foundMatchingView = this.searcher.searchFor(uniqueViews, viewClass, index)) {
                return true;
            }
            if (!scroll || this.scroller.scroll(0)) continue;
            return false;
        } while (scroll);
        return false;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, int timeout, boolean scroll) {
        HashSet uniqueViews = new HashSet();
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundMatchingView = this.searcher.searchFor(uniqueViews, viewClass, index);
            if (foundMatchingView) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public <T extends View> boolean waitForViews(Class<? extends T> ... classes) {
        long endTime = SystemClock.uptimeMillis() + (long)Timeout.getSmallTimeout();
        while (SystemClock.uptimeMillis() < endTime) {
            for (Class<? extends T> classToWaitFor : classes) {
                if (!this.waitForView(classToWaitFor, 0, false, false)) continue;
                return true;
            }
            this.scroller.scroll(0);
            this.sleeper.sleep();
        }
        return false;
    }

    public boolean waitForView(View view) {
        return this.waitForView(view, Timeout.getLargeTimeout(), true, true);
    }

    public boolean waitForView(View view, int timeout) {
        return this.waitForView(view, timeout, true, false);
    }

    public boolean waitForView(View view, int timeout, boolean scroll, boolean checkIsShown) {
        if (view == null) {
            return false;
        }
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundAnyMatchingView = this.searcher.searchFor(view);
            if (foundAnyMatchingView) {
                return true;
            }
            if (checkIsShown && view != null && view.isShown()) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public View waitForView(int id, int index, int timeout) {
        if (timeout == 0) {
            timeout = Timeout.getSmallTimeout();
        }
        return this.waitForView(id, index, timeout, false);
    }

    public View waitForView(int id, int index, int timeout, boolean scroll) {
        HashSet<View> uniqueViewsMatchingId = new HashSet<View>();
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() <= endTime) {
            this.sleeper.sleep();
            for (View view : this.viewFetcher.getAllViews(false)) {
                Integer idOfView = view.getId();
                if (!idOfView.equals(id)) continue;
                uniqueViewsMatchingId.add(view);
                if (uniqueViewsMatchingId.size() <= index) continue;
                return view;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return null;
    }

    public WebElement waitForWebElement(By by, int minimumNumberOfMatches, int timeout, boolean scroll) {
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (true) {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                this.searcher.logMatchesFound(by.getValue());
                return null;
            }
            this.sleeper.sleep();
            WebElement webElementToReturn = this.searcher.searchForWebElement(by, minimumNumberOfMatches, timeout, scroll);
            if (webElementToReturn != null) {
                return webElementToReturn;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
    }

    public boolean waitForCondition(Condition condition, int timeout) {
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                return false;
            }
            this.sleeper.sleep();
        } while (!condition.isSatisfied());
        return true;
    }

    public TextView waitForText(String text) {
        return this.waitForText(text, 0, Timeout.getLargeTimeout(), true);
    }

    public TextView waitForText(String text, int expectedMinimumNumberOfMatches, long timeout) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, true);
    }

    public TextView waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waitForText(TextView.class, text, expectedMinimumNumberOfMatches, timeout, scroll, false, true);
    }

    public <T extends TextView> T waitForText(Class<T> classToFilterBy, String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waitForText(classToFilterBy, text, expectedMinimumNumberOfMatches, timeout, scroll, false, true);
    }

    public TextView waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible, boolean hardStoppage) {
        return this.waitForText(TextView.class, text, expectedMinimumNumberOfMatches, timeout, scroll, onlyVisible, hardStoppage);
    }

    public <T extends TextView> T waitForText(Class<T> classToFilterBy, String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible, boolean hardStoppage) {
        T textViewToReturn;
        long endTime = SystemClock.uptimeMillis() + timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                return null;
            }
            this.sleeper.sleep();
            if (hardStoppage) continue;
            timeout = 0L;
        } while ((textViewToReturn = this.searcher.searchFor(classToFilterBy, text, expectedMinimumNumberOfMatches, timeout, scroll, onlyVisible)) == null);
        return textViewToReturn;
    }

    public <T extends View> T waitForAndGetView(int index, Class<T> classToFilterBy) {
        int newIndex;
        long endTime = SystemClock.uptimeMillis() + (long)Timeout.getSmallTimeout();
        while (SystemClock.uptimeMillis() <= endTime && !this.waitForView(classToFilterBy, index, true, true)) {
        }
        int numberOfUniqueViews = this.searcher.getNumberOfUniqueViews();
        ArrayList<T> views = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(classToFilterBy));
        if (views.size() < numberOfUniqueViews && (newIndex = index - (numberOfUniqueViews - views.size())) >= 0) {
            index = newIndex;
        }
        View view = null;
        try {
            view = (View)views.get(index);
        }
        catch (IndexOutOfBoundsException exception) {
            int match = index + 1;
            if (match > 1) {
                Assert.assertTrue((String)(match + " " + classToFilterBy.getSimpleName() + "s" + " are not found!"), (boolean)false);
            }
            Assert.assertTrue((String)(classToFilterBy.getSimpleName() + " is not found!"), (boolean)false);
        }
        views = null;
        return (T)view;
    }

    public boolean waitForFragment(String tag, int id, int timeout) {
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() <= endTime) {
            if (this.getSupportFragment(tag, id) != null) {
                return true;
            }
            if (this.getFragment(tag, id) == null) continue;
            return true;
        }
        return false;
    }

    private android.support.v4.app.Fragment getSupportFragment(String tag, int id) {
        FragmentActivity fragmentActivity = null;
        try {
            fragmentActivity = (FragmentActivity)this.activityUtils.getCurrentActivity(false);
        }
        catch (ClassCastException ignored) {
            // empty catch block
        }
        if (fragmentActivity != null) {
            try {
                if (tag == null) {
                    return fragmentActivity.getSupportFragmentManager().findFragmentById(id);
                }
                return fragmentActivity.getSupportFragmentManager().findFragmentByTag(tag);
            }
            catch (NoSuchMethodError ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean waitForLogMessage(String logMessage, int timeout) {
        StringBuilder stringBuilder = new StringBuilder();
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() <= endTime) {
            if (this.getLog(stringBuilder).lastIndexOf(logMessage) != -1) {
                return true;
            }
            this.sleeper.sleep();
        }
        return false;
    }

    private StringBuilder getLog(StringBuilder stringBuilder) {
        Process p = null;
        BufferedReader reader = null;
        String line = null;
        try {
            p = Runtime.getRuntime().exec("logcat -d");
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stringBuilder.setLength(0);
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.destroy(p, reader);
        return stringBuilder;
    }

    public void clearLog() {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("logcat -c");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void destroy(Process p, BufferedReader reader) {
        p.destroy();
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Fragment getFragment(String tag, int id) {
        try {
            if (tag == null) {
                return this.activityUtils.getCurrentActivity().getFragmentManager().findFragmentById(id);
            }
            return this.activityUtils.getCurrentActivity().getFragmentManager().findFragmentByTag(tag);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }
}

