# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.

import sys
import string

propList = eval(sys.stdin.read())
props = ""
for [prop, id, flags, pref] in propList:
    extendedAttrs = ["Throws", "TreatNullAs=EmptyString"]
    # To limit the overhead of Func= annotations, we only generate them when
    # necessary, which is when the
    # CSS_PROPERTY_ALWAYS_ENABLED_IN_CHROME_OR_CERTIFIED_APP flag is set.
    # Otherwise, we try to get by with just a Pref= annotation or no annotation
    # at all.
    if "CSS_PROPERTY_ALWAYS_ENABLED_IN_CHROME_OR_CERTIFIED_APP" in flags:
        extendedAttrs.append('Func="IsCSSPropertyExposedToJS<eCSSProperty_%s>"' % id)
    # The following is an 'elif' because it is the responsibility of
    # IsCSSPropertyExposedToJS to handle the pref if there is one.
    elif pref is not "":
        extendedAttrs.append('Pref="%s"' % pref)
    if not prop.startswith("Moz"):
        prop = prop[0].lower() + prop[1:]
    # Unfortunately, even some of the getters here are fallible
    # (e.g. on nsComputedDOMStyle).
    props += "  [%s] attribute DOMString %s;\n" % (", ".join(extendedAttrs),
                                                   prop)

idlFile = open(sys.argv[1], "r");
idlTemplate = idlFile.read();
idlFile.close();

print ("/* THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT */\n\n" +
       string.Template(idlTemplate).substitute({ "props": props }))
