/*
  Copyright (C) 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003,
  2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014,
  2015, 2016, 2017, 2018, 2019, 2020, 2021 Free Software Foundation,
  Inc.

  This file is part of GNU Inetutils.

  GNU Inetutils is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or (at
  your option) any later version.

  GNU Inetutils is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see `http://www.gnu.org/licenses/'. */

/*
 * Copyright (c) 1985, 1989, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * FTP global variables.
 */

#include <sys/param.h>
#include <setjmp.h>
#include <progname.h>

#ifndef FTP_EXTERN
# define FTP_EXTERN extern
#endif

#define MAXLINE 200

/*
 * Options and other state info.
 */
FTP_EXTERN int trace;		/* trace packets exchanged */
FTP_EXTERN int hash;		/* print # for each buffer transferred */
FTP_EXTERN int hashbytes;	/* number of bytes per # printed */
FTP_EXTERN int sendport;	/* use PORT cmd for each data connection */
FTP_EXTERN int verbose;		/* print messages coming back from server */
FTP_EXTERN int connected;	/* connected to server */
FTP_EXTERN int fromatty;	/* input is from a terminal */
FTP_EXTERN int interactive;	/* interactively prompt on m* cmds */
FTP_EXTERN int debug;		/* debugging level */
FTP_EXTERN int bell;		/* ring bell on cmd completion */
FTP_EXTERN int doglob;		/* glob local file names */
FTP_EXTERN int autologin;	/* establish user account on connection */
FTP_EXTERN int proxy;		/* proxy server connection active */
FTP_EXTERN int proxflag;	/* proxy connection exists */
FTP_EXTERN int sunique;		/* store files on server with unique name */
FTP_EXTERN int runique;		/* store local files with unique name */
FTP_EXTERN int mcase;		/* map upper to lower case for mget names */
FTP_EXTERN int ntflag;		/* use ntin ntout tables for name translation */
FTP_EXTERN int mapflag;		/* use mapin mapout templates on file names */
FTP_EXTERN int code;		/* return/reply code for ftp command */
FTP_EXTERN int crflag;		/* if 1, strip car. rets. on ascii gets */
FTP_EXTERN char pasv[64];	/* passive port for proxy data connection */
FTP_EXTERN int passivemode;	/* passive mode enabled */
FTP_EXTERN int doepsv4;		/* EPSV/EPRT for IPv4 enabled */
FTP_EXTERN int usefamily;	/* Precondition on an adress family */
FTP_EXTERN int usereadline;	/* Use readline support, given a TTY.  */
FTP_EXTERN char *altarg;	/* argv[1] with no shell-like preprocessing  */
FTP_EXTERN char ntin[17];	/* input translation table */
FTP_EXTERN char ntout[17];	/* output translation table */
extern char *mapin;		/* input map template */
extern char *mapout;		/* output map template */
FTP_EXTERN char typename[32];	/* name of file transfer type */
FTP_EXTERN int type;		/* requested file transfer type */
FTP_EXTERN int curtype;		/* current file transfer type */
FTP_EXTERN char structname[32];	/* name of file transfer structure */
FTP_EXTERN int stru;		/* file transfer structure */
FTP_EXTERN char formname[32];	/* name of file transfer format */
FTP_EXTERN int form;		/* file transfer format */
FTP_EXTERN char modename[32];	/* name of file transfer mode */
FTP_EXTERN int mode;		/* file transfer mode */
FTP_EXTERN char bytename[32];	/* local byte size in ascii */
FTP_EXTERN int bytesize;	/* local byte size in binary */

FTP_EXTERN char *hostname;	/* name of host connected to */
FTP_EXTERN char *netrc;		/* netrc file chosen on command line */
FTP_EXTERN int unix_server;	/* server is unix, can use binary for ascii */
FTP_EXTERN int unix_proxy;	/* proxy is unix, can use binary for ascii */

FTP_EXTERN jmp_buf toplevel;	/* non-local goto stuff for cmd scanner */

FTP_EXTERN char *line;		/* input produced by readline or getline */
FTP_EXTERN size_t linelen;	/* allocated length of the same, if known */

#ifndef MAXMARGV
# define MAXMARGV 20
#endif

FTP_EXTERN int margc;		/* count of arguments on input line */
FTP_EXTERN char *margv[MAXMARGV]; /* args parsed from input line */
FTP_EXTERN int cpend;		/* flag: if != 0, then pending server reply */
FTP_EXTERN int mflag;		/* flag: if != 0, then active multi command */

FTP_EXTERN int options;		/* used during socket creation */

/*
 * Format of command table.
 */
struct cmd
{
  char *c_name;			/* name of command */
  char *c_help;			/* help string */
  char c_bell;			/* give bell when command completes */
  char c_conn;			/* must be connected to use command */
  char c_proxy;			/* proxy server may execute */
  void (*c_handler) (int, char **);	/* function to call */
};

struct macel
{
  char mac_name[9];		/* macro name */
  char *mac_start;		/* start of macro in macbuf */
  char *mac_end;		/* end of macro in macbuf */
};

FTP_EXTERN int macnum;		/* number of defined macros */
FTP_EXTERN struct macel macros[16];
FTP_EXTERN char macbuf[4096];

#include "extern.h"
