/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionLoader;
import gnu.jel.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public class ExpressionBits
implements Serializable {
    static final long serialVersionUID = 5432046992123704544L;
    private static volatile transient long expressionUID = 0L;
    private byte[] beforeName = null;
    private byte[] afterName = null;
    private Object[] objectConstants = null;
    private static final String classNamePrefix = "gnu/jel/generated/E_";
    private String name = null;

    ExpressionBits(byte[] beforeName, byte[] afterName, Object[] objectConstants) {
        this.beforeName = beforeName;
        this.afterName = afterName;
        this.objectConstants = objectConstants;
    }

    public CompiledExpression getExpression() {
        byte[] image = this.getImage();
        try {
            ExpressionLoader el = new ExpressionLoader(this.name, image);
            Class<?> cls = el.loadClass(this.name);
            Constructor<?>[] ca = cls.getConstructors();
            Debug.assert(ca.length == 1, "There should be only one constructor of the compiled expression.");
            Object[] constrParams = new Object[]{this.objectConstants};
            return (CompiledExpression)ca[0].newInstance(constrParams);
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
            return null;
        }
    }

    public byte[] getImage() {
        this.name = classNamePrefix + Long.toString(expressionUID++);
        int alen = this.beforeName.length + this.afterName.length + 30 + classNamePrefix.length();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(alen);
        DataOutputStream bit_stream = new DataOutputStream(baos);
        try {
            bit_stream.write(this.beforeName);
            bit_stream.write(1);
            bit_stream.writeUTF(this.name);
            bit_stream.write(this.afterName);
            FileOutputStream fos = new FileOutputStream("dump.class");
            baos.writeTo(fos);
            fos.close();
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
        return baos.toByteArray();
    }
}

