/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_unary_primitive;
import gnu.jel.debug.Debug;

class OP_convert
extends OP_unary_primitive {
    Class to;

    OP_convert(Class to) {
        this.to = to;
    }

    void compile(ExpressionImage ei) {
        ei.asm_convert(this.to);
    }

    void doOperation(OP_load c) throws Throwable {
        if (c.type == this.to) {
            return;
        }
        if (!(c.type != null && c.what != null || this.to.isPrimitive())) {
            return;
        }
        boolean pc = c.type.isPrimitive();
        boolean pt = this.to.isPrimitive();
        if (!pc && !pt) {
            Debug.assert(this.to.isAssignableFrom(c.type), "Class types not compatible.");
            return;
        }
        if (pc && pt) {
            int pfi = ExpressionImage.primitiveID(c.type);
            int pti = ExpressionImage.primitiveID(this.to);
            c.what = OP_function.narrow(OP_function.widen(c.what, pfi), pti);
            c.type = this.to;
            return;
        }
    }

    void setType(Class new_to) {
        this.to = new_to;
    }

    public String toString() {
        return "(" + this.to.toString() + ")";
    }
}

