/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.TypesStack;

public class OPcondtnl
extends OPfunction {
    OPlist trueList;
    OPlist falseList;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OPcondtnl(TypesStack typesStack, OPlist oPlist, OPlist oPlist2) throws IllegalStateException {
        int n = typesStack.peekID();
        Class clazz = typesStack.pop();
        int n2 = typesStack.peekID();
        Class clazz2 = typesStack.pop();
        if (typesStack.peekID() != 0) {
            throw new IllegalStateException("First argument of conditional must be of boolean type.");
        }
        typesStack.pop();
        if (clazz != clazz2) {
            if (n2 < 8 && n < 8) {
                int n3 = Math.min(n2, n);
                int n4 = Math.max(n2, n);
                this.resID = n2 == 1 && n == 3 || n2 == 3 && n == 1 ? 3 : OPbinary.promotions[n2][n];
            } else {
                if (n2 != 8 || n != 8) throw new IllegalStateException("Branches of conditional should be either both of primitive types or both be references.");
                this.resID = 8;
                if (clazz2 == null && clazz == null) {
                    this.resType = null;
                } else if (clazz2 == null && clazz != null) {
                    this.resType = clazz;
                } else if (clazz2 != null && clazz == null) {
                    this.resType = clazz2;
                } else if (clazz2.isAssignableFrom(clazz)) {
                    this.resType = clazz2;
                } else {
                    if (!clazz.isAssignableFrom(clazz2)) throw new IllegalStateException("Branches of conditional have reference types which are not comptible.");
                    this.resType = clazz;
                }
            }
        } else {
            this.resID = n2;
            this.resType = clazz2;
        }
        if (clazz2 != this.resType) {
            typesStack.pushID(n2, clazz2);
            oPlist.addLast(new OPunary(typesStack, this.resID, this.resType, false));
            typesStack.pop();
        }
        if (clazz != this.resType) {
            typesStack.pushID(n, clazz);
            oPlist2.addLast(new OPunary(typesStack, this.resID, this.resType, false));
            typesStack.pop();
        }
        typesStack.pushID(this.resID, this.resType);
        this.trueList = oPlist;
        this.falseList = oPlist2;
    }

    protected void compile(ClassFile classFile) {
        classFile.branch_true();
        this.trueList.compile(classFile);
        classFile.branch_false();
        this.falseList.compile(classFile);
        classFile.branch_end();
    }

    protected void eval(OPlist oPlist) {
        this.trueList.performCF();
        this.falseList.performCF();
        if (!(this.prev instanceof OPload)) {
            return;
        }
        OPload oPload = (OPload)this.prev;
        OPlist oPlist2 = (Boolean)oPload.what != false ? this.trueList : this.falseList;
        OP oP = oPlist2.getLast();
        while (oP != null) {
            OP oP2 = oP.prev;
            oPlist.addAfter(this, oP);
            oP = oP2;
        }
        oPlist.remove(this.prev);
        oPlist.remove(this);
    }

    public int getNParams() {
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("?(");
        stringBuffer.append(this.trueList.toString());
        stringBuffer.append("):(");
        stringBuffer.append(this.falseList.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

