
(defun not-grep ()
  (interactive)
  (shell-command "grep m4_limitation_of_warranty *.el"))

(defun snaffle-files ()
  (interactive)
  (progn
    (goto-char (point-min))
    (setq list nil)
    (while (re-search-forward "\\([-a-zA-Z0-9_]*\\.el\\):" nil t)
      (setq str (buffer-substring-no-properties (match-beginning 1)
                                                (match-end 1)))
      (setq list (cons str list)))
    list)
  )

(setq list-grep list)
(setq list-all  (directory-files "~/dlisp" nil "\\.el$"))

(defun subtract-list-from-list (list-grep list-all)
  (progn
    (setq list-result (mapcar '(lambda (x)
                                 (if (not (member x list-grep))
                                     x nil))
                              list-all))
    (setq list-result (delete nil list-result))
    )
  )

(insert-prin1 list-result)

("a.el"
 "assoc-old.el"
 "autogc-cycler.el"
 "autogc-inheritance.el"
 "autogc-nostuff.el"
 "bak-unix.el"
 "bak-windows.el"
 "bak.el"
 "bar.el"
 "batch.el"
 "blocks.el"
 "broken-keyboard.el"
 "c2j.el"
 "cbhs.el"
 "checksum.el"
 "clos.el"
 "compare-files.el"
 "copy-downloads.el"
 "cull-stuff.el"
 "d-add-hours.el"
 "d-auto-mode-alist.el"
 "d-bat.el"
 "d-before-save-hook.el"
 "d-begin-end.el"
 "d-calendar.el"
 "d-capitalize.el"
 "d-cc.el"
 "d-copy.el"
 "d-css.el"
 "d-debugger.el"
 "d-diff.el"
 "d-dired-updown.el"
 "d-dired-x.el"
 "d-dos-fonts.el"
 "d-eshell.el"
 "d-etags.el"
 "d-exit.el"
 "d-find.el"
 "d-flock-lisp++.el"
 "d-flush-checkpoints.el"
 "d-flyspell.el"
 "d-fonts.el"
 "d-hex.el"
 "d-hippie.el"
 "d-howto.el"
 "d-html.el"
 "d-htmlize.el"
 "d-indent.el"
 "d-iss.el"
 "d-key-find.el"
 "d-key-toggle.el"
 "d-keys.el"
 "d-latex.el"
 "d-latexize.el"
 "d-lisp.el"
 "d-make-tags.el"
 "d-math.el"
 "d-meta-period.el"
 "d-minibuffer.el"
 "d-modeline.el"
 "d-movement-advice.el"
 "d-movement-hooks.el"
 "d-movement-leftright.el"
 "d-movement-post-command-hook.el"
 "d-movement-updown.el"
 "d-movement.el"
 "d-outline.el"
 "d-php-mode.el"
 "d-povray.el"
 "d-prefs.el"
 "d-prolog.el"
 "d-publish.el"
 "d-scratch.el"
 "d-setdir.el"
 "d-shift-tab.el"
 "d-sql.el"
 "d-tidy-html-files.el"
 "d-toggle-checkpoints.el"
 "d-truncate-hook.el"
 "d-unspacify.el"
 "d-wiki.el"
 "dotemacs-dos-emacs.el"
 "dotemacs-unix-emacs.el"
 "dotemacs.el"
 "flacs-compare.el"
 "foo.el"
 "generator.el"
 "grad.el"
 "insert-insert.el"
 "jtw2m4.el"
 "lisp++.el"
 "logger.el"
 "manaaki-file-copier.el"
 "manaaki.el"
 "manifest.el"
 "name-checkpoints.el"
 "new-flock.el"
 "new-frame.el"
 "paf.el"
 "pause-break.el"
 "play-wav.el"
 "primes.el"
 "school-emacs.el"
 "search-for-constants.el"
 "search-for-ptr.el"
 "set-drive.el"
 "simbad-indent.el"
 "simbad-patch.el"
 "star-debugger.el"
 "tes-mode.el"
 "toggle-begin-end-function.el"
 "toggle-checkpoints.el"
 "varsity.el"
 "wagner-download.el"
 "weblint.el"
 "widgets.el"
 "yes.el"
 )
