
(defvar weblint--bufname "*weblint*")

(defun weblint (directory)
  (interactive "DEnter dir: ")

  (let ((go-deep (y-or-n-p "Go deep? ")))
    (if (get-buffer weblint--bufname)
        (kill-buffer weblint--bufname))

    (let ((default-directory directory))

      (shell-command (concat "perl ~/dlisp/weblint " (if go-deep "." "*.html")))
      (switch-to-buffer "*Shell Command Output*")
      (goto-char (point-min))

      (progn
        (flush-lines "extended markup")
        (flush-lines "text/css")
        (flush-lines "as an anchor")
        (flush-lines "empty container element")
        (flush-lines "illegal context for <LI>")
        (flush-lines "outer tags should be <HTML>")
        (flush-lines "unknown attribute \"TYPE\" for element <script>")
        (flush-lines "illegal value for TYPE attribute of script (text/javascript)")
        (flush-lines "<SCRIPT> cannot appear in the HEAD element.")
        (flush-lines "expected tag(s) not seen: HEAD TITLE BODY")
        (flush-lines "illegal value for TYPE attribute of ul (disk)")
        (flush-lines "illegal value for BGCOLOR attribute of td")
        )

      (when prefs-home-emacs-p
        (flush-lines "IMG does not have ALT text defined.")
        ;;(flush-lines "The HTML spec. recommends the TITLE be no longer than 64 characters.")
        )

      (let ((zero-buffer-size (= 0 (buffer-size))))
        (insert "*** weblint for buffer " directory (if go-deep ", deep" ", shallow") "\n")
        (insert "\n")
        (if zero-buffer-size
            (insert "*** no errors\n")))

      (compilation-mode)
      (read-only-mode -1)
      (delete-other-windows)
      (rename-buffer weblint--bufname)
      (message "weblint done")
      )
    )
  )

;;; downloaded from
;;;
;;;  http://ftp.akopia.com/minivend3/unsupported/weblint
;;;

(provide 'weblint)
;;; weblint.el ends here
