
(defclass my-interface ()
   ((interface-slot :initarg :interface-slot))
   "An interface to special behavior."
   :abstract t)

(defclass my-class () 
  ((slot1 :initarg :slot1 123)
   (slot2 :initarg :slot2 456))
  "Docmentation for my-class class")

(defclass my-baseclass ()
   ((slot-A :initarg :slot-A)
    (slot-B :initarg :slot-B))
  "My Baseclass.")

(defclass my-subclass (my-baseclass my-interface)
   ((specific-slot-A :initarg specific-slot-A)
    )
   "My subclass of my-baseclass")

(defclass foo () ((slot1 :initarg :slot1)
                  (slot2 :initarg :slot2))
  "Docmentation for foo class")

(setq msc (make-instance 'my-subclass))
(setq obj (make-instance 'foo :slot1 1 :slot2 2))
(setq obj (make-instance 'my-class :slot1 1))
(setq obj (make-instance 'my-class :slot1 10 :slot2 20))

(oset obj slot1 123)
(oref obj slot1)

(oset obj slot2 456)
(oref obj slot2)

(class-p 'foo)
(class-p 'my-class)
(slot-exists-p my-class 'slot1)
(slot-exists-p obj 'slot2)
(slot-boundp obj 'slot1)
;;;(eieio-class-name 'my-class)

(defclass decord () 
  ((name :initarg :name
         :initform ""
         :type string
         :custom string
         :documentation "The name of a person.")
   (birthday :initarg :birthday
             :initform "Jan 1, 1970"
             :custom string
             :type string
             :documentation "The person's birthday.")
   (phone :initarg :phone
          :initform ""
          :documentation "Phone number."))
  "A single record for tracking people I know.")

(require 'eieio-base)

(defclass decord (eieio-named) 
  ((birthday :initarg :birthday
             :initform "Jan 1, 1970"
             :custom string
             :type string
             :documentation "The person's birthday.")
   (phone :initarg :phone
          :initform ""
          :documentation "Phone number."))
  "A single record for tracking people I know.")

(defclass root ()
  ((foo :initarg :foo :initform "XXX" :type string)
   (bar :initarg :bar :initform "YYY" :type string)
   (zip :initarg :zip :initform "ZZZ" :type string))
   "Usefull base class")

(defclass inheritor (root decord my-interface)
  ()
  "Class for multiple inheritance"
  )

(defmethod call-decord ((rec decord))
  "Dial the phone for the record REC.
Execute the program SCRIPTNAME to dial the phone."
  (message "Dialing name %s phone number %s"  (oref rec name) (oref rec phone)))

(setq rec (decord "Fred" :name "Fred Stone"))

(setq rec (decord "Eric" :birthday "June" :phone "555-5555"))
(call-decord rec)

(setq x (make-instance 'decord
                       :name     "Davin Pearson"
                       :birthday "1973-06-12"
                       :phone    "+64-3-339-1145"))

(setq rec (decord "Eric" :birthday "June" :phone 5555555))

(oref rec :phone)
(oset rec :phone "+64-3-3391145")

;;; BUGGER DOESN'T WORK: 
;;; 
;;; (eieio-object-name x)

(eieio-object-p x)
