;;; d-dired.el --- Miscellaneous dired functionality

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-dired.el
;; Author/Maintainer: m4_davin_pearson
;; Keywords:
;; Version: 1.2

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; m4_limitation_of_warranty

;;; m4_install_instructions(d-dired)

;;; Known Bugs:

;; None so far!

;;; Code

(if (not (boundp 'dired-omit-extensions))
    (setq dired-omit-extensions nil))
;
;;; Dired-x installation and customization.
;;
;;; This makes `dired-jump' and `dired-jump-other-window' work
;;; even *before* `dired' has been loaded.
(define-key global-map "\C-x\C-j" 'dired-jump)
(defun d-dired-load-hook ()
  ;;(d-foo)
  (when (not emacs-dialect--xemacs-p)
    ;; This installs `dired-x.el' when `dired' is first invoked, and also
    ;; replaces `find-file' with `dired-x-find-file'.
    (setq dired-x-hands-off-my-keys t)
    (load "dired-x")
    ;; Set dired-x global variables here.  For example:
    ;; (setq dired-guess-shell-gnutar "gtar")
    (setq dired-local-variables-file "_dired")
    ;;(setq ls-lisp-dirs-first t)
    (setq dired-no-confirm '(byte-compile chmod compress copy load move print shell symlink uncompress))
    )
  (if emacs-dialect--gnuemacs-p
      (setq dired-guess-shell-alist-default
            (cons '("\\.tar$" "tar tvf") dired-guess-shell-alist-default)))
  (if emacs-dialect--xemacs-p
      (setq dired-guess-shell-alist-user
            (cons '("\\.tar$" "tar tvf") dired-guess-shell-alist-user)))
  )
(add-hook 'dired-load-hook 'd-dired-load-hook)



(defun d-dired-period ()
  (interactive)
  (shell-command (concat drive-f ":/cygwin/bin/cygstart .")) ;;; replacement for "start ."
  ;;(let ((shell-file-name "D:/Program Files/emacs-21.3/bin/cmdproxy.exe"))
  ;; (shell-command "start .")))))
  )

(defun d-dired-comma ()
  (interactive)
  ;;(d-foo)

  ;;(let ((shell-file-name "D:/Program Files/emacs-21.3/bin/cmdproxy.exe"))
  ;;(shell-command "start \".\"")))))

  ;;(d-foo)

  (let* ((found nil)
         (dd (expand-file-name default-directory))
         (cb (current-buffer))
         (list (buffer-list))
         (ptr list))

    (while ptr
      (set-buffer (car ptr))
      (when (and (string-match "^\\*eshell\\*" (buffer-name))
                 (string= dd (expand-file-name default-directory)))
        ;;(d-foo)
        (setq found t)
        (switch-to-buffer (car ptr)))
      (setq ptr (cdr ptr)))

    (set-buffer cb)

    (if (not found)
        (eshell t))))

(defun d-dired-mode-hook ()

  (safe-require 'd-diff)
  ;;(dired-omit-toggle)

  (define-key dired-mode-map [left] 'backward-char)
  (define-key dired-mode-map [right] 'forward-char)

  (define-key dired-mode-map [mouse-2] nil)

  (define-key dired-mode-map
    "z"
    (function
     (lambda () (interactive)
       (let ((filename (d-dired-get-current-file))
             (case-fold-search t))
         ;;(message "filename=%s" filename)
         ;;(sit-for 1)

         (cond
          ((and os-type--linux-p
                (string-match "\\.wav$" filename))
           (play-sound (list 'sound :file filename :volume 1.0)))

          ((and emacs-dialect--gnuemacs-p (string-match "html?" filename
           (save-window-excursion
             (let
                 ((full-filename
                   (concat
                    (file-truename default-directory)
                    filename)))
               (shell-command
                (concat "mozilla file://" full-filename " &"))
               (d-beeps "started mozilla on file %s" full-filename))))
          ((and os-type--microsoft-p
                (not os-type--msdos-p)
                (string-match "\\.\\(bmp\\|frm\\|gif\\|iff\\|jpg\\|pcx\\|png\\)$" filename))
           (let
               ((cmd
                 (concat "c:/WINDOWS/system32/mspaint.exe " filename " &")))
             (save-window-excursion
               (shell-command cmd))
             ))

          ((and os-type--mswindows-p
                (not os-type--msdos-p)
                (string-match "\\.\\(avi\\|mov\\|mpe?g\\|mid\\|wmv\\|mp4\\|mk\\)$" filename))
           ;;(d-beeps "Apple Sauce")
           (shell-command (concat "\"c:/Program Files/Windows Media Player/mplayer2.exe\" \"" filename "\" &")))


          (emacs-dialect--dosemacs-p
           (cond
            ((string-match "\\.gif$" filename)
             (shell-command
              (concat "gifview \"" filename "\"")))
            ((string-match "\\.wav$" filename)
             (shell-command
              (concat "playwav \"" filename "\"")))
            ((string-match "\\.tga$" filename)
             (shell-command
              (concat "view \"" filename "\"")))
            ((string-match "\\.pcx$" filename)
             (shell-command
              (concat "view \"" filename "\"")))
            ((string-match "\\.bmp" filename)
             (shell-command
              (concat "view \"" filename "\"")))
            ((string-match "\\.hlp" filename)
             (shell-command
              (concat "start \"" filename "\"")))
            ))
          (os-type--mswindows-p
           ;;          (d-foo)
           (cond
            ((string-match "\\.mp4$" filename)
             ;;(d-beeps "hello")
             (shell-command
              (concat "\"c:/Program Files/VideoLAN/VLC/vlc.exe\" \"" filename "\" &")))
            ;;          (cond
            ;;             ((string-match "\\.doc" filename)
            ;;          (shell-command (concat "start \"" filename "\"")))
            ;;         ((string-match "\\.\\(gif\\|exe\\)" filename)
            ;;          (if (os-type--windows95)
            ;;              (shell-command (concat "echo >tmp.bat start \"" filename "\""))
            ;;              (shell-command "start tmp.bat"))
            ;;              )
            ;;             ((string-match "\\.\\(gif\\|bmp\\|hlp\\)" filename)
            (t
             (d-beeps "end of cond: t")
             (let
                 ((cstr
                   (concat "cygstart \"" filename "\" &")))
               (shell-command cstr)
               (delete-other-windows)))))
          )))))))

  (when emacs-dialect--gnuemacs-p

    (define-key dired-mode-map "X" 'd-dired-do-shell-command)
    (define-key dired-mode-map "Z" 'd-dired-do-shell-command)
    )

  ;; "c:/WINDOWS/system32/command.com"
  (define-key dired-mode-map "." 'd-dired-period)
  (define-key dired-mode-map "," 'd-dired-comma)

  (when (fboundp 'd-find-file)
    (define-key dired-mode-map "\C-d" 'd-find-file)
    (define-key dired-mode-map "\C-f" 'd-find-file)
    )

  (if prefs-windows-bindings-p
      (define-key dired-mode-map "\C-o" nil)
    (define-key dired-mode-map "\C-o" 'd-dired--control-o)
    )

  (kill-local-variable 'mode-line-buffer-identification)
  (local-unset-key [(control d)])

  (set (make-local-variable 'font-lock-keywords-case-fold-search) t)
  (set (make-local-variable 'case-fold-search) t)

  (progn
    (make-local-variable 'font-lock-string-face)
    (setq font-lock-string-face 'fg:darkgray))

  (progn
    (make-local-variable 'font-lock-function-name-face)
    (setq font-lock-function-name-face 'fg:lightblue))

  (progn
    (make-local-variable 'font-lock-warning-face)
    (setq font-lock-warning-face 'd-face-blue-and-white))

  ;;(if (fboundp 'd-font-lock-remove-keywords)
  ;;    (d-font-lock-remove-keywords))

  ;;(set (make-local-variable 'font-lock-keywords) nil)
  ;;(setq dired-omit-files (concat "^\\(.*\\." d-files-regexp--unimportant "\\|\\..*$"))
  )

(add-hook 'dired-mode-hook          'd-dired-mode-hook)
(add-hook 'dired-after-readin-hook  'd-dired-mode-hook)
(add-hook 'dired-before-readin-hook 'd-dired-mode-hook)

(defun d-dired-omit-hook ()
  (when emacs-dialect--gnuemacs-p
    ;;(let ((prefs-home-emacs-p nil))
    (setq dired-omit-files-p (if prefs-home-emacs-p t nil))
    ;;(d-foo)
    )
  (if emacs-dialect--xemacs-p
      (setq dired-omit-files t))
  )

(add-hook 'dired-mode-hook 'd-dired-omit-hook)



(setq dired-listing-switches "-al") ;; should have g

(defun d-dired--splat-control-m ()
  (interactive)
  (assert (eq major-mode 'dired-mode))
  ;;(message (buffer-file-name))
  (let* ((dir             dired-directory)
         (auto-mode-alist (cons '("" . fundamental-mode) auto-mode-alist))
         (list            (directory-files-no-dotdotdot dir 'FULL nil t))
         (ptr             list)
         (control-m       nil))
    (while ptr
      ;; find-file doesn't seem to work properly within lisp code anymore!
      (set-buffer (find-file-noselect (car ptr)))
      ;;(message "visiting buffer %s" (buffer-name))
      (goto-char (point-min))
      (setq control-m " ") ;; so that there are no control-m's in the code!
      (aset control-m 0 13)
      (while (re-search-forward control-m nil t)
        (replace-match "" nil nil))
      (save-buffer)
      (message "killing buffer %s" (car ptr))
      (kill-buffer nil)
      (setq ptr (cdr ptr)))))

(setq dom 1)

(defun d-dired--control-o ()
  (interactive)
  (if (fboundp 'dired-omit-toggle) (dired-omit-toggle))
  ;;(setq dom (not dom))
  (if (eq dom 1)
      (setq dom -1)
    (setq dom 1))
  ;;(if dom (setq dom 1))
  (if (fboundp 'dired-omit-mode)
      (dired-omit-mode dom))
  (when emacs-dialect--xemacs-p
    (font-lock-fontify-buffer)
    (d-quote (save-excursion
             (goto-char (point-min))
             (while (not (eobp))
               (dired-next-line 1))
             )
           )
    ))



(defun d-dired-do-shell-command ()
  (interactive)
  (setq list
        (let ((files (dired-get-marked-files t current-prefix-arg)))
          (list
           ;; Want to give feedback whether this file or marked files are used:
           (dired-read-shell-command (concat "! on "
                                             "%s: ")
                                     current-prefix-arg
                                     files)
           current-prefix-arg
           files)))

  (setq do-it nil)
  (if (string-match "rm" (car list))
      (if (progn
            (beep)
            (yes-or-no-p "Are you sure you want to remove files? "))
          (setq do-it t))
    (setq do-it t))

  (if do-it (progn
              (apply 'dired-do-shell-command list)
              ;;(revert-buffer)
              ))
  )

(progn
  (setq ls-lisp-ignore-case t)
  (setq ls-lisp-dirs-first t)
  (setq ls-lisp-verbosity '(links uid gid))
  ;;(setq ls-lisp-verbosity nil)
  ;;(setq ls-lisp-emulation t)
  ;;(setq dired-use-ls-dired t)
  (setq ls-lisp-use-insert-directory-program nil)
  (safe-require 'ls-lisp)
  )

(defun d-dired-mark-all-files ()
  (interactive)
  (progn
    (dired-mark-files-regexp "")
    ;;(dired-mark-files-regexp "\\.js$")
    ;;(dired-mark-files-regexp "\\.php$")
    ;;(dired-mark-files-regexp "\\.cc")
    ;;(dired-mark-files-regexp "\\.ch")
    ;;(dired-mark-files-regexp "\\.hh")
    ))

(defun d-dired-insert-all-subdirs (dir)
  (interactive "DEnter dir:")
  (dired dir)
  (dired-insert-subdir dir "-lR")
  ;;(if (y-or-n-p "Mark files? ") (d-dired-mark-all-files))
  )

(setq dired-listing-switches "-al") ;; should have g

(defun insert-all-subdirs ()
  (interactive)
  (progn
    (let ((ptr (directory-files ".")))
      (while ptr
        (if (and (not (string= "." (car ptr)))
                 (not (string= ".." (car ptr)))
                 (file-directory-p (car ptr)))
            (dired-maybe-insert-subdir (car ptr) nil 'NO-ERROR-IF-NOT-DIR-P))
        (setq ptr (cdr ptr))))
    (message "done")
    ))

(defun dired-all-subdirs (dir)
  (interactive "FDired all subdirs: ")
  (dired dir)
  (insert-all-subdirs))

(provide 'd-dired)
;;; d-dired.el ends here
