
(require 'd-number-sayer)

(defvar flacs-compare--history nil)
(defvar flacs-compare--hdd-name   "F2TB")
(defvar flacs-compare--hdd-name   "J600GB")
(defvar flacs-compare--hdd-name   "K2TB")
(defvar flacs-compare--hdd-name-2 "K2TB")
(defvar flacs-compare--log-name   nil)
(defvar flacs-compare--stage      0)
(defvar d-compare-files--reason   nil)

;; (insert flacs-compare--drive-c-flacs) (setq dir "c:/flacs/")
(defun flacs-compare-from-hdd (which dir)
  (let (list ptr len count file-hd file-fd-1 file-fd-2 file-fd-3 a b stage)
    (setq list (directory-files-deep dir nil "\\.flac$"))
    (message "Done directory-files-deep %s" dir)
    (setq ptr list)
    (setq len (length list))
    (setq count 0)
    (setq stage flacs-compare--stage)
    (find-file flacs-compare--log-name)
    (while ptr
      (setq file-hd (concat dir (car ptr)))
      (let (dif)
        (setq flacs-compare--time-stop (current-time))
        (setq dif (seconds-of-time-difference flacs-compare--time-start flacs-compare--time-stop))
        (setq time-elapsed (seconds-to-readable-string dif)))
      (cond
       ((file-exists-p "f:/big")
        (setq file-fd-1 (concat "f:/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "f:/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "f:/flacs3/" (car ptr))))
       ((file-exists-p "g:/big")
        (setq file-fd-1 (concat "g:/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "g:/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "g:/flacs3/" (car ptr))))
       ((file-exists-p "h:/big")
        (setq file-fd-1 (concat "h:/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "h:/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "h:/flacs3/" (car ptr))))
       ((file-exists-p  (concat "/media/www/" flacs-compare--hdd-name "/"))
        (setq file-fd-1 (concat "/media/www/" flacs-compare--hdd-name "/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "/media/www/" flacs-compare--hdd-name "/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "/media/www/" flacs-compare--hdd-name "/flacs3/" (car ptr))))
       )
      (incf count)
      (if (eq (mod count 10) 0) (save-buffer buf))
      (when t
        (setq d-compare-files--reason nil)
        (save-excursion
          (find-file flacs-compare--log-name)
          (goto-char (point-max))
          (when (= which 1)
            ;;(debug "carrot")
            (if (d-compare-files file-hd file-fd-1)
                (insert "* compare \"" file-hd "\" with \"" file-fd-1 "\" OK\n")
              (condition-case err
                  (progn
                    (insert (format "* making directory %s\n" (file-name-directory file-fd-1)))
                    (make-directory (file-name-directory file-fd-1) 'PARENTS)
                    (copy-file file-hd file-fd-1 'OK-IF-ALREADY-EXISTS))
                (error
                 (d-message "Error copying file %s" err)))
              (insert "*** Error compare " file-hd " with " file-fd-1 " failed REASON=" d-compare-files--reason "\n")
              ;; -----------------------------------------------------
              (when d-is-big
                (if (d-compare-files file-hd file-fd-2)
                    (insert "* compare \"" file-hd "\" with \"" file-fd-2 "\" OK\n")
                  (condition-case err
                      (progn
                        (insert (format "* making directory %s\n" (file-name-directory file-fd-2)))
                        (make-directory (file-name-directory file-fd-2) 'PARENTS)
                        (copy-file file-hd file-fd-2 'OK-IF-ALREADY-EXISTS))
                    (error
                     (d-message "Error copying file %s" err)))
                  (insert "*** Error compare " file-hd " with " file-fd-2 " failed REASON=" d-compare-files--reason "\n")
                  ;; ---------------------------------------------------
                  (if (d-compare-files file-hd file-fd-3)
                      (insert "* compare \"" file-hd "\" with \"" file-fd-3 "\" OK\n")
                    (condition-case err
                        (progn
                          (insert (format "* making directory %s\n" (file-name-directory file-fd-3)))
                          (make-directory (file-name-directory file-fd-3) 'PARENTS)
                          (copy-file file-hd file-fd-3 'OK-IF-ALREADY-EXISTS))
                      (error
                       (d-message "Error copying file %s" err)))
                    (insert "*** Error compare " file-hd " with " file-fd-3 " failed REASON=" d-compare-files--reason "\n"))
                  ))))
          (when (= which 2)
            (if (d-compare-files file-hd file-fd-2)
                (insert "* compare \"" file-hd "\" with \"" file-fd-2 "\" OK\n")
              (condition-case err
                  (progn
                    (insert (format "* making directory %s\n" (file-name-directory file-fd-2)))
                    (make-directory (file-name-directory file-fd-2) 'PARENTS)
                    (copy-file file-hd file-fd-2 'OK-IF-ALREADY-EXISTS))
                (error
                 (d-message "Error copying file %s" err)))
              (insert "*** Error compare " file-hd " with " file-fd-2 " failed REASON=" d-compare-files--reason "\n")
              ;; -----------------------------------------------------
              (if (d-compare-files file-hd file-fd-3)
                  (insert "* compare \"" file-hd "\" with \"" file-fd-3 "\" OK\n")
                (condition-case err
                    (progn
                      (insert (format "* making directory %s\n" (file-name-directory file-fd-3)))
                      (make-directory (file-name-directory file-fd-3) 'PARENTS)
                      (copy-file file-hd file-fd-3 'OK-IF-ALREADY-EXISTS))
                  (error
                   (d-message "Error copying file %s" err)))
                (insert "*** Error compare " file-hd " with " file-fd-3 " failed REASON=" d-compare-files--reason "\n"))
              ))

          (when (= which 3)
            (if (d-compare-files file-hd file-fd-3)
                (insert "* compare \"" file-hd "\" with \"" file-fd-3 "\" OK\n")
              (condition-case err
                  (progn
                    (insert (format "* making directory %s\n" (file-name-directory file-fd-3)))
                    (make-directory (file-name-directory file-fd-3) 'PARENTS)
                    (copy-file file-hd file-fd-3 'OK-IF-ALREADY-EXISTS))
                (error
                 (d-message "Error copying file %s" err)))
              (insert "*** Error compare " file-hd " with " file-fd-3 " failed REASON=" d-compare-files--reason "\n"))
            )))
      (goto-char (point-max))
      (insert (format "* Progress=%d/%d (%d%% completed) Stage=%d\n"  count len (/ (* 100 count) len) flacs-compare--stage))
      ;;(message "*** Progress=%d/%d (%d%%) Stage %s" count len (/ (* 100 count) len) flacs-compare--stage)
      (setq ptr (cdr ptr)))
    ))

(defun flacs-compare-from-cd-drives (which)
  (flacs-compare-from-hdd which flacs-compare--drive-c-flacs)
  (incf flacs-compare--stage)
  (flacs-compare-from-hdd which flacs-compare--drive-d-flacs)
  )

;; (setq ptr '("Enya/Watermark/Track01.flac"))
(defun flacs-compare-from-f-drive ()
  (interactive)
  (let (colour list ptr len count file-hd file-fd-1 file-fd-2 file-fd-3 d-flacs)
    (setq list (directory-files-deep flacs-compare--drive-f1-flacs nil "\\.flac$"))
    (d-message "Done directory-files-deep %s" flacs-compare--drive-f1-flacs)
    ;;(assert (or (file-exists-p "h:/big") (file-exists-p "g:/big") (file-exists-p "/media/www/" flacs-compare--hdd-name "/big") (file-exists-p "/media/www/G16GB/big")))
    (setq ptr list)
    (setq len (length list))
    (setq count 0)
    (find-file flacs-compare--log-name)
    (while ptr
      (setq file-hd-c (concat flacs-compare--drive-c-flacs (car ptr)))
      (setq file-hd-d (concat flacs-compare--drive-d-flacs (car ptr)))
      (cond
       ((file-exists-p "f:/flacs/")
        (setq file-fd-1 (concat "f:/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "f:/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "f:/flacs3/" (car ptr))))
       ((file-exists-p "g:/flacs/")
        (setq file-fd-1 (concat "g:/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "g:/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "g:/flacs3/" (car ptr))))
       ((file-exists-p "h:/flacs")
        (setq file-fd-1 (concat "h:/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "h:/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "h:/flacs3/" (car ptr))))
       ((file-exists-p  (concat "/media/www/" flacs-compare--hdd-name "/"))
        (setq file-fd-1 (concat "/media/www/" flacs-compare--hdd-name "/flacs/"  (car ptr)))
        (setq file-fd-2 (concat "/media/www/" flacs-compare--hdd-name "/flacs2/" (car ptr)))
        (setq file-fd-3 (concat "/media/www/" flacs-compare--hdd-name "/flacs3/" (car ptr))))
       )
      (incf count)
      (if (eq (mod count 1000) 0) (save-buffer buf))
      (when t
        (save-excursion
          (find-file flacs-compare--log-name)
          (goto-char (point-max))
          (assert (file-exists-p file-fd-1))
          (if (and (not (file-exists-p file-hd-c))
                   (not (file-exists-p file-hd-d))
                   (file-exists-p file-fd-1))
              (progn
                (setq d-is-big (or (file-exists-p "f:/big")
                                   (file-exists-p "g:/big")
                                   (file-exists-p "h:/big")
                                   (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/big"))))
                (if (not d-is-big)
                    (delete-file file-fd-1)
                (delete-file file-fd-1)
                (delete-file file-fd-2)
                (delete-file file-fd-3))
                (d-message "*** Yes deleting files " file-fd-1 "," file-fd-2 " and " file-fd-3 "\n"))
            (d-message "** Not deleting files " file-fd-1 "," file-fd-2 "," file-fd-3 "\n")
            ;;(debug "foo")
            )))
      (d-message "*** Progress=%d/%d (%d%%) Stage=%d" count len (/ (* 100 count) len) flacs-compare--stage)
      (setq ptr (cdr ptr)))
    ))

;; (setq which 1)
;; (setq color "red")
(defun flacs-compare ()
  (interactive)
  (let (name buf stage colour (which 1) flacs-compare--time-start (d-message-on t) d-is-big d-which)
    (setq colour (read-from-minibuffer "Enter silver or black: " "white" nil 'flacs-compare--history))
    (setq flacs-compare--log-name (format "~/flacs-compare-%s-%d-%s.comp" (d-time--get-stamp) which colour))
    (setq buf (find-file flacs-compare--log-name))
    (setq flacs-compare--time-start (current-time))
    (setq flacs-compare--stage 0)
    (setq stage flacs-compare--stage)
    (setq truncate-lines nil)
    (save-excursion
      (find-file flacs-compare--log-name)
      (erase-buffer)
      (insert "**** BEGIN: archive-compare--compare-zips\n")
      (when (not (eq major-mode 'compilation-mode)) (compilation-mode))
      (read-only-mode -1)
      (save-buffer buf))
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    (setq flacs-compare--drive-c-flacs (if (file-exists-p "c:/flacs/")
                                           "c:/flacs/"
                                         (if (file-exists-p "/media/www/C80GB/flacs/")
                                             "/media/www/C80GB/flacs/")))
    (setq flacs-compare--drive-d-flacs (if (file-exists-p "d:/flacs/")
                                           "d:/flacs/"
                                         (if (file-exists-p "/media/www/D153GB/flacs/")
                                             "/media/www/D153GB/flacs/")))
    (setq flacs-compare--drive-f1-flacs (if (file-exists-p "f:/flacs/")
                                            "f:/flacs/"
                                          (if (file-exists-p "g:/flacs/")
                                              "g:/flacs/"
                                            (if (file-exists-p "h:/flacs/")
                                              "h:/flacs/"
                                              (if (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/flacs/"))
                                                  (concat "/media/www/" flacs-compare--hdd-name "/flacs/"))))))
    (setq flacs-compare--drive-f2-flacs (if (file-exists-p "f:/flacs2/")
                                            "f:/flacs2/"
                                          (if (file-exists-p "g:/flacs2/")
                                              "g:/flacs2/"
                                            (if (file-exists-p "h:/flacs2/")
                                                "h:/flacs2/"
                                                (if (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/flacs2/"))
                                                    (concat "/media/www/" flacs-compare--hdd-name "/flacs2/"))))))

    (setq flacs-compare--drive-f3-flacs (if (file-exists-p "f:/flacs3/")
                                            "f:/flacs3/"
                                          (if (file-exists-p "g:/flacs3/")
                                              "g:/flacs3/"
                                            (if (file-exists-p "h:/flacs3/")
                                                "h:/flacs3/"
                                                (if (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/flacs3/"))
                                                    (concat "/media/www/" flacs-compare--hdd-name "/flacs3/"))))))
    (setq d-is-big (or (file-exists-p "f:/big")
                       (file-exists-p "g:/big")
                       (file-exists-p "h:/big")
                       (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/big"))))
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    (incf flacs-compare--stage)
    (flacs-compare-from-f-drive)
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    (if d-is-big
        (progn
          (incf flacs-compare--stage)
          (flacs-compare-from-cd-drives 1)
          (incf flacs-compare--stage)
          (flacs-compare-from-cd-drives 2)
          (incf flacs-compare--stage)
          (flacs-compare-from-cd-drives 3)
          )
      (incf flacs-compare--stage)
      (flacs-compare-from-cd-drives 1))
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    (find-file flacs-compare--log-name)
    ;;(switch-to-buffer buf)
    (goto-char (point-max))
    (let (dif)
      (setq flacs-compare--time-stop (current-time))
      (setq dif (seconds-of-time-difference flacs-compare--time-start flacs-compare--time-stop))
      (insert "**** TIME TOOK: = " (seconds-to-readable-string dif) "\n"))
    (insert "**** STOPPED AT: " (d-time--get-stamp) "\n")
    (goto-char (point-max))
    (insert "**** END: archive-compare--compare-zips\n")
    (let ((count 0)
          (case-fold-search t))
      (save-excursion
        (find-file flacs-compare--log-name)
        ;;(set-buffer buf)
        (goto-char (point-min))
        (while (re-search-forward "Error" nil t)
          (incf count))
        (goto-char (point-max))
        (insert (format "**** ERRORS: %d\n" count))
        (d-random-play-emacs-midi (format "%s/emacs/completed-flacs-audit.wav" d-number-sayer-folder))
        (d-say-number-improved count)
        (d-random-play-emacs-midi (format "%s/emacs/numbers/errors-found.wav" d-number-sayer-folder))
        ))
    (find-file flacs-compare--log-name)
    (save-buffer buf)
    (read-only-mode 1)
    ))

(defun d-message (&rest rest)
  (let ((d-message-on t))
    (apply 'message rest)
    (insert (apply 'format rest))
    (insert "\n")
    ))

;; (setq ptr (directory-files-deep "/media/www/C80GB/flacs-incoming/" nil "\\.flac$"))
(defun flacs-copy-incoming ()
  (interactive)
  (let (colour time-started time-stopped a b d)
    (setq colour (read-from-minibuffer "Enter white or red: " "white" nil '("white red")))
    (setq buf (find-file (format "~/external-flacs-copy-%s-%s.txt" (d-time--get-stamp) colour)))
    (d-message "**** external-files started at %s" (d-time--get-stamp))
    ;;(d-message "***foo %s %s" "bar" "zip")
    (setq time-started (current-time))
    (progn
      (make-directory (concat "/media/www/" flacs-compare--hdd-name "/external-flacs") 'parents)
      (make-directory (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2") 'parents)
      (make-directory (concat "/media/www/" flacs-compare--hdd-name "/external-flacs3") 'parents))
    (let* ((list  (directory-files-deep "/media/www/C80GB/flacs-incoming/" nil "\\.\\(flac$\\|jpg\\)"))
           (ptr   list)
           (count 0)
           (len   (length list)))
      (while ptr
        (setq a (concat "/media/www/C80GB/flacs-incoming/" (car ptr)))
        (setq b (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/"  (car ptr)))
        (if (file-exists-p b)
            (d-message "** Not copying to file %s Progress=%d/%d (%d%%) Time elapsed=%s" b count len (/ (* 100 count) len) (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (d-message "* Copied file %s -> %s Progress=%d/%d (%d%%) Time elapsed=%s" a b count len (/ (* 100 count) len) (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (setq d (file-name-directory b))
          (make-directory d 'parents)
          (copy-file a b 'ok-if-already-exists 'keep-time))
        (setq a (concat "/media/www/C80GB/flacs-incoming/" (car ptr)))
        (setq b (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2/" (car ptr)))
        (if (file-exists-p b)
            (d-message "** Not copying to file %s Progress=%d/%d (%d%%) Time elapsed=%s" b count len (/ (* 100 count) len) (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (d-message "* Copied file %s -> %s Progress=%d/%d (%d%%) Time elapsed=%s" a b count len (/ (* 100 count) len) (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (setq d (file-name-directory b))
          (make-directory d 'PARENTS)
          (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME))
        (setq a (concat "/media/www/C80GB/flacs-incoming/" (car ptr)))
        (setq b (concat "/media/www/" flacs-compare--hdd-name "/external-flacs3/" (car ptr)))
        (if (file-exists-p b)
            (d-message "** Not copying to file %s Progress=%d/%d (%d%%) Time elapsed=%s" b count len (/ (* 100 count) len) (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (d-message "* Copied file %s -> %s Progress=%d/%d (%d%%) Time elapsed=%s" a b count len (/ (* 100 count) len) (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (setq d (file-name-directory b))
          (make-directory d 'PARENTS)
          (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME))
        ;;(d-message (format "*** Copied file %s" (car ptr)))
        (if (= (mod count 10) 0)
            (save-buffer))
        (incf count)
        (setq ptr (cdr ptr)))
      ;;(d-random-play-emacs-midi (format "%s/emacs/completed-flacs-audit.wav" d-number-sayer-folder))
      ;;(d-say-number-improved count)
      ;;(d-random-play-emacs-midi (format "%s/emacs/numbers/errors-found.wav" d-number-sayer-folder))
      (setq time-stopped (current-time))
      (d-message "**** external-files completed at %s" (d-time--get-stamp))
      (d-message "**** time took: %s\n" (seconds-to-readable-string (seconds-of-time-difference time-started time-stopped)))
      (save-buffer buf)
      )))

(defun flacs--report-errors-found ()
  (let ((error-count      0)
        (case-fold-search t))
    (goto-char (point-min))
    (while (re-search-forward "Error:" nil t)
      (incf error-count))
    (goto-char (point-max))
    (d-message "**** Errors found: %d\n" error-count)
    (d-random-play-emacs-midi (format "%s/emacs/completed-flacs-audit.wav" d-number-sayer-folder))
    (d-say-number-improved error-count)
    (d-random-play-emacs-midi (format "%s/emacs/numbers/errors-found.wav" d-number-sayer-folder))
    ))

(defun flacs-external-compare-flacs ()
  (interactive)
  (setq time-started (current-time))
  (find-file (format "~/external-flacs-archive-compare %s.txt" (d-time--get-stamp)))
  (d-message "**** external-compare started at %s" (d-time--get-stamp))
  (let* ((list  (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/") nil "\\.\\(flac\\|jpg\\)$"))
         (ptr   list)
         (count 0)
         (a     nil)
         (b     nil))
    (while ptr
      (setq a (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/"  (car ptr)))
      (setq b (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2/" (car ptr)))
      (if (d-compare-files a b)
          (d-message "* Not copying %s with %s (%d %% done)" a b (/ count (* 100 len)))
        (when d-compare-files--reason
          (d-message "* Yes copying file %s with %s (%d %% done) Reason: %s\n" a b (/ count (* 100 len)) d-compare-files--reason)
          (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)
          ))
      (setq a (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/"  (car ptr)))
      (setq b (concat "/media/www/" flacs-compare--hdd-name "/external-flacs3/" (car ptr)))
      (if (d-compare-files a b)
          (d-message "* Not copying %s with %s (%d %% done)" a b (/ count (* 100 len)))
        (when d-compare-files--reason
          (d-message "* Yes copying file %s with %s (%d %% done) Reason: %s\n" a b (/ count (* 100 len)) d-compare-files--reason)
          (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)))
      (if (eq (mod count 10) 0)
          (save-buffer))
      (incf count)
      (setq ptr (cdr ptr)))
    (flacs--report-errors-found)
    (setq time-stopped (current-time))
    (d-message "**** external-compare completed at %s" (d-time--get-stamp))
    (d-message "**** Time took: %s" (seconds-to-readable-string (seconds-of-time-difference time-started time-stopped)))
    (save-buffer buf)
    ))

(defun flacs-compare-copy-externals ()
  "Uses the variables flacs-compare--hdd-name and flacs-compare--hdd-name-2"
  (interactive)
  (let (time-started list ptr len count stage a b)
    (progn
      (assert (boundp 'flacs-compare--hdd-name))
      (assert (boundp 'flacs-compare--hdd-name-2))
      (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/external-flacs")))
      (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2")))
      (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/external-flacs3")))
      (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs")))
      (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs2")))
      (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs3")))
      )
    (setq time-started (current-time))
    (find-file (format "~/external-compare-copy-externals-%s.txt" (d-time--get-stamp)))
    (d-message "**** external-compare started at %s" (d-time--get-stamp))
    ;; ---------------------------------------------------------------
    (setq time-started (current-time))
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/") nil "\\.flac$"))
    (setq len (length list))
    (setq len (* 3 len))
    (setq ptr list)
    (setq stage 1)
    (setq count 0)
    (while ptr
      (setq a (concat "/media/www/" flacs-compare--hdd-name   "/external-flacs/" (car ptr)))
      (setq b (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs/" (car ptr)))
      (if (d-message a b)
          (d-message "Not copying %s -> %s Progress=%d/%d (%d%% done stage %s) Time elapsed=%s" a b count len (/ (* 100 count) len) stage (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
        (d-message "Copying failed: REASON=%s" d-compare-files--reason)
        (d-message "Yes copying %s -> %s Progress=%d/%d (%d%% done stage %s) Time elapsed=%s"   a b count len (/ (* 100 count) len) stage (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
        (make-directory (file-name-directory b) 'PARENTS)
        (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME))
      (incf count)
      (setq ptr (cdr ptr)))
    ;; ---------------------------------------------------------------
    (setq stage 2)
    (setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2/")))
    (when (file-exists-p (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs2"))
      (setq ptr list)
      (while ptr
        (setq a (concat "/media/www/" flacs-compare--hdd-name   "/external-flacs2/" (car ptr)))
        (setq b (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs2/" (car ptr)))
        (if (d-compare-files a b)
            (d-message "Not copying %s -> %s (%d%% done stage %s) Time elapsed=%s" a b count len (/ (* 100 count) len) stage (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (d-message "Copying failed: REASON=%s" d-compare-files--reason)
          (d-message "Yes copying %s -> %s Progress=%d/%d (%d%% done stage %s) Time elapsed=%s" a b count len (/ (* 100 count) len) stage (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (make-directory (file-name-directory b) 'PARENTS)
          (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME))
        (incf count)
        (setq ptr (cdr ptr)))))
    ;; ---------------------------------------------------------------
    (setq stage 3)
    (setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/")))
    (when (file-exists-p (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs3"))
      (setq ptr list)
      (while ptr
        (setq a (concat "/media/www/" flacs-compare--hdd-name   "/external-flacs3/" (car ptr)))
        (setq b (concat "/media/www/" flacs-compare--hdd-name-2 "/external-flacs3/" (car ptr)))
        (if (d-compare-files a b)
            (d-message "Not copying %s -> %s Progress=%d/%d (%d %% stage %s) Time elapsed=%s" a b count len (/ (* 100 count) len) stage (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (d-message "Copying failed: REASON=%s" d-compare-files--reason)
          (d-message "Yes copying %s -> %s Progress=%d/%d (%d%% done stage %s) Time elapsed=%s" a b count len (/ (* 100 count) len) stage (seconds-to-readable-string (seconds-of-time-difference time-started (current-time))))
          (make-directory (file-name-directory b) 'PARENTS)
          (copy-file a b 'OK-IF-ALREADY-EXISTS 'KEEP-TIME))
        (incf count)
        (setq ptr (cdr ptr))))
    (setq time-stopped (current-time))
    (d-message "**** external-compare completed at %s" (d-time--get-stamp))
    (d-message "**** Time took: %s" (seconds-to-readable-string (seconds-of-time-difference time-started time-stopped)))
    (save-buffer buf)
    )

(defun flacs--tower-backup--inner (stage ptr flacs-or-external-flacs)
  (while ptr
    (setq file-flash (concat "/media/www/" flacs-compare--hdd-name "/" flacs-or-external-flacs "/" (car ptr)))
    (setq file-tower-a (concat "/media/www/D153GB/" flacs-or-external-flacs "/" (car ptr)))
    (setq file-tower-b (concat "/media/www/C80GB/" flacs-or-external-flacs "/" (car ptr)))
    (let (dif)
      (setq flacs-compare--time-stop (current-time))
      (setq dif (seconds-of-time-difference flacs-compare--time-start flacs-compare--time-stop))
      (setq time-elapsed (seconds-to-readable-string dif)))
    ;; ---------------------------------------------------------------
    (cond
     ((and (file-exists-p file-tower-a)
           (file-exists-p file-tower-b))
      (d-message "Error: file exists on both hard drives of my tower case"))
     ;; --------------------------------------------------------------
     ((and (file-exists-p file-flash)
           (file-exists-p file-tower-a)
           (not (file-exists-p file-tower-b)))
      (if (d-compare-files file-tower-a file-flash)
          (d-message "Not copying file %s -> %s (%d%% done) stage %d time elapsed=%s" file-tower-a file-flash (/ (* 100 count) len) stage time-elapsed)
        (copy-file file-tower-a file-flash 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)
        (d-message "Yes copying file %s -> %s (%d%% done) stage %d time elapsed=%s" file-tower-a file-flash (/ (* 100 count) len) stage time-elapsed)))
     ;; --------------------------------------------------------------
     ((and (file-exists-p file-flash)
           (file-exists-p file-tower-b)
           (not (file-exists-p file-tower-a)))
      (if (d-compare-files file-tower-a file-flash)
          (d-message "Not copying file %s -> %s (%d%% done) stage %d time elapsed=%s" file-tower-a file-flash (/ (* 100 count) len) stage time-elapsed)
        (copy-file file-tower-a file-flash 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)
        (d-message "Yes copying file %s -> %s (%d%% done) stage %d time elapsed=%s" file-tower-a file-flash (/ (* 100 count) len) stage time-elapsed)))
     ;; --------------------------------------------------------------
     ((and (not (file-exists-p file-flash))
           (or (file-exists-p file-tower-a)
               (file-exists-p file-tower-b)))
      (condition-case err
          (progn
            (delete-file file-tower-a)
            (d-message "Deleting file %s" file-tower-a)
            (delete-file file-tower-b)
            (d-message "Deleting file %s" file-tower-b))
        (error
         (d-message "Error %s" err)
         )))
     ) ;; END COND!
     ;; --------------------------------------------------------------
    (if (eq (mod count 100) 0)
        (save-buffer buf))
    (incf count)
    (setq ptr (cdr ptr))
    ))

(defun flacs-tower-backup ()
  (interactive)
  (let (list ptr buf count len time-started)
    (assert (file-exists-p "/media/www/C80GB/flacs"))
    (assert (file-exists-p "/media/www/D153GB/flacs"))
    (setq flacs-compare--time-start (current-time))
    (setq buf (find-file (concat "~/flacs-tower-backup-" (d-time--get-stamp) ".txt")))
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep "/media/www/F2TB/flacs/" nil "\\.flac$"))
    (setq count 0)
    (setq len (length list))
    (flacs--tower-backup--inner 1 list "flacs")
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep "/media/www/C80GB/flacs/" nil "\\.flac$"))
    (setq count 0)
    (setq len (length list))
    (flacs--tower-backup--inner 2 list "flacs")
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep "/media/www/F2TB/flacs/" nil "\\.flac$"))
    (setq count 0)
    (setq len (length list))
    (flacs--tower-backup--inner 3 list "flacs")
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep "/media/www/D153GB/flacs/" nil "\\.flac$"))
    (setq count 0)
    (setq len (length list))
    (flacs--tower-backup--inner 4 list "flacs")
    ;; ---------------------------------------------------------------
    (save-buffer buf)
    (goto-char (point-max))
    (let (dif)
      (setq flacs-compare--time-stop (current-time))
      (setq dif (seconds-of-time-difference flacs-compare--time-start flacs-compare--time-stop))
      (insert "**** TIME TOOK: = " (seconds-to-readable-string dif) "\n"))
    (insert "**** STOPPED AT: " (d-time--get-stamp) "\n")
    (goto-char (point-max))
    (insert "**** END: archive-compare--compare-zips\n")
    (flacs--report-errors-found)
    (setq time-stopped (current-time))
    (d-message "**** external-compare completed at %s" (d-time--get-stamp))
    (save-buffer buf)
    ))

;;; (setq flacs-or-external-flacs "flacs")
;;; (setq ptr list)
;;; (setq count 0)
;;; (setq flacs-compare--hdd-name "F2TB")
;;; (setq flacs-compare--hdd-name "K2TB")
(defun flacs--laptop-backup--inner (stage ptr flacs-or-external-flacs folder-index)
  (let (count len)
    (setq count 0)
    (setq len (length ptr))
    (while ptr
      (setq file-flash  (concat "/media/www/" flacs-compare--hdd-name "/" flacs-or-external-flacs folder-index "/" (car ptr)))
      (setq file-laptop (concat "/media/www/C1TB/" flacs-or-external-flacs "/" (car ptr)))
      ;;(setq file-flash  (concat flacs-compare--external-drive flacs-or-external-flacs folder-index "/" (car ptr)))
      ;;(setq file-laptop (concat "c:/" flacs-or-external-flacs "/" (car ptr)))
      (let (dif)
        (setq flacs-compare--time-stop (current-time))
        (setq dif (seconds-of-time-difference flacs-compare--time-start flacs-compare--time-stop))
        (setq time-elapsed (seconds-to-readable-string dif)))
      ;; ---------------------------------------------------------------
      (cond
       ((and (file-exists-p file-flash)
             (file-exists-p file-laptop))
        (if (d-compare-files file-laptop file-flash)
            (d-message "Files %s and %s are identical (%d%% done) stage %d time elapsed=%s" file-flash file-laptop (/ (* 100 count) len) stage time-elapsed)
          (make-directory (file-name-directory file-flash) 'PARENTS)
          (when (and (not (string-match "/Led Zeppelin/Led Zeppelin Disc 2/" file-laptop))
                     (not (string-match "/Jeff Buckley/Grace" file-laptop)))
            (copy-file file-laptop file-flash 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)
            (d-message "Error: comparing files %s, %s (%d%% done) stage %d time elapsed=%s" file-flash file-laptop (/ (* 100 count) len) stage time-elapsed))))
       ((and (file-exists-p file-flash)
             (not (file-exists-p file-laptop)))
        (delete-file file-flash)
        (d-message "Deleting file %s" file-flash)
        )
       ((and (not (file-exists-p file-flash))
             (file-exists-p file-laptop))
        (make-directory (file-name-directory file-flash) 'PARENTS)
        (when (and (not (string-match "/Led Zeppelin/Led Zeppelin Disc 2/" file-laptop))
                   (not (string-match "Jeff Buckley/Grace" file-laptop)))
          (copy-file file-laptop file-flash 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)
          (d-message "Copying file %s -> %s (%d%% done) stage %d time elapsed=%s" file-laptop file-flash (/ (* 100 count) len) stage time-elapsed)
          ;;(delete-file file-laptop))
          )))

      (when (eq (mod count 100) 0)
        (save-buffer buf)
        ;;(debug "Saturday")
        )
      (incf count)
      (setq ptr (cdr ptr))
      )))

(setq flacs-compare--hdd-name "K2TB")
;;(setq flacs-compare--hdd-name "F2TB")
(setq flacs-compare--external-drive "k:/")
(defun flacs-laptop-backup ()
  (interactive)
  (let (list ptr buf count len time-started)
    (if (getenv "IS_DOS")
        (progn
          (assert (file-exists-p "c:/flacs"))
          (assert (file-exists-p (concat flacs-compare--external-drive "flacs")))
          (assert (file-exists-p (concat flacs-compare--external-drive "flacs2")))
          (assert (file-exists-p (concat flacs-compare--external-drive "flacs3")))
          (assert (file-exists-p "c:/external-flacs/"))
          (assert (file-exists-p (concat flacs-compare--external-drive "external-flacs")))
          (assert (file-exists-p (concat flacs-compare--external-drive "external-flacs2")))
          (assert (file-exists-p (concat flacs-compare--external-drive "external-flacs3"))))
      (progn
        (assert (file-exists-p "/media/www/C1TB/flacs"))
        (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/flacs")))
        (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/flacs2")))
        (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/flacs3")))
        (assert (file-exists-p "/media/www/C1TB/external-flacs/"))
        (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/external-flacs")))
        (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2")))
        (assert (file-exists-p (concat "/media/www/" flacs-compare--hdd-name "/external-flacs3"))))
      )
    (setq flacs-compare--time-start (current-time))
    (progn
      (setq buf (find-file-literally (concat "~/flacs-laptop-backup-" (d-time--get-stamp) "-" flacs-compare--hdd-name ".txt")))
      (set-buffer buf)
      (toggle-read-only -1)
      (insert "\n")
      (save-buffer buf))
    ;; ||
    ;; ++-------------------------------------------------------------
    ;;(setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs/") nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 0 list "external-flacs" "")
    ;; ---------------------------------------------------------------
    ;;(setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/flacs/") nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 1 list "flacs" "")
    ;; ---------------------------------------------------------------
    ;;(setq list (directory-files-deep "/media/www/C1TB/external-flacs/" nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 2 list "external-flacs" "")
    ;;----------------------------------------------------------------
    ;;(setq list (directory-files-deep "/media/www/C1TB/flacs/" nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 3 list "flacs" "")
    ;; ||
    ;; ++-------------------------------------------------------------
    ;;(setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs2/") nil "\\.flac$")) ;;;;;;
    ;;(flacs--laptop-backup--inner 4 list "external-flacs" "2") ;;;;
    ;; ---------------------------------------------------------------
    ;;(setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/flacs2/") nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 5 list "flacs" "2")
    ;; ---------------------------------------------------------------
    ;;(setq list (directory-files-deep "/media/www/C1TB/external-flacs/" nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 6 list "external-flacs" "2")
    ;;------------------------------------------------------------------
    ;;(setq list (directory-files-deep "/media/www/C1TB/flacs/" nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 7 list "flacs" "2")
    ;; ||
    ;; ++-------------------------------------------------------------
    ;;(setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/external-flacs3/") nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 8 list "external-flacs" "3")
    ;; ---------------------------------------------------------------
    ;;(setq list (directory-files-deep (concat "/media/www/" flacs-compare--hdd-name "/flacs3/") nil "\\.flac$"))
    ;;(flacs--laptop-backup--inner 9 list "flacs" "3")
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep "/media/www/C1TB/external-flacs/" nil "\\.flac$"))
    (flacs--laptop-backup--inner 10 list "external-flacs" "3")
    ;; ---------------------------------------------------------------
    (setq list (directory-files-deep "/media/www/C1TB/flacs/" nil "\\.flac$"))
    (flacs--laptop-backup--inner 11 list "flacs" "3")
    ;; ||
    ;; ++-------------------------------------------------------------
    (save-buffer buf)
    (goto-char (point-max))
    (let (dif)
      (setq flacs-compare--time-stop (current-time))
      (setq dif (seconds-of-time-difference flacs-compare--time-start flacs-compare--time-stop))
      (insert "**** TIME TOOK: = " (seconds-to-readable-string dif) "\n"))
    (insert "**** STOPPED AT: " (d-time--get-stamp) "\n")
    (goto-char (point-max))
    (insert "**** END: archive-compare--compare-zips\n")
    (flacs--report-errors-found)
    (d-message "**** external-compare completed at %s" (d-time--get-stamp))
    (save-buffer buf)
    ))

(defun flacs-patch ()
  (interactive)
  (assert (eq major-mode 'dired-mode))
  (save-some-buffers 'NO-QUESTIONS)
  (d-dired-advertised-find-file)
  (goto-char 0)
  (re-search-forward "[FK]2TB" nil t)
  (setq s (buffer-substring-no-properties (match-beginning 0) (match-end 0)))
  (kill-buffer nil)
  (setq f (d-dired-get-current-file))
  (when (not (string-match "^.*\\([FK]2TB\\).*$" f))
    (when (string-match "^/home/www/flacs-laptop-backup-\\(2015[0-9][0-9][0-9][0-9]\\-[0-9][0-9][0-9][0-9][0-9][0-9]\\)\\.txt$" f)
      (setq d (substring f (match-beginning 1) (match-end 1)))
      (rename-file f (concat "/home/www/flacs-laptop-backup-" d "-" s ".txt"))))
  (revert-buffer)
  )

(provide 'flacs-compare)
;;; flacs-compare.el ends here
