
(defvar star--buf-name "*star*")

(defun star--create-buffer ()
  (if (get-buffer star--buf-name)
      (kill-buffer (get-buffer star--buf-name)))
  (set-buffer (generate-new-buffer star--buf-name)))

(defun star-debug (filename)
  (interactive "fEnter filename: ")
  (let (p found line)
    (star--create-buffer)
    (save-excursion
      (set-buffer star--buf-name)
      (insert "cd " default-directory "\n")
      (insert "\n"))

    (save-excursion
      (find-file filename)
      (goto-char (point-min))
      (while (re-search-forward "\\<[A-Z]+[a-z][a-zA-Z0-9_]*\\>" nil t)

        (setq p (get-char-property (1- (point)) 'face))
        (when (and (not (eq p 'font-lock-string-face))
                   (not (eq p 'font-lock-comment-face)))
          (setq found (buffer-substring-no-properties (match-beginning 0) (match-end 0)))
          (setq line (d-what-line))
          (save-excursion
            (set-buffer star--buf-name)
            (goto-char (point-max))
            (insert (format "%s:%d: %s\n" (file-name-nondirectory filename) line found))))))
    (switch-to-buffer star--buf-name)
    (compilation-mode)
    (read-only-mode -1)
    ))

(provide 'star-debugger)
;;; star-debugger.el ends here
