
;;; d-indent.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-indent.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: indentation functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(d-quote defun indent ()
  (interactive)
  (goto-char (point-min))
  (while (re-search-forward "^\\([*]+\\) \\(BEG\\|END\\)" nil t)
    (setq len (length (buffer-substring-no-properties (match-beginning 1) (match-end 1))))
    (beginning-of-line)
    (insert (make-string len ? )))
  )

;; (d-set-indent 3)
(defun d-set-indent (*indent*)
  (save-match-data
    (save-excursion
      (beginning-of-line)
      (while (looking-at "[ \t]")
        (delete-char 1))
      (insert (make-string *indent* ? )))))

;;(global-set-key [kp-enter] 'd-indent-line)
;;// BEG
;;// END
(defun d-indent-line ()
  (interactive)
  (setq *indent*
        (cond
         ((save-excursion
            (forward-line 0)
            (beginning-of-line)
            (looking-at "^[ \t]*//[*]* END "))
          ;;(message "END")
          (- *indent* 1))
         ((save-excursion
            (forward-line -1)
            (beginning-of-line)
            (looking-at "^[ \t]*//[*]* BEG "))
          ;;(message "BEG")
          (+ *indent* 1))
         ((save-excursion
            (forward-line 0)
            (beginning-of-line)
            (looking-at "^[ \t]*[*]* END "))
          ;;(message "END")
          (- *indent* 1))
         ((save-excursion
            (forward-line -1)
            (beginning-of-line)
            (looking-at "^[ \t]*[*]* BEG "))
          ;;(message "BEG")
          (+ *indent* 1))
         (t
          *indent*)))
  (setq *indent* (max *indent* 0))
  (assert (>= *indent* 0))
  ;;(indent-line-to *indent*)
  (d-set-indent (* 3 *indent*))
  )

(defun d-indent ()
  (interactive)
  (save-excursion
    (goto-char (point-min))
    (let ((*indent* 0))
      (while (not (eobp))
        (forward-line 1)
        (d-indent-line)
        ;;(message "indent=%s line=%s" indent (d-what-line))
        ))))

(provide 'd-indent)
;;; d-indent.el ends here
