

;;; jtw-javac.el --- A program for receiving the output of the program: javac

;; Copyright (C) 2006-2016 Davin Pearson

;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: javac backend
;; Version: 2.0

;; This program is part of GNU Java Training Wheels.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Commentary:

;; A program for receiving the output of the program: java in the form
;; of a pipe.

;;; Known Bugs:

;; none so far!

;;; Code:

(require 'cl)
(assert *prefix*)

(setq load-path (cons (concat *prefix* "/share/emacs/site-lisp/dlisp")
                      load-path))

(require 'jtw-build-jtw)

(defun doit ()
  (interactive)
  ;;(read-line-pre)
  ;;(message "input8: jtw-javac: *stump*=%s" *stump*)
  (let (numb said-message red-line numb file-less-suffix old-suffix new-suffix
             line-left line-right file-plus-suffix location
             (case-fold-search t))
    (condition-case err
        ;;(while (setq red-line (d-read-line))
        (while (setq red-line (read-from-minibuffer ""))
          (setq said-message nil)
          ;;(message "input0: red-line=%s" red-line)
          ;;(if (not (string-match "^Loading " red-line))
          (cond
           ((string-match "\\(\\([a-zA-Z]:/\\|~/\\|/\\|./\\|\\)[a-zA-Z0-9_/]+\\)\\(\\.java\\):\\([0-9]+\\)" red-line)
            (progn
              (setq file (substring red-line (match-beginning 0) (match-end 3)))
              ;;(message "input6: filename=%s" file)
              (save-match-data
                (if (string-match "^/" file)
                    (setq file (substring file 1))))
              ;;(message "input7: filename=%s" file)
              ;;(setq said-message t)
              (setq numb             (1- (read-str (substring red-line (match-beginning 4) (match-end 4)))))
              (setq file-less-suffix (substring red-line (match-beginning 1) (match-end 1)))
              ;;(message "input3: red-line=%s" red-line)
              ;;(message "input3: file-less-suffix=%s" file-less-suffix)
              (setq old-suffix ".java")
              (setq new-suffix ".jtw")
              (setq line-left        (substring red-line 0 (match-end 1)))
              (setq line-right       (substring red-line (match-end 4)))
              (setq file-plus-suffix (concat file-less-suffix new-suffix))
              (setq file             (concat file-less-suffix old-suffix))
              (if (string-match "./" file)
                  (setq file (substring file (match-end 0))))
              ;;(setq default-directory (file-name-directory default-directory))
              ;;(setq file (concat default-directory file))
              ;;(error "Maria Callas")
              ;;(message "input8: (file-name-directory file)=%s" (file-name-directory file))
              ;;(message "input7: file=%s" file)
              ;;(message "input7: default-directory pre=%s" default-directory)
              (assert (stringp file))
              ;;(message "input7: file=%s" file)
              ;;(message "input9: (file-name-directory file)=%s" (file-name-directory file))
              (when (file-name-directory file)
                (assert (stringp (file-name-directory file)))
                (assert (stringp default-directory))
                (if (string-match (file-name-directory file) default-directory)
                    (setq default-directory (substring default-directory 0 (match-beginning 0))))
                ;;(message "input7: default-directory post=%s" default-directory)
                ;;(message "input7: (file-name-nondirectory)=%s" (file-name-nondirectory file))
                )
              (assert (stringp file))
              (assert (stringp default-directory))
              ;;(message "input8: (concat default-directory file)=%s" (concat default-directory file))
              ;;(message "input8: numb=%s" numb)
              (find-file (concat default-directory file))
              ;;(message "input2: finding file=%s" file)
              ;;(debug "Desolation Row")
              (goto-line numb)
              ;;(debug "Tiger Woods")
              ;;(message "input2: Amber Dempsey")
              ;;(message "input2: (buffer-file-name)=%s" (buffer-file-name))
              (setq location (warn--get-location))
              ;;(message "input2: (cdr location)=%d" (cdr location))
              ;;(message "input2: setq location")
              (setq red-line (concat line-left new-suffix ":" (prin1-to-string (cdr location)) line-right))
              ;;(message "input2: setq red-line")
              ;;(debug "Mass in B Minor")
              (message "input1: %s" red-line)))
           (t
            (message "input2: %s" red-line))))
      (error
       (if (and (not (string-match "Error reading from stdin" (prin1-to-string (cdr err))))
                (not (string-match "End of file"              (prin1-to-string (cdr err))))
                (not (string-match "Eobp"                     (prin1-to-string (cdr err)))))
           (message "input4: Error=%s" (cdr err)))
       ))))

(provide 'jtw-javac)
;; (/ (d-what-line) 58) 1 page
;;; end of jtw-javac.el
