/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.LetExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.ArrayNew;
import gnu.kawa.reflect.ArraySet;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotSet;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;

public class CompileInvoke {
    public static Expression validateApplyInvoke(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        int objIndex;
        int argsStartIndex;
        int margsLength;
        Type type0;
        Expression arg0;
        Invoke iproc = (Invoke)proc;
        char kind = iproc.kind;
        Compilation comp = visitor.getCompilation();
        Expression[] args = exp.getArgs();
        int nargs = args.length;
        if (!comp.mustCompile || nargs == 0 || (kind == 'V' || kind == '*') && nargs == 1) {
            exp.visitArgs(visitor);
            return exp;
        }
        args[0] = arg0 = visitor.visit(args[0], null);
        Type type = type0 = kind == 'V' || kind == '*' ? arg0.getType() : iproc.language.getTypeFor(arg0);
        ObjectType type2 = type0 instanceof PairClassType && kind == 'N' ? ((PairClassType)type0).instanceType : (type0 instanceof ObjectType ? (ObjectType)type0 : null);
        String name = CompileInvoke.getMethodName(args, kind);
        if (kind == 'V' || kind == '*') {
            margsLength = nargs - 1;
            argsStartIndex = 2;
            objIndex = 0;
        } else if (kind == 'N') {
            margsLength = nargs;
            argsStartIndex = 0;
            objIndex = -1;
        } else if (kind == 'S' || kind == 's') {
            margsLength = nargs - 2;
            argsStartIndex = 2;
            objIndex = -1;
        } else if (kind == 'P') {
            margsLength = nargs - 2;
            argsStartIndex = 3;
            objIndex = 1;
        } else {
            exp.visitArgs(visitor);
            return exp;
        }
        if (kind == 'N' && type2 instanceof ArrayType) {
            int i;
            Object arg1;
            ArrayType atype = (ArrayType)type2;
            Type elementType = atype.getComponentType();
            Expression sizeArg = null;
            boolean lengthSpecified = false;
            if (args.length >= 3 && args[1] instanceof QuoteExp && (arg1 = ((QuoteExp)args[1]).getValue()) instanceof Keyword && ("length".equals(name = ((Keyword)arg1).getName()) || "size".equals(name))) {
                sizeArg = args[2];
                lengthSpecified = true;
            }
            if (sizeArg == null) {
                sizeArg = QuoteExp.getInstance(new Integer(args.length - 1));
            }
            sizeArg = visitor.visit(sizeArg, Type.intType);
            ApplyExp alloc = new ApplyExp(new ArrayNew(elementType), new Expression[]{sizeArg});
            alloc.setType(atype);
            if (lengthSpecified && args.length == 3) {
                return alloc;
            }
            LetExp let2 = new LetExp(new Expression[]{alloc});
            Declaration adecl = let2.addDeclaration(null, atype);
            adecl.noteValue(alloc);
            BeginExp begin2 = new BeginExp();
            int index = 0;
            int n = i = lengthSpecified ? 3 : 1;
            while (i < args.length) {
                Object key;
                Expression arg = args[i];
                if (lengthSpecified && i + 1 < args.length && arg instanceof QuoteExp && (key = ((QuoteExp)arg).getValue()) instanceof Keyword) {
                    String kname = ((Keyword)key).getName();
                    try {
                        index = Integer.parseInt(kname);
                        arg = args[++i];
                    }
                    catch (Throwable ex) {
                        comp.error('e', "non-integer keyword '" + kname + "' in array constructor");
                        return exp;
                    }
                }
                arg = visitor.visit(arg, elementType);
                begin2.add(new ApplyExp(new ArraySet(elementType), new Expression[]{new ReferenceExp(adecl), QuoteExp.getInstance(new Integer(index)), arg}));
                ++index;
                ++i;
            }
            begin2.add(new ReferenceExp(adecl));
            let2.body = begin2;
            return let2;
        }
        if (type2 != null && name != null) {
            int maybeCount;
            int okCount;
            Object[] slots;
            int keywordStart;
            int numCode;
            MethodProc[] methods;
            Procedure constructor;
            if (type2 instanceof TypeValue && kind == 'N' && (constructor = ((TypeValue)((Object)type2)).getConstructor()) != null) {
                Expression[] xargs = new Expression[nargs - 1];
                System.arraycopy(args, 1, xargs, 0, nargs - 1);
                return visitor.visit((Expression)new ApplyExp(constructor, xargs), required);
            }
            ClassType caller = comp == null ? null : (comp.curClass != null ? comp.curClass : comp.mainClass);
            ObjectType ctype = type2;
            try {
                methods = CompileInvoke.getMethods(ctype, name, caller, iproc);
                numCode = ClassMethods.selectApplicable((PrimProcedure[])methods, margsLength);
            }
            catch (Exception ex) {
                comp.error('w', "unknown class: " + type2.getName());
                return exp;
            }
            int index = -1;
            if (kind == 'N' && ((keywordStart = CompileInvoke.hasKeywordArgument(1, args)) < args.length || numCode <= 0 && ClassMethods.selectApplicable((PrimProcedure[])methods, new Type[]{Compilation.typeClassType}) >> 32 == 1L) && ((slots = CompileInvoke.checkKeywords(ctype, args, keywordStart, caller)).length * 2 == args.length - keywordStart || ClassMethods.selectApplicable(ClassMethods.getMethods(ctype, "add", 'V', null, iproc.language), 2) > 0)) {
                ApplyExp ae;
                StringBuffer errbuf = null;
                for (int i = 0; i < slots.length; ++i) {
                    if (!(slots[i] instanceof String)) continue;
                    if (errbuf == null) {
                        errbuf = new StringBuffer();
                        errbuf.append("no field or setter ");
                    } else {
                        errbuf.append(", ");
                    }
                    errbuf.append('`');
                    errbuf.append(slots[i]);
                    errbuf.append('\'');
                }
                if (errbuf != null) {
                    errbuf.append(" in class ");
                    errbuf.append(type2.getName());
                    comp.error('w', errbuf.toString());
                    return exp;
                }
                if (keywordStart < args.length) {
                    Expression[] xargs = new Expression[keywordStart];
                    System.arraycopy(args, 0, xargs, 0, keywordStart);
                    ae = (ApplyExp)visitor.visit((Expression)new ApplyExp(exp.getFunction(), xargs), ctype);
                } else {
                    ae = new ApplyExp(methods[0], new Expression[]{arg0});
                }
                ae.setType(ctype);
                Expression e = ae;
                if (args.length > 0) {
                    for (int i = 0; i < slots.length; ++i) {
                        Object slot = slots[i];
                        Type stype = slot instanceof Method ? ((Method)slot).getParameterTypes()[0] : (slot instanceof Field ? ((Field)slot).getType() : null);
                        if (stype != null) {
                            stype = iproc.language.getLangTypeFor(stype);
                        }
                        Expression arg = visitor.visit(args[keywordStart + 2 * i + 1], stype);
                        Expression[] sargs = new Expression[]{ae, new QuoteExp(slot), arg};
                        ae = new ApplyExp(SlotSet.setFieldReturnObject, sargs);
                        ae.setType(ctype);
                    }
                    int sargs = keywordStart == args.length ? 1 : 2 * slots.length + keywordStart;
                    e = ae;
                    if (sargs < args.length) {
                        LetExp let3 = new LetExp(new Expression[]{e});
                        Declaration adecl = let3.addDeclaration(null, ctype);
                        adecl.noteValue(e);
                        BeginExp begin3 = new BeginExp();
                        for (int i = sargs; i < args.length; ++i) {
                            Expression[] iargs = new Expression[]{new ReferenceExp(adecl), QuoteExp.getInstance("add"), args[i]};
                            begin3.add(visitor.visit((Expression)new ApplyExp(Invoke.invoke, iargs), null));
                        }
                        begin3.add(new ReferenceExp(adecl));
                        let3.body = begin3;
                        e = let3;
                    }
                }
                return visitor.checkType(e.setLine(exp), required);
            }
            if (numCode >= 0) {
                for (int i = 1; i < nargs; ++i) {
                    boolean last;
                    Object atype = null;
                    boolean bl = last = i == nargs - 1;
                    if (kind == 'P' && i == 2 || kind != 'N' && i == 1) {
                        atype = null;
                    } else if (kind == 'P' && i == 1) {
                        atype = ctype;
                    } else if (numCode > 0) {
                        int pi = i - (kind == 'N' ? 1 : argsStartIndex);
                        for (int j = 0; j < numCode; ++j) {
                            MethodProc pproc = methods[j];
                            int pii = pi + (kind != 'S' && ((PrimProcedure)pproc).takesTarget() ? 1 : 0);
                            if (last && ((PrimProcedure)pproc).takesVarArgs() && pii == pproc.minArgs()) {
                                atype = null;
                            } else {
                                Type ptype = ((PrimProcedure)pproc).getParameterType(pii);
                                atype = j == 0 ? ptype : (ptype instanceof PrimType != atype instanceof PrimType ? null : Type.lowestCommonSuperType((Type)atype, ptype));
                            }
                            if (atype == null) break;
                        }
                    }
                    args[i] = visitor.visit(args[i], (Type)atype);
                }
                long num = CompileInvoke.selectApplicable((PrimProcedure[])methods, ctype, args, margsLength, argsStartIndex, objIndex);
                okCount = (int)(num >> 32);
                maybeCount = (int)num;
            } else {
                okCount = 0;
                maybeCount = 0;
            }
            int nmethods = methods.length;
            if (okCount + maybeCount == 0 && kind == 'N') {
                methods = CompileInvoke.getMethods(ctype, "valueOf", caller, Invoke.invokeStatic);
                argsStartIndex = 1;
                margsLength = nargs - 1;
                long num = CompileInvoke.selectApplicable((PrimProcedure[])methods, ctype, args, margsLength, argsStartIndex, -1);
                okCount = (int)(num >> 32);
                maybeCount = (int)num;
            }
            if (okCount + maybeCount == 0) {
                if (kind == 'P' || comp.warnInvokeUnknownMethod()) {
                    if (kind == 'N') {
                        name = name + "/valueOf";
                    }
                    StringBuilder sbuf = new StringBuilder();
                    if (nmethods + methods.length == 0) {
                        sbuf.append("no accessible method '");
                    } else if (numCode == -983040) {
                        sbuf.append("too few arguments for method '");
                    } else if (numCode == -917504) {
                        sbuf.append("too many arguments for method '");
                    } else {
                        sbuf.append("no possibly applicable method '");
                    }
                    sbuf.append(name);
                    sbuf.append("' in ");
                    sbuf.append(type2.getName());
                    comp.error(kind == 'P' ? (char)'e' : 'w', sbuf.toString());
                }
            } else if (okCount == 1 || okCount == 0 && maybeCount == 1) {
                index = 0;
            } else if (okCount > 0) {
                index = MethodProc.mostSpecific(methods, okCount);
                if (index < 0 && kind == 'S') {
                    for (int i = 0; i < okCount; ++i) {
                        if (!((PrimProcedure)methods[i]).getStaticFlag()) continue;
                        if (index >= 0) {
                            index = -1;
                            break;
                        }
                        index = i;
                    }
                }
                if (index < 0 && (kind == 'P' || comp.warnInvokeUnknownMethod())) {
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append("more than one definitely applicable method `");
                    sbuf.append(name);
                    sbuf.append("' in ");
                    sbuf.append(type2.getName());
                    CompileInvoke.append((PrimProcedure[])methods, okCount, sbuf);
                    comp.error(kind == 'P' ? (char)'e' : 'w', sbuf.toString());
                }
            } else if (kind == 'P' || comp.warnInvokeUnknownMethod()) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("more than one possibly applicable method '");
                sbuf.append(name);
                sbuf.append("' in ");
                sbuf.append(type2.getName());
                CompileInvoke.append((PrimProcedure[])methods, maybeCount, sbuf);
                comp.error(kind == 'P' ? (char)'e' : 'w', sbuf.toString());
            }
            if (index >= 0) {
                Expression[] margs = new Expression[margsLength];
                MethodProc method = methods[index];
                boolean variable = ((PrimProcedure)method).takesVarArgs();
                int dst = 0;
                if (objIndex >= 0) {
                    margs[dst++] = args[objIndex];
                }
                for (int src = argsStartIndex; src < args.length && dst < margs.length; ++src, ++dst) {
                    margs[dst] = args[src];
                }
                ApplyExp e = new ApplyExp(method, margs);
                e.setLine(exp);
                return visitor.visitApplyOnly(e, required);
            }
        }
        exp.visitArgs(visitor);
        return exp;
    }

    static Object[] checkKeywords(ObjectType type, Expression[] args, int start, ClassType caller) {
        int len = args.length;
        int npairs = 0;
        while (start + 2 * npairs + 1 < len && args[start + 2 * npairs].valueIfConstant() instanceof Keyword) {
            ++npairs;
        }
        Object[] fields = new Object[npairs];
        for (int i = 0; i < npairs; ++i) {
            Object value = args[start + 2 * i].valueIfConstant();
            String name = ((Keyword)value).getName();
            Member slot = SlotSet.lookupMember(type, name, caller);
            if (slot == null) {
                slot = type.getMethod(ClassExp.slotToMethodName("add", name), SlotSet.type1Array);
            }
            fields[i] = slot != null ? slot : name;
        }
        return fields;
    }

    private static String getMethodName(Expression[] args, char kind) {
        int nameIndex;
        if (kind == 'N') {
            return "<init>";
        }
        int n = nameIndex = kind == 'P' ? 2 : 1;
        if (args.length >= nameIndex + 1) {
            return ClassMethods.checkName(args[nameIndex], false);
        }
        return null;
    }

    private static void append(PrimProcedure[] methods, int mcount, StringBuffer sbuf) {
        for (int i = 0; i < mcount; ++i) {
            sbuf.append("\n  candidate: ");
            sbuf.append(methods[i]);
        }
    }

    protected static PrimProcedure[] getMethods(ObjectType ctype, String mname, ClassType caller, Invoke iproc) {
        char kind = iproc.kind;
        return ClassMethods.getMethods(ctype, mname, kind == 'P' ? (char)'P' : (kind == '*' || kind == 'V' ? (char)'V' : '\u0000'), caller, iproc.language);
    }

    static int hasKeywordArgument(int argsStartIndex, Expression[] args) {
        for (int i = argsStartIndex; i < args.length; ++i) {
            if (!(args[i].valueIfConstant() instanceof Keyword)) continue;
            return i;
        }
        return args.length;
    }

    private static long selectApplicable(PrimProcedure[] methods, ObjectType ctype, Expression[] args, int margsLength, int argsStartIndex, int objIndex) {
        Type[] atypes = new Type[margsLength];
        int dst = 0;
        if (objIndex >= 0) {
            atypes[dst++] = ctype;
        }
        for (int src = argsStartIndex; src < args.length && dst < atypes.length; ++src, ++dst) {
            Expression arg = args[src];
            Type atype = null;
            if (InlineCalls.checkIntValue(arg) != null) {
                atype = Type.intType;
            } else if (InlineCalls.checkLongValue(arg) != null) {
                atype = Type.longType;
            } else if (atype == null) {
                atype = arg.getType();
            }
            atypes[dst] = atype;
        }
        return ClassMethods.selectApplicable(methods, atypes);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType type, String name, Expression[] args) {
        MethodProc[] methods = CompileInvoke.getMethods(type, name, null, Invoke.invokeStatic);
        long num = CompileInvoke.selectApplicable((PrimProcedure[])methods, type, args, args.length, 0, -1);
        int okCount = (int)(num >> 32);
        int maybeCount = (int)num;
        int index = methods == null ? -1 : (okCount > 0 ? MethodProc.mostSpecific(methods, okCount) : (maybeCount == 1 ? 0 : -1));
        return index < 0 ? null : methods[index];
    }
}

