/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Environment;
import gnu.mapping.InheritingEnvironment;
import gnu.mapping.Location;
import gnu.mapping.Procedure;
import gnu.mapping.ValueStack;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import gnu.math.IntNum;
import java.io.File;

public class CallContext {
    static ThreadLocal currentContext = new ThreadLocal();
    Thread currentThread;
    Environment curEnvironment;
    public Procedure proc;
    public int pc;
    public ValueStack vstack = new ValueStack();
    public Consumer consumer = this.vstack;
    public Object value1;
    public Object value2;
    public Object value3;
    public Object value4;
    public Object[] values;
    public int ivalue1;
    public int ivalue2;
    public int count;
    public int next;
    public int where;
    public static final int ARG_IN_VALUES_ARRAY = 0;
    public static final int ARG_IN_VALUE1 = 1;
    public static final int ARG_IN_VALUE2 = 2;
    public static final int ARG_IN_VALUE3 = 3;
    public static final int ARG_IN_VALUE4 = 4;
    public static final int ARG_IN_IVALUE1 = 5;
    public static final int ARG_IN_IVALUE2 = 6;
    protected String baseUri;
    protected static String baseUriDefault;
    Location[] pushedFluids;
    int pushedFluidsCount;
    public Object[][] evalFrames;

    public final Environment getEnvironmentRaw() {
        return this.curEnvironment;
    }

    public final void setEnvironmentRaw(Environment env) {
        this.curEnvironment = env;
    }

    public final Environment getEnvironment() {
        if (this.curEnvironment == null) {
            InheritingEnvironment env = Environment.make(this.currentThread.getName(), Environment.global);
            env.flags |= 8;
            this.curEnvironment = env;
        }
        return this.curEnvironment;
    }

    public static void setInstance(CallContext ctx) {
        Thread thread2;
        ctx.currentThread = thread2 = Thread.currentThread();
        currentContext.set(ctx);
    }

    public static CallContext getOnlyInstance() {
        return (CallContext)currentContext.get();
    }

    public static CallContext getInstance() {
        CallContext ctx = CallContext.getOnlyInstance();
        if (ctx == null) {
            ctx = new CallContext();
            CallContext.setInstance(ctx);
        }
        return ctx;
    }

    Object getArgAsObject(int i) {
        if (i < 8) {
            switch (this.where >> 4 * i & 0xF) {
                case 1: {
                    return this.value1;
                }
                case 2: {
                    return this.value2;
                }
                case 3: {
                    return this.value3;
                }
                case 4: {
                    return this.value4;
                }
                case 5: {
                    return IntNum.make(this.ivalue1);
                }
                case 6: {
                    return IntNum.make(this.ivalue2);
                }
            }
        }
        return this.values[i];
    }

    public Object getNextArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(null, this.count);
        }
        return this.getArgAsObject(this.next++);
    }

    public int getNextIntArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(null, this.count);
        }
        Object arg = this.getArgAsObject(this.next++);
        return ((Number)arg).intValue();
    }

    public Object getNextArg(Object defaultValue) {
        if (this.next >= this.count) {
            return defaultValue;
        }
        return this.getArgAsObject(this.next++);
    }

    public int getNextIntArg(int defaultValue) {
        if (this.next >= this.count) {
            return defaultValue;
        }
        return ((Number)this.getArgAsObject(this.next++)).intValue();
    }

    public final Object[] getRestArgsArray(int next) {
        Object[] args = new Object[this.count - next];
        int i = 0;
        while (next < this.count) {
            args[i++] = this.getArgAsObject(next++);
        }
        return args;
    }

    public final LList getRestArgsList(int next) {
        LList nil;
        LList list = nil = LList.Empty;
        Pair last = null;
        while (next < this.count) {
            Pair pair = new Pair(this.getArgAsObject(next++), nil);
            if (last == null) {
                list = pair;
            } else {
                last.cdr = pair;
            }
            last = pair;
        }
        return list;
    }

    public void lastArg() {
        if (this.next < this.count) {
            throw new WrongArguments(null, this.count);
        }
        this.values = null;
    }

    public Object[] getArgs() {
        if (this.where == 0) {
            return this.values;
        }
        int n = this.count;
        this.next = 0;
        Object[] args = new Object[n];
        for (int i = 0; i < n; ++i) {
            args[i] = this.getNextArg();
        }
        return args;
    }

    public void runUntilDone() throws Throwable {
        Procedure proc;
        while ((proc = this.proc) != null) {
            this.proc = null;
            proc.apply(this);
        }
    }

    public final int startFromContext() {
        ValueStack vst = this.vstack;
        int oindex = vst.find(this.consumer);
        vst.ensureSpace(3);
        int gapStart = vst.gapStart;
        vst.data[gapStart++] = 61698;
        vst.setIntN(gapStart, oindex);
        this.consumer = vst;
        vst.gapStart = gapStart += 2;
        return gapStart;
    }

    public final Object getFromContext(int oldIndex) throws Throwable {
        this.runUntilDone();
        ValueStack vst = this.vstack;
        Object result = Values.make(vst, oldIndex, vst.gapStart);
        this.cleanupFromContext(oldIndex);
        return result;
    }

    public final void cleanupFromContext(int oldIndex) throws Throwable {
        ValueStack vst = this.vstack;
        char[] data = vst.data;
        int oindex = data[oldIndex - 2] << 16 | data[oldIndex - 1] & 0xFFFF;
        this.consumer = (Consumer)vst.objects[oindex];
        vst.objects[oindex] = null;
        vst.oindex = oindex;
        vst.gapStart = oldIndex - 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object runUntilValue() throws Throwable {
        Consumer consumerSave = this.consumer;
        ValueStack vst = this.vstack;
        this.consumer = vst;
        int dindexSave = vst.gapStart;
        int oindexSave = vst.oindex;
        try {
            this.runUntilDone();
            Object object2 = Values.make(vst, dindexSave, vst.gapStart);
            Object var7_6 = null;
            this.consumer = consumerSave;
            vst.gapStart = dindexSave;
            vst.oindex = oindexSave;
            return object2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.consumer = consumerSave;
            vst.gapStart = dindexSave;
            vst.oindex = oindexSave;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUntilValue(Consumer out) throws Throwable {
        Consumer consumerSave = this.consumer;
        this.consumer = out;
        try {
            this.runUntilDone();
        }
        finally {
            this.consumer = consumerSave;
        }
    }

    public void writeValue(Object value) {
        Values.writeValues(value, this.consumer);
    }

    public static String getBaseUriDefault() {
        String uri = baseUriDefault;
        if (uri == null) {
            baseUriDefault = uri = new File("").toURI().toString();
        }
        return uri;
    }

    public String getBaseUriRaw() {
        return this.baseUri;
    }

    public String getBaseUri() {
        String uri = this.baseUri;
        if (uri == null) {
            this.baseUri = uri = CallContext.getBaseUriDefault();
        }
        return uri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public final void pushFluid(Location loc) {
        Location[] fluids = this.pushedFluids;
        int count = this.pushedFluidsCount;
        if (fluids == null) {
            this.pushedFluids = fluids = new Location[10];
        } else if (count == fluids.length) {
            Location[] newFluids = new Location[2 * count];
            System.arraycopy(fluids, 0, newFluids, 0, count);
            fluids = newFluids;
            this.pushedFluids = newFluids;
        }
        fluids[count] = loc;
        this.pushedFluidsCount = count + 1;
    }

    public final void popFluid() {
        this.pushedFluids[--this.pushedFluidsCount] = null;
    }
}

