/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ScopeExp;
import java.util.Hashtable;
import java.util.Vector;

public class NameLookup {
    Hashtable map = new Hashtable(100);
    Language language;

    public NameLookup(Language language) {
        this.language = language;
    }

    public void push(Declaration declaration) {
        Object object2 = declaration.getSymbol();
        if (object2 == null) {
            return;
        }
        Object v = this.map.get(object2);
        if (v == null) {
            this.map.put(object2, declaration);
        } else {
            Vector<Declaration> vector;
            if (v instanceof Vector) {
                vector = (Vector<Declaration>)v;
            } else {
                vector = new Vector<Declaration>(10);
                vector.addElement((Declaration)v);
                this.map.put(object2, vector);
            }
            vector.addElement(declaration);
        }
    }

    public boolean pop(Declaration declaration) {
        Object object2 = declaration.getSymbol();
        if (object2 == null) {
            return false;
        }
        Object v = this.map.get(object2);
        if (v == declaration) {
            this.map.remove(object2);
            return true;
        }
        if (v instanceof Vector) {
            int n;
            Vector vector = (Vector)v;
            int n2 = n = vector.size();
            while (--n2 >= 0) {
                if (vector.elementAt(n2) != declaration) continue;
                while (++n2 < n) {
                    vector.setElementAt(vector.elementAt(n2), n2 - 1);
                }
                vector.setSize(n - 1);
                return true;
            }
        }
        return false;
    }

    public void push(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            this.push(declaration);
        }
    }

    public void pop(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            this.pop(declaration);
        }
    }

    public Declaration lookup(Object object2, int n) {
        int n2;
        Object v = this.map.get(object2);
        if (v == null) {
            return null;
        }
        if (v instanceof Declaration) {
            Declaration declaration = (Declaration)v;
            if (declaration.getSymbol() == object2 && (this.language.getNamespaceOf(declaration) & n) != 0) {
                return declaration;
            }
            return null;
        }
        Vector vector = (Vector)v;
        int n3 = n2 = vector.size();
        while (--n3 >= 0) {
            Declaration declaration = (Declaration)vector.elementAt(n3);
            if (declaration.getSymbol() != object2 || (this.language.getNamespaceOf(declaration) & n) == 0) continue;
            return declaration;
        }
        return null;
    }

    public Declaration lookup(Object object2, boolean bl) {
        return this.lookup(object2, bl ? 2 : 1);
    }
}

