/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Keyword;
import gnu.expr.QuoteExp;
import gnu.expr.Special;
import gnu.expr.Undefined;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ReaderIgnoreRestOfLine;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.lists.Convert;
import gnu.lists.F32Vector;
import gnu.lists.F64Vector;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.lists.S16Vector;
import gnu.lists.S32Vector;
import gnu.lists.S64Vector;
import gnu.lists.S8Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import gnu.lists.U16Vector;
import gnu.lists.U32Vector;
import gnu.lists.U64Vector;
import gnu.lists.U8Vector;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.UnboundLocationException;
import gnu.mapping.Values;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Quantity;
import gnu.math.RatNum;
import gnu.math.RealNum;
import gnu.math.Unit;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;

public class LispReader
extends Lexer {
    public static final char TOKEN_ESCAPE_CHAR = '\uffff';
    protected boolean seenEscapes;
    protected boolean initialColonIsKeyword = true;
    protected boolean finalColonIsKeyword = true;
    static final int SCM_COMPLEX = 1;
    public static final int SCM_NUMBERS = 1;

    public LispReader(LineBufferedReader lineBufferedReader) {
        super(lineBufferedReader);
    }

    public LispReader(LineBufferedReader lineBufferedReader, SourceMessages sourceMessages) {
        super(lineBufferedReader, sourceMessages);
    }

    public static Object lookupUnit(String string) {
        string = (string + "$unit").intern();
        try {
            return Environment.getCurrent().getChecked(string);
        }
        catch (UnboundLocationException unboundLocationException) {
            return string;
        }
    }

    public final void readNestedComment(char c, char c2) throws IOException {
        int n = 1;
        do {
            int n2;
            if ((n2 = this.read()) == 124) {
                n2 = this.read();
                if (n2 == c) {
                    --n;
                }
            } else if (n2 == c && (n2 = this.read()) == c2) {
                ++n;
            }
            if (n2 >= 0) continue;
            this.error("unexpected eof in " + c + c2 + " comment.");
            return;
        } while (n > 0);
    }

    public char getReadCase() {
        int n;
        try {
            String string = Environment.getCurrent().get("symbol-read-case", (Object)"P").toString();
            n = string.charAt(0);
            if (n != 80) {
                if (n == 117) {
                    n = 85;
                } else if (n == 100 || n == 108 || n == 76) {
                    n = 68;
                } else if (n == 105) {
                    n = 73;
                }
            }
        }
        catch (Exception exception) {
            n = 80;
        }
        return (char)n;
    }

    public Object readValues(int n) throws IOException, SyntaxException {
        return this.readValues(n, ReadTable.getCurrent().lookup(n));
    }

    public Object readValues(int n, ReadTableEntry readTableEntry) throws IOException, SyntaxException {
        int n2 = this.tokenBufferLength;
        if (readTableEntry == null) {
            String string = "invalid character #\\" + (char)n;
            if (this.interactive) {
                this.fatal(string);
            } else {
                this.error(string);
            }
            return Values.empty;
        }
        int n3 = readTableEntry.getKind();
        boolean bl = false;
        this.seenEscapes = false;
        switch (n3) {
            case 1: {
                return Values.empty;
            }
            case 5: 
            case 6: {
                Object object2 = readTableEntry.read(this, n, -1);
                return object2;
            }
            case 3: {
                n = this.read();
                if (n < 0) {
                    this.eofError("unexpected EOF after single escape");
                }
                this.tokenBufferAppend(65535);
                this.tokenBufferAppend(n);
                this.seenEscapes = true;
                n = this.read();
                break;
            }
            case 4: {
                bl = true;
                this.seenEscapes = true;
                n = this.read();
                break;
            }
        }
        this.readToken(n, bl, this.getReadCase());
        int n4 = this.tokenBufferLength;
        if (this.seenEscapes) {
            return this.returnSymbol(n2, n4);
        }
        return this.handleToken(n2, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readToken(int n, boolean bl, char c) throws IOException, SyntaxException {
        while (true) {
            ReadTableEntry readTableEntry;
            if (n < 0) {
                if (!bl) return;
                this.eofError("unexpected EOF between escapes");
            }
            if ((readTableEntry = ReadTable.getCurrent().lookup(n)) == null) {
                if (!bl) {
                    this.unread(n);
                    return;
                }
                this.tokenBufferAppend(65535);
                this.tokenBufferAppend(n);
            } else {
                int n2 = readTableEntry.getKind();
                if (n2 == 3) {
                    n = this.read();
                    if (n < 0) {
                        this.eofError("unexpected EOF after single escape");
                    }
                    this.tokenBufferAppend(65535);
                    this.tokenBufferAppend(n);
                    this.seenEscapes = true;
                } else if (n2 == 4) {
                    bl = !bl;
                } else if (bl) {
                    this.tokenBufferAppend(65535);
                    this.tokenBufferAppend(n);
                } else {
                    switch (n2) {
                        case 2: 
                        case 6: {
                            if (c == 'U' || c == 'I' && Character.isLowerCase((char)n)) {
                                n = Character.toUpperCase((char)n);
                            } else if (c == 'D' || c == 'I' && Character.isUpperCase((char)n)) {
                                n = Character.toLowerCase((char)n);
                            }
                            this.tokenBufferAppend(n);
                            break;
                        }
                        case 4: {
                            bl = true;
                            this.seenEscapes = true;
                            break;
                        }
                        case 5: {
                            this.unread(n);
                            return;
                        }
                        case 1: {
                            this.unread(n);
                            return;
                        }
                    }
                }
            }
            n = this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws IOException, SyntaxException {
        char c = ((InPort)this.port).readState;
        int n = this.tokenBufferLength;
        ((InPort)this.port).readState = (char)32;
        try {
            int n2;
            Object object2;
            do {
                if ((n2 = this.port.read()) >= 0) continue;
                object2 = Sequence.eofValue;
                return object2;
            } while ((object2 = this.readValues(n2)) == Values.empty);
            if (object2 == QuoteExp.voidExp) {
                object2 = Values.empty;
            }
            Object object3 = object2;
            return object3;
        }
        finally {
            this.tokenBufferLength = n;
            ((InPort)this.port).readState = c;
        }
    }

    private boolean isPotentialNumber(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c)) {
                ++n3;
                continue;
            }
            if (c == '-' || c == '+') {
                if (i + 1 != n2) continue;
                return false;
            }
            if (c == '#') {
                return true;
            }
            if (!(Character.isLetter(c) || c == '/' || c == '_' || c == '^' ? i == n : c != '.')) continue;
            return false;
        }
        return n3 > 0;
    }

    public static Object parseNumber(char[] cArray, int n, int n2, char c, int n3, int n4) {
        Object object2;
        int n5;
        int n6;
        int n7;
        char c2;
        int n8;
        int n9;
        block98: {
            n9 = n;
            n8 = n + n2;
            if (n9 >= n8) {
                return "no digits";
            }
            c2 = cArray[n9++];
            while (c2 == '#') {
                if (n9 >= n8) {
                    return "no digits";
                }
                c2 = cArray[n9++];
                switch (c2) {
                    case 'B': 
                    case 'b': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 2;
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 8;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 10;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 16;
                        break;
                    }
                    case 'E': 
                    case 'I': 
                    case 'e': 
                    case 'i': {
                        if (c != '\u0000') {
                            if (c == ' ') {
                                return "non-prefix exactness specifier";
                            }
                            return "duplicate exactness specifier";
                        }
                        c = c2;
                        break;
                    }
                    default: {
                        n7 = 0;
                        while ((n6 = Character.digit(c2, 10)) >= 0) {
                            n7 = 10 * n7 + n6;
                            if (n9 >= n8) {
                                return "missing letter after '#'";
                            }
                            c2 = cArray[n9++];
                        }
                        if (c2 == 'R' || c2 == 'r') {
                            if (n3 != 0) {
                                return "duplicate radix specifier";
                            }
                            if (n7 < 2 || n7 > 35) {
                                return "invalid radix specifier";
                            }
                            n3 = n7;
                            break;
                        }
                        return "unknown modifier '#" + c2 + '\'';
                    }
                }
                if (n9 >= n8) {
                    return "no digits";
                }
                c2 = cArray[n9++];
            }
            if (c == '\u0000') {
                c = (char)32;
            }
            if (n3 == 0) {
                n7 = n2;
                do {
                    if (--n7 >= 0) continue;
                    n3 = 10;
                    break block98;
                } while (cArray[n + n7] != '.');
                n3 = 10;
            }
        }
        n6 = n7 = c2 == '-' ? 1 : 0;
        if (c2 == '-' || c2 == '+') {
            if (n9 >= n8) {
                return "no digits following sign";
            }
            c2 = cArray[n9++];
        }
        if ((c2 == 'i' || c2 == 'I') && n9 == n8 && n == n9 - 2 && (n4 & 1) != 0) {
            char c3 = cArray[n];
            if (c3 != '+' && c3 != '-') {
                return "no digits";
            }
            if (c == 'i' || c == 'I') {
                return new DComplex(0.0, n7 != 0 ? -1.0 : 1.0);
            }
            return n7 != 0 ? Complex.imMinusOne() : Complex.imOne();
        }
        int n10 = n9 - 1;
        boolean bl = false;
        char c4 = '\u0000';
        int n11 = -1;
        int n12 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        IntNum intNum = null;
        long l = 0L;
        block15: while (true) {
            if ((n5 = Character.digit(c2, n3)) >= 0) {
                if (bl && n12 < 0) {
                    return "digit after '#' in number";
                }
                if (n11 < 0) {
                    n11 = n9 - 1;
                }
                l = (long)n3 * l + (long)n5;
            } else {
                switch (c2) {
                    case '.': {
                        if (n12 >= 0) {
                            return "duplicate '.' in number";
                        }
                        if (n3 != 10) {
                            return "'.' in non-decimal number";
                        }
                        n12 = n9 - 1;
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'L': 
                    case 'S': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'l': 
                    case 's': {
                        if (n9 == n8 || n3 != 10) {
                            --n9;
                            break block15;
                        }
                        char c5 = cArray[n9];
                        if (c5 == '+' || c5 == '-') {
                            if (++n9 >= n8 || Character.digit(cArray[n9], 10) < 0) {
                                return "missing exponent digits";
                            }
                        } else if (Character.digit(c5, 10) < 0) {
                            --n9;
                            break block15;
                        }
                        if (c4 != '\u0000') {
                            return "duplicate exponent";
                        }
                        if (n3 != 10) {
                            return "exponent in non-decimal number";
                        }
                        if (n11 < 0) {
                            return "mantissa with no digits";
                        }
                        c4 = c2;
                        while (++n9 < n8 && Character.digit(cArray[n9], 10) >= 0) {
                        }
                        break block15;
                    }
                    case '/': {
                        if (intNum != null) {
                            return "multiple fraction symbol '/'";
                        }
                        if (n11 < 0) {
                            return "no digits before fraction symbol '/'";
                        }
                        if (c4 != '\u0000' || n12 >= 0) {
                            return "fraction symbol '/' following exponent or '.'";
                        }
                        intNum = LispReader.valueOf(cArray, n11, n9 - n11, n3, n7 != 0, l);
                        n11 = -1;
                        l = 0L;
                        n7 = 0;
                        bl = false;
                        bl3 = false;
                        break;
                    }
                    default: {
                        --n9;
                        break block15;
                    }
                }
            }
            if (n9 == n8) break;
            c2 = cArray[n9++];
        }
        if (n11 < 0) {
            return "no digits";
        }
        if (bl || bl3) {
            // empty if block
        }
        n5 = c == 'i' || c == 'I' || c == ' ' && bl ? 1 : 0;
        Object object3 = null;
        if (c4 != '\u0000' || n12 >= 0) {
            if (n11 > n12 && n12 >= 0) {
                n11 = n12;
            }
            if (intNum != null) {
                return "floating-point number after fraction symbol '/'";
            }
            object2 = new String(cArray, n11, n9 - n11);
            double d = Convert.parseDouble((String)object2);
            object3 = new DFloNum(n7 != 0 ? -d : d);
        } else {
            object2 = LispReader.valueOf(cArray, n11, n9 - n11, n3, n7 != 0, l);
            if (intNum == null) {
                object3 = object2;
            } else if (((IntNum)object2).isZero()) {
                boolean bl4 = intNum.isZero();
                if (n5 != 0) {
                    object3 = new DFloNum(bl4 ? Double.NaN : (n6 != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY));
                } else {
                    if (bl4) {
                        return "0/0 is undefined";
                    }
                    object3 = RatNum.make(intNum, (IntNum)object2);
                }
            } else {
                object3 = RatNum.make(intNum, (IntNum)object2);
            }
            if (n5 != 0 && ((Complex)object3).isExact()) {
                object3 = new DFloNum(n6 != 0 && ((RealNum)object3).isZero() ? -0.0 : ((Complex)object3).doubleValue());
            }
        }
        if (c == 'e' || c == 'E') {
            object3 = ((RealNum)object3).toExact();
        }
        if (n9 < n8) {
            char c6;
            if ((c2 = cArray[n9++]) == '@') {
                object2 = LispReader.parseNumber(cArray, n9, n8 - n9, c, 10, n4);
                if (object2 instanceof String) {
                    return object2;
                }
                if (!(object2 instanceof RealNum)) {
                    return "invalid complex polar constant";
                }
                RealNum realNum = (RealNum)object2;
                if (((RealNum)object3).isZero() && !realNum.isExact()) {
                    return new DFloNum(0.0);
                }
                return Complex.polar((RealNum)object3, realNum);
            }
            if (c2 == '-' || c2 == '+') {
                if ((object2 = LispReader.parseNumber(cArray, --n9, n8 - n9, c, 10, n4)) instanceof String) {
                    return object2;
                }
                if (!(object2 instanceof Complex)) {
                    return "invalid numeric constant (" + object2 + ")";
                }
                Complex complex = (Complex)object2;
                RealNum realNum = complex.re();
                if (!realNum.isZero()) {
                    return "invalid numeric constant";
                }
                return Complex.make((RealNum)object3, complex.im());
            }
            int n13 = 0;
            while (true) {
                if (!Character.isLetter(c2)) {
                    --n9;
                    break;
                }
                ++n13;
                if (n9 == n8) break;
                c2 = cArray[n9++];
            }
            if (n13 == 1 && ((c6 = cArray[n9 - 1]) == 'i' || c6 == 'I')) {
                if (n9 < n8) {
                    return "junk after imaginary suffix 'i'";
                }
                return Complex.make(IntNum.zero(), (RealNum)object3);
            }
            if (n13 > 0) {
                Object object4;
                block99: {
                    object4 = null;
                    block18: do {
                        String string = new String(cArray, n9 - n13, n13);
                        Object object5 = LispReader.lookupUnit(string);
                        int n14 = 1;
                        if (n9 < n8) {
                            boolean bl5;
                            c2 = cArray[n9];
                            if (c2 == '^' && ++n9 < n8) {
                                c2 = cArray[n9];
                            }
                            boolean bl6 = bl5 = c2 == '-';
                            if ((c2 == '-' || c2 == '+') && ++n9 < n8) {
                                c2 = cArray[n9];
                            }
                            n14 = -1;
                            while (true) {
                                int n15;
                                if ((n15 = Character.digit(c2, 10)) < 0) {
                                    if (n14 >= 0) break;
                                    return "junk after unit name";
                                }
                                int n16 = n14 = n14 < 0 ? n15 : 10 * n14 + n15;
                                if (++n9 == n8) break;
                                if (n14 > 1000000) {
                                    return "unit power too large";
                                }
                                c2 = cArray[n9];
                            }
                            if (bl5) {
                                n14 = -n14;
                            }
                        }
                        if (n14 != 1) {
                            object5 = object5 instanceof Unit ? Unit.pow((Unit)object5, n14) : LList.list3("expt", object5, IntNum.make(n14));
                        }
                        object4 = object4 == null ? object5 : (object5 instanceof Unit && object4 instanceof Unit ? Unit.times((Unit)object4, (Unit)object5) : LList.list3("*", object4, object5));
                        if (n9 >= n8) break block99;
                        if ((c2 = cArray[n9++]) == '*') {
                            if (n9 == n8) {
                                return "end of token after '*'";
                            }
                            c2 = cArray[n9++];
                        }
                        n13 = 0;
                        while (true) {
                            if (!Character.isLetter(c2)) {
                                --n9;
                                continue block18;
                            }
                            ++n13;
                            if (n9 == n8) continue block18;
                            c2 = cArray[n9++];
                        }
                    } while (n13 != 0);
                    return "excess junk after unit";
                }
                if (object4 == null) {
                    return "expected unit";
                }
                if (object4 instanceof Unit) {
                    return Quantity.make((Complex)object3, (Unit)object4);
                }
                return LList.list3("*", object3, object4);
            }
            return "excess junk after number";
        }
        return object3;
    }

    private static IntNum valueOf(char[] cArray, int n, int n2, int n3, boolean bl, long l) {
        if (n2 + n3 <= 28) {
            return IntNum.make(bl ? -l : l);
        }
        return IntNum.valueOf(cArray, n, n2, n3, bl);
    }

    protected Object returnSymbol(int n, int n2) {
        char c;
        int n3;
        int n4;
        int n5;
        int n6 = this.getReadCase();
        if (n6 == 73) {
            n5 = 0;
            n4 = 0;
            for (n3 = n; n3 < n2; ++n3) {
                c = this.tokenBuffer[n3];
                if (c == '\uffff') {
                    ++n3;
                    continue;
                }
                if (Character.isLowerCase(c)) {
                    ++n4;
                    continue;
                }
                if (!Character.isUpperCase(c)) continue;
                ++n5;
            }
            n6 = n4 == 0 ? 68 : (n5 == 0 ? 85 : 80);
        }
        n5 = -1;
        n4 = n;
        for (n3 = n; n3 < n2; ++n3) {
            c = this.tokenBuffer[n3];
            if (c == '\uffff') {
                if (++n3 >= n2) continue;
                this.tokenBuffer[n4++] = this.tokenBuffer[n3];
                continue;
            }
            if (c == ':') {
                n5 = n5 >= 0 ? -1 : n4;
            } else if (n6 == 85) {
                c = Character.toUpperCase(c);
            } else if (n6 == 68) {
                c = Character.toLowerCase(c);
            }
            this.tokenBuffer[n4++] = c;
        }
        n2 = n4;
        n3 = n2 - n;
        if (this.initialColonIsKeyword && n5 == n && n3 > 1) {
            String string = new String(this.tokenBuffer, ++n, n2 - n);
            return Keyword.make(string.intern());
        }
        if (this.finalColonIsKeyword && n5 == n2 - 1 && n3 > 1) {
            String string = new String(this.tokenBuffer, n, n3 - 1);
            return Keyword.make(string.intern());
        }
        return this.makeSymbol(new String(this.tokenBuffer, n, n3));
    }

    public Object handleToken(int n, int n2) {
        Object object2 = LispReader.parseNumber(this.tokenBuffer, n, n2 - n, '\u0000', 0, 1);
        if (object2 != null && !(object2 instanceof String)) {
            return object2;
        }
        if (this.isPotentialNumber(this.tokenBuffer, n, n2)) {
            this.error(object2 == null ? "not a valid number" : "not a valid number: " + object2);
            return IntNum.zero();
        }
        return this.returnSymbol(n, n2);
    }

    public int readEscape() throws IOException, SyntaxException {
        int n = this.read();
        if (n < 0) {
            this.eofError("unexpected EOF in character literal");
            return -1;
        }
        return this.readEscape(n);
    }

    public final int readEscape(int n) throws IOException, SyntaxException {
        block0 : switch ((char)n) {
            case 'a': {
                n = 7;
                break;
            }
            case 'b': {
                n = 8;
                break;
            }
            case 't': {
                n = 9;
                break;
            }
            case 'n': {
                n = 10;
                break;
            }
            case 'v': {
                n = 11;
                break;
            }
            case 'f': {
                n = 12;
                break;
            }
            case 'r': {
                n = 13;
                break;
            }
            case 'e': {
                n = 27;
                break;
            }
            case '\"': {
                n = 34;
                break;
            }
            case '\\': {
                n = 92;
                break;
            }
            case ' ': {
                do {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected EOF in character literal");
                        return -1;
                    }
                    if (n == 10) {
                        return -2;
                    }
                    if (n != 13) continue;
                    if (this.peek() == 10) {
                        this.skip();
                    }
                    return -2;
                } while (n == 32 || n == 9);
                this.unread(n);
            }
            case '\r': {
                if (this.peek() == 10) {
                    this.skip();
                }
                return -2;
            }
            case '\n': {
                return -2;
            }
            case 'M': {
                n = this.read();
                if (n != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
                n = this.read();
                if (n == 92) {
                    n = this.readEscape();
                }
                return n | 0x80;
            }
            case 'C': {
                n = this.read();
                if (n != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
            }
            case '^': {
                n = this.read();
                if (n == 92) {
                    n = this.readEscape();
                }
                if (n == 63) {
                    return 127;
                }
                return n & 0x9F;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                n -= 48;
                int n2 = 0;
                while (++n2 < 3) {
                    int n3 = this.read();
                    int n4 = Character.digit((char)n3, 8);
                    if (n4 >= 0) {
                        n = (n << 3) + n4;
                        continue;
                    }
                    if (n3 < 0) break block0;
                    this.unread(n3);
                    break block0;
                }
                break;
            }
            case 'u': {
                n = 0;
                int n5 = 4;
                while (--n5 >= 0) {
                    int n6;
                    int n7 = this.read();
                    if (n7 < 0) {
                        this.eofError("premature EOF in \\u escape");
                    }
                    if ((n6 = Character.digit((char)n7, 16)) < 0) {
                        this.error("non-hex character following \\u");
                    }
                    n = 16 * n + n6;
                }
                break;
            }
            case 'x': {
                int n8;
                int n9;
                n = 0;
                while ((n9 = Character.digit((char)(n8 = this.read()), 16)) >= 0) {
                    n = (n << 4) + n9;
                }
                if (n8 < 0) break;
                this.unread(n8);
                break;
            }
        }
        return n;
    }

    public final Object readObject(int n) throws IOException, SyntaxException {
        this.unread(n);
        return this.readObject();
    }

    public Object readCommand() throws IOException, SyntaxException {
        return this.readObject();
    }

    protected Object makeSymbol(String string) {
        return string.intern();
    }

    protected Object makeNil() {
        return LList.Empty;
    }

    protected Object makePair(Object object2, int n, int n2) {
        return PairWithPosition.make(object2, LList.Empty, this.port.getName(), n + 1, n2 + 1);
    }

    public Object makePair(Object object2, Object object3) {
        Object object4 = this.makePair(object2, 0, 0);
        this.setCdr(object4, object3);
        return object4;
    }

    protected void setCdr(Object object2, Object object3) {
        ((Pair)object2).cdr = object3;
    }

    public static Object readNumberWithRadix(int n, LispReader lispReader, int n2) throws IOException, SyntaxException {
        int n3 = lispReader.tokenBufferLength - n;
        lispReader.readToken(lispReader.read(), false, 'P');
        int n4 = lispReader.tokenBufferLength;
        if (n3 == n4) {
            lispReader.error("missing numeric token");
            return IntNum.zero();
        }
        Object object2 = LispReader.parseNumber(lispReader.tokenBuffer, n3, n4 - n3, '\u0000', n2, 0);
        if (object2 instanceof String) {
            lispReader.error((String)object2);
            return IntNum.zero();
        }
        if (object2 == null) {
            lispReader.error("invalid numeric constant");
            return IntNum.zero();
        }
        return object2;
    }

    public static Object readCharacter(LispReader lispReader) throws IOException, SyntaxException {
        int n = lispReader.read();
        if (n < 0) {
            lispReader.eofError("unexpected EOF in character literal");
        }
        int n2 = lispReader.tokenBufferLength;
        lispReader.tokenBufferAppend(n);
        lispReader.readToken(lispReader.read(), false, 'D');
        int n3 = lispReader.tokenBufferLength - n2;
        if (n3 == 1) {
            return Char.make(lispReader.tokenBuffer[n2]);
        }
        String string = new String(lispReader.tokenBuffer, n2, n3);
        n = Char.nameToChar(string);
        if (n >= 0) {
            return Char.make(n);
        }
        n = Character.digit(lispReader.tokenBuffer[n2], 8);
        if (n >= 0) {
            int n4 = n;
            int n5 = 1;
            while (true) {
                if (n5 == n3) {
                    return Char.make(n4);
                }
                n = Character.digit(lispReader.tokenBuffer[n2 + n5], 8);
                if (n < 0) break;
                n4 = 8 * n4 + n;
                ++n5;
            }
        }
        lispReader.error("unknown character name: " + string);
        return Char.make(63);
    }

    public static Object readSpecial(LispReader lispReader) throws IOException, SyntaxException {
        int n = lispReader.read();
        if (n < 0) {
            lispReader.eofError("unexpected EOF in #! special form");
        }
        if (n == 47 && lispReader.getLineNumber() == 0 && lispReader.getColumnNumber() == 3) {
            ReaderIgnoreRestOfLine.getInstance().read(lispReader, 35, 1);
            return Values.empty;
        }
        int n2 = lispReader.tokenBufferLength;
        lispReader.tokenBufferAppend(n);
        lispReader.readToken(lispReader.read(), false, 'D');
        int n3 = lispReader.tokenBufferLength - n2;
        String string = new String(lispReader.tokenBuffer, n2, n3);
        if (string.equals("optional")) {
            return Special.optional;
        }
        if (string.equals("rest")) {
            return Special.rest;
        }
        if (string.equals("key")) {
            return Special.key;
        }
        if (string.equals("eof")) {
            return Special.eof;
        }
        if (string.equals("void")) {
            return QuoteExp.voidExp;
        }
        if (string.equals("default")) {
            return Special.dfault;
        }
        if (string.equals("undefined")) {
            return Undefined.undefined;
        }
        if (string.equals("null")) {
            return null;
        }
        lispReader.error("unknown named constant #!" + string);
        return null;
    }

    public static SimpleVector readSimpleVector(LispReader lispReader, char c) throws IOException, SyntaxException {
        int n;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n = lispReader.read()) < 0) {
                lispReader.eofError("unexpected EOF reading uniform vector");
            }
            if ((n3 = Character.digit((char)n, 10)) < 0) break;
            n2 = n2 * 10 + n3;
        }
        if (n2 != 8 && n2 != 16 && n2 != 32 && n2 != 64 || c == 'F' && n2 < 32 || n != 40) {
            lispReader.error("invalid uniform vector syntax");
            return null;
        }
        Object object2 = ReaderParens.readList(lispReader, 40, -1, 41);
        int n4 = LList.listLength(object2, false);
        if (n4 < 0) {
            lispReader.error("invalid elements in uniform vector syntax");
            return null;
        }
        Sequence sequence = (Sequence)object2;
        switch (c) {
            case 'F': {
                switch (n2) {
                    case 32: {
                        return new F32Vector(sequence);
                    }
                    case 64: {
                        return new F64Vector(sequence);
                    }
                }
            }
            case 'S': {
                switch (n2) {
                    case 8: {
                        return new S8Vector(sequence);
                    }
                    case 16: {
                        return new S16Vector(sequence);
                    }
                    case 32: {
                        return new S32Vector(sequence);
                    }
                    case 64: {
                        return new S64Vector(sequence);
                    }
                }
            }
            case 'U': {
                switch (n2) {
                    case 8: {
                        return new U8Vector(sequence);
                    }
                    case 16: {
                        return new U16Vector(sequence);
                    }
                    case 32: {
                        return new U32Vector(sequence);
                    }
                    case 64: {
                        return new U64Vector(sequence);
                    }
                }
            }
        }
        return null;
    }
}

