/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Environment;
import gnu.mapping.InheritingEnvironment;
import gnu.mapping.Location;
import gnu.mapping.Procedure;
import gnu.mapping.ValueStack;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import gnu.math.IntNum;
import java.io.File;

public class CallContext {
    static ThreadLocal currentContext = new ThreadLocal();
    Thread currentThread;
    Environment curEnvironment;
    public Procedure proc;
    public int pc;
    public ValueStack vstack = new ValueStack();
    public Consumer consumer = this.vstack;
    public Object value1;
    public Object value2;
    public Object value3;
    public Object value4;
    public Object[] values;
    public int ivalue1;
    public int ivalue2;
    public int count;
    public int next;
    public int where;
    public static final int ARG_IN_VALUES_ARRAY = 0;
    public static final int ARG_IN_VALUE1 = 1;
    public static final int ARG_IN_VALUE2 = 2;
    public static final int ARG_IN_VALUE3 = 3;
    public static final int ARG_IN_VALUE4 = 4;
    public static final int ARG_IN_IVALUE1 = 5;
    public static final int ARG_IN_IVALUE2 = 6;
    protected String baseUri;
    protected static String baseUriDefault;
    Location[] pushedFluids;
    int pushedFluidsCount;

    public final Environment getEnvironmentRaw() {
        return this.curEnvironment;
    }

    public final void setEnvironmentRaw(Environment environment) {
        this.curEnvironment = environment;
    }

    public final Environment getEnvironment() {
        if (this.curEnvironment == null) {
            InheritingEnvironment inheritingEnvironment = Environment.make(this.currentThread.getName(), Environment.global);
            inheritingEnvironment.flags |= 8;
            this.curEnvironment = inheritingEnvironment;
        }
        return this.curEnvironment;
    }

    public static void setInstance(CallContext callContext) {
        Thread thread2;
        callContext.currentThread = thread2 = Thread.currentThread();
        currentContext.set(callContext);
    }

    public static CallContext getOnlyInstance() {
        return (CallContext)currentContext.get();
    }

    public static CallContext getInstance() {
        CallContext callContext = CallContext.getOnlyInstance();
        if (callContext == null) {
            callContext = new CallContext();
            CallContext.setInstance(callContext);
        }
        return callContext;
    }

    Object getArgAsObject(int n) {
        if (n < 8) {
            switch (this.where >> 4 * n & 0xF) {
                case 1: {
                    return this.value1;
                }
                case 2: {
                    return this.value2;
                }
                case 3: {
                    return this.value3;
                }
                case 4: {
                    return this.value4;
                }
                case 5: {
                    return IntNum.make(this.ivalue1);
                }
                case 6: {
                    return IntNum.make(this.ivalue2);
                }
            }
        }
        return this.values[n];
    }

    public Object getNextArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(null, this.count);
        }
        return this.getArgAsObject(this.next++);
    }

    public int getNextIntArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(null, this.count);
        }
        Object object2 = this.getArgAsObject(this.next++);
        return ((Number)object2).intValue();
    }

    public Object getNextArg(Object object2) {
        if (this.next >= this.count) {
            return object2;
        }
        return this.getArgAsObject(this.next++);
    }

    public int getNextIntArg(int n) {
        if (this.next >= this.count) {
            return n;
        }
        return ((Number)this.getArgAsObject(this.next++)).intValue();
    }

    public final Object[] getRestArgsArray(int n) {
        Object[] objectArray = new Object[this.count - n];
        int n2 = 0;
        while (n < this.count) {
            objectArray[n2++] = this.getArgAsObject(n++);
        }
        return objectArray;
    }

    public final LList getRestArgsList(int n) {
        LList lList;
        LList lList2 = lList = LList.Empty;
        Pair pair = null;
        while (n < this.count) {
            Pair pair2 = new Pair(this.getArgAsObject(n++), lList);
            if (pair == null) {
                lList2 = pair2;
            } else {
                pair.cdr = pair2;
            }
            pair = pair2;
        }
        return lList2;
    }

    public void lastArg() {
        if (this.next < this.count) {
            throw new WrongArguments(null, this.count);
        }
        this.values = null;
    }

    public Object[] getArgs() {
        if (this.where == 0) {
            return this.values;
        }
        int n = this.count;
        this.next = 0;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getNextArg();
        }
        return objectArray;
    }

    public void runUntilDone() throws Throwable {
        Procedure procedure;
        while ((procedure = this.proc) != null) {
            this.proc = null;
            procedure.apply(this);
        }
    }

    public final int startFromContext() {
        ValueStack valueStack = this.vstack;
        int n = valueStack.find(this.consumer);
        valueStack.ensureSpace(3);
        int n2 = valueStack.gapStart;
        valueStack.data[n2++] = 61698;
        valueStack.setIntN(n2, n);
        this.consumer = valueStack;
        valueStack.gapStart = n2 += 2;
        return n2;
    }

    public final Object getFromContext(int n) throws Throwable {
        this.runUntilDone();
        ValueStack valueStack = this.vstack;
        Object object2 = Values.make(valueStack, n, valueStack.gapStart);
        this.cleanupFromContext(n);
        return object2;
    }

    public final void cleanupFromContext(int n) throws Throwable {
        ValueStack valueStack = this.vstack;
        char[] cArray = valueStack.data;
        int n2 = cArray[n - 2] << 16 | cArray[n - 1] & 0xFFFF;
        this.consumer = (Consumer)valueStack.objects[n2];
        valueStack.objects[n2] = null;
        valueStack.oindex = n2;
        valueStack.gapStart = n - 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object runUntilValue() throws Throwable {
        Consumer consumer = this.consumer;
        ValueStack valueStack = this.vstack;
        this.consumer = valueStack;
        int n = valueStack.gapStart;
        int n2 = valueStack.oindex;
        try {
            this.runUntilDone();
            Object object2 = Values.make(valueStack, n, valueStack.gapStart);
            Object var7_6 = null;
            this.consumer = consumer;
            valueStack.gapStart = n;
            valueStack.oindex = n2;
            return object2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.consumer = consumer;
            valueStack.gapStart = n;
            valueStack.oindex = n2;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUntilValue(Consumer consumer) throws Throwable {
        Consumer consumer2 = this.consumer;
        this.consumer = consumer;
        try {
            this.runUntilDone();
        }
        finally {
            this.consumer = consumer2;
        }
    }

    public void writeValue(Object object2) {
        Values.writeValues(object2, this.consumer);
    }

    public static String getBaseUriDefault() {
        String string = baseUriDefault;
        if (string == null) {
            baseUriDefault = string = new File("").toURI().toString();
        }
        return string;
    }

    public String getBaseUriRaw() {
        return this.baseUri;
    }

    public String getBaseUri() {
        String string = this.baseUri;
        if (string == null) {
            this.baseUri = string = CallContext.getBaseUriDefault();
        }
        return string;
    }

    public void setBaseUri(String string) {
        this.baseUri = string;
    }

    public final void pushFluid(Location location2) {
        Location[] locationArray = this.pushedFluids;
        int n = this.pushedFluidsCount;
        if (locationArray == null) {
            this.pushedFluids = locationArray = new Location[10];
        } else if (n == locationArray.length) {
            Location[] locationArray2 = new Location[2 * n];
            System.arraycopy(locationArray, 0, locationArray2, 0, n);
            locationArray = locationArray2;
            this.pushedFluids = locationArray2;
        }
        locationArray[n] = location2;
        this.pushedFluidsCount = n + 1;
    }

    public final void popFluid() {
        this.pushedFluids[--this.pushedFluidsCount] = null;
    }
}

