/* Jump to a new context.
   Copyright (C) 2002-2014 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <sysdep.h>
#include <rtld-global-offsets.h>
#include <shlib-compat.h>
#include <kernel-features.h>

#define __ASSEMBLY__
#include <asm/ptrace.h>
#include "ucontext_i.h"

#define __CONTEXT_FUNC_NAME __setcontext
#define __CONTEXT_ENABLE_FPRS 1
#define __CONTEXT_ENABLE_VRS 1

/* Size of ucontext in GLIBC_2.3.4 and later.  */
#define _UC_SIZE_2_3_4	1184

	.section ".text";
ENTRY (__setcontext)
	mr	r4,r3
	li	r3,0
	li	r5,_UC_SIZE_2_3_4;
	DO_CALL (SYS_ify (swapcontext));
	bso-	cr0,1f
/* the kernel does not set the return code for the success case */
	li	r3,0
	blr
1:
	b	__syscall_error@local
END(__setcontext)

versioned_symbol (libc, __setcontext, setcontext, GLIBC_2_3_4)

#if SHLIB_COMPAT (libc, GLIBC_2_3_3, GLIBC_2_3_4)

	compat_text_section

# undef __CONTEXT_FUNC_NAME
# define __CONTEXT_FUNC_NAME __novec_setcontext
# undef __CONTEXT_ENABLE_VRS

# include "setcontext-common.S"

	.previous

compat_symbol (libc, __novec_setcontext, setcontext, GLIBC_2_3_3)

#endif

#if SHLIB_COMPAT (libc, GLIBC_2_0, GLIBC_2_3_3)

# define _ERRNO_H	1
# include <bits/errno.h>

	compat_text_section
ENTRY (__setcontext_stub)
	li	r3,ENOSYS
	b	__syscall_error@local
END (__setcontext_stub)
	.previous

compat_symbol (libc, __setcontext_stub, setcontext, GLIBC_2_0)

#endif
