/* Mapping tables for SJIS handling.
   Copyright (C) 1997-2014 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ulrich Drepper <drepper@cygnus.com>, 1997.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <dlfcn.h>
#include <stdint.h>
#include <wchar.h>


/* The following table can be generated from the file
	unix/mappings/eastasia/jis/shiftjis.txt
   from the Unicode CD (also available on their FTP server) using
   the command

	egrep '^0x8[01234][[:xdigit:]][[:xdigit:]]' \
	  /mnt/cdrom/unix/mappings/eastasia/jis/shiftjis.txt | perl ~/sjis.pl

   where sjis.pl contains:

  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  while (<>) {
    local($sjis, $ucs, %rest) = split;
    $sjis = hex($sjis) - 0x8140;
    local($sidx) = int($sjis / 256) * 192 + ($sjis % 256);
    printf "\n " if (($n % 4) == 0);
    ++$n;
    printf " [%4d] = %s,", $sidx, $ucs;
  }
  print "\n";
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

static const uint16_t cjk_block1[703] =
{
  [  0] = 0x3000, [  1] = 0x3001, [  2] = 0x3002, [  3] = 0xFF0C,
  [  4] = 0xFF0E, [  5] = 0x30FB, [  6] = 0xFF1A, [  7] = 0xFF1B,
  [  8] = 0xFF1F, [  9] = 0xFF01, [ 10] = 0x309B, [ 11] = 0x309C,
  [ 12] = 0x00B4, [ 13] = 0xFF40, [ 14] = 0x00A8, [ 15] = 0xFF3E,
  [ 16] = 0xFFE3, [ 17] = 0xFF3F, [ 18] = 0x30FD, [ 19] = 0x30FE,
  [ 20] = 0x309D, [ 21] = 0x309E, [ 22] = 0x3003, [ 23] = 0x4EDD,
  [ 24] = 0x3005, [ 25] = 0x3006, [ 26] = 0x3007, [ 27] = 0x30FC,
  [ 28] = 0x2015, [ 29] = 0x2010, [ 30] = 0xFF0F, [ 31] = 0xFF3C,
  [ 32] = 0x301C, [ 33] = 0x2016, [ 34] = 0xFF5C, [ 35] = 0x2026,
  [ 36] = 0x2025, [ 37] = 0x2018, [ 38] = 0x2019, [ 39] = 0x201C,
  [ 40] = 0x201D, [ 41] = 0xFF08, [ 42] = 0xFF09, [ 43] = 0x3014,
  [ 44] = 0x3015, [ 45] = 0xFF3B, [ 46] = 0xFF3D, [ 47] = 0xFF5B,
  [ 48] = 0xFF5D, [ 49] = 0x3008, [ 50] = 0x3009, [ 51] = 0x300A,
  [ 52] = 0x300B, [ 53] = 0x300C, [ 54] = 0x300D, [ 55] = 0x300E,
  [ 56] = 0x300F, [ 57] = 0x3010, [ 58] = 0x3011, [ 59] = 0xFF0B,
  [ 60] = 0x2212, [ 61] = 0x00B1, [ 62] = 0x00D7, [ 64] = 0x00F7,
  [ 65] = 0xFF1D, [ 66] = 0x2260, [ 67] = 0xFF1C, [ 68] = 0xFF1E,
  [ 69] = 0x2266, [ 70] = 0x2267, [ 71] = 0x221E, [ 72] = 0x2234,
  [ 73] = 0x2642, [ 74] = 0x2640, [ 75] = 0x00B0, [ 76] = 0x2032,
  [ 77] = 0x2033, [ 78] = 0x2103, [ 79] = 0xFFE5, [ 80] = 0xFF04,
  [ 81] = 0x00A2, [ 82] = 0x00A3, [ 83] = 0xFF05, [ 84] = 0xFF03,
  [ 85] = 0xFF06, [ 86] = 0xFF0A, [ 87] = 0xFF20, [ 88] = 0x00A7,
  [ 89] = 0x2606, [ 90] = 0x2605, [ 91] = 0x25CB, [ 92] = 0x25CF,
  [ 93] = 0x25CE, [ 94] = 0x25C7, [ 95] = 0x25C6, [ 96] = 0x25A1,
  [ 97] = 0x25A0, [ 98] = 0x25B3, [ 99] = 0x25B2, [100] = 0x25BD,
  [101] = 0x25BC, [102] = 0x203B, [103] = 0x3012, [104] = 0x2192,
  [105] = 0x2190, [106] = 0x2191, [107] = 0x2193, [108] = 0x3013,
  [120] = 0x2208, [121] = 0x220B, [122] = 0x2286, [123] = 0x2287,
  [124] = 0x2282, [125] = 0x2283, [126] = 0x222A, [127] = 0x2229,
  [136] = 0x2227, [137] = 0x2228, [138] = 0x00AC, [139] = 0x21D2,
  [140] = 0x21D4, [141] = 0x2200, [142] = 0x2203, [154] = 0x2220,
  [155] = 0x22A5, [156] = 0x2312, [157] = 0x2202, [158] = 0x2207,
  [159] = 0x2261, [160] = 0x2252, [161] = 0x226A, [162] = 0x226B,
  [163] = 0x221A, [164] = 0x223D, [165] = 0x221D, [166] = 0x2235,
  [167] = 0x222B, [168] = 0x222C, [176] = 0x212B, [177] = 0x2030,
  [178] = 0x266F, [179] = 0x266D, [180] = 0x266A, [181] = 0x2020,
  [182] = 0x2021, [183] = 0x00B6, [188] = 0x25EF, [207] = 0xFF10,
  [208] = 0xFF11, [209] = 0xFF12, [210] = 0xFF13, [211] = 0xFF14,
  [212] = 0xFF15, [213] = 0xFF16, [214] = 0xFF17, [215] = 0xFF18,
  [216] = 0xFF19, [224] = 0xFF21, [225] = 0xFF22, [226] = 0xFF23,
  [227] = 0xFF24, [228] = 0xFF25, [229] = 0xFF26, [230] = 0xFF27,
  [231] = 0xFF28, [232] = 0xFF29, [233] = 0xFF2A, [234] = 0xFF2B,
  [235] = 0xFF2C, [236] = 0xFF2D, [237] = 0xFF2E, [238] = 0xFF2F,
  [239] = 0xFF30, [240] = 0xFF31, [241] = 0xFF32, [242] = 0xFF33,
  [243] = 0xFF34, [244] = 0xFF35, [245] = 0xFF36, [246] = 0xFF37,
  [247] = 0xFF38, [248] = 0xFF39, [249] = 0xFF3A, [257] = 0xFF41,
  [258] = 0xFF42, [259] = 0xFF43, [260] = 0xFF44, [261] = 0xFF45,
  [262] = 0xFF46, [263] = 0xFF47, [264] = 0xFF48, [265] = 0xFF49,
  [266] = 0xFF4A, [267] = 0xFF4B, [268] = 0xFF4C, [269] = 0xFF4D,
  [270] = 0xFF4E, [271] = 0xFF4F, [272] = 0xFF50, [273] = 0xFF51,
  [274] = 0xFF52, [275] = 0xFF53, [276] = 0xFF54, [277] = 0xFF55,
  [278] = 0xFF56, [279] = 0xFF57, [280] = 0xFF58, [281] = 0xFF59,
  [282] = 0xFF5A, [287] = 0x3041, [288] = 0x3042, [289] = 0x3043,
  [290] = 0x3044, [291] = 0x3045, [292] = 0x3046, [293] = 0x3047,
  [294] = 0x3048, [295] = 0x3049, [296] = 0x304A, [297] = 0x304B,
  [298] = 0x304C, [299] = 0x304D, [300] = 0x304E, [301] = 0x304F,
  [302] = 0x3050, [303] = 0x3051, [304] = 0x3052, [305] = 0x3053,
  [306] = 0x3054, [307] = 0x3055, [308] = 0x3056, [309] = 0x3057,
  [310] = 0x3058, [311] = 0x3059, [312] = 0x305A, [313] = 0x305B,
  [314] = 0x305C, [315] = 0x305D, [316] = 0x305E, [317] = 0x305F,
  [318] = 0x3060, [319] = 0x3061, [320] = 0x3062, [321] = 0x3063,
  [322] = 0x3064, [323] = 0x3065, [324] = 0x3066, [325] = 0x3067,
  [326] = 0x3068, [327] = 0x3069, [328] = 0x306A, [329] = 0x306B,
  [330] = 0x306C, [331] = 0x306D, [332] = 0x306E, [333] = 0x306F,
  [334] = 0x3070, [335] = 0x3071, [336] = 0x3072, [337] = 0x3073,
  [338] = 0x3074, [339] = 0x3075, [340] = 0x3076, [341] = 0x3077,
  [342] = 0x3078, [343] = 0x3079, [344] = 0x307A, [345] = 0x307B,
  [346] = 0x307C, [347] = 0x307D, [348] = 0x307E, [349] = 0x307F,
  [350] = 0x3080, [351] = 0x3081, [352] = 0x3082, [353] = 0x3083,
  [354] = 0x3084, [355] = 0x3085, [356] = 0x3086, [357] = 0x3087,
  [358] = 0x3088, [359] = 0x3089, [360] = 0x308A, [361] = 0x308B,
  [362] = 0x308C, [363] = 0x308D, [364] = 0x308E, [365] = 0x308F,
  [366] = 0x3090, [367] = 0x3091, [368] = 0x3092, [369] = 0x3093,
  [384] = 0x30A1, [385] = 0x30A2, [386] = 0x30A3, [387] = 0x30A4,
  [388] = 0x30A5, [389] = 0x30A6, [390] = 0x30A7, [391] = 0x30A8,
  [392] = 0x30A9, [393] = 0x30AA, [394] = 0x30AB, [395] = 0x30AC,
  [396] = 0x30AD, [397] = 0x30AE, [398] = 0x30AF, [399] = 0x30B0,
  [400] = 0x30B1, [401] = 0x30B2, [402] = 0x30B3, [403] = 0x30B4,
  [404] = 0x30B5, [405] = 0x30B6, [406] = 0x30B7, [407] = 0x30B8,
  [408] = 0x30B9, [409] = 0x30BA, [410] = 0x30BB, [411] = 0x30BC,
  [412] = 0x30BD, [413] = 0x30BE, [414] = 0x30BF, [415] = 0x30C0,
  [416] = 0x30C1, [417] = 0x30C2, [418] = 0x30C3, [419] = 0x30C4,
  [420] = 0x30C5, [421] = 0x30C6, [422] = 0x30C7, [423] = 0x30C8,
  [424] = 0x30C9, [425] = 0x30CA, [426] = 0x30CB, [427] = 0x30CC,
  [428] = 0x30CD, [429] = 0x30CE, [430] = 0x30CF, [431] = 0x30D0,
  [432] = 0x30D1, [433] = 0x30D2, [434] = 0x30D3, [435] = 0x30D4,
  [436] = 0x30D5, [437] = 0x30D6, [438] = 0x30D7, [439] = 0x30D8,
  [440] = 0x30D9, [441] = 0x30DA, [442] = 0x30DB, [443] = 0x30DC,
  [444] = 0x30DD, [445] = 0x30DE, [446] = 0x30DF, [448] = 0x30E0,
  [449] = 0x30E1, [450] = 0x30E2, [451] = 0x30E3, [452] = 0x30E4,
  [453] = 0x30E5, [454] = 0x30E6, [455] = 0x30E7, [456] = 0x30E8,
  [457] = 0x30E9, [458] = 0x30EA, [459] = 0x30EB, [460] = 0x30EC,
  [461] = 0x30ED, [462] = 0x30EE, [463] = 0x30EF, [464] = 0x30F0,
  [465] = 0x30F1, [466] = 0x30F2, [467] = 0x30F3, [468] = 0x30F4,
  [469] = 0x30F5, [470] = 0x30F6, [479] = 0x0391, [480] = 0x0392,
  [481] = 0x0393, [482] = 0x0394, [483] = 0x0395, [484] = 0x0396,
  [485] = 0x0397, [486] = 0x0398, [487] = 0x0399, [488] = 0x039A,
  [489] = 0x039B, [490] = 0x039C, [491] = 0x039D, [492] = 0x039E,
  [493] = 0x039F, [494] = 0x03A0, [495] = 0x03A1, [496] = 0x03A3,
  [497] = 0x03A4, [498] = 0x03A5, [499] = 0x03A6, [500] = 0x03A7,
  [501] = 0x03A8, [502] = 0x03A9, [511] = 0x03B1, [512] = 0x03B2,
  [513] = 0x03B3, [514] = 0x03B4, [515] = 0x03B5, [516] = 0x03B6,
  [517] = 0x03B7, [518] = 0x03B8, [519] = 0x03B9, [520] = 0x03BA,
  [521] = 0x03BB, [522] = 0x03BC, [523] = 0x03BD, [524] = 0x03BE,
  [525] = 0x03BF, [526] = 0x03C0, [527] = 0x03C1, [528] = 0x03C3,
  [529] = 0x03C4, [530] = 0x03C5, [531] = 0x03C6, [532] = 0x03C7,
  [533] = 0x03C8, [534] = 0x03C9, [576] = 0x0410, [577] = 0x0411,
  [578] = 0x0412, [579] = 0x0413, [580] = 0x0414, [581] = 0x0415,
  [582] = 0x0401, [583] = 0x0416, [584] = 0x0417, [585] = 0x0418,
  [586] = 0x0419, [587] = 0x041A, [588] = 0x041B, [589] = 0x041C,
  [590] = 0x041D, [591] = 0x041E, [592] = 0x041F, [593] = 0x0420,
  [594] = 0x0421, [595] = 0x0422, [596] = 0x0423, [597] = 0x0424,
  [598] = 0x0425, [599] = 0x0426, [600] = 0x0427, [601] = 0x0428,
  [602] = 0x0429, [603] = 0x042A, [604] = 0x042B, [605] = 0x042C,
  [606] = 0x042D, [607] = 0x042E, [608] = 0x042F, [624] = 0x0430,
  [625] = 0x0431, [626] = 0x0432, [627] = 0x0433, [628] = 0x0434,
  [629] = 0x0435, [630] = 0x0451, [631] = 0x0436, [632] = 0x0437,
  [633] = 0x0438, [634] = 0x0439, [635] = 0x043A, [636] = 0x043B,
  [637] = 0x043C, [638] = 0x043D, [640] = 0x043E, [641] = 0x043F,
  [642] = 0x0440, [643] = 0x0441, [644] = 0x0442, [645] = 0x0443,
  [646] = 0x0444, [647] = 0x0445, [648] = 0x0446, [649] = 0x0447,
  [650] = 0x0448, [651] = 0x0449, [652] = 0x044A, [653] = 0x044B,
  [654] = 0x044C, [655] = 0x044D, [656] = 0x044E, [657] = 0x044F,
  [671] = 0x2500, [672] = 0x2502, [673] = 0x250C, [674] = 0x2510,
  [675] = 0x2518, [676] = 0x2514, [677] = 0x251C, [678] = 0x252C,
  [679] = 0x2524, [680] = 0x2534, [681] = 0x253C, [682] = 0x2501,
  [683] = 0x2503, [684] = 0x250F, [685] = 0x2513, [686] = 0x251B,
  [687] = 0x2517, [688] = 0x2523, [689] = 0x2533, [690] = 0x252B,
  [691] = 0x253B, [692] = 0x254B, [693] = 0x2520, [694] = 0x252F,
  [695] = 0x2528, [696] = 0x2537, [697] = 0x253F, [698] = 0x251D,
  [699] = 0x2530, [700] = 0x2525, [701] = 0x2538, [702] = 0x2542
};


/* The following table can be generated from the file
	unix/mappings/eastasia/jis/shiftjis.txt
   from the Unicode CD (also available on their FTP server) using
   the command

	egrep '^0x8[89][[:xdigit:]][[:xdigit:]]' \
	  /mnt/cdrom/unix/mappings/eastasia/jis/shiftjis.txt | perl ~/sjis.pl

   where sjis.pl contains:

  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  while (<>) {
    local($sjis, $ucs, %rest) = split;
    $sjis = hex($sjis) - 0x8840;
    local($sidx) = int($sjis / 256) * 192 + ($sjis % 256) - 0x5f;
    printf "\n " if (($n % 4) == 0);
    ++$n;
    printf " [%3d] = %s,", $sidx, $ucs;
  }
  print "\n";
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static const uint16_t cjk_block2[94] =
{
  [  0] = 0x4E9C, [  1] = 0x5516, [  2] = 0x5A03, [  3] = 0x963F,
  [  4] = 0x54C0, [  5] = 0x611B, [  6] = 0x6328, [  7] = 0x59F6,
  [  8] = 0x9022, [  9] = 0x8475, [ 10] = 0x831C, [ 11] = 0x7A50,
  [ 12] = 0x60AA, [ 13] = 0x63E1, [ 14] = 0x6E25, [ 15] = 0x65ED,
  [ 16] = 0x8466, [ 17] = 0x82A6, [ 18] = 0x9BF5, [ 19] = 0x6893,
  [ 20] = 0x5727, [ 21] = 0x65A1, [ 22] = 0x6271, [ 23] = 0x5B9B,
  [ 24] = 0x59D0, [ 25] = 0x867B, [ 26] = 0x98F4, [ 27] = 0x7D62,
  [ 28] = 0x7DBE, [ 29] = 0x9B8E, [ 30] = 0x6216, [ 31] = 0x7C9F,
  [ 32] = 0x88B7, [ 33] = 0x5B89, [ 34] = 0x5EB5, [ 35] = 0x6309,
  [ 36] = 0x6697, [ 37] = 0x6848, [ 38] = 0x95C7, [ 39] = 0x978D,
  [ 40] = 0x674F, [ 41] = 0x4EE5, [ 42] = 0x4F0A, [ 43] = 0x4F4D,
  [ 44] = 0x4F9D, [ 45] = 0x5049, [ 46] = 0x56F2, [ 47] = 0x5937,
  [ 48] = 0x59D4, [ 49] = 0x5A01, [ 50] = 0x5C09, [ 51] = 0x60DF,
  [ 52] = 0x610F, [ 53] = 0x6170, [ 54] = 0x6613, [ 55] = 0x6905,
  [ 56] = 0x70BA, [ 57] = 0x754F, [ 58] = 0x7570, [ 59] = 0x79FB,
  [ 60] = 0x7DAD, [ 61] = 0x7DEF, [ 62] = 0x80C3, [ 63] = 0x840E,
  [ 64] = 0x8863, [ 65] = 0x8B02, [ 66] = 0x9055, [ 67] = 0x907A,
  [ 68] = 0x533B, [ 69] = 0x4E95, [ 70] = 0x4EA5, [ 71] = 0x57DF,
  [ 72] = 0x80B2, [ 73] = 0x90C1, [ 74] = 0x78EF, [ 75] = 0x4E00,
  [ 76] = 0x58F1, [ 77] = 0x6EA2, [ 78] = 0x9038, [ 79] = 0x7A32,
  [ 80] = 0x8328, [ 81] = 0x828B, [ 82] = 0x9C2F, [ 83] = 0x5141,
  [ 84] = 0x5370, [ 85] = 0x54BD, [ 86] = 0x54E1, [ 87] = 0x56E0,
  [ 88] = 0x59FB, [ 89] = 0x5F15, [ 90] = 0x98F2, [ 91] = 0x6DEB,
  [ 92] = 0x80E4, [ 93] = 0x852D
};

/* The following table can be generated from the file
	unix/mappings/eastasia/jis/shiftjis.txt
   from the Unicode CD (also available on their FTP server) using
   the command

	egrep '^0x(8[9a-fA-F]|9[[:xdigit:]])[[:xdigit:]][[:xdigit:]]' \
	  /mnt/cdrom/unix/mappings/eastasia/jis/shiftjis.txt | perl ~/sjis.pl

   where sjis.pl contains:

  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  while (<>) {
    local($sjis, $ucs, %rest) = split;
    $sjis = hex($sjis) - 0x8940;
    local($sidx) = int($sjis / 256) * 192 + ($sjis % 256) - 0x5f;
    printf "\n " if (($n % 4) == 0);
    ++$n;
    printf " [%4d] = %s,", $sidx, $ucs;
  }
  print "\n";
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static const uint16_t cjk_block3[4413] =
{
  [   0] = 0x9662, [   1] = 0x9670, [   2] = 0x96A0, [   3] = 0x97FB,
  [   4] = 0x540B, [   5] = 0x53F3, [   6] = 0x5B87, [   7] = 0x70CF,
  [   8] = 0x7FBD, [   9] = 0x8FC2, [  10] = 0x96E8, [  11] = 0x536F,
  [  12] = 0x9D5C, [  13] = 0x7ABA, [  14] = 0x4E11, [  15] = 0x7893,
  [  16] = 0x81FC, [  17] = 0x6E26, [  18] = 0x5618, [  19] = 0x5504,
  [  20] = 0x6B1D, [  21] = 0x851A, [  22] = 0x9C3B, [  23] = 0x59E5,
  [  24] = 0x53A9, [  25] = 0x6D66, [  26] = 0x74DC, [  27] = 0x958F,
  [  28] = 0x5642, [  29] = 0x4E91, [  30] = 0x904B, [  31] = 0x96F2,
  [  32] = 0x834F, [  33] = 0x990C, [  34] = 0x53E1, [  35] = 0x55B6,
  [  36] = 0x5B30, [  37] = 0x5F71, [  38] = 0x6620, [  39] = 0x66F3,
  [  40] = 0x6804, [  41] = 0x6C38, [  42] = 0x6CF3, [  43] = 0x6D29,
  [  44] = 0x745B, [  45] = 0x76C8, [  46] = 0x7A4E, [  47] = 0x9834,
  [  48] = 0x82F1, [  49] = 0x885B, [  50] = 0x8A60, [  51] = 0x92ED,
  [  52] = 0x6DB2, [  53] = 0x75AB, [  54] = 0x76CA, [  55] = 0x99C5,
  [  56] = 0x60A6, [  57] = 0x8B01, [  58] = 0x8D8A, [  59] = 0x95B2,
  [  60] = 0x698E, [  61] = 0x53AD, [  62] = 0x5186, [  64] = 0x5712,
  [  65] = 0x5830, [  66] = 0x5944, [  67] = 0x5BB4, [  68] = 0x5EF6,
  [  69] = 0x6028, [  70] = 0x63A9, [  71] = 0x63F4, [  72] = 0x6CBF,
  [  73] = 0x6F14, [  74] = 0x708E, [  75] = 0x7114, [  76] = 0x7159,
  [  77] = 0x71D5, [  78] = 0x733F, [  79] = 0x7E01, [  80] = 0x8276,
  [  81] = 0x82D1, [  82] = 0x8597, [  83] = 0x9060, [  84] = 0x925B,
  [  85] = 0x9D1B, [  86] = 0x5869, [  87] = 0x65BC, [  88] = 0x6C5A,
  [  89] = 0x7525, [  90] = 0x51F9, [  91] = 0x592E, [  92] = 0x5965,
  [  93] = 0x5F80, [  94] = 0x5FDC, [  95] = 0x62BC, [  96] = 0x65FA,
  [  97] = 0x6A2A, [  98] = 0x6B27, [  99] = 0x6BB4, [ 100] = 0x738B,
  [ 101] = 0x7FC1, [ 102] = 0x8956, [ 103] = 0x9D2C, [ 104] = 0x9D0E,
  [ 105] = 0x9EC4, [ 106] = 0x5CA1, [ 107] = 0x6C96, [ 108] = 0x837B,
  [ 109] = 0x5104, [ 110] = 0x5C4B, [ 111] = 0x61B6, [ 112] = 0x81C6,
  [ 113] = 0x6876, [ 114] = 0x7261, [ 115] = 0x4E59, [ 116] = 0x4FFA,
  [ 117] = 0x5378, [ 118] = 0x6069, [ 119] = 0x6E29, [ 120] = 0x7A4F,
  [ 121] = 0x97F3, [ 122] = 0x4E0B, [ 123] = 0x5316, [ 124] = 0x4EEE,
  [ 125] = 0x4F55, [ 126] = 0x4F3D, [ 127] = 0x4FA1, [ 128] = 0x4F73,
  [ 129] = 0x52A0, [ 130] = 0x53EF, [ 131] = 0x5609, [ 132] = 0x590F,
  [ 133] = 0x5AC1, [ 134] = 0x5BB6, [ 135] = 0x5BE1, [ 136] = 0x79D1,
  [ 137] = 0x6687, [ 138] = 0x679C, [ 139] = 0x67B6, [ 140] = 0x6B4C,
  [ 141] = 0x6CB3, [ 142] = 0x706B, [ 143] = 0x73C2, [ 144] = 0x798D,
  [ 145] = 0x79BE, [ 146] = 0x7A3C, [ 147] = 0x7B87, [ 148] = 0x82B1,
  [ 149] = 0x82DB, [ 150] = 0x8304, [ 151] = 0x8377, [ 152] = 0x83EF,
  [ 153] = 0x83D3, [ 154] = 0x8766, [ 155] = 0x8AB2, [ 156] = 0x5629,
  [ 157] = 0x8CA8, [ 158] = 0x8FE6, [ 159] = 0x904E, [ 160] = 0x971E,
  [ 161] = 0x868A, [ 162] = 0x4FC4, [ 163] = 0x5CE8, [ 164] = 0x6211,
  [ 165] = 0x7259, [ 166] = 0x753B, [ 167] = 0x81E5, [ 168] = 0x82BD,
  [ 169] = 0x86FE, [ 170] = 0x8CC0, [ 171] = 0x96C5, [ 172] = 0x9913,
  [ 173] = 0x99D5, [ 174] = 0x4ECB, [ 175] = 0x4F1A, [ 176] = 0x89E3,
  [ 177] = 0x56DE, [ 178] = 0x584A, [ 179] = 0x58CA, [ 180] = 0x5EFB,
  [ 181] = 0x5FEB, [ 182] = 0x602A, [ 183] = 0x6094, [ 184] = 0x6062,
  [ 185] = 0x61D0, [ 186] = 0x6212, [ 187] = 0x62D0, [ 188] = 0x6539,
  [ 192] = 0x9B41, [ 193] = 0x6666, [ 194] = 0x68B0, [ 195] = 0x6D77,
  [ 196] = 0x7070, [ 197] = 0x754C, [ 198] = 0x7686, [ 199] = 0x7D75,
  [ 200] = 0x82A5, [ 201] = 0x87F9, [ 202] = 0x958B, [ 203] = 0x968E,
  [ 204] = 0x8C9D, [ 205] = 0x51F1, [ 206] = 0x52BE, [ 207] = 0x5916,
  [ 208] = 0x54B3, [ 209] = 0x5BB3, [ 210] = 0x5D16, [ 211] = 0x6168,
  [ 212] = 0x6982, [ 213] = 0x6DAF, [ 214] = 0x788D, [ 215] = 0x84CB,
  [ 216] = 0x8857, [ 217] = 0x8A72, [ 218] = 0x93A7, [ 219] = 0x9AB8,
  [ 220] = 0x6D6C, [ 221] = 0x99A8, [ 222] = 0x86D9, [ 223] = 0x57A3,
  [ 224] = 0x67FF, [ 225] = 0x86CE, [ 226] = 0x920E, [ 227] = 0x5283,
  [ 228] = 0x5687, [ 229] = 0x5404, [ 230] = 0x5ED3, [ 231] = 0x62E1,
  [ 232] = 0x64B9, [ 233] = 0x683C, [ 234] = 0x6838, [ 235] = 0x6BBB,
  [ 236] = 0x7372, [ 237] = 0x78BA, [ 238] = 0x7A6B, [ 239] = 0x899A,
  [ 240] = 0x89D2, [ 241] = 0x8D6B, [ 242] = 0x8F03, [ 243] = 0x90ED,
  [ 244] = 0x95A3, [ 245] = 0x9694, [ 246] = 0x9769, [ 247] = 0x5B66,
  [ 248] = 0x5CB3, [ 249] = 0x697D, [ 250] = 0x984D, [ 251] = 0x984E,
  [ 252] = 0x639B, [ 253] = 0x7B20, [ 254] = 0x6A2B, [ 256] = 0x6A7F,
  [ 257] = 0x68B6, [ 258] = 0x9C0D, [ 259] = 0x6F5F, [ 260] = 0x5272,
  [ 261] = 0x559D, [ 262] = 0x6070, [ 263] = 0x62EC, [ 264] = 0x6D3B,
  [ 265] = 0x6E07, [ 266] = 0x6ED1, [ 267] = 0x845B, [ 268] = 0x8910,
  [ 269] = 0x8F44, [ 270] = 0x4E14, [ 271] = 0x9C39, [ 272] = 0x53F6,
  [ 273] = 0x691B, [ 274] = 0x6A3A, [ 275] = 0x9784, [ 276] = 0x682A,
  [ 277] = 0x515C, [ 278] = 0x7AC3, [ 279] = 0x84B2, [ 280] = 0x91DC,
  [ 281] = 0x938C, [ 282] = 0x565B, [ 283] = 0x9D28, [ 284] = 0x6822,
  [ 285] = 0x8305, [ 286] = 0x8431, [ 287] = 0x7CA5, [ 288] = 0x5208,
  [ 289] = 0x82C5, [ 290] = 0x74E6, [ 291] = 0x4E7E, [ 292] = 0x4F83,
  [ 293] = 0x51A0, [ 294] = 0x5BD2, [ 295] = 0x520A, [ 296] = 0x52D8,
  [ 297] = 0x52E7, [ 298] = 0x5DFB, [ 299] = 0x559A, [ 300] = 0x582A,
  [ 301] = 0x59E6, [ 302] = 0x5B8C, [ 303] = 0x5B98, [ 304] = 0x5BDB,
  [ 305] = 0x5E72, [ 306] = 0x5E79, [ 307] = 0x60A3, [ 308] = 0x611F,
  [ 309] = 0x6163, [ 310] = 0x61BE, [ 311] = 0x63DB, [ 312] = 0x6562,
  [ 313] = 0x67D1, [ 314] = 0x6853, [ 315] = 0x68FA, [ 316] = 0x6B3E,
  [ 317] = 0x6B53, [ 318] = 0x6C57, [ 319] = 0x6F22, [ 320] = 0x6F97,
  [ 321] = 0x6F45, [ 322] = 0x74B0, [ 323] = 0x7518, [ 324] = 0x76E3,
  [ 325] = 0x770B, [ 326] = 0x7AFF, [ 327] = 0x7BA1, [ 328] = 0x7C21,
  [ 329] = 0x7DE9, [ 330] = 0x7F36, [ 331] = 0x7FF0, [ 332] = 0x809D,
  [ 333] = 0x8266, [ 334] = 0x839E, [ 335] = 0x89B3, [ 336] = 0x8ACC,
  [ 337] = 0x8CAB, [ 338] = 0x9084, [ 339] = 0x9451, [ 340] = 0x9593,
  [ 341] = 0x9591, [ 342] = 0x95A2, [ 343] = 0x9665, [ 344] = 0x97D3,
  [ 345] = 0x9928, [ 346] = 0x8218, [ 347] = 0x4E38, [ 348] = 0x542B,
  [ 349] = 0x5CB8, [ 350] = 0x5DCC, [ 351] = 0x73A9, [ 352] = 0x764C,
  [ 353] = 0x773C, [ 354] = 0x5CA9, [ 355] = 0x7FEB, [ 356] = 0x8D0B,
  [ 357] = 0x96C1, [ 358] = 0x9811, [ 359] = 0x9854, [ 360] = 0x9858,
  [ 361] = 0x4F01, [ 362] = 0x4F0E, [ 363] = 0x5371, [ 364] = 0x559C,
  [ 365] = 0x5668, [ 366] = 0x57FA, [ 367] = 0x5947, [ 368] = 0x5B09,
  [ 369] = 0x5BC4, [ 370] = 0x5C90, [ 371] = 0x5E0C, [ 372] = 0x5E7E,
  [ 373] = 0x5FCC, [ 374] = 0x63EE, [ 375] = 0x673A, [ 376] = 0x65D7,
  [ 377] = 0x65E2, [ 378] = 0x671F, [ 379] = 0x68CB, [ 380] = 0x68C4,
  [ 384] = 0x6A5F, [ 385] = 0x5E30, [ 386] = 0x6BC5, [ 387] = 0x6C17,
  [ 388] = 0x6C7D, [ 389] = 0x757F, [ 390] = 0x7948, [ 391] = 0x5B63,
  [ 392] = 0x7A00, [ 393] = 0x7D00, [ 394] = 0x5FBD, [ 395] = 0x898F,
  [ 396] = 0x8A18, [ 397] = 0x8CB4, [ 398] = 0x8D77, [ 399] = 0x8ECC,
  [ 400] = 0x8F1D, [ 401] = 0x98E2, [ 402] = 0x9A0E, [ 403] = 0x9B3C,
  [ 404] = 0x4E80, [ 405] = 0x507D, [ 406] = 0x5100, [ 407] = 0x5993,
  [ 408] = 0x5B9C, [ 409] = 0x622F, [ 410] = 0x6280, [ 411] = 0x64EC,
  [ 412] = 0x6B3A, [ 413] = 0x72A0, [ 414] = 0x7591, [ 415] = 0x7947,
  [ 416] = 0x7FA9, [ 417] = 0x87FB, [ 418] = 0x8ABC, [ 419] = 0x8B70,
  [ 420] = 0x63AC, [ 421] = 0x83CA, [ 422] = 0x97A0, [ 423] = 0x5409,
  [ 424] = 0x5403, [ 425] = 0x55AB, [ 426] = 0x6854, [ 427] = 0x6A58,
  [ 428] = 0x8A70, [ 429] = 0x7827, [ 430] = 0x6775, [ 431] = 0x9ECD,
  [ 432] = 0x5374, [ 433] = 0x5BA2, [ 434] = 0x811A, [ 435] = 0x8650,
  [ 436] = 0x9006, [ 437] = 0x4E18, [ 438] = 0x4E45, [ 439] = 0x4EC7,
  [ 440] = 0x4F11, [ 441] = 0x53CA, [ 442] = 0x5438, [ 443] = 0x5BAE,
  [ 444] = 0x5F13, [ 445] = 0x6025, [ 446] = 0x6551, [ 448] = 0x673D,
  [ 449] = 0x6C42, [ 450] = 0x6C72, [ 451] = 0x6CE3, [ 452] = 0x7078,
  [ 453] = 0x7403, [ 454] = 0x7A76, [ 455] = 0x7AAE, [ 456] = 0x7B08,
  [ 457] = 0x7D1A, [ 458] = 0x7CFE, [ 459] = 0x7D66, [ 460] = 0x65E7,
  [ 461] = 0x725B, [ 462] = 0x53BB, [ 463] = 0x5C45, [ 464] = 0x5DE8,
  [ 465] = 0x62D2, [ 466] = 0x62E0, [ 467] = 0x6319, [ 468] = 0x6E20,
  [ 469] = 0x865A, [ 470] = 0x8A31, [ 471] = 0x8DDD, [ 472] = 0x92F8,
  [ 473] = 0x6F01, [ 474] = 0x79A6, [ 475] = 0x9B5A, [ 476] = 0x4EA8,
  [ 477] = 0x4EAB, [ 478] = 0x4EAC, [ 479] = 0x4F9B, [ 480] = 0x4FA0,
  [ 481] = 0x50D1, [ 482] = 0x5147, [ 483] = 0x7AF6, [ 484] = 0x5171,
  [ 485] = 0x51F6, [ 486] = 0x5354, [ 487] = 0x5321, [ 488] = 0x537F,
  [ 489] = 0x53EB, [ 490] = 0x55AC, [ 491] = 0x5883, [ 492] = 0x5CE1,
  [ 493] = 0x5F37, [ 494] = 0x5F4A, [ 495] = 0x602F, [ 496] = 0x6050,
  [ 497] = 0x606D, [ 498] = 0x631F, [ 499] = 0x6559, [ 500] = 0x6A4B,
  [ 501] = 0x6CC1, [ 502] = 0x72C2, [ 503] = 0x72ED, [ 504] = 0x77EF,
  [ 505] = 0x80F8, [ 506] = 0x8105, [ 507] = 0x8208, [ 508] = 0x854E,
  [ 509] = 0x90F7, [ 510] = 0x93E1, [ 511] = 0x97FF, [ 512] = 0x9957,
  [ 513] = 0x9A5A, [ 514] = 0x4EF0, [ 515] = 0x51DD, [ 516] = 0x5C2D,
  [ 517] = 0x6681, [ 518] = 0x696D, [ 519] = 0x5C40, [ 520] = 0x66F2,
  [ 521] = 0x6975, [ 522] = 0x7389, [ 523] = 0x6850, [ 524] = 0x7C81,
  [ 525] = 0x50C5, [ 526] = 0x52E4, [ 527] = 0x5747, [ 528] = 0x5DFE,
  [ 529] = 0x9326, [ 530] = 0x65A4, [ 531] = 0x6B23, [ 532] = 0x6B3D,
  [ 533] = 0x7434, [ 534] = 0x7981, [ 535] = 0x79BD, [ 536] = 0x7B4B,
  [ 537] = 0x7DCA, [ 538] = 0x82B9, [ 539] = 0x83CC, [ 540] = 0x887F,
  [ 541] = 0x895F, [ 542] = 0x8B39, [ 543] = 0x8FD1, [ 544] = 0x91D1,
  [ 545] = 0x541F, [ 546] = 0x9280, [ 547] = 0x4E5D, [ 548] = 0x5036,
  [ 549] = 0x53E5, [ 550] = 0x533A, [ 551] = 0x72D7, [ 552] = 0x7396,
  [ 553] = 0x77E9, [ 554] = 0x82E6, [ 555] = 0x8EAF, [ 556] = 0x99C6,
  [ 557] = 0x99C8, [ 558] = 0x99D2, [ 559] = 0x5177, [ 560] = 0x611A,
  [ 561] = 0x865E, [ 562] = 0x55B0, [ 563] = 0x7A7A, [ 564] = 0x5076,
  [ 565] = 0x5BD3, [ 566] = 0x9047, [ 567] = 0x9685, [ 568] = 0x4E32,
  [ 569] = 0x6ADB, [ 570] = 0x91E7, [ 571] = 0x5C51, [ 572] = 0x5C48,
  [ 576] = 0x6398, [ 577] = 0x7A9F, [ 578] = 0x6C93, [ 579] = 0x9774,
  [ 580] = 0x8F61, [ 581] = 0x7AAA, [ 582] = 0x718A, [ 583] = 0x9688,
  [ 584] = 0x7C82, [ 585] = 0x6817, [ 586] = 0x7E70, [ 587] = 0x6851,
  [ 588] = 0x936C, [ 589] = 0x52F2, [ 590] = 0x541B, [ 591] = 0x85AB,
  [ 592] = 0x8A13, [ 593] = 0x7FA4, [ 594] = 0x8ECD, [ 595] = 0x90E1,
  [ 596] = 0x5366, [ 597] = 0x8888, [ 598] = 0x7941, [ 599] = 0x4FC2,
  [ 600] = 0x50BE, [ 601] = 0x5211, [ 602] = 0x5144, [ 603] = 0x5553,
  [ 604] = 0x572D, [ 605] = 0x73EA, [ 606] = 0x578B, [ 607] = 0x5951,
  [ 608] = 0x5F62, [ 609] = 0x5F84, [ 610] = 0x6075, [ 611] = 0x6176,
  [ 612] = 0x6167, [ 613] = 0x61A9, [ 614] = 0x63B2, [ 615] = 0x643A,
  [ 616] = 0x656C, [ 617] = 0x666F, [ 618] = 0x6842, [ 619] = 0x6E13,
  [ 620] = 0x7566, [ 621] = 0x7A3D, [ 622] = 0x7CFB, [ 623] = 0x7D4C,
  [ 624] = 0x7D99, [ 625] = 0x7E4B, [ 626] = 0x7F6B, [ 627] = 0x830E,
  [ 628] = 0x834A, [ 629] = 0x86CD, [ 630] = 0x8A08, [ 631] = 0x8A63,
  [ 632] = 0x8B66, [ 633] = 0x8EFD, [ 634] = 0x981A, [ 635] = 0x9D8F,
  [ 636] = 0x82B8, [ 637] = 0x8FCE, [ 638] = 0x9BE8, [ 640] = 0x5287,
  [ 641] = 0x621F, [ 642] = 0x6483, [ 643] = 0x6FC0, [ 644] = 0x9699,
  [ 645] = 0x6841, [ 646] = 0x5091, [ 647] = 0x6B20, [ 648] = 0x6C7A,
  [ 649] = 0x6F54, [ 650] = 0x7A74, [ 651] = 0x7D50, [ 652] = 0x8840,
  [ 653] = 0x8A23, [ 654] = 0x6708, [ 655] = 0x4EF6, [ 656] = 0x5039,
  [ 657] = 0x5026, [ 658] = 0x5065, [ 659] = 0x517C, [ 660] = 0x5238,
  [ 661] = 0x5263, [ 662] = 0x55A7, [ 663] = 0x570F, [ 664] = 0x5805,
  [ 665] = 0x5ACC, [ 666] = 0x5EFA, [ 667] = 0x61B2, [ 668] = 0x61F8,
  [ 669] = 0x62F3, [ 670] = 0x6372, [ 671] = 0x691C, [ 672] = 0x6A29,
  [ 673] = 0x727D, [ 674] = 0x72AC, [ 675] = 0x732E, [ 676] = 0x7814,
  [ 677] = 0x786F, [ 678] = 0x7D79, [ 679] = 0x770C, [ 680] = 0x80A9,
  [ 681] = 0x898B, [ 682] = 0x8B19, [ 683] = 0x8CE2, [ 684] = 0x8ED2,
  [ 685] = 0x9063, [ 686] = 0x9375, [ 687] = 0x967A, [ 688] = 0x9855,
  [ 689] = 0x9A13, [ 690] = 0x9E78, [ 691] = 0x5143, [ 692] = 0x539F,
  [ 693] = 0x53B3, [ 694] = 0x5E7B, [ 695] = 0x5F26, [ 696] = 0x6E1B,
  [ 697] = 0x6E90, [ 698] = 0x7384, [ 699] = 0x73FE, [ 700] = 0x7D43,
  [ 701] = 0x8237, [ 702] = 0x8A00, [ 703] = 0x8AFA, [ 704] = 0x9650,
  [ 705] = 0x4E4E, [ 706] = 0x500B, [ 707] = 0x53E4, [ 708] = 0x547C,
  [ 709] = 0x56FA, [ 710] = 0x59D1, [ 711] = 0x5B64, [ 712] = 0x5DF1,
  [ 713] = 0x5EAB, [ 714] = 0x5F27, [ 715] = 0x6238, [ 716] = 0x6545,
  [ 717] = 0x67AF, [ 718] = 0x6E56, [ 719] = 0x72D0, [ 720] = 0x7CCA,
  [ 721] = 0x88B4, [ 722] = 0x80A1, [ 723] = 0x80E1, [ 724] = 0x83F0,
  [ 725] = 0x864E, [ 726] = 0x8A87, [ 727] = 0x8DE8, [ 728] = 0x9237,
  [ 729] = 0x96C7, [ 730] = 0x9867, [ 731] = 0x9F13, [ 732] = 0x4E94,
  [ 733] = 0x4E92, [ 734] = 0x4F0D, [ 735] = 0x5348, [ 736] = 0x5449,
  [ 737] = 0x543E, [ 738] = 0x5A2F, [ 739] = 0x5F8C, [ 740] = 0x5FA1,
  [ 741] = 0x609F, [ 742] = 0x68A7, [ 743] = 0x6A8E, [ 744] = 0x745A,
  [ 745] = 0x7881, [ 746] = 0x8A9E, [ 747] = 0x8AA4, [ 748] = 0x8B77,
  [ 749] = 0x9190, [ 750] = 0x4E5E, [ 751] = 0x9BC9, [ 752] = 0x4EA4,
  [ 753] = 0x4F7C, [ 754] = 0x4FAF, [ 755] = 0x5019, [ 756] = 0x5016,
  [ 757] = 0x5149, [ 758] = 0x516C, [ 759] = 0x529F, [ 760] = 0x52B9,
  [ 761] = 0x52FE, [ 762] = 0x539A, [ 763] = 0x53E3, [ 764] = 0x5411,
  [ 768] = 0x540E, [ 769] = 0x5589, [ 770] = 0x5751, [ 771] = 0x57A2,
  [ 772] = 0x597D, [ 773] = 0x5B54, [ 774] = 0x5B5D, [ 775] = 0x5B8F,
  [ 776] = 0x5DE5, [ 777] = 0x5DE7, [ 778] = 0x5DF7, [ 779] = 0x5E78,
  [ 780] = 0x5E83, [ 781] = 0x5E9A, [ 782] = 0x5EB7, [ 783] = 0x5F18,
  [ 784] = 0x6052, [ 785] = 0x614C, [ 786] = 0x6297, [ 787] = 0x62D8,
  [ 788] = 0x63A7, [ 789] = 0x653B, [ 790] = 0x6602, [ 791] = 0x6643,
  [ 792] = 0x66F4, [ 793] = 0x676D, [ 794] = 0x6821, [ 795] = 0x6897,
  [ 796] = 0x69CB, [ 797] = 0x6C5F, [ 798] = 0x6D2A, [ 799] = 0x6D69,
  [ 800] = 0x6E2F, [ 801] = 0x6E9D, [ 802] = 0x7532, [ 803] = 0x7687,
  [ 804] = 0x786C, [ 805] = 0x7A3F, [ 806] = 0x7CE0, [ 807] = 0x7D05,
  [ 808] = 0x7D18, [ 809] = 0x7D5E, [ 810] = 0x7DB1, [ 811] = 0x8015,
  [ 812] = 0x8003, [ 813] = 0x80AF, [ 814] = 0x80B1, [ 815] = 0x8154,
  [ 816] = 0x818F, [ 817] = 0x822A, [ 818] = 0x8352, [ 819] = 0x884C,
  [ 820] = 0x8861, [ 821] = 0x8B1B, [ 822] = 0x8CA2, [ 823] = 0x8CFC,
  [ 824] = 0x90CA, [ 825] = 0x9175, [ 826] = 0x9271, [ 827] = 0x783F,
  [ 828] = 0x92FC, [ 829] = 0x95A4, [ 830] = 0x964D, [ 832] = 0x9805,
  [ 833] = 0x9999, [ 834] = 0x9AD8, [ 835] = 0x9D3B, [ 836] = 0x525B,
  [ 837] = 0x52AB, [ 838] = 0x53F7, [ 839] = 0x5408, [ 840] = 0x58D5,
  [ 841] = 0x62F7, [ 842] = 0x6FE0, [ 843] = 0x8C6A, [ 844] = 0x8F5F,
  [ 845] = 0x9EB9, [ 846] = 0x514B, [ 847] = 0x523B, [ 848] = 0x544A,
  [ 849] = 0x56FD, [ 850] = 0x7A40, [ 851] = 0x9177, [ 852] = 0x9D60,
  [ 853] = 0x9ED2, [ 854] = 0x7344, [ 855] = 0x6F09, [ 856] = 0x8170,
  [ 857] = 0x7511, [ 858] = 0x5FFD, [ 859] = 0x60DA, [ 860] = 0x9AA8,
  [ 861] = 0x72DB, [ 862] = 0x8FBC, [ 863] = 0x6B64, [ 864] = 0x9803,
  [ 865] = 0x4ECA, [ 866] = 0x56F0, [ 867] = 0x5764, [ 868] = 0x58BE,
  [ 869] = 0x5A5A, [ 870] = 0x6068, [ 871] = 0x61C7, [ 872] = 0x660F,
  [ 873] = 0x6606, [ 874] = 0x6839, [ 875] = 0x68B1, [ 876] = 0x6DF7,
  [ 877] = 0x75D5, [ 878] = 0x7D3A, [ 879] = 0x826E, [ 880] = 0x9B42,
  [ 881] = 0x4E9B, [ 882] = 0x4F50, [ 883] = 0x53C9, [ 884] = 0x5506,
  [ 885] = 0x5D6F, [ 886] = 0x5DE6, [ 887] = 0x5DEE, [ 888] = 0x67FB,
  [ 889] = 0x6C99, [ 890] = 0x7473, [ 891] = 0x7802, [ 892] = 0x8A50,
  [ 893] = 0x9396, [ 894] = 0x88DF, [ 895] = 0x5750, [ 896] = 0x5EA7,
  [ 897] = 0x632B, [ 898] = 0x50B5, [ 899] = 0x50AC, [ 900] = 0x518D,
  [ 901] = 0x6700, [ 902] = 0x54C9, [ 903] = 0x585E, [ 904] = 0x59BB,
  [ 905] = 0x5BB0, [ 906] = 0x5F69, [ 907] = 0x624D, [ 908] = 0x63A1,
  [ 909] = 0x683D, [ 910] = 0x6B73, [ 911] = 0x6E08, [ 912] = 0x707D,
  [ 913] = 0x91C7, [ 914] = 0x7280, [ 915] = 0x7815, [ 916] = 0x7826,
  [ 917] = 0x796D, [ 918] = 0x658E, [ 919] = 0x7D30, [ 920] = 0x83DC,
  [ 921] = 0x88C1, [ 922] = 0x8F09, [ 923] = 0x969B, [ 924] = 0x5264,
  [ 925] = 0x5728, [ 926] = 0x6750, [ 927] = 0x7F6A, [ 928] = 0x8CA1,
  [ 929] = 0x51B4, [ 930] = 0x5742, [ 931] = 0x962A, [ 932] = 0x583A,
  [ 933] = 0x698A, [ 934] = 0x80B4, [ 935] = 0x54B2, [ 936] = 0x5D0E,
  [ 937] = 0x57FC, [ 938] = 0x7895, [ 939] = 0x9DFA, [ 940] = 0x4F5C,
  [ 941] = 0x524A, [ 942] = 0x548B, [ 943] = 0x643E, [ 944] = 0x6628,
  [ 945] = 0x6714, [ 946] = 0x67F5, [ 947] = 0x7A84, [ 948] = 0x7B56,
  [ 949] = 0x7D22, [ 950] = 0x932F, [ 951] = 0x685C, [ 952] = 0x9BAD,
  [ 953] = 0x7B39, [ 954] = 0x5319, [ 955] = 0x518A, [ 956] = 0x5237,
  [ 960] = 0x5BDF, [ 961] = 0x62F6, [ 962] = 0x64AE, [ 963] = 0x64E6,
  [ 964] = 0x672D, [ 965] = 0x6BBA, [ 966] = 0x85A9, [ 967] = 0x96D1,
  [ 968] = 0x7690, [ 969] = 0x9BD6, [ 970] = 0x634C, [ 971] = 0x9306,
  [ 972] = 0x9BAB, [ 973] = 0x76BF, [ 974] = 0x6652, [ 975] = 0x4E09,
  [ 976] = 0x5098, [ 977] = 0x53C2, [ 978] = 0x5C71, [ 979] = 0x60E8,
  [ 980] = 0x6492, [ 981] = 0x6563, [ 982] = 0x685F, [ 983] = 0x71E6,
  [ 984] = 0x73CA, [ 985] = 0x7523, [ 986] = 0x7B97, [ 987] = 0x7E82,
  [ 988] = 0x8695, [ 989] = 0x8B83, [ 990] = 0x8CDB, [ 991] = 0x9178,
  [ 992] = 0x9910, [ 993] = 0x65AC, [ 994] = 0x66AB, [ 995] = 0x6B8B,
  [ 996] = 0x4ED5, [ 997] = 0x4ED4, [ 998] = 0x4F3A, [ 999] = 0x4F7F,
  [1000] = 0x523A, [1001] = 0x53F8, [1002] = 0x53F2, [1003] = 0x55E3,
  [1004] = 0x56DB, [1005] = 0x58EB, [1006] = 0x59CB, [1007] = 0x59C9,
  [1008] = 0x59FF, [1009] = 0x5B50, [1010] = 0x5C4D, [1011] = 0x5E02,
  [1012] = 0x5E2B, [1013] = 0x5FD7, [1014] = 0x601D, [1015] = 0x6307,
  [1016] = 0x652F, [1017] = 0x5B5C, [1018] = 0x65AF, [1019] = 0x65BD,
  [1020] = 0x65E8, [1021] = 0x679D, [1022] = 0x6B62, [1024] = 0x6B7B,
  [1025] = 0x6C0F, [1026] = 0x7345, [1027] = 0x7949, [1028] = 0x79C1,
  [1029] = 0x7CF8, [1030] = 0x7D19, [1031] = 0x7D2B, [1032] = 0x80A2,
  [1033] = 0x8102, [1034] = 0x81F3, [1035] = 0x8996, [1036] = 0x8A5E,
  [1037] = 0x8A69, [1038] = 0x8A66, [1039] = 0x8A8C, [1040] = 0x8AEE,
  [1041] = 0x8CC7, [1042] = 0x8CDC, [1043] = 0x96CC, [1044] = 0x98FC,
  [1045] = 0x6B6F, [1046] = 0x4E8B, [1047] = 0x4F3C, [1048] = 0x4F8D,
  [1049] = 0x5150, [1050] = 0x5B57, [1051] = 0x5BFA, [1052] = 0x6148,
  [1053] = 0x6301, [1054] = 0x6642, [1055] = 0x6B21, [1056] = 0x6ECB,
  [1057] = 0x6CBB, [1058] = 0x723E, [1059] = 0x74BD, [1060] = 0x75D4,
  [1061] = 0x78C1, [1062] = 0x793A, [1063] = 0x800C, [1064] = 0x8033,
  [1065] = 0x81EA, [1066] = 0x8494, [1067] = 0x8F9E, [1068] = 0x6C50,
  [1069] = 0x9E7F, [1070] = 0x5F0F, [1071] = 0x8B58, [1072] = 0x9D2B,
  [1073] = 0x7AFA, [1074] = 0x8EF8, [1075] = 0x5B8D, [1076] = 0x96EB,
  [1077] = 0x4E03, [1078] = 0x53F1, [1079] = 0x57F7, [1080] = 0x5931,
  [1081] = 0x5AC9, [1082] = 0x5BA4, [1083] = 0x6089, [1084] = 0x6E7F,
  [1085] = 0x6F06, [1086] = 0x75BE, [1087] = 0x8CEA, [1088] = 0x5B9F,
  [1089] = 0x8500, [1090] = 0x7BE0, [1091] = 0x5072, [1092] = 0x67F4,
  [1093] = 0x829D, [1094] = 0x5C61, [1095] = 0x854A, [1096] = 0x7E1E,
  [1097] = 0x820E, [1098] = 0x5199, [1099] = 0x5C04, [1100] = 0x6368,
  [1101] = 0x8D66, [1102] = 0x659C, [1103] = 0x716E, [1104] = 0x793E,
  [1105] = 0x7D17, [1106] = 0x8005, [1107] = 0x8B1D, [1108] = 0x8ECA,
  [1109] = 0x906E, [1110] = 0x86C7, [1111] = 0x90AA, [1112] = 0x501F,
  [1113] = 0x52FA, [1114] = 0x5C3A, [1115] = 0x6753, [1116] = 0x707C,
  [1117] = 0x7235, [1118] = 0x914C, [1119] = 0x91C8, [1120] = 0x932B,
  [1121] = 0x82E5, [1122] = 0x5BC2, [1123] = 0x5F31, [1124] = 0x60F9,
  [1125] = 0x4E3B, [1126] = 0x53D6, [1127] = 0x5B88, [1128] = 0x624B,
  [1129] = 0x6731, [1130] = 0x6B8A, [1131] = 0x72E9, [1132] = 0x73E0,
  [1133] = 0x7A2E, [1134] = 0x816B, [1135] = 0x8DA3, [1136] = 0x9152,
  [1137] = 0x9996, [1138] = 0x5112, [1139] = 0x53D7, [1140] = 0x546A,
  [1141] = 0x5BFF, [1142] = 0x6388, [1143] = 0x6A39, [1144] = 0x7DAC,
  [1145] = 0x9700, [1146] = 0x56DA, [1147] = 0x53CE, [1148] = 0x5468,
  [1152] = 0x5B97, [1153] = 0x5C31, [1154] = 0x5DDE, [1155] = 0x4FEE,
  [1156] = 0x6101, [1157] = 0x62FE, [1158] = 0x6D32, [1159] = 0x79C0,
  [1160] = 0x79CB, [1161] = 0x7D42, [1162] = 0x7E4D, [1163] = 0x7FD2,
  [1164] = 0x81ED, [1165] = 0x821F, [1166] = 0x8490, [1167] = 0x8846,
  [1168] = 0x8972, [1169] = 0x8B90, [1170] = 0x8E74, [1171] = 0x8F2F,
  [1172] = 0x9031, [1173] = 0x914B, [1174] = 0x916C, [1175] = 0x96C6,
  [1176] = 0x919C, [1177] = 0x4EC0, [1178] = 0x4F4F, [1179] = 0x5145,
  [1180] = 0x5341, [1181] = 0x5F93, [1182] = 0x620E, [1183] = 0x67D4,
  [1184] = 0x6C41, [1185] = 0x6E0B, [1186] = 0x7363, [1187] = 0x7E26,
  [1188] = 0x91CD, [1189] = 0x9283, [1190] = 0x53D4, [1191] = 0x5919,
  [1192] = 0x5BBF, [1193] = 0x6DD1, [1194] = 0x795D, [1195] = 0x7E2E,
  [1196] = 0x7C9B, [1197] = 0x587E, [1198] = 0x719F, [1199] = 0x51FA,
  [1200] = 0x8853, [1201] = 0x8FF0, [1202] = 0x4FCA, [1203] = 0x5CFB,
  [1204] = 0x6625, [1205] = 0x77AC, [1206] = 0x7AE3, [1207] = 0x821C,
  [1208] = 0x99FF, [1209] = 0x51C6, [1210] = 0x5FAA, [1211] = 0x65EC,
  [1212] = 0x696F, [1213] = 0x6B89, [1214] = 0x6DF3, [1216] = 0x6E96,
  [1217] = 0x6F64, [1218] = 0x76FE, [1219] = 0x7D14, [1220] = 0x5DE1,
  [1221] = 0x9075, [1222] = 0x9187, [1223] = 0x9806, [1224] = 0x51E6,
  [1225] = 0x521D, [1226] = 0x6240, [1227] = 0x6691, [1228] = 0x66D9,
  [1229] = 0x6E1A, [1230] = 0x5EB6, [1231] = 0x7DD2, [1232] = 0x7F72,
  [1233] = 0x66F8, [1234] = 0x85AF, [1235] = 0x85F7, [1236] = 0x8AF8,
  [1237] = 0x52A9, [1238] = 0x53D9, [1239] = 0x5973, [1240] = 0x5E8F,
  [1241] = 0x5F90, [1242] = 0x6055, [1243] = 0x92E4, [1244] = 0x9664,
  [1245] = 0x50B7, [1246] = 0x511F, [1247] = 0x52DD, [1248] = 0x5320,
  [1249] = 0x5347, [1250] = 0x53EC, [1251] = 0x54E8, [1252] = 0x5546,
  [1253] = 0x5531, [1254] = 0x5617, [1255] = 0x5968, [1256] = 0x59BE,
  [1257] = 0x5A3C, [1258] = 0x5BB5, [1259] = 0x5C06, [1260] = 0x5C0F,
  [1261] = 0x5C11, [1262] = 0x5C1A, [1263] = 0x5E84, [1264] = 0x5E8A,
  [1265] = 0x5EE0, [1266] = 0x5F70, [1267] = 0x627F, [1268] = 0x6284,
  [1269] = 0x62DB, [1270] = 0x638C, [1271] = 0x6377, [1272] = 0x6607,
  [1273] = 0x660C, [1274] = 0x662D, [1275] = 0x6676, [1276] = 0x677E,
  [1277] = 0x68A2, [1278] = 0x6A1F, [1279] = 0x6A35, [1280] = 0x6CBC,
  [1281] = 0x6D88, [1282] = 0x6E09, [1283] = 0x6E58, [1284] = 0x713C,
  [1285] = 0x7126, [1286] = 0x7167, [1287] = 0x75C7, [1288] = 0x7701,
  [1289] = 0x785D, [1290] = 0x7901, [1291] = 0x7965, [1292] = 0x79F0,
  [1293] = 0x7AE0, [1294] = 0x7B11, [1295] = 0x7CA7, [1296] = 0x7D39,
  [1297] = 0x8096, [1298] = 0x83D6, [1299] = 0x848B, [1300] = 0x8549,
  [1301] = 0x885D, [1302] = 0x88F3, [1303] = 0x8A1F, [1304] = 0x8A3C,
  [1305] = 0x8A54, [1306] = 0x8A73, [1307] = 0x8C61, [1308] = 0x8CDE,
  [1309] = 0x91A4, [1310] = 0x9266, [1311] = 0x937E, [1312] = 0x9418,
  [1313] = 0x969C, [1314] = 0x9798, [1315] = 0x4E0A, [1316] = 0x4E08,
  [1317] = 0x4E1E, [1318] = 0x4E57, [1319] = 0x5197, [1320] = 0x5270,
  [1321] = 0x57CE, [1322] = 0x5834, [1323] = 0x58CC, [1324] = 0x5B22,
  [1325] = 0x5E38, [1326] = 0x60C5, [1327] = 0x64FE, [1328] = 0x6761,
  [1329] = 0x6756, [1330] = 0x6D44, [1331] = 0x72B6, [1332] = 0x7573,
  [1333] = 0x7A63, [1334] = 0x84B8, [1335] = 0x8B72, [1336] = 0x91B8,
  [1337] = 0x9320, [1338] = 0x5631, [1339] = 0x57F4, [1340] = 0x98FE,
  [1344] = 0x62ED, [1345] = 0x690D, [1346] = 0x6B96, [1347] = 0x71ED,
  [1348] = 0x7E54, [1349] = 0x8077, [1350] = 0x8272, [1351] = 0x89E6,
  [1352] = 0x98DF, [1353] = 0x8755, [1354] = 0x8FB1, [1355] = 0x5C3B,
  [1356] = 0x4F38, [1357] = 0x4FE1, [1358] = 0x4FB5, [1359] = 0x5507,
  [1360] = 0x5A20, [1361] = 0x5BDD, [1362] = 0x5BE9, [1363] = 0x5FC3,
  [1364] = 0x614E, [1365] = 0x632F, [1366] = 0x65B0, [1367] = 0x664B,
  [1368] = 0x68EE, [1369] = 0x699B, [1370] = 0x6D78, [1371] = 0x6DF1,
  [1372] = 0x7533, [1373] = 0x75B9, [1374] = 0x771F, [1375] = 0x795E,
  [1376] = 0x79E6, [1377] = 0x7D33, [1378] = 0x81E3, [1379] = 0x82AF,
  [1380] = 0x85AA, [1381] = 0x89AA, [1382] = 0x8A3A, [1383] = 0x8EAB,
  [1384] = 0x8F9B, [1385] = 0x9032, [1386] = 0x91DD, [1387] = 0x9707,
  [1388] = 0x4EBA, [1389] = 0x4EC1, [1390] = 0x5203, [1391] = 0x5875,
  [1392] = 0x58EC, [1393] = 0x5C0B, [1394] = 0x751A, [1395] = 0x5C3D,
  [1396] = 0x814E, [1397] = 0x8A0A, [1398] = 0x8FC5, [1399] = 0x9663,
  [1400] = 0x976D, [1401] = 0x7B25, [1402] = 0x8ACF, [1403] = 0x9808,
  [1404] = 0x9162, [1405] = 0x56F3, [1406] = 0x53A8, [1408] = 0x9017,
  [1409] = 0x5439, [1410] = 0x5782, [1411] = 0x5E25, [1412] = 0x63A8,
  [1413] = 0x6C34, [1414] = 0x708A, [1415] = 0x7761, [1416] = 0x7C8B,
  [1417] = 0x7FE0, [1418] = 0x8870, [1419] = 0x9042, [1420] = 0x9154,
  [1421] = 0x9310, [1422] = 0x9318, [1423] = 0x968F, [1424] = 0x745E,
  [1425] = 0x9AC4, [1426] = 0x5D07, [1427] = 0x5D69, [1428] = 0x6570,
  [1429] = 0x67A2, [1430] = 0x8DA8, [1431] = 0x96DB, [1432] = 0x636E,
  [1433] = 0x6749, [1434] = 0x6919, [1435] = 0x83C5, [1436] = 0x9817,
  [1437] = 0x96C0, [1438] = 0x88FE, [1439] = 0x6F84, [1440] = 0x647A,
  [1441] = 0x5BF8, [1442] = 0x4E16, [1443] = 0x702C, [1444] = 0x755D,
  [1445] = 0x662F, [1446] = 0x51C4, [1447] = 0x5236, [1448] = 0x52E2,
  [1449] = 0x59D3, [1450] = 0x5F81, [1451] = 0x6027, [1452] = 0x6210,
  [1453] = 0x653F, [1454] = 0x6574, [1455] = 0x661F, [1456] = 0x6674,
  [1457] = 0x68F2, [1458] = 0x6816, [1459] = 0x6B63, [1460] = 0x6E05,
  [1461] = 0x7272, [1462] = 0x751F, [1463] = 0x76DB, [1464] = 0x7CBE,
  [1465] = 0x8056, [1466] = 0x58F0, [1467] = 0x88FD, [1468] = 0x897F,
  [1469] = 0x8AA0, [1470] = 0x8A93, [1471] = 0x8ACB, [1472] = 0x901D,
  [1473] = 0x9192, [1474] = 0x9752, [1475] = 0x9759, [1476] = 0x6589,
  [1477] = 0x7A0E, [1478] = 0x8106, [1479] = 0x96BB, [1480] = 0x5E2D,
  [1481] = 0x60DC, [1482] = 0x621A, [1483] = 0x65A5, [1484] = 0x6614,
  [1485] = 0x6790, [1486] = 0x77F3, [1487] = 0x7A4D, [1488] = 0x7C4D,
  [1489] = 0x7E3E, [1490] = 0x810A, [1491] = 0x8CAC, [1492] = 0x8D64,
  [1493] = 0x8DE1, [1494] = 0x8E5F, [1495] = 0x78A9, [1496] = 0x5207,
  [1497] = 0x62D9, [1498] = 0x63A5, [1499] = 0x6442, [1500] = 0x6298,
  [1501] = 0x8A2D, [1502] = 0x7A83, [1503] = 0x7BC0, [1504] = 0x8AAC,
  [1505] = 0x96EA, [1506] = 0x7D76, [1507] = 0x820C, [1508] = 0x8749,
  [1509] = 0x4ED9, [1510] = 0x5148, [1511] = 0x5343, [1512] = 0x5360,
  [1513] = 0x5BA3, [1514] = 0x5C02, [1515] = 0x5C16, [1516] = 0x5DDD,
  [1517] = 0x6226, [1518] = 0x6247, [1519] = 0x64B0, [1520] = 0x6813,
  [1521] = 0x6834, [1522] = 0x6CC9, [1523] = 0x6D45, [1524] = 0x6D17,
  [1525] = 0x67D3, [1526] = 0x6F5C, [1527] = 0x714E, [1528] = 0x717D,
  [1529] = 0x65CB, [1530] = 0x7A7F, [1531] = 0x7BAD, [1532] = 0x7DDA,
  [1536] = 0x7E4A, [1537] = 0x7FA8, [1538] = 0x817A, [1539] = 0x821B,
  [1540] = 0x8239, [1541] = 0x85A6, [1542] = 0x8A6E, [1543] = 0x8CCE,
  [1544] = 0x8DF5, [1545] = 0x9078, [1546] = 0x9077, [1547] = 0x92AD,
  [1548] = 0x9291, [1549] = 0x9583, [1550] = 0x9BAE, [1551] = 0x524D,
  [1552] = 0x5584, [1553] = 0x6F38, [1554] = 0x7136, [1555] = 0x5168,
  [1556] = 0x7985, [1557] = 0x7E55, [1558] = 0x81B3, [1559] = 0x7CCE,
  [1560] = 0x564C, [1561] = 0x5851, [1562] = 0x5CA8, [1563] = 0x63AA,
  [1564] = 0x66FE, [1565] = 0x66FD, [1566] = 0x695A, [1567] = 0x72D9,
  [1568] = 0x758F, [1569] = 0x758E, [1570] = 0x790E, [1571] = 0x7956,
  [1572] = 0x79DF, [1573] = 0x7C97, [1574] = 0x7D20, [1575] = 0x7D44,
  [1576] = 0x8607, [1577] = 0x8A34, [1578] = 0x963B, [1579] = 0x9061,
  [1580] = 0x9F20, [1581] = 0x50E7, [1582] = 0x5275, [1583] = 0x53CC,
  [1584] = 0x53E2, [1585] = 0x5009, [1586] = 0x55AA, [1587] = 0x58EE,
  [1588] = 0x594F, [1589] = 0x723D, [1590] = 0x5B8B, [1591] = 0x5C64,
  [1592] = 0x531D, [1593] = 0x60E3, [1594] = 0x60F3, [1595] = 0x635C,
  [1596] = 0x6383, [1597] = 0x633F, [1598] = 0x63BB, [1600] = 0x64CD,
  [1601] = 0x65E9, [1602] = 0x66F9, [1603] = 0x5DE3, [1604] = 0x69CD,
  [1605] = 0x69FD, [1606] = 0x6F15, [1607] = 0x71E5, [1608] = 0x4E89,
  [1609] = 0x75E9, [1610] = 0x76F8, [1611] = 0x7A93, [1612] = 0x7CDF,
  [1613] = 0x7DCF, [1614] = 0x7D9C, [1615] = 0x8061, [1616] = 0x8349,
  [1617] = 0x8358, [1618] = 0x846C, [1619] = 0x84BC, [1620] = 0x85FB,
  [1621] = 0x88C5, [1622] = 0x8D70, [1623] = 0x9001, [1624] = 0x906D,
  [1625] = 0x9397, [1626] = 0x971C, [1627] = 0x9A12, [1628] = 0x50CF,
  [1629] = 0x5897, [1630] = 0x618E, [1631] = 0x81D3, [1632] = 0x8535,
  [1633] = 0x8D08, [1634] = 0x9020, [1635] = 0x4FC3, [1636] = 0x5074,
  [1637] = 0x5247, [1638] = 0x5373, [1639] = 0x606F, [1640] = 0x6349,
  [1641] = 0x675F, [1642] = 0x6E2C, [1643] = 0x8DB3, [1644] = 0x901F,
  [1645] = 0x4FD7, [1646] = 0x5C5E, [1647] = 0x8CCA, [1648] = 0x65CF,
  [1649] = 0x7D9A, [1650] = 0x5352, [1651] = 0x8896, [1652] = 0x5176,
  [1653] = 0x63C3, [1654] = 0x5B58, [1655] = 0x5B6B, [1656] = 0x5C0A,
  [1657] = 0x640D, [1658] = 0x6751, [1659] = 0x905C, [1660] = 0x4ED6,
  [1661] = 0x591A, [1662] = 0x592A, [1663] = 0x6C70, [1664] = 0x8A51,
  [1665] = 0x553E, [1666] = 0x5815, [1667] = 0x59A5, [1668] = 0x60F0,
  [1669] = 0x6253, [1670] = 0x67C1, [1671] = 0x8235, [1672] = 0x6955,
  [1673] = 0x9640, [1674] = 0x99C4, [1675] = 0x9A28, [1676] = 0x4F53,
  [1677] = 0x5806, [1678] = 0x5BFE, [1679] = 0x8010, [1680] = 0x5CB1,
  [1681] = 0x5E2F, [1682] = 0x5F85, [1683] = 0x6020, [1684] = 0x614B,
  [1685] = 0x6234, [1686] = 0x66FF, [1687] = 0x6CF0, [1688] = 0x6EDE,
  [1689] = 0x80CE, [1690] = 0x817F, [1691] = 0x82D4, [1692] = 0x888B,
  [1693] = 0x8CB8, [1694] = 0x9000, [1695] = 0x902E, [1696] = 0x968A,
  [1697] = 0x9EDB, [1698] = 0x9BDB, [1699] = 0x4EE3, [1700] = 0x53F0,
  [1701] = 0x5927, [1702] = 0x7B2C, [1703] = 0x918D, [1704] = 0x984C,
  [1705] = 0x9DF9, [1706] = 0x6EDD, [1707] = 0x7027, [1708] = 0x5353,
  [1709] = 0x5544, [1710] = 0x5B85, [1711] = 0x6258, [1712] = 0x629E,
  [1713] = 0x62D3, [1714] = 0x6CA2, [1715] = 0x6FEF, [1716] = 0x7422,
  [1717] = 0x8A17, [1718] = 0x9438, [1719] = 0x6FC1, [1720] = 0x8AFE,
  [1721] = 0x8338, [1722] = 0x51E7, [1723] = 0x86F8, [1724] = 0x53EA,
  [1728] = 0x53E9, [1729] = 0x4F46, [1730] = 0x9054, [1731] = 0x8FB0,
  [1732] = 0x596A, [1733] = 0x8131, [1734] = 0x5DFD, [1735] = 0x7AEA,
  [1736] = 0x8FBF, [1737] = 0x68DA, [1738] = 0x8C37, [1739] = 0x72F8,
  [1740] = 0x9C48, [1741] = 0x6A3D, [1742] = 0x8AB0, [1743] = 0x4E39,
  [1744] = 0x5358, [1745] = 0x5606, [1746] = 0x5766, [1747] = 0x62C5,
  [1748] = 0x63A2, [1749] = 0x65E6, [1750] = 0x6B4E, [1751] = 0x6DE1,
  [1752] = 0x6E5B, [1753] = 0x70AD, [1754] = 0x77ED, [1755] = 0x7AEF,
  [1756] = 0x7BAA, [1757] = 0x7DBB, [1758] = 0x803D, [1759] = 0x80C6,
  [1760] = 0x86CB, [1761] = 0x8A95, [1762] = 0x935B, [1763] = 0x56E3,
  [1764] = 0x58C7, [1765] = 0x5F3E, [1766] = 0x65AD, [1767] = 0x6696,
  [1768] = 0x6A80, [1769] = 0x6BB5, [1770] = 0x7537, [1771] = 0x8AC7,
  [1772] = 0x5024, [1773] = 0x77E5, [1774] = 0x5730, [1775] = 0x5F1B,
  [1776] = 0x6065, [1777] = 0x667A, [1778] = 0x6C60, [1779] = 0x75F4,
  [1780] = 0x7A1A, [1781] = 0x7F6E, [1782] = 0x81F4, [1783] = 0x8718,
  [1784] = 0x9045, [1785] = 0x99B3, [1786] = 0x7BC9, [1787] = 0x755C,
  [1788] = 0x7AF9, [1789] = 0x7B51, [1790] = 0x84C4, [1792] = 0x9010,
  [1793] = 0x79E9, [1794] = 0x7A92, [1795] = 0x8336, [1796] = 0x5AE1,
  [1797] = 0x7740, [1798] = 0x4E2D, [1799] = 0x4EF2, [1800] = 0x5B99,
  [1801] = 0x5FE0, [1802] = 0x62BD, [1803] = 0x663C, [1804] = 0x67F1,
  [1805] = 0x6CE8, [1806] = 0x866B, [1807] = 0x8877, [1808] = 0x8A3B,
  [1809] = 0x914E, [1810] = 0x92F3, [1811] = 0x99D0, [1812] = 0x6A17,
  [1813] = 0x7026, [1814] = 0x732A, [1815] = 0x82E7, [1816] = 0x8457,
  [1817] = 0x8CAF, [1818] = 0x4E01, [1819] = 0x5146, [1820] = 0x51CB,
  [1821] = 0x558B, [1822] = 0x5BF5, [1823] = 0x5E16, [1824] = 0x5E33,
  [1825] = 0x5E81, [1826] = 0x5F14, [1827] = 0x5F35, [1828] = 0x5F6B,
  [1829] = 0x5FB4, [1830] = 0x61F2, [1831] = 0x6311, [1832] = 0x66A2,
  [1833] = 0x671D, [1834] = 0x6F6E, [1835] = 0x7252, [1836] = 0x753A,
  [1837] = 0x773A, [1838] = 0x8074, [1839] = 0x8139, [1840] = 0x8178,
  [1841] = 0x8776, [1842] = 0x8ABF, [1843] = 0x8ADC, [1844] = 0x8D85,
  [1845] = 0x8DF3, [1846] = 0x929A, [1847] = 0x9577, [1848] = 0x9802,
  [1849] = 0x9CE5, [1850] = 0x52C5, [1851] = 0x6357, [1852] = 0x76F4,
  [1853] = 0x6715, [1854] = 0x6C88, [1855] = 0x73CD, [1856] = 0x8CC3,
  [1857] = 0x93AE, [1858] = 0x9673, [1859] = 0x6D25, [1860] = 0x589C,
  [1861] = 0x690E, [1862] = 0x69CC, [1863] = 0x8FFD, [1864] = 0x939A,
  [1865] = 0x75DB, [1866] = 0x901A, [1867] = 0x585A, [1868] = 0x6802,
  [1869] = 0x63B4, [1870] = 0x69FB, [1871] = 0x4F43, [1872] = 0x6F2C,
  [1873] = 0x67D8, [1874] = 0x8FBB, [1875] = 0x8526, [1876] = 0x7DB4,
  [1877] = 0x9354, [1878] = 0x693F, [1879] = 0x6F70, [1880] = 0x576A,
  [1881] = 0x58F7, [1882] = 0x5B2C, [1883] = 0x7D2C, [1884] = 0x722A,
  [1885] = 0x540A, [1886] = 0x91E3, [1887] = 0x9DB4, [1888] = 0x4EAD,
  [1889] = 0x4F4E, [1890] = 0x505C, [1891] = 0x5075, [1892] = 0x5243,
  [1893] = 0x8C9E, [1894] = 0x5448, [1895] = 0x5824, [1896] = 0x5B9A,
  [1897] = 0x5E1D, [1898] = 0x5E95, [1899] = 0x5EAD, [1900] = 0x5EF7,
  [1901] = 0x5F1F, [1902] = 0x608C, [1903] = 0x62B5, [1904] = 0x633A,
  [1905] = 0x63D0, [1906] = 0x68AF, [1907] = 0x6C40, [1908] = 0x7887,
  [1909] = 0x798E, [1910] = 0x7A0B, [1911] = 0x7DE0, [1912] = 0x8247,
  [1913] = 0x8A02, [1914] = 0x8AE6, [1915] = 0x8E44, [1916] = 0x9013,
  [1920] = 0x90B8, [1921] = 0x912D, [1922] = 0x91D8, [1923] = 0x9F0E,
  [1924] = 0x6CE5, [1925] = 0x6458, [1926] = 0x64E2, [1927] = 0x6575,
  [1928] = 0x6EF4, [1929] = 0x7684, [1930] = 0x7B1B, [1931] = 0x9069,
  [1932] = 0x93D1, [1933] = 0x6EBA, [1934] = 0x54F2, [1935] = 0x5FB9,
  [1936] = 0x64A4, [1937] = 0x8F4D, [1938] = 0x8FED, [1939] = 0x9244,
  [1940] = 0x5178, [1941] = 0x586B, [1942] = 0x5929, [1943] = 0x5C55,
  [1944] = 0x5E97, [1945] = 0x6DFB, [1946] = 0x7E8F, [1947] = 0x751C,
  [1948] = 0x8CBC, [1949] = 0x8EE2, [1950] = 0x985B, [1951] = 0x70B9,
  [1952] = 0x4F1D, [1953] = 0x6BBF, [1954] = 0x6FB1, [1955] = 0x7530,
  [1956] = 0x96FB, [1957] = 0x514E, [1958] = 0x5410, [1959] = 0x5835,
  [1960] = 0x5857, [1961] = 0x59AC, [1962] = 0x5C60, [1963] = 0x5F92,
  [1964] = 0x6597, [1965] = 0x675C, [1966] = 0x6E21, [1967] = 0x767B,
  [1968] = 0x83DF, [1969] = 0x8CED, [1970] = 0x9014, [1971] = 0x90FD,
  [1972] = 0x934D, [1973] = 0x7825, [1974] = 0x783A, [1975] = 0x52AA,
  [1976] = 0x5EA6, [1977] = 0x571F, [1978] = 0x5974, [1979] = 0x6012,
  [1980] = 0x5012, [1981] = 0x515A, [1982] = 0x51AC, [1984] = 0x51CD,
  [1985] = 0x5200, [1986] = 0x5510, [1987] = 0x5854, [1988] = 0x5858,
  [1989] = 0x5957, [1990] = 0x5B95, [1991] = 0x5CF6, [1992] = 0x5D8B,
  [1993] = 0x60BC, [1994] = 0x6295, [1995] = 0x642D, [1996] = 0x6771,
  [1997] = 0x6843, [1998] = 0x68BC, [1999] = 0x68DF, [2000] = 0x76D7,
  [2001] = 0x6DD8, [2002] = 0x6E6F, [2003] = 0x6D9B, [2004] = 0x706F,
  [2005] = 0x71C8, [2006] = 0x5F53, [2007] = 0x75D8, [2008] = 0x7977,
  [2009] = 0x7B49, [2010] = 0x7B54, [2011] = 0x7B52, [2012] = 0x7CD6,
  [2013] = 0x7D71, [2014] = 0x5230, [2015] = 0x8463, [2016] = 0x8569,
  [2017] = 0x85E4, [2018] = 0x8A0E, [2019] = 0x8B04, [2020] = 0x8C46,
  [2021] = 0x8E0F, [2022] = 0x9003, [2023] = 0x900F, [2024] = 0x9419,
  [2025] = 0x9676, [2026] = 0x982D, [2027] = 0x9A30, [2028] = 0x95D8,
  [2029] = 0x50CD, [2030] = 0x52D5, [2031] = 0x540C, [2032] = 0x5802,
  [2033] = 0x5C0E, [2034] = 0x61A7, [2035] = 0x649E, [2036] = 0x6D1E,
  [2037] = 0x77B3, [2038] = 0x7AE5, [2039] = 0x80F4, [2040] = 0x8404,
  [2041] = 0x9053, [2042] = 0x9285, [2043] = 0x5CE0, [2044] = 0x9D07,
  [2045] = 0x533F, [2046] = 0x5F97, [2047] = 0x5FB3, [2048] = 0x6D9C,
  [2049] = 0x7279, [2050] = 0x7763, [2051] = 0x79BF, [2052] = 0x7BE4,
  [2053] = 0x6BD2, [2054] = 0x72EC, [2055] = 0x8AAD, [2056] = 0x6803,
  [2057] = 0x6A61, [2058] = 0x51F8, [2059] = 0x7A81, [2060] = 0x6934,
  [2061] = 0x5C4A, [2062] = 0x9CF6, [2063] = 0x82EB, [2064] = 0x5BC5,
  [2065] = 0x9149, [2066] = 0x701E, [2067] = 0x5678, [2068] = 0x5C6F,
  [2069] = 0x60C7, [2070] = 0x6566, [2071] = 0x6C8C, [2072] = 0x8C5A,
  [2073] = 0x9041, [2074] = 0x9813, [2075] = 0x5451, [2076] = 0x66C7,
  [2077] = 0x920D, [2078] = 0x5948, [2079] = 0x90A3, [2080] = 0x5185,
  [2081] = 0x4E4D, [2082] = 0x51EA, [2083] = 0x8599, [2084] = 0x8B0E,
  [2085] = 0x7058, [2086] = 0x637A, [2087] = 0x934B, [2088] = 0x6962,
  [2089] = 0x99B4, [2090] = 0x7E04, [2091] = 0x7577, [2092] = 0x5357,
  [2093] = 0x6960, [2094] = 0x8EDF, [2095] = 0x96E3, [2096] = 0x6C5D,
  [2097] = 0x4E8C, [2098] = 0x5C3C, [2099] = 0x5F10, [2100] = 0x8FE9,
  [2101] = 0x5302, [2102] = 0x8CD1, [2103] = 0x8089, [2104] = 0x8679,
  [2105] = 0x5EFF, [2106] = 0x65E5, [2107] = 0x4E73, [2108] = 0x5165,
  [2112] = 0x5982, [2113] = 0x5C3F, [2114] = 0x97EE, [2115] = 0x4EFB,
  [2116] = 0x598A, [2117] = 0x5FCD, [2118] = 0x8A8D, [2119] = 0x6FE1,
  [2120] = 0x79B0, [2121] = 0x7962, [2122] = 0x5BE7, [2123] = 0x8471,
  [2124] = 0x732B, [2125] = 0x71B1, [2126] = 0x5E74, [2127] = 0x5FF5,
  [2128] = 0x637B, [2129] = 0x649A, [2130] = 0x71C3, [2131] = 0x7C98,
  [2132] = 0x4E43, [2133] = 0x5EFC, [2134] = 0x4E4B, [2135] = 0x57DC,
  [2136] = 0x56A2, [2137] = 0x60A9, [2138] = 0x6FC3, [2139] = 0x7D0D,
  [2140] = 0x80FD, [2141] = 0x8133, [2142] = 0x81BF, [2143] = 0x8FB2,
  [2144] = 0x8997, [2145] = 0x86A4, [2146] = 0x5DF4, [2147] = 0x628A,
  [2148] = 0x64AD, [2149] = 0x8987, [2150] = 0x6777, [2151] = 0x6CE2,
  [2152] = 0x6D3E, [2153] = 0x7436, [2154] = 0x7834, [2155] = 0x5A46,
  [2156] = 0x7F75, [2157] = 0x82AD, [2158] = 0x99AC, [2159] = 0x4FF3,
  [2160] = 0x5EC3, [2161] = 0x62DD, [2162] = 0x6392, [2163] = 0x6557,
  [2164] = 0x676F, [2165] = 0x76C3, [2166] = 0x724C, [2167] = 0x80CC,
  [2168] = 0x80BA, [2169] = 0x8F29, [2170] = 0x914D, [2171] = 0x500D,
  [2172] = 0x57F9, [2173] = 0x5A92, [2174] = 0x6885, [2176] = 0x6973,
  [2177] = 0x7164, [2178] = 0x72FD, [2179] = 0x8CB7, [2180] = 0x58F2,
  [2181] = 0x8CE0, [2182] = 0x966A, [2183] = 0x9019, [2184] = 0x877F,
  [2185] = 0x79E4, [2186] = 0x77E7, [2187] = 0x8429, [2188] = 0x4F2F,
  [2189] = 0x5265, [2190] = 0x535A, [2191] = 0x62CD, [2192] = 0x67CF,
  [2193] = 0x6CCA, [2194] = 0x767D, [2195] = 0x7B94, [2196] = 0x7C95,
  [2197] = 0x8236, [2198] = 0x8584, [2199] = 0x8FEB, [2200] = 0x66DD,
  [2201] = 0x6F20, [2202] = 0x7206, [2203] = 0x7E1B, [2204] = 0x83AB,
  [2205] = 0x99C1, [2206] = 0x9EA6, [2207] = 0x51FD, [2208] = 0x7BB1,
  [2209] = 0x7872, [2210] = 0x7BB8, [2211] = 0x8087, [2212] = 0x7B48,
  [2213] = 0x6AE8, [2214] = 0x5E61, [2215] = 0x808C, [2216] = 0x7551,
  [2217] = 0x7560, [2218] = 0x516B, [2219] = 0x9262, [2220] = 0x6E8C,
  [2221] = 0x767A, [2222] = 0x9197, [2223] = 0x9AEA, [2224] = 0x4F10,
  [2225] = 0x7F70, [2226] = 0x629C, [2227] = 0x7B4F, [2228] = 0x95A5,
  [2229] = 0x9CE9, [2230] = 0x567A, [2231] = 0x5859, [2232] = 0x86E4,
  [2233] = 0x96BC, [2234] = 0x4F34, [2235] = 0x5224, [2236] = 0x534A,
  [2237] = 0x53CD, [2238] = 0x53DB, [2239] = 0x5E06, [2240] = 0x642C,
  [2241] = 0x6591, [2242] = 0x677F, [2243] = 0x6C3E, [2244] = 0x6C4E,
  [2245] = 0x7248, [2246] = 0x72AF, [2247] = 0x73ED, [2248] = 0x7554,
  [2249] = 0x7E41, [2250] = 0x822C, [2251] = 0x85E9, [2252] = 0x8CA9,
  [2253] = 0x7BC4, [2254] = 0x91C6, [2255] = 0x7169, [2256] = 0x9812,
  [2257] = 0x98EF, [2258] = 0x633D, [2259] = 0x6669, [2260] = 0x756A,
  [2261] = 0x76E4, [2262] = 0x78D0, [2263] = 0x8543, [2264] = 0x86EE,
  [2265] = 0x532A, [2266] = 0x5351, [2267] = 0x5426, [2268] = 0x5983,
  [2269] = 0x5E87, [2270] = 0x5F7C, [2271] = 0x60B2, [2272] = 0x6249,
  [2273] = 0x6279, [2274] = 0x62AB, [2275] = 0x6590, [2276] = 0x6BD4,
  [2277] = 0x6CCC, [2278] = 0x75B2, [2279] = 0x76AE, [2280] = 0x7891,
  [2281] = 0x79D8, [2282] = 0x7DCB, [2283] = 0x7F77, [2284] = 0x80A5,
  [2285] = 0x88AB, [2286] = 0x8AB9, [2287] = 0x8CBB, [2288] = 0x907F,
  [2289] = 0x975E, [2290] = 0x98DB, [2291] = 0x6A0B, [2292] = 0x7C38,
  [2293] = 0x5099, [2294] = 0x5C3E, [2295] = 0x5FAE, [2296] = 0x6787,
  [2297] = 0x6BD8, [2298] = 0x7435, [2299] = 0x7709, [2300] = 0x7F8E,
  [2304] = 0x9F3B, [2305] = 0x67CA, [2306] = 0x7A17, [2307] = 0x5339,
  [2308] = 0x758B, [2309] = 0x9AED, [2310] = 0x5F66, [2311] = 0x819D,
  [2312] = 0x83F1, [2313] = 0x8098, [2314] = 0x5F3C, [2315] = 0x5FC5,
  [2316] = 0x7562, [2317] = 0x7B46, [2318] = 0x903C, [2319] = 0x6867,
  [2320] = 0x59EB, [2321] = 0x5A9B, [2322] = 0x7D10, [2323] = 0x767E,
  [2324] = 0x8B2C, [2325] = 0x4FF5, [2326] = 0x5F6A, [2327] = 0x6A19,
  [2328] = 0x6C37, [2329] = 0x6F02, [2330] = 0x74E2, [2331] = 0x7968,
  [2332] = 0x8868, [2333] = 0x8A55, [2334] = 0x8C79, [2335] = 0x5EDF,
  [2336] = 0x63CF, [2337] = 0x75C5, [2338] = 0x79D2, [2339] = 0x82D7,
  [2340] = 0x9328, [2341] = 0x92F2, [2342] = 0x849C, [2343] = 0x86ED,
  [2344] = 0x9C2D, [2345] = 0x54C1, [2346] = 0x5F6C, [2347] = 0x658C,
  [2348] = 0x6D5C, [2349] = 0x7015, [2350] = 0x8CA7, [2351] = 0x8CD3,
  [2352] = 0x983B, [2353] = 0x654F, [2354] = 0x74F6, [2355] = 0x4E0D,
  [2356] = 0x4ED8, [2357] = 0x57E0, [2358] = 0x592B, [2359] = 0x5A66,
  [2360] = 0x5BCC, [2361] = 0x51A8, [2362] = 0x5E03, [2363] = 0x5E9C,
  [2364] = 0x6016, [2365] = 0x6276, [2366] = 0x6577, [2368] = 0x65A7,
  [2369] = 0x666E, [2370] = 0x6D6E, [2371] = 0x7236, [2372] = 0x7B26,
  [2373] = 0x8150, [2374] = 0x819A, [2375] = 0x8299, [2376] = 0x8B5C,
  [2377] = 0x8CA0, [2378] = 0x8CE6, [2379] = 0x8D74, [2380] = 0x961C,
  [2381] = 0x9644, [2382] = 0x4FAE, [2383] = 0x64AB, [2384] = 0x6B66,
  [2385] = 0x821E, [2386] = 0x8461, [2387] = 0x856A, [2388] = 0x90E8,
  [2389] = 0x5C01, [2390] = 0x6953, [2391] = 0x98A8, [2392] = 0x847A,
  [2393] = 0x8557, [2394] = 0x4F0F, [2395] = 0x526F, [2396] = 0x5FA9,
  [2397] = 0x5E45, [2398] = 0x670D, [2399] = 0x798F, [2400] = 0x8179,
  [2401] = 0x8907, [2402] = 0x8986, [2403] = 0x6DF5, [2404] = 0x5F17,
  [2405] = 0x6255, [2406] = 0x6CB8, [2407] = 0x4ECF, [2408] = 0x7269,
  [2409] = 0x9B92, [2410] = 0x5206, [2411] = 0x543B, [2412] = 0x5674,
  [2413] = 0x58B3, [2414] = 0x61A4, [2415] = 0x626E, [2416] = 0x711A,
  [2417] = 0x596E, [2418] = 0x7C89, [2419] = 0x7CDE, [2420] = 0x7D1B,
  [2421] = 0x96F0, [2422] = 0x6587, [2423] = 0x805E, [2424] = 0x4E19,
  [2425] = 0x4F75, [2426] = 0x5175, [2427] = 0x5840, [2428] = 0x5E63,
  [2429] = 0x5E73, [2430] = 0x5F0A, [2431] = 0x67C4, [2432] = 0x4E26,
  [2433] = 0x853D, [2434] = 0x9589, [2435] = 0x965B, [2436] = 0x7C73,
  [2437] = 0x9801, [2438] = 0x50FB, [2439] = 0x58C1, [2440] = 0x7656,
  [2441] = 0x78A7, [2442] = 0x5225, [2443] = 0x77A5, [2444] = 0x8511,
  [2445] = 0x7B86, [2446] = 0x504F, [2447] = 0x5909, [2448] = 0x7247,
  [2449] = 0x7BC7, [2450] = 0x7DE8, [2451] = 0x8FBA, [2452] = 0x8FD4,
  [2453] = 0x904D, [2454] = 0x4FBF, [2455] = 0x52C9, [2456] = 0x5A29,
  [2457] = 0x5F01, [2458] = 0x97AD, [2459] = 0x4FDD, [2460] = 0x8217,
  [2461] = 0x92EA, [2462] = 0x5703, [2463] = 0x6355, [2464] = 0x6B69,
  [2465] = 0x752B, [2466] = 0x88DC, [2467] = 0x8F14, [2468] = 0x7A42,
  [2469] = 0x52DF, [2470] = 0x5893, [2471] = 0x6155, [2472] = 0x620A,
  [2473] = 0x66AE, [2474] = 0x6BCD, [2475] = 0x7C3F, [2476] = 0x83E9,
  [2477] = 0x5023, [2478] = 0x4FF8, [2479] = 0x5305, [2480] = 0x5446,
  [2481] = 0x5831, [2482] = 0x5949, [2483] = 0x5B9D, [2484] = 0x5CF0,
  [2485] = 0x5CEF, [2486] = 0x5D29, [2487] = 0x5E96, [2488] = 0x62B1,
  [2489] = 0x6367, [2490] = 0x653E, [2491] = 0x65B9, [2492] = 0x670B,
  [2496] = 0x6CD5, [2497] = 0x6CE1, [2498] = 0x70F9, [2499] = 0x7832,
  [2500] = 0x7E2B, [2501] = 0x80DE, [2502] = 0x82B3, [2503] = 0x840C,
  [2504] = 0x84EC, [2505] = 0x8702, [2506] = 0x8912, [2507] = 0x8A2A,
  [2508] = 0x8C4A, [2509] = 0x90A6, [2510] = 0x92D2, [2511] = 0x98FD,
  [2512] = 0x9CF3, [2513] = 0x9D6C, [2514] = 0x4E4F, [2515] = 0x4EA1,
  [2516] = 0x508D, [2517] = 0x5256, [2518] = 0x574A, [2519] = 0x59A8,
  [2520] = 0x5E3D, [2521] = 0x5FD8, [2522] = 0x5FD9, [2523] = 0x623F,
  [2524] = 0x66B4, [2525] = 0x671B, [2526] = 0x67D0, [2527] = 0x68D2,
  [2528] = 0x5192, [2529] = 0x7D21, [2530] = 0x80AA, [2531] = 0x81A8,
  [2532] = 0x8B00, [2533] = 0x8C8C, [2534] = 0x8CBF, [2535] = 0x927E,
  [2536] = 0x9632, [2537] = 0x5420, [2538] = 0x982C, [2539] = 0x5317,
  [2540] = 0x50D5, [2541] = 0x535C, [2542] = 0x58A8, [2543] = 0x64B2,
  [2544] = 0x6734, [2545] = 0x7267, [2546] = 0x7766, [2547] = 0x7A46,
  [2548] = 0x91E6, [2549] = 0x52C3, [2550] = 0x6CA1, [2551] = 0x6B86,
  [2552] = 0x5800, [2553] = 0x5E4C, [2554] = 0x5954, [2555] = 0x672C,
  [2556] = 0x7FFB, [2557] = 0x51E1, [2558] = 0x76C6, [2560] = 0x6469,
  [2561] = 0x78E8, [2562] = 0x9B54, [2563] = 0x9EBB, [2564] = 0x57CB,
  [2565] = 0x59B9, [2566] = 0x6627, [2567] = 0x679A, [2568] = 0x6BCE,
  [2569] = 0x54E9, [2570] = 0x69D9, [2571] = 0x5E55, [2572] = 0x819C,
  [2573] = 0x6795, [2574] = 0x9BAA, [2575] = 0x67FE, [2576] = 0x9C52,
  [2577] = 0x685D, [2578] = 0x4EA6, [2579] = 0x4FE3, [2580] = 0x53C8,
  [2581] = 0x62B9, [2582] = 0x672B, [2583] = 0x6CAB, [2584] = 0x8FC4,
  [2585] = 0x4FAD, [2586] = 0x7E6D, [2587] = 0x9EBF, [2588] = 0x4E07,
  [2589] = 0x6162, [2590] = 0x6E80, [2591] = 0x6F2B, [2592] = 0x8513,
  [2593] = 0x5473, [2594] = 0x672A, [2595] = 0x9B45, [2596] = 0x5DF3,
  [2597] = 0x7B95, [2598] = 0x5CAC, [2599] = 0x5BC6, [2600] = 0x871C,
  [2601] = 0x6E4A, [2602] = 0x84D1, [2603] = 0x7A14, [2604] = 0x8108,
  [2605] = 0x5999, [2606] = 0x7C8D, [2607] = 0x6C11, [2608] = 0x7720,
  [2609] = 0x52D9, [2610] = 0x5922, [2611] = 0x7121, [2612] = 0x725F,
  [2613] = 0x77DB, [2614] = 0x9727, [2615] = 0x9D61, [2616] = 0x690B,
  [2617] = 0x5A7F, [2618] = 0x5A18, [2619] = 0x51A5, [2620] = 0x540D,
  [2621] = 0x547D, [2622] = 0x660E, [2623] = 0x76DF, [2624] = 0x8FF7,
  [2625] = 0x9298, [2626] = 0x9CF4, [2627] = 0x59EA, [2628] = 0x725D,
  [2629] = 0x6EC5, [2630] = 0x514D, [2631] = 0x68C9, [2632] = 0x7DBF,
  [2633] = 0x7DEC, [2634] = 0x9762, [2635] = 0x9EBA, [2636] = 0x6478,
  [2637] = 0x6A21, [2638] = 0x8302, [2639] = 0x5984, [2640] = 0x5B5F,
  [2641] = 0x6BDB, [2642] = 0x731B, [2643] = 0x76F2, [2644] = 0x7DB2,
  [2645] = 0x8017, [2646] = 0x8499, [2647] = 0x5132, [2648] = 0x6728,
  [2649] = 0x9ED9, [2650] = 0x76EE, [2651] = 0x6762, [2652] = 0x52FF,
  [2653] = 0x9905, [2654] = 0x5C24, [2655] = 0x623B, [2656] = 0x7C7E,
  [2657] = 0x8CB0, [2658] = 0x554F, [2659] = 0x60B6, [2660] = 0x7D0B,
  [2661] = 0x9580, [2662] = 0x5301, [2663] = 0x4E5F, [2664] = 0x51B6,
  [2665] = 0x591C, [2666] = 0x723A, [2667] = 0x8036, [2668] = 0x91CE,
  [2669] = 0x5F25, [2670] = 0x77E2, [2671] = 0x5384, [2672] = 0x5F79,
  [2673] = 0x7D04, [2674] = 0x85AC, [2675] = 0x8A33, [2676] = 0x8E8D,
  [2677] = 0x9756, [2678] = 0x67F3, [2679] = 0x85AE, [2680] = 0x9453,
  [2681] = 0x6109, [2682] = 0x6108, [2683] = 0x6CB9, [2684] = 0x7652,
  [2688] = 0x8AED, [2689] = 0x8F38, [2690] = 0x552F, [2691] = 0x4F51,
  [2692] = 0x512A, [2693] = 0x52C7, [2694] = 0x53CB, [2695] = 0x5BA5,
  [2696] = 0x5E7D, [2697] = 0x60A0, [2698] = 0x6182, [2699] = 0x63D6,
  [2700] = 0x6709, [2701] = 0x67DA, [2702] = 0x6E67, [2703] = 0x6D8C,
  [2704] = 0x7336, [2705] = 0x7337, [2706] = 0x7531, [2707] = 0x7950,
  [2708] = 0x88D5, [2709] = 0x8A98, [2710] = 0x904A, [2711] = 0x9091,
  [2712] = 0x90F5, [2713] = 0x96C4, [2714] = 0x878D, [2715] = 0x5915,
  [2716] = 0x4E88, [2717] = 0x4F59, [2718] = 0x4E0E, [2719] = 0x8A89,
  [2720] = 0x8F3F, [2721] = 0x9810, [2722] = 0x50AD, [2723] = 0x5E7C,
  [2724] = 0x5996, [2725] = 0x5BB9, [2726] = 0x5EB8, [2727] = 0x63DA,
  [2728] = 0x63FA, [2729] = 0x64C1, [2730] = 0x66DC, [2731] = 0x694A,
  [2732] = 0x69D8, [2733] = 0x6D0B, [2734] = 0x6EB6, [2735] = 0x7194,
  [2736] = 0x7528, [2737] = 0x7AAF, [2738] = 0x7F8A, [2739] = 0x8000,
  [2740] = 0x8449, [2741] = 0x84C9, [2742] = 0x8981, [2743] = 0x8B21,
  [2744] = 0x8E0A, [2745] = 0x9065, [2746] = 0x967D, [2747] = 0x990A,
  [2748] = 0x617E, [2749] = 0x6291, [2750] = 0x6B32, [2752] = 0x6C83,
  [2753] = 0x6D74, [2754] = 0x7FCC, [2755] = 0x7FFC, [2756] = 0x6DC0,
  [2757] = 0x7F85, [2758] = 0x87BA, [2759] = 0x88F8, [2760] = 0x6765,
  [2761] = 0x83B1, [2762] = 0x983C, [2763] = 0x96F7, [2764] = 0x6D1B,
  [2765] = 0x7D61, [2766] = 0x843D, [2767] = 0x916A, [2768] = 0x4E71,
  [2769] = 0x5375, [2770] = 0x5D50, [2771] = 0x6B04, [2772] = 0x6FEB,
  [2773] = 0x85CD, [2774] = 0x862D, [2775] = 0x89A7, [2776] = 0x5229,
  [2777] = 0x540F, [2778] = 0x5C65, [2779] = 0x674E, [2780] = 0x68A8,
  [2781] = 0x7406, [2782] = 0x7483, [2783] = 0x75E2, [2784] = 0x88CF,
  [2785] = 0x88E1, [2786] = 0x91CC, [2787] = 0x96E2, [2788] = 0x9678,
  [2789] = 0x5F8B, [2790] = 0x7387, [2791] = 0x7ACB, [2792] = 0x844E,
  [2793] = 0x63A0, [2794] = 0x7565, [2795] = 0x5289, [2796] = 0x6D41,
  [2797] = 0x6E9C, [2798] = 0x7409, [2799] = 0x7559, [2800] = 0x786B,
  [2801] = 0x7C92, [2802] = 0x9686, [2803] = 0x7ADC, [2804] = 0x9F8D,
  [2805] = 0x4FB6, [2806] = 0x616E, [2807] = 0x65C5, [2808] = 0x865C,
  [2809] = 0x4E86, [2810] = 0x4EAE, [2811] = 0x50DA, [2812] = 0x4E21,
  [2813] = 0x51CC, [2814] = 0x5BEE, [2815] = 0x6599, [2816] = 0x6881,
  [2817] = 0x6DBC, [2818] = 0x731F, [2819] = 0x7642, [2820] = 0x77AD,
  [2821] = 0x7A1C, [2822] = 0x7CE7, [2823] = 0x826F, [2824] = 0x8AD2,
  [2825] = 0x907C, [2826] = 0x91CF, [2827] = 0x9675, [2828] = 0x9818,
  [2829] = 0x529B, [2830] = 0x7DD1, [2831] = 0x502B, [2832] = 0x5398,
  [2833] = 0x6797, [2834] = 0x6DCB, [2835] = 0x71D0, [2836] = 0x7433,
  [2837] = 0x81E8, [2838] = 0x8F2A, [2839] = 0x96A3, [2840] = 0x9C57,
  [2841] = 0x9E9F, [2842] = 0x7460, [2843] = 0x5841, [2844] = 0x6D99,
  [2845] = 0x7D2F, [2846] = 0x985E, [2847] = 0x4EE4, [2848] = 0x4F36,
  [2849] = 0x4F8B, [2850] = 0x51B7, [2851] = 0x52B1, [2852] = 0x5DBA,
  [2853] = 0x601C, [2854] = 0x73B2, [2855] = 0x793C, [2856] = 0x82D3,
  [2857] = 0x9234, [2858] = 0x96B7, [2859] = 0x96F6, [2860] = 0x970A,
  [2861] = 0x9E97, [2862] = 0x9F62, [2863] = 0x66A6, [2864] = 0x6B74,
  [2865] = 0x5217, [2866] = 0x52A3, [2867] = 0x70C8, [2868] = 0x88C2,
  [2869] = 0x5EC9, [2870] = 0x604B, [2871] = 0x6190, [2872] = 0x6F23,
  [2873] = 0x7149, [2874] = 0x7C3E, [2875] = 0x7DF4, [2876] = 0x806F,
  [2880] = 0x84EE, [2881] = 0x9023, [2882] = 0x932C, [2883] = 0x5442,
  [2884] = 0x9B6F, [2885] = 0x6AD3, [2886] = 0x7089, [2887] = 0x8CC2,
  [2888] = 0x8DEF, [2889] = 0x9732, [2890] = 0x52B4, [2891] = 0x5A41,
  [2892] = 0x5ECA, [2893] = 0x5F04, [2894] = 0x6717, [2895] = 0x697C,
  [2896] = 0x6994, [2897] = 0x6D6A, [2898] = 0x6F0F, [2899] = 0x7262,
  [2900] = 0x72FC, [2901] = 0x7BED, [2902] = 0x8001, [2903] = 0x807E,
  [2904] = 0x874B, [2905] = 0x90CE, [2906] = 0x516D, [2907] = 0x9E93,
  [2908] = 0x7984, [2909] = 0x808B, [2910] = 0x9332, [2911] = 0x8AD6,
  [2912] = 0x502D, [2913] = 0x548C, [2914] = 0x8A71, [2915] = 0x6B6A,
  [2916] = 0x8CC4, [2917] = 0x8107, [2918] = 0x60D1, [2919] = 0x67A0,
  [2920] = 0x9DF2, [2921] = 0x4E99, [2922] = 0x4E98, [2923] = 0x9C10,
  [2924] = 0x8A6B, [2925] = 0x85C1, [2926] = 0x8568, [2927] = 0x6900,
  [2928] = 0x6E7E, [2929] = 0x7897, [2930] = 0x8155, [2975] = 0x5F0C,
  [2976] = 0x4E10, [2977] = 0x4E15, [2978] = 0x4E2A, [2979] = 0x4E31,
  [2980] = 0x4E36, [2981] = 0x4E3C, [2982] = 0x4E3F, [2983] = 0x4E42,
  [2984] = 0x4E56, [2985] = 0x4E58, [2986] = 0x4E82, [2987] = 0x4E85,
  [2988] = 0x8C6B, [2989] = 0x4E8A, [2990] = 0x8212, [2991] = 0x5F0D,
  [2992] = 0x4E8E, [2993] = 0x4E9E, [2994] = 0x4E9F, [2995] = 0x4EA0,
  [2996] = 0x4EA2, [2997] = 0x4EB0, [2998] = 0x4EB3, [2999] = 0x4EB6,
  [3000] = 0x4ECE, [3001] = 0x4ECD, [3002] = 0x4EC4, [3003] = 0x4EC6,
  [3004] = 0x4EC2, [3005] = 0x4ED7, [3006] = 0x4EDE, [3007] = 0x4EED,
  [3008] = 0x4EDF, [3009] = 0x4EF7, [3010] = 0x4F09, [3011] = 0x4F5A,
  [3012] = 0x4F30, [3013] = 0x4F5B, [3014] = 0x4F5D, [3015] = 0x4F57,
  [3016] = 0x4F47, [3017] = 0x4F76, [3018] = 0x4F88, [3019] = 0x4F8F,
  [3020] = 0x4F98, [3021] = 0x4F7B, [3022] = 0x4F69, [3023] = 0x4F70,
  [3024] = 0x4F91, [3025] = 0x4F6F, [3026] = 0x4F86, [3027] = 0x4F96,
  [3028] = 0x5118, [3029] = 0x4FD4, [3030] = 0x4FDF, [3031] = 0x4FCE,
  [3032] = 0x4FD8, [3033] = 0x4FDB, [3034] = 0x4FD1, [3035] = 0x4FDA,
  [3036] = 0x4FD0, [3037] = 0x4FE4, [3038] = 0x4FE5, [3039] = 0x501A,
  [3040] = 0x5028, [3041] = 0x5014, [3042] = 0x502A, [3043] = 0x5025,
  [3044] = 0x5005, [3045] = 0x4F1C, [3046] = 0x4FF6, [3047] = 0x5021,
  [3048] = 0x5029, [3049] = 0x502C, [3050] = 0x4FFE, [3051] = 0x4FEF,
  [3052] = 0x5011, [3053] = 0x5006, [3054] = 0x5043, [3055] = 0x5047,
  [3056] = 0x6703, [3057] = 0x5055, [3058] = 0x5050, [3059] = 0x5048,
  [3060] = 0x505A, [3061] = 0x5056, [3062] = 0x506C, [3063] = 0x5078,
  [3064] = 0x5080, [3065] = 0x509A, [3066] = 0x5085, [3067] = 0x50B4,
  [3068] = 0x50B2, [3072] = 0x50C9, [3073] = 0x50CA, [3074] = 0x50B3,
  [3075] = 0x50C2, [3076] = 0x50D6, [3077] = 0x50DE, [3078] = 0x50E5,
  [3079] = 0x50ED, [3080] = 0x50E3, [3081] = 0x50EE, [3082] = 0x50F9,
  [3083] = 0x50F5, [3084] = 0x5109, [3085] = 0x5101, [3086] = 0x5102,
  [3087] = 0x5116, [3088] = 0x5115, [3089] = 0x5114, [3090] = 0x511A,
  [3091] = 0x5121, [3092] = 0x513A, [3093] = 0x5137, [3094] = 0x513C,
  [3095] = 0x513B, [3096] = 0x513F, [3097] = 0x5140, [3098] = 0x5152,
  [3099] = 0x514C, [3100] = 0x5154, [3101] = 0x5162, [3102] = 0x7AF8,
  [3103] = 0x5169, [3104] = 0x516A, [3105] = 0x516E, [3106] = 0x5180,
  [3107] = 0x5182, [3108] = 0x56D8, [3109] = 0x518C, [3110] = 0x5189,
  [3111] = 0x518F, [3112] = 0x5191, [3113] = 0x5193, [3114] = 0x5195,
  [3115] = 0x5196, [3116] = 0x51A4, [3117] = 0x51A6, [3118] = 0x51A2,
  [3119] = 0x51A9, [3120] = 0x51AA, [3121] = 0x51AB, [3122] = 0x51B3,
  [3123] = 0x51B1, [3124] = 0x51B2, [3125] = 0x51B0, [3126] = 0x51B5,
  [3127] = 0x51BD, [3128] = 0x51C5, [3129] = 0x51C9, [3130] = 0x51DB,
  [3131] = 0x51E0, [3132] = 0x8655, [3133] = 0x51E9, [3134] = 0x51ED,
  [3136] = 0x51F0, [3137] = 0x51F5, [3138] = 0x51FE, [3139] = 0x5204,
  [3140] = 0x520B, [3141] = 0x5214, [3142] = 0x520E, [3143] = 0x5227,
  [3144] = 0x522A, [3145] = 0x522E, [3146] = 0x5233, [3147] = 0x5239,
  [3148] = 0x524F, [3149] = 0x5244, [3150] = 0x524B, [3151] = 0x524C,
  [3152] = 0x525E, [3153] = 0x5254, [3154] = 0x526A, [3155] = 0x5274,
  [3156] = 0x5269, [3157] = 0x5273, [3158] = 0x527F, [3159] = 0x527D,
  [3160] = 0x528D, [3161] = 0x5294, [3162] = 0x5292, [3163] = 0x5271,
  [3164] = 0x5288, [3165] = 0x5291, [3166] = 0x8FA8, [3167] = 0x8FA7,
  [3168] = 0x52AC, [3169] = 0x52AD, [3170] = 0x52BC, [3171] = 0x52B5,
  [3172] = 0x52C1, [3173] = 0x52CD, [3174] = 0x52D7, [3175] = 0x52DE,
  [3176] = 0x52E3, [3177] = 0x52E6, [3178] = 0x98ED, [3179] = 0x52E0,
  [3180] = 0x52F3, [3181] = 0x52F5, [3182] = 0x52F8, [3183] = 0x52F9,
  [3184] = 0x5306, [3185] = 0x5308, [3186] = 0x7538, [3187] = 0x530D,
  [3188] = 0x5310, [3189] = 0x530F, [3190] = 0x5315, [3191] = 0x531A,
  [3192] = 0x5323, [3193] = 0x532F, [3194] = 0x5331, [3195] = 0x5333,
  [3196] = 0x5338, [3197] = 0x5340, [3198] = 0x5346, [3199] = 0x5345,
  [3200] = 0x4E17, [3201] = 0x5349, [3202] = 0x534D, [3203] = 0x51D6,
  [3204] = 0x535E, [3205] = 0x5369, [3206] = 0x536E, [3207] = 0x5918,
  [3208] = 0x537B, [3209] = 0x5377, [3210] = 0x5382, [3211] = 0x5396,
  [3212] = 0x53A0, [3213] = 0x53A6, [3214] = 0x53A5, [3215] = 0x53AE,
  [3216] = 0x53B0, [3217] = 0x53B6, [3218] = 0x53C3, [3219] = 0x7C12,
  [3220] = 0x96D9, [3221] = 0x53DF, [3222] = 0x66FC, [3223] = 0x71EE,
  [3224] = 0x53EE, [3225] = 0x53E8, [3226] = 0x53ED, [3227] = 0x53FA,
  [3228] = 0x5401, [3229] = 0x543D, [3230] = 0x5440, [3231] = 0x542C,
  [3232] = 0x542D, [3233] = 0x543C, [3234] = 0x542E, [3235] = 0x5436,
  [3236] = 0x5429, [3237] = 0x541D, [3238] = 0x544E, [3239] = 0x548F,
  [3240] = 0x5475, [3241] = 0x548E, [3242] = 0x545F, [3243] = 0x5471,
  [3244] = 0x5477, [3245] = 0x5470, [3246] = 0x5492, [3247] = 0x547B,
  [3248] = 0x5480, [3249] = 0x5476, [3250] = 0x5484, [3251] = 0x5490,
  [3252] = 0x5486, [3253] = 0x54C7, [3254] = 0x54A2, [3255] = 0x54B8,
  [3256] = 0x54A5, [3257] = 0x54AC, [3258] = 0x54C4, [3259] = 0x54C8,
  [3260] = 0x54A8, [3264] = 0x54AB, [3265] = 0x54C2, [3266] = 0x54A4,
  [3267] = 0x54BE, [3268] = 0x54BC, [3269] = 0x54D8, [3270] = 0x54E5,
  [3271] = 0x54E6, [3272] = 0x550F, [3273] = 0x5514, [3274] = 0x54FD,
  [3275] = 0x54EE, [3276] = 0x54ED, [3277] = 0x54FA, [3278] = 0x54E2,
  [3279] = 0x5539, [3280] = 0x5540, [3281] = 0x5563, [3282] = 0x554C,
  [3283] = 0x552E, [3284] = 0x555C, [3285] = 0x5545, [3286] = 0x5556,
  [3287] = 0x5557, [3288] = 0x5538, [3289] = 0x5533, [3290] = 0x555D,
  [3291] = 0x5599, [3292] = 0x5580, [3293] = 0x54AF, [3294] = 0x558A,
  [3295] = 0x559F, [3296] = 0x557B, [3297] = 0x557E, [3298] = 0x5598,
  [3299] = 0x559E, [3300] = 0x55AE, [3301] = 0x557C, [3302] = 0x5583,
  [3303] = 0x55A9, [3304] = 0x5587, [3305] = 0x55A8, [3306] = 0x55DA,
  [3307] = 0x55C5, [3308] = 0x55DF, [3309] = 0x55C4, [3310] = 0x55DC,
  [3311] = 0x55E4, [3312] = 0x55D4, [3313] = 0x5614, [3314] = 0x55F7,
  [3315] = 0x5616, [3316] = 0x55FE, [3317] = 0x55FD, [3318] = 0x561B,
  [3319] = 0x55F9, [3320] = 0x564E, [3321] = 0x5650, [3322] = 0x71DF,
  [3323] = 0x5634, [3324] = 0x5636, [3325] = 0x5632, [3326] = 0x5638,
  [3328] = 0x566B, [3329] = 0x5664, [3330] = 0x562F, [3331] = 0x566C,
  [3332] = 0x566A, [3333] = 0x5686, [3334] = 0x5680, [3335] = 0x568A,
  [3336] = 0x56A0, [3337] = 0x5694, [3338] = 0x568F, [3339] = 0x56A5,
  [3340] = 0x56AE, [3341] = 0x56B6, [3342] = 0x56B4, [3343] = 0x56C2,
  [3344] = 0x56BC, [3345] = 0x56C1, [3346] = 0x56C3, [3347] = 0x56C0,
  [3348] = 0x56C8, [3349] = 0x56CE, [3350] = 0x56D1, [3351] = 0x56D3,
  [3352] = 0x56D7, [3353] = 0x56EE, [3354] = 0x56F9, [3355] = 0x5700,
  [3356] = 0x56FF, [3357] = 0x5704, [3358] = 0x5709, [3359] = 0x5708,
  [3360] = 0x570B, [3361] = 0x570D, [3362] = 0x5713, [3363] = 0x5718,
  [3364] = 0x5716, [3365] = 0x55C7, [3366] = 0x571C, [3367] = 0x5726,
  [3368] = 0x5737, [3369] = 0x5738, [3370] = 0x574E, [3371] = 0x573B,
  [3372] = 0x5740, [3373] = 0x574F, [3374] = 0x5769, [3375] = 0x57C0,
  [3376] = 0x5788, [3377] = 0x5761, [3378] = 0x577F, [3379] = 0x5789,
  [3380] = 0x5793, [3381] = 0x57A0, [3382] = 0x57B3, [3383] = 0x57A4,
  [3384] = 0x57AA, [3385] = 0x57B0, [3386] = 0x57C3, [3387] = 0x57C6,
  [3388] = 0x57D4, [3389] = 0x57D2, [3390] = 0x57D3, [3391] = 0x580A,
  [3392] = 0x57D6, [3393] = 0x57E3, [3394] = 0x580B, [3395] = 0x5819,
  [3396] = 0x581D, [3397] = 0x5872, [3398] = 0x5821, [3399] = 0x5862,
  [3400] = 0x584B, [3401] = 0x5870, [3402] = 0x6BC0, [3403] = 0x5852,
  [3404] = 0x583D, [3405] = 0x5879, [3406] = 0x5885, [3407] = 0x58B9,
  [3408] = 0x589F, [3409] = 0x58AB, [3410] = 0x58BA, [3411] = 0x58DE,
  [3412] = 0x58BB, [3413] = 0x58B8, [3414] = 0x58AE, [3415] = 0x58C5,
  [3416] = 0x58D3, [3417] = 0x58D1, [3418] = 0x58D7, [3419] = 0x58D9,
  [3420] = 0x58D8, [3421] = 0x58E5, [3422] = 0x58DC, [3423] = 0x58E4,
  [3424] = 0x58DF, [3425] = 0x58EF, [3426] = 0x58FA, [3427] = 0x58F9,
  [3428] = 0x58FB, [3429] = 0x58FC, [3430] = 0x58FD, [3431] = 0x5902,
  [3432] = 0x590A, [3433] = 0x5910, [3434] = 0x591B, [3435] = 0x68A6,
  [3436] = 0x5925, [3437] = 0x592C, [3438] = 0x592D, [3439] = 0x5932,
  [3440] = 0x5938, [3441] = 0x593E, [3442] = 0x7AD2, [3443] = 0x5955,
  [3444] = 0x5950, [3445] = 0x594E, [3446] = 0x595A, [3447] = 0x5958,
  [3448] = 0x5962, [3449] = 0x5960, [3450] = 0x5967, [3451] = 0x596C,
  [3452] = 0x5969, [3456] = 0x5978, [3457] = 0x5981, [3458] = 0x599D,
  [3459] = 0x4F5E, [3460] = 0x4FAB, [3461] = 0x59A3, [3462] = 0x59B2,
  [3463] = 0x59C6, [3464] = 0x59E8, [3465] = 0x59DC, [3466] = 0x598D,
  [3467] = 0x59D9, [3468] = 0x59DA, [3469] = 0x5A25, [3470] = 0x5A1F,
  [3471] = 0x5A11, [3472] = 0x5A1C, [3473] = 0x5A09, [3474] = 0x5A1A,
  [3475] = 0x5A40, [3476] = 0x5A6C, [3477] = 0x5A49, [3478] = 0x5A35,
  [3479] = 0x5A36, [3480] = 0x5A62, [3481] = 0x5A6A, [3482] = 0x5A9A,
  [3483] = 0x5ABC, [3484] = 0x5ABE, [3485] = 0x5ACB, [3486] = 0x5AC2,
  [3487] = 0x5ABD, [3488] = 0x5AE3, [3489] = 0x5AD7, [3490] = 0x5AE6,
  [3491] = 0x5AE9, [3492] = 0x5AD6, [3493] = 0x5AFA, [3494] = 0x5AFB,
  [3495] = 0x5B0C, [3496] = 0x5B0B, [3497] = 0x5B16, [3498] = 0x5B32,
  [3499] = 0x5AD0, [3500] = 0x5B2A, [3501] = 0x5B36, [3502] = 0x5B3E,
  [3503] = 0x5B43, [3504] = 0x5B45, [3505] = 0x5B40, [3506] = 0x5B51,
  [3507] = 0x5B55, [3508] = 0x5B5A, [3509] = 0x5B5B, [3510] = 0x5B65,
  [3511] = 0x5B69, [3512] = 0x5B70, [3513] = 0x5B73, [3514] = 0x5B75,
  [3515] = 0x5B78, [3516] = 0x6588, [3517] = 0x5B7A, [3518] = 0x5B80,
  [3520] = 0x5B83, [3521] = 0x5BA6, [3522] = 0x5BB8, [3523] = 0x5BC3,
  [3524] = 0x5BC7, [3525] = 0x5BC9, [3526] = 0x5BD4, [3527] = 0x5BD0,
  [3528] = 0x5BE4, [3529] = 0x5BE6, [3530] = 0x5BE2, [3531] = 0x5BDE,
  [3532] = 0x5BE5, [3533] = 0x5BEB, [3534] = 0x5BF0, [3535] = 0x5BF6,
  [3536] = 0x5BF3, [3537] = 0x5C05, [3538] = 0x5C07, [3539] = 0x5C08,
  [3540] = 0x5C0D, [3541] = 0x5C13, [3542] = 0x5C20, [3543] = 0x5C22,
  [3544] = 0x5C28, [3545] = 0x5C38, [3546] = 0x5C39, [3547] = 0x5C41,
  [3548] = 0x5C46, [3549] = 0x5C4E, [3550] = 0x5C53, [3551] = 0x5C50,
  [3552] = 0x5C4F, [3553] = 0x5B71, [3554] = 0x5C6C, [3555] = 0x5C6E,
  [3556] = 0x4E62, [3557] = 0x5C76, [3558] = 0x5C79, [3559] = 0x5C8C,
  [3560] = 0x5C91, [3561] = 0x5C94, [3562] = 0x599B, [3563] = 0x5CAB,
  [3564] = 0x5CBB, [3565] = 0x5CB6, [3566] = 0x5CBC, [3567] = 0x5CB7,
  [3568] = 0x5CC5, [3569] = 0x5CBE, [3570] = 0x5CC7, [3571] = 0x5CD9,
  [3572] = 0x5CE9, [3573] = 0x5CFD, [3574] = 0x5CFA, [3575] = 0x5CED,
  [3576] = 0x5D8C, [3577] = 0x5CEA, [3578] = 0x5D0B, [3579] = 0x5D15,
  [3580] = 0x5D17, [3581] = 0x5D5C, [3582] = 0x5D1F, [3583] = 0x5D1B,
  [3584] = 0x5D11, [3585] = 0x5D14, [3586] = 0x5D22, [3587] = 0x5D1A,
  [3588] = 0x5D19, [3589] = 0x5D18, [3590] = 0x5D4C, [3591] = 0x5D52,
  [3592] = 0x5D4E, [3593] = 0x5D4B, [3594] = 0x5D6C, [3595] = 0x5D73,
  [3596] = 0x5D76, [3597] = 0x5D87, [3598] = 0x5D84, [3599] = 0x5D82,
  [3600] = 0x5DA2, [3601] = 0x5D9D, [3602] = 0x5DAC, [3603] = 0x5DAE,
  [3604] = 0x5DBD, [3605] = 0x5D90, [3606] = 0x5DB7, [3607] = 0x5DBC,
  [3608] = 0x5DC9, [3609] = 0x5DCD, [3610] = 0x5DD3, [3611] = 0x5DD2,
  [3612] = 0x5DD6, [3613] = 0x5DDB, [3614] = 0x5DEB, [3615] = 0x5DF2,
  [3616] = 0x5DF5, [3617] = 0x5E0B, [3618] = 0x5E1A, [3619] = 0x5E19,
  [3620] = 0x5E11, [3621] = 0x5E1B, [3622] = 0x5E36, [3623] = 0x5E37,
  [3624] = 0x5E44, [3625] = 0x5E43, [3626] = 0x5E40, [3627] = 0x5E4E,
  [3628] = 0x5E57, [3629] = 0x5E54, [3630] = 0x5E5F, [3631] = 0x5E62,
  [3632] = 0x5E64, [3633] = 0x5E47, [3634] = 0x5E75, [3635] = 0x5E76,
  [3636] = 0x5E7A, [3637] = 0x9EBC, [3638] = 0x5E7F, [3639] = 0x5EA0,
  [3640] = 0x5EC1, [3641] = 0x5EC2, [3642] = 0x5EC8, [3643] = 0x5ED0,
  [3644] = 0x5ECF, [3648] = 0x5ED6, [3649] = 0x5EE3, [3650] = 0x5EDD,
  [3651] = 0x5EDA, [3652] = 0x5EDB, [3653] = 0x5EE2, [3654] = 0x5EE1,
  [3655] = 0x5EE8, [3656] = 0x5EE9, [3657] = 0x5EEC, [3658] = 0x5EF1,
  [3659] = 0x5EF3, [3660] = 0x5EF0, [3661] = 0x5EF4, [3662] = 0x5EF8,
  [3663] = 0x5EFE, [3664] = 0x5F03, [3665] = 0x5F09, [3666] = 0x5F5D,
  [3667] = 0x5F5C, [3668] = 0x5F0B, [3669] = 0x5F11, [3670] = 0x5F16,
  [3671] = 0x5F29, [3672] = 0x5F2D, [3673] = 0x5F38, [3674] = 0x5F41,
  [3675] = 0x5F48, [3676] = 0x5F4C, [3677] = 0x5F4E, [3678] = 0x5F2F,
  [3679] = 0x5F51, [3680] = 0x5F56, [3681] = 0x5F57, [3682] = 0x5F59,
  [3683] = 0x5F61, [3684] = 0x5F6D, [3685] = 0x5F73, [3686] = 0x5F77,
  [3687] = 0x5F83, [3688] = 0x5F82, [3689] = 0x5F7F, [3690] = 0x5F8A,
  [3691] = 0x5F88, [3692] = 0x5F91, [3693] = 0x5F87, [3694] = 0x5F9E,
  [3695] = 0x5F99, [3696] = 0x5F98, [3697] = 0x5FA0, [3698] = 0x5FA8,
  [3699] = 0x5FAD, [3700] = 0x5FBC, [3701] = 0x5FD6, [3702] = 0x5FFB,
  [3703] = 0x5FE4, [3704] = 0x5FF8, [3705] = 0x5FF1, [3706] = 0x5FDD,
  [3707] = 0x60B3, [3708] = 0x5FFF, [3709] = 0x6021, [3710] = 0x6060,
  [3712] = 0x6019, [3713] = 0x6010, [3714] = 0x6029, [3715] = 0x600E,
  [3716] = 0x6031, [3717] = 0x601B, [3718] = 0x6015, [3719] = 0x602B,
  [3720] = 0x6026, [3721] = 0x600F, [3722] = 0x603A, [3723] = 0x605A,
  [3724] = 0x6041, [3725] = 0x606A, [3726] = 0x6077, [3727] = 0x605F,
  [3728] = 0x604A, [3729] = 0x6046, [3730] = 0x604D, [3731] = 0x6063,
  [3732] = 0x6043, [3733] = 0x6064, [3734] = 0x6042, [3735] = 0x606C,
  [3736] = 0x606B, [3737] = 0x6059, [3738] = 0x6081, [3739] = 0x608D,
  [3740] = 0x60E7, [3741] = 0x6083, [3742] = 0x609A, [3743] = 0x6084,
  [3744] = 0x609B, [3745] = 0x6096, [3746] = 0x6097, [3747] = 0x6092,
  [3748] = 0x60A7, [3749] = 0x608B, [3750] = 0x60E1, [3751] = 0x60B8,
  [3752] = 0x60E0, [3753] = 0x60D3, [3754] = 0x60B4, [3755] = 0x5FF0,
  [3756] = 0x60BD, [3757] = 0x60C6, [3758] = 0x60B5, [3759] = 0x60D8,
  [3760] = 0x614D, [3761] = 0x6115, [3762] = 0x6106, [3763] = 0x60F6,
  [3764] = 0x60F7, [3765] = 0x6100, [3766] = 0x60F4, [3767] = 0x60FA,
  [3768] = 0x6103, [3769] = 0x6121, [3770] = 0x60FB, [3771] = 0x60F1,
  [3772] = 0x610D, [3773] = 0x610E, [3774] = 0x6147, [3775] = 0x613E,
  [3776] = 0x6128, [3777] = 0x6127, [3778] = 0x614A, [3779] = 0x613F,
  [3780] = 0x613C, [3781] = 0x612C, [3782] = 0x6134, [3783] = 0x613D,
  [3784] = 0x6142, [3785] = 0x6144, [3786] = 0x6173, [3787] = 0x6177,
  [3788] = 0x6158, [3789] = 0x6159, [3790] = 0x615A, [3791] = 0x616B,
  [3792] = 0x6174, [3793] = 0x616F, [3794] = 0x6165, [3795] = 0x6171,
  [3796] = 0x615F, [3797] = 0x615D, [3798] = 0x6153, [3799] = 0x6175,
  [3800] = 0x6199, [3801] = 0x6196, [3802] = 0x6187, [3803] = 0x61AC,
  [3804] = 0x6194, [3805] = 0x619A, [3806] = 0x618A, [3807] = 0x6191,
  [3808] = 0x61AB, [3809] = 0x61AE, [3810] = 0x61CC, [3811] = 0x61CA,
  [3812] = 0x61C9, [3813] = 0x61F7, [3814] = 0x61C8, [3815] = 0x61C3,
  [3816] = 0x61C6, [3817] = 0x61BA, [3818] = 0x61CB, [3819] = 0x7F79,
  [3820] = 0x61CD, [3821] = 0x61E6, [3822] = 0x61E3, [3823] = 0x61F6,
  [3824] = 0x61FA, [3825] = 0x61F4, [3826] = 0x61FF, [3827] = 0x61FD,
  [3828] = 0x61FC, [3829] = 0x61FE, [3830] = 0x6200, [3831] = 0x6208,
  [3832] = 0x6209, [3833] = 0x620D, [3834] = 0x620C, [3835] = 0x6214,
  [3836] = 0x621B, [3840] = 0x621E, [3841] = 0x6221, [3842] = 0x622A,
  [3843] = 0x622E, [3844] = 0x6230, [3845] = 0x6232, [3846] = 0x6233,
  [3847] = 0x6241, [3848] = 0x624E, [3849] = 0x625E, [3850] = 0x6263,
  [3851] = 0x625B, [3852] = 0x6260, [3853] = 0x6268, [3854] = 0x627C,
  [3855] = 0x6282, [3856] = 0x6289, [3857] = 0x627E, [3858] = 0x6292,
  [3859] = 0x6293, [3860] = 0x6296, [3861] = 0x62D4, [3862] = 0x6283,
  [3863] = 0x6294, [3864] = 0x62D7, [3865] = 0x62D1, [3866] = 0x62BB,
  [3867] = 0x62CF, [3868] = 0x62FF, [3869] = 0x62C6, [3870] = 0x64D4,
  [3871] = 0x62C8, [3872] = 0x62DC, [3873] = 0x62CC, [3874] = 0x62CA,
  [3875] = 0x62C2, [3876] = 0x62C7, [3877] = 0x629B, [3878] = 0x62C9,
  [3879] = 0x630C, [3880] = 0x62EE, [3881] = 0x62F1, [3882] = 0x6327,
  [3883] = 0x6302, [3884] = 0x6308, [3885] = 0x62EF, [3886] = 0x62F5,
  [3887] = 0x6350, [3888] = 0x633E, [3889] = 0x634D, [3890] = 0x641C,
  [3891] = 0x634F, [3892] = 0x6396, [3893] = 0x638E, [3894] = 0x6380,
  [3895] = 0x63AB, [3896] = 0x6376, [3897] = 0x63A3, [3898] = 0x638F,
  [3899] = 0x6389, [3900] = 0x639F, [3901] = 0x63B5, [3902] = 0x636B,
  [3904] = 0x6369, [3905] = 0x63BE, [3906] = 0x63E9, [3907] = 0x63C0,
  [3908] = 0x63C6, [3909] = 0x63E3, [3910] = 0x63C9, [3911] = 0x63D2,
  [3912] = 0x63F6, [3913] = 0x63C4, [3914] = 0x6416, [3915] = 0x6434,
  [3916] = 0x6406, [3917] = 0x6413, [3918] = 0x6426, [3919] = 0x6436,
  [3920] = 0x651D, [3921] = 0x6417, [3922] = 0x6428, [3923] = 0x640F,
  [3924] = 0x6467, [3925] = 0x646F, [3926] = 0x6476, [3927] = 0x644E,
  [3928] = 0x652A, [3929] = 0x6495, [3930] = 0x6493, [3931] = 0x64A5,
  [3932] = 0x64A9, [3933] = 0x6488, [3934] = 0x64BC, [3935] = 0x64DA,
  [3936] = 0x64D2, [3937] = 0x64C5, [3938] = 0x64C7, [3939] = 0x64BB,
  [3940] = 0x64D8, [3941] = 0x64C2, [3942] = 0x64F1, [3943] = 0x64E7,
  [3944] = 0x8209, [3945] = 0x64E0, [3946] = 0x64E1, [3947] = 0x62AC,
  [3948] = 0x64E3, [3949] = 0x64EF, [3950] = 0x652C, [3951] = 0x64F6,
  [3952] = 0x64F4, [3953] = 0x64F2, [3954] = 0x64FA, [3955] = 0x6500,
  [3956] = 0x64FD, [3957] = 0x6518, [3958] = 0x651C, [3959] = 0x6505,
  [3960] = 0x6524, [3961] = 0x6523, [3962] = 0x652B, [3963] = 0x6534,
  [3964] = 0x6535, [3965] = 0x6537, [3966] = 0x6536, [3967] = 0x6538,
  [3968] = 0x754B, [3969] = 0x6548, [3970] = 0x6556, [3971] = 0x6555,
  [3972] = 0x654D, [3973] = 0x6558, [3974] = 0x655E, [3975] = 0x655D,
  [3976] = 0x6572, [3977] = 0x6578, [3978] = 0x6582, [3979] = 0x6583,
  [3980] = 0x8B8A, [3981] = 0x659B, [3982] = 0x659F, [3983] = 0x65AB,
  [3984] = 0x65B7, [3985] = 0x65C3, [3986] = 0x65C6, [3987] = 0x65C1,
  [3988] = 0x65C4, [3989] = 0x65CC, [3990] = 0x65D2, [3991] = 0x65DB,
  [3992] = 0x65D9, [3993] = 0x65E0, [3994] = 0x65E1, [3995] = 0x65F1,
  [3996] = 0x6772, [3997] = 0x660A, [3998] = 0x6603, [3999] = 0x65FB,
  [4000] = 0x6773, [4001] = 0x6635, [4002] = 0x6636, [4003] = 0x6634,
  [4004] = 0x661C, [4005] = 0x664F, [4006] = 0x6644, [4007] = 0x6649,
  [4008] = 0x6641, [4009] = 0x665E, [4010] = 0x665D, [4011] = 0x6664,
  [4012] = 0x6667, [4013] = 0x6668, [4014] = 0x665F, [4015] = 0x6662,
  [4016] = 0x6670, [4017] = 0x6683, [4018] = 0x6688, [4019] = 0x668E,
  [4020] = 0x6689, [4021] = 0x6684, [4022] = 0x6698, [4023] = 0x669D,
  [4024] = 0x66C1, [4025] = 0x66B9, [4026] = 0x66C9, [4027] = 0x66BE,
  [4028] = 0x66BC, [4032] = 0x66C4, [4033] = 0x66B8, [4034] = 0x66D6,
  [4035] = 0x66DA, [4036] = 0x66E0, [4037] = 0x663F, [4038] = 0x66E6,
  [4039] = 0x66E9, [4040] = 0x66F0, [4041] = 0x66F5, [4042] = 0x66F7,
  [4043] = 0x670F, [4044] = 0x6716, [4045] = 0x671E, [4046] = 0x6726,
  [4047] = 0x6727, [4048] = 0x9738, [4049] = 0x672E, [4050] = 0x673F,
  [4051] = 0x6736, [4052] = 0x6741, [4053] = 0x6738, [4054] = 0x6737,
  [4055] = 0x6746, [4056] = 0x675E, [4057] = 0x6760, [4058] = 0x6759,
  [4059] = 0x6763, [4060] = 0x6764, [4061] = 0x6789, [4062] = 0x6770,
  [4063] = 0x67A9, [4064] = 0x677C, [4065] = 0x676A, [4066] = 0x678C,
  [4067] = 0x678B, [4068] = 0x67A6, [4069] = 0x67A1, [4070] = 0x6785,
  [4071] = 0x67B7, [4072] = 0x67EF, [4073] = 0x67B4, [4074] = 0x67EC,
  [4075] = 0x67B3, [4076] = 0x67E9, [4077] = 0x67B8, [4078] = 0x67E4,
  [4079] = 0x67DE, [4080] = 0x67DD, [4081] = 0x67E2, [4082] = 0x67EE,
  [4083] = 0x67B9, [4084] = 0x67CE, [4085] = 0x67C6, [4086] = 0x67E7,
  [4087] = 0x6A9C, [4088] = 0x681E, [4089] = 0x6846, [4090] = 0x6829,
  [4091] = 0x6840, [4092] = 0x684D, [4093] = 0x6832, [4094] = 0x684E,
  [4096] = 0x68B3, [4097] = 0x682B, [4098] = 0x6859, [4099] = 0x6863,
  [4100] = 0x6877, [4101] = 0x687F, [4102] = 0x689F, [4103] = 0x688F,
  [4104] = 0x68AD, [4105] = 0x6894, [4106] = 0x689D, [4107] = 0x689B,
  [4108] = 0x6883, [4109] = 0x6AAE, [4110] = 0x68B9, [4111] = 0x6874,
  [4112] = 0x68B5, [4113] = 0x68A0, [4114] = 0x68BA, [4115] = 0x690F,
  [4116] = 0x688D, [4117] = 0x687E, [4118] = 0x6901, [4119] = 0x68CA,
  [4120] = 0x6908, [4121] = 0x68D8, [4122] = 0x6922, [4123] = 0x6926,
  [4124] = 0x68E1, [4125] = 0x690C, [4126] = 0x68CD, [4127] = 0x68D4,
  [4128] = 0x68E7, [4129] = 0x68D5, [4130] = 0x6936, [4131] = 0x6912,
  [4132] = 0x6904, [4133] = 0x68D7, [4134] = 0x68E3, [4135] = 0x6925,
  [4136] = 0x68F9, [4137] = 0x68E0, [4138] = 0x68EF, [4139] = 0x6928,
  [4140] = 0x692A, [4141] = 0x691A, [4142] = 0x6923, [4143] = 0x6921,
  [4144] = 0x68C6, [4145] = 0x6979, [4146] = 0x6977, [4147] = 0x695C,
  [4148] = 0x6978, [4149] = 0x696B, [4150] = 0x6954, [4151] = 0x697E,
  [4152] = 0x696E, [4153] = 0x6939, [4154] = 0x6974, [4155] = 0x693D,
  [4156] = 0x6959, [4157] = 0x6930, [4158] = 0x6961, [4159] = 0x695E,
  [4160] = 0x695D, [4161] = 0x6981, [4162] = 0x696A, [4163] = 0x69B2,
  [4164] = 0x69AE, [4165] = 0x69D0, [4166] = 0x69BF, [4167] = 0x69C1,
  [4168] = 0x69D3, [4169] = 0x69BE, [4170] = 0x69CE, [4171] = 0x5BE8,
  [4172] = 0x69CA, [4173] = 0x69DD, [4174] = 0x69BB, [4175] = 0x69C3,
  [4176] = 0x69A7, [4177] = 0x6A2E, [4178] = 0x6991, [4179] = 0x69A0,
  [4180] = 0x699C, [4181] = 0x6995, [4182] = 0x69B4, [4183] = 0x69DE,
  [4184] = 0x69E8, [4185] = 0x6A02, [4186] = 0x6A1B, [4187] = 0x69FF,
  [4188] = 0x6B0A, [4189] = 0x69F9, [4190] = 0x69F2, [4191] = 0x69E7,
  [4192] = 0x6A05, [4193] = 0x69B1, [4194] = 0x6A1E, [4195] = 0x69ED,
  [4196] = 0x6A14, [4197] = 0x69EB, [4198] = 0x6A0A, [4199] = 0x6A12,
  [4200] = 0x6AC1, [4201] = 0x6A23, [4202] = 0x6A13, [4203] = 0x6A44,
  [4204] = 0x6A0C, [4205] = 0x6A72, [4206] = 0x6A36, [4207] = 0x6A78,
  [4208] = 0x6A47, [4209] = 0x6A62, [4210] = 0x6A59, [4211] = 0x6A66,
  [4212] = 0x6A48, [4213] = 0x6A38, [4214] = 0x6A22, [4215] = 0x6A90,
  [4216] = 0x6A8D, [4217] = 0x6AA0, [4218] = 0x6A84, [4219] = 0x6AA2,
  [4220] = 0x6AA3, [4224] = 0x6A97, [4225] = 0x8617, [4226] = 0x6ABB,
  [4227] = 0x6AC3, [4228] = 0x6AC2, [4229] = 0x6AB8, [4230] = 0x6AB3,
  [4231] = 0x6AAC, [4232] = 0x6ADE, [4233] = 0x6AD1, [4234] = 0x6ADF,
  [4235] = 0x6AAA, [4236] = 0x6ADA, [4237] = 0x6AEA, [4238] = 0x6AFB,
  [4239] = 0x6B05, [4240] = 0x8616, [4241] = 0x6AFA, [4242] = 0x6B12,
  [4243] = 0x6B16, [4244] = 0x9B31, [4245] = 0x6B1F, [4246] = 0x6B38,
  [4247] = 0x6B37, [4248] = 0x76DC, [4249] = 0x6B39, [4250] = 0x98EE,
  [4251] = 0x6B47, [4252] = 0x6B43, [4253] = 0x6B49, [4254] = 0x6B50,
  [4255] = 0x6B59, [4256] = 0x6B54, [4257] = 0x6B5B, [4258] = 0x6B5F,
  [4259] = 0x6B61, [4260] = 0x6B78, [4261] = 0x6B79, [4262] = 0x6B7F,
  [4263] = 0x6B80, [4264] = 0x6B84, [4265] = 0x6B83, [4266] = 0x6B8D,
  [4267] = 0x6B98, [4268] = 0x6B95, [4269] = 0x6B9E, [4270] = 0x6BA4,
  [4271] = 0x6BAA, [4272] = 0x6BAB, [4273] = 0x6BAF, [4274] = 0x6BB2,
  [4275] = 0x6BB1, [4276] = 0x6BB3, [4277] = 0x6BB7, [4278] = 0x6BBC,
  [4279] = 0x6BC6, [4280] = 0x6BCB, [4281] = 0x6BD3, [4282] = 0x6BDF,
  [4283] = 0x6BEC, [4284] = 0x6BEB, [4285] = 0x6BF3, [4286] = 0x6BEF,
  [4288] = 0x9EBE, [4289] = 0x6C08, [4290] = 0x6C13, [4291] = 0x6C14,
  [4292] = 0x6C1B, [4293] = 0x6C24, [4294] = 0x6C23, [4295] = 0x6C5E,
  [4296] = 0x6C55, [4297] = 0x6C62, [4298] = 0x6C6A, [4299] = 0x6C82,
  [4300] = 0x6C8D, [4301] = 0x6C9A, [4302] = 0x6C81, [4303] = 0x6C9B,
  [4304] = 0x6C7E, [4305] = 0x6C68, [4306] = 0x6C73, [4307] = 0x6C92,
  [4308] = 0x6C90, [4309] = 0x6CC4, [4310] = 0x6CF1, [4311] = 0x6CD3,
  [4312] = 0x6CBD, [4313] = 0x6CD7, [4314] = 0x6CC5, [4315] = 0x6CDD,
  [4316] = 0x6CAE, [4317] = 0x6CB1, [4318] = 0x6CBE, [4319] = 0x6CBA,
  [4320] = 0x6CDB, [4321] = 0x6CEF, [4322] = 0x6CD9, [4323] = 0x6CEA,
  [4324] = 0x6D1F, [4325] = 0x884D, [4326] = 0x6D36, [4327] = 0x6D2B,
  [4328] = 0x6D3D, [4329] = 0x6D38, [4330] = 0x6D19, [4331] = 0x6D35,
  [4332] = 0x6D33, [4333] = 0x6D12, [4334] = 0x6D0C, [4335] = 0x6D63,
  [4336] = 0x6D93, [4337] = 0x6D64, [4338] = 0x6D5A, [4339] = 0x6D79,
  [4340] = 0x6D59, [4341] = 0x6D8E, [4342] = 0x6D95, [4343] = 0x6FE4,
  [4344] = 0x6D85, [4345] = 0x6DF9, [4346] = 0x6E15, [4347] = 0x6E0A,
  [4348] = 0x6DB5, [4349] = 0x6DC7, [4350] = 0x6DE6, [4351] = 0x6DB8,
  [4352] = 0x6DC6, [4353] = 0x6DEC, [4354] = 0x6DDE, [4355] = 0x6DCC,
  [4356] = 0x6DE8, [4357] = 0x6DD2, [4358] = 0x6DC5, [4359] = 0x6DFA,
  [4360] = 0x6DD9, [4361] = 0x6DE4, [4362] = 0x6DD5, [4363] = 0x6DEA,
  [4364] = 0x6DEE, [4365] = 0x6E2D, [4366] = 0x6E6E, [4367] = 0x6E2E,
  [4368] = 0x6E19, [4369] = 0x6E72, [4370] = 0x6E5F, [4371] = 0x6E3E,
  [4372] = 0x6E23, [4373] = 0x6E6B, [4374] = 0x6E2B, [4375] = 0x6E76,
  [4376] = 0x6E4D, [4377] = 0x6E1F, [4378] = 0x6E43, [4379] = 0x6E3A,
  [4380] = 0x6E4E, [4381] = 0x6E24, [4382] = 0x6EFF, [4383] = 0x6E1D,
  [4384] = 0x6E38, [4385] = 0x6E82, [4386] = 0x6EAA, [4387] = 0x6E98,
  [4388] = 0x6EC9, [4389] = 0x6EB7, [4390] = 0x6ED3, [4391] = 0x6EBD,
  [4392] = 0x6EAF, [4393] = 0x6EC4, [4394] = 0x6EB2, [4395] = 0x6ED4,
  [4396] = 0x6ED5, [4397] = 0x6E8F, [4398] = 0x6EA5, [4399] = 0x6EC2,
  [4400] = 0x6E9F, [4401] = 0x6F41, [4402] = 0x6F11, [4403] = 0x704C,
  [4404] = 0x6EEC, [4405] = 0x6EF8, [4406] = 0x6EFE, [4407] = 0x6F3F,
  [4408] = 0x6EF2, [4409] = 0x6F31, [4410] = 0x6EEF, [4411] = 0x6F32,
  [4412] = 0x6ECC
};


/* The following table can be generated from the file
	unix/mappings/eastasia/jis/shiftjis.txt
   from the Unicode CD (also available on their FTP server) using
   the command

	egrep '^0x[eE][[:xdigit:]][[:xdigit:]][[:xdigit:]]' \
	  /mnt/cdrom/unix/mappings/eastasia/jis/shiftjis.txt | perl ~/sjis.pl

   where sjis.pl contains:

  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  $n = 0;
  while (<>) {
    local($sjis, $ucs, %rest) = split;
    $sjis = hex($sjis) - 0xe040;
    local($sidx) = int($sjis / 256) * 192 + ($sjis % 256);
    printf "\n " if (($n % 4) == 0);
    ++$n;
    printf " [%4d] = %s,", $sidx, $ucs;
  }
  print "\n";
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static const uint16_t cjk_block4[2021] =
{
  [   0] = 0x6F3E, [   1] = 0x6F13, [   2] = 0x6EF7, [   3] = 0x6F86,
  [   4] = 0x6F7A, [   5] = 0x6F78, [   6] = 0x6F81, [   7] = 0x6F80,
  [   8] = 0x6F6F, [   9] = 0x6F5B, [  10] = 0x6FF3, [  11] = 0x6F6D,
  [  12] = 0x6F82, [  13] = 0x6F7C, [  14] = 0x6F58, [  15] = 0x6F8E,
  [  16] = 0x6F91, [  17] = 0x6FC2, [  18] = 0x6F66, [  19] = 0x6FB3,
  [  20] = 0x6FA3, [  21] = 0x6FA1, [  22] = 0x6FA4, [  23] = 0x6FB9,
  [  24] = 0x6FC6, [  25] = 0x6FAA, [  26] = 0x6FDF, [  27] = 0x6FD5,
  [  28] = 0x6FEC, [  29] = 0x6FD4, [  30] = 0x6FD8, [  31] = 0x6FF1,
  [  32] = 0x6FEE, [  33] = 0x6FDB, [  34] = 0x7009, [  35] = 0x700B,
  [  36] = 0x6FFA, [  37] = 0x7011, [  38] = 0x7001, [  39] = 0x700F,
  [  40] = 0x6FFE, [  41] = 0x701B, [  42] = 0x701A, [  43] = 0x6F74,
  [  44] = 0x701D, [  45] = 0x7018, [  46] = 0x701F, [  47] = 0x7030,
  [  48] = 0x703E, [  49] = 0x7032, [  50] = 0x7051, [  51] = 0x7063,
  [  52] = 0x7099, [  53] = 0x7092, [  54] = 0x70AF, [  55] = 0x70F1,
  [  56] = 0x70AC, [  57] = 0x70B8, [  58] = 0x70B3, [  59] = 0x70AE,
  [  60] = 0x70DF, [  61] = 0x70CB, [  62] = 0x70DD, [  64] = 0x70D9,
  [  65] = 0x7109, [  66] = 0x70FD, [  67] = 0x711C, [  68] = 0x7119,
  [  69] = 0x7165, [  70] = 0x7155, [  71] = 0x7188, [  72] = 0x7166,
  [  73] = 0x7162, [  74] = 0x714C, [  75] = 0x7156, [  76] = 0x716C,
  [  77] = 0x718F, [  78] = 0x71FB, [  79] = 0x7184, [  80] = 0x7195,
  [  81] = 0x71A8, [  82] = 0x71AC, [  83] = 0x71D7, [  84] = 0x71B9,
  [  85] = 0x71BE, [  86] = 0x71D2, [  87] = 0x71C9, [  88] = 0x71D4,
  [  89] = 0x71CE, [  90] = 0x71E0, [  91] = 0x71EC, [  92] = 0x71E7,
  [  93] = 0x71F5, [  94] = 0x71FC, [  95] = 0x71F9, [  96] = 0x71FF,
  [  97] = 0x720D, [  98] = 0x7210, [  99] = 0x721B, [ 100] = 0x7228,
  [ 101] = 0x722D, [ 102] = 0x722C, [ 103] = 0x7230, [ 104] = 0x7232,
  [ 105] = 0x723B, [ 106] = 0x723C, [ 107] = 0x723F, [ 108] = 0x7240,
  [ 109] = 0x7246, [ 110] = 0x724B, [ 111] = 0x7258, [ 112] = 0x7274,
  [ 113] = 0x727E, [ 114] = 0x7282, [ 115] = 0x7281, [ 116] = 0x7287,
  [ 117] = 0x7292, [ 118] = 0x7296, [ 119] = 0x72A2, [ 120] = 0x72A7,
  [ 121] = 0x72B9, [ 122] = 0x72B2, [ 123] = 0x72C3, [ 124] = 0x72C6,
  [ 125] = 0x72C4, [ 126] = 0x72CE, [ 127] = 0x72D2, [ 128] = 0x72E2,
  [ 129] = 0x72E0, [ 130] = 0x72E1, [ 131] = 0x72F9, [ 132] = 0x72F7,
  [ 133] = 0x500F, [ 134] = 0x7317, [ 135] = 0x730A, [ 136] = 0x731C,
  [ 137] = 0x7316, [ 138] = 0x731D, [ 139] = 0x7334, [ 140] = 0x732F,
  [ 141] = 0x7329, [ 142] = 0x7325, [ 143] = 0x733E, [ 144] = 0x734E,
  [ 145] = 0x734F, [ 146] = 0x9ED8, [ 147] = 0x7357, [ 148] = 0x736A,
  [ 149] = 0x7368, [ 150] = 0x7370, [ 151] = 0x7378, [ 152] = 0x7375,
  [ 153] = 0x737B, [ 154] = 0x737A, [ 155] = 0x73C8, [ 156] = 0x73B3,
  [ 157] = 0x73CE, [ 158] = 0x73BB, [ 159] = 0x73C0, [ 160] = 0x73E5,
  [ 161] = 0x73EE, [ 162] = 0x73DE, [ 163] = 0x74A2, [ 164] = 0x7405,
  [ 165] = 0x746F, [ 166] = 0x7425, [ 167] = 0x73F8, [ 168] = 0x7432,
  [ 169] = 0x743A, [ 170] = 0x7455, [ 171] = 0x743F, [ 172] = 0x745F,
  [ 173] = 0x7459, [ 174] = 0x7441, [ 175] = 0x745C, [ 176] = 0x7469,
  [ 177] = 0x7470, [ 178] = 0x7463, [ 179] = 0x746A, [ 180] = 0x7476,
  [ 181] = 0x747E, [ 182] = 0x748B, [ 183] = 0x749E, [ 184] = 0x74A7,
  [ 185] = 0x74CA, [ 186] = 0x74CF, [ 187] = 0x74D4, [ 188] = 0x73F1,
  [ 192] = 0x74E0, [ 193] = 0x74E3, [ 194] = 0x74E7, [ 195] = 0x74E9,
  [ 196] = 0x74EE, [ 197] = 0x74F2, [ 198] = 0x74F0, [ 199] = 0x74F1,
  [ 200] = 0x74F8, [ 201] = 0x74F7, [ 202] = 0x7504, [ 203] = 0x7503,
  [ 204] = 0x7505, [ 205] = 0x750C, [ 206] = 0x750E, [ 207] = 0x750D,
  [ 208] = 0x7515, [ 209] = 0x7513, [ 210] = 0x751E, [ 211] = 0x7526,
  [ 212] = 0x752C, [ 213] = 0x753C, [ 214] = 0x7544, [ 215] = 0x754D,
  [ 216] = 0x754A, [ 217] = 0x7549, [ 218] = 0x755B, [ 219] = 0x7546,
  [ 220] = 0x755A, [ 221] = 0x7569, [ 222] = 0x7564, [ 223] = 0x7567,
  [ 224] = 0x756B, [ 225] = 0x756D, [ 226] = 0x7578, [ 227] = 0x7576,
  [ 228] = 0x7586, [ 229] = 0x7587, [ 230] = 0x7574, [ 231] = 0x758A,
  [ 232] = 0x7589, [ 233] = 0x7582, [ 234] = 0x7594, [ 235] = 0x759A,
  [ 236] = 0x759D, [ 237] = 0x75A5, [ 238] = 0x75A3, [ 239] = 0x75C2,
  [ 240] = 0x75B3, [ 241] = 0x75C3, [ 242] = 0x75B5, [ 243] = 0x75BD,
  [ 244] = 0x75B8, [ 245] = 0x75BC, [ 246] = 0x75B1, [ 247] = 0x75CD,
  [ 248] = 0x75CA, [ 249] = 0x75D2, [ 250] = 0x75D9, [ 251] = 0x75E3,
  [ 252] = 0x75DE, [ 253] = 0x75FE, [ 254] = 0x75FF, [ 256] = 0x75FC,
  [ 257] = 0x7601, [ 258] = 0x75F0, [ 259] = 0x75FA, [ 260] = 0x75F2,
  [ 261] = 0x75F3, [ 262] = 0x760B, [ 263] = 0x760D, [ 264] = 0x7609,
  [ 265] = 0x761F, [ 266] = 0x7627, [ 267] = 0x7620, [ 268] = 0x7621,
  [ 269] = 0x7622, [ 270] = 0x7624, [ 271] = 0x7634, [ 272] = 0x7630,
  [ 273] = 0x763B, [ 274] = 0x7647, [ 275] = 0x7648, [ 276] = 0x7646,
  [ 277] = 0x765C, [ 278] = 0x7658, [ 279] = 0x7661, [ 280] = 0x7662,
  [ 281] = 0x7668, [ 282] = 0x7669, [ 283] = 0x766A, [ 284] = 0x7667,
  [ 285] = 0x766C, [ 286] = 0x7670, [ 287] = 0x7672, [ 288] = 0x7676,
  [ 289] = 0x7678, [ 290] = 0x767C, [ 291] = 0x7680, [ 292] = 0x7683,
  [ 293] = 0x7688, [ 294] = 0x768B, [ 295] = 0x768E, [ 296] = 0x7696,
  [ 297] = 0x7693, [ 298] = 0x7699, [ 299] = 0x769A, [ 300] = 0x76B0,
  [ 301] = 0x76B4, [ 302] = 0x76B8, [ 303] = 0x76B9, [ 304] = 0x76BA,
  [ 305] = 0x76C2, [ 306] = 0x76CD, [ 307] = 0x76D6, [ 308] = 0x76D2,
  [ 309] = 0x76DE, [ 310] = 0x76E1, [ 311] = 0x76E5, [ 312] = 0x76E7,
  [ 313] = 0x76EA, [ 314] = 0x862F, [ 315] = 0x76FB, [ 316] = 0x7708,
  [ 317] = 0x7707, [ 318] = 0x7704, [ 319] = 0x7729, [ 320] = 0x7724,
  [ 321] = 0x771E, [ 322] = 0x7725, [ 323] = 0x7726, [ 324] = 0x771B,
  [ 325] = 0x7737, [ 326] = 0x7738, [ 327] = 0x7747, [ 328] = 0x775A,
  [ 329] = 0x7768, [ 330] = 0x776B, [ 331] = 0x775B, [ 332] = 0x7765,
  [ 333] = 0x777F, [ 334] = 0x777E, [ 335] = 0x7779, [ 336] = 0x778E,
  [ 337] = 0x778B, [ 338] = 0x7791, [ 339] = 0x77A0, [ 340] = 0x779E,
  [ 341] = 0x77B0, [ 342] = 0x77B6, [ 343] = 0x77B9, [ 344] = 0x77BF,
  [ 345] = 0x77BC, [ 346] = 0x77BD, [ 347] = 0x77BB, [ 348] = 0x77C7,
  [ 349] = 0x77CD, [ 350] = 0x77D7, [ 351] = 0x77DA, [ 352] = 0x77DC,
  [ 353] = 0x77E3, [ 354] = 0x77EE, [ 355] = 0x77FC, [ 356] = 0x780C,
  [ 357] = 0x7812, [ 358] = 0x7926, [ 359] = 0x7820, [ 360] = 0x792A,
  [ 361] = 0x7845, [ 362] = 0x788E, [ 363] = 0x7874, [ 364] = 0x7886,
  [ 365] = 0x787C, [ 366] = 0x789A, [ 367] = 0x788C, [ 368] = 0x78A3,
  [ 369] = 0x78B5, [ 370] = 0x78AA, [ 371] = 0x78AF, [ 372] = 0x78D1,
  [ 373] = 0x78C6, [ 374] = 0x78CB, [ 375] = 0x78D4, [ 376] = 0x78BE,
  [ 377] = 0x78BC, [ 378] = 0x78C5, [ 379] = 0x78CA, [ 380] = 0x78EC,
  [ 384] = 0x78E7, [ 385] = 0x78DA, [ 386] = 0x78FD, [ 387] = 0x78F4,
  [ 388] = 0x7907, [ 389] = 0x7912, [ 390] = 0x7911, [ 391] = 0x7919,
  [ 392] = 0x792C, [ 393] = 0x792B, [ 394] = 0x7940, [ 395] = 0x7960,
  [ 396] = 0x7957, [ 397] = 0x795F, [ 398] = 0x795A, [ 399] = 0x7955,
  [ 400] = 0x7953, [ 401] = 0x797A, [ 402] = 0x797F, [ 403] = 0x798A,
  [ 404] = 0x799D, [ 405] = 0x79A7, [ 406] = 0x9F4B, [ 407] = 0x79AA,
  [ 408] = 0x79AE, [ 409] = 0x79B3, [ 410] = 0x79B9, [ 411] = 0x79BA,
  [ 412] = 0x79C9, [ 413] = 0x79D5, [ 414] = 0x79E7, [ 415] = 0x79EC,
  [ 416] = 0x79E1, [ 417] = 0x79E3, [ 418] = 0x7A08, [ 419] = 0x7A0D,
  [ 420] = 0x7A18, [ 421] = 0x7A19, [ 422] = 0x7A20, [ 423] = 0x7A1F,
  [ 424] = 0x7980, [ 425] = 0x7A31, [ 426] = 0x7A3B, [ 427] = 0x7A3E,
  [ 428] = 0x7A37, [ 429] = 0x7A43, [ 430] = 0x7A57, [ 431] = 0x7A49,
  [ 432] = 0x7A61, [ 433] = 0x7A62, [ 434] = 0x7A69, [ 435] = 0x9F9D,
  [ 436] = 0x7A70, [ 437] = 0x7A79, [ 438] = 0x7A7D, [ 439] = 0x7A88,
  [ 440] = 0x7A97, [ 441] = 0x7A95, [ 442] = 0x7A98, [ 443] = 0x7A96,
  [ 444] = 0x7AA9, [ 445] = 0x7AC8, [ 446] = 0x7AB0, [ 448] = 0x7AB6,
  [ 449] = 0x7AC5, [ 450] = 0x7AC4, [ 451] = 0x7ABF, [ 452] = 0x9083,
  [ 453] = 0x7AC7, [ 454] = 0x7ACA, [ 455] = 0x7ACD, [ 456] = 0x7ACF,
  [ 457] = 0x7AD5, [ 458] = 0x7AD3, [ 459] = 0x7AD9, [ 460] = 0x7ADA,
  [ 461] = 0x7ADD, [ 462] = 0x7AE1, [ 463] = 0x7AE2, [ 464] = 0x7AE6,
  [ 465] = 0x7AED, [ 466] = 0x7AF0, [ 467] = 0x7B02, [ 468] = 0x7B0F,
  [ 469] = 0x7B0A, [ 470] = 0x7B06, [ 471] = 0x7B33, [ 472] = 0x7B18,
  [ 473] = 0x7B19, [ 474] = 0x7B1E, [ 475] = 0x7B35, [ 476] = 0x7B28,
  [ 477] = 0x7B36, [ 478] = 0x7B50, [ 479] = 0x7B7A, [ 480] = 0x7B04,
  [ 481] = 0x7B4D, [ 482] = 0x7B0B, [ 483] = 0x7B4C, [ 484] = 0x7B45,
  [ 485] = 0x7B75, [ 486] = 0x7B65, [ 487] = 0x7B74, [ 488] = 0x7B67,
  [ 489] = 0x7B70, [ 490] = 0x7B71, [ 491] = 0x7B6C, [ 492] = 0x7B6E,
  [ 493] = 0x7B9D, [ 494] = 0x7B98, [ 495] = 0x7B9F, [ 496] = 0x7B8D,
  [ 497] = 0x7B9C, [ 498] = 0x7B9A, [ 499] = 0x7B8B, [ 500] = 0x7B92,
  [ 501] = 0x7B8F, [ 502] = 0x7B5D, [ 503] = 0x7B99, [ 504] = 0x7BCB,
  [ 505] = 0x7BC1, [ 506] = 0x7BCC, [ 507] = 0x7BCF, [ 508] = 0x7BB4,
  [ 509] = 0x7BC6, [ 510] = 0x7BDD, [ 511] = 0x7BE9, [ 512] = 0x7C11,
  [ 513] = 0x7C14, [ 514] = 0x7BE6, [ 515] = 0x7BE5, [ 516] = 0x7C60,
  [ 517] = 0x7C00, [ 518] = 0x7C07, [ 519] = 0x7C13, [ 520] = 0x7BF3,
  [ 521] = 0x7BF7, [ 522] = 0x7C17, [ 523] = 0x7C0D, [ 524] = 0x7BF6,
  [ 525] = 0x7C23, [ 526] = 0x7C27, [ 527] = 0x7C2A, [ 528] = 0x7C1F,
  [ 529] = 0x7C37, [ 530] = 0x7C2B, [ 531] = 0x7C3D, [ 532] = 0x7C4C,
  [ 533] = 0x7C43, [ 534] = 0x7C54, [ 535] = 0x7C4F, [ 536] = 0x7C40,
  [ 537] = 0x7C50, [ 538] = 0x7C58, [ 539] = 0x7C5F, [ 540] = 0x7C64,
  [ 541] = 0x7C56, [ 542] = 0x7C65, [ 543] = 0x7C6C, [ 544] = 0x7C75,
  [ 545] = 0x7C83, [ 546] = 0x7C90, [ 547] = 0x7CA4, [ 548] = 0x7CAD,
  [ 549] = 0x7CA2, [ 550] = 0x7CAB, [ 551] = 0x7CA1, [ 552] = 0x7CA8,
  [ 553] = 0x7CB3, [ 554] = 0x7CB2, [ 555] = 0x7CB1, [ 556] = 0x7CAE,
  [ 557] = 0x7CB9, [ 558] = 0x7CBD, [ 559] = 0x7CC0, [ 560] = 0x7CC5,
  [ 561] = 0x7CC2, [ 562] = 0x7CD8, [ 563] = 0x7CD2, [ 564] = 0x7CDC,
  [ 565] = 0x7CE2, [ 566] = 0x9B3B, [ 567] = 0x7CEF, [ 568] = 0x7CF2,
  [ 569] = 0x7CF4, [ 570] = 0x7CF6, [ 571] = 0x7CFA, [ 572] = 0x7D06,
  [ 576] = 0x7D02, [ 577] = 0x7D1C, [ 578] = 0x7D15, [ 579] = 0x7D0A,
  [ 580] = 0x7D45, [ 581] = 0x7D4B, [ 582] = 0x7D2E, [ 583] = 0x7D32,
  [ 584] = 0x7D3F, [ 585] = 0x7D35, [ 586] = 0x7D46, [ 587] = 0x7D73,
  [ 588] = 0x7D56, [ 589] = 0x7D4E, [ 590] = 0x7D72, [ 591] = 0x7D68,
  [ 592] = 0x7D6E, [ 593] = 0x7D4F, [ 594] = 0x7D63, [ 595] = 0x7D93,
  [ 596] = 0x7D89, [ 597] = 0x7D5B, [ 598] = 0x7D8F, [ 599] = 0x7D7D,
  [ 600] = 0x7D9B, [ 601] = 0x7DBA, [ 602] = 0x7DAE, [ 603] = 0x7DA3,
  [ 604] = 0x7DB5, [ 605] = 0x7DC7, [ 606] = 0x7DBD, [ 607] = 0x7DAB,
  [ 608] = 0x7E3D, [ 609] = 0x7DA2, [ 610] = 0x7DAF, [ 611] = 0x7DDC,
  [ 612] = 0x7DB8, [ 613] = 0x7D9F, [ 614] = 0x7DB0, [ 615] = 0x7DD8,
  [ 616] = 0x7DDD, [ 617] = 0x7DE4, [ 618] = 0x7DDE, [ 619] = 0x7DFB,
  [ 620] = 0x7DF2, [ 621] = 0x7DE1, [ 622] = 0x7E05, [ 623] = 0x7E0A,
  [ 624] = 0x7E23, [ 625] = 0x7E21, [ 626] = 0x7E12, [ 627] = 0x7E31,
  [ 628] = 0x7E1F, [ 629] = 0x7E09, [ 630] = 0x7E0B, [ 631] = 0x7E22,
  [ 632] = 0x7E46, [ 633] = 0x7E66, [ 634] = 0x7E3B, [ 635] = 0x7E35,
  [ 636] = 0x7E39, [ 637] = 0x7E43, [ 638] = 0x7E37, [ 640] = 0x7E32,
  [ 641] = 0x7E3A, [ 642] = 0x7E67, [ 643] = 0x7E5D, [ 644] = 0x7E56,
  [ 645] = 0x7E5E, [ 646] = 0x7E59, [ 647] = 0x7E5A, [ 648] = 0x7E79,
  [ 649] = 0x7E6A, [ 650] = 0x7E69, [ 651] = 0x7E7C, [ 652] = 0x7E7B,
  [ 653] = 0x7E83, [ 654] = 0x7DD5, [ 655] = 0x7E7D, [ 656] = 0x8FAE,
  [ 657] = 0x7E7F, [ 658] = 0x7E88, [ 659] = 0x7E89, [ 660] = 0x7E8C,
  [ 661] = 0x7E92, [ 662] = 0x7E90, [ 663] = 0x7E93, [ 664] = 0x7E94,
  [ 665] = 0x7E96, [ 666] = 0x7E8E, [ 667] = 0x7E9B, [ 668] = 0x7E9C,
  [ 669] = 0x7F38, [ 670] = 0x7F3A, [ 671] = 0x7F45, [ 672] = 0x7F4C,
  [ 673] = 0x7F4D, [ 674] = 0x7F4E, [ 675] = 0x7F50, [ 676] = 0x7F51,
  [ 677] = 0x7F55, [ 678] = 0x7F54, [ 679] = 0x7F58, [ 680] = 0x7F5F,
  [ 681] = 0x7F60, [ 682] = 0x7F68, [ 683] = 0x7F69, [ 684] = 0x7F67,
  [ 685] = 0x7F78, [ 686] = 0x7F82, [ 687] = 0x7F86, [ 688] = 0x7F83,
  [ 689] = 0x7F88, [ 690] = 0x7F87, [ 691] = 0x7F8C, [ 692] = 0x7F94,
  [ 693] = 0x7F9E, [ 694] = 0x7F9D, [ 695] = 0x7F9A, [ 696] = 0x7FA3,
  [ 697] = 0x7FAF, [ 698] = 0x7FB2, [ 699] = 0x7FB9, [ 700] = 0x7FAE,
  [ 701] = 0x7FB6, [ 702] = 0x7FB8, [ 703] = 0x8B71, [ 704] = 0x7FC5,
  [ 705] = 0x7FC6, [ 706] = 0x7FCA, [ 707] = 0x7FD5, [ 708] = 0x7FD4,
  [ 709] = 0x7FE1, [ 710] = 0x7FE6, [ 711] = 0x7FE9, [ 712] = 0x7FF3,
  [ 713] = 0x7FF9, [ 714] = 0x98DC, [ 715] = 0x8006, [ 716] = 0x8004,
  [ 717] = 0x800B, [ 718] = 0x8012, [ 719] = 0x8018, [ 720] = 0x8019,
  [ 721] = 0x801C, [ 722] = 0x8021, [ 723] = 0x8028, [ 724] = 0x803F,
  [ 725] = 0x803B, [ 726] = 0x804A, [ 727] = 0x8046, [ 728] = 0x8052,
  [ 729] = 0x8058, [ 730] = 0x805A, [ 731] = 0x805F, [ 732] = 0x8062,
  [ 733] = 0x8068, [ 734] = 0x8073, [ 735] = 0x8072, [ 736] = 0x8070,
  [ 737] = 0x8076, [ 738] = 0x8079, [ 739] = 0x807D, [ 740] = 0x807F,
  [ 741] = 0x8084, [ 742] = 0x8086, [ 743] = 0x8085, [ 744] = 0x809B,
  [ 745] = 0x8093, [ 746] = 0x809A, [ 747] = 0x80AD, [ 748] = 0x5190,
  [ 749] = 0x80AC, [ 750] = 0x80DB, [ 751] = 0x80E5, [ 752] = 0x80D9,
  [ 753] = 0x80DD, [ 754] = 0x80C4, [ 755] = 0x80DA, [ 756] = 0x80D6,
  [ 757] = 0x8109, [ 758] = 0x80EF, [ 759] = 0x80F1, [ 760] = 0x811B,
  [ 761] = 0x8129, [ 762] = 0x8123, [ 763] = 0x812F, [ 764] = 0x814B,
  [ 768] = 0x968B, [ 769] = 0x8146, [ 770] = 0x813E, [ 771] = 0x8153,
  [ 772] = 0x8151, [ 773] = 0x80FC, [ 774] = 0x8171, [ 775] = 0x816E,
  [ 776] = 0x8165, [ 777] = 0x8166, [ 778] = 0x8174, [ 779] = 0x8183,
  [ 780] = 0x8188, [ 781] = 0x818A, [ 782] = 0x8180, [ 783] = 0x8182,
  [ 784] = 0x81A0, [ 785] = 0x8195, [ 786] = 0x81A4, [ 787] = 0x81A3,
  [ 788] = 0x815F, [ 789] = 0x8193, [ 790] = 0x81A9, [ 791] = 0x81B0,
  [ 792] = 0x81B5, [ 793] = 0x81BE, [ 794] = 0x81B8, [ 795] = 0x81BD,
  [ 796] = 0x81C0, [ 797] = 0x81C2, [ 798] = 0x81BA, [ 799] = 0x81C9,
  [ 800] = 0x81CD, [ 801] = 0x81D1, [ 802] = 0x81D9, [ 803] = 0x81D8,
  [ 804] = 0x81C8, [ 805] = 0x81DA, [ 806] = 0x81DF, [ 807] = 0x81E0,
  [ 808] = 0x81E7, [ 809] = 0x81FA, [ 810] = 0x81FB, [ 811] = 0x81FE,
  [ 812] = 0x8201, [ 813] = 0x8202, [ 814] = 0x8205, [ 815] = 0x8207,
  [ 816] = 0x820A, [ 817] = 0x820D, [ 818] = 0x8210, [ 819] = 0x8216,
  [ 820] = 0x8229, [ 821] = 0x822B, [ 822] = 0x8238, [ 823] = 0x8233,
  [ 824] = 0x8240, [ 825] = 0x8259, [ 826] = 0x8258, [ 827] = 0x825D,
  [ 828] = 0x825A, [ 829] = 0x825F, [ 830] = 0x8264, [ 832] = 0x8262,
  [ 833] = 0x8268, [ 834] = 0x826A, [ 835] = 0x826B, [ 836] = 0x822E,
  [ 837] = 0x8271, [ 838] = 0x8277, [ 839] = 0x8278, [ 840] = 0x827E,
  [ 841] = 0x828D, [ 842] = 0x8292, [ 843] = 0x82AB, [ 844] = 0x829F,
  [ 845] = 0x82BB, [ 846] = 0x82AC, [ 847] = 0x82E1, [ 848] = 0x82E3,
  [ 849] = 0x82DF, [ 850] = 0x82D2, [ 851] = 0x82F4, [ 852] = 0x82F3,
  [ 853] = 0x82FA, [ 854] = 0x8393, [ 855] = 0x8303, [ 856] = 0x82FB,
  [ 857] = 0x82F9, [ 858] = 0x82DE, [ 859] = 0x8306, [ 860] = 0x82DC,
  [ 861] = 0x8309, [ 862] = 0x82D9, [ 863] = 0x8335, [ 864] = 0x8334,
  [ 865] = 0x8316, [ 866] = 0x8332, [ 867] = 0x8331, [ 868] = 0x8340,
  [ 869] = 0x8339, [ 870] = 0x8350, [ 871] = 0x8345, [ 872] = 0x832F,
  [ 873] = 0x832B, [ 874] = 0x8317, [ 875] = 0x8318, [ 876] = 0x8385,
  [ 877] = 0x839A, [ 878] = 0x83AA, [ 879] = 0x839F, [ 880] = 0x83A2,
  [ 881] = 0x8396, [ 882] = 0x8323, [ 883] = 0x838E, [ 884] = 0x8387,
  [ 885] = 0x838A, [ 886] = 0x837C, [ 887] = 0x83B5, [ 888] = 0x8373,
  [ 889] = 0x8375, [ 890] = 0x83A0, [ 891] = 0x8389, [ 892] = 0x83A8,
  [ 893] = 0x83F4, [ 894] = 0x8413, [ 895] = 0x83EB, [ 896] = 0x83CE,
  [ 897] = 0x83FD, [ 898] = 0x8403, [ 899] = 0x83D8, [ 900] = 0x840B,
  [ 901] = 0x83C1, [ 902] = 0x83F7, [ 903] = 0x8407, [ 904] = 0x83E0,
  [ 905] = 0x83F2, [ 906] = 0x840D, [ 907] = 0x8422, [ 908] = 0x8420,
  [ 909] = 0x83BD, [ 910] = 0x8438, [ 911] = 0x8506, [ 912] = 0x83FB,
  [ 913] = 0x846D, [ 914] = 0x842A, [ 915] = 0x843C, [ 916] = 0x855A,
  [ 917] = 0x8484, [ 918] = 0x8477, [ 919] = 0x846B, [ 920] = 0x84AD,
  [ 921] = 0x846E, [ 922] = 0x8482, [ 923] = 0x8469, [ 924] = 0x8446,
  [ 925] = 0x842C, [ 926] = 0x846F, [ 927] = 0x8479, [ 928] = 0x8435,
  [ 929] = 0x84CA, [ 930] = 0x8462, [ 931] = 0x84B9, [ 932] = 0x84BF,
  [ 933] = 0x849F, [ 934] = 0x84D9, [ 935] = 0x84CD, [ 936] = 0x84BB,
  [ 937] = 0x84DA, [ 938] = 0x84D0, [ 939] = 0x84C1, [ 940] = 0x84C6,
  [ 941] = 0x84D6, [ 942] = 0x84A1, [ 943] = 0x8521, [ 944] = 0x84FF,
  [ 945] = 0x84F4, [ 946] = 0x8517, [ 947] = 0x8518, [ 948] = 0x852C,
  [ 949] = 0x851F, [ 950] = 0x8515, [ 951] = 0x8514, [ 952] = 0x84FC,
  [ 953] = 0x8540, [ 954] = 0x8563, [ 955] = 0x8558, [ 956] = 0x8548,
  [ 960] = 0x8541, [ 961] = 0x8602, [ 962] = 0x854B, [ 963] = 0x8555,
  [ 964] = 0x8580, [ 965] = 0x85A4, [ 966] = 0x8588, [ 967] = 0x8591,
  [ 968] = 0x858A, [ 969] = 0x85A8, [ 970] = 0x856D, [ 971] = 0x8594,
  [ 972] = 0x859B, [ 973] = 0x85EA, [ 974] = 0x8587, [ 975] = 0x859C,
  [ 976] = 0x8577, [ 977] = 0x857E, [ 978] = 0x8590, [ 979] = 0x85C9,
  [ 980] = 0x85BA, [ 981] = 0x85CF, [ 982] = 0x85B9, [ 983] = 0x85D0,
  [ 984] = 0x85D5, [ 985] = 0x85DD, [ 986] = 0x85E5, [ 987] = 0x85DC,
  [ 988] = 0x85F9, [ 989] = 0x860A, [ 990] = 0x8613, [ 991] = 0x860B,
  [ 992] = 0x85FE, [ 993] = 0x85FA, [ 994] = 0x8606, [ 995] = 0x8622,
  [ 996] = 0x861A, [ 997] = 0x8630, [ 998] = 0x863F, [ 999] = 0x864D,
  [1000] = 0x4E55, [1001] = 0x8654, [1002] = 0x865F, [1003] = 0x8667,
  [1004] = 0x8671, [1005] = 0x8693, [1006] = 0x86A3, [1007] = 0x86A9,
  [1008] = 0x86AA, [1009] = 0x868B, [1010] = 0x868C, [1011] = 0x86B6,
  [1012] = 0x86AF, [1013] = 0x86C4, [1014] = 0x86C6, [1015] = 0x86B0,
  [1016] = 0x86C9, [1017] = 0x8823, [1018] = 0x86AB, [1019] = 0x86D4,
  [1020] = 0x86DE, [1021] = 0x86E9, [1022] = 0x86EC, [1024] = 0x86DF,
  [1025] = 0x86DB, [1026] = 0x86EF, [1027] = 0x8712, [1028] = 0x8706,
  [1029] = 0x8708, [1030] = 0x8700, [1031] = 0x8703, [1032] = 0x86FB,
  [1033] = 0x8711, [1034] = 0x8709, [1035] = 0x870D, [1036] = 0x86F9,
  [1037] = 0x870A, [1038] = 0x8734, [1039] = 0x873F, [1040] = 0x8737,
  [1041] = 0x873B, [1042] = 0x8725, [1043] = 0x8729, [1044] = 0x871A,
  [1045] = 0x8760, [1046] = 0x875F, [1047] = 0x8778, [1048] = 0x874C,
  [1049] = 0x874E, [1050] = 0x8774, [1051] = 0x8757, [1052] = 0x8768,
  [1053] = 0x876E, [1054] = 0x8759, [1055] = 0x8753, [1056] = 0x8763,
  [1057] = 0x876A, [1058] = 0x8805, [1059] = 0x87A2, [1060] = 0x879F,
  [1061] = 0x8782, [1062] = 0x87AF, [1063] = 0x87CB, [1064] = 0x87BD,
  [1065] = 0x87C0, [1066] = 0x87D0, [1067] = 0x96D6, [1068] = 0x87AB,
  [1069] = 0x87C4, [1070] = 0x87B3, [1071] = 0x87C7, [1072] = 0x87C6,
  [1073] = 0x87BB, [1074] = 0x87EF, [1075] = 0x87F2, [1076] = 0x87E0,
  [1077] = 0x880F, [1078] = 0x880D, [1079] = 0x87FE, [1080] = 0x87F6,
  [1081] = 0x87F7, [1082] = 0x880E, [1083] = 0x87D2, [1084] = 0x8811,
  [1085] = 0x8816, [1086] = 0x8815, [1087] = 0x8822, [1088] = 0x8821,
  [1089] = 0x8831, [1090] = 0x8836, [1091] = 0x8839, [1092] = 0x8827,
  [1093] = 0x883B, [1094] = 0x8844, [1095] = 0x8842, [1096] = 0x8852,
  [1097] = 0x8859, [1098] = 0x885E, [1099] = 0x8862, [1100] = 0x886B,
  [1101] = 0x8881, [1102] = 0x887E, [1103] = 0x889E, [1104] = 0x8875,
  [1105] = 0x887D, [1106] = 0x88B5, [1107] = 0x8872, [1108] = 0x8882,
  [1109] = 0x8897, [1110] = 0x8892, [1111] = 0x88AE, [1112] = 0x8899,
  [1113] = 0x88A2, [1114] = 0x888D, [1115] = 0x88A4, [1116] = 0x88B0,
  [1117] = 0x88BF, [1118] = 0x88B1, [1119] = 0x88C3, [1120] = 0x88C4,
  [1121] = 0x88D4, [1122] = 0x88D8, [1123] = 0x88D9, [1124] = 0x88DD,
  [1125] = 0x88F9, [1126] = 0x8902, [1127] = 0x88FC, [1128] = 0x88F4,
  [1129] = 0x88E8, [1130] = 0x88F2, [1131] = 0x8904, [1132] = 0x890C,
  [1133] = 0x890A, [1134] = 0x8913, [1135] = 0x8943, [1136] = 0x891E,
  [1137] = 0x8925, [1138] = 0x892A, [1139] = 0x892B, [1140] = 0x8941,
  [1141] = 0x8944, [1142] = 0x893B, [1143] = 0x8936, [1144] = 0x8938,
  [1145] = 0x894C, [1146] = 0x891D, [1147] = 0x8960, [1148] = 0x895E,
  [1152] = 0x8966, [1153] = 0x8964, [1154] = 0x896D, [1155] = 0x896A,
  [1156] = 0x896F, [1157] = 0x8974, [1158] = 0x8977, [1159] = 0x897E,
  [1160] = 0x8983, [1161] = 0x8988, [1162] = 0x898A, [1163] = 0x8993,
  [1164] = 0x8998, [1165] = 0x89A1, [1166] = 0x89A9, [1167] = 0x89A6,
  [1168] = 0x89AC, [1169] = 0x89AF, [1170] = 0x89B2, [1171] = 0x89BA,
  [1172] = 0x89BD, [1173] = 0x89BF, [1174] = 0x89C0, [1175] = 0x89DA,
  [1176] = 0x89DC, [1177] = 0x89DD, [1178] = 0x89E7, [1179] = 0x89F4,
  [1180] = 0x89F8, [1181] = 0x8A03, [1182] = 0x8A16, [1183] = 0x8A10,
  [1184] = 0x8A0C, [1185] = 0x8A1B, [1186] = 0x8A1D, [1187] = 0x8A25,
  [1188] = 0x8A36, [1189] = 0x8A41, [1190] = 0x8A5B, [1191] = 0x8A52,
  [1192] = 0x8A46, [1193] = 0x8A48, [1194] = 0x8A7C, [1195] = 0x8A6D,
  [1196] = 0x8A6C, [1197] = 0x8A62, [1198] = 0x8A85, [1199] = 0x8A82,
  [1200] = 0x8A84, [1201] = 0x8AA8, [1202] = 0x8AA1, [1203] = 0x8A91,
  [1204] = 0x8AA5, [1205] = 0x8AA6, [1206] = 0x8A9A, [1207] = 0x8AA3,
  [1208] = 0x8AC4, [1209] = 0x8ACD, [1210] = 0x8AC2, [1211] = 0x8ADA,
  [1212] = 0x8AEB, [1213] = 0x8AF3, [1214] = 0x8AE7, [1216] = 0x8AE4,
  [1217] = 0x8AF1, [1218] = 0x8B14, [1219] = 0x8AE0, [1220] = 0x8AE2,
  [1221] = 0x8AF7, [1222] = 0x8ADE, [1223] = 0x8ADB, [1224] = 0x8B0C,
  [1225] = 0x8B07, [1226] = 0x8B1A, [1227] = 0x8AE1, [1228] = 0x8B16,
  [1229] = 0x8B10, [1230] = 0x8B17, [1231] = 0x8B20, [1232] = 0x8B33,
  [1233] = 0x97AB, [1234] = 0x8B26, [1235] = 0x8B2B, [1236] = 0x8B3E,
  [1237] = 0x8B28, [1238] = 0x8B41, [1239] = 0x8B4C, [1240] = 0x8B4F,
  [1241] = 0x8B4E, [1242] = 0x8B49, [1243] = 0x8B56, [1244] = 0x8B5B,
  [1245] = 0x8B5A, [1246] = 0x8B6B, [1247] = 0x8B5F, [1248] = 0x8B6C,
  [1249] = 0x8B6F, [1250] = 0x8B74, [1251] = 0x8B7D, [1252] = 0x8B80,
  [1253] = 0x8B8C, [1254] = 0x8B8E, [1255] = 0x8B92, [1256] = 0x8B93,
  [1257] = 0x8B96, [1258] = 0x8B99, [1259] = 0x8B9A, [1260] = 0x8C3A,
  [1261] = 0x8C41, [1262] = 0x8C3F, [1263] = 0x8C48, [1264] = 0x8C4C,
  [1265] = 0x8C4E, [1266] = 0x8C50, [1267] = 0x8C55, [1268] = 0x8C62,
  [1269] = 0x8C6C, [1270] = 0x8C78, [1271] = 0x8C7A, [1272] = 0x8C82,
  [1273] = 0x8C89, [1274] = 0x8C85, [1275] = 0x8C8A, [1276] = 0x8C8D,
  [1277] = 0x8C8E, [1278] = 0x8C94, [1279] = 0x8C7C, [1280] = 0x8C98,
  [1281] = 0x621D, [1282] = 0x8CAD, [1283] = 0x8CAA, [1284] = 0x8CBD,
  [1285] = 0x8CB2, [1286] = 0x8CB3, [1287] = 0x8CAE, [1288] = 0x8CB6,
  [1289] = 0x8CC8, [1290] = 0x8CC1, [1291] = 0x8CE4, [1292] = 0x8CE3,
  [1293] = 0x8CDA, [1294] = 0x8CFD, [1295] = 0x8CFA, [1296] = 0x8CFB,
  [1297] = 0x8D04, [1298] = 0x8D05, [1299] = 0x8D0A, [1300] = 0x8D07,
  [1301] = 0x8D0F, [1302] = 0x8D0D, [1303] = 0x8D10, [1304] = 0x9F4E,
  [1305] = 0x8D13, [1306] = 0x8CCD, [1307] = 0x8D14, [1308] = 0x8D16,
  [1309] = 0x8D67, [1310] = 0x8D6D, [1311] = 0x8D71, [1312] = 0x8D73,
  [1313] = 0x8D81, [1314] = 0x8D99, [1315] = 0x8DC2, [1316] = 0x8DBE,
  [1317] = 0x8DBA, [1318] = 0x8DCF, [1319] = 0x8DDA, [1320] = 0x8DD6,
  [1321] = 0x8DCC, [1322] = 0x8DDB, [1323] = 0x8DCB, [1324] = 0x8DEA,
  [1325] = 0x8DEB, [1326] = 0x8DDF, [1327] = 0x8DE3, [1328] = 0x8DFC,
  [1329] = 0x8E08, [1330] = 0x8E09, [1331] = 0x8DFF, [1332] = 0x8E1D,
  [1333] = 0x8E1E, [1334] = 0x8E10, [1335] = 0x8E1F, [1336] = 0x8E42,
  [1337] = 0x8E35, [1338] = 0x8E30, [1339] = 0x8E34, [1340] = 0x8E4A,
  [1344] = 0x8E47, [1345] = 0x8E49, [1346] = 0x8E4C, [1347] = 0x8E50,
  [1348] = 0x8E48, [1349] = 0x8E59, [1350] = 0x8E64, [1351] = 0x8E60,
  [1352] = 0x8E2A, [1353] = 0x8E63, [1354] = 0x8E55, [1355] = 0x8E76,
  [1356] = 0x8E72, [1357] = 0x8E7C, [1358] = 0x8E81, [1359] = 0x8E87,
  [1360] = 0x8E85, [1361] = 0x8E84, [1362] = 0x8E8B, [1363] = 0x8E8A,
  [1364] = 0x8E93, [1365] = 0x8E91, [1366] = 0x8E94, [1367] = 0x8E99,
  [1368] = 0x8EAA, [1369] = 0x8EA1, [1370] = 0x8EAC, [1371] = 0x8EB0,
  [1372] = 0x8EC6, [1373] = 0x8EB1, [1374] = 0x8EBE, [1375] = 0x8EC5,
  [1376] = 0x8EC8, [1377] = 0x8ECB, [1378] = 0x8EDB, [1379] = 0x8EE3,
  [1380] = 0x8EFC, [1381] = 0x8EFB, [1382] = 0x8EEB, [1383] = 0x8EFE,
  [1384] = 0x8F0A, [1385] = 0x8F05, [1386] = 0x8F15, [1387] = 0x8F12,
  [1388] = 0x8F19, [1389] = 0x8F13, [1390] = 0x8F1C, [1391] = 0x8F1F,
  [1392] = 0x8F1B, [1393] = 0x8F0C, [1394] = 0x8F26, [1395] = 0x8F33,
  [1396] = 0x8F3B, [1397] = 0x8F39, [1398] = 0x8F45, [1399] = 0x8F42,
  [1400] = 0x8F3E, [1401] = 0x8F4C, [1402] = 0x8F49, [1403] = 0x8F46,
  [1404] = 0x8F4E, [1405] = 0x8F57, [1406] = 0x8F5C, [1408] = 0x8F62,
  [1409] = 0x8F63, [1410] = 0x8F64, [1411] = 0x8F9C, [1412] = 0x8F9F,
  [1413] = 0x8FA3, [1414] = 0x8FAD, [1415] = 0x8FAF, [1416] = 0x8FB7,
  [1417] = 0x8FDA, [1418] = 0x8FE5, [1419] = 0x8FE2, [1420] = 0x8FEA,
  [1421] = 0x8FEF, [1422] = 0x9087, [1423] = 0x8FF4, [1424] = 0x9005,
  [1425] = 0x8FF9, [1426] = 0x8FFA, [1427] = 0x9011, [1428] = 0x9015,
  [1429] = 0x9021, [1430] = 0x900D, [1431] = 0x901E, [1432] = 0x9016,
  [1433] = 0x900B, [1434] = 0x9027, [1435] = 0x9036, [1436] = 0x9035,
  [1437] = 0x9039, [1438] = 0x8FF8, [1439] = 0x904F, [1440] = 0x9050,
  [1441] = 0x9051, [1442] = 0x9052, [1443] = 0x900E, [1444] = 0x9049,
  [1445] = 0x903E, [1446] = 0x9056, [1447] = 0x9058, [1448] = 0x905E,
  [1449] = 0x9068, [1450] = 0x906F, [1451] = 0x9076, [1452] = 0x96A8,
  [1453] = 0x9072, [1454] = 0x9082, [1455] = 0x907D, [1456] = 0x9081,
  [1457] = 0x9080, [1458] = 0x908A, [1459] = 0x9089, [1460] = 0x908F,
  [1461] = 0x90A8, [1462] = 0x90AF, [1463] = 0x90B1, [1464] = 0x90B5,
  [1465] = 0x90E2, [1466] = 0x90E4, [1467] = 0x6248, [1468] = 0x90DB,
  [1469] = 0x9102, [1470] = 0x9112, [1471] = 0x9119, [1472] = 0x9132,
  [1473] = 0x9130, [1474] = 0x914A, [1475] = 0x9156, [1476] = 0x9158,
  [1477] = 0x9163, [1478] = 0x9165, [1479] = 0x9169, [1480] = 0x9173,
  [1481] = 0x9172, [1482] = 0x918B, [1483] = 0x9189, [1484] = 0x9182,
  [1485] = 0x91A2, [1486] = 0x91AB, [1487] = 0x91AF, [1488] = 0x91AA,
  [1489] = 0x91B5, [1490] = 0x91B4, [1491] = 0x91BA, [1492] = 0x91C0,
  [1493] = 0x91C1, [1494] = 0x91C9, [1495] = 0x91CB, [1496] = 0x91D0,
  [1497] = 0x91D6, [1498] = 0x91DF, [1499] = 0x91E1, [1500] = 0x91DB,
  [1501] = 0x91FC, [1502] = 0x91F5, [1503] = 0x91F6, [1504] = 0x921E,
  [1505] = 0x91FF, [1506] = 0x9214, [1507] = 0x922C, [1508] = 0x9215,
  [1509] = 0x9211, [1510] = 0x925E, [1511] = 0x9257, [1512] = 0x9245,
  [1513] = 0x9249, [1514] = 0x9264, [1515] = 0x9248, [1516] = 0x9295,
  [1517] = 0x923F, [1518] = 0x924B, [1519] = 0x9250, [1520] = 0x929C,
  [1521] = 0x9296, [1522] = 0x9293, [1523] = 0x929B, [1524] = 0x925A,
  [1525] = 0x92CF, [1526] = 0x92B9, [1527] = 0x92B7, [1528] = 0x92E9,
  [1529] = 0x930F, [1530] = 0x92FA, [1531] = 0x9344, [1532] = 0x932E,
  [1536] = 0x9319, [1537] = 0x9322, [1538] = 0x931A, [1539] = 0x9323,
  [1540] = 0x933A, [1541] = 0x9335, [1542] = 0x933B, [1543] = 0x935C,
  [1544] = 0x9360, [1545] = 0x937C, [1546] = 0x936E, [1547] = 0x9356,
  [1548] = 0x93B0, [1549] = 0x93AC, [1550] = 0x93AD, [1551] = 0x9394,
  [1552] = 0x93B9, [1553] = 0x93D6, [1554] = 0x93D7, [1555] = 0x93E8,
  [1556] = 0x93E5, [1557] = 0x93D8, [1558] = 0x93C3, [1559] = 0x93DD,
  [1560] = 0x93D0, [1561] = 0x93C8, [1562] = 0x93E4, [1563] = 0x941A,
  [1564] = 0x9414, [1565] = 0x9413, [1566] = 0x9403, [1567] = 0x9407,
  [1568] = 0x9410, [1569] = 0x9436, [1570] = 0x942B, [1571] = 0x9435,
  [1572] = 0x9421, [1573] = 0x943A, [1574] = 0x9441, [1575] = 0x9452,
  [1576] = 0x9444, [1577] = 0x945B, [1578] = 0x9460, [1579] = 0x9462,
  [1580] = 0x945E, [1581] = 0x946A, [1582] = 0x9229, [1583] = 0x9470,
  [1584] = 0x9475, [1585] = 0x9477, [1586] = 0x947D, [1587] = 0x945A,
  [1588] = 0x947C, [1589] = 0x947E, [1590] = 0x9481, [1591] = 0x947F,
  [1592] = 0x9582, [1593] = 0x9587, [1594] = 0x958A, [1595] = 0x9594,
  [1596] = 0x9596, [1597] = 0x9598, [1598] = 0x9599, [1600] = 0x95A0,
  [1601] = 0x95A8, [1602] = 0x95A7, [1603] = 0x95AD, [1604] = 0x95BC,
  [1605] = 0x95BB, [1606] = 0x95B9, [1607] = 0x95BE, [1608] = 0x95CA,
  [1609] = 0x6FF6, [1610] = 0x95C3, [1611] = 0x95CD, [1612] = 0x95CC,
  [1613] = 0x95D5, [1614] = 0x95D4, [1615] = 0x95D6, [1616] = 0x95DC,
  [1617] = 0x95E1, [1618] = 0x95E5, [1619] = 0x95E2, [1620] = 0x9621,
  [1621] = 0x9628, [1622] = 0x962E, [1623] = 0x962F, [1624] = 0x9642,
  [1625] = 0x964C, [1626] = 0x964F, [1627] = 0x964B, [1628] = 0x9677,
  [1629] = 0x965C, [1630] = 0x965E, [1631] = 0x965D, [1632] = 0x965F,
  [1633] = 0x9666, [1634] = 0x9672, [1635] = 0x966C, [1636] = 0x968D,
  [1637] = 0x9698, [1638] = 0x9695, [1639] = 0x9697, [1640] = 0x96AA,
  [1641] = 0x96A7, [1642] = 0x96B1, [1643] = 0x96B2, [1644] = 0x96B0,
  [1645] = 0x96B4, [1646] = 0x96B6, [1647] = 0x96B8, [1648] = 0x96B9,
  [1649] = 0x96CE, [1650] = 0x96CB, [1651] = 0x96C9, [1652] = 0x96CD,
  [1653] = 0x894D, [1654] = 0x96DC, [1655] = 0x970D, [1656] = 0x96D5,
  [1657] = 0x96F9, [1658] = 0x9704, [1659] = 0x9706, [1660] = 0x9708,
  [1661] = 0x9713, [1662] = 0x970E, [1663] = 0x9711, [1664] = 0x970F,
  [1665] = 0x9716, [1666] = 0x9719, [1667] = 0x9724, [1668] = 0x972A,
  [1669] = 0x9730, [1670] = 0x9739, [1671] = 0x973D, [1672] = 0x973E,
  [1673] = 0x9744, [1674] = 0x9746, [1675] = 0x9748, [1676] = 0x9742,
  [1677] = 0x9749, [1678] = 0x975C, [1679] = 0x9760, [1680] = 0x9764,
  [1681] = 0x9766, [1682] = 0x9768, [1683] = 0x52D2, [1684] = 0x976B,
  [1685] = 0x9771, [1686] = 0x9779, [1687] = 0x9785, [1688] = 0x977C,
  [1689] = 0x9781, [1690] = 0x977A, [1691] = 0x9786, [1692] = 0x978B,
  [1693] = 0x978F, [1694] = 0x9790, [1695] = 0x979C, [1696] = 0x97A8,
  [1697] = 0x97A6, [1698] = 0x97A3, [1699] = 0x97B3, [1700] = 0x97B4,
  [1701] = 0x97C3, [1702] = 0x97C6, [1703] = 0x97C8, [1704] = 0x97CB,
  [1705] = 0x97DC, [1706] = 0x97ED, [1707] = 0x9F4F, [1708] = 0x97F2,
  [1709] = 0x7ADF, [1710] = 0x97F6, [1711] = 0x97F5, [1712] = 0x980F,
  [1713] = 0x980C, [1714] = 0x9838, [1715] = 0x9824, [1716] = 0x9821,
  [1717] = 0x9837, [1718] = 0x983D, [1719] = 0x9846, [1720] = 0x984F,
  [1721] = 0x984B, [1722] = 0x986B, [1723] = 0x986F, [1724] = 0x9870,
  [1728] = 0x9871, [1729] = 0x9874, [1730] = 0x9873, [1731] = 0x98AA,
  [1732] = 0x98AF, [1733] = 0x98B1, [1734] = 0x98B6, [1735] = 0x98C4,
  [1736] = 0x98C3, [1737] = 0x98C6, [1738] = 0x98E9, [1739] = 0x98EB,
  [1740] = 0x9903, [1741] = 0x9909, [1742] = 0x9912, [1743] = 0x9914,
  [1744] = 0x9918, [1745] = 0x9921, [1746] = 0x991D, [1747] = 0x991E,
  [1748] = 0x9924, [1749] = 0x9920, [1750] = 0x992C, [1751] = 0x992E,
  [1752] = 0x993D, [1753] = 0x993E, [1754] = 0x9942, [1755] = 0x9949,
  [1756] = 0x9945, [1757] = 0x9950, [1758] = 0x994B, [1759] = 0x9951,
  [1760] = 0x9952, [1761] = 0x994C, [1762] = 0x9955, [1763] = 0x9997,
  [1764] = 0x9998, [1765] = 0x99A5, [1766] = 0x99AD, [1767] = 0x99AE,
  [1768] = 0x99BC, [1769] = 0x99DF, [1770] = 0x99DB, [1771] = 0x99DD,
  [1772] = 0x99D8, [1773] = 0x99D1, [1774] = 0x99ED, [1775] = 0x99EE,
  [1776] = 0x99F1, [1777] = 0x99F2, [1778] = 0x99FB, [1779] = 0x99F8,
  [1780] = 0x9A01, [1781] = 0x9A0F, [1782] = 0x9A05, [1783] = 0x99E2,
  [1784] = 0x9A19, [1785] = 0x9A2B, [1786] = 0x9A37, [1787] = 0x9A45,
  [1788] = 0x9A42, [1789] = 0x9A40, [1790] = 0x9A43, [1792] = 0x9A3E,
  [1793] = 0x9A55, [1794] = 0x9A4D, [1795] = 0x9A5B, [1796] = 0x9A57,
  [1797] = 0x9A5F, [1798] = 0x9A62, [1799] = 0x9A65, [1800] = 0x9A64,
  [1801] = 0x9A69, [1802] = 0x9A6B, [1803] = 0x9A6A, [1804] = 0x9AAD,
  [1805] = 0x9AB0, [1806] = 0x9ABC, [1807] = 0x9AC0, [1808] = 0x9ACF,
  [1809] = 0x9AD1, [1810] = 0x9AD3, [1811] = 0x9AD4, [1812] = 0x9ADE,
  [1813] = 0x9ADF, [1814] = 0x9AE2, [1815] = 0x9AE3, [1816] = 0x9AE6,
  [1817] = 0x9AEF, [1818] = 0x9AEB, [1819] = 0x9AEE, [1820] = 0x9AF4,
  [1821] = 0x9AF1, [1822] = 0x9AF7, [1823] = 0x9AFB, [1824] = 0x9B06,
  [1825] = 0x9B18, [1826] = 0x9B1A, [1827] = 0x9B1F, [1828] = 0x9B22,
  [1829] = 0x9B23, [1830] = 0x9B25, [1831] = 0x9B27, [1832] = 0x9B28,
  [1833] = 0x9B29, [1834] = 0x9B2A, [1835] = 0x9B2E, [1836] = 0x9B2F,
  [1837] = 0x9B32, [1838] = 0x9B44, [1839] = 0x9B43, [1840] = 0x9B4F,
  [1841] = 0x9B4D, [1842] = 0x9B4E, [1843] = 0x9B51, [1844] = 0x9B58,
  [1845] = 0x9B74, [1846] = 0x9B93, [1847] = 0x9B83, [1848] = 0x9B91,
  [1849] = 0x9B96, [1850] = 0x9B97, [1851] = 0x9B9F, [1852] = 0x9BA0,
  [1853] = 0x9BA8, [1854] = 0x9BB4, [1855] = 0x9BC0, [1856] = 0x9BCA,
  [1857] = 0x9BB9, [1858] = 0x9BC6, [1859] = 0x9BCF, [1860] = 0x9BD1,
  [1861] = 0x9BD2, [1862] = 0x9BE3, [1863] = 0x9BE2, [1864] = 0x9BE4,
  [1865] = 0x9BD4, [1866] = 0x9BE1, [1867] = 0x9C3A, [1868] = 0x9BF2,
  [1869] = 0x9BF1, [1870] = 0x9BF0, [1871] = 0x9C15, [1872] = 0x9C14,
  [1873] = 0x9C09, [1874] = 0x9C13, [1875] = 0x9C0C, [1876] = 0x9C06,
  [1877] = 0x9C08, [1878] = 0x9C12, [1879] = 0x9C0A, [1880] = 0x9C04,
  [1881] = 0x9C2E, [1882] = 0x9C1B, [1883] = 0x9C25, [1884] = 0x9C24,
  [1885] = 0x9C21, [1886] = 0x9C30, [1887] = 0x9C47, [1888] = 0x9C32,
  [1889] = 0x9C46, [1890] = 0x9C3E, [1891] = 0x9C5A, [1892] = 0x9C60,
  [1893] = 0x9C67, [1894] = 0x9C76, [1895] = 0x9C78, [1896] = 0x9CE7,
  [1897] = 0x9CEC, [1898] = 0x9CF0, [1899] = 0x9D09, [1900] = 0x9D08,
  [1901] = 0x9CEB, [1902] = 0x9D03, [1903] = 0x9D06, [1904] = 0x9D2A,
  [1905] = 0x9D26, [1906] = 0x9DAF, [1907] = 0x9D23, [1908] = 0x9D1F,
  [1909] = 0x9D44, [1910] = 0x9D15, [1911] = 0x9D12, [1912] = 0x9D41,
  [1913] = 0x9D3F, [1914] = 0x9D3E, [1915] = 0x9D46, [1916] = 0x9D48,
  [1920] = 0x9D5D, [1921] = 0x9D5E, [1922] = 0x9D64, [1923] = 0x9D51,
  [1924] = 0x9D50, [1925] = 0x9D59, [1926] = 0x9D72, [1927] = 0x9D89,
  [1928] = 0x9D87, [1929] = 0x9DAB, [1930] = 0x9D6F, [1931] = 0x9D7A,
  [1932] = 0x9D9A, [1933] = 0x9DA4, [1934] = 0x9DA9, [1935] = 0x9DB2,
  [1936] = 0x9DC4, [1937] = 0x9DC1, [1938] = 0x9DBB, [1939] = 0x9DB8,
  [1940] = 0x9DBA, [1941] = 0x9DC6, [1942] = 0x9DCF, [1943] = 0x9DC2,
  [1944] = 0x9DD9, [1945] = 0x9DD3, [1946] = 0x9DF8, [1947] = 0x9DE6,
  [1948] = 0x9DED, [1949] = 0x9DEF, [1950] = 0x9DFD, [1951] = 0x9E1A,
  [1952] = 0x9E1B, [1953] = 0x9E1E, [1954] = 0x9E75, [1955] = 0x9E79,
  [1956] = 0x9E7D, [1957] = 0x9E81, [1958] = 0x9E88, [1959] = 0x9E8B,
  [1960] = 0x9E8C, [1961] = 0x9E92, [1962] = 0x9E95, [1963] = 0x9E91,
  [1964] = 0x9E9D, [1965] = 0x9EA5, [1966] = 0x9EA9, [1967] = 0x9EB8,
  [1968] = 0x9EAA, [1969] = 0x9EAD, [1970] = 0x9761, [1971] = 0x9ECC,
  [1972] = 0x9ECE, [1973] = 0x9ECF, [1974] = 0x9ED0, [1975] = 0x9ED4,
  [1976] = 0x9EDC, [1977] = 0x9EDE, [1978] = 0x9EDD, [1979] = 0x9EE0,
  [1980] = 0x9EE5, [1981] = 0x9EE8, [1982] = 0x9EEF, [1984] = 0x9EF4,
  [1985] = 0x9EF6, [1986] = 0x9EF7, [1987] = 0x9EF9, [1988] = 0x9EFB,
  [1989] = 0x9EFC, [1990] = 0x9EFD, [1991] = 0x9F07, [1992] = 0x9F08,
  [1993] = 0x76B7, [1994] = 0x9F15, [1995] = 0x9F21, [1996] = 0x9F2C,
  [1997] = 0x9F3E, [1998] = 0x9F4A, [1999] = 0x9F52, [2000] = 0x9F54,
  [2001] = 0x9F63, [2002] = 0x9F5F, [2003] = 0x9F60, [2004] = 0x9F61,
  [2005] = 0x9F66, [2006] = 0x9F67, [2007] = 0x9F6C, [2008] = 0x9F6A,
  [2009] = 0x9F77, [2010] = 0x9F72, [2011] = 0x9F76, [2012] = 0x9F95,
  [2013] = 0x9F9C, [2014] = 0x9FA0, [2015] = 0x582F, [2016] = 0x69C7,
  [2017] = 0x9059, [2018] = 0x7464, [2019] = 0x51DC, [2020] = 0x7199
};




/* The following table can be generated using

   awk '/^0x/ { print $2, $1; }' < .../eastasia/jis/shiftjis.txt |
   egrep "^0x00[[:xdigit:]][[:xdigit:]]" |
   sort -u | perl tab.pl

   where tab.pl is

   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   $n=0;
   while (<>) {
     local($ucs4, $sjis, %rest) = split;
     local($u)=hex($ucs4);
     local($s)=hex($sjis);
     printf ("\n ") if ($n % 3 == 0);
     ++$n;
     printf (" [0x%04x] = \"\\x%02x\\x%02x\",", $u,
	     $s < 0x100 ? $s : int($s/256), $s < 0x100 ? 0 : $s&255);
   }
   printf ("\n");
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The only problem is that the shiftjis.txt file does not contain the
   mapping for the characters 0x00 to 0x1f.  We add them ourself.

   A much bigger problem is that mapping of the tilde and the backslash
   character.  There are no such characters in SJIS.  The proposed
   handling is to simply map the two input values to the corresponding
   byte values of ASCII.  Things fall more or less in place this way.
*/
static const char from_ucs4_lat1[0xf8][2] =
{
  [0x0000] = "\x00\x00", [0x0001] = "\x01\x00", [0x0002] = "\x02\x00",
  [0x0003] = "\x03\x00", [0x0004] = "\x04\x00", [0x0005] = "\x05\x00",
  [0x0006] = "\x06\x00", [0x0007] = "\x07\x00", [0x0008] = "\x08\x00",
  [0x0009] = "\x09\x00", [0x000a] = "\x0a\x00", [0x000b] = "\x0b\x00",
  [0x000c] = "\x0c\x00", [0x000d] = "\x0d\x00", [0x000e] = "\x0e\x00",
  [0x000f] = "\x0f\x00", [0x0010] = "\x10\x00", [0x0011] = "\x11\x00",
  [0x0012] = "\x12\x00", [0x0013] = "\x13\x00", [0x0014] = "\x14\x00",
  [0x0015] = "\x15\x00", [0x0016] = "\x16\x00", [0x0017] = "\x17\x00",
  [0x0018] = "\x18\x00", [0x0019] = "\x19\x00", [0x001a] = "\x1a\x00",
  [0x001b] = "\x1b\x00", [0x001c] = "\x1c\x00", [0x001d] = "\x1d\x00",
  [0x001e] = "\x1e\x00", [0x001f] = "\x1f\x00", [0x0020] = "\x20\x00",
  [0x0021] = "\x21\x00", [0x0022] = "\x22\x00", [0x0023] = "\x23\x00",
  [0x0024] = "\x24\x00", [0x0025] = "\x25\x00", [0x0026] = "\x26\x00",
  [0x0027] = "\x27\x00", [0x0028] = "\x28\x00", [0x0029] = "\x29\x00",
  [0x002a] = "\x2a\x00", [0x002b] = "\x2b\x00", [0x002c] = "\x2c\x00",
  [0x002d] = "\x2d\x00", [0x002e] = "\x2e\x00", [0x002f] = "\x2f\x00",
  [0x0030] = "\x30\x00", [0x0031] = "\x31\x00", [0x0032] = "\x32\x00",
  [0x0033] = "\x33\x00", [0x0034] = "\x34\x00", [0x0035] = "\x35\x00",
  [0x0036] = "\x36\x00", [0x0037] = "\x37\x00", [0x0038] = "\x38\x00",
  [0x0039] = "\x39\x00", [0x003a] = "\x3a\x00", [0x003b] = "\x3b\x00",
  [0x003c] = "\x3c\x00", [0x003d] = "\x3d\x00", [0x003e] = "\x3e\x00",
  [0x003f] = "\x3f\x00", [0x0040] = "\x40\x00", [0x0041] = "\x41\x00",
  [0x0042] = "\x42\x00", [0x0043] = "\x43\x00", [0x0044] = "\x44\x00",
  [0x0045] = "\x45\x00", [0x0046] = "\x46\x00", [0x0047] = "\x47\x00",
  [0x0048] = "\x48\x00", [0x0049] = "\x49\x00", [0x004a] = "\x4a\x00",
  [0x004b] = "\x4b\x00", [0x004c] = "\x4c\x00", [0x004d] = "\x4d\x00",
  [0x004e] = "\x4e\x00", [0x004f] = "\x4f\x00", [0x0050] = "\x50\x00",
  [0x0051] = "\x51\x00", [0x0052] = "\x52\x00", [0x0053] = "\x53\x00",
  [0x0054] = "\x54\x00", [0x0055] = "\x55\x00", [0x0056] = "\x56\x00",
  [0x0057] = "\x57\x00", [0x0058] = "\x58\x00", [0x0059] = "\x59\x00",
  [0x005a] = "\x5a\x00", [0x005b] = "\x5b\x00", [0x005c] = "\x5c\x00",
  [0x005d] = "\x5d\x00", [0x005e] = "\x5e\x00", [0x005f] = "\x5f\x00",
  [0x0060] = "\x60\x00", [0x0061] = "\x61\x00", [0x0062] = "\x62\x00",
  [0x0063] = "\x63\x00", [0x0064] = "\x64\x00", [0x0065] = "\x65\x00",
  [0x0066] = "\x66\x00", [0x0067] = "\x67\x00", [0x0068] = "\x68\x00",
  [0x0069] = "\x69\x00", [0x006a] = "\x6a\x00", [0x006b] = "\x6b\x00",
  [0x006c] = "\x6c\x00", [0x006d] = "\x6d\x00", [0x006e] = "\x6e\x00",
  [0x006f] = "\x6f\x00", [0x0070] = "\x70\x00", [0x0071] = "\x71\x00",
  [0x0072] = "\x72\x00", [0x0073] = "\x73\x00", [0x0074] = "\x74\x00",
  [0x0075] = "\x75\x00", [0x0076] = "\x76\x00", [0x0077] = "\x77\x00",
  [0x0078] = "\x78\x00", [0x0079] = "\x79\x00", [0x007a] = "\x7a\x00",
  [0x007b] = "\x7b\x00", [0x007c] = "\x7c\x00", [0x007d] = "\x7d\x00",
  [0x007e] = "\x7e\x00", [0x007f] = "\x7f\x00",
  [0x00a2] = "\x81\x91", [0x00a3] = "\x81\x92", [0x00a5] = "\x5c\x00",
  [0x00a7] = "\x81\x98", [0x00a8] = "\x81\x4e", [0x00ac] = "\x81\xca",
  [0x00b0] = "\x81\x8b", [0x00b1] = "\x81\x7d", [0x00b4] = "\x81\x4c",
  [0x00b6] = "\x81\xf7", [0x00d7] = "\x81\x7e", [0x00f7] = "\x81\x80"
};


/* The following table can be generated using

   awk '/^0x/ { print $2, $1; }' < .../eastasia/jis/shiftjis.txt |
   egrep "^0x0[34][[:xdigit:]][[:xdigit:]]" |
   sort -u | perl tab.pl

   where tab.pl is

   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   $n=0;
   while (<>) {
     local($ucs4, $sjis, %rest) = split;
     local($u)=hex($ucs4);
     local($s)=hex($sjis);
     printf ("\n ") if ($n % 3 == 0);
     ++$n;
     printf (" [0x%04x] = \"\\x%02x\\x%02x\",", $u - 0x391,
	     $s < 0x100 ? $s : int($s/256), $s < 0x100 ? 0 : $s&255);
   }
   printf ("\n");
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static const char from_ucs4_greek[193][2] =
{
  [0x0000] = "\x83\x9f", [0x0001] = "\x83\xa0", [0x0002] = "\x83\xa1",
  [0x0003] = "\x83\xa2", [0x0004] = "\x83\xa3", [0x0005] = "\x83\xa4",
  [0x0006] = "\x83\xa5", [0x0007] = "\x83\xa6", [0x0008] = "\x83\xa7",
  [0x0009] = "\x83\xa8", [0x000a] = "\x83\xa9", [0x000b] = "\x83\xaa",
  [0x000c] = "\x83\xab", [0x000d] = "\x83\xac", [0x000e] = "\x83\xad",
  [0x000f] = "\x83\xae", [0x0010] = "\x83\xaf", [0x0012] = "\x83\xb0",
  [0x0013] = "\x83\xb1", [0x0014] = "\x83\xb2", [0x0015] = "\x83\xb3",
  [0x0016] = "\x83\xb4", [0x0017] = "\x83\xb5", [0x0018] = "\x83\xb6",
  [0x0020] = "\x83\xbf", [0x0021] = "\x83\xc0", [0x0022] = "\x83\xc1",
  [0x0023] = "\x83\xc2", [0x0024] = "\x83\xc3", [0x0025] = "\x83\xc4",
  [0x0026] = "\x83\xc5", [0x0027] = "\x83\xc6", [0x0028] = "\x83\xc7",
  [0x0029] = "\x83\xc8", [0x002a] = "\x83\xc9", [0x002b] = "\x83\xca",
  [0x002c] = "\x83\xcb", [0x002d] = "\x83\xcc", [0x002e] = "\x83\xcd",
  [0x002f] = "\x83\xce", [0x0030] = "\x83\xcf", [0x0032] = "\x83\xd0",
  [0x0033] = "\x83\xd1", [0x0034] = "\x83\xd2", [0x0035] = "\x83\xd3",
  [0x0036] = "\x83\xd4", [0x0037] = "\x83\xd5", [0x0038] = "\x83\xd6",
  [0x0070] = "\x84\x46", [0x007f] = "\x84\x40", [0x0080] = "\x84\x41",
  [0x0081] = "\x84\x42", [0x0082] = "\x84\x43", [0x0083] = "\x84\x44",
  [0x0084] = "\x84\x45", [0x0085] = "\x84\x47", [0x0086] = "\x84\x48",
  [0x0087] = "\x84\x49", [0x0088] = "\x84\x4a", [0x0089] = "\x84\x4b",
  [0x008a] = "\x84\x4c", [0x008b] = "\x84\x4d", [0x008c] = "\x84\x4e",
  [0x008d] = "\x84\x4f", [0x008e] = "\x84\x50", [0x008f] = "\x84\x51",
  [0x0090] = "\x84\x52", [0x0091] = "\x84\x53", [0x0092] = "\x84\x54",
  [0x0093] = "\x84\x55", [0x0094] = "\x84\x56", [0x0095] = "\x84\x57",
  [0x0096] = "\x84\x58", [0x0097] = "\x84\x59", [0x0098] = "\x84\x5a",
  [0x0099] = "\x84\x5b", [0x009a] = "\x84\x5c", [0x009b] = "\x84\x5d",
  [0x009c] = "\x84\x5e", [0x009d] = "\x84\x5f", [0x009e] = "\x84\x60",
  [0x009f] = "\x84\x70", [0x00a0] = "\x84\x71", [0x00a1] = "\x84\x72",
  [0x00a2] = "\x84\x73", [0x00a3] = "\x84\x74", [0x00a4] = "\x84\x75",
  [0x00a5] = "\x84\x77", [0x00a6] = "\x84\x78", [0x00a7] = "\x84\x79",
  [0x00a8] = "\x84\x7a", [0x00a9] = "\x84\x7b", [0x00aa] = "\x84\x7c",
  [0x00ab] = "\x84\x7d", [0x00ac] = "\x84\x7e", [0x00ad] = "\x84\x80",
  [0x00ae] = "\x84\x81", [0x00af] = "\x84\x82", [0x00b0] = "\x84\x83",
  [0x00b1] = "\x84\x84", [0x00b2] = "\x84\x85", [0x00b3] = "\x84\x86",
  [0x00b4] = "\x84\x87", [0x00b5] = "\x84\x88", [0x00b6] = "\x84\x89",
  [0x00b7] = "\x84\x8a", [0x00b8] = "\x84\x8b", [0x00b9] = "\x84\x8c",
  [0x00ba] = "\x84\x8d", [0x00bb] = "\x84\x8e", [0x00bc] = "\x84\x8f",
  [0x00bd] = "\x84\x90", [0x00be] = "\x84\x91", [0x00c0] = "\x84\x76"
};


/* The mapping of the Kanji is horrible.  The glyphs covered by Shift JIS
   are spreaded all around the Unicode CJK area.  We use one big table
   since using the gaps will not buy us much.

   The following table can be generated using

   awk '/^0x/ { print $2, $1; }' < ...eastasia/jis/shiftjis.txt |
   egrep "^0x[2-9][[:xdigit:]][[:xdigit:]][[:xdigit:]]" |
   sort -u | perl tab.pl

   where tab.pl is

   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   $n=0;
   while (<>) {
     local($ucs4, $sjis, %rest) = split;
     local($u)=hex($ucs4);
     local($s)=hex($sjis);
     printf ("\n ") if ($n % 3 == 0);
     ++$n;
     printf (" [0x%04x] = \"\\x%02x\\x%02x\",", $u - 0x2010,
	     $s < 0x100 ? $s : int($s/256), $s < 0x100 ? 0 : $s&255);
   }
   printf ("\n");
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static const char from_ucs4_cjk[32657][2] =
{
  [0x0000] = "\x81\x5d", [0x0005] = "\x81\x5c", [0x0006] = "\x81\x61",
  [0x0008] = "\x81\x65", [0x0009] = "\x81\x66", [0x000c] = "\x81\x67",
  [0x000d] = "\x81\x68", [0x0010] = "\x81\xf5", [0x0011] = "\x81\xf6",
  [0x0015] = "\x81\x64", [0x0016] = "\x81\x63", [0x0020] = "\x81\xf1",
  [0x0022] = "\x81\x8c", [0x0023] = "\x81\x8d", [0x002b] = "\x81\xa6",
  [0x002e] = "\x7e\x00", [0x00f3] = "\x81\x8e", [0x011b] = "\x81\xf0",
  [0x0180] = "\x81\xa9", [0x0181] = "\x81\xaa", [0x0182] = "\x81\xa8",
  [0x0183] = "\x81\xab", [0x01c2] = "\x81\xcb", [0x01c4] = "\x81\xcc",
  [0x01f0] = "\x81\xcd", [0x01f2] = "\x81\xdd", [0x01f3] = "\x81\xce",
  [0x01f7] = "\x81\xde", [0x01f8] = "\x81\xb8", [0x01fb] = "\x81\xb9",
  [0x0202] = "\x81\x7c", [0x020a] = "\x81\xe3", [0x020d] = "\x81\xe5",
  [0x020e] = "\x81\x87", [0x0210] = "\x81\xda", [0x0217] = "\x81\xc8",
  [0x0218] = "\x81\xc9", [0x0219] = "\x81\xbf", [0x021a] = "\x81\xbe",
  [0x021b] = "\x81\xe7", [0x021c] = "\x81\xe8", [0x0224] = "\x81\x88",
  [0x0225] = "\x81\xe6", [0x022d] = "\x81\xe4", [0x0242] = "\x81\xe0",
  [0x0250] = "\x81\x82", [0x0251] = "\x81\xdf", [0x0256] = "\x81\x85",
  [0x0257] = "\x81\x86", [0x025a] = "\x81\xe1", [0x025b] = "\x81\xe2",
  [0x0272] = "\x81\xbc", [0x0273] = "\x81\xbd", [0x0276] = "\x81\xba",
  [0x0277] = "\x81\xbb", [0x0295] = "\x81\xdb", [0x0302] = "\x81\xdc",
  [0x04f0] = "\x84\x9f", [0x04f1] = "\x84\xaa", [0x04f2] = "\x84\xa0",
  [0x04f3] = "\x84\xab", [0x04fc] = "\x84\xa1", [0x04ff] = "\x84\xac",
  [0x0500] = "\x84\xa2", [0x0503] = "\x84\xad", [0x0504] = "\x84\xa4",
  [0x0507] = "\x84\xaf", [0x0508] = "\x84\xa3", [0x050b] = "\x84\xae",
  [0x050c] = "\x84\xa5", [0x050d] = "\x84\xba", [0x0510] = "\x84\xb5",
  [0x0513] = "\x84\xb0", [0x0514] = "\x84\xa7", [0x0515] = "\x84\xbc",
  [0x0518] = "\x84\xb7", [0x051b] = "\x84\xb2", [0x051c] = "\x84\xa6",
  [0x051f] = "\x84\xb6", [0x0520] = "\x84\xbb", [0x0523] = "\x84\xb1",
  [0x0524] = "\x84\xa8", [0x0527] = "\x84\xb8", [0x0528] = "\x84\xbd",
  [0x052b] = "\x84\xb3", [0x052c] = "\x84\xa9", [0x052f] = "\x84\xb9",
  [0x0532] = "\x84\xbe", [0x053b] = "\x84\xb4", [0x0590] = "\x81\xa1",
  [0x0591] = "\x81\xa0", [0x05a2] = "\x81\xa3", [0x05a3] = "\x81\xa2",
  [0x05ac] = "\x81\xa5", [0x05ad] = "\x81\xa4", [0x05b6] = "\x81\x9f",
  [0x05b7] = "\x81\x9e", [0x05bb] = "\x81\x9b", [0x05be] = "\x81\x9d",
  [0x05bf] = "\x81\x9c", [0x05df] = "\x81\xfc", [0x05f5] = "\x81\x9a",
  [0x05f6] = "\x81\x99", [0x0630] = "\x81\x8a", [0x0632] = "\x81\x89",
  [0x065a] = "\x81\xf4", [0x065d] = "\x81\xf3", [0x065f] = "\x81\xf2",
  [0x0ff0] = "\x81\x40", [0x0ff1] = "\x81\x41", [0x0ff2] = "\x81\x42",
  [0x0ff3] = "\x81\x56", [0x0ff5] = "\x81\x58", [0x0ff6] = "\x81\x59",
  [0x0ff7] = "\x81\x5a", [0x0ff8] = "\x81\x71", [0x0ff9] = "\x81\x72",
  [0x0ffa] = "\x81\x73", [0x0ffb] = "\x81\x74", [0x0ffc] = "\x81\x75",
  [0x0ffd] = "\x81\x76", [0x0ffe] = "\x81\x77", [0x0fff] = "\x81\x78",
  [0x1000] = "\x81\x79", [0x1001] = "\x81\x7a", [0x1002] = "\x81\xa7",
  [0x1003] = "\x81\xac", [0x1004] = "\x81\x6b", [0x1005] = "\x81\x6c",
  [0x100c] = "\x81\x60", [0x1031] = "\x82\x9f", [0x1032] = "\x82\xa0",
  [0x1033] = "\x82\xa1", [0x1034] = "\x82\xa2", [0x1035] = "\x82\xa3",
  [0x1036] = "\x82\xa4", [0x1037] = "\x82\xa5", [0x1038] = "\x82\xa6",
  [0x1039] = "\x82\xa7", [0x103a] = "\x82\xa8", [0x103b] = "\x82\xa9",
  [0x103c] = "\x82\xaa", [0x103d] = "\x82\xab", [0x103e] = "\x82\xac",
  [0x103f] = "\x82\xad", [0x1040] = "\x82\xae", [0x1041] = "\x82\xaf",
  [0x1042] = "\x82\xb0", [0x1043] = "\x82\xb1", [0x1044] = "\x82\xb2",
  [0x1045] = "\x82\xb3", [0x1046] = "\x82\xb4", [0x1047] = "\x82\xb5",
  [0x1048] = "\x82\xb6", [0x1049] = "\x82\xb7", [0x104a] = "\x82\xb8",
  [0x104b] = "\x82\xb9", [0x104c] = "\x82\xba", [0x104d] = "\x82\xbb",
  [0x104e] = "\x82\xbc", [0x104f] = "\x82\xbd", [0x1050] = "\x82\xbe",
  [0x1051] = "\x82\xbf", [0x1052] = "\x82\xc0", [0x1053] = "\x82\xc1",
  [0x1054] = "\x82\xc2", [0x1055] = "\x82\xc3", [0x1056] = "\x82\xc4",
  [0x1057] = "\x82\xc5", [0x1058] = "\x82\xc6", [0x1059] = "\x82\xc7",
  [0x105a] = "\x82\xc8", [0x105b] = "\x82\xc9", [0x105c] = "\x82\xca",
  [0x105d] = "\x82\xcb", [0x105e] = "\x82\xcc", [0x105f] = "\x82\xcd",
  [0x1060] = "\x82\xce", [0x1061] = "\x82\xcf", [0x1062] = "\x82\xd0",
  [0x1063] = "\x82\xd1", [0x1064] = "\x82\xd2", [0x1065] = "\x82\xd3",
  [0x1066] = "\x82\xd4", [0x1067] = "\x82\xd5", [0x1068] = "\x82\xd6",
  [0x1069] = "\x82\xd7", [0x106a] = "\x82\xd8", [0x106b] = "\x82\xd9",
  [0x106c] = "\x82\xda", [0x106d] = "\x82\xdb", [0x106e] = "\x82\xdc",
  [0x106f] = "\x82\xdd", [0x1070] = "\x82\xde", [0x1071] = "\x82\xdf",
  [0x1072] = "\x82\xe0", [0x1073] = "\x82\xe1", [0x1074] = "\x82\xe2",
  [0x1075] = "\x82\xe3", [0x1076] = "\x82\xe4", [0x1077] = "\x82\xe5",
  [0x1078] = "\x82\xe6", [0x1079] = "\x82\xe7", [0x107a] = "\x82\xe8",
  [0x107b] = "\x82\xe9", [0x107c] = "\x82\xea", [0x107d] = "\x82\xeb",
  [0x107e] = "\x82\xec", [0x107f] = "\x82\xed", [0x1080] = "\x82\xee",
  [0x1081] = "\x82\xef", [0x1082] = "\x82\xf0", [0x1083] = "\x82\xf1",
  [0x108b] = "\x81\x4a", [0x108c] = "\x81\x4b", [0x108d] = "\x81\x54",
  [0x108e] = "\x81\x55", [0x1091] = "\x83\x40", [0x1092] = "\x83\x41",
  [0x1093] = "\x83\x42", [0x1094] = "\x83\x43", [0x1095] = "\x83\x44",
  [0x1096] = "\x83\x45", [0x1097] = "\x83\x46", [0x1098] = "\x83\x47",
  [0x1099] = "\x83\x48", [0x109a] = "\x83\x49", [0x109b] = "\x83\x4a",
  [0x109c] = "\x83\x4b", [0x109d] = "\x83\x4c", [0x109e] = "\x83\x4d",
  [0x109f] = "\x83\x4e", [0x10a0] = "\x83\x4f", [0x10a1] = "\x83\x50",
  [0x10a2] = "\x83\x51", [0x10a3] = "\x83\x52", [0x10a4] = "\x83\x53",
  [0x10a5] = "\x83\x54", [0x10a6] = "\x83\x55", [0x10a7] = "\x83\x56",
  [0x10a8] = "\x83\x57", [0x10a9] = "\x83\x58", [0x10aa] = "\x83\x59",
  [0x10ab] = "\x83\x5a", [0x10ac] = "\x83\x5b", [0x10ad] = "\x83\x5c",
  [0x10ae] = "\x83\x5d", [0x10af] = "\x83\x5e", [0x10b0] = "\x83\x5f",
  [0x10b1] = "\x83\x60", [0x10b2] = "\x83\x61", [0x10b3] = "\x83\x62",
  [0x10b4] = "\x83\x63", [0x10b5] = "\x83\x64", [0x10b6] = "\x83\x65",
  [0x10b7] = "\x83\x66", [0x10b8] = "\x83\x67", [0x10b9] = "\x83\x68",
  [0x10ba] = "\x83\x69", [0x10bb] = "\x83\x6a", [0x10bc] = "\x83\x6b",
  [0x10bd] = "\x83\x6c", [0x10be] = "\x83\x6d", [0x10bf] = "\x83\x6e",
  [0x10c0] = "\x83\x6f", [0x10c1] = "\x83\x70", [0x10c2] = "\x83\x71",
  [0x10c3] = "\x83\x72", [0x10c4] = "\x83\x73", [0x10c5] = "\x83\x74",
  [0x10c6] = "\x83\x75", [0x10c7] = "\x83\x76", [0x10c8] = "\x83\x77",
  [0x10c9] = "\x83\x78", [0x10ca] = "\x83\x79", [0x10cb] = "\x83\x7a",
  [0x10cc] = "\x83\x7b", [0x10cd] = "\x83\x7c", [0x10ce] = "\x83\x7d",
  [0x10cf] = "\x83\x7e", [0x10d0] = "\x83\x80", [0x10d1] = "\x83\x81",
  [0x10d2] = "\x83\x82", [0x10d3] = "\x83\x83", [0x10d4] = "\x83\x84",
  [0x10d5] = "\x83\x85", [0x10d6] = "\x83\x86", [0x10d7] = "\x83\x87",
  [0x10d8] = "\x83\x88", [0x10d9] = "\x83\x89", [0x10da] = "\x83\x8a",
  [0x10db] = "\x83\x8b", [0x10dc] = "\x83\x8c", [0x10dd] = "\x83\x8d",
  [0x10de] = "\x83\x8e", [0x10df] = "\x83\x8f", [0x10e0] = "\x83\x90",
  [0x10e1] = "\x83\x91", [0x10e2] = "\x83\x92", [0x10e3] = "\x83\x93",
  [0x10e4] = "\x83\x94", [0x10e5] = "\x83\x95", [0x10e6] = "\x83\x96",
  [0x10eb] = "\x81\x45", [0x10ec] = "\x81\x5b", [0x10ed] = "\x81\x52",
  [0x10ee] = "\x81\x53", [0x2df0] = "\x88\xea", [0x2df1] = "\x92\x9a",
  [0x2df3] = "\x8e\xb5", [0x2df7] = "\x96\x9c", [0x2df8] = "\x8f\xe4",
  [0x2df9] = "\x8e\x4f", [0x2dfa] = "\x8f\xe3", [0x2dfb] = "\x89\xba",
  [0x2dfd] = "\x95\x73", [0x2dfe] = "\x97\x5e", [0x2e00] = "\x98\xa0",
  [0x2e01] = "\x89\x4e", [0x2e04] = "\x8a\x8e", [0x2e05] = "\x98\xa1",
  [0x2e06] = "\x90\xa2", [0x2e07] = "\x99\xc0", [0x2e08] = "\x8b\x75",
  [0x2e09] = "\x95\xb8", [0x2e0e] = "\x8f\xe5", [0x2e11] = "\x97\xbc",
  [0x2e16] = "\x95\xc0", [0x2e1a] = "\x98\xa2", [0x2e1d] = "\x92\x86",
  [0x2e21] = "\x98\xa3", [0x2e22] = "\x8b\xf8", [0x2e26] = "\x98\xa4",
  [0x2e28] = "\x8a\xdb", [0x2e29] = "\x92\x4f", [0x2e2b] = "\x8e\xe5",
  [0x2e2c] = "\x98\xa5", [0x2e2f] = "\x98\xa6", [0x2e32] = "\x98\xa7",
  [0x2e33] = "\x94\x54", [0x2e35] = "\x8b\x76", [0x2e3b] = "\x94\x56",
  [0x2e3d] = "\x93\xe1", [0x2e3e] = "\x8c\xc1", [0x2e3f] = "\x96\x52",
  [0x2e45] = "\xe5\x68", [0x2e46] = "\x98\xa8", [0x2e47] = "\x8f\xe6",
  [0x2e48] = "\x98\xa9", [0x2e49] = "\x89\xb3", [0x2e4d] = "\x8b\xe3",
  [0x2e4e] = "\x8c\xee", [0x2e4f] = "\x96\xe7", [0x2e52] = "\x9b\xa4",
  [0x2e61] = "\x97\x90", [0x2e63] = "\x93\xfb", [0x2e6e] = "\x8a\xa3",
  [0x2e70] = "\x8b\x54", [0x2e72] = "\x98\xaa", [0x2e75] = "\x98\xab",
  [0x2e76] = "\x97\xb9", [0x2e78] = "\x97\x5c", [0x2e79] = "\x91\x88",
  [0x2e7a] = "\x98\xad", [0x2e7b] = "\x8e\x96", [0x2e7c] = "\x93\xf1",
  [0x2e7e] = "\x98\xb0", [0x2e81] = "\x89\x5d", [0x2e82] = "\x8c\xdd",
  [0x2e84] = "\x8c\xdc", [0x2e85] = "\x88\xe4", [0x2e88] = "\x98\x6a",
  [0x2e89] = "\x98\x69", [0x2e8b] = "\x8d\xb1", [0x2e8c] = "\x88\x9f",
  [0x2e8e] = "\x98\xb1", [0x2e8f] = "\x98\xb2", [0x2e90] = "\x98\xb3",
  [0x2e91] = "\x96\x53", [0x2e92] = "\x98\xb4", [0x2e94] = "\x8c\xf0",
  [0x2e95] = "\x88\xe5", [0x2e96] = "\x96\x92", [0x2e98] = "\x8b\x9c",
  [0x2e9b] = "\x8b\x9d", [0x2e9c] = "\x8b\x9e", [0x2e9d] = "\x92\xe0",
  [0x2e9e] = "\x97\xba", [0x2ea0] = "\x98\xb5", [0x2ea3] = "\x98\xb6",
  [0x2ea6] = "\x98\xb7", [0x2eaa] = "\x90\x6c", [0x2eb0] = "\x8f\x59",
  [0x2eb1] = "\x90\x6d", [0x2eb2] = "\x98\xbc", [0x2eb4] = "\x98\xba",
  [0x2eb6] = "\x98\xbb", [0x2eb7] = "\x8b\x77", [0x2eba] = "\x8d\xa1",
  [0x2ebb] = "\x89\xee", [0x2ebd] = "\x98\xb9", [0x2ebe] = "\x98\xb8",
  [0x2ebf] = "\x95\xa7", [0x2ec4] = "\x8e\x65", [0x2ec5] = "\x8e\x64",
  [0x2ec6] = "\x91\xbc", [0x2ec7] = "\x98\xbd", [0x2ec8] = "\x95\x74",
  [0x2ec9] = "\x90\xe5", [0x2ecd] = "\x81\x57", [0x2ece] = "\x98\xbe",
  [0x2ecf] = "\x98\xc0", [0x2ed3] = "\x91\xe3", [0x2ed4] = "\x97\xdf",
  [0x2ed5] = "\x88\xc8", [0x2edd] = "\x98\xbf", [0x2ede] = "\x89\xbc",
  [0x2ee0] = "\x8b\xc2", [0x2ee2] = "\x92\x87", [0x2ee6] = "\x8c\x8f",
  [0x2ee7] = "\x98\xc1", [0x2eeb] = "\x94\x43", [0x2ef1] = "\x8a\xe9",
  [0x2ef9] = "\x98\xc2", [0x2efa] = "\x88\xc9", [0x2efd] = "\x8c\xde",
  [0x2efe] = "\x8a\xea", [0x2eff] = "\x95\x9a", [0x2f00] = "\x94\xb0",
  [0x2f01] = "\x8b\x78", [0x2f0a] = "\x89\xef", [0x2f0c] = "\x98\xe5",
  [0x2f0d] = "\x93\x60", [0x2f1f] = "\x94\x8c", [0x2f20] = "\x98\xc4",
  [0x2f24] = "\x94\xba", [0x2f26] = "\x97\xe0", [0x2f28] = "\x90\x4c",
  [0x2f2a] = "\x8e\x66", [0x2f2c] = "\x8e\x97", [0x2f2d] = "\x89\xbe",
  [0x2f33] = "\x92\xcf", [0x2f36] = "\x92\x41", [0x2f37] = "\x98\xc8",
  [0x2f3d] = "\x88\xca", [0x2f3e] = "\x92\xe1", [0x2f3f] = "\x8f\x5a",
  [0x2f40] = "\x8d\xb2", [0x2f41] = "\x97\x43", [0x2f43] = "\x91\xcc",
  [0x2f45] = "\x89\xbd", [0x2f47] = "\x98\xc7", [0x2f49] = "\x97\x5d",
  [0x2f4a] = "\x98\xc3", [0x2f4b] = "\x98\xc5", [0x2f4c] = "\x8d\xec",
  [0x2f4d] = "\x98\xc6", [0x2f4e] = "\x9b\x43", [0x2f59] = "\x98\xce",
  [0x2f5f] = "\x98\xd1", [0x2f60] = "\x98\xcf", [0x2f63] = "\x89\xc0",
  [0x2f65] = "\x95\xb9", [0x2f66] = "\x98\xc9", [0x2f6b] = "\x98\xcd",
  [0x2f6c] = "\x8c\xf1", [0x2f6f] = "\x8e\x67", [0x2f73] = "\x8a\xa4",
  [0x2f76] = "\x98\xd2", [0x2f78] = "\x98\xca", [0x2f7b] = "\x97\xe1",
  [0x2f7d] = "\x8e\x98", [0x2f7f] = "\x98\xcb", [0x2f81] = "\x98\xd0",
  [0x2f86] = "\x98\xd3", [0x2f88] = "\x98\xcc", [0x2f8b] = "\x8b\x9f",
  [0x2f8d] = "\x88\xcb", [0x2f90] = "\x8b\xa0", [0x2f91] = "\x89\xbf",
  [0x2f9b] = "\x9b\x44", [0x2f9d] = "\x96\x99", [0x2f9e] = "\x95\x8e",
  [0x2f9f] = "\x8c\xf2", [0x2fa5] = "\x90\x4e", [0x2fa6] = "\x97\xb5",
  [0x2faf] = "\x95\xd6", [0x2fb2] = "\x8c\x57", [0x2fb3] = "\x91\xa3",
  [0x2fb4] = "\x89\xe2", [0x2fba] = "\x8f\x72", [0x2fbe] = "\x98\xd7",
  [0x2fc0] = "\x98\xdc", [0x2fc1] = "\x98\xda", [0x2fc4] = "\x98\xd5",
  [0x2fc7] = "\x91\xad", [0x2fc8] = "\x98\xd8", [0x2fca] = "\x98\xdb",
  [0x2fcb] = "\x98\xd9", [0x2fcd] = "\x95\xdb", [0x2fcf] = "\x98\xd6",
  [0x2fd1] = "\x90\x4d", [0x2fd3] = "\x96\x93", [0x2fd4] = "\x98\xdd",
  [0x2fd5] = "\x98\xde", [0x2fde] = "\x8f\x43", [0x2fdf] = "\x98\xeb",
  [0x2fe3] = "\x94\x6f", [0x2fe5] = "\x95\x55", [0x2fe6] = "\x98\xe6",
  [0x2fe8] = "\x95\xee", [0x2fea] = "\x89\xb4", [0x2fee] = "\x98\xea",
  [0x2ff5] = "\x98\xe4", [0x2ff6] = "\x98\xed", [0x2ff9] = "\x91\x71",
  [0x2ffb] = "\x8c\xc2", [0x2ffd] = "\x94\x7b", [0x2fff] = "\xe0\xc5",
  [0x3001] = "\x98\xec", [0x3002] = "\x93\x7c", [0x3004] = "\x98\xe1",
  [0x3006] = "\x8c\xf4", [0x3009] = "\x8c\xf3", [0x300a] = "\x98\xdf",
  [0x300f] = "\x8e\xd8", [0x3011] = "\x98\xe7", [0x3013] = "\x95\xed",
  [0x3014] = "\x92\x6c", [0x3015] = "\x98\xe3", [0x3016] = "\x8c\x91",
  [0x3018] = "\x98\xe0", [0x3019] = "\x98\xe8", [0x301a] = "\x98\xe2",
  [0x301b] = "\x97\xcf", [0x301c] = "\x98\xe9", [0x301d] = "\x98\x60",
  [0x3026] = "\x8b\xe4", [0x3029] = "\x8c\x90", [0x3033] = "\x98\xee",
  [0x3037] = "\x98\xef", [0x3038] = "\x98\xf3", [0x3039] = "\x88\xcc",
  [0x303f] = "\x95\xce", [0x3040] = "\x98\xf2", [0x3045] = "\x98\xf1",
  [0x3046] = "\x98\xf5", [0x304a] = "\x98\xf4", [0x304c] = "\x92\xe2",
  [0x3055] = "\x8c\x92", [0x305c] = "\x98\xf6", [0x3062] = "\x8e\xc3",
  [0x3064] = "\x91\xa4", [0x3065] = "\x92\xe3", [0x3066] = "\x8b\xf4",
  [0x3068] = "\x98\xf7", [0x306d] = "\x8b\x55", [0x3070] = "\x98\xf8",
  [0x3075] = "\x98\xfa", [0x307d] = "\x96\x54", [0x3081] = "\x8c\x86",
  [0x3088] = "\x8e\x50", [0x3089] = "\x94\xf5", [0x308a] = "\x98\xf9",
  [0x309c] = "\x8d\xc3", [0x309d] = "\x97\x62", [0x30a2] = "\x98\xfc",
  [0x30a3] = "\x99\x42", [0x30a4] = "\x98\xfb", [0x30a5] = "\x8d\xc2",
  [0x30a7] = "\x8f\x9d", [0x30ae] = "\x8c\x58", [0x30b2] = "\x99\x43",
  [0x30b5] = "\x8b\xcd", [0x30b9] = "\x99\x40", [0x30ba] = "\x99\x41",
  [0x30bd] = "\x93\xad", [0x30bf] = "\x91\x9c", [0x30c1] = "\x8b\xa1",
  [0x30c5] = "\x96\x6c", [0x30c6] = "\x99\x44", [0x30ca] = "\x97\xbb",
  [0x30ce] = "\x99\x45", [0x30d3] = "\x99\x48", [0x30d5] = "\x99\x46",
  [0x30d7] = "\x91\x6d", [0x30dd] = "\x99\x47", [0x30de] = "\x99\x49",
  [0x30e5] = "\x99\x4b", [0x30e9] = "\x99\x4a", [0x30eb] = "\x95\xc6",
  [0x30f0] = "\x8b\x56", [0x30f1] = "\x99\x4d", [0x30f2] = "\x99\x4e",
  [0x30f4] = "\x89\xad", [0x30f9] = "\x99\x4c", [0x3102] = "\x8e\xf2",
  [0x3104] = "\x99\x51", [0x3105] = "\x99\x50", [0x3106] = "\x99\x4f",
  [0x3108] = "\x98\xd4", [0x310a] = "\x99\x52", [0x310f] = "\x8f\x9e",
  [0x3111] = "\x99\x53", [0x311a] = "\x97\x44", [0x3122] = "\x96\xd7",
  [0x3127] = "\x99\x55", [0x312a] = "\x99\x54", [0x312b] = "\x99\x57",
  [0x312c] = "\x99\x56", [0x312f] = "\x99\x58", [0x3130] = "\x99\x59",
  [0x3131] = "\x88\xf2", [0x3133] = "\x8c\xb3", [0x3134] = "\x8c\x5a",
  [0x3135] = "\x8f\x5b", [0x3136] = "\x92\x9b", [0x3137] = "\x8b\xa2",
  [0x3138] = "\x90\xe6", [0x3139] = "\x8c\xf5", [0x313b] = "\x8d\x8e",
  [0x313c] = "\x99\x5b", [0x313d] = "\x96\xc6", [0x313e] = "\x93\x65",
  [0x3140] = "\x8e\x99", [0x3142] = "\x99\x5a", [0x3144] = "\x99\x5c",
  [0x314a] = "\x93\x7d", [0x314c] = "\x8a\x95", [0x3152] = "\x99\x5d",
  [0x3155] = "\x93\xfc", [0x3158] = "\x91\x53", [0x3159] = "\x99\x5f",
  [0x315a] = "\x99\x60", [0x315b] = "\x94\xaa", [0x315c] = "\x8c\xf6",
  [0x315d] = "\x98\x5a", [0x315e] = "\x99\x61", [0x3161] = "\x8b\xa4",
  [0x3165] = "\x95\xba", [0x3166] = "\x91\xb4", [0x3167] = "\x8b\xef",
  [0x3168] = "\x93\x54", [0x316c] = "\x8c\x93", [0x3170] = "\x99\x62",
  [0x3172] = "\x99\x63", [0x3175] = "\x93\xe0", [0x3176] = "\x89\x7e",
  [0x3179] = "\x99\x66", [0x317a] = "\x8d\xfb", [0x317c] = "\x99\x65",
  [0x317d] = "\x8d\xc4", [0x317f] = "\x99\x67", [0x3180] = "\xe3\xec",
  [0x3181] = "\x99\x68", [0x3182] = "\x96\x60", [0x3183] = "\x99\x69",
  [0x3185] = "\x99\x6a", [0x3186] = "\x99\x6b", [0x3187] = "\x8f\xe7",
  [0x3189] = "\x8e\xca", [0x3190] = "\x8a\xa5", [0x3192] = "\x99\x6e",
  [0x3194] = "\x99\x6c", [0x3195] = "\x96\xbb", [0x3196] = "\x99\x6d",
  [0x3198] = "\x95\x79", [0x3199] = "\x99\x6f", [0x319a] = "\x99\x70",
  [0x319b] = "\x99\x71", [0x319c] = "\x93\x7e", [0x31a0] = "\x99\x75",
  [0x31a1] = "\x99\x73", [0x31a2] = "\x99\x74", [0x31a3] = "\x99\x72",
  [0x31a4] = "\x8d\xe1", [0x31a5] = "\x99\x76", [0x31a6] = "\x96\xe8",
  [0x31a7] = "\x97\xe2", [0x31ad] = "\x99\x77", [0x31b4] = "\x90\xa6",
  [0x31b5] = "\x99\x78", [0x31b6] = "\x8f\x79", [0x31b9] = "\x99\x79",
  [0x31bb] = "\x92\x9c", [0x31bc] = "\x97\xbd", [0x31bd] = "\x93\x80",
  [0x31c6] = "\x99\xc3", [0x31cb] = "\x99\x7a", [0x31cc] = "\xea\xa3",
  [0x31cd] = "\x8b\xc3", [0x31d0] = "\x99\x7b", [0x31d1] = "\x96\x7d",
  [0x31d6] = "\x8f\x88", [0x31d7] = "\x91\xfa", [0x31d9] = "\x99\x7d",
  [0x31da] = "\x93\xe2", [0x31dd] = "\x99\x7e", [0x31e0] = "\x99\x80",
  [0x31e1] = "\x8a\x4d", [0x31e5] = "\x99\x81", [0x31e6] = "\x8b\xa5",
  [0x31e8] = "\x93\xca", [0x31e9] = "\x89\x9a", [0x31ea] = "\x8f\x6f",
  [0x31ed] = "\x94\x9f", [0x31ee] = "\x99\x82", [0x31f0] = "\x93\x81",
  [0x31f3] = "\x90\x6e", [0x31f4] = "\x99\x83", [0x31f6] = "\x95\xaa",
  [0x31f7] = "\x90\xd8", [0x31f8] = "\x8a\xa0", [0x31fa] = "\x8a\xa7",
  [0x31fb] = "\x99\x84", [0x31fe] = "\x99\x86", [0x3201] = "\x8c\x59",
  [0x3204] = "\x99\x85", [0x3207] = "\x97\xf1", [0x320d] = "\x8f\x89",
  [0x3214] = "\x94\xbb", [0x3215] = "\x95\xca", [0x3217] = "\x99\x87",
  [0x3219] = "\x97\x98", [0x321a] = "\x99\x88", [0x321e] = "\x99\x89",
  [0x3220] = "\x93\x9e", [0x3223] = "\x99\x8a", [0x3226] = "\x90\xa7",
  [0x3227] = "\x8d\xfc", [0x3228] = "\x8c\x94", [0x3229] = "\x99\x8b",
  [0x322a] = "\x8e\x68", [0x322b] = "\x8d\x8f", [0x3233] = "\x92\xe4",
  [0x3234] = "\x99\x8d", [0x3237] = "\x91\xa5", [0x323a] = "\x8d\xed",
  [0x323b] = "\x99\x8e", [0x323c] = "\x99\x8f", [0x323d] = "\x91\x4f",
  [0x323f] = "\x99\x8c", [0x3244] = "\x99\x91", [0x3246] = "\x96\x55",
  [0x324b] = "\x8d\x84", [0x324e] = "\x99\x90", [0x3253] = "\x8c\x95",
  [0x3254] = "\x8d\xdc", [0x3255] = "\x94\x8d", [0x3259] = "\x99\x94",
  [0x325a] = "\x99\x92", [0x325f] = "\x95\x9b", [0x3260] = "\x8f\xe8",
  [0x3261] = "\x99\x9b", [0x3262] = "\x8a\x84", [0x3263] = "\x99\x95",
  [0x3264] = "\x99\x93", [0x3265] = "\x91\x6e", [0x326d] = "\x99\x97",
  [0x326f] = "\x99\x96", [0x3273] = "\x8a\x63", [0x3277] = "\x8c\x80",
  [0x3278] = "\x99\x9c", [0x3279] = "\x97\xab", [0x327d] = "\x99\x98",
  [0x3281] = "\x99\x9d", [0x3282] = "\x99\x9a", [0x3284] = "\x99\x99",
  [0x328b] = "\x97\xcd", [0x328f] = "\x8c\xf7", [0x3290] = "\x89\xc1",
  [0x3293] = "\x97\xf2", [0x3299] = "\x8f\x95", [0x329a] = "\x93\x77",
  [0x329b] = "\x8d\x85", [0x329c] = "\x99\xa0", [0x329d] = "\x99\xa1",
  [0x32a1] = "\x97\xe3", [0x32a4] = "\x98\x4a", [0x32a5] = "\x99\xa3",
  [0x32a9] = "\x8c\xf8", [0x32ac] = "\x99\xa2", [0x32ae] = "\x8a\x4e",
  [0x32b1] = "\x99\xa4", [0x32b3] = "\x96\x75", [0x32b5] = "\x92\xba",
  [0x32b7] = "\x97\x45", [0x32b9] = "\x95\xd7", [0x32bd] = "\x99\xa5",
  [0x32c2] = "\xe8\xd3", [0x32c5] = "\x93\xae", [0x32c7] = "\x99\xa6",
  [0x32c8] = "\x8a\xa8", [0x32c9] = "\x96\xb1", [0x32cd] = "\x8f\x9f",
  [0x32ce] = "\x99\xa7", [0x32cf] = "\x95\xe5", [0x32d0] = "\x99\xab",
  [0x32d2] = "\x90\xa8", [0x32d3] = "\x99\xa8", [0x32d4] = "\x8b\xce",
  [0x32d6] = "\x99\xa9", [0x32d7] = "\x8a\xa9", [0x32e2] = "\x8c\x4d",
  [0x32e3] = "\x99\xac", [0x32e5] = "\x99\xad", [0x32e8] = "\x99\xae",
  [0x32e9] = "\x99\xaf", [0x32ea] = "\x8e\xd9", [0x32ee] = "\x8c\xf9",
  [0x32ef] = "\x96\xdc", [0x32f1] = "\x96\xe6", [0x32f2] = "\x93\xf5",
  [0x32f5] = "\x95\xef", [0x32f6] = "\x99\xb0", [0x32f8] = "\x99\xb1",
  [0x32fd] = "\x99\xb3", [0x32ff] = "\x99\xb5", [0x3300] = "\x99\xb4",
  [0x3305] = "\x99\xb6", [0x3306] = "\x89\xbb", [0x3307] = "\x96\x6b",
  [0x3309] = "\x8d\xfa", [0x330a] = "\x99\xb7", [0x330d] = "\x91\x78",
  [0x3310] = "\x8f\xa0", [0x3311] = "\x8b\xa7", [0x3313] = "\x99\xb8",
  [0x331a] = "\x94\xd9", [0x331f] = "\x99\xb9", [0x3321] = "\x99\xba",
  [0x3323] = "\x99\xbb", [0x3328] = "\x99\xbc", [0x3329] = "\x95\x43",
  [0x332a] = "\x8b\xe6", [0x332b] = "\x88\xe3", [0x332f] = "\x93\xbd",
  [0x3330] = "\x99\xbd", [0x3331] = "\x8f\x5c", [0x3333] = "\x90\xe7",
  [0x3335] = "\x99\xbf", [0x3336] = "\x99\xbe", [0x3337] = "\x8f\xa1",
  [0x3338] = "\x8c\xdf", [0x3339] = "\x99\xc1", [0x333a] = "\x94\xbc",
  [0x333d] = "\x99\xc2", [0x3341] = "\x94\xda", [0x3342] = "\x91\xb2",
  [0x3343] = "\x91\xec", [0x3344] = "\x8b\xa6", [0x3347] = "\x93\xec",
  [0x3348] = "\x92\x50", [0x334a] = "\x94\x8e", [0x334c] = "\x96\x6d",
  [0x334e] = "\x99\xc4", [0x3350] = "\x90\xe8", [0x3356] = "\x8c\x54",
  [0x3359] = "\x99\xc5", [0x335e] = "\x99\xc6", [0x335f] = "\x89\x4b",
  [0x3360] = "\x88\xf3", [0x3361] = "\x8a\xeb", [0x3363] = "\x91\xa6",
  [0x3364] = "\x8b\x70", [0x3365] = "\x97\x91", [0x3367] = "\x99\xc9",
  [0x3368] = "\x89\xb5", [0x336b] = "\x99\xc8", [0x336f] = "\x8b\xa8",
  [0x3372] = "\x99\xca", [0x3374] = "\x96\xef", [0x3386] = "\x99\xcb",
  [0x3388] = "\x97\xd0", [0x338a] = "\x8c\xfa", [0x338f] = "\x8c\xb4",
  [0x3390] = "\x99\xcc", [0x3395] = "\x99\xce", [0x3396] = "\x99\xcd",
  [0x3398] = "\x90\x7e", [0x3399] = "\x89\x58", [0x339d] = "\x89\x7d",
  [0x339e] = "\x99\xcf", [0x33a0] = "\x99\xd0", [0x33a3] = "\x8c\xb5",
  [0x33a6] = "\x99\xd1", [0x33ab] = "\x8b\x8e", [0x33b2] = "\x8e\x51",
  [0x33b3] = "\x99\xd2", [0x33b8] = "\x96\x94", [0x33b9] = "\x8d\xb3",
  [0x33ba] = "\x8b\x79", [0x33bb] = "\x97\x46", [0x33bc] = "\x91\x6f",
  [0x33bd] = "\x94\xbd", [0x33be] = "\x8e\xfb", [0x33c4] = "\x8f\x66",
  [0x33c6] = "\x8e\xe6", [0x33c7] = "\x8e\xf3", [0x33c9] = "\x8f\x96",
  [0x33cb] = "\x94\xbe", [0x33cf] = "\x99\xd5", [0x33d1] = "\x89\x62",
  [0x33d2] = "\x91\x70", [0x33d3] = "\x8c\xfb", [0x33d4] = "\x8c\xc3",
  [0x33d5] = "\x8b\xe5", [0x33d8] = "\x99\xd9", [0x33d9] = "\x92\x40",
  [0x33da] = "\x91\xfc", [0x33db] = "\x8b\xa9", [0x33dc] = "\x8f\xa2",
  [0x33dd] = "\x99\xda", [0x33de] = "\x99\xd8", [0x33df] = "\x89\xc2",
  [0x33e0] = "\x91\xe4", [0x33e1] = "\x8e\xb6", [0x33e2] = "\x8e\x6a",
  [0x33e3] = "\x89\x45", [0x33e6] = "\x8a\x90", [0x33e7] = "\x8d\x86",
  [0x33e8] = "\x8e\x69", [0x33ea] = "\x99\xdb", [0x33f1] = "\x99\xdc",
  [0x33f3] = "\x8b\x68", [0x33f4] = "\x8a\x65", [0x33f8] = "\x8d\x87",
  [0x33f9] = "\x8b\x67", [0x33fa] = "\x92\xdd", [0x33fb] = "\x89\x44",
  [0x33fc] = "\x93\xaf", [0x33fd] = "\x96\xbc", [0x33fe] = "\x8d\x40",
  [0x33ff] = "\x97\x99", [0x3400] = "\x93\x66", [0x3401] = "\x8c\xfc",
  [0x340b] = "\x8c\x4e", [0x340d] = "\x99\xe5", [0x340f] = "\x8b\xe1",
  [0x3410] = "\x96\x69", [0x3416] = "\x94\xdb", [0x3419] = "\x99\xe4",
  [0x341b] = "\x8a\xdc", [0x341c] = "\x99\xdf", [0x341d] = "\x99\xe0",
  [0x341e] = "\x99\xe2", [0x3426] = "\x99\xe3", [0x3428] = "\x8b\x7a",
  [0x3429] = "\x90\x81", [0x342b] = "\x95\xab", [0x342c] = "\x99\xe1",
  [0x342d] = "\x99\xdd", [0x342e] = "\x8c\xe1", [0x3430] = "\x99\xde",
  [0x3432] = "\x98\x43", [0x3436] = "\x95\xf0", [0x3438] = "\x92\xe6",
  [0x3439] = "\x8c\xe0", [0x343a] = "\x8d\x90", [0x343e] = "\x99\xe6",
  [0x3441] = "\x93\xdb", [0x344f] = "\x99\xea", [0x3458] = "\x8e\xfc",
  [0x345a] = "\x8e\xf4", [0x3460] = "\x99\xed", [0x3461] = "\x99\xeb",
  [0x3463] = "\x96\xa1", [0x3465] = "\x99\xe8", [0x3466] = "\x99\xf1",
  [0x3467] = "\x99\xec", [0x346b] = "\x99\xef", [0x346c] = "\x8c\xc4",
  [0x346d] = "\x96\xbd", [0x3470] = "\x99\xf0", [0x3474] = "\x99\xf2",
  [0x3476] = "\x99\xf4", [0x347b] = "\x8d\xee", [0x347c] = "\x98\x61",
  [0x347e] = "\x99\xe9", [0x347f] = "\x99\xe7", [0x3480] = "\x99\xf3",
  [0x3482] = "\x99\xee", [0x3492] = "\x99\xf6", [0x3494] = "\x9a\x42",
  [0x3495] = "\x99\xf8", [0x3498] = "\x99\xfc", [0x349b] = "\x9a\x40",
  [0x349c] = "\x99\xf9", [0x349f] = "\x9a\x5d", [0x34a2] = "\x8d\xe7",
  [0x34a3] = "\x8a\x50", [0x34a8] = "\x99\xf7", [0x34ac] = "\x9a\x44",
  [0x34ad] = "\x88\xf4", [0x34ae] = "\x9a\x43", [0x34b0] = "\x88\xa3",
  [0x34b1] = "\x95\x69", [0x34b2] = "\x9a\x41", [0x34b4] = "\x99\xfa",
  [0x34b7] = "\x99\xf5", [0x34b8] = "\x99\xfb", [0x34b9] = "\x8d\xc6",
  [0x34c8] = "\x9a\x45", [0x34d1] = "\x88\xf5", [0x34d2] = "\x9a\x4e",
  [0x34d5] = "\x9a\x46", [0x34d6] = "\x9a\x47", [0x34d8] = "\x8f\xa3",
  [0x34d9] = "\x96\x89", [0x34dd] = "\x9a\x4c", [0x34de] = "\x9a\x4b",
  [0x34e2] = "\x93\x4e", [0x34ea] = "\x9a\x4d", [0x34ed] = "\x9a\x4a",
  [0x34f4] = "\x89\x53", [0x34f6] = "\x8d\xb4", [0x34f7] = "\x90\x4f",
  [0x34ff] = "\x9a\x48", [0x3500] = "\x93\x82", [0x3504] = "\x9a\x49",
  [0x3506] = "\x88\xa0", [0x351e] = "\x9a\x53", [0x351f] = "\x97\x42",
  [0x3521] = "\x8f\xa5", [0x3523] = "\x9a\x59", [0x3528] = "\x9a\x58",
  [0x3529] = "\x9a\x4f", [0x352e] = "\x91\xc1", [0x3530] = "\x9a\x50",
  [0x3534] = "\x91\xed", [0x3535] = "\x9a\x55", [0x3536] = "\x8f\xa4",
  [0x353c] = "\x9a\x52", [0x353f] = "\x96\xe2", [0x3543] = "\x8c\x5b",
  [0x3546] = "\x9a\x56", [0x3547] = "\x9a\x57", [0x354c] = "\x9a\x54",
  [0x354d] = "\x9a\x5a", [0x3553] = "\x9a\x51", [0x356b] = "\x9a\x60",
  [0x356c] = "\x9a\x65", [0x356e] = "\x9a\x61", [0x3570] = "\x9a\x5c",
  [0x3573] = "\x9a\x66", [0x3574] = "\x91\x50", [0x3577] = "\x9a\x68",
  [0x3579] = "\x8d\x41", [0x357a] = "\x9a\x5e", [0x357b] = "\x92\x9d",
  [0x3588] = "\x9a\x62", [0x3589] = "\x9a\x5b", [0x358a] = "\x8a\xab",
  [0x358c] = "\x8a\xec", [0x358d] = "\x8a\x85", [0x358e] = "\x9a\x63",
  [0x358f] = "\x9a\x5f", [0x3597] = "\x8c\x96", [0x3598] = "\x9a\x69",
  [0x3599] = "\x9a\x67", [0x359a] = "\x91\x72", [0x359b] = "\x8b\x69",
  [0x359c] = "\x8b\xaa", [0x359e] = "\x9a\x64", [0x35a0] = "\x8b\xf2",
  [0x35a6] = "\x89\x63", [0x35b4] = "\x9a\x6d", [0x35b5] = "\x9a\x6b",
  [0x35b7] = "\x9a\xa5", [0x35c4] = "\x9a\x70", [0x35ca] = "\x9a\x6a",
  [0x35cc] = "\x9a\x6e", [0x35cf] = "\x9a\x6c", [0x35d3] = "\x8e\x6b",
  [0x35d4] = "\x9a\x6f", [0x35e7] = "\x9a\x72", [0x35e9] = "\x9a\x77",
  [0x35ed] = "\x9a\x75", [0x35ee] = "\x9a\x74", [0x35f6] = "\x92\x51",
  [0x35f9] = "\x89\xc3", [0x3604] = "\x9a\x71", [0x3606] = "\x9a\x73",
  [0x3607] = "\x8f\xa6", [0x3608] = "\x89\x52", [0x360b] = "\x9a\x76",
  [0x3619] = "\x89\xdc", [0x361f] = "\x9a\x82", [0x3621] = "\x8f\xfa",
  [0x3622] = "\x9a\x7d", [0x3624] = "\x9a\x7b", [0x3626] = "\x9a\x7c",
  [0x3628] = "\x9a\x7e", [0x3632] = "\x89\x5c", [0x363c] = "\x91\x58",
  [0x363e] = "\x9a\x78", [0x3640] = "\x9a\x79", [0x364b] = "\x8a\x9a",
  [0x3654] = "\x9a\x81", [0x3658] = "\x8a\xed", [0x365a] = "\x9a\x84",
  [0x365b] = "\x9a\x80", [0x365c] = "\x9a\x83", [0x3664] = "\x95\xac",
  [0x3668] = "\x93\xd3", [0x366a] = "\x94\xb6", [0x3670] = "\x9a\x86",
  [0x3676] = "\x9a\x85", [0x3677] = "\x8a\x64", [0x367a] = "\x9a\x87",
  [0x367f] = "\x9a\x8a", [0x3684] = "\x9a\x89", [0x3690] = "\x9a\x88",
  [0x3692] = "\x94\x58", [0x3695] = "\x9a\x8b", [0x369e] = "\x9a\x8c",
  [0x36a4] = "\x9a\x8e", [0x36a6] = "\x9a\x8d", [0x36ac] = "\x9a\x90",
  [0x36b0] = "\x9a\x93", [0x36b1] = "\x9a\x91", [0x36b2] = "\x9a\x8f",
  [0x36b3] = "\x9a\x92", [0x36b8] = "\x9a\x94", [0x36be] = "\x9a\x95",
  [0x36c1] = "\x9a\x96", [0x36c3] = "\x9a\x97", [0x36c7] = "\x9a\x98",
  [0x36c8] = "\x99\x64", [0x36ca] = "\x8e\xfa", [0x36cb] = "\x8e\x6c",
  [0x36ce] = "\x89\xf1", [0x36d0] = "\x88\xf6", [0x36d3] = "\x92\x63",
  [0x36de] = "\x9a\x99", [0x36e0] = "\x8d\xa2", [0x36e2] = "\x88\xcd",
  [0x36e3] = "\x90\x7d", [0x36e9] = "\x9a\x9a", [0x36ea] = "\x8c\xc5",
  [0x36ed] = "\x8d\x91", [0x36ef] = "\x9a\x9c", [0x36f0] = "\x9a\x9b",
  [0x36f3] = "\x95\xde", [0x36f4] = "\x9a\x9d", [0x36f8] = "\x9a\x9f",
  [0x36f9] = "\x9a\x9e", [0x36fb] = "\x9a\xa0", [0x36fd] = "\x9a\xa1",
  [0x36ff] = "\x8c\x97", [0x3702] = "\x89\x80", [0x3703] = "\x9a\xa2",
  [0x3706] = "\x9a\xa4", [0x3708] = "\x9a\xa3", [0x370c] = "\x9a\xa6",
  [0x370f] = "\x93\x79", [0x3716] = "\x9a\xa7", [0x3717] = "\x88\xb3",
  [0x3718] = "\x8d\xdd", [0x371d] = "\x8c\x5c", [0x3720] = "\x92\x6e",
  [0x3727] = "\x9a\xa8", [0x3728] = "\x9a\xa9", [0x372b] = "\x9a\xab",
  [0x3730] = "\x9a\xac", [0x3732] = "\x8d\xe2", [0x3737] = "\x8b\xcf",
  [0x373a] = "\x96\x56", [0x373e] = "\x9a\xaa", [0x373f] = "\x9a\xad",
  [0x3740] = "\x8d\xbf", [0x3741] = "\x8d\x42", [0x3751] = "\x9a\xb1",
  [0x3754] = "\x8d\xa3", [0x3756] = "\x92\x52", [0x3759] = "\x9a\xae",
  [0x375a] = "\x92\xd8", [0x376f] = "\x9a\xb2", [0x3772] = "\x90\x82",
  [0x3778] = "\x9a\xb0", [0x3779] = "\x9a\xb3", [0x377b] = "\x8c\x5e",
  [0x3783] = "\x9a\xb4", [0x3790] = "\x9a\xb5", [0x3792] = "\x8d\x43",
  [0x3793] = "\x8a\x5f", [0x3794] = "\x9a\xb7", [0x379a] = "\x9a\xb8",
  [0x37a0] = "\x9a\xb9", [0x37a3] = "\x9a\xb6", [0x37b0] = "\x9a\xaf",
  [0x37b3] = "\x9a\xba", [0x37b6] = "\x9a\xbb", [0x37bb] = "\x96\x84",
  [0x37be] = "\x8f\xe9", [0x37c2] = "\x9a\xbd", [0x37c3] = "\x9a\xbe",
  [0x37c4] = "\x9a\xbc", [0x37c6] = "\x9a\xc0", [0x37cc] = "\x94\x57",
  [0x37cf] = "\x88\xe6", [0x37d0] = "\x95\x75", [0x37d3] = "\x9a\xc1",
  [0x37e4] = "\x8f\xfb", [0x37e7] = "\x8e\xb7", [0x37e9] = "\x94\x7c",
  [0x37ea] = "\x8a\xee", [0x37ec] = "\x8d\xe9", [0x37f0] = "\x96\x78",
  [0x37f2] = "\x93\xb0", [0x37f5] = "\x8c\x98", [0x37f6] = "\x91\xcd",
  [0x37fa] = "\x9a\xbf", [0x37fb] = "\x9a\xc2", [0x3805] = "\x91\xc2",
  [0x3809] = "\x9a\xc3", [0x380d] = "\x9a\xc4", [0x3811] = "\x9a\xc6",
  [0x3814] = "\x92\xe7", [0x381a] = "\x8a\xac", [0x381f] = "\xea\x9f",
  [0x3820] = "\x89\x81", [0x3821] = "\x95\xf1", [0x3824] = "\x8f\xea",
  [0x3825] = "\x93\x67", [0x382a] = "\x8d\xe4", [0x382d] = "\x9a\xcc",
  [0x3830] = "\x95\xbb", [0x3831] = "\x97\xdb", [0x383a] = "\x89\xf2",
  [0x383b] = "\x9a\xc8", [0x3841] = "\x91\x59", [0x3842] = "\x9a\xcb",
  [0x3844] = "\x93\x83", [0x3847] = "\x93\x68", [0x3848] = "\x93\x84",
  [0x3849] = "\x94\xb7", [0x384a] = "\x92\xcb", [0x384e] = "\x8d\xc7",
  [0x3852] = "\x9a\xc7", [0x3859] = "\x89\x96", [0x385b] = "\x93\x55",
  [0x3860] = "\x9a\xc9", [0x3862] = "\x9a\xc5", [0x3865] = "\x90\x6f",
  [0x3869] = "\x9a\xcd", [0x386e] = "\x8f\x6d", [0x3873] = "\x8b\xab",
  [0x3875] = "\x9a\xce", [0x3883] = "\x95\xe6", [0x3887] = "\x91\x9d",
  [0x388c] = "\x92\xc4", [0x388f] = "\x9a\xd0", [0x3898] = "\x96\x6e",
  [0x389b] = "\x9a\xd1", [0x389e] = "\x9a\xd6", [0x38a3] = "\x95\xad",
  [0x38a8] = "\x9a\xd5", [0x38a9] = "\x9a\xcf", [0x38aa] = "\x9a\xd2",
  [0x38ab] = "\x9a\xd4", [0x38ae] = "\x8d\xa4", [0x38b1] = "\x95\xc7",
  [0x38b5] = "\x9a\xd7", [0x38b7] = "\x92\x64", [0x38ba] = "\x89\xf3",
  [0x38bc] = "\x8f\xeb", [0x38c1] = "\x9a\xd9", [0x38c3] = "\x9a\xd8",
  [0x38c5] = "\x8d\x88", [0x38c7] = "\x9a\xda", [0x38c8] = "\x9a\xdc",
  [0x38c9] = "\x9a\xdb", [0x38cc] = "\x9a\xde", [0x38ce] = "\x9a\xd3",
  [0x38cf] = "\x9a\xe0", [0x38d4] = "\x9a\xdf", [0x38d5] = "\x9a\xdd",
  [0x38db] = "\x8e\x6d", [0x38dc] = "\x90\x70", [0x38de] = "\x91\x73",
  [0x38df] = "\x9a\xe1", [0x38e0] = "\x90\xba", [0x38e1] = "\x88\xeb",
  [0x38e2] = "\x94\x84", [0x38e7] = "\x92\xd9", [0x38e9] = "\x9a\xe3",
  [0x38ea] = "\x9a\xe2", [0x38eb] = "\x9a\xe4", [0x38ec] = "\x9a\xe5",
  [0x38ed] = "\x9a\xe6", [0x38f2] = "\x9a\xe7", [0x38f9] = "\x95\xcf",
  [0x38fa] = "\x9a\xe8", [0x38ff] = "\x89\xc4", [0x3900] = "\x9a\xe9",
  [0x3905] = "\x97\x5b", [0x3906] = "\x8a\x4f", [0x3908] = "\x99\xc7",
  [0x3909] = "\x8f\x67", [0x390a] = "\x91\xbd", [0x390b] = "\x9a\xea",
  [0x390c] = "\x96\xe9", [0x3912] = "\x96\xb2", [0x3915] = "\x9a\xec",
  [0x3917] = "\x91\xe5", [0x3919] = "\x93\x56", [0x391a] = "\x91\xbe",
  [0x391b] = "\x95\x76", [0x391c] = "\x9a\xed", [0x391d] = "\x9a\xee",
  [0x391e] = "\x89\x9b", [0x3921] = "\x8e\xb8", [0x3922] = "\x9a\xef",
  [0x3927] = "\x88\xce", [0x3928] = "\x9a\xf0", [0x392e] = "\x9a\xf1",
  [0x3934] = "\x89\x82", [0x3937] = "\x8a\xef", [0x3938] = "\x93\xde",
  [0x3939] = "\x95\xf2", [0x393e] = "\x9a\xf5", [0x393f] = "\x91\x74",
  [0x3940] = "\x9a\xf4", [0x3941] = "\x8c\x5f", [0x3944] = "\x96\x7a",
  [0x3945] = "\x9a\xf3", [0x3947] = "\x93\x85", [0x3948] = "\x9a\xf7",
  [0x394a] = "\x9a\xf6", [0x3950] = "\x9a\xf9", [0x3952] = "\x9a\xf8",
  [0x3955] = "\x89\x9c", [0x3957] = "\x9a\xfa", [0x3958] = "\x8f\xa7",
  [0x3959] = "\x9a\xfc", [0x395a] = "\x92\x44", [0x395c] = "\x9a\xfb",
  [0x395e] = "\x95\xb1", [0x3963] = "\x8f\x97", [0x3964] = "\x93\x7a",
  [0x3968] = "\x9b\x40", [0x396d] = "\x8d\x44", [0x3971] = "\x9b\x41",
  [0x3972] = "\x94\x40", [0x3973] = "\x94\xdc", [0x3974] = "\x96\xcf",
  [0x397a] = "\x94\x44", [0x397d] = "\x9b\x4a", [0x3983] = "\x8b\x57",
  [0x3986] = "\x97\x64", [0x3989] = "\x96\xad", [0x398b] = "\x9b\xaa",
  [0x398d] = "\x9b\x42", [0x3993] = "\x9b\x45", [0x3995] = "\x91\xc3",
  [0x3998] = "\x96\x57", [0x399c] = "\x93\x69", [0x39a2] = "\x9b\x46",
  [0x39a9] = "\x96\x85", [0x39ab] = "\x8d\xc8", [0x39ae] = "\x8f\xa8",
  [0x39b6] = "\x9b\x47", [0x39b9] = "\x8e\x6f", [0x39bb] = "\x8e\x6e",
  [0x39c0] = "\x88\xb7", [0x39c1] = "\x8c\xc6", [0x39c3] = "\x90\xa9",
  [0x39c4] = "\x88\xcf", [0x39c9] = "\x9b\x4b", [0x39ca] = "\x9b\x4c",
  [0x39cc] = "\x9b\x49", [0x39d5] = "\x89\x57", [0x39d6] = "\x8a\xad",
  [0x39d8] = "\x9b\x48", [0x39da] = "\x96\xc3", [0x39db] = "\x95\x50",
  [0x39e6] = "\x88\xa6", [0x39eb] = "\x88\xf7", [0x39ef] = "\x8e\x70",
  [0x39f1] = "\x88\xd0", [0x39f3] = "\x88\xa1", [0x39f9] = "\x9b\x51",
  [0x3a01] = "\x9b\x4f", [0x3a08] = "\x96\xba", [0x3a0a] = "\x9b\x52",
  [0x3a0c] = "\x9b\x50", [0x3a0f] = "\x9b\x4e", [0x3a10] = "\x90\x50",
  [0x3a15] = "\x9b\x4d", [0x3a19] = "\x95\xd8", [0x3a1f] = "\x8c\xe2",
  [0x3a25] = "\x9b\x56", [0x3a26] = "\x9b\x57", [0x3a2c] = "\x8f\xa9",
  [0x3a30] = "\x9b\x53", [0x3a31] = "\x98\x4b", [0x3a36] = "\x94\x6b",
  [0x3a39] = "\x9b\x55", [0x3a4a] = "\x8d\xa5", [0x3a52] = "\x9b\x58",
  [0x3a56] = "\x95\x77", [0x3a5a] = "\x9b\x59", [0x3a5c] = "\x9b\x54",
  [0x3a6f] = "\x96\xb9", [0x3a82] = "\x94\x7d", [0x3a8a] = "\x9b\x5a",
  [0x3a8b] = "\x95\x51", [0x3aac] = "\x9b\x5b", [0x3aad] = "\x9b\x5f",
  [0x3aae] = "\x9b\x5c", [0x3ab1] = "\x89\xc5", [0x3ab2] = "\x9b\x5e",
  [0x3ab9] = "\x8e\xb9", [0x3abb] = "\x9b\x5d", [0x3abc] = "\x8c\x99",
  [0x3ac0] = "\x9b\x6b", [0x3ac6] = "\x9b\x64", [0x3ac7] = "\x9b\x61",
  [0x3ad1] = "\x92\x84", [0x3ad3] = "\x9b\x60", [0x3ad6] = "\x9b\x62",
  [0x3ad9] = "\x9b\x63", [0x3aea] = "\x9b\x65", [0x3aeb] = "\x9b\x66",
  [0x3af9] = "\x8a\xf0", [0x3afb] = "\x9b\x68", [0x3afc] = "\x9b\x67",
  [0x3b06] = "\x9b\x69", [0x3b12] = "\x8f\xec", [0x3b1a] = "\x9b\x6c",
  [0x3b1c] = "\x92\xda", [0x3b20] = "\x89\x64", [0x3b22] = "\x9b\x6a",
  [0x3b26] = "\x9b\x6d", [0x3b2e] = "\x9b\x6e", [0x3b30] = "\x9b\x71",
  [0x3b33] = "\x9b\x6f", [0x3b35] = "\x9b\x70", [0x3b40] = "\x8e\x71",
  [0x3b41] = "\x9b\x72", [0x3b44] = "\x8d\x45", [0x3b45] = "\x9b\x73",
  [0x3b47] = "\x8e\x9a", [0x3b48] = "\x91\xb6", [0x3b4a] = "\x9b\x74",
  [0x3b4b] = "\x9b\x75", [0x3b4c] = "\x8e\x79", [0x3b4d] = "\x8d\x46",
  [0x3b4f] = "\x96\xd0", [0x3b53] = "\x8b\x47", [0x3b54] = "\x8c\xc7",
  [0x3b55] = "\x9b\x76", [0x3b56] = "\x8a\x77", [0x3b59] = "\x9b\x77",
  [0x3b5b] = "\x91\xb7", [0x3b60] = "\x9b\x78", [0x3b61] = "\x9b\xa1",
  [0x3b63] = "\x9b\x79", [0x3b65] = "\x9b\x7a", [0x3b68] = "\x9b\x7b",
  [0x3b6a] = "\x9b\x7d", [0x3b70] = "\x9b\x7e", [0x3b73] = "\x9b\x80",
  [0x3b75] = "\x91\xee", [0x3b77] = "\x89\x46", [0x3b78] = "\x8e\xe7",
  [0x3b79] = "\x88\xc0", [0x3b7b] = "\x91\x76", [0x3b7c] = "\x8a\xae",
  [0x3b7d] = "\x8e\xb3", [0x3b7f] = "\x8d\x47", [0x3b85] = "\x93\x86",
  [0x3b87] = "\x8f\x40", [0x3b88] = "\x8a\xaf", [0x3b89] = "\x92\x88",
  [0x3b8a] = "\x92\xe8", [0x3b8b] = "\x88\xb6", [0x3b8c] = "\x8b\x58",
  [0x3b8d] = "\x95\xf3", [0x3b8f] = "\x8e\xc0", [0x3b92] = "\x8b\x71",
  [0x3b93] = "\x90\xe9", [0x3b94] = "\x8e\xba", [0x3b95] = "\x97\x47",
  [0x3b96] = "\x9b\x81", [0x3b9e] = "\x8b\x7b", [0x3ba0] = "\x8d\xc9",
  [0x3ba3] = "\x8a\x51", [0x3ba4] = "\x89\x83", [0x3ba5] = "\x8f\xaa",
  [0x3ba6] = "\x89\xc6", [0x3ba8] = "\x9b\x82", [0x3ba9] = "\x97\x65",
  [0x3baf] = "\x8f\x68", [0x3bb2] = "\x8e\xe2", [0x3bb3] = "\x9b\x83",
  [0x3bb4] = "\x8a\xf1", [0x3bb5] = "\x93\xd0", [0x3bb6] = "\x96\xa7",
  [0x3bb7] = "\x9b\x84", [0x3bb9] = "\x9b\x85", [0x3bbc] = "\x95\x78",
  [0x3bc0] = "\x9b\x87", [0x3bc2] = "\x8a\xa6", [0x3bc3] = "\x8b\xf5",
  [0x3bc4] = "\x9b\x86", [0x3bcb] = "\x8a\xb0", [0x3bcd] = "\x90\x51",
  [0x3bce] = "\x9b\x8b", [0x3bcf] = "\x8e\x40", [0x3bd1] = "\x89\xc7",
  [0x3bd2] = "\x9b\x8a", [0x3bd4] = "\x9b\x88", [0x3bd5] = "\x9b\x8c",
  [0x3bd6] = "\x9b\x89", [0x3bd7] = "\x94\x4a", [0x3bd8] = "\x9e\xcb",
  [0x3bd9] = "\x90\x52", [0x3bdb] = "\x9b\x8d", [0x3bde] = "\x97\xbe",
  [0x3be0] = "\x9b\x8e", [0x3be3] = "\x9b\x90", [0x3be5] = "\x92\x9e",
  [0x3be6] = "\x9b\x8f", [0x3be8] = "\x90\xa1", [0x3bea] = "\x8e\x9b",
  [0x3bee] = "\x91\xce", [0x3bef] = "\x8e\xf5", [0x3bf1] = "\x95\x95",
  [0x3bf2] = "\x90\xea", [0x3bf4] = "\x8e\xcb", [0x3bf5] = "\x9b\x91",
  [0x3bf6] = "\x8f\xab", [0x3bf7] = "\x9b\x92", [0x3bf8] = "\x9b\x93",
  [0x3bf9] = "\x88\xd1", [0x3bfa] = "\x91\xb8", [0x3bfb] = "\x90\x71",
  [0x3bfd] = "\x9b\x94", [0x3bfe] = "\x93\xb1", [0x3bff] = "\x8f\xac",
  [0x3c01] = "\x8f\xad", [0x3c03] = "\x9b\x95", [0x3c06] = "\x90\xeb",
  [0x3c0a] = "\x8f\xae", [0x3c10] = "\x9b\x96", [0x3c12] = "\x9b\x97",
  [0x3c14] = "\x96\xde", [0x3c18] = "\x9b\x98", [0x3c1d] = "\x8b\xc4",
  [0x3c21] = "\x8f\x41", [0x3c28] = "\x9b\x99", [0x3c29] = "\x9b\x9a",
  [0x3c2a] = "\x8e\xda", [0x3c2b] = "\x90\x4b", [0x3c2c] = "\x93\xf2",
  [0x3c2d] = "\x90\x73", [0x3c2e] = "\x94\xf6", [0x3c2f] = "\x94\x41",
  [0x3c30] = "\x8b\xc7", [0x3c31] = "\x9b\x9b", [0x3c35] = "\x8b\x8f",
  [0x3c36] = "\x9b\x9c", [0x3c38] = "\x8b\xfc", [0x3c3a] = "\x93\xcd",
  [0x3c3b] = "\x89\xae", [0x3c3d] = "\x8e\x72", [0x3c3e] = "\x9b\x9d",
  [0x3c3f] = "\x9b\xa0", [0x3c40] = "\x9b\x9f", [0x3c41] = "\x8b\xfb",
  [0x3c43] = "\x9b\x9e", [0x3c45] = "\x93\x57", [0x3c4e] = "\x91\xae",
  [0x3c50] = "\x93\x6a", [0x3c51] = "\x8e\xc6", [0x3c54] = "\x91\x77",
  [0x3c55] = "\x97\x9a", [0x3c5c] = "\x9b\xa2", [0x3c5e] = "\x9b\xa3",
  [0x3c5f] = "\x93\xd4", [0x3c61] = "\x8e\x52", [0x3c66] = "\x9b\xa5",
  [0x3c69] = "\x9b\xa6", [0x3c7c] = "\x9b\xa7", [0x3c80] = "\x8a\xf2",
  [0x3c81] = "\x9b\xa8", [0x3c84] = "\x9b\xa9", [0x3c91] = "\x89\xaa",
  [0x3c98] = "\x91\x5a", [0x3c99] = "\x8a\xe2", [0x3c9b] = "\x9b\xab",
  [0x3c9c] = "\x96\xa6", [0x3ca1] = "\x91\xd0", [0x3ca3] = "\x8a\x78",
  [0x3ca6] = "\x9b\xad", [0x3ca7] = "\x9b\xaf", [0x3ca8] = "\x8a\xdd",
  [0x3cab] = "\x9b\xac", [0x3cac] = "\x9b\xae", [0x3cae] = "\x9b\xb1",
  [0x3cb5] = "\x9b\xb0", [0x3cb7] = "\x9b\xb2", [0x3cc9] = "\x9b\xb3",
  [0x3cd0] = "\x93\xbb", [0x3cd1] = "\x8b\xac", [0x3cd8] = "\x89\xe3",
  [0x3cd9] = "\x9b\xb4", [0x3cda] = "\x9b\xb9", [0x3cdd] = "\x9b\xb7",
  [0x3cdf] = "\x95\xf5", [0x3ce0] = "\x95\xf4", [0x3ce6] = "\x93\x87",
  [0x3cea] = "\x9b\xb6", [0x3ceb] = "\x8f\x73", [0x3ced] = "\x9b\xb5",
  [0x3cf7] = "\x90\x92", [0x3cfb] = "\x9b\xba", [0x3cfe] = "\x8d\xe8",
  [0x3d01] = "\x9b\xc0", [0x3d04] = "\x9b\xc1", [0x3d05] = "\x9b\xbb",
  [0x3d06] = "\x8a\x52", [0x3d07] = "\x9b\xbc", [0x3d08] = "\x9b\xc5",
  [0x3d09] = "\x9b\xc4", [0x3d0a] = "\x9b\xc3", [0x3d0b] = "\x9b\xbf",
  [0x3d0f] = "\x9b\xbe", [0x3d12] = "\x9b\xc2", [0x3d19] = "\x95\xf6",
  [0x3d3b] = "\x9b\xc9", [0x3d3c] = "\x9b\xc6", [0x3d3e] = "\x9b\xc8",
  [0x3d40] = "\x97\x92", [0x3d42] = "\x9b\xc7", [0x3d4c] = "\x9b\xbd",
  [0x3d59] = "\x90\x93", [0x3d5c] = "\x9b\xca", [0x3d5f] = "\x8d\xb5",
  [0x3d63] = "\x9b\xcb", [0x3d66] = "\x9b\xcc", [0x3d72] = "\x9b\xcf",
  [0x3d74] = "\x9b\xce", [0x3d77] = "\x9b\xcd", [0x3d7b] = "\x93\x88",
  [0x3d7c] = "\x9b\xb8", [0x3d80] = "\x9b\xd5", [0x3d8d] = "\x9b\xd1",
  [0x3d92] = "\x9b\xd0", [0x3d9c] = "\x9b\xd2", [0x3d9e] = "\x9b\xd3",
  [0x3da7] = "\x9b\xd6", [0x3daa] = "\x97\xe4", [0x3dac] = "\x9b\xd7",
  [0x3dad] = "\x9b\xd4", [0x3db9] = "\x9b\xd8", [0x3dbc] = "\x8a\xde",
  [0x3dbd] = "\x9b\xd9", [0x3dc2] = "\x9b\xdb", [0x3dc3] = "\x9b\xda",
  [0x3dc6] = "\x9b\xdc", [0x3dcb] = "\x9b\xdd", [0x3dcd] = "\x90\xec",
  [0x3dce] = "\x8f\x42", [0x3dd1] = "\x8f\x84", [0x3dd3] = "\x91\x83",
  [0x3dd5] = "\x8d\x48", [0x3dd6] = "\x8d\xb6", [0x3dd7] = "\x8d\x49",
  [0x3dd8] = "\x8b\x90", [0x3ddb] = "\x9b\xde", [0x3dde] = "\x8d\xb7",
  [0x3de1] = "\x8c\xc8", [0x3de2] = "\x9b\xdf", [0x3de3] = "\x96\xa4",
  [0x3de4] = "\x94\x62", [0x3de5] = "\x9b\xe0", [0x3de7] = "\x8d\x4a",
  [0x3deb] = "\x8a\xaa", [0x3ded] = "\x92\x46", [0x3dee] = "\x8b\xd0",
  [0x3df2] = "\x8e\x73", [0x3df3] = "\x95\x7a", [0x3df6] = "\x94\xbf",
  [0x3dfb] = "\x9b\xe1", [0x3dfc] = "\x8a\xf3", [0x3e01] = "\x9b\xe4",
  [0x3e06] = "\x92\x9f", [0x3e09] = "\x9b\xe3", [0x3e0a] = "\x9b\xe2",
  [0x3e0b] = "\x9b\xe5", [0x3e0d] = "\x92\xe9", [0x3e15] = "\x90\x83",
  [0x3e1b] = "\x8e\x74", [0x3e1d] = "\x90\xc8", [0x3e1f] = "\x91\xd1",
  [0x3e20] = "\x8b\x41", [0x3e23] = "\x92\xa0", [0x3e26] = "\x9b\xe6",
  [0x3e27] = "\x9b\xe7", [0x3e28] = "\x8f\xed", [0x3e2d] = "\x96\x58",
  [0x3e30] = "\x9b\xea", [0x3e33] = "\x9b\xe9", [0x3e34] = "\x9b\xe8",
  [0x3e35] = "\x95\x9d", [0x3e37] = "\x9b\xf1", [0x3e3c] = "\x96\x79",
  [0x3e3e] = "\x9b\xeb", [0x3e44] = "\x9b\xed", [0x3e45] = "\x96\x8b",
  [0x3e47] = "\x9b\xec", [0x3e4f] = "\x9b\xee", [0x3e51] = "\x94\xa6",
  [0x3e52] = "\x9b\xef", [0x3e53] = "\x95\xbc", [0x3e54] = "\x9b\xf0",
  [0x3e62] = "\x8a\xb1", [0x3e63] = "\x95\xbd", [0x3e64] = "\x94\x4e",
  [0x3e65] = "\x9b\xf2", [0x3e66] = "\x9b\xf3", [0x3e68] = "\x8d\x4b",
  [0x3e69] = "\x8a\xb2", [0x3e6a] = "\x9b\xf4", [0x3e6b] = "\x8c\xb6",
  [0x3e6c] = "\x97\x63", [0x3e6d] = "\x97\x48", [0x3e6e] = "\x8a\xf4",
  [0x3e6f] = "\x9b\xf6", [0x3e71] = "\x92\xa1", [0x3e73] = "\x8d\x4c",
  [0x3e74] = "\x8f\xaf", [0x3e77] = "\x94\xdd", [0x3e7a] = "\x8f\xb0",
  [0x3e7f] = "\x8f\x98", [0x3e85] = "\x92\xea", [0x3e86] = "\x95\xf7",
  [0x3e87] = "\x93\x58", [0x3e8a] = "\x8d\x4d", [0x3e8c] = "\x95\x7b",
  [0x3e90] = "\x9b\xf7", [0x3e96] = "\x93\x78", [0x3e97] = "\x8d\xc0",
  [0x3e9b] = "\x8c\xc9", [0x3e9d] = "\x92\xeb", [0x3ea5] = "\x88\xc1",
  [0x3ea6] = "\x8f\x8e", [0x3ea7] = "\x8d\x4e", [0x3ea8] = "\x97\x66",
  [0x3eb1] = "\x9b\xf8", [0x3eb2] = "\x9b\xf9", [0x3eb3] = "\x94\x70",
  [0x3eb8] = "\x9b\xfa", [0x3eb9] = "\x97\xf5", [0x3eba] = "\x98\x4c",
  [0x3ebf] = "\x9b\xfc", [0x3ec0] = "\x9b\xfb", [0x3ec3] = "\x8a\x66",
  [0x3ec6] = "\x9c\x40", [0x3eca] = "\x9c\x43", [0x3ecb] = "\x9c\x44",
  [0x3ecd] = "\x9c\x42", [0x3ecf] = "\x95\x5f", [0x3ed0] = "\x8f\xb1",
  [0x3ed1] = "\x9c\x46", [0x3ed2] = "\x9c\x45", [0x3ed3] = "\x9c\x41",
  [0x3ed8] = "\x9c\x47", [0x3ed9] = "\x9c\x48", [0x3edc] = "\x9c\x49",
  [0x3ee0] = "\x9c\x4c", [0x3ee1] = "\x9c\x4a", [0x3ee3] = "\x9c\x4b",
  [0x3ee4] = "\x9c\x4d", [0x3ee6] = "\x89\x84", [0x3ee7] = "\x92\xec",
  [0x3ee8] = "\x9c\x4e", [0x3eea] = "\x8c\x9a", [0x3eeb] = "\x89\xf4",
  [0x3eec] = "\x94\x55", [0x3eee] = "\x9c\x4f", [0x3eef] = "\x93\xf9",
  [0x3ef1] = "\x95\xd9", [0x3ef3] = "\x9c\x50", [0x3ef4] = "\x98\x4d",
  [0x3ef9] = "\x9c\x51", [0x3efa] = "\x95\xbe", [0x3efb] = "\x9c\x54",
  [0x3efc] = "\x98\x9f", [0x3efd] = "\x98\xaf", [0x3eff] = "\x8e\xae",
  [0x3f00] = "\x93\xf3", [0x3f01] = "\x9c\x55", [0x3f03] = "\x8b\x7c",
  [0x3f04] = "\x92\xa2", [0x3f05] = "\x88\xf8", [0x3f06] = "\x9c\x56",
  [0x3f07] = "\x95\xa4", [0x3f08] = "\x8d\x4f", [0x3f0b] = "\x92\x6f",
  [0x3f0f] = "\x92\xed", [0x3f15] = "\x96\xed", [0x3f16] = "\x8c\xb7",
  [0x3f17] = "\x8c\xca", [0x3f19] = "\x9c\x57", [0x3f1d] = "\x9c\x58",
  [0x3f1f] = "\x9c\x5e", [0x3f21] = "\x8e\xe3", [0x3f25] = "\x92\xa3",
  [0x3f27] = "\x8b\xad", [0x3f28] = "\x9c\x59", [0x3f2c] = "\x95\x4a",
  [0x3f2e] = "\x92\x65", [0x3f31] = "\x9c\x5a", [0x3f38] = "\x9c\x5b",
  [0x3f3a] = "\x8b\xae", [0x3f3c] = "\x9c\x5c", [0x3f3e] = "\x9c\x5d",
  [0x3f41] = "\x9c\x5f", [0x3f43] = "\x93\x96", [0x3f46] = "\x9c\x60",
  [0x3f47] = "\x9c\x61", [0x3f49] = "\x9c\x62", [0x3f4c] = "\x9c\x53",
  [0x3f4d] = "\x9c\x52", [0x3f51] = "\x9c\x63", [0x3f52] = "\x8c\x60",
  [0x3f56] = "\x95\x46", [0x3f59] = "\x8d\xca", [0x3f5a] = "\x95\x56",
  [0x3f5b] = "\x92\xa4", [0x3f5c] = "\x95\x6a", [0x3f5d] = "\x9c\x64",
  [0x3f60] = "\x8f\xb2", [0x3f61] = "\x89\x65", [0x3f63] = "\x9c\x65",
  [0x3f67] = "\x9c\x66", [0x3f69] = "\x96\xf0", [0x3f6c] = "\x94\xde",
  [0x3f6f] = "\x9c\x69", [0x3f70] = "\x89\x9d", [0x3f71] = "\x90\xaa",
  [0x3f72] = "\x9c\x68", [0x3f73] = "\x9c\x67", [0x3f74] = "\x8c\x61",
  [0x3f75] = "\x91\xd2", [0x3f77] = "\x9c\x6d", [0x3f78] = "\x9c\x6b",
  [0x3f7a] = "\x9c\x6a", [0x3f7b] = "\x97\xa5", [0x3f7c] = "\x8c\xe3",
  [0x3f80] = "\x8f\x99", [0x3f81] = "\x9c\x6c", [0x3f82] = "\x93\x6b",
  [0x3f83] = "\x8f\x5d", [0x3f87] = "\x93\xbe", [0x3f88] = "\x9c\x70",
  [0x3f89] = "\x9c\x6f", [0x3f8e] = "\x9c\x6e", [0x3f90] = "\x9c\x71",
  [0x3f91] = "\x8c\xe4", [0x3f98] = "\x9c\x72", [0x3f99] = "\x95\x9c",
  [0x3f9a] = "\x8f\x7a", [0x3f9d] = "\x9c\x73", [0x3f9e] = "\x94\xf7",
  [0x3fa3] = "\x93\xbf", [0x3fa4] = "\x92\xa5", [0x3fa9] = "\x93\x4f",
  [0x3fac] = "\x9c\x74", [0x3fad] = "\x8b\x4a", [0x3fb3] = "\x90\x53",
  [0x3fb5] = "\x95\x4b", [0x3fbc] = "\x8a\xf5", [0x3fbd] = "\x94\x45",
  [0x3fc6] = "\x9c\x75", [0x3fc7] = "\x8e\x75", [0x3fc8] = "\x96\x59",
  [0x3fc9] = "\x96\x5a", [0x3fcc] = "\x89\x9e", [0x3fcd] = "\x9c\x7a",
  [0x3fd0] = "\x92\x89", [0x3fd4] = "\x9c\x77", [0x3fdb] = "\x89\xf5",
  [0x3fe0] = "\x9c\xab", [0x3fe1] = "\x9c\x79", [0x3fe5] = "\x94\x4f",
  [0x3fe8] = "\x9c\x78", [0x3feb] = "\x9c\x76", [0x3fed] = "\x8d\x9a",
  [0x3fef] = "\x9c\x7c", [0x3ffe] = "\x9c\x83", [0x3fff] = "\x9c\x89",
  [0x4000] = "\x9c\x81", [0x4002] = "\x93\x7b", [0x4005] = "\x9c\x86",
  [0x4006] = "\x95\x7c", [0x4009] = "\x9c\x80", [0x400b] = "\x9c\x85",
  [0x400c] = "\x97\xe5", [0x400d] = "\x8e\x76", [0x4010] = "\x91\xd3",
  [0x4011] = "\x9c\x7d", [0x4015] = "\x8b\x7d", [0x4016] = "\x9c\x88",
  [0x4017] = "\x90\xab", [0x4018] = "\x89\x85", [0x4019] = "\x9c\x82",
  [0x401a] = "\x89\xf6", [0x401b] = "\x9c\x87", [0x401f] = "\x8b\xaf",
  [0x4021] = "\x9c\x84", [0x402a] = "\x9c\x8a", [0x4031] = "\x9c\x8c",
  [0x4032] = "\x9c\x96", [0x4033] = "\x9c\x94", [0x4036] = "\x9c\x91",
  [0x403a] = "\x9c\x90", [0x403b] = "\x97\xf6", [0x403d] = "\x9c\x92",
  [0x4040] = "\x8b\xb0", [0x4042] = "\x8d\x50", [0x4045] = "\x8f\x9a",
  [0x4049] = "\x9c\x99", [0x404a] = "\x9c\x8b", [0x404f] = "\x9c\x8f",
  [0x4050] = "\x9c\x7e", [0x4052] = "\x89\xf8", [0x4053] = "\x9c\x93",
  [0x4054] = "\x9c\x95", [0x4055] = "\x92\x70", [0x4058] = "\x8d\xa6",
  [0x4059] = "\x89\xb6", [0x405a] = "\x9c\x8d", [0x405b] = "\x9c\x98",
  [0x405c] = "\x9c\x97", [0x405d] = "\x8b\xb1", [0x405f] = "\x91\xa7",
  [0x4060] = "\x8a\x86", [0x4065] = "\x8c\x62", [0x4067] = "\x9c\x8e",
  [0x4071] = "\x9c\x9a", [0x4073] = "\x9c\x9d", [0x4074] = "\x9c\x9f",
  [0x4079] = "\x8e\xbb", [0x407b] = "\x9c\xa5", [0x407c] = "\x92\xee",
  [0x407d] = "\x9c\x9b", [0x4082] = "\x9c\xa3", [0x4084] = "\x89\xf7",
  [0x4086] = "\x9c\xa1", [0x4087] = "\x9c\xa2", [0x408a] = "\x9c\x9e",
  [0x408b] = "\x9c\xa0", [0x408f] = "\x8c\xe5", [0x4090] = "\x97\x49",
  [0x4093] = "\x8a\xb3", [0x4096] = "\x89\x78", [0x4097] = "\x9c\xa4",
  [0x4099] = "\x94\x59", [0x409a] = "\x88\xab", [0x40a2] = "\x94\xdf",
  [0x40a3] = "\x9c\x7b", [0x40a4] = "\x9c\xaa", [0x40a5] = "\x9c\xae",
  [0x40a6] = "\x96\xe3", [0x40a8] = "\x9c\xa7", [0x40ac] = "\x93\x89",
  [0x40ad] = "\x9c\xac", [0x40b5] = "\x8f\xee", [0x40b6] = "\x9c\xad",
  [0x40b7] = "\x93\xd5", [0x40c1] = "\x98\x66", [0x40c3] = "\x9c\xa9",
  [0x40c8] = "\x9c\xaf", [0x40ca] = "\x8d\x9b", [0x40cc] = "\x90\xc9",
  [0x40cf] = "\x88\xd2", [0x40d0] = "\x9c\xa8", [0x40d1] = "\x9c\xa6",
  [0x40d3] = "\x91\x79", [0x40d7] = "\x9c\x9c", [0x40d8] = "\x8e\x53",
  [0x40e0] = "\x91\xc4", [0x40e1] = "\x9c\xbb", [0x40e3] = "\x91\x7a",
  [0x40e4] = "\x9c\xb6", [0x40e6] = "\x9c\xb3", [0x40e7] = "\x9c\xb4",
  [0x40e9] = "\x8e\xe4", [0x40ea] = "\x9c\xb7", [0x40eb] = "\x9c\xba",
  [0x40f0] = "\x9c\xb5", [0x40f1] = "\x8f\x44", [0x40f3] = "\x9c\xb8",
  [0x40f6] = "\x9c\xb2", [0x40f8] = "\x96\xfa", [0x40f9] = "\x96\xf9",
  [0x40fd] = "\x9c\xbc", [0x40fe] = "\x9c\xbd", [0x40ff] = "\x88\xd3",
  [0x4105] = "\x9c\xb1", [0x410a] = "\x8b\xf0", [0x410b] = "\x88\xa4",
  [0x410f] = "\x8a\xb4", [0x4111] = "\x9c\xb9", [0x4117] = "\x9c\xc1",
  [0x4118] = "\x9c\xc0", [0x411c] = "\x9c\xc5", [0x4124] = "\x9c\xc6",
  [0x412c] = "\x9c\xc4", [0x412d] = "\x9c\xc7", [0x412e] = "\x9c\xbf",
  [0x412f] = "\x9c\xc3", [0x4132] = "\x9c\xc8", [0x4134] = "\x9c\xc9",
  [0x4137] = "\x9c\xbe", [0x4138] = "\x8e\x9c", [0x413a] = "\x9c\xc2",
  [0x413b] = "\x91\xd4", [0x413c] = "\x8d\x51", [0x413d] = "\x9c\xb0",
  [0x413e] = "\x90\x54", [0x4143] = "\x9c\xd6", [0x4145] = "\x95\xe7",
  [0x4148] = "\x9c\xcc", [0x4149] = "\x9c\xcd", [0x414a] = "\x9c\xce",
  [0x414d] = "\x9c\xd5", [0x414f] = "\x9c\xd4", [0x4152] = "\x96\x9d",
  [0x4153] = "\x8a\xb5", [0x4155] = "\x9c\xd2", [0x4157] = "\x8c\x64",
  [0x4158] = "\x8a\x53", [0x415b] = "\x9c\xcf", [0x415e] = "\x97\xb6",
  [0x415f] = "\x9c\xd1", [0x4160] = "\x88\xd4", [0x4161] = "\x9c\xd3",
  [0x4163] = "\x9c\xca", [0x4164] = "\x9c\xd0", [0x4165] = "\x9c\xd7",
  [0x4166] = "\x8c\x63", [0x4167] = "\x9c\xcb", [0x416e] = "\x97\x7c",
  [0x4172] = "\x97\x4a", [0x4177] = "\x9c\xda", [0x417a] = "\x9c\xde",
  [0x417e] = "\x91\x9e", [0x4180] = "\x97\xf7", [0x4181] = "\x9c\xdf",
  [0x4184] = "\x9c\xdc", [0x4186] = "\x9c\xd9", [0x4189] = "\x9c\xd8",
  [0x418a] = "\x9c\xdd", [0x4194] = "\x95\xae", [0x4197] = "\x93\xb2",
  [0x4199] = "\x8c\x65", [0x419b] = "\x9c\xe0", [0x419c] = "\x9c\xdb",
  [0x419e] = "\x9c\xe1", [0x41a2] = "\x8c\x9b", [0x41a6] = "\x89\xaf",
  [0x41aa] = "\x9c\xe9", [0x41ae] = "\x8a\xb6", [0x41b3] = "\x9c\xe7",
  [0x41b6] = "\x9c\xe8", [0x41b7] = "\x8d\xa7", [0x41b8] = "\x9c\xe6",
  [0x41b9] = "\x9c\xe4", [0x41ba] = "\x9c\xe3", [0x41bb] = "\x9c\xea",
  [0x41bc] = "\x9c\xe2", [0x41bd] = "\x9c\xec", [0x41c0] = "\x89\xf9",
  [0x41d3] = "\x9c\xee", [0x41d6] = "\x9c\xed", [0x41e2] = "\x92\xa6",
  [0x41e4] = "\x9c\xf1", [0x41e6] = "\x9c\xef", [0x41e7] = "\x9c\xe5",
  [0x41e8] = "\x8c\x9c", [0x41ea] = "\x9c\xf0", [0x41ec] = "\x9c\xf4",
  [0x41ed] = "\x9c\xf3", [0x41ee] = "\x9c\xf5", [0x41ef] = "\x9c\xf2",
  [0x41f0] = "\x9c\xf6", [0x41f8] = "\x9c\xf7", [0x41f9] = "\x9c\xf8",
  [0x41fa] = "\x95\xe8", [0x41fc] = "\x9c\xfa", [0x41fd] = "\x9c\xf9",
  [0x41fe] = "\x8f\x5e", [0x4200] = "\x90\xac", [0x4201] = "\x89\xe4",
  [0x4202] = "\x89\xfa", [0x4204] = "\x9c\xfb", [0x4206] = "\x88\xbd",
  [0x420a] = "\x90\xca", [0x420b] = "\x9c\xfc", [0x420d] = "\xe6\xc1",
  [0x420e] = "\x9d\x40", [0x420f] = "\x8c\x81", [0x4211] = "\x9d\x41",
  [0x4216] = "\x90\xed", [0x421a] = "\x9d\x42", [0x421e] = "\x9d\x43",
  [0x421f] = "\x8b\x59", [0x4220] = "\x9d\x44", [0x4222] = "\x9d\x45",
  [0x4223] = "\x9d\x46", [0x4224] = "\x91\xd5", [0x4228] = "\x8c\xcb",
  [0x422b] = "\x96\xdf", [0x422f] = "\x96\x5b", [0x4230] = "\x8f\x8a",
  [0x4231] = "\x9d\x47", [0x4237] = "\x90\xee", [0x4238] = "\xe7\xbb",
  [0x4239] = "\x94\xe0", [0x423b] = "\x8e\xe8", [0x423d] = "\x8d\xcb",
  [0x423e] = "\x9d\x48", [0x4243] = "\x91\xc5", [0x4245] = "\x95\xa5",
  [0x4248] = "\x91\xef", [0x424b] = "\x9d\x4b", [0x424e] = "\x9d\x49",
  [0x4250] = "\x9d\x4c", [0x4253] = "\x9d\x4a", [0x4258] = "\x9d\x4d",
  [0x425e] = "\x95\xaf", [0x4261] = "\x88\xb5", [0x4266] = "\x95\x7d",
  [0x4269] = "\x94\xe1", [0x426c] = "\x9d\x4e", [0x426e] = "\x9d\x51",
  [0x426f] = "\x8f\xb3", [0x4270] = "\x8b\x5a", [0x4272] = "\x9d\x4f",
  [0x4273] = "\x9d\x56", [0x4274] = "\x8f\xb4", [0x4279] = "\x9d\x50",
  [0x427a] = "\x94\x63", [0x4281] = "\x97\x7d", [0x4282] = "\x9d\x52",
  [0x4283] = "\x9d\x53", [0x4284] = "\x9d\x57", [0x4285] = "\x93\x8a",
  [0x4286] = "\x9d\x54", [0x4287] = "\x8d\x52", [0x4288] = "\x90\xdc",
  [0x428b] = "\x9d\x65", [0x428c] = "\x94\xb2", [0x428e] = "\x91\xf0",
  [0x429b] = "\x94\xe2", [0x429c] = "\x9d\xab", [0x42a1] = "\x95\xf8",
  [0x42a5] = "\x92\xef", [0x42a9] = "\x96\x95", [0x42ab] = "\x9d\x5a",
  [0x42ac] = "\x89\x9f", [0x42ad] = "\x92\x8a", [0x42b2] = "\x9d\x63",
  [0x42b5] = "\x92\x53", [0x42b6] = "\x9d\x5d", [0x42b7] = "\x9d\x64",
  [0x42b8] = "\x9d\x5f", [0x42b9] = "\x9d\x66", [0x42ba] = "\x9d\x62",
  [0x42bc] = "\x9d\x61", [0x42bd] = "\x94\x8f", [0x42bf] = "\x9d\x5b",
  [0x42c0] = "\x89\xfb", [0x42c1] = "\x9d\x59", [0x42c2] = "\x8b\x91",
  [0x42c3] = "\x91\xf1", [0x42c4] = "\x9d\x55", [0x42c7] = "\x9d\x58",
  [0x42c8] = "\x8d\x53", [0x42c9] = "\x90\xd9", [0x42cb] = "\x8f\xb5",
  [0x42cc] = "\x9d\x60", [0x42cd] = "\x94\x71", [0x42d0] = "\x8b\x92",
  [0x42d1] = "\x8a\x67", [0x42dc] = "\x8a\x87", [0x42dd] = "\x90\x40",
  [0x42de] = "\x9d\x68", [0x42df] = "\x9d\x6d", [0x42e1] = "\x9d\x69",
  [0x42e3] = "\x8c\x9d", [0x42e5] = "\x9d\x6e", [0x42e6] = "\x8e\x41",
  [0x42e7] = "\x8d\x89", [0x42ee] = "\x8f\x45", [0x42ef] = "\x9d\x5c",
  [0x42f1] = "\x8e\x9d", [0x42f2] = "\x9d\x6b", [0x42f7] = "\x8e\x77",
  [0x42f8] = "\x9d\x6c", [0x42f9] = "\x88\xc2", [0x42fc] = "\x9d\x67",
  [0x4301] = "\x92\xa7", [0x4309] = "\x8b\x93", [0x430f] = "\x8b\xb2",
  [0x4317] = "\x9d\x6a", [0x4318] = "\x88\xa5", [0x431b] = "\x8d\xc1",
  [0x431f] = "\x90\x55", [0x432a] = "\x92\xf0", [0x432d] = "\x94\xd2",
  [0x432e] = "\x9d\x70", [0x432f] = "\x91\x7d", [0x4339] = "\x91\xa8",
  [0x433c] = "\x8e\x4a", [0x433d] = "\x9d\x71", [0x433f] = "\x9d\x73",
  [0x4340] = "\x9d\x6f", [0x4345] = "\x95\xdf", [0x4347] = "\x92\xbb",
  [0x434c] = "\x91\x7b", [0x4357] = "\x95\xf9", [0x4358] = "\x8e\xcc",
  [0x4359] = "\x9d\x80", [0x435b] = "\x9d\x7e", [0x435e] = "\x90\x98",
  [0x4362] = "\x8c\x9e", [0x4366] = "\x9d\x78", [0x4367] = "\x8f\xb7",
  [0x436a] = "\x93\xe6", [0x436b] = "\x94\x50", [0x4370] = "\x9d\x76",
  [0x4373] = "\x91\x7c", [0x4378] = "\x8e\xf6", [0x4379] = "\x9d\x7b",
  [0x437c] = "\x8f\xb6", [0x437e] = "\x9d\x75", [0x437f] = "\x9d\x7a",
  [0x4382] = "\x94\x72", [0x4386] = "\x9d\x74", [0x4388] = "\x8c\x40",
  [0x438b] = "\x8a\x7c", [0x438f] = "\x9d\x7c", [0x4390] = "\x97\xa9",
  [0x4391] = "\x8d\xcc", [0x4392] = "\x92\x54", [0x4393] = "\x9d\x79",
  [0x4395] = "\x90\xda", [0x4397] = "\x8d\x54", [0x4398] = "\x90\x84",
  [0x4399] = "\x89\x86", [0x439a] = "\x91\x5b", [0x439b] = "\x9d\x77",
  [0x439c] = "\x8b\x64", [0x43a2] = "\x8c\x66", [0x43a4] = "\x92\xcd",
  [0x43a5] = "\x9d\x7d", [0x43ab] = "\x91\x7e", [0x43ae] = "\x9d\x81",
  [0x43b0] = "\x9d\x83", [0x43b3] = "\x91\xb5", [0x43b4] = "\x9d\x89",
  [0x43b6] = "\x9d\x84", [0x43b9] = "\x9d\x86", [0x43bf] = "\x95\x60",
  [0x43c0] = "\x92\xf1", [0x43c2] = "\x9d\x87", [0x43c6] = "\x97\x4b",
  [0x43ca] = "\x97\x67", [0x43cb] = "\x8a\xb7", [0x43d1] = "\x88\xac",
  [0x43d3] = "\x9d\x85", [0x43d9] = "\x9d\x82", [0x43de] = "\x8a\xf6",
  [0x43e4] = "\x89\x87", [0x43e6] = "\x9d\x88", [0x43ea] = "\x97\x68",
  [0x43f6] = "\x9d\x8c", [0x43fd] = "\x91\xb9", [0x43ff] = "\x9d\x93",
  [0x4403] = "\x9d\x8d", [0x4406] = "\x9d\x8a", [0x4407] = "\x9d\x91",
  [0x440c] = "\x9d\x72", [0x4416] = "\x9d\x8e", [0x4418] = "\x9d\x92",
  [0x441c] = "\x94\xc0", [0x441d] = "\x93\x8b", [0x4424] = "\x9d\x8b",
  [0x4426] = "\x9d\x8f", [0x442a] = "\x8c\x67", [0x442e] = "\x8d\xef",
  [0x4432] = "\x90\xdb", [0x443e] = "\x9d\x97", [0x4448] = "\x93\x45",
  [0x4457] = "\x9d\x94", [0x4459] = "\x96\x80", [0x445f] = "\x9d\x95",
  [0x4466] = "\x9d\x96", [0x4468] = "\x96\xcc", [0x446a] = "\x90\xa0",
  [0x4473] = "\x8c\x82", [0x4478] = "\x9d\x9d", [0x4482] = "\x8e\x54",
  [0x4483] = "\x9d\x9a", [0x4485] = "\x9d\x99", [0x448a] = "\x94\x51",
  [0x448e] = "\x93\xb3", [0x4494] = "\x93\x50", [0x4495] = "\x9d\x9b",
  [0x4499] = "\x9d\x9c", [0x449b] = "\x95\x8f", [0x449d] = "\x94\x64",
  [0x449e] = "\x8e\x42", [0x44a0] = "\x90\xef", [0x44a2] = "\x96\x6f",
  [0x44a9] = "\x8a\x68", [0x44ab] = "\x9d\xa3", [0x44ac] = "\x9d\x9e",
  [0x44b1] = "\x97\x69", [0x44b2] = "\x9d\xa5", [0x44b5] = "\x9d\xa1",
  [0x44b7] = "\x9d\xa2", [0x44bd] = "\x91\x80", [0x44c2] = "\x9d\xa0",
  [0x44c4] = "\x9d\x5e", [0x44c8] = "\x9d\xa4", [0x44ca] = "\x9d\x9f",
  [0x44d0] = "\x9d\xa9", [0x44d1] = "\x9d\xaa", [0x44d2] = "\x93\x46",
  [0x44d3] = "\x9d\xac", [0x44d6] = "\x8e\x43", [0x44d7] = "\x9d\xa7",
  [0x44dc] = "\x8b\x5b", [0x44df] = "\x9d\xad", [0x44e1] = "\x9d\xa6",
  [0x44e2] = "\x9d\xb1", [0x44e4] = "\x9d\xb0", [0x44e6] = "\x9d\xaf",
  [0x44ea] = "\x9d\xb2", [0x44ed] = "\x9d\xb4", [0x44ee] = "\x8f\xef",
  [0x44f0] = "\x9d\xb3", [0x44f5] = "\x9d\xb7", [0x4508] = "\x9d\xb5",
  [0x450c] = "\x9d\xb6", [0x450d] = "\x9d\x90", [0x4513] = "\x9d\xb9",
  [0x4514] = "\x9d\xb8", [0x451a] = "\x9d\x98", [0x451b] = "\x9d\xba",
  [0x451c] = "\x9d\xae", [0x451f] = "\x8e\x78", [0x4524] = "\x9d\xbb",
  [0x4525] = "\x9d\xbc", [0x4526] = "\x9d\xbe", [0x4527] = "\x9d\xbd",
  [0x4528] = "\x9d\xbf", [0x4529] = "\x89\xfc", [0x452b] = "\x8d\x55",
  [0x452e] = "\x95\xfa", [0x452f] = "\x90\xad", [0x4535] = "\x8c\xcc",
  [0x4538] = "\x9d\xc1", [0x453d] = "\x9d\xc4", [0x453f] = "\x95\x71",
  [0x4541] = "\x8b\x7e", [0x4545] = "\x9d\xc3", [0x4546] = "\x9d\xc2",
  [0x4547] = "\x94\x73", [0x4548] = "\x9d\xc5", [0x4549] = "\x8b\xb3",
  [0x454d] = "\x9d\xc7", [0x454e] = "\x9d\xc6", [0x4552] = "\x8a\xb8",
  [0x4553] = "\x8e\x55", [0x4556] = "\x93\xd6", [0x455c] = "\x8c\x68",
  [0x4560] = "\x90\x94", [0x4562] = "\x9d\xc8", [0x4564] = "\x90\xae",
  [0x4565] = "\x93\x47", [0x4567] = "\x95\x7e", [0x4568] = "\x9d\xc9",
  [0x4572] = "\x9d\xca", [0x4573] = "\x9d\xcb", [0x4577] = "\x95\xb6",
  [0x4578] = "\x9b\x7c", [0x4579] = "\x90\xc4", [0x457c] = "\x95\x6b",
  [0x457e] = "\x8d\xd6", [0x4580] = "\x94\xe3", [0x4581] = "\x94\xc1",
  [0x4587] = "\x93\x6c", [0x4589] = "\x97\xbf", [0x458b] = "\x9d\xcd",
  [0x458c] = "\x8e\xce", [0x458f] = "\x9d\xce", [0x4591] = "\x88\xb4",
  [0x4594] = "\x8b\xd2", [0x4595] = "\x90\xcb", [0x4597] = "\x95\x80",
  [0x459b] = "\x9d\xcf", [0x459c] = "\x8e\x61", [0x459d] = "\x92\x66",
  [0x459f] = "\x8e\x7a", [0x45a0] = "\x90\x56", [0x45a7] = "\x9d\xd0",
  [0x45a9] = "\x95\xfb", [0x45ac] = "\x89\x97", [0x45ad] = "\x8e\x7b",
  [0x45b1] = "\x9d\xd3", [0x45b3] = "\x9d\xd1", [0x45b4] = "\x9d\xd4",
  [0x45b5] = "\x97\xb7", [0x45b6] = "\x9d\xd2", [0x45bb] = "\x90\xf9",
  [0x45bc] = "\x9d\xd5", [0x45bf] = "\x91\xb0", [0x45c2] = "\x9d\xd6",
  [0x45c7] = "\x8a\xf8", [0x45c9] = "\x9d\xd8", [0x45cb] = "\x9d\xd7",
  [0x45d0] = "\x9d\xd9", [0x45d1] = "\x9d\xda", [0x45d2] = "\x8a\xf9",
  [0x45d5] = "\x93\xfa", [0x45d6] = "\x92\x55", [0x45d7] = "\x8b\x8c",
  [0x45d8] = "\x8e\x7c", [0x45d9] = "\x91\x81", [0x45dc] = "\x8f\x7b",
  [0x45dd] = "\x88\xae", [0x45e1] = "\x9d\xdb", [0x45ea] = "\x89\xa0",
  [0x45eb] = "\x9d\xdf", [0x45f2] = "\x8d\x56", [0x45f3] = "\x9d\xde",
  [0x45f6] = "\x8d\xa9", [0x45f7] = "\x8f\xb8", [0x45fa] = "\x9d\xdd",
  [0x45fc] = "\x8f\xb9", [0x45fe] = "\x96\xbe", [0x45ff] = "\x8d\xa8",
  [0x4603] = "\x88\xd5", [0x4604] = "\x90\xcc", [0x460c] = "\x9d\xe4",
  [0x460f] = "\x90\xaf", [0x4610] = "\x89\x66", [0x4615] = "\x8f\x74",
  [0x4617] = "\x96\x86", [0x4618] = "\x8d\xf0", [0x461d] = "\x8f\xba",
  [0x461f] = "\x90\xa5", [0x4624] = "\x9d\xe3", [0x4625] = "\x9d\xe1",
  [0x4626] = "\x9d\xe2", [0x462c] = "\x92\x8b", [0x462f] = "\x9e\x45",
  [0x4631] = "\x9d\xe8", [0x4632] = "\x8e\x9e", [0x4633] = "\x8d\x57",
  [0x4634] = "\x9d\xe6", [0x4639] = "\x9d\xe7", [0x463b] = "\x90\x57",
  [0x463f] = "\x9d\xe5", [0x4642] = "\x8e\x4e", [0x464d] = "\x9d\xea",
  [0x464e] = "\x9d\xe9", [0x464f] = "\x9d\xee", [0x4652] = "\x9d\xef",
  [0x4654] = "\x9d\xeb", [0x4656] = "\x8a\x41", [0x4657] = "\x9d\xec",
  [0x4658] = "\x9d\xed", [0x4659] = "\x94\xd3", [0x465e] = "\x95\x81",
  [0x465f] = "\x8c\x69", [0x4660] = "\x9d\xf0", [0x4664] = "\x90\xb0",
  [0x4666] = "\x8f\xbb", [0x466a] = "\x92\x71", [0x4671] = "\x8b\xc5",
  [0x4673] = "\x9d\xf1", [0x4674] = "\x9d\xf5", [0x4677] = "\x89\xc9",
  [0x4678] = "\x9d\xf2", [0x4679] = "\x9d\xf4", [0x467e] = "\x9d\xf3",
  [0x4681] = "\x8f\x8b", [0x4686] = "\x92\x67", [0x4687] = "\x88\xc3",
  [0x4688] = "\x9d\xf6", [0x468d] = "\x9d\xf7", [0x4692] = "\x92\xa8",
  [0x4696] = "\x97\xef", [0x469b] = "\x8e\x62", [0x469e] = "\x95\xe9",
  [0x46a4] = "\x96\x5c", [0x46a8] = "\x9e\x41", [0x46a9] = "\x9d\xf9",
  [0x46ac] = "\x9d\xfc", [0x46ae] = "\x9d\xfb", [0x46b1] = "\x9d\xf8",
  [0x46b4] = "\x9e\x40", [0x46b7] = "\x93\xdc", [0x46b9] = "\x9d\xfa",
  [0x46c6] = "\x9e\x42", [0x46c9] = "\x8f\x8c", [0x46ca] = "\x9e\x43",
  [0x46cc] = "\x97\x6a", [0x46cd] = "\x94\x98", [0x46d0] = "\x9e\x44",
  [0x46d6] = "\x9e\x46", [0x46d9] = "\x9e\x47", [0x46e0] = "\x9e\x48",
  [0x46e2] = "\x8b\xc8", [0x46e3] = "\x89\x67", [0x46e4] = "\x8d\x58",
  [0x46e5] = "\x9e\x49", [0x46e7] = "\x9e\x4a", [0x46e8] = "\x8f\x91",
  [0x46e9] = "\x91\x82", [0x46ec] = "\x99\xd6", [0x46ed] = "\x91\x5d",
  [0x46ee] = "\x91\x5c", [0x46ef] = "\x91\xd6", [0x46f0] = "\x8d\xc5",
  [0x46f3] = "\x98\xf0", [0x46f8] = "\x8c\x8e", [0x46f9] = "\x97\x4c",
  [0x46fb] = "\x95\xfc", [0x46fd] = "\x95\x9e", [0x46ff] = "\x9e\x4b",
  [0x4704] = "\x8d\xf1", [0x4705] = "\x92\xbd", [0x4706] = "\x9e\x4c",
  [0x4707] = "\x98\x4e", [0x470b] = "\x96\x5d", [0x470d] = "\x92\xa9",
  [0x470e] = "\x9e\x4d", [0x470f] = "\x8a\xfa", [0x4716] = "\x9e\x4e",
  [0x4717] = "\x9e\x4f", [0x4718] = "\x96\xd8", [0x471a] = "\x96\xa2",
  [0x471b] = "\x96\x96", [0x471c] = "\x96\x7b", [0x471d] = "\x8e\x44",
  [0x471e] = "\x9e\x51", [0x4721] = "\x8e\xe9", [0x4724] = "\x96\x70",
  [0x4726] = "\x9e\x53", [0x4727] = "\x9e\x56", [0x4728] = "\x9e\x55",
  [0x472a] = "\x8a\xf7", [0x472d] = "\x8b\x80", [0x472f] = "\x9e\x52",
  [0x4731] = "\x9e\x54", [0x4736] = "\x9e\x57", [0x4739] = "\x90\x99",
  [0x473e] = "\x97\x9b", [0x473f] = "\x88\xc7", [0x4740] = "\x8d\xde",
  [0x4741] = "\x91\xba", [0x4743] = "\x8e\xdb", [0x4746] = "\x8f\xf1",
  [0x4749] = "\x9e\x5a", [0x474c] = "\x93\x6d", [0x474e] = "\x9e\x58",
  [0x474f] = "\x91\xa9", [0x4750] = "\x9e\x59", [0x4751] = "\x8f\xf0",
  [0x4752] = "\x96\xdb", [0x4753] = "\x9e\x5b", [0x4754] = "\x9e\x5c",
  [0x4755] = "\x97\x88", [0x475a] = "\x9e\x61", [0x475d] = "\x8d\x59",
  [0x475f] = "\x94\x74", [0x4760] = "\x9e\x5e", [0x4761] = "\x93\x8c",
  [0x4762] = "\x9d\xdc", [0x4763] = "\x9d\xe0", [0x4765] = "\x8b\x6e",
  [0x4767] = "\x94\x66", [0x476c] = "\x9e\x60", [0x476e] = "\x8f\xbc",
  [0x476f] = "\x94\xc2", [0x4775] = "\x9e\x66", [0x4777] = "\x94\xf8",
  [0x4779] = "\x9e\x5d", [0x477b] = "\x9e\x63", [0x477c] = "\x9e\x62",
  [0x4780] = "\x90\xcd", [0x4785] = "\x96\x8d", [0x4787] = "\x97\xd1",
  [0x478a] = "\x96\x87", [0x478c] = "\x89\xca", [0x478d] = "\x8e\x7d",
  [0x4790] = "\x98\x67", [0x4791] = "\x9e\x65", [0x4792] = "\x90\x95",
  [0x4796] = "\x9e\x64", [0x4799] = "\x9e\x5f", [0x479f] = "\x8c\xcd",
  [0x47a3] = "\x9e\x6b", [0x47a4] = "\x9e\x69", [0x47a6] = "\x89\xcb",
  [0x47a7] = "\x9e\x67", [0x47a8] = "\x9e\x6d", [0x47a9] = "\x9e\x73",
  [0x47b1] = "\x91\xc6", [0x47b4] = "\x95\xbf", [0x47b6] = "\x9e\x75",
  [0x47ba] = "\x95\x41", [0x47be] = "\x9e\x74", [0x47bf] = "\x94\x90",
  [0x47c0] = "\x96\x5e", [0x47c1] = "\x8a\xb9", [0x47c3] = "\x90\xf5",
  [0x47c4] = "\x8f\x5f", [0x47c8] = "\x92\xd1", [0x47ca] = "\x97\x4d",
  [0x47cd] = "\x9e\x70", [0x47ce] = "\x9e\x6f", [0x47d2] = "\x9e\x71",
  [0x47d4] = "\x9e\x6e", [0x47d7] = "\x9e\x76", [0x47d9] = "\x9e\x6c",
  [0x47dc] = "\x9e\x6a", [0x47de] = "\x9e\x72", [0x47df] = "\x9e\x68",
  [0x47e1] = "\x92\x8c", [0x47e3] = "\x96\xf6", [0x47e4] = "\x8e\xc4",
  [0x47e5] = "\x8d\xf2", [0x47eb] = "\x8d\xb8", [0x47ee] = "\x96\x8f",
  [0x47ef] = "\x8a\x60", [0x47f2] = "\x92\xcc", [0x47f3] = "\x93\xc8",
  [0x47f4] = "\x89\x68", [0x4803] = "\x90\xf0", [0x4806] = "\x90\xb2",
  [0x4807] = "\x8c\x49", [0x480e] = "\x9e\x78", [0x4811] = "\x8d\x5a",
  [0x4812] = "\x8a\x9c", [0x4819] = "\x9e\x7a", [0x481a] = "\x8a\x94",
  [0x481b] = "\x9e\x81", [0x4822] = "\x9e\x7d", [0x4824] = "\x90\xf1",
  [0x4828] = "\x8a\x6a", [0x4829] = "\x8d\xaa", [0x482c] = "\x8a\x69",
  [0x482d] = "\x8d\xcd", [0x4830] = "\x9e\x7b", [0x4831] = "\x8c\x85",
  [0x4832] = "\x8c\x6a", [0x4833] = "\x93\x8d", [0x4836] = "\x9e\x79",
  [0x4838] = "\x88\xc4", [0x483d] = "\x9e\x7c", [0x483e] = "\x9e\x7e",
  [0x4840] = "\x8b\xcb", [0x4841] = "\x8c\x4b", [0x4843] = "\x8a\xba",
  [0x4844] = "\x8b\x6a", [0x4849] = "\x9e\x82", [0x484c] = "\x8d\xf7",
  [0x484d] = "\x96\x91", [0x484f] = "\x8e\x56", [0x4853] = "\x9e\x83",
  [0x4857] = "\x95\x4f", [0x4864] = "\x9e\x8f", [0x4866] = "\x89\xb1",
  [0x4867] = "\x9e\x84", [0x486e] = "\x9e\x95", [0x486f] = "\x9e\x85",
  [0x4871] = "\x97\xc0", [0x4873] = "\x9e\x8c", [0x4875] = "\x94\x7e",
  [0x487d] = "\x9e\x94", [0x487f] = "\x9e\x87", [0x4883] = "\x88\xb2",
  [0x4884] = "\x9e\x89", [0x4887] = "\x8d\x5b", [0x488b] = "\x9e\x8b",
  [0x488d] = "\x9e\x8a", [0x488f] = "\x9e\x86", [0x4890] = "\x9e\x91",
  [0x4892] = "\x8f\xbd", [0x4896] = "\x9a\xeb", [0x4897] = "\x8c\xe6",
  [0x4898] = "\x97\x9c", [0x489d] = "\x9e\x88", [0x489f] = "\x92\xf2",
  [0x48a0] = "\x8a\x42", [0x48a1] = "\x8d\xab", [0x48a3] = "\x9e\x80",
  [0x48a5] = "\x9e\x90", [0x48a6] = "\x8a\x81", [0x48a9] = "\x9e\x8e",
  [0x48aa] = "\x9e\x92", [0x48ac] = "\x93\x8e", [0x48b4] = "\x8a\xfc",
  [0x48b6] = "\x9e\xb0", [0x48b9] = "\x96\xc7", [0x48ba] = "\x9e\x97",
  [0x48bb] = "\x8a\xfb", [0x48bd] = "\x9e\x9e", [0x48c2] = "\x96\x5f",
  [0x48c4] = "\x9e\x9f", [0x48c5] = "\x9e\xa1", [0x48c7] = "\x9e\xa5",
  [0x48c8] = "\x9e\x99", [0x48ca] = "\x92\x49", [0x48cf] = "\x93\x8f",
  [0x48d0] = "\x9e\xa9", [0x48d1] = "\x9e\x9c", [0x48d3] = "\x9e\xa6",
  [0x48d7] = "\x9e\xa0", [0x48de] = "\x90\x58", [0x48df] = "\x9e\xaa",
  [0x48e2] = "\x90\xb1", [0x48e9] = "\x9e\xa8", [0x48ea] = "\x8a\xbb",
  [0x48f0] = "\x98\x6f", [0x48f1] = "\x9e\x96", [0x48f4] = "\x9e\xa4",
  [0x48f5] = "\x88\xd6", [0x48f8] = "\x9e\x98", [0x48fb] = "\x96\xb8",
  [0x48fc] = "\x9e\x9d", [0x48fd] = "\x90\x41", [0x48fe] = "\x92\xc5",
  [0x48ff] = "\x9e\x93", [0x4902] = "\x9e\xa3", [0x4909] = "\x90\x9a",
  [0x490a] = "\x9e\xad", [0x490b] = "\x8a\x91", [0x490c] = "\x8c\x9f",
  [0x4911] = "\x9e\xaf", [0x4912] = "\x9e\x9a", [0x4913] = "\x9e\xae",
  [0x4915] = "\x9e\xa7", [0x4916] = "\x9e\x9b", [0x4918] = "\x9e\xab",
  [0x491a] = "\x9e\xac", [0x4920] = "\x9e\xbd", [0x4924] = "\x93\xcc",
  [0x4926] = "\x9e\xa2", [0x4929] = "\x9e\xb9", [0x492d] = "\x9e\xbb",
  [0x492f] = "\x92\xd6", [0x493a] = "\x97\x6b", [0x4943] = "\x95\x96",
  [0x4944] = "\x9e\xb6", [0x4945] = "\x91\xc8", [0x4949] = "\x9e\xbc",
  [0x494a] = "\x91\x5e", [0x494c] = "\x9e\xb3", [0x494d] = "\x9e\xc0",
  [0x494e] = "\x9e\xbf", [0x4950] = "\x93\xed", [0x4951] = "\x9e\xbe",
  [0x4952] = "\x93\xe8", [0x495a] = "\x9e\xc2", [0x495b] = "\x9e\xb5",
  [0x495d] = "\x8b\xc6", [0x495e] = "\x9e\xb8", [0x495f] = "\x8f\x7c",
  [0x4963] = "\x94\x80", [0x4964] = "\x9e\xba", [0x4965] = "\x8b\xc9",
  [0x4967] = "\x9e\xb2", [0x4968] = "\x9e\xb4", [0x4969] = "\x9e\xb1",
  [0x496c] = "\x98\x4f", [0x496d] = "\x8a\x79", [0x496e] = "\x9e\xb7",
  [0x4971] = "\x9e\xc1", [0x4972] = "\x8a\x54", [0x497a] = "\x8d\xe5",
  [0x497e] = "\x89\x7c", [0x4981] = "\x9e\xd2", [0x4984] = "\x98\x50",
  [0x4985] = "\x9e\xd5", [0x498b] = "\x90\x59", [0x498c] = "\x9e\xd4",
  [0x4990] = "\x9e\xd3", [0x4997] = "\x9e\xd0", [0x499e] = "\x9e\xc4",
  [0x49a1] = "\x9e\xe1", [0x49a2] = "\x9e\xc3", [0x49a4] = "\x9e\xd6",
  [0x49ab] = "\x9e\xce", [0x49ae] = "\x9e\xc9", [0x49af] = "\x9e\xc6",
  [0x49b1] = "\x9e\xc7", [0x49b3] = "\x9e\xcf", [0x49b7] = "\xea\xa0",
  [0x49ba] = "\x9e\xcc", [0x49bb] = "\x8d\x5c", [0x49bc] = "\x92\xc6",
  [0x49bd] = "\x91\x84", [0x49be] = "\x9e\xca", [0x49c0] = "\x9e\xc5",
  [0x49c3] = "\x9e\xc8", [0x49c8] = "\x97\x6c", [0x49c9] = "\x96\x8a",
  [0x49cd] = "\x9e\xcd", [0x49ce] = "\x9e\xd7", [0x49d7] = "\x9e\xdf",
  [0x49d8] = "\x9e\xd8", [0x49db] = "\x9e\xe5", [0x49dd] = "\x9e\xe3",
  [0x49e2] = "\x9e\xde", [0x49e9] = "\x9e\xdd", [0x49eb] = "\x92\xce",
  [0x49ed] = "\x91\x85", [0x49ef] = "\x9e\xdb", [0x49f2] = "\x9e\xd9",
  [0x49f5] = "\x9e\xe0", [0x49fa] = "\x9e\xe6", [0x49fb] = "\x94\xf3",
  [0x49fc] = "\x9e\xec", [0x4a02] = "\x9e\xe7", [0x4a03] = "\x9e\xea",
  [0x4a04] = "\x9e\xe4", [0x4a07] = "\x92\x94", [0x4a09] = "\x95\x57",
  [0x4a0b] = "\x9e\xda", [0x4a0e] = "\x9e\xe2", [0x4a0f] = "\x8f\xbe",
  [0x4a11] = "\x96\xcd", [0x4a12] = "\x9e\xf6", [0x4a13] = "\x9e\xe9",
  [0x4a19] = "\x8c\xa0", [0x4a1a] = "\x89\xa1", [0x4a1b] = "\x8a\x7e",
  [0x4a1e] = "\x9e\xd1", [0x4a25] = "\x8f\xbf", [0x4a26] = "\x9e\xee",
  [0x4a28] = "\x9e\xf5", [0x4a29] = "\x8e\xf7", [0x4a2a] = "\x8a\x92",
  [0x4a2d] = "\x92\x4d", [0x4a34] = "\x9e\xeb", [0x4a37] = "\x9e\xf0",
  [0x4a38] = "\x9e\xf4", [0x4a3b] = "\x8b\xb4", [0x4a48] = "\x8b\x6b",
  [0x4a49] = "\x9e\xf2", [0x4a4f] = "\x8b\x40", [0x4a51] = "\x93\xc9",
  [0x4a52] = "\x9e\xf1", [0x4a56] = "\x9e\xf3", [0x4a62] = "\x9e\xed",
  [0x4a68] = "\x9e\xef", [0x4a6f] = "\x8a\x80", [0x4a70] = "\x92\x68",
  [0x4a74] = "\x9e\xfa", [0x4a7d] = "\x9e\xf8", [0x4a7e] = "\x8c\xe7",
  [0x4a80] = "\x9e\xf7", [0x4a87] = "\x9f\x40", [0x4a8c] = "\x9e\x77",
  [0x4a90] = "\x9e\xf9", [0x4a92] = "\x9e\xfb", [0x4a93] = "\x9e\xfc",
  [0x4a9a] = "\x9f\x4b", [0x4a9c] = "\x9f\x47", [0x4a9e] = "\x9e\x8d",
  [0x4aa3] = "\x9f\x46", [0x4aa8] = "\x9f\x45", [0x4aab] = "\x9f\x42",
  [0x4ab1] = "\x9e\xe8", [0x4ab2] = "\x9f\x44", [0x4ab3] = "\x9f\x43",
  [0x4ac1] = "\x9f\x49", [0x4ac3] = "\x98\x45", [0x4aca] = "\x9f\x4c",
  [0x4acb] = "\x8b\xf9", [0x4ace] = "\x9f\x48", [0x4acf] = "\x9f\x4a",
  [0x4ad8] = "\x94\xa5", [0x4ada] = "\x9f\x4d", [0x4aea] = "\x9f\x51",
  [0x4aeb] = "\x9f\x4e", [0x4af4] = "\x97\x93", [0x4af5] = "\x9f\x4f",
  [0x4afa] = "\x9e\xdc", [0x4b02] = "\x9f\x52", [0x4b06] = "\x9f\x53",
  [0x4b0d] = "\x89\x54", [0x4b0f] = "\x9f\x55", [0x4b10] = "\x8c\x87",
  [0x4b11] = "\x8e\x9f", [0x4b13] = "\x8b\xd3", [0x4b17] = "\x89\xa2",
  [0x4b22] = "\x97\x7e", [0x4b27] = "\x9f\x57", [0x4b28] = "\x9f\x56",
  [0x4b29] = "\x9f\x59", [0x4b2a] = "\x8b\x5c", [0x4b2d] = "\x8b\xd4",
  [0x4b2e] = "\x8a\xbc", [0x4b33] = "\x9f\x5c", [0x4b37] = "\x9f\x5b",
  [0x4b39] = "\x9f\x5d", [0x4b3c] = "\x89\xcc", [0x4b3e] = "\x92\x56",
  [0x4b40] = "\x9f\x5e", [0x4b43] = "\x8a\xbd", [0x4b44] = "\x9f\x60",
  [0x4b49] = "\x9f\x5f", [0x4b4b] = "\x9f\x61", [0x4b4f] = "\x9f\x62",
  [0x4b51] = "\x9f\x63", [0x4b52] = "\x8e\x7e", [0x4b53] = "\x90\xb3",
  [0x4b54] = "\x8d\x9f", [0x4b56] = "\x95\x90", [0x4b59] = "\x95\xe0",
  [0x4b5a] = "\x98\x63", [0x4b5f] = "\x8e\x95", [0x4b63] = "\x8d\xce",
  [0x4b64] = "\x97\xf0", [0x4b68] = "\x9f\x64", [0x4b69] = "\x9f\x65",
  [0x4b6b] = "\x8e\x80", [0x4b6f] = "\x9f\x66", [0x4b70] = "\x9f\x67",
  [0x4b73] = "\x9f\x69", [0x4b74] = "\x9f\x68", [0x4b76] = "\x96\x77",
  [0x4b79] = "\x8f\x7d", [0x4b7a] = "\x8e\xea", [0x4b7b] = "\x8e\x63",
  [0x4b7d] = "\x9f\x6a", [0x4b85] = "\x9f\x6c", [0x4b86] = "\x90\x42",
  [0x4b88] = "\x9f\x6b", [0x4b8e] = "\x9f\x6d", [0x4b94] = "\x9f\x6e",
  [0x4b9a] = "\x9f\x6f", [0x4b9b] = "\x9f\x70", [0x4b9f] = "\x9f\x71",
  [0x4ba1] = "\x9f\x73", [0x4ba2] = "\x9f\x72", [0x4ba3] = "\x9f\x74",
  [0x4ba4] = "\x89\xa3", [0x4ba5] = "\x92\x69", [0x4ba7] = "\x9f\x75",
  [0x4baa] = "\x8e\x45", [0x4bab] = "\x8a\x6b", [0x4bac] = "\x9f\x76",
  [0x4baf] = "\x93\x61", [0x4bb0] = "\x9a\xca", [0x4bb5] = "\x8b\x42",
  [0x4bb6] = "\x9f\x77", [0x4bbb] = "\x9f\x78", [0x4bbd] = "\x95\xea",
  [0x4bbe] = "\x96\x88", [0x4bc2] = "\x93\xc5", [0x4bc3] = "\x9f\x79",
  [0x4bc4] = "\x94\xe4", [0x4bc8] = "\x94\xf9", [0x4bcb] = "\x96\xd1",
  [0x4bcf] = "\x9f\x7a", [0x4bdb] = "\x9f\x7c", [0x4bdc] = "\x9f\x7b",
  [0x4bdf] = "\x9f\x7e", [0x4be3] = "\x9f\x7d", [0x4bf8] = "\x9f\x81",
  [0x4bff] = "\x8e\x81", [0x4c01] = "\x96\xaf", [0x4c03] = "\x9f\x82",
  [0x4c04] = "\x9f\x83", [0x4c07] = "\x8b\x43", [0x4c0b] = "\x9f\x84",
  [0x4c13] = "\x9f\x86", [0x4c14] = "\x9f\x85", [0x4c24] = "\x90\x85",
  [0x4c27] = "\x95\x58", [0x4c28] = "\x89\x69", [0x4c2e] = "\x94\xc3",
  [0x4c30] = "\x92\xf3", [0x4c31] = "\x8f\x60", [0x4c32] = "\x8b\x81",
  [0x4c3e] = "\x94\xc4", [0x4c40] = "\x8e\xac", [0x4c45] = "\x9f\x88",
  [0x4c47] = "\x8a\xbe", [0x4c4a] = "\x89\x98", [0x4c4d] = "\x93\xf0",
  [0x4c4e] = "\x9f\x87", [0x4c4f] = "\x8d\x5d", [0x4c50] = "\x92\x72",
  [0x4c52] = "\x9f\x89", [0x4c58] = "\x9f\x91", [0x4c5a] = "\x9f\x8a",
  [0x4c60] = "\x91\xbf", [0x4c62] = "\x8b\x82", [0x4c63] = "\x9f\x92",
  [0x4c6a] = "\x8c\x88", [0x4c6d] = "\x8b\x44", [0x4c6e] = "\x9f\x90",
  [0x4c71] = "\x9f\x8e", [0x4c72] = "\x9f\x8b", [0x4c73] = "\x97\x80",
  [0x4c78] = "\x92\xbe", [0x4c7c] = "\x93\xd7", [0x4c7d] = "\x9f\x8c",
  [0x4c80] = "\x9f\x94", [0x4c82] = "\x9f\x93", [0x4c83] = "\x8c\x42",
  [0x4c86] = "\x89\xab", [0x4c89] = "\x8d\xb9", [0x4c8a] = "\x9f\x8d",
  [0x4c8b] = "\x9f\x8f", [0x4c91] = "\x96\x76", [0x4c92] = "\x91\xf2",
  [0x4c9b] = "\x96\x97", [0x4c9e] = "\x9f\x9c", [0x4ca1] = "\x9f\x9d",
  [0x4ca3] = "\x89\xcd", [0x4ca8] = "\x95\xa6", [0x4ca9] = "\x96\xfb",
  [0x4caa] = "\x9f\x9f", [0x4cab] = "\x8e\xa1", [0x4cac] = "\x8f\xc0",
  [0x4cad] = "\x9f\x98", [0x4cae] = "\x9f\x9e", [0x4caf] = "\x89\x88",
  [0x4cb1] = "\x8b\xb5", [0x4cb4] = "\x9f\x95", [0x4cb5] = "\x9f\x9a",
  [0x4cb9] = "\x90\xf2", [0x4cba] = "\x94\x91", [0x4cbc] = "\x94\xe5",
  [0x4cc3] = "\x9f\x97", [0x4cc5] = "\x96\x40", [0x4cc7] = "\x9f\x99",
  [0x4cc9] = "\x9f\xa2", [0x4ccb] = "\x9f\xa0", [0x4ccd] = "\x9f\x9b",
  [0x4cd1] = "\x96\x41", [0x4cd2] = "\x94\x67", [0x4cd3] = "\x8b\x83",
  [0x4cd5] = "\x93\x44", [0x4cd8] = "\x92\x8d", [0x4cda] = "\x9f\xa3",
  [0x4cdf] = "\x9f\xa1", [0x4ce0] = "\x91\xd7", [0x4ce1] = "\x9f\x96",
  [0x4ce3] = "\x89\x6a", [0x4cfb] = "\x97\x6d", [0x4cfc] = "\x9f\xae",
  [0x4d02] = "\x9f\xad", [0x4d07] = "\x90\xf4", [0x4d09] = "\x9f\xaa",
  [0x4d0b] = "\x97\x8c", [0x4d0e] = "\x93\xb4", [0x4d0f] = "\x9f\xa4",
  [0x4d15] = "\x92\xc3", [0x4d19] = "\x89\x6b", [0x4d1a] = "\x8d\x5e",
  [0x4d1b] = "\x9f\xa7", [0x4d22] = "\x8f\x46", [0x4d23] = "\x9f\xac",
  [0x4d25] = "\x9f\xab", [0x4d26] = "\x9f\xa6", [0x4d28] = "\x9f\xa9",
  [0x4d2b] = "\x8a\x88", [0x4d2d] = "\x9f\xa8", [0x4d2e] = "\x94\x68",
  [0x4d31] = "\x97\xac", [0x4d34] = "\x8f\xf2", [0x4d35] = "\x90\xf3",
  [0x4d49] = "\x9f\xb4", [0x4d4a] = "\x9f\xb2", [0x4d4c] = "\x95\x6c",
  [0x4d53] = "\x9f\xaf", [0x4d54] = "\x9f\xb1", [0x4d56] = "\x89\x59",
  [0x4d59] = "\x8d\x5f", [0x4d5a] = "\x98\x51", [0x4d5c] = "\x8a\x5c",
  [0x4d5e] = "\x95\x82", [0x4d64] = "\x97\x81", [0x4d67] = "\x8a\x43",
  [0x4d68] = "\x90\x5a", [0x4d69] = "\x9f\xb3", [0x4d75] = "\x9f\xb8",
  [0x4d78] = "\x8f\xc1", [0x4d7c] = "\x97\x4f", [0x4d7e] = "\x9f\xb5",
  [0x4d83] = "\x9f\xb0", [0x4d85] = "\x9f\xb6", [0x4d89] = "\x97\xdc",
  [0x4d8b] = "\x93\x93", [0x4d8c] = "\x93\xc0", [0x4d9f] = "\x8a\x55",
  [0x4da2] = "\x89\x74", [0x4da5] = "\x9f\xbc", [0x4da8] = "\x9f\xbf",
  [0x4dac] = "\x97\xc1", [0x4db0] = "\x97\x84", [0x4db5] = "\x9f\xc6",
  [0x4db6] = "\x9f\xc0", [0x4db7] = "\x9f\xbd", [0x4dbb] = "\x97\xd2",
  [0x4dbc] = "\x9f\xc3", [0x4dc1] = "\x8f\x69", [0x4dc2] = "\x9f\xc5",
  [0x4dc5] = "\x9f\xca", [0x4dc8] = "\x93\x91", [0x4dc9] = "\x9f\xc8",
  [0x4dce] = "\x9f\xc2", [0x4dd1] = "\x92\x57", [0x4dd4] = "\x9f\xc9",
  [0x4dd6] = "\x9f\xbe", [0x4dd8] = "\x9f\xc4", [0x4dda] = "\x9f\xcb",
  [0x4ddb] = "\x88\xfa", [0x4ddc] = "\x9f\xc1", [0x4dde] = "\x9f\xcc",
  [0x4de1] = "\x90\x5b", [0x4de3] = "\x8f\x7e", [0x4de5] = "\x95\xa3",
  [0x4de7] = "\x8d\xac", [0x4de9] = "\x9f\xb9", [0x4dea] = "\x9f\xc7",
  [0x4deb] = "\x93\x59", [0x4df5] = "\x90\xb4", [0x4df7] = "\x8a\x89",
  [0x4df8] = "\x8d\xcf", [0x4df9] = "\x8f\xc2", [0x4dfa] = "\x9f\xbb",
  [0x4dfb] = "\x8f\x61", [0x4e03] = "\x8c\x6b", [0x4e05] = "\x9f\xba",
  [0x4e09] = "\x9f\xd0", [0x4e0a] = "\x8f\x8d", [0x4e0b] = "\x8c\xb8",
  [0x4e0d] = "\x9f\xdf", [0x4e0f] = "\x9f\xd9", [0x4e10] = "\x8b\x94",
  [0x4e11] = "\x93\x6e", [0x4e13] = "\x9f\xd4", [0x4e14] = "\x9f\xdd",
  [0x4e15] = "\x88\xad", [0x4e16] = "\x89\x51", [0x4e19] = "\x89\xb7",
  [0x4e1b] = "\x9f\xd6", [0x4e1c] = "\x91\xaa", [0x4e1d] = "\x9f\xcd",
  [0x4e1e] = "\x9f\xcf", [0x4e1f] = "\x8d\x60", [0x4e28] = "\x9f\xe0",
  [0x4e2a] = "\x9f\xdb", [0x4e2e] = "\x9f\xd3", [0x4e33] = "\x9f\xda",
  [0x4e3a] = "\x96\xa9", [0x4e3d] = "\x9f\xd8", [0x4e3e] = "\x9f\xdc",
  [0x4e46] = "\x8c\xce", [0x4e48] = "\x8f\xc3", [0x4e4b] = "\x92\x58",
  [0x4e4f] = "\x9f\xd2", [0x4e57] = "\x97\x4e", [0x4e5b] = "\x9f\xd5",
  [0x4e5e] = "\x9f\xce", [0x4e5f] = "\x93\x92", [0x4e62] = "\x9f\xd1",
  [0x4e66] = "\x9f\xd7", [0x4e6e] = "\x98\x70", [0x4e6f] = "\x8e\xbc",
  [0x4e70] = "\x96\x9e", [0x4e72] = "\x9f\xe1", [0x4e7c] = "\x94\xac",
  [0x4e7f] = "\x9f\xed", [0x4e80] = "\x8c\xb9", [0x4e86] = "\x8f\x80",
  [0x4e88] = "\x9f\xe3", [0x4e8c] = "\x97\xad", [0x4e8d] = "\x8d\x61",
  [0x4e8f] = "\x9f\xf0", [0x4e92] = "\x88\xec", [0x4e95] = "\x9f\xee",
  [0x4e9a] = "\x9f\xe2", [0x4e9f] = "\x9f\xe8", [0x4ea2] = "\x9f\xea",
  [0x4ea6] = "\x97\x6e", [0x4ea7] = "\x9f\xe5", [0x4eaa] = "\x93\x4d",
  [0x4ead] = "\x9f\xe7", [0x4eb2] = "\x9f\xef", [0x4eb4] = "\x9f\xe9",
  [0x4eb5] = "\x96\xc5", [0x4eb9] = "\x9f\xe4", [0x4ebb] = "\x8e\xa0",
  [0x4ebc] = "\x9f\xfc", [0x4ec1] = "\x8a\x8a", [0x4ec3] = "\x9f\xe6",
  [0x4ec4] = "\x9f\xeb", [0x4ec5] = "\x9f\xec", [0x4ecd] = "\x91\xea",
  [0x4ece] = "\x91\xd8", [0x4edc] = "\x9f\xf4", [0x4edf] = "\x9f\xfa",
  [0x4ee2] = "\x9f\xf8", [0x4ee4] = "\x93\x48", [0x4ee7] = "\xe0\x42",
  [0x4ee8] = "\x9f\xf5", [0x4eee] = "\x9f\xf6", [0x4eef] = "\x9f\xde",
  [0x4ef1] = "\x8b\x99", [0x4ef2] = "\x95\x59", [0x4ef6] = "\x8e\xbd",
  [0x4ef9] = "\x8d\x97", [0x4eff] = "\x98\x52", [0x4f01] = "\x9f\xf2",
  [0x4f03] = "\xe0\x41", [0x4f04] = "\x89\x89", [0x4f05] = "\x91\x86",
  [0x4f10] = "\x94\x99", [0x4f12] = "\x8a\xbf", [0x4f13] = "\x97\xf8",
  [0x4f1b] = "\x96\x9f", [0x4f1c] = "\x92\xd0", [0x4f21] = "\x9f\xf9",
  [0x4f22] = "\x9f\xfb", [0x4f28] = "\x91\x51", [0x4f2e] = "\xe0\x40",
  [0x4f2f] = "\x9f\xf7", [0x4f31] = "\x9f\xf1", [0x4f35] = "\x8a\xc1",
  [0x4f44] = "\x8c\x89", [0x4f48] = "\xe0\x4e", [0x4f4b] = "\xe0\x49",
  [0x4f4c] = "\x90\xf6", [0x4f4f] = "\x8a\x83", [0x4f54] = "\x8f\x81",
  [0x4f56] = "\xe0\x52", [0x4f5d] = "\xe0\x4b", [0x4f5e] = "\x92\xaa",
  [0x4f5f] = "\xe0\x48", [0x4f60] = "\x92\xd7", [0x4f64] = "\xe0\x6b",
  [0x4f68] = "\xe0\x45", [0x4f6a] = "\xe0\x44", [0x4f6c] = "\xe0\x4d",
  [0x4f70] = "\xe0\x47", [0x4f71] = "\xe0\x46", [0x4f72] = "\xe0\x4c",
  [0x4f74] = "\x90\x9f", [0x4f76] = "\xe0\x43", [0x4f7e] = "\xe0\x4f",
  [0x4f81] = "\xe0\x50", [0x4f87] = "\x8a\xc0", [0x4f91] = "\xe0\x55",
  [0x4f93] = "\xe0\x54", [0x4f94] = "\xe0\x56", [0x4f9a] = "\xe0\x59",
  [0x4fa1] = "\x93\x62", [0x4fa3] = "\xe0\x53", [0x4fa9] = "\xe0\x57",
  [0x4fb0] = "\x8c\x83", [0x4fb1] = "\x91\xf7", [0x4fb2] = "\xe0\x51",
  [0x4fb3] = "\x94\x5a", [0x4fb6] = "\xe0\x58", [0x4fc4] = "\xe0\x5d",
  [0x4fc5] = "\xe0\x5b", [0x4fc8] = "\xe0\x5e", [0x4fcb] = "\xe0\x61",
  [0x4fcf] = "\xe0\x5a", [0x4fd0] = "\x8d\x8a", [0x4fd1] = "\x94\x47",
  [0x4fd4] = "\x9f\xb7", [0x4fdb] = "\x97\x94", [0x4fdc] = "\xe0\x5c",
  [0x4fde] = "\xe0\x60", [0x4fdf] = "\x91\xf3", [0x4fe1] = "\xe0\x5f",
  [0x4fe3] = "\xe0\x4a", [0x4fe6] = "\xe8\x89", [0x4fea] = "\xe0\x64",
  [0x4fee] = "\xe0\x68", [0x4ff1] = "\xe0\x66", [0x4ff9] = "\xe0\x62",
  [0x4ffb] = "\xe0\x63", [0x4fff] = "\xe0\x67", [0x5001] = "\xe0\x65",
  [0x5005] = "\x95\x6d", [0x5008] = "\xe0\x6d", [0x500a] = "\xe0\x6a",
  [0x500b] = "\xe0\x69", [0x500d] = "\xe0\x6c", [0x500e] = "\x93\xd2",
  [0x500f] = "\xe0\x6e", [0x5016] = "\x92\x95", [0x5017] = "\x91\xeb",
  [0x501c] = "\x90\xa3", [0x5020] = "\xe0\x6f", [0x5022] = "\xe0\x71",
  [0x502e] = "\xe0\x70", [0x503c] = "\x9f\xf3", [0x5041] = "\xe0\x72",
  [0x5048] = "\x93\xe5", [0x5053] = "\xe0\x73", [0x505b] = "\x89\xce",
  [0x505f] = "\x93\x94", [0x5060] = "\x8a\x44", [0x5068] = "\x8b\x84",
  [0x506c] = "\x8e\xdc", [0x506d] = "\x8d\xd0", [0x5079] = "\x98\x46",
  [0x507a] = "\x90\x86", [0x507e] = "\x89\x8a", [0x5082] = "\xe0\x75",
  [0x5089] = "\xe0\x74", [0x509c] = "\xe0\x78", [0x509d] = "\x92\x59",
  [0x509e] = "\xe0\x7b", [0x509f] = "\xe0\x76", [0x50a3] = "\xe0\x7a",
  [0x50a8] = "\xe0\x79", [0x50a9] = "\x93\x5f", [0x50aa] = "\x88\xd7",
  [0x50b8] = "\x97\xf3", [0x50bb] = "\xe0\x7d", [0x50bf] = "\x89\x47",
  [0x50c9] = "\xe0\x80", [0x50cd] = "\xe0\x7e", [0x50cf] = "\xe0\x7c",
  [0x50e1] = "\xe0\x77", [0x50e9] = "\x96\x42", [0x50ed] = "\xe0\x82",
  [0x50f9] = "\xe0\x81", [0x5104] = "\x89\x8b", [0x5109] = "\xe0\x84",
  [0x510a] = "\x95\xb0", [0x510c] = "\xe0\x83", [0x5111] = "\x96\xb3",
  [0x5116] = "\x8f\xc5", [0x5126] = "\x91\x52", [0x512c] = "\x8f\xc4",
  [0x5139] = "\x97\xf9", [0x513c] = "\xe0\x8a", [0x513e] = "\x90\xf7",
  [0x5145] = "\xe0\x86", [0x5146] = "\xe0\x8b", [0x5149] = "\x89\x8c",
  [0x5152] = "\xe0\x89", [0x5154] = "\x94\x81", [0x5155] = "\xe0\x85",
  [0x5156] = "\xe0\x88", [0x5157] = "\x8f\xc6", [0x5159] = "\x94\xcf",
  [0x515c] = "\xe0\x8c", [0x515e] = "\x8e\xcf", [0x516d] = "\x90\xf8",
  [0x5174] = "\xe0\x8f", [0x5178] = "\xe0\x87", [0x517a] = "\x8c\x46",
  [0x517f] = "\xe0\x8d", [0x5184] = "\x97\x6f", [0x5185] = "\xe0\x90",
  [0x5189] = "\xea\xa4", [0x518f] = "\x8f\x6e", [0x5198] = "\xe0\x91",
  [0x519c] = "\xe0\x92", [0x51a1] = "\x94\x4d", [0x51a9] = "\xe0\x94",
  [0x51ae] = "\xe0\x95", [0x51b3] = "\x94\x52", [0x51b8] = "\x93\x95",
  [0x51b9] = "\xe0\x97", [0x51be] = "\xe0\x99", [0x51c0] = "\x97\xd3",
  [0x51c2] = "\xe0\x96", [0x51c4] = "\xe0\x98", [0x51c5] = "\x89\x8d",
  [0x51c7] = "\xe0\x93", [0x51cf] = "\x9a\x7a", [0x51d0] = "\xe0\x9a",
  [0x51d5] = "\x91\x87", [0x51d6] = "\x8e\x57", [0x51d7] = "\xe0\x9c",
  [0x51dc] = "\xe0\x9b", [0x51dd] = "\x90\x43", [0x51de] = "\x99\xd7",
  [0x51e5] = "\xe0\x9d", [0x51e9] = "\xe0\x9f", [0x51eb] = "\xe0\x8e",
  [0x51ec] = "\xe0\x9e", [0x51ef] = "\xe0\xa0", [0x51f6] = "\x94\x9a",
  [0x51fd] = "\xe0\xa1", [0x5200] = "\xe0\xa2", [0x520b] = "\xe0\xa3",
  [0x5218] = "\xe0\xa4", [0x521a] = "\x92\xdc", [0x521c] = "\xe0\xa6",
  [0x521d] = "\xe0\xa5", [0x5220] = "\xe0\xa7", [0x5222] = "\xe0\xa8",
  [0x5225] = "\x8e\xdd", [0x5226] = "\x95\x83", [0x522a] = "\x96\xea",
  [0x522b] = "\xe0\xa9", [0x522c] = "\xe0\xaa", [0x522d] = "\x91\x75",
  [0x522e] = "\x8e\xa2", [0x522f] = "\xe0\xab", [0x5230] = "\xe0\xac",
  [0x5236] = "\xe0\xad", [0x5237] = "\x95\xd0", [0x5238] = "\x94\xc5",
  [0x523b] = "\xe0\xae", [0x523c] = "\x94\x76", [0x5242] = "\x92\xab",
  [0x5248] = "\xe0\xaf", [0x5249] = "\x89\xe5", [0x524b] = "\x8b\x8d",
  [0x524d] = "\x96\xc4", [0x524f] = "\x96\xb4", [0x5251] = "\x89\xb2",
  [0x5252] = "\x98\x53", [0x5257] = "\x96\x71", [0x5259] = "\x95\xa8",
  [0x5262] = "\x90\xb5", [0x5264] = "\xe0\xb0", [0x5269] = "\x93\xc1",
  [0x526d] = "\x8c\xa1", [0x526e] = "\xe0\xb1", [0x5270] = "\x8d\xd2",
  [0x5271] = "\xe0\xb3", [0x5272] = "\xe0\xb2", [0x5277] = "\xe0\xb4",
  [0x5282] = "\xe0\xb5", [0x5286] = "\xe0\xb6", [0x5290] = "\x8b\x5d",
  [0x5292] = "\xe0\xb7", [0x5297] = "\xe0\xb8", [0x529c] = "\x8c\xa2",
  [0x529f] = "\x94\xc6", [0x52a2] = "\xe0\xba", [0x52a6] = "\x8f\xf3",
  [0x52a9] = "\xe0\xb9", [0x52b2] = "\x8b\xb6", [0x52b3] = "\xe0\xbb",
  [0x52b4] = "\xe0\xbd", [0x52b6] = "\xe0\xbc", [0x52be] = "\xe0\xbe",
  [0x52c0] = "\x8c\xcf", [0x52c2] = "\xe0\xbf", [0x52c7] = "\x8b\xe7",
  [0x52c9] = "\x91\x5f", [0x52cb] = "\x8d\x9d", [0x52d0] = "\xe0\xc1",
  [0x52d1] = "\xe0\xc2", [0x52d2] = "\xe0\xc0", [0x52d9] = "\x8e\xeb",
  [0x52dc] = "\x93\xc6", [0x52dd] = "\x8b\xb7", [0x52e7] = "\xe0\xc4",
  [0x52e8] = "\x92\x4b", [0x52e9] = "\xe0\xc3", [0x52ec] = "\x98\x54",
  [0x52ed] = "\x94\x82", [0x52fa] = "\xe0\xc7", [0x5306] = "\xe0\xc9",
  [0x5307] = "\xe0\xc6", [0x530b] = "\x96\xd2", [0x530c] = "\xe0\xc8",
  [0x530d] = "\xe0\xca", [0x530f] = "\x97\xc2", [0x5315] = "\xe0\xce",
  [0x5319] = "\xe0\xcd", [0x531a] = "\x92\x96", [0x531b] = "\x94\x4c",
  [0x531e] = "\x8c\xa3", [0x531f] = "\xe0\xcc", [0x5324] = "\xe0\xcb",
  [0x5326] = "\x97\x50", [0x5327] = "\x97\x51", [0x532e] = "\xe0\xcf",
  [0x532f] = "\x89\x8e", [0x5334] = "\x8d\x96", [0x5335] = "\x8e\x82",
  [0x533e] = "\xe0\xd0", [0x533f] = "\xe0\xd1", [0x5347] = "\xe0\xd3",
  [0x5353] = "\x8f\x62", [0x5358] = "\xe0\xd5", [0x535a] = "\xe0\xd4",
  [0x5360] = "\xe0\xd6", [0x5362] = "\x8a\x6c", [0x5365] = "\xe0\xd8",
  [0x5368] = "\xe0\xd7", [0x536a] = "\xe0\xda", [0x536b] = "\xe0\xd9",
  [0x5374] = "\x8c\xba", [0x5377] = "\x97\xa6", [0x5379] = "\x8b\xca",
  [0x537b] = "\x89\xa4", [0x5386] = "\x8b\xe8", [0x5399] = "\x8a\xdf",
  [0x53a2] = "\x97\xe6", [0x53a3] = "\xe0\xdc", [0x53ab] = "\xe0\xde",
  [0x53b0] = "\xe0\xdf", [0x53b2] = "\x89\xcf", [0x53b8] = "\xe0\xdb",
  [0x53ba] = "\x8e\x58", [0x53bd] = "\x92\xbf", [0x53be] = "\xe0\xdd",
  [0x53ce] = "\xe0\xe2", [0x53d0] = "\x8e\xec", [0x53d5] = "\xe0\xe0",
  [0x53da] = "\x8c\x5d", [0x53dd] = "\x94\xc7", [0x53de] = "\xe0\xe1",
  [0x53e1] = "\xe0\xfc", [0x53e8] = "\xe0\xe7", [0x53ee] = "\x8c\xbb",
  [0x53f3] = "\x8b\x85", [0x53f5] = "\xe0\xe4", [0x53f6] = "\x97\x9d",
  [0x53f9] = "\x97\xae", [0x5412] = "\x91\xf4", [0x5415] = "\xe0\xe6",
  [0x5422] = "\xe0\xe8", [0x5423] = "\x97\xd4", [0x5424] = "\x8b\xd5",
  [0x5425] = "\x94\xfa", [0x5426] = "\x94\x69", [0x542a] = "\xe0\xe9",
  [0x542f] = "\xe0\xeb", [0x5431] = "\xe0\xee", [0x5445] = "\xe0\xea",
  [0x5449] = "\xe0\xed", [0x544a] = "\x8c\xe8", [0x544b] = "\x89\x6c",
  [0x544c] = "\xe0\xef", [0x544e] = "\x90\x90", [0x544f] = "\xe0\xec",
  [0x5450] = "\x97\xda", [0x5453] = "\xe0\xf2", [0x5454] = "\xea\xa2",
  [0x5459] = "\xe0\xf0", [0x545a] = "\xe0\xf3", [0x545f] = "\xe0\xe5",
  [0x5460] = "\xe0\xf1", [0x5463] = "\x8d\xba", [0x5466] = "\xe0\xf4",
  [0x546e] = "\xe0\xf5", [0x5473] = "\x97\x9e", [0x547b] = "\xe0\xf6",
  [0x548e] = "\xe0\xf7", [0x5492] = "\xe0\xe3", [0x5497] = "\xe0\xf8",
  [0x54a0] = "\x8a\xc2", [0x54ad] = "\x8e\xa3", [0x54ba] = "\xe0\xf9",
  [0x54bf] = "\xe0\xfa", [0x54c4] = "\xe0\xfb", [0x54cc] = "\x89\x5a",
  [0x54d0] = "\xe1\x40", [0x54d2] = "\x95\x5a", [0x54d3] = "\xe1\x41",
  [0x54d6] = "\x8a\xa2", [0x54d7] = "\xe1\x42", [0x54d9] = "\xe1\x43",
  [0x54de] = "\xe1\x44", [0x54e0] = "\xe1\x46", [0x54e1] = "\xe1\x47",
  [0x54e2] = "\xe1\x45", [0x54e6] = "\x95\x72", [0x54e7] = "\xe1\x49",
  [0x54e8] = "\xe1\x48", [0x54f3] = "\xe1\x4b", [0x54f4] = "\xe1\x4a",
  [0x54f5] = "\xe1\x4c", [0x54fc] = "\xe1\x4d", [0x54fd] = "\xe1\x4f",
  [0x54fe] = "\xe1\x4e", [0x5501] = "\x8d\x99", [0x5503] = "\xe1\x51",
  [0x5505] = "\xe1\x50", [0x5508] = "\x8a\xc3", [0x550a] = "\x90\x72",
  [0x550c] = "\x93\x5b", [0x550e] = "\xe1\x52", [0x550f] = "\x90\xb6",
  [0x5513] = "\x8e\x59", [0x5515] = "\x89\x99", [0x5516] = "\xe1\x53",
  [0x5518] = "\x97\x70", [0x551b] = "\x95\xe1", [0x551c] = "\xe1\x54",
  [0x5520] = "\x93\x63", [0x5521] = "\x97\x52", [0x5522] = "\x8d\x62",
  [0x5523] = "\x90\x5c", [0x5527] = "\x92\x6a", [0x5528] = "\x99\xb2",
  [0x552a] = "\x92\xac", [0x552b] = "\x89\xe6", [0x552c] = "\xe1\x55",
  [0x5534] = "\xe1\x56", [0x5536] = "\xe1\x5b", [0x5539] = "\xe1\x59",
  [0x553a] = "\xe1\x58", [0x553b] = "\x9d\xc0", [0x553c] = "\x8a\x45",
  [0x553d] = "\xe1\x57", [0x553f] = "\x88\xd8", [0x5541] = "\x94\xa8",
  [0x5544] = "\x94\xc8", [0x5549] = "\x97\xaf", [0x554a] = "\xe1\x5c",
  [0x554b] = "\xe1\x5a", [0x554c] = "\x92\x7b", [0x554d] = "\x90\xa4",
  [0x5550] = "\x94\xa9", [0x5552] = "\x95\x4c", [0x5554] = "\xe1\x5e",
  [0x5555] = "\x97\xaa", [0x5556] = "\x8c\x6c", [0x5557] = "\xe1\x5f",
  [0x5559] = "\xe1\x5d", [0x555a] = "\x94\xd4", [0x555b] = "\xe1\x60",
  [0x555d] = "\xe1\x61", [0x5560] = "\x88\xd9", [0x5563] = "\x8f\xf4",
  [0x5564] = "\xe1\x66", [0x5566] = "\xe1\x63", [0x5567] = "\x93\xeb",
  [0x5568] = "\xe1\x62", [0x556f] = "\x8b\x45", [0x5572] = "\xe1\x69",
  [0x5576] = "\xe1\x64", [0x5577] = "\xe1\x65", [0x5579] = "\xe1\x68",
  [0x557a] = "\xe1\x67", [0x557b] = "\x95\x44", [0x557e] = "\x91\x61",
  [0x557f] = "\x91\x60", [0x5581] = "\x8b\x5e", [0x5584] = "\xe1\x6a",
  [0x558a] = "\xe1\x6b", [0x558d] = "\xe1\x6c", [0x5593] = "\xe1\x6e",
  [0x5595] = "\xe1\x6d", [0x559b] = "\x89\x75", [0x55a1] = "\xe1\x76",
  [0x55a2] = "\x94\xe6", [0x55a3] = "\xe1\x70", [0x55a5] = "\xe1\x72",
  [0x55a8] = "\xe1\x74", [0x55a9] = "\x90\x5d", [0x55ac] = "\xe1\x75",
  [0x55ad] = "\xe1\x73", [0x55ae] = "\x8e\xbe", [0x55b2] = "\xe1\x6f",
  [0x55b3] = "\xe1\x71", [0x55b5] = "\x95\x61", [0x55b7] = "\x8f\xc7",
  [0x55ba] = "\xe1\x78", [0x55bd] = "\xe1\x77", [0x55c2] = "\xe1\x79",
  [0x55c4] = "\x8e\xa4", [0x55c5] = "\x8d\xad", [0x55c8] = "\x93\x97",
  [0x55c9] = "\xe1\x7a", [0x55cb] = "\x92\xc9", [0x55ce] = "\xe1\x7c",
  [0x55d2] = "\x97\x9f", [0x55d3] = "\xe1\x7b", [0x55d9] = "\x91\x89",
  [0x55e0] = "\xe1\x82", [0x55e2] = "\xe1\x84", [0x55e3] = "\xe1\x85",
  [0x55e4] = "\x92\x73", [0x55ea] = "\xe1\x83", [0x55ec] = "\xe1\x80",
  [0x55ee] = "\xe1\x7d", [0x55ef] = "\xe1\x7e", [0x55f1] = "\xe1\x81",
  [0x55f9] = "\xe1\x88", [0x55fb] = "\xe1\x86", [0x55fd] = "\xe1\x87",
  [0x560f] = "\xe1\x89", [0x5610] = "\xe1\x8b", [0x5611] = "\xe1\x8c",
  [0x5612] = "\xe1\x8d", [0x5614] = "\xe1\x8e", [0x5617] = "\xe1\x8a",
  [0x5620] = "\xe1\x90", [0x5624] = "\xe1\x8f", [0x562b] = "\xe1\x91",
  [0x5632] = "\x97\xc3", [0x5636] = "\xe1\x94", [0x5637] = "\xe1\x92",
  [0x5638] = "\xe1\x93", [0x563c] = "\x8a\xe0", [0x5642] = "\x96\xfc",
  [0x5646] = "\x95\xc8", [0x5648] = "\xe1\x96", [0x564c] = "\xe1\x95",
  [0x5651] = "\xe1\x97", [0x5652] = "\xe1\x98", [0x5657] = "\xe1\x9c",
  [0x5658] = "\xe1\x99", [0x5659] = "\xe1\x9a", [0x565a] = "\xe1\x9b",
  [0x565c] = "\xe1\x9d", [0x5660] = "\xe1\x9e", [0x5662] = "\xe1\x9f",
  [0x5666] = "\xe1\xa0", [0x5668] = "\xe1\xa1", [0x566a] = "\x94\xad",
  [0x566b] = "\x93\x6f", [0x566c] = "\xe1\xa2", [0x566d] = "\x94\x92",
  [0x566e] = "\x95\x53", [0x5670] = "\xe1\xa3", [0x5673] = "\xe1\xa4",
  [0x5674] = "\x93\x49", [0x5676] = "\x8a\x46", [0x5677] = "\x8d\x63",
  [0x5678] = "\xe1\xa5", [0x567b] = "\xe1\xa6", [0x567e] = "\xe1\xa7",
  [0x5680] = "\x8e\x48", [0x5683] = "\xe1\xa9", [0x5686] = "\xe1\xa8",
  [0x5689] = "\xe1\xaa", [0x568a] = "\xe1\xab", [0x569e] = "\x94\xe7",
  [0x56a0] = "\xe1\xac", [0x56a4] = "\xe1\xad", [0x56a7] = "\xea\x89",
  [0x56a8] = "\xe1\xae", [0x56a9] = "\xe1\xaf", [0x56aa] = "\xe1\xb0",
  [0x56af] = "\x8e\x4d", [0x56b2] = "\xe1\xb1", [0x56b3] = "\x94\x75",
  [0x56b6] = "\x96\x7e", [0x56b8] = "\x89\x6d", [0x56ba] = "\x89\x76",
  [0x56bd] = "\xe1\xb2", [0x56c2] = "\xe1\xb4", [0x56c6] = "\xe1\xb3",
  [0x56c7] = "\x93\x90", [0x56cb] = "\x90\xb7", [0x56cc] = "\x9f\x58",
  [0x56ce] = "\xe1\xb5", [0x56cf] = "\x96\xbf", [0x56d1] = "\xe1\xb6",
  [0x56d3] = "\x8a\xc4", [0x56d4] = "\x94\xd5", [0x56d5] = "\xe1\xb7",
  [0x56d7] = "\xe1\xb8", [0x56da] = "\xe1\xb9", [0x56de] = "\x96\xda",
  [0x56e2] = "\x96\xd3", [0x56e4] = "\x92\xbc", [0x56e8] = "\x91\x8a",
  [0x56eb] = "\xe1\xbb", [0x56ee] = "\x8f\x82", [0x56f1] = "\x8f\xc8",
  [0x56f4] = "\xe1\xbe", [0x56f7] = "\xe1\xbd", [0x56f8] = "\xe1\xbc",
  [0x56f9] = "\x94\xfb", [0x56fb] = "\x8a\xc5", [0x56fc] = "\x8c\xa7",
  [0x570b] = "\xe1\xc4", [0x570e] = "\xe1\xc1", [0x570f] = "\x90\x5e",
  [0x5710] = "\x96\xb0", [0x5714] = "\xe1\xc0", [0x5715] = "\xe1\xc2",
  [0x5716] = "\xe1\xc3", [0x5719] = "\xe1\xbf", [0x5727] = "\xe1\xc5",
  [0x5728] = "\xe1\xc6", [0x572a] = "\x92\xad", [0x572c] = "\x8a\xe1",
  [0x5730] = "\x92\x85", [0x5737] = "\xe1\xc7", [0x574a] = "\xe1\xc8",
  [0x574b] = "\xe1\xcb", [0x5751] = "\x90\x87", [0x5753] = "\x93\xc2",
  [0x5755] = "\xe1\xcc", [0x5756] = "\x96\x72", [0x5758] = "\xe1\xc9",
  [0x575b] = "\xe1\xca", [0x5769] = "\xe1\xcf", [0x576e] = "\xe1\xce",
  [0x576f] = "\xe1\xcd", [0x577b] = "\xe1\xd1", [0x577e] = "\xe1\xd0",
  [0x5781] = "\xe1\xd2", [0x578e] = "\xe1\xd4", [0x5790] = "\xe1\xd3",
  [0x5795] = "\x95\xcb", [0x579c] = "\x8f\x75", [0x579d] = "\x97\xc4",
  [0x57a0] = "\xe1\xd5", [0x57a3] = "\x93\xb5", [0x57a6] = "\xe1\xd6",
  [0x57a9] = "\xe1\xd7", [0x57ab] = "\xe1\xdb", [0x57ac] = "\xe1\xd9",
  [0x57ad] = "\xe1\xda", [0x57af] = "\xe1\xd8", [0x57b7] = "\xe1\xdc",
  [0x57bd] = "\xe1\xdd", [0x57c7] = "\xe1\xde", [0x57ca] = "\xe1\xdf",
  [0x57cb] = "\x96\xb5", [0x57cc] = "\xe1\xe0", [0x57d2] = "\x96\xee",
  [0x57d3] = "\xe1\xe1", [0x57d5] = "\x92\x6d", [0x57d7] = "\x94\x8a",
  [0x57d9] = "\x8b\xe9", [0x57dd] = "\x92\x5a", [0x57de] = "\xe1\xe2",
  [0x57df] = "\x8b\xb8", [0x57e3] = "\x90\xce", [0x57ec] = "\xe1\xe3",
  [0x57f2] = "\x8d\xbb", [0x57fc] = "\xe1\xe4", [0x5802] = "\xe1\xe5",
  [0x5804] = "\x8c\xa4", [0x5805] = "\x8d\xd3", [0x5810] = "\xe1\xe7",
  [0x5815] = "\x93\x75", [0x5816] = "\x8d\xd4", [0x5817] = "\x8b\x6d",
  [0x5822] = "\x96\x43", [0x5824] = "\x94\x6a", [0x582a] = "\x93\x76",
  [0x582f] = "\x8d\x7b", [0x5835] = "\xe1\xe9", [0x584d] = "\x8f\xc9",
  [0x585b] = "\x97\xb0", [0x585c] = "\x8d\x64", [0x585f] = "\x8c\xa5",
  [0x5862] = "\x94\xa1", [0x5864] = "\xe1\xeb", [0x586c] = "\xe1\xed",
  [0x5871] = "\x8c\xe9", [0x5876] = "\xe1\xec", [0x5877] = "\x92\xf4",
  [0x587c] = "\xe1\xef", [0x587d] = "\x8a\x56", [0x587e] = "\xe1\xea",
  [0x5881] = "\x94\xe8", [0x5883] = "\x89\x4f", [0x5885] = "\x8d\xea",
  [0x5887] = "\x98\x71", [0x588a] = "\xe1\xee", [0x5893] = "\xe1\xf0",
  [0x5897] = "\x95\xc9", [0x5899] = "\x90\xd7", [0x589a] = "\xe1\xf2",
  [0x589f] = "\xe1\xf3", [0x58a5] = "\xe1\xf1", [0x58aa] = "\x8a\x6d",
  [0x58ac] = "\xe1\xf9", [0x58ae] = "\xe1\xf8", [0x58b1] = "\x8e\xa5",
  [0x58b5] = "\xe1\xfa", [0x58b6] = "\xe1\xf5", [0x58ba] = "\xe1\xfb",
  [0x58bb] = "\xe1\xf6", [0x58c0] = "\x94\xd6", [0x58c1] = "\xe1\xf4",
  [0x58c4] = "\xe1\xf7", [0x58ca] = "\xe2\x41", [0x58d7] = "\xe2\x40",
  [0x58d8] = "\x96\x81", [0x58dc] = "\xe1\xfc", [0x58df] = "\x88\xe9",
  [0x58e4] = "\xe2\x43", [0x58ed] = "\xe2\x42", [0x58f1] = "\x8f\xca",
  [0x58f7] = "\xe2\x44", [0x58fe] = "\x91\x62", [0x5901] = "\xe2\x46",
  [0x5902] = "\xe2\x45", [0x5909] = "\xe2\x47", [0x5916] = "\xe1\xe6",
  [0x591a] = "\xe1\xe8", [0x591b] = "\xe2\x49", [0x591c] = "\xe2\x48",
  [0x592a] = "\x8e\xa6", [0x592c] = "\x97\xe7", [0x592e] = "\x8e\xd0",
  [0x5930] = "\xe2\x4a", [0x5931] = "\x8c\x56", [0x5937] = "\x8b\x5f",
  [0x5938] = "\x8b\x46", [0x5939] = "\x8e\x83", [0x5940] = "\x97\x53",
  [0x5943] = "\xe2\x50", [0x5945] = "\xe2\x4f", [0x5946] = "\x91\x63",
  [0x5947] = "\xe2\x4c", [0x594a] = "\xe2\x4e", [0x594d] = "\x8f\x6a",
  [0x594e] = "\x90\x5f", [0x594f] = "\xe2\x4d", [0x5950] = "\xe2\x4b",
  [0x5952] = "\x94\x49", [0x5955] = "\x8f\xcb", [0x5958] = "\x95\x5b",
  [0x595d] = "\x8d\xd5", [0x5967] = "\x93\x98", [0x596a] = "\xe2\x51",
  [0x596f] = "\xe2\x52", [0x5970] = "\xe2\x68", [0x5971] = "\x8b\xd6",
  [0x5974] = "\x98\x5c", [0x5975] = "\x91\x54", [0x597a] = "\xe2\x53",
  [0x597d] = "\x89\xd0", [0x597e] = "\x92\xf5", [0x597f] = "\x95\x9f",
  [0x598d] = "\xe2\x54", [0x5996] = "\x8b\x9a", [0x5997] = "\xe2\x55",
  [0x599a] = "\xe2\x57", [0x599e] = "\xe2\x58", [0x59a0] = "\x94\x48",
  [0x59a3] = "\xe2\x59", [0x59a9] = "\xe2\x5a", [0x59aa] = "\xe2\x5b",
  [0x59ad] = "\x8b\xd7", [0x59ae] = "\x89\xd1", [0x59af] = "\x93\xc3",
  [0x59b0] = "\x8f\x47", [0x59b1] = "\x8e\x84", [0x59b9] = "\xe2\x5c",
  [0x59bb] = "\x8f\x48", [0x59c1] = "\x89\xc8", [0x59c2] = "\x95\x62",
  [0x59c5] = "\xe2\x5d", [0x59c8] = "\x94\xe9", [0x59cf] = "\x91\x64",
  [0x59d1] = "\xe2\x60", [0x59d3] = "\xe2\x61", [0x59d4] = "\x94\x89",
  [0x59d6] = "\x90\x60", [0x59d7] = "\xe2\x5e", [0x59d9] = "\x92\x81",
  [0x59dc] = "\xe2\x5f", [0x59e0] = "\x8f\xcc", [0x59eb] = "\x88\xda",
  [0x59f0] = "\x8b\x48", [0x59f8] = "\xe2\x62", [0x59fb] = "\x92\xf6",
  [0x59fd] = "\xe2\x63", [0x59fe] = "\x90\xc5", [0x5a04] = "\x96\xab",
  [0x5a07] = "\x95\x42", [0x5a08] = "\xe2\x64", [0x5a09] = "\xe2\x65",
  [0x5a0a] = "\x92\x74", [0x5a0c] = "\x97\xc5", [0x5a0f] = "\xe2\x67",
  [0x5a10] = "\xe2\x66", [0x5a1e] = "\x8e\xed", [0x5a21] = "\xe2\x69",
  [0x5a22] = "\x88\xee", [0x5a27] = "\xe2\x6c", [0x5a2b] = "\xe2\x6a",
  [0x5a2c] = "\x89\xd2", [0x5a2d] = "\x8c\x6d", [0x5a2e] = "\xe2\x6b",
  [0x5a2f] = "\x8d\x65", [0x5a30] = "\x8d\x92", [0x5a32] = "\x95\xe4",
  [0x5a33] = "\xe2\x6d", [0x5a36] = "\x96\x73", [0x5a39] = "\xe2\x6f",
  [0x5a3d] = "\x90\xcf", [0x5a3e] = "\x89\x6e", [0x5a3f] = "\x89\xb8",
  [0x5a40] = "\x88\xaa", [0x5a47] = "\xe2\x6e", [0x5a51] = "\xe2\x70",
  [0x5a52] = "\xe2\x71", [0x5a53] = "\x8f\xf5", [0x5a59] = "\xe2\x72",
  [0x5a5b] = "\x8a\x6e", [0x5a60] = "\xe2\x74", [0x5a64] = "\x8c\x8a",
  [0x5a66] = "\x8b\x86", [0x5a69] = "\xe2\x75", [0x5a6a] = "\x8b\xf3",
  [0x5a6d] = "\xe2\x76", [0x5a6f] = "\x90\xfa", [0x5a71] = "\x93\xcb",
  [0x5a73] = "\x90\xde", [0x5a74] = "\x8d\xf3", [0x5a78] = "\xe2\x77",
  [0x5a82] = "\x92\x82", [0x5a83] = "\x91\x8b", [0x5a85] = "\xe2\x79",
  [0x5a86] = "\xe2\x7b", [0x5a87] = "\xe2\x78", [0x5a88] = "\xe2\x7a",
  [0x5a8f] = "\x8c\x41", [0x5a99] = "\xe2\x7c", [0x5a9a] = "\x8c\x45",
  [0x5a9e] = "\x8b\x87", [0x5a9f] = "\x97\x71", [0x5aa0] = "\xe2\x7e",
  [0x5aa6] = "\xe2\x80", [0x5aaa] = "\x89\x4d", [0x5aaf] = "\xe2\x83",
  [0x5ab3] = "\x8a\x96", [0x5ab4] = "\xe2\x82", [0x5ab5] = "\xe2\x81",
  [0x5ab7] = "\xe2\x85", [0x5ab8] = "\xe2\x7d", [0x5aba] = "\xe2\x86",
  [0x5abb] = "\x97\xa7", [0x5abd] = "\xe2\x87", [0x5abf] = "\xe2\x88",
  [0x5ac2] = "\x9a\xf2", [0x5ac3] = "\xe2\x8a", [0x5ac5] = "\xe2\x89",
  [0x5ac9] = "\xe2\x8b", [0x5aca] = "\xe2\x8c", [0x5acc] = "\x97\xb3",
  [0x5acd] = "\xe2\x8d", [0x5acf] = "\xe8\xed", [0x5ad0] = "\x8f\xcd",
  [0x5ad1] = "\xe2\x8e", [0x5ad2] = "\xe2\x8f", [0x5ad3] = "\x8f\x76",
  [0x5ad5] = "\x93\xb6", [0x5ad6] = "\xe2\x90", [0x5ada] = "\x92\x47",
  [0x5add] = "\xe2\x91", [0x5adf] = "\x92\x5b", [0x5ae0] = "\xe2\x92",
  [0x5ae6] = "\x8b\xa3", [0x5ae8] = "\x99\x5e", [0x5ae9] = "\x92\x7c",
  [0x5aea] = "\x8e\xb1", [0x5aef] = "\x8a\xc6", [0x5af2] = "\xe2\x93",
  [0x5af4] = "\xe2\xa0", [0x5af6] = "\xe2\x96", [0x5af8] = "\x8b\x88",
  [0x5afa] = "\xe2\x95", [0x5afb] = "\xe2\xa2", [0x5aff] = "\xe2\x94",
  [0x5b01] = "\x8f\xce", [0x5b08] = "\xe2\x98", [0x5b09] = "\xe2\x99",
  [0x5b0b] = "\x93\x4a", [0x5b0e] = "\xe2\x9a", [0x5b10] = "\x8a\x7d",
  [0x5b15] = "\x90\x79", [0x5b16] = "\x95\x84", [0x5b18] = "\xe2\x9c",
  [0x5b1c] = "\x91\xe6", [0x5b23] = "\xe2\x97", [0x5b25] = "\xe2\x9b",
  [0x5b26] = "\xe2\x9d", [0x5b29] = "\x8d\xf9", [0x5b35] = "\xe2\xa4",
  [0x5b36] = "\x95\x4d", [0x5b38] = "\x94\xa4", [0x5b39] = "\x93\x99",
  [0x5b3b] = "\x8b\xd8", [0x5b3c] = "\xe2\xa3", [0x5b3d] = "\xe2\xa1",
  [0x5b3f] = "\x94\xb3", [0x5b40] = "\xe2\x9e", [0x5b41] = "\x92\x7d",
  [0x5b42] = "\x93\x9b", [0x5b44] = "\x93\x9a", [0x5b46] = "\x8d\xf4",
  [0x5b4d] = "\xe2\xb6", [0x5b55] = "\xe2\xa6", [0x5b57] = "\xe2\xa8",
  [0x5b5c] = "\xe2\xab", [0x5b5e] = "\xe2\xac", [0x5b60] = "\xe2\xa9",
  [0x5b61] = "\xe2\xaa", [0x5b64] = "\xe2\xa7", [0x5b65] = "\xe2\xa5",
  [0x5b6a] = "\xe2\x9f", [0x5b76] = "\x95\xcd", [0x5b77] = "\x89\xd3",
  [0x5b7b] = "\xe2\xb3", [0x5b7d] = "\xe2\xb0", [0x5b7f] = "\xe2\xb5",
  [0x5b82] = "\xe2\xb4", [0x5b84] = "\x94\x93", [0x5b85] = "\x96\xa5",
  [0x5b87] = "\x8e\x5a", [0x5b88] = "\xe2\xae", [0x5b89] = "\xe2\xb7",
  [0x5b8a] = "\xe2\xb2", [0x5b8c] = "\xe2\xb1", [0x5b8d] = "\xe2\xad",
  [0x5b8f] = "\xe2\xaf", [0x5b91] = "\x8a\xc7", [0x5b9a] = "\x92\x5c",
  [0x5b9d] = "\x90\xfb", [0x5ba1] = "\x94\xa0", [0x5ba4] = "\xe2\xbc",
  [0x5ba8] = "\x94\xa2", [0x5bb0] = "\x90\xdf", [0x5bb1] = "\xe2\xb9",
  [0x5bb4] = "\x94\xcd", [0x5bb6] = "\xe2\xbd", [0x5bb7] = "\x95\xd1",
  [0x5bb9] = "\x92\x7a", [0x5bbb] = "\xe2\xb8", [0x5bbc] = "\xe2\xba",
  [0x5bbf] = "\xe2\xbb", [0x5bcd] = "\xe2\xbe", [0x5bd0] = "\x8e\xc2",
  [0x5bd4] = "\x93\xc4", [0x5bd5] = "\xe2\xc3", [0x5bd6] = "\xe2\xc2",
  [0x5bd9] = "\xe2\xbf", [0x5bdd] = "\x98\x55", [0x5be3] = "\xe2\xc8",
  [0x5be6] = "\xe2\xcc", [0x5be7] = "\xe2\xc9", [0x5bf0] = "\xe2\xc5",
  [0x5bf7] = "\xe2\xc6", [0x5bfd] = "\xe2\xcb", [0x5c01] = "\xe2\xc0",
  [0x5c02] = "\x99\xd3", [0x5c03] = "\xe2\xc7", [0x5c04] = "\xe2\xc1",
  [0x5c07] = "\xe2\xca", [0x5c0f] = "\xe2\xd0", [0x5c11] = "\x8a\xc8",
  [0x5c13] = "\xe2\xcd", [0x5c17] = "\xe2\xce", [0x5c1a] = "\xe2\xcf",
  [0x5c1b] = "\xe2\xd2", [0x5c27] = "\xe2\xd1", [0x5c28] = "\x94\xf4",
  [0x5c2d] = "\xe2\xd3", [0x5c2e] = "\x97\xfa", [0x5c2f] = "\x95\xeb",
  [0x5c30] = "\xe2\xd8", [0x5c33] = "\xe2\xd5", [0x5c3c] = "\xe2\xd4",
  [0x5c3d] = "\x90\xd0", [0x5c3f] = "\xe2\xd7", [0x5c40] = "\xe2\xd9",
  [0x5c44] = "\xe2\xd6", [0x5c46] = "\xe2\xdd", [0x5c48] = "\xe2\xda",
  [0x5c4f] = "\xe2\xdb", [0x5c50] = "\xe2\xc4", [0x5c54] = "\xe2\xdc",
  [0x5c55] = "\xe2\xde", [0x5c5c] = "\xe2\xdf", [0x5c63] = "\x95\xc4",
  [0x5c65] = "\xe2\xe0", [0x5c6e] = "\x96\xe0", [0x5c71] = "\x8b\xcc",
  [0x5c72] = "\x8c\x48", [0x5c73] = "\xe2\xe1", [0x5c79] = "\x95\xb2",
  [0x5c7b] = "\x90\x88", [0x5c7d] = "\x96\xae", [0x5c80] = "\xe2\xe2",
  [0x5c82] = "\x97\xb1", [0x5c85] = "\x94\x94", [0x5c87] = "\x91\x65",
  [0x5c88] = "\x94\x53", [0x5c8b] = "\x8f\x6c", [0x5c8f] = "\x88\xbe",
  [0x5c91] = "\xe2\xe7", [0x5c92] = "\xe2\xe5", [0x5c94] = "\xe2\xe3",
  [0x5c95] = "\x8a\x9f", [0x5c97] = "\x8f\xcf", [0x5c98] = "\xe2\xe8",
  [0x5c9b] = "\xe2\xe6", [0x5c9d] = "\xe2\xe4", [0x5c9e] = "\xe2\xec",
  [0x5ca1] = "\xe2\xeb", [0x5ca2] = "\xe2\xea", [0x5ca3] = "\xe2\xe9",
  [0x5ca9] = "\xe2\xed", [0x5cad] = "\xe2\xee", [0x5cae] = "\x90\xb8",
  [0x5cb0] = "\xe2\xef", [0x5cb2] = "\xe2\xf1", [0x5cb5] = "\xe2\xf0",
  [0x5cba] = "\x8c\xd0", [0x5cbe] = "\x91\x57", [0x5cc2] = "\xe2\xf3",
  [0x5cc6] = "\x93\x9c", [0x5cc8] = "\xe2\xf2", [0x5ccc] = "\xe2\xf4",
  [0x5cce] = "\x95\xb3", [0x5ccf] = "\x91\x8c", [0x5cd0] = "\x8d\x66",
  [0x5cd2] = "\xe2\xf5", [0x5cd7] = "\x97\xc6", [0x5cdf] = "\xe2\xf7",
  [0x5ce2] = "\xe2\xf8", [0x5ce4] = "\xe2\xf9", [0x5ce6] = "\xe2\xfa",
  [0x5ce8] = "\x8e\x85", [0x5cea] = "\xe2\xfb", [0x5ceb] = "\x8c\x6e",
  [0x5cee] = "\x8b\x8a", [0x5cf0] = "\x8b\x49", [0x5cf2] = "\xe3\x40",
  [0x5cf4] = "\x96\xf1", [0x5cf5] = "\x8d\x67", [0x5cf6] = "\xe2\xfc",
  [0x5cfa] = "\xe3\x43", [0x5cfb] = "\x96\xe4", [0x5cfd] = "\x94\x5b",
  [0x5d00] = "\x95\x52", [0x5d04] = "\x8f\x83", [0x5d05] = "\xe3\x42",
  [0x5d07] = "\x8e\xd1", [0x5d08] = "\x8d\x68", [0x5d09] = "\x8e\x86",
  [0x5d0a] = "\x8b\x89", [0x5d0b] = "\x95\xb4", [0x5d0c] = "\xe3\x41",
  [0x5d10] = "\x91\x66", [0x5d11] = "\x96\x61", [0x5d12] = "\x8d\xf5",
  [0x5d1b] = "\x8e\x87", [0x5d1c] = "\x92\xdb", [0x5d1e] = "\xe3\x46",
  [0x5d1f] = "\x97\xdd", [0x5d20] = "\x8d\xd7", [0x5d22] = "\xe3\x47",
  [0x5d23] = "\x90\x61", [0x5d25] = "\xe3\x49", [0x5d29] = "\x8f\xd0",
  [0x5d2a] = "\x8d\xae", [0x5d2f] = "\xe3\x48", [0x5d32] = "\x8f\x49",
  [0x5d33] = "\x8c\xbc", [0x5d34] = "\x91\x67", [0x5d35] = "\xe3\x44",
  [0x5d36] = "\xe3\x4a", [0x5d3b] = "\xe3\x45", [0x5d3c] = "\x8c\x6f",
  [0x5d3e] = "\xe3\x4d", [0x5d3f] = "\xe3\x51", [0x5d40] = "\x8c\x8b",
  [0x5d46] = "\xe3\x4c", [0x5d4b] = "\xe3\x55", [0x5d4e] = "\x8d\x69",
  [0x5d51] = "\x97\x8d", [0x5d52] = "\x88\xba", [0x5d53] = "\xe3\x52",
  [0x5d56] = "\x8b\x8b", [0x5d58] = "\xe3\x4f", [0x5d5e] = "\xe3\x50",
  [0x5d61] = "\x93\x9d", [0x5d62] = "\xe3\x4e", [0x5d63] = "\xe3\x4b",
  [0x5d65] = "\x8a\x47", [0x5d66] = "\x90\xe2", [0x5d69] = "\x8c\xa6",
  [0x5d6d] = "\xe3\x57", [0x5d79] = "\xe3\x54", [0x5d7f] = "\xe3\x56",
  [0x5d83] = "\xe3\x53", [0x5d89] = "\x8c\x70", [0x5d8a] = "\x91\xb1",
  [0x5d8b] = "\xe3\x58", [0x5d8c] = "\x91\x8e", [0x5d8f] = "\xe3\x65",
  [0x5d92] = "\xe3\x61", [0x5d93] = "\xe3\x5b", [0x5d9b] = "\xe3\x5f",
  [0x5d9c] = "\x8e\xf8", [0x5d9d] = "\x88\xdb", [0x5d9e] = "\xe3\x5a",
  [0x5d9f] = "\xe3\x62", [0x5da0] = "\xe3\x66", [0x5da1] = "\x8d\x6a",
  [0x5da2] = "\x96\xd4", [0x5da4] = "\x92\xd4", [0x5da5] = "\xe3\x5c",
  [0x5da8] = "\xe3\x64", [0x5daa] = "\xe3\x59", [0x5dab] = "\x92\x5d",
  [0x5dad] = "\xe3\x5e", [0x5dae] = "\x88\xbb", [0x5daf] = "\x96\xc8",
  [0x5db7] = "\xe3\x5d", [0x5dba] = "\x8b\xd9", [0x5dbb] = "\x94\xea",
  [0x5dbf] = "\x91\x8d", [0x5dc1] = "\x97\xce", [0x5dc2] = "\x8f\x8f",
  [0x5dc5] = "\xe3\x8e", [0x5dc8] = "\xe3\x67", [0x5dca] = "\x90\xfc",
  [0x5dcc] = "\xe3\x63", [0x5dcd] = "\xe3\x68", [0x5dce] = "\xe3\x6a",
  [0x5dd0] = "\x92\xf7", [0x5dd1] = "\xe3\x6d", [0x5dd4] = "\xe3\x69",
  [0x5dd8] = "\x95\xd2", [0x5dd9] = "\x8a\xc9", [0x5ddc] = "\x96\xc9",
  [0x5ddf] = "\x88\xdc", [0x5de2] = "\xe3\x6c", [0x5de4] = "\x97\xfb",
  [0x5deb] = "\xe3\x6b", [0x5df1] = "\x89\x8f", [0x5df4] = "\x93\xea",
  [0x5df5] = "\xe3\x6e", [0x5df9] = "\xe3\x75", [0x5dfa] = "\xe3\x6f",
  [0x5dfb] = "\xe3\x76", [0x5e02] = "\xe3\x72", [0x5e0b] = "\x94\x9b",
  [0x5e0e] = "\x8e\xc8", [0x5e0f] = "\xe3\x74", [0x5e11] = "\xe3\x71",
  [0x5e12] = "\xe3\x77", [0x5e13] = "\xe3\x70", [0x5e16] = "\x8f\x63",
  [0x5e1b] = "\x96\x44", [0x5e1e] = "\x8f\x6b", [0x5e21] = "\xe3\x73",
  [0x5e22] = "\xe3\x80", [0x5e25] = "\xe3\x7b", [0x5e27] = "\xe3\x7e",
  [0x5e29] = "\xe3\x7c", [0x5e2a] = "\xe3\x81", [0x5e2b] = "\xe3\x7a",
  [0x5e2d] = "\xe3\x60", [0x5e2e] = "\x90\xd1", [0x5e31] = "\x94\xc9",
  [0x5e33] = "\xe3\x7d", [0x5e36] = "\xe3\x78", [0x5e3a] = "\x91\x40",
  [0x5e3b] = "\x8c\x71", [0x5e3d] = "\x8f\x4a", [0x5e44] = "\x90\x44",
  [0x5e45] = "\x91\x55", [0x5e46] = "\xe3\x84", [0x5e49] = "\xe3\x86",
  [0x5e4a] = "\xe3\x87", [0x5e4d] = "\xe3\x83", [0x5e4e] = "\xe3\x85",
  [0x5e56] = "\xe3\x79", [0x5e57] = "\xe3\x82", [0x5e59] = "\xe3\x8a",
  [0x5e5a] = "\xe3\x89", [0x5e5d] = "\x96\x9a", [0x5e60] = "\x8c\x4a",
  [0x5e69] = "\xe3\x88", [0x5e6b] = "\xe3\x8c", [0x5e6c] = "\xe3\x8b",
  [0x5e6d] = "\xe3\x8f", [0x5e6f] = "\xe3\x91", [0x5e72] = "\x8e\x5b",
  [0x5e73] = "\xe3\x8d", [0x5e78] = "\xe3\x92", [0x5e79] = "\xe3\x93",
  [0x5e7c] = "\xe3\x94", [0x5e7e] = "\xe3\x9a", [0x5e7f] = "\x93\x5a",
  [0x5e80] = "\xe3\x96", [0x5e82] = "\xe3\x95", [0x5e83] = "\xe3\x97",
  [0x5e84] = "\xe3\x98", [0x5e86] = "\xe3\x99", [0x5e8b] = "\xe3\x9b",
  [0x5e8c] = "\xe3\x9c", [0x5f26] = "\x8a\xca", [0x5f28] = "\xe3\x9d",
  [0x5f2a] = "\xe3\x9e", [0x5f35] = "\xe3\x9f", [0x5f3c] = "\xe3\xa0",
  [0x5f3d] = "\xe3\xa1", [0x5f3e] = "\xe3\xa2", [0x5f40] = "\xe3\xa3",
  [0x5f41] = "\xe3\xa4", [0x5f44] = "\xe3\xa6", [0x5f45] = "\xe3\xa5",
  [0x5f48] = "\xe3\xa7", [0x5f4f] = "\xe3\xa8", [0x5f50] = "\xe3\xa9",
  [0x5f57] = "\xe3\xac", [0x5f58] = "\xe3\xaa", [0x5f59] = "\xe3\xab",
  [0x5f5a] = "\x8d\xdf", [0x5f5b] = "\x8c\x72", [0x5f5e] = "\x92\x75",
  [0x5f60] = "\x94\xb1", [0x5f62] = "\x8f\x90", [0x5f65] = "\x94\x6c",
  [0x5f67] = "\x94\xeb", [0x5f68] = "\xe3\xad", [0x5f69] = "\x9c\xeb",
  [0x5f72] = "\xe3\xae", [0x5f73] = "\xe3\xb0", [0x5f75] = "\x97\x85",
  [0x5f76] = "\xe3\xaf", [0x5f77] = "\xe3\xb2", [0x5f78] = "\xe3\xb1",
  [0x5f7a] = "\x97\x72", [0x5f7c] = "\xe3\xb3", [0x5f7e] = "\x94\xfc",
  [0x5f84] = "\xe3\xb4", [0x5f8a] = "\xe3\xb7", [0x5f8d] = "\xe3\xb6",
  [0x5f8e] = "\xe3\xb5", [0x5f93] = "\xe3\xb8", [0x5f94] = "\x8c\x51",
  [0x5f98] = "\x91\x41", [0x5f99] = "\x8b\x60", [0x5f9e] = "\xe3\xbc",
  [0x5f9f] = "\xe3\xb9", [0x5fa2] = "\xe3\xba", [0x5fa6] = "\xe3\xbd",
  [0x5fa8] = "\xe3\xbe", [0x5fa9] = "\xe3\xbb", [0x5fad] = "\x89\x48",
  [0x5fb1] = "\x89\xa5", [0x5fb5] = "\xe3\xc0", [0x5fb6] = "\xe3\xc1",
  [0x5fba] = "\xe3\xc2", [0x5fbc] = "\x97\x82", [0x5fc2] = "\x8f\x4b",
  [0x5fc4] = "\xe3\xc4", [0x5fc5] = "\xe3\xc3", [0x5fd0] = "\x90\x89",
  [0x5fd1] = "\xe3\xc5", [0x5fd6] = "\xe3\xc6", [0x5fd9] = "\xe3\xc7",
  [0x5fdb] = "\x8a\xe3", [0x5fe0] = "\x8a\xcb", [0x5fe3] = "\xe3\xc8",
  [0x5fe9] = "\xe3\xc9", [0x5feb] = "\x96\x7c", [0x5fec] = "\x97\x83",
  [0x5ff0] = "\x97\x73", [0x5ff1] = "\x98\x56", [0x5ff3] = "\x8d\x6c",
  [0x5ff4] = "\xe3\xcc", [0x5ff5] = "\x8e\xd2", [0x5ff6] = "\xe3\xcb",
  [0x5ffb] = "\xe3\xcd", [0x5ffc] = "\x8e\xa7", [0x6000] = "\x91\xcf",
  [0x6002] = "\xe3\xce", [0x6005] = "\x8d\x6b", [0x6007] = "\x96\xd5",
  [0x6008] = "\xe3\xcf", [0x6009] = "\xe3\xd0", [0x600c] = "\xe3\xd1",
  [0x6011] = "\xe3\xd2", [0x6018] = "\xe3\xd3", [0x6023] = "\x8e\xa8",
  [0x6026] = "\x96\xeb", [0x602b] = "\xe3\xd5", [0x602d] = "\x92\x5e",
  [0x602f] = "\xe3\xd4", [0x6036] = "\xe3\xd7", [0x603a] = "\xe3\xd6",
  [0x6042] = "\xe3\xd8", [0x6046] = "\x90\xb9", [0x6048] = "\xe3\xd9",
  [0x604a] = "\xe3\xda", [0x604e] = "\x95\xb7", [0x604f] = "\xe3\xdb",
  [0x6051] = "\x91\x8f", [0x6052] = "\xe3\xdc", [0x6058] = "\xe3\xdd",
  [0x605f] = "\x97\xfc", [0x6060] = "\xe3\xe0", [0x6062] = "\xe3\xdf",
  [0x6063] = "\xe3\xde", [0x6064] = "\x92\xae", [0x6066] = "\xe3\xe1",
  [0x6067] = "\x90\x45", [0x6069] = "\xe3\xe2", [0x606d] = "\xe3\xe3",
  [0x606e] = "\x98\x57", [0x606f] = "\xe3\xe4", [0x6074] = "\xe3\xe5",
  [0x6075] = "\xe3\xe7", [0x6076] = "\xe3\xe6", [0x6077] = "\x94\xa3",
  [0x6079] = "\x93\xf7", [0x607b] = "\x98\x5d", [0x607c] = "\x94\xa7",
  [0x6083] = "\xe3\xe9", [0x6086] = "\x8f\xd1", [0x6088] = "\x95\x49",
  [0x608a] = "\xe3\xea", [0x608b] = "\xe3\xe8", [0x608d] = "\x8a\xcc",
  [0x6091] = "\x8c\xd2", [0x6092] = "\x8e\x88", [0x6095] = "\x94\xec",
  [0x6099] = "\x8c\xa8", [0x609a] = "\x96\x62", [0x609c] = "\xe3\xed",
  [0x609d] = "\xe3\xeb", [0x609f] = "\x8d\x6d", [0x60a1] = "\x8d\x6e",
  [0x60a2] = "\x88\xe7", [0x60a4] = "\x8d\xe6", [0x60aa] = "\x94\x78",
  [0x60b3] = "\x88\xdd", [0x60b4] = "\xe3\xf2", [0x60b6] = "\x92\x5f",
  [0x60bc] = "\x94\x77", [0x60be] = "\x91\xd9", [0x60c6] = "\xe3\xf4",
  [0x60c9] = "\xe3\xf0", [0x60ca] = "\xe3\xf3", [0x60cb] = "\xe3\xee",
  [0x60cd] = "\xe3\xf1", [0x60ce] = "\x96\x45", [0x60d1] = "\x8c\xd3",
  [0x60d4] = "\x88\xfb", [0x60d5] = "\xe3\xef", [0x60df] = "\xe3\xf6",
  [0x60e1] = "\xe3\xf7", [0x60e4] = "\x93\xb7", [0x60e8] = "\x8b\xb9",
  [0x60ec] = "\xe4\x45", [0x60ed] = "\x94\x5c", [0x60f2] = "\x8e\x89",
  [0x60f5] = "\x8b\xba", [0x60f6] = "\x90\xc6", [0x60f7] = "\x98\x65",
  [0x60f8] = "\x96\xac", [0x60f9] = "\xe3\xf5", [0x60fa] = "\x90\xd2",
  [0x610a] = "\x8b\x72", [0x610b] = "\xe3\xf8", [0x6113] = "\xe3\xfa",
  [0x6119] = "\xe3\xf9", [0x611f] = "\xe3\xfb", [0x6121] = "\x92\x45",
  [0x6123] = "\x94\x5d", [0x6129] = "\x92\xaf", [0x612e] = "\xe4\x42",
  [0x6136] = "\xe4\x41", [0x613b] = "\xe3\xfc", [0x613e] = "\x90\x74",
  [0x6140] = "\x95\x85", [0x6141] = "\xe4\x44", [0x6143] = "\xe4\x43",
  [0x6144] = "\x8d\x6f", [0x6145] = "\x98\x72", [0x614f] = "\xe4\x54",
  [0x6155] = "\xe4\x48", [0x6156] = "\xe4\x49", [0x615b] = "\x8e\xee",
  [0x615e] = "\xe4\x47", [0x6160] = "\x8d\x98", [0x6161] = "\xe4\x46",
  [0x6164] = "\xe4\x4a", [0x6168] = "\x92\xb0", [0x6169] = "\x95\xa0",
  [0x616a] = "\x91\x42", [0x616f] = "\x91\xda", [0x6170] = "\xe4\x4e",
  [0x6172] = "\xe4\x4f", [0x6173] = "\xe4\x4b", [0x6178] = "\xe4\x4c",
  [0x617a] = "\xe4\x4d", [0x617f] = "\x8d\x70", [0x6183] = "\xe4\x55",
  [0x6185] = "\xe4\x51", [0x618a] = "\x95\x86", [0x618c] = "\x96\x8c",
  [0x618d] = "\x95\x47", [0x6190] = "\xe4\x50", [0x6193] = "\xe4\x53",
  [0x6194] = "\xe4\x52", [0x6198] = "\x96\x63", [0x6199] = "\xe4\x56",
  [0x61a0] = "\xe4\x57", [0x61a3] = "\x91\x56", [0x61a5] = "\xe4\x58",
  [0x61a8] = "\xe4\x5a", [0x61aa] = "\xe4\x5e", [0x61ad] = "\xe4\x5b",
  [0x61ae] = "\xe4\x59", [0x61af] = "\x94\x5e", [0x61b0] = "\xe4\x5c",
  [0x61b2] = "\xe4\x5d", [0x61b6] = "\x89\xb0", [0x61b8] = "\xe4\x64",
  [0x61b9] = "\xe4\x5f", [0x61bd] = "\xe4\x60", [0x61c1] = "\xe4\x61",
  [0x61c3] = "\x91\x9f", [0x61c8] = "\xe4\x63", [0x61c9] = "\xe4\x62",
  [0x61ca] = "\xe4\x65", [0x61cf] = "\xe4\x66", [0x61d0] = "\xe4\x67",
  [0x61d3] = "\x90\x62", [0x61d5] = "\x89\xe7", [0x61d7] = "\xe4\x68",
  [0x61d8] = "\x97\xd5", [0x61da] = "\x8e\xa9", [0x61dd] = "\x8f\x4c",
  [0x61e3] = "\x8e\x8a", [0x61e4] = "\x92\x76", [0x61ea] = "\xe4\x69",
  [0x61eb] = "\xe4\x6a", [0x61ec] = "\x89\x50", [0x61ee] = "\xe4\x6b",
  [0x61f1] = "\xe4\x6c", [0x61f2] = "\xe4\x6d", [0x61f5] = "\xe4\x6e",
  [0x61f7] = "\xe4\x6f", [0x61f8] = "\x8b\xbb", [0x61f9] = "\x9d\xa8",
  [0x61fa] = "\xe4\x70", [0x61fc] = "\x90\xe3", [0x61fd] = "\xe4\x71",
  [0x61fe] = "\x8e\xc9", [0x6200] = "\xe4\x72", [0x6202] = "\x98\xae",
  [0x6206] = "\xe4\x73", [0x6207] = "\x95\xdc", [0x6208] = "\x8a\xda",
  [0x620b] = "\x91\x43", [0x620c] = "\x8f\x77", [0x620e] = "\x95\x91",
  [0x620f] = "\x8f\x4d", [0x6219] = "\xe4\x74", [0x621a] = "\x8d\x71",
  [0x621b] = "\xe4\x75", [0x621c] = "\x94\xca", [0x621e] = "\xe4\x84",
  [0x6223] = "\xe4\x77", [0x6225] = "\x91\xc7", [0x6226] = "\x94\x95",
  [0x6227] = "\x8c\xbd", [0x6228] = "\xe4\x76", [0x6229] = "\x91\x44",
  [0x6230] = "\xe4\x78", [0x6237] = "\x92\xf8", [0x6248] = "\xe4\x7a",
  [0x6249] = "\xe4\x79", [0x624a] = "\xe4\x7c", [0x624d] = "\xe4\x7b",
  [0x624f] = "\xe4\x7d", [0x6252] = "\xe4\x80", [0x6254] = "\xe4\x7e",
  [0x6256] = "\x8a\xcd", [0x6258] = "\xe4\x81", [0x625a] = "\xe4\x82",
  [0x625b] = "\xe4\x83", [0x625e] = "\x8d\xaf", [0x625f] = "\x97\xc7",
  [0x6261] = "\xe4\x85", [0x6262] = "\x90\x46", [0x6266] = "\x89\x90",
  [0x6267] = "\xe4\x86", [0x6268] = "\xe4\x87", [0x626e] = "\xe4\x88",
  [0x627b] = "\x88\xf0", [0x627d] = "\xe4\x89", [0x6282] = "\xe4\x8a",
  [0x6289] = "\x95\x87", [0x628d] = "\x8e\xc5", [0x628f] = "\xe4\x8c",
  [0x6295] = "\x8a\x48", [0x6296] = "\x88\xb0", [0x629b] = "\xe4\x8b",
  [0x629c] = "\xe4\x8e", [0x629d] = "\x94\x6d", [0x629f] = "\x90\x63",
  [0x62a1] = "\x89\xd4", [0x62a3] = "\x96\x46", [0x62a8] = "\x8c\x7c",
  [0x62a9] = "\x8b\xda", [0x62ab] = "\xe4\x8d", [0x62ad] = "\x89\xe8",
  [0x62b5] = "\x8a\xa1", [0x62c1] = "\x89\x91", [0x62c2] = "\xe4\x92",
  [0x62c3] = "\x97\xe8", [0x62c4] = "\x91\xdb", [0x62c7] = "\x95\x63",
  [0x62c9] = "\xe4\x9e", [0x62cb] = "\x89\xd5", [0x62cc] = "\xe4\x9c",
  [0x62ce] = "\xe4\x9a", [0x62cf] = "\xe4\x91", [0x62d1] = "\xe4\x8f",
  [0x62d3] = "\xe4\x90", [0x62d5] = "\x8e\xe1", [0x62d6] = "\x8b\xea",
  [0x62d7] = "\x92\x97", [0x62db] = "\x93\xcf", [0x62e1] = "\x89\x70",
  [0x62e3] = "\xe4\x94", [0x62e4] = "\xe4\x93", [0x62e9] = "\xe4\x99",
  [0x62ea] = "\xe4\x95", [0x62eb] = "\xe4\x98", [0x62f2] = "\x96\xce",
  [0x62f3] = "\xe4\x97", [0x62f4] = "\x89\xd6", [0x62f5] = "\x8a\x9d",
  [0x62f6] = "\xe4\x9b", [0x62f9] = "\xe4\x9d", [0x62fe] = "\x8c\x73",
  [0x6306] = "\xe4\xa1", [0x6307] = "\xe4\xaa", [0x6308] = "\xe4\xab",
  [0x630c] = "\x88\xa9", [0x6313] = "\xe4\xb2", [0x6318] = "\x88\xef",
  [0x631b] = "\xe4\xa9", [0x631f] = "\xe4\xa8", [0x6321] = "\xe4\xa3",
  [0x6322] = "\xe4\xa2", [0x6324] = "\xe4\xa0", [0x6325] = "\xe4\x9f",
  [0x6326] = "\x92\x83", [0x6328] = "\x91\xf9", [0x6329] = "\xe4\xa5",
  [0x6330] = "\xe4\xa4", [0x6335] = "\xe4\xa7", [0x6339] = "\x91\x90",
  [0x633a] = "\x8c\x74", [0x633f] = "\x89\x60", [0x6340] = "\xe4\xa6",
  [0x6342] = "\x8d\x72", [0x6348] = "\x91\x91", [0x6363] = "\xe4\xb8",
  [0x6365] = "\xe4\xb9", [0x6367] = "\x89\xd7", [0x636b] = "\x89\xac",
  [0x636c] = "\xe4\xb6", [0x6375] = "\xe4\xac", [0x6377] = "\xe4\xb4",
  [0x6379] = "\xe4\xbb", [0x637a] = "\xe4\xb5", [0x637e] = "\xe4\xb3",
  [0x6383] = "\xe4\x96", [0x6386] = "\xe4\xb1", [0x638a] = "\xe4\xad",
  [0x638e] = "\x8a\xce", [0x638f] = "\xe4\xaf", [0x6390] = "\xe4\xba",
  [0x6392] = "\xe4\xb0", [0x6398] = "\xe4\xbc", [0x639a] = "\xe4\xae",
  [0x639b] = "\x94\x9c", [0x63a1] = "\x97\x89", [0x63a5] = "\xe4\xb7",
  [0x63ad] = "\xe4\xcd", [0x63b1] = "\xe4\xc5", [0x63b5] = "\x90\x9b",
  [0x63ba] = "\x8b\x65", [0x63bc] = "\x8b\xdb", [0x63be] = "\xe4\xc0",
  [0x63c3] = "\x89\xd9", [0x63c6] = "\x8f\xd2", [0x63c8] = "\xe4\xc3",
  [0x63cc] = "\x8d\xd8", [0x63cf] = "\x93\x70", [0x63d0] = "\xe4\xc8",
  [0x63d9] = "\x95\xec", [0x63db] = "\xe4\xbf", [0x63df] = "\x89\xd8",
  [0x63e0] = "\x8c\xd4", [0x63e1] = "\x95\x48", [0x63e2] = "\xe4\xc9",
  [0x63e4] = "\xe4\xbd", [0x63e7] = "\xe4\xc6", [0x63eb] = "\xe4\xd0",
  [0x63ed] = "\xe4\xc1", [0x63f3] = "\xe4\xc2", [0x63f4] = "\x93\xb8",
  [0x63f7] = "\xe4\xc7", [0x63fb] = "\xe4\xc4", [0x63fc] = "\x96\x47",
  [0x63fd] = "\xe4\xca", [0x63fe] = "\x88\xde", [0x6403] = "\xe4\xbe",
  [0x6410] = "\xe4\xcc", [0x6412] = "\xe4\xcb", [0x6419] = "\x94\x8b",
  [0x641a] = "\xe4\xd2", [0x641c] = "\xe4\xdd", [0x6421] = "\x8a\x9e",
  [0x6425] = "\xe4\xe0", [0x6428] = "\xe4\xce", [0x642c] = "\xe4\xd3",
  [0x642d] = "\x97\x8e", [0x6436] = "\xe4\xdc", [0x6439] = "\x97\x74",
  [0x643e] = "\x97\xa8", [0x6447] = "\x92\x98", [0x644b] = "\x8a\x8b",
  [0x6451] = "\x95\x92", [0x6452] = "\xe4\xe2", [0x6453] = "\x93\x9f",
  [0x6456] = "\x88\xaf", [0x6459] = "\xe4\xdb", [0x645b] = "\xe4\xd7",
  [0x645c] = "\x91\x92", [0x645d] = "\xe4\xd1", [0x645e] = "\xe4\xd9",
  [0x645f] = "\xe4\xde", [0x6461] = "\x94\x4b", [0x6465] = "\x88\xa8",
  [0x6467] = "\xe4\xd6", [0x6469] = "\xe4\xdf", [0x646a] = "\x95\x98",
  [0x6472] = "\xe4\xda", [0x6474] = "\xe4\xd5", [0x647b] = "\x8f\xd3",
  [0x6480] = "\x8f\x4e", [0x6484] = "\x8e\xaa", [0x6489] = "\x96\xd6",
  [0x648c] = "\x95\x66", [0x648f] = "\xe4\xe5", [0x6491] = "\xe4\xee",
  [0x649d] = "\xe4\xd8", [0x64a2] = "\x8a\x97", [0x64a8] = "\x8f\xf6",
  [0x64a9] = "\xe4\xe3", [0x64ab] = "\xe4\xe8", [0x64ac] = "\x91\x93",
  [0x64af] = "\xe4\xe4", [0x64b1] = "\xe4\xeb", [0x64b4] = "\x92\x7e",
  [0x64b6] = "\xe4\xec", [0x64b9] = "\x97\x75", [0x64ba] = "\xe4\xe1",
  [0x64bb] = "\x8a\x57", [0x64bd] = "\xe4\xe7", [0x64c0] = "\xe4\xea",
  [0x64c1] = "\x96\xaa", [0x64c6] = "\xe4\xed", [0x64c9] = "\xe4\xe6",
  [0x64ca] = "\xe4\xe9", [0x64dc] = "\x96\x48", [0x64de] = "\x98\x40",
  [0x64e4] = "\xe4\xf1", [0x64ec] = "\xe4\xf8", [0x64ef] = "\xe4\xf0",
  [0x64f0] = "\x8e\xc1", [0x64f6] = "\xe4\xcf", [0x6501] = "\x95\xcc",
  [0x6503] = "\x96\xa0", [0x6504] = "\xe4\xf7", [0x6505] = "\xe4\xf6",
  [0x6507] = "\xe4\xf2", [0x6508] = "\xe4\xf3", [0x650a] = "\x89\x55",
  [0x650f] = "\xe4\xf5", [0x6511] = "\xe4\xef", [0x6516] = "\x92\xd3",
  [0x651c] = "\xe4\xf4", [0x651d] = "\x88\xfc", [0x6525] = "\x91\xa0",
  [0x652d] = "\x95\xc1", [0x6530] = "\xe4\xf9", [0x6531] = "\xe5\x40",
  [0x6533] = "\x94\xd7", [0x6538] = "\xe4\xfc", [0x6539] = "\x8f\xd4",
  [0x653a] = "\x8e\xc7", [0x653b] = "\xe5\x42", [0x653e] = "\x8b\xbc",
  [0x6545] = "\xe5\x43", [0x6547] = "\x95\x99", [0x6548] = "\xe4\xfb",
  [0x654a] = "\xe4\xd4", [0x6553] = "\xe4\xfa", [0x6558] = "\x98\x6e",
  [0x6559] = "\x93\xa0", [0x655a] = "\x95\x93", [0x655d] = "\xe5\x4a",
  [0x6567] = "\xe5\x50", [0x656e] = "\xe5\x51", [0x6570] = "\xe5\x44",
  [0x6574] = "\x94\x96", [0x6577] = "\xe5\x4e", [0x6578] = "\xe5\x46",
  [0x657a] = "\xe5\x48", [0x6580] = "\xe5\x52", [0x6581] = "\xe5\x47",
  [0x6584] = "\xe5\x4b", [0x6587] = "\x89\x92", [0x6589] = "\x93\xe3",
  [0x658b] = "\xe5\x4c", [0x658c] = "\xe5\x4f", [0x6594] = "\xe5\x45",
  [0x6596] = "\x91\x45", [0x6598] = "\xe5\x49", [0x6599] = "\x8e\x46",
  [0x659a] = "\x90\x64", [0x659b] = "\x8c\x4f", [0x659c] = "\x96\xf2",
  [0x659e] = "\x96\xf7", [0x659f] = "\x8f\x92", [0x65a9] = "\xe5\x56",
  [0x65aa] = "\xe5\x54", [0x65b1] = "\x98\x6d", [0x65b9] = "\xe5\x53",
  [0x65bd] = "\x97\x95", [0x65bf] = "\xe5\x55", [0x65c0] = "\xe5\x57",
  [0x65c5] = "\xe5\x58", [0x65cc] = "\xe5\x5b", [0x65cd] = "\xe5\x59",
  [0x65d4] = "\x93\xa1", [0x65d5] = "\xe5\x5a", [0x65d9] = "\x94\xcb",
  [0x65da] = "\xe5\x4d", [0x65e7] = "\x8f\x93", [0x65e9] = "\xe5\x5c",
  [0x65ea] = "\xe5\x61", [0x65eb] = "\x91\x94", [0x65ee] = "\xe5\x60",
  [0x65f2] = "\xe5\x41", [0x65f6] = "\xe5\x62", [0x65f7] = "\x91\x68",
  [0x65fa] = "\xe5\x5d", [0x65fb] = "\xe5\x5f", [0x6603] = "\xe5\x5e",
  [0x6606] = "\x9f\x50", [0x6607] = "\x9f\x41", [0x660a] = "\xe5\x64",
  [0x6612] = "\xe5\x63", [0x661d] = "\x97\x96", [0x661f] = "\xe1\xba",
  [0x6620] = "\xe5\x65", [0x662f] = "\xe5\x66", [0x663d] = "\xe5\x67",
  [0x663e] = "\x8c\xd5", [0x6640] = "\x8b\x73", [0x6644] = "\xe5\x69",
  [0x6645] = "\x99\x7c", [0x664a] = "\x8b\x95", [0x664c] = "\x97\xb8",
  [0x664e] = "\x8b\xf1", [0x664f] = "\xe5\x6a", [0x6657] = "\xe5\x6b",
  [0x665b] = "\x92\x8e", [0x6661] = "\xe5\x6c", [0x6669] = "\x93\xf8",
  [0x666b] = "\x88\xb8", [0x667a] = "\x89\xe1", [0x667b] = "\xe5\x71",
  [0x667c] = "\xe5\x72", [0x6683] = "\xe5\x6d", [0x6685] = "\x8e\x5c",
  [0x6693] = "\xe5\x6e", [0x6694] = "\x94\x61", [0x6699] = "\xe5\x6f",
  [0x669a] = "\xe5\x70", [0x669b] = "\xe5\x7a", [0x669f] = "\xe5\x74",
  [0x66a0] = "\xe5\x77", [0x66a6] = "\xe5\x73", [0x66b4] = "\xe5\x75",
  [0x66b6] = "\xe5\x76", [0x66b7] = "\x8e\xd6", [0x66b9] = "\xe5\x78",
  [0x66bb] = "\x92\x60", [0x66bd] = "\x8c\x75", [0x66be] = "\x8a\x61",
  [0x66c4] = "\xe5\x7b", [0x66c9] = "\x8a\x5e", [0x66cb] = "\xe5\x81",
  [0x66ce] = "\xe5\x7c", [0x66cf] = "\xe5\x80", [0x66d4] = "\x94\xb8",
  [0x66d9] = "\xe5\x7d", [0x66dc] = "\xe5\x7e", [0x66dd] = "\x95\x67",
  [0x66de] = "\x94\xd8", [0x66df] = "\xe5\x82", [0x66e8] = "\x91\xfb",
  [0x66e9] = "\xe5\x8c", [0x66eb] = "\xe5\x88", [0x66ee] = "\x89\xe9",
  [0x66f0] = "\xe5\x86", [0x66f2] = "\x96\x49", [0x66f3] = "\xe5\x87",
  [0x66f6] = "\xe5\x84", [0x66f8] = "\xe5\x85", [0x66f9] = "\xe5\x8a",
  [0x66fa] = "\xe5\x8d", [0x66fd] = "\xe5\x8b", [0x6701] = "\xe5\x89",
  [0x6702] = "\xe5\x83", [0x6708] = "\x92\x77", [0x670a] = "\xe5\x94",
  [0x670c] = "\x96\xa8", [0x6715] = "\xe5\x92", [0x6719] = "\xe5\x93",
  [0x6724] = "\xe5\x8e", [0x6727] = "\xe5\x90", [0x672b] = "\xe5\x91",
  [0x672f] = "\xe5\x8f", [0x6739] = "\x90\xe4", [0x673b] = "\x98\x58",
  [0x673c] = "\xe5\x98", [0x673e] = "\xe5\x99", [0x6743] = "\xe5\x9f",
  [0x6745] = "\x90\x49", [0x6747] = "\xe5\x9b", [0x6749] = "\xe5\x9e",
  [0x674f] = "\xe5\x96", [0x6750] = "\xe5\x95", [0x6753] = "\xe5\xa0",
  [0x6756] = "\x89\xda", [0x6758] = "\xe5\x9c", [0x675a] = "\xe5\xa1",
  [0x675e] = "\xe5\x9d", [0x6764] = "\xe5\x9a", [0x6766] = "\x92\xb1",
  [0x6768] = "\xe5\x97", [0x676f] = "\x94\x88", [0x6772] = "\xe5\xa5",
  [0x677d] = "\x97\x5a", [0x678f] = "\xe5\xa4", [0x6792] = "\xe5\xa3",
  [0x679b] = "\xe5\xac", [0x679f] = "\xe5\xa6", [0x67a3] = "\xe5\xae",
  [0x67aa] = "\x97\x86", [0x67ab] = "\xe5\xb1", [0x67ad] = "\xe5\xa8",
  [0x67b0] = "\xe5\xa9", [0x67b4] = "\xe5\xad", [0x67b6] = "\xe5\xb0",
  [0x67b7] = "\xe5\xaf", [0x67bb] = "\xe5\xa7", [0x67c0] = "\xe5\xaa",
  [0x67c2] = "\xe5\xbb", [0x67d0] = "\xe5\xb4", [0x67df] = "\xe5\xb2",
  [0x67e2] = "\xe5\xb3", [0x67e6] = "\xe5\xb8", [0x67e7] = "\xe5\xb9",
  [0x67e9] = "\x8a\x49", [0x67eb] = "\x8b\x61", [0x67ee] = "\xe5\xb7",
  [0x67f5] = "\xe5\xa2", [0x67fd] = "\xe5\xb6", [0x67fe] = "\xe5\xba",
  [0x67ff] = "\xe5\xb5", [0x6801] = "\xe5\xbc", [0x6805] = "\xe5\xbe",
  [0x6806] = "\xe5\xbd", [0x6811] = "\xe5\xc0", [0x6812] = "\xe5\xbf",
  [0x6813] = "\xe5\x79", [0x6817] = "\xe5\xc4", [0x6821] = "\xe5\xc1",
  [0x6826] = "\xe5\xc2", [0x6829] = "\xe5\xc3", [0x682b] = "\xe5\xc5",
  [0x6830] = "\x8c\x8c", [0x6832] = "\xe5\xc7", [0x6834] = "\xe5\xc6",
  [0x6836] = "\x8f\x4f", [0x683c] = "\x8d\x73", [0x683d] = "\x9f\xa5",
  [0x6842] = "\xe5\xc8", [0x6843] = "\x8f\x70", [0x6847] = "\x8a\x58",
  [0x6849] = "\xe5\xc9", [0x684b] = "\x89\x71", [0x684d] = "\x8f\xd5",
  [0x684e] = "\xe5\xca", [0x6851] = "\x8d\x74", [0x6852] = "\xe5\xcb",
  [0x6853] = "\x88\xdf", [0x6858] = "\x95\x5c", [0x685b] = "\xe5\xcc",
  [0x6860] = "\x90\x8a", [0x6862] = "\xe5\xd3", [0x6865] = "\xe5\xd0",
  [0x6867] = "\x92\x8f", [0x686d] = "\xe5\xd1", [0x686e] = "\xe5\xce",
  [0x686f] = "\x8b\xdc", [0x6871] = "\xe5\xcd", [0x6872] = "\xe5\xd4",
  [0x6878] = "\x8c\x55", [0x687b] = "\x91\xdc", [0x687d] = "\xe5\xda",
  [0x6882] = "\xe5\xd6", [0x6886] = "\x91\xb3", [0x6887] = "\xe5\xd5",
  [0x6889] = "\xe5\xd8", [0x688e] = "\xe5\xcf", [0x6892] = "\xe5\xd9",
  [0x6894] = "\xe5\xdb", [0x689b] = "\x94\xed", [0x689e] = "\xe5\xd7",
  [0x68a0] = "\xe5\xdc", [0x68a1] = "\xe5\xde", [0x68a4] = "\x8c\xd1",
  [0x68a5] = "\xe5\xd2", [0x68a7] = "\x88\xbf", [0x68af] = "\xe5\xdd",
  [0x68b1] = "\x8d\xd9", [0x68b2] = "\x97\xf4", [0x68b3] = "\xe5\xdf",
  [0x68b4] = "\xe5\xe0", [0x68b5] = "\x91\x95", [0x68bf] = "\x97\xa0",
  [0x68c4] = "\xe5\xe1", [0x68c5] = "\x97\x54", [0x68c8] = "\xe5\xe2",
  [0x68c9] = "\xe5\xe3", [0x68cc] = "\x95\xe2", [0x68cd] = "\xe5\xe4",
  [0x68cf] = "\x8d\xbe", [0x68d1] = "\x97\xa1", [0x68d8] = "\xe5\xe9",
  [0x68e2] = "\xe5\xea", [0x68e3] = "\x8f\xd6", [0x68e4] = "\xe5\xe8",
  [0x68e8] = "\x97\x87", [0x68e9] = "\xe5\xe5", [0x68ec] = "\xe5\xe7",
  [0x68ed] = "\x90\xbb", [0x68ee] = "\x90\x9e", [0x68f2] = "\xe5\xe6",
  [0x68f4] = "\xe5\xeb", [0x68f7] = "\x95\xa1", [0x68fa] = "\xe5\xed",
  [0x68fc] = "\xe5\xec", [0x6900] = "\x8a\x8c", [0x6902] = "\x96\x4a",
  [0x6903] = "\xe5\xee", [0x690d] = "\xe5\xfa", [0x690e] = "\xe5\xf0",
  [0x6915] = "\xe5\xf1", [0x691a] = "\xe5\xf2", [0x691b] = "\xe5\xf3",
  [0x6926] = "\xe5\xf7", [0x6928] = "\xe5\xf8", [0x692b] = "\xe5\xf6",
  [0x6931] = "\xe5\xf4", [0x6933] = "\xe5\xef", [0x6934] = "\xe5\xf5",
  [0x693c] = "\xe5\xf9", [0x693d] = "\xe8\xb5", [0x6946] = "\x89\xa6",
  [0x694e] = "\xe5\xfc", [0x694f] = "\x8b\xdd", [0x6950] = "\xe5\xfb",
  [0x6954] = "\xe6\x41", [0x6956] = "\xe6\x40", [0x695a] = "\xe6\x43",
  [0x695d] = "\xe6\x42", [0x695f] = "\xe6\x44", [0x6962] = "\x8f\x50",
  [0x6964] = "\xe6\x45", [0x6967] = "\xe6\x46", [0x696e] = "\xe6\x47",
  [0x696f] = "\x90\xbc", [0x6971] = "\x97\x76", [0x6973] = "\xe6\x48",
  [0x6976] = "\x95\xa2", [0x6977] = "\x94\x65", [0x6978] = "\xe6\x49",
  [0x697a] = "\xe6\x4a", [0x697b] = "\x8c\xa9", [0x697f] = "\x8b\x4b",
  [0x6983] = "\xe6\x4b", [0x6986] = "\x8e\x8b", [0x6987] = "\x94\x60",
  [0x6988] = "\xe6\x4c", [0x698a] = "\x8a\x6f", [0x6991] = "\xe6\x4d",
  [0x6996] = "\xe6\x4f", [0x6997] = "\x97\x97", [0x6999] = "\xe6\x4e",
  [0x699a] = "\x90\x65", [0x699c] = "\xe6\x50", [0x699f] = "\xe6\x51",
  [0x69a2] = "\xe6\x52", [0x69a3] = "\x8a\xcf", [0x69aa] = "\xe6\x53",
  [0x69ad] = "\xe6\x54", [0x69af] = "\xe6\x55", [0x69b0] = "\xe6\x56",
  [0x69c2] = "\x8a\x70", [0x69ca] = "\xe6\x57", [0x69cc] = "\xe6\x58",
  [0x69cd] = "\xe6\x59", [0x69d3] = "\x89\xf0", [0x69d6] = "\x90\x47",
  [0x69d7] = "\xe6\x5a", [0x69e4] = "\xe6\x5b", [0x69e8] = "\xe6\x5c",
  [0x69f0] = "\x8c\xbe", [0x69f2] = "\x92\xf9", [0x69f3] = "\xe6\x5d",
  [0x69f8] = "\x8c\x76", [0x69fa] = "\x90\x75", [0x69fc] = "\xe6\x60",
  [0x69fe] = "\x93\xa2", [0x6a00] = "\xe6\x5f", [0x6a03] = "\x8c\x50",
  [0x6a06] = "\xe6\x5e", [0x6a07] = "\x91\xf5", [0x6a08] = "\x8b\x4c",
  [0x6a0b] = "\xe6\x61", [0x6a0d] = "\xe6\x62", [0x6a0f] = "\x8f\xd7",
  [0x6a13] = "\x8c\x8d", [0x6a15] = "\xe6\x63", [0x6a1a] = "\x96\x4b",
  [0x6a1d] = "\x90\xdd", [0x6a21] = "\x8b\x96", [0x6a23] = "\x96\xf3",
  [0x6a24] = "\x91\x69", [0x6a26] = "\xe6\x64", [0x6a2a] = "\x90\x66",
  [0x6a2b] = "\x92\x90", [0x6a2c] = "\x8f\xd8", [0x6a31] = "\xe6\x65",
  [0x6a36] = "\xe6\x68", [0x6a38] = "\xe6\x69", [0x6a40] = "\x8d\xbc",
  [0x6a41] = "\x91\xc0", [0x6a42] = "\xe6\x67", [0x6a44] = "\x8f\xd9",
  [0x6a45] = "\x95\x5d", [0x6a4b] = "\xe6\x66", [0x6a4e] = "\x8e\x8c",
  [0x6a50] = "\x89\x72", [0x6a52] = "\xe6\x6d", [0x6a53] = "\x8c\x77",
  [0x6a56] = "\x8e\x8e", [0x6a59] = "\x8e\x8d", [0x6a5b] = "\x98\x6c",
  [0x6a5c] = "\xe6\x6c", [0x6a5d] = "\xe6\x6b", [0x6a5e] = "\x91\x46",
  [0x6a60] = "\x8b\x6c", [0x6a61] = "\x98\x62", [0x6a62] = "\x8a\x59",
  [0x6a63] = "\x8f\xda", [0x6a6c] = "\xe6\x6a", [0x6a72] = "\xe6\x6f",
  [0x6a74] = "\xe6\x70", [0x6a75] = "\xe6\x6e", [0x6a77] = "\x8c\xd6",
  [0x6a79] = "\x97\x5f", [0x6a7c] = "\x8e\x8f", [0x6a7d] = "\x94\x46",
  [0x6a81] = "\xe6\x73", [0x6a83] = "\x90\xbe", [0x6a85] = "\x92\x61",
  [0x6a88] = "\x97\x55", [0x6a8a] = "\xe6\x76", [0x6a8e] = "\x8c\xea",
  [0x6a90] = "\x90\xbd", [0x6a91] = "\xe6\x72", [0x6a93] = "\xe6\x77",
  [0x6a94] = "\x8c\xeb", [0x6a95] = "\xe6\x74", [0x6a96] = "\xe6\x75",
  [0x6a98] = "\xe6\x71", [0x6a9c] = "\x90\xe0", [0x6a9d] = "\x93\xc7",
  [0x6aa0] = "\x92\x4e", [0x6aa2] = "\x89\xdb", [0x6aa9] = "\x94\xee",
  [0x6aac] = "\x8b\x62", [0x6aaf] = "\x92\xb2", [0x6ab2] = "\xe6\x7a",
  [0x6ab4] = "\xe6\x78", [0x6ab7] = "\x92\x6b", [0x6abb] = "\x90\xbf",
  [0x6abc] = "\x8a\xd0", [0x6abd] = "\xe6\x79", [0x6abf] = "\x90\x7a",
  [0x6ac2] = "\x97\xc8", [0x6ac6] = "\x98\x5f", [0x6aca] = "\xe6\x7b",
  [0x6acb] = "\xe6\x87", [0x6acc] = "\x92\xb3", [0x6ace] = "\xe6\x86",
  [0x6ad0] = "\xe6\x83", [0x6ad1] = "\xe6\x8b", [0x6ad2] = "\xe6\x84",
  [0x6ad4] = "\xe6\x80", [0x6ad6] = "\x92\xfa", [0x6ad7] = "\xe6\x7e",
  [0x6adb] = "\xe6\x7c", [0x6add] = "\x97\x40", [0x6ade] = "\x8e\x90",
  [0x6ae1] = "\xe6\x81", [0x6ae3] = "\xe6\x7d", [0x6ae7] = "\xe6\x85",
  [0x6ae8] = "\x8f\x94", [0x6aea] = "\x8c\xbf", [0x6aee] = "\x91\xf8",
  [0x6af0] = "\x96\x64", [0x6af1] = "\x89\x79", [0x6af2] = "\x88\xe0",
  [0x6af4] = "\x93\xa3", [0x6af7] = "\xe6\x89", [0x6afc] = "\xe6\x88",
  [0x6afe] = "\x93\xe4", [0x6b00] = "\xe6\x8d", [0x6b04] = "\xe6\x82",
  [0x6b06] = "\xe6\x8c", [0x6b07] = "\xe6\x8e", [0x6b09] = "\x8c\xaa",
  [0x6b0a] = "\xe6\x8a", [0x6b0b] = "\x8d\x75", [0x6b0d] = "\x8e\xd3",
  [0x6b10] = "\xe6\x8f", [0x6b11] = "\x97\x77", [0x6b16] = "\xe6\x92",
  [0x6b18] = "\xe6\x95", [0x6b1b] = "\xe6\x93", [0x6b1c] = "\x95\x54",
  [0x6b23] = "\xe6\x90", [0x6b29] = "\x8b\xde", [0x6b2e] = "\xe6\x94",
  [0x6b31] = "\xe6\x96", [0x6b39] = "\xe6\x9a", [0x6b3c] = "\xe6\x97",
  [0x6b3e] = "\xe6\x99", [0x6b3f] = "\xe6\x98", [0x6b46] = "\xe6\x9b",
  [0x6b48] = "\x8e\xaf", [0x6b4a] = "\xe6\x9d", [0x6b4b] = "\xe6\x9c",
  [0x6b4c] = "\x95\x88", [0x6b4f] = "\xe6\x9f", [0x6b56] = "\x8c\x78",
  [0x6b5b] = "\xe6\x9e", [0x6b5c] = "\xe6\xa0", [0x6b5f] = "\xe6\xa1",
  [0x6b60] = "\x8b\x63", [0x6b61] = "\xe3\xbf", [0x6b62] = "\x8f\xf7",
  [0x6b64] = "\xe6\xa2", [0x6b67] = "\x8c\xec", [0x6b6d] = "\xe6\xa3",
  [0x6b70] = "\xe6\xa4", [0x6b73] = "\x8e\x5d", [0x6b7a] = "\x9d\xcc",
  [0x6b7c] = "\xe6\xa5", [0x6b7e] = "\xe6\xa6", [0x6b80] = "\x8f\x51",
  [0x6b82] = "\xe6\xa7", [0x6b83] = "\xe6\xa8", [0x6b86] = "\xe6\xa9",
  [0x6b89] = "\xe6\xaa", [0x6b8a] = "\xe6\xab", [0x6c27] = "\x92\x4a",
  [0x6c2a] = "\xe6\xac", [0x6c2f] = "\xe6\xae", [0x6c31] = "\xe6\xad",
  [0x6c36] = "\x93\xa4", [0x6c38] = "\xe6\xaf", [0x6c3a] = "\x96\x4c",
  [0x6c3c] = "\xe6\xb0", [0x6c3e] = "\xe6\xb1", [0x6c40] = "\xe6\xb2",
  [0x6c45] = "\xe6\xb3", [0x6c4a] = "\x93\xd8", [0x6c51] = "\x8f\xdb",
  [0x6c52] = "\xe6\xb4", [0x6c5a] = "\x8d\x8b", [0x6c5b] = "\x98\xac",
  [0x6c5c] = "\xe6\xb5", [0x6c68] = "\xe6\xb6", [0x6c69] = "\x95\x5e",
  [0x6c6a] = "\xe6\xb7", [0x6c6c] = "\xe6\xbf", [0x6c72] = "\xe6\xb8",
  [0x6c75] = "\xe6\xba", [0x6c79] = "\xe6\xb9", [0x6c7a] = "\xe6\xbb",
  [0x6c7c] = "\x96\x65", [0x6c7d] = "\xe6\xbc", [0x6c7e] = "\xe6\xbd",
  [0x6c84] = "\xe6\xbe", [0x6c88] = "\xe6\xc0", [0x6c8d] = "\x8a\x4c",
  [0x6c8e] = "\x92\xe5", [0x6c90] = "\x95\x89", [0x6c91] = "\x8d\xe0",
  [0x6c92] = "\x8d\x76", [0x6c97] = "\x95\x6e", [0x6c98] = "\x89\xdd",
  [0x6c99] = "\x94\xcc", [0x6c9a] = "\xe6\xc3", [0x6c9b] = "\x8a\xd1",
  [0x6c9c] = "\x90\xd3", [0x6c9d] = "\xe6\xc2", [0x6c9e] = "\xe6\xc7",
  [0x6c9f] = "\x92\x99", [0x6ca0] = "\x96\xe1", [0x6ca2] = "\xe6\xc5",
  [0x6ca3] = "\xe6\xc6", [0x6ca4] = "\x8b\x4d", [0x6ca6] = "\xe6\xc8",
  [0x6ca7] = "\x94\x83", [0x6ca8] = "\x91\xdd", [0x6cab] = "\x94\xef",
  [0x6cac] = "\x93\x5c", [0x6cad] = "\xe6\xc4", [0x6caf] = "\x96\x66",
  [0x6cb0] = "\x89\xea", [0x6cb1] = "\xe6\xca", [0x6cb2] = "\x98\x47",
  [0x6cb3] = "\x92\xc0", [0x6cb4] = "\x98\x64", [0x6cb7] = "\x8e\x91",
  [0x6cb8] = "\xe6\xc9", [0x6cba] = "\x91\xaf", [0x6cbd] = "\xe6\xda",
  [0x6cbe] = "\x91\x47", [0x6cc1] = "\x93\xf6", [0x6cc3] = "\x95\x6f",
  [0x6cca] = "\xe6\xcd", [0x6ccb] = "\x8e\x5e", [0x6ccc] = "\x8e\x92",
  [0x6cce] = "\x8f\xdc", [0x6cd0] = "\x94\x85", [0x6cd2] = "\x8c\xab",
  [0x6cd3] = "\xe6\xcc", [0x6cd4] = "\xe6\xcb", [0x6cd6] = "\x95\x8a",
  [0x6cda] = "\x8e\xbf", [0x6cdd] = "\x93\x71", [0x6cea] = "\xe6\xcf",
  [0x6ceb] = "\xe6\xd0", [0x6cec] = "\x8d\x77", [0x6ced] = "\xe6\xce",
  [0x6cf4] = "\xe6\xd1", [0x6cf5] = "\xe6\xd2", [0x6cf7] = "\xe6\xd4",
  [0x6cf8] = "\x91\xa1", [0x6cfa] = "\xe6\xd3", [0x6cfb] = "\x8a\xe4",
  [0x6cfd] = "\xe6\xd6", [0x6cff] = "\xe6\xd5", [0x6d00] = "\xe6\xd7",
  [0x6d03] = "\xe6\xd9", [0x6d04] = "\xe6\xdb", [0x6d06] = "\xe6\xdc",
  [0x6d54] = "\x90\xd4", [0x6d56] = "\x8e\xcd", [0x6d57] = "\xe6\xdd",
  [0x6d5b] = "\x8a\x71", [0x6d5d] = "\xe6\xde", [0x6d60] = "\x91\x96",
  [0x6d61] = "\xe6\xdf", [0x6d63] = "\xe6\xe0", [0x6d64] = "\x95\x8b",
  [0x6d67] = "\x8b\x4e", [0x6d71] = "\xe6\xe1", [0x6d75] = "\x92\xb4",
  [0x6d7a] = "\x89\x7a", [0x6d89] = "\xe6\xe2", [0x6d93] = "\x8e\xef",
  [0x6d98] = "\x90\x96", [0x6da3] = "\x91\xab", [0x6daa] = "\xe6\xe5",
  [0x6dae] = "\xe6\xe4", [0x6db2] = "\xe6\xe3", [0x6dbb] = "\xe6\xeb",
  [0x6dbc] = "\xe6\xe9", [0x6dbf] = "\xe6\xe6", [0x6dc6] = "\xe6\xe8",
  [0x6dca] = "\xe6\xe7", [0x6dcb] = "\xe6\xea", [0x6dcd] = "\x8b\x97",
  [0x6dcf] = "\xe6\xee", [0x6dd1] = "\x90\xd5", [0x6dd3] = "\xe6\xef",
  [0x6dd8] = "\x8c\xd7", [0x6dda] = "\xe6\xec", [0x6ddb] = "\xe6\xed",
  [0x6ddf] = "\x98\x48", [0x6de3] = "\x92\xb5", [0x6de5] = "\x91\x48",
  [0x6dec] = "\xe6\xf0", [0x6def] = "\xe6\xf3", [0x6df8] = "\xe6\xf1",
  [0x6df9] = "\xe6\xf2", [0x6dfa] = "\x97\x78", [0x6dff] = "\x93\xa5",
  [0x6e00] = "\xe6\xf6", [0x6e0d] = "\xe6\xf4", [0x6e0e] = "\xe6\xf5",
  [0x6e0f] = "\xe6\xf7", [0x6e1a] = "\xe7\x48", [0x6e20] = "\xe6\xfa",
  [0x6e24] = "\xe6\xfb", [0x6e25] = "\xe6\xf9", [0x6e32] = "\xe6\xf8",
  [0x6e34] = "\x92\xfb", [0x6e37] = "\xe7\x40", [0x6e38] = "\xe7\x44",
  [0x6e39] = "\xe7\x41", [0x6e3a] = "\xe6\xfc", [0x6e3c] = "\xe7\x42",
  [0x6e40] = "\xe7\x43", [0x6e45] = "\xe7\x4a", [0x6e49] = "\xe7\x45",
  [0x6e4f] = "\x90\xd6", [0x6e50] = "\xe7\x47", [0x6e53] = "\xe7\x49",
  [0x6e54] = "\xe7\x46", [0x6e62] = "\xe7\x4c", [0x6e64] = "\x8f\x52",
  [0x6e66] = "\xe7\x4b", [0x6e6c] = "\xe7\x4d", [0x6e71] = "\xe7\x4e",
  [0x6e74] = "\xe7\x51", [0x6e75] = "\xe7\x50", [0x6e77] = "\xe7\x4f",
  [0x6e7a] = "\xe7\x53", [0x6e7b] = "\xe7\x52", [0x6e7d] = "\x96\xf4",
  [0x6e81] = "\xe7\x55", [0x6e83] = "\xe7\x54", [0x6e84] = "\xe7\x56",
  [0x6e89] = "\xe7\x57", [0x6e91] = "\xe7\x59", [0x6e9a] = "\xe7\x58",
  [0x6e9b] = "\x90\x67", [0x6e9c] = "\xe7\x5a", [0x6e9f] = "\x8b\xeb",
  [0x6ea0] = "\xe7\x5b", [0x6ea1] = "\xe7\x5d", [0x6eae] = "\xe7\x5e",
  [0x6eb5] = "\xe7\x5f", [0x6eb6] = "\xe7\x5c", [0x6eb8] = "\xe7\x60",
  [0x6eba] = "\x8e\xd4", [0x6ebb] = "\xe7\x61", [0x6ebc] = "\x8b\x4f",
  [0x6ebd] = "\x8c\x52", [0x6ec2] = "\x8c\xac", [0x6ecb] = "\xe7\x62",
  [0x6ecf] = "\x93\xee", [0x6ed2] = "\x93\x5d", [0x6ed3] = "\xe7\x63",
  [0x6edb] = "\xe7\x66", [0x6ee8] = "\x8e\xb2", [0x6eeb] = "\xe7\x65",
  [0x6eec] = "\xe7\x64", [0x6eed] = "\x8c\x79", [0x6eee] = "\xe7\x67",
  [0x6ef3] = "\x8a\x72", [0x6ef5] = "\xe7\x69", [0x6ef9] = "\x8d\xda",
  [0x6efa] = "\xe7\x68", [0x6efc] = "\xe7\x71", [0x6f02] = "\xe7\x6b",
  [0x6f03] = "\xe7\x6d", [0x6f04] = "\x95\xe3", [0x6f05] = "\xe7\x6a",
  [0x6f09] = "\xe7\x6c", [0x6f0b] = "\xe7\x70", [0x6f0c] = "\xe7\x6e",
  [0x6f0d] = "\x8b\x50", [0x6f0f] = "\xe7\x6f", [0x6f16] = "\xe7\x72",
  [0x6f19] = "\x94\x79", [0x6f1a] = "\x97\xd6", [0x6f1f] = "\x8f\x53",
  [0x6f23] = "\xe7\x73", [0x6f28] = "\x97\x41", [0x6f29] = "\xe7\x75",
  [0x6f2b] = "\xe7\x74", [0x6f2e] = "\xe7\x78", [0x6f2f] = "\x97\x60",
  [0x6f32] = "\xe7\x77", [0x6f34] = "\x8a\x8d", [0x6f35] = "\xe7\x76",
  [0x6f36] = "\xe7\x7b", [0x6f39] = "\xe7\x7a", [0x6f3c] = "\xe7\x79",
  [0x6f3d] = "\x93\x51", [0x6f3e] = "\xe7\x7c", [0x6f47] = "\xe7\x7d",
  [0x6f4c] = "\xe7\x7e", [0x6f4f] = "\x8d\x8c", [0x6f51] = "\x8c\x44",
  [0x6f52] = "\xe7\x80", [0x6f53] = "\xe7\x81", [0x6f54] = "\xe7\x82",
  [0x6f8b] = "\x90\x68", [0x6f8c] = "\xe7\x83", [0x6f8e] = "\x8e\xab",
  [0x6f8f] = "\xe7\x84", [0x6f93] = "\xe7\x85", [0x6f97] = "\x99\x9f",
  [0x6f98] = "\x99\x9e", [0x6f9d] = "\xe7\x86", [0x6f9e] = "\xe3\x90",
  [0x6f9f] = "\xe7\x87", [0x6fa0] = "\x92\x43", [0x6fa1] = "\x90\x4a",
  [0x6fa2] = "\x94\x5f", [0x6fa7] = "\xe7\x88", [0x6faa] = "\x95\xd3",
  [0x6fab] = "\x92\xd2", [0x6fac] = "\x8d\x9e", [0x6faf] = "\x92\x48",
  [0x6fb2] = "\x89\x49", [0x6fb4] = "\x96\x98", [0x6fb5] = "\x90\x76",
  [0x6fbe] = "\x8c\x7d", [0x6fc1] = "\x8b\xdf", [0x6fc4] = "\x95\xd4",
  [0x6fca] = "\xe7\x89", [0x6fd2] = "\xe7\x8b", [0x6fd5] = "\xe7\x8a",
  [0x6fd6] = "\x89\xde", [0x6fd9] = "\x93\xf4", [0x6fda] = "\xe7\x8c",
  [0x6fdb] = "\x94\x97", [0x6fdd] = "\x93\x52", [0x6fdf] = "\xe7\x8d",
  [0x6fe0] = "\x8f\x71", [0x6fe4] = "\xe7\x8f", [0x6fe7] = "\x96\xc0",
  [0x6fe8] = "\xe7\x9e", [0x6fe9] = "\xe7\x91", [0x6fea] = "\xe7\x92",
  [0x6fed] = "\x92\xc7", [0x6ff0] = "\x91\xde", [0x6ff1] = "\x91\x97",
  [0x6ff3] = "\x93\xa6", [0x6ff5] = "\xe7\x90", [0x6ff6] = "\x8b\x74",
  [0x6ffb] = "\xe7\x99", [0x6ffd] = "\xe7\x96", [0x6ffe] = "\xe7\xa3",
  [0x6fff] = "\x93\xa7", [0x7000] = "\x92\x80", [0x7001] = "\xe7\x93",
  [0x7003] = "\x92\xfc", [0x7004] = "\x93\x72", [0x7005] = "\xe7\x94",
  [0x7006] = "\xe7\x98", [0x7007] = "\x90\x80", [0x7009] = "\x94\x87",
  [0x700a] = "\x92\xca", [0x700d] = "\x90\xc0", [0x700e] = "\xe7\x97",
  [0x700f] = "\x91\xac", [0x7010] = "\x91\xa2", [0x7011] = "\xe7\x95",
  [0x7012] = "\x88\xa7", [0x7013] = "\x98\x41", [0x7017] = "\xe7\x9a",
  [0x701e] = "\x91\xdf", [0x7021] = "\x8f\x54", [0x7022] = "\x90\x69",
  [0x7025] = "\xe7\x9c", [0x7026] = "\xe7\x9b", [0x7028] = "\x88\xed",
  [0x7029] = "\xe7\x9d", [0x702c] = "\x95\x4e", [0x702e] = "\xe7\xa5",
  [0x7031] = "\x93\xd9", [0x7032] = "\x90\x8b", [0x7035] = "\x92\x78",
  [0x7037] = "\x8b\xf6", [0x7039] = "\xe7\xa4", [0x703a] = "\x97\x56",
  [0x703b] = "\x89\x5e", [0x703d] = "\x95\xd5", [0x703e] = "\x89\xdf",
  [0x703f] = "\xe7\x9f", [0x7040] = "\xe7\xa0", [0x7041] = "\xe7\xa1",
  [0x7042] = "\xe7\xa2", [0x7043] = "\x93\xb9", [0x7044] = "\x92\x42",
  [0x7045] = "\x88\xe1", [0x7046] = "\xe7\xa6", [0x7048] = "\xe7\xa7",
  [0x7049] = "\xea\xa1", [0x704c] = "\x91\xbb", [0x704e] = "\xe7\xa8",
  [0x7050] = "\x89\x93", [0x7051] = "\x91\x6b", [0x7053] = "\x8c\xad",
  [0x7055] = "\x97\x79", [0x7058] = "\xe7\xa9", [0x7059] = "\x93\x4b",
  [0x705d] = "\x91\x98", [0x705e] = "\x8e\xd5", [0x705f] = "\xe7\xaa",
  [0x7062] = "\xe7\xad", [0x7065] = "\x8f\x85", [0x7066] = "\xe7\xab",
  [0x7067] = "\x91\x4a", [0x7068] = "\x91\x49", [0x706a] = "\x88\xe2",
  [0x706c] = "\x97\xc9", [0x706d] = "\xe7\xaf", [0x706f] = "\x94\xf0",
  [0x7070] = "\xe7\xb1", [0x7071] = "\xe7\xb0", [0x7072] = "\xe7\xae",
  [0x7073] = "\xe2\x84", [0x7074] = "\x8a\xd2", [0x7077] = "\xe7\x8e",
  [0x7079] = "\xe7\xb3", [0x707a] = "\xe7\xb2", [0x707f] = "\xe7\xb4",
  [0x7081] = "\x97\x57", [0x7093] = "\x93\xdf", [0x7096] = "\x96\x4d",
  [0x7098] = "\xe7\xb5", [0x709a] = "\x8e\xd7", [0x709f] = "\xe7\xb6",
  [0x70a1] = "\xe7\xb7", [0x70a5] = "\xe7\xb8", [0x70a8] = "\x93\x40",
  [0x70b1] = "\x88\xe8", [0x70ba] = "\x8d\x78", [0x70be] = "\x98\x59",
  [0x70cb] = "\xe7\xbc", [0x70d1] = "\x8c\x53", [0x70d2] = "\xe7\xb9",
  [0x70d4] = "\xe7\xba", [0x70d8] = "\x95\x94", [0x70dd] = "\x8a\x73",
  [0x70e5] = "\x97\x58", [0x70e7] = "\x8b\xbd", [0x70ed] = "\x93\x73",
  [0x70f2] = "\xe7\xbd", [0x7102] = "\xe7\xbe", [0x7109] = "\xe7\xbf",
  [0x711d] = "\x93\x41", [0x7120] = "\xe7\xc1", [0x7122] = "\xe7\xc0",
  [0x7139] = "\x93\xd1", [0x713a] = "\xe7\xc2", [0x713b] = "\x8f\x55",
  [0x713c] = "\x8e\xde", [0x713d] = "\x94\x7a", [0x713e] = "\x92\x91",
  [0x7142] = "\x8e\xf0", [0x7144] = "\x90\x8c", [0x7146] = "\xe7\xc3",
  [0x7148] = "\xe7\xc4", [0x7152] = "\x90\x7c", [0x7153] = "\xe7\xc5",
  [0x7155] = "\xe7\xc6", [0x7159] = "\xe7\xc7", [0x715a] = "\x97\x8f",
  [0x715c] = "\x8f\x56", [0x7162] = "\xe7\xc9", [0x7163] = "\xe7\xc8",
  [0x7165] = "\x8d\x79", [0x7167] = "\x8d\x93", [0x7168] = "\x8e\x5f",
  [0x7172] = "\xe7\xcc", [0x7177] = "\x8f\x86", [0x7179] = "\xe7\xcb",
  [0x717b] = "\xe7\xca", [0x717d] = "\x91\xe7", [0x7180] = "\x8c\xed",
  [0x7182] = "\x90\xc1", [0x7187] = "\x94\xae", [0x718c] = "\x8f\x58",
  [0x7192] = "\xe7\xcd", [0x7194] = "\x8f\xdd", [0x719a] = "\xe7\xd0",
  [0x719b] = "\xe7\xce", [0x719f] = "\xe7\xcf", [0x71a4] = "\xe7\xd2",
  [0x71a5] = "\xe7\xd1", [0x71a8] = "\x8f\xf8", [0x71aa] = "\xe7\xd3",
  [0x71b0] = "\xe7\xd4", [0x71b1] = "\xe7\xd5", [0x71b6] = "\x94\xce",
  [0x71b7] = "\x8d\xd1", [0x71b8] = "\x8e\xdf", [0x71b9] = "\xe7\xd6",
  [0x71bb] = "\xe7\xd7", [0x71bc] = "\x97\xa2", [0x71bd] = "\x8f\x64",
  [0x71be] = "\x96\xec", [0x71bf] = "\x97\xca", [0x71c0] = "\xe7\xd8",
  [0x71c1] = "\x8b\xe0", [0x71c6] = "\xe7\xd9", [0x71c8] = "\x93\x42",
  [0x71cb] = "\xe7\xdc", [0x71cc] = "\x8a\x98", [0x71cd] = "\x90\x6a",
  [0x71cf] = "\xe7\xda", [0x71d1] = "\xe7\xdb", [0x71d3] = "\x92\xde",
  [0x71d6] = "\x96\x74", [0x71d7] = "\x8b\xfa", [0x71e5] = "\xe7\xde",
  [0x71e6] = "\xe7\xdf", [0x71ec] = "\xe7\xdd", [0x71ef] = "\xe7\xe1",
  [0x71fd] = "\x93\xdd", [0x71fe] = "\x8a\x62", [0x7201] = "\xe7\xe5",
  [0x7204] = "\xe7\xe2", [0x7205] = "\xe7\xe4", [0x720e] = "\xe7\xe0",
  [0x7219] = "\xe8\x6e", [0x721c] = "\xe7\xe3", [0x7224] = "\x97\xe9",
  [0x7227] = "\x8c\xd8", [0x722f] = "\xe7\xed", [0x7234] = "\x93\x53",
  [0x7235] = "\xe7\xe8", [0x7238] = "\xe7\xeb", [0x7239] = "\xe7\xe9",
  [0x723b] = "\xe7\xee", [0x7240] = "\xe7\xef", [0x7247] = "\xe7\xe7",
  [0x724a] = "\xe7\xf4", [0x724b] = "\x89\x94", [0x724e] = "\xe7\xe6",
  [0x7252] = "\x94\xab", [0x7254] = "\xe7\xea", [0x7256] = "\x8f\xde",
  [0x7261] = "\x8d\x7a", [0x726e] = "\x96\x67", [0x7270] = "\x8b\xe2",
  [0x7273] = "\x8f\x65", [0x7275] = "\x93\xba", [0x7281] = "\x91\x4c",
  [0x7283] = "\xe7\xf2", [0x7285] = "\xe7\xec", [0x7286] = "\xe7\xf1",
  [0x7288] = "\x96\xc1", [0x728a] = "\x92\xb6", [0x728b] = "\xe7\xf3",
  [0x728c] = "\xe7\xf0", [0x729d] = "\x91\x4b", [0x72a7] = "\xe7\xf7",
  [0x72a9] = "\xe7\xf6", [0x72bf] = "\xe7\xf5", [0x72c2] = "\x96\x4e",
  [0x72d4] = "\x8f\x9b", [0x72d9] = "\xe7\xf8", [0x72da] = "\x95\xdd",
  [0x72dd] = "\x89\x73", [0x72e2] = "\x95\x65", [0x72e3] = "\x92\x92",
  [0x72e8] = "\x8b\x98", [0x72ea] = "\xe7\xfa", [0x72ec] = "\x8d\x7c",
  [0x72f6] = "\x8e\x4b", [0x72ff] = "\xe7\xf9", [0x7300] = "\x90\x8d",
  [0x7308] = "\x90\x8e", [0x7309] = "\xe8\x40", [0x730a] = "\xe8\x42",
  [0x7310] = "\x8f\xf9", [0x7312] = "\xe8\x41", [0x7313] = "\xe8\x43",
  [0x7316] = "\x8b\xd1", [0x7318] = "\x95\x64", [0x731b] = "\x8e\xe0",
  [0x731c] = "\x98\x42", [0x731e] = "\xe7\xfc", [0x731f] = "\x8d\xf6",
  [0x7322] = "\x98\x5e", [0x7325] = "\xe8\x45", [0x732a] = "\xe8\x44",
  [0x732b] = "\xe8\x46", [0x7334] = "\xe7\xfb", [0x733b] = "\x93\xe7",
  [0x733d] = "\x93\x74", [0x7344] = "\x92\xd5", [0x7346] = "\xe8\x4b",
  [0x734b] = "\x92\x62", [0x734c] = "\xe8\x47", [0x7350] = "\xe8\x48",
  [0x735c] = "\x8c\x4c", [0x735e] = "\xe8\x4a", [0x7365] = "\x8c\xae",
  [0x736c] = "\xe8\x49", [0x736e] = "\x8f\xdf", [0x737c] = "\x8a\x99",
  [0x7384] = "\xe8\x4f", [0x7386] = "\x8d\xbd", [0x7387] = "\x91\x99",
  [0x738a] = "\x92\xc8", [0x7397] = "\x8a\x5a", [0x739c] = "\xe8\x4d",
  [0x739d] = "\xe8\x4e", [0x739e] = "\x92\xc1", [0x73a0] = "\xe8\x4c",
  [0x73a9] = "\xe8\x50", [0x73b3] = "\xe8\x56", [0x73b8] = "\xe8\x59",
  [0x73c0] = "\xe8\x58", [0x73c1] = "\x93\x4c", [0x73c6] = "\xe8\x51",
  [0x73c7] = "\xe8\x52", [0x73c8] = "\xe8\x55", [0x73cd] = "\xe8\x57",
  [0x73d1] = "\x8b\xbe", [0x73d4] = "\xe8\x5a", [0x73d5] = "\xe8\x54",
  [0x73d8] = "\xe8\x53", [0x73f3] = "\xe8\x5e", [0x73f7] = "\xe8\x5f",
  [0x7400] = "\xe8\x60", [0x7403] = "\xe8\x5d", [0x7404] = "\xe8\x5c",
  [0x7408] = "\x8f\xe0", [0x7409] = "\x93\xa8", [0x740a] = "\xe8\x5b",
  [0x7411] = "\xe8\x64", [0x741b] = "\xe8\x62", [0x7425] = "\xe8\x63",
  [0x7426] = "\xe8\x61", [0x7428] = "\x91\xf6", [0x742a] = "\xe8\x65",
  [0x7431] = "\xe8\x66", [0x7434] = "\xe8\x68", [0x7441] = "\x8a\xd3",
  [0x7442] = "\xe8\x67", [0x7443] = "\x96\xf8", [0x744a] = "\xe8\x73",
  [0x744b] = "\xe8\x69", [0x744e] = "\xe8\x6c", [0x7450] = "\xe8\x6a",
  [0x7452] = "\xe8\x6b", [0x745a] = "\xe8\x6d", [0x7460] = "\xe8\x6f",
  [0x7465] = "\xe8\x70", [0x7467] = "\xe8\x71", [0x746c] = "\xe8\x74",
  [0x746d] = "\xe8\x72", [0x746e] = "\xe8\x75", [0x746f] = "\xe8\x77",
  [0x7471] = "\xe8\x76", [0x7567] = "\x92\xb7", [0x7570] = "\x96\xe5",
  [0x7572] = "\xe8\x78", [0x7573] = "\x91\x4d", [0x7577] = "\xe8\x79",
  [0x7579] = "\x95\xc2", [0x757a] = "\xe8\x7a", [0x757b] = "\x8a\x4a",
  [0x757f] = "\x89\x5b", [0x7581] = "\x8a\xd5", [0x7583] = "\x8a\xd4",
  [0x7584] = "\xe8\x7b", [0x7586] = "\xe8\x7c", [0x7588] = "\xe8\x7d",
  [0x7589] = "\xe8\x7e", [0x7590] = "\xe8\x80", [0x7592] = "\x8a\xd6",
  [0x7593] = "\x8a\x74", [0x7594] = "\x8d\x7d", [0x7595] = "\x94\xb4",
  [0x7597] = "\xe8\x82", [0x7598] = "\xe8\x81", [0x759d] = "\xe8\x83",
  [0x75a2] = "\x89\x7b", [0x75a9] = "\xe8\x86", [0x75ab] = "\xe8\x85",
  [0x75ac] = "\xe8\x84", [0x75ae] = "\xe8\x87", [0x75b3] = "\xe8\x8a",
  [0x75b7] = "\x88\xc5", [0x75ba] = "\xe8\x88", [0x75bc] = "\xe8\x8c",
  [0x75bd] = "\xe8\x8b", [0x75c4] = "\xe8\x8e", [0x75c5] = "\xe8\x8d",
  [0x75c6] = "\xe8\x8f", [0x75c8] = "\x93\xac", [0x75cc] = "\xe8\x90",
  [0x75d1] = "\xe8\x91", [0x75d2] = "\xe8\x93", [0x75d5] = "\xe8\x92",
  [0x760c] = "\x95\x8c", [0x7611] = "\xe8\x94", [0x7618] = "\xe8\x95",
  [0x761a] = "\x8d\xe3", [0x761e] = "\xe8\x96", [0x761f] = "\xe8\x97",
  [0x7622] = "\x96\x68", [0x762b] = "\x91\x6a", [0x762f] = "\x88\xa2",
  [0x7630] = "\x91\xc9", [0x7632] = "\xe8\x98", [0x7634] = "\x95\x8d",
  [0x763b] = "\xe8\x9b", [0x763c] = "\xe8\x99", [0x763d] = "\x8d\x7e",
  [0x763f] = "\xe8\x9a", [0x7640] = "\x8c\xc0", [0x764b] = "\x95\xc3",
  [0x764c] = "\xe8\x9d", [0x764d] = "\xe8\x9f", [0x764e] = "\xe8\x9e",
  [0x764f] = "\xe8\xa0", [0x7652] = "\x89\x40", [0x7653] = "\x90\x77",
  [0x7654] = "\x8f\x9c", [0x7655] = "\x8a\xd7", [0x7656] = "\xe8\xa1",
  [0x765a] = "\x94\x86", [0x765c] = "\xe8\xa3", [0x7660] = "\x89\x41",
  [0x7662] = "\xe8\xa2", [0x7663] = "\x92\xc2", [0x7665] = "\x97\xcb",
  [0x7666] = "\x93\xa9", [0x7667] = "\xe8\x9c", [0x7668] = "\x97\xa4",
  [0x766a] = "\x8c\xaf", [0x766d] = "\x97\x7a", [0x7675] = "\x8b\xf7",
  [0x7676] = "\x97\xb2", [0x7678] = "\x8c\x47", [0x767a] = "\x91\xe0",
  [0x767b] = "\xe4\x40", [0x767d] = "\xe8\xa4", [0x767e] = "\x8a\x4b",
  [0x767f] = "\x90\x8f", [0x7684] = "\x8a\x75", [0x7685] = "\xe8\xa6",
  [0x7687] = "\xe8\xa7", [0x7688] = "\xe8\xa5", [0x7689] = "\x8c\x84",
  [0x768b] = "\x8d\xdb", [0x768c] = "\x8f\xe1", [0x7690] = "\x89\x42",
  [0x7693] = "\x97\xd7", [0x7697] = "\xe8\xa9", [0x7698] = "\xe7\xac",
  [0x769a] = "\xe8\xa8", [0x76a0] = "\xe8\xac", [0x76a1] = "\xe8\xaa",
  [0x76a2] = "\xe8\xab", [0x76a4] = "\xe8\xad", [0x76a6] = "\xe8\xae",
  [0x76a7] = "\x97\xea", [0x76a8] = "\xe8\xaf", [0x76a9] = "\xe8\xb0",
  [0x76ab] = "\x90\xc7", [0x76ac] = "\x94\xb9", [0x76b0] = "\x90\x9d",
  [0x76b1] = "\x8a\xe5", [0x76b4] = "\x97\x59", [0x76b5] = "\x89\xeb",
  [0x76b6] = "\x8f\x57", [0x76b7] = "\x8c\xd9", [0x76b9] = "\xe8\xb3",
  [0x76bb] = "\xe8\xb2", [0x76bc] = "\x8e\x93", [0x76bd] = "\xe8\xb4",
  [0x76be] = "\xe8\xb1", [0x76c1] = "\x8e\x47", [0x76c5] = "\xe8\xb8",
  [0x76c6] = "\xe5\xab", [0x76c9] = "\x99\xd4", [0x76cb] = "\x90\x97",
  [0x76cc] = "\xe8\xb6", [0x76d2] = "\x97\xa3", [0x76d3] = "\x93\xef",
  [0x76d8] = "\x89\x4a", [0x76da] = "\x90\xe1", [0x76db] = "\x8e\xb4",
  [0x76e0] = "\x95\xb5", [0x76e2] = "\x89\x5f", [0x76e6] = "\x97\xeb",
  [0x76e7] = "\x97\x8b", [0x76e9] = "\xe8\xb9", [0x76eb] = "\x93\x64",
  [0x76f0] = "\x8e\xf9", [0x76f4] = "\xe8\xba", [0x76f6] = "\xe8\xbb",
  [0x76f7] = "\x90\x6b", [0x76f8] = "\xe8\xbc", [0x76fa] = "\x97\xec",
  [0x76fd] = "\xe8\xb7", [0x76fe] = "\xe8\xbe", [0x76ff] = "\xe8\xc0",
  [0x7701] = "\xe8\xbf", [0x7703] = "\xe8\xbd", [0x7706] = "\xe8\xc1",
  [0x7709] = "\xe8\xc2", [0x770c] = "\x91\x9a", [0x770e] = "\x89\xe0",
  [0x7714] = "\xe8\xc3", [0x7717] = "\x96\xb6", [0x771a] = "\xe8\xc4",
  [0x7720] = "\xe8\xc5", [0x7722] = "\x98\x49", [0x7728] = "\x9e\x50",
  [0x7729] = "\xe8\xc6", [0x772d] = "\xe8\xc7", [0x772e] = "\xe8\xc8",
  [0x7732] = "\xe8\xcc", [0x7734] = "\xe8\xc9", [0x7736] = "\xe8\xca",
  [0x7738] = "\xe8\xcb", [0x7739] = "\xe8\xcd", [0x7742] = "\x90\xc2",
  [0x7746] = "\x96\xf5", [0x7749] = "\x90\xc3", [0x774c] = "\xe8\xce",
  [0x774e] = "\x94\xf1", [0x7750] = "\xe8\xcf", [0x7751] = "\xea\x72",
  [0x7752] = "\x96\xca", [0x7754] = "\xe8\xd0", [0x7756] = "\xe8\xd1",
  [0x7758] = "\xe8\xd2", [0x7759] = "\x8a\x76", [0x775b] = "\xe8\xd4",
  [0x775d] = "\x90\x78", [0x7761] = "\xe8\xd5", [0x7764] = "\x8c\x43",
  [0x7769] = "\xe8\xd6", [0x776a] = "\xe8\xda", [0x776c] = "\xe8\xd8",
  [0x7771] = "\xe8\xd9", [0x7774] = "\x8a\x93", [0x7775] = "\xe8\xd7",
  [0x7776] = "\xe8\xdb", [0x777b] = "\xe8\xdc", [0x777d] = "\x88\xc6",
  [0x777f] = "\xe8\xdd", [0x7780] = "\xe8\xde", [0x7788] = "\x8f\xe2",
  [0x778c] = "\xe8\xdf", [0x7790] = "\x8b\x66", [0x7793] = "\xe8\xe2",
  [0x7796] = "\xe8\xe1", [0x7798] = "\xe8\xe0", [0x779b] = "\xe6\x91",
  [0x779d] = "\x95\xda", [0x77a3] = "\xe8\xe3", [0x77a4] = "\xe8\xe4",
  [0x77b3] = "\xe8\xe5", [0x77b6] = "\xe8\xe6", [0x77b8] = "\xe8\xe7",
  [0x77bb] = "\xe8\xe8", [0x77c3] = "\x8a\xd8", [0x77cc] = "\xe8\xe9",
  [0x77dd] = "\xe8\xea", [0x77de] = "\x94\x42", [0x77e2] = "\xe8\xec",
  [0x77e3] = "\x89\xb9", [0x77e5] = "\xe8\xef", [0x77e6] = "\xe8\xee",
  [0x77eb] = "\x89\x43", [0x77ef] = "\x8b\xbf", [0x77f1] = "\x95\xc5",
  [0x77f2] = "\x92\xb8", [0x77f3] = "\x8d\xa0", [0x77f5] = "\x8d\x80",
  [0x77f6] = "\x8f\x87", [0x77f8] = "\x90\x7b", [0x77fc] = "\xe8\xf1",
  [0x77ff] = "\xe8\xf0", [0x7800] = "\x97\x61", [0x7801] = "\x8a\xe6",
  [0x7802] = "\x94\xd0", [0x7803] = "\x93\xda", [0x7807] = "\x90\x9c",
  [0x7808] = "\x97\xcc", [0x780a] = "\x8c\x7a", [0x7811] = "\xe8\xf4",
  [0x7814] = "\xe8\xf3", [0x781c] = "\x96\x6a", [0x781d] = "\x93\xaa",
  [0x7824] = "\x89\x6f", [0x7827] = "\xe8\xf5", [0x7828] = "\xe8\xf2",
  [0x782b] = "\x95\x70", [0x782c] = "\x97\x8a", [0x782d] = "\xe8\xf6",
  [0x7836] = "\xe8\xf7", [0x783b] = "\xe8\xf9", [0x783c] = "\x91\xe8",
  [0x783d] = "\x8a\x7a", [0x783e] = "\x8a\x7b", [0x783f] = "\xe8\xf8",
  [0x7844] = "\x8a\xe7", [0x7845] = "\x8c\xb0", [0x7848] = "\x8a\xe8",
  [0x784b] = "\x93\x5e", [0x784e] = "\x97\xde", [0x7857] = "\x8c\xda",
  [0x785b] = "\xe8\xfa", [0x785f] = "\xe8\xfb", [0x7860] = "\xe8\xfc",
  [0x7861] = "\xe9\x40", [0x7863] = "\xe9\x42", [0x7864] = "\xe9\x41",
  [0x7898] = "\x95\x97", [0x789a] = "\xe9\x43", [0x789f] = "\xe9\x44",
  [0x78a1] = "\xe9\x45", [0x78a6] = "\xe9\x46", [0x78b3] = "\xe9\x48",
  [0x78b4] = "\xe9\x47", [0x78b6] = "\xe9\x49", [0x78cb] = "\x94\xf2",
  [0x78cc] = "\xe3\xca", [0x78cf] = "\x90\x48", [0x78d2] = "\x8b\x51",
  [0x78d9] = "\xe9\x4a", [0x78db] = "\xe9\x4b", [0x78dd] = "\x99\xaa",
  [0x78de] = "\x9f\x5a", [0x78df] = "\x94\xd1", [0x78e2] = "\x88\xf9",
  [0x78e4] = "\x88\xb9", [0x78ec] = "\x8e\x94", [0x78ed] = "\x96\x4f",
  [0x78ee] = "\x8f\xfc", [0x78f3] = "\xe9\x4c", [0x78f5] = "\x96\xdd",
  [0x78f9] = "\xe9\x4d", [0x78fa] = "\x97\x7b", [0x78fc] = "\x89\x61",
  [0x7900] = "\x8e\x60", [0x7902] = "\xe9\x4e", [0x7903] = "\x89\xec",
  [0x7904] = "\xe9\x4f", [0x7908] = "\xe9\x50", [0x790d] = "\xe9\x52",
  [0x790e] = "\xe9\x53", [0x7910] = "\xe9\x55", [0x7911] = "\xe9\x51",
  [0x7914] = "\xe9\x54", [0x7918] = "\x8a\xd9", [0x791c] = "\xe9\x56",
  [0x791e] = "\xe9\x57", [0x792d] = "\xe9\x58", [0x792e] = "\xe9\x59",
  [0x7932] = "\xe9\x5a", [0x7935] = "\xe9\x5c", [0x7939] = "\xe9\x5b",
  [0x793b] = "\xe9\x5e", [0x793c] = "\xe9\x61", [0x7940] = "\xe9\x5d",
  [0x7941] = "\xe9\x5f", [0x7942] = "\xe9\x60", [0x7945] = "\xe9\x62",
  [0x7947] = "\x8b\xc0", [0x7986] = "\x8e\xf1", [0x7987] = "\xe9\x63",
  [0x7988] = "\xe9\x64", [0x7989] = "\x8d\x81", [0x7995] = "\xe9\x65",
  [0x7998] = "\x8a\x5d", [0x799c] = "\x94\x6e", [0x799d] = "\xe9\x66",
  [0x799e] = "\xe9\x67", [0x79a3] = "\x92\x79", [0x79a4] = "\x93\xe9",
  [0x79ac] = "\xe9\x68", [0x79b1] = "\x94\x9d", [0x79b4] = "\x91\xca",
  [0x79b5] = "\x89\x77", [0x79b6] = "\x8b\xec", [0x79b8] = "\x8b\xed",
  [0x79c0] = "\x92\x93", [0x79c1] = "\xe9\x6d", [0x79c2] = "\x8b\xee",
  [0x79c5] = "\x89\xed", [0x79c8] = "\xe9\x6c", [0x79cb] = "\xe9\x6a",
  [0x79cd] = "\xe9\x6b", [0x79cf] = "\xe9\x69", [0x79d2] = "\xe9\x77",
  [0x79dd] = "\xe9\x6e", [0x79de] = "\xe9\x6f", [0x79e1] = "\xe9\x70",
  [0x79e2] = "\xe9\x71", [0x79e8] = "\xe9\x73", [0x79eb] = "\xe9\x72",
  [0x79ef] = "\x8f\x78", [0x79f1] = "\xe9\x74", [0x79f5] = "\xe9\x76",
  [0x79fe] = "\x8b\x52", [0x79ff] = "\xe9\x75", [0x7a02] = "\x91\x9b",
  [0x7a03] = "\x8c\xb1", [0x7a09] = "\xe9\x78", [0x7a18] = "\x91\xcb",
  [0x7a1b] = "\xe9\x79", [0x7a20] = "\x93\xab", [0x7a27] = "\xe9\x7a",
  [0x7a2e] = "\xe9\x80", [0x7a30] = "\xe9\x7d", [0x7a32] = "\xe9\x7c",
  [0x7a33] = "\xe9\x7e", [0x7a35] = "\xe9\x7b", [0x7a3d] = "\xe9\x82",
  [0x7a45] = "\xe9\x81", [0x7a47] = "\xe9\x84", [0x7a4a] = "\x8b\xc1",
  [0x7a4b] = "\xe9\x83", [0x7a4f] = "\xe9\x85", [0x7a52] = "\xe9\x86",
  [0x7a54] = "\xe9\x88", [0x7a55] = "\xe9\x87", [0x7a59] = "\xe9\x89",
  [0x7a5a] = "\xe9\x8b", [0x7a5b] = "\xe9\x8a", [0x7a98] = "\x8d\x9c",
  [0x7a9d] = "\xe9\x8c", [0x7aa0] = "\xe9\x8d", [0x7aa8] = "\x8a\x5b",
  [0x7aac] = "\xe9\x8e", [0x7ab0] = "\xe9\x8f", [0x7ab4] = "\x90\x91",
  [0x7abf] = "\xe9\x90", [0x7ac1] = "\xe9\x91", [0x7ac3] = "\xe9\x92",
  [0x7ac4] = "\xe9\x93", [0x7ac8] = "\x8d\x82", [0x7ace] = "\xe9\x94",
  [0x7acf] = "\xe9\x95", [0x7ad2] = "\xe9\x96", [0x7ad3] = "\xe9\x97",
  [0x7ad6] = "\xe9\x98", [0x7ada] = "\x94\xaf", [0x7adb] = "\xe9\x9a",
  [0x7add] = "\x95\x45", [0x7ade] = "\xe9\x9b", [0x7adf] = "\xe9\x99",
  [0x7ae1] = "\xe9\x9d", [0x7ae4] = "\xe9\x9c", [0x7ae7] = "\xe9\x9e",
  [0x7aeb] = "\xe9\x9f", [0x7af6] = "\xe9\xa0", [0x7b08] = "\xe9\xa1",
  [0x7b0a] = "\xe9\xa2", [0x7b0f] = "\xe9\xa3", [0x7b12] = "\xe9\xa4",
  [0x7b13] = "\xe9\xa5", [0x7b15] = "\xe9\xa6", [0x7b17] = "\xe9\xa7",
  [0x7b18] = "\xe9\xa8", [0x7b19] = "\xe9\xa9", [0x7b1a] = "\xe9\xaa",
  [0x7b1e] = "\xe9\xab", [0x7b1f] = "\xe9\xac", [0x7b21] = "\x9f\x54",
  [0x7b22] = "\xe9\xad", [0x7b2b] = "\xe2\xf6", [0x7b2c] = "\x8b\x53",
  [0x7b31] = "\x8a\x40", [0x7b32] = "\x8d\xb0", [0x7b33] = "\xe9\xaf",
  [0x7b34] = "\xe9\xae", [0x7b35] = "\x96\xa3", [0x7b3d] = "\xe9\xb1",
  [0x7b3e] = "\xe9\xb2", [0x7b3f] = "\xe9\xb0", [0x7b41] = "\xe9\xb3",
  [0x7b44] = "\x96\x82", [0x7b48] = "\xe9\xb4", [0x7b4a] = "\x8b\x9b",
  [0x7b5f] = "\x98\x44", [0x7b64] = "\xe9\xb5", [0x7b73] = "\xe9\xb7",
  [0x7b7e] = "\x88\xbc", [0x7b81] = "\xe9\xb8", [0x7b82] = "\x95\xa9",
  [0x7b83] = "\xe9\xb6", [0x7b86] = "\xe9\xb9", [0x7b87] = "\xe9\xba",
  [0x7b8f] = "\xe9\xbb", [0x7b90] = "\xe9\xbc", [0x7b98] = "\xe9\xbd",
  [0x7b9a] = "\x96\x8e", [0x7b9b] = "\x8e\x4c", [0x7b9d] = "\x8d\xf8",
  [0x7b9e] = "\x91\x4e", [0x7ba4] = "\xe9\xbe", [0x7ba9] = "\xe9\xc1",
  [0x7bb0] = "\xe9\xbf", [0x7bb6] = "\xe9\xc2", [0x7bb9] = "\x8c\xef",
  [0x7bba] = "\xe9\xc0", [0x7bbf] = "\xe9\xc3", [0x7bc1] = "\xe9\xc4",
  [0x7bc2] = "\xe9\xc5", [0x7bc4] = "\xe9\xc9", [0x7bc6] = "\x8e\x49",
  [0x7bcb] = "\x91\xe2", [0x7bd1] = "\xe9\xca", [0x7bd2] = "\xe9\xc7",
  [0x7bd3] = "\xe9\xc6", [0x7bd4] = "\xe9\xc8", [0x7bd8] = "\x8c\x7e",
  [0x7be0] = "\xe9\xce", [0x7be1] = "\xe9\xcd", [0x7be2] = "\xe9\xcc",
  [0x7be5] = "\x88\xb1", [0x7bf4] = "\xe9\xd8", [0x7bf6] = "\xe9\xd4",
  [0x7bf8] = "\xe9\xd5", [0x7bf9] = "\xe9\xd1", [0x7bfa] = "\xe9\xd7",
  [0x7bfc] = "\xe9\xd3", [0x7bfd] = "\x8a\x82", [0x7c00] = "\x98\x6b",
  [0x7c02] = "\xe9\xd6", [0x7c03] = "\xe9\xd2", [0x7c04] = "\xe9\xd0",
  [0x7c05] = "\xe9\xcf", [0x7c0b] = "\xe9\xda", [0x7c11] = "\xe9\xdd",
  [0x7c14] = "\xe9\xdc", [0x7c15] = "\xe9\xdb", [0x7c1d] = "\x95\x68",
  [0x7c1e] = "\xe9\xd9", [0x7c1f] = "\x88\xf1", [0x7c20] = "\xe9\xde",
  [0x7c22] = "\xe9\xe0", [0x7c29] = "\x8a\x8f", [0x7c2a] = "\xe9\xcb",
  [0x7c2b] = "\x89\x56", [0x7c2e] = "\xe9\xe2", [0x7c36] = "\xe9\xe1",
  [0x7c37] = "\xe9\xdf", [0x7c38] = "\x92\x4c", [0x7c42] = "\x96\x90",
  [0x7c47] = "\x97\xd8", [0x7c4a] = "\xe9\xe3", [0x7c50] = "\xe9\xe4",
  [0x7c57] = "\xe9\xe5", [0x7c66] = "\xe9\xe6", [0x7c68] = "\xe9\xe7",
  [0x7cd5] = "\x92\xb9", [0x7cd7] = "\xe9\xe8", [0x7cd9] = "\x94\xb5",
  [0x7cdb] = "\xe9\xed", [0x7cdc] = "\xe9\xe9", [0x7ce0] = "\xe9\xea",
  [0x7ce3] = "\x96\x50", [0x7ce4] = "\x96\xc2", [0x7ce6] = "\x93\xce",
  [0x7cf3] = "\xe9\xee", [0x7cf6] = "\xe9\xef", [0x7cf7] = "\x93\xbc",
  [0x7cf8] = "\xe9\xec", [0x7cf9] = "\xe9\xeb", [0x7cfe] = "\x89\xa8",
  [0x7d02] = "\xe9\xf7", [0x7d05] = "\xe9\xf6", [0x7d0b] = "\x89\x95",
  [0x7d0f] = "\xe9\xf4", [0x7d13] = "\xe9\xf3", [0x7d16] = "\xe9\xf1",
  [0x7d18] = "\x8a\x9b", [0x7d1a] = "\xe9\xf0", [0x7d1b] = "\x8e\xb0",
  [0x7d1c] = "\x89\xa7", [0x7d2b] = "\x8d\x83", [0x7d2e] = "\xe9\xfa",
  [0x7d2f] = "\xe9\xf9", [0x7d31] = "\xe9\xf8", [0x7d34] = "\xe9\xf5",
  [0x7d36] = "\xe9\xfb", [0x7d38] = "\xe9\xfc", [0x7d40] = "\xea\x44",
  [0x7d41] = "\xea\x43", [0x7d49] = "\xea\x45", [0x7d4c] = "\x89\x4c",
  [0x7d4d] = "\xea\x40", [0x7d4e] = "\xea\x41", [0x7d50] = "\x8d\x94",
  [0x7d51] = "\x96\xb7", [0x7d54] = "\xea\x42", [0x7d5c] = "\x96\x51",
  [0x7d5f] = "\xea\x4a", [0x7d62] = "\xea\x46", [0x7d6a] = "\xea\x4b",
  [0x7d77] = "\xea\x48", [0x7d79] = "\xea\x47", [0x7d7f] = "\x8c\x7b",
  [0x7d8a] = "\xea\x4c", [0x7d94] = "\xea\x4d", [0x7d99] = "\xea\x4e",
  [0x7d9b] = "\xea\x49", [0x7d9f] = "\xe9\xf2", [0x7da2] = "\xea\x4f",
  [0x7da4] = "\x92\xdf", [0x7da8] = "\xea\x53", [0x7daa] = "\xea\x54",
  [0x7dab] = "\xea\x52", [0x7db1] = "\xea\x51", [0x7db2] = "\xea\x57",
  [0x7db4] = "\xea\x50", [0x7db6] = "\xea\x55", [0x7dbf] = "\xea\x56",
  [0x7dc3] = "\xea\x59", [0x7dc9] = "\xea\x58", [0x7dd6] = "\xea\x5b",
  [0x7ddd] = "\xea\x5c", [0x7ddf] = "\xea\x5d", [0x7de2] = "\x98\x68",
  [0x7de8] = "\xea\x5a", [0x7de9] = "\x91\xe9", [0x7dea] = "\x8d\xeb",
  [0x7ded] = "\xea\x5e", [0x7e0a] = "\xea\x5f", [0x7e0b] = "\xea\x60",
  [0x7e0e] = "\xea\x61", [0x7e65] = "\xea\x62", [0x7e68] = "\x8c\xb2",
  [0x7e69] = "\xea\x63", [0x7e6d] = "\xea\x64", [0x7e6f] = "\x8e\xad",
  [0x7e71] = "\xea\x65", [0x7e78] = "\xea\x66", [0x7e7b] = "\xea\x67",
  [0x7e7c] = "\xea\x68", [0x7e81] = "\xea\x6b", [0x7e82] = "\xea\x69",
  [0x7e83] = "\x98\x5b", [0x7e85] = "\xea\x6a", [0x7e87] = "\x97\xed",
  [0x7e8d] = "\xea\x6c", [0x7e8f] = "\x97\xd9", [0x7e95] = "\xea\x6d",
  [0x7e96] = "\x94\x9e", [0x7e99] = "\xea\x6e", [0x7e9a] = "\xea\x70",
  [0x7e9d] = "\xea\x71", [0x7ea8] = "\xea\x6f", [0x7ea9] = "\x8d\x8d",
  [0x7eaa] = "\x96\xcb", [0x7eab] = "\x96\x83", [0x7eac] = "\x9b\xf5",
  [0x7eae] = "\x9f\x80", [0x7eaf] = "\x96\x9b", [0x7eb4] = "\x89\xa9",
  [0x7ebc] = "\xea\x73", [0x7ebd] = "\x8b\x6f", [0x7ebe] = "\xea\x74",
  [0x7ebf] = "\xea\x75", [0x7ec0] = "\xea\x76", [0x7ec2] = "\x8d\x95",
  [0x7ec4] = "\xea\x77", [0x7ec8] = "\xe0\xd2", [0x7ec9] = "\x96\xd9",
  [0x7ecb] = "\x91\xe1", [0x7ecc] = "\xea\x78", [0x7ecd] = "\xea\x7a",
  [0x7ece] = "\xea\x79", [0x7ed0] = "\xea\x7b", [0x7ed5] = "\xea\x7c",
  [0x7ed8] = "\xea\x7d", [0x7edf] = "\xea\x7e", [0x7ee4] = "\xea\x80",
  [0x7ee6] = "\xea\x81", [0x7ee7] = "\xea\x82", [0x7ee9] = "\xea\x83",
  [0x7eeb] = "\xea\x84", [0x7eec] = "\xea\x85", [0x7eed] = "\xea\x86",
  [0x7ef7] = "\xea\x87", [0x7ef8] = "\xea\x88", [0x7efe] = "\x93\x43",
  [0x7f03] = "\x8c\xdb", [0x7f05] = "\xea\x8a", [0x7f10] = "\x91\x6c",
  [0x7f11] = "\xea\x8b", [0x7f1c] = "\xea\x8c", [0x7f2b] = "\x95\x40",
  [0x7f2e] = "\xea\x8d", [0x7f3a] = "\xea\x8e", [0x7f3b] = "\xe2\x56",
  [0x7f3e] = "\xe6\xd8", [0x7f3f] = "\xe8\xeb", [0x7f42] = "\xea\x8f",
  [0x7f44] = "\xea\x90", [0x7f4f] = "\xea\x92", [0x7f50] = "\xea\x93",
  [0x7f51] = "\xea\x94", [0x7f52] = "\x97\xee", [0x7f53] = "\xea\x91",
  [0x7f56] = "\xea\x95", [0x7f57] = "\xea\x96", [0x7f5a] = "\xea\x98",
  [0x7f5c] = "\xea\x97", [0x7f62] = "\xea\x9a", [0x7f66] = "\xea\x9b",
  [0x7f67] = "\xea\x99", [0x7f7d] = "\x97\xb4", [0x7f85] = "\xea\x9c",
  [0x7f8c] = "\xea\x9d", [0x7f8d] = "\xe2\x73", [0x7f90] = "\xea\x9e"
};

static const char from_ucs4_extra[0x100][2] =
{
  [0x0001] = "\x81\x49", [0x0003] = "\x81\x94", [0x0004] = "\x81\x90",
  [0x0005] = "\x81\x93", [0x0006] = "\x81\x95", [0x0008] = "\x81\x69",
  [0x0009] = "\x81\x6a", [0x000a] = "\x81\x96", [0x000b] = "\x81\x7b",
  [0x000c] = "\x81\x43", [0x000e] = "\x81\x44", [0x000f] = "\x81\x5e",
  [0x0010] = "\x82\x4f", [0x0011] = "\x82\x50", [0x0012] = "\x82\x51",
  [0x0013] = "\x82\x52", [0x0014] = "\x82\x53", [0x0015] = "\x82\x54",
  [0x0016] = "\x82\x55", [0x0017] = "\x82\x56", [0x0018] = "\x82\x57",
  [0x0019] = "\x82\x58", [0x001a] = "\x81\x46", [0x001b] = "\x81\x47",
  [0x001c] = "\x81\x83", [0x001d] = "\x81\x81", [0x001e] = "\x81\x84",
  [0x001f] = "\x81\x48", [0x0020] = "\x81\x97", [0x0021] = "\x82\x60",
  [0x0022] = "\x82\x61", [0x0023] = "\x82\x62", [0x0024] = "\x82\x63",
  [0x0025] = "\x82\x64", [0x0026] = "\x82\x65", [0x0027] = "\x82\x66",
  [0x0028] = "\x82\x67", [0x0029] = "\x82\x68", [0x002a] = "\x82\x69",
  [0x002b] = "\x82\x6a", [0x002c] = "\x82\x6b", [0x002d] = "\x82\x6c",
  [0x002e] = "\x82\x6d", [0x002f] = "\x82\x6e", [0x0030] = "\x82\x6f",
  [0x0031] = "\x82\x70", [0x0032] = "\x82\x71", [0x0033] = "\x82\x72",
  [0x0034] = "\x82\x73", [0x0035] = "\x82\x74", [0x0036] = "\x82\x75",
  [0x0037] = "\x82\x76", [0x0038] = "\x82\x77", [0x0039] = "\x82\x78",
  [0x003a] = "\x82\x79", [0x003b] = "\x81\x6d", [0x003c] = "\x81\x5f",
  [0x003d] = "\x81\x6e", [0x003e] = "\x81\x4f", [0x003f] = "\x81\x51",
  [0x0040] = "\x81\x4d", [0x0041] = "\x82\x81", [0x0042] = "\x82\x82",
  [0x0043] = "\x82\x83", [0x0044] = "\x82\x84", [0x0045] = "\x82\x85",
  [0x0046] = "\x82\x86", [0x0047] = "\x82\x87", [0x0048] = "\x82\x88",
  [0x0049] = "\x82\x89", [0x004a] = "\x82\x8a", [0x004b] = "\x82\x8b",
  [0x004c] = "\x82\x8c", [0x004d] = "\x82\x8d", [0x004e] = "\x82\x8e",
  [0x004f] = "\x82\x8f", [0x0050] = "\x82\x90", [0x0051] = "\x82\x91",
  [0x0052] = "\x82\x92", [0x0053] = "\x82\x93", [0x0054] = "\x82\x94",
  [0x0055] = "\x82\x95", [0x0056] = "\x82\x96", [0x0057] = "\x82\x97",
  [0x0058] = "\x82\x98", [0x0059] = "\x82\x99", [0x005a] = "\x82\x9a",
  [0x005b] = "\x81\x6f", [0x005c] = "\x81\x62", [0x005d] = "\x81\x70",
  [0x005e] = "\x00\x00", [0x005f] = "\x00\x00",
  [0x0060] = "\x00\x00", [0x0061] = "\xa1\x00", [0x0062] = "\xa2\x00",
  [0x0063] = "\xa3\x00", [0x0064] = "\xa4\x00", [0x0065] = "\xa5\x00",
  [0x0066] = "\xa6\x00", [0x0067] = "\xa7\x00", [0x0068] = "\xa8\x00",
  [0x0069] = "\xa9\x00", [0x006a] = "\xaa\x00", [0x006b] = "\xab\x00",
  [0x006c] = "\xac\x00", [0x006d] = "\xad\x00", [0x006e] = "\xae\x00",
  [0x006f] = "\xaf\x00", [0x0070] = "\xb0\x00", [0x0071] = "\xb1\x00",
  [0x0072] = "\xb2\x00", [0x0073] = "\xb3\x00", [0x0074] = "\xb4\x00",
  [0x0075] = "\xb5\x00", [0x0076] = "\xb6\x00", [0x0077] = "\xb7\x00",
  [0x0078] = "\xb8\x00", [0x0079] = "\xb9\x00", [0x007a] = "\xba\x00",
  [0x007b] = "\xbb\x00", [0x007c] = "\xbc\x00", [0x007d] = "\xbd\x00",
  [0x007e] = "\xbe\x00", [0x007f] = "\xbf\x00", [0x0080] = "\xc0\x00",
  [0x0081] = "\xc1\x00", [0x0082] = "\xc2\x00", [0x0083] = "\xc3\x00",
  [0x0084] = "\xc4\x00", [0x0085] = "\xc5\x00", [0x0086] = "\xc6\x00",
  [0x0087] = "\xc7\x00", [0x0088] = "\xc8\x00", [0x0089] = "\xc9\x00",
  [0x008a] = "\xca\x00", [0x008b] = "\xcb\x00", [0x008c] = "\xcc\x00",
  [0x008d] = "\xcd\x00", [0x008e] = "\xce\x00", [0x008f] = "\xcf\x00",
  [0x0090] = "\xd0\x00", [0x0091] = "\xd1\x00", [0x0092] = "\xd2\x00",
  [0x0093] = "\xd3\x00", [0x0094] = "\xd4\x00", [0x0095] = "\xd5\x00",
  [0x0096] = "\xd6\x00", [0x0097] = "\xd7\x00", [0x0098] = "\xd8\x00",
  [0x0099] = "\xd9\x00", [0x009a] = "\xda\x00", [0x009b] = "\xdb\x00",
  [0x009c] = "\xdc\x00", [0x009d] = "\xdd\x00", [0x009e] = "\xde\x00",
  [0x009f] = "\xdf\x00",
  [0x00e0] = "\x81\x91", [0x00e1] = "\x81\x92", [0x00e2] = "\x81\xCA",
  [0x00e3] = "\x81\x50", [0x00e5] = "\x81\x8f"
};

/* Definitions used in the body of the `gconv' function.  */
#define CHARSET_NAME		"SJIS//"
#define FROM_LOOP		from_sjis
#define TO_LOOP			to_sjis
#define DEFINE_INIT		1
#define DEFINE_FINI		1
#define MIN_NEEDED_FROM		1
#define MAX_NEEDED_FROM		2
#define MIN_NEEDED_TO		4
#define ONE_DIRECTION		0

/* First define the conversion function from SJIS to UCS4.  */
#define MIN_NEEDED_INPUT	MIN_NEEDED_FROM
#define MAX_NEEDED_INPUT	MAX_NEEDED_FROM
#define MIN_NEEDED_OUTPUT	MIN_NEEDED_TO
#define LOOPFCT			FROM_LOOP
#define BODY \
  {									      \
    uint32_t ch = *inptr;						      \
									      \
    if (__builtin_expect (ch, 0) == 0x5c)				      \
      {									      \
	ch = 0xa5;							      \
	++inptr;							      \
      }									      \
    else if (__builtin_expect (ch, 0) == 0x7e)				      \
      {									      \
	ch = 0x203e;							      \
	++inptr;							      \
      }									      \
    else if (ch < 0x80)							      \
      ++inptr;								      \
    else if (ch >= 0xa1 && ch <= 0xdf)					      \
      {									      \
	ch += 0xfec0;							      \
	++inptr;							      \
      }									      \
    else if (__builtin_expect (ch > 0xea, 0)				      \
	     || __builtin_expect (ch, 0) == 0xa0			      \
	     || __builtin_expect (ch <= 0x80, 0))			      \
      {									      \
	/* These are illegal.  */					      \
	STANDARD_FROM_LOOP_ERR_HANDLER (1);				      \
      }									      \
    else								      \
      {									      \
	/* Two-byte character.  First test whether the next byte	      \
	   is also available.  */					      \
	uint32_t ch2;							      \
	uint_fast32_t idx;						      \
									      \
	if (__glibc_unlikely (inptr + 1 >= inend))			      \
	  {								      \
	    /* The second byte is not available.  Store			      \
	       the intermediate result.  */				      \
	    result = __GCONV_INCOMPLETE_INPUT;				      \
	    break;							      \
	  }								      \
									      \
	ch2 = inptr[1];							      \
	idx = ch * 256 + ch2;						      \
	if (__glibc_unlikely (ch2 < 0x40))				      \
	  {								      \
	    /* This is illegal.  */					      \
	    STANDARD_FROM_LOOP_ERR_HANDLER (1);				      \
	  }								      \
	else if ((__builtin_expect (idx > 0x84be && idx < 0x889f, 0))	      \
		 || (__builtin_expect (idx > 0x88fc && idx < 0x8940, 0))      \
		 || (__builtin_expect (idx > 0x9ffc && idx < 0xe040, 0))      \
		 || __builtin_expect (idx > 0xeaa4, 0))			      \
	  {								      \
	    /* This is illegal.  */					      \
	    STANDARD_FROM_LOOP_ERR_HANDLER (2);				      \
	  }								      \
	else								      \
	  {								      \
	    /* We could pack the data a bit more dense.  The second	      \
	       byte will never be 0x7f and it will also be never	      \
	       >0xfc.  But this would mean yet more `if's.  */		      \
	    if (idx <= 0x84be)						      \
	      ch = cjk_block1[(ch - 0x81) * 192 + ch2 - 0x40];		      \
	    else if (idx <= 0x88fc)					      \
	      ch = cjk_block2[(ch - 0x88) * 192 + ch2 - 0x9f];		      \
	    else if (idx <= 0x9ffc)					      \
	      ch = cjk_block3[(ch - 0x89) * 192 + ch2 - 0x40];		      \
	    else							      \
	      ch = cjk_block4[(ch - 0xe0) * 192 + ch2 - 0x40];		      \
									      \
	    if (__glibc_unlikely (ch == 0))				      \
	      {								      \
		/* This is an illegal character.  */			      \
		STANDARD_FROM_LOOP_ERR_HANDLER (2);			      \
	      }								      \
									      \
	    inptr += 2;							      \
	  }								      \
      }									      \
									      \
    put32 (outptr, ch);							      \
    outptr += 4;							      \
  }
#define LOOP_NEED_FLAGS
#define ONEBYTE_BODY \
  {									      \
    if (c < 0x80)							      \
      {									      \
	if (c == 0x5c)							      \
	  return 0xa5;							      \
	if (c == 0x7e)							      \
	  return 0x203e;						      \
	return c;							      \
      }									      \
    if (c >= 0xa1 && c <= 0xdf)						      \
      return 0xfec0 + c;						      \
    return WEOF;							      \
  }
#include <iconv/loop.c>


/* Next, define the other direction.  */
#define MIN_NEEDED_INPUT	MIN_NEEDED_TO
#define MIN_NEEDED_OUTPUT	MIN_NEEDED_FROM
#define MAX_NEEDED_OUTPUT	MAX_NEEDED_FROM
#define LOOPFCT			TO_LOOP
#define BODY \
  {									      \
    uint32_t ch = get32 (inptr);					      \
    const char *cp;							      \
									      \
    if (ch >= (sizeof (from_ucs4_lat1) / sizeof (from_ucs4_lat1[0])))	      \
      {									      \
	if (ch >= 0x0391 && ch <= 0x0451)				      \
	  cp = from_ucs4_greek[ch - 0x391];				      \
	else if (ch >= 0x2010 && ch <= 0x9fa0)				      \
	  cp = from_ucs4_cjk[ch - 0x02010];				      \
	else if (__builtin_expect (ch >= 0xff01, 1)			      \
		 && __builtin_expect (ch <= 0xffef, 1))			      \
	  cp = from_ucs4_extra[ch - 0xff00];				      \
	else								      \
	  {								      \
	    UNICODE_TAG_HANDLER (ch, 4);				      \
	    /* Illegal character.  */					      \
	    cp = "";							      \
	  }								      \
      }									      \
    else								      \
      cp = from_ucs4_lat1[ch];						      \
									      \
    if (__builtin_expect (cp[0] == '\0', 0) && ch != 0)			      \
      {									      \
	/* Illegal character.  */					      \
	STANDARD_TO_LOOP_ERR_HANDLER (4);				      \
      }									      \
    else								      \
      {									      \
	*outptr = cp[0];						      \
	/* Now test for a possible second byte and write this if possible.  */\
	if (cp[1] != '\0')						      \
	  {								      \
	    if (__glibc_unlikely (outptr + 1 >= outend))		      \
	      {								      \
		/* The result does not fit into the buffer.  */		      \
		result = __GCONV_FULL_OUTPUT;				      \
		break;							      \
	      }								      \
	    *++outptr = cp[1];						      \
	  }								      \
	++outptr;							      \
      }									      \
									      \
    inptr += 4;								      \
  }
#define LOOP_NEED_FLAGS
#include <iconv/loop.c>


/* Now define the toplevel functions.  */
#include <iconv/skeleton.c>
