/* Table of MP integer constants 10^(2^i), used for floating point <-> decimal.
   Copyright (C) 1995-2015 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include "fpioconst.h"
#include <gmp-mparam.h>		/* This defines BITS_PER_MP_LIMB.  */

/* First page	: 32-bit limbs
   Second page	: 64-bit limbs
   Last page	: table of pointers

   The tables (apart from internal #if conditions) may be generated
   with gen-fpioconst.c.
 */

#if BITS_PER_MP_LIMB == 32

/* Table with constants of 10^(2^i), i=0..12 for 32-bit limbs.	*/

const mp_limb_t __tens[] =
{
#define TENS_P0_IDX	0
#define TENS_P0_SIZE	3
  [TENS_P0_IDX] = 0x00000000, 0x00000000, 0x0000000a,

#define TENS_P1_IDX	(TENS_P0_IDX + TENS_P0_SIZE)
#define TENS_P1_SIZE	3
  [TENS_P1_IDX] = 0x00000000, 0x00000000, 0x00000064,

#define TENS_P2_IDX	(TENS_P1_IDX + TENS_P1_SIZE)
#define TENS_P2_SIZE	3
  [TENS_P2_IDX] = 0x00000000, 0x00000000, 0x00002710,

#define TENS_P3_IDX	(TENS_P2_IDX + TENS_P2_SIZE)
#define TENS_P3_SIZE	3
  [TENS_P3_IDX] = 0x00000000, 0x00000000, 0x05f5e100,

#define TENS_P4_IDX	(TENS_P3_IDX + TENS_P3_SIZE)
#define TENS_P4_SIZE	4
  [TENS_P4_IDX] = 0x00000000, 0x00000000, 0x6fc10000, 0x002386f2,

#define TENS_P5_IDX	(TENS_P4_IDX + TENS_P4_SIZE)
#define TENS_P5_SIZE	6
  [TENS_P5_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x85acef81, 0x2d6d415b,
  0x000004ee,

#define TENS_P6_IDX	(TENS_P5_IDX + TENS_P5_SIZE)
#define TENS_P6_SIZE	9
  [TENS_P6_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xbf6a1f01,
  0x6e38ed64, 0xdaa797ed, 0xe93ff9f4, 0x00184f03,

#define TENS_P7_IDX	(TENS_P6_IDX + TENS_P6_SIZE)
#define TENS_P7_SIZE	16
  [TENS_P7_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x2e953e01, 0x03df9909, 0x0f1538fd, 0x2374e42f, 0xd3cff5ec,
  0xc404dc08, 0xbccdb0da, 0xa6337f19, 0xe91f2603, 0x0000024e,

#define TENS_P8_IDX	(TENS_P7_IDX + TENS_P7_SIZE)
#define TENS_P8_SIZE	29
  [TENS_P8_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x982e7c01,
  0xbed3875b, 0xd8d99f72, 0x12152f87, 0x6bde50c6, 0xcf4a6e70, 0xd595d80f,
  0x26b2716e, 0xadc666b0, 0x1d153624, 0x3c42d35a, 0x63ff540e, 0xcc5573c0,
  0x65f9ef17, 0x55bc28f2, 0x80dcc7f7, 0xf46eeddc, 0x5fdcefce, 0x000553f7,

#define TENS_P9_IDX	(TENS_P8_IDX + TENS_P8_SIZE)
#define TENS_P9_SIZE	56
  [TENS_P9_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0xfc6cf801, 0x77f27267, 0x8f9546dc, 0x5d96976f, 0xb83a8a97,
  0xc31e1ad9, 0x46c40513, 0x94e65747, 0xc88976c1, 0x4475b579, 0x28f8733b,
  0xaa1da1bf, 0x703ed321, 0x1e25cfea, 0xb21a2f22, 0xbc51fb2e, 0x96e14f5d,
  0xbfa3edac, 0x329c57ae, 0xe7fc7153, 0xc3fc0695, 0x85a91924, 0xf95f635e,
  0xb2908ee0, 0x93abade4, 0x1366732a, 0x9449775c, 0x69be5b0e, 0x7343afac,
  0xb099bc81, 0x45a71d46, 0xa2699748, 0x8cb07303, 0x8a0b1f13, 0x8cab8a97,
  0xc1d238d9, 0x633415d4, 0x0000001c,

#define TENS_P10_IDX	(TENS_P9_IDX + TENS_P9_SIZE)
#define TENS_P10_SIZE	109
  [TENS_P10_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2919f001,
  0xf55b2b72, 0x6e7c215b, 0x1ec29f86, 0x991c4e87, 0x15c51a88, 0x140ac535,
  0x4c7d1e1a, 0xcc2cd819, 0x0ed1440e, 0x896634ee, 0x7de16cfb, 0x1e43f61f,
  0x9fce837d, 0x231d2b9c, 0x233e55c7, 0x65dc60d7, 0xf451218b, 0x1c5cd134,
  0xc9635986, 0x922bbb9f, 0xa7e89431, 0x9f9f2a07, 0x62be695a, 0x8e1042c4,
  0x045b7a74, 0x1abe1de3, 0x8ad822a5, 0xba34c411, 0xd814b505, 0xbf3fdeb3,
  0x8fc51a16, 0xb1b896bc, 0xf56deeec, 0x31fb6bfd, 0xb6f4654b, 0x101a3616,
  0x6b7595fb, 0xdc1a47fe, 0x80d98089, 0x80bda5a5, 0x9a202882, 0x31eb0f66,
  0xfc8f1f90, 0x976a3310, 0xe26a7b7e, 0xdf68368a, 0x3ce3a0b8, 0x8e4262ce,
  0x75a351a2, 0x6cb0b6c9, 0x44597583, 0x31b5653f, 0xc356e38a, 0x35faaba6,
  0x0190fba0, 0x9fc4ed52, 0x88bc491b, 0x1640114a, 0x005b8041, 0xf4f3235e,
  0x1e8d4649, 0x36a8de06, 0x73c55349, 0xa7e6bd2a, 0xc1a6970c, 0x47187094,
  0xd2db49ef, 0x926c3f5b, 0xae6209d4, 0x2d433949, 0x34f4a3c6, 0xd4305d94,
  0xd9d61a05, 0x00000325,

#if !defined __NO_LONG_DOUBLE_MATH && __LDBL_MAX_EXP__ > 1024
# define TENS_P11_IDX	(TENS_P10_IDX + TENS_P10_SIZE)
# define TENS_P11_SIZE	215
  [TENS_P11_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x1333e001, 0xe3096865, 0xb27d4d3f, 0x49e28dcf, 0xec2e4721,
  0xee87e354, 0xb6067584, 0x368b8abb, 0xa5e5a191, 0x2ed56d55, 0xfd827773,
  0xea50d142, 0x51b78db2, 0x98342c9e, 0xc850dabc, 0x866ed6f1, 0x19342c12,
  0x92794987, 0xd2f869c2, 0x66912e4a, 0x71c7fd8f, 0x57a7842d, 0x235552eb,
  0xfb7fedcc, 0xf3861ce0, 0x38209ce1, 0x9713b449, 0x34c10134, 0x8c6c54de,
  0xa7a8289c, 0x2dbb6643, 0xe3cb64f3, 0x8074ff01, 0xe3892ee9, 0x10c17f94,
  0xa8f16f92, 0xa8281ed6, 0x967abbb3, 0x5a151440, 0x9952fbed, 0x13b41e44,
  0xafe609c3, 0xa2bca416, 0xf111821f, 0xfb1264b4, 0x91bac974, 0xd6c7d6ab,
  0x8e48ff35, 0x4419bd43, 0xc4a65665, 0x685e5510, 0x33554c36, 0xab498697,
  0x0dbd21fe, 0x3cfe491d, 0x982da466, 0xcbea4ca7, 0x9e110c7b, 0x79c56b8a,
  0x5fc5a047, 0x84d80e2e, 0x1aa9f444, 0x730f203c, 0x6a57b1ab, 0xd752f7a6,
  0x87a7dc62, 0x944545ff, 0x40660460, 0x77c1a42f, 0xc9ac375d, 0xe866d7ef,
  0x744695f0, 0x81428c85, 0xa1fc6b96, 0xd7917c7b, 0x7bf03c19, 0x5b33eb41,
  0x5715f791, 0x8f6cae5f, 0xdb0708fd, 0xb125ac8e, 0x785ce6b7, 0x56c6815b,
  0x6f46eadb, 0x4eeebeee, 0x195355d8, 0xa244de3c, 0x9d7389c0, 0x53761abd,
  0xcf99d019, 0xde9ec24b, 0x0d76ce39, 0x70beb181, 0x2e55ecee, 0xd5f86079,
  0xf56d9d4b, 0xfb8886fb, 0x13ef5a83, 0x408f43c5, 0x3f3389a4, 0xfad37943,
  0x58ccf45c, 0xf82df846, 0x415c7f3e, 0x2915e818, 0x8b3d5cf4, 0x6a445f27,
  0xf8dbb57a, 0xca8f0070, 0x8ad803ec, 0xb2e87c34, 0x038f9245, 0xbedd8a6c,
  0xc7c9dee0, 0x0eac7d56, 0x2ad3fa14, 0xe0de0840, 0xf775677c, 0xf1bd0ad5,
  0x92be221e, 0x87fa1fb9, 0xce9d04a4, 0xd2c36fa9, 0x3f6f7024, 0xb028af62,
  0x907855ee, 0xd83e49d6, 0x4efac5dc, 0xe7151aab, 0x77cd8c6b, 0x0a753b7d,
  0x0af908b4, 0x8c983623, 0xe50f3027, 0x94222771, 0x1d08e2d6, 0xf7e928e6,
  0xf2ee5ca6, 0x1b61b93c, 0x11eb962b, 0x9648b21c, 0xce2bcba1, 0x34f77154,
  0x7bbebe30, 0xe526a319, 0x8ce329ac, 0xde4a74d2, 0xb5dc53d5, 0x0009e8b3,

# define TENS_P12_IDX	(TENS_P11_IDX + TENS_P11_SIZE)
# define TENS_P12_SIZE	428
  [TENS_P12_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2a67c001,
  0xd4724e8d, 0x8efe7ae7, 0xf89a1e90, 0xef084117, 0x54e05154, 0x13b1bb51,
  0x506be829, 0xfb29b172, 0xe599574e, 0xf0da6146, 0x806c0ed3, 0xb86ae5be,
  0x45155e93, 0xc0591cc2, 0x7e1e7c34, 0x7c4823da, 0x1d1f4cce, 0x9b8ba1e8,
  0xd6bfdf75, 0xe341be10, 0xc2dfae78, 0x016b67b2, 0x0f237f1a, 0x3dbeabcd,
  0xaf6a2574, 0xcab3e6d7, 0x142e0e80, 0x61959127, 0x2c234811, 0x87009701,
  0xcb4bf982, 0xf8169c84, 0x88052f8c, 0x68dde6d4, 0xbc131761, 0xff0b0905,
  0x54ab9c41, 0x7613b224, 0x1a1c304e, 0x3bfe167b, 0x441c2d47, 0x4f6cea9c,
  0x78f06181, 0xeb659fb8, 0x30c7ae41, 0x947e0d0e, 0xa1ebcad7, 0xd97d9556,
  0x2130504d, 0x1a8309cb, 0xf2acd507, 0x3f8ec72a, 0xfd82373a, 0x95a842bc,
  0x280f4d32, 0xf3618ac0, 0x811a4f04, 0x6dc3a5b4, 0xd3967a1b, 0x15b8c898,
  0xdcfe388f, 0x454eb2a0, 0x8738b909, 0x10c4e996, 0x2bd9cc11, 0x3297cd0c,
  0x655fec30, 0xae0725b1, 0xf4090ee8, 0x037d19ee, 0x398c6fed, 0x3b9af26b,
  0xc994a450, 0xb5341743, 0x75a697b2, 0xac50b9c1, 0x3ccb5b92, 0xffe06205,
  0xa8329761, 0xdfea5242, 0xeb83cadb, 0xe79dadf7, 0x3c20ee69, 0x1e0a6817,
  0x7021b97a, 0x743074fa, 0x176ca776, 0x77fb8af6, 0xeca19beb, 0x92baf1de,
  0xaf63b712, 0xde35c88b, 0xa4eb8f8c, 0xe137d5e9, 0x40b464a0, 0x87d1cde8,
  0x42923bbd, 0xcd8f62ff, 0x2e2690f3, 0x095edc16, 0x59c89f1b, 0x1fa8fd5d,
  0x5138753d, 0x390a2b29, 0x80152f18, 0x2dd8d925, 0xf984d83e, 0x7a872e74,
  0xc19e1faf, 0xed4d542d, 0xecf9b5d0, 0x9462ea75, 0xc53c0adf, 0x0caea134,
  0x37a2d439, 0xc8fa2e8a, 0x2181327e, 0x6e7bb827, 0x2d240820, 0x50be10e0,
  0x5893d4b8, 0xab312bb9, 0x1f2b2322, 0x440b3f25, 0xbf627ede, 0x72dac789,
  0xb608b895, 0x78787e2a, 0x86deb3f0, 0x6fee7aab, 0xbb9373f4, 0x27ecf57b,
  0xf7d8b57e, 0xfca26a9f, 0x3d04e8d2, 0xc9df13cb, 0x3172826a, 0xcd9e8d7c,
  0xa8fcd8e0, 0xb2c39497, 0x307641d9, 0x1cc939c1, 0x2608c4cf, 0xb6d1c7bf,
  0x3d326a7e, 0xeeaf19e6, 0x8e13e25f, 0xee63302b, 0x2dfe6d97, 0x25971d58,
  0xe41d3cc4, 0x0a80627c, 0xab8db59a, 0x9eea37c8, 0xe90afb77, 0x90ca19cf,
  0x9ee3352c, 0x3613c850, 0xfe78d682, 0x788f6e50, 0x5b060904, 0xb71bd1a4,
  0x3fecb534, 0xb32c450c, 0x20c33857, 0xa6e9cfda, 0x0239f4ce, 0x48497187,
  0xa19adb95, 0xb492ed8a, 0x95aca6a8, 0x4dcd6cd9, 0xcf1b2350, 0xfbe8b12a,
  0x1a67778c, 0x38eb3acc, 0xc32da383, 0xfb126ab1, 0xa03f40a8, 0xed5bf546,
  0xe9ce4724, 0x4c4a74fd, 0x73a130d8, 0xd9960e2d, 0xa2ebd6c1, 0x94ab6feb,
  0x6f233b7c, 0x49126080, 0x8e7b9a73, 0x4b8c9091, 0xd298f999, 0x35e836b5,
  0xa96ddeff, 0x96119b31, 0x6b0dd9bc, 0xc6cc3f8d, 0x282566fb, 0x72b882e7,
  0xd6769f3b, 0xa674343d, 0x00fc509b, 0xdcbf7789, 0xd6266a3f, 0xae9641fd,
  0x4e89541b, 0x11953407, 0x53400d03, 0x8e0dd75a, 0xe5b53345, 0x108f19ad,
  0x108b89bc, 0x41a4c954, 0xe03b2b63, 0x437b3d7f, 0x97aced8e, 0xcbd66670,
  0x2c5508c2, 0x650ebc69, 0x5c4f2ef0, 0x904ff6bf, 0x9985a2df, 0x9faddd9e,
  0x5ed8d239, 0x25585832, 0xe3e51cb9, 0x0ff4f1d4, 0x56c02d9a, 0x8c4ef804,
  0xc1a08a13, 0x13fd01c8, 0xe6d27671, 0xa7c234f4, 0x9d0176cc, 0xd0d73df2,
  0x4d8bfa89, 0x544f10cd, 0x2b17e0b2, 0xb70a5c7d, 0xfd86fe49, 0xdf373f41,
  0x214495bb, 0x84e857fd, 0x00d313d5, 0x0496fcbe, 0xa4ba4744, 0xe8cac982,
  0xaec29e6e, 0x87ec7038, 0x7000a519, 0xaeee333b, 0xff66e42c, 0x8afd6b25,
  0x03b4f63b, 0xbd7991dc, 0x5ab8d9c7, 0x2ed4684e, 0x48741a6c, 0xaf06940d,
  0x2fdc6349, 0xb03d7ecd, 0xe974996f, 0xac7867f9, 0x52ec8721, 0xbcdd9d4a,
  0x8edd2d00, 0x3557de06, 0x41c759f8, 0x3956d4b9, 0xa75409f2, 0x123cd8a1,
  0xb6100fab, 0x3e7b21e2, 0x2e8d623b, 0x92959da2, 0xbca35f77, 0x200c03a5,
  0x35fcb457, 0x1bb6c6e4, 0xf74eb928, 0x3d5d0b54, 0x87cc1d21, 0x4964046f,
  0x18ae4240, 0xd868b275, 0x8bd2b496, 0x1c5563f4, 0xc234d8f5, 0xf868e970,
  0xf9151fff, 0xae7be4a2, 0x271133ee, 0xbb0fd922, 0x25254932, 0xa60a9fc0,
  0x104bcd64, 0x30290145, 0x00000062,

# define TENS_P13_IDX	(TENS_P12_IDX + TENS_P12_SIZE)
# define TENS_P13_SIZE	853
  [TENS_P13_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x64cf8001, 0x9f345226, 0x644963e5, 0x7b8d5053, 0x49f0aa29,
  0xb945c82f, 0x430ff478, 0x933b6bb8, 0x5ff82d0a, 0x64c501d4, 0x73bbf174,
  0x9ec1e1b3, 0x3bfbe803, 0xe9010689, 0xf7390d8e, 0x3fef8d80, 0xf31d1325,
  0x2c73446b, 0xf5ca7a92, 0x1c19e379, 0x270af2be, 0xf52d9d9c, 0xeb2bed48,
  0x3abf72e1, 0x4ac4ffc2, 0x7ecf3508, 0x22019a82, 0x38597a5a, 0xbe6a7b3c,
  0x9a51ff6e, 0xa2d28437, 0x0c0abe9d, 0x7c9ec6ea, 0xc79887ff, 0x5851c899,
  0x436420d0, 0xefead581, 0x72b5547f, 0x99b1d2b5, 0x077ad8f8, 0x5cddbf5b,
  0x3b4305ed, 0xe3861ac7, 0x2d88f3fd, 0x3d6b43be, 0x393220aa, 0xe5382405,
  0x1cd62095, 0x61a10c96, 0x87a0d1e1, 0xca95a55d, 0x68c933e6, 0x9ee082e2,
  0x778089bb, 0x41429ee9, 0xfbb6d8d4, 0xc529500d, 0x26cf5471, 0x68b9be29,
  0xd6c9b140, 0x07be635a, 0x84151852, 0xb5572182, 0x83730335, 0xeb2300b4,
  0xdd312d31, 0x05d6dd9b, 0x488da59c, 0x37784d25, 0xda2c2e40, 0x6a8d92fa,
  0x6a57d720, 0x950b41ac, 0xf07a8632, 0xcd55f062, 0x2ecad06a, 0xe6a3dfe7,
  0x34c98bb0, 0x9c767d8f, 0xb60521b1, 0x752aafd1, 0xe87d16be, 0x9de1d728,
  0xe58a8b0c, 0xc6013830, 0x2fa2c119, 0x3c4f9156, 0x519b40c8, 0x5058fc8f,
  0xab78701b, 0xadc59c47, 0xc502a554, 0x0fb3286f, 0x6647f04c, 0x9db4076e,
  0x5ea495c8, 0x9c74fab1, 0xb4f00f8b, 0x897c7a3c, 0xd092b4c6, 0x283e0340,
  0x32f31fa8, 0xeeb708cc, 0x67b63de2, 0x4f7b3c8b, 0xef2bc02b, 0xda14bfe3,
  0xc49344c0, 0xaabc85be, 0xb6c4e69e, 0x2ece8aa6, 0x63a11016, 0x19cfba4d,
  0x726ae4d9, 0x0fc90b42, 0xee6ae707, 0x4290b04a, 0x4d9aabc5, 0xfb2b070e,
  0xf34906cd, 0x1ff54b0a, 0x52ca9709, 0x0b42bfe1, 0x16431570, 0x980f3076,
  0x6b5565bb, 0xeb8c4c4a, 0x9ce63c76, 0xb9e4c771, 0x3da24c53, 0x6f0266fa,
  0xb50e3c66, 0x76e34f79, 0x01bb4b96, 0x9948cf3e, 0x0fbea124, 0x86bead12,
  0xa1fa4edc, 0xd11e901c, 0xc3b97bf9, 0x71730e03, 0x370ca58e, 0x48b19715,
  0x886467e2, 0xdb237497, 0x3c727e24, 0x2116ccd2, 0x8e67d76e, 0xf973aecf,
  0x34bdedd3, 0x31d680ec, 0xb042ab05, 0x770e96a0, 0xfc5c3c17, 0xab6f1874,
  0xb8204ece, 0x5843f3a5, 0x416c0ced, 0x11dd112f, 0x95780183, 0xb1c74bd8,
  0x7e0e8613, 0x96c6453b, 0xa79ffc10, 0xb2157651, 0xfcd6da0a, 0x836a34a7,
  0x3dd0ccac, 0x316e5a36, 0x496049ed, 0x0322bcb2, 0xdea1a97d, 0xcdf2aa5a,
  0x39578d53, 0x1d1aa931, 0x030565c9, 0xd198cbed, 0x324e0a27, 0x5db83e8a,
  0x28432534, 0x90bf23e8, 0x5cb134c0, 0xdd0adab6, 0x009e5051, 0xf8ad61da,
  0x7e36a6d7, 0x84c75e57, 0xbdffe6aa, 0xb5d5532e, 0x138d680e, 0xbd84ddac,
  0x4a5f74a1, 0xccff00d1, 0x55538cfa, 0xb0948b8c, 0x48528011, 0xe345f82e,
  0x9e047ad7, 0x6ee770ff, 0xea77bef0, 0x0fc13669, 0x2f162567, 0x869426ac,
  0x0614686c, 0x3a3ff464, 0x4263ed82, 0xb3589b47, 0x57205a7a, 0x213f24ad,
  0xae6fc46b, 0x3de03e4e, 0xd92b133f, 0x315a589b, 0x1b49c24a, 0x73381bcb,
  0x1641c138, 0x7bc99425, 0xbc680ada, 0xa5cfbc9a, 0x962e9884, 0x0a960d70,
  0xfc8d12f6, 0xed18ef4c, 0x60acc868, 0x9aea5d14, 0x13113036, 0xc747c87e,
  0x2d99a5b0, 0x3a369bb3, 0x006b3658, 0x118a5135, 0xe43fa6e6, 0xb4947190,
  0xa13dc05e, 0xd7733db8, 0x0dbd7170, 0xc3fb67d1, 0x117ed7e7, 0xe2d72a49,
  0xc05fe99e, 0x9638db40, 0xd971a25b, 0x4239d468, 0x1a159559, 0x850a223c,
  0xc1117392, 0x22d2dbd8, 0x567b5fc0, 0x92c5b4eb, 0xc051007a, 0x11cc0099,
  0xfb355720, 0x6907810d, 0x39848161, 0x5e8534f4, 0x61d19ef2, 0x2ee8c466,
  0x8a0ab03c, 0xc234af76, 0x879aa514, 0x9774a235, 0x59e5da57, 0x9bc466b3,
  0xf339bd5a, 0x44ab026d, 0xbbb5fd67, 0x2b977202, 0x3685c9f2, 0x03e5dc00,
  0x7054359e, 0x5239cfb0, 0x9ba11f08, 0xf8237562, 0x9c258687, 0xa3b510dd,
  0x52c7bf8f, 0xb31ed0cf, 0x3245e079, 0xff9ff8d3, 0xbaee38c7, 0xf17d5562,
  0xf702b3b9, 0xcc4c8563, 0xcbca275d, 0xe005d9d1, 0xe817dbac, 0x05c6920a,
  0x62cee350, 0x0f1deac0, 0x19e049b9, 0x59599f74, 0xb2a27a16, 0xf0911d5a,
  0x7dcef00d, 0x3603dd66, 0x37552251, 0x97813735, 0x5fa022da, 0x0d849416,
  0xefbe57c2, 0x30a0e592, 0x57619296, 0xc953cc47, 0x11735043, 0xa83526ad,
  0xc0444be0, 0xb5f8463c, 0x16ff5136, 0x2a0a6631, 0xf037572c, 0xd30464da,
  0xb1bf8daa, 0x7f5718f7, 0x0f3e9e7e, 0xe5a4cfe7, 0xc26f2624, 0x8c9b5ae4,
  0xdfe8f485, 0xf6fa82e3, 0xc64a1509, 0xacb24aea, 0x3024b220, 0xddb02ac0,
  0xddcdfedd, 0xd834c574, 0x384c86c3, 0xd904e099, 0xdd48a571, 0x4550a05f,
  0x77b35c74, 0x81e85f71, 0xaaebdc6d, 0x0f9bb0b1, 0xd4cdc054, 0x7af4df85,
  0x845786af, 0xe5e53887, 0xdf2a91ca, 0xf6a58211, 0x5689a3c4, 0x8cf6aa15,
  0xa705983a, 0x9fbf2f52, 0x2ce7fef0, 0x48e84a62, 0x4a3b5365, 0xf8281a47,
  0xd48a0872, 0x8423dcf6, 0xf0929c3e, 0x044a5049, 0xe9ec071b, 0x17decc36,
  0x20e30c1b, 0x45fc2813, 0x3342196a, 0x46afb7f9, 0x6601e337, 0x30754439,
  0xf18094d1, 0xd38b4112, 0x61410dd1, 0xd8796b36, 0xd97d4dd8, 0x47e9bc0b,
  0x80805191, 0x1584e2da, 0xcde438c1, 0x955d24f1, 0x409659a1, 0x1b0950b1,
  0x5a09635f, 0x65b1febe, 0x615472b9, 0x525dc00a, 0x6308e067, 0x4089e2d4,
  0xd4e705a4, 0x43fc9209, 0x32c18b26, 0x4447a5fa, 0xaf271153, 0x3617cadc,
  0x4dc4f0d2, 0x692eb386, 0x6aa116ef, 0x655991bc, 0x0641dc0b, 0x54469597,
  0xc6559664, 0x749c0fe8, 0x4bdc0d1a, 0xa7d3381e, 0xc5292a61, 0x4eb65fdc,
  0x42474cc2, 0xf2c6b173, 0x19dfc9ee, 0x0a19a199, 0xbece2ee3, 0xc68b778d,
  0xaa03aa7c, 0xc8db86f0, 0xae54d2be, 0xb92a01e0, 0xdee3f48f, 0x6023c0a9,
  0xf6ae2852, 0xa233763b, 0xa441cb9e, 0x3246dddd, 0x3a8bb4b7, 0x44faa3c3,
  0x308ef2c8, 0xfd1c8516, 0xd2862534, 0x3b25ebe7, 0x62336f6f, 0x0c336a45,
  0x0b8e2ce6, 0xe867f171, 0x11eea1f2, 0x523972ec, 0x68df4903, 0x50c05824,
  0x51ef4cb7, 0xcb4df2a8, 0x3ffae115, 0xb51aca2f, 0x3ed1635f, 0xd6ff1cc6,
  0x0a5ac09f, 0xde8ed9d6, 0x0a3dc76f, 0x5dc2d8dd, 0x37991dde, 0xf95bacb2,
  0x80ad6e13, 0x163005ee, 0xd4f8c7a6, 0x3225d180, 0xa4760f08, 0x5fff004d,
  0x9b2b1a87, 0xe7ea8576, 0x5cd00b66, 0xec478452, 0x285dd80d, 0x20112439,
  0x4301b3a1, 0xff879fc8, 0xfacbb68c, 0xaf6af6b8, 0xb17fdf84, 0xc208d9f1,
  0xf4489576, 0x8794a6e9, 0xadcc862c, 0x0e83e54c, 0x931685a4, 0xab01c580,
  0x1e40293b, 0xcad784fa, 0x1f1ddf7f, 0x6b856084, 0xcee722b2, 0x1c39938b,
  0x74254eb4, 0xc7ccebf4, 0xb9c26d9a, 0x6b08dfb9, 0x2e3ece24, 0x981455ec,
  0xdff60410, 0xbc804e2b, 0xe06fa38b, 0xb534540c, 0x72e53c52, 0x02dfb2ef,
  0xb2a5c05a, 0x5002a2a5, 0x97313338, 0x597c53ff, 0xd61df455, 0x34e5261a,
  0x39ac2ec5, 0xc6bc0cab, 0x388b7539, 0x3f732fc0, 0x00eac704, 0x92fb21d9,
  0xc089971e, 0xb4ffa503, 0x7af93f8f, 0x72e353b6, 0xa8311b23, 0x8266c9af,
  0x1de496ca, 0xdbdb16b0, 0xd6fa0b51, 0x9991a5ef, 0xbd563089, 0x168cbe0f,
  0x0954a1e3, 0x537b9245, 0x53d09723, 0x2867272d, 0x86558cb9, 0x0b83f026,
  0xfac85d10, 0xf8562951, 0x1e5ddb95, 0xad3668c8, 0x48d27b92, 0xc930b7e6,
  0x19b58a99, 0xa3de74e3, 0xa9cda917, 0xcb6e35ee, 0x7a4dd16e, 0x4c80e9d5,
  0x4d84073f, 0x74a95ba8, 0x9cffcfc0, 0xd28485eb, 0x15796372, 0x5717e9cd,
  0x77eda8df, 0xab473c4e, 0xadb965e1, 0xffad6959, 0x5bc05659, 0x6ed63880,
  0xfb240227, 0x2014850b, 0xd15fdddf, 0xfdd74592, 0xb538f37d, 0x3a8e2e82,
  0x1473396f, 0xf6a5edf8, 0x3ce41a21, 0x0cc4351a, 0x754e8264, 0xaab95e73,
  0xc7821b96, 0xf42ff463, 0xc242faaa, 0xdd00ac65, 0x087e260e, 0x17d193f5,
  0x0dbe0328, 0x844a63c9, 0xf9d10f96, 0x85aa91dd, 0xbaf127ec, 0x0ab6dabb,
  0xce85e6a5, 0x1af5d24f, 0xe7b56a16, 0xcd6c5a19, 0x57d1d79f, 0x5dfc2b28,
  0xec4dd2f0, 0x18fe64a1, 0x8d72216a, 0x5f222077, 0x72f14a08, 0xd8b09b11,
  0x3bf038ab, 0xc6cf1f44, 0xc4265d7c, 0xdab1b0e7, 0x46398d2c, 0x7dcfdc68,
  0xb6e705d3, 0x4aafd1e6, 0x362c1183, 0xd8701107, 0xf6ac98b7, 0xad114d7e,
  0xd6649424, 0xc40ab551, 0xddd1c6e4, 0xa132030f, 0xc9d284c8, 0xdb1f662a,
  0x824069ee, 0x4157904b, 0xc846b3ad, 0xd38481ca, 0x0a248c17, 0xc846831f,
  0xe8745feb, 0x000025a8,

# define TENS_P14_IDX	(TENS_P13_IDX + TENS_P13_SIZE)
# define TENS_P14_SIZE	1703
  [TENS_P14_IDX] = 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x099f0001,
  0x41b5687d, 0xcbfd1b6e, 0x8c75ee63, 0x4b191cea, 0xd75296ad, 0x2394d80a,
  0x1eb5da9b, 0x18a004ed, 0x5c79fed9, 0x37e3b01c, 0xed67a1b8, 0x78d9a714,
  0x2a1a34d5, 0x8fbe7f0d, 0x6b1d3516, 0xe57c43ea, 0xa7825681, 0xc81d32e8,
  0xd3e716e1, 0x58860b00, 0xa6d93d65, 0x83159c97, 0x0113232f, 0xd6122269,
  0x7321c3a0, 0xbe6a92f3, 0xca4ca9d3, 0xd1e276a5, 0xc0e55163, 0xb05915d6,
  0x7b7a78c1, 0x0fae0ca4, 0x62a3df4b, 0x08abec6f, 0x13030d11, 0xd446338a,
  0x60dcc8f2, 0x5f05d1d5, 0x25e1f9f6, 0x04a40bee, 0x7f8c7113, 0x88f47ec0,
  0x589ff59a, 0x308c3661, 0xea5068a1, 0x95fb108f, 0x06e87dff, 0x1559e741,
  0xd4d4abdc, 0x01e092e4, 0xee16907c, 0x5a7b78e6, 0xe73aabcb, 0x146bb7e0,
  0xad372889, 0x4f6b43c5, 0xfd49fc1d, 0x0f29f589, 0xd3739253, 0xc4745a56,
  0xe2acfcc2, 0xd75ccbc7, 0xedd016cd, 0xac5a63e0, 0xef82ccd3, 0xb352496e,
  0x2bdabfc4, 0x5b3d0401, 0x01b0197f, 0xade96d3c, 0x29d9253d, 0x19bebdba,
  0x73c56b1b, 0x255e7b25, 0x1f2b7f1e, 0xa56a457e, 0x6299c836, 0x5c63cc78,
  0xa2ca74c6, 0x5c85fe93, 0xee571bea, 0x508e2561, 0x2db5f1d0, 0xb1fde6a9,
  0xa9b87b99, 0x4fb90a37, 0xf7260f07, 0xff58c5fd, 0x56ee7e97, 0xbab9fa46,
  0x42e6f9ce, 0x78816f73, 0x1b76d267, 0xfdb2c728, 0x4566519c, 0xae17dd8d,
  0xb9f6a95f, 0x1cd533a1, 0x67160dea, 0x14534bac, 0xfcd8f8f9, 0xf3f2901d,
  0x708b1f0a, 0x8829063b, 0x9457a1df, 0x8f872aa1, 0x36bb9335, 0xb5672c0e,
  0xd889d109, 0x7ec63a6a, 0x93306672, 0x39b6d457, 0x8239ab68, 0xef2e2506,
  0xbe0d7a1f, 0x4251b635, 0x05f65522, 0x0ef0bd55, 0x03286891, 0x2c42b664,
  0x9815fbac, 0x471fd611, 0x814e379c, 0x7dd8349d, 0xa4a25bda, 0x9886b84c,
  0x01b9e39d, 0x5a7ce1a2, 0xae31cbc9, 0x86d07f32, 0x83ef8faf, 0xb66b5b76,
  0x58470fdf, 0x96d59b73, 0x51618889, 0xdc400cf7, 0xfc8e0fc6, 0xaf693670,
  0x09a08e56, 0x91737de6, 0x74f682e1, 0x0e03923f, 0x7f8ac56d, 0x7400cfd4,
  0x8e05e49a, 0x4cebea3c, 0x384e1164, 0xb2e43d8c, 0xb50ae05e, 0x0f0b3ed9,
  0xa4006123, 0x64137137, 0x4e9a1934, 0x05404100, 0xd9621be6, 0x9329a255,
  0x5c347ebb, 0x75cbeb1b, 0xe684346b, 0x840fee55, 0xba6a9753, 0xf43836f6,
  0x60505b7b, 0x334a9278, 0xfd6d475d, 0x5db94761, 0x267375aa, 0xc110e160,
  0x024f6d63, 0x2ec96610, 0xa99b4c19, 0xb915c9f4, 0x338cfd90, 0xf02ea846,
  0xb9e51a09, 0xae928fb1, 0xfae31d88, 0x1a3db721, 0x8475dd26, 0x5769489d,
  0x7ad4c407, 0x0a49e9f0, 0x34e275c8, 0x3d075d83, 0x1d63114a, 0x72a96415,
  0x6b98e947, 0x1d500b5f, 0xd50fdc36, 0x141e5085, 0x87751275, 0xe7843834,
  0x2278809e, 0xb15c52ee, 0x947aead2, 0xfedb7b02, 0x5197b744, 0x64e09ba8,
  0x8849d0a6, 0x23beaa85, 0x11ecb913, 0x0f7ed667, 0x5d984848, 0x9f6331ea,
  0x588290e9, 0xa24d64d1, 0x7e09e9e5, 0x32592033, 0x03a501df, 0x27c270a6,
  0xbb3df738, 0x3c7c5a70, 0x4190833c, 0x7d4bf9f4, 0x80e5d89b, 0xa7fc6194,
  0xfaefb663, 0x62e52b49, 0xd3b6adcd, 0x809646fc, 0x1f2cf73a, 0xb765ed4f,
  0x531e4bfb, 0x92cd05f2, 0xaf12d1a6, 0x22ee30f3, 0x38da1074, 0xed6447bb,
  0x1a725608, 0xaff222d3, 0x7a3c6f54, 0xbca79a56, 0x7b0e8d12, 0x1c4660c5,
  0x6e34d6fb, 0x6f481a9f, 0xfe9dc99c, 0xf888db82, 0xd8489ea0, 0x84b4c0fa,
  0xc0dea281, 0x977a8583, 0xae30e887, 0x8c1cbcec, 0x1d4848cb, 0x0ee0d137,
  0xd011b0fc, 0x94b5fd49, 0x478d7dd4, 0x3d67f2e7, 0xacab62ad, 0x0ab4e62a,
  0x1dfc7df5, 0xd22e4553, 0x870b0e75, 0x49b7b001, 0x1b73bf6d, 0x12807ffd,
  0xdc9f0737, 0x6f3e5852, 0xc0e2f250, 0x93e62e4a, 0x4d96a55a, 0xc1d0e185,
  0x83a126db, 0x190b917b, 0xefbfd043, 0xc7df1669, 0x8f25b6dd, 0x2062eac9,
  0x476c17a6, 0xcb60f278, 0x25460383, 0x0e85e996, 0xda8c05be, 0x6f678a34,
  0x69206234, 0xf59be929, 0x1947b69a, 0x0ebfa11b, 0x90fd8322, 0x15c1e9bf,
  0xd699b1ec, 0xb2f0343f, 0x7001d002, 0xcf76eaaa, 0xc0778ab5, 0x5173eda8,
  0xb7b008e2, 0x4e00e4c6, 0x505d3f4d, 0x99dd341a, 0x1c9d4e12, 0x4ffb6978,
  0x474c5e95, 0x6e9ca6dd, 0xda19f938, 0xe2dda6e0, 0x98dc318e, 0xda455e54,
  0x3f67b836, 0x21e4181c, 0xa97e9a64, 0x1e17f655, 0x527a08bb, 0x1712dc21,
  0x682972ad, 0x0042d256, 0xccbeadf1, 0xca497b96, 0x861e99e0, 0x0d8aa585,
  0xeeb0f650, 0xdcc3c3da, 0x506af77e, 0x5deb9768, 0x7c9d60be, 0xe9d978b7,
  0x37b37e95, 0x77ad0b94, 0x42747f75, 0x07be42c4, 0x6d5fd2fe, 0x4c8c5da9,
  0x0d8fc27d, 0x0f2fd50f, 0x0ccf6023, 0x5b56053f, 0x3b1101bd, 0x56d34906,
  0xc0feca27, 0x7602a150, 0xc4888da4, 0x419abe54, 0x56d10633, 0xc76120ed,
  0x8db14123, 0xb656e675, 0x741e8f76, 0xd297b94e, 0x96be6f21, 0x3662439d,
  0x9b409e27, 0x6626574d, 0x35fff92a, 0xbf558205, 0x69e02439, 0xbe6838b7,
  0x6400fd4c, 0xa00f64ca, 0x1f4b158a, 0x9e2052ae, 0x04cca558, 0xfb5ee69e,
  0x58da644c, 0x96f26e1f, 0x8ab19401, 0xbee1e16b, 0xed8bf908, 0x2f2809a4,
  0xd50babab, 0x6e57f7e6, 0x6b0a8929, 0xf7356431, 0xb54a4cfc, 0x9a1d0ac4,
  0x6f9fd6cb, 0x836bfbf8, 0x3b42f469, 0x8bd32129, 0x40111b6b, 0x7c278fb1,
  0xb345d955, 0xff1fd188, 0xd32cd13c, 0xf7ec3aa0, 0x3789f792, 0xab707fa4,
  0x4d79a4bf, 0xb3a28ceb, 0xd9c24d8e, 0x7134dadc, 0x06e2eb3e, 0xd7c04f76,
  0xb379d811, 0x2b3b0ebc, 0x8c94fc33, 0xa28b53ab, 0xc06c5d01, 0xd900432a,
  0x7fea91ca, 0x6d30b008, 0x64845f08, 0x796f5349, 0xfde4687d, 0xf888fe67,
  0xe0046c56, 0xae482177, 0xce98cb11, 0x84590c46, 0x1feb4400, 0x6e1ba29b,
  0xff2f1611, 0xf73f3e9c, 0x3159ca8c, 0x34845918, 0x56f0ed46, 0xb7d10c32,
  0xd9a16a01, 0x405b9e91, 0x3cee3e24, 0x8739e4a6, 0x2ab396b4, 0x3f1b7871,
  0x09835dfd, 0x8c7a489f, 0x1592b74a, 0x05df7c81, 0x0e8d3f37, 0xa61ff273,
  0x68b29622, 0x259cd337, 0x43ff84a6, 0x81cf8fe9, 0x566ed883, 0x48427fc6,
  0x35c79428, 0xcfd2fb59, 0xa97e8c8b, 0x750aaed8, 0x32ddca23, 0xaa8108ef,
  0x96fbfff9, 0xa1d039aa, 0xe3cdf588, 0x47e77e00, 0xcd6b3fdb, 0xe72a9a80,
  0x9a522152, 0xeda06283, 0xef175610, 0xa670cfa1, 0x339fe6c4, 0x2dfbf3ee,
  0xc2d7f53b, 0x92a44e27, 0xcc47e4b0, 0xdfa212bc, 0xd64f83c9, 0x997e5475,
  0xb51319bf, 0x9fffe599, 0x1fc2c7b6, 0xef5605e7, 0x832169dd, 0xfeb6be4e,
  0xbf921dc8, 0x60bdfb1d, 0x72759f8d, 0x3546efa0, 0x020eebed, 0xcaab3d64,
  0xdb20a2fe, 0xba1218f6, 0xb2b62bdd, 0x3101eff0, 0x8fde5cfa, 0x2e319213,
  0xa52114d2, 0x87eead3f, 0xdf08b1dd, 0xa5387642, 0x746f34d0, 0xd76c4844,
  0x4cc40317, 0xe4f689c9, 0xb7d76071, 0x5fe0b4a2, 0x6e1c7915, 0xc7d43f53,
  0x3efb7d71, 0x068dd906, 0x35a75f5f, 0x652d7770, 0x750f4607, 0x64a1656c,
  0x36c2cf8e, 0x214d758b, 0x9348ef93, 0xe4058978, 0x9674b7f3, 0x10570b0b,
  0xbdfaba8f, 0xcef09dd7, 0xa92b261f, 0x071c21b6, 0xcbebb81f, 0xf427ed6c,
  0x44228cd6, 0x65e56fcf, 0x5036c460, 0xad919def, 0xccfd848b, 0x61d158a6,
  0x7527dca3, 0x4cf30459, 0x50855075, 0xa70dfd09, 0x3540f5aa, 0x35577adb,
  0xb5ba3d4e, 0x35736c4f, 0xcdfb689f, 0xefe8fa82, 0x97ab0dca, 0x51bd2ff3,
  0x77a7fe9c, 0x3107846c, 0x3d618b81, 0xbca797a4, 0xfc5e9651, 0xe2e08fbc,
  0xf7e8791f, 0x772f1cc0, 0x7c426f9d, 0x08d56f88, 0x0080c3ab, 0x0deea663,
  0xe6d46ec6, 0x7dca4eb7, 0x6b681d9d, 0xda06730b, 0x4af0e0f2, 0x038bf468,
  0x52097463, 0xca19d302, 0xbc09bb9a, 0xaa55aeb1, 0x3ded4433, 0xf27938ba,
  0x3e4b7865, 0x28296be7, 0x7ef96314, 0x7a1d55cc, 0xdf0b6b47, 0xcde11852,
  0xcedda5bd, 0xf00a0eb3, 0x72ca1a8b, 0x5241b572, 0xb002fdcc, 0xff8898b3,
  0xc4878862, 0xb3e85372, 0xbf4bca29, 0x7e1fef45, 0xf2d83189, 0x0f5427af,
  0x3cdf9e05, 0x75bae885, 0xf65c06ac, 0x9c71a700, 0xa3145eac, 0xde63bab2,
  0x76255bbf, 0x6e817be6, 0x4c6ad3d0, 0x25ab9935, 0xe95ef2f8, 0x11cd095a,
  0xd54f78de, 0xa001ae7e, 0xb3829dcb, 0x5abd18bd, 0x18eb9c9e, 0xada3c504,
  0xe3e3556c, 0xd35479aa, 0x5191ac5f, 0x221821ac, 0xc8d1d9d3, 0x313a8c51,
  0x088c3fc8, 0xc146a264, 0xb154abed, 0x92755bc5, 0x349ec093, 0xf94aba57,
  0x41d5886c, 0x0a5ad8b2, 0x36aba94b, 0x883a6758, 0xa9ad229f, 0x5d64069a,
  0x0546172f, 0x0366da16, 0xc3808ea4, 0x0b172403, 0x70f0a235, 0xfa816e66,
  0x4fceb827, 0xa65fcfea, 0x167b56d5, 0xfe2b9fb2, 0xfec36bcd, 0xa84c4cc9,
  0xcd96320f, 0x3e128584, 0x09eda8b8, 0x91eca525, 0x7ec7e17b, 0xbc45bedc,
  0xc14032f4, 0x9be689a7, 0x2eb20bc0, 0xffdf1efc, 0x14ef835f, 0xc6966c59,
  0xcd778dd8, 0x5feb0f3b, 0x23d47715, 0xd64b87c8, 0x5722a550, 0x62883198,
  0x315a1a8b, 0x648e17e6, 0x4b7e9d7a, 0x2ba43d28, 0x67caca84, 0x741f0398,
  0x6e660159, 0x3e16e1a9, 0x3dde3c45, 0xa53e56ae, 0xc7eb0aef, 0x3f39f33e,
  0x78751d73, 0x45816df8, 0x626770f7, 0xcb17d28d, 0x909e87f4, 0x93a86aba,
  0xc1dcf328, 0x1a1e4ce2, 0xd895d042, 0xb9f6dd69, 0xbb00eaf5, 0xacc37687,
  0xca609578, 0x5b490d39, 0xf8b86d4c, 0xf2737ef0, 0x39419f6d, 0x69267bc0,
  0x72524a03, 0x6eb060c4, 0xdbc01e93, 0x291035b1, 0x83984d54, 0xf673ad85,
  0xe08cbc20, 0x1fb24915, 0x584803a6, 0xe15bbcd7, 0x4088ddb5, 0xd4c22542,
  0x2c18041a, 0xa51372d1, 0xb2ba69b4, 0x2299283f, 0xcd11c296, 0x25dcd6f3,
  0xac54df23, 0x24a3a55e, 0x77e16e1d, 0xb3cd415b, 0xb99d85c0, 0x497befc7,
  0xe91154e3, 0x7365cd8b, 0xb55100aa, 0x0ee699eb, 0xfc0927a6, 0xefb374de,
  0x8acaa910, 0x83b40e3d, 0xda3f0006, 0x8590a089, 0xc6ce1b75, 0x54f6ff20,
  0xfda2f7f3, 0xd2ab58f6, 0xd0763b6d, 0x6caf2515, 0x2519622d, 0xc3714057,
  0x9863638f, 0xea00bb4f, 0x09ea4a4d, 0xe69de96d, 0x6b01fe5f, 0x960161a5,
  0x529e32ec, 0xf8260ae9, 0x01a37eea, 0x69710577, 0x5aa0716f, 0xcb3fb1da,
  0x4260feda, 0xa33fb790, 0x76012f75, 0x24c0e5be, 0x130f09ae, 0x2e8323dc,
  0x5c8ecb76, 0x17cb8f12, 0x401b5f5c, 0x5f0a63e0, 0x47e1560a, 0xdc57a786,
  0xee1377d4, 0x228e7ee5, 0x0aa294b9, 0xaea6c534, 0x55b0fe2f, 0x922d318a,
  0xf108b772, 0xf15bddf6, 0xdfb69702, 0xcd438a4e, 0x90e1db66, 0x584ce4a1,
  0x568ef6cb, 0x69e55f9d, 0x6da376ba, 0x5ca6c109, 0x45c7e294, 0xc977b3e9,
  0xcf5b6c0c, 0x1d694499, 0x11b487ae, 0xcf8339ac, 0xbcb3cc6e, 0x50b828e0,
  0x046b1071, 0x5703ed0d, 0x2c615946, 0x720d1610, 0xa908dbd0, 0x742bbe33,
  0x22c076e2, 0x48966a66, 0x1d0cefa4, 0x1dde819f, 0x601352bf, 0xb9370c39,
  0xa585cc4a, 0xeb857f94, 0x5a2f7206, 0x3fae6b58, 0x49cd0f1f, 0x78e5fb3d,
  0x1b89d476, 0x74e9e65b, 0xed82945b, 0xb74e6483, 0x2941c4d9, 0x7e087acc,
  0x565c18dc, 0x1a09f2e5, 0xbf4ccd3d, 0xd304e977, 0xa522631d, 0x6123378e,
  0x4517109b, 0xb7e4285a, 0x4bf1a506, 0x625803c2, 0x683172f8, 0xc84e7354,
  0x3f8a2b11, 0x7dd12b89, 0xed420491, 0x8c698b0b, 0x9853fb97, 0x9631777b,
  0xb697e1c9, 0x5f028f05, 0x51038110, 0x9055f055, 0x30e255e3, 0xe2d0c1b6,
  0xb990321e, 0xa8fdf4d1, 0xff4dc144, 0x521a3056, 0x148999e0, 0xa8111c66,
  0xa9c96852, 0x8157f508, 0x4b394a94, 0xa0dc4df1, 0x94ec2e93, 0x6e6afa56,
  0x8fc28377, 0xf72ffa04, 0xc435186f, 0xf91488b7, 0x8d037f6f, 0xa899ec1e,
  0x48757727, 0x4101b612, 0xb8cf377d, 0xa5a54e68, 0xb4570569, 0x2ac5a0a0,
  0x063d9cfd, 0x7c504c74, 0xf1a5884c, 0x0a9b1955, 0x8d0b91bf, 0xe5f6862f,
  0x79ff5361, 0x0ed3d38f, 0xc6fd31fb, 0x9fe131c7, 0x85b9c648, 0x8febf2b4,
  0x8e77e86b, 0x992ba80e, 0x56429986, 0x6848879a, 0x608cdda5, 0x3e0d106e,
  0x754b300e, 0x25200576, 0xafd5195b, 0x5d37aad9, 0xe81f0939, 0xe00a390e,
  0xdeeea20a, 0xf5fef0be, 0xb5d51155, 0x6e27d173, 0x9e72ebcf, 0xb776e978,
  0xb966f7ba, 0x09520238, 0x726c8408, 0x3347ebc5, 0x65dce5a2, 0x3ec78337,
  0x8c92d740, 0x3cdde3fe, 0x32caec93, 0xd20379ae, 0x411be811, 0x41756580,
  0x72fa1bbd, 0xa92125b3, 0x84c42f04, 0xdd4ee5fe, 0x3a25922c, 0x96446853,
  0x49ad3be0, 0x2880366d, 0x1c841afe, 0xf1e09019, 0xfb905fe1, 0xa451ad59,
  0x3ba9d0c9, 0x56db2e9c, 0xa42419f2, 0xe921e7a0, 0x3c9a3ca5, 0xad8ea375,
  0xcec7d091, 0x99bdb940, 0x477ef58f, 0x8a4933c7, 0xb2598b8d, 0xf5659df7,
  0xcfac1e1c, 0x339f8748, 0xe2a04aab, 0xe122b03f, 0x45bc6f37, 0xc9feeb30,
  0x9c75aaa0, 0xc13c174e, 0x0ea0585d, 0xdc58bbb4, 0x3a96bd5a, 0x20251482,
  0x3c7a714d, 0x696897eb, 0x6cb83b6b, 0xa37de406, 0x3b496b5f, 0x37e75d6a,
  0x380dd382, 0x0e1a513c, 0xda26fac9, 0xf2458364, 0x12b5c6ea, 0x79ce9e47,
  0x1ff1fcbf, 0xbe7c6e86, 0x59a6a7ba, 0x8d70f515, 0x94761453, 0x6b04e425,
  0x8768ffb2, 0x1ca5f425, 0x3f9e8407, 0x3b641184, 0x5f8f6756, 0x62b1a5a5,
  0x56bc2120, 0xd1e5da68, 0x17f2fa18, 0x8cce5e2d, 0xa1bc9c06, 0x8e290fb1,
  0x892df1af, 0xad10b8c8, 0xb43e5517, 0xd0597409, 0x4407c38f, 0x4a020d81,
  0xfea9c9b6, 0xd8e0e7d6, 0xd5b2aaf9, 0xde5e9b40, 0xda44ed4a, 0x45d6bf41,
  0x87aa3ca0, 0xc62d12fc, 0x4708acc8, 0x10212e26, 0x0d1227ff, 0xfeeb5742,
  0x5da02550, 0xd66668e7, 0x1d56e5e1, 0x32c215ec, 0xae1e0bef, 0x7f048b7e,
  0x58c0e922, 0x2aea8619, 0x58251aac, 0xbbe10425, 0xa1fea536, 0x2e1d9667,
  0xd233eb7d, 0xcf435c0b, 0xb0693c67, 0x61d918ea, 0x903ec9f0, 0xd6c4e8ac,
  0x0efb1788, 0xb0098f5b, 0x1709d878, 0x3c12b35e, 0x3f6ce1b7, 0xa1b3ff54,
  0x8a8f7dbb, 0x37608d6a, 0x73e8563e, 0xa3330540, 0x64e00749, 0xebbfcab9,
  0x8d5caaf9, 0x3bc87c7e, 0xedb2bd94, 0x22f8f62d, 0xe656dec3, 0xc5683222,
  0x670c1626, 0x94089e7f, 0x4237542f, 0x47d29440, 0x2fc4e530, 0x8419441e,
  0x8b288dac, 0x7f9245f9, 0xa7afb4e9, 0x8a15650d, 0x082adef7, 0x3104ef19,
  0x043c62de, 0x0aff3dc5, 0x7ecd0635, 0xe7e80a8b, 0xe0600fad, 0x4d8e81cc,
  0x81ebf4e0, 0xf587e30f, 0x7b372af7, 0x2d8f8ca0, 0xdee11c6f, 0xd3624b1c,
  0xf8adc426, 0xca9debed, 0x5c22de4f, 0x3634f778, 0xfae3186b, 0xacf8b595,
  0xd7bfa75f, 0x003cd316, 0xbbfe3cf6, 0xb023cb50, 0xc51055a1, 0x0063cffd,
  0x93869a77, 0x51e022d4, 0xfbceeb10, 0x5187457e, 0x109defc9, 0x673892d8,
  0xe13cfde2, 0xd4aa3272, 0xc09c8134, 0xbf89ad5b, 0x0327181b, 0x09511ec7,
  0xaa21b632, 0xd7e72186, 0xe41885b5, 0x46713f9c, 0x493d2789, 0x1386c526,
  0xd5d22a5c, 0xcefddfc4, 0xcf59281c, 0x92973ea6, 0x4ebe43f6, 0xeac5c6ad,
  0x6cf4897d, 0xd95082a0, 0x82ce562a, 0x28e5e9bd, 0x28d8f0db, 0xddf06e81,
  0x707b0166, 0x7dae3f00, 0xfbf5756a, 0x035a4680, 0x4f114102, 0xe7ba4b33,
  0x5190fedf, 0x106a7594, 0xe5f1bc49, 0xaae3ad67, 0xd7a1a766, 0x040ee971,
  0x9120a214, 0xf415b374, 0x1edc87ea, 0x17aab43c, 0xc6ad637d, 0x885858c1,
  0xd90303c7, 0xbfd4b70b, 0x3ff4eb0e, 0x344a9a88, 0xd81eea30, 0x95925446,
  0x5adef0ec, 0xabb5f5e7, 0x20bbd8c3, 0xc1c22cce, 0xe6944262, 0xc5acdb23,
  0x80024021, 0x2232c635, 0x94b30c81, 0x55f07648, 0x78569acd, 0x9696ea39,
  0x4dd6b528, 0x1c3e1b40, 0xde5853b3, 0x8a2c3679, 0x6eb5a7d8, 0x56bda89a,
  0x8f9cf096, 0xfda86d5b, 0x6481c7e7, 0x50a6a7d5, 0x15bfb45d, 0x4f9a5381,
  0xc057d45d, 0x4fb10024, 0xa0009f00, 0x5e1ca0dd, 0xac420f74, 0xcfbb38bd,
  0xf0d4a615, 0x19bf0318, 0x0e3aef84, 0xcb3d7b20, 0x166c1e3e, 0x58272fdd,
  0x3bfacf9f, 0xc0f5ce46, 0x63a13528, 0xea59e333, 0xa020ca8c, 0xaadd116b,
  0x3dbb5a3d, 0xe5523f47, 0x747f55ea, 0x0922171e, 0x64d520fb, 0x6c709e84,
  0x07ce951b, 0x35fdc402, 0x7508eb6d, 0xc495a8fa, 0xb0d11c39, 0x81313d65,
  0x57447ef0, 0xa7b61e26, 0xf72301f3, 0xbb096315, 0x45a3a7c5, 0xa903a44b,
  0x00432f88, 0x19081987, 0xeb4e1b66, 0xbb7b66bd, 0x6d245171, 0xde4182f5,
  0x0d89bd0b, 0x87f4de6c, 0xf70d8a60, 0x9a87855b, 0x08a27449, 0x4ac7720a,
  0xd4964017, 0xb0d9ddac, 0x4db3488c, 0xfe397d44, 0xd07b745b, 0x197dcb7b,
  0x6e9d567d, 0xe3b90812, 0x9143fef1, 0xb9e002ac, 0x115ff96d, 0xf60a2201,
  0x5b61c9c8, 0x09abab2f, 0xb14a44a7, 0x0ca19c73, 0x843c7997, 0xe3a9bbe6,
  0x5e3fc18c, 0x0c0404ee, 0x764df59d, 0x990ec2c2, 0x4ad0ba3c, 0x05e8be0f,
  0xe599647d, 0xc19d365d, 0x4d0c2990, 0xe5a9d9ac, 0xb680a72d, 0x4ce2e5dd,
  0x6d6c0267, 0x06f9c25b, 0xbd6078e0, 0xb5fcdc81, 0xd742fa41, 0xcccc2399,
  0xc691adc0, 0x215ad82c, 0xea73b0c3, 0xa511e5b0, 0xf499e0a6, 0x53e27ab0,
  0xd94440a2, 0x47752521, 0x9a6e3644, 0xab113708, 0x8f8b301d, 0x058a42a3,
#endif	/* !__NO_LONG_DOUBLE_MATH */
};

#elif BITS_PER_MP_LIMB == 64

/* Table with constants of 10^(2^i), i=0..12 for 64-bit limbs.	*/

const mp_limb_t __tens[] =
{
#define TENS_P0_IDX	0
#define TENS_P0_SIZE	2
  [TENS_P0_IDX] = 0x0000000000000000ull, 0x000000000000000aull,

#define TENS_P1_IDX	(TENS_P0_IDX + TENS_P0_SIZE)
#define TENS_P1_SIZE	2
  [TENS_P1_IDX] = 0x0000000000000000ull, 0x0000000000000064ull,

#define TENS_P2_IDX	(TENS_P1_IDX + TENS_P1_SIZE)
#define TENS_P2_SIZE	2
  [TENS_P2_IDX] = 0x0000000000000000ull, 0x0000000000002710ull,

#define TENS_P3_IDX	(TENS_P2_IDX + TENS_P2_SIZE)
#define TENS_P3_SIZE	2
  [TENS_P3_IDX] = 0x0000000000000000ull, 0x0000000005f5e100ull,

#define TENS_P4_IDX	(TENS_P3_IDX + TENS_P3_SIZE)
#define TENS_P4_SIZE	2
  [TENS_P4_IDX] = 0x0000000000000000ull, 0x002386f26fc10000ull,

#define TENS_P5_IDX	(TENS_P4_IDX + TENS_P4_SIZE)
#define TENS_P5_SIZE	3
  [TENS_P5_IDX] = 0x0000000000000000ull, 0x85acef8100000000ull,
  0x000004ee2d6d415bull,

#define TENS_P6_IDX	(TENS_P5_IDX + TENS_P5_SIZE)
#define TENS_P6_SIZE	5
  [TENS_P6_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x6e38ed64bf6a1f01ull, 0xe93ff9f4daa797edull, 0x0000000000184f03ull,

#define TENS_P7_IDX	(TENS_P6_IDX + TENS_P6_SIZE)
#define TENS_P7_SIZE	8
  [TENS_P7_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x03df99092e953e01ull, 0x2374e42f0f1538fdull,
  0xc404dc08d3cff5ecull, 0xa6337f19bccdb0daull, 0x0000024ee91f2603ull,

#define TENS_P8_IDX	(TENS_P7_IDX + TENS_P7_SIZE)
#define TENS_P8_SIZE	15
  [TENS_P8_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0xbed3875b982e7c01ull, 0x12152f87d8d99f72ull, 0xcf4a6e706bde50c6ull,
  0x26b2716ed595d80full, 0x1d153624adc666b0ull, 0x63ff540e3c42d35aull,
  0x65f9ef17cc5573c0ull, 0x80dcc7f755bc28f2ull, 0x5fdcefcef46eeddcull,
  0x00000000000553f7ull,

#define TENS_P9_IDX	(TENS_P8_IDX + TENS_P8_SIZE)
#define TENS_P9_SIZE	28
  [TENS_P9_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x77f27267fc6cf801ull, 0x5d96976f8f9546dcull,
  0xc31e1ad9b83a8a97ull, 0x94e6574746c40513ull, 0x4475b579c88976c1ull,
  0xaa1da1bf28f8733bull, 0x1e25cfea703ed321ull, 0xbc51fb2eb21a2f22ull,
  0xbfa3edac96e14f5dull, 0xe7fc7153329c57aeull, 0x85a91924c3fc0695ull,
  0xb2908ee0f95f635eull, 0x1366732a93abade4ull, 0x69be5b0e9449775cull,
  0xb099bc817343afacull, 0xa269974845a71d46ull, 0x8a0b1f138cb07303ull,
  0xc1d238d98cab8a97ull, 0x0000001c633415d4ull,

#define TENS_P10_IDX	(TENS_P9_IDX + TENS_P9_SIZE)
#define TENS_P10_SIZE	55
  [TENS_P10_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0xf55b2b722919f001ull, 0x1ec29f866e7c215bull, 0x15c51a88991c4e87ull,
  0x4c7d1e1a140ac535ull, 0x0ed1440ecc2cd819ull, 0x7de16cfb896634eeull,
  0x9fce837d1e43f61full, 0x233e55c7231d2b9cull, 0xf451218b65dc60d7ull,
  0xc96359861c5cd134ull, 0xa7e89431922bbb9full, 0x62be695a9f9f2a07ull,
  0x045b7a748e1042c4ull, 0x8ad822a51abe1de3ull, 0xd814b505ba34c411ull,
  0x8fc51a16bf3fdeb3ull, 0xf56deeecb1b896bcull, 0xb6f4654b31fb6bfdull,
  0x6b7595fb101a3616ull, 0x80d98089dc1a47feull, 0x9a20288280bda5a5ull,
  0xfc8f1f9031eb0f66ull, 0xe26a7b7e976a3310ull, 0x3ce3a0b8df68368aull,
  0x75a351a28e4262ceull, 0x445975836cb0b6c9ull, 0xc356e38a31b5653full,
  0x0190fba035faaba6ull, 0x88bc491b9fc4ed52ull, 0x005b80411640114aull,
  0x1e8d4649f4f3235eull, 0x73c5534936a8de06ull, 0xc1a6970ca7e6bd2aull,
  0xd2db49ef47187094ull, 0xae6209d4926c3f5bull, 0x34f4a3c62d433949ull,
  0xd9d61a05d4305d94ull, 0x0000000000000325ull,

#if !defined __NO_LONG_DOUBLE_MATH && __LDBL_MAX_EXP__ > 1024
# define TENS_P11_IDX	(TENS_P10_IDX + TENS_P10_SIZE)
# define TENS_P11_SIZE	108
  [TENS_P11_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0xe30968651333e001ull, 0x49e28dcfb27d4d3full,
  0xee87e354ec2e4721ull, 0x368b8abbb6067584ull, 0x2ed56d55a5e5a191ull,
  0xea50d142fd827773ull, 0x98342c9e51b78db2ull, 0x866ed6f1c850dabcull,
  0x9279498719342c12ull, 0x66912e4ad2f869c2ull, 0x57a7842d71c7fd8full,
  0xfb7fedcc235552ebull, 0x38209ce1f3861ce0ull, 0x34c101349713b449ull,
  0xa7a8289c8c6c54deull, 0xe3cb64f32dbb6643ull, 0xe3892ee98074ff01ull,
  0xa8f16f9210c17f94ull, 0x967abbb3a8281ed6ull, 0x9952fbed5a151440ull,
  0xafe609c313b41e44ull, 0xf111821fa2bca416ull, 0x91bac974fb1264b4ull,
  0x8e48ff35d6c7d6abull, 0xc4a656654419bd43ull, 0x33554c36685e5510ull,
  0x0dbd21feab498697ull, 0x982da4663cfe491dull, 0x9e110c7bcbea4ca7ull,
  0x5fc5a04779c56b8aull, 0x1aa9f44484d80e2eull, 0x6a57b1ab730f203cull,
  0x87a7dc62d752f7a6ull, 0x40660460944545ffull, 0xc9ac375d77c1a42full,
  0x744695f0e866d7efull, 0xa1fc6b9681428c85ull, 0x7bf03c19d7917c7bull,
  0x5715f7915b33eb41ull, 0xdb0708fd8f6cae5full, 0x785ce6b7b125ac8eull,
  0x6f46eadb56c6815bull, 0x195355d84eeebeeeull, 0x9d7389c0a244de3cull,
  0xcf99d01953761abdull, 0x0d76ce39de9ec24bull, 0x2e55ecee70beb181ull,
  0xf56d9d4bd5f86079ull, 0x13ef5a83fb8886fbull, 0x3f3389a4408f43c5ull,
  0x58ccf45cfad37943ull, 0x415c7f3ef82df846ull, 0x8b3d5cf42915e818ull,
  0xf8dbb57a6a445f27ull, 0x8ad803ecca8f0070ull, 0x038f9245b2e87c34ull,
  0xc7c9dee0bedd8a6cull, 0x2ad3fa140eac7d56ull, 0xf775677ce0de0840ull,
  0x92be221ef1bd0ad5ull, 0xce9d04a487fa1fb9ull, 0x3f6f7024d2c36fa9ull,
  0x907855eeb028af62ull, 0x4efac5dcd83e49d6ull, 0x77cd8c6be7151aabull,
  0x0af908b40a753b7dull, 0xe50f30278c983623ull, 0x1d08e2d694222771ull,
  0xf2ee5ca6f7e928e6ull, 0x11eb962b1b61b93cull, 0xce2bcba19648b21cull,
  0x7bbebe3034f77154ull, 0x8ce329ace526a319ull, 0xb5dc53d5de4a74d2ull,
  0x000000000009e8b3ull,

# define TENS_P12_IDX	(TENS_P11_IDX + TENS_P11_SIZE)
# define TENS_P12_SIZE	214
  [TENS_P12_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0xd4724e8d2a67c001ull, 0xf89a1e908efe7ae7ull, 0x54e05154ef084117ull,
  0x506be82913b1bb51ull, 0xe599574efb29b172ull, 0x806c0ed3f0da6146ull,
  0x45155e93b86ae5beull, 0x7e1e7c34c0591cc2ull, 0x1d1f4cce7c4823daull,
  0xd6bfdf759b8ba1e8ull, 0xc2dfae78e341be10ull, 0x0f237f1a016b67b2ull,
  0xaf6a25743dbeabcdull, 0x142e0e80cab3e6d7ull, 0x2c23481161959127ull,
  0xcb4bf98287009701ull, 0x88052f8cf8169c84ull, 0xbc13176168dde6d4ull,
  0x54ab9c41ff0b0905ull, 0x1a1c304e7613b224ull, 0x441c2d473bfe167bull,
  0x78f061814f6cea9cull, 0x30c7ae41eb659fb8ull, 0xa1ebcad7947e0d0eull,
  0x2130504dd97d9556ull, 0xf2acd5071a8309cbull, 0xfd82373a3f8ec72aull,
  0x280f4d3295a842bcull, 0x811a4f04f3618ac0ull, 0xd3967a1b6dc3a5b4ull,
  0xdcfe388f15b8c898ull, 0x8738b909454eb2a0ull, 0x2bd9cc1110c4e996ull,
  0x655fec303297cd0cull, 0xf4090ee8ae0725b1ull, 0x398c6fed037d19eeull,
  0xc994a4503b9af26bull, 0x75a697b2b5341743ull, 0x3ccb5b92ac50b9c1ull,
  0xa8329761ffe06205ull, 0xeb83cadbdfea5242ull, 0x3c20ee69e79dadf7ull,
  0x7021b97a1e0a6817ull, 0x176ca776743074faull, 0xeca19beb77fb8af6ull,
  0xaf63b71292baf1deull, 0xa4eb8f8cde35c88bull, 0x40b464a0e137d5e9ull,
  0x42923bbd87d1cde8ull, 0x2e2690f3cd8f62ffull, 0x59c89f1b095edc16ull,
  0x5138753d1fa8fd5dull, 0x80152f18390a2b29ull, 0xf984d83e2dd8d925ull,
  0xc19e1faf7a872e74ull, 0xecf9b5d0ed4d542dull, 0xc53c0adf9462ea75ull,
  0x37a2d4390caea134ull, 0x2181327ec8fa2e8aull, 0x2d2408206e7bb827ull,
  0x5893d4b850be10e0ull, 0x1f2b2322ab312bb9ull, 0xbf627ede440b3f25ull,
  0xb608b89572dac789ull, 0x86deb3f078787e2aull, 0xbb9373f46fee7aabull,
  0xf7d8b57e27ecf57bull, 0x3d04e8d2fca26a9full, 0x3172826ac9df13cbull,
  0xa8fcd8e0cd9e8d7cull, 0x307641d9b2c39497ull, 0x2608c4cf1cc939c1ull,
  0x3d326a7eb6d1c7bfull, 0x8e13e25feeaf19e6ull, 0x2dfe6d97ee63302bull,
  0xe41d3cc425971d58ull, 0xab8db59a0a80627cull, 0xe90afb779eea37c8ull,
  0x9ee3352c90ca19cfull, 0xfe78d6823613c850ull, 0x5b060904788f6e50ull,
  0x3fecb534b71bd1a4ull, 0x20c33857b32c450cull, 0x0239f4cea6e9cfdaull,
  0xa19adb9548497187ull, 0x95aca6a8b492ed8aull, 0xcf1b23504dcd6cd9ull,
  0x1a67778cfbe8b12aull, 0xc32da38338eb3accull, 0xa03f40a8fb126ab1ull,
  0xe9ce4724ed5bf546ull, 0x73a130d84c4a74fdull, 0xa2ebd6c1d9960e2dull,
  0x6f233b7c94ab6febull, 0x8e7b9a7349126080ull, 0xd298f9994b8c9091ull,
  0xa96ddeff35e836b5ull, 0x6b0dd9bc96119b31ull, 0x282566fbc6cc3f8dull,
  0xd6769f3b72b882e7ull, 0x00fc509ba674343dull, 0xd6266a3fdcbf7789ull,
  0x4e89541bae9641fdull, 0x53400d0311953407ull, 0xe5b533458e0dd75aull,
  0x108b89bc108f19adull, 0xe03b2b6341a4c954ull, 0x97aced8e437b3d7full,
  0x2c5508c2cbd66670ull, 0x5c4f2ef0650ebc69ull, 0x9985a2df904ff6bfull,
  0x5ed8d2399faddd9eull, 0xe3e51cb925585832ull, 0x56c02d9a0ff4f1d4ull,
  0xc1a08a138c4ef804ull, 0xe6d2767113fd01c8ull, 0x9d0176cca7c234f4ull,
  0x4d8bfa89d0d73df2ull, 0x2b17e0b2544f10cdull, 0xfd86fe49b70a5c7dull,
  0x214495bbdf373f41ull, 0x00d313d584e857fdull, 0xa4ba47440496fcbeull,
  0xaec29e6ee8cac982ull, 0x7000a51987ec7038ull, 0xff66e42caeee333bull,
  0x03b4f63b8afd6b25ull, 0x5ab8d9c7bd7991dcull, 0x48741a6c2ed4684eull,
  0x2fdc6349af06940dull, 0xe974996fb03d7ecdull, 0x52ec8721ac7867f9ull,
  0x8edd2d00bcdd9d4aull, 0x41c759f83557de06ull, 0xa75409f23956d4b9ull,
  0xb6100fab123cd8a1ull, 0x2e8d623b3e7b21e2ull, 0xbca35f7792959da2ull,
  0x35fcb457200c03a5ull, 0xf74eb9281bb6c6e4ull, 0x87cc1d213d5d0b54ull,
  0x18ae42404964046full, 0x8bd2b496d868b275ull, 0xc234d8f51c5563f4ull,
  0xf9151ffff868e970ull, 0x271133eeae7be4a2ull, 0x25254932bb0fd922ull,
  0x104bcd64a60a9fc0ull, 0x0000006230290145ull,

# define TENS_P13_IDX	(TENS_P12_IDX + TENS_P12_SIZE)
# define TENS_P13_SIZE	427
  [TENS_P13_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x9f34522664cf8001ull, 0x7b8d5053644963e5ull,
  0xb945c82f49f0aa29ull, 0x933b6bb8430ff478ull, 0x64c501d45ff82d0aull,
  0x9ec1e1b373bbf174ull, 0xe90106893bfbe803ull, 0x3fef8d80f7390d8eull,
  0x2c73446bf31d1325ull, 0x1c19e379f5ca7a92ull, 0xf52d9d9c270af2beull,
  0x3abf72e1eb2bed48ull, 0x7ecf35084ac4ffc2ull, 0x38597a5a22019a82ull,
  0x9a51ff6ebe6a7b3cull, 0x0c0abe9da2d28437ull, 0xc79887ff7c9ec6eaull,
  0x436420d05851c899ull, 0x72b5547fefead581ull, 0x077ad8f899b1d2b5ull,
  0x3b4305ed5cddbf5bull, 0x2d88f3fde3861ac7ull, 0x393220aa3d6b43beull,
  0x1cd62095e5382405ull, 0x87a0d1e161a10c96ull, 0x68c933e6ca95a55dull,
  0x778089bb9ee082e2ull, 0xfbb6d8d441429ee9ull, 0x26cf5471c529500dull,
  0xd6c9b14068b9be29ull, 0x8415185207be635aull, 0x83730335b5572182ull,
  0xdd312d31eb2300b4ull, 0x488da59c05d6dd9bull, 0xda2c2e4037784d25ull,
  0x6a57d7206a8d92faull, 0xf07a8632950b41acull, 0x2ecad06acd55f062ull,
  0x34c98bb0e6a3dfe7ull, 0xb60521b19c767d8full, 0xe87d16be752aafd1ull,
  0xe58a8b0c9de1d728ull, 0x2fa2c119c6013830ull, 0x519b40c83c4f9156ull,
  0xab78701b5058fc8full, 0xc502a554adc59c47ull, 0x6647f04c0fb3286full,
  0x5ea495c89db4076eull, 0xb4f00f8b9c74fab1ull, 0xd092b4c6897c7a3cull,
  0x32f31fa8283e0340ull, 0x67b63de2eeb708ccull, 0xef2bc02b4f7b3c8bull,
  0xc49344c0da14bfe3ull, 0xb6c4e69eaabc85beull, 0x63a110162ece8aa6ull,
  0x726ae4d919cfba4dull, 0xee6ae7070fc90b42ull, 0x4d9aabc54290b04aull,
  0xf34906cdfb2b070eull, 0x52ca97091ff54b0aull, 0x164315700b42bfe1ull,
  0x6b5565bb980f3076ull, 0x9ce63c76eb8c4c4aull, 0x3da24c53b9e4c771ull,
  0xb50e3c666f0266faull, 0x01bb4b9676e34f79ull, 0x0fbea1249948cf3eull,
  0xa1fa4edc86bead12ull, 0xc3b97bf9d11e901cull, 0x370ca58e71730e03ull,
  0x886467e248b19715ull, 0x3c727e24db237497ull, 0x8e67d76e2116ccd2ull,
  0x34bdedd3f973aecfull, 0xb042ab0531d680ecull, 0xfc5c3c17770e96a0ull,
  0xb8204eceab6f1874ull, 0x416c0ced5843f3a5ull, 0x9578018311dd112full,
  0x7e0e8613b1c74bd8ull, 0xa79ffc1096c6453bull, 0xfcd6da0ab2157651ull,
  0x3dd0ccac836a34a7ull, 0x496049ed316e5a36ull, 0xdea1a97d0322bcb2ull,
  0x39578d53cdf2aa5aull, 0x030565c91d1aa931ull, 0x324e0a27d198cbedull,
  0x284325345db83e8aull, 0x5cb134c090bf23e8ull, 0x009e5051dd0adab6ull,
  0x7e36a6d7f8ad61daull, 0xbdffe6aa84c75e57ull, 0x138d680eb5d5532eull,
  0x4a5f74a1bd84ddacull, 0x55538cfaccff00d1ull, 0x48528011b0948b8cull,
  0x9e047ad7e345f82eull, 0xea77bef06ee770ffull, 0x2f1625670fc13669ull,
  0x0614686c869426acull, 0x4263ed823a3ff464ull, 0x57205a7ab3589b47ull,
  0xae6fc46b213f24adull, 0xd92b133f3de03e4eull, 0x1b49c24a315a589bull,
  0x1641c13873381bcbull, 0xbc680ada7bc99425ull, 0x962e9884a5cfbc9aull,
  0xfc8d12f60a960d70ull, 0x60acc868ed18ef4cull, 0x131130369aea5d14ull,
  0x2d99a5b0c747c87eull, 0x006b36583a369bb3ull, 0xe43fa6e6118a5135ull,
  0xa13dc05eb4947190ull, 0x0dbd7170d7733db8ull, 0x117ed7e7c3fb67d1ull,
  0xc05fe99ee2d72a49ull, 0xd971a25b9638db40ull, 0x1a1595594239d468ull,
  0xc1117392850a223cull, 0x567b5fc022d2dbd8ull, 0xc051007a92c5b4ebull,
  0xfb35572011cc0099ull, 0x398481616907810dull, 0x61d19ef25e8534f4ull,
  0x8a0ab03c2ee8c466ull, 0x879aa514c234af76ull, 0x59e5da579774a235ull,
  0xf339bd5a9bc466b3ull, 0xbbb5fd6744ab026dull, 0x3685c9f22b977202ull,
  0x7054359e03e5dc00ull, 0x9ba11f085239cfb0ull, 0x9c258687f8237562ull,
  0x52c7bf8fa3b510ddull, 0x3245e079b31ed0cfull, 0xbaee38c7ff9ff8d3ull,
  0xf702b3b9f17d5562ull, 0xcbca275dcc4c8563ull, 0xe817dbace005d9d1ull,
  0x62cee35005c6920aull, 0x19e049b90f1deac0ull, 0xb2a27a1659599f74ull,
  0x7dcef00df0911d5aull, 0x375522513603dd66ull, 0x5fa022da97813735ull,
  0xefbe57c20d849416ull, 0x5761929630a0e592ull, 0x11735043c953cc47ull,
  0xc0444be0a83526adull, 0x16ff5136b5f8463cull, 0xf037572c2a0a6631ull,
  0xb1bf8daad30464daull, 0x0f3e9e7e7f5718f7ull, 0xc26f2624e5a4cfe7ull,
  0xdfe8f4858c9b5ae4ull, 0xc64a1509f6fa82e3ull, 0x3024b220acb24aeaull,
  0xddcdfeddddb02ac0ull, 0x384c86c3d834c574ull, 0xdd48a571d904e099ull,
  0x77b35c744550a05full, 0xaaebdc6d81e85f71ull, 0xd4cdc0540f9bb0b1ull,
  0x845786af7af4df85ull, 0xdf2a91cae5e53887ull, 0x5689a3c4f6a58211ull,
  0xa705983a8cf6aa15ull, 0x2ce7fef09fbf2f52ull, 0x4a3b536548e84a62ull,
  0xd48a0872f8281a47ull, 0xf0929c3e8423dcf6ull, 0xe9ec071b044a5049ull,
  0x20e30c1b17decc36ull, 0x3342196a45fc2813ull, 0x6601e33746afb7f9ull,
  0xf18094d130754439ull, 0x61410dd1d38b4112ull, 0xd97d4dd8d8796b36ull,
  0x8080519147e9bc0bull, 0xcde438c11584e2daull, 0x409659a1955d24f1ull,
  0x5a09635f1b0950b1ull, 0x615472b965b1febeull, 0x6308e067525dc00aull,
  0xd4e705a44089e2d4ull, 0x32c18b2643fc9209ull, 0xaf2711534447a5faull,
  0x4dc4f0d23617cadcull, 0x6aa116ef692eb386ull, 0x0641dc0b655991bcull,
  0xc655966454469597ull, 0x4bdc0d1a749c0fe8ull, 0xc5292a61a7d3381eull,
  0x42474cc24eb65fdcull, 0x19dfc9eef2c6b173ull, 0xbece2ee30a19a199ull,
  0xaa03aa7cc68b778dull, 0xae54d2bec8db86f0ull, 0xdee3f48fb92a01e0ull,
  0xf6ae28526023c0a9ull, 0xa441cb9ea233763bull, 0x3a8bb4b73246ddddull,
  0x308ef2c844faa3c3ull, 0xd2862534fd1c8516ull, 0x62336f6f3b25ebe7ull,
  0x0b8e2ce60c336a45ull, 0x11eea1f2e867f171ull, 0x68df4903523972ecull,
  0x51ef4cb750c05824ull, 0x3ffae115cb4df2a8ull, 0x3ed1635fb51aca2full,
  0x0a5ac09fd6ff1cc6ull, 0x0a3dc76fde8ed9d6ull, 0x37991dde5dc2d8ddull,
  0x80ad6e13f95bacb2ull, 0xd4f8c7a6163005eeull, 0xa4760f083225d180ull,
  0x9b2b1a875fff004dull, 0x5cd00b66e7ea8576ull, 0x285dd80dec478452ull,
  0x4301b3a120112439ull, 0xfacbb68cff879fc8ull, 0xb17fdf84af6af6b8ull,
  0xf4489576c208d9f1ull, 0xadcc862c8794a6e9ull, 0x931685a40e83e54cull,
  0x1e40293bab01c580ull, 0x1f1ddf7fcad784faull, 0xcee722b26b856084ull,
  0x74254eb41c39938bull, 0xb9c26d9ac7ccebf4ull, 0x2e3ece246b08dfb9ull,
  0xdff60410981455ecull, 0xe06fa38bbc804e2bull, 0x72e53c52b534540cull,
  0xb2a5c05a02dfb2efull, 0x973133385002a2a5ull, 0xd61df455597c53ffull,
  0x39ac2ec534e5261aull, 0x388b7539c6bc0cabull, 0x00eac7043f732fc0ull,
  0xc089971e92fb21d9ull, 0x7af93f8fb4ffa503ull, 0xa8311b2372e353b6ull,
  0x1de496ca8266c9afull, 0xd6fa0b51dbdb16b0ull, 0xbd5630899991a5efull,
  0x0954a1e3168cbe0full, 0x53d09723537b9245ull, 0x86558cb92867272dull,
  0xfac85d100b83f026ull, 0x1e5ddb95f8562951ull, 0x48d27b92ad3668c8ull,
  0x19b58a99c930b7e6ull, 0xa9cda917a3de74e3ull, 0x7a4dd16ecb6e35eeull,
  0x4d84073f4c80e9d5ull, 0x9cffcfc074a95ba8ull, 0x15796372d28485ebull,
  0x77eda8df5717e9cdull, 0xadb965e1ab473c4eull, 0x5bc05659ffad6959ull,
  0xfb2402276ed63880ull, 0xd15fdddf2014850bull, 0xb538f37dfdd74592ull,
  0x1473396f3a8e2e82ull, 0x3ce41a21f6a5edf8ull, 0x754e82640cc4351aull,
  0xc7821b96aab95e73ull, 0xc242faaaf42ff463ull, 0x087e260edd00ac65ull,
  0x0dbe032817d193f5ull, 0xf9d10f96844a63c9ull, 0xbaf127ec85aa91ddull,
  0xce85e6a50ab6dabbull, 0xe7b56a161af5d24full, 0x57d1d79fcd6c5a19ull,
  0xec4dd2f05dfc2b28ull, 0x8d72216a18fe64a1ull, 0x72f14a085f222077ull,
  0x3bf038abd8b09b11ull, 0xc4265d7cc6cf1f44ull, 0x46398d2cdab1b0e7ull,
  0xb6e705d37dcfdc68ull, 0x362c11834aafd1e6ull, 0xf6ac98b7d8701107ull,
  0xd6649424ad114d7eull, 0xddd1c6e4c40ab551ull, 0xc9d284c8a132030full,
  0x824069eedb1f662aull, 0xc846b3ad4157904bull, 0x0a248c17d38481caull,
  0xe8745febc846831full, 0x00000000000025a8ull,

# define TENS_P14_IDX	(TENS_P13_IDX + TENS_P13_SIZE)
# define TENS_P14_SIZE	852
  [TENS_P14_IDX] = 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x0000000000000000ull, 0x0000000000000000ull, 0x0000000000000000ull,
  0x41b5687d099f0001ull, 0x8c75ee63cbfd1b6eull, 0xd75296ad4b191ceaull,
  0x1eb5da9b2394d80aull, 0x5c79fed918a004edull, 0xed67a1b837e3b01cull,
  0x2a1a34d578d9a714ull, 0x6b1d35168fbe7f0dull, 0xa7825681e57c43eaull,
  0xd3e716e1c81d32e8ull, 0xa6d93d6558860b00ull, 0x0113232f83159c97ull,
  0x7321c3a0d6122269ull, 0xca4ca9d3be6a92f3ull, 0xc0e55163d1e276a5ull,
  0x7b7a78c1b05915d6ull, 0x62a3df4b0fae0ca4ull, 0x13030d1108abec6full,
  0x60dcc8f2d446338aull, 0x25e1f9f65f05d1d5ull, 0x7f8c711304a40beeull,
  0x589ff59a88f47ec0ull, 0xea5068a1308c3661ull, 0x06e87dff95fb108full,
  0xd4d4abdc1559e741ull, 0xee16907c01e092e4ull, 0xe73aabcb5a7b78e6ull,
  0xad372889146bb7e0ull, 0xfd49fc1d4f6b43c5ull, 0xd37392530f29f589ull,
  0xe2acfcc2c4745a56ull, 0xedd016cdd75ccbc7ull, 0xef82ccd3ac5a63e0ull,
  0x2bdabfc4b352496eull, 0x01b0197f5b3d0401ull, 0x29d9253dade96d3cull,
  0x73c56b1b19bebdbaull, 0x1f2b7f1e255e7b25ull, 0x6299c836a56a457eull,
  0xa2ca74c65c63cc78ull, 0xee571bea5c85fe93ull, 0x2db5f1d0508e2561ull,
  0xa9b87b99b1fde6a9ull, 0xf7260f074fb90a37ull, 0x56ee7e97ff58c5fdull,
  0x42e6f9cebab9fa46ull, 0x1b76d26778816f73ull, 0x4566519cfdb2c728ull,
  0xb9f6a95fae17dd8dull, 0x67160dea1cd533a1ull, 0xfcd8f8f914534bacull,
  0x708b1f0af3f2901dull, 0x9457a1df8829063bull, 0x36bb93358f872aa1ull,
  0xd889d109b5672c0eull, 0x933066727ec63a6aull, 0x8239ab6839b6d457ull,
  0xbe0d7a1fef2e2506ull, 0x05f655224251b635ull, 0x032868910ef0bd55ull,
  0x9815fbac2c42b664ull, 0x814e379c471fd611ull, 0xa4a25bda7dd8349dull,
  0x01b9e39d9886b84cull, 0xae31cbc95a7ce1a2ull, 0x83ef8faf86d07f32ull,
  0x58470fdfb66b5b76ull, 0x5161888996d59b73ull, 0xfc8e0fc6dc400cf7ull,
  0x09a08e56af693670ull, 0x74f682e191737de6ull, 0x7f8ac56d0e03923full,
  0x8e05e49a7400cfd4ull, 0x384e11644cebea3cull, 0xb50ae05eb2e43d8cull,
  0xa40061230f0b3ed9ull, 0x4e9a193464137137ull, 0xd9621be605404100ull,
  0x5c347ebb9329a255ull, 0xe684346b75cbeb1bull, 0xba6a9753840fee55ull,
  0x60505b7bf43836f6ull, 0xfd6d475d334a9278ull, 0x267375aa5db94761ull,
  0x024f6d63c110e160ull, 0xa99b4c192ec96610ull, 0x338cfd90b915c9f4ull,
  0xb9e51a09f02ea846ull, 0xfae31d88ae928fb1ull, 0x8475dd261a3db721ull,
  0x7ad4c4075769489dull, 0x34e275c80a49e9f0ull, 0x1d63114a3d075d83ull,
  0x6b98e94772a96415ull, 0xd50fdc361d500b5full, 0x87751275141e5085ull,
  0x2278809ee7843834ull, 0x947aead2b15c52eeull, 0x5197b744fedb7b02ull,
  0x8849d0a664e09ba8ull, 0x11ecb91323beaa85ull, 0x5d9848480f7ed667ull,
  0x588290e99f6331eaull, 0x7e09e9e5a24d64d1ull, 0x03a501df32592033ull,
  0xbb3df73827c270a6ull, 0x4190833c3c7c5a70ull, 0x80e5d89b7d4bf9f4ull,
  0xfaefb663a7fc6194ull, 0xd3b6adcd62e52b49ull, 0x1f2cf73a809646fcull,
  0x531e4bfbb765ed4full, 0xaf12d1a692cd05f2ull, 0x38da107422ee30f3ull,
  0x1a725608ed6447bbull, 0x7a3c6f54aff222d3ull, 0x7b0e8d12bca79a56ull,
  0x6e34d6fb1c4660c5ull, 0xfe9dc99c6f481a9full, 0xd8489ea0f888db82ull,
  0xc0dea28184b4c0faull, 0xae30e887977a8583ull, 0x1d4848cb8c1cbcecull,
  0xd011b0fc0ee0d137ull, 0x478d7dd494b5fd49ull, 0xacab62ad3d67f2e7ull,
  0x1dfc7df50ab4e62aull, 0x870b0e75d22e4553ull, 0x1b73bf6d49b7b001ull,
  0xdc9f073712807ffdull, 0xc0e2f2506f3e5852ull, 0x4d96a55a93e62e4aull,
  0x83a126dbc1d0e185ull, 0xefbfd043190b917bull, 0x8f25b6ddc7df1669ull,
  0x476c17a62062eac9ull, 0x25460383cb60f278ull, 0xda8c05be0e85e996ull,
  0x692062346f678a34ull, 0x1947b69af59be929ull, 0x90fd83220ebfa11bull,
  0xd699b1ec15c1e9bfull, 0x7001d002b2f0343full, 0xc0778ab5cf76eaaaull,
  0xb7b008e25173eda8ull, 0x505d3f4d4e00e4c6ull, 0x1c9d4e1299dd341aull,
  0x474c5e954ffb6978ull, 0xda19f9386e9ca6ddull, 0x98dc318ee2dda6e0ull,
  0x3f67b836da455e54ull, 0xa97e9a6421e4181cull, 0x527a08bb1e17f655ull,
  0x682972ad1712dc21ull, 0xccbeadf10042d256ull, 0x861e99e0ca497b96ull,
  0xeeb0f6500d8aa585ull, 0x506af77edcc3c3daull, 0x7c9d60be5deb9768ull,
  0x37b37e95e9d978b7ull, 0x42747f7577ad0b94ull, 0x6d5fd2fe07be42c4ull,
  0x0d8fc27d4c8c5da9ull, 0x0ccf60230f2fd50full, 0x3b1101bd5b56053full,
  0xc0feca2756d34906ull, 0xc4888da47602a150ull, 0x56d10633419abe54ull,
  0x8db14123c76120edull, 0x741e8f76b656e675ull, 0x96be6f21d297b94eull,
  0x9b409e273662439dull, 0x35fff92a6626574dull, 0x69e02439bf558205ull,
  0x6400fd4cbe6838b7ull, 0x1f4b158aa00f64caull, 0x04cca5589e2052aeull,
  0x58da644cfb5ee69eull, 0x8ab1940196f26e1full, 0xed8bf908bee1e16bull,
  0xd50babab2f2809a4ull, 0x6b0a89296e57f7e6ull, 0xb54a4cfcf7356431ull,
  0x6f9fd6cb9a1d0ac4ull, 0x3b42f469836bfbf8ull, 0x40111b6b8bd32129ull,
  0xb345d9557c278fb1ull, 0xd32cd13cff1fd188ull, 0x3789f792f7ec3aa0ull,
  0x4d79a4bfab707fa4ull, 0xd9c24d8eb3a28cebull, 0x06e2eb3e7134dadcull,
  0xb379d811d7c04f76ull, 0x8c94fc332b3b0ebcull, 0xc06c5d01a28b53abull,
  0x7fea91cad900432aull, 0x64845f086d30b008ull, 0xfde4687d796f5349ull,
  0xe0046c56f888fe67ull, 0xce98cb11ae482177ull, 0x1feb440084590c46ull,
  0xff2f16116e1ba29bull, 0x3159ca8cf73f3e9cull, 0x56f0ed4634845918ull,
  0xd9a16a01b7d10c32ull, 0x3cee3e24405b9e91ull, 0x2ab396b48739e4a6ull,
  0x09835dfd3f1b7871ull, 0x1592b74a8c7a489full, 0x0e8d3f3705df7c81ull,
  0x68b29622a61ff273ull, 0x43ff84a6259cd337ull, 0x566ed88381cf8fe9ull,
  0x35c7942848427fc6ull, 0xa97e8c8bcfd2fb59ull, 0x32ddca23750aaed8ull,
  0x96fbfff9aa8108efull, 0xe3cdf588a1d039aaull, 0xcd6b3fdb47e77e00ull,
  0x9a522152e72a9a80ull, 0xef175610eda06283ull, 0x339fe6c4a670cfa1ull,
  0xc2d7f53b2dfbf3eeull, 0xcc47e4b092a44e27ull, 0xd64f83c9dfa212bcull,
  0xb51319bf997e5475ull, 0x1fc2c7b69fffe599ull, 0x832169ddef5605e7ull,
  0xbf921dc8feb6be4eull, 0x72759f8d60bdfb1dull, 0x020eebed3546efa0ull,
  0xdb20a2fecaab3d64ull, 0xb2b62bddba1218f6ull, 0x8fde5cfa3101eff0ull,
  0xa52114d22e319213ull, 0xdf08b1dd87eead3full, 0x746f34d0a5387642ull,
  0x4cc40317d76c4844ull, 0xb7d76071e4f689c9ull, 0x6e1c79155fe0b4a2ull,
  0x3efb7d71c7d43f53ull, 0x35a75f5f068dd906ull, 0x750f4607652d7770ull,
  0x36c2cf8e64a1656cull, 0x9348ef93214d758bull, 0x9674b7f3e4058978ull,
  0xbdfaba8f10570b0bull, 0xa92b261fcef09dd7ull, 0xcbebb81f071c21b6ull,
  0x44228cd6f427ed6cull, 0x5036c46065e56fcfull, 0xccfd848bad919defull,
  0x7527dca361d158a6ull, 0x508550754cf30459ull, 0x3540f5aaa70dfd09ull,
  0xb5ba3d4e35577adbull, 0xcdfb689f35736c4full, 0x97ab0dcaefe8fa82ull,
  0x77a7fe9c51bd2ff3ull, 0x3d618b813107846cull, 0xfc5e9651bca797a4ull,
  0xf7e8791fe2e08fbcull, 0x7c426f9d772f1cc0ull, 0x0080c3ab08d56f88ull,
  0xe6d46ec60deea663ull, 0x6b681d9d7dca4eb7ull, 0x4af0e0f2da06730bull,
  0x52097463038bf468ull, 0xbc09bb9aca19d302ull, 0x3ded4433aa55aeb1ull,
  0x3e4b7865f27938baull, 0x7ef9631428296be7ull, 0xdf0b6b477a1d55ccull,
  0xcedda5bdcde11852ull, 0x72ca1a8bf00a0eb3ull, 0xb002fdcc5241b572ull,
  0xc4878862ff8898b3ull, 0xbf4bca29b3e85372ull, 0xf2d831897e1fef45ull,
  0x3cdf9e050f5427afull, 0xf65c06ac75bae885ull, 0xa3145eac9c71a700ull,
  0x76255bbfde63bab2ull, 0x4c6ad3d06e817be6ull, 0xe95ef2f825ab9935ull,
  0xd54f78de11cd095aull, 0xb3829dcba001ae7eull, 0x18eb9c9e5abd18bdull,
  0xe3e3556cada3c504ull, 0x5191ac5fd35479aaull, 0xc8d1d9d3221821acull,
  0x088c3fc8313a8c51ull, 0xb154abedc146a264ull, 0x349ec09392755bc5ull,
  0x41d5886cf94aba57ull, 0x36aba94b0a5ad8b2ull, 0xa9ad229f883a6758ull,
  0x0546172f5d64069aull, 0xc3808ea40366da16ull, 0x70f0a2350b172403ull,
  0x4fceb827fa816e66ull, 0x167b56d5a65fcfeaull, 0xfec36bcdfe2b9fb2ull,
  0xcd96320fa84c4cc9ull, 0x09eda8b83e128584ull, 0x7ec7e17b91eca525ull,
  0xc14032f4bc45bedcull, 0x2eb20bc09be689a7ull, 0x14ef835fffdf1efcull,
  0xcd778dd8c6966c59ull, 0x23d477155feb0f3bull, 0x5722a550d64b87c8ull,
  0x315a1a8b62883198ull, 0x4b7e9d7a648e17e6ull, 0x67caca842ba43d28ull,
  0x6e660159741f0398ull, 0x3dde3c453e16e1a9ull, 0xc7eb0aefa53e56aeull,
  0x78751d733f39f33eull, 0x626770f745816df8ull, 0x909e87f4cb17d28dull,
  0xc1dcf32893a86abaull, 0xd895d0421a1e4ce2ull, 0xbb00eaf5b9f6dd69ull,
  0xca609578acc37687ull, 0xf8b86d4c5b490d39ull, 0x39419f6df2737ef0ull,
  0x72524a0369267bc0ull, 0xdbc01e936eb060c4ull, 0x83984d54291035b1ull,
  0xe08cbc20f673ad85ull, 0x584803a61fb24915ull, 0x4088ddb5e15bbcd7ull,
  0x2c18041ad4c22542ull, 0xb2ba69b4a51372d1ull, 0xcd11c2962299283full,
  0xac54df2325dcd6f3ull, 0x77e16e1d24a3a55eull, 0xb99d85c0b3cd415bull,
  0xe91154e3497befc7ull, 0xb55100aa7365cd8bull, 0xfc0927a60ee699ebull,
  0x8acaa910efb374deull, 0xda3f000683b40e3dull, 0xc6ce1b758590a089ull,
  0xfda2f7f354f6ff20ull, 0xd0763b6dd2ab58f6ull, 0x2519622d6caf2515ull,
  0x9863638fc3714057ull, 0x09ea4a4dea00bb4full, 0x6b01fe5fe69de96dull,
  0x529e32ec960161a5ull, 0x01a37eeaf8260ae9ull, 0x5aa0716f69710577ull,
  0x4260fedacb3fb1daull, 0x76012f75a33fb790ull, 0x130f09ae24c0e5beull,
  0x5c8ecb762e8323dcull, 0x401b5f5c17cb8f12ull, 0x47e1560a5f0a63e0ull,
  0xee1377d4dc57a786ull, 0x0aa294b9228e7ee5ull, 0x55b0fe2faea6c534ull,
  0xf108b772922d318aull, 0xdfb69702f15bddf6ull, 0x90e1db66cd438a4eull,
  0x568ef6cb584ce4a1ull, 0x6da376ba69e55f9dull, 0x45c7e2945ca6c109ull,
  0xcf5b6c0cc977b3e9ull, 0x11b487ae1d694499ull, 0xbcb3cc6ecf8339acull,
  0x046b107150b828e0ull, 0x2c6159465703ed0dull, 0xa908dbd0720d1610ull,
  0x22c076e2742bbe33ull, 0x1d0cefa448966a66ull, 0x601352bf1dde819full,
  0xa585cc4ab9370c39ull, 0x5a2f7206eb857f94ull, 0x49cd0f1f3fae6b58ull,
  0x1b89d47678e5fb3dull, 0xed82945b74e9e65bull, 0x2941c4d9b74e6483ull,
  0x565c18dc7e087accull, 0xbf4ccd3d1a09f2e5ull, 0xa522631dd304e977ull,
  0x4517109b6123378eull, 0x4bf1a506b7e4285aull, 0x683172f8625803c2ull,
  0x3f8a2b11c84e7354ull, 0xed4204917dd12b89ull, 0x9853fb978c698b0bull,
  0xb697e1c99631777bull, 0x510381105f028f05ull, 0x30e255e39055f055ull,
  0xb990321ee2d0c1b6ull, 0xff4dc144a8fdf4d1ull, 0x148999e0521a3056ull,
  0xa9c96852a8111c66ull, 0x4b394a948157f508ull, 0x94ec2e93a0dc4df1ull,
  0x8fc283776e6afa56ull, 0xc435186ff72ffa04ull, 0x8d037f6ff91488b7ull,
  0x48757727a899ec1eull, 0xb8cf377d4101b612ull, 0xb4570569a5a54e68ull,
  0x063d9cfd2ac5a0a0ull, 0xf1a5884c7c504c74ull, 0x8d0b91bf0a9b1955ull,
  0x79ff5361e5f6862full, 0xc6fd31fb0ed3d38full, 0x85b9c6489fe131c7ull,
  0x8e77e86b8febf2b4ull, 0x56429986992ba80eull, 0x608cdda56848879aull,
  0x754b300e3e0d106eull, 0xafd5195b25200576ull, 0xe81f09395d37aad9ull,
  0xdeeea20ae00a390eull, 0xb5d51155f5fef0beull, 0x9e72ebcf6e27d173ull,
  0xb966f7bab776e978ull, 0x726c840809520238ull, 0x65dce5a23347ebc5ull,
  0x8c92d7403ec78337ull, 0x32caec933cdde3feull, 0x411be811d20379aeull,
  0x72fa1bbd41756580ull, 0x84c42f04a92125b3ull, 0x3a25922cdd4ee5feull,
  0x49ad3be096446853ull, 0x1c841afe2880366dull, 0xfb905fe1f1e09019ull,
  0x3ba9d0c9a451ad59ull, 0xa42419f256db2e9cull, 0x3c9a3ca5e921e7a0ull,
  0xcec7d091ad8ea375ull, 0x477ef58f99bdb940ull, 0xb2598b8d8a4933c7ull,
  0xcfac1e1cf5659df7ull, 0xe2a04aab339f8748ull, 0x45bc6f37e122b03full,
  0x9c75aaa0c9feeb30ull, 0x0ea0585dc13c174eull, 0x3a96bd5adc58bbb4ull,
  0x3c7a714d20251482ull, 0x6cb83b6b696897ebull, 0x3b496b5fa37de406ull,
  0x380dd38237e75d6aull, 0xda26fac90e1a513cull, 0x12b5c6eaf2458364ull,
  0x1ff1fcbf79ce9e47ull, 0x59a6a7babe7c6e86ull, 0x947614538d70f515ull,
  0x8768ffb26b04e425ull, 0x3f9e84071ca5f425ull, 0x5f8f67563b641184ull,
  0x56bc212062b1a5a5ull, 0x17f2fa18d1e5da68ull, 0xa1bc9c068cce5e2dull,
  0x892df1af8e290fb1ull, 0xb43e5517ad10b8c8ull, 0x4407c38fd0597409ull,
  0xfea9c9b64a020d81ull, 0xd5b2aaf9d8e0e7d6ull, 0xda44ed4ade5e9b40ull,
  0x87aa3ca045d6bf41ull, 0x4708acc8c62d12fcull, 0x0d1227ff10212e26ull,
  0x5da02550feeb5742ull, 0x1d56e5e1d66668e7ull, 0xae1e0bef32c215ecull,
  0x58c0e9227f048b7eull, 0x58251aac2aea8619ull, 0xa1fea536bbe10425ull,
  0xd233eb7d2e1d9667ull, 0xb0693c67cf435c0bull, 0x903ec9f061d918eaull,
  0x0efb1788d6c4e8acull, 0x1709d878b0098f5bull, 0x3f6ce1b73c12b35eull,
  0x8a8f7dbba1b3ff54ull, 0x73e8563e37608d6aull, 0x64e00749a3330540ull,
  0x8d5caaf9ebbfcab9ull, 0xedb2bd943bc87c7eull, 0xe656dec322f8f62dull,
  0x670c1626c5683222ull, 0x4237542f94089e7full, 0x2fc4e53047d29440ull,
  0x8b288dac8419441eull, 0xa7afb4e97f9245f9ull, 0x082adef78a15650dull,
  0x043c62de3104ef19ull, 0x7ecd06350aff3dc5ull, 0xe0600fade7e80a8bull,
  0x81ebf4e04d8e81ccull, 0x7b372af7f587e30full, 0xdee11c6f2d8f8ca0ull,
  0xf8adc426d3624b1cull, 0x5c22de4fca9debedull, 0xfae3186b3634f778ull,
  0xd7bfa75facf8b595ull, 0xbbfe3cf6003cd316ull, 0xc51055a1b023cb50ull,
  0x93869a770063cffdull, 0xfbceeb1051e022d4ull, 0x109defc95187457eull,
  0xe13cfde2673892d8ull, 0xc09c8134d4aa3272ull, 0x0327181bbf89ad5bull,
  0xaa21b63209511ec7ull, 0xe41885b5d7e72186ull, 0x493d278946713f9cull,
  0xd5d22a5c1386c526ull, 0xcf59281ccefddfc4ull, 0x4ebe43f692973ea6ull,
  0x6cf4897deac5c6adull, 0x82ce562ad95082a0ull, 0x28d8f0db28e5e9bdull,
  0x707b0166ddf06e81ull, 0xfbf5756a7dae3f00ull, 0x4f114102035a4680ull,
  0x5190fedfe7ba4b33ull, 0xe5f1bc49106a7594ull, 0xd7a1a766aae3ad67ull,
  0x9120a214040ee971ull, 0x1edc87eaf415b374ull, 0xc6ad637d17aab43cull,
  0xd90303c7885858c1ull, 0x3ff4eb0ebfd4b70bull, 0xd81eea30344a9a88ull,
  0x5adef0ec95925446ull, 0x20bbd8c3abb5f5e7ull, 0xe6944262c1c22cceull,
  0x80024021c5acdb23ull, 0x94b30c812232c635ull, 0x78569acd55f07648ull,
  0x4dd6b5289696ea39ull, 0xde5853b31c3e1b40ull, 0x6eb5a7d88a2c3679ull,
  0x8f9cf09656bda89aull, 0x6481c7e7fda86d5bull, 0x15bfb45d50a6a7d5ull,
  0xc057d45d4f9a5381ull, 0xa0009f004fb10024ull, 0xac420f745e1ca0ddull,
  0xf0d4a615cfbb38bdull, 0x0e3aef8419bf0318ull, 0x166c1e3ecb3d7b20ull,
  0x3bfacf9f58272fddull, 0x63a13528c0f5ce46ull, 0xa020ca8cea59e333ull,
  0x3dbb5a3daadd116bull, 0x747f55eae5523f47ull, 0x64d520fb0922171eull,
  0x07ce951b6c709e84ull, 0x7508eb6d35fdc402ull, 0xb0d11c39c495a8faull,
  0x57447ef081313d65ull, 0xf72301f3a7b61e26ull, 0x45a3a7c5bb096315ull,
  0x00432f88a903a44bull, 0xeb4e1b6619081987ull, 0x6d245171bb7b66bdull,
  0x0d89bd0bde4182f5ull, 0xf70d8a6087f4de6cull, 0x08a274499a87855bull,
  0xd49640174ac7720aull, 0x4db3488cb0d9ddacull, 0xd07b745bfe397d44ull,
  0x6e9d567d197dcb7bull, 0x9143fef1e3b90812ull, 0x115ff96db9e002acull,
  0x5b61c9c8f60a2201ull, 0xb14a44a709abab2full, 0x843c79970ca19c73ull,
  0x5e3fc18ce3a9bbe6ull, 0x764df59d0c0404eeull, 0x4ad0ba3c990ec2c2ull,
  0xe599647d05e8be0full, 0x4d0c2990c19d365dull, 0xb680a72de5a9d9acull,
  0x6d6c02674ce2e5ddull, 0xbd6078e006f9c25bull, 0xd742fa41b5fcdc81ull,
  0xc691adc0cccc2399ull, 0xea73b0c3215ad82cull, 0xf499e0a6a511e5b0ull,
  0xd94440a253e27ab0ull, 0x9a6e364447752521ull, 0x8f8b301dab113708ull,
  0x00000000058a42a3ull,
#endif
};

#else
# error "mp_limb_t size " BITS_PER_MP_LIMB "not accounted for"
#endif

/* Each of array variable above defines one mpn integer which is a power of 10.
   This table points to those variables, indexed by the exponent.  */

const struct mp_power _fpioconst_pow10[FPIOCONST_POW10_ARRAY_SIZE] =
{
  { TENS_P0_IDX, TENS_P0_SIZE,		4,	     },
  { TENS_P1_IDX, TENS_P1_SIZE,		7,	   4 },
  { TENS_P2_IDX, TENS_P2_SIZE,		14,	  10 },
  { TENS_P3_IDX, TENS_P3_SIZE,		27,	  24 },
  { TENS_P4_IDX, TENS_P4_SIZE,		54,	  50 },
  { TENS_P5_IDX, TENS_P5_SIZE,		107,	 103 },
  { TENS_P6_IDX, TENS_P6_SIZE,		213,	 210 },
  { TENS_P7_IDX, TENS_P7_SIZE,		426,	 422 },
  { TENS_P8_IDX, TENS_P8_SIZE,  	851,	 848 },
  { TENS_P9_IDX, TENS_P9_SIZE,	 	1701,	1698 },
  { TENS_P10_IDX, TENS_P10_SIZE,	3402,	3399 },
#if !defined __NO_LONG_DOUBLE_MATH && __LDBL_MAX_EXP__ > 1024
  { TENS_P11_IDX, TENS_P11_SIZE,	6804,	6800 },
  { TENS_P12_IDX, TENS_P12_SIZE,	13607,	13604 },
  { TENS_P13_IDX, TENS_P13_SIZE,	27214,	27210 },
  { TENS_P14_IDX, TENS_P14_SIZE,	54427,	54424 },
#endif
};
