/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.24
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON

#ifndef SWIG_TEMPLATE_DISAMBIGUATOR
#  if defined(__SUNPRO_CC) 
#    define SWIG_TEMPLATE_DISAMBIGUATOR template
#  else
#    define SWIG_TEMPLATE_DISAMBIGUATOR 
#  endif
#endif


#include <Python.h>

/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "1"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
#define SWIG_QUOTE_STRING(x) #x
#define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
#define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
#define SWIG_TYPE_TABLE_NAME
#endif

#include <string.h>

#ifndef SWIGINLINE
#if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#  define SWIGINLINE inline
#else
#  define SWIGINLINE
#endif
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/
#ifndef SWIGRUNTIME
#define SWIGRUNTIME static
#endif
#ifndef SWIGRUNTIMEINLINE
#define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Register a type mapping with the type-checking
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeRegisterTL(swig_type_info **tl, swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *tl;
  while (tc) {
    /* check simple type equivalence */
    int typeequiv = (strcmp(tc->name, ti->name) == 0);   
    /* check full type equivalence, resolving typedefs */
    if (!typeequiv) {
      /* only if tc is not a typedef (no '|' on it) */
      if (tc->str && ti->str && !strstr(tc->str,"|")) {
	typeequiv = SWIG_TypeEquiv(ti->str,tc->str);
      }
    }
    if (typeequiv) {
      /* Already exists in the table.  Just add additional types to the list */
      if (ti->clientdata) tc->clientdata = ti->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *tl;
  *tl = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;

  return ret;
}

/*
  Check the typename
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/*
  Search for a swig_type_info structure
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryTL(swig_type_info *tl, const char *name) {
  swig_type_info *ty = tl;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientDataTL(swig_type_info *tl, swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata) return;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = tl;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientDataTL(tl,tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register int d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/*
  This function will propagate the clientdata field of type to any new
  swig_type_info structures that have been added into the list of
  equivalent types.  It is like calling SWIG_TypeClientData(type,
  clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientDataTL(swig_type_info *tl, swig_type_info *type) {
  swig_type_info *equiv = type->next;
  swig_type_info *tc;
  if (!type->clientdata) return;
  while (equiv) {
    if (!equiv->converter) {
      tc = tl;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0) && !tc->clientdata)
          SWIG_TypeClientDataTL(tl,tc, type->clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/


#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if !defined(STATIC_LINKED)
#    define SWIGEXPORT(a) __declspec(dllexport) a
#  else
#    define SWIGEXPORT(a) a
#  endif
#else
#  define SWIGEXPORT(a) a
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*************************************************************************/


/* The static type info list */

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;
  

/* Register a type mapping with the type-checking */
static swig_type_info *
SWIG_TypeRegister(swig_type_info *ti) {
  return SWIG_TypeRegisterTL(swig_type_list_handle, ti);
}

/* Search for a swig_type_info structure */
static swig_type_info *
SWIG_TypeQuery(const char *name) {
  return SWIG_TypeQueryTL(*swig_type_list_handle, name);
}

/* Set the clientdata field for a type */
static void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientDataTL(*swig_type_list_handle, ti, clientdata);
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
static void
SWIG_PropagateClientData(swig_type_info *type) {
  SWIG_PropagateClientDataTL(*swig_type_list_handle, type);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * SWIG API. Portion that goes into the runtime
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * for internal method declarations
 * ----------------------------------------------------------------------------- */

#ifndef SWIGINTERN
#define SWIGINTERN static 
#endif

#ifndef SWIGINTERNSHORT
#ifdef __cplusplus
#define SWIGINTERNSHORT static inline 
#else /* C case */
#define SWIGINTERNSHORT static 
#endif /* __cplusplus */
#endif


/*
  Exception handling in wrappers
*/
#define SWIG_fail                goto fail
#define SWIG_arg_fail(arg)       SWIG_Python_ArgFail(arg)
#define SWIG_append_errmsg(msg)   SWIG_Python_AddErrMesg(msg,0)
#define SWIG_preppend_errmsg(msg) SWIG_Python_AddErrMesg(msg,1)
#define SWIG_type_error(type,obj) SWIG_Python_TypeError(type,obj)
#define SWIG_null_ref(type)       SWIG_Python_NullRef(type)

/*
  Contract support
*/
#define SWIG_contract_assert(expr, msg) \
 if (!(expr)) { PyErr_SetString(PyExc_RuntimeError, (char *) msg ); goto fail; } else

/* -----------------------------------------------------------------------------
 * Constant declarations
 * ----------------------------------------------------------------------------- */

/* Constant Types */
#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;


/* -----------------------------------------------------------------------------
 * Alloc. memory flags
 * ----------------------------------------------------------------------------- */
#define SWIG_OLDOBJ  1
#define SWIG_NEWOBJ  SWIG_OLDOBJ + 1
#define SWIG_PYSTR   SWIG_NEWOBJ + 1

#ifdef __cplusplus
}
#endif


/***********************************************************************
 * pyrun.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags)    SWIG_Python_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags)       SWIG_Python_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags)  SWIG_Python_MustGetPtr(p, type, argnum, flags)
 

/* Python-specific SWIG API */
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags)   SWIG_Python_ConvertPacked(obj, ptr, sz, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type)              SWIG_Python_NewPackedObj(ptr, sz, type)


/* -----------------------------------------------------------------------------
 * Pointer declarations
 * ----------------------------------------------------------------------------- */
/*
  Use SWIG_NO_COBJECT_TYPES to force the use of strings to represent
  C/C++ pointers in the python side. Very useful for debugging, but
  not always safe.
*/
#if !defined(SWIG_NO_COBJECT_TYPES) && !defined(SWIG_COBJECT_TYPES)
#  define SWIG_COBJECT_TYPES
#endif

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * Create a new pointer string 
 * ----------------------------------------------------------------------------- */

#ifndef SWIG_BUFFER_SIZE
#define SWIG_BUFFER_SIZE 1024
#endif

#if defined(SWIG_COBJECT_TYPES)
#if !defined(SWIG_COBJECT_PYTHON)
/* -----------------------------------------------------------------------------
 * Implements a simple Swig Object type, and use it instead of PyCObject
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *ptr;
  const char *desc;
} PySwigObject;

/* Declarations for objects of type PySwigObject */

SWIGRUNTIME int
PySwigObject_print(PySwigObject *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result))) {
    fputs("<Swig Object at ", fp); fputs(result, fp); fputs(">", fp);
    return 0; 
  } else {
    return 1; 
  }
}
  
SWIGRUNTIME PyObject *
PySwigObject_repr(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromFormat("<Swig Object at %s>", result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_str(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromString(result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_long(PySwigObject *v)
{
  return PyLong_FromUnsignedLong((unsigned long) v->ptr);
}

SWIGRUNTIME PyObject *
PySwigObject_oct(PySwigObject *v)
{
  char buf[100];
  unsigned long x = (unsigned long)v->ptr;
  if (x == 0)
    strcpy(buf, "0");
  else
    PyOS_snprintf(buf, sizeof(buf), "0%lo", x);
  return PyString_FromString(buf);
}

SWIGRUNTIME PyObject *
PySwigObject_hex(PySwigObject *v)
{
  char buf[100];
  PyOS_snprintf(buf, sizeof(buf), "0x%lx", (unsigned long)v->ptr);
  return PyString_FromString(buf);
}

SWIGRUNTIME int
PySwigObject_compare(PySwigObject *v, PySwigObject *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return c;
  } else {
    void *i = v->ptr;
    void *j = w->ptr;
    return (i < j) ? -1 : (i > j) ? 1 : 0;
  }
}

SWIGRUNTIME void
PySwigObject_dealloc(PySwigObject *self)
{
  PyObject_DEL(self);
}

SWIGRUNTIME PyTypeObject*
PySwigObject_GetType() {
  static char PySwigObject_Type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  
  static PyNumberMethods PySwigObject_as_number = {
    (binaryfunc)0, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)0, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0, /*nb_remainder*/
    (binaryfunc)0, /*nb_divmod*/
    (ternaryfunc)0,/*nb_power*/
    (unaryfunc)0,  /*nb_negative*/
    (unaryfunc)0,  /*nb_positive*/
    (unaryfunc)0,  /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    0,		   /*nb_invert*/
    0,		   /*nb_lshift*/
    0,		   /*nb_rshift*/
    0,		   /*nb_and*/
    0,		   /*nb_xor*/
    0,		   /*nb_or*/
    (coercion)0,   /*nb_coerce*/
    (unaryfunc)PySwigObject_long, /*nb_int*/
    (unaryfunc)PySwigObject_long, /*nb_long*/
    (unaryfunc)0,                 /*nb_float*/
    (unaryfunc)PySwigObject_oct,  /*nb_oct*/
    (unaryfunc)PySwigObject_hex,  /*nb_hex*/
#if PY_VERSION_HEX >= 0x02000000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_true_divide */ 
#endif
  };

  static int type_init = 0;  
  static PyTypeObject PySwigObject_Type;

  if (!type_init) {
    PyTypeObject tmp = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    "PySwigObject",			/*tp_name*/
    sizeof(PySwigObject),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigObject_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigObject_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigObject_compare,	/*tp_compare*/
    (reprfunc)PySwigObject_repr,	/*tp_repr*/
    &PySwigObject_as_number,	        /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigObject_str,		/*tp_str*/
    /* Space for future expansion */
    0L,0L,0L,0L,
    PySwigObject_Type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };

    PySwigObject_Type = tmp;
    type_init = 1;
  }

  return &PySwigObject_Type;
}

SWIGRUNTIME PyObject *
PySwigObject_FromVoidPtrAndDesc(void *ptr, const char *desc)
{
  PySwigObject *self = PyObject_NEW(PySwigObject, PySwigObject_GetType());
  if (self == NULL) return NULL;
  self->ptr = ptr;
  self->desc = desc;
  return (PyObject *)self;
}

SWIGRUNTIMEINLINE void *
PySwigObject_AsVoidPtr(PyObject *self)
{
  return ((PySwigObject *)self)->ptr;
}

SWIGRUNTIMEINLINE const char *
PySwigObject_GetDesc(PyObject *self)
{
  return ((PySwigObject *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigObject_Check(PyObject *op) {
  return ((op)->ob_type == PySwigObject_GetType()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigObject") == 0);
}

/* -----------------------------------------------------------------------------
 * Implements a simple Swig Packed type, and use it instead of string
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *pack;
  const char *desc;
  size_t size;
} PySwigPacked;

SWIGRUNTIME int
PySwigPacked_print(PySwigPacked *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  fputs("<Swig Packed ", fp); 
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    fputs("at ", fp); 
    fputs(result, fp); 
  }
  fputs(v->desc,fp); 
  fputs(">", fp);
  return 0; 
}
  
SWIGRUNTIME PyObject *
PySwigPacked_repr(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    return PyString_FromFormat("<Swig Packed at %s%s>", result, v->desc);
  } else {
    return PyString_FromFormat("<Swig Packed %s>", v->desc);
  }  
}

SWIGRUNTIME PyObject *
PySwigPacked_str(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))){
    return PyString_FromFormat("%s%s", result, v->desc);
  } else {
    return PyString_FromFormat("%s", v->desc);
  }  
}

SWIGRUNTIME int
PySwigPacked_compare(PySwigPacked *v, PySwigPacked *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return c;
  } else {
    size_t i = v->size;
    size_t j = w->size;
    int s = (i < j) ? -1 : (i > j) ? 1 : 0;
    return s ? s : strncmp((char *)v->pack, (char *)w->pack, 2*v->size);
  }
}

SWIGRUNTIME void
PySwigPacked_dealloc(PySwigPacked *self)
{
  free(self->pack);
  PyObject_DEL(self);
}

SWIGRUNTIME PyTypeObject*
PySwigPacked_GetType() {
  static char PySwigPacked_Type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  static int type_init = 0;
  
  static PyTypeObject PySwigPacked_Type;
  if (!type_init) {
    PyTypeObject tmp = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    "PySwigPacked",			/*tp_name*/
    sizeof(PySwigPacked),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigPacked_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigPacked_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigPacked_compare,	/*tp_compare*/
    (reprfunc)PySwigPacked_repr,	/*tp_repr*/
    0,	                                /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigPacked_str,		/*tp_str*/
    /* Space for future expansion */
    0L,0L,0L,0L,
    PySwigPacked_Type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000         
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };

    PySwigPacked_Type = tmp;
    type_init = 1;
  }
  
      

  return &PySwigPacked_Type;
}

SWIGRUNTIME PyObject *
PySwigPacked_FromDataAndDesc(void *ptr, size_t size, const char *desc)
{
  PySwigPacked *self = PyObject_NEW(PySwigPacked, PySwigPacked_GetType());
  if (self == NULL) {
    return NULL;
  } else {
    void *pack = malloc(size);
    memcpy(pack, ptr, size);
    self->pack = pack;
    self->desc = desc;
    self->size = size;
    return (PyObject *) self;
  }
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_UnpackData(PyObject *obj, void *ptr, size_t size)
{
  PySwigPacked *self = (PySwigPacked *)obj;
  if (self->size != size) return 0;
  memcpy(ptr, self->pack, size);
  return self->desc;
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_GetDesc(PyObject *self)
{
  return ((PySwigPacked *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigPacked_Check(PyObject *op) {
  return ((op)->ob_type == PySwigPacked_GetType()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigPacked") == 0);
}

#else
/* -----------------------------------------------------------------------------
 * Use the old Python PyCObject instead of PySwigObject
 * ----------------------------------------------------------------------------- */

#define PySwigObject_GetDesc(obj)	           PyCObject_GetDesc(obj)
#define PySwigObject_Check(obj)	           PyCObject_Check(obj)
#define PySwigObject_AsVoidPtr(obj)	   PyCObject_AsVoidPtr(obj)
#define PySwigObject_FromVoidPtrAndDesc(p, d)  PyCObject_FromVoidPtrAndDesc(p, d, NULL)

#endif

#endif

/* -----------------------------------------------------------------------------
 * errors manipulation
 * ----------------------------------------------------------------------------- */

SWIGRUNTIME void
SWIG_Python_TypeError(const char *type, PyObject *obj)
{
  if (type) {
#if defined(SWIG_COBJECT_TYPES)
    if (PySwigObject_Check(obj)) {
      const char *otype = (const char *) PySwigObject_GetDesc(obj);
      if (otype) {
	PyErr_Format(PyExc_TypeError, "a '%s' is expected, 'PySwigObject(%s)' is received",
		     type, otype);
	return;
      }
    } else 
#endif      
    {
      const char *otype = (obj ? obj->ob_type->tp_name : 0); 
      if (otype) {
	PyObject *str = PyObject_Str(obj);
	const char *cstr = str ? PyString_AsString(str) : 0;
	if (cstr) {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s(%s)' is received",
		       type, otype, cstr);
	} else {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s' is received",
		       type, otype);
	}
	Py_DECREF(str);
	return;
      }
    }   
    PyErr_Format(PyExc_TypeError, "a '%s' is expected", type);
  } else {
    PyErr_Format(PyExc_TypeError, "unexpected type is received");
  }
}

SWIGRUNTIMEINLINE void
SWIG_Python_NullRef(const char *type)
{
  if (type) {
    PyErr_Format(PyExc_TypeError, "null reference of type '%s' was received",type);
  } else {
    PyErr_Format(PyExc_TypeError, "null reference was received");
  }
}

SWIGRUNTIME int
SWIG_Python_AddErrMesg(const char* mesg, int infront)
{
  if (PyErr_Occurred()) {
    PyObject *type = 0;
    PyObject *value = 0;
    PyObject *traceback = 0;
    PyErr_Fetch(&type, &value, &traceback);
    if (value) {
      PyObject *old_str = PyObject_Str(value);
      Py_XINCREF(type);
      PyErr_Clear();
      if (infront) {
	PyErr_Format(type, "%s %s", mesg, PyString_AsString(old_str));
      } else {
	PyErr_Format(type, "%s %s", PyString_AsString(old_str), mesg);
      }
      Py_DECREF(old_str);
    }
    return 1;
  } else {
    return 0;
  }
}

SWIGRUNTIME int
SWIG_Python_ArgFail(int argnum)
{
  if (PyErr_Occurred()) {
    /* add information about failing argument */
    char mesg[256];
    sprintf(mesg, "argument number %d:", argnum);
    return SWIG_Python_AddErrMesg(mesg, 1);
  } else {
    return 0;
  }
}


/* -----------------------------------------------------------------------------
 * pointers/data manipulation
 * ----------------------------------------------------------------------------- */

/* Convert a pointer value */
SWIGRUNTIME int
SWIG_Python_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  const char *c = 0;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;
  void *vptr;
  
  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }

#ifdef SWIG_COBJECT_TYPES
  if (!(PySwigObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PySwigObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  vptr = PySwigObject_AsVoidPtr(obj);
  c = (const char *) PySwigObject_GetDesc(obj);
  if (newref) { Py_DECREF(obj); }
  goto type_check;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AS_STRING(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackVoidPtr(c, &vptr, ty->name);
  if (newref) { Py_DECREF(obj); }
  if (!c) goto type_error;
#endif

type_check:

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,vptr);
  } else {
    *ptr = vptr;
  }

  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
    PyObject_SetAttrString(pyobj,(char*)"thisown",Py_False);
  }
  return 0;

type_error:
  PyErr_Clear();
  if (pyobj && !obj) {    
    obj = pyobj;
    if (PyCFunction_Check(obj)) {
      /* here we get the method pointer for callbacks */
      char *doc = (((PyCFunctionObject *)obj) -> m_ml -> ml_doc);
      c = doc ? strstr(doc, "swig_ptr: ") : 0;
      if (c) {
	c = SWIG_UnpackVoidPtr(c + 10, &vptr, ty->name);
	if (!c) goto type_error;
	goto type_check;
      }
    }
  }
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ pointer", obj);
    }
  }
  return -1;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME void *
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int argnum, int flags) {
  void *result;
  if (SWIG_Python_ConvertPtr(obj, &result, ty, flags) == -1) {
    PyErr_Clear();
    if (flags & SWIG_POINTER_EXCEPTION) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
      SWIG_Python_ArgFail(argnum);
    }
  }
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME int
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, size_t sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  const char *c = 0;

#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  c = PySwigPacked_UnpackData(obj, ptr, sz);
#else
  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AS_STRING(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackDataName(c, ptr, sz, ty->name);
#endif
  if (!c) goto type_error;
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:
  PyErr_Clear();
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ packed data", obj);
    }
  }
  return -1;
}  

/* Create a new array object */
SWIGRUNTIME PyObject *
SWIG_Python_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj = 0;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PySwigObject_FromVoidPtrAndDesc((void *) ptr, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackVoidPtr(result, ptr, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
        PyObject_SetAttrString(inst,(char*)"thisown",Py_True);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME PyObject *
SWIG_Python_NewPackedObj(void *ptr, size_t sz, swig_type_info *type) {
  PyObject *robj = 0;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  robj = PySwigPacked_FromDataAndDesc((void *) ptr, sz, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackDataName(result, ptr, sz, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  return robj;
}

/* -----------------------------------------------------------------------------*
 *  Get type list 
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
void *SWIG_ReturnGlobalTypeList(void *);
#endif

SWIGRUNTIME swig_type_info **
SWIG_Python_GetTypeListHandle() {
  static void *type_pointer = (void *)0;
  /* first check if module already created */
  if (!type_pointer) {
#ifdef SWIG_LINK_RUNTIME
    type_pointer = SWIG_ReturnGlobalTypeList((void *)0);
#else
    type_pointer = PyCObject_Import((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				    (char*)"type_pointer" SWIG_TYPE_TABLE_NAME);
    if (PyErr_Occurred()) {
      PyErr_Clear();
      type_pointer = (void *)0;
    }
  }
#endif
  return (swig_type_info **) type_pointer;
}

/*
  Search for a swig_type_info structure
 */
SWIGRUNTIMEINLINE swig_type_info *
SWIG_Python_GetTypeList() {
  swig_type_info **tlh = SWIG_Python_GetTypeListHandle();
  return tlh ? *tlh : (swig_type_info*)0;
}

#define SWIG_Runtime_GetTypeList SWIG_Python_GetTypeList 

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_cdio_read_mode_t swig_types[0] 
#define  SWIGTYPE_p_CdIo_t swig_types[1] 
#define  SWIGTYPE_p_char swig_types[2] 
#define  SWIGTYPE_size_t swig_types[3] 
#define  SWIGTYPE_p_long swig_types[4] 
#define  SWIGTYPE_p_unsigned_int swig_types[5] 
#define  SWIGTYPE_ptrdiff_t swig_types[6] 
#define  SWIGTYPE_p_int swig_types[7] 
#define  SWIGTYPE_p_off_t swig_types[8] 
static swig_type_info *swig_types[10];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= _pycdio.so
  ------------------------------------------------*/
#define SWIG_init    init_pycdio

#define SWIG_name    "_pycdio"

/* Includes the header in the wrapper code */
#include <cdio/cdio.h>
#include <cdio/audio.h>
#include <cdio/cd_types.h>


/* When libcdio version > 0.76 comes out this won't be needed. */
#include <cdio/version.h>
#if LIBCDIO_VERSION_NUM <= 76

/**< Masks derived from above... */
#undef CDIO_DRIVE_CAP_WRITE_DVD
#define CDIO_DRIVE_CAP_WRITE_DVD (               \
      CDIO_DRIVE_CAP_WRITE_DVD_R                 \
    | CDIO_DRIVE_CAP_WRITE_DVD_PR                \
    | CDIO_DRIVE_CAP_WRITE_DVD_RAM               \
    | CDIO_DRIVE_CAP_WRITE_DVD_RW                \
    | CDIO_DRIVE_CAP_WRITE_DVD_RPW               \
    ) 

/** All the different ways a block/sector can be read. */
typedef enum {
  CDIO_READ_MODE_AUDIO,  /**< CD-DA, audio, Red Book */
  CDIO_READ_MODE_M1F1,   /**< Mode 1 Form 1 */
  CDIO_READ_MODE_M1F2,   /**< Mode 1 Form 2 */
  CDIO_READ_MODE_M2F1,   /**< Mode 2 Form 1 */
  CDIO_READ_MODE_M2F2,   /**< Mode 2 Form 2 */
} cdio_read_mode_t;

/*!
  Reads a number of sectors (AKA blocks).
  
  @param p_buf place to read data into. The caller should make sure
  this location is large enough. See below for size information.
  @param read_mode the kind of "mode" to use in reading.
  @param i_lsn sector to read
  @param i_blocks number of sectors to read
  @return DRIVER_OP_SUCCESS (0) if no error, other (negative) enumerations
  are returned on error.
  
  If read_mode is CDIO_MODE_AUDIO,
    *p_buf should hold at least CDIO_FRAMESIZE_RAW * i_blocks bytes.

  If read_mode is CDIO_MODE_DATA,
    *p_buf should hold at least i_blocks times either ISO_BLOCKSIZE, 
    M1RAW_SECTOR_SIZE or M2F2_SECTOR_SIZE depending on the kind of 
    sector getting read. If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is M2RAW_SECTOR_SIZE.

  If read_mode is CDIO_MODE_M2F1,
    *p_buf should hold at least M2RAW_SECTOR_SIZE * i_blocks bytes.

  If read_mode is CDIO_MODE_M2F2,
    *p_buf should hold at least CDIO_CD_FRAMESIZE * i_blocks bytes.


*/
driver_return_code_t 
cdio_read_sectors(const CdIo_t *p_cdio, void *p_buf, lsn_t i_lsn, 
                  cdio_read_mode_t read_mode, uint32_t i_blocks)
{
  switch(read_mode) {
  case CDIO_READ_MODE_AUDIO:
    return cdio_read_audio_sectors (p_cdio, p_buf, i_lsn, i_blocks);
  case CDIO_READ_MODE_M1F1:
    return cdio_read_mode1_sectors (p_cdio, p_buf, i_lsn, false, i_blocks);
  case CDIO_READ_MODE_M1F2:
    return cdio_read_mode1_sectors (p_cdio, p_buf, i_lsn, true,  i_blocks);
  case CDIO_READ_MODE_M2F1:
    return cdio_read_mode2_sectors (p_cdio, p_buf, i_lsn, false, i_blocks);
  case CDIO_READ_MODE_M2F2:
    return cdio_read_mode2_sectors (p_cdio, p_buf, i_lsn, true,  i_blocks);
  }
  /* Can't happen. Just to shut up gcc. */
  return DRIVER_OP_ERROR; 
}

driver_return_code_t
cdio_eject_media_drive (const char *psz_drive)
{
  CdIo_t *p_cdio = cdio_open (psz_drive, DRIVER_DEVICE);
  if (p_cdio) {
    return cdio_eject_media(&p_cdio);
  } else {
    return DRIVER_OP_UNINIT;
  }
}
#endif /* LIBCDIO_VERSION_NUM <= 76 */


  /*@/usr/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_int PyInt_FromLong
/*@@*/


#include <limits.h>


SWIGINTERN int
  SWIG_CheckLongInRange(long value, long min_value, long max_value,
			const char *errmsg)
{
  if (value < min_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %ld is less than '%s' minimum %ld", 
		   value, errmsg, min_value);
    }
    return 0;    
  } else if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %ld is greater than '%s' maximum %ld", 
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
}


SWIGINTERN int
  SWIG_AsVal_long(PyObject * obj, long* val)
{
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    long v = PyLong_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (val) {
    SWIG_type_error("long", obj);
  }
  return 0;
 }


#if INT_MAX != LONG_MAX
SWIGINTERN int
  SWIG_AsVal_int(PyObject *obj, int *val)
{ 
  const char* errmsg = val ? "int" : (char*)0;
  long v;
  if (SWIG_AsVal_long(obj, &v)) {
    if (SWIG_CheckLongInRange(v, INT_MIN,INT_MAX, errmsg)) {
      if (val) *val = (int)(v);
      return 1;
    } else {
      return 0;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNSHORT int
  SWIG_AsVal_int(PyObject *obj, int *val)
{
  return SWIG_AsVal_long(obj,(long*)val);
}
#endif


SWIGINTERNSHORT int
SWIG_As_int(PyObject* obj)
{
  int v;
  if (!SWIG_AsVal_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(int));
  }
  return v;
}


SWIGINTERNSHORT int
  SWIG_CheckUnsignedLongInRange(unsigned long value,
				unsigned long max_value,
				const char *errmsg) 
{
  if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %lu is greater than '%s' minimum %lu",
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
 }


SWIGINTERN int
  SWIG_AsVal_unsigned_SS_long(PyObject *obj, unsigned long *val) 
{
  if (PyInt_Check(obj)) {
    long v = PyInt_AS_LONG(obj);
    if (v >= 0) {
      if (val) *val = v;
      return 1;
    }   
  }
  if (PyLong_Check(obj)) {
    unsigned long v = PyLong_AsUnsignedLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  } 
  if (val) {
    SWIG_type_error("unsigned long", obj);
  }
  return 0;
}


#if UINT_MAX != ULONG_MAX
SWIGINTERN int
  SWIG_AsVal_unsigned_SS_int(PyObject *obj, unsigned int *val)
{ 
  const char* errmsg = val ? "unsigned int" : (char*)0;
  unsigned long v;
  if (SWIG_AsVal_unsigned_SS_long(obj, &v)) {
    if (SWIG_CheckUnsignedLongInRange(v, INT_MAX, errmsg)) {
      if (val) *val = (unsigned int)(v);
      return 1;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNSHORT unsigned int
  SWIG_AsVal_unsigned_SS_int(PyObject *obj, unsigned int *val)
{
  return SWIG_AsVal_unsigned_SS_long(obj,(unsigned long *)val);
}
#endif


SWIGINTERNSHORT unsigned int
SWIG_As_unsigned_SS_int(PyObject* obj)
{
  unsigned int v;
  if (!SWIG_AsVal_unsigned_SS_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(unsigned int));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_int(PyObject* obj)
{
  return SWIG_AsVal_int(obj, (int*)0);
}

  
SWIGINTERNSHORT int
SWIG_Check_unsigned_SS_int(PyObject* obj)
{
  return SWIG_AsVal_unsigned_SS_int(obj, (unsigned int*)0);
}


  /*@/usr/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_long PyInt_FromLong
/*@@*/


/* returns SWIG_OLDOBJ if the input is a raw char*, SWIG_PYSTR if is a PyString */
SWIGINTERN int
SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize)
{
  static swig_type_info* pchar_info = 0;
  char* vptr = 0;
  if (!pchar_info) pchar_info = SWIG_TypeQuery("char *");
  if (SWIG_ConvertPtr(obj, (void**)&vptr, pchar_info, 0) != -1) {
    if (cptr) *cptr = vptr;
    if (psize) *psize = vptr ? (strlen(vptr) + 1) : 0;
    return SWIG_OLDOBJ;
  } else {
    PyErr_Clear();
    if (PyString_Check(obj)) {
      if (cptr) {
	*cptr = PyString_AS_STRING(obj);
	if (psize) {
	  *psize = PyString_GET_SIZE(obj) + 1;
	}
      }
      return SWIG_PYSTR;
    }
  }
  if (cptr) {
    SWIG_type_error("char *", obj);
  }
  return 0;
}


SWIGINTERNSHORT int
SWIG_AsCharPtr(PyObject *obj, char **val)
{
  if (SWIG_AsCharPtrAndSize(obj, val, (size_t*)(0))) {
    return 1;
  }
  if (val) {
    PyErr_Clear();
    SWIG_type_error("char *", obj);
  }
  return 0;
}


driver_return_code_t audio_play_lsn (CdIo_t *p_cdio, lsn_t start_lsn,
				     lsn_t end_lsn)
{
  msf_t start_msf;
  msf_t end_msf;
  cdio_lsn_to_msf (start_lsn, &start_msf);
  cdio_lsn_to_msf (end_lsn, &end_msf);
  return cdio_audio_play_msf(p_cdio, &start_msf, &end_msf);
}


SWIGINTERN PyObject*
t_output_helper(PyObject* target, PyObject* o) {
  if (!target) {
    target = o;
  } else if (target == Py_None) {  
    Py_DECREF(target);
    target = o;
  } else {
    if (!PyList_Check(target)) {
      PyObject *o2 = target;
      target = PyList_New(1);
      PyList_SetItem(target, 0, o2);
    }
    PyList_Append(target,o);
    }
  return target;
}


ssize_t
read_cd(const CdIo_t *p_cdio, char *p_buf, ssize_t *pi_size) 
{
  *pi_size = cdio_read(p_cdio, p_buf, *pi_size);
  return *pi_size;
}



ssize_t read_sectors(const CdIo_t *p_cdio, char *p_buf, ssize_t *pi_size, 
		     lsn_t i_lsn, cdio_read_mode_t read_mode)
{
  
  driver_return_code_t drc;
  uint32_t i_blocks;
  uint16_t i_blocksize;
  switch (read_mode) {
  case CDIO_READ_MODE_AUDIO: 
    i_blocksize = CDIO_CD_FRAMESIZE_RAW;
    break;
  case CDIO_READ_MODE_M1F1: 
    i_blocksize = M2RAW_SECTOR_SIZE;
    break;
  case CDIO_READ_MODE_M1F2: 
    i_blocksize = M2RAW_SECTOR_SIZE;
    break;
  case CDIO_READ_MODE_M2F1: 
    i_blocksize = CDIO_CD_FRAMESIZE;
    break;
  case CDIO_READ_MODE_M2F2: 
    i_blocksize = M2F2_SECTOR_SIZE;
    break;
  default: 
    pi_size = NULL;
    return DRIVER_OP_BAD_PARAMETER;
  }

  i_blocks = *pi_size / i_blocksize;
  drc = cdio_read_sectors(p_cdio, p_buf, i_lsn, read_mode, i_blocks);
  if (drc < 0) {
    pi_size = NULL;
    return drc;
  }
  return *pi_size;
}


ssize_t read_data_bytes(const CdIo_t *p_cdio, char *p_buf, ssize_t *pi_size, 
			lsn_t i_lsn, int16_t i_blocksize)
{
  driver_return_code_t drc;
  uint32_t i_blocks = *pi_size / i_blocksize;

  switch (i_blocksize) {
  case CDIO_CD_FRAMESIZE:
  case CDIO_CD_FRAMESIZE_RAW:
  case M2F2_SECTOR_SIZE:
  case M2RAW_SECTOR_SIZE:
    break;
  default:
    /* Don't know about these block sizes */
    pi_size = NULL;
    return DRIVER_OP_BAD_PARAMETER;
  }
  
#if DEBUGGING  
  printf("p_cdio: %x, i_size: %d, lsn: %d, blocksize %d, blocks %d\n",
	 p_cdio, *pi_size, i_lsn, i_blocksize, i_blocks);
#endif
  drc = cdio_read_data_sectors (p_cdio, p_buf, i_lsn, 
				i_blocksize, i_blocks);
#if DEBUGGING  
  printf("drc: %d\n", drc);
#endif
  if (drc < 0) {
    pi_size = NULL;
    return drc;
  }
  return *pi_size;
}


SWIGINTERNSHORT PyObject* 
  SWIG_From_unsigned_SS_long(unsigned long value)
{
  return (value > LONG_MAX) ?
    PyLong_FromUnsignedLong(value) 
    : PyInt_FromLong((long)(value)); 
}


#if UINT_MAX < LONG_MAX
/*@/usr/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_unsigned_SS_int SWIG_From_long
/*@@*/
#else
/*@/usr/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_unsigned_SS_int SWIG_From_unsigned_SS_long
/*@@*/
#endif


SWIGINTERN PyObject *
SWIG_FromCharPtr(const char* cptr)
{ 
  if (cptr) {
    size_t size = strlen(cptr);
    if (size > INT_MAX) {
      return SWIG_NewPointerObj((char*)(cptr), 
				SWIG_TypeQuery("char *"), 0);
    } else {
      if (size != 0) {
	return PyString_FromStringAndSize(cptr, size);
      } else {
	return PyString_FromString(cptr);
      }
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}


SWIGINTERNSHORT PyObject*
  SWIG_From_bool(bool value)
{
  PyObject *obj = value ? Py_True : Py_False;
  Py_INCREF(obj);
  return obj;
}


const char 
*get_track_format(const CdIo_t *p_cdio, track_t i_track) 
{
  track_format_t track_format = cdio_get_track_format(p_cdio, i_track);
  return track_format2str[track_format];
}


typedef char ** DeviceList_t;



driver_return_code_t 
eject_media (CdIo_t *p_cdio) 
{
  /* libcdio routines uses a Cdio_t **p_cdio, so we have to pass in
     something it can clobber.
   */
  CdIo_t **pp_cdio = &p_cdio;
  return cdio_eject_media (pp_cdio);
}


SWIGINTERNSHORT long
SWIG_As_long(PyObject* obj)
{
  long v;
  if (!SWIG_AsVal_long(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(long));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_long(PyObject* obj)
{
  return SWIG_AsVal_long(obj, (long*)0);
}



char *
get_default_device_driver(driver_id_t driver_id, driver_id_t *p_out_driver_id)
{
  *p_out_driver_id = driver_id;
  return cdio_get_default_device_driver(p_out_driver_id);
}


DeviceList_t get_devices_ret (driver_id_t driver_id, 
			      driver_id_t *p_out_driver_id) {
  *p_out_driver_id = driver_id;
  return cdio_get_devices_ret (p_out_driver_id);
 }


SWIGINTERN int
  SWIG_AsVal_bool(PyObject *obj, bool *val)
{
  if (obj == Py_True) {
    if (val) *val = true;
    return 1;
  }
  if (obj == Py_False) {
    if (val) *val = false;
    return 1;
  }
  int res = 0;
  if (SWIG_AsVal_int(obj, &res)) {    
    if (val) *val = res ? true : false;
    return 1;
  } else {
    PyErr_Clear();
  }  
  if (val) {
    SWIG_type_error("bool", obj);
  }
  return 0;
}


SWIGINTERNSHORT bool
SWIG_As_bool(PyObject* obj)
{
  bool v;
  if (!SWIG_AsVal_bool(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(bool));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_bool(PyObject* obj)
{
  return SWIG_AsVal_bool(obj, (bool*)0);
}


DeviceList_t 
get_devices_with_cap (unsigned int capabilities, bool b_any) {
  /* FIXME: ? libcdio allows one to specify a list (char **) of devices
     to search. Don't know how to do that via SWIG though. */
  return cdio_get_devices_with_cap (NULL, (cdio_fs_anal_t) capabilities,
				    b_any);
 }


DeviceList_t
get_devices_with_cap_ret (unsigned int capabilities, bool b_any,
			  driver_id_t *p_out_driver_id) {
  /* FIXME: ? libcdio allows one to specify a list (char **) of devices
     to search. Don't know how to do that via SWIG though. */
  return cdio_get_devices_with_cap_ret (NULL, 
					(cdio_fs_anal_t) capabilities, b_any, 
					p_out_driver_id);
 }



int
have_driver (unsigned int driver_id)
{
  if (driver_id < CDIO_MIN_DRIVER || driver_id > CDIO_MAX_DRIVER)
    return -1;
  if (cdio_have_driver(driver_id)) return 1;
  return 0;
}


/*! True if CD-ROM understand ATAPI commands. */
bool 
have_ATAPI (CdIo_t *p_cdio)
{
  return cdio_have_atapi(p_cdio) == yep;
}


bool 
is_device(const char *psz_source, driver_id_t driver_id)
{
  if (DRIVER_UNKNOWN == driver_id || DRIVER_DEVICE == driver_id) {
    char *psz_drive = cdio_get_default_device_driver(&driver_id);
    /* We don't need the psz_drive, just the driver_id */
    free(psz_drive); 
  }
  return cdio_is_device(psz_source, driver_id);
}


int get_hwinfo ( const CdIo_t *p_cdio, 
		 char *vendor, char *model, char *revision ) 
{
  /** There's a bug somewhere here. If we take off the static,
      we clobber our parameters. So get_hwinfo sizes must not
      agree.
   **/
  static cdio_hwinfo_t hw_info;
  bool b_got_hwinfo = cdio_get_hwinfo(p_cdio, &hw_info);

  if (b_got_hwinfo) {
    strncpy(vendor, hw_info.psz_vendor, CDIO_MMC_HW_VENDOR_LEN);
    strncpy(model, hw_info.psz_model, CDIO_MMC_HW_MODEL_LEN);
    strncpy(revision, hw_info.psz_revision, CDIO_MMC_HW_REVISION_LEN);
  }

  return b_got_hwinfo;
}



/* FIXME: Instead of a static variable drc which doesn't allow for
   multiple threads, we should change the C code to return the status
   parameter and have the exception handling code work off of this.
   Although this is easily done in C and the SWIG-generated C wrapper
   code, I don't the SWIG lingo to make the generated C wrapper do
   this.

   Basically, we need a way to tell SWIG not to translate the %inline
   C code return value into a Python return value, but save the value
   anyway to pick it value up in the SWIG %exception.
*/
static driver_return_code_t drc = DRIVER_OP_SUCCESS;

static void 
set_python_errstring(driver_return_code_t drc) 
{
  switch(drc) {
    case DRIVER_OP_SUCCESS: 
      break;
    case DRIVER_OP_ERROR:
      PyErr_SetString(PyExc_IOError, "driver I/O error.");
      break;
    case DRIVER_OP_UNINIT:
      PyErr_SetString(PyExc_IOError, "driver not initialized.");
      break;
    case DRIVER_OP_UNSUPPORTED:
      PyErr_SetString(PyExc_IOError, "driver operatation not supported.");
      break;
    case DRIVER_OP_NOT_PERMITTED:
      PyErr_SetString(PyExc_IOError, "driver operatation not permitted.");
      break;
    case DRIVER_OP_BAD_PARAMETER:
      PyErr_SetString(PyExc_IOError, "bad parameter passed.");
      break;
    case DRIVER_OP_BAD_POINTER:
      PyErr_SetString(PyExc_IOError, "bad pointer to memory area.");
      break;
    case DRIVER_OP_NO_DRIVER:
      PyErr_SetString(PyExc_IOError, "driver not available.");
      break;
    default:
      PyErr_SetString(PyExc_IOError, "unknown error.");
      break;
  }
 }
 
CdIo_t *open_cd(const char *psz_source, driver_id_t driver_id, 
		const char *psz_access_mode) {
  /* FIXME: On error we return a funny "NULL" Object.
   */
  CdIo_t *p_cdio = cdio_open_am(psz_source, driver_id, psz_access_mode);
  if (NULL == p_cdio) {
    drc = DRIVER_OP_ERROR;
  } else {
    drc = DRIVER_OP_SUCCESS;
  }
  return p_cdio;
 }


const char *
get_disc_mode (CdIo_t *p_cdio) 
{
  discmode_t discmode = cdio_get_discmode(p_cdio);
  if (CDIO_DISC_MODE_ERROR == discmode) return NULL;
  return discmode2str[discmode];
}


#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_cdio_read_sectors(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    void *arg2 = (void *) 0 ;
    lsn_t arg3 ;
    cdio_read_mode_t arg4 ;
    unsigned int arg5 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:cdio_read_sectors",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(2);SWIG_fail;
        }
    }
    {
        arg3 = (lsn_t)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (cdio_read_mode_t)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (unsigned int)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (driver_return_code_t)cdio_read_sectors((CdIo_t const *)arg1,arg2,arg3,(cdio_read_mode_t )arg4,arg5);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_cdio_eject_media_drive(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) 0 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:cdio_eject_media_drive",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (driver_return_code_t)cdio_eject_media_drive((char const *)arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_audio_pause(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:audio_pause",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (driver_return_code_t)cdio_audio_pause(arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_audio_play_lsn(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    lsn_t arg2 ;
    lsn_t arg3 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:audio_play_lsn",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (lsn_t)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (lsn_t)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (driver_return_code_t)audio_play_lsn(arg1,arg2,arg3);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_audio_resume(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:audio_resume",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (driver_return_code_t)cdio_audio_resume(arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_audio_stop(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:audio_stop",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (driver_return_code_t)cdio_audio_stop(arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_lseek(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    off_t arg2 ;
    int arg3 = (int) SEEK_SET ;
    off_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:lseek",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        off_t * argp;
        SWIG_Python_ConvertPtr(obj1, (void **)&argp, SWIGTYPE_p_off_t, SWIG_POINTER_EXCEPTION);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (argp == NULL) {
            SWIG_null_ref("off_t");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = *argp;
    }
    if (obj2) {
        {
            arg3 = (int)(SWIG_As_int(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = cdio_lseek((CdIo_t const *)arg1,arg2,arg3);
    
    {
        off_t * resultptr;
        resultptr = (off_t *) malloc(sizeof(off_t));
        memmove(resultptr, &result, sizeof(off_t));
        resultobj = SWIG_NewPointerObj((void *)(resultptr), SWIGTYPE_p_off_t, 1);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_read_cd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 = (char *) 0 ;
    ssize_t *arg3 = (ssize_t *) 0 ;
    ssize_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:read_cd",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        int n = PyInt_AsLong(obj1);
        if (SWIG_arg_fail(2)) SWIG_fail;
        
        
        
        
        arg2 = (char *) malloc(n+1);
        arg3 = (ssize_t *) malloc(sizeof(ssize_t));
        
        *arg3 = n;
    }
    result = (ssize_t)read_cd((CdIo_t const *)arg1,arg2,arg3);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    {
        PyObject *o;
        o = PyString_FromStringAndSize(arg2,*arg3);
        resultobj = t_output_helper(resultobj,o);
        
        
        
        
        free(arg2);
        free(arg3);
        
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_read_sectors(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 = (char *) 0 ;
    ssize_t *arg3 = (ssize_t *) 0 ;
    lsn_t arg4 ;
    cdio_read_mode_t arg5 ;
    ssize_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:read_sectors",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        int n = PyInt_AsLong(obj1);
        if (SWIG_arg_fail(2)) SWIG_fail;
        
        
        
        
        arg2 = (char *) malloc(n+1);
        arg3 = (ssize_t *) malloc(sizeof(ssize_t));
        
        *arg3 = n;
    }
    {
        arg4 = (lsn_t)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (cdio_read_mode_t)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (ssize_t)read_sectors((CdIo_t const *)arg1,arg2,arg3,arg4,(cdio_read_mode_t )arg5);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    {
        PyObject *o;
        o = PyString_FromStringAndSize(arg2,*arg3);
        resultobj = t_output_helper(resultobj,o);
        
        
        
        
        free(arg2);
        free(arg3);
        
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_read_data_bytes(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 = (char *) 0 ;
    ssize_t *arg3 = (ssize_t *) 0 ;
    lsn_t arg4 ;
    int16_t arg5 ;
    ssize_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:read_data_bytes",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        int n = PyInt_AsLong(obj1);
        if (SWIG_arg_fail(2)) SWIG_fail;
        
        
        
        
        arg2 = (char *) malloc(n+1);
        arg3 = (ssize_t *) malloc(sizeof(ssize_t));
        
        *arg3 = n;
    }
    {
        arg4 = (lsn_t)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (int16_t)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (ssize_t)read_data_bytes((CdIo_t const *)arg1,arg2,arg3,arg4,arg5);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    {
        PyObject *o;
        o = PyString_FromStringAndSize(arg2,*arg3);
        resultobj = t_output_helper(resultobj,o);
        
        
        
        
        free(arg2);
        free(arg3);
        
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_first_track_num(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_first_track_num",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (track_t)cdio_get_first_track_num((CdIo_t const *)arg1);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_last_track_num(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_last_track_num",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (track_t)cdio_get_last_track_num((CdIo_t const *)arg1);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    lsn_t arg2 ;
    track_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (lsn_t)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (track_t)cdio_get_track((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_channels(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_channels",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (int)cdio_get_track_channels((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_copy_permit(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    track_flag_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_copy_permit",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (track_flag_t)cdio_get_track_copy_permit((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_format(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_format",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (char *)get_track_format((CdIo_t const *)arg1,arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_track_green(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:is_track_green",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (bool)cdio_get_track_green((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_last_lsn(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    lsn_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_last_lsn",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (lsn_t)cdio_get_track_last_lsn((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_lba(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    lba_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_lba",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (lba_t)cdio_get_track_lba((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_lsn(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    lsn_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_lsn",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (lsn_t)cdio_get_track_lsn((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_preemphasis(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    track_flag_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_preemphasis",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (track_flag_t)cdio_get_track_preemphasis((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_track_sec_count(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t arg2 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_track_sec_count",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (track_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (unsigned int)cdio_get_track_sec_count((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_close_tray(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) NULL ;
    driver_id_t *arg2 = (driver_id_t *) NULL ;
    driver_return_code_t result;
    driver_id_t temp2 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"|OO:close_tray",&obj0,&obj1)) goto fail;
    if (obj0) {
        if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    if (obj1) {
        {
            if (!(SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_long,0) != -1)) {
                temp2 = SWIG_As_int(obj1);
                if (SWIG_arg_fail(2)) SWIG_fail;
                arg2 = &temp2;
                res2 = SWIG_NEWOBJ;
            }
        }
    }
    result = (driver_return_code_t)cdio_close_tray((char const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_int((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_long, 0)));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_close(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:close",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    cdio_destroy(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_eject_media(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:eject_media",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (driver_return_code_t)eject_media(arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_eject_media_drive(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) NULL ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"|O:eject_media_drive",&obj0)) goto fail;
    if (obj0) {
        if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    result = (driver_return_code_t)cdio_eject_media_drive((char const *)arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_arg(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_arg",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (char *)cdio_get_arg((CdIo_t const *)arg1,(char const (*))arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_device(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) NULL ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"|O:get_device",&obj0)) goto fail;
    if (obj0) {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (char *)cdio_get_default_device((CdIo_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_default_device_driver(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    driver_id_t arg1 ;
    driver_id_t *arg2 = (driver_id_t *) 0 ;
    char *result;
    driver_id_t temp2 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2; res2 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"O:get_default_device_driver",&obj0)) goto fail;
    {
        arg1 = (driver_id_t)(SWIG_As_long(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (char *)get_default_device_driver(arg1,arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_long((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_long, 0)));
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_devices(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    driver_id_t arg1 ;
    DeviceList_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_devices",&obj0)) goto fail;
    {
        arg1 = (driver_id_t)(SWIG_As_long(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (DeviceList_t)cdio_get_devices(arg1);
    
    {
        // result is of type DeviceList_t
        char **p   = result;
        if (!result) goto fail;
        
        /* For each element in the array of strings, push that
             * onto the result object. */
        for (p = result; *p; p++) {
            PyObject *o = PyString_FromString(*p);
            resultobj = t_output_helper(resultobj,o);
        }
    }
    cdio_free_device_list(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_devices_ret(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    driver_id_t arg1 ;
    driver_id_t *arg2 = (driver_id_t *) 0 ;
    DeviceList_t result;
    driver_id_t temp2 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2; res2 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"O:get_devices_ret",&obj0)) goto fail;
    {
        arg1 = (driver_id_t)(SWIG_As_long(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (DeviceList_t)get_devices_ret(arg1,arg2);
    
    {
        // result is of type DeviceList_t
        char **p   = result;
        if (!result) goto fail;
        
        /* For each element in the array of strings, push that
             * onto the result object. */
        for (p = result; *p; p++) {
            PyObject *o = PyString_FromString(*p);
            resultobj = t_output_helper(resultobj,o);
        }
    }
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_long((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_long, 0)));
    cdio_free_device_list(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_devices_with_cap(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    unsigned int arg1 ;
    bool arg2 ;
    DeviceList_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_devices_with_cap",&obj0,&obj1)) goto fail;
    {
        arg1 = (unsigned int)(SWIG_As_unsigned_SS_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        arg2 = (bool)(SWIG_As_bool(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (DeviceList_t)get_devices_with_cap(arg1,arg2);
    
    {
        // result is of type DeviceList_t
        char **p   = result;
        if (!result) goto fail;
        
        /* For each element in the array of strings, push that
             * onto the result object. */
        for (p = result; *p; p++) {
            PyObject *o = PyString_FromString(*p);
            resultobj = t_output_helper(resultobj,o);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_devices_with_cap_ret(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    unsigned int arg1 ;
    bool arg2 ;
    driver_id_t *arg3 = (driver_id_t *) 0 ;
    DeviceList_t result;
    driver_id_t temp3 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    arg3 = &temp3; res3 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"OO:get_devices_with_cap_ret",&obj0,&obj1)) goto fail;
    {
        arg1 = (unsigned int)(SWIG_As_unsigned_SS_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        arg2 = (bool)(SWIG_As_bool(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (DeviceList_t)get_devices_with_cap_ret(arg1,arg2,arg3);
    
    {
        // result is of type DeviceList_t
        char **p   = result;
        if (!result) goto fail;
        
        /* For each element in the array of strings, push that
             * onto the result object. */
        for (p = result; *p; p++) {
            PyObject *o = PyString_FromString(*p);
            resultobj = t_output_helper(resultobj,o);
        }
    }
    resultobj = t_output_helper(resultobj, ((res3 == SWIG_NEWOBJ) ?
    SWIG_From_long((*arg3)) : SWIG_NewPointerObj((void*)(arg3), SWIGTYPE_p_long, 0)));
    cdio_free_device_list(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_drive_cap__SWIG_0(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    unsigned int *arg3 = (unsigned int *) 0 ;
    unsigned int *arg4 = (unsigned int *) 0 ;
    unsigned int temp2 ;
    int res2 = 0 ;
    unsigned int temp3 ;
    int res3 = 0 ;
    unsigned int temp4 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2; res2 = SWIG_NEWOBJ;
    arg3 = &temp3; res3 = SWIG_NEWOBJ;
    arg4 = &temp4; res4 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"O:get_drive_cap",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    cdio_get_drive_cap((CdIo_t const *)arg1,arg2,arg3,arg4);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_unsigned_SS_int((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_unsigned_int, 0)));
    resultobj = t_output_helper(resultobj, ((res3 == SWIG_NEWOBJ) ?
    SWIG_From_unsigned_SS_int((*arg3)) : SWIG_NewPointerObj((void*)(arg3), SWIGTYPE_p_unsigned_int, 0)));
    resultobj = t_output_helper(resultobj, ((res4 == SWIG_NEWOBJ) ?
    SWIG_From_unsigned_SS_int((*arg4)) : SWIG_NewPointerObj((void*)(arg4), SWIGTYPE_p_unsigned_int, 0)));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_drive_cap__SWIG_1(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) NULL ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    unsigned int *arg3 = (unsigned int *) 0 ;
    unsigned int *arg4 = (unsigned int *) 0 ;
    unsigned int temp2 ;
    int res2 = 0 ;
    unsigned int temp3 ;
    int res3 = 0 ;
    unsigned int temp4 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2; res2 = SWIG_NEWOBJ;
    arg3 = &temp3; res3 = SWIG_NEWOBJ;
    arg4 = &temp4; res4 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"|O:get_drive_cap",&obj0)) goto fail;
    if (obj0) {
        if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    cdio_get_drive_cap_dev((char const *)arg1,arg2,arg3,arg4);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_unsigned_SS_int((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_unsigned_int, 0)));
    resultobj = t_output_helper(resultobj, ((res3 == SWIG_NEWOBJ) ?
    SWIG_From_unsigned_SS_int((*arg3)) : SWIG_NewPointerObj((void*)(arg3), SWIGTYPE_p_unsigned_int, 0)));
    resultobj = t_output_helper(resultobj, ((res4 == SWIG_NEWOBJ) ?
    SWIG_From_unsigned_SS_int((*arg4)) : SWIG_NewPointerObj((void*)(arg4), SWIGTYPE_p_unsigned_int, 0)));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_drive_cap(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_get_drive_cap__SWIG_1(self,args);
        }
        _v = SWIG_AsCharPtr(argv[0], (char **)(0));
        if (_v) {
            return _wrap_get_drive_cap__SWIG_1(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_CdIo_t, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_get_drive_cap__SWIG_0(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'get_drive_cap'");
    return NULL;
}


static PyObject *_wrap_get_driver_name(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_driver_name",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        result = (char *)cdio_get_driver_name((CdIo_t const *)arg1);
        
        if (NULL == result) {
            PyErr_SetString(PyExc_IOError, "Error getting driver name.");
            return NULL;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_driver_id(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    driver_id_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_driver_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (driver_id_t)cdio_get_driver_id((CdIo_t const *)arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_last_session(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    lsn_t *arg2 = (lsn_t *) 0 ;
    driver_return_code_t result;
    lsn_t temp2 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2; res2 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"O:get_last_session",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (driver_return_code_t)cdio_get_last_session(arg1,arg2);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_int((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_int, 0)));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_have_driver(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    unsigned int arg1 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:have_driver",&obj0)) goto fail;
    {
        arg1 = (unsigned int)(SWIG_As_unsigned_SS_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (int)have_driver(arg1);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_have_ATAPI(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:have_ATAPI",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (bool)have_ATAPI(arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_binfile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_binfile",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (char *)cdio_is_binfile((char const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_cuefile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_cuefile",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (char *)cdio_is_cuefile((char const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_device(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) 0 ;
    driver_id_t arg2 = (driver_id_t) DRIVER_UNKNOWN ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:is_device",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    if (obj1) {
        {
            arg2 = (driver_id_t)(SWIG_As_long(obj1)); 
            if (SWIG_arg_fail(2)) SWIG_fail;
        }
    }
    result = (bool)is_device((char const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_nrg(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_nrg",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (bool)cdio_is_nrg((char const *)arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_tocfile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_tocfile",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (bool)cdio_is_tocfile((char const *)arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_media_changed(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_media_changed",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)cdio_get_media_changed(arg1);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_hwinfo(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    int result;
    char temp2[CDIO_MMC_HW_VENDOR_LEN+1] ;
    char temp3[CDIO_MMC_HW_MODEL_LEN+1] ;
    char temp4[CDIO_MMC_HW_REVISION_LEN+1] ;
    PyObject * obj0 = 0 ;
    
    {
        arg2 = (char *) temp2;
    }
    {
        arg3 = (char *) temp3;
    }
    {
        arg4 = (char *) temp4;
    }
    if(!PyArg_ParseTuple(args,(char *)"O:get_hwinfo",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)get_hwinfo((CdIo_t const *)arg1,arg2,arg3,arg4);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    {
        PyObject *o;
        arg2[CDIO_MMC_HW_VENDOR_LEN] = 0;
        o = PyString_FromString(arg2);
        resultobj = t_output_helper(resultobj,o);
    }
    {
        PyObject *o;
        arg3[CDIO_MMC_HW_MODEL_LEN] = 0;
        o = PyString_FromString(arg3);
        resultobj = t_output_helper(resultobj,o);
    }
    {
        PyObject *o;
        arg4[CDIO_MMC_HW_REVISION_LEN] = 0;
        o = PyString_FromString(arg4);
        resultobj = t_output_helper(resultobj,o);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_set_blocksize(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    int arg2 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:set_blocksize",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (int)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (driver_return_code_t)cdio_set_blocksize((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_set_speed(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    int arg2 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:set_speed",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (int)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (driver_return_code_t)cdio_set_speed((CdIo_t const *)arg1,arg2);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_open_cd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg1 = (char *) NULL ;
    driver_id_t arg2 = (driver_id_t) DRIVER_UNKNOWN ;
    char *arg3 = (char *) NULL ;
    CdIo_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"|OOO:open_cd",&obj0,&obj1,&obj2)) goto fail;
    if (obj0) {
        if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    if (obj1) {
        {
            arg2 = (driver_id_t)(SWIG_As_long(obj1)); 
            if (SWIG_arg_fail(2)) SWIG_fail;
        }
    }
    if (obj2) {
        if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
            SWIG_arg_fail(3);SWIG_fail;
        }
    }
    {
        result = (CdIo_t *)open_cd((char const *)arg1,arg2,(char const *)arg3);
        
        if (DRIVER_OP_SUCCESS == drc) goto out;
        set_python_errstring(drc);
        return NULL;
        out: ;
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_CdIo_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static int _wrap_drc_set(PyObject *_val) {
    {
        driver_return_code_t temp = (driver_return_code_t)(SWIG_As_long(_val));
        if (PyErr_Occurred()) {
            SWIG_append_errmsg("C/C++ variable 'drc (driver_return_code_t)'");
            return 1;
        }
        drc = temp;
    }
    return 0;
}


static PyObject *_wrap_drc_get(void) {
    PyObject *pyobj;
    
    {
        pyobj = SWIG_From_long((driver_return_code_t)(drc)); 
    }
    return pyobj;
}


static PyObject *_wrap_set_python_errstring(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    driver_return_code_t arg1 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:set_python_errstring",&obj0)) goto fail;
    {
        arg1 = (driver_return_code_t)(SWIG_As_long(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        set_python_errstring(arg1);
        
        if (DRIVER_OP_SUCCESS == drc) goto out;
        set_python_errstring(drc);
        return NULL;
        out: ;
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_disc_last_lsn(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    lsn_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_disc_last_lsn",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        result = (lsn_t)cdio_get_disc_last_lsn((CdIo_t const *)arg1);
        
        if (DRIVER_OP_SUCCESS == drc) goto out;
        set_python_errstring(drc);
        return NULL;
        out: ;
    }
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_disc_mode(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_disc_mode",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        result = (char *)get_disc_mode(arg1);
        
        if (NULL == result) {
            PyErr_SetString(PyExc_IOError, "Error getting disc mode.");
            return NULL;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_joliet_level(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_joliet_level",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        result = (int)cdio_get_joliet_level((CdIo_t const *)arg1);
        
        if (DRIVER_OP_SUCCESS == drc) goto out;
        set_python_errstring(drc);
        return NULL;
        out: ;
    }
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_mcn(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_mcn",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        result = (char *)cdio_get_mcn(arg1);
        
        if (DRIVER_OP_SUCCESS == drc) goto out;
        set_python_errstring(drc);
        return NULL;
        out: ;
    }
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_num_tracks(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    track_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_num_tracks",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        result = (track_t)cdio_get_num_tracks((CdIo_t const *)arg1);
        
        if (DRIVER_OP_SUCCESS == drc) goto out;
        set_python_errstring(drc);
        return NULL;
        out: ;
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyMethodDef SwigMethods[] = {
	 { (char *)"cdio_read_sectors", _wrap_cdio_read_sectors, METH_VARARGS, NULL},
	 { (char *)"cdio_eject_media_drive", _wrap_cdio_eject_media_drive, METH_VARARGS, NULL},
	 { (char *)"audio_pause", _wrap_audio_pause, METH_VARARGS, NULL},
	 { (char *)"audio_play_lsn", _wrap_audio_play_lsn, METH_VARARGS, NULL},
	 { (char *)"audio_resume", _wrap_audio_resume, METH_VARARGS, NULL},
	 { (char *)"audio_stop", _wrap_audio_stop, METH_VARARGS, NULL},
	 { (char *)"lseek", _wrap_lseek, METH_VARARGS, NULL},
	 { (char *)"read_cd", _wrap_read_cd, METH_VARARGS, NULL},
	 { (char *)"read_sectors", _wrap_read_sectors, METH_VARARGS, NULL},
	 { (char *)"read_data_bytes", _wrap_read_data_bytes, METH_VARARGS, NULL},
	 { (char *)"get_first_track_num", _wrap_get_first_track_num, METH_VARARGS, NULL},
	 { (char *)"get_last_track_num", _wrap_get_last_track_num, METH_VARARGS, NULL},
	 { (char *)"get_track", _wrap_get_track, METH_VARARGS, NULL},
	 { (char *)"get_track_channels", _wrap_get_track_channels, METH_VARARGS, NULL},
	 { (char *)"get_track_copy_permit", _wrap_get_track_copy_permit, METH_VARARGS, NULL},
	 { (char *)"get_track_format", _wrap_get_track_format, METH_VARARGS, NULL},
	 { (char *)"is_track_green", _wrap_is_track_green, METH_VARARGS, NULL},
	 { (char *)"get_track_last_lsn", _wrap_get_track_last_lsn, METH_VARARGS, NULL},
	 { (char *)"get_track_lba", _wrap_get_track_lba, METH_VARARGS, NULL},
	 { (char *)"get_track_lsn", _wrap_get_track_lsn, METH_VARARGS, NULL},
	 { (char *)"get_track_preemphasis", _wrap_get_track_preemphasis, METH_VARARGS, NULL},
	 { (char *)"get_track_sec_count", _wrap_get_track_sec_count, METH_VARARGS, NULL},
	 { (char *)"close_tray", _wrap_close_tray, METH_VARARGS, NULL},
	 { (char *)"close", _wrap_close, METH_VARARGS, NULL},
	 { (char *)"eject_media", _wrap_eject_media, METH_VARARGS, NULL},
	 { (char *)"eject_media_drive", _wrap_eject_media_drive, METH_VARARGS, NULL},
	 { (char *)"get_arg", _wrap_get_arg, METH_VARARGS, NULL},
	 { (char *)"get_device", _wrap_get_device, METH_VARARGS, NULL},
	 { (char *)"get_default_device_driver", _wrap_get_default_device_driver, METH_VARARGS, NULL},
	 { (char *)"get_devices", _wrap_get_devices, METH_VARARGS, NULL},
	 { (char *)"get_devices_ret", _wrap_get_devices_ret, METH_VARARGS, NULL},
	 { (char *)"get_devices_with_cap", _wrap_get_devices_with_cap, METH_VARARGS, NULL},
	 { (char *)"get_devices_with_cap_ret", _wrap_get_devices_with_cap_ret, METH_VARARGS, NULL},
	 { (char *)"get_drive_cap", _wrap_get_drive_cap, METH_VARARGS, NULL},
	 { (char *)"get_driver_name", _wrap_get_driver_name, METH_VARARGS, NULL},
	 { (char *)"get_driver_id", _wrap_get_driver_id, METH_VARARGS, NULL},
	 { (char *)"get_last_session", _wrap_get_last_session, METH_VARARGS, NULL},
	 { (char *)"have_driver", _wrap_have_driver, METH_VARARGS, NULL},
	 { (char *)"have_ATAPI", _wrap_have_ATAPI, METH_VARARGS, NULL},
	 { (char *)"is_binfile", _wrap_is_binfile, METH_VARARGS, NULL},
	 { (char *)"is_cuefile", _wrap_is_cuefile, METH_VARARGS, NULL},
	 { (char *)"is_device", _wrap_is_device, METH_VARARGS, NULL},
	 { (char *)"is_nrg", _wrap_is_nrg, METH_VARARGS, NULL},
	 { (char *)"is_tocfile", _wrap_is_tocfile, METH_VARARGS, NULL},
	 { (char *)"get_media_changed", _wrap_get_media_changed, METH_VARARGS, NULL},
	 { (char *)"get_hwinfo", _wrap_get_hwinfo, METH_VARARGS, NULL},
	 { (char *)"set_blocksize", _wrap_set_blocksize, METH_VARARGS, NULL},
	 { (char *)"set_speed", _wrap_set_speed, METH_VARARGS, NULL},
	 { (char *)"open_cd", _wrap_open_cd, METH_VARARGS, NULL},
	 { (char *)"set_python_errstring", _wrap_set_python_errstring, METH_VARARGS, NULL},
	 { (char *)"get_disc_last_lsn", _wrap_get_disc_last_lsn, METH_VARARGS, NULL},
	 { (char *)"get_disc_mode", _wrap_get_disc_mode, METH_VARARGS, NULL},
	 { (char *)"get_joliet_level", _wrap_get_joliet_level, METH_VARARGS, NULL},
	 { (char *)"get_mcn", _wrap_get_mcn, METH_VARARGS, NULL},
	 { (char *)"get_num_tracks", _wrap_get_num_tracks, METH_VARARGS, NULL},
	 { NULL, NULL, 0, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_cdio_read_mode_t[] = {{"_p_cdio_read_mode_t", 0, "enum cdio_read_mode_t *|cdio_read_mode_t *", 0, 0, 0, 0},{"_p_cdio_read_mode_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_CdIo_t[] = {{"_p_CdIo_t", 0, "CdIo_t *", 0, 0, 0, 0},{"_p_CdIo_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0, 0, 0, 0},{"_p_char", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__size_t[] = {{"_size_t", 0, "size_t", 0, 0, 0, 0},{"_size_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_long[] = {{"_p_long", 0, "long *|driver_id_t *", 0, 0, 0, 0},{"_p_long", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_unsigned_int[] = {{"_p_unsigned_int", 0, "unsigned int *", 0, 0, 0, 0},{"_p_unsigned_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__ptrdiff_t[] = {{"_ptrdiff_t", 0, "ptrdiff_t", 0, 0, 0, 0},{"_ptrdiff_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *|lsn_t *", 0, 0, 0, 0},{"_p_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_off_t[] = {{"_p_off_t", 0, "off_t *", 0, 0, 0, 0},{"_p_off_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_cdio_read_mode_t, 
_swigt__p_CdIo_t, 
_swigt__p_char, 
_swigt__size_t, 
_swigt__p_long, 
_swigt__p_unsigned_int, 
_swigt__ptrdiff_t, 
_swigt__p_int, 
_swigt__p_off_t, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{0, 0, 0, 0.0, 0, 0}};

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
    
    /* Python-specific SWIG API */
#define SWIG_newvarlink()                             SWIG_Python_newvarlink()
#define SWIG_addvarlink(p, name, get_attr, set_attr)  SWIG_Python_addvarlink(p, name, get_attr, set_attr)
#define SWIG_InstallConstants(d, constants)           SWIG_Python_InstallConstants(d, constants)
    
    /* -----------------------------------------------------------------------------
     * global variable support code.
     * ----------------------------------------------------------------------------- */
    
    typedef struct swig_globalvar {
        char       *name;                  /* Name of global variable */
        PyObject *(*get_attr)();           /* Return the current value */
        int       (*set_attr)(PyObject *); /* Set the value */
        struct swig_globalvar *next;
    } swig_globalvar;
    
    typedef struct swig_varlinkobject {
        PyObject_HEAD
        swig_globalvar *vars;
    } swig_varlinkobject;
    
    static PyObject *
    swig_varlink_repr(swig_varlinkobject *v) {
        v = v;
        return PyString_FromString("<Swig global variables>");
    }
    
    static int
    swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
        swig_globalvar  *var;
        flags = flags;
        fprintf(fp,"Swig global variables { ");
        for (var = v->vars; var; var=var->next) {
            fprintf(fp,"%s", var->name);
            if (var->next) fprintf(fp,", ");
        }
        fprintf(fp," }\n");
        return 0;
    }
    
    static PyObject *
    swig_varlink_getattr(swig_varlinkobject *v, char *n) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->get_attr)();
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return NULL;
    }
    
    static int
    swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->set_attr)(p);
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return 1;
    }
    
    static PyTypeObject varlinktype = {
        PyObject_HEAD_INIT(0)              
        0,                                  /* Number of items in variable part (ob_size) */
        (char *)"swigvarlink",              /* Type name (tp_name) */
        sizeof(swig_varlinkobject),         /* Basic size (tp_basicsize) */
        0,                                  /* Itemsize (tp_itemsize) */
        0,                                  /* Deallocator (tp_dealloc) */ 
        (printfunc) swig_varlink_print,     /* Print (tp_print) */
        (getattrfunc) swig_varlink_getattr, /* get attr (tp_getattr) */
        (setattrfunc) swig_varlink_setattr, /* Set attr (tp_setattr) */
        0,                                  /* tp_compare */
        (reprfunc) swig_varlink_repr,       /* tp_repr */
        0,                                  /* tp_as_number */
        0,                                  /* tp_as_sequence */
        0,                                  /* tp_as_mapping */
        0,                                  /* tp_hash */
        0,                                  /* tp_call */
        0,                                  /* tp_str */
        0,                                  /* tp_getattro */
        0,                                  /* tp_setattro */
        0,                                  /* tp_as_buffer */
        0,                                  /* tp_flags */
        0,                                  /* tp_doc */
#if PY_VERSION_HEX >= 0x02000000
        0,                                  /* tp_traverse */
        0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
        0,                                  /* tp_richcompare */
        0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
        0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
        0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };
    
    /* Create a variable linking object for use later */
    static PyObject *
    SWIG_Python_newvarlink(void) {
        swig_varlinkobject *result = 0;
        result = PyMem_NEW(swig_varlinkobject,1);
        varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
        result->ob_type = &varlinktype;
        result->vars = 0;
        result->ob_refcnt = 0;
        Py_XINCREF((PyObject *) result);
        return ((PyObject*) result);
    }
    
    static void
    SWIG_Python_addvarlink(PyObject *p, char *name, PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
        swig_varlinkobject *v;
        swig_globalvar *gv;
        v= (swig_varlinkobject *) p;
        gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
        gv->name = (char *) malloc(strlen(name)+1);
        strcpy(gv->name,name);
        gv->get_attr = get_attr;
        gv->set_attr = set_attr;
        gv->next = v->vars;
        v->vars = gv;
    }
    
    /* -----------------------------------------------------------------------------
     * constants/methods manipulation
     * ----------------------------------------------------------------------------- */
    
    /* Install Constants */
    static void
    SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]) {
        PyObject *obj = 0;
        size_t i;
        for (i = 0; constants[i].type; i++) {
            switch(constants[i].type) {
                case SWIG_PY_INT:
                obj = PyInt_FromLong(constants[i].lvalue);
                break;
                case SWIG_PY_FLOAT:
                obj = PyFloat_FromDouble(constants[i].dvalue);
                break;
                case SWIG_PY_STRING:
                if (constants[i].pvalue) {
                    obj = PyString_FromString((char *) constants[i].pvalue);
                } else {
                    Py_INCREF(Py_None);
                    obj = Py_None;
                }
                break;
                case SWIG_PY_POINTER:
                obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
                break;
                case SWIG_PY_BINARY:
                obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
                break;
                default:
                obj = 0;
                break;
            }
            if (obj) {
                PyDict_SetItemString(d,constants[i].name,obj);
                Py_DECREF(obj);
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*/
    /* Fix SwigMethods to carry the callback ptrs when needed */
    /* -----------------------------------------------------------------------------*/
    
    static void
    SWIG_Python_FixMethods(PyMethodDef *methods,
    swig_const_info *const_table,
    swig_type_info **types,
    swig_type_info **types_initial) {
        size_t i;
        for (i = 0; methods[i].ml_name; ++i) {
            char *c = methods[i].ml_doc;
            if (c && (c = strstr(c, "swig_ptr: "))) {
                int j;
                swig_const_info *ci = 0;
                char *name = c + 10;
                for (j = 0; const_table[j].type; j++) {
                    if (strncmp(const_table[j].name, name, 
                    strlen(const_table[j].name)) == 0) {
                        ci = &(const_table[j]);
                        break;
                    }
                }
                if (ci) {
                    size_t shift = (ci->ptype) - types;
                    swig_type_info *ty = types_initial[shift];
                    size_t ldoc = (c - methods[i].ml_doc);
                    size_t lptr = strlen(ty->name)+2*sizeof(void*)+2;
                    char *ndoc = (char*)malloc(ldoc + lptr + 10);
                    char *buff = ndoc;
                    void *ptr = (ci->type == SWIG_PY_POINTER) ? ci->pvalue: (void *)(ci->lvalue);
                    strncpy(buff, methods[i].ml_doc, ldoc);
                    buff += ldoc;
                    strncpy(buff, "swig_ptr: ", 10);
                    buff += 10;
                    SWIG_PackVoidPtr(buff, ptr, ty->name, lptr);
                    methods[i].ml_doc = ndoc;
                }
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*
     *  Initialize type list
     * -----------------------------------------------------------------------------*/
    
#if PY_MAJOR_VERSION < 2
    /* PyModule_AddObject function was introduced in Python 2.0.  The following function
    is copied out of Python/modsupport.c in python version 2.3.4 */
    static int
    PyModule_AddObject(PyObject *m, char *name, PyObject *o)
    {
        PyObject *dict;
        if (!PyModule_Check(m)) {
            PyErr_SetString(PyExc_TypeError,
            "PyModule_AddObject() needs module as first arg");
            return -1;
        }
        if (!o) {
            PyErr_SetString(PyExc_TypeError,
            "PyModule_AddObject() needs non-NULL value");
            return -1;
        }
        
        dict = PyModule_GetDict(m);
        if (dict == NULL) {
            /* Internal error -- modules must have a dict! */
            PyErr_Format(PyExc_SystemError, "module '%s' has no __dict__",
            PyModule_GetName(m));
            return -1;
        }
        if (PyDict_SetItemString(dict, name, o))
        return -1;
        Py_DECREF(o);
        return 0;
    }
#endif
    
    static swig_type_info **
    SWIG_Python_SetTypeListHandle(swig_type_info **type_list_handle) {
        static PyMethodDef swig_empty_runtime_method_table[] = {
            {
                NULL, NULL, 0, NULL
            } 
        };/* Sentinel */
        
        PyObject *module = Py_InitModule((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
        swig_empty_runtime_method_table);
        PyObject *pointer = PyCObject_FromVoidPtr((void *) type_list_handle, NULL);
        if (pointer && module) {
            PyModule_AddObject(module, (char*)"type_pointer" SWIG_TYPE_TABLE_NAME, pointer);
        }
        return type_list_handle;
    } 
    
    static swig_type_info **
    SWIG_Python_LookupTypePointer(swig_type_info **type_list_handle) {
        swig_type_info **type_pointer;
        
        /* first check if module already created */
        type_pointer = SWIG_Python_GetTypeListHandle();
        if (type_pointer) {
            return type_pointer;
        } else {
            /* create a new module and variable */
            return SWIG_Python_SetTypeListHandle(type_list_handle);
        }
    }
    
#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------*
 *  Partial Init method
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void *) SWIG_ReturnGlobalTypeList(void *);
#endif

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) SWIG_init(void) {
    static PyObject *SWIG_globals = 0; 
    static int       typeinit = 0;
    PyObject *m, *d;
    int       i;
    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    
    /* Fix SwigMethods to carry the callback ptrs when needed */
    SWIG_Python_FixMethods(SwigMethods, swig_const_table, swig_types, swig_types_initial);
    
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
    
    if (!typeinit) {
#ifdef SWIG_LINK_RUNTIME
        swig_type_list_handle = (swig_type_info **) SWIG_ReturnGlobalTypeList(swig_type_list_handle);
#else
#  ifndef SWIG_STATIC_RUNTIME
        swig_type_list_handle = SWIG_Python_LookupTypePointer(swig_type_list_handle);
#  endif
#endif
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        typeinit = 1;
    }
    SWIG_InstallConstants(d,swig_const_table);
    
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_AUDIO", SWIG_From_int((int)(CDIO_READ_MODE_AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M1F1", SWIG_From_int((int)(CDIO_READ_MODE_M1F1))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M1F2", SWIG_From_int((int)(CDIO_READ_MODE_M1F2))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M2F1", SWIG_From_int((int)(CDIO_READ_MODE_M2F1))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M2F2", SWIG_From_int((int)(CDIO_READ_MODE_M2F2))); 
    }
    {
        PyDict_SetItemString(d,"VERSION_NUM", SWIG_From_long((long)(LIBCDIO_VERSION_NUM))); 
    }
    {
        PyDict_SetItemString(d,"INVALID_LBA", SWIG_From_long((long)(CDIO_INVALID_LBA))); 
    }
    {
        PyDict_SetItemString(d,"INVALID_LSN", SWIG_From_long((long)(CDIO_INVALID_LSN))); 
    }
    {
        PyDict_SetItemString(d,"CD_FRAMESIZE", SWIG_From_long((long)(CDIO_CD_FRAMESIZE))); 
    }
    {
        PyDict_SetItemString(d,"CD_FRAMESIZE_RAW", SWIG_From_long((long)(CDIO_CD_FRAMESIZE_RAW))); 
    }
    {
        PyDict_SetItemString(d,"ISO_BLOCKSIZE", SWIG_From_long((long)(CDIO_CD_FRAMESIZE))); 
    }
    {
        PyDict_SetItemString(d,"M2F2_SECTOR_SIZE", SWIG_From_long((long)(M2F2_SECTOR_SIZE))); 
    }
    {
        PyDict_SetItemString(d,"M2RAW_SECTOR_SIZE", SWIG_From_long((long)(M2RAW_SECTOR_SIZE))); 
    }
    {
        PyDict_SetItemString(d,"READ_MODE_AUDIO", SWIG_From_long((long)(CDIO_READ_MODE_AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"READ_MODE_M1F1", SWIG_From_long((long)(CDIO_READ_MODE_M1F1))); 
    }
    {
        PyDict_SetItemString(d,"READ_MODE_M1F2", SWIG_From_long((long)(CDIO_READ_MODE_M1F2))); 
    }
    {
        PyDict_SetItemString(d,"READ_MODE_M2F1", SWIG_From_long((long)(CDIO_READ_MODE_M2F1))); 
    }
    {
        PyDict_SetItemString(d,"READ_MODE_M2F2", SWIG_From_long((long)(CDIO_READ_MODE_M2F2))); 
    }
    {
        PyDict_SetItemString(d,"TRACK_FORMAT_AUDIO", SWIG_From_long((long)(TRACK_FORMAT_AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"TRACK_FORMAT_CDI", SWIG_From_long((long)(TRACK_FORMAT_CDI))); 
    }
    {
        PyDict_SetItemString(d,"TRACK_FORMAT_XA", SWIG_From_long((long)(TRACK_FORMAT_XA))); 
    }
    {
        PyDict_SetItemString(d,"TRACK_FORMAT_DATA", SWIG_From_long((long)(TRACK_FORMAT_DATA))); 
    }
    {
        PyDict_SetItemString(d,"TRACK_FORMAT_PSX", SWIG_From_long((long)(TRACK_FORMAT_PSX))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_TRACK_FLAG_FALSE", SWIG_From_long((long)(CDIO_TRACK_FLAG_FALSE))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_TRACK_FLAG_TRUE", SWIG_From_long((long)(CDIO_TRACK_FLAG_TRUE))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_TRACK_FLAG_ERROR", SWIG_From_long((long)(CDIO_TRACK_FLAG_ERROR))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_TRACK_FLAG_UNKNOWN", SWIG_From_long((long)(CDIO_TRACK_FLAG_UNKNOWN))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_CDROM_LBA", SWIG_From_long((long)(CDIO_CDROM_LBA))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_CDROM_MSF", SWIG_From_long((long)(CDIO_CDROM_MSF))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_CDROM_DATA_TRACK", SWIG_From_long((long)(CDIO_CDROM_DATA_TRACK))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_CDROM_CDI_TRACK", SWIG_From_long((long)(CDIO_CDROM_CDI_TRACK))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_CDROM_XA_TRACK", SWIG_From_long((long)(CDIO_CDROM_XA_TRACK))); 
    }
    {
        PyDict_SetItemString(d,"AUDIO", SWIG_From_long((long)(AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"MODE1", SWIG_From_long((long)(MODE1))); 
    }
    {
        PyDict_SetItemString(d,"MODE1_RAW", SWIG_From_long((long)(MODE1_RAW))); 
    }
    {
        PyDict_SetItemString(d,"MODE2", SWIG_From_long((long)(MODE2))); 
    }
    {
        PyDict_SetItemString(d,"MODE2_FORM1", SWIG_From_long((long)(MODE2_FORM1))); 
    }
    {
        PyDict_SetItemString(d,"MODE2_FORM2", SWIG_From_long((long)(MODE2_FORM2))); 
    }
    {
        PyDict_SetItemString(d,"MODE2_FORM_MIX", SWIG_From_long((long)(MODE2_FORM_MIX))); 
    }
    {
        PyDict_SetItemString(d,"MODE2_RAW", SWIG_From_long((long)(MODE2_RAW))); 
    }
    {
        PyDict_SetItemString(d,"INVALID_TRACK", SWIG_From_long((long)(CDIO_INVALID_TRACK))); 
    }
    {
        PyDict_SetItemString(d,"CDROM_LEADOUT_TRACK", SWIG_From_long((long)(0xAA))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_ERROR", SWIG_From_long((long)(CDIO_DRIVE_CAP_ERROR))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_UNKNOWN", SWIG_From_long((long)(CDIO_DRIVE_CAP_UNKNOWN))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_CLOSE_TRAY", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_CLOSE_TRAY))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_EJECT", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_EJECT))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_LOCK", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_LOCK))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_SELECT_SPEED", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_SELECT_SPEED))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_SELECT_DISC", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_SELECT_DISC))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_MULTI_SESSION", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_MULTI_SESSION))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_MEDIA_CHANGED", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_MEDIA_CHANGED))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_RESET", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_RESET))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_MISC_FILE", SWIG_From_long((long)(CDIO_DRIVE_CAP_MISC_FILE))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_AUDIO", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_CD_DA", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_CD_DA))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_CD_G", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_CD_G))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_CD_R", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_CD_R))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_CD_RW", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_CD_RW))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_DVD_R", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_DVD_R))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_DVD_PR", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_DVD_PR))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_DVD_RAM", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_DVD_RAM))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_DVD_ROM", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_DVD_ROM))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_DVD_RW", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_DVD_RW))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_DVD_RPW", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_DVD_RPW))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_C2_ERRS", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_C2_ERRS))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_MODE2_FORM1", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_MODE2_FORM1))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_MODE2_FORM2", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_MODE2_FORM2))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_MCN", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_MCN))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_READ_ISRC", SWIG_From_long((long)(CDIO_DRIVE_CAP_READ_ISRC))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_CD_R", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_CD_R))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_CD_RW", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_CD_RW))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_DVD_R", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_DVD_R))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_DVD_PR", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_DVD_PR))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_DVD_RAM", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_DVD_RAM))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_DVD_RW", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_DVD_RW))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_DVD_RPW", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_DVD_RPW))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_MT_RAINIER", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_MT_RAINIER))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_BURN_PROOF", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_BURN_PROOF))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_CD", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_CD))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE_DVD", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE_DVD))); 
    }
    {
        PyDict_SetItemString(d,"DRIVE_CAP_WRITE", SWIG_From_long((long)(CDIO_DRIVE_CAP_WRITE))); 
    }
    {
        PyDict_SetItemString(d,"MMC_HW_VENDOR_LEN", SWIG_From_long((long)(CDIO_MMC_HW_VENDOR_LEN))); 
    }
    {
        PyDict_SetItemString(d,"MMC_HW_MODEL_LEN", SWIG_From_long((long)(CDIO_MMC_HW_MODEL_LEN))); 
    }
    {
        PyDict_SetItemString(d,"MMC_HW_REVISION_LEN", SWIG_From_long((long)(CDIO_MMC_HW_REVISION_LEN))); 
    }
    {
        PyDict_SetItemString(d,"SRC_IS_DISK_IMAGE_MASK", SWIG_From_long((long)(CDIO_SRC_IS_DISK_IMAGE_MASK))); 
    }
    {
        PyDict_SetItemString(d,"SRC_IS_DEVICE_MASK", SWIG_From_long((long)(CDIO_SRC_IS_DEVICE_MASK))); 
    }
    {
        PyDict_SetItemString(d,"SRC_IS_SCSI_MASK", SWIG_From_long((long)(CDIO_SRC_IS_SCSI_MASK))); 
    }
    {
        PyDict_SetItemString(d,"SRC_IS_NATIVE_MASK", SWIG_From_long((long)(CDIO_SRC_IS_NATIVE_MASK))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_UNKNOWN", SWIG_From_long((long)(DRIVER_UNKNOWN))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_AIX", SWIG_From_long((long)(DRIVER_AIX))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_BSDI", SWIG_From_long((long)(DRIVER_BSDI))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_FREEBSD", SWIG_From_long((long)(DRIVER_FREEBSD))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_LINUX", SWIG_From_long((long)(DRIVER_LINUX))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_SOLARIS", SWIG_From_long((long)(DRIVER_SOLARIS))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OSX", SWIG_From_long((long)(DRIVER_OSX))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_WIN32", SWIG_From_long((long)(DRIVER_WIN32))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_CDRDAO", SWIG_From_long((long)(DRIVER_CDRDAO))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_BINCUE", SWIG_From_long((long)(DRIVER_BINCUE))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_NRG", SWIG_From_long((long)(DRIVER_NRG))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_DEVICE", SWIG_From_long((long)(DRIVER_DEVICE))); 
    }
    {
        PyDict_SetItemString(d,"MIN_DRIVER", SWIG_From_long((long)(CDIO_MIN_DRIVER))); 
    }
    {
        PyDict_SetItemString(d,"MIN_DEVICE_DRIVER", SWIG_From_long((long)(CDIO_MIN_DEVICE_DRIVER))); 
    }
    {
        PyDict_SetItemString(d,"MAX_DRIVER", SWIG_From_long((long)(CDIO_MAX_DRIVER))); 
    }
    {
        PyDict_SetItemString(d,"MAX_DEVICE_DRIVER", SWIG_From_long((long)(CDIO_MAX_DEVICE_DRIVER))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_SUCCESS", SWIG_From_long((long)(DRIVER_OP_SUCCESS))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_ERROR", SWIG_From_long((long)(DRIVER_OP_ERROR))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_UNSUPPORTED", SWIG_From_long((long)(DRIVER_OP_UNSUPPORTED))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_UNINIT", SWIG_From_long((long)(DRIVER_OP_UNINIT))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_NOT_PERMITTED", SWIG_From_long((long)(DRIVER_OP_NOT_PERMITTED))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_BAD_PARAMETER", SWIG_From_long((long)(DRIVER_OP_BAD_PARAMETER))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_BAD_POINTER", SWIG_From_long((long)(DRIVER_OP_BAD_POINTER))); 
    }
    {
        PyDict_SetItemString(d,"DRIVER_OP_NO_DRIVER", SWIG_From_long((long)(DRIVER_OP_NO_DRIVER))); 
    }
    {
        PyDict_SetItemString(d,"FS_AUDIO", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"FS_HIGH_SIERRA", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_HIGH_SIERRA))); 
    }
    {
        PyDict_SetItemString(d,"FS_ISO_9660", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ISO_9660))); 
    }
    {
        PyDict_SetItemString(d,"FS_INTERACTIVE", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_INTERACTIVE))); 
    }
    {
        PyDict_SetItemString(d,"FS_HFS", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_HFS))); 
    }
    {
        PyDict_SetItemString(d,"FS_UFS", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_UFS))); 
    }
    {
        PyDict_SetItemString(d,"FS_EXT2", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_EXT2))); 
    }
    {
        PyDict_SetItemString(d,"FS_ISO_HFS", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ISO_HFS))); 
    }
    {
        PyDict_SetItemString(d,"FS_ISO_9660_INTERACTIVE", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ISO_9660_INTERACTIVE))); 
    }
    {
        PyDict_SetItemString(d,"FS_3DO", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_3DO))); 
    }
    {
        PyDict_SetItemString(d,"FS_XISO", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_XISO))); 
    }
    {
        PyDict_SetItemString(d,"FS_UDFX", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_UDFX))); 
    }
    {
        PyDict_SetItemString(d,"FS_UDF", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_UDF))); 
    }
    {
        PyDict_SetItemString(d,"FS_ISO_UDF", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ISO_UDF))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_XA", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_XA))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_MULTISESSION", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_MULTISESSION))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_PHOTO_CD", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_PHOTO_CD))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_HIDDEN_TRACK", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_HIDDEN_TRACK))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_CDTV", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_CDTV))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_BOOTABLE", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_BOOTABLE))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_VIDEOCD", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_VIDEOCD))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_ROCKRIDGE", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_ROCKRIDGE))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_JOLIET", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_JOLIET))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_SVCD", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_SVCD))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_CVD", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_CVD))); 
    }
    {
        PyDict_SetItemString(d,"FS_ANAL_XISO", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_ANAL_XISO))); 
    }
    {
        PyDict_SetItemString(d,"FS_MATCH_ALL", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_MATCH_ALL))); 
    }
    {
        PyDict_SetItemString(d,"FS_UNKNOWN", SWIG_From_unsigned_SS_int((unsigned int)(CDIO_FS_UNKNOWN))); 
    }
    PyDict_SetItemString(d,(char*)"cvar", SWIG_globals);
    SWIG_addvarlink(SWIG_globals,(char*)"drc",_wrap_drc_get, _wrap_drc_set);
    {
        PyDict_SetItemString(d,"DISC_MODE_CD_DA", SWIG_From_long((long)(CDIO_DISC_MODE_CD_DA))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_CD_DATA", SWIG_From_long((long)(CDIO_DISC_MODE_CD_DATA))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_CD_XA", SWIG_From_long((long)(CDIO_DISC_MODE_CD_XA))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_CD_MIXED", SWIG_From_long((long)(CDIO_DISC_MODE_CD_MIXED))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_ROM", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_ROM))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_RAM", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_RAM))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_R", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_R))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_RW", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_RW))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_PR", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_PR))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_PRW", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_PRW))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_DVD_OTHER", SWIG_From_long((long)(CDIO_DISC_MODE_DVD_OTHER))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_NO_INFO", SWIG_From_long((long)(CDIO_DISC_MODE_NO_INFO))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_ERROR", SWIG_From_long((long)(CDIO_DISC_MODE_ERROR))); 
    }
    {
        PyDict_SetItemString(d,"DISC_MODE_CD_I", SWIG_From_long((long)(CDIO_DISC_MODE_CD_I))); 
    }
    {
        PyDict_SetItemString(d,"INCLUDE_CLASS", SWIG_From_int((int)(0))); 
    }
}

