/* ex: set ro ft=c: -*- mode: c; buffer-read-only: t -*- */
/*****************************************************************************/
/*  LibreDWG - free implementation of the DWG file format                    */
/*                                                                           */
/*  Copyright (C) 2019-2020 Free Software Foundation, Inc.                   */
/*                                                                           */
/*  This library is free software, licensed under the terms of the GNU       */
/*  General Public License as published by the Free Software Foundation,     */
/*  either version 3 of the License, or (at your option) any later version.  */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.    */
/*****************************************************************************/
/* dynapi coverage tests, generated by gen-dynapi.pl from dynapi_test.c.in
   do not modify */
/* written by: Reini Urban */

#line 16 "dynapi_test.c.in"
#define DYNAPI_TEST_C
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <sys/stat.h>

#define DWG_LOGLEVEL DWG_LOGLEVEL_NONE
#include "../../src/config.h"
#include "../../src/common.h"
#include "dwg.h"
#include "dwg_api.h"
#include "tests_common.h"

/* for all objects/entities/header_vars:
   compare direct api vs dynapi values
*/
static int
test_header (const Dwg_Data *dwg)
{
  int error = 0;
  BITCODE_RL rl;
  BITCODE_RC rc;
  BITCODE_BLL bll;
  BITCODE_BD bd;
  BITCODE_TV tv;

#line 46 "dynapi_test.c"
  /* @@for test_HEADER@@ */
  {
    BITCODE_RL size;
    if (dwg_dynapi_header_value (dwg, "size", &size, NULL)
        && size == dwg->header_vars.size)
      pass ();
    else
      fail ("HEADER.size [RL] %u != %u", dwg->header_vars.size, size);
    size++;
    if (dwg_dynapi_header_set_value (dwg, "size", &size, 0)
        && size == dwg->header_vars.size)
      pass ();
    else
      fail ("HEADER.size [RL] set+1 %u != %u",
            dwg->header_vars.size, size);
    size--;
    dwg_dynapi_header_set_value (dwg, "size", &size, 0);

  }
  {
    BITCODE_RL bitsize_hi;
    if (dwg_dynapi_header_value (dwg, "bitsize_hi", &bitsize_hi, NULL)
        && bitsize_hi == dwg->header_vars.bitsize_hi)
      pass ();
    else
      fail ("HEADER.bitsize_hi [RL] %u != %u", dwg->header_vars.bitsize_hi, bitsize_hi);
    bitsize_hi++;
    if (dwg_dynapi_header_set_value (dwg, "bitsize_hi", &bitsize_hi, 0)
        && bitsize_hi == dwg->header_vars.bitsize_hi)
      pass ();
    else
      fail ("HEADER.bitsize_hi [RL] set+1 %u != %u",
            dwg->header_vars.bitsize_hi, bitsize_hi);
    bitsize_hi--;
    dwg_dynapi_header_set_value (dwg, "bitsize_hi", &bitsize_hi, 0);

  }
  {
    BITCODE_RL bitsize;
    if (dwg_dynapi_header_value (dwg, "bitsize", &bitsize, NULL)
        && bitsize == dwg->header_vars.bitsize)
      pass ();
    else
      fail ("HEADER.bitsize [RL] %u != %u", dwg->header_vars.bitsize, bitsize);
    bitsize++;
    if (dwg_dynapi_header_set_value (dwg, "bitsize", &bitsize, 0)
        && bitsize == dwg->header_vars.bitsize)
      pass ();
    else
      fail ("HEADER.bitsize [RL] set+1 %u != %u",
            dwg->header_vars.bitsize, bitsize);
    bitsize--;
    dwg_dynapi_header_set_value (dwg, "bitsize", &bitsize, 0);

  }
  {
    BITCODE_RC acadmaintver;
    if (dwg_dynapi_header_value (dwg, "ACADMAINTVER", &acadmaintver, NULL)
        && acadmaintver == dwg->header_vars.ACADMAINTVER)
      pass ();
    else
      fail ("HEADER.ACADMAINTVER [RC] %u != %u", dwg->header_vars.ACADMAINTVER, acadmaintver);
    acadmaintver++;
    if (dwg_dynapi_header_set_value (dwg, "ACADMAINTVER", &acadmaintver, 0)
        && acadmaintver == dwg->header_vars.ACADMAINTVER)
      pass ();
    else
      fail ("HEADER.ACADMAINTVER [RC] set+1 %u != %u",
            dwg->header_vars.ACADMAINTVER, acadmaintver);
    acadmaintver--;
    dwg_dynapi_header_set_value (dwg, "ACADMAINTVER", &acadmaintver, 0);

  }
  {
    BITCODE_BLL requiredversions;
    if (dwg_dynapi_header_value (dwg, "REQUIREDVERSIONS", &requiredversions, NULL)
        && requiredversions == dwg->header_vars.REQUIREDVERSIONS)
      pass ();
    else
      fail ("HEADER.REQUIREDVERSIONS [BLL] " FORMAT_BLL " != " FORMAT_BLL "", dwg->header_vars.REQUIREDVERSIONS, requiredversions);
    requiredversions++;
    if (dwg_dynapi_header_set_value (dwg, "REQUIREDVERSIONS", &requiredversions, 0)
        && requiredversions == dwg->header_vars.REQUIREDVERSIONS)
      pass ();
    else
      fail ("HEADER.REQUIREDVERSIONS [BLL] set+1 " FORMAT_BLL " != " FORMAT_BLL "",
            dwg->header_vars.REQUIREDVERSIONS, requiredversions);
    requiredversions--;
    dwg_dynapi_header_set_value (dwg, "REQUIREDVERSIONS", &requiredversions, 0);

  }
  {
    BITCODE_TV dwgcodepage;
    if (dwg_dynapi_header_value (dwg, "DWGCODEPAGE", &dwgcodepage, NULL)
        && !memcmp (&dwgcodepage, &dwg->header_vars.DWGCODEPAGE, sizeof (dwg->header_vars.DWGCODEPAGE))
       )
      pass ();
    else
      fail ("HEADER.DWGCODEPAGE [TV]");
  }
  {
    BITCODE_BD unknown_0;
    if (dwg_dynapi_header_value (dwg, "unknown_0", &unknown_0, NULL)
        && unknown_0 == dwg->header_vars.unknown_0)
      pass ();
    else
      fail ("HEADER.unknown_0 [BD] %g != %g", dwg->header_vars.unknown_0, unknown_0);
    unknown_0++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_0", &unknown_0, 0)
        && unknown_0 == dwg->header_vars.unknown_0)
      pass ();
    else
      fail ("HEADER.unknown_0 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_0, unknown_0);
    unknown_0--;
    dwg_dynapi_header_set_value (dwg, "unknown_0", &unknown_0, 0);

  }
  {
    BITCODE_BD unknown_1;
    if (dwg_dynapi_header_value (dwg, "unknown_1", &unknown_1, NULL)
        && unknown_1 == dwg->header_vars.unknown_1)
      pass ();
    else
      fail ("HEADER.unknown_1 [BD] %g != %g", dwg->header_vars.unknown_1, unknown_1);
    unknown_1++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_1", &unknown_1, 0)
        && unknown_1 == dwg->header_vars.unknown_1)
      pass ();
    else
      fail ("HEADER.unknown_1 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_1, unknown_1);
    unknown_1--;
    dwg_dynapi_header_set_value (dwg, "unknown_1", &unknown_1, 0);

  }
  {
    BITCODE_BD unknown_2;
    if (dwg_dynapi_header_value (dwg, "unknown_2", &unknown_2, NULL)
        && unknown_2 == dwg->header_vars.unknown_2)
      pass ();
    else
      fail ("HEADER.unknown_2 [BD] %g != %g", dwg->header_vars.unknown_2, unknown_2);
    unknown_2++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_2", &unknown_2, 0)
        && unknown_2 == dwg->header_vars.unknown_2)
      pass ();
    else
      fail ("HEADER.unknown_2 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_2, unknown_2);
    unknown_2--;
    dwg_dynapi_header_set_value (dwg, "unknown_2", &unknown_2, 0);

  }
  {
    BITCODE_BD unknown_3;
    if (dwg_dynapi_header_value (dwg, "unknown_3", &unknown_3, NULL)
        && unknown_3 == dwg->header_vars.unknown_3)
      pass ();
    else
      fail ("HEADER.unknown_3 [BD] %g != %g", dwg->header_vars.unknown_3, unknown_3);
    unknown_3++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_3", &unknown_3, 0)
        && unknown_3 == dwg->header_vars.unknown_3)
      pass ();
    else
      fail ("HEADER.unknown_3 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_3, unknown_3);
    unknown_3--;
    dwg_dynapi_header_set_value (dwg, "unknown_3", &unknown_3, 0);

  }
  {
    BITCODE_TV unknown_text1;
    if (dwg_dynapi_header_value (dwg, "unknown_text1", &unknown_text1, NULL)
        && !memcmp (&unknown_text1, &dwg->header_vars.unknown_text1, sizeof (dwg->header_vars.unknown_text1))
       )
      pass ();
    else
      fail ("HEADER.unknown_text1 [TV]");
  }
  {
    BITCODE_TV unknown_text2;
    if (dwg_dynapi_header_value (dwg, "unknown_text2", &unknown_text2, NULL)
        && !memcmp (&unknown_text2, &dwg->header_vars.unknown_text2, sizeof (dwg->header_vars.unknown_text2))
       )
      pass ();
    else
      fail ("HEADER.unknown_text2 [TV]");
  }
  {
    BITCODE_TV unknown_text3;
    if (dwg_dynapi_header_value (dwg, "unknown_text3", &unknown_text3, NULL)
        && !memcmp (&unknown_text3, &dwg->header_vars.unknown_text3, sizeof (dwg->header_vars.unknown_text3))
       )
      pass ();
    else
      fail ("HEADER.unknown_text3 [TV]");
  }
  {
    BITCODE_TV unknown_text4;
    if (dwg_dynapi_header_value (dwg, "unknown_text4", &unknown_text4, NULL)
        && !memcmp (&unknown_text4, &dwg->header_vars.unknown_text4, sizeof (dwg->header_vars.unknown_text4))
       )
      pass ();
    else
      fail ("HEADER.unknown_text4 [TV]");
  }
  {
    BITCODE_BL unknown_8;
    if (dwg_dynapi_header_value (dwg, "unknown_8", &unknown_8, NULL)
        && unknown_8 == dwg->header_vars.unknown_8)
      pass ();
    else
      fail ("HEADER.unknown_8 [BL] %u != %u", dwg->header_vars.unknown_8, unknown_8);
    unknown_8++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_8", &unknown_8, 0)
        && unknown_8 == dwg->header_vars.unknown_8)
      pass ();
    else
      fail ("HEADER.unknown_8 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_8, unknown_8);
    unknown_8--;
    dwg_dynapi_header_set_value (dwg, "unknown_8", &unknown_8, 0);

  }
  {
    BITCODE_BL unknown_9;
    if (dwg_dynapi_header_value (dwg, "unknown_9", &unknown_9, NULL)
        && unknown_9 == dwg->header_vars.unknown_9)
      pass ();
    else
      fail ("HEADER.unknown_9 [BL] %u != %u", dwg->header_vars.unknown_9, unknown_9);
    unknown_9++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_9", &unknown_9, 0)
        && unknown_9 == dwg->header_vars.unknown_9)
      pass ();
    else
      fail ("HEADER.unknown_9 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_9, unknown_9);
    unknown_9--;
    dwg_dynapi_header_set_value (dwg, "unknown_9", &unknown_9, 0);

  }
  {
    BITCODE_BS unknown_10;
    if (dwg_dynapi_header_value (dwg, "unknown_10", &unknown_10, NULL)
        && unknown_10 == dwg->header_vars.unknown_10)
      pass ();
    else
      fail ("HEADER.unknown_10 [BS] %hu != %hu", dwg->header_vars.unknown_10, unknown_10);
    unknown_10++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_10", &unknown_10, 0)
        && unknown_10 == dwg->header_vars.unknown_10)
      pass ();
    else
      fail ("HEADER.unknown_10 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_10, unknown_10);
    unknown_10--;
    dwg_dynapi_header_set_value (dwg, "unknown_10", &unknown_10, 0);

  }
  {
    BITCODE_H vport_entity_header;
    if (dwg_dynapi_header_value (dwg, "VPORT_ENTITY_HEADER", &vport_entity_header, NULL)
        && !memcmp (&vport_entity_header, &dwg->header_vars.VPORT_ENTITY_HEADER, sizeof (dwg->header_vars.VPORT_ENTITY_HEADER))
       )
      pass ();
    else
      fail ("HEADER.VPORT_ENTITY_HEADER [H]");
  }
  {
    BITCODE_B dimaso;
    if (dwg_dynapi_header_value (dwg, "DIMASO", &dimaso, NULL)
        && dimaso == dwg->header_vars.DIMASO)
      pass ();
    else
      fail ("HEADER.DIMASO [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMASO, dimaso);
    dimaso++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASO", &dimaso, 0)
        && dimaso == dwg->header_vars.DIMASO)
      pass ();
    else
      fail ("HEADER.DIMASO [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMASO, dimaso);
    dimaso--;
    dwg_dynapi_header_set_value (dwg, "DIMASO", &dimaso, 0);

  }
  {
    BITCODE_B dimsho;
    if (dwg_dynapi_header_value (dwg, "DIMSHO", &dimsho, NULL)
        && dimsho == dwg->header_vars.DIMSHO)
      pass ();
    else
      fail ("HEADER.DIMSHO [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSHO, dimsho);
    dimsho++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSHO", &dimsho, 0)
        && dimsho == dwg->header_vars.DIMSHO)
      pass ();
    else
      fail ("HEADER.DIMSHO [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSHO, dimsho);
    dimsho--;
    dwg_dynapi_header_set_value (dwg, "DIMSHO", &dimsho, 0);

  }
  {
    BITCODE_B dimsav;
    if (dwg_dynapi_header_value (dwg, "DIMSAV", &dimsav, NULL)
        && dimsav == dwg->header_vars.DIMSAV)
      pass ();
    else
      fail ("HEADER.DIMSAV [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSAV, dimsav);
    dimsav++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSAV", &dimsav, 0)
        && dimsav == dwg->header_vars.DIMSAV)
      pass ();
    else
      fail ("HEADER.DIMSAV [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSAV, dimsav);
    dimsav--;
    dwg_dynapi_header_set_value (dwg, "DIMSAV", &dimsav, 0);

  }
  {
    BITCODE_B plinegen;
    if (dwg_dynapi_header_value (dwg, "PLINEGEN", &plinegen, NULL)
        && plinegen == dwg->header_vars.PLINEGEN)
      pass ();
    else
      fail ("HEADER.PLINEGEN [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PLINEGEN, plinegen);
    plinegen++;
    if (dwg_dynapi_header_set_value (dwg, "PLINEGEN", &plinegen, 0)
        && plinegen == dwg->header_vars.PLINEGEN)
      pass ();
    else
      fail ("HEADER.PLINEGEN [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PLINEGEN, plinegen);
    plinegen--;
    dwg_dynapi_header_set_value (dwg, "PLINEGEN", &plinegen, 0);

  }
  {
    BITCODE_B orthomode;
    if (dwg_dynapi_header_value (dwg, "ORTHOMODE", &orthomode, NULL)
        && orthomode == dwg->header_vars.ORTHOMODE)
      pass ();
    else
      fail ("HEADER.ORTHOMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ORTHOMODE, orthomode);
    orthomode++;
    if (dwg_dynapi_header_set_value (dwg, "ORTHOMODE", &orthomode, 0)
        && orthomode == dwg->header_vars.ORTHOMODE)
      pass ();
    else
      fail ("HEADER.ORTHOMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ORTHOMODE, orthomode);
    orthomode--;
    dwg_dynapi_header_set_value (dwg, "ORTHOMODE", &orthomode, 0);

  }
  {
    BITCODE_B regenmode;
    if (dwg_dynapi_header_value (dwg, "REGENMODE", &regenmode, NULL)
        && regenmode == dwg->header_vars.REGENMODE)
      pass ();
    else
      fail ("HEADER.REGENMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.REGENMODE, regenmode);
    regenmode++;
    if (dwg_dynapi_header_set_value (dwg, "REGENMODE", &regenmode, 0)
        && regenmode == dwg->header_vars.REGENMODE)
      pass ();
    else
      fail ("HEADER.REGENMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.REGENMODE, regenmode);
    regenmode--;
    dwg_dynapi_header_set_value (dwg, "REGENMODE", &regenmode, 0);

  }
  {
    BITCODE_B fillmode;
    if (dwg_dynapi_header_value (dwg, "FILLMODE", &fillmode, NULL)
        && fillmode == dwg->header_vars.FILLMODE)
      pass ();
    else
      fail ("HEADER.FILLMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.FILLMODE, fillmode);
    fillmode++;
    if (dwg_dynapi_header_set_value (dwg, "FILLMODE", &fillmode, 0)
        && fillmode == dwg->header_vars.FILLMODE)
      pass ();
    else
      fail ("HEADER.FILLMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.FILLMODE, fillmode);
    fillmode--;
    dwg_dynapi_header_set_value (dwg, "FILLMODE", &fillmode, 0);

  }
  {
    BITCODE_B qtextmode;
    if (dwg_dynapi_header_value (dwg, "QTEXTMODE", &qtextmode, NULL)
        && qtextmode == dwg->header_vars.QTEXTMODE)
      pass ();
    else
      fail ("HEADER.QTEXTMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.QTEXTMODE, qtextmode);
    qtextmode++;
    if (dwg_dynapi_header_set_value (dwg, "QTEXTMODE", &qtextmode, 0)
        && qtextmode == dwg->header_vars.QTEXTMODE)
      pass ();
    else
      fail ("HEADER.QTEXTMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.QTEXTMODE, qtextmode);
    qtextmode--;
    dwg_dynapi_header_set_value (dwg, "QTEXTMODE", &qtextmode, 0);

  }
  {
    BITCODE_B psltscale;
    if (dwg_dynapi_header_value (dwg, "PSLTSCALE", &psltscale, NULL)
        && psltscale == dwg->header_vars.PSLTSCALE)
      pass ();
    else
      fail ("HEADER.PSLTSCALE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PSLTSCALE, psltscale);
    psltscale++;
    if (dwg_dynapi_header_set_value (dwg, "PSLTSCALE", &psltscale, 0)
        && psltscale == dwg->header_vars.PSLTSCALE)
      pass ();
    else
      fail ("HEADER.PSLTSCALE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PSLTSCALE, psltscale);
    psltscale--;
    dwg_dynapi_header_set_value (dwg, "PSLTSCALE", &psltscale, 0);

  }
  {
    BITCODE_B limcheck;
    if (dwg_dynapi_header_value (dwg, "LIMCHECK", &limcheck, NULL)
        && limcheck == dwg->header_vars.LIMCHECK)
      pass ();
    else
      fail ("HEADER.LIMCHECK [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.LIMCHECK, limcheck);
    limcheck++;
    if (dwg_dynapi_header_set_value (dwg, "LIMCHECK", &limcheck, 0)
        && limcheck == dwg->header_vars.LIMCHECK)
      pass ();
    else
      fail ("HEADER.LIMCHECK [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.LIMCHECK, limcheck);
    limcheck--;
    dwg_dynapi_header_set_value (dwg, "LIMCHECK", &limcheck, 0);

  }
  {
    BITCODE_B blipmode;
    if (dwg_dynapi_header_value (dwg, "BLIPMODE", &blipmode, NULL)
        && blipmode == dwg->header_vars.BLIPMODE)
      pass ();
    else
      fail ("HEADER.BLIPMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.BLIPMODE, blipmode);
    blipmode++;
    if (dwg_dynapi_header_set_value (dwg, "BLIPMODE", &blipmode, 0)
        && blipmode == dwg->header_vars.BLIPMODE)
      pass ();
    else
      fail ("HEADER.BLIPMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.BLIPMODE, blipmode);
    blipmode--;
    dwg_dynapi_header_set_value (dwg, "BLIPMODE", &blipmode, 0);

  }
  {
    BITCODE_B unknown_11;
    if (dwg_dynapi_header_value (dwg, "unknown_11", &unknown_11, NULL)
        && unknown_11 == dwg->header_vars.unknown_11)
      pass ();
    else
      fail ("HEADER.unknown_11 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.unknown_11, unknown_11);
    unknown_11++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_11", &unknown_11, 0)
        && unknown_11 == dwg->header_vars.unknown_11)
      pass ();
    else
      fail ("HEADER.unknown_11 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.unknown_11, unknown_11);
    unknown_11--;
    dwg_dynapi_header_set_value (dwg, "unknown_11", &unknown_11, 0);

  }
  {
    BITCODE_B usrtimer;
    if (dwg_dynapi_header_value (dwg, "USRTIMER", &usrtimer, NULL)
        && usrtimer == dwg->header_vars.USRTIMER)
      pass ();
    else
      fail ("HEADER.USRTIMER [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.USRTIMER, usrtimer);
    usrtimer++;
    if (dwg_dynapi_header_set_value (dwg, "USRTIMER", &usrtimer, 0)
        && usrtimer == dwg->header_vars.USRTIMER)
      pass ();
    else
      fail ("HEADER.USRTIMER [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.USRTIMER, usrtimer);
    usrtimer--;
    dwg_dynapi_header_set_value (dwg, "USRTIMER", &usrtimer, 0);

  }
  {
    BITCODE_B skpoly;
    if (dwg_dynapi_header_value (dwg, "SKPOLY", &skpoly, NULL)
        && skpoly == dwg->header_vars.SKPOLY)
      pass ();
    else
      fail ("HEADER.SKPOLY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.SKPOLY, skpoly);
    skpoly++;
    if (dwg_dynapi_header_set_value (dwg, "SKPOLY", &skpoly, 0)
        && skpoly == dwg->header_vars.SKPOLY)
      pass ();
    else
      fail ("HEADER.SKPOLY [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.SKPOLY, skpoly);
    skpoly--;
    dwg_dynapi_header_set_value (dwg, "SKPOLY", &skpoly, 0);

  }
  {
    BITCODE_B angdir;
    if (dwg_dynapi_header_value (dwg, "ANGDIR", &angdir, NULL)
        && angdir == dwg->header_vars.ANGDIR)
      pass ();
    else
      fail ("HEADER.ANGDIR [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ANGDIR, angdir);
    angdir++;
    if (dwg_dynapi_header_set_value (dwg, "ANGDIR", &angdir, 0)
        && angdir == dwg->header_vars.ANGDIR)
      pass ();
    else
      fail ("HEADER.ANGDIR [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ANGDIR, angdir);
    angdir--;
    dwg_dynapi_header_set_value (dwg, "ANGDIR", &angdir, 0);

  }
  {
    BITCODE_B splframe;
    if (dwg_dynapi_header_value (dwg, "SPLFRAME", &splframe, NULL)
        && splframe == dwg->header_vars.SPLFRAME)
      pass ();
    else
      fail ("HEADER.SPLFRAME [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.SPLFRAME, splframe);
    splframe++;
    if (dwg_dynapi_header_set_value (dwg, "SPLFRAME", &splframe, 0)
        && splframe == dwg->header_vars.SPLFRAME)
      pass ();
    else
      fail ("HEADER.SPLFRAME [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.SPLFRAME, splframe);
    splframe--;
    dwg_dynapi_header_set_value (dwg, "SPLFRAME", &splframe, 0);

  }
  {
    BITCODE_B attreq;
    if (dwg_dynapi_header_value (dwg, "ATTREQ", &attreq, NULL)
        && attreq == dwg->header_vars.ATTREQ)
      pass ();
    else
      fail ("HEADER.ATTREQ [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ATTREQ, attreq);
    attreq++;
    if (dwg_dynapi_header_set_value (dwg, "ATTREQ", &attreq, 0)
        && attreq == dwg->header_vars.ATTREQ)
      pass ();
    else
      fail ("HEADER.ATTREQ [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ATTREQ, attreq);
    attreq--;
    dwg_dynapi_header_set_value (dwg, "ATTREQ", &attreq, 0);

  }
  {
    BITCODE_B attdia;
    if (dwg_dynapi_header_value (dwg, "ATTDIA", &attdia, NULL)
        && attdia == dwg->header_vars.ATTDIA)
      pass ();
    else
      fail ("HEADER.ATTDIA [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ATTDIA, attdia);
    attdia++;
    if (dwg_dynapi_header_set_value (dwg, "ATTDIA", &attdia, 0)
        && attdia == dwg->header_vars.ATTDIA)
      pass ();
    else
      fail ("HEADER.ATTDIA [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ATTDIA, attdia);
    attdia--;
    dwg_dynapi_header_set_value (dwg, "ATTDIA", &attdia, 0);

  }
  {
    BITCODE_B mirrtext;
    if (dwg_dynapi_header_value (dwg, "MIRRTEXT", &mirrtext, NULL)
        && mirrtext == dwg->header_vars.MIRRTEXT)
      pass ();
    else
      fail ("HEADER.MIRRTEXT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.MIRRTEXT, mirrtext);
    mirrtext++;
    if (dwg_dynapi_header_set_value (dwg, "MIRRTEXT", &mirrtext, 0)
        && mirrtext == dwg->header_vars.MIRRTEXT)
      pass ();
    else
      fail ("HEADER.MIRRTEXT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.MIRRTEXT, mirrtext);
    mirrtext--;
    dwg_dynapi_header_set_value (dwg, "MIRRTEXT", &mirrtext, 0);

  }
  {
    BITCODE_B worldview;
    if (dwg_dynapi_header_value (dwg, "WORLDVIEW", &worldview, NULL)
        && worldview == dwg->header_vars.WORLDVIEW)
      pass ();
    else
      fail ("HEADER.WORLDVIEW [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.WORLDVIEW, worldview);
    worldview++;
    if (dwg_dynapi_header_set_value (dwg, "WORLDVIEW", &worldview, 0)
        && worldview == dwg->header_vars.WORLDVIEW)
      pass ();
    else
      fail ("HEADER.WORLDVIEW [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.WORLDVIEW, worldview);
    worldview--;
    dwg_dynapi_header_set_value (dwg, "WORLDVIEW", &worldview, 0);

  }
  {
    BITCODE_B wireframe;
    if (dwg_dynapi_header_value (dwg, "WIREFRAME", &wireframe, NULL)
        && wireframe == dwg->header_vars.WIREFRAME)
      pass ();
    else
      fail ("HEADER.WIREFRAME [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.WIREFRAME, wireframe);
    wireframe++;
    if (dwg_dynapi_header_set_value (dwg, "WIREFRAME", &wireframe, 0)
        && wireframe == dwg->header_vars.WIREFRAME)
      pass ();
    else
      fail ("HEADER.WIREFRAME [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.WIREFRAME, wireframe);
    wireframe--;
    dwg_dynapi_header_set_value (dwg, "WIREFRAME", &wireframe, 0);

  }
  {
    BITCODE_B tilemode;
    if (dwg_dynapi_header_value (dwg, "TILEMODE", &tilemode, NULL)
        && tilemode == dwg->header_vars.TILEMODE)
      pass ();
    else
      fail ("HEADER.TILEMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.TILEMODE, tilemode);
    tilemode++;
    if (dwg_dynapi_header_set_value (dwg, "TILEMODE", &tilemode, 0)
        && tilemode == dwg->header_vars.TILEMODE)
      pass ();
    else
      fail ("HEADER.TILEMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.TILEMODE, tilemode);
    tilemode--;
    dwg_dynapi_header_set_value (dwg, "TILEMODE", &tilemode, 0);

  }
  {
    BITCODE_B plimcheck;
    if (dwg_dynapi_header_value (dwg, "PLIMCHECK", &plimcheck, NULL)
        && plimcheck == dwg->header_vars.PLIMCHECK)
      pass ();
    else
      fail ("HEADER.PLIMCHECK [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PLIMCHECK, plimcheck);
    plimcheck++;
    if (dwg_dynapi_header_set_value (dwg, "PLIMCHECK", &plimcheck, 0)
        && plimcheck == dwg->header_vars.PLIMCHECK)
      pass ();
    else
      fail ("HEADER.PLIMCHECK [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PLIMCHECK, plimcheck);
    plimcheck--;
    dwg_dynapi_header_set_value (dwg, "PLIMCHECK", &plimcheck, 0);

  }
  {
    BITCODE_B visretain;
    if (dwg_dynapi_header_value (dwg, "VISRETAIN", &visretain, NULL)
        && visretain == dwg->header_vars.VISRETAIN)
      pass ();
    else
      fail ("HEADER.VISRETAIN [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.VISRETAIN, visretain);
    visretain++;
    if (dwg_dynapi_header_set_value (dwg, "VISRETAIN", &visretain, 0)
        && visretain == dwg->header_vars.VISRETAIN)
      pass ();
    else
      fail ("HEADER.VISRETAIN [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.VISRETAIN, visretain);
    visretain--;
    dwg_dynapi_header_set_value (dwg, "VISRETAIN", &visretain, 0);

  }
  {
    BITCODE_B delobj;
    if (dwg_dynapi_header_value (dwg, "DELOBJ", &delobj, NULL)
        && delobj == dwg->header_vars.DELOBJ)
      pass ();
    else
      fail ("HEADER.DELOBJ [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DELOBJ, delobj);
    delobj++;
    if (dwg_dynapi_header_set_value (dwg, "DELOBJ", &delobj, 0)
        && delobj == dwg->header_vars.DELOBJ)
      pass ();
    else
      fail ("HEADER.DELOBJ [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DELOBJ, delobj);
    delobj--;
    dwg_dynapi_header_set_value (dwg, "DELOBJ", &delobj, 0);

  }
  {
    BITCODE_B dispsilh;
    if (dwg_dynapi_header_value (dwg, "DISPSILH", &dispsilh, NULL)
        && dispsilh == dwg->header_vars.DISPSILH)
      pass ();
    else
      fail ("HEADER.DISPSILH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DISPSILH, dispsilh);
    dispsilh++;
    if (dwg_dynapi_header_set_value (dwg, "DISPSILH", &dispsilh, 0)
        && dispsilh == dwg->header_vars.DISPSILH)
      pass ();
    else
      fail ("HEADER.DISPSILH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DISPSILH, dispsilh);
    dispsilh--;
    dwg_dynapi_header_set_value (dwg, "DISPSILH", &dispsilh, 0);

  }
  {
    BITCODE_B pellipse;
    if (dwg_dynapi_header_value (dwg, "PELLIPSE", &pellipse, NULL)
        && pellipse == dwg->header_vars.PELLIPSE)
      pass ();
    else
      fail ("HEADER.PELLIPSE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PELLIPSE, pellipse);
    pellipse++;
    if (dwg_dynapi_header_set_value (dwg, "PELLIPSE", &pellipse, 0)
        && pellipse == dwg->header_vars.PELLIPSE)
      pass ();
    else
      fail ("HEADER.PELLIPSE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PELLIPSE, pellipse);
    pellipse--;
    dwg_dynapi_header_set_value (dwg, "PELLIPSE", &pellipse, 0);

  }
  {
    BITCODE_BS saveimages;
    if (dwg_dynapi_header_value (dwg, "SAVEIMAGES", &saveimages, NULL)
        && saveimages == dwg->header_vars.SAVEIMAGES)
      pass ();
    else
      fail ("HEADER.SAVEIMAGES [BS] %hu != %hu", dwg->header_vars.SAVEIMAGES, saveimages);
    saveimages++;
    if (dwg_dynapi_header_set_value (dwg, "SAVEIMAGES", &saveimages, 0)
        && saveimages == dwg->header_vars.SAVEIMAGES)
      pass ();
    else
      fail ("HEADER.SAVEIMAGES [BS] set+1 %hu != %hu",
            dwg->header_vars.SAVEIMAGES, saveimages);
    saveimages--;
    dwg_dynapi_header_set_value (dwg, "SAVEIMAGES", &saveimages, 0);

  }
  {
    BITCODE_BS proxygraphics;
    if (dwg_dynapi_header_value (dwg, "PROXYGRAPHICS", &proxygraphics, NULL)
        && proxygraphics == dwg->header_vars.PROXYGRAPHICS)
      pass ();
    else
      fail ("HEADER.PROXYGRAPHICS [BS] %hu != %hu", dwg->header_vars.PROXYGRAPHICS, proxygraphics);
    proxygraphics++;
    if (dwg_dynapi_header_set_value (dwg, "PROXYGRAPHICS", &proxygraphics, 0)
        && proxygraphics == dwg->header_vars.PROXYGRAPHICS)
      pass ();
    else
      fail ("HEADER.PROXYGRAPHICS [BS] set+1 %hu != %hu",
            dwg->header_vars.PROXYGRAPHICS, proxygraphics);
    proxygraphics--;
    dwg_dynapi_header_set_value (dwg, "PROXYGRAPHICS", &proxygraphics, 0);

  }
  {
    BITCODE_BS measurement;
    if (dwg_dynapi_header_value (dwg, "MEASUREMENT", &measurement, NULL)
        && measurement == dwg->header_vars.MEASUREMENT)
      pass ();
    else
      fail ("HEADER.MEASUREMENT [BS] %hu != %hu", dwg->header_vars.MEASUREMENT, measurement);
    measurement++;
    if (dwg_dynapi_header_set_value (dwg, "MEASUREMENT", &measurement, 0)
        && measurement == dwg->header_vars.MEASUREMENT)
      pass ();
    else
      fail ("HEADER.MEASUREMENT [BS] set+1 %hu != %hu",
            dwg->header_vars.MEASUREMENT, measurement);
    measurement--;
    dwg_dynapi_header_set_value (dwg, "MEASUREMENT", &measurement, 0);

  }
  {
    BITCODE_BS dragmode;
    if (dwg_dynapi_header_value (dwg, "DRAGMODE", &dragmode, NULL)
        && dragmode == dwg->header_vars.DRAGMODE)
      pass ();
    else
      fail ("HEADER.DRAGMODE [BS] %hu != %hu", dwg->header_vars.DRAGMODE, dragmode);
    dragmode++;
    if (dwg_dynapi_header_set_value (dwg, "DRAGMODE", &dragmode, 0)
        && dragmode == dwg->header_vars.DRAGMODE)
      pass ();
    else
      fail ("HEADER.DRAGMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.DRAGMODE, dragmode);
    dragmode--;
    dwg_dynapi_header_set_value (dwg, "DRAGMODE", &dragmode, 0);

  }
  {
    BITCODE_BS treedepth;
    if (dwg_dynapi_header_value (dwg, "TREEDEPTH", &treedepth, NULL)
        && treedepth == dwg->header_vars.TREEDEPTH)
      pass ();
    else
      fail ("HEADER.TREEDEPTH [BS] %hu != %hu", dwg->header_vars.TREEDEPTH, treedepth);
    treedepth++;
    if (dwg_dynapi_header_set_value (dwg, "TREEDEPTH", &treedepth, 0)
        && treedepth == dwg->header_vars.TREEDEPTH)
      pass ();
    else
      fail ("HEADER.TREEDEPTH [BS] set+1 %hu != %hu",
            dwg->header_vars.TREEDEPTH, treedepth);
    treedepth--;
    dwg_dynapi_header_set_value (dwg, "TREEDEPTH", &treedepth, 0);

  }
  {
    BITCODE_BS lunits;
    if (dwg_dynapi_header_value (dwg, "LUNITS", &lunits, NULL)
        && lunits == dwg->header_vars.LUNITS)
      pass ();
    else
      fail ("HEADER.LUNITS [BS] %hu != %hu", dwg->header_vars.LUNITS, lunits);
    lunits++;
    if (dwg_dynapi_header_set_value (dwg, "LUNITS", &lunits, 0)
        && lunits == dwg->header_vars.LUNITS)
      pass ();
    else
      fail ("HEADER.LUNITS [BS] set+1 %hu != %hu",
            dwg->header_vars.LUNITS, lunits);
    lunits--;
    dwg_dynapi_header_set_value (dwg, "LUNITS", &lunits, 0);

  }
  {
    BITCODE_BS luprec;
    if (dwg_dynapi_header_value (dwg, "LUPREC", &luprec, NULL)
        && luprec == dwg->header_vars.LUPREC)
      pass ();
    else
      fail ("HEADER.LUPREC [BS] %hu != %hu", dwg->header_vars.LUPREC, luprec);
    luprec++;
    if (dwg_dynapi_header_set_value (dwg, "LUPREC", &luprec, 0)
        && luprec == dwg->header_vars.LUPREC)
      pass ();
    else
      fail ("HEADER.LUPREC [BS] set+1 %hu != %hu",
            dwg->header_vars.LUPREC, luprec);
    luprec--;
    dwg_dynapi_header_set_value (dwg, "LUPREC", &luprec, 0);

  }
  {
    BITCODE_BS aunits;
    if (dwg_dynapi_header_value (dwg, "AUNITS", &aunits, NULL)
        && aunits == dwg->header_vars.AUNITS)
      pass ();
    else
      fail ("HEADER.AUNITS [BS] %hu != %hu", dwg->header_vars.AUNITS, aunits);
    aunits++;
    if (dwg_dynapi_header_set_value (dwg, "AUNITS", &aunits, 0)
        && aunits == dwg->header_vars.AUNITS)
      pass ();
    else
      fail ("HEADER.AUNITS [BS] set+1 %hu != %hu",
            dwg->header_vars.AUNITS, aunits);
    aunits--;
    dwg_dynapi_header_set_value (dwg, "AUNITS", &aunits, 0);

  }
  {
    BITCODE_BS auprec;
    if (dwg_dynapi_header_value (dwg, "AUPREC", &auprec, NULL)
        && auprec == dwg->header_vars.AUPREC)
      pass ();
    else
      fail ("HEADER.AUPREC [BS] %hu != %hu", dwg->header_vars.AUPREC, auprec);
    auprec++;
    if (dwg_dynapi_header_set_value (dwg, "AUPREC", &auprec, 0)
        && auprec == dwg->header_vars.AUPREC)
      pass ();
    else
      fail ("HEADER.AUPREC [BS] set+1 %hu != %hu",
            dwg->header_vars.AUPREC, auprec);
    auprec--;
    dwg_dynapi_header_set_value (dwg, "AUPREC", &auprec, 0);

  }
  {
    BITCODE_BS osmode;
    if (dwg_dynapi_header_value (dwg, "OSMODE", &osmode, NULL)
        && osmode == dwg->header_vars.OSMODE)
      pass ();
    else
      fail ("HEADER.OSMODE [BS] %hu != %hu", dwg->header_vars.OSMODE, osmode);
    osmode++;
    if (dwg_dynapi_header_set_value (dwg, "OSMODE", &osmode, 0)
        && osmode == dwg->header_vars.OSMODE)
      pass ();
    else
      fail ("HEADER.OSMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.OSMODE, osmode);
    osmode--;
    dwg_dynapi_header_set_value (dwg, "OSMODE", &osmode, 0);

  }
  {
    BITCODE_BS attmode;
    if (dwg_dynapi_header_value (dwg, "ATTMODE", &attmode, NULL)
        && attmode == dwg->header_vars.ATTMODE)
      pass ();
    else
      fail ("HEADER.ATTMODE [BS] %hu != %hu", dwg->header_vars.ATTMODE, attmode);
    attmode++;
    if (dwg_dynapi_header_set_value (dwg, "ATTMODE", &attmode, 0)
        && attmode == dwg->header_vars.ATTMODE)
      pass ();
    else
      fail ("HEADER.ATTMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.ATTMODE, attmode);
    attmode--;
    dwg_dynapi_header_set_value (dwg, "ATTMODE", &attmode, 0);

  }
  {
    BITCODE_BS coords;
    if (dwg_dynapi_header_value (dwg, "COORDS", &coords, NULL)
        && coords == dwg->header_vars.COORDS)
      pass ();
    else
      fail ("HEADER.COORDS [BS] %hu != %hu", dwg->header_vars.COORDS, coords);
    coords++;
    if (dwg_dynapi_header_set_value (dwg, "COORDS", &coords, 0)
        && coords == dwg->header_vars.COORDS)
      pass ();
    else
      fail ("HEADER.COORDS [BS] set+1 %hu != %hu",
            dwg->header_vars.COORDS, coords);
    coords--;
    dwg_dynapi_header_set_value (dwg, "COORDS", &coords, 0);

  }
  {
    BITCODE_BS pdmode;
    if (dwg_dynapi_header_value (dwg, "PDMODE", &pdmode, NULL)
        && pdmode == dwg->header_vars.PDMODE)
      pass ();
    else
      fail ("HEADER.PDMODE [BS] %hu != %hu", dwg->header_vars.PDMODE, pdmode);
    pdmode++;
    if (dwg_dynapi_header_set_value (dwg, "PDMODE", &pdmode, 0)
        && pdmode == dwg->header_vars.PDMODE)
      pass ();
    else
      fail ("HEADER.PDMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.PDMODE, pdmode);
    pdmode--;
    dwg_dynapi_header_set_value (dwg, "PDMODE", &pdmode, 0);

  }
  {
    BITCODE_BS pickstyle;
    if (dwg_dynapi_header_value (dwg, "PICKSTYLE", &pickstyle, NULL)
        && pickstyle == dwg->header_vars.PICKSTYLE)
      pass ();
    else
      fail ("HEADER.PICKSTYLE [BS] %hu != %hu", dwg->header_vars.PICKSTYLE, pickstyle);
    pickstyle++;
    if (dwg_dynapi_header_set_value (dwg, "PICKSTYLE", &pickstyle, 0)
        && pickstyle == dwg->header_vars.PICKSTYLE)
      pass ();
    else
      fail ("HEADER.PICKSTYLE [BS] set+1 %hu != %hu",
            dwg->header_vars.PICKSTYLE, pickstyle);
    pickstyle--;
    dwg_dynapi_header_set_value (dwg, "PICKSTYLE", &pickstyle, 0);

  }
  {
    BITCODE_BL unknown_12;
    if (dwg_dynapi_header_value (dwg, "unknown_12", &unknown_12, NULL)
        && unknown_12 == dwg->header_vars.unknown_12)
      pass ();
    else
      fail ("HEADER.unknown_12 [BL] %u != %u", dwg->header_vars.unknown_12, unknown_12);
    unknown_12++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_12", &unknown_12, 0)
        && unknown_12 == dwg->header_vars.unknown_12)
      pass ();
    else
      fail ("HEADER.unknown_12 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_12, unknown_12);
    unknown_12--;
    dwg_dynapi_header_set_value (dwg, "unknown_12", &unknown_12, 0);

  }
  {
    BITCODE_BL unknown_13;
    if (dwg_dynapi_header_value (dwg, "unknown_13", &unknown_13, NULL)
        && unknown_13 == dwg->header_vars.unknown_13)
      pass ();
    else
      fail ("HEADER.unknown_13 [BL] %u != %u", dwg->header_vars.unknown_13, unknown_13);
    unknown_13++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_13", &unknown_13, 0)
        && unknown_13 == dwg->header_vars.unknown_13)
      pass ();
    else
      fail ("HEADER.unknown_13 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_13, unknown_13);
    unknown_13--;
    dwg_dynapi_header_set_value (dwg, "unknown_13", &unknown_13, 0);

  }
  {
    BITCODE_BL unknown_14;
    if (dwg_dynapi_header_value (dwg, "unknown_14", &unknown_14, NULL)
        && unknown_14 == dwg->header_vars.unknown_14)
      pass ();
    else
      fail ("HEADER.unknown_14 [BL] %u != %u", dwg->header_vars.unknown_14, unknown_14);
    unknown_14++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_14", &unknown_14, 0)
        && unknown_14 == dwg->header_vars.unknown_14)
      pass ();
    else
      fail ("HEADER.unknown_14 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_14, unknown_14);
    unknown_14--;
    dwg_dynapi_header_set_value (dwg, "unknown_14", &unknown_14, 0);

  }
  {
    BITCODE_BS useri1;
    if (dwg_dynapi_header_value (dwg, "USERI1", &useri1, NULL)
        && useri1 == dwg->header_vars.USERI1)
      pass ();
    else
      fail ("HEADER.USERI1 [BS] %hu != %hu", dwg->header_vars.USERI1, useri1);
    useri1++;
    if (dwg_dynapi_header_set_value (dwg, "USERI1", &useri1, 0)
        && useri1 == dwg->header_vars.USERI1)
      pass ();
    else
      fail ("HEADER.USERI1 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI1, useri1);
    useri1--;
    dwg_dynapi_header_set_value (dwg, "USERI1", &useri1, 0);

  }
  {
    BITCODE_BS useri2;
    if (dwg_dynapi_header_value (dwg, "USERI2", &useri2, NULL)
        && useri2 == dwg->header_vars.USERI2)
      pass ();
    else
      fail ("HEADER.USERI2 [BS] %hu != %hu", dwg->header_vars.USERI2, useri2);
    useri2++;
    if (dwg_dynapi_header_set_value (dwg, "USERI2", &useri2, 0)
        && useri2 == dwg->header_vars.USERI2)
      pass ();
    else
      fail ("HEADER.USERI2 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI2, useri2);
    useri2--;
    dwg_dynapi_header_set_value (dwg, "USERI2", &useri2, 0);

  }
  {
    BITCODE_BS useri3;
    if (dwg_dynapi_header_value (dwg, "USERI3", &useri3, NULL)
        && useri3 == dwg->header_vars.USERI3)
      pass ();
    else
      fail ("HEADER.USERI3 [BS] %hu != %hu", dwg->header_vars.USERI3, useri3);
    useri3++;
    if (dwg_dynapi_header_set_value (dwg, "USERI3", &useri3, 0)
        && useri3 == dwg->header_vars.USERI3)
      pass ();
    else
      fail ("HEADER.USERI3 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI3, useri3);
    useri3--;
    dwg_dynapi_header_set_value (dwg, "USERI3", &useri3, 0);

  }
  {
    BITCODE_BS useri4;
    if (dwg_dynapi_header_value (dwg, "USERI4", &useri4, NULL)
        && useri4 == dwg->header_vars.USERI4)
      pass ();
    else
      fail ("HEADER.USERI4 [BS] %hu != %hu", dwg->header_vars.USERI4, useri4);
    useri4++;
    if (dwg_dynapi_header_set_value (dwg, "USERI4", &useri4, 0)
        && useri4 == dwg->header_vars.USERI4)
      pass ();
    else
      fail ("HEADER.USERI4 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI4, useri4);
    useri4--;
    dwg_dynapi_header_set_value (dwg, "USERI4", &useri4, 0);

  }
  {
    BITCODE_BS useri5;
    if (dwg_dynapi_header_value (dwg, "USERI5", &useri5, NULL)
        && useri5 == dwg->header_vars.USERI5)
      pass ();
    else
      fail ("HEADER.USERI5 [BS] %hu != %hu", dwg->header_vars.USERI5, useri5);
    useri5++;
    if (dwg_dynapi_header_set_value (dwg, "USERI5", &useri5, 0)
        && useri5 == dwg->header_vars.USERI5)
      pass ();
    else
      fail ("HEADER.USERI5 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI5, useri5);
    useri5--;
    dwg_dynapi_header_set_value (dwg, "USERI5", &useri5, 0);

  }
  {
    BITCODE_BS splinesegs;
    if (dwg_dynapi_header_value (dwg, "SPLINESEGS", &splinesegs, NULL)
        && splinesegs == dwg->header_vars.SPLINESEGS)
      pass ();
    else
      fail ("HEADER.SPLINESEGS [BS] %hu != %hu", dwg->header_vars.SPLINESEGS, splinesegs);
    splinesegs++;
    if (dwg_dynapi_header_set_value (dwg, "SPLINESEGS", &splinesegs, 0)
        && splinesegs == dwg->header_vars.SPLINESEGS)
      pass ();
    else
      fail ("HEADER.SPLINESEGS [BS] set+1 %hu != %hu",
            dwg->header_vars.SPLINESEGS, splinesegs);
    splinesegs--;
    dwg_dynapi_header_set_value (dwg, "SPLINESEGS", &splinesegs, 0);

  }
  {
    BITCODE_BS surfu;
    if (dwg_dynapi_header_value (dwg, "SURFU", &surfu, NULL)
        && surfu == dwg->header_vars.SURFU)
      pass ();
    else
      fail ("HEADER.SURFU [BS] %hu != %hu", dwg->header_vars.SURFU, surfu);
    surfu++;
    if (dwg_dynapi_header_set_value (dwg, "SURFU", &surfu, 0)
        && surfu == dwg->header_vars.SURFU)
      pass ();
    else
      fail ("HEADER.SURFU [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFU, surfu);
    surfu--;
    dwg_dynapi_header_set_value (dwg, "SURFU", &surfu, 0);

  }
  {
    BITCODE_BS surfv;
    if (dwg_dynapi_header_value (dwg, "SURFV", &surfv, NULL)
        && surfv == dwg->header_vars.SURFV)
      pass ();
    else
      fail ("HEADER.SURFV [BS] %hu != %hu", dwg->header_vars.SURFV, surfv);
    surfv++;
    if (dwg_dynapi_header_set_value (dwg, "SURFV", &surfv, 0)
        && surfv == dwg->header_vars.SURFV)
      pass ();
    else
      fail ("HEADER.SURFV [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFV, surfv);
    surfv--;
    dwg_dynapi_header_set_value (dwg, "SURFV", &surfv, 0);

  }
  {
    BITCODE_BS surftype;
    if (dwg_dynapi_header_value (dwg, "SURFTYPE", &surftype, NULL)
        && surftype == dwg->header_vars.SURFTYPE)
      pass ();
    else
      fail ("HEADER.SURFTYPE [BS] %hu != %hu", dwg->header_vars.SURFTYPE, surftype);
    surftype++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTYPE", &surftype, 0)
        && surftype == dwg->header_vars.SURFTYPE)
      pass ();
    else
      fail ("HEADER.SURFTYPE [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFTYPE, surftype);
    surftype--;
    dwg_dynapi_header_set_value (dwg, "SURFTYPE", &surftype, 0);

  }
  {
    BITCODE_BS surftab1;
    if (dwg_dynapi_header_value (dwg, "SURFTAB1", &surftab1, NULL)
        && surftab1 == dwg->header_vars.SURFTAB1)
      pass ();
    else
      fail ("HEADER.SURFTAB1 [BS] %hu != %hu", dwg->header_vars.SURFTAB1, surftab1);
    surftab1++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTAB1", &surftab1, 0)
        && surftab1 == dwg->header_vars.SURFTAB1)
      pass ();
    else
      fail ("HEADER.SURFTAB1 [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFTAB1, surftab1);
    surftab1--;
    dwg_dynapi_header_set_value (dwg, "SURFTAB1", &surftab1, 0);

  }
  {
    BITCODE_BS surftab2;
    if (dwg_dynapi_header_value (dwg, "SURFTAB2", &surftab2, NULL)
        && surftab2 == dwg->header_vars.SURFTAB2)
      pass ();
    else
      fail ("HEADER.SURFTAB2 [BS] %hu != %hu", dwg->header_vars.SURFTAB2, surftab2);
    surftab2++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTAB2", &surftab2, 0)
        && surftab2 == dwg->header_vars.SURFTAB2)
      pass ();
    else
      fail ("HEADER.SURFTAB2 [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFTAB2, surftab2);
    surftab2--;
    dwg_dynapi_header_set_value (dwg, "SURFTAB2", &surftab2, 0);

  }
  {
    BITCODE_BS splinetype;
    if (dwg_dynapi_header_value (dwg, "SPLINETYPE", &splinetype, NULL)
        && splinetype == dwg->header_vars.SPLINETYPE)
      pass ();
    else
      fail ("HEADER.SPLINETYPE [BS] %hu != %hu", dwg->header_vars.SPLINETYPE, splinetype);
    splinetype++;
    if (dwg_dynapi_header_set_value (dwg, "SPLINETYPE", &splinetype, 0)
        && splinetype == dwg->header_vars.SPLINETYPE)
      pass ();
    else
      fail ("HEADER.SPLINETYPE [BS] set+1 %hu != %hu",
            dwg->header_vars.SPLINETYPE, splinetype);
    splinetype--;
    dwg_dynapi_header_set_value (dwg, "SPLINETYPE", &splinetype, 0);

  }
  {
    BITCODE_BS shadedge;
    if (dwg_dynapi_header_value (dwg, "SHADEDGE", &shadedge, NULL)
        && shadedge == dwg->header_vars.SHADEDGE)
      pass ();
    else
      fail ("HEADER.SHADEDGE [BS] %hu != %hu", dwg->header_vars.SHADEDGE, shadedge);
    shadedge++;
    if (dwg_dynapi_header_set_value (dwg, "SHADEDGE", &shadedge, 0)
        && shadedge == dwg->header_vars.SHADEDGE)
      pass ();
    else
      fail ("HEADER.SHADEDGE [BS] set+1 %hu != %hu",
            dwg->header_vars.SHADEDGE, shadedge);
    shadedge--;
    dwg_dynapi_header_set_value (dwg, "SHADEDGE", &shadedge, 0);

  }
  {
    BITCODE_BS shadedif;
    if (dwg_dynapi_header_value (dwg, "SHADEDIF", &shadedif, NULL)
        && shadedif == dwg->header_vars.SHADEDIF)
      pass ();
    else
      fail ("HEADER.SHADEDIF [BS] %hu != %hu", dwg->header_vars.SHADEDIF, shadedif);
    shadedif++;
    if (dwg_dynapi_header_set_value (dwg, "SHADEDIF", &shadedif, 0)
        && shadedif == dwg->header_vars.SHADEDIF)
      pass ();
    else
      fail ("HEADER.SHADEDIF [BS] set+1 %hu != %hu",
            dwg->header_vars.SHADEDIF, shadedif);
    shadedif--;
    dwg_dynapi_header_set_value (dwg, "SHADEDIF", &shadedif, 0);

  }
  {
    BITCODE_BS unitmode;
    if (dwg_dynapi_header_value (dwg, "UNITMODE", &unitmode, NULL)
        && unitmode == dwg->header_vars.UNITMODE)
      pass ();
    else
      fail ("HEADER.UNITMODE [BS] %hu != %hu", dwg->header_vars.UNITMODE, unitmode);
    unitmode++;
    if (dwg_dynapi_header_set_value (dwg, "UNITMODE", &unitmode, 0)
        && unitmode == dwg->header_vars.UNITMODE)
      pass ();
    else
      fail ("HEADER.UNITMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.UNITMODE, unitmode);
    unitmode--;
    dwg_dynapi_header_set_value (dwg, "UNITMODE", &unitmode, 0);

  }
  {
    BITCODE_BS maxactvp;
    if (dwg_dynapi_header_value (dwg, "MAXACTVP", &maxactvp, NULL)
        && maxactvp == dwg->header_vars.MAXACTVP)
      pass ();
    else
      fail ("HEADER.MAXACTVP [BS] %hu != %hu", dwg->header_vars.MAXACTVP, maxactvp);
    maxactvp++;
    if (dwg_dynapi_header_set_value (dwg, "MAXACTVP", &maxactvp, 0)
        && maxactvp == dwg->header_vars.MAXACTVP)
      pass ();
    else
      fail ("HEADER.MAXACTVP [BS] set+1 %hu != %hu",
            dwg->header_vars.MAXACTVP, maxactvp);
    maxactvp--;
    dwg_dynapi_header_set_value (dwg, "MAXACTVP", &maxactvp, 0);

  }
  {
    BITCODE_BS isolines;
    if (dwg_dynapi_header_value (dwg, "ISOLINES", &isolines, NULL)
        && isolines == dwg->header_vars.ISOLINES)
      pass ();
    else
      fail ("HEADER.ISOLINES [BS] %hu != %hu", dwg->header_vars.ISOLINES, isolines);
    isolines++;
    if (dwg_dynapi_header_set_value (dwg, "ISOLINES", &isolines, 0)
        && isolines == dwg->header_vars.ISOLINES)
      pass ();
    else
      fail ("HEADER.ISOLINES [BS] set+1 %hu != %hu",
            dwg->header_vars.ISOLINES, isolines);
    isolines--;
    dwg_dynapi_header_set_value (dwg, "ISOLINES", &isolines, 0);

  }
  {
    BITCODE_BS cmljust;
    if (dwg_dynapi_header_value (dwg, "CMLJUST", &cmljust, NULL)
        && cmljust == dwg->header_vars.CMLJUST)
      pass ();
    else
      fail ("HEADER.CMLJUST [BS] %hu != %hu", dwg->header_vars.CMLJUST, cmljust);
    cmljust++;
    if (dwg_dynapi_header_set_value (dwg, "CMLJUST", &cmljust, 0)
        && cmljust == dwg->header_vars.CMLJUST)
      pass ();
    else
      fail ("HEADER.CMLJUST [BS] set+1 %hu != %hu",
            dwg->header_vars.CMLJUST, cmljust);
    cmljust--;
    dwg_dynapi_header_set_value (dwg, "CMLJUST", &cmljust, 0);

  }
  {
    BITCODE_BS textqlty;
    if (dwg_dynapi_header_value (dwg, "TEXTQLTY", &textqlty, NULL)
        && textqlty == dwg->header_vars.TEXTQLTY)
      pass ();
    else
      fail ("HEADER.TEXTQLTY [BS] %hu != %hu", dwg->header_vars.TEXTQLTY, textqlty);
    textqlty++;
    if (dwg_dynapi_header_set_value (dwg, "TEXTQLTY", &textqlty, 0)
        && textqlty == dwg->header_vars.TEXTQLTY)
      pass ();
    else
      fail ("HEADER.TEXTQLTY [BS] set+1 %hu != %hu",
            dwg->header_vars.TEXTQLTY, textqlty);
    textqlty--;
    dwg_dynapi_header_set_value (dwg, "TEXTQLTY", &textqlty, 0);

  }
  {
    BITCODE_BL unknown_14b;
    if (dwg_dynapi_header_value (dwg, "unknown_14b", &unknown_14b, NULL)
        && unknown_14b == dwg->header_vars.unknown_14b)
      pass ();
    else
      fail ("HEADER.unknown_14b [BL] %u != %u", dwg->header_vars.unknown_14b, unknown_14b);
    unknown_14b++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_14b", &unknown_14b, 0)
        && unknown_14b == dwg->header_vars.unknown_14b)
      pass ();
    else
      fail ("HEADER.unknown_14b [BL] set+1 %u != %u",
            dwg->header_vars.unknown_14b, unknown_14b);
    unknown_14b--;
    dwg_dynapi_header_set_value (dwg, "unknown_14b", &unknown_14b, 0);

  }
  {
    BITCODE_BD ltscale;
    if (dwg_dynapi_header_value (dwg, "LTSCALE", &ltscale, NULL)
        && ltscale == dwg->header_vars.LTSCALE)
      pass ();
    else
      fail ("HEADER.LTSCALE [BD] %g != %g", dwg->header_vars.LTSCALE, ltscale);
    ltscale++;
    if (dwg_dynapi_header_set_value (dwg, "LTSCALE", &ltscale, 0)
        && ltscale == dwg->header_vars.LTSCALE)
      pass ();
    else
      fail ("HEADER.LTSCALE [BD] set+1 %g != %g",
            dwg->header_vars.LTSCALE, ltscale);
    ltscale--;
    dwg_dynapi_header_set_value (dwg, "LTSCALE", &ltscale, 0);

  }
  {
    BITCODE_BD textsize;
    if (dwg_dynapi_header_value (dwg, "TEXTSIZE", &textsize, NULL)
        && textsize == dwg->header_vars.TEXTSIZE)
      pass ();
    else
      fail ("HEADER.TEXTSIZE [BD] %g != %g", dwg->header_vars.TEXTSIZE, textsize);
    textsize++;
    if (dwg_dynapi_header_set_value (dwg, "TEXTSIZE", &textsize, 0)
        && textsize == dwg->header_vars.TEXTSIZE)
      pass ();
    else
      fail ("HEADER.TEXTSIZE [BD] set+1 %g != %g",
            dwg->header_vars.TEXTSIZE, textsize);
    textsize--;
    dwg_dynapi_header_set_value (dwg, "TEXTSIZE", &textsize, 0);

  }
  {
    BITCODE_BD tracewid;
    if (dwg_dynapi_header_value (dwg, "TRACEWID", &tracewid, NULL)
        && tracewid == dwg->header_vars.TRACEWID)
      pass ();
    else
      fail ("HEADER.TRACEWID [BD] %g != %g", dwg->header_vars.TRACEWID, tracewid);
    tracewid++;
    if (dwg_dynapi_header_set_value (dwg, "TRACEWID", &tracewid, 0)
        && tracewid == dwg->header_vars.TRACEWID)
      pass ();
    else
      fail ("HEADER.TRACEWID [BD] set+1 %g != %g",
            dwg->header_vars.TRACEWID, tracewid);
    tracewid--;
    dwg_dynapi_header_set_value (dwg, "TRACEWID", &tracewid, 0);

  }
  {
    BITCODE_BD sketchinc;
    if (dwg_dynapi_header_value (dwg, "SKETCHINC", &sketchinc, NULL)
        && sketchinc == dwg->header_vars.SKETCHINC)
      pass ();
    else
      fail ("HEADER.SKETCHINC [BD] %g != %g", dwg->header_vars.SKETCHINC, sketchinc);
    sketchinc++;
    if (dwg_dynapi_header_set_value (dwg, "SKETCHINC", &sketchinc, 0)
        && sketchinc == dwg->header_vars.SKETCHINC)
      pass ();
    else
      fail ("HEADER.SKETCHINC [BD] set+1 %g != %g",
            dwg->header_vars.SKETCHINC, sketchinc);
    sketchinc--;
    dwg_dynapi_header_set_value (dwg, "SKETCHINC", &sketchinc, 0);

  }
  {
    BITCODE_BD filletrad;
    if (dwg_dynapi_header_value (dwg, "FILLETRAD", &filletrad, NULL)
        && filletrad == dwg->header_vars.FILLETRAD)
      pass ();
    else
      fail ("HEADER.FILLETRAD [BD] %g != %g", dwg->header_vars.FILLETRAD, filletrad);
    filletrad++;
    if (dwg_dynapi_header_set_value (dwg, "FILLETRAD", &filletrad, 0)
        && filletrad == dwg->header_vars.FILLETRAD)
      pass ();
    else
      fail ("HEADER.FILLETRAD [BD] set+1 %g != %g",
            dwg->header_vars.FILLETRAD, filletrad);
    filletrad--;
    dwg_dynapi_header_set_value (dwg, "FILLETRAD", &filletrad, 0);

  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_header_value (dwg, "THICKNESS", &thickness, NULL)
        && thickness == dwg->header_vars.THICKNESS)
      pass ();
    else
      fail ("HEADER.THICKNESS [BD] %g != %g", dwg->header_vars.THICKNESS, thickness);
    thickness++;
    if (dwg_dynapi_header_set_value (dwg, "THICKNESS", &thickness, 0)
        && thickness == dwg->header_vars.THICKNESS)
      pass ();
    else
      fail ("HEADER.THICKNESS [BD] set+1 %g != %g",
            dwg->header_vars.THICKNESS, thickness);
    thickness--;
    dwg_dynapi_header_set_value (dwg, "THICKNESS", &thickness, 0);

  }
  {
    BITCODE_BD angbase;
    if (dwg_dynapi_header_value (dwg, "ANGBASE", &angbase, NULL)
        && angbase == dwg->header_vars.ANGBASE)
      pass ();
    else
      fail ("HEADER.ANGBASE [BD] %g != %g", dwg->header_vars.ANGBASE, angbase);
    angbase++;
    if (dwg_dynapi_header_set_value (dwg, "ANGBASE", &angbase, 0)
        && angbase == dwg->header_vars.ANGBASE)
      pass ();
    else
      fail ("HEADER.ANGBASE [BD] set+1 %g != %g",
            dwg->header_vars.ANGBASE, angbase);
    angbase--;
    dwg_dynapi_header_set_value (dwg, "ANGBASE", &angbase, 0);

  }
  {
    BITCODE_BD pdsize;
    if (dwg_dynapi_header_value (dwg, "PDSIZE", &pdsize, NULL)
        && pdsize == dwg->header_vars.PDSIZE)
      pass ();
    else
      fail ("HEADER.PDSIZE [BD] %g != %g", dwg->header_vars.PDSIZE, pdsize);
    pdsize++;
    if (dwg_dynapi_header_set_value (dwg, "PDSIZE", &pdsize, 0)
        && pdsize == dwg->header_vars.PDSIZE)
      pass ();
    else
      fail ("HEADER.PDSIZE [BD] set+1 %g != %g",
            dwg->header_vars.PDSIZE, pdsize);
    pdsize--;
    dwg_dynapi_header_set_value (dwg, "PDSIZE", &pdsize, 0);

  }
  {
    BITCODE_BD plinewid;
    if (dwg_dynapi_header_value (dwg, "PLINEWID", &plinewid, NULL)
        && plinewid == dwg->header_vars.PLINEWID)
      pass ();
    else
      fail ("HEADER.PLINEWID [BD] %g != %g", dwg->header_vars.PLINEWID, plinewid);
    plinewid++;
    if (dwg_dynapi_header_set_value (dwg, "PLINEWID", &plinewid, 0)
        && plinewid == dwg->header_vars.PLINEWID)
      pass ();
    else
      fail ("HEADER.PLINEWID [BD] set+1 %g != %g",
            dwg->header_vars.PLINEWID, plinewid);
    plinewid--;
    dwg_dynapi_header_set_value (dwg, "PLINEWID", &plinewid, 0);

  }
  {
    BITCODE_BD userr1;
    if (dwg_dynapi_header_value (dwg, "USERR1", &userr1, NULL)
        && userr1 == dwg->header_vars.USERR1)
      pass ();
    else
      fail ("HEADER.USERR1 [BD] %g != %g", dwg->header_vars.USERR1, userr1);
    userr1++;
    if (dwg_dynapi_header_set_value (dwg, "USERR1", &userr1, 0)
        && userr1 == dwg->header_vars.USERR1)
      pass ();
    else
      fail ("HEADER.USERR1 [BD] set+1 %g != %g",
            dwg->header_vars.USERR1, userr1);
    userr1--;
    dwg_dynapi_header_set_value (dwg, "USERR1", &userr1, 0);

  }
  {
    BITCODE_BD userr2;
    if (dwg_dynapi_header_value (dwg, "USERR2", &userr2, NULL)
        && userr2 == dwg->header_vars.USERR2)
      pass ();
    else
      fail ("HEADER.USERR2 [BD] %g != %g", dwg->header_vars.USERR2, userr2);
    userr2++;
    if (dwg_dynapi_header_set_value (dwg, "USERR2", &userr2, 0)
        && userr2 == dwg->header_vars.USERR2)
      pass ();
    else
      fail ("HEADER.USERR2 [BD] set+1 %g != %g",
            dwg->header_vars.USERR2, userr2);
    userr2--;
    dwg_dynapi_header_set_value (dwg, "USERR2", &userr2, 0);

  }
  {
    BITCODE_BD userr3;
    if (dwg_dynapi_header_value (dwg, "USERR3", &userr3, NULL)
        && userr3 == dwg->header_vars.USERR3)
      pass ();
    else
      fail ("HEADER.USERR3 [BD] %g != %g", dwg->header_vars.USERR3, userr3);
    userr3++;
    if (dwg_dynapi_header_set_value (dwg, "USERR3", &userr3, 0)
        && userr3 == dwg->header_vars.USERR3)
      pass ();
    else
      fail ("HEADER.USERR3 [BD] set+1 %g != %g",
            dwg->header_vars.USERR3, userr3);
    userr3--;
    dwg_dynapi_header_set_value (dwg, "USERR3", &userr3, 0);

  }
  {
    BITCODE_BD userr4;
    if (dwg_dynapi_header_value (dwg, "USERR4", &userr4, NULL)
        && userr4 == dwg->header_vars.USERR4)
      pass ();
    else
      fail ("HEADER.USERR4 [BD] %g != %g", dwg->header_vars.USERR4, userr4);
    userr4++;
    if (dwg_dynapi_header_set_value (dwg, "USERR4", &userr4, 0)
        && userr4 == dwg->header_vars.USERR4)
      pass ();
    else
      fail ("HEADER.USERR4 [BD] set+1 %g != %g",
            dwg->header_vars.USERR4, userr4);
    userr4--;
    dwg_dynapi_header_set_value (dwg, "USERR4", &userr4, 0);

  }
  {
    BITCODE_BD userr5;
    if (dwg_dynapi_header_value (dwg, "USERR5", &userr5, NULL)
        && userr5 == dwg->header_vars.USERR5)
      pass ();
    else
      fail ("HEADER.USERR5 [BD] %g != %g", dwg->header_vars.USERR5, userr5);
    userr5++;
    if (dwg_dynapi_header_set_value (dwg, "USERR5", &userr5, 0)
        && userr5 == dwg->header_vars.USERR5)
      pass ();
    else
      fail ("HEADER.USERR5 [BD] set+1 %g != %g",
            dwg->header_vars.USERR5, userr5);
    userr5--;
    dwg_dynapi_header_set_value (dwg, "USERR5", &userr5, 0);

  }
  {
    BITCODE_BD chamfera;
    if (dwg_dynapi_header_value (dwg, "CHAMFERA", &chamfera, NULL)
        && chamfera == dwg->header_vars.CHAMFERA)
      pass ();
    else
      fail ("HEADER.CHAMFERA [BD] %g != %g", dwg->header_vars.CHAMFERA, chamfera);
    chamfera++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERA", &chamfera, 0)
        && chamfera == dwg->header_vars.CHAMFERA)
      pass ();
    else
      fail ("HEADER.CHAMFERA [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERA, chamfera);
    chamfera--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERA", &chamfera, 0);

  }
  {
    BITCODE_BD chamferb;
    if (dwg_dynapi_header_value (dwg, "CHAMFERB", &chamferb, NULL)
        && chamferb == dwg->header_vars.CHAMFERB)
      pass ();
    else
      fail ("HEADER.CHAMFERB [BD] %g != %g", dwg->header_vars.CHAMFERB, chamferb);
    chamferb++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERB", &chamferb, 0)
        && chamferb == dwg->header_vars.CHAMFERB)
      pass ();
    else
      fail ("HEADER.CHAMFERB [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERB, chamferb);
    chamferb--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERB", &chamferb, 0);

  }
  {
    BITCODE_BD chamferc;
    if (dwg_dynapi_header_value (dwg, "CHAMFERC", &chamferc, NULL)
        && chamferc == dwg->header_vars.CHAMFERC)
      pass ();
    else
      fail ("HEADER.CHAMFERC [BD] %g != %g", dwg->header_vars.CHAMFERC, chamferc);
    chamferc++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERC", &chamferc, 0)
        && chamferc == dwg->header_vars.CHAMFERC)
      pass ();
    else
      fail ("HEADER.CHAMFERC [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERC, chamferc);
    chamferc--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERC", &chamferc, 0);

  }
  {
    BITCODE_BD chamferd;
    if (dwg_dynapi_header_value (dwg, "CHAMFERD", &chamferd, NULL)
        && chamferd == dwg->header_vars.CHAMFERD)
      pass ();
    else
      fail ("HEADER.CHAMFERD [BD] %g != %g", dwg->header_vars.CHAMFERD, chamferd);
    chamferd++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERD", &chamferd, 0)
        && chamferd == dwg->header_vars.CHAMFERD)
      pass ();
    else
      fail ("HEADER.CHAMFERD [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERD, chamferd);
    chamferd--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERD", &chamferd, 0);

  }
  {
    BITCODE_BD facetres;
    if (dwg_dynapi_header_value (dwg, "FACETRES", &facetres, NULL)
        && facetres == dwg->header_vars.FACETRES)
      pass ();
    else
      fail ("HEADER.FACETRES [BD] %g != %g", dwg->header_vars.FACETRES, facetres);
    facetres++;
    if (dwg_dynapi_header_set_value (dwg, "FACETRES", &facetres, 0)
        && facetres == dwg->header_vars.FACETRES)
      pass ();
    else
      fail ("HEADER.FACETRES [BD] set+1 %g != %g",
            dwg->header_vars.FACETRES, facetres);
    facetres--;
    dwg_dynapi_header_set_value (dwg, "FACETRES", &facetres, 0);

  }
  {
    BITCODE_BD cmlscale;
    if (dwg_dynapi_header_value (dwg, "CMLSCALE", &cmlscale, NULL)
        && cmlscale == dwg->header_vars.CMLSCALE)
      pass ();
    else
      fail ("HEADER.CMLSCALE [BD] %g != %g", dwg->header_vars.CMLSCALE, cmlscale);
    cmlscale++;
    if (dwg_dynapi_header_set_value (dwg, "CMLSCALE", &cmlscale, 0)
        && cmlscale == dwg->header_vars.CMLSCALE)
      pass ();
    else
      fail ("HEADER.CMLSCALE [BD] set+1 %g != %g",
            dwg->header_vars.CMLSCALE, cmlscale);
    cmlscale--;
    dwg_dynapi_header_set_value (dwg, "CMLSCALE", &cmlscale, 0);

  }
  {
    BITCODE_BD celtscale;
    if (dwg_dynapi_header_value (dwg, "CELTSCALE", &celtscale, NULL)
        && celtscale == dwg->header_vars.CELTSCALE)
      pass ();
    else
      fail ("HEADER.CELTSCALE [BD] %g != %g", dwg->header_vars.CELTSCALE, celtscale);
    celtscale++;
    if (dwg_dynapi_header_set_value (dwg, "CELTSCALE", &celtscale, 0)
        && celtscale == dwg->header_vars.CELTSCALE)
      pass ();
    else
      fail ("HEADER.CELTSCALE [BD] set+1 %g != %g",
            dwg->header_vars.CELTSCALE, celtscale);
    celtscale--;
    dwg_dynapi_header_set_value (dwg, "CELTSCALE", &celtscale, 0);

  }
  {
    BITCODE_TV menu;
    if (dwg_dynapi_header_value (dwg, "MENU", &menu, NULL)
        && !memcmp (&menu, &dwg->header_vars.MENU, sizeof (dwg->header_vars.MENU))
       )
      pass ();
    else
      fail ("HEADER.MENU [TV]");
  }
  {
    BITCODE_TIMEBLL tdcreate;
    if (dwg_dynapi_header_value (dwg, "TDCREATE", &tdcreate, NULL)
        && !memcmp (&tdcreate, &dwg->header_vars.TDCREATE, sizeof (dwg->header_vars.TDCREATE))
       )
      pass ();
    else
      fail ("HEADER.TDCREATE [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tdupdate;
    if (dwg_dynapi_header_value (dwg, "TDUPDATE", &tdupdate, NULL)
        && !memcmp (&tdupdate, &dwg->header_vars.TDUPDATE, sizeof (dwg->header_vars.TDUPDATE))
       )
      pass ();
    else
      fail ("HEADER.TDUPDATE [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tducreate;
    if (dwg_dynapi_header_value (dwg, "TDUCREATE", &tducreate, NULL)
        && !memcmp (&tducreate, &dwg->header_vars.TDUCREATE, sizeof (dwg->header_vars.TDUCREATE))
       )
      pass ();
    else
      fail ("HEADER.TDUCREATE [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tduupdate;
    if (dwg_dynapi_header_value (dwg, "TDUUPDATE", &tduupdate, NULL)
        && !memcmp (&tduupdate, &dwg->header_vars.TDUUPDATE, sizeof (dwg->header_vars.TDUUPDATE))
       )
      pass ();
    else
      fail ("HEADER.TDUUPDATE [TIMEBLL]");
  }
  {
    BITCODE_BL unknown_15;
    if (dwg_dynapi_header_value (dwg, "unknown_15", &unknown_15, NULL)
        && unknown_15 == dwg->header_vars.unknown_15)
      pass ();
    else
      fail ("HEADER.unknown_15 [BL] %u != %u", dwg->header_vars.unknown_15, unknown_15);
    unknown_15++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_15", &unknown_15, 0)
        && unknown_15 == dwg->header_vars.unknown_15)
      pass ();
    else
      fail ("HEADER.unknown_15 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_15, unknown_15);
    unknown_15--;
    dwg_dynapi_header_set_value (dwg, "unknown_15", &unknown_15, 0);

  }
  {
    BITCODE_BL unknown_16;
    if (dwg_dynapi_header_value (dwg, "unknown_16", &unknown_16, NULL)
        && unknown_16 == dwg->header_vars.unknown_16)
      pass ();
    else
      fail ("HEADER.unknown_16 [BL] %u != %u", dwg->header_vars.unknown_16, unknown_16);
    unknown_16++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_16", &unknown_16, 0)
        && unknown_16 == dwg->header_vars.unknown_16)
      pass ();
    else
      fail ("HEADER.unknown_16 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_16, unknown_16);
    unknown_16--;
    dwg_dynapi_header_set_value (dwg, "unknown_16", &unknown_16, 0);

  }
  {
    BITCODE_BL unknown_17;
    if (dwg_dynapi_header_value (dwg, "unknown_17", &unknown_17, NULL)
        && unknown_17 == dwg->header_vars.unknown_17)
      pass ();
    else
      fail ("HEADER.unknown_17 [BL] %u != %u", dwg->header_vars.unknown_17, unknown_17);
    unknown_17++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_17", &unknown_17, 0)
        && unknown_17 == dwg->header_vars.unknown_17)
      pass ();
    else
      fail ("HEADER.unknown_17 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_17, unknown_17);
    unknown_17--;
    dwg_dynapi_header_set_value (dwg, "unknown_17", &unknown_17, 0);

  }
  {
    BITCODE_TIMEBLL tdindwg;
    if (dwg_dynapi_header_value (dwg, "TDINDWG", &tdindwg, NULL)
        && !memcmp (&tdindwg, &dwg->header_vars.TDINDWG, sizeof (dwg->header_vars.TDINDWG))
       )
      pass ();
    else
      fail ("HEADER.TDINDWG [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tdusrtimer;
    if (dwg_dynapi_header_value (dwg, "TDUSRTIMER", &tdusrtimer, NULL)
        && !memcmp (&tdusrtimer, &dwg->header_vars.TDUSRTIMER, sizeof (dwg->header_vars.TDUSRTIMER))
       )
      pass ();
    else
      fail ("HEADER.TDUSRTIMER [TIMEBLL]");
  }
  {
    BITCODE_CMC cecolor;
    if (dwg_dynapi_header_value (dwg, "CECOLOR", &cecolor, NULL)
        && !memcmp (&cecolor, &dwg->header_vars.CECOLOR, sizeof (dwg->header_vars.CECOLOR))
       )
      pass ();
    else
      fail ("HEADER.CECOLOR [CMC]");
  }
  {
    BITCODE_BS handling;
    if (dwg_dynapi_header_value (dwg, "HANDLING", &handling, NULL)
        && handling == dwg->header_vars.HANDLING)
      pass ();
    else
      fail ("HEADER.HANDLING [BS] %hu != %hu", dwg->header_vars.HANDLING, handling);
    handling++;
    if (dwg_dynapi_header_set_value (dwg, "HANDLING", &handling, 0)
        && handling == dwg->header_vars.HANDLING)
      pass ();
    else
      fail ("HEADER.HANDLING [BS] set+1 %hu != %hu",
            dwg->header_vars.HANDLING, handling);
    handling--;
    dwg_dynapi_header_set_value (dwg, "HANDLING", &handling, 0);

  }
  {
    BITCODE_H handseed;
    if (dwg_dynapi_header_value (dwg, "HANDSEED", &handseed, NULL)
        && !memcmp (&handseed, &dwg->header_vars.HANDSEED, sizeof (dwg->header_vars.HANDSEED))
       )
      pass ();
    else
      fail ("HEADER.HANDSEED [H]");
  }
  {
    BITCODE_H clayer;
    if (dwg_dynapi_header_value (dwg, "CLAYER", &clayer, NULL)
        && !memcmp (&clayer, &dwg->header_vars.CLAYER, sizeof (dwg->header_vars.CLAYER))
       )
      pass ();
    else
      fail ("HEADER.CLAYER [H]");
  }
  {
    BITCODE_H textstyle;
    if (dwg_dynapi_header_value (dwg, "TEXTSTYLE", &textstyle, NULL)
        && !memcmp (&textstyle, &dwg->header_vars.TEXTSTYLE, sizeof (dwg->header_vars.TEXTSTYLE))
       )
      pass ();
    else
      fail ("HEADER.TEXTSTYLE [H]");
  }
  {
    BITCODE_H celtype;
    if (dwg_dynapi_header_value (dwg, "CELTYPE", &celtype, NULL)
        && !memcmp (&celtype, &dwg->header_vars.CELTYPE, sizeof (dwg->header_vars.CELTYPE))
       )
      pass ();
    else
      fail ("HEADER.CELTYPE [H]");
  }
  {
    BITCODE_H cmaterial;
    if (dwg_dynapi_header_value (dwg, "CMATERIAL", &cmaterial, NULL)
        && !memcmp (&cmaterial, &dwg->header_vars.CMATERIAL, sizeof (dwg->header_vars.CMATERIAL))
       )
      pass ();
    else
      fail ("HEADER.CMATERIAL [H]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_header_value (dwg, "DIMSTYLE", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dwg->header_vars.DIMSTYLE, sizeof (dwg->header_vars.DIMSTYLE))
       )
      pass ();
    else
      fail ("HEADER.DIMSTYLE [H]");
  }
  {
    BITCODE_H cmlstyle;
    if (dwg_dynapi_header_value (dwg, "CMLSTYLE", &cmlstyle, NULL)
        && !memcmp (&cmlstyle, &dwg->header_vars.CMLSTYLE, sizeof (dwg->header_vars.CMLSTYLE))
       )
      pass ();
    else
      fail ("HEADER.CMLSTYLE [H]");
  }
  {
    BITCODE_BD psvpscale;
    if (dwg_dynapi_header_value (dwg, "PSVPSCALE", &psvpscale, NULL)
        && psvpscale == dwg->header_vars.PSVPSCALE)
      pass ();
    else
      fail ("HEADER.PSVPSCALE [BD] %g != %g", dwg->header_vars.PSVPSCALE, psvpscale);
    psvpscale++;
    if (dwg_dynapi_header_set_value (dwg, "PSVPSCALE", &psvpscale, 0)
        && psvpscale == dwg->header_vars.PSVPSCALE)
      pass ();
    else
      fail ("HEADER.PSVPSCALE [BD] set+1 %g != %g",
            dwg->header_vars.PSVPSCALE, psvpscale);
    psvpscale--;
    dwg_dynapi_header_set_value (dwg, "PSVPSCALE", &psvpscale, 0);

  }
  {
    BITCODE_3BD pinsbase;
    if (dwg_dynapi_header_value (dwg, "PINSBASE", &pinsbase, NULL)
        && !memcmp (&pinsbase, &dwg->header_vars.PINSBASE, sizeof (dwg->header_vars.PINSBASE))
       )
      pass ();
    else
      fail ("HEADER.PINSBASE [3BD]");
  }
  {
    BITCODE_3BD pextmin;
    if (dwg_dynapi_header_value (dwg, "PEXTMIN", &pextmin, NULL)
        && !memcmp (&pextmin, &dwg->header_vars.PEXTMIN, sizeof (dwg->header_vars.PEXTMIN))
       )
      pass ();
    else
      fail ("HEADER.PEXTMIN [3BD]");
  }
  {
    BITCODE_3BD pextmax;
    if (dwg_dynapi_header_value (dwg, "PEXTMAX", &pextmax, NULL)
        && !memcmp (&pextmax, &dwg->header_vars.PEXTMAX, sizeof (dwg->header_vars.PEXTMAX))
       )
      pass ();
    else
      fail ("HEADER.PEXTMAX [3BD]");
  }
  {
    BITCODE_2RD plimmin;
    if (dwg_dynapi_header_value (dwg, "PLIMMIN", &plimmin, NULL)
        && !memcmp (&plimmin, &dwg->header_vars.PLIMMIN, sizeof (dwg->header_vars.PLIMMIN))
       )
      pass ();
    else
      fail ("HEADER.PLIMMIN [2RD]");
  }
  {
    BITCODE_2RD plimmax;
    if (dwg_dynapi_header_value (dwg, "PLIMMAX", &plimmax, NULL)
        && !memcmp (&plimmax, &dwg->header_vars.PLIMMAX, sizeof (dwg->header_vars.PLIMMAX))
       )
      pass ();
    else
      fail ("HEADER.PLIMMAX [2RD]");
  }
  {
    BITCODE_BD pelevation;
    if (dwg_dynapi_header_value (dwg, "PELEVATION", &pelevation, NULL)
        && pelevation == dwg->header_vars.PELEVATION)
      pass ();
    else
      fail ("HEADER.PELEVATION [BD] %g != %g", dwg->header_vars.PELEVATION, pelevation);
    pelevation++;
    if (dwg_dynapi_header_set_value (dwg, "PELEVATION", &pelevation, 0)
        && pelevation == dwg->header_vars.PELEVATION)
      pass ();
    else
      fail ("HEADER.PELEVATION [BD] set+1 %g != %g",
            dwg->header_vars.PELEVATION, pelevation);
    pelevation--;
    dwg_dynapi_header_set_value (dwg, "PELEVATION", &pelevation, 0);

  }
  {
    BITCODE_3BD pucsorg;
    if (dwg_dynapi_header_value (dwg, "PUCSORG", &pucsorg, NULL)
        && !memcmp (&pucsorg, &dwg->header_vars.PUCSORG, sizeof (dwg->header_vars.PUCSORG))
       )
      pass ();
    else
      fail ("HEADER.PUCSORG [3BD]");
  }
  {
    BITCODE_3BD pucsxdir;
    if (dwg_dynapi_header_value (dwg, "PUCSXDIR", &pucsxdir, NULL)
        && !memcmp (&pucsxdir, &dwg->header_vars.PUCSXDIR, sizeof (dwg->header_vars.PUCSXDIR))
       )
      pass ();
    else
      fail ("HEADER.PUCSXDIR [3BD]");
  }
  {
    BITCODE_3BD pucsydir;
    if (dwg_dynapi_header_value (dwg, "PUCSYDIR", &pucsydir, NULL)
        && !memcmp (&pucsydir, &dwg->header_vars.PUCSYDIR, sizeof (dwg->header_vars.PUCSYDIR))
       )
      pass ();
    else
      fail ("HEADER.PUCSYDIR [3BD]");
  }
  {
    BITCODE_H pucsname;
    if (dwg_dynapi_header_value (dwg, "PUCSNAME", &pucsname, NULL)
        && !memcmp (&pucsname, &dwg->header_vars.PUCSNAME, sizeof (dwg->header_vars.PUCSNAME))
       )
      pass ();
    else
      fail ("HEADER.PUCSNAME [H]");
  }
  {
    BITCODE_H pucsbase;
    if (dwg_dynapi_header_value (dwg, "PUCSBASE", &pucsbase, NULL)
        && !memcmp (&pucsbase, &dwg->header_vars.PUCSBASE, sizeof (dwg->header_vars.PUCSBASE))
       )
      pass ();
    else
      fail ("HEADER.PUCSBASE [H]");
  }
  {
    BITCODE_H pucsorthoref;
    if (dwg_dynapi_header_value (dwg, "PUCSORTHOREF", &pucsorthoref, NULL)
        && !memcmp (&pucsorthoref, &dwg->header_vars.PUCSORTHOREF, sizeof (dwg->header_vars.PUCSORTHOREF))
       )
      pass ();
    else
      fail ("HEADER.PUCSORTHOREF [H]");
  }
  {
    BITCODE_BS pucsorthoview;
    if (dwg_dynapi_header_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, NULL)
        && pucsorthoview == dwg->header_vars.PUCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.PUCSORTHOVIEW [BS] %hu != %hu", dwg->header_vars.PUCSORTHOVIEW, pucsorthoview);
    pucsorthoview++;
    if (dwg_dynapi_header_set_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, 0)
        && pucsorthoview == dwg->header_vars.PUCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.PUCSORTHOVIEW [BS] set+1 %hu != %hu",
            dwg->header_vars.PUCSORTHOVIEW, pucsorthoview);
    pucsorthoview--;
    dwg_dynapi_header_set_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, 0);

  }
  {
    BITCODE_3BD pucsorgtop;
    if (dwg_dynapi_header_value (dwg, "PUCSORGTOP", &pucsorgtop, NULL)
        && !memcmp (&pucsorgtop, &dwg->header_vars.PUCSORGTOP, sizeof (dwg->header_vars.PUCSORGTOP))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGTOP [3BD]");
  }
  {
    BITCODE_3BD pucsorgbottom;
    if (dwg_dynapi_header_value (dwg, "PUCSORGBOTTOM", &pucsorgbottom, NULL)
        && !memcmp (&pucsorgbottom, &dwg->header_vars.PUCSORGBOTTOM, sizeof (dwg->header_vars.PUCSORGBOTTOM))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGBOTTOM [3BD]");
  }
  {
    BITCODE_3BD pucsorgleft;
    if (dwg_dynapi_header_value (dwg, "PUCSORGLEFT", &pucsorgleft, NULL)
        && !memcmp (&pucsorgleft, &dwg->header_vars.PUCSORGLEFT, sizeof (dwg->header_vars.PUCSORGLEFT))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGLEFT [3BD]");
  }
  {
    BITCODE_3BD pucsorgright;
    if (dwg_dynapi_header_value (dwg, "PUCSORGRIGHT", &pucsorgright, NULL)
        && !memcmp (&pucsorgright, &dwg->header_vars.PUCSORGRIGHT, sizeof (dwg->header_vars.PUCSORGRIGHT))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGRIGHT [3BD]");
  }
  {
    BITCODE_3BD pucsorgfront;
    if (dwg_dynapi_header_value (dwg, "PUCSORGFRONT", &pucsorgfront, NULL)
        && !memcmp (&pucsorgfront, &dwg->header_vars.PUCSORGFRONT, sizeof (dwg->header_vars.PUCSORGFRONT))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGFRONT [3BD]");
  }
  {
    BITCODE_3BD pucsorgback;
    if (dwg_dynapi_header_value (dwg, "PUCSORGBACK", &pucsorgback, NULL)
        && !memcmp (&pucsorgback, &dwg->header_vars.PUCSORGBACK, sizeof (dwg->header_vars.PUCSORGBACK))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGBACK [3BD]");
  }
  {
    BITCODE_3BD insbase;
    if (dwg_dynapi_header_value (dwg, "INSBASE", &insbase, NULL)
        && !memcmp (&insbase, &dwg->header_vars.INSBASE, sizeof (dwg->header_vars.INSBASE))
       )
      pass ();
    else
      fail ("HEADER.INSBASE [3BD]");
  }
  {
    BITCODE_3BD extmin;
    if (dwg_dynapi_header_value (dwg, "EXTMIN", &extmin, NULL)
        && !memcmp (&extmin, &dwg->header_vars.EXTMIN, sizeof (dwg->header_vars.EXTMIN))
       )
      pass ();
    else
      fail ("HEADER.EXTMIN [3BD]");
  }
  {
    BITCODE_3BD extmax;
    if (dwg_dynapi_header_value (dwg, "EXTMAX", &extmax, NULL)
        && !memcmp (&extmax, &dwg->header_vars.EXTMAX, sizeof (dwg->header_vars.EXTMAX))
       )
      pass ();
    else
      fail ("HEADER.EXTMAX [3BD]");
  }
  {
    BITCODE_2RD limmin;
    if (dwg_dynapi_header_value (dwg, "LIMMIN", &limmin, NULL)
        && !memcmp (&limmin, &dwg->header_vars.LIMMIN, sizeof (dwg->header_vars.LIMMIN))
       )
      pass ();
    else
      fail ("HEADER.LIMMIN [2RD]");
  }
  {
    BITCODE_2RD limmax;
    if (dwg_dynapi_header_value (dwg, "LIMMAX", &limmax, NULL)
        && !memcmp (&limmax, &dwg->header_vars.LIMMAX, sizeof (dwg->header_vars.LIMMAX))
       )
      pass ();
    else
      fail ("HEADER.LIMMAX [2RD]");
  }
  {
    BITCODE_2RD viewctr;
    if (dwg_dynapi_header_value (dwg, "VIEWCTR", &viewctr, NULL)
        && !memcmp (&viewctr, &dwg->header_vars.VIEWCTR, sizeof (dwg->header_vars.VIEWCTR))
       )
      pass ();
    else
      fail ("HEADER.VIEWCTR [2RD]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_header_value (dwg, "ELEVATION", &elevation, NULL)
        && elevation == dwg->header_vars.ELEVATION)
      pass ();
    else
      fail ("HEADER.ELEVATION [BD] %g != %g", dwg->header_vars.ELEVATION, elevation);
    elevation++;
    if (dwg_dynapi_header_set_value (dwg, "ELEVATION", &elevation, 0)
        && elevation == dwg->header_vars.ELEVATION)
      pass ();
    else
      fail ("HEADER.ELEVATION [BD] set+1 %g != %g",
            dwg->header_vars.ELEVATION, elevation);
    elevation--;
    dwg_dynapi_header_set_value (dwg, "ELEVATION", &elevation, 0);

  }
  {
    BITCODE_RD viewsize;
    if (dwg_dynapi_header_value (dwg, "VIEWSIZE", &viewsize, NULL)
        && viewsize == dwg->header_vars.VIEWSIZE)
      pass ();
    else
      fail ("HEADER.VIEWSIZE [RD] %g != %g", dwg->header_vars.VIEWSIZE, viewsize);
    viewsize++;
    if (dwg_dynapi_header_set_value (dwg, "VIEWSIZE", &viewsize, 0)
        && viewsize == dwg->header_vars.VIEWSIZE)
      pass ();
    else
      fail ("HEADER.VIEWSIZE [RD] set+1 %g != %g",
            dwg->header_vars.VIEWSIZE, viewsize);
    viewsize--;
    dwg_dynapi_header_set_value (dwg, "VIEWSIZE", &viewsize, 0);

  }
  {
    BITCODE_RS snapmode;
    if (dwg_dynapi_header_value (dwg, "SNAPMODE", &snapmode, NULL)
        && snapmode == dwg->header_vars.SNAPMODE)
      pass ();
    else
      fail ("HEADER.SNAPMODE [RS] %hu != %hu", dwg->header_vars.SNAPMODE, snapmode);
    snapmode++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPMODE", &snapmode, 0)
        && snapmode == dwg->header_vars.SNAPMODE)
      pass ();
    else
      fail ("HEADER.SNAPMODE [RS] set+1 %hu != %hu",
            dwg->header_vars.SNAPMODE, snapmode);
    snapmode--;
    dwg_dynapi_header_set_value (dwg, "SNAPMODE", &snapmode, 0);

  }
  {
    BITCODE_2RD snapunit;
    if (dwg_dynapi_header_value (dwg, "SNAPUNIT", &snapunit, NULL)
        && !memcmp (&snapunit, &dwg->header_vars.SNAPUNIT, sizeof (dwg->header_vars.SNAPUNIT))
       )
      pass ();
    else
      fail ("HEADER.SNAPUNIT [2RD]");
  }
  {
    BITCODE_2RD snapbase;
    if (dwg_dynapi_header_value (dwg, "SNAPBASE", &snapbase, NULL)
        && !memcmp (&snapbase, &dwg->header_vars.SNAPBASE, sizeof (dwg->header_vars.SNAPBASE))
       )
      pass ();
    else
      fail ("HEADER.SNAPBASE [2RD]");
  }
  {
    BITCODE_RD snapang;
    if (dwg_dynapi_header_value (dwg, "SNAPANG", &snapang, NULL)
        && snapang == dwg->header_vars.SNAPANG)
      pass ();
    else
      fail ("HEADER.SNAPANG [RD] %g != %g", dwg->header_vars.SNAPANG, snapang);
    snapang++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPANG", &snapang, 0)
        && snapang == dwg->header_vars.SNAPANG)
      pass ();
    else
      fail ("HEADER.SNAPANG [RD] set+1 %g != %g",
            dwg->header_vars.SNAPANG, snapang);
    snapang--;
    dwg_dynapi_header_set_value (dwg, "SNAPANG", &snapang, 0);

  }
  {
    BITCODE_RS snapstyl;
    if (dwg_dynapi_header_value (dwg, "SNAPSTYL", &snapstyl, NULL)
        && snapstyl == dwg->header_vars.SNAPSTYL)
      pass ();
    else
      fail ("HEADER.SNAPSTYL [RS] %hu != %hu", dwg->header_vars.SNAPSTYL, snapstyl);
    snapstyl++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPSTYL", &snapstyl, 0)
        && snapstyl == dwg->header_vars.SNAPSTYL)
      pass ();
    else
      fail ("HEADER.SNAPSTYL [RS] set+1 %hu != %hu",
            dwg->header_vars.SNAPSTYL, snapstyl);
    snapstyl--;
    dwg_dynapi_header_set_value (dwg, "SNAPSTYL", &snapstyl, 0);

  }
  {
    BITCODE_RS snapisopair;
    if (dwg_dynapi_header_value (dwg, "SNAPISOPAIR", &snapisopair, NULL)
        && snapisopair == dwg->header_vars.SNAPISOPAIR)
      pass ();
    else
      fail ("HEADER.SNAPISOPAIR [RS] %hu != %hu", dwg->header_vars.SNAPISOPAIR, snapisopair);
    snapisopair++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPISOPAIR", &snapisopair, 0)
        && snapisopair == dwg->header_vars.SNAPISOPAIR)
      pass ();
    else
      fail ("HEADER.SNAPISOPAIR [RS] set+1 %hu != %hu",
            dwg->header_vars.SNAPISOPAIR, snapisopair);
    snapisopair--;
    dwg_dynapi_header_set_value (dwg, "SNAPISOPAIR", &snapisopair, 0);

  }
  {
    BITCODE_RS gridmode;
    if (dwg_dynapi_header_value (dwg, "GRIDMODE", &gridmode, NULL)
        && gridmode == dwg->header_vars.GRIDMODE)
      pass ();
    else
      fail ("HEADER.GRIDMODE [RS] %hu != %hu", dwg->header_vars.GRIDMODE, gridmode);
    gridmode++;
    if (dwg_dynapi_header_set_value (dwg, "GRIDMODE", &gridmode, 0)
        && gridmode == dwg->header_vars.GRIDMODE)
      pass ();
    else
      fail ("HEADER.GRIDMODE [RS] set+1 %hu != %hu",
            dwg->header_vars.GRIDMODE, gridmode);
    gridmode--;
    dwg_dynapi_header_set_value (dwg, "GRIDMODE", &gridmode, 0);

  }
  {
    BITCODE_2RD gridunit;
    if (dwg_dynapi_header_value (dwg, "GRIDUNIT", &gridunit, NULL)
        && !memcmp (&gridunit, &dwg->header_vars.GRIDUNIT, sizeof (dwg->header_vars.GRIDUNIT))
       )
      pass ();
    else
      fail ("HEADER.GRIDUNIT [2RD]");
  }
  {
    BITCODE_3BD ucsorg;
    if (dwg_dynapi_header_value (dwg, "UCSORG", &ucsorg, NULL)
        && !memcmp (&ucsorg, &dwg->header_vars.UCSORG, sizeof (dwg->header_vars.UCSORG))
       )
      pass ();
    else
      fail ("HEADER.UCSORG [3BD]");
  }
  {
    BITCODE_3BD ucsxdir;
    if (dwg_dynapi_header_value (dwg, "UCSXDIR", &ucsxdir, NULL)
        && !memcmp (&ucsxdir, &dwg->header_vars.UCSXDIR, sizeof (dwg->header_vars.UCSXDIR))
       )
      pass ();
    else
      fail ("HEADER.UCSXDIR [3BD]");
  }
  {
    BITCODE_3BD ucsydir;
    if (dwg_dynapi_header_value (dwg, "UCSYDIR", &ucsydir, NULL)
        && !memcmp (&ucsydir, &dwg->header_vars.UCSYDIR, sizeof (dwg->header_vars.UCSYDIR))
       )
      pass ();
    else
      fail ("HEADER.UCSYDIR [3BD]");
  }
  {
    BITCODE_H ucsname;
    if (dwg_dynapi_header_value (dwg, "UCSNAME", &ucsname, NULL)
        && !memcmp (&ucsname, &dwg->header_vars.UCSNAME, sizeof (dwg->header_vars.UCSNAME))
       )
      pass ();
    else
      fail ("HEADER.UCSNAME [H]");
  }
  {
    BITCODE_H ucsbase;
    if (dwg_dynapi_header_value (dwg, "UCSBASE", &ucsbase, NULL)
        && !memcmp (&ucsbase, &dwg->header_vars.UCSBASE, sizeof (dwg->header_vars.UCSBASE))
       )
      pass ();
    else
      fail ("HEADER.UCSBASE [H]");
  }
  {
    BITCODE_BS ucsorthoview;
    if (dwg_dynapi_header_value (dwg, "UCSORTHOVIEW", &ucsorthoview, NULL)
        && ucsorthoview == dwg->header_vars.UCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.UCSORTHOVIEW [BS] %hu != %hu", dwg->header_vars.UCSORTHOVIEW, ucsorthoview);
    ucsorthoview++;
    if (dwg_dynapi_header_set_value (dwg, "UCSORTHOVIEW", &ucsorthoview, 0)
        && ucsorthoview == dwg->header_vars.UCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.UCSORTHOVIEW [BS] set+1 %hu != %hu",
            dwg->header_vars.UCSORTHOVIEW, ucsorthoview);
    ucsorthoview--;
    dwg_dynapi_header_set_value (dwg, "UCSORTHOVIEW", &ucsorthoview, 0);

  }
  {
    BITCODE_H ucsorthoref;
    if (dwg_dynapi_header_value (dwg, "UCSORTHOREF", &ucsorthoref, NULL)
        && !memcmp (&ucsorthoref, &dwg->header_vars.UCSORTHOREF, sizeof (dwg->header_vars.UCSORTHOREF))
       )
      pass ();
    else
      fail ("HEADER.UCSORTHOREF [H]");
  }
  {
    BITCODE_3BD ucsorgtop;
    if (dwg_dynapi_header_value (dwg, "UCSORGTOP", &ucsorgtop, NULL)
        && !memcmp (&ucsorgtop, &dwg->header_vars.UCSORGTOP, sizeof (dwg->header_vars.UCSORGTOP))
       )
      pass ();
    else
      fail ("HEADER.UCSORGTOP [3BD]");
  }
  {
    BITCODE_3BD ucsorgbottom;
    if (dwg_dynapi_header_value (dwg, "UCSORGBOTTOM", &ucsorgbottom, NULL)
        && !memcmp (&ucsorgbottom, &dwg->header_vars.UCSORGBOTTOM, sizeof (dwg->header_vars.UCSORGBOTTOM))
       )
      pass ();
    else
      fail ("HEADER.UCSORGBOTTOM [3BD]");
  }
  {
    BITCODE_3BD ucsorgleft;
    if (dwg_dynapi_header_value (dwg, "UCSORGLEFT", &ucsorgleft, NULL)
        && !memcmp (&ucsorgleft, &dwg->header_vars.UCSORGLEFT, sizeof (dwg->header_vars.UCSORGLEFT))
       )
      pass ();
    else
      fail ("HEADER.UCSORGLEFT [3BD]");
  }
  {
    BITCODE_3BD ucsorgright;
    if (dwg_dynapi_header_value (dwg, "UCSORGRIGHT", &ucsorgright, NULL)
        && !memcmp (&ucsorgright, &dwg->header_vars.UCSORGRIGHT, sizeof (dwg->header_vars.UCSORGRIGHT))
       )
      pass ();
    else
      fail ("HEADER.UCSORGRIGHT [3BD]");
  }
  {
    BITCODE_3BD ucsorgfront;
    if (dwg_dynapi_header_value (dwg, "UCSORGFRONT", &ucsorgfront, NULL)
        && !memcmp (&ucsorgfront, &dwg->header_vars.UCSORGFRONT, sizeof (dwg->header_vars.UCSORGFRONT))
       )
      pass ();
    else
      fail ("HEADER.UCSORGFRONT [3BD]");
  }
  {
    BITCODE_3BD ucsorgback;
    if (dwg_dynapi_header_value (dwg, "UCSORGBACK", &ucsorgback, NULL)
        && !memcmp (&ucsorgback, &dwg->header_vars.UCSORGBACK, sizeof (dwg->header_vars.UCSORGBACK))
       )
      pass ();
    else
      fail ("HEADER.UCSORGBACK [3BD]");
  }
  {
    BITCODE_TV dimpost;
    if (dwg_dynapi_header_value (dwg, "DIMPOST", &dimpost, NULL)
        && !memcmp (&dimpost, &dwg->header_vars.DIMPOST, sizeof (dwg->header_vars.DIMPOST))
       )
      pass ();
    else
      fail ("HEADER.DIMPOST [TV]");
  }
  {
    BITCODE_TV dimapost;
    if (dwg_dynapi_header_value (dwg, "DIMAPOST", &dimapost, NULL)
        && !memcmp (&dimapost, &dwg->header_vars.DIMAPOST, sizeof (dwg->header_vars.DIMAPOST))
       )
      pass ();
    else
      fail ("HEADER.DIMAPOST [TV]");
  }
  {
    BITCODE_B dimtol;
    if (dwg_dynapi_header_value (dwg, "DIMTOL", &dimtol, NULL)
        && dimtol == dwg->header_vars.DIMTOL)
      pass ();
    else
      fail ("HEADER.DIMTOL [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOL, dimtol);
    dimtol++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOL", &dimtol, 0)
        && dimtol == dwg->header_vars.DIMTOL)
      pass ();
    else
      fail ("HEADER.DIMTOL [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTOL, dimtol);
    dimtol--;
    dwg_dynapi_header_set_value (dwg, "DIMTOL", &dimtol, 0);

  }
  {
    BITCODE_B dimlim;
    if (dwg_dynapi_header_value (dwg, "DIMLIM", &dimlim, NULL)
        && dimlim == dwg->header_vars.DIMLIM)
      pass ();
    else
      fail ("HEADER.DIMLIM [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMLIM, dimlim);
    dimlim++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLIM", &dimlim, 0)
        && dimlim == dwg->header_vars.DIMLIM)
      pass ();
    else
      fail ("HEADER.DIMLIM [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMLIM, dimlim);
    dimlim--;
    dwg_dynapi_header_set_value (dwg, "DIMLIM", &dimlim, 0);

  }
  {
    BITCODE_B dimtih;
    if (dwg_dynapi_header_value (dwg, "DIMTIH", &dimtih, NULL)
        && dimtih == dwg->header_vars.DIMTIH)
      pass ();
    else
      fail ("HEADER.DIMTIH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTIH, dimtih);
    dimtih++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTIH", &dimtih, 0)
        && dimtih == dwg->header_vars.DIMTIH)
      pass ();
    else
      fail ("HEADER.DIMTIH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTIH, dimtih);
    dimtih--;
    dwg_dynapi_header_set_value (dwg, "DIMTIH", &dimtih, 0);

  }
  {
    BITCODE_B dimtoh;
    if (dwg_dynapi_header_value (dwg, "DIMTOH", &dimtoh, NULL)
        && dimtoh == dwg->header_vars.DIMTOH)
      pass ();
    else
      fail ("HEADER.DIMTOH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOH, dimtoh);
    dimtoh++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOH", &dimtoh, 0)
        && dimtoh == dwg->header_vars.DIMTOH)
      pass ();
    else
      fail ("HEADER.DIMTOH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTOH, dimtoh);
    dimtoh--;
    dwg_dynapi_header_set_value (dwg, "DIMTOH", &dimtoh, 0);

  }
  {
    BITCODE_B dimse1;
    if (dwg_dynapi_header_value (dwg, "DIMSE1", &dimse1, NULL)
        && dimse1 == dwg->header_vars.DIMSE1)
      pass ();
    else
      fail ("HEADER.DIMSE1 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSE1, dimse1);
    dimse1++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSE1", &dimse1, 0)
        && dimse1 == dwg->header_vars.DIMSE1)
      pass ();
    else
      fail ("HEADER.DIMSE1 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSE1, dimse1);
    dimse1--;
    dwg_dynapi_header_set_value (dwg, "DIMSE1", &dimse1, 0);

  }
  {
    BITCODE_B dimse2;
    if (dwg_dynapi_header_value (dwg, "DIMSE2", &dimse2, NULL)
        && dimse2 == dwg->header_vars.DIMSE2)
      pass ();
    else
      fail ("HEADER.DIMSE2 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSE2, dimse2);
    dimse2++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSE2", &dimse2, 0)
        && dimse2 == dwg->header_vars.DIMSE2)
      pass ();
    else
      fail ("HEADER.DIMSE2 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSE2, dimse2);
    dimse2--;
    dwg_dynapi_header_set_value (dwg, "DIMSE2", &dimse2, 0);

  }
  {
    BITCODE_B dimalt;
    if (dwg_dynapi_header_value (dwg, "DIMALT", &dimalt, NULL)
        && dimalt == dwg->header_vars.DIMALT)
      pass ();
    else
      fail ("HEADER.DIMALT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMALT, dimalt);
    dimalt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALT", &dimalt, 0)
        && dimalt == dwg->header_vars.DIMALT)
      pass ();
    else
      fail ("HEADER.DIMALT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMALT, dimalt);
    dimalt--;
    dwg_dynapi_header_set_value (dwg, "DIMALT", &dimalt, 0);

  }
  {
    BITCODE_B dimtofl;
    if (dwg_dynapi_header_value (dwg, "DIMTOFL", &dimtofl, NULL)
        && dimtofl == dwg->header_vars.DIMTOFL)
      pass ();
    else
      fail ("HEADER.DIMTOFL [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOFL, dimtofl);
    dimtofl++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOFL", &dimtofl, 0)
        && dimtofl == dwg->header_vars.DIMTOFL)
      pass ();
    else
      fail ("HEADER.DIMTOFL [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTOFL, dimtofl);
    dimtofl--;
    dwg_dynapi_header_set_value (dwg, "DIMTOFL", &dimtofl, 0);

  }
  {
    BITCODE_B dimsah;
    if (dwg_dynapi_header_value (dwg, "DIMSAH", &dimsah, NULL)
        && dimsah == dwg->header_vars.DIMSAH)
      pass ();
    else
      fail ("HEADER.DIMSAH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSAH, dimsah);
    dimsah++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSAH", &dimsah, 0)
        && dimsah == dwg->header_vars.DIMSAH)
      pass ();
    else
      fail ("HEADER.DIMSAH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSAH, dimsah);
    dimsah--;
    dwg_dynapi_header_set_value (dwg, "DIMSAH", &dimsah, 0);

  }
  {
    BITCODE_B dimtix;
    if (dwg_dynapi_header_value (dwg, "DIMTIX", &dimtix, NULL)
        && dimtix == dwg->header_vars.DIMTIX)
      pass ();
    else
      fail ("HEADER.DIMTIX [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTIX, dimtix);
    dimtix++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTIX", &dimtix, 0)
        && dimtix == dwg->header_vars.DIMTIX)
      pass ();
    else
      fail ("HEADER.DIMTIX [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTIX, dimtix);
    dimtix--;
    dwg_dynapi_header_set_value (dwg, "DIMTIX", &dimtix, 0);

  }
  {
    BITCODE_B dimsoxd;
    if (dwg_dynapi_header_value (dwg, "DIMSOXD", &dimsoxd, NULL)
        && dimsoxd == dwg->header_vars.DIMSOXD)
      pass ();
    else
      fail ("HEADER.DIMSOXD [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSOXD, dimsoxd);
    dimsoxd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSOXD", &dimsoxd, 0)
        && dimsoxd == dwg->header_vars.DIMSOXD)
      pass ();
    else
      fail ("HEADER.DIMSOXD [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSOXD, dimsoxd);
    dimsoxd--;
    dwg_dynapi_header_set_value (dwg, "DIMSOXD", &dimsoxd, 0);

  }
  {
    BITCODE_BS dimaltd;
    if (dwg_dynapi_header_value (dwg, "DIMALTD", &dimaltd, NULL)
        && dimaltd == dwg->header_vars.DIMALTD)
      pass ();
    else
      fail ("HEADER.DIMALTD [BS] %hu != %hu", dwg->header_vars.DIMALTD, dimaltd);
    dimaltd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTD", &dimaltd, 0)
        && dimaltd == dwg->header_vars.DIMALTD)
      pass ();
    else
      fail ("HEADER.DIMALTD [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTD, dimaltd);
    dimaltd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTD", &dimaltd, 0);

  }
  {
    BITCODE_BS dimzin;
    if (dwg_dynapi_header_value (dwg, "DIMZIN", &dimzin, NULL)
        && dimzin == dwg->header_vars.DIMZIN)
      pass ();
    else
      fail ("HEADER.DIMZIN [BS] %hu != %hu", dwg->header_vars.DIMZIN, dimzin);
    dimzin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMZIN", &dimzin, 0)
        && dimzin == dwg->header_vars.DIMZIN)
      pass ();
    else
      fail ("HEADER.DIMZIN [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMZIN, dimzin);
    dimzin--;
    dwg_dynapi_header_set_value (dwg, "DIMZIN", &dimzin, 0);

  }
  {
    BITCODE_B dimsd1;
    if (dwg_dynapi_header_value (dwg, "DIMSD1", &dimsd1, NULL)
        && dimsd1 == dwg->header_vars.DIMSD1)
      pass ();
    else
      fail ("HEADER.DIMSD1 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSD1, dimsd1);
    dimsd1++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSD1", &dimsd1, 0)
        && dimsd1 == dwg->header_vars.DIMSD1)
      pass ();
    else
      fail ("HEADER.DIMSD1 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSD1, dimsd1);
    dimsd1--;
    dwg_dynapi_header_set_value (dwg, "DIMSD1", &dimsd1, 0);

  }
  {
    BITCODE_B dimsd2;
    if (dwg_dynapi_header_value (dwg, "DIMSD2", &dimsd2, NULL)
        && dimsd2 == dwg->header_vars.DIMSD2)
      pass ();
    else
      fail ("HEADER.DIMSD2 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSD2, dimsd2);
    dimsd2++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSD2", &dimsd2, 0)
        && dimsd2 == dwg->header_vars.DIMSD2)
      pass ();
    else
      fail ("HEADER.DIMSD2 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSD2, dimsd2);
    dimsd2--;
    dwg_dynapi_header_set_value (dwg, "DIMSD2", &dimsd2, 0);

  }
  {
    BITCODE_BS dimtolj;
    if (dwg_dynapi_header_value (dwg, "DIMTOLJ", &dimtolj, NULL)
        && dimtolj == dwg->header_vars.DIMTOLJ)
      pass ();
    else
      fail ("HEADER.DIMTOLJ [BS] %hu != %hu", dwg->header_vars.DIMTOLJ, dimtolj);
    dimtolj++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOLJ", &dimtolj, 0)
        && dimtolj == dwg->header_vars.DIMTOLJ)
      pass ();
    else
      fail ("HEADER.DIMTOLJ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTOLJ, dimtolj);
    dimtolj--;
    dwg_dynapi_header_set_value (dwg, "DIMTOLJ", &dimtolj, 0);

  }
  {
    BITCODE_BS dimjust;
    if (dwg_dynapi_header_value (dwg, "DIMJUST", &dimjust, NULL)
        && dimjust == dwg->header_vars.DIMJUST)
      pass ();
    else
      fail ("HEADER.DIMJUST [BS] %hu != %hu", dwg->header_vars.DIMJUST, dimjust);
    dimjust++;
    if (dwg_dynapi_header_set_value (dwg, "DIMJUST", &dimjust, 0)
        && dimjust == dwg->header_vars.DIMJUST)
      pass ();
    else
      fail ("HEADER.DIMJUST [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMJUST, dimjust);
    dimjust--;
    dwg_dynapi_header_set_value (dwg, "DIMJUST", &dimjust, 0);

  }
  {
    BITCODE_BS dimfit;
    if (dwg_dynapi_header_value (dwg, "DIMFIT", &dimfit, NULL)
        && dimfit == dwg->header_vars.DIMFIT)
      pass ();
    else
      fail ("HEADER.DIMFIT [BS] %hu != %hu", dwg->header_vars.DIMFIT, dimfit);
    dimfit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFIT", &dimfit, 0)
        && dimfit == dwg->header_vars.DIMFIT)
      pass ();
    else
      fail ("HEADER.DIMFIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMFIT, dimfit);
    dimfit--;
    dwg_dynapi_header_set_value (dwg, "DIMFIT", &dimfit, 0);

  }
  {
    BITCODE_B dimupt;
    if (dwg_dynapi_header_value (dwg, "DIMUPT", &dimupt, NULL)
        && dimupt == dwg->header_vars.DIMUPT)
      pass ();
    else
      fail ("HEADER.DIMUPT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMUPT, dimupt);
    dimupt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMUPT", &dimupt, 0)
        && dimupt == dwg->header_vars.DIMUPT)
      pass ();
    else
      fail ("HEADER.DIMUPT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMUPT, dimupt);
    dimupt--;
    dwg_dynapi_header_set_value (dwg, "DIMUPT", &dimupt, 0);

  }
  {
    BITCODE_BS dimtzin;
    if (dwg_dynapi_header_value (dwg, "DIMTZIN", &dimtzin, NULL)
        && dimtzin == dwg->header_vars.DIMTZIN)
      pass ();
    else
      fail ("HEADER.DIMTZIN [BS] %hu != %hu", dwg->header_vars.DIMTZIN, dimtzin);
    dimtzin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTZIN", &dimtzin, 0)
        && dimtzin == dwg->header_vars.DIMTZIN)
      pass ();
    else
      fail ("HEADER.DIMTZIN [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTZIN, dimtzin);
    dimtzin--;
    dwg_dynapi_header_set_value (dwg, "DIMTZIN", &dimtzin, 0);

  }
  {
    BITCODE_BS dimmaltz;
    if (dwg_dynapi_header_value (dwg, "DIMMALTZ", &dimmaltz, NULL)
        && dimmaltz == dwg->header_vars.DIMMALTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTZ [BS] %hu != %hu", dwg->header_vars.DIMMALTZ, dimmaltz);
    dimmaltz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMALTZ", &dimmaltz, 0)
        && dimmaltz == dwg->header_vars.DIMMALTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMMALTZ, dimmaltz);
    dimmaltz--;
    dwg_dynapi_header_set_value (dwg, "DIMMALTZ", &dimmaltz, 0);

  }
  {
    BITCODE_BS dimmalttz;
    if (dwg_dynapi_header_value (dwg, "DIMMALTTZ", &dimmalttz, NULL)
        && dimmalttz == dwg->header_vars.DIMMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTTZ [BS] %hu != %hu", dwg->header_vars.DIMMALTTZ, dimmalttz);
    dimmalttz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMALTTZ", &dimmalttz, 0)
        && dimmalttz == dwg->header_vars.DIMMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMMALTTZ, dimmalttz);
    dimmalttz--;
    dwg_dynapi_header_set_value (dwg, "DIMMALTTZ", &dimmalttz, 0);

  }
  {
    BITCODE_BS dimtad;
    if (dwg_dynapi_header_value (dwg, "DIMTAD", &dimtad, NULL)
        && dimtad == dwg->header_vars.DIMTAD)
      pass ();
    else
      fail ("HEADER.DIMTAD [BS] %hu != %hu", dwg->header_vars.DIMTAD, dimtad);
    dimtad++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTAD", &dimtad, 0)
        && dimtad == dwg->header_vars.DIMTAD)
      pass ();
    else
      fail ("HEADER.DIMTAD [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTAD, dimtad);
    dimtad--;
    dwg_dynapi_header_set_value (dwg, "DIMTAD", &dimtad, 0);

  }
  {
    BITCODE_BS dimunit;
    if (dwg_dynapi_header_value (dwg, "DIMUNIT", &dimunit, NULL)
        && dimunit == dwg->header_vars.DIMUNIT)
      pass ();
    else
      fail ("HEADER.DIMUNIT [BS] %hu != %hu", dwg->header_vars.DIMUNIT, dimunit);
    dimunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMUNIT", &dimunit, 0)
        && dimunit == dwg->header_vars.DIMUNIT)
      pass ();
    else
      fail ("HEADER.DIMUNIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMUNIT, dimunit);
    dimunit--;
    dwg_dynapi_header_set_value (dwg, "DIMUNIT", &dimunit, 0);

  }
  {
    BITCODE_BS dimaunit;
    if (dwg_dynapi_header_value (dwg, "DIMAUNIT", &dimaunit, NULL)
        && dimaunit == dwg->header_vars.DIMAUNIT)
      pass ();
    else
      fail ("HEADER.DIMAUNIT [BS] %hu != %hu", dwg->header_vars.DIMAUNIT, dimaunit);
    dimaunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMAUNIT", &dimaunit, 0)
        && dimaunit == dwg->header_vars.DIMAUNIT)
      pass ();
    else
      fail ("HEADER.DIMAUNIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMAUNIT, dimaunit);
    dimaunit--;
    dwg_dynapi_header_set_value (dwg, "DIMAUNIT", &dimaunit, 0);

  }
  {
    BITCODE_BS dimdec;
    if (dwg_dynapi_header_value (dwg, "DIMDEC", &dimdec, NULL)
        && dimdec == dwg->header_vars.DIMDEC)
      pass ();
    else
      fail ("HEADER.DIMDEC [BS] %hu != %hu", dwg->header_vars.DIMDEC, dimdec);
    dimdec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDEC", &dimdec, 0)
        && dimdec == dwg->header_vars.DIMDEC)
      pass ();
    else
      fail ("HEADER.DIMDEC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMDEC, dimdec);
    dimdec--;
    dwg_dynapi_header_set_value (dwg, "DIMDEC", &dimdec, 0);

  }
  {
    BITCODE_BS dimtdec;
    if (dwg_dynapi_header_value (dwg, "DIMTDEC", &dimtdec, NULL)
        && dimtdec == dwg->header_vars.DIMTDEC)
      pass ();
    else
      fail ("HEADER.DIMTDEC [BS] %hu != %hu", dwg->header_vars.DIMTDEC, dimtdec);
    dimtdec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTDEC", &dimtdec, 0)
        && dimtdec == dwg->header_vars.DIMTDEC)
      pass ();
    else
      fail ("HEADER.DIMTDEC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTDEC, dimtdec);
    dimtdec--;
    dwg_dynapi_header_set_value (dwg, "DIMTDEC", &dimtdec, 0);

  }
  {
    BITCODE_BS dimaltu;
    if (dwg_dynapi_header_value (dwg, "DIMALTU", &dimaltu, NULL)
        && dimaltu == dwg->header_vars.DIMALTU)
      pass ();
    else
      fail ("HEADER.DIMALTU [BS] %hu != %hu", dwg->header_vars.DIMALTU, dimaltu);
    dimaltu++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTU", &dimaltu, 0)
        && dimaltu == dwg->header_vars.DIMALTU)
      pass ();
    else
      fail ("HEADER.DIMALTU [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTU, dimaltu);
    dimaltu--;
    dwg_dynapi_header_set_value (dwg, "DIMALTU", &dimaltu, 0);

  }
  {
    BITCODE_BS dimalttd;
    if (dwg_dynapi_header_value (dwg, "DIMALTTD", &dimalttd, NULL)
        && dimalttd == dwg->header_vars.DIMALTTD)
      pass ();
    else
      fail ("HEADER.DIMALTTD [BS] %hu != %hu", dwg->header_vars.DIMALTTD, dimalttd);
    dimalttd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTTD", &dimalttd, 0)
        && dimalttd == dwg->header_vars.DIMALTTD)
      pass ();
    else
      fail ("HEADER.DIMALTTD [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTTD, dimalttd);
    dimalttd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTTD", &dimalttd, 0);

  }
  {
    BITCODE_H dimtxsty;
    if (dwg_dynapi_header_value (dwg, "DIMTXSTY", &dimtxsty, NULL)
        && !memcmp (&dimtxsty, &dwg->header_vars.DIMTXSTY, sizeof (dwg->header_vars.DIMTXSTY))
       )
      pass ();
    else
      fail ("HEADER.DIMTXSTY [H]");
  }
  {
    BITCODE_BD dimscale;
    if (dwg_dynapi_header_value (dwg, "DIMSCALE", &dimscale, NULL)
        && dimscale == dwg->header_vars.DIMSCALE)
      pass ();
    else
      fail ("HEADER.DIMSCALE [BD] %g != %g", dwg->header_vars.DIMSCALE, dimscale);
    dimscale++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSCALE", &dimscale, 0)
        && dimscale == dwg->header_vars.DIMSCALE)
      pass ();
    else
      fail ("HEADER.DIMSCALE [BD] set+1 %g != %g",
            dwg->header_vars.DIMSCALE, dimscale);
    dimscale--;
    dwg_dynapi_header_set_value (dwg, "DIMSCALE", &dimscale, 0);

  }
  {
    BITCODE_BD dimasz;
    if (dwg_dynapi_header_value (dwg, "DIMASZ", &dimasz, NULL)
        && dimasz == dwg->header_vars.DIMASZ)
      pass ();
    else
      fail ("HEADER.DIMASZ [BD] %g != %g", dwg->header_vars.DIMASZ, dimasz);
    dimasz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASZ", &dimasz, 0)
        && dimasz == dwg->header_vars.DIMASZ)
      pass ();
    else
      fail ("HEADER.DIMASZ [BD] set+1 %g != %g",
            dwg->header_vars.DIMASZ, dimasz);
    dimasz--;
    dwg_dynapi_header_set_value (dwg, "DIMASZ", &dimasz, 0);

  }
  {
    BITCODE_BD dimexo;
    if (dwg_dynapi_header_value (dwg, "DIMEXO", &dimexo, NULL)
        && dimexo == dwg->header_vars.DIMEXO)
      pass ();
    else
      fail ("HEADER.DIMEXO [BD] %g != %g", dwg->header_vars.DIMEXO, dimexo);
    dimexo++;
    if (dwg_dynapi_header_set_value (dwg, "DIMEXO", &dimexo, 0)
        && dimexo == dwg->header_vars.DIMEXO)
      pass ();
    else
      fail ("HEADER.DIMEXO [BD] set+1 %g != %g",
            dwg->header_vars.DIMEXO, dimexo);
    dimexo--;
    dwg_dynapi_header_set_value (dwg, "DIMEXO", &dimexo, 0);

  }
  {
    BITCODE_BD dimdli;
    if (dwg_dynapi_header_value (dwg, "DIMDLI", &dimdli, NULL)
        && dimdli == dwg->header_vars.DIMDLI)
      pass ();
    else
      fail ("HEADER.DIMDLI [BD] %g != %g", dwg->header_vars.DIMDLI, dimdli);
    dimdli++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDLI", &dimdli, 0)
        && dimdli == dwg->header_vars.DIMDLI)
      pass ();
    else
      fail ("HEADER.DIMDLI [BD] set+1 %g != %g",
            dwg->header_vars.DIMDLI, dimdli);
    dimdli--;
    dwg_dynapi_header_set_value (dwg, "DIMDLI", &dimdli, 0);

  }
  {
    BITCODE_BD dimexe;
    if (dwg_dynapi_header_value (dwg, "DIMEXE", &dimexe, NULL)
        && dimexe == dwg->header_vars.DIMEXE)
      pass ();
    else
      fail ("HEADER.DIMEXE [BD] %g != %g", dwg->header_vars.DIMEXE, dimexe);
    dimexe++;
    if (dwg_dynapi_header_set_value (dwg, "DIMEXE", &dimexe, 0)
        && dimexe == dwg->header_vars.DIMEXE)
      pass ();
    else
      fail ("HEADER.DIMEXE [BD] set+1 %g != %g",
            dwg->header_vars.DIMEXE, dimexe);
    dimexe--;
    dwg_dynapi_header_set_value (dwg, "DIMEXE", &dimexe, 0);

  }
  {
    BITCODE_BD dimrnd;
    if (dwg_dynapi_header_value (dwg, "DIMRND", &dimrnd, NULL)
        && dimrnd == dwg->header_vars.DIMRND)
      pass ();
    else
      fail ("HEADER.DIMRND [BD] %g != %g", dwg->header_vars.DIMRND, dimrnd);
    dimrnd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMRND", &dimrnd, 0)
        && dimrnd == dwg->header_vars.DIMRND)
      pass ();
    else
      fail ("HEADER.DIMRND [BD] set+1 %g != %g",
            dwg->header_vars.DIMRND, dimrnd);
    dimrnd--;
    dwg_dynapi_header_set_value (dwg, "DIMRND", &dimrnd, 0);

  }
  {
    BITCODE_BD dimdle;
    if (dwg_dynapi_header_value (dwg, "DIMDLE", &dimdle, NULL)
        && dimdle == dwg->header_vars.DIMDLE)
      pass ();
    else
      fail ("HEADER.DIMDLE [BD] %g != %g", dwg->header_vars.DIMDLE, dimdle);
    dimdle++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDLE", &dimdle, 0)
        && dimdle == dwg->header_vars.DIMDLE)
      pass ();
    else
      fail ("HEADER.DIMDLE [BD] set+1 %g != %g",
            dwg->header_vars.DIMDLE, dimdle);
    dimdle--;
    dwg_dynapi_header_set_value (dwg, "DIMDLE", &dimdle, 0);

  }
  {
    BITCODE_BD dimtp;
    if (dwg_dynapi_header_value (dwg, "DIMTP", &dimtp, NULL)
        && dimtp == dwg->header_vars.DIMTP)
      pass ();
    else
      fail ("HEADER.DIMTP [BD] %g != %g", dwg->header_vars.DIMTP, dimtp);
    dimtp++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTP", &dimtp, 0)
        && dimtp == dwg->header_vars.DIMTP)
      pass ();
    else
      fail ("HEADER.DIMTP [BD] set+1 %g != %g",
            dwg->header_vars.DIMTP, dimtp);
    dimtp--;
    dwg_dynapi_header_set_value (dwg, "DIMTP", &dimtp, 0);

  }
  {
    BITCODE_BD dimtm;
    if (dwg_dynapi_header_value (dwg, "DIMTM", &dimtm, NULL)
        && dimtm == dwg->header_vars.DIMTM)
      pass ();
    else
      fail ("HEADER.DIMTM [BD] %g != %g", dwg->header_vars.DIMTM, dimtm);
    dimtm++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTM", &dimtm, 0)
        && dimtm == dwg->header_vars.DIMTM)
      pass ();
    else
      fail ("HEADER.DIMTM [BD] set+1 %g != %g",
            dwg->header_vars.DIMTM, dimtm);
    dimtm--;
    dwg_dynapi_header_set_value (dwg, "DIMTM", &dimtm, 0);

  }
  {
    BITCODE_BD dimfxl;
    if (dwg_dynapi_header_value (dwg, "DIMFXL", &dimfxl, NULL)
        && dimfxl == dwg->header_vars.DIMFXL)
      pass ();
    else
      fail ("HEADER.DIMFXL [BD] %g != %g", dwg->header_vars.DIMFXL, dimfxl);
    dimfxl++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFXL", &dimfxl, 0)
        && dimfxl == dwg->header_vars.DIMFXL)
      pass ();
    else
      fail ("HEADER.DIMFXL [BD] set+1 %g != %g",
            dwg->header_vars.DIMFXL, dimfxl);
    dimfxl--;
    dwg_dynapi_header_set_value (dwg, "DIMFXL", &dimfxl, 0);

  }
  {
    BITCODE_BD dimjogang;
    if (dwg_dynapi_header_value (dwg, "DIMJOGANG", &dimjogang, NULL)
        && dimjogang == dwg->header_vars.DIMJOGANG)
      pass ();
    else
      fail ("HEADER.DIMJOGANG [BD] %g != %g", dwg->header_vars.DIMJOGANG, dimjogang);
    dimjogang++;
    if (dwg_dynapi_header_set_value (dwg, "DIMJOGANG", &dimjogang, 0)
        && dimjogang == dwg->header_vars.DIMJOGANG)
      pass ();
    else
      fail ("HEADER.DIMJOGANG [BD] set+1 %g != %g",
            dwg->header_vars.DIMJOGANG, dimjogang);
    dimjogang--;
    dwg_dynapi_header_set_value (dwg, "DIMJOGANG", &dimjogang, 0);

  }
  {
    BITCODE_BS dimtfill;
    if (dwg_dynapi_header_value (dwg, "DIMTFILL", &dimtfill, NULL)
        && dimtfill == dwg->header_vars.DIMTFILL)
      pass ();
    else
      fail ("HEADER.DIMTFILL [BS] %hu != %hu", dwg->header_vars.DIMTFILL, dimtfill);
    dimtfill++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTFILL", &dimtfill, 0)
        && dimtfill == dwg->header_vars.DIMTFILL)
      pass ();
    else
      fail ("HEADER.DIMTFILL [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTFILL, dimtfill);
    dimtfill--;
    dwg_dynapi_header_set_value (dwg, "DIMTFILL", &dimtfill, 0);

  }
  {
    BITCODE_CMC dimtfillclr;
    if (dwg_dynapi_header_value (dwg, "DIMTFILLCLR", &dimtfillclr, NULL)
        && !memcmp (&dimtfillclr, &dwg->header_vars.DIMTFILLCLR, sizeof (dwg->header_vars.DIMTFILLCLR))
       )
      pass ();
    else
      fail ("HEADER.DIMTFILLCLR [CMC]");
  }
  {
    BITCODE_BS dimazin;
    if (dwg_dynapi_header_value (dwg, "DIMAZIN", &dimazin, NULL)
        && dimazin == dwg->header_vars.DIMAZIN)
      pass ();
    else
      fail ("HEADER.DIMAZIN [BS] %hu != %hu", dwg->header_vars.DIMAZIN, dimazin);
    dimazin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMAZIN", &dimazin, 0)
        && dimazin == dwg->header_vars.DIMAZIN)
      pass ();
    else
      fail ("HEADER.DIMAZIN [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMAZIN, dimazin);
    dimazin--;
    dwg_dynapi_header_set_value (dwg, "DIMAZIN", &dimazin, 0);

  }
  {
    BITCODE_BS dimarcsym;
    if (dwg_dynapi_header_value (dwg, "DIMARCSYM", &dimarcsym, NULL)
        && dimarcsym == dwg->header_vars.DIMARCSYM)
      pass ();
    else
      fail ("HEADER.DIMARCSYM [BS] %hu != %hu", dwg->header_vars.DIMARCSYM, dimarcsym);
    dimarcsym++;
    if (dwg_dynapi_header_set_value (dwg, "DIMARCSYM", &dimarcsym, 0)
        && dimarcsym == dwg->header_vars.DIMARCSYM)
      pass ();
    else
      fail ("HEADER.DIMARCSYM [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMARCSYM, dimarcsym);
    dimarcsym--;
    dwg_dynapi_header_set_value (dwg, "DIMARCSYM", &dimarcsym, 0);

  }
  {
    BITCODE_BD dimtxt;
    if (dwg_dynapi_header_value (dwg, "DIMTXT", &dimtxt, NULL)
        && dimtxt == dwg->header_vars.DIMTXT)
      pass ();
    else
      fail ("HEADER.DIMTXT [BD] %g != %g", dwg->header_vars.DIMTXT, dimtxt);
    dimtxt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTXT", &dimtxt, 0)
        && dimtxt == dwg->header_vars.DIMTXT)
      pass ();
    else
      fail ("HEADER.DIMTXT [BD] set+1 %g != %g",
            dwg->header_vars.DIMTXT, dimtxt);
    dimtxt--;
    dwg_dynapi_header_set_value (dwg, "DIMTXT", &dimtxt, 0);

  }
  {
    BITCODE_BD dimcen;
    if (dwg_dynapi_header_value (dwg, "DIMCEN", &dimcen, NULL)
        && dimcen == dwg->header_vars.DIMCEN)
      pass ();
    else
      fail ("HEADER.DIMCEN [BD] %g != %g", dwg->header_vars.DIMCEN, dimcen);
    dimcen++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCEN", &dimcen, 0)
        && dimcen == dwg->header_vars.DIMCEN)
      pass ();
    else
      fail ("HEADER.DIMCEN [BD] set+1 %g != %g",
            dwg->header_vars.DIMCEN, dimcen);
    dimcen--;
    dwg_dynapi_header_set_value (dwg, "DIMCEN", &dimcen, 0);

  }
  {
    BITCODE_BD dimtsz;
    if (dwg_dynapi_header_value (dwg, "DIMTSZ", &dimtsz, NULL)
        && dimtsz == dwg->header_vars.DIMTSZ)
      pass ();
    else
      fail ("HEADER.DIMTSZ [BD] %g != %g", dwg->header_vars.DIMTSZ, dimtsz);
    dimtsz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTSZ", &dimtsz, 0)
        && dimtsz == dwg->header_vars.DIMTSZ)
      pass ();
    else
      fail ("HEADER.DIMTSZ [BD] set+1 %g != %g",
            dwg->header_vars.DIMTSZ, dimtsz);
    dimtsz--;
    dwg_dynapi_header_set_value (dwg, "DIMTSZ", &dimtsz, 0);

  }
  {
    BITCODE_BD dimaltf;
    if (dwg_dynapi_header_value (dwg, "DIMALTF", &dimaltf, NULL)
        && dimaltf == dwg->header_vars.DIMALTF)
      pass ();
    else
      fail ("HEADER.DIMALTF [BD] %g != %g", dwg->header_vars.DIMALTF, dimaltf);
    dimaltf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTF", &dimaltf, 0)
        && dimaltf == dwg->header_vars.DIMALTF)
      pass ();
    else
      fail ("HEADER.DIMALTF [BD] set+1 %g != %g",
            dwg->header_vars.DIMALTF, dimaltf);
    dimaltf--;
    dwg_dynapi_header_set_value (dwg, "DIMALTF", &dimaltf, 0);

  }
  {
    BITCODE_BD dimlfac;
    if (dwg_dynapi_header_value (dwg, "DIMLFAC", &dimlfac, NULL)
        && dimlfac == dwg->header_vars.DIMLFAC)
      pass ();
    else
      fail ("HEADER.DIMLFAC [BD] %g != %g", dwg->header_vars.DIMLFAC, dimlfac);
    dimlfac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLFAC", &dimlfac, 0)
        && dimlfac == dwg->header_vars.DIMLFAC)
      pass ();
    else
      fail ("HEADER.DIMLFAC [BD] set+1 %g != %g",
            dwg->header_vars.DIMLFAC, dimlfac);
    dimlfac--;
    dwg_dynapi_header_set_value (dwg, "DIMLFAC", &dimlfac, 0);

  }
  {
    BITCODE_BD dimtvp;
    if (dwg_dynapi_header_value (dwg, "DIMTVP", &dimtvp, NULL)
        && dimtvp == dwg->header_vars.DIMTVP)
      pass ();
    else
      fail ("HEADER.DIMTVP [BD] %g != %g", dwg->header_vars.DIMTVP, dimtvp);
    dimtvp++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTVP", &dimtvp, 0)
        && dimtvp == dwg->header_vars.DIMTVP)
      pass ();
    else
      fail ("HEADER.DIMTVP [BD] set+1 %g != %g",
            dwg->header_vars.DIMTVP, dimtvp);
    dimtvp--;
    dwg_dynapi_header_set_value (dwg, "DIMTVP", &dimtvp, 0);

  }
  {
    BITCODE_BD dimtfac;
    if (dwg_dynapi_header_value (dwg, "DIMTFAC", &dimtfac, NULL)
        && dimtfac == dwg->header_vars.DIMTFAC)
      pass ();
    else
      fail ("HEADER.DIMTFAC [BD] %g != %g", dwg->header_vars.DIMTFAC, dimtfac);
    dimtfac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTFAC", &dimtfac, 0)
        && dimtfac == dwg->header_vars.DIMTFAC)
      pass ();
    else
      fail ("HEADER.DIMTFAC [BD] set+1 %g != %g",
            dwg->header_vars.DIMTFAC, dimtfac);
    dimtfac--;
    dwg_dynapi_header_set_value (dwg, "DIMTFAC", &dimtfac, 0);

  }
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_header_value (dwg, "DIMGAP", &dimgap, NULL)
        && dimgap == dwg->header_vars.DIMGAP)
      pass ();
    else
      fail ("HEADER.DIMGAP [BD] %g != %g", dwg->header_vars.DIMGAP, dimgap);
    dimgap++;
    if (dwg_dynapi_header_set_value (dwg, "DIMGAP", &dimgap, 0)
        && dimgap == dwg->header_vars.DIMGAP)
      pass ();
    else
      fail ("HEADER.DIMGAP [BD] set+1 %g != %g",
            dwg->header_vars.DIMGAP, dimgap);
    dimgap--;
    dwg_dynapi_header_set_value (dwg, "DIMGAP", &dimgap, 0);

  }
  {
    BITCODE_T dimpost_t;
    if (dwg_dynapi_header_value (dwg, "DIMPOST_T", &dimpost_t, NULL)
        && !memcmp (&dimpost_t, &dwg->header_vars.DIMPOST_T, sizeof (dwg->header_vars.DIMPOST_T))
       )
      pass ();
    else
      fail ("HEADER.DIMPOST_T [T]");
  }
  {
    BITCODE_T dimapost_t;
    if (dwg_dynapi_header_value (dwg, "DIMAPOST_T", &dimapost_t, NULL)
        && !memcmp (&dimapost_t, &dwg->header_vars.DIMAPOST_T, sizeof (dwg->header_vars.DIMAPOST_T))
       )
      pass ();
    else
      fail ("HEADER.DIMAPOST_T [T]");
  }
  {
    BITCODE_T dimblk_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK_T", &dimblk_t, NULL)
        && !memcmp (&dimblk_t, &dwg->header_vars.DIMBLK_T, sizeof (dwg->header_vars.DIMBLK_T))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK_T [T]");
  }
  {
    BITCODE_T dimblk1_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK1_T", &dimblk1_t, NULL)
        && !memcmp (&dimblk1_t, &dwg->header_vars.DIMBLK1_T, sizeof (dwg->header_vars.DIMBLK1_T))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK1_T [T]");
  }
  {
    BITCODE_T dimblk2_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK2_T", &dimblk2_t, NULL)
        && !memcmp (&dimblk2_t, &dwg->header_vars.DIMBLK2_T, sizeof (dwg->header_vars.DIMBLK2_T))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK2_T [T]");
  }
  {
    BITCODE_BD dimaltrnd;
    if (dwg_dynapi_header_value (dwg, "DIMALTRND", &dimaltrnd, NULL)
        && dimaltrnd == dwg->header_vars.DIMALTRND)
      pass ();
    else
      fail ("HEADER.DIMALTRND [BD] %g != %g", dwg->header_vars.DIMALTRND, dimaltrnd);
    dimaltrnd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTRND", &dimaltrnd, 0)
        && dimaltrnd == dwg->header_vars.DIMALTRND)
      pass ();
    else
      fail ("HEADER.DIMALTRND [BD] set+1 %g != %g",
            dwg->header_vars.DIMALTRND, dimaltrnd);
    dimaltrnd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTRND", &dimaltrnd, 0);

  }
  {
    BITCODE_RS dimclrd_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRD_C", &dimclrd_c, NULL)
        && dimclrd_c == dwg->header_vars.DIMCLRD_C)
      pass ();
    else
      fail ("HEADER.DIMCLRD_C [RS] %hu != %hu", dwg->header_vars.DIMCLRD_C, dimclrd_c);
    dimclrd_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRD_C", &dimclrd_c, 0)
        && dimclrd_c == dwg->header_vars.DIMCLRD_C)
      pass ();
    else
      fail ("HEADER.DIMCLRD_C [RS] set+1 %hu != %hu",
            dwg->header_vars.DIMCLRD_C, dimclrd_c);
    dimclrd_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRD_C", &dimclrd_c, 0);

  }
  {
    BITCODE_RS dimclre_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRE_C", &dimclre_c, NULL)
        && dimclre_c == dwg->header_vars.DIMCLRE_C)
      pass ();
    else
      fail ("HEADER.DIMCLRE_C [RS] %hu != %hu", dwg->header_vars.DIMCLRE_C, dimclre_c);
    dimclre_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRE_C", &dimclre_c, 0)
        && dimclre_c == dwg->header_vars.DIMCLRE_C)
      pass ();
    else
      fail ("HEADER.DIMCLRE_C [RS] set+1 %hu != %hu",
            dwg->header_vars.DIMCLRE_C, dimclre_c);
    dimclre_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRE_C", &dimclre_c, 0);

  }
  {
    BITCODE_RS dimclrt_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRT_C", &dimclrt_c, NULL)
        && dimclrt_c == dwg->header_vars.DIMCLRT_C)
      pass ();
    else
      fail ("HEADER.DIMCLRT_C [RS] %hu != %hu", dwg->header_vars.DIMCLRT_C, dimclrt_c);
    dimclrt_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRT_C", &dimclrt_c, 0)
        && dimclrt_c == dwg->header_vars.DIMCLRT_C)
      pass ();
    else
      fail ("HEADER.DIMCLRT_C [RS] set+1 %hu != %hu",
            dwg->header_vars.DIMCLRT_C, dimclrt_c);
    dimclrt_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRT_C", &dimclrt_c, 0);

  }
  {
    BITCODE_CMC dimclrd;
    if (dwg_dynapi_header_value (dwg, "DIMCLRD", &dimclrd, NULL)
        && !memcmp (&dimclrd, &dwg->header_vars.DIMCLRD, sizeof (dwg->header_vars.DIMCLRD))
       )
      pass ();
    else
      fail ("HEADER.DIMCLRD [CMC]");
  }
  {
    BITCODE_CMC dimclre;
    if (dwg_dynapi_header_value (dwg, "DIMCLRE", &dimclre, NULL)
        && !memcmp (&dimclre, &dwg->header_vars.DIMCLRE, sizeof (dwg->header_vars.DIMCLRE))
       )
      pass ();
    else
      fail ("HEADER.DIMCLRE [CMC]");
  }
  {
    BITCODE_CMC dimclrt;
    if (dwg_dynapi_header_value (dwg, "DIMCLRT", &dimclrt, NULL)
        && !memcmp (&dimclrt, &dwg->header_vars.DIMCLRT, sizeof (dwg->header_vars.DIMCLRT))
       )
      pass ();
    else
      fail ("HEADER.DIMCLRT [CMC]");
  }
  {
    BITCODE_BS dimadec;
    if (dwg_dynapi_header_value (dwg, "DIMADEC", &dimadec, NULL)
        && dimadec == dwg->header_vars.DIMADEC)
      pass ();
    else
      fail ("HEADER.DIMADEC [BS] %hu != %hu", dwg->header_vars.DIMADEC, dimadec);
    dimadec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMADEC", &dimadec, 0)
        && dimadec == dwg->header_vars.DIMADEC)
      pass ();
    else
      fail ("HEADER.DIMADEC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMADEC, dimadec);
    dimadec--;
    dwg_dynapi_header_set_value (dwg, "DIMADEC", &dimadec, 0);

  }
  {
    BITCODE_BS dimfrac;
    if (dwg_dynapi_header_value (dwg, "DIMFRAC", &dimfrac, NULL)
        && dimfrac == dwg->header_vars.DIMFRAC)
      pass ();
    else
      fail ("HEADER.DIMFRAC [BS] %hu != %hu", dwg->header_vars.DIMFRAC, dimfrac);
    dimfrac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFRAC", &dimfrac, 0)
        && dimfrac == dwg->header_vars.DIMFRAC)
      pass ();
    else
      fail ("HEADER.DIMFRAC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMFRAC, dimfrac);
    dimfrac--;
    dwg_dynapi_header_set_value (dwg, "DIMFRAC", &dimfrac, 0);

  }
  {
    BITCODE_BS dimlunit;
    if (dwg_dynapi_header_value (dwg, "DIMLUNIT", &dimlunit, NULL)
        && dimlunit == dwg->header_vars.DIMLUNIT)
      pass ();
    else
      fail ("HEADER.DIMLUNIT [BS] %hu != %hu", dwg->header_vars.DIMLUNIT, dimlunit);
    dimlunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLUNIT", &dimlunit, 0)
        && dimlunit == dwg->header_vars.DIMLUNIT)
      pass ();
    else
      fail ("HEADER.DIMLUNIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMLUNIT, dimlunit);
    dimlunit--;
    dwg_dynapi_header_set_value (dwg, "DIMLUNIT", &dimlunit, 0);

  }
  {
    BITCODE_BS dimdsep;
    if (dwg_dynapi_header_value (dwg, "DIMDSEP", &dimdsep, NULL)
        && dimdsep == dwg->header_vars.DIMDSEP)
      pass ();
    else
      fail ("HEADER.DIMDSEP [BS] %hu != %hu", dwg->header_vars.DIMDSEP, dimdsep);
    dimdsep++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDSEP", &dimdsep, 0)
        && dimdsep == dwg->header_vars.DIMDSEP)
      pass ();
    else
      fail ("HEADER.DIMDSEP [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMDSEP, dimdsep);
    dimdsep--;
    dwg_dynapi_header_set_value (dwg, "DIMDSEP", &dimdsep, 0);

  }
  {
    BITCODE_BS dimtmove;
    if (dwg_dynapi_header_value (dwg, "DIMTMOVE", &dimtmove, NULL)
        && dimtmove == dwg->header_vars.DIMTMOVE)
      pass ();
    else
      fail ("HEADER.DIMTMOVE [BS] %hu != %hu", dwg->header_vars.DIMTMOVE, dimtmove);
    dimtmove++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTMOVE", &dimtmove, 0)
        && dimtmove == dwg->header_vars.DIMTMOVE)
      pass ();
    else
      fail ("HEADER.DIMTMOVE [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTMOVE, dimtmove);
    dimtmove--;
    dwg_dynapi_header_set_value (dwg, "DIMTMOVE", &dimtmove, 0);

  }
  {
    BITCODE_BS dimaltz;
    if (dwg_dynapi_header_value (dwg, "DIMALTZ", &dimaltz, NULL)
        && dimaltz == dwg->header_vars.DIMALTZ)
      pass ();
    else
      fail ("HEADER.DIMALTZ [BS] %hu != %hu", dwg->header_vars.DIMALTZ, dimaltz);
    dimaltz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTZ", &dimaltz, 0)
        && dimaltz == dwg->header_vars.DIMALTZ)
      pass ();
    else
      fail ("HEADER.DIMALTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTZ, dimaltz);
    dimaltz--;
    dwg_dynapi_header_set_value (dwg, "DIMALTZ", &dimaltz, 0);

  }
  {
    BITCODE_BS dimalttz;
    if (dwg_dynapi_header_value (dwg, "DIMALTTZ", &dimalttz, NULL)
        && dimalttz == dwg->header_vars.DIMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMALTTZ [BS] %hu != %hu", dwg->header_vars.DIMALTTZ, dimalttz);
    dimalttz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTTZ", &dimalttz, 0)
        && dimalttz == dwg->header_vars.DIMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMALTTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTTZ, dimalttz);
    dimalttz--;
    dwg_dynapi_header_set_value (dwg, "DIMALTTZ", &dimalttz, 0);

  }
  {
    BITCODE_BS dimatfit;
    if (dwg_dynapi_header_value (dwg, "DIMATFIT", &dimatfit, NULL)
        && dimatfit == dwg->header_vars.DIMATFIT)
      pass ();
    else
      fail ("HEADER.DIMATFIT [BS] %hu != %hu", dwg->header_vars.DIMATFIT, dimatfit);
    dimatfit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMATFIT", &dimatfit, 0)
        && dimatfit == dwg->header_vars.DIMATFIT)
      pass ();
    else
      fail ("HEADER.DIMATFIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMATFIT, dimatfit);
    dimatfit--;
    dwg_dynapi_header_set_value (dwg, "DIMATFIT", &dimatfit, 0);

  }
  {
    BITCODE_B dimfxlon;
    if (dwg_dynapi_header_value (dwg, "DIMFXLON", &dimfxlon, NULL)
        && dimfxlon == dwg->header_vars.DIMFXLON)
      pass ();
    else
      fail ("HEADER.DIMFXLON [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMFXLON, dimfxlon);
    dimfxlon++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFXLON", &dimfxlon, 0)
        && dimfxlon == dwg->header_vars.DIMFXLON)
      pass ();
    else
      fail ("HEADER.DIMFXLON [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMFXLON, dimfxlon);
    dimfxlon--;
    dwg_dynapi_header_set_value (dwg, "DIMFXLON", &dimfxlon, 0);

  }
  {
    BITCODE_B dimtxtdirection;
    if (dwg_dynapi_header_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, NULL)
        && dimtxtdirection == dwg->header_vars.DIMTXTDIRECTION)
      pass ();
    else
      fail ("HEADER.DIMTXTDIRECTION [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTXTDIRECTION, dimtxtdirection);
    dimtxtdirection++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, 0)
        && dimtxtdirection == dwg->header_vars.DIMTXTDIRECTION)
      pass ();
    else
      fail ("HEADER.DIMTXTDIRECTION [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTXTDIRECTION, dimtxtdirection);
    dimtxtdirection--;
    dwg_dynapi_header_set_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, 0);

  }
  {
    BITCODE_BD dimaltmzf;
    if (dwg_dynapi_header_value (dwg, "DIMALTMZF", &dimaltmzf, NULL)
        && dimaltmzf == dwg->header_vars.DIMALTMZF)
      pass ();
    else
      fail ("HEADER.DIMALTMZF [BD] %g != %g", dwg->header_vars.DIMALTMZF, dimaltmzf);
    dimaltmzf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTMZF", &dimaltmzf, 0)
        && dimaltmzf == dwg->header_vars.DIMALTMZF)
      pass ();
    else
      fail ("HEADER.DIMALTMZF [BD] set+1 %g != %g",
            dwg->header_vars.DIMALTMZF, dimaltmzf);
    dimaltmzf--;
    dwg_dynapi_header_set_value (dwg, "DIMALTMZF", &dimaltmzf, 0);

  }
  {
    BITCODE_T dimaltmzs;
    if (dwg_dynapi_header_value (dwg, "DIMALTMZS", &dimaltmzs, NULL)
        && !memcmp (&dimaltmzs, &dwg->header_vars.DIMALTMZS, sizeof (dwg->header_vars.DIMALTMZS))
       )
      pass ();
    else
      fail ("HEADER.DIMALTMZS [T]");
  }
  {
    BITCODE_BD dimmzf;
    if (dwg_dynapi_header_value (dwg, "DIMMZF", &dimmzf, NULL)
        && dimmzf == dwg->header_vars.DIMMZF)
      pass ();
    else
      fail ("HEADER.DIMMZF [BD] %g != %g", dwg->header_vars.DIMMZF, dimmzf);
    dimmzf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMZF", &dimmzf, 0)
        && dimmzf == dwg->header_vars.DIMMZF)
      pass ();
    else
      fail ("HEADER.DIMMZF [BD] set+1 %g != %g",
            dwg->header_vars.DIMMZF, dimmzf);
    dimmzf--;
    dwg_dynapi_header_set_value (dwg, "DIMMZF", &dimmzf, 0);

  }
  {
    BITCODE_T dimmzs;
    if (dwg_dynapi_header_value (dwg, "DIMMZS", &dimmzs, NULL)
        && !memcmp (&dimmzs, &dwg->header_vars.DIMMZS, sizeof (dwg->header_vars.DIMMZS))
       )
      pass ();
    else
      fail ("HEADER.DIMMZS [T]");
  }
  {
    BITCODE_H dimldrblk;
    if (dwg_dynapi_header_value (dwg, "DIMLDRBLK", &dimldrblk, NULL)
        && !memcmp (&dimldrblk, &dwg->header_vars.DIMLDRBLK, sizeof (dwg->header_vars.DIMLDRBLK))
       )
      pass ();
    else
      fail ("HEADER.DIMLDRBLK [H]");
  }
  {
    BITCODE_H dimblk;
    if (dwg_dynapi_header_value (dwg, "DIMBLK", &dimblk, NULL)
        && !memcmp (&dimblk, &dwg->header_vars.DIMBLK, sizeof (dwg->header_vars.DIMBLK))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK [H]");
  }
  {
    BITCODE_H dimblk1;
    if (dwg_dynapi_header_value (dwg, "DIMBLK1", &dimblk1, NULL)
        && !memcmp (&dimblk1, &dwg->header_vars.DIMBLK1, sizeof (dwg->header_vars.DIMBLK1))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK1 [H]");
  }
  {
    BITCODE_H dimblk2;
    if (dwg_dynapi_header_value (dwg, "DIMBLK2", &dimblk2, NULL)
        && !memcmp (&dimblk2, &dwg->header_vars.DIMBLK2, sizeof (dwg->header_vars.DIMBLK2))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK2 [H]");
  }
  {
    BITCODE_H dimltype;
    if (dwg_dynapi_header_value (dwg, "DIMLTYPE", &dimltype, NULL)
        && !memcmp (&dimltype, &dwg->header_vars.DIMLTYPE, sizeof (dwg->header_vars.DIMLTYPE))
       )
      pass ();
    else
      fail ("HEADER.DIMLTYPE [H]");
  }
  {
    BITCODE_H dimltex1;
    if (dwg_dynapi_header_value (dwg, "DIMLTEX1", &dimltex1, NULL)
        && !memcmp (&dimltex1, &dwg->header_vars.DIMLTEX1, sizeof (dwg->header_vars.DIMLTEX1))
       )
      pass ();
    else
      fail ("HEADER.DIMLTEX1 [H]");
  }
  {
    BITCODE_H dimltex2;
    if (dwg_dynapi_header_value (dwg, "DIMLTEX2", &dimltex2, NULL)
        && !memcmp (&dimltex2, &dwg->header_vars.DIMLTEX2, sizeof (dwg->header_vars.DIMLTEX2))
       )
      pass ();
    else
      fail ("HEADER.DIMLTEX2 [H]");
  }
  {
    BITCODE_BSd dimlwd;
    if (dwg_dynapi_header_value (dwg, "DIMLWD", &dimlwd, NULL)
        && dimlwd == dwg->header_vars.DIMLWD)
      pass ();
    else
      fail ("HEADER.DIMLWD [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dwg->header_vars.DIMLWD, dimlwd);
    dimlwd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLWD", &dimlwd, 0)
        && dimlwd == dwg->header_vars.DIMLWD)
      pass ();
    else
      fail ("HEADER.DIMLWD [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "",
            dwg->header_vars.DIMLWD, dimlwd);
    dimlwd--;
    dwg_dynapi_header_set_value (dwg, "DIMLWD", &dimlwd, 0);

  }
  {
    BITCODE_BSd dimlwe;
    if (dwg_dynapi_header_value (dwg, "DIMLWE", &dimlwe, NULL)
        && dimlwe == dwg->header_vars.DIMLWE)
      pass ();
    else
      fail ("HEADER.DIMLWE [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dwg->header_vars.DIMLWE, dimlwe);
    dimlwe++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLWE", &dimlwe, 0)
        && dimlwe == dwg->header_vars.DIMLWE)
      pass ();
    else
      fail ("HEADER.DIMLWE [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "",
            dwg->header_vars.DIMLWE, dimlwe);
    dimlwe--;
    dwg_dynapi_header_set_value (dwg, "DIMLWE", &dimlwe, 0);

  }
  {
    BITCODE_H block_control_object;
    if (dwg_dynapi_header_value (dwg, "BLOCK_CONTROL_OBJECT", &block_control_object, NULL)
        && !memcmp (&block_control_object, &dwg->header_vars.BLOCK_CONTROL_OBJECT, sizeof (dwg->header_vars.BLOCK_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.BLOCK_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H layer_control_object;
    if (dwg_dynapi_header_value (dwg, "LAYER_CONTROL_OBJECT", &layer_control_object, NULL)
        && !memcmp (&layer_control_object, &dwg->header_vars.LAYER_CONTROL_OBJECT, sizeof (dwg->header_vars.LAYER_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.LAYER_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H style_control_object;
    if (dwg_dynapi_header_value (dwg, "STYLE_CONTROL_OBJECT", &style_control_object, NULL)
        && !memcmp (&style_control_object, &dwg->header_vars.STYLE_CONTROL_OBJECT, sizeof (dwg->header_vars.STYLE_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.STYLE_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H ltype_control_object;
    if (dwg_dynapi_header_value (dwg, "LTYPE_CONTROL_OBJECT", &ltype_control_object, NULL)
        && !memcmp (&ltype_control_object, &dwg->header_vars.LTYPE_CONTROL_OBJECT, sizeof (dwg->header_vars.LTYPE_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H view_control_object;
    if (dwg_dynapi_header_value (dwg, "VIEW_CONTROL_OBJECT", &view_control_object, NULL)
        && !memcmp (&view_control_object, &dwg->header_vars.VIEW_CONTROL_OBJECT, sizeof (dwg->header_vars.VIEW_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.VIEW_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H ucs_control_object;
    if (dwg_dynapi_header_value (dwg, "UCS_CONTROL_OBJECT", &ucs_control_object, NULL)
        && !memcmp (&ucs_control_object, &dwg->header_vars.UCS_CONTROL_OBJECT, sizeof (dwg->header_vars.UCS_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.UCS_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H vport_control_object;
    if (dwg_dynapi_header_value (dwg, "VPORT_CONTROL_OBJECT", &vport_control_object, NULL)
        && !memcmp (&vport_control_object, &dwg->header_vars.VPORT_CONTROL_OBJECT, sizeof (dwg->header_vars.VPORT_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.VPORT_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H appid_control_object;
    if (dwg_dynapi_header_value (dwg, "APPID_CONTROL_OBJECT", &appid_control_object, NULL)
        && !memcmp (&appid_control_object, &dwg->header_vars.APPID_CONTROL_OBJECT, sizeof (dwg->header_vars.APPID_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.APPID_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H dimstyle_control_object;
    if (dwg_dynapi_header_value (dwg, "DIMSTYLE_CONTROL_OBJECT", &dimstyle_control_object, NULL)
        && !memcmp (&dimstyle_control_object, &dwg->header_vars.DIMSTYLE_CONTROL_OBJECT, sizeof (dwg->header_vars.DIMSTYLE_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.DIMSTYLE_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H vport_entity_control_object;
    if (dwg_dynapi_header_value (dwg, "VPORT_ENTITY_CONTROL_OBJECT", &vport_entity_control_object, NULL)
        && !memcmp (&vport_entity_control_object, &dwg->header_vars.VPORT_ENTITY_CONTROL_OBJECT, sizeof (dwg->header_vars.VPORT_ENTITY_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.VPORT_ENTITY_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H dictionary_acad_group;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_ACAD_GROUP", &dictionary_acad_group, NULL)
        && !memcmp (&dictionary_acad_group, &dwg->header_vars.DICTIONARY_ACAD_GROUP, sizeof (dwg->header_vars.DICTIONARY_ACAD_GROUP))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_ACAD_GROUP [H]");
  }
  {
    BITCODE_H dictionary_acad_mlinestyle;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_ACAD_MLINESTYLE", &dictionary_acad_mlinestyle, NULL)
        && !memcmp (&dictionary_acad_mlinestyle, &dwg->header_vars.DICTIONARY_ACAD_MLINESTYLE, sizeof (dwg->header_vars.DICTIONARY_ACAD_MLINESTYLE))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_ACAD_MLINESTYLE [H]");
  }
  {
    BITCODE_H dictionary_named_object;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_NAMED_OBJECT", &dictionary_named_object, NULL)
        && !memcmp (&dictionary_named_object, &dwg->header_vars.DICTIONARY_NAMED_OBJECT, sizeof (dwg->header_vars.DICTIONARY_NAMED_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_NAMED_OBJECT [H]");
  }
  {
    BITCODE_BS tstackalign;
    if (dwg_dynapi_header_value (dwg, "TSTACKALIGN", &tstackalign, NULL)
        && tstackalign == dwg->header_vars.TSTACKALIGN)
      pass ();
    else
      fail ("HEADER.TSTACKALIGN [BS] %hu != %hu", dwg->header_vars.TSTACKALIGN, tstackalign);
    tstackalign++;
    if (dwg_dynapi_header_set_value (dwg, "TSTACKALIGN", &tstackalign, 0)
        && tstackalign == dwg->header_vars.TSTACKALIGN)
      pass ();
    else
      fail ("HEADER.TSTACKALIGN [BS] set+1 %hu != %hu",
            dwg->header_vars.TSTACKALIGN, tstackalign);
    tstackalign--;
    dwg_dynapi_header_set_value (dwg, "TSTACKALIGN", &tstackalign, 0);

  }
  {
    BITCODE_BS tstacksize;
    if (dwg_dynapi_header_value (dwg, "TSTACKSIZE", &tstacksize, NULL)
        && tstacksize == dwg->header_vars.TSTACKSIZE)
      pass ();
    else
      fail ("HEADER.TSTACKSIZE [BS] %hu != %hu", dwg->header_vars.TSTACKSIZE, tstacksize);
    tstacksize++;
    if (dwg_dynapi_header_set_value (dwg, "TSTACKSIZE", &tstacksize, 0)
        && tstacksize == dwg->header_vars.TSTACKSIZE)
      pass ();
    else
      fail ("HEADER.TSTACKSIZE [BS] set+1 %hu != %hu",
            dwg->header_vars.TSTACKSIZE, tstacksize);
    tstacksize--;
    dwg_dynapi_header_set_value (dwg, "TSTACKSIZE", &tstacksize, 0);

  }
  {
    BITCODE_TV hyperlinkbase;
    if (dwg_dynapi_header_value (dwg, "HYPERLINKBASE", &hyperlinkbase, NULL)
        && !memcmp (&hyperlinkbase, &dwg->header_vars.HYPERLINKBASE, sizeof (dwg->header_vars.HYPERLINKBASE))
       )
      pass ();
    else
      fail ("HEADER.HYPERLINKBASE [TV]");
  }
  {
    BITCODE_TV stylesheet;
    if (dwg_dynapi_header_value (dwg, "STYLESHEET", &stylesheet, NULL)
        && !memcmp (&stylesheet, &dwg->header_vars.STYLESHEET, sizeof (dwg->header_vars.STYLESHEET))
       )
      pass ();
    else
      fail ("HEADER.STYLESHEET [TV]");
  }
  {
    BITCODE_H dictionary_layout;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_LAYOUT", &dictionary_layout, NULL)
        && !memcmp (&dictionary_layout, &dwg->header_vars.DICTIONARY_LAYOUT, sizeof (dwg->header_vars.DICTIONARY_LAYOUT))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_LAYOUT [H]");
  }
  {
    BITCODE_H dictionary_plotsettings;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_PLOTSETTINGS", &dictionary_plotsettings, NULL)
        && !memcmp (&dictionary_plotsettings, &dwg->header_vars.DICTIONARY_PLOTSETTINGS, sizeof (dwg->header_vars.DICTIONARY_PLOTSETTINGS))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_PLOTSETTINGS [H]");
  }
  {
    BITCODE_H dictionary_plotstylename;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_PLOTSTYLENAME", &dictionary_plotstylename, NULL)
        && !memcmp (&dictionary_plotstylename, &dwg->header_vars.DICTIONARY_PLOTSTYLENAME, sizeof (dwg->header_vars.DICTIONARY_PLOTSTYLENAME))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_PLOTSTYLENAME [H]");
  }
  {
    BITCODE_H dictionary_material;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_MATERIAL", &dictionary_material, NULL)
        && !memcmp (&dictionary_material, &dwg->header_vars.DICTIONARY_MATERIAL, sizeof (dwg->header_vars.DICTIONARY_MATERIAL))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_MATERIAL [H]");
  }
  {
    BITCODE_H dictionary_color;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_COLOR", &dictionary_color, NULL)
        && !memcmp (&dictionary_color, &dwg->header_vars.DICTIONARY_COLOR, sizeof (dwg->header_vars.DICTIONARY_COLOR))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_COLOR [H]");
  }
  {
    BITCODE_H dictionary_visualstyle;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_VISUALSTYLE", &dictionary_visualstyle, NULL)
        && !memcmp (&dictionary_visualstyle, &dwg->header_vars.DICTIONARY_VISUALSTYLE, sizeof (dwg->header_vars.DICTIONARY_VISUALSTYLE))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_VISUALSTYLE [H]");
  }
  {
    BITCODE_H dictionary_lightlist;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_LIGHTLIST", &dictionary_lightlist, NULL)
        && !memcmp (&dictionary_lightlist, &dwg->header_vars.DICTIONARY_LIGHTLIST, sizeof (dwg->header_vars.DICTIONARY_LIGHTLIST))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_LIGHTLIST [H]");
  }
  {
    BITCODE_H unknown_20;
    if (dwg_dynapi_header_value (dwg, "unknown_20", &unknown_20, NULL)
        && !memcmp (&unknown_20, &dwg->header_vars.unknown_20, sizeof (dwg->header_vars.unknown_20))
       )
      pass ();
    else
      fail ("HEADER.unknown_20 [H]");
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_header_value (dwg, "FLAGS", &flags, NULL)
        && flags == dwg->header_vars.FLAGS)
      pass ();
    else
      fail ("HEADER.FLAGS [BL] %u != %u", dwg->header_vars.FLAGS, flags);
    flags++;
    if (dwg_dynapi_header_set_value (dwg, "FLAGS", &flags, 0)
        && flags == dwg->header_vars.FLAGS)
      pass ();
    else
      fail ("HEADER.FLAGS [BL] set+1 %u != %u",
            dwg->header_vars.FLAGS, flags);
    flags--;
    dwg_dynapi_header_set_value (dwg, "FLAGS", &flags, 0);

  }
  {
    BITCODE_BSd celweight;
    if (dwg_dynapi_header_value (dwg, "CELWEIGHT", &celweight, NULL)
        && celweight == dwg->header_vars.CELWEIGHT)
      pass ();
    else
      fail ("HEADER.CELWEIGHT [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dwg->header_vars.CELWEIGHT, celweight);
    celweight++;
    if (dwg_dynapi_header_set_value (dwg, "CELWEIGHT", &celweight, 0)
        && celweight == dwg->header_vars.CELWEIGHT)
      pass ();
    else
      fail ("HEADER.CELWEIGHT [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "",
            dwg->header_vars.CELWEIGHT, celweight);
    celweight--;
    dwg_dynapi_header_set_value (dwg, "CELWEIGHT", &celweight, 0);

  }
  {
    BITCODE_B endcaps;
    if (dwg_dynapi_header_value (dwg, "ENDCAPS", &endcaps, NULL)
        && endcaps == dwg->header_vars.ENDCAPS)
      pass ();
    else
      fail ("HEADER.ENDCAPS [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ENDCAPS, endcaps);
    endcaps++;
    if (dwg_dynapi_header_set_value (dwg, "ENDCAPS", &endcaps, 0)
        && endcaps == dwg->header_vars.ENDCAPS)
      pass ();
    else
      fail ("HEADER.ENDCAPS [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ENDCAPS, endcaps);
    endcaps--;
    dwg_dynapi_header_set_value (dwg, "ENDCAPS", &endcaps, 0);

  }
  {
    BITCODE_B joinstyle;
    if (dwg_dynapi_header_value (dwg, "JOINSTYLE", &joinstyle, NULL)
        && joinstyle == dwg->header_vars.JOINSTYLE)
      pass ();
    else
      fail ("HEADER.JOINSTYLE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.JOINSTYLE, joinstyle);
    joinstyle++;
    if (dwg_dynapi_header_set_value (dwg, "JOINSTYLE", &joinstyle, 0)
        && joinstyle == dwg->header_vars.JOINSTYLE)
      pass ();
    else
      fail ("HEADER.JOINSTYLE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.JOINSTYLE, joinstyle);
    joinstyle--;
    dwg_dynapi_header_set_value (dwg, "JOINSTYLE", &joinstyle, 0);

  }
  {
    BITCODE_B lwdisplay;
    if (dwg_dynapi_header_value (dwg, "LWDISPLAY", &lwdisplay, NULL)
        && lwdisplay == dwg->header_vars.LWDISPLAY)
      pass ();
    else
      fail ("HEADER.LWDISPLAY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.LWDISPLAY, lwdisplay);
    lwdisplay++;
    if (dwg_dynapi_header_set_value (dwg, "LWDISPLAY", &lwdisplay, 0)
        && lwdisplay == dwg->header_vars.LWDISPLAY)
      pass ();
    else
      fail ("HEADER.LWDISPLAY [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.LWDISPLAY, lwdisplay);
    lwdisplay--;
    dwg_dynapi_header_set_value (dwg, "LWDISPLAY", &lwdisplay, 0);

  }
  {
    BITCODE_B xedit;
    if (dwg_dynapi_header_value (dwg, "XEDIT", &xedit, NULL)
        && xedit == dwg->header_vars.XEDIT)
      pass ();
    else
      fail ("HEADER.XEDIT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.XEDIT, xedit);
    xedit++;
    if (dwg_dynapi_header_set_value (dwg, "XEDIT", &xedit, 0)
        && xedit == dwg->header_vars.XEDIT)
      pass ();
    else
      fail ("HEADER.XEDIT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.XEDIT, xedit);
    xedit--;
    dwg_dynapi_header_set_value (dwg, "XEDIT", &xedit, 0);

  }
  {
    BITCODE_B extnames;
    if (dwg_dynapi_header_value (dwg, "EXTNAMES", &extnames, NULL)
        && extnames == dwg->header_vars.EXTNAMES)
      pass ();
    else
      fail ("HEADER.EXTNAMES [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.EXTNAMES, extnames);
    extnames++;
    if (dwg_dynapi_header_set_value (dwg, "EXTNAMES", &extnames, 0)
        && extnames == dwg->header_vars.EXTNAMES)
      pass ();
    else
      fail ("HEADER.EXTNAMES [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.EXTNAMES, extnames);
    extnames--;
    dwg_dynapi_header_set_value (dwg, "EXTNAMES", &extnames, 0);

  }
  {
    BITCODE_B pstylemode;
    if (dwg_dynapi_header_value (dwg, "PSTYLEMODE", &pstylemode, NULL)
        && pstylemode == dwg->header_vars.PSTYLEMODE)
      pass ();
    else
      fail ("HEADER.PSTYLEMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PSTYLEMODE, pstylemode);
    pstylemode++;
    if (dwg_dynapi_header_set_value (dwg, "PSTYLEMODE", &pstylemode, 0)
        && pstylemode == dwg->header_vars.PSTYLEMODE)
      pass ();
    else
      fail ("HEADER.PSTYLEMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PSTYLEMODE, pstylemode);
    pstylemode--;
    dwg_dynapi_header_set_value (dwg, "PSTYLEMODE", &pstylemode, 0);

  }
  {
    BITCODE_B olestartup;
    if (dwg_dynapi_header_value (dwg, "OLESTARTUP", &olestartup, NULL)
        && olestartup == dwg->header_vars.OLESTARTUP)
      pass ();
    else
      fail ("HEADER.OLESTARTUP [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.OLESTARTUP, olestartup);
    olestartup++;
    if (dwg_dynapi_header_set_value (dwg, "OLESTARTUP", &olestartup, 0)
        && olestartup == dwg->header_vars.OLESTARTUP)
      pass ();
    else
      fail ("HEADER.OLESTARTUP [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.OLESTARTUP, olestartup);
    olestartup--;
    dwg_dynapi_header_set_value (dwg, "OLESTARTUP", &olestartup, 0);

  }
  {
    BITCODE_BS insunits;
    if (dwg_dynapi_header_value (dwg, "INSUNITS", &insunits, NULL)
        && insunits == dwg->header_vars.INSUNITS)
      pass ();
    else
      fail ("HEADER.INSUNITS [BS] %hu != %hu", dwg->header_vars.INSUNITS, insunits);
    insunits++;
    if (dwg_dynapi_header_set_value (dwg, "INSUNITS", &insunits, 0)
        && insunits == dwg->header_vars.INSUNITS)
      pass ();
    else
      fail ("HEADER.INSUNITS [BS] set+1 %hu != %hu",
            dwg->header_vars.INSUNITS, insunits);
    insunits--;
    dwg_dynapi_header_set_value (dwg, "INSUNITS", &insunits, 0);

  }
  {
    BITCODE_BS cepsntype;
    if (dwg_dynapi_header_value (dwg, "CEPSNTYPE", &cepsntype, NULL)
        && cepsntype == dwg->header_vars.CEPSNTYPE)
      pass ();
    else
      fail ("HEADER.CEPSNTYPE [BS] %hu != %hu", dwg->header_vars.CEPSNTYPE, cepsntype);
    cepsntype++;
    if (dwg_dynapi_header_set_value (dwg, "CEPSNTYPE", &cepsntype, 0)
        && cepsntype == dwg->header_vars.CEPSNTYPE)
      pass ();
    else
      fail ("HEADER.CEPSNTYPE [BS] set+1 %hu != %hu",
            dwg->header_vars.CEPSNTYPE, cepsntype);
    cepsntype--;
    dwg_dynapi_header_set_value (dwg, "CEPSNTYPE", &cepsntype, 0);

  }
  {
    BITCODE_H cpsnid;
    if (dwg_dynapi_header_value (dwg, "CPSNID", &cpsnid, NULL)
        && !memcmp (&cpsnid, &dwg->header_vars.CPSNID, sizeof (dwg->header_vars.CPSNID))
       )
      pass ();
    else
      fail ("HEADER.CPSNID [H]");
  }
  {
    BITCODE_TV fingerprintguid;
    if (dwg_dynapi_header_value (dwg, "FINGERPRINTGUID", &fingerprintguid, NULL)
        && !memcmp (&fingerprintguid, &dwg->header_vars.FINGERPRINTGUID, sizeof (dwg->header_vars.FINGERPRINTGUID))
       )
      pass ();
    else
      fail ("HEADER.FINGERPRINTGUID [TV]");
  }
  {
    BITCODE_TV versionguid;
    if (dwg_dynapi_header_value (dwg, "VERSIONGUID", &versionguid, NULL)
        && !memcmp (&versionguid, &dwg->header_vars.VERSIONGUID, sizeof (dwg->header_vars.VERSIONGUID))
       )
      pass ();
    else
      fail ("HEADER.VERSIONGUID [TV]");
  }
  {
    BITCODE_RC sortents;
    if (dwg_dynapi_header_value (dwg, "SORTENTS", &sortents, NULL)
        && sortents == dwg->header_vars.SORTENTS)
      pass ();
    else
      fail ("HEADER.SORTENTS [RC] %u != %u", dwg->header_vars.SORTENTS, sortents);
    sortents++;
    if (dwg_dynapi_header_set_value (dwg, "SORTENTS", &sortents, 0)
        && sortents == dwg->header_vars.SORTENTS)
      pass ();
    else
      fail ("HEADER.SORTENTS [RC] set+1 %u != %u",
            dwg->header_vars.SORTENTS, sortents);
    sortents--;
    dwg_dynapi_header_set_value (dwg, "SORTENTS", &sortents, 0);

  }
  {
    BITCODE_RC indexctl;
    if (dwg_dynapi_header_value (dwg, "INDEXCTL", &indexctl, NULL)
        && indexctl == dwg->header_vars.INDEXCTL)
      pass ();
    else
      fail ("HEADER.INDEXCTL [RC] %u != %u", dwg->header_vars.INDEXCTL, indexctl);
    indexctl++;
    if (dwg_dynapi_header_set_value (dwg, "INDEXCTL", &indexctl, 0)
        && indexctl == dwg->header_vars.INDEXCTL)
      pass ();
    else
      fail ("HEADER.INDEXCTL [RC] set+1 %u != %u",
            dwg->header_vars.INDEXCTL, indexctl);
    indexctl--;
    dwg_dynapi_header_set_value (dwg, "INDEXCTL", &indexctl, 0);

  }
  {
    BITCODE_RC hidetext;
    if (dwg_dynapi_header_value (dwg, "HIDETEXT", &hidetext, NULL)
        && hidetext == dwg->header_vars.HIDETEXT)
      pass ();
    else
      fail ("HEADER.HIDETEXT [RC] %u != %u", dwg->header_vars.HIDETEXT, hidetext);
    hidetext++;
    if (dwg_dynapi_header_set_value (dwg, "HIDETEXT", &hidetext, 0)
        && hidetext == dwg->header_vars.HIDETEXT)
      pass ();
    else
      fail ("HEADER.HIDETEXT [RC] set+1 %u != %u",
            dwg->header_vars.HIDETEXT, hidetext);
    hidetext--;
    dwg_dynapi_header_set_value (dwg, "HIDETEXT", &hidetext, 0);

  }
  {
    BITCODE_RC xclipframe;
    if (dwg_dynapi_header_value (dwg, "XCLIPFRAME", &xclipframe, NULL)
        && xclipframe == dwg->header_vars.XCLIPFRAME)
      pass ();
    else
      fail ("HEADER.XCLIPFRAME [RC] %u != %u", dwg->header_vars.XCLIPFRAME, xclipframe);
    xclipframe++;
    if (dwg_dynapi_header_set_value (dwg, "XCLIPFRAME", &xclipframe, 0)
        && xclipframe == dwg->header_vars.XCLIPFRAME)
      pass ();
    else
      fail ("HEADER.XCLIPFRAME [RC] set+1 %u != %u",
            dwg->header_vars.XCLIPFRAME, xclipframe);
    xclipframe--;
    dwg_dynapi_header_set_value (dwg, "XCLIPFRAME", &xclipframe, 0);

  }
  {
    BITCODE_RC dimassoc;
    if (dwg_dynapi_header_value (dwg, "DIMASSOC", &dimassoc, NULL)
        && dimassoc == dwg->header_vars.DIMASSOC)
      pass ();
    else
      fail ("HEADER.DIMASSOC [RC] %u != %u", dwg->header_vars.DIMASSOC, dimassoc);
    dimassoc++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASSOC", &dimassoc, 0)
        && dimassoc == dwg->header_vars.DIMASSOC)
      pass ();
    else
      fail ("HEADER.DIMASSOC [RC] set+1 %u != %u",
            dwg->header_vars.DIMASSOC, dimassoc);
    dimassoc--;
    dwg_dynapi_header_set_value (dwg, "DIMASSOC", &dimassoc, 0);

  }
  {
    BITCODE_RC halogap;
    if (dwg_dynapi_header_value (dwg, "HALOGAP", &halogap, NULL)
        && halogap == dwg->header_vars.HALOGAP)
      pass ();
    else
      fail ("HEADER.HALOGAP [RC] %u != %u", dwg->header_vars.HALOGAP, halogap);
    halogap++;
    if (dwg_dynapi_header_set_value (dwg, "HALOGAP", &halogap, 0)
        && halogap == dwg->header_vars.HALOGAP)
      pass ();
    else
      fail ("HEADER.HALOGAP [RC] set+1 %u != %u",
            dwg->header_vars.HALOGAP, halogap);
    halogap--;
    dwg_dynapi_header_set_value (dwg, "HALOGAP", &halogap, 0);

  }
  {
    BITCODE_BS obscolor;
    if (dwg_dynapi_header_value (dwg, "OBSCOLOR", &obscolor, NULL)
        && obscolor == dwg->header_vars.OBSCOLOR)
      pass ();
    else
      fail ("HEADER.OBSCOLOR [BS] %hu != %hu", dwg->header_vars.OBSCOLOR, obscolor);
    obscolor++;
    if (dwg_dynapi_header_set_value (dwg, "OBSCOLOR", &obscolor, 0)
        && obscolor == dwg->header_vars.OBSCOLOR)
      pass ();
    else
      fail ("HEADER.OBSCOLOR [BS] set+1 %hu != %hu",
            dwg->header_vars.OBSCOLOR, obscolor);
    obscolor--;
    dwg_dynapi_header_set_value (dwg, "OBSCOLOR", &obscolor, 0);

  }
  {
    BITCODE_BS intersectioncolor;
    if (dwg_dynapi_header_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, NULL)
        && intersectioncolor == dwg->header_vars.INTERSECTIONCOLOR)
      pass ();
    else
      fail ("HEADER.INTERSECTIONCOLOR [BS] %hu != %hu", dwg->header_vars.INTERSECTIONCOLOR, intersectioncolor);
    intersectioncolor++;
    if (dwg_dynapi_header_set_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, 0)
        && intersectioncolor == dwg->header_vars.INTERSECTIONCOLOR)
      pass ();
    else
      fail ("HEADER.INTERSECTIONCOLOR [BS] set+1 %hu != %hu",
            dwg->header_vars.INTERSECTIONCOLOR, intersectioncolor);
    intersectioncolor--;
    dwg_dynapi_header_set_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, 0);

  }
  {
    BITCODE_RC obsltype;
    if (dwg_dynapi_header_value (dwg, "OBSLTYPE", &obsltype, NULL)
        && obsltype == dwg->header_vars.OBSLTYPE)
      pass ();
    else
      fail ("HEADER.OBSLTYPE [RC] %u != %u", dwg->header_vars.OBSLTYPE, obsltype);
    obsltype++;
    if (dwg_dynapi_header_set_value (dwg, "OBSLTYPE", &obsltype, 0)
        && obsltype == dwg->header_vars.OBSLTYPE)
      pass ();
    else
      fail ("HEADER.OBSLTYPE [RC] set+1 %u != %u",
            dwg->header_vars.OBSLTYPE, obsltype);
    obsltype--;
    dwg_dynapi_header_set_value (dwg, "OBSLTYPE", &obsltype, 0);

  }
  {
    BITCODE_RC intersectiondisplay;
    if (dwg_dynapi_header_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, NULL)
        && intersectiondisplay == dwg->header_vars.INTERSECTIONDISPLAY)
      pass ();
    else
      fail ("HEADER.INTERSECTIONDISPLAY [RC] %u != %u", dwg->header_vars.INTERSECTIONDISPLAY, intersectiondisplay);
    intersectiondisplay++;
    if (dwg_dynapi_header_set_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, 0)
        && intersectiondisplay == dwg->header_vars.INTERSECTIONDISPLAY)
      pass ();
    else
      fail ("HEADER.INTERSECTIONDISPLAY [RC] set+1 %u != %u",
            dwg->header_vars.INTERSECTIONDISPLAY, intersectiondisplay);
    intersectiondisplay--;
    dwg_dynapi_header_set_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, 0);

  }
  {
    BITCODE_TV projectname;
    if (dwg_dynapi_header_value (dwg, "PROJECTNAME", &projectname, NULL)
        && !memcmp (&projectname, &dwg->header_vars.PROJECTNAME, sizeof (dwg->header_vars.PROJECTNAME))
       )
      pass ();
    else
      fail ("HEADER.PROJECTNAME [TV]");
  }
  {
    BITCODE_H block_record_pspace;
    if (dwg_dynapi_header_value (dwg, "BLOCK_RECORD_PSPACE", &block_record_pspace, NULL)
        && !memcmp (&block_record_pspace, &dwg->header_vars.BLOCK_RECORD_PSPACE, sizeof (dwg->header_vars.BLOCK_RECORD_PSPACE))
       )
      pass ();
    else
      fail ("HEADER.BLOCK_RECORD_PSPACE [H]");
  }
  {
    BITCODE_H block_record_mspace;
    if (dwg_dynapi_header_value (dwg, "BLOCK_RECORD_MSPACE", &block_record_mspace, NULL)
        && !memcmp (&block_record_mspace, &dwg->header_vars.BLOCK_RECORD_MSPACE, sizeof (dwg->header_vars.BLOCK_RECORD_MSPACE))
       )
      pass ();
    else
      fail ("HEADER.BLOCK_RECORD_MSPACE [H]");
  }
  {
    BITCODE_H ltype_bylayer;
    if (dwg_dynapi_header_value (dwg, "LTYPE_BYLAYER", &ltype_bylayer, NULL)
        && !memcmp (&ltype_bylayer, &dwg->header_vars.LTYPE_BYLAYER, sizeof (dwg->header_vars.LTYPE_BYLAYER))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_BYLAYER [H]");
  }
  {
    BITCODE_H ltype_byblock;
    if (dwg_dynapi_header_value (dwg, "LTYPE_BYBLOCK", &ltype_byblock, NULL)
        && !memcmp (&ltype_byblock, &dwg->header_vars.LTYPE_BYBLOCK, sizeof (dwg->header_vars.LTYPE_BYBLOCK))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_BYBLOCK [H]");
  }
  {
    BITCODE_H ltype_continuous;
    if (dwg_dynapi_header_value (dwg, "LTYPE_CONTINUOUS", &ltype_continuous, NULL)
        && !memcmp (&ltype_continuous, &dwg->header_vars.LTYPE_CONTINUOUS, sizeof (dwg->header_vars.LTYPE_CONTINUOUS))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_CONTINUOUS [H]");
  }
  {
    BITCODE_B cameradisplay;
    if (dwg_dynapi_header_value (dwg, "CAMERADISPLAY", &cameradisplay, NULL)
        && cameradisplay == dwg->header_vars.CAMERADISPLAY)
      pass ();
    else
      fail ("HEADER.CAMERADISPLAY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.CAMERADISPLAY, cameradisplay);
    cameradisplay++;
    if (dwg_dynapi_header_set_value (dwg, "CAMERADISPLAY", &cameradisplay, 0)
        && cameradisplay == dwg->header_vars.CAMERADISPLAY)
      pass ();
    else
      fail ("HEADER.CAMERADISPLAY [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.CAMERADISPLAY, cameradisplay);
    cameradisplay--;
    dwg_dynapi_header_set_value (dwg, "CAMERADISPLAY", &cameradisplay, 0);

  }
  {
    BITCODE_BL unknown_21;
    if (dwg_dynapi_header_value (dwg, "unknown_21", &unknown_21, NULL)
        && unknown_21 == dwg->header_vars.unknown_21)
      pass ();
    else
      fail ("HEADER.unknown_21 [BL] %u != %u", dwg->header_vars.unknown_21, unknown_21);
    unknown_21++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_21", &unknown_21, 0)
        && unknown_21 == dwg->header_vars.unknown_21)
      pass ();
    else
      fail ("HEADER.unknown_21 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_21, unknown_21);
    unknown_21--;
    dwg_dynapi_header_set_value (dwg, "unknown_21", &unknown_21, 0);

  }
  {
    BITCODE_BL unknown_22;
    if (dwg_dynapi_header_value (dwg, "unknown_22", &unknown_22, NULL)
        && unknown_22 == dwg->header_vars.unknown_22)
      pass ();
    else
      fail ("HEADER.unknown_22 [BL] %u != %u", dwg->header_vars.unknown_22, unknown_22);
    unknown_22++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_22", &unknown_22, 0)
        && unknown_22 == dwg->header_vars.unknown_22)
      pass ();
    else
      fail ("HEADER.unknown_22 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_22, unknown_22);
    unknown_22--;
    dwg_dynapi_header_set_value (dwg, "unknown_22", &unknown_22, 0);

  }
  {
    BITCODE_BD unknown_23;
    if (dwg_dynapi_header_value (dwg, "unknown_23", &unknown_23, NULL)
        && unknown_23 == dwg->header_vars.unknown_23)
      pass ();
    else
      fail ("HEADER.unknown_23 [BD] %g != %g", dwg->header_vars.unknown_23, unknown_23);
    unknown_23++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_23", &unknown_23, 0)
        && unknown_23 == dwg->header_vars.unknown_23)
      pass ();
    else
      fail ("HEADER.unknown_23 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_23, unknown_23);
    unknown_23--;
    dwg_dynapi_header_set_value (dwg, "unknown_23", &unknown_23, 0);

  }
  {
    BITCODE_BD stepspersec;
    if (dwg_dynapi_header_value (dwg, "STEPSPERSEC", &stepspersec, NULL)
        && stepspersec == dwg->header_vars.STEPSPERSEC)
      pass ();
    else
      fail ("HEADER.STEPSPERSEC [BD] %g != %g", dwg->header_vars.STEPSPERSEC, stepspersec);
    stepspersec++;
    if (dwg_dynapi_header_set_value (dwg, "STEPSPERSEC", &stepspersec, 0)
        && stepspersec == dwg->header_vars.STEPSPERSEC)
      pass ();
    else
      fail ("HEADER.STEPSPERSEC [BD] set+1 %g != %g",
            dwg->header_vars.STEPSPERSEC, stepspersec);
    stepspersec--;
    dwg_dynapi_header_set_value (dwg, "STEPSPERSEC", &stepspersec, 0);

  }
  {
    BITCODE_BD stepsize;
    if (dwg_dynapi_header_value (dwg, "STEPSIZE", &stepsize, NULL)
        && stepsize == dwg->header_vars.STEPSIZE)
      pass ();
    else
      fail ("HEADER.STEPSIZE [BD] %g != %g", dwg->header_vars.STEPSIZE, stepsize);
    stepsize++;
    if (dwg_dynapi_header_set_value (dwg, "STEPSIZE", &stepsize, 0)
        && stepsize == dwg->header_vars.STEPSIZE)
      pass ();
    else
      fail ("HEADER.STEPSIZE [BD] set+1 %g != %g",
            dwg->header_vars.STEPSIZE, stepsize);
    stepsize--;
    dwg_dynapi_header_set_value (dwg, "STEPSIZE", &stepsize, 0);

  }
  {
    BITCODE_BD _3ddwfprec;
    if (dwg_dynapi_header_value (dwg, "_3DDWFPREC", &_3ddwfprec, NULL)
        && _3ddwfprec == dwg->header_vars._3DDWFPREC)
      pass ();
    else
      fail ("HEADER._3DDWFPREC [BD] %g != %g", dwg->header_vars._3DDWFPREC, _3ddwfprec);
    _3ddwfprec++;
    if (dwg_dynapi_header_set_value (dwg, "_3DDWFPREC", &_3ddwfprec, 0)
        && _3ddwfprec == dwg->header_vars._3DDWFPREC)
      pass ();
    else
      fail ("HEADER._3DDWFPREC [BD] set+1 %g != %g",
            dwg->header_vars._3DDWFPREC, _3ddwfprec);
    _3ddwfprec--;
    dwg_dynapi_header_set_value (dwg, "_3DDWFPREC", &_3ddwfprec, 0);

  }
  {
    BITCODE_BD lenslength;
    if (dwg_dynapi_header_value (dwg, "LENSLENGTH", &lenslength, NULL)
        && lenslength == dwg->header_vars.LENSLENGTH)
      pass ();
    else
      fail ("HEADER.LENSLENGTH [BD] %g != %g", dwg->header_vars.LENSLENGTH, lenslength);
    lenslength++;
    if (dwg_dynapi_header_set_value (dwg, "LENSLENGTH", &lenslength, 0)
        && lenslength == dwg->header_vars.LENSLENGTH)
      pass ();
    else
      fail ("HEADER.LENSLENGTH [BD] set+1 %g != %g",
            dwg->header_vars.LENSLENGTH, lenslength);
    lenslength--;
    dwg_dynapi_header_set_value (dwg, "LENSLENGTH", &lenslength, 0);

  }
  {
    BITCODE_BD cameraheight;
    if (dwg_dynapi_header_value (dwg, "CAMERAHEIGHT", &cameraheight, NULL)
        && cameraheight == dwg->header_vars.CAMERAHEIGHT)
      pass ();
    else
      fail ("HEADER.CAMERAHEIGHT [BD] %g != %g", dwg->header_vars.CAMERAHEIGHT, cameraheight);
    cameraheight++;
    if (dwg_dynapi_header_set_value (dwg, "CAMERAHEIGHT", &cameraheight, 0)
        && cameraheight == dwg->header_vars.CAMERAHEIGHT)
      pass ();
    else
      fail ("HEADER.CAMERAHEIGHT [BD] set+1 %g != %g",
            dwg->header_vars.CAMERAHEIGHT, cameraheight);
    cameraheight--;
    dwg_dynapi_header_set_value (dwg, "CAMERAHEIGHT", &cameraheight, 0);

  }
  {
    BITCODE_RC solidhist;
    if (dwg_dynapi_header_value (dwg, "SOLIDHIST", &solidhist, NULL)
        && solidhist == dwg->header_vars.SOLIDHIST)
      pass ();
    else
      fail ("HEADER.SOLIDHIST [RC] %u != %u", dwg->header_vars.SOLIDHIST, solidhist);
    solidhist++;
    if (dwg_dynapi_header_set_value (dwg, "SOLIDHIST", &solidhist, 0)
        && solidhist == dwg->header_vars.SOLIDHIST)
      pass ();
    else
      fail ("HEADER.SOLIDHIST [RC] set+1 %u != %u",
            dwg->header_vars.SOLIDHIST, solidhist);
    solidhist--;
    dwg_dynapi_header_set_value (dwg, "SOLIDHIST", &solidhist, 0);

  }
  {
    BITCODE_RC showhist;
    if (dwg_dynapi_header_value (dwg, "SHOWHIST", &showhist, NULL)
        && showhist == dwg->header_vars.SHOWHIST)
      pass ();
    else
      fail ("HEADER.SHOWHIST [RC] %u != %u", dwg->header_vars.SHOWHIST, showhist);
    showhist++;
    if (dwg_dynapi_header_set_value (dwg, "SHOWHIST", &showhist, 0)
        && showhist == dwg->header_vars.SHOWHIST)
      pass ();
    else
      fail ("HEADER.SHOWHIST [RC] set+1 %u != %u",
            dwg->header_vars.SHOWHIST, showhist);
    showhist--;
    dwg_dynapi_header_set_value (dwg, "SHOWHIST", &showhist, 0);

  }
  {
    BITCODE_BD psolwidth;
    if (dwg_dynapi_header_value (dwg, "PSOLWIDTH", &psolwidth, NULL)
        && psolwidth == dwg->header_vars.PSOLWIDTH)
      pass ();
    else
      fail ("HEADER.PSOLWIDTH [BD] %g != %g", dwg->header_vars.PSOLWIDTH, psolwidth);
    psolwidth++;
    if (dwg_dynapi_header_set_value (dwg, "PSOLWIDTH", &psolwidth, 0)
        && psolwidth == dwg->header_vars.PSOLWIDTH)
      pass ();
    else
      fail ("HEADER.PSOLWIDTH [BD] set+1 %g != %g",
            dwg->header_vars.PSOLWIDTH, psolwidth);
    psolwidth--;
    dwg_dynapi_header_set_value (dwg, "PSOLWIDTH", &psolwidth, 0);

  }
  {
    BITCODE_BD psolheight;
    if (dwg_dynapi_header_value (dwg, "PSOLHEIGHT", &psolheight, NULL)
        && psolheight == dwg->header_vars.PSOLHEIGHT)
      pass ();
    else
      fail ("HEADER.PSOLHEIGHT [BD] %g != %g", dwg->header_vars.PSOLHEIGHT, psolheight);
    psolheight++;
    if (dwg_dynapi_header_set_value (dwg, "PSOLHEIGHT", &psolheight, 0)
        && psolheight == dwg->header_vars.PSOLHEIGHT)
      pass ();
    else
      fail ("HEADER.PSOLHEIGHT [BD] set+1 %g != %g",
            dwg->header_vars.PSOLHEIGHT, psolheight);
    psolheight--;
    dwg_dynapi_header_set_value (dwg, "PSOLHEIGHT", &psolheight, 0);

  }
  {
    BITCODE_BD loftang1;
    if (dwg_dynapi_header_value (dwg, "LOFTANG1", &loftang1, NULL)
        && loftang1 == dwg->header_vars.LOFTANG1)
      pass ();
    else
      fail ("HEADER.LOFTANG1 [BD] %g != %g", dwg->header_vars.LOFTANG1, loftang1);
    loftang1++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTANG1", &loftang1, 0)
        && loftang1 == dwg->header_vars.LOFTANG1)
      pass ();
    else
      fail ("HEADER.LOFTANG1 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTANG1, loftang1);
    loftang1--;
    dwg_dynapi_header_set_value (dwg, "LOFTANG1", &loftang1, 0);

  }
  {
    BITCODE_BD loftang2;
    if (dwg_dynapi_header_value (dwg, "LOFTANG2", &loftang2, NULL)
        && loftang2 == dwg->header_vars.LOFTANG2)
      pass ();
    else
      fail ("HEADER.LOFTANG2 [BD] %g != %g", dwg->header_vars.LOFTANG2, loftang2);
    loftang2++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTANG2", &loftang2, 0)
        && loftang2 == dwg->header_vars.LOFTANG2)
      pass ();
    else
      fail ("HEADER.LOFTANG2 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTANG2, loftang2);
    loftang2--;
    dwg_dynapi_header_set_value (dwg, "LOFTANG2", &loftang2, 0);

  }
  {
    BITCODE_BD loftmag1;
    if (dwg_dynapi_header_value (dwg, "LOFTMAG1", &loftmag1, NULL)
        && loftmag1 == dwg->header_vars.LOFTMAG1)
      pass ();
    else
      fail ("HEADER.LOFTMAG1 [BD] %g != %g", dwg->header_vars.LOFTMAG1, loftmag1);
    loftmag1++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTMAG1", &loftmag1, 0)
        && loftmag1 == dwg->header_vars.LOFTMAG1)
      pass ();
    else
      fail ("HEADER.LOFTMAG1 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTMAG1, loftmag1);
    loftmag1--;
    dwg_dynapi_header_set_value (dwg, "LOFTMAG1", &loftmag1, 0);

  }
  {
    BITCODE_BD loftmag2;
    if (dwg_dynapi_header_value (dwg, "LOFTMAG2", &loftmag2, NULL)
        && loftmag2 == dwg->header_vars.LOFTMAG2)
      pass ();
    else
      fail ("HEADER.LOFTMAG2 [BD] %g != %g", dwg->header_vars.LOFTMAG2, loftmag2);
    loftmag2++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTMAG2", &loftmag2, 0)
        && loftmag2 == dwg->header_vars.LOFTMAG2)
      pass ();
    else
      fail ("HEADER.LOFTMAG2 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTMAG2, loftmag2);
    loftmag2--;
    dwg_dynapi_header_set_value (dwg, "LOFTMAG2", &loftmag2, 0);

  }
  {
    BITCODE_BS loftparam;
    if (dwg_dynapi_header_value (dwg, "LOFTPARAM", &loftparam, NULL)
        && loftparam == dwg->header_vars.LOFTPARAM)
      pass ();
    else
      fail ("HEADER.LOFTPARAM [BS] %hu != %hu", dwg->header_vars.LOFTPARAM, loftparam);
    loftparam++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTPARAM", &loftparam, 0)
        && loftparam == dwg->header_vars.LOFTPARAM)
      pass ();
    else
      fail ("HEADER.LOFTPARAM [BS] set+1 %hu != %hu",
            dwg->header_vars.LOFTPARAM, loftparam);
    loftparam--;
    dwg_dynapi_header_set_value (dwg, "LOFTPARAM", &loftparam, 0);

  }
  {
    BITCODE_RC loftnormals;
    if (dwg_dynapi_header_value (dwg, "LOFTNORMALS", &loftnormals, NULL)
        && loftnormals == dwg->header_vars.LOFTNORMALS)
      pass ();
    else
      fail ("HEADER.LOFTNORMALS [RC] %u != %u", dwg->header_vars.LOFTNORMALS, loftnormals);
    loftnormals++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTNORMALS", &loftnormals, 0)
        && loftnormals == dwg->header_vars.LOFTNORMALS)
      pass ();
    else
      fail ("HEADER.LOFTNORMALS [RC] set+1 %u != %u",
            dwg->header_vars.LOFTNORMALS, loftnormals);
    loftnormals--;
    dwg_dynapi_header_set_value (dwg, "LOFTNORMALS", &loftnormals, 0);

  }
  {
    BITCODE_BD latitude;
    if (dwg_dynapi_header_value (dwg, "LATITUDE", &latitude, NULL)
        && latitude == dwg->header_vars.LATITUDE)
      pass ();
    else
      fail ("HEADER.LATITUDE [BD] %g != %g", dwg->header_vars.LATITUDE, latitude);
    latitude++;
    if (dwg_dynapi_header_set_value (dwg, "LATITUDE", &latitude, 0)
        && latitude == dwg->header_vars.LATITUDE)
      pass ();
    else
      fail ("HEADER.LATITUDE [BD] set+1 %g != %g",
            dwg->header_vars.LATITUDE, latitude);
    latitude--;
    dwg_dynapi_header_set_value (dwg, "LATITUDE", &latitude, 0);

  }
  {
    BITCODE_BD longitude;
    if (dwg_dynapi_header_value (dwg, "LONGITUDE", &longitude, NULL)
        && longitude == dwg->header_vars.LONGITUDE)
      pass ();
    else
      fail ("HEADER.LONGITUDE [BD] %g != %g", dwg->header_vars.LONGITUDE, longitude);
    longitude++;
    if (dwg_dynapi_header_set_value (dwg, "LONGITUDE", &longitude, 0)
        && longitude == dwg->header_vars.LONGITUDE)
      pass ();
    else
      fail ("HEADER.LONGITUDE [BD] set+1 %g != %g",
            dwg->header_vars.LONGITUDE, longitude);
    longitude--;
    dwg_dynapi_header_set_value (dwg, "LONGITUDE", &longitude, 0);

  }
  {
    BITCODE_BD northdirection;
    if (dwg_dynapi_header_value (dwg, "NORTHDIRECTION", &northdirection, NULL)
        && northdirection == dwg->header_vars.NORTHDIRECTION)
      pass ();
    else
      fail ("HEADER.NORTHDIRECTION [BD] %g != %g", dwg->header_vars.NORTHDIRECTION, northdirection);
    northdirection++;
    if (dwg_dynapi_header_set_value (dwg, "NORTHDIRECTION", &northdirection, 0)
        && northdirection == dwg->header_vars.NORTHDIRECTION)
      pass ();
    else
      fail ("HEADER.NORTHDIRECTION [BD] set+1 %g != %g",
            dwg->header_vars.NORTHDIRECTION, northdirection);
    northdirection--;
    dwg_dynapi_header_set_value (dwg, "NORTHDIRECTION", &northdirection, 0);

  }
  {
    BITCODE_BL timezone;
    if (dwg_dynapi_header_value (dwg, "TIMEZONE", &timezone, NULL)
        && timezone == dwg->header_vars.TIMEZONE)
      pass ();
    else
      fail ("HEADER.TIMEZONE [BL] %u != %u", dwg->header_vars.TIMEZONE, timezone);
    timezone++;
    if (dwg_dynapi_header_set_value (dwg, "TIMEZONE", &timezone, 0)
        && timezone == dwg->header_vars.TIMEZONE)
      pass ();
    else
      fail ("HEADER.TIMEZONE [BL] set+1 %u != %u",
            dwg->header_vars.TIMEZONE, timezone);
    timezone--;
    dwg_dynapi_header_set_value (dwg, "TIMEZONE", &timezone, 0);

  }
  {
    BITCODE_RC lightglyphdisplay;
    if (dwg_dynapi_header_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, NULL)
        && lightglyphdisplay == dwg->header_vars.LIGHTGLYPHDISPLAY)
      pass ();
    else
      fail ("HEADER.LIGHTGLYPHDISPLAY [RC] %u != %u", dwg->header_vars.LIGHTGLYPHDISPLAY, lightglyphdisplay);
    lightglyphdisplay++;
    if (dwg_dynapi_header_set_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, 0)
        && lightglyphdisplay == dwg->header_vars.LIGHTGLYPHDISPLAY)
      pass ();
    else
      fail ("HEADER.LIGHTGLYPHDISPLAY [RC] set+1 %u != %u",
            dwg->header_vars.LIGHTGLYPHDISPLAY, lightglyphdisplay);
    lightglyphdisplay--;
    dwg_dynapi_header_set_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, 0);

  }
  {
    BITCODE_RC tilemodelightsynch;
    if (dwg_dynapi_header_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, NULL)
        && tilemodelightsynch == dwg->header_vars.TILEMODELIGHTSYNCH)
      pass ();
    else
      fail ("HEADER.TILEMODELIGHTSYNCH [RC] %u != %u", dwg->header_vars.TILEMODELIGHTSYNCH, tilemodelightsynch);
    tilemodelightsynch++;
    if (dwg_dynapi_header_set_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, 0)
        && tilemodelightsynch == dwg->header_vars.TILEMODELIGHTSYNCH)
      pass ();
    else
      fail ("HEADER.TILEMODELIGHTSYNCH [RC] set+1 %u != %u",
            dwg->header_vars.TILEMODELIGHTSYNCH, tilemodelightsynch);
    tilemodelightsynch--;
    dwg_dynapi_header_set_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, 0);

  }
  {
    BITCODE_RC dwfframe;
    if (dwg_dynapi_header_value (dwg, "DWFFRAME", &dwfframe, NULL)
        && dwfframe == dwg->header_vars.DWFFRAME)
      pass ();
    else
      fail ("HEADER.DWFFRAME [RC] %u != %u", dwg->header_vars.DWFFRAME, dwfframe);
    dwfframe++;
    if (dwg_dynapi_header_set_value (dwg, "DWFFRAME", &dwfframe, 0)
        && dwfframe == dwg->header_vars.DWFFRAME)
      pass ();
    else
      fail ("HEADER.DWFFRAME [RC] set+1 %u != %u",
            dwg->header_vars.DWFFRAME, dwfframe);
    dwfframe--;
    dwg_dynapi_header_set_value (dwg, "DWFFRAME", &dwfframe, 0);

  }
  {
    BITCODE_RC dgnframe;
    if (dwg_dynapi_header_value (dwg, "DGNFRAME", &dgnframe, NULL)
        && dgnframe == dwg->header_vars.DGNFRAME)
      pass ();
    else
      fail ("HEADER.DGNFRAME [RC] %u != %u", dwg->header_vars.DGNFRAME, dgnframe);
    dgnframe++;
    if (dwg_dynapi_header_set_value (dwg, "DGNFRAME", &dgnframe, 0)
        && dgnframe == dwg->header_vars.DGNFRAME)
      pass ();
    else
      fail ("HEADER.DGNFRAME [RC] set+1 %u != %u",
            dwg->header_vars.DGNFRAME, dgnframe);
    dgnframe--;
    dwg_dynapi_header_set_value (dwg, "DGNFRAME", &dgnframe, 0);

  }
  {
    BITCODE_B realworldscale;
    if (dwg_dynapi_header_value (dwg, "REALWORLDSCALE", &realworldscale, NULL)
        && realworldscale == dwg->header_vars.REALWORLDSCALE)
      pass ();
    else
      fail ("HEADER.REALWORLDSCALE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.REALWORLDSCALE, realworldscale);
    realworldscale++;
    if (dwg_dynapi_header_set_value (dwg, "REALWORLDSCALE", &realworldscale, 0)
        && realworldscale == dwg->header_vars.REALWORLDSCALE)
      pass ();
    else
      fail ("HEADER.REALWORLDSCALE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.REALWORLDSCALE, realworldscale);
    realworldscale--;
    dwg_dynapi_header_set_value (dwg, "REALWORLDSCALE", &realworldscale, 0);

  }
  {
    BITCODE_CMC interferecolor;
    if (dwg_dynapi_header_value (dwg, "INTERFERECOLOR", &interferecolor, NULL)
        && !memcmp (&interferecolor, &dwg->header_vars.INTERFERECOLOR, sizeof (dwg->header_vars.INTERFERECOLOR))
       )
      pass ();
    else
      fail ("HEADER.INTERFERECOLOR [CMC]");
  }
  {
    BITCODE_H interfereobjvs;
    if (dwg_dynapi_header_value (dwg, "INTERFEREOBJVS", &interfereobjvs, NULL)
        && !memcmp (&interfereobjvs, &dwg->header_vars.INTERFEREOBJVS, sizeof (dwg->header_vars.INTERFEREOBJVS))
       )
      pass ();
    else
      fail ("HEADER.INTERFEREOBJVS [H]");
  }
  {
    BITCODE_H interferevpvs;
    if (dwg_dynapi_header_value (dwg, "INTERFEREVPVS", &interferevpvs, NULL)
        && !memcmp (&interferevpvs, &dwg->header_vars.INTERFEREVPVS, sizeof (dwg->header_vars.INTERFEREVPVS))
       )
      pass ();
    else
      fail ("HEADER.INTERFEREVPVS [H]");
  }
  {
    BITCODE_H dragvs;
    if (dwg_dynapi_header_value (dwg, "DRAGVS", &dragvs, NULL)
        && !memcmp (&dragvs, &dwg->header_vars.DRAGVS, sizeof (dwg->header_vars.DRAGVS))
       )
      pass ();
    else
      fail ("HEADER.DRAGVS [H]");
  }
  {
    BITCODE_RC cshadow;
    if (dwg_dynapi_header_value (dwg, "CSHADOW", &cshadow, NULL)
        && cshadow == dwg->header_vars.CSHADOW)
      pass ();
    else
      fail ("HEADER.CSHADOW [RC] %u != %u", dwg->header_vars.CSHADOW, cshadow);
    cshadow++;
    if (dwg_dynapi_header_set_value (dwg, "CSHADOW", &cshadow, 0)
        && cshadow == dwg->header_vars.CSHADOW)
      pass ();
    else
      fail ("HEADER.CSHADOW [RC] set+1 %u != %u",
            dwg->header_vars.CSHADOW, cshadow);
    cshadow--;
    dwg_dynapi_header_set_value (dwg, "CSHADOW", &cshadow, 0);

  }
  {
    BITCODE_BD shadowplanelocation;
    if (dwg_dynapi_header_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, NULL)
        && shadowplanelocation == dwg->header_vars.SHADOWPLANELOCATION)
      pass ();
    else
      fail ("HEADER.SHADOWPLANELOCATION [BD] %g != %g", dwg->header_vars.SHADOWPLANELOCATION, shadowplanelocation);
    shadowplanelocation++;
    if (dwg_dynapi_header_set_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, 0)
        && shadowplanelocation == dwg->header_vars.SHADOWPLANELOCATION)
      pass ();
    else
      fail ("HEADER.SHADOWPLANELOCATION [BD] set+1 %g != %g",
            dwg->header_vars.SHADOWPLANELOCATION, shadowplanelocation);
    shadowplanelocation--;
    dwg_dynapi_header_set_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, 0);

  }
  {
    BITCODE_BS unknown_54;
    if (dwg_dynapi_header_value (dwg, "unknown_54", &unknown_54, NULL)
        && unknown_54 == dwg->header_vars.unknown_54)
      pass ();
    else
      fail ("HEADER.unknown_54 [BS] %hu != %hu", dwg->header_vars.unknown_54, unknown_54);
    unknown_54++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_54", &unknown_54, 0)
        && unknown_54 == dwg->header_vars.unknown_54)
      pass ();
    else
      fail ("HEADER.unknown_54 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_54, unknown_54);
    unknown_54--;
    dwg_dynapi_header_set_value (dwg, "unknown_54", &unknown_54, 0);

  }
  {
    BITCODE_BS unknown_55;
    if (dwg_dynapi_header_value (dwg, "unknown_55", &unknown_55, NULL)
        && unknown_55 == dwg->header_vars.unknown_55)
      pass ();
    else
      fail ("HEADER.unknown_55 [BS] %hu != %hu", dwg->header_vars.unknown_55, unknown_55);
    unknown_55++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_55", &unknown_55, 0)
        && unknown_55 == dwg->header_vars.unknown_55)
      pass ();
    else
      fail ("HEADER.unknown_55 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_55, unknown_55);
    unknown_55--;
    dwg_dynapi_header_set_value (dwg, "unknown_55", &unknown_55, 0);

  }
  {
    BITCODE_BS unknown_56;
    if (dwg_dynapi_header_value (dwg, "unknown_56", &unknown_56, NULL)
        && unknown_56 == dwg->header_vars.unknown_56)
      pass ();
    else
      fail ("HEADER.unknown_56 [BS] %hu != %hu", dwg->header_vars.unknown_56, unknown_56);
    unknown_56++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_56", &unknown_56, 0)
        && unknown_56 == dwg->header_vars.unknown_56)
      pass ();
    else
      fail ("HEADER.unknown_56 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_56, unknown_56);
    unknown_56--;
    dwg_dynapi_header_set_value (dwg, "unknown_56", &unknown_56, 0);

  }
  {
    BITCODE_BS unknown_57;
    if (dwg_dynapi_header_value (dwg, "unknown_57", &unknown_57, NULL)
        && unknown_57 == dwg->header_vars.unknown_57)
      pass ();
    else
      fail ("HEADER.unknown_57 [BS] %hu != %hu", dwg->header_vars.unknown_57, unknown_57);
    unknown_57++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_57", &unknown_57, 0)
        && unknown_57 == dwg->header_vars.unknown_57)
      pass ();
    else
      fail ("HEADER.unknown_57 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_57, unknown_57);
    unknown_57--;
    dwg_dynapi_header_set_value (dwg, "unknown_57", &unknown_57, 0);

  }
#line 47 "dynapi_test.c.in"
  return error;
}
#line 5379 "dynapi_test.c"
/* @@for test_OBJECT@@ */
static int test__3DFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity__3DFACE *restrict _3dface = obj->tio.entity->tio._3DFACE;
  {
    BITCODE_3BD corner1;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &_3dface->corner1, sizeof (_3dface->corner1)))
        pass ();
    else
        fail ("3DFACE.corner1 [3BD]");
  }
  {
    BITCODE_3BD corner2;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &_3dface->corner2, sizeof (_3dface->corner2)))
        pass ();
    else
        fail ("3DFACE.corner2 [3BD]");
  }
  {
    BITCODE_3BD corner3;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &_3dface->corner3, sizeof (_3dface->corner3)))
        pass ();
    else
        fail ("3DFACE.corner3 [3BD]");
  }
  {
    BITCODE_3BD corner4;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &_3dface->corner4, sizeof (_3dface->corner4)))
        pass ();
    else
        fail ("3DFACE.corner4 [3BD]");
  }
  {
    BITCODE_B has_no_flags;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "has_no_flags", &has_no_flags, NULL)
        && has_no_flags == _3dface->has_no_flags)
      pass ();
    else
      fail ("3DFACE.has_no_flags [B] " FORMAT_B " != " FORMAT_B "", _3dface->has_no_flags, has_no_flags);
    has_no_flags++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "has_no_flags", &has_no_flags, 0)
        && has_no_flags == _3dface->has_no_flags)
      pass ();
    else
      fail ("3DFACE.has_no_flags [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dface->has_no_flags, has_no_flags);
    _3dface->has_no_flags--;

  }
  {
    BITCODE_BS invis_flags;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "invis_flags", &invis_flags, NULL)
        && invis_flags == _3dface->invis_flags)
      pass ();
    else
      fail ("3DFACE.invis_flags [BS] %hu != %hu", _3dface->invis_flags, invis_flags);
    invis_flags++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "invis_flags", &invis_flags, 0)
        && invis_flags == _3dface->invis_flags)
      pass ();
    else
      fail ("3DFACE.invis_flags [BS] set+1 %hu != %hu", _3dface->invis_flags, invis_flags);
    _3dface->invis_flags--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &_3dface->parent, sizeof (_3dface->parent)))
        pass ();
    else
        fail ("3DFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B z_is_zero;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "z_is_zero", &z_is_zero, NULL)
        && z_is_zero == _3dface->z_is_zero)
      pass ();
    else
      fail ("3DFACE.z_is_zero [B] " FORMAT_B " != " FORMAT_B "", _3dface->z_is_zero, z_is_zero);
    z_is_zero++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "z_is_zero", &z_is_zero, 0)
        && z_is_zero == _3dface->z_is_zero)
      pass ();
    else
      fail ("3DFACE.z_is_zero [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dface->z_is_zero, z_is_zero);
    _3dface->z_is_zero--;

  }
  return failed;
}
static int test__3DSOLID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity__3DSOLID *restrict _3dsolid = obj->tio.entity->tio._3DSOLID;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)_3dsolid->acis_data)
           : !_3dsolid->acis_data)
      pass ();
    else
      fail ("3DSOLID.acis_data [RC*] '%s' <> '%s'", acis_data, _3dsolid->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_empty", &acis_empty, NULL)
        && acis_empty == _3dsolid->acis_empty)
      pass ();
    else
      fail ("3DSOLID.acis_empty [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty", &acis_empty, 0)
        && acis_empty == _3dsolid->acis_empty)
      pass ();
    else
      fail ("3DSOLID.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty, acis_empty);
    _3dsolid->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == _3dsolid->acis_empty2)
      pass ();
    else
      fail ("3DSOLID.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == _3dsolid->acis_empty2)
      pass ();
    else
      fail ("3DSOLID.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty2, acis_empty2);
    _3dsolid->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == _3dsolid->acis_empty_bit)
      pass ();
    else
      fail ("3DSOLID.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == _3dsolid->acis_empty_bit)
      pass ();
    else
      fail ("3DSOLID.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty_bit, acis_empty_bit);
    _3dsolid->acis_empty_bit--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &_3dsolid->block_size, sizeof (_3dsolid->block_size)))
        pass ();
    else
        fail ("3DSOLID.block_size [BL*]");
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &_3dsolid->encr_sat_data, sizeof (_3dsolid->encr_sat_data)))
      pass ();
    else
      fail ("3DSOLID.encr_sat_data [char **]");
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &_3dsolid->extra_acis_data, sizeof (_3dsolid->extra_acis_data)))
        pass ();
    else
        fail ("3DSOLID.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &_3dsolid->history_id, sizeof (_3dsolid->history_id)))
        pass ();
    else
        fail ("3DSOLID.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "isoline_present", &isoline_present, NULL)
        && isoline_present == _3dsolid->isoline_present)
      pass ();
    else
      fail ("3DSOLID.isoline_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "isoline_present", &isoline_present, 0)
        && isoline_present == _3dsolid->isoline_present)
      pass ();
    else
      fail ("3DSOLID.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->isoline_present, isoline_present);
    _3dsolid->isoline_present--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_blocks", &num_blocks, NULL)
        && num_blocks == _3dsolid->num_blocks)
      pass ();
    else
      fail ("3DSOLID.num_blocks [BL] %u != %u", _3dsolid->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_blocks", &num_blocks, 0)
        && num_blocks == _3dsolid->num_blocks)
      pass ();
    else
      fail ("3DSOLID.num_blocks [BL] set+1 %u != %u", _3dsolid->num_blocks, num_blocks);
    _3dsolid->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_isolines", &num_isolines, NULL)
        && num_isolines == _3dsolid->num_isolines)
      pass ();
    else
      fail ("3DSOLID.num_isolines [BL] %u != %u", _3dsolid->num_isolines, num_isolines);
    num_isolines++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_isolines", &num_isolines, 0)
        && num_isolines == _3dsolid->num_isolines)
      pass ();
    else
      fail ("3DSOLID.num_isolines [BL] set+1 %u != %u", _3dsolid->num_isolines, num_isolines);
    _3dsolid->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == _3dsolid->num_silhouettes)
      pass ();
    else
      fail ("3DSOLID.num_silhouettes [BL] %u != %u", _3dsolid->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == _3dsolid->num_silhouettes)
      pass ();
    else
      fail ("3DSOLID.num_silhouettes [BL] set+1 %u != %u", _3dsolid->num_silhouettes, num_silhouettes);
    _3dsolid->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_wires", &num_wires, NULL)
        && num_wires == _3dsolid->num_wires)
      pass ();
    else
      fail ("3DSOLID.num_wires [BL] %u != %u", _3dsolid->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_wires", &num_wires, 0)
        && num_wires == _3dsolid->num_wires)
      pass ();
    else
      fail ("3DSOLID.num_wires [BL] set+1 %u != %u", _3dsolid->num_wires, num_wires);
    _3dsolid->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "parent", &parent, NULL)
        && !memcmp (&parent, &_3dsolid->parent, sizeof (_3dsolid->parent)))
        pass ();
    else
        fail ("3DSOLID.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "point", &point, NULL)
        && !memcmp (&point, &_3dsolid->point, sizeof (_3dsolid->point)))
        pass ();
    else
        fail ("3DSOLID.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "point_present", &point_present, NULL)
        && point_present == _3dsolid->point_present)
      pass ();
    else
      fail ("3DSOLID.point_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "point_present", &point_present, 0)
        && point_present == _3dsolid->point_present)
      pass ();
    else
      fail ("3DSOLID.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->point_present, point_present);
    _3dsolid->point_present--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "silhouettes", &silhouettes, NULL)
        && silhouettes == _3dsolid->silhouettes)
      pass ();
    else
      fail ("3DSOLID.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "unknown", &unknown, NULL)
        && unknown == _3dsolid->unknown)
      pass ();
    else
      fail ("3DSOLID.unknown [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "unknown", &unknown, 0)
        && unknown == _3dsolid->unknown)
      pass ();
    else
      fail ("3DSOLID.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->unknown, unknown);
    _3dsolid->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == _3dsolid->unknown_2007)
      pass ();
    else
      fail ("3DSOLID.unknown_2007 [BL] %u != %u", _3dsolid->unknown_2007, unknown_2007);
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "unknown_2007", &unknown_2007, 0)
        && unknown_2007 == _3dsolid->unknown_2007)
      pass ();
    else
      fail ("3DSOLID.unknown_2007 [BL] set+1 %u != %u", _3dsolid->unknown_2007, unknown_2007);
    _3dsolid->unknown_2007--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "version", &version, NULL)
        && version == _3dsolid->version)
      pass ();
    else
      fail ("3DSOLID.version [BS] %hu != %hu", _3dsolid->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "version", &version, 0)
        && version == _3dsolid->version)
      pass ();
    else
      fail ("3DSOLID.version [BS] set+1 %hu != %hu", _3dsolid->version, version);
    _3dsolid->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == _3dsolid->wireframe_data_present)
      pass ();
    else
      fail ("3DSOLID.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == _3dsolid->wireframe_data_present)
      pass ();
    else
      fail ("3DSOLID.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->wireframe_data_present, wireframe_data_present);
    _3dsolid->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "wires", &wires, NULL)
        && wires == _3dsolid->wires)
      pass ();
    else
      fail ("3DSOLID.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  return failed;
}
static int test_ARC (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ARC *restrict arc = obj->tio.entity->tio.ARC;
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (arc, "ARC", "center", &center, NULL)
        && !memcmp (&center, &arc->center, sizeof (arc->center)))
        pass ();
    else
        fail ("ARC.center [3BD]");
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value (arc, "ARC", "end_angle", &end_angle, NULL)
        && end_angle == arc->end_angle)
      pass ();
    else
      fail ("ARC.end_angle [BD] %g != %g", arc->end_angle, end_angle);
    end_angle++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "end_angle", &end_angle, 0)
        && end_angle == arc->end_angle)
      pass ();
    else
      fail ("ARC.end_angle [BD] set+1 %g != %g", arc->end_angle, end_angle);
    arc->end_angle--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (arc, "ARC", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &arc->extrusion, sizeof (arc->extrusion)))
        pass ();
    else
        fail ("ARC.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (arc, "ARC", "parent", &parent, NULL)
        && !memcmp (&parent, &arc->parent, sizeof (arc->parent)))
        pass ();
    else
        fail ("ARC.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (arc, "ARC", "radius", &radius, NULL)
        && radius == arc->radius)
      pass ();
    else
      fail ("ARC.radius [BD] %g != %g", arc->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "radius", &radius, 0)
        && radius == arc->radius)
      pass ();
    else
      fail ("ARC.radius [BD] set+1 %g != %g", arc->radius, radius);
    arc->radius--;

  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (arc, "ARC", "start_angle", &start_angle, NULL)
        && start_angle == arc->start_angle)
      pass ();
    else
      fail ("ARC.start_angle [BD] %g != %g", arc->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "start_angle", &start_angle, 0)
        && start_angle == arc->start_angle)
      pass ();
    else
      fail ("ARC.start_angle [BD] set+1 %g != %g", arc->start_angle, start_angle);
    arc->start_angle--;

  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (arc, "ARC", "thickness", &thickness, NULL)
        && thickness == arc->thickness)
      pass ();
    else
      fail ("ARC.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", arc->thickness, thickness);
    if (dwg_dynapi_entity_set_value (arc, "ARC", "thickness", &thickness, 0)
        && thickness == arc->thickness)
      pass ();
    else
      fail ("ARC.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", arc->thickness, thickness);
    arc->thickness--;

  }
  return failed;
}
static int test_ARC_DIMENSION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ARC_DIMENSION *restrict arc_dimension = obj->tio.entity->tio.ARC_DIMENSION;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &arc_dimension->_13_pt, sizeof (arc_dimension->_13_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION._13_pt [3BD]");
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &arc_dimension->_14_pt, sizeof (arc_dimension->_14_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION._14_pt [3BD]");
  }
  {
    BITCODE_3BD _15_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "_15_pt", &_15_pt, NULL)
        && !memcmp (&_15_pt, &arc_dimension->_15_pt, sizeof (arc_dimension->_15_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION._15_pt [3BD]");
  }
  {
    BITCODE_3BD _16_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "_16_pt", &_16_pt, NULL)
        && !memcmp (&_16_pt, &arc_dimension->_16_pt, sizeof (arc_dimension->_16_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION._16_pt [3BD]");
  }
  {
    BITCODE_3BD _17_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "_17_pt", &_17_pt, NULL)
        && !memcmp (&_17_pt, &arc_dimension->_17_pt, sizeof (arc_dimension->_17_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION._17_pt [3BD]");
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "act_measurement", &act_measurement, NULL)
        && act_measurement == arc_dimension->act_measurement)
      pass ();
    else
      fail ("ARC_DIMENSION.act_measurement [BD] %g != %g", arc_dimension->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "act_measurement", &act_measurement, 0)
        && act_measurement == arc_dimension->act_measurement)
      pass ();
    else
      fail ("ARC_DIMENSION.act_measurement [BD] set+1 %g != %g", arc_dimension->act_measurement, act_measurement);
    arc_dimension->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "attachment", &attachment, NULL)
        && attachment == arc_dimension->attachment)
      pass ();
    else
      fail ("ARC_DIMENSION.attachment [BS] %hu != %hu", arc_dimension->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "attachment", &attachment, 0)
        && attachment == arc_dimension->attachment)
      pass ();
    else
      fail ("ARC_DIMENSION.attachment [BS] set+1 %hu != %hu", arc_dimension->attachment, attachment);
    arc_dimension->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "block", &block, NULL)
        && !memcmp (&block, &arc_dimension->block, sizeof (arc_dimension->block)))
        pass ();
    else
        fail ("ARC_DIMENSION.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)arc_dimension->blockname)
           : !arc_dimension->blockname)
      pass ();
    else
      fail ("ARC_DIMENSION.blockname [TV] '%s' <> '%s'", blockname, arc_dimension->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "class_version", &class_version, NULL)
        && class_version == arc_dimension->class_version)
      pass ();
    else
      fail ("ARC_DIMENSION.class_version [RC] %u != %u", arc_dimension->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "class_version", &class_version, 0)
        && class_version == arc_dimension->class_version)
      pass ();
    else
      fail ("ARC_DIMENSION.class_version [RC] set+1 %u != %u", arc_dimension->class_version, class_version);
    arc_dimension->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &arc_dimension->clone_ins_pt, sizeof (arc_dimension->clone_ins_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &arc_dimension->def_pt, sizeof (arc_dimension->def_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &arc_dimension->dimstyle, sizeof (arc_dimension->dimstyle)))
        pass ();
    else
        fail ("ARC_DIMENSION.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "elevation", &elevation, NULL)
        && elevation == arc_dimension->elevation)
      pass ();
    else
      fail ("ARC_DIMENSION.elevation [BD] %g != %g", arc_dimension->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "elevation", &elevation, 0)
        && elevation == arc_dimension->elevation)
      pass ();
    else
      fail ("ARC_DIMENSION.elevation [BD] set+1 %g != %g", arc_dimension->elevation, elevation);
    arc_dimension->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &arc_dimension->extrusion, sizeof (arc_dimension->extrusion)))
        pass ();
    else
        fail ("ARC_DIMENSION.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flag", &flag, NULL)
        && flag == arc_dimension->flag)
      pass ();
    else
      fail ("ARC_DIMENSION.flag [RC] %u != %u", arc_dimension->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag", &flag, 0)
        && flag == arc_dimension->flag)
      pass ();
    else
      fail ("ARC_DIMENSION.flag [RC] set+1 %u != %u", arc_dimension->flag, flag);
    arc_dimension->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flag1", &flag1, NULL)
        && flag1 == arc_dimension->flag1)
      pass ();
    else
      fail ("ARC_DIMENSION.flag1 [RC] %u != %u", arc_dimension->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag1", &flag1, 0)
        && flag1 == arc_dimension->flag1)
      pass ();
    else
      fail ("ARC_DIMENSION.flag1 [RC] set+1 %u != %u", arc_dimension->flag1, flag1);
    arc_dimension->flag1--;

  }
  {
    BITCODE_RC flag2;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flag2", &flag2, NULL)
        && flag2 == arc_dimension->flag2)
      pass ();
    else
      fail ("ARC_DIMENSION.flag2 [RC] %u != %u", arc_dimension->flag2, flag2);
    flag2++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag2", &flag2, 0)
        && flag2 == arc_dimension->flag2)
      pass ();
    else
      fail ("ARC_DIMENSION.flag2 [RC] set+1 %u != %u", arc_dimension->flag2, flag2);
    arc_dimension->flag2--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == arc_dimension->flip_arrow1)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == arc_dimension->flip_arrow1)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow1, flip_arrow1);
    arc_dimension->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == arc_dimension->flip_arrow2)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == arc_dimension->flip_arrow2)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow2, flip_arrow2);
    arc_dimension->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == arc_dimension->horiz_dir)
      pass ();
    else
      fail ("ARC_DIMENSION.horiz_dir [BD] %g != %g", arc_dimension->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == arc_dimension->horiz_dir)
      pass ();
    else
      fail ("ARC_DIMENSION.horiz_dir [BD] set+1 %g != %g", arc_dimension->horiz_dir, horiz_dir);
    arc_dimension->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == arc_dimension->ins_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.ins_rotation [BD] %g != %g", arc_dimension->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == arc_dimension->ins_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.ins_rotation [BD] set+1 %g != %g", arc_dimension->ins_rotation, ins_rotation);
    arc_dimension->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &arc_dimension->ins_scale, sizeof (arc_dimension->ins_scale)))
        pass ();
    else
        fail ("ARC_DIMENSION.ins_scale [3BD]");
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "leader_len", &leader_len, NULL)
        && leader_len == arc_dimension->leader_len)
      pass ();
    else
      fail ("ARC_DIMENSION.leader_len [BD] %g != %g", arc_dimension->leader_len, leader_len);
    leader_len++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "leader_len", &leader_len, 0)
        && leader_len == arc_dimension->leader_len)
      pass ();
    else
      fail ("ARC_DIMENSION.leader_len [BD] set+1 %g != %g", arc_dimension->leader_len, leader_len);
    arc_dimension->leader_len--;

  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == arc_dimension->lspace_factor)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_factor [BD] %g != %g", arc_dimension->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == arc_dimension->lspace_factor)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_factor [BD] set+1 %g != %g", arc_dimension->lspace_factor, lspace_factor);
    arc_dimension->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "lspace_style", &lspace_style, NULL)
        && lspace_style == arc_dimension->lspace_style)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_style [BS] %hu != %hu", arc_dimension->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "lspace_style", &lspace_style, 0)
        && lspace_style == arc_dimension->lspace_style)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_style [BS] set+1 %hu != %hu", arc_dimension->lspace_style, lspace_style);
    arc_dimension->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "parent", &parent, NULL)
        && !memcmp (&parent, &arc_dimension->parent, sizeof (arc_dimension->parent)))
        pass ();
    else
        fail ("ARC_DIMENSION.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &arc_dimension->text_midpt, sizeof (arc_dimension->text_midpt)))
        pass ();
    else
        fail ("ARC_DIMENSION.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "text_rotation", &text_rotation, NULL)
        && text_rotation == arc_dimension->text_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.text_rotation [BD] %g != %g", arc_dimension->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "text_rotation", &text_rotation, 0)
        && text_rotation == arc_dimension->text_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.text_rotation [BD] set+1 %g != %g", arc_dimension->text_rotation, text_rotation);
    arc_dimension->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "unknown", &unknown, NULL)
        && unknown == arc_dimension->unknown)
      pass ();
    else
      fail ("ARC_DIMENSION.unknown [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "unknown", &unknown, 0)
        && unknown == arc_dimension->unknown)
      pass ();
    else
      fail ("ARC_DIMENSION.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->unknown, unknown);
    arc_dimension->unknown--;

  }
  {
    BITCODE_3BD unknown_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "unknown_pt", &unknown_pt, NULL)
        && !memcmp (&unknown_pt, &arc_dimension->unknown_pt, sizeof (arc_dimension->unknown_pt)))
        pass ();
    else
        fail ("ARC_DIMENSION.unknown_pt [3BD]");
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)arc_dimension->user_text)
           : !arc_dimension->user_text)
      pass ();
    else
      fail ("ARC_DIMENSION.user_text [TV] '%s' <> '%s'", user_text, arc_dimension->user_text);
  }
  return failed;
}
static int test_ATTDEF (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATTDEF *restrict attdef = obj->tio.entity->tio.ATTDEF;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &attdef->alignment_pt, sizeof (attdef->alignment_pt)))
        pass ();
    else
        fail ("ATTDEF.alignment_pt [2DPOINT]");
  }
  {
    BITCODE_H annotative_app;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_app", &annotative_app, NULL)
        && !memcmp (&annotative_app, &attdef->annotative_app, sizeof (attdef->annotative_app)))
        pass ();
    else
        fail ("ATTDEF.annotative_app [H]");
  }
  {
    BITCODE_RC annotative_data_bytes;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_data_bytes", &annotative_data_bytes, NULL)
        && annotative_data_bytes == attdef->annotative_data_bytes)
      pass ();
    else
      fail ("ATTDEF.annotative_data_bytes [RC] %u != %u", attdef->annotative_data_bytes, annotative_data_bytes);
    annotative_data_bytes++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_data_bytes", &annotative_data_bytes, 0)
        && annotative_data_bytes == attdef->annotative_data_bytes)
      pass ();
    else
      fail ("ATTDEF.annotative_data_bytes [RC] set+1 %u != %u", attdef->annotative_data_bytes, annotative_data_bytes);
    attdef->annotative_data_bytes--;

  }
  {
    BITCODE_BS annotative_data_size;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_data_size", &annotative_data_size, NULL)
        && annotative_data_size == attdef->annotative_data_size)
      pass ();
    else
      fail ("ATTDEF.annotative_data_size [BS] %hu != %hu", attdef->annotative_data_size, annotative_data_size);
    annotative_data_size++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_data_size", &annotative_data_size, 0)
        && annotative_data_size == attdef->annotative_data_size)
      pass ();
    else
      fail ("ATTDEF.annotative_data_size [BS] set+1 %hu != %hu", attdef->annotative_data_size, annotative_data_size);
    attdef->annotative_data_size--;

  }
  {
    BITCODE_BS annotative_short;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_short", &annotative_short, NULL)
        && annotative_short == attdef->annotative_short)
      pass ();
    else
      fail ("ATTDEF.annotative_short [BS] %hu != %hu", attdef->annotative_short, annotative_short);
    annotative_short++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_short", &annotative_short, 0)
        && annotative_short == attdef->annotative_short)
      pass ();
    else
      fail ("ATTDEF.annotative_short [BS] set+1 %hu != %hu", attdef->annotative_short, annotative_short);
    attdef->annotative_short--;

  }
  {
    BITCODE_RC attdef_class_version;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "attdef_class_version", &attdef_class_version, NULL)
        && attdef_class_version == attdef->attdef_class_version)
      pass ();
    else
      fail ("ATTDEF.attdef_class_version [RC] %u != %u", attdef->attdef_class_version, attdef_class_version);
    attdef_class_version++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "attdef_class_version", &attdef_class_version, 0)
        && attdef_class_version == attdef->attdef_class_version)
      pass ();
    else
      fail ("ATTDEF.attdef_class_version [RC] set+1 %u != %u", attdef->attdef_class_version, attdef_class_version);
    attdef->attdef_class_version--;

  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "class_version", &class_version, NULL)
        && class_version == attdef->class_version)
      pass ();
    else
      fail ("ATTDEF.class_version [RC] %u != %u", attdef->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "class_version", &class_version, 0)
        && class_version == attdef->class_version)
      pass ();
    else
      fail ("ATTDEF.class_version [RC] set+1 %u != %u", attdef->class_version, class_version);
    attdef->class_version--;

  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "dataflags", &dataflags, NULL)
        && dataflags == attdef->dataflags)
      pass ();
    else
      fail ("ATTDEF.dataflags [RC] %u != %u", attdef->dataflags, dataflags);
    dataflags++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "dataflags", &dataflags, 0)
        && dataflags == attdef->dataflags)
      pass ();
    else
      fail ("ATTDEF.dataflags [RC] set+1 %u != %u", attdef->dataflags, dataflags);
    attdef->dataflags--;

  }
  {
    BITCODE_TV default_value;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "default_value", &default_value, NULL)
        && default_value
           ? strEQ ((char *)default_value, (char *)attdef->default_value)
           : !attdef->default_value)
      pass ();
    else
      fail ("ATTDEF.default_value [TV] '%s' <> '%s'", default_value, attdef->default_value);
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "elevation", &elevation, NULL)
        && elevation == attdef->elevation)
      pass ();
    else
      fail ("ATTDEF.elevation [BD] %g != %g", attdef->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "elevation", &elevation, 0)
        && elevation == attdef->elevation)
      pass ();
    else
      fail ("ATTDEF.elevation [BD] set+1 %g != %g", attdef->elevation, elevation);
    attdef->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &attdef->extrusion, sizeof (attdef->extrusion)))
        pass ();
    else
        fail ("ATTDEF.extrusion [BE]");
  }
  {
    BITCODE_BS field_length;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "field_length", &field_length, NULL)
        && field_length == attdef->field_length)
      pass ();
    else
      fail ("ATTDEF.field_length [BS] %hu != %hu", attdef->field_length, field_length);
    field_length++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "field_length", &field_length, 0)
        && field_length == attdef->field_length)
      pass ();
    else
      fail ("ATTDEF.field_length [BS] set+1 %hu != %hu", attdef->field_length, field_length);
    attdef->field_length--;

  }
  {
    BITCODE_RC flags;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "flags", &flags, NULL)
        && flags == attdef->flags)
      pass ();
    else
      fail ("ATTDEF.flags [RC] %u != %u", attdef->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "flags", &flags, 0)
        && flags == attdef->flags)
      pass ();
    else
      fail ("ATTDEF.flags [RC] set+1 %u != %u", attdef->flags, flags);
    attdef->flags--;

  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "generation", &generation, NULL)
        && generation == attdef->generation)
      pass ();
    else
      fail ("ATTDEF.generation [BS] %hu != %hu", attdef->generation, generation);
    generation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "generation", &generation, 0)
        && generation == attdef->generation)
      pass ();
    else
      fail ("ATTDEF.generation [BS] set+1 %hu != %hu", attdef->generation, generation);
    attdef->generation--;

  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "height", &height, NULL)
        && height == attdef->height)
      pass ();
    else
      fail ("ATTDEF.height [RD] %g != %g", attdef->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "height", &height, 0)
        && height == attdef->height)
      pass ();
    else
      fail ("ATTDEF.height [RD] set+1 %g != %g", attdef->height, height);
    attdef->height--;

  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == attdef->horiz_alignment)
      pass ();
    else
      fail ("ATTDEF.horiz_alignment [BS] %hu != %hu", attdef->horiz_alignment, horiz_alignment);
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "horiz_alignment", &horiz_alignment, 0)
        && horiz_alignment == attdef->horiz_alignment)
      pass ();
    else
      fail ("ATTDEF.horiz_alignment [BS] set+1 %hu != %hu", attdef->horiz_alignment, horiz_alignment);
    attdef->horiz_alignment--;

  }
  {
    BITCODE_2DPOINT insertion_pt;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &attdef->insertion_pt, sizeof (attdef->insertion_pt)))
        pass ();
    else
        fail ("ATTDEF.insertion_pt [2DPOINT]");
  }
  {
    BITCODE_B lock_position_flag;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "lock_position_flag", &lock_position_flag, NULL)
        && lock_position_flag == attdef->lock_position_flag)
      pass ();
    else
      fail ("ATTDEF.lock_position_flag [B] " FORMAT_B " != " FORMAT_B "", attdef->lock_position_flag, lock_position_flag);
    lock_position_flag++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "lock_position_flag", &lock_position_flag, 0)
        && lock_position_flag == attdef->lock_position_flag)
      pass ();
    else
      fail ("ATTDEF.lock_position_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", attdef->lock_position_flag, lock_position_flag);
    attdef->lock_position_flag--;

  }
  {
    BITCODE_H mtext_handles;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "mtext_handles", &mtext_handles, NULL)
        && !memcmp (&mtext_handles, &attdef->mtext_handles, sizeof (attdef->mtext_handles)))
        pass ();
    else
        fail ("ATTDEF.mtext_handles [H]");
  }
  {
    BITCODE_RD oblique_ang;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "oblique_ang", &oblique_ang, NULL)
        && oblique_ang == attdef->oblique_ang)
      pass ();
    else
      fail ("ATTDEF.oblique_ang [RD] %g != %g", attdef->oblique_ang, oblique_ang);
    oblique_ang++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "oblique_ang", &oblique_ang, 0)
        && oblique_ang == attdef->oblique_ang)
      pass ();
    else
      fail ("ATTDEF.oblique_ang [RD] set+1 %g != %g", attdef->oblique_ang, oblique_ang);
    attdef->oblique_ang--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "parent", &parent, NULL)
        && !memcmp (&parent, &attdef->parent, sizeof (attdef->parent)))
        pass ();
    else
        fail ("ATTDEF.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_TV prompt;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "prompt", &prompt, NULL)
        && prompt
           ? strEQ ((char *)prompt, (char *)attdef->prompt)
           : !attdef->prompt)
      pass ();
    else
      fail ("ATTDEF.prompt [TV] '%s' <> '%s'", prompt, attdef->prompt);
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "rotation", &rotation, NULL)
        && rotation == attdef->rotation)
      pass ();
    else
      fail ("ATTDEF.rotation [RD] %g != %g", attdef->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "rotation", &rotation, 0)
        && rotation == attdef->rotation)
      pass ();
    else
      fail ("ATTDEF.rotation [RD] set+1 %g != %g", attdef->rotation, rotation);
    attdef->rotation--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "style", &style, NULL)
        && !memcmp (&style, &attdef->style, sizeof (attdef->style)))
        pass ();
    else
        fail ("ATTDEF.style [H]");
  }
  {
    BITCODE_TV tag;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "tag", &tag, NULL)
        && tag
           ? strEQ ((char *)tag, (char *)attdef->tag)
           : !attdef->tag)
      pass ();
    else
      fail ("ATTDEF.tag [TV] '%s' <> '%s'", tag, attdef->tag);
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "thickness", &thickness, NULL)
        && thickness == attdef->thickness)
      pass ();
    else
      fail ("ATTDEF.thickness [RD] %g != %g", attdef->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "thickness", &thickness, 0)
        && thickness == attdef->thickness)
      pass ();
    else
      fail ("ATTDEF.thickness [RD] set+1 %g != %g", attdef->thickness, thickness);
    attdef->thickness--;

  }
  {
    BITCODE_RC type;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "type", &type, NULL)
        && type == attdef->type)
      pass ();
    else
      fail ("ATTDEF.type [RC] %u != %u", attdef->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "type", &type, 0)
        && type == attdef->type)
      pass ();
    else
      fail ("ATTDEF.type [RC] set+1 %u != %u", attdef->type, type);
    attdef->type--;

  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == attdef->vert_alignment)
      pass ();
    else
      fail ("ATTDEF.vert_alignment [BS] %hu != %hu", attdef->vert_alignment, vert_alignment);
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "vert_alignment", &vert_alignment, 0)
        && vert_alignment == attdef->vert_alignment)
      pass ();
    else
      fail ("ATTDEF.vert_alignment [BS] set+1 %hu != %hu", attdef->vert_alignment, vert_alignment);
    attdef->vert_alignment--;

  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "width_factor", &width_factor, NULL)
        && width_factor == attdef->width_factor)
      pass ();
    else
      fail ("ATTDEF.width_factor [RD] %g != %g", attdef->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "width_factor", &width_factor, 0)
        && width_factor == attdef->width_factor)
      pass ();
    else
      fail ("ATTDEF.width_factor [RD] set+1 %g != %g", attdef->width_factor, width_factor);
    attdef->width_factor--;

  }
  return failed;
}
static int test_ATTRIB (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATTRIB *restrict attrib = obj->tio.entity->tio.ATTRIB;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &attrib->alignment_pt, sizeof (attrib->alignment_pt)))
        pass ();
    else
        fail ("ATTRIB.alignment_pt [2DPOINT]");
  }
  {
    BITCODE_H annotative_app;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_app", &annotative_app, NULL)
        && !memcmp (&annotative_app, &attrib->annotative_app, sizeof (attrib->annotative_app)))
        pass ();
    else
        fail ("ATTRIB.annotative_app [H]");
  }
  {
    BITCODE_RC annotative_data_bytes;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_data_bytes", &annotative_data_bytes, NULL)
        && annotative_data_bytes == attrib->annotative_data_bytes)
      pass ();
    else
      fail ("ATTRIB.annotative_data_bytes [RC] %u != %u", attrib->annotative_data_bytes, annotative_data_bytes);
    annotative_data_bytes++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_data_bytes", &annotative_data_bytes, 0)
        && annotative_data_bytes == attrib->annotative_data_bytes)
      pass ();
    else
      fail ("ATTRIB.annotative_data_bytes [RC] set+1 %u != %u", attrib->annotative_data_bytes, annotative_data_bytes);
    attrib->annotative_data_bytes--;

  }
  {
    BITCODE_BS annotative_data_size;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_data_size", &annotative_data_size, NULL)
        && annotative_data_size == attrib->annotative_data_size)
      pass ();
    else
      fail ("ATTRIB.annotative_data_size [BS] %hu != %hu", attrib->annotative_data_size, annotative_data_size);
    annotative_data_size++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_data_size", &annotative_data_size, 0)
        && annotative_data_size == attrib->annotative_data_size)
      pass ();
    else
      fail ("ATTRIB.annotative_data_size [BS] set+1 %hu != %hu", attrib->annotative_data_size, annotative_data_size);
    attrib->annotative_data_size--;

  }
  {
    BITCODE_BS annotative_short;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_short", &annotative_short, NULL)
        && annotative_short == attrib->annotative_short)
      pass ();
    else
      fail ("ATTRIB.annotative_short [BS] %hu != %hu", attrib->annotative_short, annotative_short);
    annotative_short++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_short", &annotative_short, 0)
        && annotative_short == attrib->annotative_short)
      pass ();
    else
      fail ("ATTRIB.annotative_short [BS] set+1 %hu != %hu", attrib->annotative_short, annotative_short);
    attrib->annotative_short--;

  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "class_version", &class_version, NULL)
        && class_version == attrib->class_version)
      pass ();
    else
      fail ("ATTRIB.class_version [RC] %u != %u", attrib->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "class_version", &class_version, 0)
        && class_version == attrib->class_version)
      pass ();
    else
      fail ("ATTRIB.class_version [RC] set+1 %u != %u", attrib->class_version, class_version);
    attrib->class_version--;

  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "dataflags", &dataflags, NULL)
        && dataflags == attrib->dataflags)
      pass ();
    else
      fail ("ATTRIB.dataflags [RC] %u != %u", attrib->dataflags, dataflags);
    dataflags++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "dataflags", &dataflags, 0)
        && dataflags == attrib->dataflags)
      pass ();
    else
      fail ("ATTRIB.dataflags [RC] set+1 %u != %u", attrib->dataflags, dataflags);
    attrib->dataflags--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "elevation", &elevation, NULL)
        && elevation == attrib->elevation)
      pass ();
    else
      fail ("ATTRIB.elevation [BD] %g != %g", attrib->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "elevation", &elevation, 0)
        && elevation == attrib->elevation)
      pass ();
    else
      fail ("ATTRIB.elevation [BD] set+1 %g != %g", attrib->elevation, elevation);
    attrib->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &attrib->extrusion, sizeof (attrib->extrusion)))
        pass ();
    else
        fail ("ATTRIB.extrusion [BE]");
  }
  {
    BITCODE_BS field_length;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "field_length", &field_length, NULL)
        && field_length == attrib->field_length)
      pass ();
    else
      fail ("ATTRIB.field_length [BS] %hu != %hu", attrib->field_length, field_length);
    field_length++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "field_length", &field_length, 0)
        && field_length == attrib->field_length)
      pass ();
    else
      fail ("ATTRIB.field_length [BS] set+1 %hu != %hu", attrib->field_length, field_length);
    attrib->field_length--;

  }
  {
    BITCODE_RC flags;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "flags", &flags, NULL)
        && flags == attrib->flags)
      pass ();
    else
      fail ("ATTRIB.flags [RC] %u != %u", attrib->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "flags", &flags, 0)
        && flags == attrib->flags)
      pass ();
    else
      fail ("ATTRIB.flags [RC] set+1 %u != %u", attrib->flags, flags);
    attrib->flags--;

  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "generation", &generation, NULL)
        && generation == attrib->generation)
      pass ();
    else
      fail ("ATTRIB.generation [BS] %hu != %hu", attrib->generation, generation);
    generation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "generation", &generation, 0)
        && generation == attrib->generation)
      pass ();
    else
      fail ("ATTRIB.generation [BS] set+1 %hu != %hu", attrib->generation, generation);
    attrib->generation--;

  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "height", &height, NULL)
        && height == attrib->height)
      pass ();
    else
      fail ("ATTRIB.height [RD] %g != %g", attrib->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "height", &height, 0)
        && height == attrib->height)
      pass ();
    else
      fail ("ATTRIB.height [RD] set+1 %g != %g", attrib->height, height);
    attrib->height--;

  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == attrib->horiz_alignment)
      pass ();
    else
      fail ("ATTRIB.horiz_alignment [BS] %hu != %hu", attrib->horiz_alignment, horiz_alignment);
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "horiz_alignment", &horiz_alignment, 0)
        && horiz_alignment == attrib->horiz_alignment)
      pass ();
    else
      fail ("ATTRIB.horiz_alignment [BS] set+1 %hu != %hu", attrib->horiz_alignment, horiz_alignment);
    attrib->horiz_alignment--;

  }
  {
    BITCODE_2DPOINT insertion_pt;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &attrib->insertion_pt, sizeof (attrib->insertion_pt)))
        pass ();
    else
        fail ("ATTRIB.insertion_pt [2DPOINT]");
  }
  {
    BITCODE_B lock_position_flag;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "lock_position_flag", &lock_position_flag, NULL)
        && lock_position_flag == attrib->lock_position_flag)
      pass ();
    else
      fail ("ATTRIB.lock_position_flag [B] " FORMAT_B " != " FORMAT_B "", attrib->lock_position_flag, lock_position_flag);
    lock_position_flag++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "lock_position_flag", &lock_position_flag, 0)
        && lock_position_flag == attrib->lock_position_flag)
      pass ();
    else
      fail ("ATTRIB.lock_position_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", attrib->lock_position_flag, lock_position_flag);
    attrib->lock_position_flag--;

  }
  {
    BITCODE_H mtext_handles;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "mtext_handles", &mtext_handles, NULL)
        && !memcmp (&mtext_handles, &attrib->mtext_handles, sizeof (attrib->mtext_handles)))
        pass ();
    else
        fail ("ATTRIB.mtext_handles [H]");
  }
  {
    BITCODE_RD oblique_ang;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "oblique_ang", &oblique_ang, NULL)
        && oblique_ang == attrib->oblique_ang)
      pass ();
    else
      fail ("ATTRIB.oblique_ang [RD] %g != %g", attrib->oblique_ang, oblique_ang);
    oblique_ang++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "oblique_ang", &oblique_ang, 0)
        && oblique_ang == attrib->oblique_ang)
      pass ();
    else
      fail ("ATTRIB.oblique_ang [RD] set+1 %g != %g", attrib->oblique_ang, oblique_ang);
    attrib->oblique_ang--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "parent", &parent, NULL)
        && !memcmp (&parent, &attrib->parent, sizeof (attrib->parent)))
        pass ();
    else
        fail ("ATTRIB.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "rotation", &rotation, NULL)
        && rotation == attrib->rotation)
      pass ();
    else
      fail ("ATTRIB.rotation [RD] %g != %g", attrib->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "rotation", &rotation, 0)
        && rotation == attrib->rotation)
      pass ();
    else
      fail ("ATTRIB.rotation [RD] set+1 %g != %g", attrib->rotation, rotation);
    attrib->rotation--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "style", &style, NULL)
        && !memcmp (&style, &attrib->style, sizeof (attrib->style)))
        pass ();
    else
        fail ("ATTRIB.style [H]");
  }
  {
    BITCODE_TV tag;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "tag", &tag, NULL)
        && tag
           ? strEQ ((char *)tag, (char *)attrib->tag)
           : !attrib->tag)
      pass ();
    else
      fail ("ATTRIB.tag [TV] '%s' <> '%s'", tag, attrib->tag);
  }
  {
    BITCODE_TV text_value;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)attrib->text_value)
           : !attrib->text_value)
      pass ();
    else
      fail ("ATTRIB.text_value [TV] '%s' <> '%s'", text_value, attrib->text_value);
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "thickness", &thickness, NULL)
        && thickness == attrib->thickness)
      pass ();
    else
      fail ("ATTRIB.thickness [RD] %g != %g", attrib->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "thickness", &thickness, 0)
        && thickness == attrib->thickness)
      pass ();
    else
      fail ("ATTRIB.thickness [RD] set+1 %g != %g", attrib->thickness, thickness);
    attrib->thickness--;

  }
  {
    BITCODE_RC type;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "type", &type, NULL)
        && type == attrib->type)
      pass ();
    else
      fail ("ATTRIB.type [RC] %u != %u", attrib->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "type", &type, 0)
        && type == attrib->type)
      pass ();
    else
      fail ("ATTRIB.type [RC] set+1 %u != %u", attrib->type, type);
    attrib->type--;

  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == attrib->vert_alignment)
      pass ();
    else
      fail ("ATTRIB.vert_alignment [BS] %hu != %hu", attrib->vert_alignment, vert_alignment);
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "vert_alignment", &vert_alignment, 0)
        && vert_alignment == attrib->vert_alignment)
      pass ();
    else
      fail ("ATTRIB.vert_alignment [BS] set+1 %hu != %hu", attrib->vert_alignment, vert_alignment);
    attrib->vert_alignment--;

  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "width_factor", &width_factor, NULL)
        && width_factor == attrib->width_factor)
      pass ();
    else
      fail ("ATTRIB.width_factor [RD] %g != %g", attrib->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "width_factor", &width_factor, 0)
        && width_factor == attrib->width_factor)
      pass ();
    else
      fail ("ATTRIB.width_factor [RD] set+1 %g != %g", attrib->width_factor, width_factor);
    attrib->width_factor--;

  }
  return failed;
}
static int test_BLOCK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_BLOCK *restrict block = obj->tio.entity->tio.BLOCK;
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value (block, "BLOCK", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)block->name)
           : !block->name)
      pass ();
    else
      fail ("BLOCK.name [TV] '%s' <> '%s'", name, block->name);
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (block, "BLOCK", "parent", &parent, NULL)
        && !memcmp (&parent, &block->parent, sizeof (block->parent)))
        pass ();
    else
        fail ("BLOCK.parent [struct _dwg_object_entity*]");
  }
  return failed;
}
static int test_BODY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_BODY *restrict body = obj->tio.entity->tio.BODY;
  return failed;
}
static int test_CAMERA (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_CAMERA *restrict camera = obj->tio.entity->tio.CAMERA;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (camera, "CAMERA", "parent", &parent, NULL)
        && !memcmp (&parent, &camera->parent, sizeof (camera->parent)))
        pass ();
    else
        fail ("CAMERA.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H view;
    if (dwg_dynapi_entity_value (camera, "CAMERA", "view", &view, NULL)
        && !memcmp (&view, &camera->view, sizeof (camera->view)))
        pass ();
    else
        fail ("CAMERA.view [H]");
  }
  return failed;
}
static int test_CIRCLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_CIRCLE *restrict circle = obj->tio.entity->tio.CIRCLE;
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "center", &center, NULL)
        && !memcmp (&center, &circle->center, sizeof (circle->center)))
        pass ();
    else
        fail ("CIRCLE.center [3BD]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &circle->extrusion, sizeof (circle->extrusion)))
        pass ();
    else
        fail ("CIRCLE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "parent", &parent, NULL)
        && !memcmp (&parent, &circle->parent, sizeof (circle->parent)))
        pass ();
    else
        fail ("CIRCLE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "radius", &radius, NULL)
        && radius == circle->radius)
      pass ();
    else
      fail ("CIRCLE.radius [BD] %g != %g", circle->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (circle, "CIRCLE", "radius", &radius, 0)
        && radius == circle->radius)
      pass ();
    else
      fail ("CIRCLE.radius [BD] set+1 %g != %g", circle->radius, radius);
    circle->radius--;

  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "thickness", &thickness, NULL)
        && thickness == circle->thickness)
      pass ();
    else
      fail ("CIRCLE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", circle->thickness, thickness);
    if (dwg_dynapi_entity_set_value (circle, "CIRCLE", "thickness", &thickness, 0)
        && thickness == circle->thickness)
      pass ();
    else
      fail ("CIRCLE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", circle->thickness, thickness);
    circle->thickness--;

  }
  return failed;
}
static int test_DIMENSION_ALIGNED (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ALIGNED *restrict dimension_aligned = obj->tio.entity->tio.DIMENSION_ALIGNED;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_aligned->_13_pt, sizeof (dimension_aligned->_13_pt)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED._13_pt [3BD]");
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_aligned->_14_pt, sizeof (dimension_aligned->_14_pt)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED._14_pt [3BD]");
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_aligned->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.act_measurement [BD] %g != %g", dimension_aligned->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_aligned->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.act_measurement [BD] set+1 %g != %g", dimension_aligned->act_measurement, act_measurement);
    dimension_aligned->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "attachment", &attachment, NULL)
        && attachment == dimension_aligned->attachment)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.attachment [BS] %hu != %hu", dimension_aligned->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "attachment", &attachment, 0)
        && attachment == dimension_aligned->attachment)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.attachment [BS] set+1 %hu != %hu", dimension_aligned->attachment, attachment);
    dimension_aligned->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "block", &block, NULL)
        && !memcmp (&block, &dimension_aligned->block, sizeof (dimension_aligned->block)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_aligned->blockname)
           : !dimension_aligned->blockname)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.blockname [TV] '%s' <> '%s'", blockname, dimension_aligned->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "class_version", &class_version, NULL)
        && class_version == dimension_aligned->class_version)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.class_version [RC] %u != %u", dimension_aligned->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "class_version", &class_version, 0)
        && class_version == dimension_aligned->class_version)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.class_version [RC] set+1 %u != %u", dimension_aligned->class_version, class_version);
    dimension_aligned->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_aligned->clone_ins_pt, sizeof (dimension_aligned->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_aligned->def_pt, sizeof (dimension_aligned->def_pt)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_aligned->dimstyle, sizeof (dimension_aligned->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "elevation", &elevation, NULL)
        && elevation == dimension_aligned->elevation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.elevation [BD] %g != %g", dimension_aligned->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "elevation", &elevation, 0)
        && elevation == dimension_aligned->elevation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.elevation [BD] set+1 %g != %g", dimension_aligned->elevation, elevation);
    dimension_aligned->elevation--;

  }
  {
    BITCODE_BD ext_line_rotation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "ext_line_rotation", &ext_line_rotation, NULL)
        && ext_line_rotation == dimension_aligned->ext_line_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.ext_line_rotation [BD] %g != %g", dimension_aligned->ext_line_rotation, ext_line_rotation);
    ext_line_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "ext_line_rotation", &ext_line_rotation, 0)
        && ext_line_rotation == dimension_aligned->ext_line_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.ext_line_rotation [BD] set+1 %g != %g", dimension_aligned->ext_line_rotation, ext_line_rotation);
    dimension_aligned->ext_line_rotation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_aligned->extrusion, sizeof (dimension_aligned->extrusion)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flag", &flag, NULL)
        && flag == dimension_aligned->flag)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag [RC] %u != %u", dimension_aligned->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flag", &flag, 0)
        && flag == dimension_aligned->flag)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag [RC] set+1 %u != %u", dimension_aligned->flag, flag);
    dimension_aligned->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flag1", &flag1, NULL)
        && flag1 == dimension_aligned->flag1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag1 [RC] %u != %u", dimension_aligned->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flag1", &flag1, 0)
        && flag1 == dimension_aligned->flag1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag1 [RC] set+1 %u != %u", dimension_aligned->flag1, flag1);
    dimension_aligned->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_aligned->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_aligned->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow1, flip_arrow1);
    dimension_aligned->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_aligned->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_aligned->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow2, flip_arrow2);
    dimension_aligned->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_aligned->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.horiz_dir [BD] %g != %g", dimension_aligned->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_aligned->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.horiz_dir [BD] set+1 %g != %g", dimension_aligned->horiz_dir, horiz_dir);
    dimension_aligned->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_aligned->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.ins_rotation [BD] %g != %g", dimension_aligned->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_aligned->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.ins_rotation [BD] set+1 %g != %g", dimension_aligned->ins_rotation, ins_rotation);
    dimension_aligned->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_aligned->ins_scale, sizeof (dimension_aligned->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_aligned->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_factor [BD] %g != %g", dimension_aligned->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_aligned->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_factor [BD] set+1 %g != %g", dimension_aligned->lspace_factor, lspace_factor);
    dimension_aligned->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_aligned->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_style [BS] %hu != %hu", dimension_aligned->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_aligned->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_style [BS] set+1 %hu != %hu", dimension_aligned->lspace_style, lspace_style);
    dimension_aligned->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_aligned->parent, sizeof (dimension_aligned->parent)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_aligned->text_midpt, sizeof (dimension_aligned->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_aligned->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.text_rotation [BD] %g != %g", dimension_aligned->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_aligned->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.text_rotation [BD] set+1 %g != %g", dimension_aligned->text_rotation, text_rotation);
    dimension_aligned->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "unknown", &unknown, NULL)
        && unknown == dimension_aligned->unknown)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "unknown", &unknown, 0)
        && unknown == dimension_aligned->unknown)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->unknown, unknown);
    dimension_aligned->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_aligned->user_text)
           : !dimension_aligned->user_text)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.user_text [TV] '%s' <> '%s'", user_text, dimension_aligned->user_text);
  }
  return failed;
}
static int test_DIMENSION_ANG2LN (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ANG2LN *restrict dimension_ang2ln = obj->tio.entity->tio.DIMENSION_ANG2LN;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_ang2ln->_13_pt, sizeof (dimension_ang2ln->_13_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN._13_pt [3BD]");
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_ang2ln->_14_pt, sizeof (dimension_ang2ln->_14_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN._14_pt [3BD]");
  }
  {
    BITCODE_2RD _16_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "_16_pt", &_16_pt, NULL)
        && !memcmp (&_16_pt, &dimension_ang2ln->_16_pt, sizeof (dimension_ang2ln->_16_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN._16_pt [2RD]");
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ang2ln->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.act_measurement [BD] %g != %g", dimension_ang2ln->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_ang2ln->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.act_measurement [BD] set+1 %g != %g", dimension_ang2ln->act_measurement, act_measurement);
    dimension_ang2ln->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "attachment", &attachment, NULL)
        && attachment == dimension_ang2ln->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.attachment [BS] %hu != %hu", dimension_ang2ln->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "attachment", &attachment, 0)
        && attachment == dimension_ang2ln->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.attachment [BS] set+1 %hu != %hu", dimension_ang2ln->attachment, attachment);
    dimension_ang2ln->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "block", &block, NULL)
        && !memcmp (&block, &dimension_ang2ln->block, sizeof (dimension_ang2ln->block)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_ang2ln->blockname)
           : !dimension_ang2ln->blockname)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.blockname [TV] '%s' <> '%s'", blockname, dimension_ang2ln->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "class_version", &class_version, NULL)
        && class_version == dimension_ang2ln->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.class_version [RC] %u != %u", dimension_ang2ln->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "class_version", &class_version, 0)
        && class_version == dimension_ang2ln->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.class_version [RC] set+1 %u != %u", dimension_ang2ln->class_version, class_version);
    dimension_ang2ln->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ang2ln->clone_ins_pt, sizeof (dimension_ang2ln->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ang2ln->def_pt, sizeof (dimension_ang2ln->def_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ang2ln->dimstyle, sizeof (dimension_ang2ln->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "elevation", &elevation, NULL)
        && elevation == dimension_ang2ln->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.elevation [BD] %g != %g", dimension_ang2ln->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "elevation", &elevation, 0)
        && elevation == dimension_ang2ln->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.elevation [BD] set+1 %g != %g", dimension_ang2ln->elevation, elevation);
    dimension_ang2ln->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ang2ln->extrusion, sizeof (dimension_ang2ln->extrusion)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_ang2ln->first_arc_pt, sizeof (dimension_ang2ln->first_arc_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag", &flag, NULL)
        && flag == dimension_ang2ln->flag)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag [RC] %u != %u", dimension_ang2ln->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag", &flag, 0)
        && flag == dimension_ang2ln->flag)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag [RC] set+1 %u != %u", dimension_ang2ln->flag, flag);
    dimension_ang2ln->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag1", &flag1, NULL)
        && flag1 == dimension_ang2ln->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag1 [RC] %u != %u", dimension_ang2ln->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag1", &flag1, 0)
        && flag1 == dimension_ang2ln->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag1 [RC] set+1 %u != %u", dimension_ang2ln->flag1, flag1);
    dimension_ang2ln->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ang2ln->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_ang2ln->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow1, flip_arrow1);
    dimension_ang2ln->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ang2ln->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_ang2ln->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow2, flip_arrow2);
    dimension_ang2ln->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ang2ln->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.horiz_dir [BD] %g != %g", dimension_ang2ln->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_ang2ln->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.horiz_dir [BD] set+1 %g != %g", dimension_ang2ln->horiz_dir, horiz_dir);
    dimension_ang2ln->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ang2ln->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.ins_rotation [BD] %g != %g", dimension_ang2ln->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_ang2ln->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.ins_rotation [BD] set+1 %g != %g", dimension_ang2ln->ins_rotation, ins_rotation);
    dimension_ang2ln->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ang2ln->ins_scale, sizeof (dimension_ang2ln->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ang2ln->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_factor [BD] %g != %g", dimension_ang2ln->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_ang2ln->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_factor [BD] set+1 %g != %g", dimension_ang2ln->lspace_factor, lspace_factor);
    dimension_ang2ln->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ang2ln->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_style [BS] %hu != %hu", dimension_ang2ln->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_ang2ln->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_style [BS] set+1 %hu != %hu", dimension_ang2ln->lspace_style, lspace_style);
    dimension_ang2ln->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ang2ln->parent, sizeof (dimension_ang2ln->parent)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ang2ln->text_midpt, sizeof (dimension_ang2ln->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ang2ln->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.text_rotation [BD] %g != %g", dimension_ang2ln->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_ang2ln->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.text_rotation [BD] set+1 %g != %g", dimension_ang2ln->text_rotation, text_rotation);
    dimension_ang2ln->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "unknown", &unknown, NULL)
        && unknown == dimension_ang2ln->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "unknown", &unknown, 0)
        && unknown == dimension_ang2ln->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->unknown, unknown);
    dimension_ang2ln->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_ang2ln->user_text)
           : !dimension_ang2ln->user_text)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.user_text [TV] '%s' <> '%s'", user_text, dimension_ang2ln->user_text);
  }
  return failed;
}
static int test_DIMENSION_ANG3PT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ANG3PT *restrict dimension_ang3pt = obj->tio.entity->tio.DIMENSION_ANG3PT;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_ang3pt->_13_pt, sizeof (dimension_ang3pt->_13_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT._13_pt [3BD]");
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_ang3pt->_14_pt, sizeof (dimension_ang3pt->_14_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT._14_pt [3BD]");
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ang3pt->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.act_measurement [BD] %g != %g", dimension_ang3pt->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_ang3pt->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.act_measurement [BD] set+1 %g != %g", dimension_ang3pt->act_measurement, act_measurement);
    dimension_ang3pt->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "attachment", &attachment, NULL)
        && attachment == dimension_ang3pt->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.attachment [BS] %hu != %hu", dimension_ang3pt->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "attachment", &attachment, 0)
        && attachment == dimension_ang3pt->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.attachment [BS] set+1 %hu != %hu", dimension_ang3pt->attachment, attachment);
    dimension_ang3pt->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "block", &block, NULL)
        && !memcmp (&block, &dimension_ang3pt->block, sizeof (dimension_ang3pt->block)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_ang3pt->blockname)
           : !dimension_ang3pt->blockname)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.blockname [TV] '%s' <> '%s'", blockname, dimension_ang3pt->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "class_version", &class_version, NULL)
        && class_version == dimension_ang3pt->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.class_version [RC] %u != %u", dimension_ang3pt->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "class_version", &class_version, 0)
        && class_version == dimension_ang3pt->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.class_version [RC] set+1 %u != %u", dimension_ang3pt->class_version, class_version);
    dimension_ang3pt->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ang3pt->clone_ins_pt, sizeof (dimension_ang3pt->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ang3pt->def_pt, sizeof (dimension_ang3pt->def_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ang3pt->dimstyle, sizeof (dimension_ang3pt->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "elevation", &elevation, NULL)
        && elevation == dimension_ang3pt->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.elevation [BD] %g != %g", dimension_ang3pt->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "elevation", &elevation, 0)
        && elevation == dimension_ang3pt->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.elevation [BD] set+1 %g != %g", dimension_ang3pt->elevation, elevation);
    dimension_ang3pt->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ang3pt->extrusion, sizeof (dimension_ang3pt->extrusion)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_ang3pt->first_arc_pt, sizeof (dimension_ang3pt->first_arc_pt)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag", &flag, NULL)
        && flag == dimension_ang3pt->flag)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag [RC] %u != %u", dimension_ang3pt->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag", &flag, 0)
        && flag == dimension_ang3pt->flag)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag [RC] set+1 %u != %u", dimension_ang3pt->flag, flag);
    dimension_ang3pt->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag1", &flag1, NULL)
        && flag1 == dimension_ang3pt->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag1 [RC] %u != %u", dimension_ang3pt->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag1", &flag1, 0)
        && flag1 == dimension_ang3pt->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag1 [RC] set+1 %u != %u", dimension_ang3pt->flag1, flag1);
    dimension_ang3pt->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ang3pt->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_ang3pt->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow1, flip_arrow1);
    dimension_ang3pt->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ang3pt->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_ang3pt->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow2, flip_arrow2);
    dimension_ang3pt->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ang3pt->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.horiz_dir [BD] %g != %g", dimension_ang3pt->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_ang3pt->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.horiz_dir [BD] set+1 %g != %g", dimension_ang3pt->horiz_dir, horiz_dir);
    dimension_ang3pt->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ang3pt->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.ins_rotation [BD] %g != %g", dimension_ang3pt->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_ang3pt->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.ins_rotation [BD] set+1 %g != %g", dimension_ang3pt->ins_rotation, ins_rotation);
    dimension_ang3pt->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ang3pt->ins_scale, sizeof (dimension_ang3pt->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ang3pt->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_factor [BD] %g != %g", dimension_ang3pt->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_ang3pt->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_factor [BD] set+1 %g != %g", dimension_ang3pt->lspace_factor, lspace_factor);
    dimension_ang3pt->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ang3pt->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_style [BS] %hu != %hu", dimension_ang3pt->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_ang3pt->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_style [BS] set+1 %hu != %hu", dimension_ang3pt->lspace_style, lspace_style);
    dimension_ang3pt->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ang3pt->parent, sizeof (dimension_ang3pt->parent)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ang3pt->text_midpt, sizeof (dimension_ang3pt->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ang3pt->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.text_rotation [BD] %g != %g", dimension_ang3pt->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_ang3pt->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.text_rotation [BD] set+1 %g != %g", dimension_ang3pt->text_rotation, text_rotation);
    dimension_ang3pt->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "unknown", &unknown, NULL)
        && unknown == dimension_ang3pt->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "unknown", &unknown, 0)
        && unknown == dimension_ang3pt->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->unknown, unknown);
    dimension_ang3pt->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_ang3pt->user_text)
           : !dimension_ang3pt->user_text)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.user_text [TV] '%s' <> '%s'", user_text, dimension_ang3pt->user_text);
  }
  return failed;
}
static int test_DIMENSION_DIAMETER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_DIAMETER *restrict dimension_diameter = obj->tio.entity->tio.DIMENSION_DIAMETER;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_diameter->act_measurement)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.act_measurement [BD] %g != %g", dimension_diameter->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_diameter->act_measurement)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.act_measurement [BD] set+1 %g != %g", dimension_diameter->act_measurement, act_measurement);
    dimension_diameter->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "attachment", &attachment, NULL)
        && attachment == dimension_diameter->attachment)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.attachment [BS] %hu != %hu", dimension_diameter->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "attachment", &attachment, 0)
        && attachment == dimension_diameter->attachment)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.attachment [BS] set+1 %hu != %hu", dimension_diameter->attachment, attachment);
    dimension_diameter->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "block", &block, NULL)
        && !memcmp (&block, &dimension_diameter->block, sizeof (dimension_diameter->block)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_diameter->blockname)
           : !dimension_diameter->blockname)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.blockname [TV] '%s' <> '%s'", blockname, dimension_diameter->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "class_version", &class_version, NULL)
        && class_version == dimension_diameter->class_version)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.class_version [RC] %u != %u", dimension_diameter->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "class_version", &class_version, 0)
        && class_version == dimension_diameter->class_version)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.class_version [RC] set+1 %u != %u", dimension_diameter->class_version, class_version);
    dimension_diameter->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_diameter->clone_ins_pt, sizeof (dimension_diameter->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_diameter->def_pt, sizeof (dimension_diameter->def_pt)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_diameter->dimstyle, sizeof (dimension_diameter->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "elevation", &elevation, NULL)
        && elevation == dimension_diameter->elevation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.elevation [BD] %g != %g", dimension_diameter->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "elevation", &elevation, 0)
        && elevation == dimension_diameter->elevation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.elevation [BD] set+1 %g != %g", dimension_diameter->elevation, elevation);
    dimension_diameter->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_diameter->extrusion, sizeof (dimension_diameter->extrusion)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_diameter->first_arc_pt, sizeof (dimension_diameter->first_arc_pt)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flag", &flag, NULL)
        && flag == dimension_diameter->flag)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag [RC] %u != %u", dimension_diameter->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flag", &flag, 0)
        && flag == dimension_diameter->flag)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag [RC] set+1 %u != %u", dimension_diameter->flag, flag);
    dimension_diameter->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flag1", &flag1, NULL)
        && flag1 == dimension_diameter->flag1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag1 [RC] %u != %u", dimension_diameter->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flag1", &flag1, 0)
        && flag1 == dimension_diameter->flag1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag1 [RC] set+1 %u != %u", dimension_diameter->flag1, flag1);
    dimension_diameter->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_diameter->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_diameter->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow1, flip_arrow1);
    dimension_diameter->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_diameter->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_diameter->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow2, flip_arrow2);
    dimension_diameter->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_diameter->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.horiz_dir [BD] %g != %g", dimension_diameter->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_diameter->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.horiz_dir [BD] set+1 %g != %g", dimension_diameter->horiz_dir, horiz_dir);
    dimension_diameter->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_diameter->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.ins_rotation [BD] %g != %g", dimension_diameter->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_diameter->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.ins_rotation [BD] set+1 %g != %g", dimension_diameter->ins_rotation, ins_rotation);
    dimension_diameter->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_diameter->ins_scale, sizeof (dimension_diameter->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.ins_scale [3BD]");
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "leader_len", &leader_len, NULL)
        && leader_len == dimension_diameter->leader_len)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.leader_len [BD] %g != %g", dimension_diameter->leader_len, leader_len);
    leader_len++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "leader_len", &leader_len, 0)
        && leader_len == dimension_diameter->leader_len)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.leader_len [BD] set+1 %g != %g", dimension_diameter->leader_len, leader_len);
    dimension_diameter->leader_len--;

  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_diameter->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_factor [BD] %g != %g", dimension_diameter->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_diameter->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_factor [BD] set+1 %g != %g", dimension_diameter->lspace_factor, lspace_factor);
    dimension_diameter->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_diameter->lspace_style)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_style [BS] %hu != %hu", dimension_diameter->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_diameter->lspace_style)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_style [BS] set+1 %hu != %hu", dimension_diameter->lspace_style, lspace_style);
    dimension_diameter->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_diameter->parent, sizeof (dimension_diameter->parent)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_diameter->text_midpt, sizeof (dimension_diameter->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_diameter->text_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.text_rotation [BD] %g != %g", dimension_diameter->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_diameter->text_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.text_rotation [BD] set+1 %g != %g", dimension_diameter->text_rotation, text_rotation);
    dimension_diameter->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "unknown", &unknown, NULL)
        && unknown == dimension_diameter->unknown)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "unknown", &unknown, 0)
        && unknown == dimension_diameter->unknown)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->unknown, unknown);
    dimension_diameter->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_diameter->user_text)
           : !dimension_diameter->user_text)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.user_text [TV] '%s' <> '%s'", user_text, dimension_diameter->user_text);
  }
  return failed;
}
static int test_DIMENSION_LINEAR (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_LINEAR *restrict dimension_linear = obj->tio.entity->tio.DIMENSION_LINEAR;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_linear->_13_pt, sizeof (dimension_linear->_13_pt)))
        pass ();
    else
        fail ("DIMENSION_LINEAR._13_pt [3BD]");
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_linear->_14_pt, sizeof (dimension_linear->_14_pt)))
        pass ();
    else
        fail ("DIMENSION_LINEAR._14_pt [3BD]");
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_linear->act_measurement)
      pass ();
    else
      fail ("DIMENSION_LINEAR.act_measurement [BD] %g != %g", dimension_linear->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_linear->act_measurement)
      pass ();
    else
      fail ("DIMENSION_LINEAR.act_measurement [BD] set+1 %g != %g", dimension_linear->act_measurement, act_measurement);
    dimension_linear->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "attachment", &attachment, NULL)
        && attachment == dimension_linear->attachment)
      pass ();
    else
      fail ("DIMENSION_LINEAR.attachment [BS] %hu != %hu", dimension_linear->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "attachment", &attachment, 0)
        && attachment == dimension_linear->attachment)
      pass ();
    else
      fail ("DIMENSION_LINEAR.attachment [BS] set+1 %hu != %hu", dimension_linear->attachment, attachment);
    dimension_linear->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "block", &block, NULL)
        && !memcmp (&block, &dimension_linear->block, sizeof (dimension_linear->block)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_linear->blockname)
           : !dimension_linear->blockname)
      pass ();
    else
      fail ("DIMENSION_LINEAR.blockname [TV] '%s' <> '%s'", blockname, dimension_linear->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "class_version", &class_version, NULL)
        && class_version == dimension_linear->class_version)
      pass ();
    else
      fail ("DIMENSION_LINEAR.class_version [RC] %u != %u", dimension_linear->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "class_version", &class_version, 0)
        && class_version == dimension_linear->class_version)
      pass ();
    else
      fail ("DIMENSION_LINEAR.class_version [RC] set+1 %u != %u", dimension_linear->class_version, class_version);
    dimension_linear->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_linear->clone_ins_pt, sizeof (dimension_linear->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_linear->def_pt, sizeof (dimension_linear->def_pt)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.def_pt [3BD]");
  }
  {
    BITCODE_BD dim_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "dim_rotation", &dim_rotation, NULL)
        && dim_rotation == dimension_linear->dim_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.dim_rotation [BD] %g != %g", dimension_linear->dim_rotation, dim_rotation);
    dim_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "dim_rotation", &dim_rotation, 0)
        && dim_rotation == dimension_linear->dim_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.dim_rotation [BD] set+1 %g != %g", dimension_linear->dim_rotation, dim_rotation);
    dimension_linear->dim_rotation--;

  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_linear->dimstyle, sizeof (dimension_linear->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "elevation", &elevation, NULL)
        && elevation == dimension_linear->elevation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.elevation [BD] %g != %g", dimension_linear->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "elevation", &elevation, 0)
        && elevation == dimension_linear->elevation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.elevation [BD] set+1 %g != %g", dimension_linear->elevation, elevation);
    dimension_linear->elevation--;

  }
  {
    BITCODE_BD ext_line_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "ext_line_rotation", &ext_line_rotation, NULL)
        && ext_line_rotation == dimension_linear->ext_line_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.ext_line_rotation [BD] %g != %g", dimension_linear->ext_line_rotation, ext_line_rotation);
    ext_line_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "ext_line_rotation", &ext_line_rotation, 0)
        && ext_line_rotation == dimension_linear->ext_line_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.ext_line_rotation [BD] set+1 %g != %g", dimension_linear->ext_line_rotation, ext_line_rotation);
    dimension_linear->ext_line_rotation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_linear->extrusion, sizeof (dimension_linear->extrusion)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flag", &flag, NULL)
        && flag == dimension_linear->flag)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag [RC] %u != %u", dimension_linear->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flag", &flag, 0)
        && flag == dimension_linear->flag)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag [RC] set+1 %u != %u", dimension_linear->flag, flag);
    dimension_linear->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flag1", &flag1, NULL)
        && flag1 == dimension_linear->flag1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag1 [RC] %u != %u", dimension_linear->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flag1", &flag1, 0)
        && flag1 == dimension_linear->flag1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag1 [RC] set+1 %u != %u", dimension_linear->flag1, flag1);
    dimension_linear->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_linear->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_linear->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow1, flip_arrow1);
    dimension_linear->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_linear->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_linear->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow2, flip_arrow2);
    dimension_linear->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_linear->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_LINEAR.horiz_dir [BD] %g != %g", dimension_linear->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_linear->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_LINEAR.horiz_dir [BD] set+1 %g != %g", dimension_linear->horiz_dir, horiz_dir);
    dimension_linear->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_linear->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.ins_rotation [BD] %g != %g", dimension_linear->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_linear->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.ins_rotation [BD] set+1 %g != %g", dimension_linear->ins_rotation, ins_rotation);
    dimension_linear->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_linear->ins_scale, sizeof (dimension_linear->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_linear->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_factor [BD] %g != %g", dimension_linear->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_linear->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_factor [BD] set+1 %g != %g", dimension_linear->lspace_factor, lspace_factor);
    dimension_linear->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_linear->lspace_style)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_style [BS] %hu != %hu", dimension_linear->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_linear->lspace_style)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_style [BS] set+1 %hu != %hu", dimension_linear->lspace_style, lspace_style);
    dimension_linear->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_linear->parent, sizeof (dimension_linear->parent)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_linear->text_midpt, sizeof (dimension_linear->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_linear->text_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.text_rotation [BD] %g != %g", dimension_linear->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_linear->text_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.text_rotation [BD] set+1 %g != %g", dimension_linear->text_rotation, text_rotation);
    dimension_linear->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "unknown", &unknown, NULL)
        && unknown == dimension_linear->unknown)
      pass ();
    else
      fail ("DIMENSION_LINEAR.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "unknown", &unknown, 0)
        && unknown == dimension_linear->unknown)
      pass ();
    else
      fail ("DIMENSION_LINEAR.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->unknown, unknown);
    dimension_linear->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_linear->user_text)
           : !dimension_linear->user_text)
      pass ();
    else
      fail ("DIMENSION_LINEAR.user_text [TV] '%s' <> '%s'", user_text, dimension_linear->user_text);
  }
  return failed;
}
static int test_DIMENSION_ORDINATE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ORDINATE *restrict dimension_ordinate = obj->tio.entity->tio.DIMENSION_ORDINATE;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ordinate->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.act_measurement [BD] %g != %g", dimension_ordinate->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_ordinate->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.act_measurement [BD] set+1 %g != %g", dimension_ordinate->act_measurement, act_measurement);
    dimension_ordinate->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "attachment", &attachment, NULL)
        && attachment == dimension_ordinate->attachment)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.attachment [BS] %hu != %hu", dimension_ordinate->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "attachment", &attachment, 0)
        && attachment == dimension_ordinate->attachment)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.attachment [BS] set+1 %hu != %hu", dimension_ordinate->attachment, attachment);
    dimension_ordinate->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "block", &block, NULL)
        && !memcmp (&block, &dimension_ordinate->block, sizeof (dimension_ordinate->block)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_ordinate->blockname)
           : !dimension_ordinate->blockname)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.blockname [TV] '%s' <> '%s'", blockname, dimension_ordinate->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "class_version", &class_version, NULL)
        && class_version == dimension_ordinate->class_version)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.class_version [RC] %u != %u", dimension_ordinate->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "class_version", &class_version, 0)
        && class_version == dimension_ordinate->class_version)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.class_version [RC] set+1 %u != %u", dimension_ordinate->class_version, class_version);
    dimension_ordinate->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ordinate->clone_ins_pt, sizeof (dimension_ordinate->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ordinate->def_pt, sizeof (dimension_ordinate->def_pt)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ordinate->dimstyle, sizeof (dimension_ordinate->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "elevation", &elevation, NULL)
        && elevation == dimension_ordinate->elevation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.elevation [BD] %g != %g", dimension_ordinate->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "elevation", &elevation, 0)
        && elevation == dimension_ordinate->elevation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.elevation [BD] set+1 %g != %g", dimension_ordinate->elevation, elevation);
    dimension_ordinate->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ordinate->extrusion, sizeof (dimension_ordinate->extrusion)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.extrusion [BE]");
  }
  {
    BITCODE_3BD feature_location_pt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "feature_location_pt", &feature_location_pt, NULL)
        && !memcmp (&feature_location_pt, &dimension_ordinate->feature_location_pt, sizeof (dimension_ordinate->feature_location_pt)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.feature_location_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag", &flag, NULL)
        && flag == dimension_ordinate->flag)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag [RC] %u != %u", dimension_ordinate->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag", &flag, 0)
        && flag == dimension_ordinate->flag)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag [RC] set+1 %u != %u", dimension_ordinate->flag, flag);
    dimension_ordinate->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag1", &flag1, NULL)
        && flag1 == dimension_ordinate->flag1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag1 [RC] %u != %u", dimension_ordinate->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag1", &flag1, 0)
        && flag1 == dimension_ordinate->flag1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag1 [RC] set+1 %u != %u", dimension_ordinate->flag1, flag1);
    dimension_ordinate->flag1--;

  }
  {
    BITCODE_RC flag2;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag2", &flag2, NULL)
        && flag2 == dimension_ordinate->flag2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag2 [RC] %u != %u", dimension_ordinate->flag2, flag2);
    flag2++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag2", &flag2, 0)
        && flag2 == dimension_ordinate->flag2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag2 [RC] set+1 %u != %u", dimension_ordinate->flag2, flag2);
    dimension_ordinate->flag2--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ordinate->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_ordinate->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow1, flip_arrow1);
    dimension_ordinate->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ordinate->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_ordinate->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow2, flip_arrow2);
    dimension_ordinate->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ordinate->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.horiz_dir [BD] %g != %g", dimension_ordinate->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_ordinate->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.horiz_dir [BD] set+1 %g != %g", dimension_ordinate->horiz_dir, horiz_dir);
    dimension_ordinate->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ordinate->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.ins_rotation [BD] %g != %g", dimension_ordinate->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_ordinate->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.ins_rotation [BD] set+1 %g != %g", dimension_ordinate->ins_rotation, ins_rotation);
    dimension_ordinate->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ordinate->ins_scale, sizeof (dimension_ordinate->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.ins_scale [3BD]");
  }
  {
    BITCODE_3BD leader_endpt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "leader_endpt", &leader_endpt, NULL)
        && !memcmp (&leader_endpt, &dimension_ordinate->leader_endpt, sizeof (dimension_ordinate->leader_endpt)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.leader_endpt [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ordinate->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_factor [BD] %g != %g", dimension_ordinate->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_ordinate->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_factor [BD] set+1 %g != %g", dimension_ordinate->lspace_factor, lspace_factor);
    dimension_ordinate->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ordinate->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_style [BS] %hu != %hu", dimension_ordinate->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_ordinate->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_style [BS] set+1 %hu != %hu", dimension_ordinate->lspace_style, lspace_style);
    dimension_ordinate->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ordinate->parent, sizeof (dimension_ordinate->parent)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ordinate->text_midpt, sizeof (dimension_ordinate->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ordinate->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.text_rotation [BD] %g != %g", dimension_ordinate->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_ordinate->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.text_rotation [BD] set+1 %g != %g", dimension_ordinate->text_rotation, text_rotation);
    dimension_ordinate->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "unknown", &unknown, NULL)
        && unknown == dimension_ordinate->unknown)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "unknown", &unknown, 0)
        && unknown == dimension_ordinate->unknown)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->unknown, unknown);
    dimension_ordinate->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_ordinate->user_text)
           : !dimension_ordinate->user_text)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.user_text [TV] '%s' <> '%s'", user_text, dimension_ordinate->user_text);
  }
  return failed;
}
static int test_DIMENSION_RADIUS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_RADIUS *restrict dimension_radius = obj->tio.entity->tio.DIMENSION_RADIUS;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_radius->act_measurement)
      pass ();
    else
      fail ("DIMENSION_RADIUS.act_measurement [BD] %g != %g", dimension_radius->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_radius->act_measurement)
      pass ();
    else
      fail ("DIMENSION_RADIUS.act_measurement [BD] set+1 %g != %g", dimension_radius->act_measurement, act_measurement);
    dimension_radius->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "attachment", &attachment, NULL)
        && attachment == dimension_radius->attachment)
      pass ();
    else
      fail ("DIMENSION_RADIUS.attachment [BS] %hu != %hu", dimension_radius->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "attachment", &attachment, 0)
        && attachment == dimension_radius->attachment)
      pass ();
    else
      fail ("DIMENSION_RADIUS.attachment [BS] set+1 %hu != %hu", dimension_radius->attachment, attachment);
    dimension_radius->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "block", &block, NULL)
        && !memcmp (&block, &dimension_radius->block, sizeof (dimension_radius->block)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_radius->blockname)
           : !dimension_radius->blockname)
      pass ();
    else
      fail ("DIMENSION_RADIUS.blockname [TV] '%s' <> '%s'", blockname, dimension_radius->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "class_version", &class_version, NULL)
        && class_version == dimension_radius->class_version)
      pass ();
    else
      fail ("DIMENSION_RADIUS.class_version [RC] %u != %u", dimension_radius->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "class_version", &class_version, 0)
        && class_version == dimension_radius->class_version)
      pass ();
    else
      fail ("DIMENSION_RADIUS.class_version [RC] set+1 %u != %u", dimension_radius->class_version, class_version);
    dimension_radius->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_radius->clone_ins_pt, sizeof (dimension_radius->clone_ins_pt)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_radius->def_pt, sizeof (dimension_radius->def_pt)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_radius->dimstyle, sizeof (dimension_radius->dimstyle)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "elevation", &elevation, NULL)
        && elevation == dimension_radius->elevation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.elevation [BD] %g != %g", dimension_radius->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "elevation", &elevation, 0)
        && elevation == dimension_radius->elevation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.elevation [BD] set+1 %g != %g", dimension_radius->elevation, elevation);
    dimension_radius->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_radius->extrusion, sizeof (dimension_radius->extrusion)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_radius->first_arc_pt, sizeof (dimension_radius->first_arc_pt)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flag", &flag, NULL)
        && flag == dimension_radius->flag)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag [RC] %u != %u", dimension_radius->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flag", &flag, 0)
        && flag == dimension_radius->flag)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag [RC] set+1 %u != %u", dimension_radius->flag, flag);
    dimension_radius->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flag1", &flag1, NULL)
        && flag1 == dimension_radius->flag1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag1 [RC] %u != %u", dimension_radius->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flag1", &flag1, 0)
        && flag1 == dimension_radius->flag1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag1 [RC] set+1 %u != %u", dimension_radius->flag1, flag1);
    dimension_radius->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_radius->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_radius->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow1, flip_arrow1);
    dimension_radius->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_radius->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_radius->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow2, flip_arrow2);
    dimension_radius->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_radius->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_RADIUS.horiz_dir [BD] %g != %g", dimension_radius->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_radius->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_RADIUS.horiz_dir [BD] set+1 %g != %g", dimension_radius->horiz_dir, horiz_dir);
    dimension_radius->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_radius->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.ins_rotation [BD] %g != %g", dimension_radius->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_radius->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.ins_rotation [BD] set+1 %g != %g", dimension_radius->ins_rotation, ins_rotation);
    dimension_radius->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_radius->ins_scale, sizeof (dimension_radius->ins_scale)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.ins_scale [3BD]");
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "leader_len", &leader_len, NULL)
        && leader_len == dimension_radius->leader_len)
      pass ();
    else
      fail ("DIMENSION_RADIUS.leader_len [BD] %g != %g", dimension_radius->leader_len, leader_len);
    leader_len++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "leader_len", &leader_len, 0)
        && leader_len == dimension_radius->leader_len)
      pass ();
    else
      fail ("DIMENSION_RADIUS.leader_len [BD] set+1 %g != %g", dimension_radius->leader_len, leader_len);
    dimension_radius->leader_len--;

  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_radius->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_factor [BD] %g != %g", dimension_radius->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_radius->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_factor [BD] set+1 %g != %g", dimension_radius->lspace_factor, lspace_factor);
    dimension_radius->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_radius->lspace_style)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_style [BS] %hu != %hu", dimension_radius->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_radius->lspace_style)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_style [BS] set+1 %hu != %hu", dimension_radius->lspace_style, lspace_style);
    dimension_radius->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_radius->parent, sizeof (dimension_radius->parent)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_radius->text_midpt, sizeof (dimension_radius->text_midpt)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_radius->text_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.text_rotation [BD] %g != %g", dimension_radius->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_radius->text_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.text_rotation [BD] set+1 %g != %g", dimension_radius->text_rotation, text_rotation);
    dimension_radius->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "unknown", &unknown, NULL)
        && unknown == dimension_radius->unknown)
      pass ();
    else
      fail ("DIMENSION_RADIUS.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "unknown", &unknown, 0)
        && unknown == dimension_radius->unknown)
      pass ();
    else
      fail ("DIMENSION_RADIUS.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->unknown, unknown);
    dimension_radius->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_radius->user_text)
           : !dimension_radius->user_text)
      pass ();
    else
      fail ("DIMENSION_RADIUS.user_text [TV] '%s' <> '%s'", user_text, dimension_radius->user_text);
  }
  return failed;
}
static int test_ELLIPSE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ELLIPSE *restrict ellipse = obj->tio.entity->tio.ELLIPSE;
  {
    BITCODE_BD axis_ratio;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "axis_ratio", &axis_ratio, NULL)
        && axis_ratio == ellipse->axis_ratio)
      pass ();
    else
      fail ("ELLIPSE.axis_ratio [BD] %g != %g", ellipse->axis_ratio, axis_ratio);
    axis_ratio++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "axis_ratio", &axis_ratio, 0)
        && axis_ratio == ellipse->axis_ratio)
      pass ();
    else
      fail ("ELLIPSE.axis_ratio [BD] set+1 %g != %g", ellipse->axis_ratio, axis_ratio);
    ellipse->axis_ratio--;

  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "center", &center, NULL)
        && !memcmp (&center, &ellipse->center, sizeof (ellipse->center)))
        pass ();
    else
        fail ("ELLIPSE.center [3BD]");
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "end_angle", &end_angle, NULL)
        && end_angle == ellipse->end_angle)
      pass ();
    else
      fail ("ELLIPSE.end_angle [BD] %g != %g", ellipse->end_angle, end_angle);
    end_angle++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "end_angle", &end_angle, 0)
        && end_angle == ellipse->end_angle)
      pass ();
    else
      fail ("ELLIPSE.end_angle [BD] set+1 %g != %g", ellipse->end_angle, end_angle);
    ellipse->end_angle--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &ellipse->extrusion, sizeof (ellipse->extrusion)))
        pass ();
    else
        fail ("ELLIPSE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "parent", &parent, NULL)
        && !memcmp (&parent, &ellipse->parent, sizeof (ellipse->parent)))
        pass ();
    else
        fail ("ELLIPSE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD sm_axis;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "sm_axis", &sm_axis, NULL)
        && !memcmp (&sm_axis, &ellipse->sm_axis, sizeof (ellipse->sm_axis)))
        pass ();
    else
        fail ("ELLIPSE.sm_axis [3BD]");
  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "start_angle", &start_angle, NULL)
        && start_angle == ellipse->start_angle)
      pass ();
    else
      fail ("ELLIPSE.start_angle [BD] %g != %g", ellipse->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "start_angle", &start_angle, 0)
        && start_angle == ellipse->start_angle)
      pass ();
    else
      fail ("ELLIPSE.start_angle [BD] set+1 %g != %g", ellipse->start_angle, start_angle);
    ellipse->start_angle--;

  }
  return failed;
}
static int test_ENDBLK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ENDBLK *restrict endblk = obj->tio.entity->tio.ENDBLK;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (endblk, "ENDBLK", "parent", &parent, NULL)
        && !memcmp (&parent, &endblk->parent, sizeof (endblk->parent)))
        pass ();
    else
        fail ("ENDBLK.parent [struct _dwg_object_entity*]");
  }
  return failed;
}
static int test_EXTRUDEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_EXTRUDEDSURFACE *restrict extrudedsurface = obj->tio.entity->tio.EXTRUDEDSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)extrudedsurface->acis_data)
           : !extrudedsurface->acis_data)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, extrudedsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == extrudedsurface->acis_empty)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == extrudedsurface->acis_empty)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty, acis_empty);
    extrudedsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == extrudedsurface->acis_empty2)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == extrudedsurface->acis_empty2)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty2, acis_empty2);
    extrudedsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == extrudedsurface->acis_empty_bit)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == extrudedsurface->acis_empty_bit)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty_bit, acis_empty_bit);
    extrudedsurface->acis_empty_bit--;

  }
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "align_angle", &align_angle, NULL)
        && align_angle == extrudedsurface->align_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_angle [BD] %g != %g", extrudedsurface->align_angle, align_angle);
    align_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "align_angle", &align_angle, 0)
        && align_angle == extrudedsurface->align_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_angle [BD] set+1 %g != %g", extrudedsurface->align_angle, align_angle);
    extrudedsurface->align_angle--;

  }
  {
    BITCODE_B align_start;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "align_start", &align_start, NULL)
        && align_start == extrudedsurface->align_start)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_start [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->align_start, align_start);
    align_start++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "align_start", &align_start, 0)
        && align_start == extrudedsurface->align_start)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->align_start, align_start);
    extrudedsurface->align_start--;

  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "bank", &bank, NULL)
        && bank == extrudedsurface->bank)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.bank [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->bank, bank);
    bank++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "bank", &bank, 0)
        && bank == extrudedsurface->bank)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->bank, bank);
    extrudedsurface->bank--;

  }
  {
    BITCODE_B base_point_set;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "base_point_set", &base_point_set, NULL)
        && base_point_set == extrudedsurface->base_point_set)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.base_point_set [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->base_point_set, base_point_set);
    base_point_set++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "base_point_set", &base_point_set, 0)
        && base_point_set == extrudedsurface->base_point_set)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.base_point_set [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->base_point_set, base_point_set);
    extrudedsurface->base_point_set--;

  }
  {
    BITCODE_TF bindata;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "bindata", &bindata, NULL)
        && !memcmp (&bindata, &extrudedsurface->bindata, sizeof (extrudedsurface->bindata)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.bindata [TF]");
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &extrudedsurface->block_size, sizeof (extrudedsurface->block_size)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "class_version", &class_version, NULL)
        && class_version == extrudedsurface->class_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.class_version [BL] %u != %u", extrudedsurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "class_version", &class_version, 0)
        && class_version == extrudedsurface->class_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.class_version [BL] set+1 %u != %u", extrudedsurface->class_version, class_version);
    extrudedsurface->class_version--;

  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == extrudedsurface->draft_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_angle [BD] %g != %g", extrudedsurface->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_angle", &draft_angle, 0)
        && draft_angle == extrudedsurface->draft_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_angle [BD] set+1 %g != %g", extrudedsurface->draft_angle, draft_angle);
    extrudedsurface->draft_angle--;

  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == extrudedsurface->draft_end_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_end_distance [BD] %g != %g", extrudedsurface->draft_end_distance, draft_end_distance);
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_end_distance", &draft_end_distance, 0)
        && draft_end_distance == extrudedsurface->draft_end_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_end_distance [BD] set+1 %g != %g", extrudedsurface->draft_end_distance, draft_end_distance);
    extrudedsurface->draft_end_distance--;

  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == extrudedsurface->draft_start_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_start_distance [BD] %g != %g", extrudedsurface->draft_start_distance, draft_start_distance);
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_start_distance", &draft_start_distance, 0)
        && draft_start_distance == extrudedsurface->draft_start_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_start_distance [BD] set+1 %g != %g", extrudedsurface->draft_start_distance, draft_start_distance);
    extrudedsurface->draft_start_distance--;

  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &extrudedsurface->encr_sat_data, sizeof (extrudedsurface->encr_sat_data)))
      pass ();
    else
      fail ("EXTRUDEDSURFACE.encr_sat_data [char **]");
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &extrudedsurface->extra_acis_data, sizeof (extrudedsurface->extra_acis_data)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "height", &height, NULL)
        && height == extrudedsurface->height)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.height [BD] %g != %g", extrudedsurface->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "height", &height, 0)
        && height == extrudedsurface->height)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.height [BD] set+1 %g != %g", extrudedsurface->height, height);
    extrudedsurface->height--;

  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &extrudedsurface->history_id, sizeof (extrudedsurface->history_id)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == extrudedsurface->isoline_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == extrudedsurface->isoline_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->isoline_present, isoline_present);
    extrudedsurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == extrudedsurface->modeler_format_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.modeler_format_version [BS] %hu != %hu", extrudedsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == extrudedsurface->modeler_format_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", extrudedsurface->modeler_format_version, modeler_format_version);
    extrudedsurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == extrudedsurface->num_blocks)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_blocks [BL] %u != %u", extrudedsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == extrudedsurface->num_blocks)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_blocks [BL] set+1 %u != %u", extrudedsurface->num_blocks, num_blocks);
    extrudedsurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == extrudedsurface->num_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_isolines [BL] %u != %u", extrudedsurface->num_isolines, num_isolines);
    num_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_isolines", &num_isolines, 0)
        && num_isolines == extrudedsurface->num_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_isolines [BL] set+1 %u != %u", extrudedsurface->num_isolines, num_isolines);
    extrudedsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == extrudedsurface->num_silhouettes)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_silhouettes [BL] %u != %u", extrudedsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == extrudedsurface->num_silhouettes)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_silhouettes [BL] set+1 %u != %u", extrudedsurface->num_silhouettes, num_silhouettes);
    extrudedsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == extrudedsurface->num_wires)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_wires [BL] %u != %u", extrudedsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &num_wires, 0)
        && num_wires == extrudedsurface->num_wires)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_wires [BL] set+1 %u != %u", extrudedsurface->num_wires, num_wires);
    extrudedsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &extrudedsurface->parent, sizeof (extrudedsurface->parent)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H path_entity;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity", &path_entity, NULL)
        && !memcmp (&path_entity, &extrudedsurface->path_entity, sizeof (extrudedsurface->path_entity)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.path_entity [H]");
  }
  {
    BITCODE_B path_entity_transform_computed;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, NULL)
        && path_entity_transform_computed == extrudedsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.path_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->path_entity_transform_computed, path_entity_transform_computed);
    path_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, 0)
        && path_entity_transform_computed == extrudedsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->path_entity_transform_computed, path_entity_transform_computed);
    extrudedsurface->path_entity_transform_computed--;

  }
  {
    BITCODE_BD* path_entity_transmatrix;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transmatrix", &path_entity_transmatrix, NULL)
        && !memcmp (&path_entity_transmatrix, &extrudedsurface->path_entity_transmatrix, sizeof (extrudedsurface->path_entity_transmatrix)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.path_entity_transmatrix [BD*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &extrudedsurface->point, sizeof (extrudedsurface->point)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "point_present", &point_present, NULL)
        && point_present == extrudedsurface->point_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "point_present", &point_present, 0)
        && point_present == extrudedsurface->point_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->point_present, point_present);
    extrudedsurface->point_present--;

  }
  {
    BITCODE_3BD reference_vector_for_controlling_twist;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "reference_vector_for_controlling_twist", &reference_vector_for_controlling_twist, NULL)
        && !memcmp (&reference_vector_for_controlling_twist, &extrudedsurface->reference_vector_for_controlling_twist, sizeof (extrudedsurface->reference_vector_for_controlling_twist)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.reference_vector_for_controlling_twist [3BD]");
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "scale_factor", &scale_factor, NULL)
        && scale_factor == extrudedsurface->scale_factor)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.scale_factor [BD] %g != %g", extrudedsurface->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "scale_factor", &scale_factor, 0)
        && scale_factor == extrudedsurface->scale_factor)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.scale_factor [BD] set+1 %g != %g", extrudedsurface->scale_factor, scale_factor);
    extrudedsurface->scale_factor--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == extrudedsurface->silhouettes)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BL size_bindata;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "size_bindata", &size_bindata, NULL)
        && size_bindata == extrudedsurface->size_bindata)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.size_bindata [BL] %u != %u", extrudedsurface->size_bindata, size_bindata);
    size_bindata++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "size_bindata", &size_bindata, 0)
        && size_bindata == extrudedsurface->size_bindata)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.size_bindata [BL] set+1 %u != %u", extrudedsurface->size_bindata, size_bindata);
    extrudedsurface->size_bindata--;

  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "solid", &solid, NULL)
        && solid == extrudedsurface->solid)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->solid, solid);
    solid++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "solid", &solid, 0)
        && solid == extrudedsurface->solid)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->solid, solid);
    extrudedsurface->solid--;

  }
  {
    BITCODE_BS sweep_alignment_flags;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, NULL)
        && sweep_alignment_flags == extrudedsurface->sweep_alignment_flags)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] %hu != %hu", extrudedsurface->sweep_alignment_flags, sweep_alignment_flags);
    sweep_alignment_flags++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, 0)
        && sweep_alignment_flags == extrudedsurface->sweep_alignment_flags)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] set+1 %hu != %hu", extrudedsurface->sweep_alignment_flags, sweep_alignment_flags);
    extrudedsurface->sweep_alignment_flags--;

  }
  {
    BITCODE_H sweep_entity;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity", &sweep_entity, NULL)
        && !memcmp (&sweep_entity, &extrudedsurface->sweep_entity, sizeof (extrudedsurface->sweep_entity)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_entity [H]");
  }
  {
    BITCODE_B sweep_entity_transform_computed;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, NULL)
        && sweep_entity_transform_computed == extrudedsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    sweep_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, 0)
        && sweep_entity_transform_computed == extrudedsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    extrudedsurface->sweep_entity_transform_computed--;

  }
  {
    BITCODE_BD* sweep_entity_transmatrix;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transmatrix", &sweep_entity_transmatrix, NULL)
        && !memcmp (&sweep_entity_transmatrix, &extrudedsurface->sweep_entity_transmatrix, sizeof (extrudedsurface->sweep_entity_transmatrix)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BD* sweep_transmatrix;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_transmatrix", &sweep_transmatrix, NULL)
        && !memcmp (&sweep_transmatrix, &extrudedsurface->sweep_transmatrix, sizeof (extrudedsurface->sweep_transmatrix)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_transmatrix [BD*]");
  }
  {
    BITCODE_3BD sweep_vector;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_vector", &sweep_vector, NULL)
        && !memcmp (&sweep_vector, &extrudedsurface->sweep_vector, sizeof (extrudedsurface->sweep_vector)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_vector [3BD]");
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == extrudedsurface->twist_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.twist_angle [BD] %g != %g", extrudedsurface->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "twist_angle", &twist_angle, 0)
        && twist_angle == extrudedsurface->twist_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.twist_angle [BD] set+1 %g != %g", extrudedsurface->twist_angle, twist_angle);
    extrudedsurface->twist_angle--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == extrudedsurface->u_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.u_isolines [BS] %hu != %hu", extrudedsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == extrudedsurface->u_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.u_isolines [BS] set+1 %hu != %hu", extrudedsurface->u_isolines, u_isolines);
    extrudedsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown", &unknown, NULL)
        && unknown == extrudedsurface->unknown)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown", &unknown, 0)
        && unknown == extrudedsurface->unknown)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->unknown, unknown);
    extrudedsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == extrudedsurface->unknown_2007)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.unknown_2007 [BL] %u != %u", extrudedsurface->unknown_2007, unknown_2007);
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown_2007", &unknown_2007, 0)
        && unknown_2007 == extrudedsurface->unknown_2007)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.unknown_2007 [BL] set+1 %u != %u", extrudedsurface->unknown_2007, unknown_2007);
    extrudedsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == extrudedsurface->v_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.v_isolines [BS] %hu != %hu", extrudedsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == extrudedsurface->v_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.v_isolines [BS] set+1 %hu != %hu", extrudedsurface->v_isolines, v_isolines);
    extrudedsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "version", &version, NULL)
        && version == extrudedsurface->version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.version [BS] %hu != %hu", extrudedsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "version", &version, 0)
        && version == extrudedsurface->version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.version [BS] set+1 %hu != %hu", extrudedsurface->version, version);
    extrudedsurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == extrudedsurface->wireframe_data_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == extrudedsurface->wireframe_data_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->wireframe_data_present, wireframe_data_present);
    extrudedsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "wires", &wires, NULL)
        && wires == extrudedsurface->wires)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  return failed;
}
static int test_GEOPOSITIONMARKER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_GEOPOSITIONMARKER *restrict geopositionmarker = obj->tio.entity->tio.GEOPOSITIONMARKER;
  {
    BITCODE_B enable_frame_text;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "enable_frame_text", &enable_frame_text, NULL)
        && enable_frame_text == geopositionmarker->enable_frame_text)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.enable_frame_text [B] " FORMAT_B " != " FORMAT_B "", geopositionmarker->enable_frame_text, enable_frame_text);
    enable_frame_text++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "enable_frame_text", &enable_frame_text, 0)
        && enable_frame_text == geopositionmarker->enable_frame_text)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.enable_frame_text [B] set+1 " FORMAT_B " != " FORMAT_B "", geopositionmarker->enable_frame_text, enable_frame_text);
    geopositionmarker->enable_frame_text--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &geopositionmarker->extrusion, sizeof (geopositionmarker->extrusion)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.extrusion [BE]");
  }
  {
    BITCODE_BD landing_gap;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "landing_gap", &landing_gap, NULL)
        && landing_gap == geopositionmarker->landing_gap)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.landing_gap [BD] %g != %g", geopositionmarker->landing_gap, landing_gap);
    landing_gap++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "landing_gap", &landing_gap, 0)
        && landing_gap == geopositionmarker->landing_gap)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.landing_gap [BD] set+1 %g != %g", geopositionmarker->landing_gap, landing_gap);
    geopositionmarker->landing_gap--;

  }
  {
    BITCODE_H mtext_handle;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext_handle", &mtext_handle, NULL)
        && !memcmp (&mtext_handle, &geopositionmarker->mtext_handle, sizeof (geopositionmarker->mtext_handle)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.mtext_handle [H]");
  }
  {
    BITCODE_B mtext_visible;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext_visible", &mtext_visible, NULL)
        && mtext_visible == geopositionmarker->mtext_visible)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.mtext_visible [B] " FORMAT_B " != " FORMAT_B "", geopositionmarker->mtext_visible, mtext_visible);
    mtext_visible++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext_visible", &mtext_visible, 0)
        && mtext_visible == geopositionmarker->mtext_visible)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.mtext_visible [B] set+1 " FORMAT_B " != " FORMAT_B "", geopositionmarker->mtext_visible, mtext_visible);
    geopositionmarker->mtext_visible--;

  }
  {
    BITCODE_T notes;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "notes", &notes, NULL)
        && !memcmp (&notes, &geopositionmarker->notes, sizeof (geopositionmarker->notes)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.notes [T]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "parent", &parent, NULL)
        && !memcmp (&parent, &geopositionmarker->parent, sizeof (geopositionmarker->parent)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD position;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "position", &position, NULL)
        && !memcmp (&position, &geopositionmarker->position, sizeof (geopositionmarker->position)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.position [3BD]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "radius", &radius, NULL)
        && radius == geopositionmarker->radius)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.radius [BD] %g != %g", geopositionmarker->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "radius", &radius, 0)
        && radius == geopositionmarker->radius)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.radius [BD] set+1 %g != %g", geopositionmarker->radius, radius);
    geopositionmarker->radius--;

  }
  {
    BITCODE_T text;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "text", &text, NULL)
        && !memcmp (&text, &geopositionmarker->text, sizeof (geopositionmarker->text)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.text [T]");
  }
  {
    BITCODE_BS text_alignment;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "text_alignment", &text_alignment, NULL)
        && text_alignment == geopositionmarker->text_alignment)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.text_alignment [BS] %hu != %hu", geopositionmarker->text_alignment, text_alignment);
    text_alignment++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "text_alignment", &text_alignment, 0)
        && text_alignment == geopositionmarker->text_alignment)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.text_alignment [BS] set+1 %hu != %hu", geopositionmarker->text_alignment, text_alignment);
    geopositionmarker->text_alignment--;

  }
  {
    BITCODE_H text_style;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "text_style", &text_style, NULL)
        && !memcmp (&text_style, &geopositionmarker->text_style, sizeof (geopositionmarker->text_style)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.text_style [H]");
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "type", &type, NULL)
        && type == geopositionmarker->type)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.type [BS] %hu != %hu", geopositionmarker->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "type", &type, 0)
        && type == geopositionmarker->type)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.type [BS] set+1 %hu != %hu", geopositionmarker->type, type);
    geopositionmarker->type--;

  }
  return failed;
}
static int test_HATCH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_HATCH *restrict hatch = obj->tio.entity->tio.HATCH;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "angle", &angle, NULL)
        && angle == hatch->angle)
      pass ();
    else
      fail ("HATCH.angle [BD] %g != %g", hatch->angle, angle);
    angle++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "angle", &angle, 0)
        && angle == hatch->angle)
      pass ();
    else
      fail ("HATCH.angle [BD] set+1 %g != %g", hatch->angle, angle);
    hatch->angle--;

  }
  {
    BITCODE_B associative;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "associative", &associative, NULL)
        && associative == hatch->associative)
      pass ();
    else
      fail ("HATCH.associative [B] " FORMAT_B " != " FORMAT_B "", hatch->associative, associative);
    associative++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "associative", &associative, 0)
        && associative == hatch->associative)
      pass ();
    else
      fail ("HATCH.associative [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->associative, associative);
    hatch->associative--;

  }
  {
    BITCODE_H* boundary_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_boundary_handles", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "boundary_handles", &boundary_handles, NULL)
        && boundary_handles == hatch->boundary_handles)
      pass ();
    else
      fail ("HATCH.boundary_handles [H*] * %u num_boundary_handles", count);
  }
  {
    Dwg_HATCH_Color* colors;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_colors", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "colors", &colors, NULL)
        && colors == hatch->colors)
      pass ();
    else
      fail ("HATCH.colors [Dwg_HATCH_Color*] * %u num_colors", count);
  }
  {
    Dwg_HATCH_DefLine* deflines;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_deflines", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "deflines", &deflines, NULL)
        && deflines == hatch->deflines)
      pass ();
    else
      fail ("HATCH.deflines [Dwg_HATCH_DefLine*] * %u num_deflines", count);
  }
  {
    BITCODE_B double_flag;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "double_flag", &double_flag, NULL)
        && double_flag == hatch->double_flag)
      pass ();
    else
      fail ("HATCH.double_flag [B] " FORMAT_B " != " FORMAT_B "", hatch->double_flag, double_flag);
    double_flag++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "double_flag", &double_flag, 0)
        && double_flag == hatch->double_flag)
      pass ();
    else
      fail ("HATCH.double_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->double_flag, double_flag);
    hatch->double_flag--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "elevation", &elevation, NULL)
        && elevation == hatch->elevation)
      pass ();
    else
      fail ("HATCH.elevation [BD] %g != %g", hatch->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "elevation", &elevation, 0)
        && elevation == hatch->elevation)
      pass ();
    else
      fail ("HATCH.elevation [BD] set+1 %g != %g", hatch->elevation, elevation);
    hatch->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &hatch->extrusion, sizeof (hatch->extrusion)))
        pass ();
    else
        fail ("HATCH.extrusion [BE]");
  }
  {
    BITCODE_BD gradient_angle;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_angle", &gradient_angle, NULL)
        && gradient_angle == hatch->gradient_angle)
      pass ();
    else
      fail ("HATCH.gradient_angle [BD] %g != %g", hatch->gradient_angle, gradient_angle);
    gradient_angle++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_angle", &gradient_angle, 0)
        && gradient_angle == hatch->gradient_angle)
      pass ();
    else
      fail ("HATCH.gradient_angle [BD] set+1 %g != %g", hatch->gradient_angle, gradient_angle);
    hatch->gradient_angle--;

  }
  {
    BITCODE_TV gradient_name;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_name", &gradient_name, NULL)
        && gradient_name
           ? strEQ ((char *)gradient_name, (char *)hatch->gradient_name)
           : !hatch->gradient_name)
      pass ();
    else
      fail ("HATCH.gradient_name [TV] '%s' <> '%s'", gradient_name, hatch->gradient_name);
  }
  {
    BITCODE_BD gradient_shift;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_shift", &gradient_shift, NULL)
        && gradient_shift == hatch->gradient_shift)
      pass ();
    else
      fail ("HATCH.gradient_shift [BD] %g != %g", hatch->gradient_shift, gradient_shift);
    gradient_shift++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_shift", &gradient_shift, 0)
        && gradient_shift == hatch->gradient_shift)
      pass ();
    else
      fail ("HATCH.gradient_shift [BD] set+1 %g != %g", hatch->gradient_shift, gradient_shift);
    hatch->gradient_shift--;

  }
  {
    BITCODE_BD gradient_tint;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_tint", &gradient_tint, NULL)
        && gradient_tint == hatch->gradient_tint)
      pass ();
    else
      fail ("HATCH.gradient_tint [BD] %g != %g", hatch->gradient_tint, gradient_tint);
    gradient_tint++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_tint", &gradient_tint, 0)
        && gradient_tint == hatch->gradient_tint)
      pass ();
    else
      fail ("HATCH.gradient_tint [BD] set+1 %g != %g", hatch->gradient_tint, gradient_tint);
    hatch->gradient_tint--;

  }
  {
    BITCODE_B has_derived;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "has_derived", &has_derived, NULL)
        && has_derived == hatch->has_derived)
      pass ();
    else
      fail ("HATCH.has_derived [B] " FORMAT_B " != " FORMAT_B "", hatch->has_derived, has_derived);
    has_derived++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "has_derived", &has_derived, 0)
        && has_derived == hatch->has_derived)
      pass ();
    else
      fail ("HATCH.has_derived [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->has_derived, has_derived);
    hatch->has_derived--;

  }
  {
    BITCODE_BL is_gradient_fill;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "is_gradient_fill", &is_gradient_fill, NULL)
        && is_gradient_fill == hatch->is_gradient_fill)
      pass ();
    else
      fail ("HATCH.is_gradient_fill [BL] %u != %u", hatch->is_gradient_fill, is_gradient_fill);
    is_gradient_fill++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "is_gradient_fill", &is_gradient_fill, 0)
        && is_gradient_fill == hatch->is_gradient_fill)
      pass ();
    else
      fail ("HATCH.is_gradient_fill [BL] set+1 %u != %u", hatch->is_gradient_fill, is_gradient_fill);
    hatch->is_gradient_fill--;

  }
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)hatch->name)
           : !hatch->name)
      pass ();
    else
      fail ("HATCH.name [TV] '%s' <> '%s'", name, hatch->name);
  }
  {
    BITCODE_BL num_boundary_handles;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_boundary_handles", &num_boundary_handles, NULL)
        && num_boundary_handles == hatch->num_boundary_handles)
      pass ();
    else
      fail ("HATCH.num_boundary_handles [BL] %u != %u", hatch->num_boundary_handles, num_boundary_handles);
    num_boundary_handles++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_boundary_handles", &num_boundary_handles, 0)
        && num_boundary_handles == hatch->num_boundary_handles)
      pass ();
    else
      fail ("HATCH.num_boundary_handles [BL] set+1 %u != %u", hatch->num_boundary_handles, num_boundary_handles);
    hatch->num_boundary_handles--;

  }
  {
    BITCODE_BL num_colors;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_colors", &num_colors, NULL)
        && num_colors == hatch->num_colors)
      pass ();
    else
      fail ("HATCH.num_colors [BL] %u != %u", hatch->num_colors, num_colors);
    num_colors++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_colors", &num_colors, 0)
        && num_colors == hatch->num_colors)
      pass ();
    else
      fail ("HATCH.num_colors [BL] set+1 %u != %u", hatch->num_colors, num_colors);
    hatch->num_colors--;

  }
  {
    BITCODE_BS num_deflines;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_deflines", &num_deflines, NULL)
        && num_deflines == hatch->num_deflines)
      pass ();
    else
      fail ("HATCH.num_deflines [BS] %hu != %hu", hatch->num_deflines, num_deflines);
    num_deflines++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_deflines", &num_deflines, 0)
        && num_deflines == hatch->num_deflines)
      pass ();
    else
      fail ("HATCH.num_deflines [BS] set+1 %hu != %hu", hatch->num_deflines, num_deflines);
    hatch->num_deflines--;

  }
  {
    BITCODE_BL num_paths;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_paths", &num_paths, NULL)
        && num_paths == hatch->num_paths)
      pass ();
    else
      fail ("HATCH.num_paths [BL] %u != %u", hatch->num_paths, num_paths);
    num_paths++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_paths", &num_paths, 0)
        && num_paths == hatch->num_paths)
      pass ();
    else
      fail ("HATCH.num_paths [BL] set+1 %u != %u", hatch->num_paths, num_paths);
    hatch->num_paths--;

  }
  {
    BITCODE_BL num_seeds;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_seeds", &num_seeds, NULL)
        && num_seeds == hatch->num_seeds)
      pass ();
    else
      fail ("HATCH.num_seeds [BL] %u != %u", hatch->num_seeds, num_seeds);
    num_seeds++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_seeds", &num_seeds, 0)
        && num_seeds == hatch->num_seeds)
      pass ();
    else
      fail ("HATCH.num_seeds [BL] set+1 %u != %u", hatch->num_seeds, num_seeds);
    hatch->num_seeds--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "parent", &parent, NULL)
        && !memcmp (&parent, &hatch->parent, sizeof (hatch->parent)))
        pass ();
    else
        fail ("HATCH.parent [struct _dwg_object_entity*]");
  }
  {
    Dwg_HATCH_Path* paths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_paths", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "paths", &paths, NULL)
        && paths == hatch->paths)
      pass ();
    else
      fail ("HATCH.paths [Dwg_HATCH_Path*] * %u num_paths", count);
  }
  {
    BITCODE_BS pattern_type;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "pattern_type", &pattern_type, NULL)
        && pattern_type == hatch->pattern_type)
      pass ();
    else
      fail ("HATCH.pattern_type [BS] %hu != %hu", hatch->pattern_type, pattern_type);
    pattern_type++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "pattern_type", &pattern_type, 0)
        && pattern_type == hatch->pattern_type)
      pass ();
    else
      fail ("HATCH.pattern_type [BS] set+1 %hu != %hu", hatch->pattern_type, pattern_type);
    hatch->pattern_type--;

  }
  {
    BITCODE_BD pixel_size;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "pixel_size", &pixel_size, NULL)
        && pixel_size == hatch->pixel_size)
      pass ();
    else
      fail ("HATCH.pixel_size [BD] %g != %g", hatch->pixel_size, pixel_size);
    pixel_size++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "pixel_size", &pixel_size, 0)
        && pixel_size == hatch->pixel_size)
      pass ();
    else
      fail ("HATCH.pixel_size [BD] set+1 %g != %g", hatch->pixel_size, pixel_size);
    hatch->pixel_size--;

  }
  {
    BITCODE_BL reserved;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "reserved", &reserved, NULL)
        && reserved == hatch->reserved)
      pass ();
    else
      fail ("HATCH.reserved [BL] %u != %u", hatch->reserved, reserved);
    reserved++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "reserved", &reserved, 0)
        && reserved == hatch->reserved)
      pass ();
    else
      fail ("HATCH.reserved [BL] set+1 %u != %u", hatch->reserved, reserved);
    hatch->reserved--;

  }
  {
    BITCODE_BD scale_spacing;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "scale_spacing", &scale_spacing, NULL)
        && scale_spacing == hatch->scale_spacing)
      pass ();
    else
      fail ("HATCH.scale_spacing [BD] %g != %g", hatch->scale_spacing, scale_spacing);
    scale_spacing++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "scale_spacing", &scale_spacing, 0)
        && scale_spacing == hatch->scale_spacing)
      pass ();
    else
      fail ("HATCH.scale_spacing [BD] set+1 %g != %g", hatch->scale_spacing, scale_spacing);
    hatch->scale_spacing--;

  }
  {
    BITCODE_2RD* seeds;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_seeds", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "seeds", &seeds, NULL)
        && seeds == hatch->seeds)
      pass ();
    else
      fail ("HATCH.seeds [2RD*] * %u num_seeds", count);
  }
  {
    BITCODE_BL single_color_gradient;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "single_color_gradient", &single_color_gradient, NULL)
        && single_color_gradient == hatch->single_color_gradient)
      pass ();
    else
      fail ("HATCH.single_color_gradient [BL] %u != %u", hatch->single_color_gradient, single_color_gradient);
    single_color_gradient++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "single_color_gradient", &single_color_gradient, 0)
        && single_color_gradient == hatch->single_color_gradient)
      pass ();
    else
      fail ("HATCH.single_color_gradient [BL] set+1 %u != %u", hatch->single_color_gradient, single_color_gradient);
    hatch->single_color_gradient--;

  }
  {
    BITCODE_B solid_fill;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "solid_fill", &solid_fill, NULL)
        && solid_fill == hatch->solid_fill)
      pass ();
    else
      fail ("HATCH.solid_fill [B] " FORMAT_B " != " FORMAT_B "", hatch->solid_fill, solid_fill);
    solid_fill++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "solid_fill", &solid_fill, 0)
        && solid_fill == hatch->solid_fill)
      pass ();
    else
      fail ("HATCH.solid_fill [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->solid_fill, solid_fill);
    hatch->solid_fill--;

  }
  {
    BITCODE_BS style;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "style", &style, NULL)
        && style == hatch->style)
      pass ();
    else
      fail ("HATCH.style [BS] %hu != %hu", hatch->style, style);
    style++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "style", &style, 0)
        && style == hatch->style)
      pass ();
    else
      fail ("HATCH.style [BS] set+1 %hu != %hu", hatch->style, style);
    hatch->style--;

  }
  return failed;
}
static int test_HELIX (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_HELIX *restrict helix = obj->tio.entity->tio.HELIX;
  {
    BITCODE_3BD axis_base_pt;
    if (dwg_dynapi_entity_value (helix, "HELIX", "axis_base_pt", &axis_base_pt, NULL)
        && !memcmp (&axis_base_pt, &helix->axis_base_pt, sizeof (helix->axis_base_pt)))
        pass ();
    else
        fail ("HELIX.axis_base_pt [3BD]");
  }
  {
    BITCODE_3BD axis_vector;
    if (dwg_dynapi_entity_value (helix, "HELIX", "axis_vector", &axis_vector, NULL)
        && !memcmp (&axis_vector, &helix->axis_vector, sizeof (helix->axis_vector)))
        pass ();
    else
        fail ("HELIX.axis_vector [3BD_1]");
  }
  {
    BITCODE_3BD beg_tan_vec;
    if (dwg_dynapi_entity_value (helix, "HELIX", "beg_tan_vec", &beg_tan_vec, NULL)
        && !memcmp (&beg_tan_vec, &helix->beg_tan_vec, sizeof (helix->beg_tan_vec)))
        pass ();
    else
        fail ("HELIX.beg_tan_vec [3BD]");
  }
  {
    BITCODE_B closed_b;
    if (dwg_dynapi_entity_value (helix, "HELIX", "closed_b", &closed_b, NULL)
        && closed_b == helix->closed_b)
      pass ();
    else
      fail ("HELIX.closed_b [B] " FORMAT_B " != " FORMAT_B "", helix->closed_b, closed_b);
    closed_b++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "closed_b", &closed_b, 0)
        && closed_b == helix->closed_b)
      pass ();
    else
      fail ("HELIX.closed_b [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->closed_b, closed_b);
    helix->closed_b--;

  }
  {
    BITCODE_BS constraint_type;
    if (dwg_dynapi_entity_value (helix, "HELIX", "constraint_type", &constraint_type, NULL)
        && constraint_type == helix->constraint_type)
      pass ();
    else
      fail ("HELIX.constraint_type [BS] %hu != %hu", helix->constraint_type, constraint_type);
    constraint_type++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "constraint_type", &constraint_type, 0)
        && constraint_type == helix->constraint_type)
      pass ();
    else
      fail ("HELIX.constraint_type [BS] set+1 %hu != %hu", helix->constraint_type, constraint_type);
    helix->constraint_type--;

  }
  {
    Dwg_SPLINE_control_point* ctrl_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_ctrl_pts", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "ctrl_pts", &ctrl_pts, NULL)
        && ctrl_pts == helix->ctrl_pts)
      pass ();
    else
      fail ("HELIX.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
  }
  {
    BITCODE_BD ctrl_tol;
    if (dwg_dynapi_entity_value (helix, "HELIX", "ctrl_tol", &ctrl_tol, NULL)
        && ctrl_tol == helix->ctrl_tol)
      pass ();
    else
      fail ("HELIX.ctrl_tol [BD] %g != %g", helix->ctrl_tol, ctrl_tol);
    ctrl_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "ctrl_tol", &ctrl_tol, 0)
        && ctrl_tol == helix->ctrl_tol)
      pass ();
    else
      fail ("HELIX.ctrl_tol [BD] set+1 %g != %g", helix->ctrl_tol, ctrl_tol);
    helix->ctrl_tol--;

  }
  {
    BITCODE_BS degree;
    if (dwg_dynapi_entity_value (helix, "HELIX", "degree", &degree, NULL)
        && degree == helix->degree)
      pass ();
    else
      fail ("HELIX.degree [BS] %hu != %hu", helix->degree, degree);
    degree++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "degree", &degree, 0)
        && degree == helix->degree)
      pass ();
    else
      fail ("HELIX.degree [BS] set+1 %hu != %hu", helix->degree, degree);
    helix->degree--;

  }
  {
    BITCODE_3BD end_tan_vec;
    if (dwg_dynapi_entity_value (helix, "HELIX", "end_tan_vec", &end_tan_vec, NULL)
        && !memcmp (&end_tan_vec, &helix->end_tan_vec, sizeof (helix->end_tan_vec)))
        pass ();
    else
        fail ("HELIX.end_tan_vec [3BD]");
  }
  {
    Dwg_SPLINE_point* fit_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_fit_pts", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "fit_pts", &fit_pts, NULL)
        && fit_pts == helix->fit_pts)
      pass ();
    else
      fail ("HELIX.fit_pts [Dwg_SPLINE_point*] * %u num_fit_pts", count);
  }
  {
    BITCODE_BD fit_tol;
    if (dwg_dynapi_entity_value (helix, "HELIX", "fit_tol", &fit_tol, NULL)
        && fit_tol == helix->fit_tol)
      pass ();
    else
      fail ("HELIX.fit_tol [BD] %g != %g", helix->fit_tol, fit_tol);
    fit_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "fit_tol", &fit_tol, 0)
        && fit_tol == helix->fit_tol)
      pass ();
    else
      fail ("HELIX.fit_tol [BD] set+1 %g != %g", helix->fit_tol, fit_tol);
    helix->fit_tol--;

  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (helix, "HELIX", "flag", &flag, NULL)
        && flag == helix->flag)
      pass ();
    else
      fail ("HELIX.flag [BS] %hu != %hu", helix->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "flag", &flag, 0)
        && flag == helix->flag)
      pass ();
    else
      fail ("HELIX.flag [BS] set+1 %hu != %hu", helix->flag, flag);
    helix->flag--;

  }
  {
    BITCODE_B handedness;
    if (dwg_dynapi_entity_value (helix, "HELIX", "handedness", &handedness, NULL)
        && handedness == helix->handedness)
      pass ();
    else
      fail ("HELIX.handedness [B] " FORMAT_B " != " FORMAT_B "", helix->handedness, handedness);
    handedness++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "handedness", &handedness, 0)
        && handedness == helix->handedness)
      pass ();
    else
      fail ("HELIX.handedness [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->handedness, handedness);
    helix->handedness--;

  }
  {
    BITCODE_BD knot_tol;
    if (dwg_dynapi_entity_value (helix, "HELIX", "knot_tol", &knot_tol, NULL)
        && knot_tol == helix->knot_tol)
      pass ();
    else
      fail ("HELIX.knot_tol [BD] %g != %g", helix->knot_tol, knot_tol);
    knot_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "knot_tol", &knot_tol, 0)
        && knot_tol == helix->knot_tol)
      pass ();
    else
      fail ("HELIX.knot_tol [BD] set+1 %g != %g", helix->knot_tol, knot_tol);
    helix->knot_tol--;

  }
  {
    BITCODE_BL knotparam;
    if (dwg_dynapi_entity_value (helix, "HELIX", "knotparam", &knotparam, NULL)
        && knotparam == helix->knotparam)
      pass ();
    else
      fail ("HELIX.knotparam [BL] %u != %u", helix->knotparam, knotparam);
    knotparam++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "knotparam", &knotparam, 0)
        && knotparam == helix->knotparam)
      pass ();
    else
      fail ("HELIX.knotparam [BL] set+1 %u != %u", helix->knotparam, knotparam);
    helix->knotparam--;

  }
  {
    BITCODE_BD* knots;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_knots", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "knots", &knots, NULL)
        && knots == helix->knots)
      pass ();
    else
      fail ("HELIX.knots [BD*] * %u num_knots", count);
  }
  {
    BITCODE_BS maint_version;
    if (dwg_dynapi_entity_value (helix, "HELIX", "maint_version", &maint_version, NULL)
        && maint_version == helix->maint_version)
      pass ();
    else
      fail ("HELIX.maint_version [BS] %hu != %hu", helix->maint_version, maint_version);
    maint_version++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "maint_version", &maint_version, 0)
        && maint_version == helix->maint_version)
      pass ();
    else
      fail ("HELIX.maint_version [BS] set+1 %hu != %hu", helix->maint_version, maint_version);
    helix->maint_version--;

  }
  {
    BITCODE_BS major_version;
    if (dwg_dynapi_entity_value (helix, "HELIX", "major_version", &major_version, NULL)
        && major_version == helix->major_version)
      pass ();
    else
      fail ("HELIX.major_version [BS] %hu != %hu", helix->major_version, major_version);
    major_version++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "major_version", &major_version, 0)
        && major_version == helix->major_version)
      pass ();
    else
      fail ("HELIX.major_version [BS] set+1 %hu != %hu", helix->major_version, major_version);
    helix->major_version--;

  }
  {
    BITCODE_BL num_ctrl_pts;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_ctrl_pts", &num_ctrl_pts, NULL)
        && num_ctrl_pts == helix->num_ctrl_pts)
      pass ();
    else
      fail ("HELIX.num_ctrl_pts [BL] %u != %u", helix->num_ctrl_pts, num_ctrl_pts);
    num_ctrl_pts++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_ctrl_pts", &num_ctrl_pts, 0)
        && num_ctrl_pts == helix->num_ctrl_pts)
      pass ();
    else
      fail ("HELIX.num_ctrl_pts [BL] set+1 %u != %u", helix->num_ctrl_pts, num_ctrl_pts);
    helix->num_ctrl_pts--;

  }
  {
    BITCODE_BS num_fit_pts;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_fit_pts", &num_fit_pts, NULL)
        && num_fit_pts == helix->num_fit_pts)
      pass ();
    else
      fail ("HELIX.num_fit_pts [BS] %hu != %hu", helix->num_fit_pts, num_fit_pts);
    num_fit_pts++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_fit_pts", &num_fit_pts, 0)
        && num_fit_pts == helix->num_fit_pts)
      pass ();
    else
      fail ("HELIX.num_fit_pts [BS] set+1 %hu != %hu", helix->num_fit_pts, num_fit_pts);
    helix->num_fit_pts--;

  }
  {
    BITCODE_BL num_knots;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_knots", &num_knots, NULL)
        && num_knots == helix->num_knots)
      pass ();
    else
      fail ("HELIX.num_knots [BL] %u != %u", helix->num_knots, num_knots);
    num_knots++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_knots", &num_knots, 0)
        && num_knots == helix->num_knots)
      pass ();
    else
      fail ("HELIX.num_knots [BL] set+1 %u != %u", helix->num_knots, num_knots);
    helix->num_knots--;

  }
  {
    BITCODE_BD num_turns;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_turns", &num_turns, NULL)
        && num_turns == helix->num_turns)
      pass ();
    else
      fail ("HELIX.num_turns [BD] %g != %g", helix->num_turns, num_turns);
    num_turns++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_turns", &num_turns, 0)
        && num_turns == helix->num_turns)
      pass ();
    else
      fail ("HELIX.num_turns [BD] set+1 %g != %g", helix->num_turns, num_turns);
    helix->num_turns--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (helix, "HELIX", "parent", &parent, NULL)
        && !memcmp (&parent, &helix->parent, sizeof (helix->parent)))
        pass ();
    else
        fail ("HELIX.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B periodic;
    if (dwg_dynapi_entity_value (helix, "HELIX", "periodic", &periodic, NULL)
        && periodic == helix->periodic)
      pass ();
    else
      fail ("HELIX.periodic [B] " FORMAT_B " != " FORMAT_B "", helix->periodic, periodic);
    periodic++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "periodic", &periodic, 0)
        && periodic == helix->periodic)
      pass ();
    else
      fail ("HELIX.periodic [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->periodic, periodic);
    helix->periodic--;

  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (helix, "HELIX", "radius", &radius, NULL)
        && radius == helix->radius)
      pass ();
    else
      fail ("HELIX.radius [BD] %g != %g", helix->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "radius", &radius, 0)
        && radius == helix->radius)
      pass ();
    else
      fail ("HELIX.radius [BD] set+1 %g != %g", helix->radius, radius);
    helix->radius--;

  }
  {
    BITCODE_B rational;
    if (dwg_dynapi_entity_value (helix, "HELIX", "rational", &rational, NULL)
        && rational == helix->rational)
      pass ();
    else
      fail ("HELIX.rational [B] " FORMAT_B " != " FORMAT_B "", helix->rational, rational);
    rational++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "rational", &rational, 0)
        && rational == helix->rational)
      pass ();
    else
      fail ("HELIX.rational [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->rational, rational);
    helix->rational--;

  }
  {
    BITCODE_BS scenario;
    if (dwg_dynapi_entity_value (helix, "HELIX", "scenario", &scenario, NULL)
        && scenario == helix->scenario)
      pass ();
    else
      fail ("HELIX.scenario [BS] %hu != %hu", helix->scenario, scenario);
    scenario++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "scenario", &scenario, 0)
        && scenario == helix->scenario)
      pass ();
    else
      fail ("HELIX.scenario [BS] set+1 %hu != %hu", helix->scenario, scenario);
    helix->scenario--;

  }
  {
    BITCODE_BL splineflags1;
    if (dwg_dynapi_entity_value (helix, "HELIX", "splineflags1", &splineflags1, NULL)
        && splineflags1 == helix->splineflags1)
      pass ();
    else
      fail ("HELIX.splineflags1 [BL] %u != %u", helix->splineflags1, splineflags1);
    splineflags1++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "splineflags1", &splineflags1, 0)
        && splineflags1 == helix->splineflags1)
      pass ();
    else
      fail ("HELIX.splineflags1 [BL] set+1 %u != %u", helix->splineflags1, splineflags1);
    helix->splineflags1--;

  }
  {
    BITCODE_3BD start_pt;
    if (dwg_dynapi_entity_value (helix, "HELIX", "start_pt", &start_pt, NULL)
        && !memcmp (&start_pt, &helix->start_pt, sizeof (helix->start_pt)))
        pass ();
    else
        fail ("HELIX.start_pt [3BD_1]");
  }
  {
    BITCODE_BD turn_height;
    if (dwg_dynapi_entity_value (helix, "HELIX", "turn_height", &turn_height, NULL)
        && turn_height == helix->turn_height)
      pass ();
    else
      fail ("HELIX.turn_height [BD] %g != %g", helix->turn_height, turn_height);
    turn_height++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "turn_height", &turn_height, 0)
        && turn_height == helix->turn_height)
      pass ();
    else
      fail ("HELIX.turn_height [BD] set+1 %g != %g", helix->turn_height, turn_height);
    helix->turn_height--;

  }
  {
    BITCODE_B weighted;
    if (dwg_dynapi_entity_value (helix, "HELIX", "weighted", &weighted, NULL)
        && weighted == helix->weighted)
      pass ();
    else
      fail ("HELIX.weighted [B] " FORMAT_B " != " FORMAT_B "", helix->weighted, weighted);
    weighted++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "weighted", &weighted, 0)
        && weighted == helix->weighted)
      pass ();
    else
      fail ("HELIX.weighted [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->weighted, weighted);
    helix->weighted--;

  }
  return failed;
}
static int test_IMAGE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_IMAGE *restrict image = obj->tio.entity->tio.IMAGE;
  {
    BITCODE_RC brightness;
    if (dwg_dynapi_entity_value (image, "IMAGE", "brightness", &brightness, NULL)
        && brightness == image->brightness)
      pass ();
    else
      fail ("IMAGE.brightness [RC] %u != %u", image->brightness, brightness);
    brightness++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "brightness", &brightness, 0)
        && brightness == image->brightness)
      pass ();
    else
      fail ("IMAGE.brightness [RC] set+1 %u != %u", image->brightness, brightness);
    image->brightness--;

  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (image, "IMAGE", "class_version", &class_version, NULL)
        && class_version == image->class_version)
      pass ();
    else
      fail ("IMAGE.class_version [BL] %u != %u", image->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "class_version", &class_version, 0)
        && class_version == image->class_version)
      pass ();
    else
      fail ("IMAGE.class_version [BL] set+1 %u != %u", image->class_version, class_version);
    image->class_version--;

  }
  {
    BITCODE_BS clip_boundary_type;
    if (dwg_dynapi_entity_value (image, "IMAGE", "clip_boundary_type", &clip_boundary_type, NULL)
        && clip_boundary_type == image->clip_boundary_type)
      pass ();
    else
      fail ("IMAGE.clip_boundary_type [BS] %hu != %hu", image->clip_boundary_type, clip_boundary_type);
    clip_boundary_type++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clip_boundary_type", &clip_boundary_type, 0)
        && clip_boundary_type == image->clip_boundary_type)
      pass ();
    else
      fail ("IMAGE.clip_boundary_type [BS] set+1 %hu != %hu", image->clip_boundary_type, clip_boundary_type);
    image->clip_boundary_type--;

  }
  {
    BITCODE_B clip_mode;
    if (dwg_dynapi_entity_value (image, "IMAGE", "clip_mode", &clip_mode, NULL)
        && clip_mode == image->clip_mode)
      pass ();
    else
      fail ("IMAGE.clip_mode [B] " FORMAT_B " != " FORMAT_B "", image->clip_mode, clip_mode);
    clip_mode++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clip_mode", &clip_mode, 0)
        && clip_mode == image->clip_mode)
      pass ();
    else
      fail ("IMAGE.clip_mode [B] set+1 " FORMAT_B " != " FORMAT_B "", image->clip_mode, clip_mode);
    image->clip_mode--;

  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (image, "IMAGE", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (image, "IMAGE", "clip_verts", &clip_verts, NULL)
        && clip_verts == image->clip_verts)
      pass ();
    else
      fail ("IMAGE.clip_verts [2RD*] * %u num_clip_verts", count);
  }
  {
    BITCODE_B clipping;
    if (dwg_dynapi_entity_value (image, "IMAGE", "clipping", &clipping, NULL)
        && clipping == image->clipping)
      pass ();
    else
      fail ("IMAGE.clipping [B] " FORMAT_B " != " FORMAT_B "", image->clipping, clipping);
    clipping++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clipping", &clipping, 0)
        && clipping == image->clipping)
      pass ();
    else
      fail ("IMAGE.clipping [B] set+1 " FORMAT_B " != " FORMAT_B "", image->clipping, clipping);
    image->clipping--;

  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value (image, "IMAGE", "contrast", &contrast, NULL)
        && contrast == image->contrast)
      pass ();
    else
      fail ("IMAGE.contrast [RC] %u != %u", image->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "contrast", &contrast, 0)
        && contrast == image->contrast)
      pass ();
    else
      fail ("IMAGE.contrast [RC] set+1 %u != %u", image->contrast, contrast);
    image->contrast--;

  }
  {
    BITCODE_BS display_props;
    if (dwg_dynapi_entity_value (image, "IMAGE", "display_props", &display_props, NULL)
        && display_props == image->display_props)
      pass ();
    else
      fail ("IMAGE.display_props [BS] %hu != %hu", image->display_props, display_props);
    display_props++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "display_props", &display_props, 0)
        && display_props == image->display_props)
      pass ();
    else
      fail ("IMAGE.display_props [BS] set+1 %hu != %hu", image->display_props, display_props);
    image->display_props--;

  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value (image, "IMAGE", "fade", &fade, NULL)
        && fade == image->fade)
      pass ();
    else
      fail ("IMAGE.fade [RC] %u != %u", image->fade, fade);
    fade++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "fade", &fade, 0)
        && fade == image->fade)
      pass ();
    else
      fail ("IMAGE.fade [RC] set+1 %u != %u", image->fade, fade);
    image->fade--;

  }
  {
    BITCODE_H imagedef;
    if (dwg_dynapi_entity_value (image, "IMAGE", "imagedef", &imagedef, NULL)
        && !memcmp (&imagedef, &image->imagedef, sizeof (image->imagedef)))
        pass ();
    else
        fail ("IMAGE.imagedef [H]");
  }
  {
    BITCODE_H imagedefreactor;
    if (dwg_dynapi_entity_value (image, "IMAGE", "imagedefreactor", &imagedefreactor, NULL)
        && !memcmp (&imagedefreactor, &image->imagedefreactor, sizeof (image->imagedefreactor)))
        pass ();
    else
        fail ("IMAGE.imagedefreactor [H]");
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value (image, "IMAGE", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == image->num_clip_verts)
      pass ();
    else
      fail ("IMAGE.num_clip_verts [BL] %u != %u", image->num_clip_verts, num_clip_verts);
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "num_clip_verts", &num_clip_verts, 0)
        && num_clip_verts == image->num_clip_verts)
      pass ();
    else
      fail ("IMAGE.num_clip_verts [BL] set+1 %u != %u", image->num_clip_verts, num_clip_verts);
    image->num_clip_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (image, "IMAGE", "parent", &parent, NULL)
        && !memcmp (&parent, &image->parent, sizeof (image->parent)))
        pass ();
    else
        fail ("IMAGE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt0;
    if (dwg_dynapi_entity_value (image, "IMAGE", "pt0", &pt0, NULL)
        && !memcmp (&pt0, &image->pt0, sizeof (image->pt0)))
        pass ();
    else
        fail ("IMAGE.pt0 [3BD]");
  }
  {
    BITCODE_2RD size;
    if (dwg_dynapi_entity_value (image, "IMAGE", "size", &size, NULL)
        && !memcmp (&size, &image->size, sizeof (image->size)))
        pass ();
    else
        fail ("IMAGE.size [2RD]");
  }
  {
    BITCODE_3BD uvec;
    if (dwg_dynapi_entity_value (image, "IMAGE", "uvec", &uvec, NULL)
        && !memcmp (&uvec, &image->uvec, sizeof (image->uvec)))
        pass ();
    else
        fail ("IMAGE.uvec [3BD]");
  }
  {
    BITCODE_3BD vvec;
    if (dwg_dynapi_entity_value (image, "IMAGE", "vvec", &vvec, NULL)
        && !memcmp (&vvec, &image->vvec, sizeof (image->vvec)))
        pass ();
    else
        fail ("IMAGE.vvec [3BD]");
  }
  return failed;
}
static int test_INSERT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_INSERT *restrict insert = obj->tio.entity->tio.INSERT;
  {
    BITCODE_H* attrib_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (insert, "INSERT", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (insert, "INSERT", "attrib_handles", &attrib_handles, NULL)
        && attrib_handles == insert->attrib_handles)
      pass ();
    else
      fail ("INSERT.attrib_handles [H*] * %u num_owned", count);
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value (insert, "INSERT", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &insert->block_header, sizeof (insert->block_header)))
        pass ();
    else
        fail ("INSERT.block_header [H]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (insert, "INSERT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &insert->extrusion, sizeof (insert->extrusion)))
        pass ();
    else
        fail ("INSERT.extrusion [BE]");
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value (insert, "INSERT", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &insert->first_attrib, sizeof (insert->first_attrib)))
        pass ();
    else
        fail ("INSERT.first_attrib [H]");
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value (insert, "INSERT", "has_attribs", &has_attribs, NULL)
        && has_attribs == insert->has_attribs)
      pass ();
    else
      fail ("INSERT.has_attribs [B] " FORMAT_B " != " FORMAT_B "", insert->has_attribs, has_attribs);
    has_attribs++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "has_attribs", &has_attribs, 0)
        && has_attribs == insert->has_attribs)
      pass ();
    else
      fail ("INSERT.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", insert->has_attribs, has_attribs);
    insert->has_attribs--;

  }
  {
    BITCODE_3DPOINT ins_pt;
    if (dwg_dynapi_entity_value (insert, "INSERT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &insert->ins_pt, sizeof (insert->ins_pt)))
        pass ();
    else
        fail ("INSERT.ins_pt [3DPOINT]");
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value (insert, "INSERT", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &insert->last_attrib, sizeof (insert->last_attrib)))
        pass ();
    else
        fail ("INSERT.last_attrib [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (insert, "INSERT", "num_owned", &num_owned, NULL)
        && num_owned == insert->num_owned)
      pass ();
    else
      fail ("INSERT.num_owned [BL] %u != %u", insert->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "num_owned", &num_owned, 0)
        && num_owned == insert->num_owned)
      pass ();
    else
      fail ("INSERT.num_owned [BL] set+1 %u != %u", insert->num_owned, num_owned);
    insert->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (insert, "INSERT", "parent", &parent, NULL)
        && !memcmp (&parent, &insert->parent, sizeof (insert->parent)))
        pass ();
    else
        fail ("INSERT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (insert, "INSERT", "rotation", &rotation, NULL)
        && rotation == insert->rotation)
      pass ();
    else
      fail ("INSERT.rotation [BD] %g != %g", insert->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "rotation", &rotation, 0)
        && rotation == insert->rotation)
      pass ();
    else
      fail ("INSERT.rotation [BD] set+1 %g != %g", insert->rotation, rotation);
    insert->rotation--;

  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (insert, "INSERT", "scale", &scale, NULL)
        && !memcmp (&scale, &insert->scale, sizeof (insert->scale)))
        pass ();
    else
        fail ("INSERT.scale [3BD_1]");
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value (insert, "INSERT", "scale_flag", &scale_flag, NULL)
        && scale_flag == insert->scale_flag)
      pass ();
    else
      fail ("INSERT.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", insert->scale_flag, scale_flag);
    scale_flag++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "scale_flag", &scale_flag, 0)
        && scale_flag == insert->scale_flag)
      pass ();
    else
      fail ("INSERT.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", insert->scale_flag, scale_flag);
    insert->scale_flag--;

  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (insert, "INSERT", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &insert->seqend, sizeof (insert->seqend)))
        pass ();
    else
        fail ("INSERT.seqend [H]");
  }
  return failed;
}
static int test_LEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LEADER *restrict leader = obj->tio.entity->tio.LEADER;
  {
    BITCODE_BS annot_type;
    if (dwg_dynapi_entity_value (leader, "LEADER", "annot_type", &annot_type, NULL)
        && annot_type == leader->annot_type)
      pass ();
    else
      fail ("LEADER.annot_type [BS] %hu != %hu", leader->annot_type, annot_type);
    annot_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "annot_type", &annot_type, 0)
        && annot_type == leader->annot_type)
      pass ();
    else
      fail ("LEADER.annot_type [BS] set+1 %hu != %hu", leader->annot_type, annot_type);
    leader->annot_type--;

  }
  {
    BITCODE_B arrowhead_on;
    if (dwg_dynapi_entity_value (leader, "LEADER", "arrowhead_on", &arrowhead_on, NULL)
        && arrowhead_on == leader->arrowhead_on)
      pass ();
    else
      fail ("LEADER.arrowhead_on [B] " FORMAT_B " != " FORMAT_B "", leader->arrowhead_on, arrowhead_on);
    arrowhead_on++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "arrowhead_on", &arrowhead_on, 0)
        && arrowhead_on == leader->arrowhead_on)
      pass ();
    else
      fail ("LEADER.arrowhead_on [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->arrowhead_on, arrowhead_on);
    leader->arrowhead_on--;

  }
  {
    BITCODE_BS arrowhead_type;
    if (dwg_dynapi_entity_value (leader, "LEADER", "arrowhead_type", &arrowhead_type, NULL)
        && arrowhead_type == leader->arrowhead_type)
      pass ();
    else
      fail ("LEADER.arrowhead_type [BS] %hu != %hu", leader->arrowhead_type, arrowhead_type);
    arrowhead_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "arrowhead_type", &arrowhead_type, 0)
        && arrowhead_type == leader->arrowhead_type)
      pass ();
    else
      fail ("LEADER.arrowhead_type [BS] set+1 %hu != %hu", leader->arrowhead_type, arrowhead_type);
    leader->arrowhead_type--;

  }
  {
    BITCODE_H associated_annotation;
    if (dwg_dynapi_entity_value (leader, "LEADER", "associated_annotation", &associated_annotation, NULL)
        && !memcmp (&associated_annotation, &leader->associated_annotation, sizeof (leader->associated_annotation)))
        pass ();
    else
        fail ("LEADER.associated_annotation [H]");
  }
  {
    BITCODE_BD box_height;
    if (dwg_dynapi_entity_value (leader, "LEADER", "box_height", &box_height, NULL)
        && box_height == leader->box_height)
      pass ();
    else
      fail ("LEADER.box_height [BD] %g != %g", leader->box_height, box_height);
    box_height++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "box_height", &box_height, 0)
        && box_height == leader->box_height)
      pass ();
    else
      fail ("LEADER.box_height [BD] set+1 %g != %g", leader->box_height, box_height);
    leader->box_height--;

  }
  {
    BITCODE_BD box_width;
    if (dwg_dynapi_entity_value (leader, "LEADER", "box_width", &box_width, NULL)
        && box_width == leader->box_width)
      pass ();
    else
      fail ("LEADER.box_width [BD] %g != %g", leader->box_width, box_width);
    box_width++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "box_width", &box_width, 0)
        && box_width == leader->box_width)
      pass ();
    else
      fail ("LEADER.box_width [BD] set+1 %g != %g", leader->box_width, box_width);
    leader->box_width--;

  }
  {
    BITCODE_BS byblock_color;
    if (dwg_dynapi_entity_value (leader, "LEADER", "byblock_color", &byblock_color, NULL)
        && byblock_color == leader->byblock_color)
      pass ();
    else
      fail ("LEADER.byblock_color [BS] %hu != %hu", leader->byblock_color, byblock_color);
    byblock_color++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "byblock_color", &byblock_color, 0)
        && byblock_color == leader->byblock_color)
      pass ();
    else
      fail ("LEADER.byblock_color [BS] set+1 %hu != %hu", leader->byblock_color, byblock_color);
    leader->byblock_color--;

  }
  {
    BITCODE_BD dimasz;
    if (dwg_dynapi_entity_value (leader, "LEADER", "dimasz", &dimasz, NULL)
        && dimasz == leader->dimasz)
      pass ();
    else
      fail ("LEADER.dimasz [BD] %g != %g", leader->dimasz, dimasz);
    dimasz++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "dimasz", &dimasz, 0)
        && dimasz == leader->dimasz)
      pass ();
    else
      fail ("LEADER.dimasz [BD] set+1 %g != %g", leader->dimasz, dimasz);
    leader->dimasz--;

  }
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_entity_value (leader, "LEADER", "dimgap", &dimgap, NULL)
        && dimgap == leader->dimgap)
      pass ();
    else
      fail ("LEADER.dimgap [BD] %g != %g", leader->dimgap, dimgap);
    dimgap++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "dimgap", &dimgap, 0)
        && dimgap == leader->dimgap)
      pass ();
    else
      fail ("LEADER.dimgap [BD] set+1 %g != %g", leader->dimgap, dimgap);
    leader->dimgap--;

  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (leader, "LEADER", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &leader->dimstyle, sizeof (leader->dimstyle)))
        pass ();
    else
        fail ("LEADER.dimstyle [H]");
  }
  {
    BITCODE_3DPOINT endptproj;
    if (dwg_dynapi_entity_value (leader, "LEADER", "endptproj", &endptproj, NULL)
        && !memcmp (&endptproj, &leader->endptproj, sizeof (leader->endptproj)))
        pass ();
    else
        fail ("LEADER.endptproj [3DPOINT]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (leader, "LEADER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &leader->extrusion, sizeof (leader->extrusion)))
        pass ();
    else
        fail ("LEADER.extrusion [BE]");
  }
  {
    BITCODE_B hookline_dir;
    if (dwg_dynapi_entity_value (leader, "LEADER", "hookline_dir", &hookline_dir, NULL)
        && hookline_dir == leader->hookline_dir)
      pass ();
    else
      fail ("LEADER.hookline_dir [B] " FORMAT_B " != " FORMAT_B "", leader->hookline_dir, hookline_dir);
    hookline_dir++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "hookline_dir", &hookline_dir, 0)
        && hookline_dir == leader->hookline_dir)
      pass ();
    else
      fail ("LEADER.hookline_dir [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->hookline_dir, hookline_dir);
    leader->hookline_dir--;

  }
  {
    BITCODE_B hookline_on;
    if (dwg_dynapi_entity_value (leader, "LEADER", "hookline_on", &hookline_on, NULL)
        && hookline_on == leader->hookline_on)
      pass ();
    else
      fail ("LEADER.hookline_on [B] " FORMAT_B " != " FORMAT_B "", leader->hookline_on, hookline_on);
    hookline_on++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "hookline_on", &hookline_on, 0)
        && hookline_on == leader->hookline_on)
      pass ();
    else
      fail ("LEADER.hookline_on [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->hookline_on, hookline_on);
    leader->hookline_on--;

  }
  {
    BITCODE_BL num_points;
    if (dwg_dynapi_entity_value (leader, "LEADER", "num_points", &num_points, NULL)
        && num_points == leader->num_points)
      pass ();
    else
      fail ("LEADER.num_points [BL] %u != %u", leader->num_points, num_points);
    num_points++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "num_points", &num_points, 0)
        && num_points == leader->num_points)
      pass ();
    else
      fail ("LEADER.num_points [BL] set+1 %u != %u", leader->num_points, num_points);
    leader->num_points--;

  }
  {
    BITCODE_3DPOINT offset_to_block_ins_pt;
    if (dwg_dynapi_entity_value (leader, "LEADER", "offset_to_block_ins_pt", &offset_to_block_ins_pt, NULL)
        && !memcmp (&offset_to_block_ins_pt, &leader->offset_to_block_ins_pt, sizeof (leader->offset_to_block_ins_pt)))
        pass ();
    else
        fail ("LEADER.offset_to_block_ins_pt [3DPOINT]");
  }
  {
    BITCODE_3DPOINT origin;
    if (dwg_dynapi_entity_value (leader, "LEADER", "origin", &origin, NULL)
        && !memcmp (&origin, &leader->origin, sizeof (leader->origin)))
        pass ();
    else
        fail ("LEADER.origin [3DPOINT]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (leader, "LEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &leader->parent, sizeof (leader->parent)))
        pass ();
    else
        fail ("LEADER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BS path_type;
    if (dwg_dynapi_entity_value (leader, "LEADER", "path_type", &path_type, NULL)
        && path_type == leader->path_type)
      pass ();
    else
      fail ("LEADER.path_type [BS] %hu != %hu", leader->path_type, path_type);
    path_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "path_type", &path_type, 0)
        && path_type == leader->path_type)
      pass ();
    else
      fail ("LEADER.path_type [BS] set+1 %hu != %hu", leader->path_type, path_type);
    leader->path_type--;

  }
  {
    BITCODE_3DPOINT* points;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (leader, "LEADER", "num_points", &count, NULL)
        && dwg_dynapi_entity_value (leader, "LEADER", "points", &points, NULL)
        && points == leader->points)
      pass ();
    else
      fail ("LEADER.points [3DPOINT*] * %u num_points", count);
  }
  {
    BITCODE_B unknown_bit_1;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_1", &unknown_bit_1, NULL)
        && unknown_bit_1 == leader->unknown_bit_1)
      pass ();
    else
      fail ("LEADER.unknown_bit_1 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_1, unknown_bit_1);
    unknown_bit_1++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_1", &unknown_bit_1, 0)
        && unknown_bit_1 == leader->unknown_bit_1)
      pass ();
    else
      fail ("LEADER.unknown_bit_1 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_1, unknown_bit_1);
    leader->unknown_bit_1--;

  }
  {
    BITCODE_B unknown_bit_2;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_2", &unknown_bit_2, NULL)
        && unknown_bit_2 == leader->unknown_bit_2)
      pass ();
    else
      fail ("LEADER.unknown_bit_2 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_2, unknown_bit_2);
    unknown_bit_2++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_2", &unknown_bit_2, 0)
        && unknown_bit_2 == leader->unknown_bit_2)
      pass ();
    else
      fail ("LEADER.unknown_bit_2 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_2, unknown_bit_2);
    leader->unknown_bit_2--;

  }
  {
    BITCODE_B unknown_bit_3;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_3", &unknown_bit_3, NULL)
        && unknown_bit_3 == leader->unknown_bit_3)
      pass ();
    else
      fail ("LEADER.unknown_bit_3 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_3, unknown_bit_3);
    unknown_bit_3++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_3", &unknown_bit_3, 0)
        && unknown_bit_3 == leader->unknown_bit_3)
      pass ();
    else
      fail ("LEADER.unknown_bit_3 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_3, unknown_bit_3);
    leader->unknown_bit_3--;

  }
  {
    BITCODE_B unknown_bit_5;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_5", &unknown_bit_5, NULL)
        && unknown_bit_5 == leader->unknown_bit_5)
      pass ();
    else
      fail ("LEADER.unknown_bit_5 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_5, unknown_bit_5);
    unknown_bit_5++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_5", &unknown_bit_5, 0)
        && unknown_bit_5 == leader->unknown_bit_5)
      pass ();
    else
      fail ("LEADER.unknown_bit_5 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_5, unknown_bit_5);
    leader->unknown_bit_5--;

  }
  {
    BITCODE_BS unknown_short_1;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_short_1", &unknown_short_1, NULL)
        && unknown_short_1 == leader->unknown_short_1)
      pass ();
    else
      fail ("LEADER.unknown_short_1 [BS] %hu != %hu", leader->unknown_short_1, unknown_short_1);
    unknown_short_1++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_short_1", &unknown_short_1, 0)
        && unknown_short_1 == leader->unknown_short_1)
      pass ();
    else
      fail ("LEADER.unknown_short_1 [BS] set+1 %hu != %hu", leader->unknown_short_1, unknown_short_1);
    leader->unknown_short_1--;

  }
  {
    BITCODE_3DPOINT x_direction;
    if (dwg_dynapi_entity_value (leader, "LEADER", "x_direction", &x_direction, NULL)
        && !memcmp (&x_direction, &leader->x_direction, sizeof (leader->x_direction)))
        pass ();
    else
        fail ("LEADER.x_direction [3DPOINT]");
  }
  return failed;
}
static int test_LIGHT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LIGHT *restrict light = obj->tio.entity->tio.LIGHT;
  {
    BITCODE_BD attenuation_end_limit;
    if (dwg_dynapi_entity_value (light, "LIGHT", "attenuation_end_limit", &attenuation_end_limit, NULL)
        && attenuation_end_limit == light->attenuation_end_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_end_limit [BD] %g != %g", light->attenuation_end_limit, attenuation_end_limit);
    attenuation_end_limit++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_end_limit", &attenuation_end_limit, 0)
        && attenuation_end_limit == light->attenuation_end_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_end_limit [BD] set+1 %g != %g", light->attenuation_end_limit, attenuation_end_limit);
    light->attenuation_end_limit--;

  }
  {
    BITCODE_BD attenuation_start_limit;
    if (dwg_dynapi_entity_value (light, "LIGHT", "attenuation_start_limit", &attenuation_start_limit, NULL)
        && attenuation_start_limit == light->attenuation_start_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_start_limit [BD] %g != %g", light->attenuation_start_limit, attenuation_start_limit);
    attenuation_start_limit++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_start_limit", &attenuation_start_limit, 0)
        && attenuation_start_limit == light->attenuation_start_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_start_limit [BD] set+1 %g != %g", light->attenuation_start_limit, attenuation_start_limit);
    light->attenuation_start_limit--;

  }
  {
    BITCODE_BS attenuation_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "attenuation_type", &attenuation_type, NULL)
        && attenuation_type == light->attenuation_type)
      pass ();
    else
      fail ("LIGHT.attenuation_type [BS] %hu != %hu", light->attenuation_type, attenuation_type);
    attenuation_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_type", &attenuation_type, 0)
        && attenuation_type == light->attenuation_type)
      pass ();
    else
      fail ("LIGHT.attenuation_type [BS] set+1 %hu != %hu", light->attenuation_type, attenuation_type);
    light->attenuation_type--;

  }
  {
    BITCODE_B cast_shadows;
    if (dwg_dynapi_entity_value (light, "LIGHT", "cast_shadows", &cast_shadows, NULL)
        && cast_shadows == light->cast_shadows)
      pass ();
    else
      fail ("LIGHT.cast_shadows [B] " FORMAT_B " != " FORMAT_B "", light->cast_shadows, cast_shadows);
    cast_shadows++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "cast_shadows", &cast_shadows, 0)
        && cast_shadows == light->cast_shadows)
      pass ();
    else
      fail ("LIGHT.cast_shadows [B] set+1 " FORMAT_B " != " FORMAT_B "", light->cast_shadows, cast_shadows);
    light->cast_shadows--;

  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (light, "LIGHT", "class_version", &class_version, NULL)
        && class_version == light->class_version)
      pass ();
    else
      fail ("LIGHT.class_version [BL] %u != %u", light->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "class_version", &class_version, 0)
        && class_version == light->class_version)
      pass ();
    else
      fail ("LIGHT.class_version [BL] set+1 %u != %u", light->class_version, class_version);
    light->class_version--;

  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (light, "LIGHT", "color", &color, NULL)
        && !memcmp (&color, &light->color, sizeof (light->color)))
        pass ();
    else
        fail ("LIGHT.color [CMC]");
  }
  {
    BITCODE_BD falloff_angle;
    if (dwg_dynapi_entity_value (light, "LIGHT", "falloff_angle", &falloff_angle, NULL)
        && falloff_angle == light->falloff_angle)
      pass ();
    else
      fail ("LIGHT.falloff_angle [BD] %g != %g", light->falloff_angle, falloff_angle);
    falloff_angle++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "falloff_angle", &falloff_angle, 0)
        && falloff_angle == light->falloff_angle)
      pass ();
    else
      fail ("LIGHT.falloff_angle [BD] set+1 %g != %g", light->falloff_angle, falloff_angle);
    light->falloff_angle--;

  }
  {
    BITCODE_BD hotspot_angle;
    if (dwg_dynapi_entity_value (light, "LIGHT", "hotspot_angle", &hotspot_angle, NULL)
        && hotspot_angle == light->hotspot_angle)
      pass ();
    else
      fail ("LIGHT.hotspot_angle [BD] %g != %g", light->hotspot_angle, hotspot_angle);
    hotspot_angle++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "hotspot_angle", &hotspot_angle, 0)
        && hotspot_angle == light->hotspot_angle)
      pass ();
    else
      fail ("LIGHT.hotspot_angle [BD] set+1 %g != %g", light->hotspot_angle, hotspot_angle);
    light->hotspot_angle--;

  }
  {
    BITCODE_BD intensity;
    if (dwg_dynapi_entity_value (light, "LIGHT", "intensity", &intensity, NULL)
        && intensity == light->intensity)
      pass ();
    else
      fail ("LIGHT.intensity [BD] %g != %g", light->intensity, intensity);
    intensity++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "intensity", &intensity, 0)
        && intensity == light->intensity)
      pass ();
    else
      fail ("LIGHT.intensity [BD] set+1 %g != %g", light->intensity, intensity);
    light->intensity--;

  }
  {
    BITCODE_H lights_layer;
    if (dwg_dynapi_entity_value (light, "LIGHT", "lights_layer", &lights_layer, NULL)
        && !memcmp (&lights_layer, &light->lights_layer, sizeof (light->lights_layer)))
        pass ();
    else
        fail ("LIGHT.lights_layer [H]");
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (light, "LIGHT", "name", &name, NULL)
        && !memcmp (&name, &light->name, sizeof (light->name)))
        pass ();
    else
        fail ("LIGHT.name [T]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (light, "LIGHT", "parent", &parent, NULL)
        && !memcmp (&parent, &light->parent, sizeof (light->parent)))
        pass ();
    else
        fail ("LIGHT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B plot_glyph;
    if (dwg_dynapi_entity_value (light, "LIGHT", "plot_glyph", &plot_glyph, NULL)
        && plot_glyph == light->plot_glyph)
      pass ();
    else
      fail ("LIGHT.plot_glyph [B] " FORMAT_B " != " FORMAT_B "", light->plot_glyph, plot_glyph);
    plot_glyph++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "plot_glyph", &plot_glyph, 0)
        && plot_glyph == light->plot_glyph)
      pass ();
    else
      fail ("LIGHT.plot_glyph [B] set+1 " FORMAT_B " != " FORMAT_B "", light->plot_glyph, plot_glyph);
    light->plot_glyph--;

  }
  {
    BITCODE_3BD position;
    if (dwg_dynapi_entity_value (light, "LIGHT", "position", &position, NULL)
        && !memcmp (&position, &light->position, sizeof (light->position)))
        pass ();
    else
        fail ("LIGHT.position [3BD]");
  }
  {
    BITCODE_BS shadow_map_size;
    if (dwg_dynapi_entity_value (light, "LIGHT", "shadow_map_size", &shadow_map_size, NULL)
        && shadow_map_size == light->shadow_map_size)
      pass ();
    else
      fail ("LIGHT.shadow_map_size [BS] %hu != %hu", light->shadow_map_size, shadow_map_size);
    shadow_map_size++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_map_size", &shadow_map_size, 0)
        && shadow_map_size == light->shadow_map_size)
      pass ();
    else
      fail ("LIGHT.shadow_map_size [BS] set+1 %hu != %hu", light->shadow_map_size, shadow_map_size);
    light->shadow_map_size--;

  }
  {
    BITCODE_RC shadow_map_softness;
    if (dwg_dynapi_entity_value (light, "LIGHT", "shadow_map_softness", &shadow_map_softness, NULL)
        && shadow_map_softness == light->shadow_map_softness)
      pass ();
    else
      fail ("LIGHT.shadow_map_softness [RC] %u != %u", light->shadow_map_softness, shadow_map_softness);
    shadow_map_softness++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_map_softness", &shadow_map_softness, 0)
        && shadow_map_softness == light->shadow_map_softness)
      pass ();
    else
      fail ("LIGHT.shadow_map_softness [RC] set+1 %u != %u", light->shadow_map_softness, shadow_map_softness);
    light->shadow_map_softness--;

  }
  {
    BITCODE_BS shadow_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "shadow_type", &shadow_type, NULL)
        && shadow_type == light->shadow_type)
      pass ();
    else
      fail ("LIGHT.shadow_type [BS] %hu != %hu", light->shadow_type, shadow_type);
    shadow_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_type", &shadow_type, 0)
        && shadow_type == light->shadow_type)
      pass ();
    else
      fail ("LIGHT.shadow_type [BS] set+1 %hu != %hu", light->shadow_type, shadow_type);
    light->shadow_type--;

  }
  {
    BITCODE_B status;
    if (dwg_dynapi_entity_value (light, "LIGHT", "status", &status, NULL)
        && status == light->status)
      pass ();
    else
      fail ("LIGHT.status [B] " FORMAT_B " != " FORMAT_B "", light->status, status);
    status++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "status", &status, 0)
        && status == light->status)
      pass ();
    else
      fail ("LIGHT.status [B] set+1 " FORMAT_B " != " FORMAT_B "", light->status, status);
    light->status--;

  }
  {
    BITCODE_3BD target;
    if (dwg_dynapi_entity_value (light, "LIGHT", "target", &target, NULL)
        && !memcmp (&target, &light->target, sizeof (light->target)))
        pass ();
    else
        fail ("LIGHT.target [3BD]");
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "type", &type, NULL)
        && type == light->type)
      pass ();
    else
      fail ("LIGHT.type [BS] %hu != %hu", light->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "type", &type, 0)
        && type == light->type)
      pass ();
    else
      fail ("LIGHT.type [BS] set+1 %hu != %hu", light->type, type);
    light->type--;

  }
  {
    BITCODE_B use_attenuation_limits;
    if (dwg_dynapi_entity_value (light, "LIGHT", "use_attenuation_limits", &use_attenuation_limits, NULL)
        && use_attenuation_limits == light->use_attenuation_limits)
      pass ();
    else
      fail ("LIGHT.use_attenuation_limits [B] " FORMAT_B " != " FORMAT_B "", light->use_attenuation_limits, use_attenuation_limits);
    use_attenuation_limits++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "use_attenuation_limits", &use_attenuation_limits, 0)
        && use_attenuation_limits == light->use_attenuation_limits)
      pass ();
    else
      fail ("LIGHT.use_attenuation_limits [B] set+1 " FORMAT_B " != " FORMAT_B "", light->use_attenuation_limits, use_attenuation_limits);
    light->use_attenuation_limits--;

  }
  return failed;
}
static int test_LINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LINE *restrict line = obj->tio.entity->tio.LINE;
  {
    BITCODE_3BD end;
    if (dwg_dynapi_entity_value (line, "LINE", "end", &end, NULL)
        && !memcmp (&end, &line->end, sizeof (line->end)))
        pass ();
    else
        fail ("LINE.end [3BD]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (line, "LINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &line->extrusion, sizeof (line->extrusion)))
        pass ();
    else
        fail ("LINE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (line, "LINE", "parent", &parent, NULL)
        && !memcmp (&parent, &line->parent, sizeof (line->parent)))
        pass ();
    else
        fail ("LINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD start;
    if (dwg_dynapi_entity_value (line, "LINE", "start", &start, NULL)
        && !memcmp (&start, &line->start, sizeof (line->start)))
        pass ();
    else
        fail ("LINE.start [3BD]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (line, "LINE", "thickness", &thickness, NULL)
        && thickness == line->thickness)
      pass ();
    else
      fail ("LINE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", line->thickness, thickness);
    if (dwg_dynapi_entity_set_value (line, "LINE", "thickness", &thickness, 0)
        && thickness == line->thickness)
      pass ();
    else
      fail ("LINE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", line->thickness, thickness);
    line->thickness--;

  }
  {
    BITCODE_RC z_is_zero;
    if (dwg_dynapi_entity_value (line, "LINE", "z_is_zero", &z_is_zero, NULL)
        && z_is_zero == line->z_is_zero)
      pass ();
    else
      fail ("LINE.z_is_zero [RC] %u != %u", line->z_is_zero, z_is_zero);
    z_is_zero++;
    if (dwg_dynapi_entity_set_value (line, "LINE", "z_is_zero", &z_is_zero, 0)
        && z_is_zero == line->z_is_zero)
      pass ();
    else
      fail ("LINE.z_is_zero [RC] set+1 %u != %u", line->z_is_zero, z_is_zero);
    line->z_is_zero--;

  }
  return failed;
}
static int test_LOFTEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LOFTEDSURFACE *restrict loftedsurface = obj->tio.entity->tio.LOFTEDSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)loftedsurface->acis_data)
           : !loftedsurface->acis_data)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, loftedsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == loftedsurface->acis_empty)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == loftedsurface->acis_empty)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty, acis_empty);
    loftedsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == loftedsurface->acis_empty2)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == loftedsurface->acis_empty2)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty2, acis_empty2);
    loftedsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == loftedsurface->acis_empty_bit)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == loftedsurface->acis_empty_bit)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty_bit, acis_empty_bit);
    loftedsurface->acis_empty_bit--;

  }
  {
    BITCODE_B align_direction;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "align_direction", &align_direction, NULL)
        && align_direction == loftedsurface->align_direction)
      pass ();
    else
      fail ("LOFTEDSURFACE.align_direction [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->align_direction, align_direction);
    align_direction++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "align_direction", &align_direction, 0)
        && align_direction == loftedsurface->align_direction)
      pass ();
    else
      fail ("LOFTEDSURFACE.align_direction [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->align_direction, align_direction);
    loftedsurface->align_direction--;

  }
  {
    BITCODE_B arc_length_parameterization;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "arc_length_parameterization", &arc_length_parameterization, NULL)
        && arc_length_parameterization == loftedsurface->arc_length_parameterization)
      pass ();
    else
      fail ("LOFTEDSURFACE.arc_length_parameterization [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->arc_length_parameterization, arc_length_parameterization);
    arc_length_parameterization++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "arc_length_parameterization", &arc_length_parameterization, 0)
        && arc_length_parameterization == loftedsurface->arc_length_parameterization)
      pass ();
    else
      fail ("LOFTEDSURFACE.arc_length_parameterization [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->arc_length_parameterization, arc_length_parameterization);
    loftedsurface->arc_length_parameterization--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &loftedsurface->block_size, sizeof (loftedsurface->block_size)))
        pass ();
    else
        fail ("LOFTEDSURFACE.block_size [BL*]");
  }
  {
    BITCODE_B closed_surfaces;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "closed_surfaces", &closed_surfaces, NULL)
        && closed_surfaces == loftedsurface->closed_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.closed_surfaces [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->closed_surfaces, closed_surfaces);
    closed_surfaces++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "closed_surfaces", &closed_surfaces, 0)
        && closed_surfaces == loftedsurface->closed_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.closed_surfaces [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->closed_surfaces, closed_surfaces);
    loftedsurface->closed_surfaces--;

  }
  {
    BITCODE_H* cross_sections;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "cross_sections", &cross_sections, NULL)
        && cross_sections == loftedsurface->cross_sections)
      pass ();
    else
      fail ("LOFTEDSURFACE.cross_sections [H*] * %u num_cross_sections", count);
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &loftedsurface->encr_sat_data, sizeof (loftedsurface->encr_sat_data)))
      pass ();
    else
      fail ("LOFTEDSURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BD end_draft_angle;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "end_draft_angle", &end_draft_angle, NULL)
        && end_draft_angle == loftedsurface->end_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_angle [BD] %g != %g", loftedsurface->end_draft_angle, end_draft_angle);
    end_draft_angle++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_draft_angle", &end_draft_angle, 0)
        && end_draft_angle == loftedsurface->end_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_angle [BD] set+1 %g != %g", loftedsurface->end_draft_angle, end_draft_angle);
    loftedsurface->end_draft_angle--;

  }
  {
    BITCODE_BD end_draft_magnitude;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "end_draft_magnitude", &end_draft_magnitude, NULL)
        && end_draft_magnitude == loftedsurface->end_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_magnitude [BD] %g != %g", loftedsurface->end_draft_magnitude, end_draft_magnitude);
    end_draft_magnitude++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_draft_magnitude", &end_draft_magnitude, 0)
        && end_draft_magnitude == loftedsurface->end_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_magnitude [BD] set+1 %g != %g", loftedsurface->end_draft_magnitude, end_draft_magnitude);
    loftedsurface->end_draft_magnitude--;

  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &loftedsurface->extra_acis_data, sizeof (loftedsurface->extra_acis_data)))
        pass ();
    else
        fail ("LOFTEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_H* guide_curves;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "guide_curves", &guide_curves, NULL)
        && guide_curves == loftedsurface->guide_curves)
      pass ();
    else
      fail ("LOFTEDSURFACE.guide_curves [H*] * %u num_guide_curves", count);
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &loftedsurface->history_id, sizeof (loftedsurface->history_id)))
        pass ();
    else
        fail ("LOFTEDSURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == loftedsurface->isoline_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == loftedsurface->isoline_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->isoline_present, isoline_present);
    loftedsurface->isoline_present--;

  }
  {
    BITCODE_BD* loft_entity_transmatrix;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "loft_entity_transmatrix", &loft_entity_transmatrix, NULL)
        && !memcmp (&loft_entity_transmatrix, &loftedsurface->loft_entity_transmatrix, sizeof (loftedsurface->loft_entity_transmatrix)))
        pass ();
    else
        fail ("LOFTEDSURFACE.loft_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == loftedsurface->modeler_format_version)
      pass ();
    else
      fail ("LOFTEDSURFACE.modeler_format_version [BS] %hu != %hu", loftedsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == loftedsurface->modeler_format_version)
      pass ();
    else
      fail ("LOFTEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", loftedsurface->modeler_format_version, modeler_format_version);
    loftedsurface->modeler_format_version--;

  }
  {
    BITCODE_B no_twist;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "no_twist", &no_twist, NULL)
        && no_twist == loftedsurface->no_twist)
      pass ();
    else
      fail ("LOFTEDSURFACE.no_twist [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->no_twist, no_twist);
    no_twist++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "no_twist", &no_twist, 0)
        && no_twist == loftedsurface->no_twist)
      pass ();
    else
      fail ("LOFTEDSURFACE.no_twist [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->no_twist, no_twist);
    loftedsurface->no_twist--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == loftedsurface->num_blocks)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_blocks [BL] %u != %u", loftedsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == loftedsurface->num_blocks)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_blocks [BL] set+1 %u != %u", loftedsurface->num_blocks, num_blocks);
    loftedsurface->num_blocks--;

  }
  {
    BITCODE_BS num_cross_sections;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &num_cross_sections, NULL)
        && num_cross_sections == loftedsurface->num_cross_sections)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_cross_sections [BS] %hu != %hu", loftedsurface->num_cross_sections, num_cross_sections);
    num_cross_sections++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &num_cross_sections, 0)
        && num_cross_sections == loftedsurface->num_cross_sections)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_cross_sections [BS] set+1 %hu != %hu", loftedsurface->num_cross_sections, num_cross_sections);
    loftedsurface->num_cross_sections--;

  }
  {
    BITCODE_BS num_guide_curves;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &num_guide_curves, NULL)
        && num_guide_curves == loftedsurface->num_guide_curves)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_guide_curves [BS] %hu != %hu", loftedsurface->num_guide_curves, num_guide_curves);
    num_guide_curves++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &num_guide_curves, 0)
        && num_guide_curves == loftedsurface->num_guide_curves)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_guide_curves [BS] set+1 %hu != %hu", loftedsurface->num_guide_curves, num_guide_curves);
    loftedsurface->num_guide_curves--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == loftedsurface->num_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_isolines [BL] %u != %u", loftedsurface->num_isolines, num_isolines);
    num_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_isolines", &num_isolines, 0)
        && num_isolines == loftedsurface->num_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_isolines [BL] set+1 %u != %u", loftedsurface->num_isolines, num_isolines);
    loftedsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == loftedsurface->num_silhouettes)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_silhouettes [BL] %u != %u", loftedsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == loftedsurface->num_silhouettes)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_silhouettes [BL] set+1 %u != %u", loftedsurface->num_silhouettes, num_silhouettes);
    loftedsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == loftedsurface->num_wires)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_wires [BL] %u != %u", loftedsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &num_wires, 0)
        && num_wires == loftedsurface->num_wires)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_wires [BL] set+1 %u != %u", loftedsurface->num_wires, num_wires);
    loftedsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &loftedsurface->parent, sizeof (loftedsurface->parent)))
        pass ();
    else
        fail ("LOFTEDSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H path_curve;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "path_curve", &path_curve, NULL)
        && !memcmp (&path_curve, &loftedsurface->path_curve, sizeof (loftedsurface->path_curve)))
        pass ();
    else
        fail ("LOFTEDSURFACE.path_curve [H]");
  }
  {
    BITCODE_BL plane_normal_lofting_type;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "plane_normal_lofting_type", &plane_normal_lofting_type, NULL)
        && plane_normal_lofting_type == loftedsurface->plane_normal_lofting_type)
      pass ();
    else
      fail ("LOFTEDSURFACE.plane_normal_lofting_type [BL] %u != %u", loftedsurface->plane_normal_lofting_type, plane_normal_lofting_type);
    plane_normal_lofting_type++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "plane_normal_lofting_type", &plane_normal_lofting_type, 0)
        && plane_normal_lofting_type == loftedsurface->plane_normal_lofting_type)
      pass ();
    else
      fail ("LOFTEDSURFACE.plane_normal_lofting_type [BL] set+1 %u != %u", loftedsurface->plane_normal_lofting_type, plane_normal_lofting_type);
    loftedsurface->plane_normal_lofting_type--;

  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &loftedsurface->point, sizeof (loftedsurface->point)))
        pass ();
    else
        fail ("LOFTEDSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "point_present", &point_present, NULL)
        && point_present == loftedsurface->point_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "point_present", &point_present, 0)
        && point_present == loftedsurface->point_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->point_present, point_present);
    loftedsurface->point_present--;

  }
  {
    BITCODE_B ruled_surface;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "ruled_surface", &ruled_surface, NULL)
        && ruled_surface == loftedsurface->ruled_surface)
      pass ();
    else
      fail ("LOFTEDSURFACE.ruled_surface [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->ruled_surface, ruled_surface);
    ruled_surface++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "ruled_surface", &ruled_surface, 0)
        && ruled_surface == loftedsurface->ruled_surface)
      pass ();
    else
      fail ("LOFTEDSURFACE.ruled_surface [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->ruled_surface, ruled_surface);
    loftedsurface->ruled_surface--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == loftedsurface->silhouettes)
      pass ();
    else
      fail ("LOFTEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_B simple_surfaces;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "simple_surfaces", &simple_surfaces, NULL)
        && simple_surfaces == loftedsurface->simple_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.simple_surfaces [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->simple_surfaces, simple_surfaces);
    simple_surfaces++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "simple_surfaces", &simple_surfaces, 0)
        && simple_surfaces == loftedsurface->simple_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.simple_surfaces [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->simple_surfaces, simple_surfaces);
    loftedsurface->simple_surfaces--;

  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "solid", &solid, NULL)
        && solid == loftedsurface->solid)
      pass ();
    else
      fail ("LOFTEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->solid, solid);
    solid++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "solid", &solid, 0)
        && solid == loftedsurface->solid)
      pass ();
    else
      fail ("LOFTEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->solid, solid);
    loftedsurface->solid--;

  }
  {
    BITCODE_BD start_draft_angle;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "start_draft_angle", &start_draft_angle, NULL)
        && start_draft_angle == loftedsurface->start_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_angle [BD] %g != %g", loftedsurface->start_draft_angle, start_draft_angle);
    start_draft_angle++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "start_draft_angle", &start_draft_angle, 0)
        && start_draft_angle == loftedsurface->start_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_angle [BD] set+1 %g != %g", loftedsurface->start_draft_angle, start_draft_angle);
    loftedsurface->start_draft_angle--;

  }
  {
    BITCODE_BD start_draft_magnitude;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "start_draft_magnitude", &start_draft_magnitude, NULL)
        && start_draft_magnitude == loftedsurface->start_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_magnitude [BD] %g != %g", loftedsurface->start_draft_magnitude, start_draft_magnitude);
    start_draft_magnitude++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "start_draft_magnitude", &start_draft_magnitude, 0)
        && start_draft_magnitude == loftedsurface->start_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_magnitude [BD] set+1 %g != %g", loftedsurface->start_draft_magnitude, start_draft_magnitude);
    loftedsurface->start_draft_magnitude--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == loftedsurface->u_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.u_isolines [BS] %hu != %hu", loftedsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == loftedsurface->u_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.u_isolines [BS] set+1 %hu != %hu", loftedsurface->u_isolines, u_isolines);
    loftedsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "unknown", &unknown, NULL)
        && unknown == loftedsurface->unknown)
      pass ();
    else
      fail ("LOFTEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "unknown", &unknown, 0)
        && unknown == loftedsurface->unknown)
      pass ();
    else
      fail ("LOFTEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->unknown, unknown);
    loftedsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == loftedsurface->unknown_2007)
      pass ();
    else
      fail ("LOFTEDSURFACE.unknown_2007 [BL] %u != %u", loftedsurface->unknown_2007, unknown_2007);
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "unknown_2007", &unknown_2007, 0)
        && unknown_2007 == loftedsurface->unknown_2007)
      pass ();
    else
      fail ("LOFTEDSURFACE.unknown_2007 [BL] set+1 %u != %u", loftedsurface->unknown_2007, unknown_2007);
    loftedsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == loftedsurface->v_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.v_isolines [BS] %hu != %hu", loftedsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == loftedsurface->v_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.v_isolines [BS] set+1 %hu != %hu", loftedsurface->v_isolines, v_isolines);
    loftedsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "version", &version, NULL)
        && version == loftedsurface->version)
      pass ();
    else
      fail ("LOFTEDSURFACE.version [BS] %hu != %hu", loftedsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "version", &version, 0)
        && version == loftedsurface->version)
      pass ();
    else
      fail ("LOFTEDSURFACE.version [BS] set+1 %hu != %hu", loftedsurface->version, version);
    loftedsurface->version--;

  }
  {
    BITCODE_B virtual_guide;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "virtual_guide", &virtual_guide, NULL)
        && virtual_guide == loftedsurface->virtual_guide)
      pass ();
    else
      fail ("LOFTEDSURFACE.virtual_guide [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->virtual_guide, virtual_guide);
    virtual_guide++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "virtual_guide", &virtual_guide, 0)
        && virtual_guide == loftedsurface->virtual_guide)
      pass ();
    else
      fail ("LOFTEDSURFACE.virtual_guide [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->virtual_guide, virtual_guide);
    loftedsurface->virtual_guide--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == loftedsurface->wireframe_data_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == loftedsurface->wireframe_data_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->wireframe_data_present, wireframe_data_present);
    loftedsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "wires", &wires, NULL)
        && wires == loftedsurface->wires)
      pass ();
    else
      fail ("LOFTEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  return failed;
}
static int test_LWPOLYLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LWPOLYLINE *restrict lwpolyline = obj->tio.entity->tio.LWPOLYLINE;
  {
    BITCODE_BD* bulges;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_bulges", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "bulges", &bulges, NULL)
        && bulges == lwpolyline->bulges)
      pass ();
    else
      fail ("LWPOLYLINE.bulges [BD*] * %u num_bulges", count);
  }
  {
    BITCODE_BD const_width;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "const_width", &const_width, NULL)
        && const_width == lwpolyline->const_width)
      pass ();
    else
      fail ("LWPOLYLINE.const_width [BD] %g != %g", lwpolyline->const_width, const_width);
    const_width++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "const_width", &const_width, 0)
        && const_width == lwpolyline->const_width)
      pass ();
    else
      fail ("LWPOLYLINE.const_width [BD] set+1 %g != %g", lwpolyline->const_width, const_width);
    lwpolyline->const_width--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "elevation", &elevation, NULL)
        && elevation == lwpolyline->elevation)
      pass ();
    else
      fail ("LWPOLYLINE.elevation [BD] %g != %g", lwpolyline->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "elevation", &elevation, 0)
        && elevation == lwpolyline->elevation)
      pass ();
    else
      fail ("LWPOLYLINE.elevation [BD] set+1 %g != %g", lwpolyline->elevation, elevation);
    lwpolyline->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &lwpolyline->extrusion, sizeof (lwpolyline->extrusion)))
        pass ();
    else
        fail ("LWPOLYLINE.extrusion [BE]");
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "flag", &flag, NULL)
        && flag == lwpolyline->flag)
      pass ();
    else
      fail ("LWPOLYLINE.flag [BS] %hu != %hu", lwpolyline->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "flag", &flag, 0)
        && flag == lwpolyline->flag)
      pass ();
    else
      fail ("LWPOLYLINE.flag [BS] set+1 %hu != %hu", lwpolyline->flag, flag);
    lwpolyline->flag--;

  }
  {
    BITCODE_BL num_bulges;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_bulges", &num_bulges, NULL)
        && num_bulges == lwpolyline->num_bulges)
      pass ();
    else
      fail ("LWPOLYLINE.num_bulges [BL] %u != %u", lwpolyline->num_bulges, num_bulges);
    num_bulges++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_bulges", &num_bulges, 0)
        && num_bulges == lwpolyline->num_bulges)
      pass ();
    else
      fail ("LWPOLYLINE.num_bulges [BL] set+1 %u != %u", lwpolyline->num_bulges, num_bulges);
    lwpolyline->num_bulges--;

  }
  {
    BITCODE_BL num_points;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_points", &num_points, NULL)
        && num_points == lwpolyline->num_points)
      pass ();
    else
      fail ("LWPOLYLINE.num_points [BL] %u != %u", lwpolyline->num_points, num_points);
    num_points++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_points", &num_points, 0)
        && num_points == lwpolyline->num_points)
      pass ();
    else
      fail ("LWPOLYLINE.num_points [BL] set+1 %u != %u", lwpolyline->num_points, num_points);
    lwpolyline->num_points--;

  }
  {
    BITCODE_BL num_vertexids;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &num_vertexids, NULL)
        && num_vertexids == lwpolyline->num_vertexids)
      pass ();
    else
      fail ("LWPOLYLINE.num_vertexids [BL] %u != %u", lwpolyline->num_vertexids, num_vertexids);
    num_vertexids++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &num_vertexids, 0)
        && num_vertexids == lwpolyline->num_vertexids)
      pass ();
    else
      fail ("LWPOLYLINE.num_vertexids [BL] set+1 %u != %u", lwpolyline->num_vertexids, num_vertexids);
    lwpolyline->num_vertexids--;

  }
  {
    BITCODE_BL num_widths;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_widths", &num_widths, NULL)
        && num_widths == lwpolyline->num_widths)
      pass ();
    else
      fail ("LWPOLYLINE.num_widths [BL] %u != %u", lwpolyline->num_widths, num_widths);
    num_widths++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_widths", &num_widths, 0)
        && num_widths == lwpolyline->num_widths)
      pass ();
    else
      fail ("LWPOLYLINE.num_widths [BL] set+1 %u != %u", lwpolyline->num_widths, num_widths);
    lwpolyline->num_widths--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &lwpolyline->parent, sizeof (lwpolyline->parent)))
        pass ();
    else
        fail ("LWPOLYLINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD* points;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_points", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "points", &points, NULL)
        && points == lwpolyline->points)
      pass ();
    else
      fail ("LWPOLYLINE.points [2RD*] * %u num_points", count);
  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "thickness", &thickness, NULL)
        && thickness == lwpolyline->thickness)
      pass ();
    else
      fail ("LWPOLYLINE.thickness [BD] %g != %g", lwpolyline->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "thickness", &thickness, 0)
        && thickness == lwpolyline->thickness)
      pass ();
    else
      fail ("LWPOLYLINE.thickness [BD] set+1 %g != %g", lwpolyline->thickness, thickness);
    lwpolyline->thickness--;

  }
  {
    BITCODE_BL* vertexids;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "vertexids", &vertexids, NULL)
        && vertexids == lwpolyline->vertexids)
      pass ();
    else
      fail ("LWPOLYLINE.vertexids [BL*] * %u num_vertexids", count);
  }
  {
    Dwg_LWPOLYLINE_width* widths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_widths", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "widths", &widths, NULL)
        && widths == lwpolyline->widths)
      pass ();
    else
      fail ("LWPOLYLINE.widths [Dwg_LWPOLYLINE_width*] * %u num_widths", count);
  }
  return failed;
}
static int test_MESH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MESH *restrict mesh = obj->tio.entity->tio.MESH;
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (mesh, "MESH", "class_version", &class_version, NULL)
        && class_version == mesh->class_version)
      pass ();
    else
      fail ("MESH.class_version [BL] %u != %u", mesh->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "class_version", &class_version, 0)
        && class_version == mesh->class_version)
      pass ();
    else
      fail ("MESH.class_version [BL] set+1 %u != %u", mesh->class_version, class_version);
    mesh->class_version--;

  }
  {
    BITCODE_BD* crease;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_crease", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "crease", &crease, NULL)
        && crease == mesh->crease)
      pass ();
    else
      fail ("MESH.crease [BD*] * %u num_crease", count);
  }
  {
    BITCODE_RC dlevel;
    if (dwg_dynapi_entity_value (mesh, "MESH", "dlevel", &dlevel, NULL)
        && dlevel == mesh->dlevel)
      pass ();
    else
      fail ("MESH.dlevel [RC] %u != %u", mesh->dlevel, dlevel);
    dlevel++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "dlevel", &dlevel, 0)
        && dlevel == mesh->dlevel)
      pass ();
    else
      fail ("MESH.dlevel [RC] set+1 %u != %u", mesh->dlevel, dlevel);
    mesh->dlevel--;

  }
  {
    Dwg_MESH_edge* edges;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_edges", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "edges", &edges, NULL)
        && edges == mesh->edges)
      pass ();
    else
      fail ("MESH.edges [Dwg_MESH_edge*] * %u num_edges", count);
  }
  {
    BITCODE_BL* faces;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_faces", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "faces", &faces, NULL)
        && faces == mesh->faces)
      pass ();
    else
      fail ("MESH.faces [BL*] * %u num_faces", count);
  }
  {
    BITCODE_RC is_watertight;
    if (dwg_dynapi_entity_value (mesh, "MESH", "is_watertight", &is_watertight, NULL)
        && is_watertight == mesh->is_watertight)
      pass ();
    else
      fail ("MESH.is_watertight [RC] %u != %u", mesh->is_watertight, is_watertight);
    is_watertight++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "is_watertight", &is_watertight, 0)
        && is_watertight == mesh->is_watertight)
      pass ();
    else
      fail ("MESH.is_watertight [RC] set+1 %u != %u", mesh->is_watertight, is_watertight);
    mesh->is_watertight--;

  }
  {
    BITCODE_BL num_crease;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_crease", &num_crease, NULL)
        && num_crease == mesh->num_crease)
      pass ();
    else
      fail ("MESH.num_crease [BL] %u != %u", mesh->num_crease, num_crease);
    num_crease++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_crease", &num_crease, 0)
        && num_crease == mesh->num_crease)
      pass ();
    else
      fail ("MESH.num_crease [BL] set+1 %u != %u", mesh->num_crease, num_crease);
    mesh->num_crease--;

  }
  {
    BITCODE_BL num_edges;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_edges", &num_edges, NULL)
        && num_edges == mesh->num_edges)
      pass ();
    else
      fail ("MESH.num_edges [BL] %u != %u", mesh->num_edges, num_edges);
    num_edges++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_edges", &num_edges, 0)
        && num_edges == mesh->num_edges)
      pass ();
    else
      fail ("MESH.num_edges [BL] set+1 %u != %u", mesh->num_edges, num_edges);
    mesh->num_edges--;

  }
  {
    BITCODE_BL num_faces;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_faces", &num_faces, NULL)
        && num_faces == mesh->num_faces)
      pass ();
    else
      fail ("MESH.num_faces [BL] %u != %u", mesh->num_faces, num_faces);
    num_faces++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_faces", &num_faces, 0)
        && num_faces == mesh->num_faces)
      pass ();
    else
      fail ("MESH.num_faces [BL] set+1 %u != %u", mesh->num_faces, num_faces);
    mesh->num_faces--;

  }
  {
    BITCODE_BL num_subdiv_vertex;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_subdiv_vertex", &num_subdiv_vertex, NULL)
        && num_subdiv_vertex == mesh->num_subdiv_vertex)
      pass ();
    else
      fail ("MESH.num_subdiv_vertex [BL] %u != %u", mesh->num_subdiv_vertex, num_subdiv_vertex);
    num_subdiv_vertex++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_subdiv_vertex", &num_subdiv_vertex, 0)
        && num_subdiv_vertex == mesh->num_subdiv_vertex)
      pass ();
    else
      fail ("MESH.num_subdiv_vertex [BL] set+1 %u != %u", mesh->num_subdiv_vertex, num_subdiv_vertex);
    mesh->num_subdiv_vertex--;

  }
  {
    BITCODE_BL num_vertex;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_vertex", &num_vertex, NULL)
        && num_vertex == mesh->num_vertex)
      pass ();
    else
      fail ("MESH.num_vertex [BL] %u != %u", mesh->num_vertex, num_vertex);
    num_vertex++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_vertex", &num_vertex, 0)
        && num_vertex == mesh->num_vertex)
      pass ();
    else
      fail ("MESH.num_vertex [BL] set+1 %u != %u", mesh->num_vertex, num_vertex);
    mesh->num_vertex--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mesh, "MESH", "parent", &parent, NULL)
        && !memcmp (&parent, &mesh->parent, sizeof (mesh->parent)))
        pass ();
    else
        fail ("MESH.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD* subdiv_vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_subdiv_vertex", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "subdiv_vertex", &subdiv_vertex, NULL)
        && subdiv_vertex == mesh->subdiv_vertex)
      pass ();
    else
      fail ("MESH.subdiv_vertex [3BD*] * %u num_subdiv_vertex", count);
  }
  {
    BITCODE_3BD* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "vertex", &vertex, NULL)
        && vertex == mesh->vertex)
      pass ();
    else
      fail ("MESH.vertex [3BD*] * %u num_owned", count);
  }
  return failed;
}
static int test_MINSERT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MINSERT *restrict minsert = obj->tio.entity->tio.MINSERT;
  {
    BITCODE_H* attrib_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (minsert, "MINSERT", "attrib_handles", &attrib_handles, NULL)
        && attrib_handles == minsert->attrib_handles)
      pass ();
    else
      fail ("MINSERT.attrib_handles [H*] * %u num_owned", count);
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &minsert->block_header, sizeof (minsert->block_header)))
        pass ();
    else
        fail ("MINSERT.block_header [H]");
  }
  {
    BITCODE_BD col_spacing;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "col_spacing", &col_spacing, NULL)
        && col_spacing == minsert->col_spacing)
      pass ();
    else
      fail ("MINSERT.col_spacing [BD] %g != %g", minsert->col_spacing, col_spacing);
    col_spacing++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "col_spacing", &col_spacing, 0)
        && col_spacing == minsert->col_spacing)
      pass ();
    else
      fail ("MINSERT.col_spacing [BD] set+1 %g != %g", minsert->col_spacing, col_spacing);
    minsert->col_spacing--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &minsert->extrusion, sizeof (minsert->extrusion)))
        pass ();
    else
        fail ("MINSERT.extrusion [BE]");
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &minsert->first_attrib, sizeof (minsert->first_attrib)))
        pass ();
    else
        fail ("MINSERT.first_attrib [H]");
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "has_attribs", &has_attribs, NULL)
        && has_attribs == minsert->has_attribs)
      pass ();
    else
      fail ("MINSERT.has_attribs [B] " FORMAT_B " != " FORMAT_B "", minsert->has_attribs, has_attribs);
    has_attribs++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "has_attribs", &has_attribs, 0)
        && has_attribs == minsert->has_attribs)
      pass ();
    else
      fail ("MINSERT.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", minsert->has_attribs, has_attribs);
    minsert->has_attribs--;

  }
  {
    BITCODE_3DPOINT ins_pt;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &minsert->ins_pt, sizeof (minsert->ins_pt)))
        pass ();
    else
        fail ("MINSERT.ins_pt [3DPOINT]");
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &minsert->last_attrib, sizeof (minsert->last_attrib)))
        pass ();
    else
        fail ("MINSERT.last_attrib [H]");
  }
  {
    BITCODE_BS num_cols;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_cols", &num_cols, NULL)
        && num_cols == minsert->num_cols)
      pass ();
    else
      fail ("MINSERT.num_cols [BS] %hu != %hu", minsert->num_cols, num_cols);
    num_cols++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_cols", &num_cols, 0)
        && num_cols == minsert->num_cols)
      pass ();
    else
      fail ("MINSERT.num_cols [BS] set+1 %hu != %hu", minsert->num_cols, num_cols);
    minsert->num_cols--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_owned", &num_owned, NULL)
        && num_owned == minsert->num_owned)
      pass ();
    else
      fail ("MINSERT.num_owned [BL] %u != %u", minsert->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_owned", &num_owned, 0)
        && num_owned == minsert->num_owned)
      pass ();
    else
      fail ("MINSERT.num_owned [BL] set+1 %u != %u", minsert->num_owned, num_owned);
    minsert->num_owned--;

  }
  {
    BITCODE_BS num_rows;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_rows", &num_rows, NULL)
        && num_rows == minsert->num_rows)
      pass ();
    else
      fail ("MINSERT.num_rows [BS] %hu != %hu", minsert->num_rows, num_rows);
    num_rows++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_rows", &num_rows, 0)
        && num_rows == minsert->num_rows)
      pass ();
    else
      fail ("MINSERT.num_rows [BS] set+1 %hu != %hu", minsert->num_rows, num_rows);
    minsert->num_rows--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "parent", &parent, NULL)
        && !memcmp (&parent, &minsert->parent, sizeof (minsert->parent)))
        pass ();
    else
        fail ("MINSERT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "rotation", &rotation, NULL)
        && rotation == minsert->rotation)
      pass ();
    else
      fail ("MINSERT.rotation [BD] %g != %g", minsert->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "rotation", &rotation, 0)
        && rotation == minsert->rotation)
      pass ();
    else
      fail ("MINSERT.rotation [BD] set+1 %g != %g", minsert->rotation, rotation);
    minsert->rotation--;

  }
  {
    BITCODE_BD row_spacing;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "row_spacing", &row_spacing, NULL)
        && row_spacing == minsert->row_spacing)
      pass ();
    else
      fail ("MINSERT.row_spacing [BD] %g != %g", minsert->row_spacing, row_spacing);
    row_spacing++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "row_spacing", &row_spacing, 0)
        && row_spacing == minsert->row_spacing)
      pass ();
    else
      fail ("MINSERT.row_spacing [BD] set+1 %g != %g", minsert->row_spacing, row_spacing);
    minsert->row_spacing--;

  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "scale", &scale, NULL)
        && !memcmp (&scale, &minsert->scale, sizeof (minsert->scale)))
        pass ();
    else
        fail ("MINSERT.scale [3BD_1]");
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "scale_flag", &scale_flag, NULL)
        && scale_flag == minsert->scale_flag)
      pass ();
    else
      fail ("MINSERT.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", minsert->scale_flag, scale_flag);
    scale_flag++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "scale_flag", &scale_flag, 0)
        && scale_flag == minsert->scale_flag)
      pass ();
    else
      fail ("MINSERT.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", minsert->scale_flag, scale_flag);
    minsert->scale_flag--;

  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &minsert->seqend, sizeof (minsert->seqend)))
        pass ();
    else
        fail ("MINSERT.seqend [H]");
  }
  return failed;
}
static int test_MLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MLINE *restrict mline = obj->tio.entity->tio.MLINE;
  {
    BITCODE_3BD base_point;
    if (dwg_dynapi_entity_value (mline, "MLINE", "base_point", &base_point, NULL)
        && !memcmp (&base_point, &mline->base_point, sizeof (mline->base_point)))
        pass ();
    else
        fail ("MLINE.base_point [3BD]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (mline, "MLINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mline->extrusion, sizeof (mline->extrusion)))
        pass ();
    else
        fail ("MLINE.extrusion [BE]");
  }
  {
    BITCODE_BS flags;
    if (dwg_dynapi_entity_value (mline, "MLINE", "flags", &flags, NULL)
        && flags == mline->flags)
      pass ();
    else
      fail ("MLINE.flags [BS] %hu != %hu", mline->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "flags", &flags, 0)
        && flags == mline->flags)
      pass ();
    else
      fail ("MLINE.flags [BS] set+1 %hu != %hu", mline->flags, flags);
    mline->flags--;

  }
  {
    BITCODE_RC justification;
    if (dwg_dynapi_entity_value (mline, "MLINE", "justification", &justification, NULL)
        && justification == mline->justification)
      pass ();
    else
      fail ("MLINE.justification [RC] %u != %u", mline->justification, justification);
    justification++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "justification", &justification, 0)
        && justification == mline->justification)
      pass ();
    else
      fail ("MLINE.justification [RC] set+1 %u != %u", mline->justification, justification);
    mline->justification--;

  }
  {
    BITCODE_H mlinestyle;
    if (dwg_dynapi_entity_value (mline, "MLINE", "mlinestyle", &mlinestyle, NULL)
        && !memcmp (&mlinestyle, &mline->mlinestyle, sizeof (mline->mlinestyle)))
        pass ();
    else
        fail ("MLINE.mlinestyle [H]");
  }
  {
    BITCODE_RC num_lines;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_lines", &num_lines, NULL)
        && num_lines == mline->num_lines)
      pass ();
    else
      fail ("MLINE.num_lines [RC] %u != %u", mline->num_lines, num_lines);
    num_lines++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "num_lines", &num_lines, 0)
        && num_lines == mline->num_lines)
      pass ();
    else
      fail ("MLINE.num_lines [RC] set+1 %u != %u", mline->num_lines, num_lines);
    mline->num_lines--;

  }
  {
    BITCODE_BS num_verts;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_verts", &num_verts, NULL)
        && num_verts == mline->num_verts)
      pass ();
    else
      fail ("MLINE.num_verts [BS] %hu != %hu", mline->num_verts, num_verts);
    num_verts++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "num_verts", &num_verts, 0)
        && num_verts == mline->num_verts)
      pass ();
    else
      fail ("MLINE.num_verts [BS] set+1 %hu != %hu", mline->num_verts, num_verts);
    mline->num_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mline, "MLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &mline->parent, sizeof (mline->parent)))
        pass ();
    else
        fail ("MLINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD scale;
    if (dwg_dynapi_entity_value (mline, "MLINE", "scale", &scale, NULL)
        && scale == mline->scale)
      pass ();
    else
      fail ("MLINE.scale [BD] %g != %g", mline->scale, scale);
    scale++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "scale", &scale, 0)
        && scale == mline->scale)
      pass ();
    else
      fail ("MLINE.scale [BD] set+1 %g != %g", mline->scale, scale);
    mline->scale--;

  }
  {
    Dwg_MLINE_vertex* verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_verts", &count, NULL)
        && dwg_dynapi_entity_value (mline, "MLINE", "verts", &verts, NULL)
        && verts == mline->verts)
      pass ();
    else
      fail ("MLINE.verts [Dwg_MLINE_vertex*] * %u num_verts", count);
  }
  return failed;
}
static int test_MTEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MTEXT *restrict mtext = obj->tio.entity->tio.MTEXT;
  {
    BITCODE_B annotative;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "annotative", &annotative, NULL)
        && annotative == mtext->annotative)
      pass ();
    else
      fail ("MTEXT.annotative [B] " FORMAT_B " != " FORMAT_B "", mtext->annotative, annotative);
    annotative++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "annotative", &annotative, 0)
        && annotative == mtext->annotative)
      pass ();
    else
      fail ("MTEXT.annotative [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->annotative, annotative);
    mtext->annotative--;

  }
  {
    BITCODE_H appid;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "appid", &appid, NULL)
        && !memcmp (&appid, &mtext->appid, sizeof (mtext->appid)))
        pass ();
    else
        fail ("MTEXT.appid [H]");
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "attachment", &attachment, NULL)
        && attachment == mtext->attachment)
      pass ();
    else
      fail ("MTEXT.attachment [BS] %hu != %hu", mtext->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "attachment", &attachment, 0)
        && attachment == mtext->attachment)
      pass ();
    else
      fail ("MTEXT.attachment [BS] set+1 %hu != %hu", mtext->attachment, attachment);
    mtext->attachment--;

  }
  {
    BITCODE_B auto_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "auto_height", &auto_height, NULL)
        && auto_height == mtext->auto_height)
      pass ();
    else
      fail ("MTEXT.auto_height [B] " FORMAT_B " != " FORMAT_B "", mtext->auto_height, auto_height);
    auto_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "auto_height", &auto_height, 0)
        && auto_height == mtext->auto_height)
      pass ();
    else
      fail ("MTEXT.auto_height [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->auto_height, auto_height);
    mtext->auto_height--;

  }
  {
    BITCODE_CMC bg_fill_color;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_color", &bg_fill_color, NULL)
        && !memcmp (&bg_fill_color, &mtext->bg_fill_color, sizeof (mtext->bg_fill_color)))
        pass ();
    else
        fail ("MTEXT.bg_fill_color [CMC]");
  }
  {
    BITCODE_BL bg_fill_flag;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_flag", &bg_fill_flag, NULL)
        && bg_fill_flag == mtext->bg_fill_flag)
      pass ();
    else
      fail ("MTEXT.bg_fill_flag [BL] %u != %u", mtext->bg_fill_flag, bg_fill_flag);
    bg_fill_flag++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_flag", &bg_fill_flag, 0)
        && bg_fill_flag == mtext->bg_fill_flag)
      pass ();
    else
      fail ("MTEXT.bg_fill_flag [BL] set+1 %u != %u", mtext->bg_fill_flag, bg_fill_flag);
    mtext->bg_fill_flag--;

  }
  {
    BITCODE_BL bg_fill_scale;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_scale", &bg_fill_scale, NULL)
        && bg_fill_scale == mtext->bg_fill_scale)
      pass ();
    else
      fail ("MTEXT.bg_fill_scale [BL] %u != %u", mtext->bg_fill_scale, bg_fill_scale);
    bg_fill_scale++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_scale", &bg_fill_scale, 0)
        && bg_fill_scale == mtext->bg_fill_scale)
      pass ();
    else
      fail ("MTEXT.bg_fill_scale [BL] set+1 %u != %u", mtext->bg_fill_scale, bg_fill_scale);
    mtext->bg_fill_scale--;

  }
  {
    BITCODE_BL bg_fill_trans;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_trans", &bg_fill_trans, NULL)
        && bg_fill_trans == mtext->bg_fill_trans)
      pass ();
    else
      fail ("MTEXT.bg_fill_trans [BL] %u != %u", mtext->bg_fill_trans, bg_fill_trans);
    bg_fill_trans++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_trans", &bg_fill_trans, 0)
        && bg_fill_trans == mtext->bg_fill_trans)
      pass ();
    else
      fail ("MTEXT.bg_fill_trans [BL] set+1 %u != %u", mtext->bg_fill_trans, bg_fill_trans);
    mtext->bg_fill_trans--;

  }
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "class_version", &class_version, NULL)
        && class_version == mtext->class_version)
      pass ();
    else
      fail ("MTEXT.class_version [BS] %hu != %hu", mtext->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "class_version", &class_version, 0)
        && class_version == mtext->class_version)
      pass ();
    else
      fail ("MTEXT.class_version [BS] set+1 %hu != %hu", mtext->class_version, class_version);
    mtext->class_version--;

  }
  {
    BITCODE_BD* column_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "num_column_heights", &count, NULL)
        && dwg_dynapi_entity_value (mtext, "MTEXT", "column_heights", &column_heights, NULL)
        && column_heights == mtext->column_heights)
      pass ();
    else
      fail ("MTEXT.column_heights [BD*] * %u num_column_heights", count);
  }
  {
    BITCODE_BL column_type;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "column_type", &column_type, NULL)
        && column_type == mtext->column_type)
      pass ();
    else
      fail ("MTEXT.column_type [BL] %u != %u", mtext->column_type, column_type);
    column_type++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "column_type", &column_type, 0)
        && column_type == mtext->column_type)
      pass ();
    else
      fail ("MTEXT.column_type [BL] set+1 %u != %u", mtext->column_type, column_type);
    mtext->column_type--;

  }
  {
    BITCODE_BD column_width;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "column_width", &column_width, NULL)
        && column_width == mtext->column_width)
      pass ();
    else
      fail ("MTEXT.column_width [BD] %g != %g", mtext->column_width, column_width);
    column_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "column_width", &column_width, 0)
        && column_width == mtext->column_width)
      pass ();
    else
      fail ("MTEXT.column_width [BD] set+1 %g != %g", mtext->column_width, column_width);
    mtext->column_width--;

  }
  {
    BITCODE_B default_flag;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "default_flag", &default_flag, NULL)
        && default_flag == mtext->default_flag)
      pass ();
    else
      fail ("MTEXT.default_flag [B] " FORMAT_B " != " FORMAT_B "", mtext->default_flag, default_flag);
    default_flag++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "default_flag", &default_flag, 0)
        && default_flag == mtext->default_flag)
      pass ();
    else
      fail ("MTEXT.default_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->default_flag, default_flag);
    mtext->default_flag--;

  }
  {
    BITCODE_BS drawing_dir;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "drawing_dir", &drawing_dir, NULL)
        && drawing_dir == mtext->drawing_dir)
      pass ();
    else
      fail ("MTEXT.drawing_dir [BS] %hu != %hu", mtext->drawing_dir, drawing_dir);
    drawing_dir++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "drawing_dir", &drawing_dir, 0)
        && drawing_dir == mtext->drawing_dir)
      pass ();
    else
      fail ("MTEXT.drawing_dir [BS] set+1 %hu != %hu", mtext->drawing_dir, drawing_dir);
    mtext->drawing_dir--;

  }
  {
    BITCODE_BD extents_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "extents_height", &extents_height, NULL)
        && extents_height == mtext->extents_height)
      pass ();
    else
      fail ("MTEXT.extents_height [BD] %g != %g", mtext->extents_height, extents_height);
    extents_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "extents_height", &extents_height, 0)
        && extents_height == mtext->extents_height)
      pass ();
    else
      fail ("MTEXT.extents_height [BD] set+1 %g != %g", mtext->extents_height, extents_height);
    mtext->extents_height--;

  }
  {
    BITCODE_BD extents_width;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "extents_width", &extents_width, NULL)
        && extents_width == mtext->extents_width)
      pass ();
    else
      fail ("MTEXT.extents_width [BD] %g != %g", mtext->extents_width, extents_width);
    extents_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "extents_width", &extents_width, 0)
        && extents_width == mtext->extents_width)
      pass ();
    else
      fail ("MTEXT.extents_width [BD] set+1 %g != %g", mtext->extents_width, extents_width);
    mtext->extents_width--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mtext->extrusion, sizeof (mtext->extrusion)))
        pass ();
    else
        fail ("MTEXT.extrusion [BE]");
  }
  {
    BITCODE_B flow_reversed;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "flow_reversed", &flow_reversed, NULL)
        && flow_reversed == mtext->flow_reversed)
      pass ();
    else
      fail ("MTEXT.flow_reversed [B] " FORMAT_B " != " FORMAT_B "", mtext->flow_reversed, flow_reversed);
    flow_reversed++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "flow_reversed", &flow_reversed, 0)
        && flow_reversed == mtext->flow_reversed)
      pass ();
    else
      fail ("MTEXT.flow_reversed [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->flow_reversed, flow_reversed);
    mtext->flow_reversed--;

  }
  {
    BITCODE_BD gutter;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "gutter", &gutter, NULL)
        && gutter == mtext->gutter)
      pass ();
    else
      fail ("MTEXT.gutter [BD] %g != %g", mtext->gutter, gutter);
    gutter++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "gutter", &gutter, 0)
        && gutter == mtext->gutter)
      pass ();
    else
      fail ("MTEXT.gutter [BD] set+1 %g != %g", mtext->gutter, gutter);
    mtext->gutter--;

  }
  {
    BITCODE_3BD insertion_pt;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &mtext->insertion_pt, sizeof (mtext->insertion_pt)))
        pass ();
    else
        fail ("MTEXT.insertion_pt [3BD]");
  }
  {
    BITCODE_BD linespace_factor;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "linespace_factor", &linespace_factor, NULL)
        && linespace_factor == mtext->linespace_factor)
      pass ();
    else
      fail ("MTEXT.linespace_factor [BD] %g != %g", mtext->linespace_factor, linespace_factor);
    linespace_factor++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "linespace_factor", &linespace_factor, 0)
        && linespace_factor == mtext->linespace_factor)
      pass ();
    else
      fail ("MTEXT.linespace_factor [BD] set+1 %g != %g", mtext->linespace_factor, linespace_factor);
    mtext->linespace_factor--;

  }
  {
    BITCODE_BS linespace_style;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "linespace_style", &linespace_style, NULL)
        && linespace_style == mtext->linespace_style)
      pass ();
    else
      fail ("MTEXT.linespace_style [BS] %hu != %hu", mtext->linespace_style, linespace_style);
    linespace_style++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "linespace_style", &linespace_style, 0)
        && linespace_style == mtext->linespace_style)
      pass ();
    else
      fail ("MTEXT.linespace_style [BS] set+1 %hu != %hu", mtext->linespace_style, linespace_style);
    mtext->linespace_style--;

  }
  {
    BITCODE_BL num_column_heights;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "num_column_heights", &num_column_heights, NULL)
        && num_column_heights == mtext->num_column_heights)
      pass ();
    else
      fail ("MTEXT.num_column_heights [BL] %u != %u", mtext->num_column_heights, num_column_heights);
    num_column_heights++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "num_column_heights", &num_column_heights, 0)
        && num_column_heights == mtext->num_column_heights)
      pass ();
    else
      fail ("MTEXT.num_column_heights [BL] set+1 %u != %u", mtext->num_column_heights, num_column_heights);
    mtext->num_column_heights--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &mtext->parent, sizeof (mtext->parent)))
        pass ();
    else
        fail ("MTEXT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rect_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "rect_height", &rect_height, NULL)
        && rect_height == mtext->rect_height)
      pass ();
    else
      fail ("MTEXT.rect_height [BD] %g != %g", mtext->rect_height, rect_height);
    rect_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "rect_height", &rect_height, 0)
        && rect_height == mtext->rect_height)
      pass ();
    else
      fail ("MTEXT.rect_height [BD] set+1 %g != %g", mtext->rect_height, rect_height);
    mtext->rect_height--;

  }
  {
    BITCODE_BD rect_width;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "rect_width", &rect_width, NULL)
        && rect_width == mtext->rect_width)
      pass ();
    else
      fail ("MTEXT.rect_width [BD] %g != %g", mtext->rect_width, rect_width);
    rect_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "rect_width", &rect_width, 0)
        && rect_width == mtext->rect_width)
      pass ();
    else
      fail ("MTEXT.rect_width [BD] set+1 %g != %g", mtext->rect_width, rect_width);
    mtext->rect_width--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "style", &style, NULL)
        && !memcmp (&style, &mtext->style, sizeof (mtext->style)))
        pass ();
    else
        fail ("MTEXT.style [H]");
  }
  {
    BITCODE_TV text;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "text", &text, NULL)
        && text
           ? strEQ ((char *)text, (char *)mtext->text)
           : !mtext->text)
      pass ();
    else
      fail ("MTEXT.text [TV] '%s' <> '%s'", text, mtext->text);
  }
  {
    BITCODE_BD text_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "text_height", &text_height, NULL)
        && text_height == mtext->text_height)
      pass ();
    else
      fail ("MTEXT.text_height [BD] %g != %g", mtext->text_height, text_height);
    text_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "text_height", &text_height, 0)
        && text_height == mtext->text_height)
      pass ();
    else
      fail ("MTEXT.text_height [BD] set+1 %g != %g", mtext->text_height, text_height);
    mtext->text_height--;

  }
  {
    BITCODE_B unknown_bit;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "unknown_bit", &unknown_bit, NULL)
        && unknown_bit == mtext->unknown_bit)
      pass ();
    else
      fail ("MTEXT.unknown_bit [B] " FORMAT_B " != " FORMAT_B "", mtext->unknown_bit, unknown_bit);
    unknown_bit++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "unknown_bit", &unknown_bit, 0)
        && unknown_bit == mtext->unknown_bit)
      pass ();
    else
      fail ("MTEXT.unknown_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->unknown_bit, unknown_bit);
    mtext->unknown_bit--;

  }
  {
    BITCODE_3BD x_axis_dir;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "x_axis_dir", &x_axis_dir, NULL)
        && !memcmp (&x_axis_dir, &mtext->x_axis_dir, sizeof (mtext->x_axis_dir)))
        pass ();
    else
        fail ("MTEXT.x_axis_dir [3BD]");
  }
  return failed;
}
static int test_MULTILEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MULTILEADER *restrict multileader = obj->tio.entity->tio.MULTILEADER;
  {
    BITCODE_H arrow_handle;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrow_handle", &arrow_handle, NULL)
        && !memcmp (&arrow_handle, &multileader->arrow_handle, sizeof (multileader->arrow_handle)))
        pass ();
    else
        fail ("MULTILEADER.arrow_handle [H]");
  }
  {
    BITCODE_BD arrow_size;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrow_size", &arrow_size, NULL)
        && arrow_size == multileader->arrow_size)
      pass ();
    else
      fail ("MULTILEADER.arrow_size [BD] %g != %g", multileader->arrow_size, arrow_size);
    arrow_size++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "arrow_size", &arrow_size, 0)
        && arrow_size == multileader->arrow_size)
      pass ();
    else
      fail ("MULTILEADER.arrow_size [BD] set+1 %g != %g", multileader->arrow_size, arrow_size);
    multileader->arrow_size--;

  }
  {
    Dwg_LEADER_ArrowHead* arrowheads;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_arrowheads", &count, NULL)
        && dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrowheads", &arrowheads, NULL)
        && arrowheads == multileader->arrowheads)
      pass ();
    else
      fail ("MULTILEADER.arrowheads [Dwg_LEADER_ArrowHead*] * %u num_arrowheads", count);
  }
  {
    BITCODE_BS attach_bottom;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_bottom", &attach_bottom, NULL)
        && attach_bottom == multileader->attach_bottom)
      pass ();
    else
      fail ("MULTILEADER.attach_bottom [BS] %hu != %hu", multileader->attach_bottom, attach_bottom);
    attach_bottom++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_bottom", &attach_bottom, 0)
        && attach_bottom == multileader->attach_bottom)
      pass ();
    else
      fail ("MULTILEADER.attach_bottom [BS] set+1 %hu != %hu", multileader->attach_bottom, attach_bottom);
    multileader->attach_bottom--;

  }
  {
    BITCODE_BS attach_dir;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_dir", &attach_dir, NULL)
        && attach_dir == multileader->attach_dir)
      pass ();
    else
      fail ("MULTILEADER.attach_dir [BS] %hu != %hu", multileader->attach_dir, attach_dir);
    attach_dir++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_dir", &attach_dir, 0)
        && attach_dir == multileader->attach_dir)
      pass ();
    else
      fail ("MULTILEADER.attach_dir [BS] set+1 %hu != %hu", multileader->attach_dir, attach_dir);
    multileader->attach_dir--;

  }
  {
    BITCODE_BS attach_top;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_top", &attach_top, NULL)
        && attach_top == multileader->attach_top)
      pass ();
    else
      fail ("MULTILEADER.attach_top [BS] %hu != %hu", multileader->attach_top, attach_top);
    attach_top++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_top", &attach_top, 0)
        && attach_top == multileader->attach_top)
      pass ();
    else
      fail ("MULTILEADER.attach_top [BS] set+1 %hu != %hu", multileader->attach_top, attach_top);
    multileader->attach_top--;

  }
  {
    BITCODE_BS attach_type;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_type", &attach_type, NULL)
        && attach_type == multileader->attach_type)
      pass ();
    else
      fail ("MULTILEADER.attach_type [BS] %hu != %hu", multileader->attach_type, attach_type);
    attach_type++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_type", &attach_type, 0)
        && attach_type == multileader->attach_type)
      pass ();
    else
      fail ("MULTILEADER.attach_type [BS] set+1 %hu != %hu", multileader->attach_type, attach_type);
    multileader->attach_type--;

  }
  {
    BITCODE_CMC block_color;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_color", &block_color, NULL)
        && !memcmp (&block_color, &multileader->block_color, sizeof (multileader->block_color)))
        pass ();
    else
        fail ("MULTILEADER.block_color [CMC]");
  }
  {
    BITCODE_BD block_rotation;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_rotation", &block_rotation, NULL)
        && block_rotation == multileader->block_rotation)
      pass ();
    else
      fail ("MULTILEADER.block_rotation [BD] %g != %g", multileader->block_rotation, block_rotation);
    block_rotation++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "block_rotation", &block_rotation, 0)
        && block_rotation == multileader->block_rotation)
      pass ();
    else
      fail ("MULTILEADER.block_rotation [BD] set+1 %g != %g", multileader->block_rotation, block_rotation);
    multileader->block_rotation--;

  }
  {
    BITCODE_3BD block_scale;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_scale", &block_scale, NULL)
        && !memcmp (&block_scale, &multileader->block_scale, sizeof (multileader->block_scale)))
        pass ();
    else
        fail ("MULTILEADER.block_scale [3BD]");
  }
  {
    BITCODE_H block_style;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_style", &block_style, NULL)
        && !memcmp (&block_style, &multileader->block_style, sizeof (multileader->block_style)))
        pass ();
    else
        fail ("MULTILEADER.block_style [H]");
  }
  {
    Dwg_LEADER_BlockLabel* blocklabels;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_blocklabels", &count, NULL)
        && dwg_dynapi_entity_value (multileader, "MULTILEADER", "blocklabels", &blocklabels, NULL)
        && blocklabels == multileader->blocklabels)
      pass ();
    else
      fail ("MULTILEADER.blocklabels [Dwg_LEADER_BlockLabel*] * %u num_blocklabels", count);
  }
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "class_version", &class_version, NULL)
        && class_version == multileader->class_version)
      pass ();
    else
      fail ("MULTILEADER.class_version [BS] %hu != %hu", multileader->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "class_version", &class_version, 0)
        && class_version == multileader->class_version)
      pass ();
    else
      fail ("MULTILEADER.class_version [BS] set+1 %hu != %hu", multileader->class_version, class_version);
    multileader->class_version--;

  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "color", &color, NULL)
        && !memcmp (&color, &multileader->color, sizeof (multileader->color)))
        pass ();
    else
        fail ("MULTILEADER.color [CMC]");
  }
  {
    Dwg_MLEADER_AnnotContext ctx;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "ctx", &ctx, NULL)
        && !memcmp (&ctx, &multileader->ctx, sizeof (multileader->ctx)))
        pass ();
    else
        fail ("MULTILEADER.ctx [Dwg_MLEADER_AnnotContext]");
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "flags", &flags, NULL)
        && flags == multileader->flags)
      pass ();
    else
      fail ("MULTILEADER.flags [BL] %u != %u", multileader->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "flags", &flags, 0)
        && flags == multileader->flags)
      pass ();
    else
      fail ("MULTILEADER.flags [BL] set+1 %u != %u", multileader->flags, flags);
    multileader->flags--;

  }
  {
    BITCODE_B has_dogleg;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "has_dogleg", &has_dogleg, NULL)
        && has_dogleg == multileader->has_dogleg)
      pass ();
    else
      fail ("MULTILEADER.has_dogleg [B] " FORMAT_B " != " FORMAT_B "", multileader->has_dogleg, has_dogleg);
    has_dogleg++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_dogleg", &has_dogleg, 0)
        && has_dogleg == multileader->has_dogleg)
      pass ();
    else
      fail ("MULTILEADER.has_dogleg [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_dogleg, has_dogleg);
    multileader->has_dogleg--;

  }
  {
    BITCODE_B has_landing;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "has_landing", &has_landing, NULL)
        && has_landing == multileader->has_landing)
      pass ();
    else
      fail ("MULTILEADER.has_landing [B] " FORMAT_B " != " FORMAT_B "", multileader->has_landing, has_landing);
    has_landing++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_landing", &has_landing, 0)
        && has_landing == multileader->has_landing)
      pass ();
    else
      fail ("MULTILEADER.has_landing [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_landing, has_landing);
    multileader->has_landing--;

  }
  {
    BITCODE_B has_text_frame;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "has_text_frame", &has_text_frame, NULL)
        && has_text_frame == multileader->has_text_frame)
      pass ();
    else
      fail ("MULTILEADER.has_text_frame [B] " FORMAT_B " != " FORMAT_B "", multileader->has_text_frame, has_text_frame);
    has_text_frame++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_text_frame", &has_text_frame, 0)
        && has_text_frame == multileader->has_text_frame)
      pass ();
    else
      fail ("MULTILEADER.has_text_frame [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_text_frame, has_text_frame);
    multileader->has_text_frame--;

  }
  {
    BITCODE_BS ipe_alignment;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "ipe_alignment", &ipe_alignment, NULL)
        && ipe_alignment == multileader->ipe_alignment)
      pass ();
    else
      fail ("MULTILEADER.ipe_alignment [BS] %hu != %hu", multileader->ipe_alignment, ipe_alignment);
    ipe_alignment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "ipe_alignment", &ipe_alignment, 0)
        && ipe_alignment == multileader->ipe_alignment)
      pass ();
    else
      fail ("MULTILEADER.ipe_alignment [BS] set+1 %hu != %hu", multileader->ipe_alignment, ipe_alignment);
    multileader->ipe_alignment--;

  }
  {
    BITCODE_B is_annotative;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "is_annotative", &is_annotative, NULL)
        && is_annotative == multileader->is_annotative)
      pass ();
    else
      fail ("MULTILEADER.is_annotative [B] " FORMAT_B " != " FORMAT_B "", multileader->is_annotative, is_annotative);
    is_annotative++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "is_annotative", &is_annotative, 0)
        && is_annotative == multileader->is_annotative)
      pass ();
    else
      fail ("MULTILEADER.is_annotative [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->is_annotative, is_annotative);
    multileader->is_annotative--;

  }
  {
    BITCODE_BS justification;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "justification", &justification, NULL)
        && justification == multileader->justification)
      pass ();
    else
      fail ("MULTILEADER.justification [BS] %hu != %hu", multileader->justification, justification);
    justification++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "justification", &justification, 0)
        && justification == multileader->justification)
      pass ();
    else
      fail ("MULTILEADER.justification [BS] set+1 %hu != %hu", multileader->justification, justification);
    multileader->justification--;

  }
  {
    BITCODE_BD landing_dist;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "landing_dist", &landing_dist, NULL)
        && landing_dist == multileader->landing_dist)
      pass ();
    else
      fail ("MULTILEADER.landing_dist [BD] %g != %g", multileader->landing_dist, landing_dist);
    landing_dist++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "landing_dist", &landing_dist, 0)
        && landing_dist == multileader->landing_dist)
      pass ();
    else
      fail ("MULTILEADER.landing_dist [BD] set+1 %g != %g", multileader->landing_dist, landing_dist);
    multileader->landing_dist--;

  }
  {
    BITCODE_BLd linewt;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "linewt", &linewt, NULL)
        && linewt == multileader->linewt)
      pass ();
    else
      fail ("MULTILEADER.linewt [BLd] " FORMAT_BLd " != " FORMAT_BLd "", multileader->linewt, linewt);
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "linewt", &linewt, 0)
        && linewt == multileader->linewt)
      pass ();
    else
      fail ("MULTILEADER.linewt [BLd] set+1 " FORMAT_BLd " != " FORMAT_BLd "", multileader->linewt, linewt);
    multileader->linewt--;

  }
  {
    BITCODE_H ltype;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "ltype", &ltype, NULL)
        && !memcmp (&ltype, &multileader->ltype, sizeof (multileader->ltype)))
        pass ();
    else
        fail ("MULTILEADER.ltype [H]");
  }
  {
    BITCODE_H mleaderstyle;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "mleaderstyle", &mleaderstyle, NULL)
        && !memcmp (&mleaderstyle, &multileader->mleaderstyle, sizeof (multileader->mleaderstyle)))
        pass ();
    else
        fail ("MULTILEADER.mleaderstyle [H]");
  }
  {
    BITCODE_B neg_textdir;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "neg_textdir", &neg_textdir, NULL)
        && neg_textdir == multileader->neg_textdir)
      pass ();
    else
      fail ("MULTILEADER.neg_textdir [B] " FORMAT_B " != " FORMAT_B "", multileader->neg_textdir, neg_textdir);
    neg_textdir++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "neg_textdir", &neg_textdir, 0)
        && neg_textdir == multileader->neg_textdir)
      pass ();
    else
      fail ("MULTILEADER.neg_textdir [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->neg_textdir, neg_textdir);
    multileader->neg_textdir--;

  }
  {
    BITCODE_BL num_arrowheads;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_arrowheads", &num_arrowheads, NULL)
        && num_arrowheads == multileader->num_arrowheads)
      pass ();
    else
      fail ("MULTILEADER.num_arrowheads [BL] %u != %u", multileader->num_arrowheads, num_arrowheads);
    num_arrowheads++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "num_arrowheads", &num_arrowheads, 0)
        && num_arrowheads == multileader->num_arrowheads)
      pass ();
    else
      fail ("MULTILEADER.num_arrowheads [BL] set+1 %u != %u", multileader->num_arrowheads, num_arrowheads);
    multileader->num_arrowheads--;

  }
  {
    BITCODE_BL num_blocklabels;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_blocklabels", &num_blocklabels, NULL)
        && num_blocklabels == multileader->num_blocklabels)
      pass ();
    else
      fail ("MULTILEADER.num_blocklabels [BL] %u != %u", multileader->num_blocklabels, num_blocklabels);
    num_blocklabels++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "num_blocklabels", &num_blocklabels, 0)
        && num_blocklabels == multileader->num_blocklabels)
      pass ();
    else
      fail ("MULTILEADER.num_blocklabels [BL] set+1 %u != %u", multileader->num_blocklabels, num_blocklabels);
    multileader->num_blocklabels--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &multileader->parent, sizeof (multileader->parent)))
        pass ();
    else
        fail ("MULTILEADER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "scale_factor", &scale_factor, NULL)
        && scale_factor == multileader->scale_factor)
      pass ();
    else
      fail ("MULTILEADER.scale_factor [BD] %g != %g", multileader->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "scale_factor", &scale_factor, 0)
        && scale_factor == multileader->scale_factor)
      pass ();
    else
      fail ("MULTILEADER.scale_factor [BD] set+1 %g != %g", multileader->scale_factor, scale_factor);
    multileader->scale_factor--;

  }
  {
    BITCODE_BS style_attachment;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "style_attachment", &style_attachment, NULL)
        && style_attachment == multileader->style_attachment)
      pass ();
    else
      fail ("MULTILEADER.style_attachment [BS] %hu != %hu", multileader->style_attachment, style_attachment);
    style_attachment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "style_attachment", &style_attachment, 0)
        && style_attachment == multileader->style_attachment)
      pass ();
    else
      fail ("MULTILEADER.style_attachment [BS] set+1 %hu != %hu", multileader->style_attachment, style_attachment);
    multileader->style_attachment--;

  }
  {
    BITCODE_BS style_content;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "style_content", &style_content, NULL)
        && style_content == multileader->style_content)
      pass ();
    else
      fail ("MULTILEADER.style_content [BS] %hu != %hu", multileader->style_content, style_content);
    style_content++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "style_content", &style_content, 0)
        && style_content == multileader->style_content)
      pass ();
    else
      fail ("MULTILEADER.style_content [BS] set+1 %hu != %hu", multileader->style_content, style_content);
    multileader->style_content--;

  }
  {
    BITCODE_BS text_angletype;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_angletype", &text_angletype, NULL)
        && text_angletype == multileader->text_angletype)
      pass ();
    else
      fail ("MULTILEADER.text_angletype [BS] %hu != %hu", multileader->text_angletype, text_angletype);
    text_angletype++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_angletype", &text_angletype, 0)
        && text_angletype == multileader->text_angletype)
      pass ();
    else
      fail ("MULTILEADER.text_angletype [BS] set+1 %hu != %hu", multileader->text_angletype, text_angletype);
    multileader->text_angletype--;

  }
  {
    BITCODE_CMC text_color;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_color", &text_color, NULL)
        && !memcmp (&text_color, &multileader->text_color, sizeof (multileader->text_color)))
        pass ();
    else
        fail ("MULTILEADER.text_color [CMC]");
  }
  {
    BITCODE_B text_extended;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_extended", &text_extended, NULL)
        && text_extended == multileader->text_extended)
      pass ();
    else
      fail ("MULTILEADER.text_extended [B] " FORMAT_B " != " FORMAT_B "", multileader->text_extended, text_extended);
    text_extended++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_extended", &text_extended, 0)
        && text_extended == multileader->text_extended)
      pass ();
    else
      fail ("MULTILEADER.text_extended [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->text_extended, text_extended);
    multileader->text_extended--;

  }
  {
    BITCODE_BS text_left;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_left", &text_left, NULL)
        && text_left == multileader->text_left)
      pass ();
    else
      fail ("MULTILEADER.text_left [BS] %hu != %hu", multileader->text_left, text_left);
    text_left++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_left", &text_left, 0)
        && text_left == multileader->text_left)
      pass ();
    else
      fail ("MULTILEADER.text_left [BS] set+1 %hu != %hu", multileader->text_left, text_left);
    multileader->text_left--;

  }
  {
    BITCODE_BS text_right;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_right", &text_right, NULL)
        && text_right == multileader->text_right)
      pass ();
    else
      fail ("MULTILEADER.text_right [BS] %hu != %hu", multileader->text_right, text_right);
    text_right++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_right", &text_right, 0)
        && text_right == multileader->text_right)
      pass ();
    else
      fail ("MULTILEADER.text_right [BS] set+1 %hu != %hu", multileader->text_right, text_right);
    multileader->text_right--;

  }
  {
    BITCODE_H text_style;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_style", &text_style, NULL)
        && !memcmp (&text_style, &multileader->text_style, sizeof (multileader->text_style)))
        pass ();
    else
        fail ("MULTILEADER.text_style [H]");
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "type", &type, NULL)
        && type == multileader->type)
      pass ();
    else
      fail ("MULTILEADER.type [BS] %hu != %hu", multileader->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "type", &type, 0)
        && type == multileader->type)
      pass ();
    else
      fail ("MULTILEADER.type [BS] set+1 %hu != %hu", multileader->type, type);
    multileader->type--;

  }
  return failed;
}
static int test_OLE2FRAME (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_OLE2FRAME *restrict ole2frame = obj->tio.entity->tio.OLE2FRAME;
  {
    BITCODE_TV data;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "data", &data, NULL)
        && data
           ? strEQ ((char *)data, (char *)ole2frame->data)
           : !ole2frame->data)
      pass ();
    else
      fail ("OLE2FRAME.data [TV] '%s' <> '%s'", data, ole2frame->data);
  }
  {
    BITCODE_BL data_length;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "data_length", &data_length, NULL)
        && data_length == ole2frame->data_length)
      pass ();
    else
      fail ("OLE2FRAME.data_length [BL] %u != %u", ole2frame->data_length, data_length);
    data_length++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "data_length", &data_length, 0)
        && data_length == ole2frame->data_length)
      pass ();
    else
      fail ("OLE2FRAME.data_length [BL] set+1 %u != %u", ole2frame->data_length, data_length);
    ole2frame->data_length--;

  }
  {
    BITCODE_RC lock_aspect;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "lock_aspect", &lock_aspect, NULL)
        && lock_aspect == ole2frame->lock_aspect)
      pass ();
    else
      fail ("OLE2FRAME.lock_aspect [RC] %u != %u", ole2frame->lock_aspect, lock_aspect);
    lock_aspect++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "lock_aspect", &lock_aspect, 0)
        && lock_aspect == ole2frame->lock_aspect)
      pass ();
    else
      fail ("OLE2FRAME.lock_aspect [RC] set+1 %u != %u", ole2frame->lock_aspect, lock_aspect);
    ole2frame->lock_aspect--;

  }
  {
    BITCODE_BS mode;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "mode", &mode, NULL)
        && mode == ole2frame->mode)
      pass ();
    else
      fail ("OLE2FRAME.mode [BS] %hu != %hu", ole2frame->mode, mode);
    mode++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "mode", &mode, 0)
        && mode == ole2frame->mode)
      pass ();
    else
      fail ("OLE2FRAME.mode [BS] set+1 %hu != %hu", ole2frame->mode, mode);
    ole2frame->mode--;

  }
  {
    BITCODE_TV oleclient;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "oleclient", &oleclient, NULL)
        && oleclient
           ? strEQ ((char *)oleclient, (char *)ole2frame->oleclient)
           : !ole2frame->oleclient)
      pass ();
    else
      fail ("OLE2FRAME.oleclient [TV] '%s' <> '%s'", oleclient, ole2frame->oleclient);
  }
  {
    BITCODE_BS oleversion;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "oleversion", &oleversion, NULL)
        && oleversion == ole2frame->oleversion)
      pass ();
    else
      fail ("OLE2FRAME.oleversion [BS] %hu != %hu", ole2frame->oleversion, oleversion);
    oleversion++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "oleversion", &oleversion, 0)
        && oleversion == ole2frame->oleversion)
      pass ();
    else
      fail ("OLE2FRAME.oleversion [BS] set+1 %hu != %hu", ole2frame->oleversion, oleversion);
    ole2frame->oleversion--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "parent", &parent, NULL)
        && !memcmp (&parent, &ole2frame->parent, sizeof (ole2frame->parent)))
        pass ();
    else
        fail ("OLE2FRAME.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt1;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "pt1", &pt1, NULL)
        && !memcmp (&pt1, &ole2frame->pt1, sizeof (ole2frame->pt1)))
        pass ();
    else
        fail ("OLE2FRAME.pt1 [3BD]");
  }
  {
    BITCODE_3BD pt2;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "pt2", &pt2, NULL)
        && !memcmp (&pt2, &ole2frame->pt2, sizeof (ole2frame->pt2)))
        pass ();
    else
        fail ("OLE2FRAME.pt2 [3BD]");
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "type", &type, NULL)
        && type == ole2frame->type)
      pass ();
    else
      fail ("OLE2FRAME.type [BS] %hu != %hu", ole2frame->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "type", &type, 0)
        && type == ole2frame->type)
      pass ();
    else
      fail ("OLE2FRAME.type [BS] set+1 %hu != %hu", ole2frame->type, type);
    ole2frame->type--;

  }
  return failed;
}
static int test_OLEFRAME (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_OLEFRAME *restrict oleframe = obj->tio.entity->tio.OLEFRAME;
  {
    BITCODE_TV data;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "data", &data, NULL)
        && data
           ? strEQ ((char *)data, (char *)oleframe->data)
           : !oleframe->data)
      pass ();
    else
      fail ("OLEFRAME.data [TV] '%s' <> '%s'", data, oleframe->data);
  }
  {
    BITCODE_BL data_length;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "data_length", &data_length, NULL)
        && data_length == oleframe->data_length)
      pass ();
    else
      fail ("OLEFRAME.data_length [BL] %u != %u", oleframe->data_length, data_length);
    data_length++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "data_length", &data_length, 0)
        && data_length == oleframe->data_length)
      pass ();
    else
      fail ("OLEFRAME.data_length [BL] set+1 %u != %u", oleframe->data_length, data_length);
    oleframe->data_length--;

  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "flag", &flag, NULL)
        && flag == oleframe->flag)
      pass ();
    else
      fail ("OLEFRAME.flag [BS] %hu != %hu", oleframe->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "flag", &flag, 0)
        && flag == oleframe->flag)
      pass ();
    else
      fail ("OLEFRAME.flag [BS] set+1 %hu != %hu", oleframe->flag, flag);
    oleframe->flag--;

  }
  {
    BITCODE_BS mode;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "mode", &mode, NULL)
        && mode == oleframe->mode)
      pass ();
    else
      fail ("OLEFRAME.mode [BS] %hu != %hu", oleframe->mode, mode);
    mode++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "mode", &mode, 0)
        && mode == oleframe->mode)
      pass ();
    else
      fail ("OLEFRAME.mode [BS] set+1 %hu != %hu", oleframe->mode, mode);
    oleframe->mode--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "parent", &parent, NULL)
        && !memcmp (&parent, &oleframe->parent, sizeof (oleframe->parent)))
        pass ();
    else
        fail ("OLEFRAME.parent [struct _dwg_object_entity*]");
  }
  return failed;
}
static int test_PLANESURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_PLANESURFACE *restrict planesurface = obj->tio.entity->tio.PLANESURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)planesurface->acis_data)
           : !planesurface->acis_data)
      pass ();
    else
      fail ("PLANESURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, planesurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == planesurface->acis_empty)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == planesurface->acis_empty)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty, acis_empty);
    planesurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == planesurface->acis_empty2)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == planesurface->acis_empty2)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty2, acis_empty2);
    planesurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == planesurface->acis_empty_bit)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == planesurface->acis_empty_bit)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty_bit, acis_empty_bit);
    planesurface->acis_empty_bit--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &planesurface->block_size, sizeof (planesurface->block_size)))
        pass ();
    else
        fail ("PLANESURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "class_version", &class_version, NULL)
        && class_version == planesurface->class_version)
      pass ();
    else
      fail ("PLANESURFACE.class_version [BL] %u != %u", planesurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "class_version", &class_version, 0)
        && class_version == planesurface->class_version)
      pass ();
    else
      fail ("PLANESURFACE.class_version [BL] set+1 %u != %u", planesurface->class_version, class_version);
    planesurface->class_version--;

  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &planesurface->encr_sat_data, sizeof (planesurface->encr_sat_data)))
      pass ();
    else
      fail ("PLANESURFACE.encr_sat_data [char **]");
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &planesurface->extra_acis_data, sizeof (planesurface->extra_acis_data)))
        pass ();
    else
        fail ("PLANESURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &planesurface->history_id, sizeof (planesurface->history_id)))
        pass ();
    else
        fail ("PLANESURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == planesurface->isoline_present)
      pass ();
    else
      fail ("PLANESURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == planesurface->isoline_present)
      pass ();
    else
      fail ("PLANESURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->isoline_present, isoline_present);
    planesurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == planesurface->modeler_format_version)
      pass ();
    else
      fail ("PLANESURFACE.modeler_format_version [BS] %hu != %hu", planesurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == planesurface->modeler_format_version)
      pass ();
    else
      fail ("PLANESURFACE.modeler_format_version [BS] set+1 %hu != %hu", planesurface->modeler_format_version, modeler_format_version);
    planesurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == planesurface->num_blocks)
      pass ();
    else
      fail ("PLANESURFACE.num_blocks [BL] %u != %u", planesurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == planesurface->num_blocks)
      pass ();
    else
      fail ("PLANESURFACE.num_blocks [BL] set+1 %u != %u", planesurface->num_blocks, num_blocks);
    planesurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == planesurface->num_isolines)
      pass ();
    else
      fail ("PLANESURFACE.num_isolines [BL] %u != %u", planesurface->num_isolines, num_isolines);
    num_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_isolines", &num_isolines, 0)
        && num_isolines == planesurface->num_isolines)
      pass ();
    else
      fail ("PLANESURFACE.num_isolines [BL] set+1 %u != %u", planesurface->num_isolines, num_isolines);
    planesurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == planesurface->num_silhouettes)
      pass ();
    else
      fail ("PLANESURFACE.num_silhouettes [BL] %u != %u", planesurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == planesurface->num_silhouettes)
      pass ();
    else
      fail ("PLANESURFACE.num_silhouettes [BL] set+1 %u != %u", planesurface->num_silhouettes, num_silhouettes);
    planesurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_wires", &num_wires, NULL)
        && num_wires == planesurface->num_wires)
      pass ();
    else
      fail ("PLANESURFACE.num_wires [BL] %u != %u", planesurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_wires", &num_wires, 0)
        && num_wires == planesurface->num_wires)
      pass ();
    else
      fail ("PLANESURFACE.num_wires [BL] set+1 %u != %u", planesurface->num_wires, num_wires);
    planesurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &planesurface->parent, sizeof (planesurface->parent)))
        pass ();
    else
        fail ("PLANESURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "point", &point, NULL)
        && !memcmp (&point, &planesurface->point, sizeof (planesurface->point)))
        pass ();
    else
        fail ("PLANESURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "point_present", &point_present, NULL)
        && point_present == planesurface->point_present)
      pass ();
    else
      fail ("PLANESURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "point_present", &point_present, 0)
        && point_present == planesurface->point_present)
      pass ();
    else
      fail ("PLANESURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->point_present, point_present);
    planesurface->point_present--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == planesurface->silhouettes)
      pass ();
    else
      fail ("PLANESURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == planesurface->u_isolines)
      pass ();
    else
      fail ("PLANESURFACE.u_isolines [BS] %hu != %hu", planesurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == planesurface->u_isolines)
      pass ();
    else
      fail ("PLANESURFACE.u_isolines [BS] set+1 %hu != %hu", planesurface->u_isolines, u_isolines);
    planesurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "unknown", &unknown, NULL)
        && unknown == planesurface->unknown)
      pass ();
    else
      fail ("PLANESURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", planesurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "unknown", &unknown, 0)
        && unknown == planesurface->unknown)
      pass ();
    else
      fail ("PLANESURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->unknown, unknown);
    planesurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == planesurface->unknown_2007)
      pass ();
    else
      fail ("PLANESURFACE.unknown_2007 [BL] %u != %u", planesurface->unknown_2007, unknown_2007);
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "unknown_2007", &unknown_2007, 0)
        && unknown_2007 == planesurface->unknown_2007)
      pass ();
    else
      fail ("PLANESURFACE.unknown_2007 [BL] set+1 %u != %u", planesurface->unknown_2007, unknown_2007);
    planesurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == planesurface->v_isolines)
      pass ();
    else
      fail ("PLANESURFACE.v_isolines [BS] %hu != %hu", planesurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == planesurface->v_isolines)
      pass ();
    else
      fail ("PLANESURFACE.v_isolines [BS] set+1 %hu != %hu", planesurface->v_isolines, v_isolines);
    planesurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "version", &version, NULL)
        && version == planesurface->version)
      pass ();
    else
      fail ("PLANESURFACE.version [BS] %hu != %hu", planesurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "version", &version, 0)
        && version == planesurface->version)
      pass ();
    else
      fail ("PLANESURFACE.version [BS] set+1 %hu != %hu", planesurface->version, version);
    planesurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == planesurface->wireframe_data_present)
      pass ();
    else
      fail ("PLANESURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == planesurface->wireframe_data_present)
      pass ();
    else
      fail ("PLANESURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->wireframe_data_present, wireframe_data_present);
    planesurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "wires", &wires, NULL)
        && wires == planesurface->wires)
      pass ();
    else
      fail ("PLANESURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  return failed;
}
static int test_POINT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POINT *restrict point = obj->tio.entity->tio.POINT;
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (point, "POINT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &point->extrusion, sizeof (point->extrusion)))
        pass ();
    else
        fail ("POINT.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (point, "POINT", "parent", &parent, NULL)
        && !memcmp (&parent, &point->parent, sizeof (point->parent)))
        pass ();
    else
        fail ("POINT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (point, "POINT", "thickness", &thickness, NULL)
        && thickness == point->thickness)
      pass ();
    else
      fail ("POINT.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", point->thickness, thickness);
    if (dwg_dynapi_entity_set_value (point, "POINT", "thickness", &thickness, 0)
        && thickness == point->thickness)
      pass ();
    else
      fail ("POINT.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", point->thickness, thickness);
    point->thickness--;

  }
  {
    BITCODE_BD x;
    if (dwg_dynapi_entity_value (point, "POINT", "x", &x, NULL)
        && x == point->x)
      pass ();
    else
      fail ("POINT.x [BD] %g != %g", point->x, x);
    x++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "x", &x, 0)
        && x == point->x)
      pass ();
    else
      fail ("POINT.x [BD] set+1 %g != %g", point->x, x);
    point->x--;

  }
  {
    BITCODE_BD x_ang;
    if (dwg_dynapi_entity_value (point, "POINT", "x_ang", &x_ang, NULL)
        && x_ang == point->x_ang)
      pass ();
    else
      fail ("POINT.x_ang [BD] %g != %g", point->x_ang, x_ang);
    x_ang++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "x_ang", &x_ang, 0)
        && x_ang == point->x_ang)
      pass ();
    else
      fail ("POINT.x_ang [BD] set+1 %g != %g", point->x_ang, x_ang);
    point->x_ang--;

  }
  {
    BITCODE_BD y;
    if (dwg_dynapi_entity_value (point, "POINT", "y", &y, NULL)
        && y == point->y)
      pass ();
    else
      fail ("POINT.y [BD] %g != %g", point->y, y);
    y++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "y", &y, 0)
        && y == point->y)
      pass ();
    else
      fail ("POINT.y [BD] set+1 %g != %g", point->y, y);
    point->y--;

  }
  {
    BITCODE_BD z;
    if (dwg_dynapi_entity_value (point, "POINT", "z", &z, NULL)
        && z == point->z)
      pass ();
    else
      fail ("POINT.z [BD] %g != %g", point->z, z);
    z++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "z", &z, 0)
        && z == point->z)
      pass ();
    else
      fail ("POINT.z [BD] set+1 %g != %g", point->z, z);
    point->z--;

  }
  return failed;
}
static int test_POLYLINE_2D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_2D *restrict polyline_2d = obj->tio.entity->tio.POLYLINE_2D;
  {
    BITCODE_BS curve_type;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "curve_type", &curve_type, NULL)
        && curve_type == polyline_2d->curve_type)
      pass ();
    else
      fail ("POLYLINE_2D.curve_type [BS] %hu != %hu", polyline_2d->curve_type, curve_type);
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "curve_type", &curve_type, 0)
        && curve_type == polyline_2d->curve_type)
      pass ();
    else
      fail ("POLYLINE_2D.curve_type [BS] set+1 %hu != %hu", polyline_2d->curve_type, curve_type);
    polyline_2d->curve_type--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "elevation", &elevation, NULL)
        && elevation == polyline_2d->elevation)
      pass ();
    else
      fail ("POLYLINE_2D.elevation [BD] %g != %g", polyline_2d->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "elevation", &elevation, 0)
        && elevation == polyline_2d->elevation)
      pass ();
    else
      fail ("POLYLINE_2D.elevation [BD] set+1 %g != %g", polyline_2d->elevation, elevation);
    polyline_2d->elevation--;

  }
  {
    BITCODE_BD end_width;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "end_width", &end_width, NULL)
        && end_width == polyline_2d->end_width)
      pass ();
    else
      fail ("POLYLINE_2D.end_width [BD] %g != %g", polyline_2d->end_width, end_width);
    end_width++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "end_width", &end_width, 0)
        && end_width == polyline_2d->end_width)
      pass ();
    else
      fail ("POLYLINE_2D.end_width [BD] set+1 %g != %g", polyline_2d->end_width, end_width);
    polyline_2d->end_width--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &polyline_2d->extrusion, sizeof (polyline_2d->extrusion)))
        pass ();
    else
        fail ("POLYLINE_2D.extrusion [BE]");
  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_2d->first_vertex, sizeof (polyline_2d->first_vertex)))
        pass ();
    else
        fail ("POLYLINE_2D.first_vertex [H]");
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "flag", &flag, NULL)
        && flag == polyline_2d->flag)
      pass ();
    else
      fail ("POLYLINE_2D.flag [BS] %hu != %hu", polyline_2d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "flag", &flag, 0)
        && flag == polyline_2d->flag)
      pass ();
    else
      fail ("POLYLINE_2D.flag [BS] set+1 %hu != %hu", polyline_2d->flag, flag);
    polyline_2d->flag--;

  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_2d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_2D.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_2d->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_2d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_2D.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_2d->has_vertex, has_vertex);
    polyline_2d->has_vertex--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_2d->last_vertex, sizeof (polyline_2d->last_vertex)))
        pass ();
    else
        fail ("POLYLINE_2D.last_vertex [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "num_owned", &num_owned, NULL)
        && num_owned == polyline_2d->num_owned)
      pass ();
    else
      fail ("POLYLINE_2D.num_owned [BL] %u != %u", polyline_2d->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "num_owned", &num_owned, 0)
        && num_owned == polyline_2d->num_owned)
      pass ();
    else
      fail ("POLYLINE_2D.num_owned [BL] set+1 %u != %u", polyline_2d->num_owned, num_owned);
    polyline_2d->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_2d->parent, sizeof (polyline_2d->parent)))
        pass ();
    else
        fail ("POLYLINE_2D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_2d->seqend, sizeof (polyline_2d->seqend)))
        pass ();
    else
        fail ("POLYLINE_2D.seqend [H]");
  }
  {
    BITCODE_BD start_width;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "start_width", &start_width, NULL)
        && start_width == polyline_2d->start_width)
      pass ();
    else
      fail ("POLYLINE_2D.start_width [BD] %g != %g", polyline_2d->start_width, start_width);
    start_width++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "start_width", &start_width, 0)
        && start_width == polyline_2d->start_width)
      pass ();
    else
      fail ("POLYLINE_2D.start_width [BD] set+1 %g != %g", polyline_2d->start_width, start_width);
    polyline_2d->start_width--;

  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "thickness", &thickness, NULL)
        && thickness == polyline_2d->thickness)
      pass ();
    else
      fail ("POLYLINE_2D.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", polyline_2d->thickness, thickness);
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "thickness", &thickness, 0)
        && thickness == polyline_2d->thickness)
      pass ();
    else
      fail ("POLYLINE_2D.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", polyline_2d->thickness, thickness);
    polyline_2d->thickness--;

  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "vertex", &vertex, NULL)
        && vertex == polyline_2d->vertex)
      pass ();
    else
      fail ("POLYLINE_2D.vertex [H*] * %u num_owned", count);
  }
  return failed;
}
static int test_POLYLINE_3D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_3D *restrict polyline_3d = obj->tio.entity->tio.POLYLINE_3D;
  {
    BITCODE_RC curve_type;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "curve_type", &curve_type, NULL)
        && curve_type == polyline_3d->curve_type)
      pass ();
    else
      fail ("POLYLINE_3D.curve_type [RC] %u != %u", polyline_3d->curve_type, curve_type);
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "curve_type", &curve_type, 0)
        && curve_type == polyline_3d->curve_type)
      pass ();
    else
      fail ("POLYLINE_3D.curve_type [RC] set+1 %u != %u", polyline_3d->curve_type, curve_type);
    polyline_3d->curve_type--;

  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_3d->first_vertex, sizeof (polyline_3d->first_vertex)))
        pass ();
    else
        fail ("POLYLINE_3D.first_vertex [H]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "flag", &flag, NULL)
        && flag == polyline_3d->flag)
      pass ();
    else
      fail ("POLYLINE_3D.flag [RC] %u != %u", polyline_3d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "flag", &flag, 0)
        && flag == polyline_3d->flag)
      pass ();
    else
      fail ("POLYLINE_3D.flag [RC] set+1 %u != %u", polyline_3d->flag, flag);
    polyline_3d->flag--;

  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_3d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_3D.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_3d->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_3d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_3D.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_3d->has_vertex, has_vertex);
    polyline_3d->has_vertex--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_3d->last_vertex, sizeof (polyline_3d->last_vertex)))
        pass ();
    else
        fail ("POLYLINE_3D.last_vertex [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "num_owned", &num_owned, NULL)
        && num_owned == polyline_3d->num_owned)
      pass ();
    else
      fail ("POLYLINE_3D.num_owned [BL] %u != %u", polyline_3d->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "num_owned", &num_owned, 0)
        && num_owned == polyline_3d->num_owned)
      pass ();
    else
      fail ("POLYLINE_3D.num_owned [BL] set+1 %u != %u", polyline_3d->num_owned, num_owned);
    polyline_3d->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_3d->parent, sizeof (polyline_3d->parent)))
        pass ();
    else
        fail ("POLYLINE_3D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_3d->seqend, sizeof (polyline_3d->seqend)))
        pass ();
    else
        fail ("POLYLINE_3D.seqend [H]");
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "vertex", &vertex, NULL)
        && vertex == polyline_3d->vertex)
      pass ();
    else
      fail ("POLYLINE_3D.vertex [H*] * %u num_owned", count);
  }
  return failed;
}
static int test_POLYLINE_MESH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_MESH *restrict polyline_mesh = obj->tio.entity->tio.POLYLINE_MESH;
  {
    BITCODE_BS curve_type;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "curve_type", &curve_type, NULL)
        && curve_type == polyline_mesh->curve_type)
      pass ();
    else
      fail ("POLYLINE_MESH.curve_type [BS] %hu != %hu", polyline_mesh->curve_type, curve_type);
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "curve_type", &curve_type, 0)
        && curve_type == polyline_mesh->curve_type)
      pass ();
    else
      fail ("POLYLINE_MESH.curve_type [BS] set+1 %hu != %hu", polyline_mesh->curve_type, curve_type);
    polyline_mesh->curve_type--;

  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_mesh->first_vertex, sizeof (polyline_mesh->first_vertex)))
        pass ();
    else
        fail ("POLYLINE_MESH.first_vertex [H]");
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "flag", &flag, NULL)
        && flag == polyline_mesh->flag)
      pass ();
    else
      fail ("POLYLINE_MESH.flag [BS] %hu != %hu", polyline_mesh->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "flag", &flag, 0)
        && flag == polyline_mesh->flag)
      pass ();
    else
      fail ("POLYLINE_MESH.flag [BS] set+1 %hu != %hu", polyline_mesh->flag, flag);
    polyline_mesh->flag--;

  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_mesh->has_vertex)
      pass ();
    else
      fail ("POLYLINE_MESH.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_mesh->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_mesh->has_vertex)
      pass ();
    else
      fail ("POLYLINE_MESH.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_mesh->has_vertex, has_vertex);
    polyline_mesh->has_vertex--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_mesh->last_vertex, sizeof (polyline_mesh->last_vertex)))
        pass ();
    else
        fail ("POLYLINE_MESH.last_vertex [H]");
  }
  {
    BITCODE_BS m_density;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "m_density", &m_density, NULL)
        && m_density == polyline_mesh->m_density)
      pass ();
    else
      fail ("POLYLINE_MESH.m_density [BS] %hu != %hu", polyline_mesh->m_density, m_density);
    m_density++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "m_density", &m_density, 0)
        && m_density == polyline_mesh->m_density)
      pass ();
    else
      fail ("POLYLINE_MESH.m_density [BS] set+1 %hu != %hu", polyline_mesh->m_density, m_density);
    polyline_mesh->m_density--;

  }
  {
    BITCODE_BS n_density;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "n_density", &n_density, NULL)
        && n_density == polyline_mesh->n_density)
      pass ();
    else
      fail ("POLYLINE_MESH.n_density [BS] %hu != %hu", polyline_mesh->n_density, n_density);
    n_density++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "n_density", &n_density, 0)
        && n_density == polyline_mesh->n_density)
      pass ();
    else
      fail ("POLYLINE_MESH.n_density [BS] set+1 %hu != %hu", polyline_mesh->n_density, n_density);
    polyline_mesh->n_density--;

  }
  {
    BITCODE_BS num_m_verts;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_m_verts", &num_m_verts, NULL)
        && num_m_verts == polyline_mesh->num_m_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_m_verts [BS] %hu != %hu", polyline_mesh->num_m_verts, num_m_verts);
    num_m_verts++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_m_verts", &num_m_verts, 0)
        && num_m_verts == polyline_mesh->num_m_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_m_verts [BS] set+1 %hu != %hu", polyline_mesh->num_m_verts, num_m_verts);
    polyline_mesh->num_m_verts--;

  }
  {
    BITCODE_BS num_n_verts;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_n_verts", &num_n_verts, NULL)
        && num_n_verts == polyline_mesh->num_n_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_n_verts [BS] %hu != %hu", polyline_mesh->num_n_verts, num_n_verts);
    num_n_verts++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_n_verts", &num_n_verts, 0)
        && num_n_verts == polyline_mesh->num_n_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_n_verts [BS] set+1 %hu != %hu", polyline_mesh->num_n_verts, num_n_verts);
    polyline_mesh->num_n_verts--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &num_owned, NULL)
        && num_owned == polyline_mesh->num_owned)
      pass ();
    else
      fail ("POLYLINE_MESH.num_owned [BL] %u != %u", polyline_mesh->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &num_owned, 0)
        && num_owned == polyline_mesh->num_owned)
      pass ();
    else
      fail ("POLYLINE_MESH.num_owned [BL] set+1 %u != %u", polyline_mesh->num_owned, num_owned);
    polyline_mesh->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_mesh->parent, sizeof (polyline_mesh->parent)))
        pass ();
    else
        fail ("POLYLINE_MESH.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_mesh->seqend, sizeof (polyline_mesh->seqend)))
        pass ();
    else
        fail ("POLYLINE_MESH.seqend [H]");
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "vertex", &vertex, NULL)
        && vertex == polyline_mesh->vertex)
      pass ();
    else
      fail ("POLYLINE_MESH.vertex [H*] * %u num_owned", count);
  }
  return failed;
}
static int test_POLYLINE_PFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_PFACE *restrict polyline_pface = obj->tio.entity->tio.POLYLINE_PFACE;
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_pface->first_vertex, sizeof (polyline_pface->first_vertex)))
        pass ();
    else
        fail ("POLYLINE_PFACE.first_vertex [H]");
  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_pface->has_vertex)
      pass ();
    else
      fail ("POLYLINE_PFACE.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_pface->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_pface->has_vertex)
      pass ();
    else
      fail ("POLYLINE_PFACE.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_pface->has_vertex, has_vertex);
    polyline_pface->has_vertex--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_pface->last_vertex, sizeof (polyline_pface->last_vertex)))
        pass ();
    else
        fail ("POLYLINE_PFACE.last_vertex [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &num_owned, NULL)
        && num_owned == polyline_pface->num_owned)
      pass ();
    else
      fail ("POLYLINE_PFACE.num_owned [BL] %u != %u", polyline_pface->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &num_owned, 0)
        && num_owned == polyline_pface->num_owned)
      pass ();
    else
      fail ("POLYLINE_PFACE.num_owned [BL] set+1 %u != %u", polyline_pface->num_owned, num_owned);
    polyline_pface->num_owned--;

  }
  {
    BITCODE_BS numfaces;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "numfaces", &numfaces, NULL)
        && numfaces == polyline_pface->numfaces)
      pass ();
    else
      fail ("POLYLINE_PFACE.numfaces [BS] %hu != %hu", polyline_pface->numfaces, numfaces);
    numfaces++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "numfaces", &numfaces, 0)
        && numfaces == polyline_pface->numfaces)
      pass ();
    else
      fail ("POLYLINE_PFACE.numfaces [BS] set+1 %hu != %hu", polyline_pface->numfaces, numfaces);
    polyline_pface->numfaces--;

  }
  {
    BITCODE_BS numverts;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "numverts", &numverts, NULL)
        && numverts == polyline_pface->numverts)
      pass ();
    else
      fail ("POLYLINE_PFACE.numverts [BS] %hu != %hu", polyline_pface->numverts, numverts);
    numverts++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "numverts", &numverts, 0)
        && numverts == polyline_pface->numverts)
      pass ();
    else
      fail ("POLYLINE_PFACE.numverts [BS] set+1 %hu != %hu", polyline_pface->numverts, numverts);
    polyline_pface->numverts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_pface->parent, sizeof (polyline_pface->parent)))
        pass ();
    else
        fail ("POLYLINE_PFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_pface->seqend, sizeof (polyline_pface->seqend)))
        pass ();
    else
        fail ("POLYLINE_PFACE.seqend [H]");
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "vertex", &vertex, NULL)
        && vertex == polyline_pface->vertex)
      pass ();
    else
      fail ("POLYLINE_PFACE.vertex [H*] * %u num_owned", count);
  }
  return failed;
}
static int test_PROXY_ENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_PROXY_ENTITY *restrict proxy_entity = obj->tio.entity->tio.PROXY_ENTITY;
  {
    BITCODE_BL class_id;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "class_id", &class_id, NULL)
        && class_id == proxy_entity->class_id)
      pass ();
    else
      fail ("PROXY_ENTITY.class_id [BL] %u != %u", proxy_entity->class_id, class_id);
    class_id++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "class_id", &class_id, 0)
        && class_id == proxy_entity->class_id)
      pass ();
    else
      fail ("PROXY_ENTITY.class_id [BL] set+1 %u != %u", proxy_entity->class_id, class_id);
    proxy_entity->class_id--;

  }
  {
    BITCODE_TV data;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "data", &data, NULL)
        && data
           ? strEQ ((char *)data, (char *)proxy_entity->data)
           : !proxy_entity->data)
      pass ();
    else
      fail ("PROXY_ENTITY.data [TV] '%s' <> '%s'", data, proxy_entity->data);
  }
  {
    BITCODE_B from_dxf;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "from_dxf", &from_dxf, NULL)
        && from_dxf == proxy_entity->from_dxf)
      pass ();
    else
      fail ("PROXY_ENTITY.from_dxf [B] " FORMAT_B " != " FORMAT_B "", proxy_entity->from_dxf, from_dxf);
    from_dxf++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "from_dxf", &from_dxf, 0)
        && from_dxf == proxy_entity->from_dxf)
      pass ();
    else
      fail ("PROXY_ENTITY.from_dxf [B] set+1 " FORMAT_B " != " FORMAT_B "", proxy_entity->from_dxf, from_dxf);
    proxy_entity->from_dxf--;

  }
  {
    BITCODE_BL maint_version;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "maint_version", &maint_version, NULL)
        && maint_version == proxy_entity->maint_version)
      pass ();
    else
      fail ("PROXY_ENTITY.maint_version [BL] %u != %u", proxy_entity->maint_version, maint_version);
    maint_version++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "maint_version", &maint_version, 0)
        && maint_version == proxy_entity->maint_version)
      pass ();
    else
      fail ("PROXY_ENTITY.maint_version [BL] set+1 %u != %u", proxy_entity->maint_version, maint_version);
    proxy_entity->maint_version--;

  }
  {
    BITCODE_H* objid_object_handles;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "objid_object_handles", &objid_object_handles, NULL)
        && !memcmp (&objid_object_handles, &proxy_entity->objid_object_handles, sizeof (proxy_entity->objid_object_handles)))
        pass ();
    else
        fail ("PROXY_ENTITY.objid_object_handles [H*]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &proxy_entity->parent, sizeof (proxy_entity->parent)))
        pass ();
    else
        fail ("PROXY_ENTITY.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_MS size;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "size", &size, NULL)
        && size == proxy_entity->size)
      pass ();
    else
      fail ("PROXY_ENTITY.size [MS] " FORMAT_MS " != " FORMAT_MS "", proxy_entity->size, size);
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "size", &size, 0)
        && size == proxy_entity->size)
      pass ();
    else
      fail ("PROXY_ENTITY.size [MS] set+1 " FORMAT_MS " != " FORMAT_MS "", proxy_entity->size, size);
    proxy_entity->size--;

  }
  {
    BITCODE_BL version;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "version", &version, NULL)
        && version == proxy_entity->version)
      pass ();
    else
      fail ("PROXY_ENTITY.version [BL] %u != %u", proxy_entity->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "version", &version, 0)
        && version == proxy_entity->version)
      pass ();
    else
      fail ("PROXY_ENTITY.version [BL] set+1 %u != %u", proxy_entity->version, version);
    proxy_entity->version--;

  }
  return failed;
}
static int test_RAY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_RAY *restrict ray = obj->tio.entity->tio.RAY;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (ray, "RAY", "parent", &parent, NULL)
        && !memcmp (&parent, &ray->parent, sizeof (ray->parent)))
        pass ();
    else
        fail ("RAY.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (ray, "RAY", "point", &point, NULL)
        && !memcmp (&point, &ray->point, sizeof (ray->point)))
        pass ();
    else
        fail ("RAY.point [3BD]");
  }
  {
    BITCODE_3BD vector;
    if (dwg_dynapi_entity_value (ray, "RAY", "vector", &vector, NULL)
        && !memcmp (&vector, &ray->vector, sizeof (ray->vector)))
        pass ();
    else
        fail ("RAY.vector [3BD]");
  }
  return failed;
}
static int test_REGION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_REGION *restrict region = obj->tio.entity->tio.REGION;
  return failed;
}
static int test_REVOLVEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_REVOLVEDSURFACE *restrict revolvedsurface = obj->tio.entity->tio.REVOLVEDSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)revolvedsurface->acis_data)
           : !revolvedsurface->acis_data)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, revolvedsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == revolvedsurface->acis_empty)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == revolvedsurface->acis_empty)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty, acis_empty);
    revolvedsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == revolvedsurface->acis_empty2)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == revolvedsurface->acis_empty2)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty2, acis_empty2);
    revolvedsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == revolvedsurface->acis_empty_bit)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == revolvedsurface->acis_empty_bit)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty_bit, acis_empty_bit);
    revolvedsurface->acis_empty_bit--;

  }
  {
    BITCODE_3BD axis_point;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "axis_point", &axis_point, NULL)
        && !memcmp (&axis_point, &revolvedsurface->axis_point, sizeof (revolvedsurface->axis_point)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.axis_point [3BD]");
  }
  {
    BITCODE_3BD axis_vector;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "axis_vector", &axis_vector, NULL)
        && !memcmp (&axis_vector, &revolvedsurface->axis_vector, sizeof (revolvedsurface->axis_vector)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.axis_vector [3BD]");
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &revolvedsurface->block_size, sizeof (revolvedsurface->block_size)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "class_version", &class_version, NULL)
        && class_version == revolvedsurface->class_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.class_version [BL] %u != %u", revolvedsurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "class_version", &class_version, 0)
        && class_version == revolvedsurface->class_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.class_version [BL] set+1 %u != %u", revolvedsurface->class_version, class_version);
    revolvedsurface->class_version--;

  }
  {
    BITCODE_B close_to_axis;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "close_to_axis", &close_to_axis, NULL)
        && close_to_axis == revolvedsurface->close_to_axis)
      pass ();
    else
      fail ("REVOLVEDSURFACE.close_to_axis [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->close_to_axis, close_to_axis);
    close_to_axis++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "close_to_axis", &close_to_axis, 0)
        && close_to_axis == revolvedsurface->close_to_axis)
      pass ();
    else
      fail ("REVOLVEDSURFACE.close_to_axis [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->close_to_axis, close_to_axis);
    revolvedsurface->close_to_axis--;

  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == revolvedsurface->draft_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_angle [BD] %g != %g", revolvedsurface->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_angle", &draft_angle, 0)
        && draft_angle == revolvedsurface->draft_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_angle [BD] set+1 %g != %g", revolvedsurface->draft_angle, draft_angle);
    revolvedsurface->draft_angle--;

  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == revolvedsurface->draft_end_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_end_distance [BD] %g != %g", revolvedsurface->draft_end_distance, draft_end_distance);
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_end_distance", &draft_end_distance, 0)
        && draft_end_distance == revolvedsurface->draft_end_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_end_distance [BD] set+1 %g != %g", revolvedsurface->draft_end_distance, draft_end_distance);
    revolvedsurface->draft_end_distance--;

  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == revolvedsurface->draft_start_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_start_distance [BD] %g != %g", revolvedsurface->draft_start_distance, draft_start_distance);
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_start_distance", &draft_start_distance, 0)
        && draft_start_distance == revolvedsurface->draft_start_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_start_distance [BD] set+1 %g != %g", revolvedsurface->draft_start_distance, draft_start_distance);
    revolvedsurface->draft_start_distance--;

  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &revolvedsurface->encr_sat_data, sizeof (revolvedsurface->encr_sat_data)))
      pass ();
    else
      fail ("REVOLVEDSURFACE.encr_sat_data [char **]");
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &revolvedsurface->extra_acis_data, sizeof (revolvedsurface->extra_acis_data)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &revolvedsurface->history_id, sizeof (revolvedsurface->history_id)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.history_id [H]");
  }
  {
    BITCODE_BL id;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "id", &id, NULL)
        && id == revolvedsurface->id)
      pass ();
    else
      fail ("REVOLVEDSURFACE.id [BL] %u != %u", revolvedsurface->id, id);
    id++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "id", &id, 0)
        && id == revolvedsurface->id)
      pass ();
    else
      fail ("REVOLVEDSURFACE.id [BL] set+1 %u != %u", revolvedsurface->id, id);
    revolvedsurface->id--;

  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == revolvedsurface->isoline_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == revolvedsurface->isoline_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->isoline_present, isoline_present);
    revolvedsurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == revolvedsurface->modeler_format_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.modeler_format_version [BS] %hu != %hu", revolvedsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == revolvedsurface->modeler_format_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", revolvedsurface->modeler_format_version, modeler_format_version);
    revolvedsurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == revolvedsurface->num_blocks)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_blocks [BL] %u != %u", revolvedsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == revolvedsurface->num_blocks)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_blocks [BL] set+1 %u != %u", revolvedsurface->num_blocks, num_blocks);
    revolvedsurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == revolvedsurface->num_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_isolines [BL] %u != %u", revolvedsurface->num_isolines, num_isolines);
    num_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_isolines", &num_isolines, 0)
        && num_isolines == revolvedsurface->num_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_isolines [BL] set+1 %u != %u", revolvedsurface->num_isolines, num_isolines);
    revolvedsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == revolvedsurface->num_silhouettes)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_silhouettes [BL] %u != %u", revolvedsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == revolvedsurface->num_silhouettes)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_silhouettes [BL] set+1 %u != %u", revolvedsurface->num_silhouettes, num_silhouettes);
    revolvedsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == revolvedsurface->num_wires)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_wires [BL] %u != %u", revolvedsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &num_wires, 0)
        && num_wires == revolvedsurface->num_wires)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_wires [BL] set+1 %u != %u", revolvedsurface->num_wires, num_wires);
    revolvedsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &revolvedsurface->parent, sizeof (revolvedsurface->parent)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &revolvedsurface->point, sizeof (revolvedsurface->point)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "point_present", &point_present, NULL)
        && point_present == revolvedsurface->point_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "point_present", &point_present, 0)
        && point_present == revolvedsurface->point_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->point_present, point_present);
    revolvedsurface->point_present--;

  }
  {
    BITCODE_BD revolve_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revolve_angle", &revolve_angle, NULL)
        && revolve_angle == revolvedsurface->revolve_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revolve_angle [BD] %g != %g", revolvedsurface->revolve_angle, revolve_angle);
    revolve_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "revolve_angle", &revolve_angle, 0)
        && revolve_angle == revolvedsurface->revolve_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revolve_angle [BD] set+1 %g != %g", revolvedsurface->revolve_angle, revolve_angle);
    revolvedsurface->revolve_angle--;

  }
  {
    BITCODE_BD* revolved_entity_transmatrix;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revolved_entity_transmatrix", &revolved_entity_transmatrix, NULL)
        && !memcmp (&revolved_entity_transmatrix, &revolvedsurface->revolved_entity_transmatrix, sizeof (revolvedsurface->revolved_entity_transmatrix)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.revolved_entity_transmatrix [BD*]");
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == revolvedsurface->silhouettes)
      pass ();
    else
      fail ("REVOLVEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "solid", &solid, NULL)
        && solid == revolvedsurface->solid)
      pass ();
    else
      fail ("REVOLVEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->solid, solid);
    solid++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "solid", &solid, 0)
        && solid == revolvedsurface->solid)
      pass ();
    else
      fail ("REVOLVEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->solid, solid);
    revolvedsurface->solid--;

  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "start_angle", &start_angle, NULL)
        && start_angle == revolvedsurface->start_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.start_angle [BD] %g != %g", revolvedsurface->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "start_angle", &start_angle, 0)
        && start_angle == revolvedsurface->start_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.start_angle [BD] set+1 %g != %g", revolvedsurface->start_angle, start_angle);
    revolvedsurface->start_angle--;

  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == revolvedsurface->twist_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.twist_angle [BD] %g != %g", revolvedsurface->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "twist_angle", &twist_angle, 0)
        && twist_angle == revolvedsurface->twist_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.twist_angle [BD] set+1 %g != %g", revolvedsurface->twist_angle, twist_angle);
    revolvedsurface->twist_angle--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == revolvedsurface->u_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.u_isolines [BS] %hu != %hu", revolvedsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == revolvedsurface->u_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.u_isolines [BS] set+1 %hu != %hu", revolvedsurface->u_isolines, u_isolines);
    revolvedsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "unknown", &unknown, NULL)
        && unknown == revolvedsurface->unknown)
      pass ();
    else
      fail ("REVOLVEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "unknown", &unknown, 0)
        && unknown == revolvedsurface->unknown)
      pass ();
    else
      fail ("REVOLVEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->unknown, unknown);
    revolvedsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == revolvedsurface->unknown_2007)
      pass ();
    else
      fail ("REVOLVEDSURFACE.unknown_2007 [BL] %u != %u", revolvedsurface->unknown_2007, unknown_2007);
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "unknown_2007", &unknown_2007, 0)
        && unknown_2007 == revolvedsurface->unknown_2007)
      pass ();
    else
      fail ("REVOLVEDSURFACE.unknown_2007 [BL] set+1 %u != %u", revolvedsurface->unknown_2007, unknown_2007);
    revolvedsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == revolvedsurface->v_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.v_isolines [BS] %hu != %hu", revolvedsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == revolvedsurface->v_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.v_isolines [BS] set+1 %hu != %hu", revolvedsurface->v_isolines, v_isolines);
    revolvedsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "version", &version, NULL)
        && version == revolvedsurface->version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.version [BS] %hu != %hu", revolvedsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "version", &version, 0)
        && version == revolvedsurface->version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.version [BS] set+1 %hu != %hu", revolvedsurface->version, version);
    revolvedsurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == revolvedsurface->wireframe_data_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == revolvedsurface->wireframe_data_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->wireframe_data_present, wireframe_data_present);
    revolvedsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "wires", &wires, NULL)
        && wires == revolvedsurface->wires)
      pass ();
    else
      fail ("REVOLVEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  return failed;
}
static int test_SEQEND (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SEQEND *restrict seqend = obj->tio.entity->tio.SEQEND;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (seqend, "SEQEND", "parent", &parent, NULL)
        && !memcmp (&parent, &seqend->parent, sizeof (seqend->parent)))
        pass ();
    else
        fail ("SEQEND.parent [struct _dwg_object_entity*]");
  }
  return failed;
}
static int test_SHAPE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SHAPE *restrict shape = obj->tio.entity->tio.SHAPE;
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &shape->extrusion, sizeof (shape->extrusion)))
        pass ();
    else
        fail ("SHAPE.extrusion [BE]");
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &shape->ins_pt, sizeof (shape->ins_pt)))
        pass ();
    else
        fail ("SHAPE.ins_pt [3BD]");
  }
  {
    BITCODE_BD oblique;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "oblique", &oblique, NULL)
        && oblique == shape->oblique)
      pass ();
    else
      fail ("SHAPE.oblique [BD] %g != %g", shape->oblique, oblique);
    oblique++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "oblique", &oblique, 0)
        && oblique == shape->oblique)
      pass ();
    else
      fail ("SHAPE.oblique [BD] set+1 %g != %g", shape->oblique, oblique);
    shape->oblique--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "parent", &parent, NULL)
        && !memcmp (&parent, &shape->parent, sizeof (shape->parent)))
        pass ();
    else
        fail ("SHAPE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "rotation", &rotation, NULL)
        && rotation == shape->rotation)
      pass ();
    else
      fail ("SHAPE.rotation [BD] %g != %g", shape->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "rotation", &rotation, 0)
        && rotation == shape->rotation)
      pass ();
    else
      fail ("SHAPE.rotation [BD] set+1 %g != %g", shape->rotation, rotation);
    shape->rotation--;

  }
  {
    BITCODE_BD scale;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "scale", &scale, NULL)
        && scale == shape->scale)
      pass ();
    else
      fail ("SHAPE.scale [BD] %g != %g", shape->scale, scale);
    scale++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "scale", &scale, 0)
        && scale == shape->scale)
      pass ();
    else
      fail ("SHAPE.scale [BD] set+1 %g != %g", shape->scale, scale);
    shape->scale--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "style", &style, NULL)
        && !memcmp (&style, &shape->style, sizeof (shape->style)))
        pass ();
    else
        fail ("SHAPE.style [H]");
  }
  {
    BITCODE_BS style_id;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "style_id", &style_id, NULL)
        && style_id == shape->style_id)
      pass ();
    else
      fail ("SHAPE.style_id [BS] %hu != %hu", shape->style_id, style_id);
    style_id++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "style_id", &style_id, 0)
        && style_id == shape->style_id)
      pass ();
    else
      fail ("SHAPE.style_id [BS] set+1 %hu != %hu", shape->style_id, style_id);
    shape->style_id--;

  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "thickness", &thickness, NULL)
        && thickness == shape->thickness)
      pass ();
    else
      fail ("SHAPE.thickness [BD] %g != %g", shape->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "thickness", &thickness, 0)
        && thickness == shape->thickness)
      pass ();
    else
      fail ("SHAPE.thickness [BD] set+1 %g != %g", shape->thickness, thickness);
    shape->thickness--;

  }
  {
    BITCODE_BD width_factor;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "width_factor", &width_factor, NULL)
        && width_factor == shape->width_factor)
      pass ();
    else
      fail ("SHAPE.width_factor [BD] %g != %g", shape->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "width_factor", &width_factor, 0)
        && width_factor == shape->width_factor)
      pass ();
    else
      fail ("SHAPE.width_factor [BD] set+1 %g != %g", shape->width_factor, width_factor);
    shape->width_factor--;

  }
  return failed;
}
static int test_SOLID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SOLID *restrict solid = obj->tio.entity->tio.SOLID;
  {
    BITCODE_2RD corner1;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &solid->corner1, sizeof (solid->corner1)))
        pass ();
    else
        fail ("SOLID.corner1 [2RD]");
  }
  {
    BITCODE_2RD corner2;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &solid->corner2, sizeof (solid->corner2)))
        pass ();
    else
        fail ("SOLID.corner2 [2RD]");
  }
  {
    BITCODE_2RD corner3;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &solid->corner3, sizeof (solid->corner3)))
        pass ();
    else
        fail ("SOLID.corner3 [2RD]");
  }
  {
    BITCODE_2RD corner4;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &solid->corner4, sizeof (solid->corner4)))
        pass ();
    else
        fail ("SOLID.corner4 [2RD]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (solid, "SOLID", "elevation", &elevation, NULL)
        && elevation == solid->elevation)
      pass ();
    else
      fail ("SOLID.elevation [BD] %g != %g", solid->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (solid, "SOLID", "elevation", &elevation, 0)
        && elevation == solid->elevation)
      pass ();
    else
      fail ("SOLID.elevation [BD] set+1 %g != %g", solid->elevation, elevation);
    solid->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (solid, "SOLID", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &solid->extrusion, sizeof (solid->extrusion)))
        pass ();
    else
        fail ("SOLID.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (solid, "SOLID", "parent", &parent, NULL)
        && !memcmp (&parent, &solid->parent, sizeof (solid->parent)))
        pass ();
    else
        fail ("SOLID.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (solid, "SOLID", "thickness", &thickness, NULL)
        && thickness == solid->thickness)
      pass ();
    else
      fail ("SOLID.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", solid->thickness, thickness);
    if (dwg_dynapi_entity_set_value (solid, "SOLID", "thickness", &thickness, 0)
        && thickness == solid->thickness)
      pass ();
    else
      fail ("SOLID.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", solid->thickness, thickness);
    solid->thickness--;

  }
  return failed;
}
static int test_SPLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SPLINE *restrict spline = obj->tio.entity->tio.SPLINE;
  {
    BITCODE_3BD beg_tan_vec;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "beg_tan_vec", &beg_tan_vec, NULL)
        && !memcmp (&beg_tan_vec, &spline->beg_tan_vec, sizeof (spline->beg_tan_vec)))
        pass ();
    else
        fail ("SPLINE.beg_tan_vec [3BD]");
  }
  {
    BITCODE_B closed_b;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "closed_b", &closed_b, NULL)
        && closed_b == spline->closed_b)
      pass ();
    else
      fail ("SPLINE.closed_b [B] " FORMAT_B " != " FORMAT_B "", spline->closed_b, closed_b);
    closed_b++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "closed_b", &closed_b, 0)
        && closed_b == spline->closed_b)
      pass ();
    else
      fail ("SPLINE.closed_b [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->closed_b, closed_b);
    spline->closed_b--;

  }
  {
    Dwg_SPLINE_control_point* ctrl_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_ctrl_pts", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "ctrl_pts", &ctrl_pts, NULL)
        && ctrl_pts == spline->ctrl_pts)
      pass ();
    else
      fail ("SPLINE.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
  }
  {
    BITCODE_BD ctrl_tol;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "ctrl_tol", &ctrl_tol, NULL)
        && ctrl_tol == spline->ctrl_tol)
      pass ();
    else
      fail ("SPLINE.ctrl_tol [BD] %g != %g", spline->ctrl_tol, ctrl_tol);
    ctrl_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "ctrl_tol", &ctrl_tol, 0)
        && ctrl_tol == spline->ctrl_tol)
      pass ();
    else
      fail ("SPLINE.ctrl_tol [BD] set+1 %g != %g", spline->ctrl_tol, ctrl_tol);
    spline->ctrl_tol--;

  }
  {
    BITCODE_BS degree;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "degree", &degree, NULL)
        && degree == spline->degree)
      pass ();
    else
      fail ("SPLINE.degree [BS] %hu != %hu", spline->degree, degree);
    degree++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "degree", &degree, 0)
        && degree == spline->degree)
      pass ();
    else
      fail ("SPLINE.degree [BS] set+1 %hu != %hu", spline->degree, degree);
    spline->degree--;

  }
  {
    BITCODE_3BD end_tan_vec;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "end_tan_vec", &end_tan_vec, NULL)
        && !memcmp (&end_tan_vec, &spline->end_tan_vec, sizeof (spline->end_tan_vec)))
        pass ();
    else
        fail ("SPLINE.end_tan_vec [3BD]");
  }
  {
    Dwg_SPLINE_point* fit_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_fit_pts", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "fit_pts", &fit_pts, NULL)
        && fit_pts == spline->fit_pts)
      pass ();
    else
      fail ("SPLINE.fit_pts [Dwg_SPLINE_point*] * %u num_fit_pts", count);
  }
  {
    BITCODE_BD fit_tol;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "fit_tol", &fit_tol, NULL)
        && fit_tol == spline->fit_tol)
      pass ();
    else
      fail ("SPLINE.fit_tol [BD] %g != %g", spline->fit_tol, fit_tol);
    fit_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "fit_tol", &fit_tol, 0)
        && fit_tol == spline->fit_tol)
      pass ();
    else
      fail ("SPLINE.fit_tol [BD] set+1 %g != %g", spline->fit_tol, fit_tol);
    spline->fit_tol--;

  }
  {
    BITCODE_RS flag;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "flag", &flag, NULL)
        && flag == spline->flag)
      pass ();
    else
      fail ("SPLINE.flag [RS] %hu != %hu", spline->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "flag", &flag, 0)
        && flag == spline->flag)
      pass ();
    else
      fail ("SPLINE.flag [RS] set+1 %hu != %hu", spline->flag, flag);
    spline->flag--;

  }
  {
    BITCODE_BD knot_tol;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "knot_tol", &knot_tol, NULL)
        && knot_tol == spline->knot_tol)
      pass ();
    else
      fail ("SPLINE.knot_tol [BD] %g != %g", spline->knot_tol, knot_tol);
    knot_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "knot_tol", &knot_tol, 0)
        && knot_tol == spline->knot_tol)
      pass ();
    else
      fail ("SPLINE.knot_tol [BD] set+1 %g != %g", spline->knot_tol, knot_tol);
    spline->knot_tol--;

  }
  {
    BITCODE_BL knotparam;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "knotparam", &knotparam, NULL)
        && knotparam == spline->knotparam)
      pass ();
    else
      fail ("SPLINE.knotparam [BL] %u != %u", spline->knotparam, knotparam);
    knotparam++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "knotparam", &knotparam, 0)
        && knotparam == spline->knotparam)
      pass ();
    else
      fail ("SPLINE.knotparam [BL] set+1 %u != %u", spline->knotparam, knotparam);
    spline->knotparam--;

  }
  {
    BITCODE_BD* knots;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_knots", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "knots", &knots, NULL)
        && knots == spline->knots)
      pass ();
    else
      fail ("SPLINE.knots [BD*] * %u num_knots", count);
  }
  {
    BITCODE_BL num_ctrl_pts;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_ctrl_pts", &num_ctrl_pts, NULL)
        && num_ctrl_pts == spline->num_ctrl_pts)
      pass ();
    else
      fail ("SPLINE.num_ctrl_pts [BL] %u != %u", spline->num_ctrl_pts, num_ctrl_pts);
    num_ctrl_pts++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_ctrl_pts", &num_ctrl_pts, 0)
        && num_ctrl_pts == spline->num_ctrl_pts)
      pass ();
    else
      fail ("SPLINE.num_ctrl_pts [BL] set+1 %u != %u", spline->num_ctrl_pts, num_ctrl_pts);
    spline->num_ctrl_pts--;

  }
  {
    BITCODE_BS num_fit_pts;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_fit_pts", &num_fit_pts, NULL)
        && num_fit_pts == spline->num_fit_pts)
      pass ();
    else
      fail ("SPLINE.num_fit_pts [BS] %hu != %hu", spline->num_fit_pts, num_fit_pts);
    num_fit_pts++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_fit_pts", &num_fit_pts, 0)
        && num_fit_pts == spline->num_fit_pts)
      pass ();
    else
      fail ("SPLINE.num_fit_pts [BS] set+1 %hu != %hu", spline->num_fit_pts, num_fit_pts);
    spline->num_fit_pts--;

  }
  {
    BITCODE_BL num_knots;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_knots", &num_knots, NULL)
        && num_knots == spline->num_knots)
      pass ();
    else
      fail ("SPLINE.num_knots [BL] %u != %u", spline->num_knots, num_knots);
    num_knots++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_knots", &num_knots, 0)
        && num_knots == spline->num_knots)
      pass ();
    else
      fail ("SPLINE.num_knots [BL] set+1 %u != %u", spline->num_knots, num_knots);
    spline->num_knots--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &spline->parent, sizeof (spline->parent)))
        pass ();
    else
        fail ("SPLINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B periodic;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "periodic", &periodic, NULL)
        && periodic == spline->periodic)
      pass ();
    else
      fail ("SPLINE.periodic [B] " FORMAT_B " != " FORMAT_B "", spline->periodic, periodic);
    periodic++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "periodic", &periodic, 0)
        && periodic == spline->periodic)
      pass ();
    else
      fail ("SPLINE.periodic [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->periodic, periodic);
    spline->periodic--;

  }
  {
    BITCODE_B rational;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "rational", &rational, NULL)
        && rational == spline->rational)
      pass ();
    else
      fail ("SPLINE.rational [B] " FORMAT_B " != " FORMAT_B "", spline->rational, rational);
    rational++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "rational", &rational, 0)
        && rational == spline->rational)
      pass ();
    else
      fail ("SPLINE.rational [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->rational, rational);
    spline->rational--;

  }
  {
    BITCODE_BS scenario;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "scenario", &scenario, NULL)
        && scenario == spline->scenario)
      pass ();
    else
      fail ("SPLINE.scenario [BS] %hu != %hu", spline->scenario, scenario);
    scenario++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "scenario", &scenario, 0)
        && scenario == spline->scenario)
      pass ();
    else
      fail ("SPLINE.scenario [BS] set+1 %hu != %hu", spline->scenario, scenario);
    spline->scenario--;

  }
  {
    BITCODE_BL splineflags1;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "splineflags1", &splineflags1, NULL)
        && splineflags1 == spline->splineflags1)
      pass ();
    else
      fail ("SPLINE.splineflags1 [BL] %u != %u", spline->splineflags1, splineflags1);
    splineflags1++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "splineflags1", &splineflags1, 0)
        && splineflags1 == spline->splineflags1)
      pass ();
    else
      fail ("SPLINE.splineflags1 [BL] set+1 %u != %u", spline->splineflags1, splineflags1);
    spline->splineflags1--;

  }
  {
    BITCODE_B weighted;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "weighted", &weighted, NULL)
        && weighted == spline->weighted)
      pass ();
    else
      fail ("SPLINE.weighted [B] " FORMAT_B " != " FORMAT_B "", spline->weighted, weighted);
    weighted++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "weighted", &weighted, 0)
        && weighted == spline->weighted)
      pass ();
    else
      fail ("SPLINE.weighted [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->weighted, weighted);
    spline->weighted--;

  }
  return failed;
}
static int test_SWEPTSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SWEPTSURFACE *restrict sweptsurface = obj->tio.entity->tio.SWEPTSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)sweptsurface->acis_data)
           : !sweptsurface->acis_data)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, sweptsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == sweptsurface->acis_empty)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == sweptsurface->acis_empty)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty, acis_empty);
    sweptsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == sweptsurface->acis_empty2)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == sweptsurface->acis_empty2)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty2, acis_empty2);
    sweptsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == sweptsurface->acis_empty_bit)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == sweptsurface->acis_empty_bit)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty_bit, acis_empty_bit);
    sweptsurface->acis_empty_bit--;

  }
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "align_angle", &align_angle, NULL)
        && align_angle == sweptsurface->align_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.align_angle [BD] %g != %g", sweptsurface->align_angle, align_angle);
    align_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "align_angle", &align_angle, 0)
        && align_angle == sweptsurface->align_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.align_angle [BD] set+1 %g != %g", sweptsurface->align_angle, align_angle);
    sweptsurface->align_angle--;

  }
  {
    BITCODE_B align_start;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "align_start", &align_start, NULL)
        && align_start == sweptsurface->align_start)
      pass ();
    else
      fail ("SWEPTSURFACE.align_start [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->align_start, align_start);
    align_start++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "align_start", &align_start, 0)
        && align_start == sweptsurface->align_start)
      pass ();
    else
      fail ("SWEPTSURFACE.align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->align_start, align_start);
    sweptsurface->align_start--;

  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "bank", &bank, NULL)
        && bank == sweptsurface->bank)
      pass ();
    else
      fail ("SWEPTSURFACE.bank [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->bank, bank);
    bank++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "bank", &bank, 0)
        && bank == sweptsurface->bank)
      pass ();
    else
      fail ("SWEPTSURFACE.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->bank, bank);
    sweptsurface->bank--;

  }
  {
    BITCODE_B base_point_set;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "base_point_set", &base_point_set, NULL)
        && base_point_set == sweptsurface->base_point_set)
      pass ();
    else
      fail ("SWEPTSURFACE.base_point_set [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->base_point_set, base_point_set);
    base_point_set++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "base_point_set", &base_point_set, 0)
        && base_point_set == sweptsurface->base_point_set)
      pass ();
    else
      fail ("SWEPTSURFACE.base_point_set [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->base_point_set, base_point_set);
    sweptsurface->base_point_set--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &sweptsurface->block_size, sizeof (sweptsurface->block_size)))
        pass ();
    else
        fail ("SWEPTSURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "class_version", &class_version, NULL)
        && class_version == sweptsurface->class_version)
      pass ();
    else
      fail ("SWEPTSURFACE.class_version [BL] %u != %u", sweptsurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "class_version", &class_version, 0)
        && class_version == sweptsurface->class_version)
      pass ();
    else
      fail ("SWEPTSURFACE.class_version [BL] set+1 %u != %u", sweptsurface->class_version, class_version);
    sweptsurface->class_version--;

  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == sweptsurface->draft_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_angle [BD] %g != %g", sweptsurface->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_angle", &draft_angle, 0)
        && draft_angle == sweptsurface->draft_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_angle [BD] set+1 %g != %g", sweptsurface->draft_angle, draft_angle);
    sweptsurface->draft_angle--;

  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == sweptsurface->draft_end_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_end_distance [BD] %g != %g", sweptsurface->draft_end_distance, draft_end_distance);
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_end_distance", &draft_end_distance, 0)
        && draft_end_distance == sweptsurface->draft_end_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_end_distance [BD] set+1 %g != %g", sweptsurface->draft_end_distance, draft_end_distance);
    sweptsurface->draft_end_distance--;

  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == sweptsurface->draft_start_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_start_distance [BD] %g != %g", sweptsurface->draft_start_distance, draft_start_distance);
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_start_distance", &draft_start_distance, 0)
        && draft_start_distance == sweptsurface->draft_start_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_start_distance [BD] set+1 %g != %g", sweptsurface->draft_start_distance, draft_start_distance);
    sweptsurface->draft_start_distance--;

  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &sweptsurface->encr_sat_data, sizeof (sweptsurface->encr_sat_data)))
      pass ();
    else
      fail ("SWEPTSURFACE.encr_sat_data [char **]");
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &sweptsurface->extra_acis_data, sizeof (sweptsurface->extra_acis_data)))
        pass ();
    else
        fail ("SWEPTSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &sweptsurface->history_id, sizeof (sweptsurface->history_id)))
        pass ();
    else
        fail ("SWEPTSURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == sweptsurface->isoline_present)
      pass ();
    else
      fail ("SWEPTSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == sweptsurface->isoline_present)
      pass ();
    else
      fail ("SWEPTSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->isoline_present, isoline_present);
    sweptsurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == sweptsurface->modeler_format_version)
      pass ();
    else
      fail ("SWEPTSURFACE.modeler_format_version [BS] %hu != %hu", sweptsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == sweptsurface->modeler_format_version)
      pass ();
    else
      fail ("SWEPTSURFACE.modeler_format_version [BS] set+1 %hu != %hu", sweptsurface->modeler_format_version, modeler_format_version);
    sweptsurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == sweptsurface->num_blocks)
      pass ();
    else
      fail ("SWEPTSURFACE.num_blocks [BL] %u != %u", sweptsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == sweptsurface->num_blocks)
      pass ();
    else
      fail ("SWEPTSURFACE.num_blocks [BL] set+1 %u != %u", sweptsurface->num_blocks, num_blocks);
    sweptsurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == sweptsurface->num_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.num_isolines [BL] %u != %u", sweptsurface->num_isolines, num_isolines);
    num_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_isolines", &num_isolines, 0)
        && num_isolines == sweptsurface->num_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.num_isolines [BL] set+1 %u != %u", sweptsurface->num_isolines, num_isolines);
    sweptsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == sweptsurface->num_silhouettes)
      pass ();
    else
      fail ("SWEPTSURFACE.num_silhouettes [BL] %u != %u", sweptsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == sweptsurface->num_silhouettes)
      pass ();
    else
      fail ("SWEPTSURFACE.num_silhouettes [BL] set+1 %u != %u", sweptsurface->num_silhouettes, num_silhouettes);
    sweptsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == sweptsurface->num_wires)
      pass ();
    else
      fail ("SWEPTSURFACE.num_wires [BL] %u != %u", sweptsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_wires", &num_wires, 0)
        && num_wires == sweptsurface->num_wires)
      pass ();
    else
      fail ("SWEPTSURFACE.num_wires [BL] set+1 %u != %u", sweptsurface->num_wires, num_wires);
    sweptsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &sweptsurface->parent, sizeof (sweptsurface->parent)))
        pass ();
    else
        fail ("SWEPTSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BL path_entity_id;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_id", &path_entity_id, NULL)
        && path_entity_id == sweptsurface->path_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_id [BL] %u != %u", sweptsurface->path_entity_id, path_entity_id);
    path_entity_id++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_entity_id", &path_entity_id, 0)
        && path_entity_id == sweptsurface->path_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_id [BL] set+1 %u != %u", sweptsurface->path_entity_id, path_entity_id);
    sweptsurface->path_entity_id--;

  }
  {
    BITCODE_B path_entity_transform_computed;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, NULL)
        && path_entity_transform_computed == sweptsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->path_entity_transform_computed, path_entity_transform_computed);
    path_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, 0)
        && path_entity_transform_computed == sweptsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->path_entity_transform_computed, path_entity_transform_computed);
    sweptsurface->path_entity_transform_computed--;

  }
  {
    BITCODE_BD* path_entity_transmatrix;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_transmatrix", &path_entity_transmatrix, NULL)
        && !memcmp (&path_entity_transmatrix, &sweptsurface->path_entity_transmatrix, sizeof (sweptsurface->path_entity_transmatrix)))
        pass ();
    else
        fail ("SWEPTSURFACE.path_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BD* path_entity_transmatrix1;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_transmatrix1", &path_entity_transmatrix1, NULL)
        && !memcmp (&path_entity_transmatrix1, &sweptsurface->path_entity_transmatrix1, sizeof (sweptsurface->path_entity_transmatrix1)))
        pass ();
    else
        fail ("SWEPTSURFACE.path_entity_transmatrix1 [BD*]");
  }
  {
    BITCODE_TF pathdata;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "pathdata", &pathdata, NULL)
        && !memcmp (&pathdata, &sweptsurface->pathdata, sizeof (sweptsurface->pathdata)))
        pass ();
    else
        fail ("SWEPTSURFACE.pathdata [TF]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "point", &point, NULL)
        && !memcmp (&point, &sweptsurface->point, sizeof (sweptsurface->point)))
        pass ();
    else
        fail ("SWEPTSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "point_present", &point_present, NULL)
        && point_present == sweptsurface->point_present)
      pass ();
    else
      fail ("SWEPTSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "point_present", &point_present, 0)
        && point_present == sweptsurface->point_present)
      pass ();
    else
      fail ("SWEPTSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->point_present, point_present);
    sweptsurface->point_present--;

  }
  {
    BITCODE_3BD reference_vector_for_controlling_twist;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "reference_vector_for_controlling_twist", &reference_vector_for_controlling_twist, NULL)
        && !memcmp (&reference_vector_for_controlling_twist, &sweptsurface->reference_vector_for_controlling_twist, sizeof (sweptsurface->reference_vector_for_controlling_twist)))
        pass ();
    else
        fail ("SWEPTSURFACE.reference_vector_for_controlling_twist [3BD]");
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "scale_factor", &scale_factor, NULL)
        && scale_factor == sweptsurface->scale_factor)
      pass ();
    else
      fail ("SWEPTSURFACE.scale_factor [BD] %g != %g", sweptsurface->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "scale_factor", &scale_factor, 0)
        && scale_factor == sweptsurface->scale_factor)
      pass ();
    else
      fail ("SWEPTSURFACE.scale_factor [BD] set+1 %g != %g", sweptsurface->scale_factor, scale_factor);
    sweptsurface->scale_factor--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == sweptsurface->silhouettes)
      pass ();
    else
      fail ("SWEPTSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BL size_pathdata;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "size_pathdata", &size_pathdata, NULL)
        && size_pathdata == sweptsurface->size_pathdata)
      pass ();
    else
      fail ("SWEPTSURFACE.size_pathdata [BL] %u != %u", sweptsurface->size_pathdata, size_pathdata);
    size_pathdata++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "size_pathdata", &size_pathdata, 0)
        && size_pathdata == sweptsurface->size_pathdata)
      pass ();
    else
      fail ("SWEPTSURFACE.size_pathdata [BL] set+1 %u != %u", sweptsurface->size_pathdata, size_pathdata);
    sweptsurface->size_pathdata--;

  }
  {
    BITCODE_BL size_sweepdata;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "size_sweepdata", &size_sweepdata, NULL)
        && size_sweepdata == sweptsurface->size_sweepdata)
      pass ();
    else
      fail ("SWEPTSURFACE.size_sweepdata [BL] %u != %u", sweptsurface->size_sweepdata, size_sweepdata);
    size_sweepdata++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "size_sweepdata", &size_sweepdata, 0)
        && size_sweepdata == sweptsurface->size_sweepdata)
      pass ();
    else
      fail ("SWEPTSURFACE.size_sweepdata [BL] set+1 %u != %u", sweptsurface->size_sweepdata, size_sweepdata);
    sweptsurface->size_sweepdata--;

  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "solid", &solid, NULL)
        && solid == sweptsurface->solid)
      pass ();
    else
      fail ("SWEPTSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->solid, solid);
    solid++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "solid", &solid, 0)
        && solid == sweptsurface->solid)
      pass ();
    else
      fail ("SWEPTSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->solid, solid);
    sweptsurface->solid--;

  }
  {
    BITCODE_RC sweep_alignment;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_alignment", &sweep_alignment, NULL)
        && sweep_alignment == sweptsurface->sweep_alignment)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_alignment [RC] %u != %u", sweptsurface->sweep_alignment, sweep_alignment);
    sweep_alignment++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_alignment", &sweep_alignment, 0)
        && sweep_alignment == sweptsurface->sweep_alignment)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_alignment [RC] set+1 %u != %u", sweptsurface->sweep_alignment, sweep_alignment);
    sweptsurface->sweep_alignment--;

  }
  {
    BITCODE_BL sweep_entity_id;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_id", &sweep_entity_id, NULL)
        && sweep_entity_id == sweptsurface->sweep_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_id [BL] %u != %u", sweptsurface->sweep_entity_id, sweep_entity_id);
    sweep_entity_id++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_id", &sweep_entity_id, 0)
        && sweep_entity_id == sweptsurface->sweep_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_id [BL] set+1 %u != %u", sweptsurface->sweep_entity_id, sweep_entity_id);
    sweptsurface->sweep_entity_id--;

  }
  {
    BITCODE_B sweep_entity_transform_computed;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, NULL)
        && sweep_entity_transform_computed == sweptsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    sweep_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, 0)
        && sweep_entity_transform_computed == sweptsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    sweptsurface->sweep_entity_transform_computed--;

  }
  {
    BITCODE_BD* sweep_entity_transmatrix;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transmatrix", &sweep_entity_transmatrix, NULL)
        && !memcmp (&sweep_entity_transmatrix, &sweptsurface->sweep_entity_transmatrix, sizeof (sweptsurface->sweep_entity_transmatrix)))
        pass ();
    else
        fail ("SWEPTSURFACE.sweep_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BD* sweep_entity_transmatrix1;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transmatrix1", &sweep_entity_transmatrix1, NULL)
        && !memcmp (&sweep_entity_transmatrix1, &sweptsurface->sweep_entity_transmatrix1, sizeof (sweptsurface->sweep_entity_transmatrix1)))
        pass ();
    else
        fail ("SWEPTSURFACE.sweep_entity_transmatrix1 [BD*]");
  }
  {
    BITCODE_TF sweepdata;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweepdata", &sweepdata, NULL)
        && !memcmp (&sweepdata, &sweptsurface->sweepdata, sizeof (sweptsurface->sweepdata)))
        pass ();
    else
        fail ("SWEPTSURFACE.sweepdata [TF]");
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == sweptsurface->twist_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.twist_angle [BD] %g != %g", sweptsurface->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "twist_angle", &twist_angle, 0)
        && twist_angle == sweptsurface->twist_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.twist_angle [BD] set+1 %g != %g", sweptsurface->twist_angle, twist_angle);
    sweptsurface->twist_angle--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == sweptsurface->u_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.u_isolines [BS] %hu != %hu", sweptsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == sweptsurface->u_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.u_isolines [BS] set+1 %hu != %hu", sweptsurface->u_isolines, u_isolines);
    sweptsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "unknown", &unknown, NULL)
        && unknown == sweptsurface->unknown)
      pass ();
    else
      fail ("SWEPTSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "unknown", &unknown, 0)
        && unknown == sweptsurface->unknown)
      pass ();
    else
      fail ("SWEPTSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->unknown, unknown);
    sweptsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == sweptsurface->unknown_2007)
      pass ();
    else
      fail ("SWEPTSURFACE.unknown_2007 [BL] %u != %u", sweptsurface->unknown_2007, unknown_2007);
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "unknown_2007", &unknown_2007, 0)
        && unknown_2007 == sweptsurface->unknown_2007)
      pass ();
    else
      fail ("SWEPTSURFACE.unknown_2007 [BL] set+1 %u != %u", sweptsurface->unknown_2007, unknown_2007);
    sweptsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == sweptsurface->v_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.v_isolines [BS] %hu != %hu", sweptsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == sweptsurface->v_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.v_isolines [BS] set+1 %hu != %hu", sweptsurface->v_isolines, v_isolines);
    sweptsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "version", &version, NULL)
        && version == sweptsurface->version)
      pass ();
    else
      fail ("SWEPTSURFACE.version [BS] %hu != %hu", sweptsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "version", &version, 0)
        && version == sweptsurface->version)
      pass ();
    else
      fail ("SWEPTSURFACE.version [BS] set+1 %hu != %hu", sweptsurface->version, version);
    sweptsurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == sweptsurface->wireframe_data_present)
      pass ();
    else
      fail ("SWEPTSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == sweptsurface->wireframe_data_present)
      pass ();
    else
      fail ("SWEPTSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->wireframe_data_present, wireframe_data_present);
    sweptsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "wires", &wires, NULL)
        && wires == sweptsurface->wires)
      pass ();
    else
      fail ("SWEPTSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  return failed;
}
static int test_TABLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TABLE *restrict table = obj->tio.entity->tio.TABLE;
  {
    BITCODE_H* attrib_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "attrib_handles", &attrib_handles, NULL)
        && attrib_handles == table->attrib_handles)
      pass ();
    else
      fail ("TABLE.attrib_handles [H*] * %u num_owned", count);
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value (table, "TABLE", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &table->block_header, sizeof (table->block_header)))
        pass ();
    else
        fail ("TABLE.block_header [H]");
  }
  {
    BITCODE_BL border_color_overrides_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "border_color_overrides_flag", &border_color_overrides_flag, NULL)
        && border_color_overrides_flag == table->border_color_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_color_overrides_flag [BL] %u != %u", table->border_color_overrides_flag, border_color_overrides_flag);
    border_color_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_color_overrides_flag", &border_color_overrides_flag, 0)
        && border_color_overrides_flag == table->border_color_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_color_overrides_flag [BL] set+1 %u != %u", table->border_color_overrides_flag, border_color_overrides_flag);
    table->border_color_overrides_flag--;

  }
  {
    BITCODE_BL border_lineweight_overrides_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "border_lineweight_overrides_flag", &border_lineweight_overrides_flag, NULL)
        && border_lineweight_overrides_flag == table->border_lineweight_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_lineweight_overrides_flag [BL] %u != %u", table->border_lineweight_overrides_flag, border_lineweight_overrides_flag);
    border_lineweight_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_lineweight_overrides_flag", &border_lineweight_overrides_flag, 0)
        && border_lineweight_overrides_flag == table->border_lineweight_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_lineweight_overrides_flag [BL] set+1 %u != %u", table->border_lineweight_overrides_flag, border_lineweight_overrides_flag);
    table->border_lineweight_overrides_flag--;

  }
  {
    BITCODE_BL border_visibility_overrides_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "border_visibility_overrides_flag", &border_visibility_overrides_flag, NULL)
        && border_visibility_overrides_flag == table->border_visibility_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_visibility_overrides_flag [BL] %u != %u", table->border_visibility_overrides_flag, border_visibility_overrides_flag);
    border_visibility_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_visibility_overrides_flag", &border_visibility_overrides_flag, 0)
        && border_visibility_overrides_flag == table->border_visibility_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_visibility_overrides_flag [BL] set+1 %u != %u", table->border_visibility_overrides_flag, border_visibility_overrides_flag);
    table->border_visibility_overrides_flag--;

  }
  {
    BITCODE_BL break_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_flag", &break_flag, NULL)
        && break_flag == table->break_flag)
      pass ();
    else
      fail ("TABLE.break_flag [BL] %u != %u", table->break_flag, break_flag);
    break_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_flag", &break_flag, 0)
        && break_flag == table->break_flag)
      pass ();
    else
      fail ("TABLE.break_flag [BL] set+1 %u != %u", table->break_flag, break_flag);
    table->break_flag--;

  }
  {
    BITCODE_BL break_flow_direction;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_flow_direction", &break_flow_direction, NULL)
        && break_flow_direction == table->break_flow_direction)
      pass ();
    else
      fail ("TABLE.break_flow_direction [BL] %u != %u", table->break_flow_direction, break_flow_direction);
    break_flow_direction++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_flow_direction", &break_flow_direction, 0)
        && break_flow_direction == table->break_flow_direction)
      pass ();
    else
      fail ("TABLE.break_flow_direction [BL] set+1 %u != %u", table->break_flow_direction, break_flow_direction);
    table->break_flow_direction--;

  }
  {
    Dwg_TABLE_BreakHeight* break_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_heights", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "break_heights", &break_heights, NULL)
        && break_heights == table->break_heights)
      pass ();
    else
      fail ("TABLE.break_heights [Dwg_TABLE_BreakHeight*] * %u num_break_heights", count);
  }
  {
    Dwg_TABLE_BreakRow* break_rows;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_rows", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "break_rows", &break_rows, NULL)
        && break_rows == table->break_rows)
      pass ();
    else
      fail ("TABLE.break_rows [Dwg_TABLE_BreakRow*] * %u num_break_rows", count);
  }
  {
    BITCODE_BD break_spacing;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_spacing", &break_spacing, NULL)
        && break_spacing == table->break_spacing)
      pass ();
    else
      fail ("TABLE.break_spacing [BD] %g != %g", table->break_spacing, break_spacing);
    break_spacing++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_spacing", &break_spacing, 0)
        && break_spacing == table->break_spacing)
      pass ();
    else
      fail ("TABLE.break_spacing [BD] set+1 %g != %g", table->break_spacing, break_spacing);
    table->break_spacing--;

  }
  {
    BITCODE_BL break_unknown1;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_unknown1", &break_unknown1, NULL)
        && break_unknown1 == table->break_unknown1)
      pass ();
    else
      fail ("TABLE.break_unknown1 [BL] %u != %u", table->break_unknown1, break_unknown1);
    break_unknown1++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_unknown1", &break_unknown1, 0)
        && break_unknown1 == table->break_unknown1)
      pass ();
    else
      fail ("TABLE.break_unknown1 [BL] set+1 %u != %u", table->break_unknown1, break_unknown1);
    table->break_unknown1--;

  }
  {
    BITCODE_BL break_unknown2;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_unknown2", &break_unknown2, NULL)
        && break_unknown2 == table->break_unknown2)
      pass ();
    else
      fail ("TABLE.break_unknown2 [BL] %u != %u", table->break_unknown2, break_unknown2);
    break_unknown2++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_unknown2", &break_unknown2, 0)
        && break_unknown2 == table->break_unknown2)
      pass ();
    else
      fail ("TABLE.break_unknown2 [BL] set+1 %u != %u", table->break_unknown2, break_unknown2);
    table->break_unknown2--;

  }
  {
    Dwg_TABLE_Cell* cells;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cells", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "cells", &cells, NULL)
        && cells == table->cells)
      pass ();
    else
      fail ("TABLE.cells [Dwg_TABLE_Cell*] * %u num_cells", count);
  }
  {
    BITCODE_BD* col_widths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_col_widths", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "col_widths", &col_widths, NULL)
        && col_widths == table->col_widths)
      pass ();
    else
      fail ("TABLE.col_widths [BD*] * %u num_col_widths", count);
  }
  {
    BITCODE_BB data_flags;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_flags", &data_flags, NULL)
        && data_flags == table->data_flags)
      pass ();
    else
      fail ("TABLE.data_flags [BB] " FORMAT_BB " != " FORMAT_BB "", table->data_flags, data_flags);
    data_flags++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_flags", &data_flags, 0)
        && data_flags == table->data_flags)
      pass ();
    else
      fail ("TABLE.data_flags [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", table->data_flags, data_flags);
    table->data_flags--;

  }
  {
    BITCODE_CMC data_horiz_bottom_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_bottom_color", &data_horiz_bottom_color, NULL)
        && !memcmp (&data_horiz_bottom_color, &table->data_horiz_bottom_color, sizeof (table->data_horiz_bottom_color)))
        pass ();
    else
        fail ("TABLE.data_horiz_bottom_color [CMC]");
  }
  {
    BITCODE_BS data_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_bottom_linewt", &data_horiz_bottom_linewt, NULL)
        && data_horiz_bottom_linewt == table->data_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_linewt [BS] %hu != %hu", table->data_horiz_bottom_linewt, data_horiz_bottom_linewt);
    data_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_bottom_linewt", &data_horiz_bottom_linewt, 0)
        && data_horiz_bottom_linewt == table->data_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->data_horiz_bottom_linewt, data_horiz_bottom_linewt);
    table->data_horiz_bottom_linewt--;

  }
  {
    BITCODE_BS data_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_bottom_visibility", &data_horiz_bottom_visibility, NULL)
        && data_horiz_bottom_visibility == table->data_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_visibility [BS] %hu != %hu", table->data_horiz_bottom_visibility, data_horiz_bottom_visibility);
    data_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_bottom_visibility", &data_horiz_bottom_visibility, 0)
        && data_horiz_bottom_visibility == table->data_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->data_horiz_bottom_visibility, data_horiz_bottom_visibility);
    table->data_horiz_bottom_visibility--;

  }
  {
    BITCODE_CMC data_horiz_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_ins_color", &data_horiz_ins_color, NULL)
        && !memcmp (&data_horiz_ins_color, &table->data_horiz_ins_color, sizeof (table->data_horiz_ins_color)))
        pass ();
    else
        fail ("TABLE.data_horiz_ins_color [CMC]");
  }
  {
    BITCODE_BS data_horiz_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_ins_linewt", &data_horiz_ins_linewt, NULL)
        && data_horiz_ins_linewt == table->data_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_linewt [BS] %hu != %hu", table->data_horiz_ins_linewt, data_horiz_ins_linewt);
    data_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_ins_linewt", &data_horiz_ins_linewt, 0)
        && data_horiz_ins_linewt == table->data_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_linewt [BS] set+1 %hu != %hu", table->data_horiz_ins_linewt, data_horiz_ins_linewt);
    table->data_horiz_ins_linewt--;

  }
  {
    BITCODE_BS data_horiz_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_ins_visibility", &data_horiz_ins_visibility, NULL)
        && data_horiz_ins_visibility == table->data_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_visibility [BS] %hu != %hu", table->data_horiz_ins_visibility, data_horiz_ins_visibility);
    data_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_ins_visibility", &data_horiz_ins_visibility, 0)
        && data_horiz_ins_visibility == table->data_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_visibility [BS] set+1 %hu != %hu", table->data_horiz_ins_visibility, data_horiz_ins_visibility);
    table->data_horiz_ins_visibility--;

  }
  {
    BITCODE_CMC data_horiz_top_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_top_color", &data_horiz_top_color, NULL)
        && !memcmp (&data_horiz_top_color, &table->data_horiz_top_color, sizeof (table->data_horiz_top_color)))
        pass ();
    else
        fail ("TABLE.data_horiz_top_color [CMC]");
  }
  {
    BITCODE_BS data_horiz_top_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_top_linewt", &data_horiz_top_linewt, NULL)
        && data_horiz_top_linewt == table->data_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_top_linewt [BS] %hu != %hu", table->data_horiz_top_linewt, data_horiz_top_linewt);
    data_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_top_linewt", &data_horiz_top_linewt, 0)
        && data_horiz_top_linewt == table->data_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_top_linewt [BS] set+1 %hu != %hu", table->data_horiz_top_linewt, data_horiz_top_linewt);
    table->data_horiz_top_linewt--;

  }
  {
    BITCODE_BS data_horiz_top_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_top_visibility", &data_horiz_top_visibility, NULL)
        && data_horiz_top_visibility == table->data_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_top_visibility [BS] %hu != %hu", table->data_horiz_top_visibility, data_horiz_top_visibility);
    data_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_top_visibility", &data_horiz_top_visibility, 0)
        && data_horiz_top_visibility == table->data_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_top_visibility [BS] set+1 %hu != %hu", table->data_horiz_top_visibility, data_horiz_top_visibility);
    table->data_horiz_top_visibility--;

  }
  {
    BITCODE_BS data_row_alignment;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_alignment", &data_row_alignment, NULL)
        && data_row_alignment == table->data_row_alignment)
      pass ();
    else
      fail ("TABLE.data_row_alignment [BS] %hu != %hu", table->data_row_alignment, data_row_alignment);
    data_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_alignment", &data_row_alignment, 0)
        && data_row_alignment == table->data_row_alignment)
      pass ();
    else
      fail ("TABLE.data_row_alignment [BS] set+1 %hu != %hu", table->data_row_alignment, data_row_alignment);
    table->data_row_alignment--;

  }
  {
    BITCODE_CMC data_row_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_color", &data_row_color, NULL)
        && !memcmp (&data_row_color, &table->data_row_color, sizeof (table->data_row_color)))
        pass ();
    else
        fail ("TABLE.data_row_color [CMC]");
  }
  {
    BITCODE_CMC data_row_fill_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_fill_color", &data_row_fill_color, NULL)
        && !memcmp (&data_row_fill_color, &table->data_row_fill_color, sizeof (table->data_row_fill_color)))
        pass ();
    else
        fail ("TABLE.data_row_fill_color [CMC]");
  }
  {
    BITCODE_B data_row_fill_none;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_fill_none", &data_row_fill_none, NULL)
        && data_row_fill_none == table->data_row_fill_none)
      pass ();
    else
      fail ("TABLE.data_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->data_row_fill_none, data_row_fill_none);
    data_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_fill_none", &data_row_fill_none, 0)
        && data_row_fill_none == table->data_row_fill_none)
      pass ();
    else
      fail ("TABLE.data_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->data_row_fill_none, data_row_fill_none);
    table->data_row_fill_none--;

  }
  {
    BITCODE_BD data_row_height;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_height", &data_row_height, NULL)
        && data_row_height == table->data_row_height)
      pass ();
    else
      fail ("TABLE.data_row_height [BD] %g != %g", table->data_row_height, data_row_height);
    data_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_height", &data_row_height, 0)
        && data_row_height == table->data_row_height)
      pass ();
    else
      fail ("TABLE.data_row_height [BD] set+1 %g != %g", table->data_row_height, data_row_height);
    table->data_row_height--;

  }
  {
    BITCODE_H data_row_style_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_style_override", &data_row_style_override, NULL)
        && !memcmp (&data_row_style_override, &table->data_row_style_override, sizeof (table->data_row_style_override)))
        pass ();
    else
        fail ("TABLE.data_row_style_override [H]");
  }
  {
    BITCODE_H data_text_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_text_style", &data_text_style, NULL)
        && !memcmp (&data_text_style, &table->data_text_style, sizeof (table->data_text_style)))
        pass ();
    else
        fail ("TABLE.data_text_style [H]");
  }
  {
    BITCODE_CMC data_vert_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_ins_color", &data_vert_ins_color, NULL)
        && !memcmp (&data_vert_ins_color, &table->data_vert_ins_color, sizeof (table->data_vert_ins_color)))
        pass ();
    else
        fail ("TABLE.data_vert_ins_color [CMC]");
  }
  {
    BITCODE_BS data_vert_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_ins_linewt", &data_vert_ins_linewt, NULL)
        && data_vert_ins_linewt == table->data_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_ins_linewt [BS] %hu != %hu", table->data_vert_ins_linewt, data_vert_ins_linewt);
    data_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_ins_linewt", &data_vert_ins_linewt, 0)
        && data_vert_ins_linewt == table->data_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_ins_linewt [BS] set+1 %hu != %hu", table->data_vert_ins_linewt, data_vert_ins_linewt);
    table->data_vert_ins_linewt--;

  }
  {
    BITCODE_BS data_vert_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_ins_visibility", &data_vert_ins_visibility, NULL)
        && data_vert_ins_visibility == table->data_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_ins_visibility [BS] %hu != %hu", table->data_vert_ins_visibility, data_vert_ins_visibility);
    data_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_ins_visibility", &data_vert_ins_visibility, 0)
        && data_vert_ins_visibility == table->data_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_ins_visibility [BS] set+1 %hu != %hu", table->data_vert_ins_visibility, data_vert_ins_visibility);
    table->data_vert_ins_visibility--;

  }
  {
    BITCODE_CMC data_vert_left_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_left_color", &data_vert_left_color, NULL)
        && !memcmp (&data_vert_left_color, &table->data_vert_left_color, sizeof (table->data_vert_left_color)))
        pass ();
    else
        fail ("TABLE.data_vert_left_color [CMC]");
  }
  {
    BITCODE_BS data_vert_left_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_left_linewt", &data_vert_left_linewt, NULL)
        && data_vert_left_linewt == table->data_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_left_linewt [BS] %hu != %hu", table->data_vert_left_linewt, data_vert_left_linewt);
    data_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_left_linewt", &data_vert_left_linewt, 0)
        && data_vert_left_linewt == table->data_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_left_linewt [BS] set+1 %hu != %hu", table->data_vert_left_linewt, data_vert_left_linewt);
    table->data_vert_left_linewt--;

  }
  {
    BITCODE_BS data_vert_left_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_left_visibility", &data_vert_left_visibility, NULL)
        && data_vert_left_visibility == table->data_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_left_visibility [BS] %hu != %hu", table->data_vert_left_visibility, data_vert_left_visibility);
    data_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_left_visibility", &data_vert_left_visibility, 0)
        && data_vert_left_visibility == table->data_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_left_visibility [BS] set+1 %hu != %hu", table->data_vert_left_visibility, data_vert_left_visibility);
    table->data_vert_left_visibility--;

  }
  {
    BITCODE_CMC data_vert_right_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_right_color", &data_vert_right_color, NULL)
        && !memcmp (&data_vert_right_color, &table->data_vert_right_color, sizeof (table->data_vert_right_color)))
        pass ();
    else
        fail ("TABLE.data_vert_right_color [CMC]");
  }
  {
    BITCODE_BS data_vert_right_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_right_linewt", &data_vert_right_linewt, NULL)
        && data_vert_right_linewt == table->data_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_right_linewt [BS] %hu != %hu", table->data_vert_right_linewt, data_vert_right_linewt);
    data_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_right_linewt", &data_vert_right_linewt, 0)
        && data_vert_right_linewt == table->data_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_right_linewt [BS] set+1 %hu != %hu", table->data_vert_right_linewt, data_vert_right_linewt);
    table->data_vert_right_linewt--;

  }
  {
    BITCODE_BS data_vert_right_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_right_visibility", &data_vert_right_visibility, NULL)
        && data_vert_right_visibility == table->data_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_right_visibility [BS] %hu != %hu", table->data_vert_right_visibility, data_vert_right_visibility);
    data_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_right_visibility", &data_vert_right_visibility, 0)
        && data_vert_right_visibility == table->data_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_right_visibility [BS] set+1 %hu != %hu", table->data_vert_right_visibility, data_vert_right_visibility);
    table->data_vert_right_visibility--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (table, "TABLE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &table->extrusion, sizeof (table->extrusion)))
        pass ();
    else
        fail ("TABLE.extrusion [BE]");
  }
  {
    Dwg_FormattedTableData fdata;
    if (dwg_dynapi_entity_value (table, "TABLE", "fdata", &fdata, NULL)
        && !memcmp (&fdata, &table->fdata, sizeof (table->fdata)))
        pass ();
    else
        fail ("TABLE.fdata [Dwg_FormattedTableData]");
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value (table, "TABLE", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &table->first_attrib, sizeof (table->first_attrib)))
        pass ();
    else
        fail ("TABLE.first_attrib [H]");
  }
  {
    BITCODE_BS flag_for_table_value;
    if (dwg_dynapi_entity_value (table, "TABLE", "flag_for_table_value", &flag_for_table_value, NULL)
        && flag_for_table_value == table->flag_for_table_value)
      pass ();
    else
      fail ("TABLE.flag_for_table_value [BS] %hu != %hu", table->flag_for_table_value, flag_for_table_value);
    flag_for_table_value++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "flag_for_table_value", &flag_for_table_value, 0)
        && flag_for_table_value == table->flag_for_table_value)
      pass ();
    else
      fail ("TABLE.flag_for_table_value [BS] set+1 %hu != %hu", table->flag_for_table_value, flag_for_table_value);
    table->flag_for_table_value--;

  }
  {
    BITCODE_BS flow_direction;
    if (dwg_dynapi_entity_value (table, "TABLE", "flow_direction", &flow_direction, NULL)
        && flow_direction == table->flow_direction)
      pass ();
    else
      fail ("TABLE.flow_direction [BS] %hu != %hu", table->flow_direction, flow_direction);
    flow_direction++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "flow_direction", &flow_direction, 0)
        && flow_direction == table->flow_direction)
      pass ();
    else
      fail ("TABLE.flow_direction [BS] set+1 %hu != %hu", table->flow_direction, flow_direction);
    table->flow_direction--;

  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_attribs", &has_attribs, NULL)
        && has_attribs == table->has_attribs)
      pass ();
    else
      fail ("TABLE.has_attribs [B] " FORMAT_B " != " FORMAT_B "", table->has_attribs, has_attribs);
    has_attribs++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_attribs", &has_attribs, 0)
        && has_attribs == table->has_attribs)
      pass ();
    else
      fail ("TABLE.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_attribs, has_attribs);
    table->has_attribs--;

  }
  {
    BITCODE_B has_border_color_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_border_color_overrides", &has_border_color_overrides, NULL)
        && has_border_color_overrides == table->has_border_color_overrides)
      pass ();
    else
      fail ("TABLE.has_border_color_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_color_overrides, has_border_color_overrides);
    has_border_color_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_color_overrides", &has_border_color_overrides, 0)
        && has_border_color_overrides == table->has_border_color_overrides)
      pass ();
    else
      fail ("TABLE.has_border_color_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_color_overrides, has_border_color_overrides);
    table->has_border_color_overrides--;

  }
  {
    BITCODE_B has_border_lineweight_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_border_lineweight_overrides", &has_border_lineweight_overrides, NULL)
        && has_border_lineweight_overrides == table->has_border_lineweight_overrides)
      pass ();
    else
      fail ("TABLE.has_border_lineweight_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_lineweight_overrides, has_border_lineweight_overrides);
    has_border_lineweight_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_lineweight_overrides", &has_border_lineweight_overrides, 0)
        && has_border_lineweight_overrides == table->has_border_lineweight_overrides)
      pass ();
    else
      fail ("TABLE.has_border_lineweight_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_lineweight_overrides, has_border_lineweight_overrides);
    table->has_border_lineweight_overrides--;

  }
  {
    BITCODE_B has_border_visibility_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_border_visibility_overrides", &has_border_visibility_overrides, NULL)
        && has_border_visibility_overrides == table->has_border_visibility_overrides)
      pass ();
    else
      fail ("TABLE.has_border_visibility_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_visibility_overrides, has_border_visibility_overrides);
    has_border_visibility_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_visibility_overrides", &has_border_visibility_overrides, 0)
        && has_border_visibility_overrides == table->has_border_visibility_overrides)
      pass ();
    else
      fail ("TABLE.has_border_visibility_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_visibility_overrides, has_border_visibility_overrides);
    table->has_border_visibility_overrides--;

  }
  {
    BITCODE_BL has_break_data;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_break_data", &has_break_data, NULL)
        && has_break_data == table->has_break_data)
      pass ();
    else
      fail ("TABLE.has_break_data [BL] %u != %u", table->has_break_data, has_break_data);
    has_break_data++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_break_data", &has_break_data, 0)
        && has_break_data == table->has_break_data)
      pass ();
    else
      fail ("TABLE.has_break_data [BL] set+1 %u != %u", table->has_break_data, has_break_data);
    table->has_break_data--;

  }
  {
    BITCODE_B has_table_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_table_overrides", &has_table_overrides, NULL)
        && has_table_overrides == table->has_table_overrides)
      pass ();
    else
      fail ("TABLE.has_table_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_table_overrides, has_table_overrides);
    has_table_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_table_overrides", &has_table_overrides, 0)
        && has_table_overrides == table->has_table_overrides)
      pass ();
    else
      fail ("TABLE.has_table_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_table_overrides, has_table_overrides);
    table->has_table_overrides--;

  }
  {
    BITCODE_CMC header_horiz_bottom_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_bottom_color", &header_horiz_bottom_color, NULL)
        && !memcmp (&header_horiz_bottom_color, &table->header_horiz_bottom_color, sizeof (table->header_horiz_bottom_color)))
        pass ();
    else
        fail ("TABLE.header_horiz_bottom_color [CMC]");
  }
  {
    BITCODE_BS header_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_bottom_linewt", &header_horiz_bottom_linewt, NULL)
        && header_horiz_bottom_linewt == table->header_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_linewt [BS] %hu != %hu", table->header_horiz_bottom_linewt, header_horiz_bottom_linewt);
    header_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_bottom_linewt", &header_horiz_bottom_linewt, 0)
        && header_horiz_bottom_linewt == table->header_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->header_horiz_bottom_linewt, header_horiz_bottom_linewt);
    table->header_horiz_bottom_linewt--;

  }
  {
    BITCODE_BS header_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_bottom_visibility", &header_horiz_bottom_visibility, NULL)
        && header_horiz_bottom_visibility == table->header_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_visibility [BS] %hu != %hu", table->header_horiz_bottom_visibility, header_horiz_bottom_visibility);
    header_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_bottom_visibility", &header_horiz_bottom_visibility, 0)
        && header_horiz_bottom_visibility == table->header_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->header_horiz_bottom_visibility, header_horiz_bottom_visibility);
    table->header_horiz_bottom_visibility--;

  }
  {
    BITCODE_CMC header_horiz_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_ins_color", &header_horiz_ins_color, NULL)
        && !memcmp (&header_horiz_ins_color, &table->header_horiz_ins_color, sizeof (table->header_horiz_ins_color)))
        pass ();
    else
        fail ("TABLE.header_horiz_ins_color [CMC]");
  }
  {
    BITCODE_BS header_horiz_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_ins_linewt", &header_horiz_ins_linewt, NULL)
        && header_horiz_ins_linewt == table->header_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_linewt [BS] %hu != %hu", table->header_horiz_ins_linewt, header_horiz_ins_linewt);
    header_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_ins_linewt", &header_horiz_ins_linewt, 0)
        && header_horiz_ins_linewt == table->header_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_linewt [BS] set+1 %hu != %hu", table->header_horiz_ins_linewt, header_horiz_ins_linewt);
    table->header_horiz_ins_linewt--;

  }
  {
    BITCODE_BS header_horiz_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_ins_visibility", &header_horiz_ins_visibility, NULL)
        && header_horiz_ins_visibility == table->header_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_visibility [BS] %hu != %hu", table->header_horiz_ins_visibility, header_horiz_ins_visibility);
    header_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_ins_visibility", &header_horiz_ins_visibility, 0)
        && header_horiz_ins_visibility == table->header_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_visibility [BS] set+1 %hu != %hu", table->header_horiz_ins_visibility, header_horiz_ins_visibility);
    table->header_horiz_ins_visibility--;

  }
  {
    BITCODE_CMC header_horiz_top_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_top_color", &header_horiz_top_color, NULL)
        && !memcmp (&header_horiz_top_color, &table->header_horiz_top_color, sizeof (table->header_horiz_top_color)))
        pass ();
    else
        fail ("TABLE.header_horiz_top_color [CMC]");
  }
  {
    BITCODE_BS header_horiz_top_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_top_linewt", &header_horiz_top_linewt, NULL)
        && header_horiz_top_linewt == table->header_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_top_linewt [BS] %hu != %hu", table->header_horiz_top_linewt, header_horiz_top_linewt);
    header_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_top_linewt", &header_horiz_top_linewt, 0)
        && header_horiz_top_linewt == table->header_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_top_linewt [BS] set+1 %hu != %hu", table->header_horiz_top_linewt, header_horiz_top_linewt);
    table->header_horiz_top_linewt--;

  }
  {
    BITCODE_BS header_horiz_top_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_top_visibility", &header_horiz_top_visibility, NULL)
        && header_horiz_top_visibility == table->header_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_top_visibility [BS] %hu != %hu", table->header_horiz_top_visibility, header_horiz_top_visibility);
    header_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_top_visibility", &header_horiz_top_visibility, 0)
        && header_horiz_top_visibility == table->header_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_top_visibility [BS] set+1 %hu != %hu", table->header_horiz_top_visibility, header_horiz_top_visibility);
    table->header_horiz_top_visibility--;

  }
  {
    BITCODE_BS header_row_alignment;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_alignment", &header_row_alignment, NULL)
        && header_row_alignment == table->header_row_alignment)
      pass ();
    else
      fail ("TABLE.header_row_alignment [BS] %hu != %hu", table->header_row_alignment, header_row_alignment);
    header_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_alignment", &header_row_alignment, 0)
        && header_row_alignment == table->header_row_alignment)
      pass ();
    else
      fail ("TABLE.header_row_alignment [BS] set+1 %hu != %hu", table->header_row_alignment, header_row_alignment);
    table->header_row_alignment--;

  }
  {
    BITCODE_CMC header_row_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_color", &header_row_color, NULL)
        && !memcmp (&header_row_color, &table->header_row_color, sizeof (table->header_row_color)))
        pass ();
    else
        fail ("TABLE.header_row_color [CMC]");
  }
  {
    BITCODE_CMC header_row_fill_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_fill_color", &header_row_fill_color, NULL)
        && !memcmp (&header_row_fill_color, &table->header_row_fill_color, sizeof (table->header_row_fill_color)))
        pass ();
    else
        fail ("TABLE.header_row_fill_color [CMC]");
  }
  {
    BITCODE_B header_row_fill_none;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_fill_none", &header_row_fill_none, NULL)
        && header_row_fill_none == table->header_row_fill_none)
      pass ();
    else
      fail ("TABLE.header_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->header_row_fill_none, header_row_fill_none);
    header_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_fill_none", &header_row_fill_none, 0)
        && header_row_fill_none == table->header_row_fill_none)
      pass ();
    else
      fail ("TABLE.header_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->header_row_fill_none, header_row_fill_none);
    table->header_row_fill_none--;

  }
  {
    BITCODE_BD header_row_height;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_height", &header_row_height, NULL)
        && header_row_height == table->header_row_height)
      pass ();
    else
      fail ("TABLE.header_row_height [BD] %g != %g", table->header_row_height, header_row_height);
    header_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_height", &header_row_height, 0)
        && header_row_height == table->header_row_height)
      pass ();
    else
      fail ("TABLE.header_row_height [BD] set+1 %g != %g", table->header_row_height, header_row_height);
    table->header_row_height--;

  }
  {
    BITCODE_H header_row_style_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_style_override", &header_row_style_override, NULL)
        && !memcmp (&header_row_style_override, &table->header_row_style_override, sizeof (table->header_row_style_override)))
        pass ();
    else
        fail ("TABLE.header_row_style_override [H]");
  }
  {
    BITCODE_B header_suppressed;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_suppressed", &header_suppressed, NULL)
        && header_suppressed == table->header_suppressed)
      pass ();
    else
      fail ("TABLE.header_suppressed [B] " FORMAT_B " != " FORMAT_B "", table->header_suppressed, header_suppressed);
    header_suppressed++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_suppressed", &header_suppressed, 0)
        && header_suppressed == table->header_suppressed)
      pass ();
    else
      fail ("TABLE.header_suppressed [B] set+1 " FORMAT_B " != " FORMAT_B "", table->header_suppressed, header_suppressed);
    table->header_suppressed--;

  }
  {
    BITCODE_H header_text_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_text_style", &header_text_style, NULL)
        && !memcmp (&header_text_style, &table->header_text_style, sizeof (table->header_text_style)))
        pass ();
    else
        fail ("TABLE.header_text_style [H]");
  }
  {
    BITCODE_CMC header_vert_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_ins_color", &header_vert_ins_color, NULL)
        && !memcmp (&header_vert_ins_color, &table->header_vert_ins_color, sizeof (table->header_vert_ins_color)))
        pass ();
    else
        fail ("TABLE.header_vert_ins_color [CMC]");
  }
  {
    BITCODE_BS header_vert_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_ins_linewt", &header_vert_ins_linewt, NULL)
        && header_vert_ins_linewt == table->header_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_ins_linewt [BS] %hu != %hu", table->header_vert_ins_linewt, header_vert_ins_linewt);
    header_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_ins_linewt", &header_vert_ins_linewt, 0)
        && header_vert_ins_linewt == table->header_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_ins_linewt [BS] set+1 %hu != %hu", table->header_vert_ins_linewt, header_vert_ins_linewt);
    table->header_vert_ins_linewt--;

  }
  {
    BITCODE_BS header_vert_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_ins_visibility", &header_vert_ins_visibility, NULL)
        && header_vert_ins_visibility == table->header_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_ins_visibility [BS] %hu != %hu", table->header_vert_ins_visibility, header_vert_ins_visibility);
    header_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_ins_visibility", &header_vert_ins_visibility, 0)
        && header_vert_ins_visibility == table->header_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_ins_visibility [BS] set+1 %hu != %hu", table->header_vert_ins_visibility, header_vert_ins_visibility);
    table->header_vert_ins_visibility--;

  }
  {
    BITCODE_CMC header_vert_left_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_left_color", &header_vert_left_color, NULL)
        && !memcmp (&header_vert_left_color, &table->header_vert_left_color, sizeof (table->header_vert_left_color)))
        pass ();
    else
        fail ("TABLE.header_vert_left_color [CMC]");
  }
  {
    BITCODE_BS header_vert_left_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_left_linewt", &header_vert_left_linewt, NULL)
        && header_vert_left_linewt == table->header_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_left_linewt [BS] %hu != %hu", table->header_vert_left_linewt, header_vert_left_linewt);
    header_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_left_linewt", &header_vert_left_linewt, 0)
        && header_vert_left_linewt == table->header_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_left_linewt [BS] set+1 %hu != %hu", table->header_vert_left_linewt, header_vert_left_linewt);
    table->header_vert_left_linewt--;

  }
  {
    BITCODE_BS header_vert_left_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_left_visibility", &header_vert_left_visibility, NULL)
        && header_vert_left_visibility == table->header_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_left_visibility [BS] %hu != %hu", table->header_vert_left_visibility, header_vert_left_visibility);
    header_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_left_visibility", &header_vert_left_visibility, 0)
        && header_vert_left_visibility == table->header_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_left_visibility [BS] set+1 %hu != %hu", table->header_vert_left_visibility, header_vert_left_visibility);
    table->header_vert_left_visibility--;

  }
  {
    BITCODE_CMC header_vert_right_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_right_color", &header_vert_right_color, NULL)
        && !memcmp (&header_vert_right_color, &table->header_vert_right_color, sizeof (table->header_vert_right_color)))
        pass ();
    else
        fail ("TABLE.header_vert_right_color [CMC]");
  }
  {
    BITCODE_BS header_vert_right_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_right_linewt", &header_vert_right_linewt, NULL)
        && header_vert_right_linewt == table->header_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_right_linewt [BS] %hu != %hu", table->header_vert_right_linewt, header_vert_right_linewt);
    header_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_right_linewt", &header_vert_right_linewt, 0)
        && header_vert_right_linewt == table->header_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_right_linewt [BS] set+1 %hu != %hu", table->header_vert_right_linewt, header_vert_right_linewt);
    table->header_vert_right_linewt--;

  }
  {
    BITCODE_BS header_vert_right_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_right_visibility", &header_vert_right_visibility, NULL)
        && header_vert_right_visibility == table->header_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_right_visibility [BS] %hu != %hu", table->header_vert_right_visibility, header_vert_right_visibility);
    header_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_right_visibility", &header_vert_right_visibility, 0)
        && header_vert_right_visibility == table->header_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_right_visibility [BS] set+1 %hu != %hu", table->header_vert_right_visibility, header_vert_right_visibility);
    table->header_vert_right_visibility--;

  }
  {
    BITCODE_3BD hor_dir;
    if (dwg_dynapi_entity_value (table, "TABLE", "hor_dir", &hor_dir, NULL)
        && !memcmp (&hor_dir, &table->hor_dir, sizeof (table->hor_dir)))
        pass ();
    else
        fail ("TABLE.hor_dir [3BD]");
  }
  {
    BITCODE_BD horiz_cell_margin;
    if (dwg_dynapi_entity_value (table, "TABLE", "horiz_cell_margin", &horiz_cell_margin, NULL)
        && horiz_cell_margin == table->horiz_cell_margin)
      pass ();
    else
      fail ("TABLE.horiz_cell_margin [BD] %g != %g", table->horiz_cell_margin, horiz_cell_margin);
    horiz_cell_margin++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "horiz_cell_margin", &horiz_cell_margin, 0)
        && horiz_cell_margin == table->horiz_cell_margin)
      pass ();
    else
      fail ("TABLE.horiz_cell_margin [BD] set+1 %g != %g", table->horiz_cell_margin, horiz_cell_margin);
    table->horiz_cell_margin--;

  }
  {
    BITCODE_3BD horiz_direction;
    if (dwg_dynapi_entity_value (table, "TABLE", "horiz_direction", &horiz_direction, NULL)
        && !memcmp (&horiz_direction, &table->horiz_direction, sizeof (table->horiz_direction)))
        pass ();
    else
        fail ("TABLE.horiz_direction [3BD]");
  }
  {
    BITCODE_3BD insertion_point;
    if (dwg_dynapi_entity_value (table, "TABLE", "insertion_point", &insertion_point, NULL)
        && !memcmp (&insertion_point, &table->insertion_point, sizeof (table->insertion_point)))
        pass ();
    else
        fail ("TABLE.insertion_point [3BD]");
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value (table, "TABLE", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &table->last_attrib, sizeof (table->last_attrib)))
        pass ();
    else
        fail ("TABLE.last_attrib [H]");
  }
  {
    Dwg_LinkedData ldata;
    if (dwg_dynapi_entity_value (table, "TABLE", "ldata", &ldata, NULL)
        && !memcmp (&ldata, &table->ldata, sizeof (table->ldata)))
        pass ();
    else
        fail ("TABLE.ldata [Dwg_LinkedData]");
  }
  {
    BITCODE_BL num_break_heights;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_heights", &num_break_heights, NULL)
        && num_break_heights == table->num_break_heights)
      pass ();
    else
      fail ("TABLE.num_break_heights [BL] %u != %u", table->num_break_heights, num_break_heights);
    num_break_heights++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_break_heights", &num_break_heights, 0)
        && num_break_heights == table->num_break_heights)
      pass ();
    else
      fail ("TABLE.num_break_heights [BL] set+1 %u != %u", table->num_break_heights, num_break_heights);
    table->num_break_heights--;

  }
  {
    BITCODE_BL num_break_rows;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_rows", &num_break_rows, NULL)
        && num_break_rows == table->num_break_rows)
      pass ();
    else
      fail ("TABLE.num_break_rows [BL] %u != %u", table->num_break_rows, num_break_rows);
    num_break_rows++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_break_rows", &num_break_rows, 0)
        && num_break_rows == table->num_break_rows)
      pass ();
    else
      fail ("TABLE.num_break_rows [BL] set+1 %u != %u", table->num_break_rows, num_break_rows);
    table->num_break_rows--;

  }
  {
    unsigned long num_cells;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cells", &num_cells, NULL)
        && num_cells == table->num_cells)
      pass ();
    else
      fail ("TABLE.num_cells [unsigned long] %lu != %lu", table->num_cells, num_cells);
    num_cells++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_cells", &num_cells, 0)
        && num_cells == table->num_cells)
      pass ();
    else
      fail ("TABLE.num_cells [unsigned long] set+1 %lu != %lu", table->num_cells, num_cells);
    table->num_cells--;

  }
  {
    BITCODE_BL num_cols;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cols", &num_cols, NULL)
        && num_cols == table->num_cols)
      pass ();
    else
      fail ("TABLE.num_cols [BL] %u != %u", table->num_cols, num_cols);
    num_cols++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_cols", &num_cols, 0)
        && num_cols == table->num_cols)
      pass ();
    else
      fail ("TABLE.num_cols [BL] set+1 %u != %u", table->num_cols, num_cols);
    table->num_cols--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_owned", &num_owned, NULL)
        && num_owned == table->num_owned)
      pass ();
    else
      fail ("TABLE.num_owned [BL] %u != %u", table->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_owned", &num_owned, 0)
        && num_owned == table->num_owned)
      pass ();
    else
      fail ("TABLE.num_owned [BL] set+1 %u != %u", table->num_owned, num_owned);
    table->num_owned--;

  }
  {
    BITCODE_BL num_rows;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_rows", &num_rows, NULL)
        && num_rows == table->num_rows)
      pass ();
    else
      fail ("TABLE.num_rows [BL] %u != %u", table->num_rows, num_rows);
    num_rows++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_rows", &num_rows, 0)
        && num_rows == table->num_rows)
      pass ();
    else
      fail ("TABLE.num_rows [BL] set+1 %u != %u", table->num_rows, num_rows);
    table->num_rows--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (table, "TABLE", "parent", &parent, NULL)
        && !memcmp (&parent, &table->parent, sizeof (table->parent)))
        pass ();
    else
        fail ("TABLE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (table, "TABLE", "rotation", &rotation, NULL)
        && rotation == table->rotation)
      pass ();
    else
      fail ("TABLE.rotation [BD] %g != %g", table->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "rotation", &rotation, 0)
        && rotation == table->rotation)
      pass ();
    else
      fail ("TABLE.rotation [BD] set+1 %g != %g", table->rotation, rotation);
    table->rotation--;

  }
  {
    BITCODE_BD* row_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_row_heights", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "row_heights", &row_heights, NULL)
        && row_heights == table->row_heights)
      pass ();
    else
      fail ("TABLE.row_heights [BD*] * %u num_row_heights", count);
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (table, "TABLE", "scale", &scale, NULL)
        && !memcmp (&scale, &table->scale, sizeof (table->scale)))
        pass ();
    else
        fail ("TABLE.scale [3BD_1]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (table, "TABLE", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &table->seqend, sizeof (table->seqend)))
        pass ();
    else
        fail ("TABLE.seqend [H]");
  }
  {
    BITCODE_BL table_flag_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "table_flag_override", &table_flag_override, NULL)
        && table_flag_override == table->table_flag_override)
      pass ();
    else
      fail ("TABLE.table_flag_override [BL] %u != %u", table->table_flag_override, table_flag_override);
    table_flag_override++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "table_flag_override", &table_flag_override, 0)
        && table_flag_override == table->table_flag_override)
      pass ();
    else
      fail ("TABLE.table_flag_override [BL] set+1 %u != %u", table->table_flag_override, table_flag_override);
    table->table_flag_override--;

  }
  {
    BITCODE_H table_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "table_style", &table_style, NULL)
        && !memcmp (&table_style, &table->table_style, sizeof (table->table_style)))
        pass ();
    else
        fail ("TABLE.table_style [H]");
  }
  {
    Dwg_LinkedTableData tdata;
    if (dwg_dynapi_entity_value (table, "TABLE", "tdata", &tdata, NULL)
        && !memcmp (&tdata, &table->tdata, sizeof (table->tdata)))
        pass ();
    else
        fail ("TABLE.tdata [Dwg_LinkedTableData]");
  }
  {
    BITCODE_CMC title_horiz_bottom_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_bottom_color", &title_horiz_bottom_color, NULL)
        && !memcmp (&title_horiz_bottom_color, &table->title_horiz_bottom_color, sizeof (table->title_horiz_bottom_color)))
        pass ();
    else
        fail ("TABLE.title_horiz_bottom_color [CMC]");
  }
  {
    BITCODE_BS title_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_bottom_linewt", &title_horiz_bottom_linewt, NULL)
        && title_horiz_bottom_linewt == table->title_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_linewt [BS] %hu != %hu", table->title_horiz_bottom_linewt, title_horiz_bottom_linewt);
    title_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_bottom_linewt", &title_horiz_bottom_linewt, 0)
        && title_horiz_bottom_linewt == table->title_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->title_horiz_bottom_linewt, title_horiz_bottom_linewt);
    table->title_horiz_bottom_linewt--;

  }
  {
    BITCODE_BS title_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_bottom_visibility", &title_horiz_bottom_visibility, NULL)
        && title_horiz_bottom_visibility == table->title_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_visibility [BS] %hu != %hu", table->title_horiz_bottom_visibility, title_horiz_bottom_visibility);
    title_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_bottom_visibility", &title_horiz_bottom_visibility, 0)
        && title_horiz_bottom_visibility == table->title_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->title_horiz_bottom_visibility, title_horiz_bottom_visibility);
    table->title_horiz_bottom_visibility--;

  }
  {
    BITCODE_CMC title_horiz_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_ins_color", &title_horiz_ins_color, NULL)
        && !memcmp (&title_horiz_ins_color, &table->title_horiz_ins_color, sizeof (table->title_horiz_ins_color)))
        pass ();
    else
        fail ("TABLE.title_horiz_ins_color [CMC]");
  }
  {
    BITCODE_BS title_horiz_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_ins_linewt", &title_horiz_ins_linewt, NULL)
        && title_horiz_ins_linewt == table->title_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_linewt [BS] %hu != %hu", table->title_horiz_ins_linewt, title_horiz_ins_linewt);
    title_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_ins_linewt", &title_horiz_ins_linewt, 0)
        && title_horiz_ins_linewt == table->title_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_linewt [BS] set+1 %hu != %hu", table->title_horiz_ins_linewt, title_horiz_ins_linewt);
    table->title_horiz_ins_linewt--;

  }
  {
    BITCODE_BS title_horiz_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_ins_visibility", &title_horiz_ins_visibility, NULL)
        && title_horiz_ins_visibility == table->title_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_visibility [BS] %hu != %hu", table->title_horiz_ins_visibility, title_horiz_ins_visibility);
    title_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_ins_visibility", &title_horiz_ins_visibility, 0)
        && title_horiz_ins_visibility == table->title_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_visibility [BS] set+1 %hu != %hu", table->title_horiz_ins_visibility, title_horiz_ins_visibility);
    table->title_horiz_ins_visibility--;

  }
  {
    BITCODE_CMC title_horiz_top_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_top_color", &title_horiz_top_color, NULL)
        && !memcmp (&title_horiz_top_color, &table->title_horiz_top_color, sizeof (table->title_horiz_top_color)))
        pass ();
    else
        fail ("TABLE.title_horiz_top_color [CMC]");
  }
  {
    BITCODE_BS title_horiz_top_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_top_linewt", &title_horiz_top_linewt, NULL)
        && title_horiz_top_linewt == table->title_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_top_linewt [BS] %hu != %hu", table->title_horiz_top_linewt, title_horiz_top_linewt);
    title_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_top_linewt", &title_horiz_top_linewt, 0)
        && title_horiz_top_linewt == table->title_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_top_linewt [BS] set+1 %hu != %hu", table->title_horiz_top_linewt, title_horiz_top_linewt);
    table->title_horiz_top_linewt--;

  }
  {
    BITCODE_BS title_horiz_top_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_top_visibility", &title_horiz_top_visibility, NULL)
        && title_horiz_top_visibility == table->title_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_top_visibility [BS] %hu != %hu", table->title_horiz_top_visibility, title_horiz_top_visibility);
    title_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_top_visibility", &title_horiz_top_visibility, 0)
        && title_horiz_top_visibility == table->title_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_top_visibility [BS] set+1 %hu != %hu", table->title_horiz_top_visibility, title_horiz_top_visibility);
    table->title_horiz_top_visibility--;

  }
  {
    BITCODE_BS title_row_alignment;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_alignment", &title_row_alignment, NULL)
        && title_row_alignment == table->title_row_alignment)
      pass ();
    else
      fail ("TABLE.title_row_alignment [BS] %hu != %hu", table->title_row_alignment, title_row_alignment);
    title_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_alignment", &title_row_alignment, 0)
        && title_row_alignment == table->title_row_alignment)
      pass ();
    else
      fail ("TABLE.title_row_alignment [BS] set+1 %hu != %hu", table->title_row_alignment, title_row_alignment);
    table->title_row_alignment--;

  }
  {
    BITCODE_CMC title_row_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_color", &title_row_color, NULL)
        && !memcmp (&title_row_color, &table->title_row_color, sizeof (table->title_row_color)))
        pass ();
    else
        fail ("TABLE.title_row_color [CMC]");
  }
  {
    BITCODE_CMC title_row_fill_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_fill_color", &title_row_fill_color, NULL)
        && !memcmp (&title_row_fill_color, &table->title_row_fill_color, sizeof (table->title_row_fill_color)))
        pass ();
    else
        fail ("TABLE.title_row_fill_color [CMC]");
  }
  {
    BITCODE_B title_row_fill_none;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_fill_none", &title_row_fill_none, NULL)
        && title_row_fill_none == table->title_row_fill_none)
      pass ();
    else
      fail ("TABLE.title_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->title_row_fill_none, title_row_fill_none);
    title_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_fill_none", &title_row_fill_none, 0)
        && title_row_fill_none == table->title_row_fill_none)
      pass ();
    else
      fail ("TABLE.title_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->title_row_fill_none, title_row_fill_none);
    table->title_row_fill_none--;

  }
  {
    BITCODE_BD title_row_height;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_height", &title_row_height, NULL)
        && title_row_height == table->title_row_height)
      pass ();
    else
      fail ("TABLE.title_row_height [BD] %g != %g", table->title_row_height, title_row_height);
    title_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_height", &title_row_height, 0)
        && title_row_height == table->title_row_height)
      pass ();
    else
      fail ("TABLE.title_row_height [BD] set+1 %g != %g", table->title_row_height, title_row_height);
    table->title_row_height--;

  }
  {
    BITCODE_H title_row_style_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_style_override", &title_row_style_override, NULL)
        && !memcmp (&title_row_style_override, &table->title_row_style_override, sizeof (table->title_row_style_override)))
        pass ();
    else
        fail ("TABLE.title_row_style_override [H]");
  }
  {
    BITCODE_B title_suppressed;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_suppressed", &title_suppressed, NULL)
        && title_suppressed == table->title_suppressed)
      pass ();
    else
      fail ("TABLE.title_suppressed [B] " FORMAT_B " != " FORMAT_B "", table->title_suppressed, title_suppressed);
    title_suppressed++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_suppressed", &title_suppressed, 0)
        && title_suppressed == table->title_suppressed)
      pass ();
    else
      fail ("TABLE.title_suppressed [B] set+1 " FORMAT_B " != " FORMAT_B "", table->title_suppressed, title_suppressed);
    table->title_suppressed--;

  }
  {
    BITCODE_H title_text_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_text_style", &title_text_style, NULL)
        && !memcmp (&title_text_style, &table->title_text_style, sizeof (table->title_text_style)))
        pass ();
    else
        fail ("TABLE.title_text_style [H]");
  }
  {
    BITCODE_CMC title_vert_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_ins_color", &title_vert_ins_color, NULL)
        && !memcmp (&title_vert_ins_color, &table->title_vert_ins_color, sizeof (table->title_vert_ins_color)))
        pass ();
    else
        fail ("TABLE.title_vert_ins_color [CMC]");
  }
  {
    BITCODE_BS title_vert_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_ins_linewt", &title_vert_ins_linewt, NULL)
        && title_vert_ins_linewt == table->title_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_ins_linewt [BS] %hu != %hu", table->title_vert_ins_linewt, title_vert_ins_linewt);
    title_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_ins_linewt", &title_vert_ins_linewt, 0)
        && title_vert_ins_linewt == table->title_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_ins_linewt [BS] set+1 %hu != %hu", table->title_vert_ins_linewt, title_vert_ins_linewt);
    table->title_vert_ins_linewt--;

  }
  {
    BITCODE_BS title_vert_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_ins_visibility", &title_vert_ins_visibility, NULL)
        && title_vert_ins_visibility == table->title_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_ins_visibility [BS] %hu != %hu", table->title_vert_ins_visibility, title_vert_ins_visibility);
    title_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_ins_visibility", &title_vert_ins_visibility, 0)
        && title_vert_ins_visibility == table->title_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_ins_visibility [BS] set+1 %hu != %hu", table->title_vert_ins_visibility, title_vert_ins_visibility);
    table->title_vert_ins_visibility--;

  }
  {
    BITCODE_CMC title_vert_left_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_left_color", &title_vert_left_color, NULL)
        && !memcmp (&title_vert_left_color, &table->title_vert_left_color, sizeof (table->title_vert_left_color)))
        pass ();
    else
        fail ("TABLE.title_vert_left_color [CMC]");
  }
  {
    BITCODE_BS title_vert_left_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_left_linewt", &title_vert_left_linewt, NULL)
        && title_vert_left_linewt == table->title_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_left_linewt [BS] %hu != %hu", table->title_vert_left_linewt, title_vert_left_linewt);
    title_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_left_linewt", &title_vert_left_linewt, 0)
        && title_vert_left_linewt == table->title_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_left_linewt [BS] set+1 %hu != %hu", table->title_vert_left_linewt, title_vert_left_linewt);
    table->title_vert_left_linewt--;

  }
  {
    BITCODE_BS title_vert_left_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_left_visibility", &title_vert_left_visibility, NULL)
        && title_vert_left_visibility == table->title_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_left_visibility [BS] %hu != %hu", table->title_vert_left_visibility, title_vert_left_visibility);
    title_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_left_visibility", &title_vert_left_visibility, 0)
        && title_vert_left_visibility == table->title_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_left_visibility [BS] set+1 %hu != %hu", table->title_vert_left_visibility, title_vert_left_visibility);
    table->title_vert_left_visibility--;

  }
  {
    BITCODE_CMC title_vert_right_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_right_color", &title_vert_right_color, NULL)
        && !memcmp (&title_vert_right_color, &table->title_vert_right_color, sizeof (table->title_vert_right_color)))
        pass ();
    else
        fail ("TABLE.title_vert_right_color [CMC]");
  }
  {
    BITCODE_BS title_vert_right_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_right_linewt", &title_vert_right_linewt, NULL)
        && title_vert_right_linewt == table->title_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_right_linewt [BS] %hu != %hu", table->title_vert_right_linewt, title_vert_right_linewt);
    title_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_right_linewt", &title_vert_right_linewt, 0)
        && title_vert_right_linewt == table->title_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_right_linewt [BS] set+1 %hu != %hu", table->title_vert_right_linewt, title_vert_right_linewt);
    table->title_vert_right_linewt--;

  }
  {
    BITCODE_BS title_vert_right_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_right_visibility", &title_vert_right_visibility, NULL)
        && title_vert_right_visibility == table->title_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_right_visibility [BS] %hu != %hu", table->title_vert_right_visibility, title_vert_right_visibility);
    title_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_right_visibility", &title_vert_right_visibility, 0)
        && title_vert_right_visibility == table->title_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_right_visibility [BS] set+1 %hu != %hu", table->title_vert_right_visibility, title_vert_right_visibility);
    table->title_vert_right_visibility--;

  }
  {
    BITCODE_B unknown_b;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_b", &unknown_b, NULL)
        && unknown_b == table->unknown_b)
      pass ();
    else
      fail ("TABLE.unknown_b [B] " FORMAT_B " != " FORMAT_B "", table->unknown_b, unknown_b);
    unknown_b++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_b", &unknown_b, 0)
        && unknown_b == table->unknown_b)
      pass ();
    else
      fail ("TABLE.unknown_b [B] set+1 " FORMAT_B " != " FORMAT_B "", table->unknown_b, unknown_b);
    table->unknown_b--;

  }
  {
    BITCODE_BL unknown_bl;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_bl", &unknown_bl, NULL)
        && unknown_bl == table->unknown_bl)
      pass ();
    else
      fail ("TABLE.unknown_bl [BL] %u != %u", table->unknown_bl, unknown_bl);
    unknown_bl++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bl", &unknown_bl, 0)
        && unknown_bl == table->unknown_bl)
      pass ();
    else
      fail ("TABLE.unknown_bl [BL] set+1 %u != %u", table->unknown_bl, unknown_bl);
    table->unknown_bl--;

  }
  {
    BITCODE_BL unknown_bl1;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_bl1", &unknown_bl1, NULL)
        && unknown_bl1 == table->unknown_bl1)
      pass ();
    else
      fail ("TABLE.unknown_bl1 [BL] %u != %u", table->unknown_bl1, unknown_bl1);
    unknown_bl1++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bl1", &unknown_bl1, 0)
        && unknown_bl1 == table->unknown_bl1)
      pass ();
    else
      fail ("TABLE.unknown_bl1 [BL] set+1 %u != %u", table->unknown_bl1, unknown_bl1);
    table->unknown_bl1--;

  }
  {
    BITCODE_BS unknown_bs;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_bs", &unknown_bs, NULL)
        && unknown_bs == table->unknown_bs)
      pass ();
    else
      fail ("TABLE.unknown_bs [BS] %hu != %hu", table->unknown_bs, unknown_bs);
    unknown_bs++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bs", &unknown_bs, 0)
        && unknown_bs == table->unknown_bs)
      pass ();
    else
      fail ("TABLE.unknown_bs [BS] set+1 %hu != %hu", table->unknown_bs, unknown_bs);
    table->unknown_bs--;

  }
  {
    BITCODE_H unknown_h;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_h", &unknown_h, NULL)
        && !memcmp (&unknown_h, &table->unknown_h, sizeof (table->unknown_h)))
        pass ();
    else
        fail ("TABLE.unknown_h [H]");
  }
  {
    BITCODE_RC unknown_rc;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_rc", &unknown_rc, NULL)
        && unknown_rc == table->unknown_rc)
      pass ();
    else
      fail ("TABLE.unknown_rc [RC] %u != %u", table->unknown_rc, unknown_rc);
    unknown_rc++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_rc", &unknown_rc, 0)
        && unknown_rc == table->unknown_rc)
      pass ();
    else
      fail ("TABLE.unknown_rc [RC] set+1 %u != %u", table->unknown_rc, unknown_rc);
    table->unknown_rc--;

  }
  {
    BITCODE_BD vert_cell_margin;
    if (dwg_dynapi_entity_value (table, "TABLE", "vert_cell_margin", &vert_cell_margin, NULL)
        && vert_cell_margin == table->vert_cell_margin)
      pass ();
    else
      fail ("TABLE.vert_cell_margin [BD] %g != %g", table->vert_cell_margin, vert_cell_margin);
    vert_cell_margin++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "vert_cell_margin", &vert_cell_margin, 0)
        && vert_cell_margin == table->vert_cell_margin)
      pass ();
    else
      fail ("TABLE.vert_cell_margin [BD] set+1 %g != %g", table->vert_cell_margin, vert_cell_margin);
    table->vert_cell_margin--;

  }
  return failed;
}
static int test_TEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TEXT *restrict text = obj->tio.entity->tio.TEXT;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value (text, "TEXT", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &text->alignment_pt, sizeof (text->alignment_pt)))
        pass ();
    else
        fail ("TEXT.alignment_pt [2DPOINT]");
  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value (text, "TEXT", "dataflags", &dataflags, NULL)
        && dataflags == text->dataflags)
      pass ();
    else
      fail ("TEXT.dataflags [RC] %u != %u", text->dataflags, dataflags);
    dataflags++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "dataflags", &dataflags, 0)
        && dataflags == text->dataflags)
      pass ();
    else
      fail ("TEXT.dataflags [RC] set+1 %u != %u", text->dataflags, dataflags);
    text->dataflags--;

  }
  {
    BITCODE_RD elevation;
    if (dwg_dynapi_entity_value (text, "TEXT", "elevation", &elevation, NULL)
        && elevation == text->elevation)
      pass ();
    else
      fail ("TEXT.elevation [RD] %g != %g", text->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "elevation", &elevation, 0)
        && elevation == text->elevation)
      pass ();
    else
      fail ("TEXT.elevation [RD] set+1 %g != %g", text->elevation, elevation);
    text->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (text, "TEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &text->extrusion, sizeof (text->extrusion)))
        pass ();
    else
        fail ("TEXT.extrusion [BE]");
  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value (text, "TEXT", "generation", &generation, NULL)
        && generation == text->generation)
      pass ();
    else
      fail ("TEXT.generation [BS] %hu != %hu", text->generation, generation);
    generation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "generation", &generation, 0)
        && generation == text->generation)
      pass ();
    else
      fail ("TEXT.generation [BS] set+1 %hu != %hu", text->generation, generation);
    text->generation--;

  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value (text, "TEXT", "height", &height, NULL)
        && height == text->height)
      pass ();
    else
      fail ("TEXT.height [RD] %g != %g", text->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "height", &height, 0)
        && height == text->height)
      pass ();
    else
      fail ("TEXT.height [RD] set+1 %g != %g", text->height, height);
    text->height--;

  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value (text, "TEXT", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == text->horiz_alignment)
      pass ();
    else
      fail ("TEXT.horiz_alignment [BS] %hu != %hu", text->horiz_alignment, horiz_alignment);
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "horiz_alignment", &horiz_alignment, 0)
        && horiz_alignment == text->horiz_alignment)
      pass ();
    else
      fail ("TEXT.horiz_alignment [BS] set+1 %hu != %hu", text->horiz_alignment, horiz_alignment);
    text->horiz_alignment--;

  }
  {
    BITCODE_2DPOINT insertion_pt;
    if (dwg_dynapi_entity_value (text, "TEXT", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &text->insertion_pt, sizeof (text->insertion_pt)))
        pass ();
    else
        fail ("TEXT.insertion_pt [2DPOINT]");
  }
  {
    BITCODE_RD oblique_ang;
    if (dwg_dynapi_entity_value (text, "TEXT", "oblique_ang", &oblique_ang, NULL)
        && oblique_ang == text->oblique_ang)
      pass ();
    else
      fail ("TEXT.oblique_ang [RD] %g != %g", text->oblique_ang, oblique_ang);
    oblique_ang++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "oblique_ang", &oblique_ang, 0)
        && oblique_ang == text->oblique_ang)
      pass ();
    else
      fail ("TEXT.oblique_ang [RD] set+1 %g != %g", text->oblique_ang, oblique_ang);
    text->oblique_ang--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (text, "TEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &text->parent, sizeof (text->parent)))
        pass ();
    else
        fail ("TEXT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value (text, "TEXT", "rotation", &rotation, NULL)
        && rotation == text->rotation)
      pass ();
    else
      fail ("TEXT.rotation [RD] %g != %g", text->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "rotation", &rotation, 0)
        && rotation == text->rotation)
      pass ();
    else
      fail ("TEXT.rotation [RD] set+1 %g != %g", text->rotation, rotation);
    text->rotation--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (text, "TEXT", "style", &style, NULL)
        && !memcmp (&style, &text->style, sizeof (text->style)))
        pass ();
    else
        fail ("TEXT.style [H]");
  }
  {
    BITCODE_TV text_value;
    if (dwg_dynapi_entity_value (text, "TEXT", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)text->text_value)
           : !text->text_value)
      pass ();
    else
      fail ("TEXT.text_value [TV] '%s' <> '%s'", text_value, text->text_value);
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value (text, "TEXT", "thickness", &thickness, NULL)
        && thickness == text->thickness)
      pass ();
    else
      fail ("TEXT.thickness [RD] %g != %g", text->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "thickness", &thickness, 0)
        && thickness == text->thickness)
      pass ();
    else
      fail ("TEXT.thickness [RD] set+1 %g != %g", text->thickness, thickness);
    text->thickness--;

  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value (text, "TEXT", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == text->vert_alignment)
      pass ();
    else
      fail ("TEXT.vert_alignment [BS] %hu != %hu", text->vert_alignment, vert_alignment);
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "vert_alignment", &vert_alignment, 0)
        && vert_alignment == text->vert_alignment)
      pass ();
    else
      fail ("TEXT.vert_alignment [BS] set+1 %hu != %hu", text->vert_alignment, vert_alignment);
    text->vert_alignment--;

  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value (text, "TEXT", "width_factor", &width_factor, NULL)
        && width_factor == text->width_factor)
      pass ();
    else
      fail ("TEXT.width_factor [RD] %g != %g", text->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "width_factor", &width_factor, 0)
        && width_factor == text->width_factor)
      pass ();
    else
      fail ("TEXT.width_factor [RD] set+1 %g != %g", text->width_factor, width_factor);
    text->width_factor--;

  }
  return failed;
}
static int test_TOLERANCE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TOLERANCE *restrict tolerance = obj->tio.entity->tio.TOLERANCE;
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "dimgap", &dimgap, NULL)
        && dimgap == tolerance->dimgap)
      pass ();
    else
      fail ("TOLERANCE.dimgap [BD] %g != %g", tolerance->dimgap, dimgap);
    dimgap++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "dimgap", &dimgap, 0)
        && dimgap == tolerance->dimgap)
      pass ();
    else
      fail ("TOLERANCE.dimgap [BD] set+1 %g != %g", tolerance->dimgap, dimgap);
    tolerance->dimgap--;

  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &tolerance->dimstyle, sizeof (tolerance->dimstyle)))
        pass ();
    else
        fail ("TOLERANCE.dimstyle [H]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &tolerance->extrusion, sizeof (tolerance->extrusion)))
        pass ();
    else
        fail ("TOLERANCE.extrusion [BE]");
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "height", &height, NULL)
        && height == tolerance->height)
      pass ();
    else
      fail ("TOLERANCE.height [BD] %g != %g", tolerance->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "height", &height, 0)
        && height == tolerance->height)
      pass ();
    else
      fail ("TOLERANCE.height [BD] set+1 %g != %g", tolerance->height, height);
    tolerance->height--;

  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &tolerance->ins_pt, sizeof (tolerance->ins_pt)))
        pass ();
    else
        fail ("TOLERANCE.ins_pt [3BD]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "parent", &parent, NULL)
        && !memcmp (&parent, &tolerance->parent, sizeof (tolerance->parent)))
        pass ();
    else
        fail ("TOLERANCE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_TV text_string;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "text_string", &text_string, NULL)
        && text_string
           ? strEQ ((char *)text_string, (char *)tolerance->text_string)
           : !tolerance->text_string)
      pass ();
    else
      fail ("TOLERANCE.text_string [TV] '%s' <> '%s'", text_string, tolerance->text_string);
  }
  {
    BITCODE_BS unknown_short;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "unknown_short", &unknown_short, NULL)
        && unknown_short == tolerance->unknown_short)
      pass ();
    else
      fail ("TOLERANCE.unknown_short [BS] %hu != %hu", tolerance->unknown_short, unknown_short);
    unknown_short++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "unknown_short", &unknown_short, 0)
        && unknown_short == tolerance->unknown_short)
      pass ();
    else
      fail ("TOLERANCE.unknown_short [BS] set+1 %hu != %hu", tolerance->unknown_short, unknown_short);
    tolerance->unknown_short--;

  }
  {
    BITCODE_3BD x_direction;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "x_direction", &x_direction, NULL)
        && !memcmp (&x_direction, &tolerance->x_direction, sizeof (tolerance->x_direction)))
        pass ();
    else
        fail ("TOLERANCE.x_direction [3BD]");
  }
  return failed;
}
static int test_TRACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TRACE *restrict trace = obj->tio.entity->tio.TRACE;
  {
    BITCODE_2RD corner1;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &trace->corner1, sizeof (trace->corner1)))
        pass ();
    else
        fail ("TRACE.corner1 [2RD]");
  }
  {
    BITCODE_2RD corner2;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &trace->corner2, sizeof (trace->corner2)))
        pass ();
    else
        fail ("TRACE.corner2 [2RD]");
  }
  {
    BITCODE_2RD corner3;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &trace->corner3, sizeof (trace->corner3)))
        pass ();
    else
        fail ("TRACE.corner3 [2RD]");
  }
  {
    BITCODE_2RD corner4;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &trace->corner4, sizeof (trace->corner4)))
        pass ();
    else
        fail ("TRACE.corner4 [2RD]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (trace, "TRACE", "elevation", &elevation, NULL)
        && elevation == trace->elevation)
      pass ();
    else
      fail ("TRACE.elevation [BD] %g != %g", trace->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (trace, "TRACE", "elevation", &elevation, 0)
        && elevation == trace->elevation)
      pass ();
    else
      fail ("TRACE.elevation [BD] set+1 %g != %g", trace->elevation, elevation);
    trace->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (trace, "TRACE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &trace->extrusion, sizeof (trace->extrusion)))
        pass ();
    else
        fail ("TRACE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (trace, "TRACE", "parent", &parent, NULL)
        && !memcmp (&parent, &trace->parent, sizeof (trace->parent)))
        pass ();
    else
        fail ("TRACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (trace, "TRACE", "thickness", &thickness, NULL)
        && thickness == trace->thickness)
      pass ();
    else
      fail ("TRACE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", trace->thickness, thickness);
    if (dwg_dynapi_entity_set_value (trace, "TRACE", "thickness", &thickness, 0)
        && thickness == trace->thickness)
      pass ();
    else
      fail ("TRACE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", trace->thickness, thickness);
    trace->thickness--;

  }
  return failed;
}
static int test_UNDERLAY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_UNDERLAY *restrict underlay = obj->tio.entity->tio.UNDERLAY;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "angle", &angle, NULL)
        && angle == underlay->angle)
      pass ();
    else
      fail ("UNDERLAY.angle [BD] %g != %g", underlay->angle, angle);
    angle++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "angle", &angle, 0)
        && angle == underlay->angle)
      pass ();
    else
      fail ("UNDERLAY.angle [BD] set+1 %g != %g", underlay->angle, angle);
    underlay->angle--;

  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (underlay, "UNDERLAY", "clip_verts", &clip_verts, NULL)
        && clip_verts == underlay->clip_verts)
      pass ();
    else
      fail ("UNDERLAY.clip_verts [2RD*] * %u num_clip_verts", count);
  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "contrast", &contrast, NULL)
        && contrast == underlay->contrast)
      pass ();
    else
      fail ("UNDERLAY.contrast [RC] %u != %u", underlay->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "contrast", &contrast, 0)
        && contrast == underlay->contrast)
      pass ();
    else
      fail ("UNDERLAY.contrast [RC] set+1 %u != %u", underlay->contrast, contrast);
    underlay->contrast--;

  }
  {
    BITCODE_H definition_id;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "definition_id", &definition_id, NULL)
        && !memcmp (&definition_id, &underlay->definition_id, sizeof (underlay->definition_id)))
        pass ();
    else
        fail ("UNDERLAY.definition_id [H]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &underlay->extrusion, sizeof (underlay->extrusion)))
        pass ();
    else
        fail ("UNDERLAY.extrusion [BE]");
  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "fade", &fade, NULL)
        && fade == underlay->fade)
      pass ();
    else
      fail ("UNDERLAY.fade [RC] %u != %u", underlay->fade, fade);
    fade++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "fade", &fade, 0)
        && fade == underlay->fade)
      pass ();
    else
      fail ("UNDERLAY.fade [RC] set+1 %u != %u", underlay->fade, fade);
    underlay->fade--;

  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "flag", &flag, NULL)
        && flag == underlay->flag)
      pass ();
    else
      fail ("UNDERLAY.flag [RC] %u != %u", underlay->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "flag", &flag, 0)
        && flag == underlay->flag)
      pass ();
    else
      fail ("UNDERLAY.flag [RC] set+1 %u != %u", underlay->flag, flag);
    underlay->flag--;

  }
  {
    BITCODE_3BD insertion_pt;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &underlay->insertion_pt, sizeof (underlay->insertion_pt)))
        pass ();
    else
        fail ("UNDERLAY.insertion_pt [3BD]");
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == underlay->num_clip_verts)
      pass ();
    else
      fail ("UNDERLAY.num_clip_verts [BL] %u != %u", underlay->num_clip_verts, num_clip_verts);
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "num_clip_verts", &num_clip_verts, 0)
        && num_clip_verts == underlay->num_clip_verts)
      pass ();
    else
      fail ("UNDERLAY.num_clip_verts [BL] set+1 %u != %u", underlay->num_clip_verts, num_clip_verts);
    underlay->num_clip_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "parent", &parent, NULL)
        && !memcmp (&parent, &underlay->parent, sizeof (underlay->parent)))
        pass ();
    else
        fail ("UNDERLAY.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "scale", &scale, NULL)
        && !memcmp (&scale, &underlay->scale, sizeof (underlay->scale)))
        pass ();
    else
        fail ("UNDERLAY.scale [3BD_1]");
  }
  {
    BITCODE_H underlay_layer;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "underlay_layer", &underlay_layer, NULL)
        && !memcmp (&underlay_layer, &underlay->underlay_layer, sizeof (underlay->underlay_layer)))
        pass ();
    else
        fail ("UNDERLAY.underlay_layer [H]");
  }
  return failed;
}
static int test_VERTEX_2D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_2D *restrict vertex_2d = obj->tio.entity->tio.VERTEX_2D;
  {
    BITCODE_BD bulge;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "bulge", &bulge, NULL)
        && bulge == vertex_2d->bulge)
      pass ();
    else
      fail ("VERTEX_2D.bulge [BD] %g != %g", vertex_2d->bulge, bulge);
    bulge++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "bulge", &bulge, 0)
        && bulge == vertex_2d->bulge)
      pass ();
    else
      fail ("VERTEX_2D.bulge [BD] set+1 %g != %g", vertex_2d->bulge, bulge);
    vertex_2d->bulge--;

  }
  {
    BITCODE_BD end_width;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "end_width", &end_width, NULL)
        && end_width == vertex_2d->end_width)
      pass ();
    else
      fail ("VERTEX_2D.end_width [BD] %g != %g", vertex_2d->end_width, end_width);
    end_width++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "end_width", &end_width, 0)
        && end_width == vertex_2d->end_width)
      pass ();
    else
      fail ("VERTEX_2D.end_width [BD] set+1 %g != %g", vertex_2d->end_width, end_width);
    vertex_2d->end_width--;

  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "flag", &flag, NULL)
        && flag == vertex_2d->flag)
      pass ();
    else
      fail ("VERTEX_2D.flag [RC] %u != %u", vertex_2d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "flag", &flag, 0)
        && flag == vertex_2d->flag)
      pass ();
    else
      fail ("VERTEX_2D.flag [RC] set+1 %u != %u", vertex_2d->flag, flag);
    vertex_2d->flag--;

  }
  {
    BITCODE_BL id;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "id", &id, NULL)
        && id == vertex_2d->id)
      pass ();
    else
      fail ("VERTEX_2D.id [BL] %u != %u", vertex_2d->id, id);
    id++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "id", &id, 0)
        && id == vertex_2d->id)
      pass ();
    else
      fail ("VERTEX_2D.id [BL] set+1 %u != %u", vertex_2d->id, id);
    vertex_2d->id--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_2d->parent, sizeof (vertex_2d->parent)))
        pass ();
    else
        fail ("VERTEX_2D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "point", &point, NULL)
        && !memcmp (&point, &vertex_2d->point, sizeof (vertex_2d->point)))
        pass ();
    else
        fail ("VERTEX_2D.point [3BD]");
  }
  {
    BITCODE_BD start_width;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "start_width", &start_width, NULL)
        && start_width == vertex_2d->start_width)
      pass ();
    else
      fail ("VERTEX_2D.start_width [BD] %g != %g", vertex_2d->start_width, start_width);
    start_width++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "start_width", &start_width, 0)
        && start_width == vertex_2d->start_width)
      pass ();
    else
      fail ("VERTEX_2D.start_width [BD] set+1 %g != %g", vertex_2d->start_width, start_width);
    vertex_2d->start_width--;

  }
  {
    BITCODE_BD tangent_dir;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "tangent_dir", &tangent_dir, NULL)
        && tangent_dir == vertex_2d->tangent_dir)
      pass ();
    else
      fail ("VERTEX_2D.tangent_dir [BD] %g != %g", vertex_2d->tangent_dir, tangent_dir);
    tangent_dir++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "tangent_dir", &tangent_dir, 0)
        && tangent_dir == vertex_2d->tangent_dir)
      pass ();
    else
      fail ("VERTEX_2D.tangent_dir [BD] set+1 %g != %g", vertex_2d->tangent_dir, tangent_dir);
    vertex_2d->tangent_dir--;

  }
  return failed;
}
static int test_VERTEX_3D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_3D *restrict vertex_3d = obj->tio.entity->tio.VERTEX_3D;
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (vertex_3d, "VERTEX_3D", "flag", &flag, NULL)
        && flag == vertex_3d->flag)
      pass ();
    else
      fail ("VERTEX_3D.flag [RC] %u != %u", vertex_3d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_3d, "VERTEX_3D", "flag", &flag, 0)
        && flag == vertex_3d->flag)
      pass ();
    else
      fail ("VERTEX_3D.flag [RC] set+1 %u != %u", vertex_3d->flag, flag);
    vertex_3d->flag--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (vertex_3d, "VERTEX_3D", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_3d->parent, sizeof (vertex_3d->parent)))
        pass ();
    else
        fail ("VERTEX_3D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (vertex_3d, "VERTEX_3D", "point", &point, NULL)
        && !memcmp (&point, &vertex_3d->point, sizeof (vertex_3d->point)))
        pass ();
    else
        fail ("VERTEX_3D.point [3BD]");
  }
  return failed;
}
static int test_VERTEX_PFACE_FACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_PFACE_FACE *restrict vertex_pface_face = obj->tio.entity->tio.VERTEX_PFACE_FACE;
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (vertex_pface_face, "VERTEX_PFACE_FACE", "flag", &flag, NULL)
        && flag == vertex_pface_face->flag)
      pass ();
    else
      fail ("VERTEX_PFACE_FACE.flag [RC] %u != %u", vertex_pface_face->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_pface_face, "VERTEX_PFACE_FACE", "flag", &flag, 0)
        && flag == vertex_pface_face->flag)
      pass ();
    else
      fail ("VERTEX_PFACE_FACE.flag [RC] set+1 %u != %u", vertex_pface_face->flag, flag);
    vertex_pface_face->flag--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (vertex_pface_face, "VERTEX_PFACE_FACE", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_pface_face->parent, sizeof (vertex_pface_face->parent)))
        pass ();
    else
        fail ("VERTEX_PFACE_FACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BS vertind[4];
    if (dwg_dynapi_entity_value (vertex_pface_face, "VERTEX_PFACE_FACE", "vertind[4]", &vertind, NULL)
        && !memcmp (&vertind, &vertex_pface_face->vertind, sizeof (vertex_pface_face->vertind)))
        pass ();
    else
        fail ("VERTEX_PFACE_FACE.vertind[4] [BS]");
  }
  return failed;
}
static int test_VIEWPORT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VIEWPORT *restrict viewport = obj->tio.entity->tio.VIEWPORT;
  {
    BITCODE_CMC ambient_color;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ambient_color", &ambient_color, NULL)
        && !memcmp (&ambient_color, &viewport->ambient_color, sizeof (viewport->ambient_color)))
        pass ();
    else
        fail ("VIEWPORT.ambient_color [CMC]");
  }
  {
    BITCODE_BD back_clip_z;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "back_clip_z", &back_clip_z, NULL)
        && back_clip_z == viewport->back_clip_z)
      pass ();
    else
      fail ("VIEWPORT.back_clip_z [BD] %g != %g", viewport->back_clip_z, back_clip_z);
    back_clip_z++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "back_clip_z", &back_clip_z, 0)
        && back_clip_z == viewport->back_clip_z)
      pass ();
    else
      fail ("VIEWPORT.back_clip_z [BD] set+1 %g != %g", viewport->back_clip_z, back_clip_z);
    viewport->back_clip_z--;

  }
  {
    BITCODE_BD brightness;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "brightness", &brightness, NULL)
        && brightness == viewport->brightness)
      pass ();
    else
      fail ("VIEWPORT.brightness [BD] %g != %g", viewport->brightness, brightness);
    brightness++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "brightness", &brightness, 0)
        && brightness == viewport->brightness)
      pass ();
    else
      fail ("VIEWPORT.brightness [BD] set+1 %g != %g", viewport->brightness, brightness);
    viewport->brightness--;

  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "center", &center, NULL)
        && !memcmp (&center, &viewport->center, sizeof (viewport->center)))
        pass ();
    else
        fail ("VIEWPORT.center [3BD]");
  }
  {
    BITCODE_BS circle_zoom;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "circle_zoom", &circle_zoom, NULL)
        && circle_zoom == viewport->circle_zoom)
      pass ();
    else
      fail ("VIEWPORT.circle_zoom [BS] %hu != %hu", viewport->circle_zoom, circle_zoom);
    circle_zoom++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "circle_zoom", &circle_zoom, 0)
        && circle_zoom == viewport->circle_zoom)
      pass ();
    else
      fail ("VIEWPORT.circle_zoom [BS] set+1 %hu != %hu", viewport->circle_zoom, circle_zoom);
    viewport->circle_zoom--;

  }
  {
    BITCODE_BD contrast;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "contrast", &contrast, NULL)
        && contrast == viewport->contrast)
      pass ();
    else
      fail ("VIEWPORT.contrast [BD] %g != %g", viewport->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "contrast", &contrast, 0)
        && contrast == viewport->contrast)
      pass ();
    else
      fail ("VIEWPORT.contrast [BD] set+1 %g != %g", viewport->contrast, contrast);
    viewport->contrast--;

  }
  {
    BITCODE_RC default_lighting_type;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "default_lighting_type", &default_lighting_type, NULL)
        && default_lighting_type == viewport->default_lighting_type)
      pass ();
    else
      fail ("VIEWPORT.default_lighting_type [RC] %u != %u", viewport->default_lighting_type, default_lighting_type);
    default_lighting_type++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "default_lighting_type", &default_lighting_type, 0)
        && default_lighting_type == viewport->default_lighting_type)
      pass ();
    else
      fail ("VIEWPORT.default_lighting_type [RC] set+1 %u != %u", viewport->default_lighting_type, default_lighting_type);
    viewport->default_lighting_type--;

  }
  {
    BITCODE_BD front_clip_z;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "front_clip_z", &front_clip_z, NULL)
        && front_clip_z == viewport->front_clip_z)
      pass ();
    else
      fail ("VIEWPORT.front_clip_z [BD] %g != %g", viewport->front_clip_z, front_clip_z);
    front_clip_z++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "front_clip_z", &front_clip_z, 0)
        && front_clip_z == viewport->front_clip_z)
      pass ();
    else
      fail ("VIEWPORT.front_clip_z [BD] set+1 %g != %g", viewport->front_clip_z, front_clip_z);
    viewport->front_clip_z--;

  }
  {
    BITCODE_BS grid_major;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "grid_major", &grid_major, NULL)
        && grid_major == viewport->grid_major)
      pass ();
    else
      fail ("VIEWPORT.grid_major [BS] %hu != %hu", viewport->grid_major, grid_major);
    grid_major++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "grid_major", &grid_major, 0)
        && grid_major == viewport->grid_major)
      pass ();
    else
      fail ("VIEWPORT.grid_major [BS] set+1 %hu != %hu", viewport->grid_major, grid_major);
    viewport->grid_major--;

  }
  {
    BITCODE_2RD grid_spacing;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "grid_spacing", &grid_spacing, NULL)
        && !memcmp (&grid_spacing, &viewport->grid_spacing, sizeof (viewport->grid_spacing)))
        pass ();
    else
        fail ("VIEWPORT.grid_spacing [2RD]");
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "height", &height, NULL)
        && height == viewport->height)
      pass ();
    else
      fail ("VIEWPORT.height [BD] %g != %g", viewport->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "height", &height, 0)
        && height == viewport->height)
      pass ();
    else
      fail ("VIEWPORT.height [BD] set+1 %g != %g", viewport->height, height);
    viewport->height--;

  }
  {
    BITCODE_RS id;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "id", &id, NULL)
        && id == viewport->id)
      pass ();
    else
      fail ("VIEWPORT.id [RS] %hu != %hu", viewport->id, id);
    id++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "id", &id, 0)
        && id == viewport->id)
      pass ();
    else
      fail ("VIEWPORT.id [RS] set+1 %hu != %hu", viewport->id, id);
    viewport->id--;

  }
  {
    BITCODE_BD lens_length;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "lens_length", &lens_length, NULL)
        && lens_length == viewport->lens_length)
      pass ();
    else
      fail ("VIEWPORT.lens_length [BD] %g != %g", viewport->lens_length, lens_length);
    lens_length++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "lens_length", &lens_length, 0)
        && lens_length == viewport->lens_length)
      pass ();
    else
      fail ("VIEWPORT.lens_length [BD] set+1 %g != %g", viewport->lens_length, lens_length);
    viewport->lens_length--;

  }
  {
    BITCODE_BL num_frozen_layers;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "num_frozen_layers", &num_frozen_layers, NULL)
        && num_frozen_layers == viewport->num_frozen_layers)
      pass ();
    else
      fail ("VIEWPORT.num_frozen_layers [BL] %u != %u", viewport->num_frozen_layers, num_frozen_layers);
    num_frozen_layers++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "num_frozen_layers", &num_frozen_layers, 0)
        && num_frozen_layers == viewport->num_frozen_layers)
      pass ();
    else
      fail ("VIEWPORT.num_frozen_layers [BL] set+1 %u != %u", viewport->num_frozen_layers, num_frozen_layers);
    viewport->num_frozen_layers--;

  }
  {
    BITCODE_RS on_off;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "on_off", &on_off, NULL)
        && on_off == viewport->on_off)
      pass ();
    else
      fail ("VIEWPORT.on_off [RS] %hu != %hu", viewport->on_off, on_off);
    on_off++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "on_off", &on_off, 0)
        && on_off == viewport->on_off)
      pass ();
    else
      fail ("VIEWPORT.on_off [RS] set+1 %hu != %hu", viewport->on_off, on_off);
    viewport->on_off--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "parent", &parent, NULL)
        && !memcmp (&parent, &viewport->parent, sizeof (viewport->parent)))
        pass ();
    else
        fail ("VIEWPORT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_RC render_mode;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "render_mode", &render_mode, NULL)
        && render_mode == viewport->render_mode)
      pass ();
    else
      fail ("VIEWPORT.render_mode [RC] %u != %u", viewport->render_mode, render_mode);
    render_mode++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "render_mode", &render_mode, 0)
        && render_mode == viewport->render_mode)
      pass ();
    else
      fail ("VIEWPORT.render_mode [RC] set+1 %u != %u", viewport->render_mode, render_mode);
    viewport->render_mode--;

  }
  {
    BITCODE_BS shadeplot_mode;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "shadeplot_mode", &shadeplot_mode, NULL)
        && shadeplot_mode == viewport->shadeplot_mode)
      pass ();
    else
      fail ("VIEWPORT.shadeplot_mode [BS] %hu != %hu", viewport->shadeplot_mode, shadeplot_mode);
    shadeplot_mode++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "shadeplot_mode", &shadeplot_mode, 0)
        && shadeplot_mode == viewport->shadeplot_mode)
      pass ();
    else
      fail ("VIEWPORT.shadeplot_mode [BS] set+1 %hu != %hu", viewport->shadeplot_mode, shadeplot_mode);
    viewport->shadeplot_mode--;

  }
  {
    BITCODE_BD snap_angle;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "snap_angle", &snap_angle, NULL)
        && snap_angle == viewport->snap_angle)
      pass ();
    else
      fail ("VIEWPORT.snap_angle [BD] %g != %g", viewport->snap_angle, snap_angle);
    snap_angle++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "snap_angle", &snap_angle, 0)
        && snap_angle == viewport->snap_angle)
      pass ();
    else
      fail ("VIEWPORT.snap_angle [BD] set+1 %g != %g", viewport->snap_angle, snap_angle);
    viewport->snap_angle--;

  }
  {
    BITCODE_2RD snap_base;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "snap_base", &snap_base, NULL)
        && !memcmp (&snap_base, &viewport->snap_base, sizeof (viewport->snap_base)))
        pass ();
    else
        fail ("VIEWPORT.snap_base [2RD]");
  }
  {
    BITCODE_2RD snap_spacing;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "snap_spacing", &snap_spacing, NULL)
        && !memcmp (&snap_spacing, &viewport->snap_spacing, sizeof (viewport->snap_spacing)))
        pass ();
    else
        fail ("VIEWPORT.snap_spacing [2RD]");
  }
  {
    BITCODE_BL status_flag;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "status_flag", &status_flag, NULL)
        && status_flag == viewport->status_flag)
      pass ();
    else
      fail ("VIEWPORT.status_flag [BL] %u != %u", viewport->status_flag, status_flag);
    status_flag++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "status_flag", &status_flag, 0)
        && status_flag == viewport->status_flag)
      pass ();
    else
      fail ("VIEWPORT.status_flag [BL] set+1 %u != %u", viewport->status_flag, status_flag);
    viewport->status_flag--;

  }
  {
    BITCODE_TV style_sheet;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "style_sheet", &style_sheet, NULL)
        && style_sheet
           ? strEQ ((char *)style_sheet, (char *)viewport->style_sheet)
           : !viewport->style_sheet)
      pass ();
    else
      fail ("VIEWPORT.style_sheet [TV] '%s' <> '%s'", style_sheet, viewport->style_sheet);
  }
  {
    BITCODE_B ucs_at_origin;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_at_origin", &ucs_at_origin, NULL)
        && ucs_at_origin == viewport->ucs_at_origin)
      pass ();
    else
      fail ("VIEWPORT.ucs_at_origin [B] " FORMAT_B " != " FORMAT_B "", viewport->ucs_at_origin, ucs_at_origin);
    ucs_at_origin++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_at_origin", &ucs_at_origin, 0)
        && ucs_at_origin == viewport->ucs_at_origin)
      pass ();
    else
      fail ("VIEWPORT.ucs_at_origin [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->ucs_at_origin, ucs_at_origin);
    viewport->ucs_at_origin--;

  }
  {
    BITCODE_BD ucs_elevation;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_elevation", &ucs_elevation, NULL)
        && ucs_elevation == viewport->ucs_elevation)
      pass ();
    else
      fail ("VIEWPORT.ucs_elevation [BD] %g != %g", viewport->ucs_elevation, ucs_elevation);
    ucs_elevation++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_elevation", &ucs_elevation, 0)
        && ucs_elevation == viewport->ucs_elevation)
      pass ();
    else
      fail ("VIEWPORT.ucs_elevation [BD] set+1 %g != %g", viewport->ucs_elevation, ucs_elevation);
    viewport->ucs_elevation--;

  }
  {
    BITCODE_3BD ucs_origin;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_origin", &ucs_origin, NULL)
        && !memcmp (&ucs_origin, &viewport->ucs_origin, sizeof (viewport->ucs_origin)))
        pass ();
    else
        fail ("VIEWPORT.ucs_origin [3BD]");
  }
  {
    BITCODE_BS ucs_ortho_view_type;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_ortho_view_type", &ucs_ortho_view_type, NULL)
        && ucs_ortho_view_type == viewport->ucs_ortho_view_type)
      pass ();
    else
      fail ("VIEWPORT.ucs_ortho_view_type [BS] %hu != %hu", viewport->ucs_ortho_view_type, ucs_ortho_view_type);
    ucs_ortho_view_type++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_ortho_view_type", &ucs_ortho_view_type, 0)
        && ucs_ortho_view_type == viewport->ucs_ortho_view_type)
      pass ();
    else
      fail ("VIEWPORT.ucs_ortho_view_type [BS] set+1 %hu != %hu", viewport->ucs_ortho_view_type, ucs_ortho_view_type);
    viewport->ucs_ortho_view_type--;

  }
  {
    BITCODE_B ucs_per_viewport;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_per_viewport", &ucs_per_viewport, NULL)
        && ucs_per_viewport == viewport->ucs_per_viewport)
      pass ();
    else
      fail ("VIEWPORT.ucs_per_viewport [B] " FORMAT_B " != " FORMAT_B "", viewport->ucs_per_viewport, ucs_per_viewport);
    ucs_per_viewport++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_per_viewport", &ucs_per_viewport, 0)
        && ucs_per_viewport == viewport->ucs_per_viewport)
      pass ();
    else
      fail ("VIEWPORT.ucs_per_viewport [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->ucs_per_viewport, ucs_per_viewport);
    viewport->ucs_per_viewport--;

  }
  {
    BITCODE_3BD ucs_x_axis;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_x_axis", &ucs_x_axis, NULL)
        && !memcmp (&ucs_x_axis, &viewport->ucs_x_axis, sizeof (viewport->ucs_x_axis)))
        pass ();
    else
        fail ("VIEWPORT.ucs_x_axis [3BD]");
  }
  {
    BITCODE_3BD ucs_y_axis;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_y_axis", &ucs_y_axis, NULL)
        && !memcmp (&ucs_y_axis, &viewport->ucs_y_axis, sizeof (viewport->ucs_y_axis)))
        pass ();
    else
        fail ("VIEWPORT.ucs_y_axis [3BD]");
  }
  {
    BITCODE_B use_default_lights;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "use_default_lights", &use_default_lights, NULL)
        && use_default_lights == viewport->use_default_lights)
      pass ();
    else
      fail ("VIEWPORT.use_default_lights [B] " FORMAT_B " != " FORMAT_B "", viewport->use_default_lights, use_default_lights);
    use_default_lights++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "use_default_lights", &use_default_lights, 0)
        && use_default_lights == viewport->use_default_lights)
      pass ();
    else
      fail ("VIEWPORT.use_default_lights [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->use_default_lights, use_default_lights);
    viewport->use_default_lights--;

  }
  {
    BITCODE_2RD view_center;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "view_center", &view_center, NULL)
        && !memcmp (&view_center, &viewport->view_center, sizeof (viewport->view_center)))
        pass ();
    else
        fail ("VIEWPORT.view_center [2RD]");
  }
  {
    BITCODE_3BD view_direction;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "view_direction", &view_direction, NULL)
        && !memcmp (&view_direction, &viewport->view_direction, sizeof (viewport->view_direction)))
        pass ();
    else
        fail ("VIEWPORT.view_direction [3BD]");
  }
  {
    BITCODE_BD view_height;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "view_height", &view_height, NULL)
        && view_height == viewport->view_height)
      pass ();
    else
      fail ("VIEWPORT.view_height [BD] %g != %g", viewport->view_height, view_height);
    view_height++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "view_height", &view_height, 0)
        && view_height == viewport->view_height)
      pass ();
    else
      fail ("VIEWPORT.view_height [BD] set+1 %g != %g", viewport->view_height, view_height);
    viewport->view_height--;

  }
  {
    BITCODE_3BD view_target;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "view_target", &view_target, NULL)
        && !memcmp (&view_target, &viewport->view_target, sizeof (viewport->view_target)))
        pass ();
    else
        fail ("VIEWPORT.view_target [3BD]");
  }
  {
    BITCODE_BD view_twist;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "view_twist", &view_twist, NULL)
        && view_twist == viewport->view_twist)
      pass ();
    else
      fail ("VIEWPORT.view_twist [BD] %g != %g", viewport->view_twist, view_twist);
    view_twist++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "view_twist", &view_twist, 0)
        && view_twist == viewport->view_twist)
      pass ();
    else
      fail ("VIEWPORT.view_twist [BD] set+1 %g != %g", viewport->view_twist, view_twist);
    viewport->view_twist--;

  }
  {
    BITCODE_BD width;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "width", &width, NULL)
        && width == viewport->width)
      pass ();
    else
      fail ("VIEWPORT.width [BD] %g != %g", viewport->width, width);
    width++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "width", &width, 0)
        && width == viewport->width)
      pass ();
    else
      fail ("VIEWPORT.width [BD] set+1 %g != %g", viewport->width, width);
    viewport->width--;

  }
  return failed;
}
static int test_WIPEOUT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_WIPEOUT *restrict wipeout = obj->tio.entity->tio.WIPEOUT;
  {
    BITCODE_RC brightness;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "brightness", &brightness, NULL)
        && brightness == wipeout->brightness)
      pass ();
    else
      fail ("WIPEOUT.brightness [RC] %u != %u", wipeout->brightness, brightness);
    brightness++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "brightness", &brightness, 0)
        && brightness == wipeout->brightness)
      pass ();
    else
      fail ("WIPEOUT.brightness [RC] set+1 %u != %u", wipeout->brightness, brightness);
    wipeout->brightness--;

  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "class_version", &class_version, NULL)
        && class_version == wipeout->class_version)
      pass ();
    else
      fail ("WIPEOUT.class_version [BL] %u != %u", wipeout->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "class_version", &class_version, 0)
        && class_version == wipeout->class_version)
      pass ();
    else
      fail ("WIPEOUT.class_version [BL] set+1 %u != %u", wipeout->class_version, class_version);
    wipeout->class_version--;

  }
  {
    BITCODE_BS clip_boundary_type;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clip_boundary_type", &clip_boundary_type, NULL)
        && clip_boundary_type == wipeout->clip_boundary_type)
      pass ();
    else
      fail ("WIPEOUT.clip_boundary_type [BS] %hu != %hu", wipeout->clip_boundary_type, clip_boundary_type);
    clip_boundary_type++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "clip_boundary_type", &clip_boundary_type, 0)
        && clip_boundary_type == wipeout->clip_boundary_type)
      pass ();
    else
      fail ("WIPEOUT.clip_boundary_type [BS] set+1 %hu != %hu", wipeout->clip_boundary_type, clip_boundary_type);
    wipeout->clip_boundary_type--;

  }
  {
    BITCODE_B clip_mode;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clip_mode", &clip_mode, NULL)
        && clip_mode == wipeout->clip_mode)
      pass ();
    else
      fail ("WIPEOUT.clip_mode [B] " FORMAT_B " != " FORMAT_B "", wipeout->clip_mode, clip_mode);
    clip_mode++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "clip_mode", &clip_mode, 0)
        && clip_mode == wipeout->clip_mode)
      pass ();
    else
      fail ("WIPEOUT.clip_mode [B] set+1 " FORMAT_B " != " FORMAT_B "", wipeout->clip_mode, clip_mode);
    wipeout->clip_mode--;

  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clip_verts", &clip_verts, NULL)
        && clip_verts == wipeout->clip_verts)
      pass ();
    else
      fail ("WIPEOUT.clip_verts [2RD*] * %u num_clip_verts", count);
  }
  {
    BITCODE_B clipping;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clipping", &clipping, NULL)
        && clipping == wipeout->clipping)
      pass ();
    else
      fail ("WIPEOUT.clipping [B] " FORMAT_B " != " FORMAT_B "", wipeout->clipping, clipping);
    clipping++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "clipping", &clipping, 0)
        && clipping == wipeout->clipping)
      pass ();
    else
      fail ("WIPEOUT.clipping [B] set+1 " FORMAT_B " != " FORMAT_B "", wipeout->clipping, clipping);
    wipeout->clipping--;

  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "contrast", &contrast, NULL)
        && contrast == wipeout->contrast)
      pass ();
    else
      fail ("WIPEOUT.contrast [RC] %u != %u", wipeout->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "contrast", &contrast, 0)
        && contrast == wipeout->contrast)
      pass ();
    else
      fail ("WIPEOUT.contrast [RC] set+1 %u != %u", wipeout->contrast, contrast);
    wipeout->contrast--;

  }
  {
    BITCODE_BS display_props;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "display_props", &display_props, NULL)
        && display_props == wipeout->display_props)
      pass ();
    else
      fail ("WIPEOUT.display_props [BS] %hu != %hu", wipeout->display_props, display_props);
    display_props++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "display_props", &display_props, 0)
        && display_props == wipeout->display_props)
      pass ();
    else
      fail ("WIPEOUT.display_props [BS] set+1 %hu != %hu", wipeout->display_props, display_props);
    wipeout->display_props--;

  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "fade", &fade, NULL)
        && fade == wipeout->fade)
      pass ();
    else
      fail ("WIPEOUT.fade [RC] %u != %u", wipeout->fade, fade);
    fade++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "fade", &fade, 0)
        && fade == wipeout->fade)
      pass ();
    else
      fail ("WIPEOUT.fade [RC] set+1 %u != %u", wipeout->fade, fade);
    wipeout->fade--;

  }
  {
    BITCODE_H imagedef;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "imagedef", &imagedef, NULL)
        && !memcmp (&imagedef, &wipeout->imagedef, sizeof (wipeout->imagedef)))
        pass ();
    else
        fail ("WIPEOUT.imagedef [H]");
  }
  {
    BITCODE_H imagedefreactor;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "imagedefreactor", &imagedefreactor, NULL)
        && !memcmp (&imagedefreactor, &wipeout->imagedefreactor, sizeof (wipeout->imagedefreactor)))
        pass ();
    else
        fail ("WIPEOUT.imagedefreactor [H]");
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == wipeout->num_clip_verts)
      pass ();
    else
      fail ("WIPEOUT.num_clip_verts [BL] %u != %u", wipeout->num_clip_verts, num_clip_verts);
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "num_clip_verts", &num_clip_verts, 0)
        && num_clip_verts == wipeout->num_clip_verts)
      pass ();
    else
      fail ("WIPEOUT.num_clip_verts [BL] set+1 %u != %u", wipeout->num_clip_verts, num_clip_verts);
    wipeout->num_clip_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "parent", &parent, NULL)
        && !memcmp (&parent, &wipeout->parent, sizeof (wipeout->parent)))
        pass ();
    else
        fail ("WIPEOUT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt0;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "pt0", &pt0, NULL)
        && !memcmp (&pt0, &wipeout->pt0, sizeof (wipeout->pt0)))
        pass ();
    else
        fail ("WIPEOUT.pt0 [3BD]");
  }
  {
    BITCODE_2RD size;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "size", &size, NULL)
        && !memcmp (&size, &wipeout->size, sizeof (wipeout->size)))
        pass ();
    else
        fail ("WIPEOUT.size [2RD]");
  }
  {
    BITCODE_3BD uvec;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "uvec", &uvec, NULL)
        && !memcmp (&uvec, &wipeout->uvec, sizeof (wipeout->uvec)))
        pass ();
    else
        fail ("WIPEOUT.uvec [3BD]");
  }
  {
    BITCODE_3BD vvec;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "vvec", &vvec, NULL)
        && !memcmp (&vvec, &wipeout->vvec, sizeof (wipeout->vvec)))
        pass ();
    else
        fail ("WIPEOUT.vvec [3BD]");
  }
  return failed;
}
static int test_XLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_XLINE *restrict xline = obj->tio.entity->tio.XLINE;
  return failed;
}
static int test_ACSH_SWEEP_CLASS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACSH_SWEEP_CLASS *restrict acsh_sweep_class = obj->tio.object->tio.ACSH_SWEEP_CLASS;
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "align_angle", &align_angle, NULL)
        && align_angle == acsh_sweep_class->align_angle)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.align_angle [BD] %g != %g", acsh_sweep_class->align_angle, align_angle);
    align_angle++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "align_angle", &align_angle, 0)
        && align_angle == acsh_sweep_class->align_angle)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.align_angle [BD] set+1 %g != %g", acsh_sweep_class->align_angle, align_angle);
    acsh_sweep_class->align_angle--;

  }
  {
    BITCODE_RC align_option;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "align_option", &align_option, NULL)
        && align_option == acsh_sweep_class->align_option)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.align_option [RC] %u != %u", acsh_sweep_class->align_option, align_option);
    align_option++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "align_option", &align_option, 0)
        && align_option == acsh_sweep_class->align_option)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.align_option [RC] set+1 %u != %u", acsh_sweep_class->align_option, align_option);
    acsh_sweep_class->align_option--;

  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "bank", &bank, NULL)
        && bank == acsh_sweep_class->bank)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.bank [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->bank, bank);
    bank++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "bank", &bank, 0)
        && bank == acsh_sweep_class->bank)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->bank, bank);
    acsh_sweep_class->bank--;

  }
  {
    BITCODE_3BD basept;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "basept", &basept, NULL)
        && !memcmp (&basept, &acsh_sweep_class->basept, sizeof (acsh_sweep_class->basept)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.basept [3BD]");
  }
  {
    BITCODE_B check_intersections;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "check_intersections", &check_intersections, NULL)
        && check_intersections == acsh_sweep_class->check_intersections)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.check_intersections [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->check_intersections, check_intersections);
    check_intersections++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "check_intersections", &check_intersections, 0)
        && check_intersections == acsh_sweep_class->check_intersections)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.check_intersections [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->check_intersections, check_intersections);
    acsh_sweep_class->check_intersections--;

  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "class_version", &class_version, NULL)
        && class_version == acsh_sweep_class->class_version)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.class_version [BL] %u != %u", acsh_sweep_class->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "class_version", &class_version, 0)
        && class_version == acsh_sweep_class->class_version)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.class_version [BL] set+1 %u != %u", acsh_sweep_class->class_version, class_version);
    acsh_sweep_class->class_version--;

  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "color", &color, NULL)
        && !memcmp (&color, &acsh_sweep_class->color, sizeof (acsh_sweep_class->color)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.color [CMC]");
  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "draft_angle", &draft_angle, NULL)
        && draft_angle == acsh_sweep_class->draft_angle)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.draft_angle [BD] %g != %g", acsh_sweep_class->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "draft_angle", &draft_angle, 0)
        && draft_angle == acsh_sweep_class->draft_angle)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.draft_angle [BD] set+1 %g != %g", acsh_sweep_class->draft_angle, draft_angle);
    acsh_sweep_class->draft_angle--;

  }
  {
    BITCODE_BL ee_bl98;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "ee_bl98", &ee_bl98, NULL)
        && ee_bl98 == acsh_sweep_class->ee_bl98)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.ee_bl98 [BL] %u != %u", acsh_sweep_class->ee_bl98, ee_bl98);
    ee_bl98++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "ee_bl98", &ee_bl98, 0)
        && ee_bl98 == acsh_sweep_class->ee_bl98)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.ee_bl98 [BL] set+1 %u != %u", acsh_sweep_class->ee_bl98, ee_bl98);
    acsh_sweep_class->ee_bl98--;

  }
  {
    BITCODE_BL ee_bl99;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "ee_bl99", &ee_bl99, NULL)
        && ee_bl99 == acsh_sweep_class->ee_bl99)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.ee_bl99 [BL] %u != %u", acsh_sweep_class->ee_bl99, ee_bl99);
    ee_bl99++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "ee_bl99", &ee_bl99, 0)
        && ee_bl99 == acsh_sweep_class->ee_bl99)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.ee_bl99 [BL] set+1 %u != %u", acsh_sweep_class->ee_bl99, ee_bl99);
    acsh_sweep_class->ee_bl99--;

  }
  {
    BITCODE_BD end_draft_dist;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "end_draft_dist", &end_draft_dist, NULL)
        && end_draft_dist == acsh_sweep_class->end_draft_dist)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.end_draft_dist [BD] %g != %g", acsh_sweep_class->end_draft_dist, end_draft_dist);
    end_draft_dist++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "end_draft_dist", &end_draft_dist, 0)
        && end_draft_dist == acsh_sweep_class->end_draft_dist)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.end_draft_dist [BD] set+1 %g != %g", acsh_sweep_class->end_draft_dist, end_draft_dist);
    acsh_sweep_class->end_draft_dist--;

  }
  {
    BITCODE_B has_align_start;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "has_align_start", &has_align_start, NULL)
        && has_align_start == acsh_sweep_class->has_align_start)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.has_align_start [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->has_align_start, has_align_start);
    has_align_start++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "has_align_start", &has_align_start, 0)
        && has_align_start == acsh_sweep_class->has_align_start)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.has_align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->has_align_start, has_align_start);
    acsh_sweep_class->has_align_start--;

  }
  {
    BITCODE_RC miter_option;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "miter_option", &miter_option, NULL)
        && miter_option == acsh_sweep_class->miter_option)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.miter_option [RC] %u != %u", acsh_sweep_class->miter_option, miter_option);
    miter_option++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "miter_option", &miter_option, 0)
        && miter_option == acsh_sweep_class->miter_option)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.miter_option [RC] set+1 %u != %u", acsh_sweep_class->miter_option, miter_option);
    acsh_sweep_class->miter_option--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "parent", &parent, NULL)
        && !memcmp (&parent, &acsh_sweep_class->parent, sizeof (acsh_sweep_class->parent)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_BD* pathentity_transform;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "pathentity_transform", &pathentity_transform, NULL)
        && !memcmp (&pathentity_transform, &acsh_sweep_class->pathentity_transform, sizeof (acsh_sweep_class->pathentity_transform)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.pathentity_transform [BD*]");
  }
  {
    BITCODE_3BD pt2;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "pt2", &pt2, NULL)
        && !memcmp (&pt2, &acsh_sweep_class->pt2, sizeof (acsh_sweep_class->pt2)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.pt2 [3BD]");
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "scale_factor", &scale_factor, NULL)
        && scale_factor == acsh_sweep_class->scale_factor)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.scale_factor [BD] %g != %g", acsh_sweep_class->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "scale_factor", &scale_factor, 0)
        && scale_factor == acsh_sweep_class->scale_factor)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.scale_factor [BD] set+1 %g != %g", acsh_sweep_class->scale_factor, scale_factor);
    acsh_sweep_class->scale_factor--;

  }
  {
    BITCODE_B shhn_b92;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_b92", &shhn_b92, NULL)
        && shhn_b92 == acsh_sweep_class->shhn_b92)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_b92 [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shhn_b92, shhn_b92);
    shhn_b92++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_b92", &shhn_b92, 0)
        && shhn_b92 == acsh_sweep_class->shhn_b92)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_b92 [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shhn_b92, shhn_b92);
    acsh_sweep_class->shhn_b92--;

  }
  {
    BITCODE_BL shhn_bl347;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_bl347", &shhn_bl347, NULL)
        && shhn_bl347 == acsh_sweep_class->shhn_bl347)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_bl347 [BL] %u != %u", acsh_sweep_class->shhn_bl347, shhn_bl347);
    shhn_bl347++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_bl347", &shhn_bl347, 0)
        && shhn_bl347 == acsh_sweep_class->shhn_bl347)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_bl347 [BL] set+1 %u != %u", acsh_sweep_class->shhn_bl347, shhn_bl347);
    acsh_sweep_class->shhn_bl347--;

  }
  {
    BITCODE_BL shhn_bl98;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_bl98", &shhn_bl98, NULL)
        && shhn_bl98 == acsh_sweep_class->shhn_bl98)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_bl98 [BL] %u != %u", acsh_sweep_class->shhn_bl98, shhn_bl98);
    shhn_bl98++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_bl98", &shhn_bl98, 0)
        && shhn_bl98 == acsh_sweep_class->shhn_bl98)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_bl98 [BL] set+1 %u != %u", acsh_sweep_class->shhn_bl98, shhn_bl98);
    acsh_sweep_class->shhn_bl98--;

  }
  {
    BITCODE_BL shhn_bl99;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_bl99", &shhn_bl99, NULL)
        && shhn_bl99 == acsh_sweep_class->shhn_bl99)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_bl99 [BL] %u != %u", acsh_sweep_class->shhn_bl99, shhn_bl99);
    shhn_bl99++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_bl99", &shhn_bl99, 0)
        && shhn_bl99 == acsh_sweep_class->shhn_bl99)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shhn_bl99 [BL] set+1 %u != %u", acsh_sweep_class->shhn_bl99, shhn_bl99);
    acsh_sweep_class->shhn_bl99--;

  }
  {
    BITCODE_BD* shhn_pts;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shhn_pts", &shhn_pts, NULL)
        && !memcmp (&shhn_pts, &acsh_sweep_class->shhn_pts, sizeof (acsh_sweep_class->shhn_pts)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.shhn_pts [BD*]");
  }
  {
    BITCODE_B shsw_b294;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_b294", &shsw_b294, NULL)
        && shsw_b294 == acsh_sweep_class->shsw_b294)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_b294 [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shsw_b294, shsw_b294);
    shsw_b294++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_b294", &shsw_b294, 0)
        && shsw_b294 == acsh_sweep_class->shsw_b294)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_b294 [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shsw_b294, shsw_b294);
    acsh_sweep_class->shsw_b294--;

  }
  {
    BITCODE_B shsw_b295;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_b295", &shsw_b295, NULL)
        && shsw_b295 == acsh_sweep_class->shsw_b295)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_b295 [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shsw_b295, shsw_b295);
    shsw_b295++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_b295", &shsw_b295, 0)
        && shsw_b295 == acsh_sweep_class->shsw_b295)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_b295 [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shsw_b295, shsw_b295);
    acsh_sweep_class->shsw_b295--;

  }
  {
    BITCODE_B shsw_b296;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_b296", &shsw_b296, NULL)
        && shsw_b296 == acsh_sweep_class->shsw_b296)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_b296 [B] " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shsw_b296, shsw_b296);
    shsw_b296++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_b296", &shsw_b296, 0)
        && shsw_b296 == acsh_sweep_class->shsw_b296)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_b296 [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_sweep_class->shsw_b296, shsw_b296);
    acsh_sweep_class->shsw_b296--;

  }
  {
    BITCODE_BL shsw_bl90;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl90", &shsw_bl90, NULL)
        && shsw_bl90 == acsh_sweep_class->shsw_bl90)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl90 [BL] %u != %u", acsh_sweep_class->shsw_bl90, shsw_bl90);
    shsw_bl90++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl90", &shsw_bl90, 0)
        && shsw_bl90 == acsh_sweep_class->shsw_bl90)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl90 [BL] set+1 %u != %u", acsh_sweep_class->shsw_bl90, shsw_bl90);
    acsh_sweep_class->shsw_bl90--;

  }
  {
    BITCODE_BL shsw_bl91;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl91", &shsw_bl91, NULL)
        && shsw_bl91 == acsh_sweep_class->shsw_bl91)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl91 [BL] %u != %u", acsh_sweep_class->shsw_bl91, shsw_bl91);
    shsw_bl91++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl91", &shsw_bl91, 0)
        && shsw_bl91 == acsh_sweep_class->shsw_bl91)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl91 [BL] set+1 %u != %u", acsh_sweep_class->shsw_bl91, shsw_bl91);
    acsh_sweep_class->shsw_bl91--;

  }
  {
    BITCODE_BL shsw_bl92;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl92", &shsw_bl92, NULL)
        && shsw_bl92 == acsh_sweep_class->shsw_bl92)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl92 [BL] %u != %u", acsh_sweep_class->shsw_bl92, shsw_bl92);
    shsw_bl92++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl92", &shsw_bl92, 0)
        && shsw_bl92 == acsh_sweep_class->shsw_bl92)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl92 [BL] set+1 %u != %u", acsh_sweep_class->shsw_bl92, shsw_bl92);
    acsh_sweep_class->shsw_bl92--;

  }
  {
    BITCODE_BL shsw_bl93;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl93", &shsw_bl93, NULL)
        && shsw_bl93 == acsh_sweep_class->shsw_bl93)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl93 [BL] %u != %u", acsh_sweep_class->shsw_bl93, shsw_bl93);
    shsw_bl93++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_bl93", &shsw_bl93, 0)
        && shsw_bl93 == acsh_sweep_class->shsw_bl93)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_bl93 [BL] set+1 %u != %u", acsh_sweep_class->shsw_bl93, shsw_bl93);
    acsh_sweep_class->shsw_bl93--;

  }
  {
    BITCODE_BL shsw_size_text;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_size_text", &shsw_size_text, NULL)
        && shsw_size_text == acsh_sweep_class->shsw_size_text)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_size_text [BL] %u != %u", acsh_sweep_class->shsw_size_text, shsw_size_text);
    shsw_size_text++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_size_text", &shsw_size_text, 0)
        && shsw_size_text == acsh_sweep_class->shsw_size_text)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_size_text [BL] set+1 %u != %u", acsh_sweep_class->shsw_size_text, shsw_size_text);
    acsh_sweep_class->shsw_size_text--;

  }
  {
    BITCODE_BL shsw_size_text2;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_size_text2", &shsw_size_text2, NULL)
        && shsw_size_text2 == acsh_sweep_class->shsw_size_text2)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_size_text2 [BL] %u != %u", acsh_sweep_class->shsw_size_text2, shsw_size_text2);
    shsw_size_text2++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_size_text2", &shsw_size_text2, 0)
        && shsw_size_text2 == acsh_sweep_class->shsw_size_text2)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.shsw_size_text2 [BL] set+1 %u != %u", acsh_sweep_class->shsw_size_text2, shsw_size_text2);
    acsh_sweep_class->shsw_size_text2--;

  }
  {
    BITCODE_TF shsw_text;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_text", &shsw_text, NULL)
        && !memcmp (&shsw_text, &acsh_sweep_class->shsw_text, sizeof (acsh_sweep_class->shsw_text)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.shsw_text [TF]");
  }
  {
    BITCODE_TF shsw_text2;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "shsw_text2", &shsw_text2, NULL)
        && !memcmp (&shsw_text2, &acsh_sweep_class->shsw_text2, sizeof (acsh_sweep_class->shsw_text2)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.shsw_text2 [TF]");
  }
  {
    BITCODE_BD start_draft_dist;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "start_draft_dist", &start_draft_dist, NULL)
        && start_draft_dist == acsh_sweep_class->start_draft_dist)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.start_draft_dist [BD] %g != %g", acsh_sweep_class->start_draft_dist, start_draft_dist);
    start_draft_dist++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "start_draft_dist", &start_draft_dist, 0)
        && start_draft_dist == acsh_sweep_class->start_draft_dist)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.start_draft_dist [BD] set+1 %g != %g", acsh_sweep_class->start_draft_dist, start_draft_dist);
    acsh_sweep_class->start_draft_dist--;

  }
  {
    BITCODE_BD* sweepentity_transform;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "sweepentity_transform", &sweepentity_transform, NULL)
        && !memcmp (&sweepentity_transform, &acsh_sweep_class->sweepentity_transform, sizeof (acsh_sweep_class->sweepentity_transform)))
        pass ();
    else
        fail ("ACSH_SWEEP_CLASS.sweepentity_transform [BD*]");
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "twist_angle", &twist_angle, NULL)
        && twist_angle == acsh_sweep_class->twist_angle)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.twist_angle [BD] %g != %g", acsh_sweep_class->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (acsh_sweep_class, "ACSH_SWEEP_CLASS", "twist_angle", &twist_angle, 0)
        && twist_angle == acsh_sweep_class->twist_angle)
      pass ();
    else
      fail ("ACSH_SWEEP_CLASS.twist_angle [BD] set+1 %g != %g", acsh_sweep_class->twist_angle, twist_angle);
    acsh_sweep_class->twist_angle--;

  }
  return failed;
}
static int test_ANNOTSCALEOBJECTCONTEXTDATA (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ANNOTSCALEOBJECTCONTEXTDATA *restrict annotscaleobjectcontextdata = obj->tio.object->tio.ANNOTSCALEOBJECTCONTEXTDATA;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "class_version", &class_version, NULL)
        && class_version == annotscaleobjectcontextdata->class_version)
      pass ();
    else
      fail ("ANNOTSCALEOBJECTCONTEXTDATA.class_version [BS] %hu != %hu", annotscaleobjectcontextdata->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "class_version", &class_version, 0)
        && class_version == annotscaleobjectcontextdata->class_version)
      pass ();
    else
      fail ("ANNOTSCALEOBJECTCONTEXTDATA.class_version [BS] set+1 %hu != %hu", annotscaleobjectcontextdata->class_version, class_version);
    annotscaleobjectcontextdata->class_version--;

  }
  {
    BITCODE_B defaultflag;
    if (dwg_dynapi_entity_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "defaultflag", &defaultflag, NULL)
        && defaultflag == annotscaleobjectcontextdata->defaultflag)
      pass ();
    else
      fail ("ANNOTSCALEOBJECTCONTEXTDATA.defaultflag [B] " FORMAT_B " != " FORMAT_B "", annotscaleobjectcontextdata->defaultflag, defaultflag);
    defaultflag++;
    if (dwg_dynapi_entity_set_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "defaultflag", &defaultflag, 0)
        && defaultflag == annotscaleobjectcontextdata->defaultflag)
      pass ();
    else
      fail ("ANNOTSCALEOBJECTCONTEXTDATA.defaultflag [B] set+1 " FORMAT_B " != " FORMAT_B "", annotscaleobjectcontextdata->defaultflag, defaultflag);
    annotscaleobjectcontextdata->defaultflag--;

  }
  {
    BITCODE_B has_file;
    if (dwg_dynapi_entity_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "has_file", &has_file, NULL)
        && has_file == annotscaleobjectcontextdata->has_file)
      pass ();
    else
      fail ("ANNOTSCALEOBJECTCONTEXTDATA.has_file [B] " FORMAT_B " != " FORMAT_B "", annotscaleobjectcontextdata->has_file, has_file);
    has_file++;
    if (dwg_dynapi_entity_set_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "has_file", &has_file, 0)
        && has_file == annotscaleobjectcontextdata->has_file)
      pass ();
    else
      fail ("ANNOTSCALEOBJECTCONTEXTDATA.has_file [B] set+1 " FORMAT_B " != " FORMAT_B "", annotscaleobjectcontextdata->has_file, has_file);
    annotscaleobjectcontextdata->has_file--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "parent", &parent, NULL)
        && !memcmp (&parent, &annotscaleobjectcontextdata->parent, sizeof (annotscaleobjectcontextdata->parent)))
        pass ();
    else
        fail ("ANNOTSCALEOBJECTCONTEXTDATA.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_H scale;
    if (dwg_dynapi_entity_value (annotscaleobjectcontextdata, "ANNOTSCALEOBJECTCONTEXTDATA", "scale", &scale, NULL)
        && !memcmp (&scale, &annotscaleobjectcontextdata->scale, sizeof (annotscaleobjectcontextdata->scale)))
        pass ();
    else
        fail ("ANNOTSCALEOBJECTCONTEXTDATA.scale [H]");
  }
  return failed;
}
static int test_APPID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_APPID *restrict appid = obj->tio.object->tio.APPID;
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (appid, "APPID", "flag", &flag, NULL)
        && flag == appid->flag)
      pass ();
    else
      fail ("APPID.flag [RC] %u != %u", appid->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (appid, "APPID", "flag", &flag, 0)
        && flag == appid->flag)
      pass ();
    else
      fail ("APPID.flag [RC] set+1 %u != %u", appid->flag, flag);
    appid->flag--;

  }
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value (appid, "APPID", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)appid->name)
           : !appid->name)
      pass ();
    else
      fail ("APPID.name [TV] '%s' <> '%s'", name, appid->name);
  }
  {
    BITCODE_H null_handle;
    if (dwg_dynapi_entity_value (appid, "APPID", "null_handle", &null_handle, NULL)
        && !memcmp (&null_handle, &appid->null_handle, sizeof (appid->null_handle)))
        pass ();
    else
        fail ("APPID.null_handle [H]");
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (appid, "APPID", "parent", &parent, NULL)
        && !memcmp (&parent, &appid->parent, sizeof (appid->parent)))
        pass ();
    else
        fail ("APPID.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_RC unknown;
    if (dwg_dynapi_entity_value (appid, "APPID", "unknown", &unknown, NULL)
        && unknown == appid->unknown)
      pass ();
    else
      fail ("APPID.unknown [RC] %u != %u", appid->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (appid, "APPID", "unknown", &unknown, 0)
        && unknown == appid->unknown)
      pass ();
    else
      fail ("APPID.unknown [RC] set+1 %u != %u", appid->unknown, unknown);
    appid->unknown--;

  }
  {
    BITCODE_RS used;
    if (dwg_dynapi_entity_value (appid, "APPID", "used", &used, NULL)
        && used == appid->used)
      pass ();
    else
      fail ("APPID.used [RS] %hu != %hu", appid->used, used);
    used++;
    if (dwg_dynapi_entity_set_value (appid, "APPID", "used", &used, 0)
        && used == appid->used)
      pass ();
    else
      fail ("APPID.used [RS] set+1 %hu != %hu", appid->used, used);
    appid->used--;

  }
  {
    BITCODE_B xrefdep;
    if (dwg_dynapi_entity_value (appid, "APPID", "xrefdep", &xrefdep, NULL)
        && xrefdep == appid->xrefdep)
      pass ();
    else
      fail ("APPID.xrefdep [B] " FORMAT_B " != " FORMAT_B "", appid->xrefdep, xrefdep);
    xrefdep++;
    if (dwg_dynapi_entity_set_value (appid, "APPID", "xrefdep", &xrefdep, 0)
        && xrefdep == appid->xrefdep)
      pass ();
    else
      fail ("APPID.xrefdep [B] set+1 " FORMAT_B " != " FORMAT_B "", appid->xrefdep, xrefdep);
    appid->xrefdep--;

  }
  {
    BITCODE_BS xrefindex_plus1;
    if (dwg_dynapi_entity_value (appid, "APPID", "xrefindex_plus1", &xrefindex_plus1, NULL)
        && xrefindex_plus1 == appid->xrefindex_plus1)
      pass ();
    else
      fail ("APPID.xrefindex_plus1 [BS] %hu != %hu", appid->xrefindex_plus1, xrefindex_plus1);
    xrefindex_plus1++;
    if (dwg_dynapi_entity_set_value (appid, "APPID", "xrefindex_plus1", &xrefindex_plus1, 0)
        && xrefindex_plus1 == appid->xrefindex_plus1)
      pass ();
    else
      fail ("APPID.xrefindex_plus1 [BS] set+1 %hu != %hu", appid->xrefindex_plus1, xrefindex_plus1);
    appid->xrefindex_plus1--;

  }
  {
    BITCODE_B xrefref;
    if (dwg_dynapi_entity_value (appid, "APPID", "xrefref", &xrefref, NULL)
        && xrefref == appid->xrefref)
      pass ();
    else
      fail ("APPID.xrefref [B] " FORMAT_B " != " FORMAT_B "", appid->xrefref, xrefref);
    xrefref++;
    if (dwg_dynapi_entity_set_value (appid, "APPID", "xrefref", &xrefref, 0)
        && xrefref == appid->xrefref)
      pass ();
    else
      fail ("APPID.xrefref [B] set+1 " FORMAT_B " != " FORMAT_B "", appid->xrefref, xrefref);
    appid->xrefref--;

  }
  return failed;
}
static int test_APPID_CONTROL (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_APPID_CONTROL *restrict appid_control = obj->tio.object->tio.APPID_CONTROL;
  {
    BITCODE_H* entries;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (appid_control, "APPID_CONTROL", "num_entries", &count, NULL)
        && dwg_dynapi_entity_value (appid_control, "APPID_CONTROL", "entries", &entries, NULL)
        && entries == appid_control->entries)
      pass ();
    else
      fail ("APPID_CONTROL.entries [H*] * %u num_entries", count);
  }
  {
    BITCODE_BS num_entries;
    if (dwg_dynapi_entity_value (appid_control, "APPID_CONTROL", "num_entries", &num_entries, NULL)
        && num_entries == appid_control->num_entries)
      pass ();
    else
      fail ("APPID_CONTROL.num_entries [BS] %hu != %hu", appid_control->num_entries, num_entries);
    num_entries++;
    if (dwg_dynapi_entity_set_value (appid_control, "APPID_CONTROL", "num_entries", &num_entries, 0)
        && num_entries == appid_control->num_entries)
      pass ();
    else
      fail ("APPID_CONTROL.num_entries [BS] set+1 %hu != %hu", appid_control->num_entries, num_entries);
    appid_control->num_entries--;

  }
  {
    BITCODE_BL objid;
    if (dwg_dynapi_entity_value (appid_control, "APPID_CONTROL", "objid", &objid, NULL)
        && objid == appid_control->objid)
      pass ();
    else
      fail ("APPID_CONTROL.objid [BL] %u != %u", appid_control->objid, objid);
    objid++;
    if (dwg_dynapi_entity_set_value (appid_control, "APPID_CONTROL", "objid", &objid, 0)
        && objid == appid_control->objid)
      pass ();
    else
      fail ("APPID_CONTROL.objid [BL] set+1 %u != %u", appid_control->objid, objid);
    appid_control->objid--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (appid_control, "APPID_CONTROL", "parent", &parent, NULL)
        && !memcmp (&parent, &appid_control->parent, sizeof (appid_control->parent)))
        pass ();
    else
        fail ("APPID_CONTROL.parent [struct _dwg_object_object*]");
  }
  return failed;
}
static int test_ASSOC2DCONSTRAINTGROUP (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOC2DCONSTRAINTGROUP *restrict assoc2dconstraintgroup = obj->tio.object->tio.ASSOC2DCONSTRAINTGROUP;
  {
    BITCODE_B b1;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "b1", &b1, NULL)
        && b1 == assoc2dconstraintgroup->b1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.b1 [B] " FORMAT_B " != " FORMAT_B "", assoc2dconstraintgroup->b1, b1);
    b1++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "b1", &b1, 0)
        && b1 == assoc2dconstraintgroup->b1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.b1 [B] set+1 " FORMAT_B " != " FORMAT_B "", assoc2dconstraintgroup->b1, b1);
    assoc2dconstraintgroup->b1--;

  }
  {
    BITCODE_3BD c1;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "c1", &c1, NULL)
        && !memcmp (&c1, &assoc2dconstraintgroup->c1, sizeof (assoc2dconstraintgroup->c1)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.c1 [3BD]");
  }
  {
    BITCODE_3BD c2;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "c2", &c2, NULL)
        && !memcmp (&c2, &assoc2dconstraintgroup->c2, sizeof (assoc2dconstraintgroup->c2)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.c2 [3BD]");
  }
  {
    BITCODE_3BD c3;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "c3", &c3, NULL)
        && !memcmp (&c3, &assoc2dconstraintgroup->c3, sizeof (assoc2dconstraintgroup->c3)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.c3 [3BD]");
  }
  {
    BITCODE_BL cl1;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl1", &cl1, NULL)
        && cl1 == assoc2dconstraintgroup->cl1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl1 [BL] %u != %u", assoc2dconstraintgroup->cl1, cl1);
    cl1++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl1", &cl1, 0)
        && cl1 == assoc2dconstraintgroup->cl1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl1 [BL] set+1 %u != %u", assoc2dconstraintgroup->cl1, cl1);
    assoc2dconstraintgroup->cl1--;

  }
  {
    BITCODE_BL cl2;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl2", &cl2, NULL)
        && cl2 == assoc2dconstraintgroup->cl2)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl2 [BL] %u != %u", assoc2dconstraintgroup->cl2, cl2);
    cl2++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl2", &cl2, 0)
        && cl2 == assoc2dconstraintgroup->cl2)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl2 [BL] set+1 %u != %u", assoc2dconstraintgroup->cl2, cl2);
    assoc2dconstraintgroup->cl2--;

  }
  {
    BITCODE_BL cl3;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl3", &cl3, NULL)
        && cl3 == assoc2dconstraintgroup->cl3)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl3 [BL] %u != %u", assoc2dconstraintgroup->cl3, cl3);
    cl3++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl3", &cl3, 0)
        && cl3 == assoc2dconstraintgroup->cl3)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl3 [BL] set+1 %u != %u", assoc2dconstraintgroup->cl3, cl3);
    assoc2dconstraintgroup->cl3--;

  }
  {
    BITCODE_BL cl4;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl4", &cl4, NULL)
        && cl4 == assoc2dconstraintgroup->cl4)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl4 [BL] %u != %u", assoc2dconstraintgroup->cl4, cl4);
    cl4++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cl4", &cl4, 0)
        && cl4 == assoc2dconstraintgroup->cl4)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cl4 [BL] set+1 %u != %u", assoc2dconstraintgroup->cl4, cl4);
    assoc2dconstraintgroup->cl4--;

  }
  {
    BITCODE_BL constraint_status;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "constraint_status", &constraint_status, NULL)
        && constraint_status == assoc2dconstraintgroup->constraint_status)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.constraint_status [BL] %u != %u", assoc2dconstraintgroup->constraint_status, constraint_status);
    constraint_status++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "constraint_status", &constraint_status, 0)
        && constraint_status == assoc2dconstraintgroup->constraint_status)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.constraint_status [BL] set+1 %u != %u", assoc2dconstraintgroup->constraint_status, constraint_status);
    assoc2dconstraintgroup->constraint_status--;

  }
  {
    BITCODE_RC cs1;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cs1", &cs1, NULL)
        && cs1 == assoc2dconstraintgroup->cs1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cs1 [RC] %u != %u", assoc2dconstraintgroup->cs1, cs1);
    cs1++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "cs1", &cs1, 0)
        && cs1 == assoc2dconstraintgroup->cs1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.cs1 [RC] set+1 %u != %u", assoc2dconstraintgroup->cs1, cs1);
    assoc2dconstraintgroup->cs1--;

  }
  {
    BITCODE_BL dof;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "dof", &dof, NULL)
        && dof == assoc2dconstraintgroup->dof)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.dof [BL] %u != %u", assoc2dconstraintgroup->dof, dof);
    dof++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "dof", &dof, 0)
        && dof == assoc2dconstraintgroup->dof)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.dof [BL] set+1 %u != %u", assoc2dconstraintgroup->dof, dof);
    assoc2dconstraintgroup->dof--;

  }
  {
    BITCODE_BL geometry_status;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "geometry_status", &geometry_status, NULL)
        && geometry_status == assoc2dconstraintgroup->geometry_status)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.geometry_status [BL] %u != %u", assoc2dconstraintgroup->geometry_status, geometry_status);
    geometry_status++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "geometry_status", &geometry_status, 0)
        && geometry_status == assoc2dconstraintgroup->geometry_status)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.geometry_status [BL] set+1 %u != %u", assoc2dconstraintgroup->geometry_status, geometry_status);
    assoc2dconstraintgroup->geometry_status--;

  }
  {
    BITCODE_B is_body_a_proxy;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "is_body_a_proxy", &is_body_a_proxy, NULL)
        && is_body_a_proxy == assoc2dconstraintgroup->is_body_a_proxy)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.is_body_a_proxy [B] " FORMAT_B " != " FORMAT_B "", assoc2dconstraintgroup->is_body_a_proxy, is_body_a_proxy);
    is_body_a_proxy++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "is_body_a_proxy", &is_body_a_proxy, 0)
        && is_body_a_proxy == assoc2dconstraintgroup->is_body_a_proxy)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.is_body_a_proxy [B] set+1 " FORMAT_B " != " FORMAT_B "", assoc2dconstraintgroup->is_body_a_proxy, is_body_a_proxy);
    assoc2dconstraintgroup->is_body_a_proxy--;

  }
  {
    BITCODE_BL l5;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l5", &l5, NULL)
        && l5 == assoc2dconstraintgroup->l5)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l5 [BL] %u != %u", assoc2dconstraintgroup->l5, l5);
    l5++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l5", &l5, 0)
        && l5 == assoc2dconstraintgroup->l5)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l5 [BL] set+1 %u != %u", assoc2dconstraintgroup->l5, l5);
    assoc2dconstraintgroup->l5--;

  }
  {
    BITCODE_BL l6;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l6", &l6, NULL)
        && l6 == assoc2dconstraintgroup->l6)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l6 [BL] %u != %u", assoc2dconstraintgroup->l6, l6);
    l6++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l6", &l6, 0)
        && l6 == assoc2dconstraintgroup->l6)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l6 [BL] set+1 %u != %u", assoc2dconstraintgroup->l6, l6);
    assoc2dconstraintgroup->l6--;

  }
  {
    BITCODE_BL l7;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l7", &l7, NULL)
        && l7 == assoc2dconstraintgroup->l7)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l7 [BL] %u != %u", assoc2dconstraintgroup->l7, l7);
    l7++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l7", &l7, 0)
        && l7 == assoc2dconstraintgroup->l7)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l7 [BL] set+1 %u != %u", assoc2dconstraintgroup->l7, l7);
    assoc2dconstraintgroup->l7--;

  }
  {
    BITCODE_BL l8;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l8", &l8, NULL)
        && l8 == assoc2dconstraintgroup->l8)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l8 [BL] %u != %u", assoc2dconstraintgroup->l8, l8);
    l8++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "l8", &l8, 0)
        && l8 == assoc2dconstraintgroup->l8)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.l8 [BL] set+1 %u != %u", assoc2dconstraintgroup->l8, l8);
    assoc2dconstraintgroup->l8--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "parent", &parent, NULL)
        && !memcmp (&parent, &assoc2dconstraintgroup->parent, sizeof (assoc2dconstraintgroup->parent)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_H readdep;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "readdep", &readdep, NULL)
        && !memcmp (&readdep, &assoc2dconstraintgroup->readdep, sizeof (assoc2dconstraintgroup->readdep)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.readdep [H]");
  }
  {
    BITCODE_BL solution_status;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "solution_status", &solution_status, NULL)
        && solution_status == assoc2dconstraintgroup->solution_status)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.solution_status [BL] %u != %u", assoc2dconstraintgroup->solution_status, solution_status);
    solution_status++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "solution_status", &solution_status, 0)
        && solution_status == assoc2dconstraintgroup->solution_status)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.solution_status [BL] set+1 %u != %u", assoc2dconstraintgroup->solution_status, solution_status);
    assoc2dconstraintgroup->solution_status--;

  }
  {
    BITCODE_BD w1;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "w1", &w1, NULL)
        && w1 == assoc2dconstraintgroup->w1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.w1 [BD] %g != %g", assoc2dconstraintgroup->w1, w1);
    w1++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "w1", &w1, 0)
        && w1 == assoc2dconstraintgroup->w1)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.w1 [BD] set+1 %g != %g", assoc2dconstraintgroup->w1, w1);
    assoc2dconstraintgroup->w1--;

  }
  {
    BITCODE_BD w2;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "w2", &w2, NULL)
        && w2 == assoc2dconstraintgroup->w2)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.w2 [BD] %g != %g", assoc2dconstraintgroup->w2, w2);
    w2++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "w2", &w2, 0)
        && w2 == assoc2dconstraintgroup->w2)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.w2 [BD] set+1 %g != %g", assoc2dconstraintgroup->w2, w2);
    assoc2dconstraintgroup->w2--;

  }
  {
    BITCODE_BD w3;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "w3", &w3, NULL)
        && w3 == assoc2dconstraintgroup->w3)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.w3 [BD] %g != %g", assoc2dconstraintgroup->w3, w3);
    w3++;
    if (dwg_dynapi_entity_set_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "w3", &w3, 0)
        && w3 == assoc2dconstraintgroup->w3)
      pass ();
    else
      fail ("ASSOC2DCONSTRAINTGROUP.w3 [BD] set+1 %g != %g", assoc2dconstraintgroup->w3, w3);
    assoc2dconstraintgroup->w3--;

  }
  {
    BITCODE_3BD workplane[3];
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "workplane[3]", &workplane, NULL)
        && !memcmp (&workplane, &assoc2dconstraintgroup->workplane, sizeof (assoc2dconstraintgroup->workplane)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.workplane[3] [3BD]");
  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assoc2dconstraintgroup, "ASSOC2DCONSTRAINTGROUP", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assoc2dconstraintgroup->writedep, sizeof (assoc2dconstraintgroup->writedep)))
        pass ();
    else
        fail ("ASSOC2DCONSTRAINTGROUP.writedep [H]");
  }
  return failed;
}
static int test_ASSOCACTION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCACTION *restrict assocaction = obj->tio.object->tio.ASSOCACTION;
  {
    BITCODE_H actionbody;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "actionbody", &actionbody, NULL)
        && !memcmp (&actionbody, &assocaction->actionbody, sizeof (assocaction->actionbody)))
        pass ();
    else
        fail ("ASSOCACTION.actionbody [H]");
  }
  {
    Dwg_ACTIONBODY body;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "body", &body, NULL)
        && !memcmp (&body, &assocaction->body, sizeof (assocaction->body)))
        pass ();
    else
        fail ("ASSOCACTION.body [Dwg_ACTIONBODY]");
  }
  {
    BITCODE_H callback;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "callback", &callback, NULL)
        && !memcmp (&callback, &assocaction->callback, sizeof (assocaction->callback)))
        pass ();
    else
        fail ("ASSOCACTION.callback [H]");
  }
  {
    BITCODE_BL constraint_status;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "constraint_status", &constraint_status, NULL)
        && constraint_status == assocaction->constraint_status)
      pass ();
    else
      fail ("ASSOCACTION.constraint_status [BL] %u != %u", assocaction->constraint_status, constraint_status);
    constraint_status++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "constraint_status", &constraint_status, 0)
        && constraint_status == assocaction->constraint_status)
      pass ();
    else
      fail ("ASSOCACTION.constraint_status [BL] set+1 %u != %u", assocaction->constraint_status, constraint_status);
    assocaction->constraint_status--;

  }
  {
    BITCODE_BL dof;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "dof", &dof, NULL)
        && dof == assocaction->dof)
      pass ();
    else
      fail ("ASSOCACTION.dof [BL] %u != %u", assocaction->dof, dof);
    dof++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "dof", &dof, 0)
        && dof == assocaction->dof)
      pass ();
    else
      fail ("ASSOCACTION.dof [BL] set+1 %u != %u", assocaction->dof, dof);
    assocaction->dof--;

  }
  {
    BITCODE_BL geometry_status;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "geometry_status", &geometry_status, NULL)
        && geometry_status == assocaction->geometry_status)
      pass ();
    else
      fail ("ASSOCACTION.geometry_status [BL] %u != %u", assocaction->geometry_status, geometry_status);
    geometry_status++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "geometry_status", &geometry_status, 0)
        && geometry_status == assocaction->geometry_status)
      pass ();
    else
      fail ("ASSOCACTION.geometry_status [BL] set+1 %u != %u", assocaction->geometry_status, geometry_status);
    assocaction->geometry_status--;

  }
  {
    BITCODE_B is_body_a_proxy;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "is_body_a_proxy", &is_body_a_proxy, NULL)
        && is_body_a_proxy == assocaction->is_body_a_proxy)
      pass ();
    else
      fail ("ASSOCACTION.is_body_a_proxy [B] " FORMAT_B " != " FORMAT_B "", assocaction->is_body_a_proxy, is_body_a_proxy);
    is_body_a_proxy++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "is_body_a_proxy", &is_body_a_proxy, 0)
        && is_body_a_proxy == assocaction->is_body_a_proxy)
      pass ();
    else
      fail ("ASSOCACTION.is_body_a_proxy [B] set+1 " FORMAT_B " != " FORMAT_B "", assocaction->is_body_a_proxy, is_body_a_proxy);
    assocaction->is_body_a_proxy--;

  }
  {
    BITCODE_BL num_deps;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "num_deps", &num_deps, NULL)
        && num_deps == assocaction->num_deps)
      pass ();
    else
      fail ("ASSOCACTION.num_deps [BL] %u != %u", assocaction->num_deps, num_deps);
    num_deps++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "num_deps", &num_deps, 0)
        && num_deps == assocaction->num_deps)
      pass ();
    else
      fail ("ASSOCACTION.num_deps [BL] set+1 %u != %u", assocaction->num_deps, num_deps);
    assocaction->num_deps--;

  }
  {
    BITCODE_H owningnetwork;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "owningnetwork", &owningnetwork, NULL)
        && !memcmp (&owningnetwork, &assocaction->owningnetwork, sizeof (assocaction->owningnetwork)))
        pass ();
    else
        fail ("ASSOCACTION.owningnetwork [H]");
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "parent", &parent, NULL)
        && !memcmp (&parent, &assocaction->parent, sizeof (assocaction->parent)))
        pass ();
    else
        fail ("ASSOCACTION.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_H readdep;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "readdep", &readdep, NULL)
        && !memcmp (&readdep, &assocaction->readdep, sizeof (assocaction->readdep)))
        pass ();
    else
        fail ("ASSOCACTION.readdep [H]");
  }
  {
    BITCODE_BL solution_status;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "solution_status", &solution_status, NULL)
        && solution_status == assocaction->solution_status)
      pass ();
    else
      fail ("ASSOCACTION.solution_status [BL] %u != %u", assocaction->solution_status, solution_status);
    solution_status++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "solution_status", &solution_status, 0)
        && solution_status == assocaction->solution_status)
      pass ();
    else
      fail ("ASSOCACTION.solution_status [BL] set+1 %u != %u", assocaction->solution_status, solution_status);
    assocaction->solution_status--;

  }
  {
    BITCODE_BL status;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "status", &status, NULL)
        && status == assocaction->status)
      pass ();
    else
      fail ("ASSOCACTION.status [BL] %u != %u", assocaction->status, status);
    status++;
    if (dwg_dynapi_entity_set_value (assocaction, "ASSOCACTION", "status", &status, 0)
        && status == assocaction->status)
      pass ();
    else
      fail ("ASSOCACTION.status [BL] set+1 %u != %u", assocaction->status, status);
    assocaction->status--;

  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assocaction, "ASSOCACTION", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assocaction->writedep, sizeof (assocaction->writedep)))
        pass ();
    else
        fail ("ASSOCACTION.writedep [H]");
  }
  return failed;
}
static int test_ASSOCALIGNEDDIMACTIONBODY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCALIGNEDDIMACTIONBODY *restrict assocaligneddimactionbody = obj->tio.object->tio.ASSOCALIGNEDDIMACTIONBODY;
  {
    BITCODE_BL aab_status;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "aab_status", &aab_status, NULL)
        && aab_status == assocaligneddimactionbody->aab_status)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.aab_status [BL] %u != %u", assocaligneddimactionbody->aab_status, aab_status);
    aab_status++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "aab_status", &aab_status, 0)
        && aab_status == assocaligneddimactionbody->aab_status)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.aab_status [BL] set+1 %u != %u", assocaligneddimactionbody->aab_status, aab_status);
    assocaligneddimactionbody->aab_status--;

  }
  {
    BITCODE_H d_node;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "d_node", &d_node, NULL)
        && !memcmp (&d_node, &assocaligneddimactionbody->d_node, sizeof (assocaligneddimactionbody->d_node)))
        pass ();
    else
        fail ("ASSOCALIGNEDDIMACTIONBODY.d_node [H]");
  }
  {
    BITCODE_BL dcm_status;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "dcm_status", &dcm_status, NULL)
        && dcm_status == assocaligneddimactionbody->dcm_status)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.dcm_status [BL] %u != %u", assocaligneddimactionbody->dcm_status, dcm_status);
    dcm_status++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "dcm_status", &dcm_status, 0)
        && dcm_status == assocaligneddimactionbody->dcm_status)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.dcm_status [BL] set+1 %u != %u", assocaligneddimactionbody->dcm_status, dcm_status);
    assocaligneddimactionbody->dcm_status--;

  }
  {
    BITCODE_BL pab_l2;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l2", &pab_l2, NULL)
        && pab_l2 == assocaligneddimactionbody->pab_l2)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l2 [BL] %u != %u", assocaligneddimactionbody->pab_l2, pab_l2);
    pab_l2++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l2", &pab_l2, 0)
        && pab_l2 == assocaligneddimactionbody->pab_l2)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l2 [BL] set+1 %u != %u", assocaligneddimactionbody->pab_l2, pab_l2);
    assocaligneddimactionbody->pab_l2--;

  }
  {
    BITCODE_BL pab_l3;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l3", &pab_l3, NULL)
        && pab_l3 == assocaligneddimactionbody->pab_l3)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l3 [BL] %u != %u", assocaligneddimactionbody->pab_l3, pab_l3);
    pab_l3++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l3", &pab_l3, 0)
        && pab_l3 == assocaligneddimactionbody->pab_l3)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l3 [BL] set+1 %u != %u", assocaligneddimactionbody->pab_l3, pab_l3);
    assocaligneddimactionbody->pab_l3--;

  }
  {
    BITCODE_BL pab_l4;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l4", &pab_l4, NULL)
        && pab_l4 == assocaligneddimactionbody->pab_l4)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l4 [BL] %u != %u", assocaligneddimactionbody->pab_l4, pab_l4);
    pab_l4++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l4", &pab_l4, 0)
        && pab_l4 == assocaligneddimactionbody->pab_l4)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l4 [BL] set+1 %u != %u", assocaligneddimactionbody->pab_l4, pab_l4);
    assocaligneddimactionbody->pab_l4--;

  }
  {
    BITCODE_BL pab_l5;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l5", &pab_l5, NULL)
        && pab_l5 == assocaligneddimactionbody->pab_l5)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l5 [BL] %u != %u", assocaligneddimactionbody->pab_l5, pab_l5);
    pab_l5++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l5", &pab_l5, 0)
        && pab_l5 == assocaligneddimactionbody->pab_l5)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l5 [BL] set+1 %u != %u", assocaligneddimactionbody->pab_l5, pab_l5);
    assocaligneddimactionbody->pab_l5--;

  }
  {
    BITCODE_BL pab_l6;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l6", &pab_l6, NULL)
        && pab_l6 == assocaligneddimactionbody->pab_l6)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l6 [BL] %u != %u", assocaligneddimactionbody->pab_l6, pab_l6);
    pab_l6++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_l6", &pab_l6, 0)
        && pab_l6 == assocaligneddimactionbody->pab_l6)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_l6 [BL] set+1 %u != %u", assocaligneddimactionbody->pab_l6, pab_l6);
    assocaligneddimactionbody->pab_l6--;

  }
  {
    BITCODE_BL pab_status;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_status", &pab_status, NULL)
        && pab_status == assocaligneddimactionbody->pab_status)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_status [BL] %u != %u", assocaligneddimactionbody->pab_status, pab_status);
    pab_status++;
    if (dwg_dynapi_entity_set_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "pab_status", &pab_status, 0)
        && pab_status == assocaligneddimactionbody->pab_status)
      pass ();
    else
      fail ("ASSOCALIGNEDDIMACTIONBODY.pab_status [BL] set+1 %u != %u", assocaligneddimactionbody->pab_status, pab_status);
    assocaligneddimactionbody->pab_status--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "parent", &parent, NULL)
        && !memcmp (&parent, &assocaligneddimactionbody->parent, sizeof (assocaligneddimactionbody->parent)))
        pass ();
    else
        fail ("ASSOCALIGNEDDIMACTIONBODY.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_H r_node;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "r_node", &r_node, NULL)
        && !memcmp (&r_node, &assocaligneddimactionbody->r_node, sizeof (assocaligneddimactionbody->r_node)))
        pass ();
    else
        fail ("ASSOCALIGNEDDIMACTIONBODY.r_node [H]");
  }
  {
    BITCODE_H readdep;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "readdep", &readdep, NULL)
        && !memcmp (&readdep, &assocaligneddimactionbody->readdep, sizeof (assocaligneddimactionbody->readdep)))
        pass ();
    else
        fail ("ASSOCALIGNEDDIMACTIONBODY.readdep [H]");
  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assocaligneddimactionbody, "ASSOCALIGNEDDIMACTIONBODY", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assocaligneddimactionbody->writedep, sizeof (assocaligneddimactionbody->writedep)))
        pass ();
    else
        fail ("ASSOCALIGNEDDIMACTIONBODY.writedep [H]");
  }
  return failed;
}
static int test_ASSOCDEPENDENCY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCDEPENDENCY *restrict assocdependency = obj->tio.object->tio.ASSOCDEPENDENCY;
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "class_version", &class_version, NULL)
        && class_version == assocdependency->class_version)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.class_version [BL] %u != %u", assocdependency->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "class_version", &class_version, 0)
        && class_version == assocdependency->class_version)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.class_version [BL] set+1 %u != %u", assocdependency->class_version, class_version);
    assocdependency->class_version--;

  }
  {
    BITCODE_BL depbodyid;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "depbodyid", &depbodyid, NULL)
        && depbodyid == assocdependency->depbodyid)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.depbodyid [BL] %u != %u", assocdependency->depbodyid, depbodyid);
    depbodyid++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "depbodyid", &depbodyid, 0)
        && depbodyid == assocdependency->depbodyid)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.depbodyid [BL] set+1 %u != %u", assocdependency->depbodyid, depbodyid);
    assocdependency->depbodyid--;

  }
  {
    BITCODE_B isobjectstate_dep;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "isobjectstate_dep", &isobjectstate_dep, NULL)
        && isobjectstate_dep == assocdependency->isobjectstate_dep)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.isobjectstate_dep [B] " FORMAT_B " != " FORMAT_B "", assocdependency->isobjectstate_dep, isobjectstate_dep);
    isobjectstate_dep++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "isobjectstate_dep", &isobjectstate_dep, 0)
        && isobjectstate_dep == assocdependency->isobjectstate_dep)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.isobjectstate_dep [B] set+1 " FORMAT_B " != " FORMAT_B "", assocdependency->isobjectstate_dep, isobjectstate_dep);
    assocdependency->isobjectstate_dep--;

  }
  {
    BITCODE_B isread_dep;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "isread_dep", &isread_dep, NULL)
        && isread_dep == assocdependency->isread_dep)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.isread_dep [B] " FORMAT_B " != " FORMAT_B "", assocdependency->isread_dep, isread_dep);
    isread_dep++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "isread_dep", &isread_dep, 0)
        && isread_dep == assocdependency->isread_dep)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.isread_dep [B] set+1 " FORMAT_B " != " FORMAT_B "", assocdependency->isread_dep, isread_dep);
    assocdependency->isread_dep--;

  }
  {
    BITCODE_B iswrite_dep;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "iswrite_dep", &iswrite_dep, NULL)
        && iswrite_dep == assocdependency->iswrite_dep)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.iswrite_dep [B] " FORMAT_B " != " FORMAT_B "", assocdependency->iswrite_dep, iswrite_dep);
    iswrite_dep++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "iswrite_dep", &iswrite_dep, 0)
        && iswrite_dep == assocdependency->iswrite_dep)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.iswrite_dep [B] set+1 " FORMAT_B " != " FORMAT_B "", assocdependency->iswrite_dep, iswrite_dep);
    assocdependency->iswrite_dep--;

  }
  {
    BITCODE_H node;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "node", &node, NULL)
        && !memcmp (&node, &assocdependency->node, sizeof (assocdependency->node)))
        pass ();
    else
        fail ("ASSOCDEPENDENCY.node [H]");
  }
  {
    BITCODE_BL order;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "order", &order, NULL)
        && order == assocdependency->order)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.order [BL] %u != %u", assocdependency->order, order);
    order++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "order", &order, 0)
        && order == assocdependency->order)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.order [BL] set+1 %u != %u", assocdependency->order, order);
    assocdependency->order--;

  }
  {
    BITCODE_H owner;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "owner", &owner, NULL)
        && !memcmp (&owner, &assocdependency->owner, sizeof (assocdependency->owner)))
        pass ();
    else
        fail ("ASSOCDEPENDENCY.owner [H]");
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "parent", &parent, NULL)
        && !memcmp (&parent, &assocdependency->parent, sizeof (assocdependency->parent)))
        pass ();
    else
        fail ("ASSOCDEPENDENCY.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_H readdep;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "readdep", &readdep, NULL)
        && !memcmp (&readdep, &assocdependency->readdep, sizeof (assocdependency->readdep)))
        pass ();
    else
        fail ("ASSOCDEPENDENCY.readdep [H]");
  }
  {
    BITCODE_BL status;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "status", &status, NULL)
        && status == assocdependency->status)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.status [BL] %u != %u", assocdependency->status, status);
    status++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "status", &status, 0)
        && status == assocdependency->status)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.status [BL] set+1 %u != %u", assocdependency->status, status);
    assocdependency->status--;

  }
  {
    BITCODE_B unknown_b4;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "unknown_b4", &unknown_b4, NULL)
        && unknown_b4 == assocdependency->unknown_b4)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.unknown_b4 [B] " FORMAT_B " != " FORMAT_B "", assocdependency->unknown_b4, unknown_b4);
    unknown_b4++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "unknown_b4", &unknown_b4, 0)
        && unknown_b4 == assocdependency->unknown_b4)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.unknown_b4 [B] set+1 " FORMAT_B " != " FORMAT_B "", assocdependency->unknown_b4, unknown_b4);
    assocdependency->unknown_b4--;

  }
  {
    BITCODE_B unknown_b5;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "unknown_b5", &unknown_b5, NULL)
        && unknown_b5 == assocdependency->unknown_b5)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.unknown_b5 [B] " FORMAT_B " != " FORMAT_B "", assocdependency->unknown_b5, unknown_b5);
    unknown_b5++;
    if (dwg_dynapi_entity_set_value (assocdependency, "ASSOCDEPENDENCY", "unknown_b5", &unknown_b5, 0)
        && unknown_b5 == assocdependency->unknown_b5)
      pass ();
    else
      fail ("ASSOCDEPENDENCY.unknown_b5 [B] set+1 " FORMAT_B " != " FORMAT_B "", assocdependency->unknown_b5, unknown_b5);
    assocdependency->unknown_b5--;

  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assocdependency, "ASSOCDEPENDENCY", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assocdependency->writedep, sizeof (assocdependency->writedep)))
        pass ();
    else
        fail ("ASSOCDEPENDENCY.writedep [H]");
  }
  return failed;
}
static int test_ASSOCNETWORK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCNETWORK *restrict assocnetwork = obj->tio.object->tio.ASSOCNETWORK;
  {
    BITCODE_H* actions;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "num_actions", &count, NULL)
        && dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "actions", &actions, NULL)
        && actions == assocnetwork->actions)
      pass ();
    else
      fail ("ASSOCNETWORK.actions [H*] * %u num_actions", count);
  }
  {
    BITCODE_BL constraint_status;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "constraint_status", &constraint_status, NULL)
        && constraint_status == assocnetwork->constraint_status)
      pass ();
    else
      fail ("ASSOCNETWORK.constraint_status [BL] %u != %u", assocnetwork->constraint_status, constraint_status);
    constraint_status++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "constraint_status", &constraint_status, 0)
        && constraint_status == assocnetwork->constraint_status)
      pass ();
    else
      fail ("ASSOCNETWORK.constraint_status [BL] set+1 %u != %u", assocnetwork->constraint_status, constraint_status);
    assocnetwork->constraint_status--;

  }
  {
    BITCODE_BL dof;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "dof", &dof, NULL)
        && dof == assocnetwork->dof)
      pass ();
    else
      fail ("ASSOCNETWORK.dof [BL] %u != %u", assocnetwork->dof, dof);
    dof++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "dof", &dof, 0)
        && dof == assocnetwork->dof)
      pass ();
    else
      fail ("ASSOCNETWORK.dof [BL] set+1 %u != %u", assocnetwork->dof, dof);
    assocnetwork->dof--;

  }
  {
    BITCODE_BL geometry_status;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "geometry_status", &geometry_status, NULL)
        && geometry_status == assocnetwork->geometry_status)
      pass ();
    else
      fail ("ASSOCNETWORK.geometry_status [BL] %u != %u", assocnetwork->geometry_status, geometry_status);
    geometry_status++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "geometry_status", &geometry_status, 0)
        && geometry_status == assocnetwork->geometry_status)
      pass ();
    else
      fail ("ASSOCNETWORK.geometry_status [BL] set+1 %u != %u", assocnetwork->geometry_status, geometry_status);
    assocnetwork->geometry_status--;

  }
  {
    BITCODE_B is_body_a_proxy;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "is_body_a_proxy", &is_body_a_proxy, NULL)
        && is_body_a_proxy == assocnetwork->is_body_a_proxy)
      pass ();
    else
      fail ("ASSOCNETWORK.is_body_a_proxy [B] " FORMAT_B " != " FORMAT_B "", assocnetwork->is_body_a_proxy, is_body_a_proxy);
    is_body_a_proxy++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "is_body_a_proxy", &is_body_a_proxy, 0)
        && is_body_a_proxy == assocnetwork->is_body_a_proxy)
      pass ();
    else
      fail ("ASSOCNETWORK.is_body_a_proxy [B] set+1 " FORMAT_B " != " FORMAT_B "", assocnetwork->is_body_a_proxy, is_body_a_proxy);
    assocnetwork->is_body_a_proxy--;

  }
  {
    BITCODE_BL num_actions;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "num_actions", &num_actions, NULL)
        && num_actions == assocnetwork->num_actions)
      pass ();
    else
      fail ("ASSOCNETWORK.num_actions [BL] %u != %u", assocnetwork->num_actions, num_actions);
    num_actions++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "num_actions", &num_actions, 0)
        && num_actions == assocnetwork->num_actions)
      pass ();
    else
      fail ("ASSOCNETWORK.num_actions [BL] set+1 %u != %u", assocnetwork->num_actions, num_actions);
    assocnetwork->num_actions--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "parent", &parent, NULL)
        && !memcmp (&parent, &assocnetwork->parent, sizeof (assocnetwork->parent)))
        pass ();
    else
        fail ("ASSOCNETWORK.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_H readdep;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "readdep", &readdep, NULL)
        && !memcmp (&readdep, &assocnetwork->readdep, sizeof (assocnetwork->readdep)))
        pass ();
    else
        fail ("ASSOCNETWORK.readdep [H]");
  }
  {
    BITCODE_BL solution_status;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "solution_status", &solution_status, NULL)
        && solution_status == assocnetwork->solution_status)
      pass ();
    else
      fail ("ASSOCNETWORK.solution_status [BL] %u != %u", assocnetwork->solution_status, solution_status);
    solution_status++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "solution_status", &solution_status, 0)
        && solution_status == assocnetwork->solution_status)
      pass ();
    else
      fail ("ASSOCNETWORK.solution_status [BL] set+1 %u != %u", assocnetwork->solution_status, solution_status);
    assocnetwork->solution_status--;

  }
  {
    BITCODE_BL unknown_assoc;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "unknown_assoc", &unknown_assoc, NULL)
        && unknown_assoc == assocnetwork->unknown_assoc)
      pass ();
    else
      fail ("ASSOCNETWORK.unknown_assoc [BL] %u != %u", assocnetwork->unknown_assoc, unknown_assoc);
    unknown_assoc++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "unknown_assoc", &unknown_assoc, 0)
        && unknown_assoc == assocnetwork->unknown_assoc)
      pass ();
    else
      fail ("ASSOCNETWORK.unknown_assoc [BL] set+1 %u != %u", assocnetwork->unknown_assoc, unknown_assoc);
    assocnetwork->unknown_assoc--;

  }
  {
    BITCODE_BL unknown_n1;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "unknown_n1", &unknown_n1, NULL)
        && unknown_n1 == assocnetwork->unknown_n1)
      pass ();
    else
      fail ("ASSOCNETWORK.unknown_n1 [BL] %u != %u", assocnetwork->unknown_n1, unknown_n1);
    unknown_n1++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "unknown_n1", &unknown_n1, 0)
        && unknown_n1 == assocnetwork->unknown_n1)
      pass ();
    else
      fail ("ASSOCNETWORK.unknown_n1 [BL] set+1 %u != %u", assocnetwork->unknown_n1, unknown_n1);
    assocnetwork->unknown_n1--;

  }
  {
    BITCODE_BL unknown_n2;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "unknown_n2", &unknown_n2, NULL)
        && unknown_n2 == assocnetwork->unknown_n2)
      pass ();
    else
      fail ("ASSOCNETWORK.unknown_n2 [BL] %u != %u", assocnetwork->unknown_n2, unknown_n2);
    unknown_n2++;
    if (dwg_dynapi_entity_set_value (assocnetwork, "ASSOCNETWORK", "unknown_n2", &unknown_n2, 0)
        && unknown_n2 == assocnetwork->unknown_n2)
      pass ();
    else
      fail ("ASSOCNETWORK.unknown_n2 [BL] set+1 %u != %u", assocnetwork->unknown_n2, unknown_n2);
    assocnetwork->unknown_n2--;

  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assocnetwork, "ASSOCNETWORK", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assocnetwork->writedep, sizeof (assocnetwork->writedep)))
        pass ();
    else
        fail ("ASSOCNETWORK.writedep [H]");
  }
  return failed;
}
static int test_ASSOCOSNAPPOINTREFACTIONPARAM (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCOSNAPPOINTREFACTIONPARAM *restrict assocosnappointrefactionparam = obj->tio.object->tio.ASSOCOSNAPPOINTREFACTIONPARAM;
  {
    BITCODE_H actionparam;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "actionparam", &actionparam, NULL)
        && !memcmp (&actionparam, &assocosnappointrefactionparam->actionparam, sizeof (assocosnappointrefactionparam->actionparam)))
        pass ();
    else
        fail ("ASSOCOSNAPPOINTREFACTIONPARAM.actionparam [H]");
  }
  {
    BITCODE_RS flags;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "flags", &flags, NULL)
        && flags == assocosnappointrefactionparam->flags)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.flags [RS] %hu != %hu", assocosnappointrefactionparam->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "flags", &flags, 0)
        && flags == assocosnappointrefactionparam->flags)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.flags [RS] set+1 %hu != %hu", assocosnappointrefactionparam->flags, flags);
    assocosnappointrefactionparam->flags--;

  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "name", &name, NULL)
        && !memcmp (&name, &assocosnappointrefactionparam->name, sizeof (assocosnappointrefactionparam->name)))
        pass ();
    else
        fail ("ASSOCOSNAPPOINTREFACTIONPARAM.name [T]");
  }
  {
    BITCODE_BS num_params;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "num_params", &num_params, NULL)
        && num_params == assocosnappointrefactionparam->num_params)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.num_params [BS] %hu != %hu", assocosnappointrefactionparam->num_params, num_params);
    num_params++;
    if (dwg_dynapi_entity_set_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "num_params", &num_params, 0)
        && num_params == assocosnappointrefactionparam->num_params)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.num_params [BS] set+1 %hu != %hu", assocosnappointrefactionparam->num_params, num_params);
    assocosnappointrefactionparam->num_params--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "parent", &parent, NULL)
        && !memcmp (&parent, &assocosnappointrefactionparam->parent, sizeof (assocosnappointrefactionparam->parent)))
        pass ();
    else
        fail ("ASSOCOSNAPPOINTREFACTIONPARAM.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_BS status;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "status", &status, NULL)
        && status == assocosnappointrefactionparam->status)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.status [BS] %hu != %hu", assocosnappointrefactionparam->status, status);
    status++;
    if (dwg_dynapi_entity_set_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "status", &status, 0)
        && status == assocosnappointrefactionparam->status)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.status [BS] set+1 %hu != %hu", assocosnappointrefactionparam->status, status);
    assocosnappointrefactionparam->status--;

  }
  {
    BITCODE_RC unknown;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "unknown", &unknown, NULL)
        && unknown == assocosnappointrefactionparam->unknown)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.unknown [RC] %u != %u", assocosnappointrefactionparam->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "unknown", &unknown, 0)
        && unknown == assocosnappointrefactionparam->unknown)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.unknown [RC] set+1 %u != %u", assocosnappointrefactionparam->unknown, unknown);
    assocosnappointrefactionparam->unknown--;

  }
  {
    BITCODE_B unknown1;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "unknown1", &unknown1, NULL)
        && unknown1 == assocosnappointrefactionparam->unknown1)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.unknown1 [B] " FORMAT_B " != " FORMAT_B "", assocosnappointrefactionparam->unknown1, unknown1);
    unknown1++;
    if (dwg_dynapi_entity_set_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "unknown1", &unknown1, 0)
        && unknown1 == assocosnappointrefactionparam->unknown1)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.unknown1 [B] set+1 " FORMAT_B " != " FORMAT_B "", assocosnappointrefactionparam->unknown1, unknown1);
    assocosnappointrefactionparam->unknown1--;

  }
  {
    BITCODE_BD unknown3;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "unknown3", &unknown3, NULL)
        && unknown3 == assocosnappointrefactionparam->unknown3)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.unknown3 [BD] %g != %g", assocosnappointrefactionparam->unknown3, unknown3);
    unknown3++;
    if (dwg_dynapi_entity_set_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "unknown3", &unknown3, 0)
        && unknown3 == assocosnappointrefactionparam->unknown3)
      pass ();
    else
      fail ("ASSOCOSNAPPOINTREFACTIONPARAM.unknown3 [BD] set+1 %g != %g", assocosnappointrefactionparam->unknown3, unknown3);
    assocosnappointrefactionparam->unknown3--;

  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assocosnappointrefactionparam, "ASSOCOSNAPPOINTREFACTIONPARAM", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assocosnappointrefactionparam->writedep, sizeof (assocosnappointrefactionparam->writedep)))
        pass ();
    else
        fail ("ASSOCOSNAPPOINTREFACTIONPARAM.writedep [H]");
  }
  return failed;
}
static int test_ASSOCPERSSUBENTMANAGER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCPERSSUBENTMANAGER *restrict assocperssubentmanager = obj->tio.object->tio.ASSOCPERSSUBENTMANAGER;
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "class_version", &class_version, NULL)
        && class_version == assocperssubentmanager->class_version)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.class_version [BL] %u != %u", assocperssubentmanager->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "class_version", &class_version, 0)
        && class_version == assocperssubentmanager->class_version)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.class_version [BL] set+1 %u != %u", assocperssubentmanager->class_version, class_version);
    assocperssubentmanager->class_version--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "parent", &parent, NULL)
        && !memcmp (&parent, &assocperssubentmanager->parent, sizeof (assocperssubentmanager->parent)))
        pass ();
    else
        fail ("ASSOCPERSSUBENTMANAGER.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_B unknown_b37;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_b37", &unknown_b37, NULL)
        && unknown_b37 == assocperssubentmanager->unknown_b37)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_b37 [B] " FORMAT_B " != " FORMAT_B "", assocperssubentmanager->unknown_b37, unknown_b37);
    unknown_b37++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_b37", &unknown_b37, 0)
        && unknown_b37 == assocperssubentmanager->unknown_b37)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_b37 [B] set+1 " FORMAT_B " != " FORMAT_B "", assocperssubentmanager->unknown_b37, unknown_b37);
    assocperssubentmanager->unknown_b37--;

  }
  {
    BITCODE_BL unknown_bl1;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl1", &unknown_bl1, NULL)
        && unknown_bl1 == assocperssubentmanager->unknown_bl1)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl1 [BL] %u != %u", assocperssubentmanager->unknown_bl1, unknown_bl1);
    unknown_bl1++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl1", &unknown_bl1, 0)
        && unknown_bl1 == assocperssubentmanager->unknown_bl1)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl1 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl1, unknown_bl1);
    assocperssubentmanager->unknown_bl1--;

  }
  {
    BITCODE_BL unknown_bl10;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl10", &unknown_bl10, NULL)
        && unknown_bl10 == assocperssubentmanager->unknown_bl10)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl10 [BL] %u != %u", assocperssubentmanager->unknown_bl10, unknown_bl10);
    unknown_bl10++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl10", &unknown_bl10, 0)
        && unknown_bl10 == assocperssubentmanager->unknown_bl10)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl10 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl10, unknown_bl10);
    assocperssubentmanager->unknown_bl10--;

  }
  {
    BITCODE_BL unknown_bl11;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl11", &unknown_bl11, NULL)
        && unknown_bl11 == assocperssubentmanager->unknown_bl11)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl11 [BL] %u != %u", assocperssubentmanager->unknown_bl11, unknown_bl11);
    unknown_bl11++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl11", &unknown_bl11, 0)
        && unknown_bl11 == assocperssubentmanager->unknown_bl11)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl11 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl11, unknown_bl11);
    assocperssubentmanager->unknown_bl11--;

  }
  {
    BITCODE_BL unknown_bl12;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl12", &unknown_bl12, NULL)
        && unknown_bl12 == assocperssubentmanager->unknown_bl12)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl12 [BL] %u != %u", assocperssubentmanager->unknown_bl12, unknown_bl12);
    unknown_bl12++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl12", &unknown_bl12, 0)
        && unknown_bl12 == assocperssubentmanager->unknown_bl12)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl12 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl12, unknown_bl12);
    assocperssubentmanager->unknown_bl12--;

  }
  {
    BITCODE_BL unknown_bl13;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl13", &unknown_bl13, NULL)
        && unknown_bl13 == assocperssubentmanager->unknown_bl13)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl13 [BL] %u != %u", assocperssubentmanager->unknown_bl13, unknown_bl13);
    unknown_bl13++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl13", &unknown_bl13, 0)
        && unknown_bl13 == assocperssubentmanager->unknown_bl13)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl13 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl13, unknown_bl13);
    assocperssubentmanager->unknown_bl13--;

  }
  {
    BITCODE_BL unknown_bl14;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl14", &unknown_bl14, NULL)
        && unknown_bl14 == assocperssubentmanager->unknown_bl14)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl14 [BL] %u != %u", assocperssubentmanager->unknown_bl14, unknown_bl14);
    unknown_bl14++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl14", &unknown_bl14, 0)
        && unknown_bl14 == assocperssubentmanager->unknown_bl14)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl14 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl14, unknown_bl14);
    assocperssubentmanager->unknown_bl14--;

  }
  {
    BITCODE_BL unknown_bl15;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl15", &unknown_bl15, NULL)
        && unknown_bl15 == assocperssubentmanager->unknown_bl15)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl15 [BL] %u != %u", assocperssubentmanager->unknown_bl15, unknown_bl15);
    unknown_bl15++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl15", &unknown_bl15, 0)
        && unknown_bl15 == assocperssubentmanager->unknown_bl15)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl15 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl15, unknown_bl15);
    assocperssubentmanager->unknown_bl15--;

  }
  {
    BITCODE_BL unknown_bl16;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl16", &unknown_bl16, NULL)
        && unknown_bl16 == assocperssubentmanager->unknown_bl16)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl16 [BL] %u != %u", assocperssubentmanager->unknown_bl16, unknown_bl16);
    unknown_bl16++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl16", &unknown_bl16, 0)
        && unknown_bl16 == assocperssubentmanager->unknown_bl16)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl16 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl16, unknown_bl16);
    assocperssubentmanager->unknown_bl16--;

  }
  {
    BITCODE_BL unknown_bl17;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl17", &unknown_bl17, NULL)
        && unknown_bl17 == assocperssubentmanager->unknown_bl17)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl17 [BL] %u != %u", assocperssubentmanager->unknown_bl17, unknown_bl17);
    unknown_bl17++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl17", &unknown_bl17, 0)
        && unknown_bl17 == assocperssubentmanager->unknown_bl17)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl17 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl17, unknown_bl17);
    assocperssubentmanager->unknown_bl17--;

  }
  {
    BITCODE_BL unknown_bl18;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl18", &unknown_bl18, NULL)
        && unknown_bl18 == assocperssubentmanager->unknown_bl18)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl18 [BL] %u != %u", assocperssubentmanager->unknown_bl18, unknown_bl18);
    unknown_bl18++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl18", &unknown_bl18, 0)
        && unknown_bl18 == assocperssubentmanager->unknown_bl18)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl18 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl18, unknown_bl18);
    assocperssubentmanager->unknown_bl18--;

  }
  {
    BITCODE_BL unknown_bl19;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl19", &unknown_bl19, NULL)
        && unknown_bl19 == assocperssubentmanager->unknown_bl19)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl19 [BL] %u != %u", assocperssubentmanager->unknown_bl19, unknown_bl19);
    unknown_bl19++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl19", &unknown_bl19, 0)
        && unknown_bl19 == assocperssubentmanager->unknown_bl19)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl19 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl19, unknown_bl19);
    assocperssubentmanager->unknown_bl19--;

  }
  {
    BITCODE_BL unknown_bl2;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl2", &unknown_bl2, NULL)
        && unknown_bl2 == assocperssubentmanager->unknown_bl2)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl2 [BL] %u != %u", assocperssubentmanager->unknown_bl2, unknown_bl2);
    unknown_bl2++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl2", &unknown_bl2, 0)
        && unknown_bl2 == assocperssubentmanager->unknown_bl2)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl2 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl2, unknown_bl2);
    assocperssubentmanager->unknown_bl2--;

  }
  {
    BITCODE_BL unknown_bl20;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl20", &unknown_bl20, NULL)
        && unknown_bl20 == assocperssubentmanager->unknown_bl20)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl20 [BL] %u != %u", assocperssubentmanager->unknown_bl20, unknown_bl20);
    unknown_bl20++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl20", &unknown_bl20, 0)
        && unknown_bl20 == assocperssubentmanager->unknown_bl20)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl20 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl20, unknown_bl20);
    assocperssubentmanager->unknown_bl20--;

  }
  {
    BITCODE_BL unknown_bl21;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl21", &unknown_bl21, NULL)
        && unknown_bl21 == assocperssubentmanager->unknown_bl21)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl21 [BL] %u != %u", assocperssubentmanager->unknown_bl21, unknown_bl21);
    unknown_bl21++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl21", &unknown_bl21, 0)
        && unknown_bl21 == assocperssubentmanager->unknown_bl21)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl21 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl21, unknown_bl21);
    assocperssubentmanager->unknown_bl21--;

  }
  {
    BITCODE_BL unknown_bl22;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl22", &unknown_bl22, NULL)
        && unknown_bl22 == assocperssubentmanager->unknown_bl22)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl22 [BL] %u != %u", assocperssubentmanager->unknown_bl22, unknown_bl22);
    unknown_bl22++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl22", &unknown_bl22, 0)
        && unknown_bl22 == assocperssubentmanager->unknown_bl22)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl22 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl22, unknown_bl22);
    assocperssubentmanager->unknown_bl22--;

  }
  {
    BITCODE_BL unknown_bl23;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl23", &unknown_bl23, NULL)
        && unknown_bl23 == assocperssubentmanager->unknown_bl23)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl23 [BL] %u != %u", assocperssubentmanager->unknown_bl23, unknown_bl23);
    unknown_bl23++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl23", &unknown_bl23, 0)
        && unknown_bl23 == assocperssubentmanager->unknown_bl23)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl23 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl23, unknown_bl23);
    assocperssubentmanager->unknown_bl23--;

  }
  {
    BITCODE_BL unknown_bl24;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl24", &unknown_bl24, NULL)
        && unknown_bl24 == assocperssubentmanager->unknown_bl24)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl24 [BL] %u != %u", assocperssubentmanager->unknown_bl24, unknown_bl24);
    unknown_bl24++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl24", &unknown_bl24, 0)
        && unknown_bl24 == assocperssubentmanager->unknown_bl24)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl24 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl24, unknown_bl24);
    assocperssubentmanager->unknown_bl24--;

  }
  {
    BITCODE_BL unknown_bl25;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl25", &unknown_bl25, NULL)
        && unknown_bl25 == assocperssubentmanager->unknown_bl25)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl25 [BL] %u != %u", assocperssubentmanager->unknown_bl25, unknown_bl25);
    unknown_bl25++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl25", &unknown_bl25, 0)
        && unknown_bl25 == assocperssubentmanager->unknown_bl25)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl25 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl25, unknown_bl25);
    assocperssubentmanager->unknown_bl25--;

  }
  {
    BITCODE_BL unknown_bl26;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl26", &unknown_bl26, NULL)
        && unknown_bl26 == assocperssubentmanager->unknown_bl26)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl26 [BL] %u != %u", assocperssubentmanager->unknown_bl26, unknown_bl26);
    unknown_bl26++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl26", &unknown_bl26, 0)
        && unknown_bl26 == assocperssubentmanager->unknown_bl26)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl26 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl26, unknown_bl26);
    assocperssubentmanager->unknown_bl26--;

  }
  {
    BITCODE_BL unknown_bl27;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl27", &unknown_bl27, NULL)
        && unknown_bl27 == assocperssubentmanager->unknown_bl27)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl27 [BL] %u != %u", assocperssubentmanager->unknown_bl27, unknown_bl27);
    unknown_bl27++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl27", &unknown_bl27, 0)
        && unknown_bl27 == assocperssubentmanager->unknown_bl27)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl27 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl27, unknown_bl27);
    assocperssubentmanager->unknown_bl27--;

  }
  {
    BITCODE_BL unknown_bl28;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl28", &unknown_bl28, NULL)
        && unknown_bl28 == assocperssubentmanager->unknown_bl28)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl28 [BL] %u != %u", assocperssubentmanager->unknown_bl28, unknown_bl28);
    unknown_bl28++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl28", &unknown_bl28, 0)
        && unknown_bl28 == assocperssubentmanager->unknown_bl28)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl28 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl28, unknown_bl28);
    assocperssubentmanager->unknown_bl28--;

  }
  {
    BITCODE_BL unknown_bl29;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl29", &unknown_bl29, NULL)
        && unknown_bl29 == assocperssubentmanager->unknown_bl29)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl29 [BL] %u != %u", assocperssubentmanager->unknown_bl29, unknown_bl29);
    unknown_bl29++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl29", &unknown_bl29, 0)
        && unknown_bl29 == assocperssubentmanager->unknown_bl29)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl29 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl29, unknown_bl29);
    assocperssubentmanager->unknown_bl29--;

  }
  {
    BITCODE_BL unknown_bl3;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl3", &unknown_bl3, NULL)
        && unknown_bl3 == assocperssubentmanager->unknown_bl3)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl3 [BL] %u != %u", assocperssubentmanager->unknown_bl3, unknown_bl3);
    unknown_bl3++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl3", &unknown_bl3, 0)
        && unknown_bl3 == assocperssubentmanager->unknown_bl3)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl3 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl3, unknown_bl3);
    assocperssubentmanager->unknown_bl3--;

  }
  {
    BITCODE_BL unknown_bl30;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl30", &unknown_bl30, NULL)
        && unknown_bl30 == assocperssubentmanager->unknown_bl30)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl30 [BL] %u != %u", assocperssubentmanager->unknown_bl30, unknown_bl30);
    unknown_bl30++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl30", &unknown_bl30, 0)
        && unknown_bl30 == assocperssubentmanager->unknown_bl30)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl30 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl30, unknown_bl30);
    assocperssubentmanager->unknown_bl30--;

  }
  {
    BITCODE_BL unknown_bl31;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl31", &unknown_bl31, NULL)
        && unknown_bl31 == assocperssubentmanager->unknown_bl31)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl31 [BL] %u != %u", assocperssubentmanager->unknown_bl31, unknown_bl31);
    unknown_bl31++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl31", &unknown_bl31, 0)
        && unknown_bl31 == assocperssubentmanager->unknown_bl31)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl31 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl31, unknown_bl31);
    assocperssubentmanager->unknown_bl31--;

  }
  {
    BITCODE_BL unknown_bl32;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl32", &unknown_bl32, NULL)
        && unknown_bl32 == assocperssubentmanager->unknown_bl32)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl32 [BL] %u != %u", assocperssubentmanager->unknown_bl32, unknown_bl32);
    unknown_bl32++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl32", &unknown_bl32, 0)
        && unknown_bl32 == assocperssubentmanager->unknown_bl32)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl32 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl32, unknown_bl32);
    assocperssubentmanager->unknown_bl32--;

  }
  {
    BITCODE_BL unknown_bl33;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl33", &unknown_bl33, NULL)
        && unknown_bl33 == assocperssubentmanager->unknown_bl33)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl33 [BL] %u != %u", assocperssubentmanager->unknown_bl33, unknown_bl33);
    unknown_bl33++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl33", &unknown_bl33, 0)
        && unknown_bl33 == assocperssubentmanager->unknown_bl33)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl33 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl33, unknown_bl33);
    assocperssubentmanager->unknown_bl33--;

  }
  {
    BITCODE_BL unknown_bl34;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl34", &unknown_bl34, NULL)
        && unknown_bl34 == assocperssubentmanager->unknown_bl34)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl34 [BL] %u != %u", assocperssubentmanager->unknown_bl34, unknown_bl34);
    unknown_bl34++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl34", &unknown_bl34, 0)
        && unknown_bl34 == assocperssubentmanager->unknown_bl34)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl34 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl34, unknown_bl34);
    assocperssubentmanager->unknown_bl34--;

  }
  {
    BITCODE_BL unknown_bl35;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl35", &unknown_bl35, NULL)
        && unknown_bl35 == assocperssubentmanager->unknown_bl35)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl35 [BL] %u != %u", assocperssubentmanager->unknown_bl35, unknown_bl35);
    unknown_bl35++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl35", &unknown_bl35, 0)
        && unknown_bl35 == assocperssubentmanager->unknown_bl35)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl35 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl35, unknown_bl35);
    assocperssubentmanager->unknown_bl35--;

  }
  {
    BITCODE_BL unknown_bl36;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl36", &unknown_bl36, NULL)
        && unknown_bl36 == assocperssubentmanager->unknown_bl36)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl36 [BL] %u != %u", assocperssubentmanager->unknown_bl36, unknown_bl36);
    unknown_bl36++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl36", &unknown_bl36, 0)
        && unknown_bl36 == assocperssubentmanager->unknown_bl36)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl36 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl36, unknown_bl36);
    assocperssubentmanager->unknown_bl36--;

  }
  {
    BITCODE_BL unknown_bl4;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl4", &unknown_bl4, NULL)
        && unknown_bl4 == assocperssubentmanager->unknown_bl4)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl4 [BL] %u != %u", assocperssubentmanager->unknown_bl4, unknown_bl4);
    unknown_bl4++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl4", &unknown_bl4, 0)
        && unknown_bl4 == assocperssubentmanager->unknown_bl4)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl4 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl4, unknown_bl4);
    assocperssubentmanager->unknown_bl4--;

  }
  {
    BITCODE_BL unknown_bl5;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl5", &unknown_bl5, NULL)
        && unknown_bl5 == assocperssubentmanager->unknown_bl5)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl5 [BL] %u != %u", assocperssubentmanager->unknown_bl5, unknown_bl5);
    unknown_bl5++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl5", &unknown_bl5, 0)
        && unknown_bl5 == assocperssubentmanager->unknown_bl5)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl5 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl5, unknown_bl5);
    assocperssubentmanager->unknown_bl5--;

  }
  {
    BITCODE_BL unknown_bl6;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl6", &unknown_bl6, NULL)
        && unknown_bl6 == assocperssubentmanager->unknown_bl6)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl6 [BL] %u != %u", assocperssubentmanager->unknown_bl6, unknown_bl6);
    unknown_bl6++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl6", &unknown_bl6, 0)
        && unknown_bl6 == assocperssubentmanager->unknown_bl6)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl6 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl6, unknown_bl6);
    assocperssubentmanager->unknown_bl6--;

  }
  {
    BITCODE_BL unknown_bl6a;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl6a", &unknown_bl6a, NULL)
        && unknown_bl6a == assocperssubentmanager->unknown_bl6a)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl6a [BL] %u != %u", assocperssubentmanager->unknown_bl6a, unknown_bl6a);
    unknown_bl6a++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl6a", &unknown_bl6a, 0)
        && unknown_bl6a == assocperssubentmanager->unknown_bl6a)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl6a [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl6a, unknown_bl6a);
    assocperssubentmanager->unknown_bl6a--;

  }
  {
    BITCODE_BL unknown_bl7;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl7", &unknown_bl7, NULL)
        && unknown_bl7 == assocperssubentmanager->unknown_bl7)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl7 [BL] %u != %u", assocperssubentmanager->unknown_bl7, unknown_bl7);
    unknown_bl7++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl7", &unknown_bl7, 0)
        && unknown_bl7 == assocperssubentmanager->unknown_bl7)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl7 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl7, unknown_bl7);
    assocperssubentmanager->unknown_bl7--;

  }
  {
    BITCODE_BL unknown_bl7a;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl7a", &unknown_bl7a, NULL)
        && unknown_bl7a == assocperssubentmanager->unknown_bl7a)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl7a [BL] %u != %u", assocperssubentmanager->unknown_bl7a, unknown_bl7a);
    unknown_bl7a++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl7a", &unknown_bl7a, 0)
        && unknown_bl7a == assocperssubentmanager->unknown_bl7a)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl7a [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl7a, unknown_bl7a);
    assocperssubentmanager->unknown_bl7a--;

  }
  {
    BITCODE_BL unknown_bl8;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl8", &unknown_bl8, NULL)
        && unknown_bl8 == assocperssubentmanager->unknown_bl8)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl8 [BL] %u != %u", assocperssubentmanager->unknown_bl8, unknown_bl8);
    unknown_bl8++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl8", &unknown_bl8, 0)
        && unknown_bl8 == assocperssubentmanager->unknown_bl8)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl8 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl8, unknown_bl8);
    assocperssubentmanager->unknown_bl8--;

  }
  {
    BITCODE_BL unknown_bl9;
    if (dwg_dynapi_entity_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl9", &unknown_bl9, NULL)
        && unknown_bl9 == assocperssubentmanager->unknown_bl9)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl9 [BL] %u != %u", assocperssubentmanager->unknown_bl9, unknown_bl9);
    unknown_bl9++;
    if (dwg_dynapi_entity_set_value (assocperssubentmanager, "ASSOCPERSSUBENTMANAGER", "unknown_bl9", &unknown_bl9, 0)
        && unknown_bl9 == assocperssubentmanager->unknown_bl9)
      pass ();
    else
      fail ("ASSOCPERSSUBENTMANAGER.unknown_bl9 [BL] set+1 %u != %u", assocperssubentmanager->unknown_bl9, unknown_bl9);
    assocperssubentmanager->unknown_bl9--;

  }
  return failed;
}
static int test_ASSOCPLANESURFACEACTIONBODY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ASSOCPLANESURFACEACTIONBODY *restrict assocplanesurfaceactionbody = obj->tio.object->tio.ASSOCPLANESURFACEACTIONBODY;
  {
    BITCODE_BL aab_status;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "aab_status", &aab_status, NULL)
        && aab_status == assocplanesurfaceactionbody->aab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.aab_status [BL] %u != %u", assocplanesurfaceactionbody->aab_status, aab_status);
    aab_status++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "aab_status", &aab_status, 0)
        && aab_status == assocplanesurfaceactionbody->aab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.aab_status [BL] set+1 %u != %u", assocplanesurfaceactionbody->aab_status, aab_status);
    assocplanesurfaceactionbody->aab_status--;

  }
  {
    BITCODE_BL pab_l2;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l2", &pab_l2, NULL)
        && pab_l2 == assocplanesurfaceactionbody->pab_l2)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l2 [BL] %u != %u", assocplanesurfaceactionbody->pab_l2, pab_l2);
    pab_l2++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l2", &pab_l2, 0)
        && pab_l2 == assocplanesurfaceactionbody->pab_l2)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l2 [BL] set+1 %u != %u", assocplanesurfaceactionbody->pab_l2, pab_l2);
    assocplanesurfaceactionbody->pab_l2--;

  }
  {
    BITCODE_BL pab_l3;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l3", &pab_l3, NULL)
        && pab_l3 == assocplanesurfaceactionbody->pab_l3)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l3 [BL] %u != %u", assocplanesurfaceactionbody->pab_l3, pab_l3);
    pab_l3++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l3", &pab_l3, 0)
        && pab_l3 == assocplanesurfaceactionbody->pab_l3)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l3 [BL] set+1 %u != %u", assocplanesurfaceactionbody->pab_l3, pab_l3);
    assocplanesurfaceactionbody->pab_l3--;

  }
  {
    BITCODE_BL pab_l4;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l4", &pab_l4, NULL)
        && pab_l4 == assocplanesurfaceactionbody->pab_l4)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l4 [BL] %u != %u", assocplanesurfaceactionbody->pab_l4, pab_l4);
    pab_l4++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l4", &pab_l4, 0)
        && pab_l4 == assocplanesurfaceactionbody->pab_l4)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l4 [BL] set+1 %u != %u", assocplanesurfaceactionbody->pab_l4, pab_l4);
    assocplanesurfaceactionbody->pab_l4--;

  }
  {
    BITCODE_BL pab_l5;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l5", &pab_l5, NULL)
        && pab_l5 == assocplanesurfaceactionbody->pab_l5)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l5 [BL] %u != %u", assocplanesurfaceactionbody->pab_l5, pab_l5);
    pab_l5++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_l5", &pab_l5, 0)
        && pab_l5 == assocplanesurfaceactionbody->pab_l5)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_l5 [BL] set+1 %u != %u", assocplanesurfaceactionbody->pab_l5, pab_l5);
    assocplanesurfaceactionbody->pab_l5--;

  }
  {
    BITCODE_BL pab_status;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_status", &pab_status, NULL)
        && pab_status == assocplanesurfaceactionbody->pab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_status [BL] %u != %u", assocplanesurfaceactionbody->pab_status, pab_status);
    pab_status++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pab_status", &pab_status, 0)
        && pab_status == assocplanesurfaceactionbody->pab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pab_status [BL] set+1 %u != %u", assocplanesurfaceactionbody->pab_status, pab_status);
    assocplanesurfaceactionbody->pab_status--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "parent", &parent, NULL)
        && !memcmp (&parent, &assocplanesurfaceactionbody->parent, sizeof (assocplanesurfaceactionbody->parent)))
        pass ();
    else
        fail ("ASSOCPLANESURFACEACTIONBODY.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_BL pbsab_status;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pbsab_status", &pbsab_status, NULL)
        && pbsab_status == assocplanesurfaceactionbody->pbsab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pbsab_status [BL] %u != %u", assocplanesurfaceactionbody->pbsab_status, pbsab_status);
    pbsab_status++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "pbsab_status", &pbsab_status, 0)
        && pbsab_status == assocplanesurfaceactionbody->pbsab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.pbsab_status [BL] set+1 %u != %u", assocplanesurfaceactionbody->pbsab_status, pbsab_status);
    assocplanesurfaceactionbody->pbsab_status--;

  }
  {
    BITCODE_BL psab_status;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "psab_status", &psab_status, NULL)
        && psab_status == assocplanesurfaceactionbody->psab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.psab_status [BL] %u != %u", assocplanesurfaceactionbody->psab_status, psab_status);
    psab_status++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "psab_status", &psab_status, 0)
        && psab_status == assocplanesurfaceactionbody->psab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.psab_status [BL] set+1 %u != %u", assocplanesurfaceactionbody->psab_status, psab_status);
    assocplanesurfaceactionbody->psab_status--;

  }
  {
    BITCODE_H readdep;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "readdep", &readdep, NULL)
        && !memcmp (&readdep, &assocplanesurfaceactionbody->readdep, sizeof (assocplanesurfaceactionbody->readdep)))
        pass ();
    else
        fail ("ASSOCPLANESURFACEACTIONBODY.readdep [H]");
  }
  {
    BITCODE_B sab_b1;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_b1", &sab_b1, NULL)
        && sab_b1 == assocplanesurfaceactionbody->sab_b1)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_b1 [B] " FORMAT_B " != " FORMAT_B "", assocplanesurfaceactionbody->sab_b1, sab_b1);
    sab_b1++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_b1", &sab_b1, 0)
        && sab_b1 == assocplanesurfaceactionbody->sab_b1)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_b1 [B] set+1 " FORMAT_B " != " FORMAT_B "", assocplanesurfaceactionbody->sab_b1, sab_b1);
    assocplanesurfaceactionbody->sab_b1--;

  }
  {
    BITCODE_B sab_b2;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_b2", &sab_b2, NULL)
        && sab_b2 == assocplanesurfaceactionbody->sab_b2)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_b2 [B] " FORMAT_B " != " FORMAT_B "", assocplanesurfaceactionbody->sab_b2, sab_b2);
    sab_b2++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_b2", &sab_b2, 0)
        && sab_b2 == assocplanesurfaceactionbody->sab_b2)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_b2 [B] set+1 " FORMAT_B " != " FORMAT_B "", assocplanesurfaceactionbody->sab_b2, sab_b2);
    assocplanesurfaceactionbody->sab_b2--;

  }
  {
    BITCODE_BL sab_l2;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_l2", &sab_l2, NULL)
        && sab_l2 == assocplanesurfaceactionbody->sab_l2)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_l2 [BL] %u != %u", assocplanesurfaceactionbody->sab_l2, sab_l2);
    sab_l2++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_l2", &sab_l2, 0)
        && sab_l2 == assocplanesurfaceactionbody->sab_l2)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_l2 [BL] set+1 %u != %u", assocplanesurfaceactionbody->sab_l2, sab_l2);
    assocplanesurfaceactionbody->sab_l2--;

  }
  {
    BITCODE_BS sab_s1;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_s1", &sab_s1, NULL)
        && sab_s1 == assocplanesurfaceactionbody->sab_s1)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_s1 [BS] %hu != %hu", assocplanesurfaceactionbody->sab_s1, sab_s1);
    sab_s1++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_s1", &sab_s1, 0)
        && sab_s1 == assocplanesurfaceactionbody->sab_s1)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_s1 [BS] set+1 %hu != %hu", assocplanesurfaceactionbody->sab_s1, sab_s1);
    assocplanesurfaceactionbody->sab_s1--;

  }
  {
    BITCODE_BL sab_status;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_status", &sab_status, NULL)
        && sab_status == assocplanesurfaceactionbody->sab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_status [BL] %u != %u", assocplanesurfaceactionbody->sab_status, sab_status);
    sab_status++;
    if (dwg_dynapi_entity_set_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "sab_status", &sab_status, 0)
        && sab_status == assocplanesurfaceactionbody->sab_status)
      pass ();
    else
      fail ("ASSOCPLANESURFACEACTIONBODY.sab_status [BL] set+1 %u != %u", assocplanesurfaceactionbody->sab_status, sab_status);
    assocplanesurfaceactionbody->sab_status--;

  }
  {
    BITCODE_H writedep;
    if (dwg_dynapi_entity_value (assocplanesurfaceactionbody, "ASSOCPLANESURFACEACTIONBODY", "writedep", &writedep, NULL)
        && !memcmp (&writedep, &assocplanesurfaceactionbody->writedep, sizeof (assocplanesurfaceactionbody->writedep)))
        pass ();
    else
        fail ("ASSOCPLANESURFACEACTIONBODY.writedep [H]");
  }
  return failed;
}
static int test_BLOCK_CONTROL (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_BLOCK_CONTROL *restrict block_control = obj->tio.object->tio.BLOCK_CONTROL;
  {
    BITCODE_H* entries;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "num_entries", &count, NULL)
        && dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "entries", &entries, NULL)
        && entries == block_control->entries)
      pass ();
    else
      fail ("BLOCK_CONTROL.entries [H*] * %u num_entries", count);
  }
  {
    BITCODE_H model_space;
    if (dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "model_space", &model_space, NULL)
        && !memcmp (&model_space, &block_control->model_space, sizeof (block_control->model_space)))
        pass ();
    else
        fail ("BLOCK_CONTROL.model_space [H]");
  }
  {
    BITCODE_BS num_entries;
    if (dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "num_entries", &num_entries, NULL)
        && num_entries == block_control->num_entries)
      pass ();
    else
      fail ("BLOCK_CONTROL.num_entries [BS] %hu != %hu", block_control->num_entries, num_entries);
    num_entries++;
    if (dwg_dynapi_entity_set_value (block_control, "BLOCK_CONTROL", "num_entries", &num_entries, 0)
        && num_entries == block_control->num_entries)
      pass ();
    else
      fail ("BLOCK_CONTROL.num_entries [BS] set+1 %hu != %hu", block_control->num_entries, num_entries);
    block_control->num_entries--;

  }
  {
    BITCODE_BL objid;
    if (dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "objid", &objid, NULL)
        && objid == block_control->objid)
      pass ();
    else
      fail ("BLOCK_CONTROL.objid [BL] %u != %u", block_control->objid, objid);
    objid++;
    if (dwg_dynapi_entity_set_value (block_control, "BLOCK_CONTROL", "objid", &objid, 0)
        && objid == block_control->objid)
      pass ();
    else
      fail ("BLOCK_CONTROL.objid [BL] set+1 %u != %u", block_control->objid, objid);
    block_control->objid--;

  }
  {
    BITCODE_H paper_space;
    if (dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "paper_space", &paper_space, NULL)
        && !memcmp (&paper_space, &block_control->paper_space, sizeof (block_control->paper_space)))
        pass ();
    else
        fail ("BLOCK_CONTROL.paper_space [H]");
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (block_control, "BLOCK_CONTROL", "parent", &parent, NULL)
        && !memcmp (&parent, &block_control->parent, sizeof (block_control->parent)))
        pass ();
    else
        fail ("BLOCK_CONTROL.parent [struct _dwg_object_object*]");
  }
  return failed;
}
static int test_BLOCK_HEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_BLOCK_HEADER *restrict block_header = obj->tio.object->tio.BLOCK_HEADER;
  {
    BITCODE_BL __iterator;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "__iterator", &__iterator, NULL)
        && __iterator == block_header->__iterator)
      pass ();
    else
      fail ("BLOCK_HEADER.__iterator [BL] %u != %u", block_header->__iterator, __iterator);
    __iterator++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "__iterator", &__iterator, 0)
        && __iterator == block_header->__iterator)
      pass ();
    else
      fail ("BLOCK_HEADER.__iterator [BL] set+1 %u != %u", block_header->__iterator, __iterator);
    block_header->__iterator--;

  }
  {
    BITCODE_B anonymous;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "anonymous", &anonymous, NULL)
        && anonymous == block_header->anonymous)
      pass ();
    else
      fail ("BLOCK_HEADER.anonymous [B] " FORMAT_B " != " FORMAT_B "", block_header->anonymous, anonymous);
    anonymous++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "anonymous", &anonymous, 0)
        && anonymous == block_header->anonymous)
      pass ();
    else
      fail ("BLOCK_HEADER.anonymous [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->anonymous, anonymous);
    block_header->anonymous--;

  }
  {
    BITCODE_3DPOINT base_pt;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "base_pt", &base_pt, NULL)
        && !memcmp (&base_pt, &block_header->base_pt, sizeof (block_header->base_pt)))
        pass ();
    else
        fail ("BLOCK_HEADER.base_pt [3DPOINT]");
  }
  {
    BITCODE_B blkisxref;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "blkisxref", &blkisxref, NULL)
        && blkisxref == block_header->blkisxref)
      pass ();
    else
      fail ("BLOCK_HEADER.blkisxref [B] " FORMAT_B " != " FORMAT_B "", block_header->blkisxref, blkisxref);
    blkisxref++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "blkisxref", &blkisxref, 0)
        && blkisxref == block_header->blkisxref)
      pass ();
    else
      fail ("BLOCK_HEADER.blkisxref [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->blkisxref, blkisxref);
    block_header->blkisxref--;

  }
  {
    BITCODE_H block_entity;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "block_entity", &block_entity, NULL)
        && !memcmp (&block_entity, &block_header->block_entity, sizeof (block_header->block_entity)))
        pass ();
    else
        fail ("BLOCK_HEADER.block_entity [H]");
  }
  {
    BITCODE_RC block_scaling;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "block_scaling", &block_scaling, NULL)
        && block_scaling == block_header->block_scaling)
      pass ();
    else
      fail ("BLOCK_HEADER.block_scaling [RC] %u != %u", block_header->block_scaling, block_scaling);
    block_scaling++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "block_scaling", &block_scaling, 0)
        && block_scaling == block_header->block_scaling)
      pass ();
    else
      fail ("BLOCK_HEADER.block_scaling [RC] set+1 %u != %u", block_header->block_scaling, block_scaling);
    block_header->block_scaling--;

  }
  {
    BITCODE_TV description;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "description", &description, NULL)
        && description
           ? strEQ ((char *)description, (char *)block_header->description)
           : !block_header->description)
      pass ();
    else
      fail ("BLOCK_HEADER.description [TV] '%s' <> '%s'", description, block_header->description);
  }
  {
    BITCODE_H endblk_entity;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "endblk_entity", &endblk_entity, NULL)
        && !memcmp (&endblk_entity, &block_header->endblk_entity, sizeof (block_header->endblk_entity)))
        pass ();
    else
        fail ("BLOCK_HEADER.endblk_entity [H]");
  }
  {
    BITCODE_H* entities;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "entities", &entities, NULL)
        && entities == block_header->entities)
      pass ();
    else
      fail ("BLOCK_HEADER.entities [H*] * %u num_owned", count);
  }
  {
    BITCODE_B explodable;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "explodable", &explodable, NULL)
        && explodable == block_header->explodable)
      pass ();
    else
      fail ("BLOCK_HEADER.explodable [B] " FORMAT_B " != " FORMAT_B "", block_header->explodable, explodable);
    explodable++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "explodable", &explodable, 0)
        && explodable == block_header->explodable)
      pass ();
    else
      fail ("BLOCK_HEADER.explodable [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->explodable, explodable);
    block_header->explodable--;

  }
  {
    BITCODE_H first_entity;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "first_entity", &first_entity, NULL)
        && !memcmp (&first_entity, &block_header->first_entity, sizeof (block_header->first_entity)))
        pass ();
    else
        fail ("BLOCK_HEADER.first_entity [H]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "flag", &flag, NULL)
        && flag == block_header->flag)
      pass ();
    else
      fail ("BLOCK_HEADER.flag [RC] %u != %u", block_header->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "flag", &flag, 0)
        && flag == block_header->flag)
      pass ();
    else
      fail ("BLOCK_HEADER.flag [RC] set+1 %u != %u", block_header->flag, flag);
    block_header->flag--;

  }
  {
    BITCODE_RC flag2;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "flag2", &flag2, NULL)
        && flag2 == block_header->flag2)
      pass ();
    else
      fail ("BLOCK_HEADER.flag2 [RC] %u != %u", block_header->flag2, flag2);
    flag2++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "flag2", &flag2, 0)
        && flag2 == block_header->flag2)
      pass ();
    else
      fail ("BLOCK_HEADER.flag2 [RC] set+1 %u != %u", block_header->flag2, flag2);
    block_header->flag2--;

  }
  {
    BITCODE_RS flag3;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "flag3", &flag3, NULL)
        && flag3 == block_header->flag3)
      pass ();
    else
      fail ("BLOCK_HEADER.flag3 [RS] %hu != %hu", block_header->flag3, flag3);
    flag3++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "flag3", &flag3, 0)
        && flag3 == block_header->flag3)
      pass ();
    else
      fail ("BLOCK_HEADER.flag3 [RS] set+1 %hu != %hu", block_header->flag3, flag3);
    block_header->flag3--;

  }
  {
    BITCODE_B hasattrs;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "hasattrs", &hasattrs, NULL)
        && hasattrs == block_header->hasattrs)
      pass ();
    else
      fail ("BLOCK_HEADER.hasattrs [B] " FORMAT_B " != " FORMAT_B "", block_header->hasattrs, hasattrs);
    hasattrs++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "hasattrs", &hasattrs, 0)
        && hasattrs == block_header->hasattrs)
      pass ();
    else
      fail ("BLOCK_HEADER.hasattrs [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->hasattrs, hasattrs);
    block_header->hasattrs--;

  }
  {
    BITCODE_BS insert_units;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "insert_units", &insert_units, NULL)
        && insert_units == block_header->insert_units)
      pass ();
    else
      fail ("BLOCK_HEADER.insert_units [BS] %hu != %hu", block_header->insert_units, insert_units);
    insert_units++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "insert_units", &insert_units, 0)
        && insert_units == block_header->insert_units)
      pass ();
    else
      fail ("BLOCK_HEADER.insert_units [BS] set+1 %hu != %hu", block_header->insert_units, insert_units);
    block_header->insert_units--;

  }
  {
    BITCODE_H* inserts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "num_inserts", &count, NULL)
        && dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "inserts", &inserts, NULL)
        && inserts == block_header->inserts)
      pass ();
    else
      fail ("BLOCK_HEADER.inserts [H*] * %u num_inserts", count);
  }
  {
    BITCODE_H last_entity;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "last_entity", &last_entity, NULL)
        && !memcmp (&last_entity, &block_header->last_entity, sizeof (block_header->last_entity)))
        pass ();
    else
        fail ("BLOCK_HEADER.last_entity [H]");
  }
  {
    BITCODE_H layout;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "layout", &layout, NULL)
        && !memcmp (&layout, &block_header->layout, sizeof (block_header->layout)))
        pass ();
    else
        fail ("BLOCK_HEADER.layout [H]");
  }
  {
    BITCODE_B loaded_bit;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "loaded_bit", &loaded_bit, NULL)
        && loaded_bit == block_header->loaded_bit)
      pass ();
    else
      fail ("BLOCK_HEADER.loaded_bit [B] " FORMAT_B " != " FORMAT_B "", block_header->loaded_bit, loaded_bit);
    loaded_bit++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "loaded_bit", &loaded_bit, 0)
        && loaded_bit == block_header->loaded_bit)
      pass ();
    else
      fail ("BLOCK_HEADER.loaded_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->loaded_bit, loaded_bit);
    block_header->loaded_bit--;

  }
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)block_header->name)
           : !block_header->name)
      pass ();
    else
      fail ("BLOCK_HEADER.name [TV] '%s' <> '%s'", name, block_header->name);
  }
  {
    BITCODE_H null_handle;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "null_handle", &null_handle, NULL)
        && !memcmp (&null_handle, &block_header->null_handle, sizeof (block_header->null_handle)))
        pass ();
    else
        fail ("BLOCK_HEADER.null_handle [H]");
  }
  {
    BITCODE_RL num_inserts;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "num_inserts", &num_inserts, NULL)
        && num_inserts == block_header->num_inserts)
      pass ();
    else
      fail ("BLOCK_HEADER.num_inserts [RL] %u != %u", block_header->num_inserts, num_inserts);
    num_inserts++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "num_inserts", &num_inserts, 0)
        && num_inserts == block_header->num_inserts)
      pass ();
    else
      fail ("BLOCK_HEADER.num_inserts [RL] set+1 %u != %u", block_header->num_inserts, num_inserts);
    block_header->num_inserts--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "num_owned", &num_owned, NULL)
        && num_owned == block_header->num_owned)
      pass ();
    else
      fail ("BLOCK_HEADER.num_owned [BL] %u != %u", block_header->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "num_owned", &num_owned, 0)
        && num_owned == block_header->num_owned)
      pass ();
    else
      fail ("BLOCK_HEADER.num_owned [BL] set+1 %u != %u", block_header->num_owned, num_owned);
    block_header->num_owned--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &block_header->parent, sizeof (block_header->parent)))
        pass ();
    else
        fail ("BLOCK_HEADER.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_TV preview;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "preview", &preview, NULL)
        && preview
           ? strEQ ((char *)preview, (char *)block_header->preview)
           : !block_header->preview)
      pass ();
    else
      fail ("BLOCK_HEADER.preview [TV] '%s' <> '%s'", preview, block_header->preview);
  }
  {
    BITCODE_BL preview_size;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "preview_size", &preview_size, NULL)
        && preview_size == block_header->preview_size)
      pass ();
    else
      fail ("BLOCK_HEADER.preview_size [BL] %u != %u", block_header->preview_size, preview_size);
    preview_size++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "preview_size", &preview_size, 0)
        && preview_size == block_header->preview_size)
      pass ();
    else
      fail ("BLOCK_HEADER.preview_size [BL] set+1 %u != %u", block_header->preview_size, preview_size);
    block_header->preview_size--;

  }
  {
    BITCODE_RS used;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "used", &used, NULL)
        && used == block_header->used)
      pass ();
    else
      fail ("BLOCK_HEADER.used [RS] %hu != %hu", block_header->used, used);
    used++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "used", &used, 0)
        && used == block_header->used)
      pass ();
    else
      fail ("BLOCK_HEADER.used [RS] set+1 %hu != %hu", block_header->used, used);
    block_header->used--;

  }
  {
    BITCODE_TV xref_pname;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "xref_pname", &xref_pname, NULL)
        && xref_pname
           ? strEQ ((char *)xref_pname, (char *)block_header->xref_pname)
           : !block_header->xref_pname)
      pass ();
    else
      fail ("BLOCK_HEADER.xref_pname [TV] '%s' <> '%s'", xref_pname, block_header->xref_pname);
  }
  {
    BITCODE_B xrefdep;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "xrefdep", &xrefdep, NULL)
        && xrefdep == block_header->xrefdep)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefdep [B] " FORMAT_B " != " FORMAT_B "", block_header->xrefdep, xrefdep);
    xrefdep++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "xrefdep", &xrefdep, 0)
        && xrefdep == block_header->xrefdep)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefdep [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->xrefdep, xrefdep);
    block_header->xrefdep--;

  }
  {
    BITCODE_BS xrefindex_plus1;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "xrefindex_plus1", &xrefindex_plus1, NULL)
        && xrefindex_plus1 == block_header->xrefindex_plus1)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefindex_plus1 [BS] %hu != %hu", block_header->xrefindex_plus1, xrefindex_plus1);
    xrefindex_plus1++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "xrefindex_plus1", &xrefindex_plus1, 0)
        && xrefindex_plus1 == block_header->xrefindex_plus1)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefindex_plus1 [BS] set+1 %hu != %hu", block_header->xrefindex_plus1, xrefindex_plus1);
    block_header->xrefindex_plus1--;

  }
  {
    BITCODE_B xrefoverlaid;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "xrefoverlaid", &xrefoverlaid, NULL)
        && xrefoverlaid == block_header->xrefoverlaid)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefoverlaid [B] " FORMAT_B " != " FORMAT_B "", block_header->xrefoverlaid, xrefoverlaid);
    xrefoverlaid++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "xrefoverlaid", &xrefoverlaid, 0)
        && xrefoverlaid == block_header->xrefoverlaid)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefoverlaid [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->xrefoverlaid, xrefoverlaid);
    block_header->xrefoverlaid--;

  }
  {
    BITCODE_B xrefref;
    if (dwg_dynapi_entity_value (block_header, "BLOCK_HEADER", "xrefref", &xrefref, NULL)
        && xrefref == block_header->xrefref)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefref [B] " FORMAT_B " != " FORMAT_B "", block_header->xrefref, xrefref);
    xrefref++;
    if (dwg_dynapi_entity_set_value (block_header, "BLOCK_HEADER", "xrefref", &xrefref, 0)
        && xrefref == block_header->xrefref)
      pass ();
    else
      fail ("BLOCK_HEADER.xrefref [B] set+1 " FORMAT_B " != " FORMAT_B "", block_header->xrefref, xrefref);
    block_header->xrefref--;

  }
  return failed;
}
static int test_CELLSTYLEMAP (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_CELLSTYLEMAP *restrict cellstylemap = obj->tio.object->tio.CELLSTYLEMAP;
  {
    Dwg_CELLSTYLEMAP_Cell* cells;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (cellstylemap, "CELLSTYLEMAP", "num_cells", &count, NULL)
        && dwg_dynapi_entity_value (cellstylemap, "CELLSTYLEMAP", "cells", &cells, NULL)
        && cells == cellstylemap->cells)
      pass ();
    else
      fail ("CELLSTYLEMAP.cells [Dwg_CELLSTYLEMAP_Cell*] * %u num_cells", count);
  }
  {
    BITCODE_BL num_cells;
    if (dwg_dynapi_entity_value (cellstylemap, "CELLSTYLEMAP", "num_cells", &num_cells, NULL)
        && num_cells == cellstylemap->num_cells)
      pass ();
    else
      fail ("CELLSTYLEMAP.num_cells [BL] %u != %u", cellstylemap->num_cells, num_cells);
    num_cells++;
    if (dwg_dynapi_entity_set_value (cellstylemap, "CELLSTYLEMAP", "num_cells", &num_cells, 0)
        && num_cells == cellstylemap->num_cells)
      pass ();
    else
      fail ("CELLSTYLEMAP.num_cells [BL] set+1 %u != %u", cellstylemap->num_cells, num_cells);
    cellstylemap->num_cells--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (cellstylemap, "CELLSTYLEMAP", "parent", &parent, NULL)
        && !memcmp (&parent, &cellstylemap->parent, sizeof (cellstylemap->parent)))
        pass ();
    else
        fail ("CELLSTYLEMAP.parent [struct _dwg_object_object*]");
  }
  return failed;
}
static int test_DATATABLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DATATABLE *restrict datatable = obj->tio.object->tio.DATATABLE;
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (datatable, "DATATABLE", "parent", &parent, NULL)
        && !memcmp (&parent, &datatable->parent, sizeof (datatable->parent)))
        pass ();
    else
        fail ("DATATABLE.parent [struct _dwg_object_object*]");
  }
  return failed;
}
static int test_DBCOLOR (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DBCOLOR *restrict dbcolor = obj->tio.object->tio.DBCOLOR;
  {
    BITCODE_T catalog;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "catalog", &catalog, NULL)
        && !memcmp (&catalog, &dbcolor->catalog, sizeof (dbcolor->catalog)))
        pass ();
    else
        fail ("DBCOLOR.catalog [T]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "class_version", &class_version, NULL)
        && class_version == dbcolor->class_version)
      pass ();
    else
      fail ("DBCOLOR.class_version [BL] %u != %u", dbcolor->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dbcolor, "DBCOLOR", "class_version", &class_version, 0)
        && class_version == dbcolor->class_version)
      pass ();
    else
      fail ("DBCOLOR.class_version [BL] set+1 %u != %u", dbcolor->class_version, class_version);
    dbcolor->class_version--;

  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "color", &color, NULL)
        && !memcmp (&color, &dbcolor->color, sizeof (dbcolor->color)))
        pass ();
    else
        fail ("DBCOLOR.color [CMC]");
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "name", &name, NULL)
        && !memcmp (&name, &dbcolor->name, sizeof (dbcolor->name)))
        pass ();
    else
        fail ("DBCOLOR.name [T]");
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "parent", &parent, NULL)
        && !memcmp (&parent, &dbcolor->parent, sizeof (dbcolor->parent)))
        pass ();
    else
        fail ("DBCOLOR.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_RL rgb;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "rgb", &rgb, NULL)
        && rgb == dbcolor->rgb)
      pass ();
    else
      fail ("DBCOLOR.rgb [RL] %u != %u", dbcolor->rgb, rgb);
    rgb++;
    if (dwg_dynapi_entity_set_value (dbcolor, "DBCOLOR", "rgb", &rgb, 0)
        && rgb == dbcolor->rgb)
      pass ();
    else
      fail ("DBCOLOR.rgb [RL] set+1 %u != %u", dbcolor->rgb, rgb);
    dbcolor->rgb--;

  }
  {
    BITCODE_BB unknown1;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "unknown1", &unknown1, NULL)
        && unknown1 == dbcolor->unknown1)
      pass ();
    else
      fail ("DBCOLOR.unknown1 [BB] " FORMAT_BB " != " FORMAT_BB "", dbcolor->unknown1, unknown1);
    unknown1++;
    if (dwg_dynapi_entity_set_value (dbcolor, "DBCOLOR", "unknown1", &unknown1, 0)
        && unknown1 == dbcolor->unknown1)
      pass ();
    else
      fail ("DBCOLOR.unknown1 [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", dbcolor->unknown1, unknown1);
    dbcolor->unknown1--;

  }
  {
    BITCODE_RC unknown2;
    if (dwg_dynapi_entity_value (dbcolor, "DBCOLOR", "unknown2", &unknown2, NULL)
        && unknown2 == dbcolor->unknown2)
      pass ();
    else
      fail ("DBCOLOR.unknown2 [RC] %u != %u", dbcolor->unknown2, unknown2);
    unknown2++;
    if (dwg_dynapi_entity_set_value (dbcolor, "DBCOLOR", "unknown2", &unknown2, 0)
        && unknown2 == dbcolor->unknown2)
      pass ();
    else
      fail ("DBCOLOR.unknown2 [RC] set+1 %u != %u", dbcolor->unknown2, unknown2);
    dbcolor->unknown2--;

  }
  return failed;
}
static int test_DICTIONARY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DICTIONARY *restrict dictionary = obj->tio.object->tio.DICTIONARY;
  {
    BITCODE_BS cloning;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "cloning", &cloning, NULL)
        && cloning == dictionary->cloning)
      pass ();
    else
      fail ("DICTIONARY.cloning [BS] %hu != %hu", dictionary->cloning, cloning);
    cloning++;
    if (dwg_dynapi_entity_set_value (dictionary, "DICTIONARY", "cloning", &cloning, 0)
        && cloning == dictionary->cloning)
      pass ();
    else
      fail ("DICTIONARY.cloning [BS] set+1 %hu != %hu", dictionary->cloning, cloning);
    dictionary->cloning--;

  }
  {
    BITCODE_RC cloning_r14;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "cloning_r14", &cloning_r14, NULL)
        && cloning_r14 == dictionary->cloning_r14)
      pass ();
    else
      fail ("DICTIONARY.cloning_r14 [RC] %u != %u", dictionary->cloning_r14, cloning_r14);
    cloning_r14++;
    if (dwg_dynapi_entity_set_value (dictionary, "DICTIONARY", "cloning_r14", &cloning_r14, 0)
        && cloning_r14 == dictionary->cloning_r14)
      pass ();
    else
      fail ("DICTIONARY.cloning_r14 [RC] set+1 %u != %u", dictionary->cloning_r14, cloning_r14);
    dictionary->cloning_r14--;

  }
  {
    BITCODE_RC hard_owner;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "hard_owner", &hard_owner, NULL)
        && hard_owner == dictionary->hard_owner)
      pass ();
    else
      fail ("DICTIONARY.hard_owner [RC] %u != %u", dictionary->hard_owner, hard_owner);
    hard_owner++;
    if (dwg_dynapi_entity_set_value (dictionary, "DICTIONARY", "hard_owner", &hard_owner, 0)
        && hard_owner == dictionary->hard_owner)
      pass ();
    else
      fail ("DICTIONARY.hard_owner [RC] set+1 %u != %u", dictionary->hard_owner, hard_owner);
    dictionary->hard_owner--;

  }
  {
    BITCODE_H* itemhandles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "numitems", &count, NULL)
        && dwg_dynapi_entity_value (dictionary, "DICTIONARY", "itemhandles", &itemhandles, NULL)
        && itemhandles == dictionary->itemhandles)
      pass ();
    else
      fail ("DICTIONARY.itemhandles [H*] * %u numitems", count);
  }
  {
    BITCODE_BL numitems;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "numitems", &numitems, NULL)
        && numitems == dictionary->numitems)
      pass ();
    else
      fail ("DICTIONARY.numitems [BL] %u != %u", dictionary->numitems, numitems);
    numitems++;
    if (dwg_dynapi_entity_set_value (dictionary, "DICTIONARY", "numitems", &numitems, 0)
        && numitems == dictionary->numitems)
      pass ();
    else
      fail ("DICTIONARY.numitems [BL] set+1 %u != %u", dictionary->numitems, numitems);
    dictionary->numitems--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "parent", &parent, NULL)
        && !memcmp (&parent, &dictionary->parent, sizeof (dictionary->parent)))
        pass ();
    else
        fail ("DICTIONARY.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_TV* texts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (dictionary, "DICTIONARY", "numitems", &count, NULL)
        && dwg_dynapi_entity_value (dictionary, "DICTIONARY", "texts", &texts, NULL)
        && texts == dictionary->texts)
      pass ();
    else
      fail ("DICTIONARY.texts [TV*] * %u numitems", count);
  }
  return failed;
}
static int test_DICTIONARYVAR (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DICTIONARYVAR *restrict dictionaryvar = obj->tio.object->tio.DICTIONARYVAR;
  {
    BITCODE_RC intval;
    if (dwg_dynapi_entity_value (dictionaryvar, "DICTIONARYVAR", "intval", &intval, NULL)
        && intval == dictionaryvar->intval)
      pass ();
    else
      fail ("DICTIONARYVAR.intval [RC] %u != %u", dictionaryvar->intval, intval);
    intval++;
    if (dwg_dynapi_entity_set_value (dictionaryvar, "DICTIONARYVAR", "intval", &intval, 0)
        && intval == dictionaryvar->intval)
      pass ();
    else
      fail ("DICTIONARYVAR.intval [RC] set+1 %u != %u", dictionaryvar->intval, intval);
    dictionaryvar->intval--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (dictionaryvar, "DICTIONARYVAR", "parent", &parent, NULL)
        && !memcmp (&parent, &dictionaryvar->parent, sizeof (dictionaryvar->parent)))
        pass ();
    else
        fail ("DICTIONARYVAR.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_TV str;
    if (dwg_dynapi_entity_value (dictionaryvar, "DICTIONARYVAR", "str", &str, NULL)
        && str
           ? strEQ ((char *)str, (char *)dictionaryvar->str)
           : !dictionaryvar->str)
      pass ();
    else
      fail ("DICTIONARYVAR.str [TV] '%s' <> '%s'", str, dictionaryvar->str);
  }
  return failed;
}
static int test_DICTIONARYWDFLT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DICTIONARYWDFLT *restrict dictionarywdflt = obj->tio.object->tio.DICTIONARYWDFLT;
  {
    BITCODE_BS cloning;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "cloning", &cloning, NULL)
        && cloning == dictionarywdflt->cloning)
      pass ();
    else
      fail ("DICTIONARYWDFLT.cloning [BS] %hu != %hu", dictionarywdflt->cloning, cloning);
    cloning++;
    if (dwg_dynapi_entity_set_value (dictionarywdflt, "DICTIONARYWDFLT", "cloning", &cloning, 0)
        && cloning == dictionarywdflt->cloning)
      pass ();
    else
      fail ("DICTIONARYWDFLT.cloning [BS] set+1 %hu != %hu", dictionarywdflt->cloning, cloning);
    dictionarywdflt->cloning--;

  }
  {
    BITCODE_RL cloning_r14;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "cloning_r14", &cloning_r14, NULL)
        && cloning_r14 == dictionarywdflt->cloning_r14)
      pass ();
    else
      fail ("DICTIONARYWDFLT.cloning_r14 [RL] %u != %u", dictionarywdflt->cloning_r14, cloning_r14);
    cloning_r14++;
    if (dwg_dynapi_entity_set_value (dictionarywdflt, "DICTIONARYWDFLT", "cloning_r14", &cloning_r14, 0)
        && cloning_r14 == dictionarywdflt->cloning_r14)
      pass ();
    else
      fail ("DICTIONARYWDFLT.cloning_r14 [RL] set+1 %u != %u", dictionarywdflt->cloning_r14, cloning_r14);
    dictionarywdflt->cloning_r14--;

  }
  {
    BITCODE_H defaultid;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "defaultid", &defaultid, NULL)
        && !memcmp (&defaultid, &dictionarywdflt->defaultid, sizeof (dictionarywdflt->defaultid)))
        pass ();
    else
        fail ("DICTIONARYWDFLT.defaultid [H]");
  }
  {
    BITCODE_RC hard_owner;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "hard_owner", &hard_owner, NULL)
        && hard_owner == dictionarywdflt->hard_owner)
      pass ();
    else
      fail ("DICTIONARYWDFLT.hard_owner [RC] %u != %u", dictionarywdflt->hard_owner, hard_owner);
    hard_owner++;
    if (dwg_dynapi_entity_set_value (dictionarywdflt, "DICTIONARYWDFLT", "hard_owner", &hard_owner, 0)
        && hard_owner == dictionarywdflt->hard_owner)
      pass ();
    else
      fail ("DICTIONARYWDFLT.hard_owner [RC] set+1 %u != %u", dictionarywdflt->hard_owner, hard_owner);
    dictionarywdflt->hard_owner--;

  }
  {
    BITCODE_H* itemhandles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "numitems", &count, NULL)
        && dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "itemhandles", &itemhandles, NULL)
        && itemhandles == dictionarywdflt->itemhandles)
      pass ();
    else
      fail ("DICTIONARYWDFLT.itemhandles [H*] * %u numitems", count);
  }
  {
    BITCODE_BL numitems;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "numitems", &numitems, NULL)
        && numitems == dictionarywdflt->numitems)
      pass ();
    else
      fail ("DICTIONARYWDFLT.numitems [BL] %u != %u", dictionarywdflt->numitems, numitems);
    numitems++;
    if (dwg_dynapi_entity_set_value (dictionarywdflt, "DICTIONARYWDFLT", "numitems", &numitems, 0)
        && numitems == dictionarywdflt->numitems)
      pass ();
    else
      fail ("DICTIONARYWDFLT.numitems [BL] set+1 %u != %u", dictionarywdflt->numitems, numitems);
    dictionarywdflt->numitems--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "parent", &parent, NULL)
        && !memcmp (&parent, &dictionarywdflt->parent, sizeof (dictionarywdflt->parent)))
        pass ();
    else
        fail ("DICTIONARYWDFLT.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_TV* texts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "numitems", &count, NULL)
        && dwg_dynapi_entity_value (dictionarywdflt, "DICTIONARYWDFLT", "texts", &texts, NULL)
        && texts == dictionarywdflt->texts)
      pass ();
    else
      fail ("DICTIONARYWDFLT.texts [TV*] * %u numitems", count);
  }
  return failed;
}
static int test_DIMASSOC (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DIMASSOC *restrict dimassoc = obj->tio.object->tio.DIMASSOC;
  {
    BITCODE_BL associativity;
    if (dwg_dynapi_entity_value (dimassoc, "DIMASSOC", "associativity", &associativity, NULL)
        && associativity == dimassoc->associativity)
      pass ();
    else
      fail ("DIMASSOC.associativity [BL] %u != %u", dimassoc->associativity, associativity);
    associativity++;
    if (dwg_dynapi_entity_set_value (dimassoc, "DIMASSOC", "associativity", &associativity, 0)
        && associativity == dimassoc->associativity)
      pass ();
    else
      fail ("DIMASSOC.associativity [BL] set+1 %u != %u", dimassoc->associativity, associativity);
    dimassoc->associativity--;

  }
  {
    BITCODE_BL intsect_gsmarker;
    if (dwg_dynapi_entity_value (dimassoc, "DIMASSOC", "intsect_gsmarker", &intsect_gsmarker, NULL)
        && intsect_gsmarker == dimassoc->intsect_gsmarker)
      pass ();
    else
      fail ("DIMASSOC.intsect_gsmarker [BL] %u != %u", dimassoc->intsect_gsmarker, intsect_gsmarker);
    intsect_gsmarker++;
    if (dwg_dynapi_entity_set_value (dimassoc, "DIMASSOC", "intsect_gsmarker", &intsect_gsmarker, 0)
        && intsect_gsmarker == dimassoc->intsect_gsmarker)
      pass ();
    else
      fail ("DIMASSOC.intsect_gsmarker [BL] set+1 %u != %u", dimassoc->intsect_gsmarker, intsect_gsmarker);
    dimassoc->intsect_gsmarker--;

  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (dimassoc, "DIMASSOC", "parent", &parent, NULL)
        && !memcmp (&parent, &dimassoc->parent, sizeof (dimassoc->parent)))
        pass ();
    else
        fail ("DIMASSOC.parent [struct _dwg_object_object*]");
  }
  {
    Dwg_DIMASSOC_Ref* ref;
    if (dwg_dynapi_entity_value (dimassoc, "DIMASSOC", "ref", &ref, NULL)
        && !memcmp (&ref, &dimassoc->ref, sizeof (dimassoc->ref)))
        pass ();
    else
        fail ("DIMASSOC.ref [Dwg_DIMASSOC_Ref*]");
  }
  {
    BITCODE_RC trans_space_flag;
    if (dwg_dynapi_entity_value (dimassoc, "DIMASSOC", "trans_space_flag", &trans_space_flag, NULL)
        && trans_space_flag == dimassoc->trans_space_flag)
      pass ();
    else
      fail ("DIMASSOC.trans_space_flag [RC] %u != %u", dimassoc->trans_space_flag, trans_space_flag);
    trans_space_flag++;
    if (dwg_dynapi_entity_set_value (dimassoc, "DIMASSOC", "trans_space_flag", &trans_space_flag, 0)
        && trans_space_flag == dimassoc->trans_space_flag)
      pass ();
    else
      fail ("DIMASSOC.trans_space_flag [RC] set+1 %u != %u", dimassoc->trans_space_flag, trans_space_flag);
    dimassoc->trans_space_flag--;

  }
  return failed;
}
static int test_DIMSTYLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DIMSTYLE *restrict dimstyle = obj->tio.object->tio.DIMSTYLE;
  {
    BITCODE_BS DIMADEC;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMADEC", &DIMADEC, NULL)
        && DIMADEC == dimstyle->DIMADEC)
      pass ();
    else
      fail ("DIMSTYLE.DIMADEC [BS] %hu != %hu", dimstyle->DIMADEC, DIMADEC);
    DIMADEC++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMADEC", &DIMADEC, 0)
        && DIMADEC == dimstyle->DIMADEC)
      pass ();
    else
      fail ("DIMSTYLE.DIMADEC [BS] set+1 %hu != %hu", dimstyle->DIMADEC, DIMADEC);
    dimstyle->DIMADEC--;

  }
  {
    BITCODE_B DIMALT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALT", &DIMALT, NULL)
        && DIMALT == dimstyle->DIMALT)
      pass ();
    else
      fail ("DIMSTYLE.DIMALT [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMALT, DIMALT);
    DIMALT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALT", &DIMALT, 0)
        && DIMALT == dimstyle->DIMALT)
      pass ();
    else
      fail ("DIMSTYLE.DIMALT [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMALT, DIMALT);
    dimstyle->DIMALT--;

  }
  {
    BITCODE_BS DIMALTD;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTD", &DIMALTD, NULL)
        && DIMALTD == dimstyle->DIMALTD)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTD [BS] %hu != %hu", dimstyle->DIMALTD, DIMALTD);
    DIMALTD++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTD", &DIMALTD, 0)
        && DIMALTD == dimstyle->DIMALTD)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTD [BS] set+1 %hu != %hu", dimstyle->DIMALTD, DIMALTD);
    dimstyle->DIMALTD--;

  }
  {
    BITCODE_BD DIMALTF;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTF", &DIMALTF, NULL)
        && DIMALTF == dimstyle->DIMALTF)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTF [BD] %g != %g", dimstyle->DIMALTF, DIMALTF);
    DIMALTF++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTF", &DIMALTF, 0)
        && DIMALTF == dimstyle->DIMALTF)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTF [BD] set+1 %g != %g", dimstyle->DIMALTF, DIMALTF);
    dimstyle->DIMALTF--;

  }
  {
    BITCODE_BD DIMALTMZF;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTMZF", &DIMALTMZF, NULL)
        && DIMALTMZF == dimstyle->DIMALTMZF)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTMZF [BD] %g != %g", dimstyle->DIMALTMZF, DIMALTMZF);
    DIMALTMZF++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTMZF", &DIMALTMZF, 0)
        && DIMALTMZF == dimstyle->DIMALTMZF)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTMZF [BD] set+1 %g != %g", dimstyle->DIMALTMZF, DIMALTMZF);
    dimstyle->DIMALTMZF--;

  }
  {
    BITCODE_T DIMALTMZS;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTMZS", &DIMALTMZS, NULL)
        && !memcmp (&DIMALTMZS, &dimstyle->DIMALTMZS, sizeof (dimstyle->DIMALTMZS)))
        pass ();
    else
        fail ("DIMSTYLE.DIMALTMZS [T]");
  }
  {
    BITCODE_BD DIMALTRND;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTRND", &DIMALTRND, NULL)
        && DIMALTRND == dimstyle->DIMALTRND)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTRND [BD] %g != %g", dimstyle->DIMALTRND, DIMALTRND);
    DIMALTRND++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTRND", &DIMALTRND, 0)
        && DIMALTRND == dimstyle->DIMALTRND)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTRND [BD] set+1 %g != %g", dimstyle->DIMALTRND, DIMALTRND);
    dimstyle->DIMALTRND--;

  }
  {
    BITCODE_BS DIMALTTD;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTTD", &DIMALTTD, NULL)
        && DIMALTTD == dimstyle->DIMALTTD)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTTD [BS] %hu != %hu", dimstyle->DIMALTTD, DIMALTTD);
    DIMALTTD++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTTD", &DIMALTTD, 0)
        && DIMALTTD == dimstyle->DIMALTTD)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTTD [BS] set+1 %hu != %hu", dimstyle->DIMALTTD, DIMALTTD);
    dimstyle->DIMALTTD--;

  }
  {
    BITCODE_BS DIMALTTZ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTTZ", &DIMALTTZ, NULL)
        && DIMALTTZ == dimstyle->DIMALTTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTTZ [BS] %hu != %hu", dimstyle->DIMALTTZ, DIMALTTZ);
    DIMALTTZ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTTZ", &DIMALTTZ, 0)
        && DIMALTTZ == dimstyle->DIMALTTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTTZ [BS] set+1 %hu != %hu", dimstyle->DIMALTTZ, DIMALTTZ);
    dimstyle->DIMALTTZ--;

  }
  {
    BITCODE_BS DIMALTU;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTU", &DIMALTU, NULL)
        && DIMALTU == dimstyle->DIMALTU)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTU [BS] %hu != %hu", dimstyle->DIMALTU, DIMALTU);
    DIMALTU++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTU", &DIMALTU, 0)
        && DIMALTU == dimstyle->DIMALTU)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTU [BS] set+1 %hu != %hu", dimstyle->DIMALTU, DIMALTU);
    dimstyle->DIMALTU--;

  }
  {
    BITCODE_BS DIMALTZ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMALTZ", &DIMALTZ, NULL)
        && DIMALTZ == dimstyle->DIMALTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTZ [BS] %hu != %hu", dimstyle->DIMALTZ, DIMALTZ);
    DIMALTZ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMALTZ", &DIMALTZ, 0)
        && DIMALTZ == dimstyle->DIMALTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMALTZ [BS] set+1 %hu != %hu", dimstyle->DIMALTZ, DIMALTZ);
    dimstyle->DIMALTZ--;

  }
  {
    BITCODE_T DIMAPOST;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMAPOST", &DIMAPOST, NULL)
        && !memcmp (&DIMAPOST, &dimstyle->DIMAPOST, sizeof (dimstyle->DIMAPOST)))
        pass ();
    else
        fail ("DIMSTYLE.DIMAPOST [T]");
  }
  {
    BITCODE_BS DIMARCSYM;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMARCSYM", &DIMARCSYM, NULL)
        && DIMARCSYM == dimstyle->DIMARCSYM)
      pass ();
    else
      fail ("DIMSTYLE.DIMARCSYM [BS] %hu != %hu", dimstyle->DIMARCSYM, DIMARCSYM);
    DIMARCSYM++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMARCSYM", &DIMARCSYM, 0)
        && DIMARCSYM == dimstyle->DIMARCSYM)
      pass ();
    else
      fail ("DIMSTYLE.DIMARCSYM [BS] set+1 %hu != %hu", dimstyle->DIMARCSYM, DIMARCSYM);
    dimstyle->DIMARCSYM--;

  }
  {
    BITCODE_BD DIMASZ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMASZ", &DIMASZ, NULL)
        && DIMASZ == dimstyle->DIMASZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMASZ [BD] %g != %g", dimstyle->DIMASZ, DIMASZ);
    DIMASZ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMASZ", &DIMASZ, 0)
        && DIMASZ == dimstyle->DIMASZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMASZ [BD] set+1 %g != %g", dimstyle->DIMASZ, DIMASZ);
    dimstyle->DIMASZ--;

  }
  {
    BITCODE_BS DIMATFIT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMATFIT", &DIMATFIT, NULL)
        && DIMATFIT == dimstyle->DIMATFIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMATFIT [BS] %hu != %hu", dimstyle->DIMATFIT, DIMATFIT);
    DIMATFIT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMATFIT", &DIMATFIT, 0)
        && DIMATFIT == dimstyle->DIMATFIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMATFIT [BS] set+1 %hu != %hu", dimstyle->DIMATFIT, DIMATFIT);
    dimstyle->DIMATFIT--;

  }
  {
    BITCODE_BS DIMAUNIT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMAUNIT", &DIMAUNIT, NULL)
        && DIMAUNIT == dimstyle->DIMAUNIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMAUNIT [BS] %hu != %hu", dimstyle->DIMAUNIT, DIMAUNIT);
    DIMAUNIT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMAUNIT", &DIMAUNIT, 0)
        && DIMAUNIT == dimstyle->DIMAUNIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMAUNIT [BS] set+1 %hu != %hu", dimstyle->DIMAUNIT, DIMAUNIT);
    dimstyle->DIMAUNIT--;

  }
  {
    BITCODE_BS DIMAZIN;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMAZIN", &DIMAZIN, NULL)
        && DIMAZIN == dimstyle->DIMAZIN)
      pass ();
    else
      fail ("DIMSTYLE.DIMAZIN [BS] %hu != %hu", dimstyle->DIMAZIN, DIMAZIN);
    DIMAZIN++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMAZIN", &DIMAZIN, 0)
        && DIMAZIN == dimstyle->DIMAZIN)
      pass ();
    else
      fail ("DIMSTYLE.DIMAZIN [BS] set+1 %hu != %hu", dimstyle->DIMAZIN, DIMAZIN);
    dimstyle->DIMAZIN--;

  }
  {
    BITCODE_H DIMBLK;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMBLK", &DIMBLK, NULL)
        && !memcmp (&DIMBLK, &dimstyle->DIMBLK, sizeof (dimstyle->DIMBLK)))
        pass ();
    else
        fail ("DIMSTYLE.DIMBLK [H]");
  }
  {
    BITCODE_H DIMBLK1;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMBLK1", &DIMBLK1, NULL)
        && !memcmp (&DIMBLK1, &dimstyle->DIMBLK1, sizeof (dimstyle->DIMBLK1)))
        pass ();
    else
        fail ("DIMSTYLE.DIMBLK1 [H]");
  }
  {
    BITCODE_T DIMBLK1_T;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMBLK1_T", &DIMBLK1_T, NULL)
        && !memcmp (&DIMBLK1_T, &dimstyle->DIMBLK1_T, sizeof (dimstyle->DIMBLK1_T)))
        pass ();
    else
        fail ("DIMSTYLE.DIMBLK1_T [T]");
  }
  {
    BITCODE_H DIMBLK2;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMBLK2", &DIMBLK2, NULL)
        && !memcmp (&DIMBLK2, &dimstyle->DIMBLK2, sizeof (dimstyle->DIMBLK2)))
        pass ();
    else
        fail ("DIMSTYLE.DIMBLK2 [H]");
  }
  {
    BITCODE_T DIMBLK2_T;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMBLK2_T", &DIMBLK2_T, NULL)
        && !memcmp (&DIMBLK2_T, &dimstyle->DIMBLK2_T, sizeof (dimstyle->DIMBLK2_T)))
        pass ();
    else
        fail ("DIMSTYLE.DIMBLK2_T [T]");
  }
  {
    BITCODE_T DIMBLK_T;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMBLK_T", &DIMBLK_T, NULL)
        && !memcmp (&DIMBLK_T, &dimstyle->DIMBLK_T, sizeof (dimstyle->DIMBLK_T)))
        pass ();
    else
        fail ("DIMSTYLE.DIMBLK_T [T]");
  }
  {
    BITCODE_BD DIMCEN;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCEN", &DIMCEN, NULL)
        && DIMCEN == dimstyle->DIMCEN)
      pass ();
    else
      fail ("DIMSTYLE.DIMCEN [BD] %g != %g", dimstyle->DIMCEN, DIMCEN);
    DIMCEN++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMCEN", &DIMCEN, 0)
        && DIMCEN == dimstyle->DIMCEN)
      pass ();
    else
      fail ("DIMSTYLE.DIMCEN [BD] set+1 %g != %g", dimstyle->DIMCEN, DIMCEN);
    dimstyle->DIMCEN--;

  }
  {
    BITCODE_CMC DIMCLRD;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCLRD", &DIMCLRD, NULL)
        && !memcmp (&DIMCLRD, &dimstyle->DIMCLRD, sizeof (dimstyle->DIMCLRD)))
        pass ();
    else
        fail ("DIMSTYLE.DIMCLRD [CMC]");
  }
  {
    BITCODE_RS DIMCLRD_N;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCLRD_N", &DIMCLRD_N, NULL)
        && DIMCLRD_N == dimstyle->DIMCLRD_N)
      pass ();
    else
      fail ("DIMSTYLE.DIMCLRD_N [RS] %hu != %hu", dimstyle->DIMCLRD_N, DIMCLRD_N);
    DIMCLRD_N++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMCLRD_N", &DIMCLRD_N, 0)
        && DIMCLRD_N == dimstyle->DIMCLRD_N)
      pass ();
    else
      fail ("DIMSTYLE.DIMCLRD_N [RS] set+1 %hu != %hu", dimstyle->DIMCLRD_N, DIMCLRD_N);
    dimstyle->DIMCLRD_N--;

  }
  {
    BITCODE_CMC DIMCLRE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCLRE", &DIMCLRE, NULL)
        && !memcmp (&DIMCLRE, &dimstyle->DIMCLRE, sizeof (dimstyle->DIMCLRE)))
        pass ();
    else
        fail ("DIMSTYLE.DIMCLRE [CMC]");
  }
  {
    BITCODE_RS DIMCLRE_N;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCLRE_N", &DIMCLRE_N, NULL)
        && DIMCLRE_N == dimstyle->DIMCLRE_N)
      pass ();
    else
      fail ("DIMSTYLE.DIMCLRE_N [RS] %hu != %hu", dimstyle->DIMCLRE_N, DIMCLRE_N);
    DIMCLRE_N++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMCLRE_N", &DIMCLRE_N, 0)
        && DIMCLRE_N == dimstyle->DIMCLRE_N)
      pass ();
    else
      fail ("DIMSTYLE.DIMCLRE_N [RS] set+1 %hu != %hu", dimstyle->DIMCLRE_N, DIMCLRE_N);
    dimstyle->DIMCLRE_N--;

  }
  {
    BITCODE_CMC DIMCLRT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCLRT", &DIMCLRT, NULL)
        && !memcmp (&DIMCLRT, &dimstyle->DIMCLRT, sizeof (dimstyle->DIMCLRT)))
        pass ();
    else
        fail ("DIMSTYLE.DIMCLRT [CMC]");
  }
  {
    BITCODE_RS DIMCLRT_N;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMCLRT_N", &DIMCLRT_N, NULL)
        && DIMCLRT_N == dimstyle->DIMCLRT_N)
      pass ();
    else
      fail ("DIMSTYLE.DIMCLRT_N [RS] %hu != %hu", dimstyle->DIMCLRT_N, DIMCLRT_N);
    DIMCLRT_N++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMCLRT_N", &DIMCLRT_N, 0)
        && DIMCLRT_N == dimstyle->DIMCLRT_N)
      pass ();
    else
      fail ("DIMSTYLE.DIMCLRT_N [RS] set+1 %hu != %hu", dimstyle->DIMCLRT_N, DIMCLRT_N);
    dimstyle->DIMCLRT_N--;

  }
  {
    BITCODE_BS DIMDEC;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMDEC", &DIMDEC, NULL)
        && DIMDEC == dimstyle->DIMDEC)
      pass ();
    else
      fail ("DIMSTYLE.DIMDEC [BS] %hu != %hu", dimstyle->DIMDEC, DIMDEC);
    DIMDEC++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMDEC", &DIMDEC, 0)
        && DIMDEC == dimstyle->DIMDEC)
      pass ();
    else
      fail ("DIMSTYLE.DIMDEC [BS] set+1 %hu != %hu", dimstyle->DIMDEC, DIMDEC);
    dimstyle->DIMDEC--;

  }
  {
    BITCODE_BD DIMDLE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMDLE", &DIMDLE, NULL)
        && DIMDLE == dimstyle->DIMDLE)
      pass ();
    else
      fail ("DIMSTYLE.DIMDLE [BD] %g != %g", dimstyle->DIMDLE, DIMDLE);
    DIMDLE++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMDLE", &DIMDLE, 0)
        && DIMDLE == dimstyle->DIMDLE)
      pass ();
    else
      fail ("DIMSTYLE.DIMDLE [BD] set+1 %g != %g", dimstyle->DIMDLE, DIMDLE);
    dimstyle->DIMDLE--;

  }
  {
    BITCODE_BD DIMDLI;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMDLI", &DIMDLI, NULL)
        && DIMDLI == dimstyle->DIMDLI)
      pass ();
    else
      fail ("DIMSTYLE.DIMDLI [BD] %g != %g", dimstyle->DIMDLI, DIMDLI);
    DIMDLI++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMDLI", &DIMDLI, 0)
        && DIMDLI == dimstyle->DIMDLI)
      pass ();
    else
      fail ("DIMSTYLE.DIMDLI [BD] set+1 %g != %g", dimstyle->DIMDLI, DIMDLI);
    dimstyle->DIMDLI--;

  }
  {
    BITCODE_BS DIMDSEP;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMDSEP", &DIMDSEP, NULL)
        && DIMDSEP == dimstyle->DIMDSEP)
      pass ();
    else
      fail ("DIMSTYLE.DIMDSEP [BS] %hu != %hu", dimstyle->DIMDSEP, DIMDSEP);
    DIMDSEP++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMDSEP", &DIMDSEP, 0)
        && DIMDSEP == dimstyle->DIMDSEP)
      pass ();
    else
      fail ("DIMSTYLE.DIMDSEP [BS] set+1 %hu != %hu", dimstyle->DIMDSEP, DIMDSEP);
    dimstyle->DIMDSEP--;

  }
  {
    BITCODE_BD DIMEXE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMEXE", &DIMEXE, NULL)
        && DIMEXE == dimstyle->DIMEXE)
      pass ();
    else
      fail ("DIMSTYLE.DIMEXE [BD] %g != %g", dimstyle->DIMEXE, DIMEXE);
    DIMEXE++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMEXE", &DIMEXE, 0)
        && DIMEXE == dimstyle->DIMEXE)
      pass ();
    else
      fail ("DIMSTYLE.DIMEXE [BD] set+1 %g != %g", dimstyle->DIMEXE, DIMEXE);
    dimstyle->DIMEXE--;

  }
  {
    BITCODE_BD DIMEXO;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMEXO", &DIMEXO, NULL)
        && DIMEXO == dimstyle->DIMEXO)
      pass ();
    else
      fail ("DIMSTYLE.DIMEXO [BD] %g != %g", dimstyle->DIMEXO, DIMEXO);
    DIMEXO++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMEXO", &DIMEXO, 0)
        && DIMEXO == dimstyle->DIMEXO)
      pass ();
    else
      fail ("DIMSTYLE.DIMEXO [BD] set+1 %g != %g", dimstyle->DIMEXO, DIMEXO);
    dimstyle->DIMEXO--;

  }
  {
    BITCODE_BS DIMFIT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMFIT", &DIMFIT, NULL)
        && DIMFIT == dimstyle->DIMFIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMFIT [BS] %hu != %hu", dimstyle->DIMFIT, DIMFIT);
    DIMFIT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMFIT", &DIMFIT, 0)
        && DIMFIT == dimstyle->DIMFIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMFIT [BS] set+1 %hu != %hu", dimstyle->DIMFIT, DIMFIT);
    dimstyle->DIMFIT--;

  }
  {
    BITCODE_BS DIMFRAC;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMFRAC", &DIMFRAC, NULL)
        && DIMFRAC == dimstyle->DIMFRAC)
      pass ();
    else
      fail ("DIMSTYLE.DIMFRAC [BS] %hu != %hu", dimstyle->DIMFRAC, DIMFRAC);
    DIMFRAC++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMFRAC", &DIMFRAC, 0)
        && DIMFRAC == dimstyle->DIMFRAC)
      pass ();
    else
      fail ("DIMSTYLE.DIMFRAC [BS] set+1 %hu != %hu", dimstyle->DIMFRAC, DIMFRAC);
    dimstyle->DIMFRAC--;

  }
  {
    BITCODE_BD DIMFXL;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMFXL", &DIMFXL, NULL)
        && DIMFXL == dimstyle->DIMFXL)
      pass ();
    else
      fail ("DIMSTYLE.DIMFXL [BD] %g != %g", dimstyle->DIMFXL, DIMFXL);
    DIMFXL++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMFXL", &DIMFXL, 0)
        && DIMFXL == dimstyle->DIMFXL)
      pass ();
    else
      fail ("DIMSTYLE.DIMFXL [BD] set+1 %g != %g", dimstyle->DIMFXL, DIMFXL);
    dimstyle->DIMFXL--;

  }
  {
    BITCODE_B DIMFXLON;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMFXLON", &DIMFXLON, NULL)
        && DIMFXLON == dimstyle->DIMFXLON)
      pass ();
    else
      fail ("DIMSTYLE.DIMFXLON [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMFXLON, DIMFXLON);
    DIMFXLON++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMFXLON", &DIMFXLON, 0)
        && DIMFXLON == dimstyle->DIMFXLON)
      pass ();
    else
      fail ("DIMSTYLE.DIMFXLON [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMFXLON, DIMFXLON);
    dimstyle->DIMFXLON--;

  }
  {
    BITCODE_BD DIMGAP;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMGAP", &DIMGAP, NULL)
        && DIMGAP == dimstyle->DIMGAP)
      pass ();
    else
      fail ("DIMSTYLE.DIMGAP [BD] %g != %g", dimstyle->DIMGAP, DIMGAP);
    DIMGAP++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMGAP", &DIMGAP, 0)
        && DIMGAP == dimstyle->DIMGAP)
      pass ();
    else
      fail ("DIMSTYLE.DIMGAP [BD] set+1 %g != %g", dimstyle->DIMGAP, DIMGAP);
    dimstyle->DIMGAP--;

  }
  {
    BITCODE_BD DIMJOGANG;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMJOGANG", &DIMJOGANG, NULL)
        && DIMJOGANG == dimstyle->DIMJOGANG)
      pass ();
    else
      fail ("DIMSTYLE.DIMJOGANG [BD] %g != %g", dimstyle->DIMJOGANG, DIMJOGANG);
    DIMJOGANG++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMJOGANG", &DIMJOGANG, 0)
        && DIMJOGANG == dimstyle->DIMJOGANG)
      pass ();
    else
      fail ("DIMSTYLE.DIMJOGANG [BD] set+1 %g != %g", dimstyle->DIMJOGANG, DIMJOGANG);
    dimstyle->DIMJOGANG--;

  }
  {
    BITCODE_BS DIMJUST;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMJUST", &DIMJUST, NULL)
        && DIMJUST == dimstyle->DIMJUST)
      pass ();
    else
      fail ("DIMSTYLE.DIMJUST [BS] %hu != %hu", dimstyle->DIMJUST, DIMJUST);
    DIMJUST++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMJUST", &DIMJUST, 0)
        && DIMJUST == dimstyle->DIMJUST)
      pass ();
    else
      fail ("DIMSTYLE.DIMJUST [BS] set+1 %hu != %hu", dimstyle->DIMJUST, DIMJUST);
    dimstyle->DIMJUST--;

  }
  {
    BITCODE_H DIMLDRBLK;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLDRBLK", &DIMLDRBLK, NULL)
        && !memcmp (&DIMLDRBLK, &dimstyle->DIMLDRBLK, sizeof (dimstyle->DIMLDRBLK)))
        pass ();
    else
        fail ("DIMSTYLE.DIMLDRBLK [H]");
  }
  {
    BITCODE_BD DIMLFAC;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLFAC", &DIMLFAC, NULL)
        && DIMLFAC == dimstyle->DIMLFAC)
      pass ();
    else
      fail ("DIMSTYLE.DIMLFAC [BD] %g != %g", dimstyle->DIMLFAC, DIMLFAC);
    DIMLFAC++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMLFAC", &DIMLFAC, 0)
        && DIMLFAC == dimstyle->DIMLFAC)
      pass ();
    else
      fail ("DIMSTYLE.DIMLFAC [BD] set+1 %g != %g", dimstyle->DIMLFAC, DIMLFAC);
    dimstyle->DIMLFAC--;

  }
  {
    BITCODE_B DIMLIM;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLIM", &DIMLIM, NULL)
        && DIMLIM == dimstyle->DIMLIM)
      pass ();
    else
      fail ("DIMSTYLE.DIMLIM [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMLIM, DIMLIM);
    DIMLIM++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMLIM", &DIMLIM, 0)
        && DIMLIM == dimstyle->DIMLIM)
      pass ();
    else
      fail ("DIMSTYLE.DIMLIM [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMLIM, DIMLIM);
    dimstyle->DIMLIM--;

  }
  {
    BITCODE_H DIMLTEX1;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLTEX1", &DIMLTEX1, NULL)
        && !memcmp (&DIMLTEX1, &dimstyle->DIMLTEX1, sizeof (dimstyle->DIMLTEX1)))
        pass ();
    else
        fail ("DIMSTYLE.DIMLTEX1 [H]");
  }
  {
    BITCODE_H DIMLTEX2;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLTEX2", &DIMLTEX2, NULL)
        && !memcmp (&DIMLTEX2, &dimstyle->DIMLTEX2, sizeof (dimstyle->DIMLTEX2)))
        pass ();
    else
        fail ("DIMSTYLE.DIMLTEX2 [H]");
  }
  {
    BITCODE_H DIMLTYPE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLTYPE", &DIMLTYPE, NULL)
        && !memcmp (&DIMLTYPE, &dimstyle->DIMLTYPE, sizeof (dimstyle->DIMLTYPE)))
        pass ();
    else
        fail ("DIMSTYLE.DIMLTYPE [H]");
  }
  {
    BITCODE_BS DIMLUNIT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLUNIT", &DIMLUNIT, NULL)
        && DIMLUNIT == dimstyle->DIMLUNIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMLUNIT [BS] %hu != %hu", dimstyle->DIMLUNIT, DIMLUNIT);
    DIMLUNIT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMLUNIT", &DIMLUNIT, 0)
        && DIMLUNIT == dimstyle->DIMLUNIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMLUNIT [BS] set+1 %hu != %hu", dimstyle->DIMLUNIT, DIMLUNIT);
    dimstyle->DIMLUNIT--;

  }
  {
    BITCODE_BSd DIMLWD;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLWD", &DIMLWD, NULL)
        && DIMLWD == dimstyle->DIMLWD)
      pass ();
    else
      fail ("DIMSTYLE.DIMLWD [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dimstyle->DIMLWD, DIMLWD);
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMLWD", &DIMLWD, 0)
        && DIMLWD == dimstyle->DIMLWD)
      pass ();
    else
      fail ("DIMSTYLE.DIMLWD [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "", dimstyle->DIMLWD, DIMLWD);
    dimstyle->DIMLWD--;

  }
  {
    BITCODE_BSd DIMLWE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMLWE", &DIMLWE, NULL)
        && DIMLWE == dimstyle->DIMLWE)
      pass ();
    else
      fail ("DIMSTYLE.DIMLWE [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dimstyle->DIMLWE, DIMLWE);
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMLWE", &DIMLWE, 0)
        && DIMLWE == dimstyle->DIMLWE)
      pass ();
    else
      fail ("DIMSTYLE.DIMLWE [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "", dimstyle->DIMLWE, DIMLWE);
    dimstyle->DIMLWE--;

  }
  {
    BITCODE_BS DIMMALTTZ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMMALTTZ", &DIMMALTTZ, NULL)
        && DIMMALTTZ == dimstyle->DIMMALTTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMMALTTZ [BS] %hu != %hu", dimstyle->DIMMALTTZ, DIMMALTTZ);
    DIMMALTTZ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMMALTTZ", &DIMMALTTZ, 0)
        && DIMMALTTZ == dimstyle->DIMMALTTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMMALTTZ [BS] set+1 %hu != %hu", dimstyle->DIMMALTTZ, DIMMALTTZ);
    dimstyle->DIMMALTTZ--;

  }
  {
    BITCODE_BS DIMMALTZ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMMALTZ", &DIMMALTZ, NULL)
        && DIMMALTZ == dimstyle->DIMMALTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMMALTZ [BS] %hu != %hu", dimstyle->DIMMALTZ, DIMMALTZ);
    DIMMALTZ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMMALTZ", &DIMMALTZ, 0)
        && DIMMALTZ == dimstyle->DIMMALTZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMMALTZ [BS] set+1 %hu != %hu", dimstyle->DIMMALTZ, DIMMALTZ);
    dimstyle->DIMMALTZ--;

  }
  {
    BITCODE_BD DIMMZF;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMMZF", &DIMMZF, NULL)
        && DIMMZF == dimstyle->DIMMZF)
      pass ();
    else
      fail ("DIMSTYLE.DIMMZF [BD] %g != %g", dimstyle->DIMMZF, DIMMZF);
    DIMMZF++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMMZF", &DIMMZF, 0)
        && DIMMZF == dimstyle->DIMMZF)
      pass ();
    else
      fail ("DIMSTYLE.DIMMZF [BD] set+1 %g != %g", dimstyle->DIMMZF, DIMMZF);
    dimstyle->DIMMZF--;

  }
  {
    BITCODE_T DIMMZS;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMMZS", &DIMMZS, NULL)
        && !memcmp (&DIMMZS, &dimstyle->DIMMZS, sizeof (dimstyle->DIMMZS)))
        pass ();
    else
        fail ("DIMSTYLE.DIMMZS [T]");
  }
  {
    BITCODE_T DIMPOST;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMPOST", &DIMPOST, NULL)
        && !memcmp (&DIMPOST, &dimstyle->DIMPOST, sizeof (dimstyle->DIMPOST)))
        pass ();
    else
        fail ("DIMSTYLE.DIMPOST [T]");
  }
  {
    BITCODE_BD DIMRND;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMRND", &DIMRND, NULL)
        && DIMRND == dimstyle->DIMRND)
      pass ();
    else
      fail ("DIMSTYLE.DIMRND [BD] %g != %g", dimstyle->DIMRND, DIMRND);
    DIMRND++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMRND", &DIMRND, 0)
        && DIMRND == dimstyle->DIMRND)
      pass ();
    else
      fail ("DIMSTYLE.DIMRND [BD] set+1 %g != %g", dimstyle->DIMRND, DIMRND);
    dimstyle->DIMRND--;

  }
  {
    BITCODE_B DIMSAH;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSAH", &DIMSAH, NULL)
        && DIMSAH == dimstyle->DIMSAH)
      pass ();
    else
      fail ("DIMSTYLE.DIMSAH [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSAH, DIMSAH);
    DIMSAH++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSAH", &DIMSAH, 0)
        && DIMSAH == dimstyle->DIMSAH)
      pass ();
    else
      fail ("DIMSTYLE.DIMSAH [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSAH, DIMSAH);
    dimstyle->DIMSAH--;

  }
  {
    BITCODE_BD DIMSCALE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSCALE", &DIMSCALE, NULL)
        && DIMSCALE == dimstyle->DIMSCALE)
      pass ();
    else
      fail ("DIMSTYLE.DIMSCALE [BD] %g != %g", dimstyle->DIMSCALE, DIMSCALE);
    DIMSCALE++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSCALE", &DIMSCALE, 0)
        && DIMSCALE == dimstyle->DIMSCALE)
      pass ();
    else
      fail ("DIMSTYLE.DIMSCALE [BD] set+1 %g != %g", dimstyle->DIMSCALE, DIMSCALE);
    dimstyle->DIMSCALE--;

  }
  {
    BITCODE_B DIMSD1;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSD1", &DIMSD1, NULL)
        && DIMSD1 == dimstyle->DIMSD1)
      pass ();
    else
      fail ("DIMSTYLE.DIMSD1 [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSD1, DIMSD1);
    DIMSD1++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSD1", &DIMSD1, 0)
        && DIMSD1 == dimstyle->DIMSD1)
      pass ();
    else
      fail ("DIMSTYLE.DIMSD1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSD1, DIMSD1);
    dimstyle->DIMSD1--;

  }
  {
    BITCODE_B DIMSD2;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSD2", &DIMSD2, NULL)
        && DIMSD2 == dimstyle->DIMSD2)
      pass ();
    else
      fail ("DIMSTYLE.DIMSD2 [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSD2, DIMSD2);
    DIMSD2++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSD2", &DIMSD2, 0)
        && DIMSD2 == dimstyle->DIMSD2)
      pass ();
    else
      fail ("DIMSTYLE.DIMSD2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSD2, DIMSD2);
    dimstyle->DIMSD2--;

  }
  {
    BITCODE_B DIMSE1;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSE1", &DIMSE1, NULL)
        && DIMSE1 == dimstyle->DIMSE1)
      pass ();
    else
      fail ("DIMSTYLE.DIMSE1 [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSE1, DIMSE1);
    DIMSE1++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSE1", &DIMSE1, 0)
        && DIMSE1 == dimstyle->DIMSE1)
      pass ();
    else
      fail ("DIMSTYLE.DIMSE1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSE1, DIMSE1);
    dimstyle->DIMSE1--;

  }
  {
    BITCODE_B DIMSE2;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSE2", &DIMSE2, NULL)
        && DIMSE2 == dimstyle->DIMSE2)
      pass ();
    else
      fail ("DIMSTYLE.DIMSE2 [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSE2, DIMSE2);
    DIMSE2++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSE2", &DIMSE2, 0)
        && DIMSE2 == dimstyle->DIMSE2)
      pass ();
    else
      fail ("DIMSTYLE.DIMSE2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSE2, DIMSE2);
    dimstyle->DIMSE2--;

  }
  {
    BITCODE_B DIMSOXD;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMSOXD", &DIMSOXD, NULL)
        && DIMSOXD == dimstyle->DIMSOXD)
      pass ();
    else
      fail ("DIMSTYLE.DIMSOXD [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSOXD, DIMSOXD);
    DIMSOXD++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMSOXD", &DIMSOXD, 0)
        && DIMSOXD == dimstyle->DIMSOXD)
      pass ();
    else
      fail ("DIMSTYLE.DIMSOXD [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMSOXD, DIMSOXD);
    dimstyle->DIMSOXD--;

  }
  {
    BITCODE_BS DIMTAD;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTAD", &DIMTAD, NULL)
        && DIMTAD == dimstyle->DIMTAD)
      pass ();
    else
      fail ("DIMSTYLE.DIMTAD [BS] %hu != %hu", dimstyle->DIMTAD, DIMTAD);
    DIMTAD++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTAD", &DIMTAD, 0)
        && DIMTAD == dimstyle->DIMTAD)
      pass ();
    else
      fail ("DIMSTYLE.DIMTAD [BS] set+1 %hu != %hu", dimstyle->DIMTAD, DIMTAD);
    dimstyle->DIMTAD--;

  }
  {
    BITCODE_BS DIMTDEC;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTDEC", &DIMTDEC, NULL)
        && DIMTDEC == dimstyle->DIMTDEC)
      pass ();
    else
      fail ("DIMSTYLE.DIMTDEC [BS] %hu != %hu", dimstyle->DIMTDEC, DIMTDEC);
    DIMTDEC++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTDEC", &DIMTDEC, 0)
        && DIMTDEC == dimstyle->DIMTDEC)
      pass ();
    else
      fail ("DIMSTYLE.DIMTDEC [BS] set+1 %hu != %hu", dimstyle->DIMTDEC, DIMTDEC);
    dimstyle->DIMTDEC--;

  }
  {
    BITCODE_BD DIMTFAC;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTFAC", &DIMTFAC, NULL)
        && DIMTFAC == dimstyle->DIMTFAC)
      pass ();
    else
      fail ("DIMSTYLE.DIMTFAC [BD] %g != %g", dimstyle->DIMTFAC, DIMTFAC);
    DIMTFAC++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTFAC", &DIMTFAC, 0)
        && DIMTFAC == dimstyle->DIMTFAC)
      pass ();
    else
      fail ("DIMSTYLE.DIMTFAC [BD] set+1 %g != %g", dimstyle->DIMTFAC, DIMTFAC);
    dimstyle->DIMTFAC--;

  }
  {
    BITCODE_BS DIMTFILL;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTFILL", &DIMTFILL, NULL)
        && DIMTFILL == dimstyle->DIMTFILL)
      pass ();
    else
      fail ("DIMSTYLE.DIMTFILL [BS] %hu != %hu", dimstyle->DIMTFILL, DIMTFILL);
    DIMTFILL++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTFILL", &DIMTFILL, 0)
        && DIMTFILL == dimstyle->DIMTFILL)
      pass ();
    else
      fail ("DIMSTYLE.DIMTFILL [BS] set+1 %hu != %hu", dimstyle->DIMTFILL, DIMTFILL);
    dimstyle->DIMTFILL--;

  }
  {
    BITCODE_CMC DIMTFILLCLR;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTFILLCLR", &DIMTFILLCLR, NULL)
        && !memcmp (&DIMTFILLCLR, &dimstyle->DIMTFILLCLR, sizeof (dimstyle->DIMTFILLCLR)))
        pass ();
    else
        fail ("DIMSTYLE.DIMTFILLCLR [CMC]");
  }
  {
    BITCODE_B DIMTIH;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTIH", &DIMTIH, NULL)
        && DIMTIH == dimstyle->DIMTIH)
      pass ();
    else
      fail ("DIMSTYLE.DIMTIH [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTIH, DIMTIH);
    DIMTIH++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTIH", &DIMTIH, 0)
        && DIMTIH == dimstyle->DIMTIH)
      pass ();
    else
      fail ("DIMSTYLE.DIMTIH [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTIH, DIMTIH);
    dimstyle->DIMTIH--;

  }
  {
    BITCODE_B DIMTIX;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTIX", &DIMTIX, NULL)
        && DIMTIX == dimstyle->DIMTIX)
      pass ();
    else
      fail ("DIMSTYLE.DIMTIX [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTIX, DIMTIX);
    DIMTIX++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTIX", &DIMTIX, 0)
        && DIMTIX == dimstyle->DIMTIX)
      pass ();
    else
      fail ("DIMSTYLE.DIMTIX [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTIX, DIMTIX);
    dimstyle->DIMTIX--;

  }
  {
    BITCODE_BD DIMTM;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTM", &DIMTM, NULL)
        && DIMTM == dimstyle->DIMTM)
      pass ();
    else
      fail ("DIMSTYLE.DIMTM [BD] %g != %g", dimstyle->DIMTM, DIMTM);
    DIMTM++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTM", &DIMTM, 0)
        && DIMTM == dimstyle->DIMTM)
      pass ();
    else
      fail ("DIMSTYLE.DIMTM [BD] set+1 %g != %g", dimstyle->DIMTM, DIMTM);
    dimstyle->DIMTM--;

  }
  {
    BITCODE_BS DIMTMOVE;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTMOVE", &DIMTMOVE, NULL)
        && DIMTMOVE == dimstyle->DIMTMOVE)
      pass ();
    else
      fail ("DIMSTYLE.DIMTMOVE [BS] %hu != %hu", dimstyle->DIMTMOVE, DIMTMOVE);
    DIMTMOVE++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTMOVE", &DIMTMOVE, 0)
        && DIMTMOVE == dimstyle->DIMTMOVE)
      pass ();
    else
      fail ("DIMSTYLE.DIMTMOVE [BS] set+1 %hu != %hu", dimstyle->DIMTMOVE, DIMTMOVE);
    dimstyle->DIMTMOVE--;

  }
  {
    BITCODE_B DIMTOFL;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTOFL", &DIMTOFL, NULL)
        && DIMTOFL == dimstyle->DIMTOFL)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOFL [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTOFL, DIMTOFL);
    DIMTOFL++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTOFL", &DIMTOFL, 0)
        && DIMTOFL == dimstyle->DIMTOFL)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOFL [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTOFL, DIMTOFL);
    dimstyle->DIMTOFL--;

  }
  {
    BITCODE_B DIMTOH;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTOH", &DIMTOH, NULL)
        && DIMTOH == dimstyle->DIMTOH)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOH [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTOH, DIMTOH);
    DIMTOH++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTOH", &DIMTOH, 0)
        && DIMTOH == dimstyle->DIMTOH)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOH [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTOH, DIMTOH);
    dimstyle->DIMTOH--;

  }
  {
    BITCODE_B DIMTOL;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTOL", &DIMTOL, NULL)
        && DIMTOL == dimstyle->DIMTOL)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOL [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTOL, DIMTOL);
    DIMTOL++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTOL", &DIMTOL, 0)
        && DIMTOL == dimstyle->DIMTOL)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOL [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTOL, DIMTOL);
    dimstyle->DIMTOL--;

  }
  {
    BITCODE_BS DIMTOLJ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTOLJ", &DIMTOLJ, NULL)
        && DIMTOLJ == dimstyle->DIMTOLJ)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOLJ [BS] %hu != %hu", dimstyle->DIMTOLJ, DIMTOLJ);
    DIMTOLJ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTOLJ", &DIMTOLJ, 0)
        && DIMTOLJ == dimstyle->DIMTOLJ)
      pass ();
    else
      fail ("DIMSTYLE.DIMTOLJ [BS] set+1 %hu != %hu", dimstyle->DIMTOLJ, DIMTOLJ);
    dimstyle->DIMTOLJ--;

  }
  {
    BITCODE_BD DIMTP;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTP", &DIMTP, NULL)
        && DIMTP == dimstyle->DIMTP)
      pass ();
    else
      fail ("DIMSTYLE.DIMTP [BD] %g != %g", dimstyle->DIMTP, DIMTP);
    DIMTP++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTP", &DIMTP, 0)
        && DIMTP == dimstyle->DIMTP)
      pass ();
    else
      fail ("DIMSTYLE.DIMTP [BD] set+1 %g != %g", dimstyle->DIMTP, DIMTP);
    dimstyle->DIMTP--;

  }
  {
    BITCODE_BD DIMTSZ;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTSZ", &DIMTSZ, NULL)
        && DIMTSZ == dimstyle->DIMTSZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMTSZ [BD] %g != %g", dimstyle->DIMTSZ, DIMTSZ);
    DIMTSZ++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTSZ", &DIMTSZ, 0)
        && DIMTSZ == dimstyle->DIMTSZ)
      pass ();
    else
      fail ("DIMSTYLE.DIMTSZ [BD] set+1 %g != %g", dimstyle->DIMTSZ, DIMTSZ);
    dimstyle->DIMTSZ--;

  }
  {
    BITCODE_BD DIMTVP;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTVP", &DIMTVP, NULL)
        && DIMTVP == dimstyle->DIMTVP)
      pass ();
    else
      fail ("DIMSTYLE.DIMTVP [BD] %g != %g", dimstyle->DIMTVP, DIMTVP);
    DIMTVP++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTVP", &DIMTVP, 0)
        && DIMTVP == dimstyle->DIMTVP)
      pass ();
    else
      fail ("DIMSTYLE.DIMTVP [BD] set+1 %g != %g", dimstyle->DIMTVP, DIMTVP);
    dimstyle->DIMTVP--;

  }
  {
    BITCODE_H DIMTXSTY;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTXSTY", &DIMTXSTY, NULL)
        && !memcmp (&DIMTXSTY, &dimstyle->DIMTXSTY, sizeof (dimstyle->DIMTXSTY)))
        pass ();
    else
        fail ("DIMSTYLE.DIMTXSTY [H]");
  }
  {
    BITCODE_BD DIMTXT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTXT", &DIMTXT, NULL)
        && DIMTXT == dimstyle->DIMTXT)
      pass ();
    else
      fail ("DIMSTYLE.DIMTXT [BD] %g != %g", dimstyle->DIMTXT, DIMTXT);
    DIMTXT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTXT", &DIMTXT, 0)
        && DIMTXT == dimstyle->DIMTXT)
      pass ();
    else
      fail ("DIMSTYLE.DIMTXT [BD] set+1 %g != %g", dimstyle->DIMTXT, DIMTXT);
    dimstyle->DIMTXT--;

  }
  {
    BITCODE_B DIMTXTDIRECTION;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTXTDIRECTION", &DIMTXTDIRECTION, NULL)
        && DIMTXTDIRECTION == dimstyle->DIMTXTDIRECTION)
      pass ();
    else
      fail ("DIMSTYLE.DIMTXTDIRECTION [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTXTDIRECTION, DIMTXTDIRECTION);
    DIMTXTDIRECTION++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTXTDIRECTION", &DIMTXTDIRECTION, 0)
        && DIMTXTDIRECTION == dimstyle->DIMTXTDIRECTION)
      pass ();
    else
      fail ("DIMSTYLE.DIMTXTDIRECTION [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMTXTDIRECTION, DIMTXTDIRECTION);
    dimstyle->DIMTXTDIRECTION--;

  }
  {
    BITCODE_BS DIMTZIN;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMTZIN", &DIMTZIN, NULL)
        && DIMTZIN == dimstyle->DIMTZIN)
      pass ();
    else
      fail ("DIMSTYLE.DIMTZIN [BS] %hu != %hu", dimstyle->DIMTZIN, DIMTZIN);
    DIMTZIN++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMTZIN", &DIMTZIN, 0)
        && DIMTZIN == dimstyle->DIMTZIN)
      pass ();
    else
      fail ("DIMSTYLE.DIMTZIN [BS] set+1 %hu != %hu", dimstyle->DIMTZIN, DIMTZIN);
    dimstyle->DIMTZIN--;

  }
  {
    BITCODE_BS DIMUNIT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMUNIT", &DIMUNIT, NULL)
        && DIMUNIT == dimstyle->DIMUNIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMUNIT [BS] %hu != %hu", dimstyle->DIMUNIT, DIMUNIT);
    DIMUNIT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMUNIT", &DIMUNIT, 0)
        && DIMUNIT == dimstyle->DIMUNIT)
      pass ();
    else
      fail ("DIMSTYLE.DIMUNIT [BS] set+1 %hu != %hu", dimstyle->DIMUNIT, DIMUNIT);
    dimstyle->DIMUNIT--;

  }
  {
    BITCODE_B DIMUPT;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMUPT", &DIMUPT, NULL)
        && DIMUPT == dimstyle->DIMUPT)
      pass ();
    else
      fail ("DIMSTYLE.DIMUPT [B] " FORMAT_B " != " FORMAT_B "", dimstyle->DIMUPT, DIMUPT);
    DIMUPT++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMUPT", &DIMUPT, 0)
        && DIMUPT == dimstyle->DIMUPT)
      pass ();
    else
      fail ("DIMSTYLE.DIMUPT [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->DIMUPT, DIMUPT);
    dimstyle->DIMUPT--;

  }
  {
    BITCODE_BS DIMZIN;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "DIMZIN", &DIMZIN, NULL)
        && DIMZIN == dimstyle->DIMZIN)
      pass ();
    else
      fail ("DIMSTYLE.DIMZIN [BS] %hu != %hu", dimstyle->DIMZIN, DIMZIN);
    DIMZIN++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "DIMZIN", &DIMZIN, 0)
        && DIMZIN == dimstyle->DIMZIN)
      pass ();
    else
      fail ("DIMSTYLE.DIMZIN [BS] set+1 %hu != %hu", dimstyle->DIMZIN, DIMZIN);
    dimstyle->DIMZIN--;

  }
  {
    BITCODE_H extref_handle;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "extref_handle", &extref_handle, NULL)
        && !memcmp (&extref_handle, &dimstyle->extref_handle, sizeof (dimstyle->extref_handle)))
        pass ();
    else
        fail ("DIMSTYLE.extref_handle [H]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "flag", &flag, NULL)
        && flag == dimstyle->flag)
      pass ();
    else
      fail ("DIMSTYLE.flag [RC] %u != %u", dimstyle->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "flag", &flag, 0)
        && flag == dimstyle->flag)
      pass ();
    else
      fail ("DIMSTYLE.flag [RC] set+1 %u != %u", dimstyle->flag, flag);
    dimstyle->flag--;

  }
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)dimstyle->name)
           : !dimstyle->name)
      pass ();
    else
      fail ("DIMSTYLE.name [TV] '%s' <> '%s'", name, dimstyle->name);
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "parent", &parent, NULL)
        && !memcmp (&parent, &dimstyle->parent, sizeof (dimstyle->parent)))
        pass ();
    else
        fail ("DIMSTYLE.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_RS used;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "used", &used, NULL)
        && used == dimstyle->used)
      pass ();
    else
      fail ("DIMSTYLE.used [RS] %hu != %hu", dimstyle->used, used);
    used++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "used", &used, 0)
        && used == dimstyle->used)
      pass ();
    else
      fail ("DIMSTYLE.used [RS] set+1 %hu != %hu", dimstyle->used, used);
    dimstyle->used--;

  }
  {
    BITCODE_B xrefdep;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "xrefdep", &xrefdep, NULL)
        && xrefdep == dimstyle->xrefdep)
      pass ();
    else
      fail ("DIMSTYLE.xrefdep [B] " FORMAT_B " != " FORMAT_B "", dimstyle->xrefdep, xrefdep);
    xrefdep++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "xrefdep", &xrefdep, 0)
        && xrefdep == dimstyle->xrefdep)
      pass ();
    else
      fail ("DIMSTYLE.xrefdep [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->xrefdep, xrefdep);
    dimstyle->xrefdep--;

  }
  {
    BITCODE_BS xrefindex_plus1;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "xrefindex_plus1", &xrefindex_plus1, NULL)
        && xrefindex_plus1 == dimstyle->xrefindex_plus1)
      pass ();
    else
      fail ("DIMSTYLE.xrefindex_plus1 [BS] %hu != %hu", dimstyle->xrefindex_plus1, xrefindex_plus1);
    xrefindex_plus1++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "xrefindex_plus1", &xrefindex_plus1, 0)
        && xrefindex_plus1 == dimstyle->xrefindex_plus1)
      pass ();
    else
      fail ("DIMSTYLE.xrefindex_plus1 [BS] set+1 %hu != %hu", dimstyle->xrefindex_plus1, xrefindex_plus1);
    dimstyle->xrefindex_plus1--;

  }
  {
    BITCODE_B xrefref;
    if (dwg_dynapi_entity_value (dimstyle, "DIMSTYLE", "xrefref", &xrefref, NULL)
        && xrefref == dimstyle->xrefref)
      pass ();
    else
      fail ("DIMSTYLE.xrefref [B] " FORMAT_B " != " FORMAT_B "", dimstyle->xrefref, xrefref);
    xrefref++;
    if (dwg_dynapi_entity_set_value (dimstyle, "DIMSTYLE", "xrefref", &xrefref, 0)
        && xrefref == dimstyle->xrefref)
      pass ();
    else
      fail ("DIMSTYLE.xrefref [B] set+1 " FORMAT_B " != " FORMAT_B "", dimstyle->xrefref, xrefref);
    dimstyle->xrefref--;

  }
  return failed;
}
static int test_DIMSTYLE_CONTROL (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_DIMSTYLE_CONTROL *restrict dimstyle_control = obj->tio.object->tio.DIMSTYLE_CONTROL;
  {
    BITCODE_H* entries;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (dimstyle_control, "DIMSTYLE_CONTROL", "num_entries", &count, NULL)
        && dwg_dynapi_entity_value (dimstyle_control, "DIMSTYLE_CONTROL", "entries", &entries, NULL)
        && entries == dimstyle_control->entries)
      pass ();
    else
      fail ("DIMSTYLE_CONTROL.entries [H*] * %u num_entries", count);
  }
  {
    BITCODE_H* morehandles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (dimstyle_control, "DIMSTYLE_CONTROL", "num_morehandles", &count, NULL)
        && dwg_dynapi_entity_value (dimstyle_control, "DIMSTYLE_CONTROL", "morehandles", &morehandles, NULL)
        &&