/* ex: set ro ft=c: -*- mode: c; buffer-read-only: t -*- */
#line 1141 "gen-dynapi.pl"
/*****************************************************************************/
/*  LibreDWG - free implementation of the DWG file format                    */
/*                                                                           */
/*  Copyright (C) 2018-2019 Free Software Foundation, Inc.                   */
/*                                                                           */
/*  This library is free software, licensed under the terms of the GNU       */
/*  General Public License as published by the Free Software Foundation,     */
/*  either version 3 of the License, or (at your option) any later version.  */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.    */
/*****************************************************************************/

/*
 * dynapi.c: dynamic access to all object and field names and types
 * written by Reini Urban
 * generated by src/gen-dynapi.pl from include/dwg.h, do not modify.
 */

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include "common.h"
#include "dynapi.h"
#define DWG_LOGLEVEL loglevel
#include "logging.h"
#include "decode.h"
#include "dwg.h"
#include "bits.h"
  
#ifndef _DWG_API_H_
Dwg_Object *dwg_obj_generic_to_object (const void *restrict obj,
                                       int *restrict error);
#endif

#define MAXLEN_ENTITIES 19
#define MAXLEN_OBJECTS 30

/* sorted for bsearch. from typedef struct _dwg_entity_*: */
static const char dwg_entity_names[][MAXLEN_ENTITIES] = {
  "3DFACE" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 0 */
  "3DSOLID" "\0\0\0\0\0\0\0\0\0\0\0",	/* 1 */
  "ARC" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 2 */
  "ARC_DIMENSION" "\0\0\0\0\0",	/* 3 */
  "ATTDEF" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 4 */
  "ATTRIB" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 5 */
  "BLOCK" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 6 */
  "BODY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 7 */
  "CAMERA" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 8 */
  "CIRCLE" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 9 */
  "DIMENSION_ALIGNED" "\0",	/* 10 */
  "DIMENSION_ANG2LN" "\0\0",	/* 11 */
  "DIMENSION_ANG3PT" "\0\0",	/* 12 */
  "DIMENSION_DIAMETER" "",	/* 13 */
  "DIMENSION_LINEAR" "\0\0",	/* 14 */
  "DIMENSION_ORDINATE" "",	/* 15 */
  "DIMENSION_RADIUS" "\0\0",	/* 16 */
  "ELLIPSE" "\0\0\0\0\0\0\0\0\0\0\0",	/* 17 */
  "ENDBLK" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 18 */
  "EXTRUDEDSURFACE" "\0\0\0",	/* 19 */
  "GEOPOSITIONMARKER" "\0",	/* 20 */
  "HATCH" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 21 */
  "HELIX" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 22 */
  "IMAGE" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 23 */
  "INSERT" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 24 */
  "LEADER" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 25 */
  "LIGHT" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 26 */
  "LINE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 27 */
  "LOFTEDSURFACE" "\0\0\0\0\0",	/* 28 */
  "LWPOLYLINE" "\0\0\0\0\0\0\0\0",	/* 29 */
  "MESH" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 30 */
  "MINSERT" "\0\0\0\0\0\0\0\0\0\0\0",	/* 31 */
  "MLINE" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 32 */
  "MTEXT" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 33 */
  "MULTILEADER" "\0\0\0\0\0\0\0",	/* 34 */
  "OLE2FRAME" "\0\0\0\0\0\0\0\0\0",	/* 35 */
  "OLEFRAME" "\0\0\0\0\0\0\0\0\0\0",	/* 36 */
  "PLANESURFACE" "\0\0\0\0\0\0",	/* 37 */
  "POINT" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 38 */
  "POLYLINE_2D" "\0\0\0\0\0\0\0",	/* 39 */
  "POLYLINE_3D" "\0\0\0\0\0\0\0",	/* 40 */
  "POLYLINE_MESH" "\0\0\0\0\0",	/* 41 */
  "POLYLINE_PFACE" "\0\0\0\0",	/* 42 */
  "PROXY_ENTITY" "\0\0\0\0\0\0",	/* 43 */
  "PROXY_LWPOLYLINE" "\0\0",	/* 44 */
  "RAY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 45 */
  "REGION" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 46 */
  "REVOLVEDSURFACE" "\0\0\0",	/* 47 */
  "SEQEND" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 48 */
  "SHAPE" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 49 */
  "SOLID" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 50 */
  "SPLINE" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 51 */
  "SWEPTSURFACE" "\0\0\0\0\0\0",	/* 52 */
  "TABLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 53 */
  "TEXT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 54 */
  "TOLERANCE" "\0\0\0\0\0\0\0\0\0",	/* 55 */
  "TRACE" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 56 */
  "UNDERLAY" "\0\0\0\0\0\0\0\0\0\0",	/* 57 */
  "UNKNOWN_ENT" "\0\0\0\0\0\0\0",	/* 58 */
  "VERTEX_2D" "\0\0\0\0\0\0\0\0\0",	/* 59 */
  "VERTEX_3D" "\0\0\0\0\0\0\0\0\0",	/* 60 */
  "VERTEX_PFACE_FACE" "\0",	/* 61 */
  "VIEWPORT" "\0\0\0\0\0\0\0\0\0\0",	/* 62 */
  "WIPEOUT" "\0\0\0\0\0\0\0\0\0\0\0",	/* 63 */
  "XLINE" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 64 */

};
/* sorted for bsearch. from typedef struct _dwg_object_*: */
static const char dwg_object_names[][MAXLEN_OBJECTS] = {
  "ACSH_SWEEP_CLASS" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 0 */
  "ANNOTSCALEOBJECTCONTEXTDATA" "\0\0",	/* 1 */
  "APPID" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 2 */
  "APPID_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 3 */
  "ASSOC2DCONSTRAINTGROUP" "\0\0\0\0\0\0\0",	/* 4 */
  "ASSOCACTION" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 5 */
  "ASSOCALIGNEDDIMACTIONBODY" "\0\0\0\0",	/* 6 */
  "ASSOCDEPENDENCY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 7 */
  "ASSOCNETWORK" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 8 */
  "ASSOCOSNAPPOINTREFACTIONPARAM" "",	/* 9 */
  "ASSOCPERSSUBENTMANAGER" "\0\0\0\0\0\0\0",	/* 10 */
  "ASSOCPLANESURFACEACTIONBODY" "\0\0",	/* 11 */
  "BLOCK_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 12 */
  "BLOCK_HEADER" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 13 */
  "CELLSTYLEMAP" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 14 */
  "DATATABLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 15 */
  "DBCOLOR" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 16 */
  "DICTIONARY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 17 */
  "DICTIONARYVAR" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 18 */
  "DICTIONARYWDFLT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 19 */
  "DIMASSOC" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 20 */
  "DIMSTYLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 21 */
  "DIMSTYLE_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 22 */
  "DUMMY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 23 */
  "DYNAMICBLOCKPURGEPREVENTER" "\0\0\0",	/* 24 */
  "EVALUATION_GRAPH" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 25 */
  "FIELD" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 26 */
  "FIELDLIST" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 27 */
  "GEODATA" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 28 */
  "GEOMAPIMAGE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 29 */
  "GROUP" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 30 */
  "IDBUFFER" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 31 */
  "IMAGEDEF" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 32 */
  "IMAGEDEF_REACTOR" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 33 */
  "LAYER" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 34 */
  "LAYER_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 35 */
  "LAYER_INDEX" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 36 */
  "LAYOUT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 37 */
  "LIGHTLIST" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 38 */
  "LONG_TRANSACTION" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 39 */
  "LTYPE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 40 */
  "LTYPE_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 41 */
  "MATERIAL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 42 */
  "MLEADERSTYLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 43 */
  "MLINESTYLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 44 */
  "NAVISWORKSMODELDEF" "\0\0\0\0\0\0\0\0\0\0\0",	/* 45 */
  "OBJECTCONTEXTDATA" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 46 */
  "OBJECT_PTR" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 47 */
  "PERSSUBENTMANAGER" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 48 */
  "PLACEHOLDER" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 49 */
  "PLOTSETTINGS" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 50 */
  "PROXY_OBJECT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 51 */
  "RASTERVARIABLES" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 52 */
  "RENDERENVIRONMENT" "\0\0\0\0\0\0\0\0\0\0\0\0",	/* 53 */
  "RENDERGLOBAL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 54 */
  "SCALE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 55 */
  "SORTENTSTABLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 56 */
  "SPATIAL_FILTER" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 57 */
  "SPATIAL_INDEX" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 58 */
  "STYLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 59 */
  "STYLE_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 60 */
  "SUN" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 61 */
  "SUNSTUDY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 62 */
  "TABLECONTENT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 63 */
  "TABLEGEOMETRY" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 64 */
  "TABLESTYLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 65 */
  "UCS" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 66 */
  "UCS_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 67 */
  "UNDERLAYDEFINITION" "\0\0\0\0\0\0\0\0\0\0\0",	/* 68 */
  "UNKNOWN_OBJ" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 69 */
  "VBA_PROJECT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 70 */
  "VIEW" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 71 */
  "VIEW_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 72 */
  "VISUALSTYLE" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 73 */
  "VPORT" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 74 */
  "VPORT_CONTROL" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 75 */
  "VPORT_ENTITY_CONTROL" "\0\0\0\0\0\0\0\0\0",	/* 76 */
  "VPORT_ENTITY_HEADER" "\0\0\0\0\0\0\0\0\0\0",	/* 77 */
  "WIPEOUTVARIABLES" "\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 78 */
  "XRECORD" "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",	/* 79 */

};

/* from typedef struct _dwg_header_variables: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_header_variables_fields[] = {
  { "ACADMAINTVER",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, ACADMAINTVER),
    0,0,0, 90 },
  { "ANGBASE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, ANGBASE),
    0,0,0, 50 },
  { "ANGDIR",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ANGDIR),
    0,0,0, 70 },
  { "APPID_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, APPID_CONTROL_OBJECT),
    1,0,0, 0 },
  { "ATTDIA",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ATTDIA),
    0,0,0, 70 },
  { "ATTMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, ATTMODE),
    0,0,0, 70 },
  { "ATTREQ",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ATTREQ),
    0,0,0, 70 },
  { "AUNITS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, AUNITS),
    0,0,0, 70 },
  { "AUPREC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, AUPREC),
    0,0,0, 70 },
  { "BLIPMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, BLIPMODE),
    0,0,0, 0 },
  { "BLOCK_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, BLOCK_CONTROL_OBJECT),
    1,0,0, 0 },
  { "BLOCK_RECORD_MSPACE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, BLOCK_RECORD_MSPACE),
    1,0,0, 0 },
  { "BLOCK_RECORD_PSPACE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, BLOCK_RECORD_PSPACE),
    1,0,0, 0 },
  { "CAMERADISPLAY",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, CAMERADISPLAY),
    0,0,0, 290 },
  { "CAMERAHEIGHT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CAMERAHEIGHT),
    0,0,0, 40 },
  { "CECOLOR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, CECOLOR),
    1,0,0, 62 },
  { "CELTSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CELTSCALE),
    0,0,0, 40 },
  { "CELTYPE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CELTYPE),
    1,0,0, 6 },
  { "CELWEIGHT",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_header_variables, CELWEIGHT),
    0,0,0, 0 },
  { "CEPSNTYPE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, CEPSNTYPE),
    0,0,0, 380 },
  { "CHAMFERA",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERA),
    0,0,0, 40 },
  { "CHAMFERB",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERB),
    0,0,0, 40 },
  { "CHAMFERC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERC),
    0,0,0, 40 },
  { "CHAMFERD",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERD),
    0,0,0, 40 },
  { "CLAYER",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CLAYER),
    1,0,0, 8 },
  { "CMATERIAL",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CMATERIAL),
    1,0,0, 347 },
  { "CMLJUST",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, CMLJUST),
    0,0,0, 70 },
  { "CMLSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CMLSCALE),
    0,0,0, 40 },
  { "CMLSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CMLSTYLE),
    1,0,0, 2 },
  { "COORDS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, COORDS),
    0,0,0, 70 },
  { "CPSNID",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CPSNID),
    1,0,0, 390 },
  { "CSHADOW",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, CSHADOW),
    0,0,0, 280 },
  { "DELOBJ",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DELOBJ),
    0,0,0, 70 },
  { "DGNFRAME",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, DGNFRAME),
    0,0,0, 280 },
  { "DICTIONARY_ACAD_GROUP",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_ACAD_GROUP),
    1,0,0, 0 },
  { "DICTIONARY_ACAD_MLINESTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_ACAD_MLINESTYLE),
    1,0,0, 0 },
  { "DICTIONARY_COLOR",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_COLOR),
    1,0,0, 0 },
  { "DICTIONARY_LAYOUT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_LAYOUT),
    1,0,0, 0 },
  { "DICTIONARY_LIGHTLIST",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_LIGHTLIST),
    1,0,0, 0 },
  { "DICTIONARY_MATERIAL",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_MATERIAL),
    1,0,0, 0 },
  { "DICTIONARY_NAMED_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_NAMED_OBJECT),
    1,0,0, 0 },
  { "DICTIONARY_PLOTSETTINGS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_PLOTSETTINGS),
    1,0,0, 0 },
  { "DICTIONARY_PLOTSTYLENAME",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_PLOTSTYLENAME),
    1,0,0, 0 },
  { "DICTIONARY_VISUALSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_VISUALSTYLE),
    1,0,0, 0 },
  { "DIMADEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMADEC),
    0,0,0, 70 },
  { "DIMALT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMALT),
    0,0,0, 70 },
  { "DIMALTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTD),
    0,0,0, 70 },
  { "DIMALTF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMALTF),
    0,0,0, 40 },
  { "DIMALTMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMALTMZF),
    0,0,0, 0 },
  { "DIMALTMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMALTMZS),
    1,1,1, 0 },
  { "DIMALTRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMALTRND),
    0,0,0, 40 },
  { "DIMALTTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTTD),
    0,0,0, 70 },
  { "DIMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTTZ),
    0,0,0, 70 },
  { "DIMALTU",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTU),
    0,0,0, 70 },
  { "DIMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTZ),
    0,0,0, 70 },
  { "DIMAPOST",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, DIMAPOST),
    1,1,1, 1 },
  { "DIMAPOST_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMAPOST_T),
    1,1,1, 0 },
  { "DIMARCSYM",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMARCSYM),
    0,0,0, 70 },
  { "DIMASO",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMASO),
    0,0,0, 70 },
  { "DIMASSOC",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, DIMASSOC),
    0,0,0, 280 },
  { "DIMASZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMASZ),
    0,0,0, 40 },
  { "DIMATFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMATFIT),
    0,0,0, 70 },
  { "DIMAUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMAUNIT),
    0,0,0, 70 },
  { "DIMAZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMAZIN),
    0,0,0, 70 },
  { "DIMBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMBLK),
    1,0,0, 1 },
  { "DIMBLK1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMBLK1),
    1,0,0, 1 },
  { "DIMBLK1_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMBLK1_T),
    1,1,1, 0 },
  { "DIMBLK2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMBLK2),
    1,0,0, 1 },
  { "DIMBLK2_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMBLK2_T),
    1,1,1, 0 },
  { "DIMBLK_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMBLK_T),
    1,1,1, 0 },
  { "DIMCEN",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMCEN),
    0,0,0, 40 },
  { "DIMCLRD",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMCLRD),
    1,0,0, 70 },
  { "DIMCLRD_C",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, DIMCLRD_C),
    0,0,0, 0 },
  { "DIMCLRE",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMCLRE),
    1,0,0, 70 },
  { "DIMCLRE_C",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, DIMCLRE_C),
    0,0,0, 0 },
  { "DIMCLRT",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMCLRT),
    1,0,0, 70 },
  { "DIMCLRT_C",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, DIMCLRT_C),
    0,0,0, 0 },
  { "DIMDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMDEC),
    0,0,0, 70 },
  { "DIMDLE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMDLE),
    0,0,0, 40 },
  { "DIMDLI",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMDLI),
    0,0,0, 40 },
  { "DIMDSEP",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMDSEP),
    0,0,0, 70 },
  { "DIMEXE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMEXE),
    0,0,0, 40 },
  { "DIMEXO",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMEXO),
    0,0,0, 40 },
  { "DIMFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMFIT),
    0,0,0, 70 },
  { "DIMFRAC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMFRAC),
    0,0,0, 70 },
  { "DIMFXL",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMFXL),
    0,0,0, 40 },
  { "DIMFXLON",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMFXLON),
    0,0,0, 70 },
  { "DIMGAP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMGAP),
    0,0,0, 40 },
  { "DIMJOGANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMJOGANG),
    0,0,0, 40 },
  { "DIMJUST",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMJUST),
    0,0,0, 70 },
  { "DIMLDRBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLDRBLK),
    1,0,0, 1 },
  { "DIMLFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMLFAC),
    0,0,0, 40 },
  { "DIMLIM",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMLIM),
    0,0,0, 70 },
  { "DIMLTEX1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLTEX1),
    1,0,0, 6 },
  { "DIMLTEX2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLTEX2),
    1,0,0, 6 },
  { "DIMLTYPE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLTYPE),
    1,0,0, 6 },
  { "DIMLUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMLUNIT),
    0,0,0, 70 },
  { "DIMLWD",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_header_variables, DIMLWD),
    0,0,0, 70 },
  { "DIMLWE",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_header_variables, DIMLWE),
    0,0,0, 70 },
  { "DIMMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMMALTTZ),
    0,0,0, 0 },
  { "DIMMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMMALTZ),
    0,0,0, 0 },
  { "DIMMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMMZF),
    0,0,0, 0 },
  { "DIMMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMMZS),
    1,1,1, 0 },
  { "DIMPOST",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, DIMPOST),
    1,1,1, 1 },
  { "DIMPOST_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMPOST_T),
    1,1,1, 0 },
  { "DIMRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMRND),
    0,0,0, 40 },
  { "DIMSAH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSAH),
    0,0,0, 70 },
  { "DIMSAV",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSAV),
    0,0,0, 70 },
  { "DIMSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMSCALE),
    0,0,0, 40 },
  { "DIMSD1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSD1),
    0,0,0, 70 },
  { "DIMSD2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSD2),
    0,0,0, 70 },
  { "DIMSE1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSE1),
    0,0,0, 70 },
  { "DIMSE2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSE2),
    0,0,0, 70 },
  { "DIMSHO",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSHO),
    0,0,0, 70 },
  { "DIMSOXD",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSOXD),
    0,0,0, 70 },
  { "DIMSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMSTYLE),
    1,0,0, 2 },
  { "DIMSTYLE_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMSTYLE_CONTROL_OBJECT),
    1,0,0, 0 },
  { "DIMTAD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTAD),
    0,0,0, 70 },
  { "DIMTDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTDEC),
    0,0,0, 70 },
  { "DIMTFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTFAC),
    0,0,0, 40 },
  { "DIMTFILL",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTFILL),
    0,0,0, 70 },
  { "DIMTFILLCLR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMTFILLCLR),
    1,0,0, 70 },
  { "DIMTIH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTIH),
    0,0,0, 70 },
  { "DIMTIX",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTIX),
    0,0,0, 70 },
  { "DIMTM",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTM),
    0,0,0, 40 },
  { "DIMTMOVE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTMOVE),
    0,0,0, 70 },
  { "DIMTOFL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTOFL),
    0,0,0, 70 },
  { "DIMTOH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTOH),
    0,0,0, 70 },
  { "DIMTOL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTOL),
    0,0,0, 70 },
  { "DIMTOLJ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTOLJ),
    0,0,0, 70 },
  { "DIMTP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTP),
    0,0,0, 40 },
  { "DIMTSZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTSZ),
    0,0,0, 40 },
  { "DIMTVP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTVP),
    0,0,0, 40 },
  { "DIMTXSTY",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMTXSTY),
    1,0,0, 7 },
  { "DIMTXT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTXT),
    0,0,0, 40 },
  { "DIMTXTDIRECTION",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTXTDIRECTION),
    0,0,0, 70 },
  { "DIMTZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTZIN),
    0,0,0, 70 },
  { "DIMUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMUNIT),
    0,0,0, 70 },
  { "DIMUPT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMUPT),
    0,0,0, 70 },
  { "DIMZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMZIN),
    0,0,0, 70 },
  { "DISPSILH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DISPSILH),
    0,0,0, 70 },
  { "DRAGMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DRAGMODE),
    0,0,0, 70 },
  { "DRAGVS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DRAGVS),
    1,0,0, 349 },
  { "DWFFRAME",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, DWFFRAME),
    0,0,0, 280 },
  { "DWGCODEPAGE",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, DWGCODEPAGE),
    1,1,1, 3 },
  { "ELEVATION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, ELEVATION),
    0,0,0, 40 },
  { "ENDCAPS",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ENDCAPS),
    0,0,0, 280 },
  { "EXTMAX",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, EXTMAX),
    1,0,0, 30 },
  { "EXTMIN",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, EXTMIN),
    1,0,0, 30 },
  { "EXTNAMES",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, EXTNAMES),
    0,0,0, 290 },
  { "FACETRES",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, FACETRES),
    0,0,0, 0 },
  { "FILLETRAD",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, FILLETRAD),
    0,0,0, 40 },
  { "FILLMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, FILLMODE),
    0,0,0, 70 },
  { "FINGERPRINTGUID",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, FINGERPRINTGUID),
    1,1,1, 2 },
  { "FLAGS",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, FLAGS),
    0,0,0, 0 },
  { "GRIDMODE",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, GRIDMODE),
    0,0,0, 0 },
  { "GRIDUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, GRIDUNIT),
    1,0,0, 0 },
  { "HALOGAP",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, HALOGAP),
    0,0,0, 280 },
  { "HANDLING",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, HANDLING),
    0,0,0, 70 },
  { "HANDSEED",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, HANDSEED),
    1,0,0, 5 },
  { "HIDETEXT",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, HIDETEXT),
    0,0,0, 280 },
  { "HYPERLINKBASE",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, HYPERLINKBASE),
    1,1,1, 1 },
  { "INDEXCTL",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, INDEXCTL),
    0,0,0, 280 },
  { "INSBASE",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, INSBASE),
    1,0,0, 30 },
  { "INSUNITS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, INSUNITS),
    0,0,0, 70 },
  { "INTERFERECOLOR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, INTERFERECOLOR),
    1,0,0, 62 },
  { "INTERFEREOBJVS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, INTERFEREOBJVS),
    1,0,0, 345 },
  { "INTERFEREVPVS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, INTERFEREVPVS),
    1,0,0, 346 },
  { "INTERSECTIONCOLOR",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, INTERSECTIONCOLOR),
    0,0,0, 70 },
  { "INTERSECTIONDISPLAY",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, INTERSECTIONDISPLAY),
    0,0,0, 280 },
  { "ISOLINES",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, ISOLINES),
    0,0,0, 0 },
  { "JOINSTYLE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, JOINSTYLE),
    0,0,0, 280 },
  { "LATITUDE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LATITUDE),
    0,0,0, 40 },
  { "LAYER_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LAYER_CONTROL_OBJECT),
    1,0,0, 0 },
  { "LENSLENGTH",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LENSLENGTH),
    0,0,0, 40 },
  { "LIGHTGLYPHDISPLAY",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, LIGHTGLYPHDISPLAY),
    0,0,0, 280 },
  { "LIMCHECK",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, LIMCHECK),
    0,0,0, 70 },
  { "LIMMAX",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, LIMMAX),
    1,0,0, 20 },
  { "LIMMIN",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, LIMMIN),
    1,0,0, 20 },
  { "LOFTANG1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTANG1),
    0,0,0, 40 },
  { "LOFTANG2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTANG2),
    0,0,0, 40 },
  { "LOFTMAG1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTMAG1),
    0,0,0, 40 },
  { "LOFTMAG2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTMAG2),
    0,0,0, 40 },
  { "LOFTNORMALS",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, LOFTNORMALS),
    0,0,0, 280 },
  { "LOFTPARAM",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, LOFTPARAM),
    0,0,0, 70 },
  { "LONGITUDE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LONGITUDE),
    0,0,0, 40 },
  { "LTSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LTSCALE),
    0,0,0, 40 },
  { "LTYPE_BYBLOCK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_BYBLOCK),
    1,0,0, 0 },
  { "LTYPE_BYLAYER",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_BYLAYER),
    1,0,0, 0 },
  { "LTYPE_CONTINUOUS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_CONTINUOUS),
    1,0,0, 0 },
  { "LTYPE_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_CONTROL_OBJECT),
    1,0,0, 0 },
  { "LUNITS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, LUNITS),
    0,0,0, 70 },
  { "LUPREC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, LUPREC),
    0,0,0, 70 },
  { "LWDISPLAY",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, LWDISPLAY),
    0,0,0, 290 },
  { "MAXACTVP",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, MAXACTVP),
    0,0,0, 70 },
  { "MEASUREMENT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, MEASUREMENT),
    0,0,0, 70 },
  { "MENU",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, MENU),
    1,1,1, 1 },
  { "MIRRTEXT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, MIRRTEXT),
    0,0,0, 70 },
  { "NORTHDIRECTION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, NORTHDIRECTION),
    0,0,0, 40 },
  { "OBSCOLOR",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, OBSCOLOR),
    0,0,0, 70 },
  { "OBSLTYPE",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, OBSLTYPE),
    0,0,0, 280 },
  { "OLESTARTUP",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, OLESTARTUP),
    0,0,0, 290 },
  { "ORTHOMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ORTHOMODE),
    0,0,0, 70 },
  { "OSMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, OSMODE),
    0,0,0, 70 },
  { "PDMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PDMODE),
    0,0,0, 70 },
  { "PDSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PDSIZE),
    0,0,0, 40 },
  { "PELEVATION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PELEVATION),
    0,0,0, 40 },
  { "PELLIPSE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PELLIPSE),
    0,0,0, 0 },
  { "PEXTMAX",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PEXTMAX),
    1,0,0, 30 },
  { "PEXTMIN",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PEXTMIN),
    1,0,0, 30 },
  { "PICKSTYLE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PICKSTYLE),
    0,0,0, 70 },
  { "PINSBASE",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PINSBASE),
    1,0,0, 30 },
  { "PLIMCHECK",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PLIMCHECK),
    0,0,0, 70 },
  { "PLIMMAX",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, PLIMMAX),
    1,0,0, 20 },
  { "PLIMMIN",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, PLIMMIN),
    1,0,0, 20 },
  { "PLINEGEN",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PLINEGEN),
    0,0,0, 70 },
  { "PLINEWID",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PLINEWID),
    0,0,0, 40 },
  { "PROJECTNAME",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, PROJECTNAME),
    1,1,1, 1 },
  { "PROXYGRAPHICS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PROXYGRAPHICS),
    0,0,0, 70 },
  { "PSLTSCALE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PSLTSCALE),
    0,0,0, 70 },
  { "PSOLHEIGHT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PSOLHEIGHT),
    0,0,0, 40 },
  { "PSOLWIDTH",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PSOLWIDTH),
    0,0,0, 40 },
  { "PSTYLEMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PSTYLEMODE),
    0,0,0, 290 },
  { "PSVPSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PSVPSCALE),
    0,0,0, 40 },
  { "PUCSBASE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, PUCSBASE),
    1,0,0, 2 },
  { "PUCSNAME",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, PUCSNAME),
    1,0,0, 2 },
  { "PUCSORG",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORG),
    1,0,0, 30 },
  { "PUCSORGBACK",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGBACK),
    1,0,0, 30 },
  { "PUCSORGBOTTOM",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGBOTTOM),
    1,0,0, 30 },
  { "PUCSORGFRONT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGFRONT),
    1,0,0, 30 },
  { "PUCSORGLEFT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGLEFT),
    1,0,0, 30 },
  { "PUCSORGRIGHT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGRIGHT),
    1,0,0, 30 },
  { "PUCSORGTOP",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGTOP),
    1,0,0, 30 },
  { "PUCSORTHOREF",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, PUCSORTHOREF),
    1,0,0, 2 },
  { "PUCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PUCSORTHOVIEW),
    0,0,0, 70 },
  { "PUCSXDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSXDIR),
    1,0,0, 30 },
  { "PUCSYDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSYDIR),
    1,0,0, 30 },
  { "QTEXTMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, QTEXTMODE),
    0,0,0, 70 },
  { "REALWORLDSCALE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, REALWORLDSCALE),
    0,0,0, 290 },
  { "REGENMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, REGENMODE),
    0,0,0, 70 },
  { "REQUIREDVERSIONS",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_header_variables, REQUIREDVERSIONS),
    0,0,0, 160 },
  { "SAVEIMAGES",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SAVEIMAGES),
    0,0,0, 0 },
  { "SHADEDGE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SHADEDGE),
    0,0,0, 70 },
  { "SHADEDIF",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SHADEDIF),
    0,0,0, 70 },
  { "SHADOWPLANELOCATION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, SHADOWPLANELOCATION),
    0,0,0, 40 },
  { "SHOWHIST",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, SHOWHIST),
    0,0,0, 280 },
  { "SKETCHINC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, SKETCHINC),
    0,0,0, 40 },
  { "SKPOLY",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, SKPOLY),
    0,0,0, 70 },
  { "SNAPANG",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_header_variables, SNAPANG),
    0,0,0, 0 },
  { "SNAPBASE",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, SNAPBASE),
    1,0,0, 0 },
  { "SNAPISOPAIR",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, SNAPISOPAIR),
    0,0,0, 0 },
  { "SNAPMODE",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, SNAPMODE),
    0,0,0, 0 },
  { "SNAPSTYL",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, SNAPSTYL),
    0,0,0, 0 },
  { "SNAPUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, SNAPUNIT),
    1,0,0, 0 },
  { "SOLIDHIST",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, SOLIDHIST),
    0,0,0, 280 },
  { "SORTENTS",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, SORTENTS),
    0,0,0, 280 },
  { "SPLFRAME",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, SPLFRAME),
    0,0,0, 70 },
  { "SPLINESEGS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SPLINESEGS),
    0,0,0, 70 },
  { "SPLINETYPE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SPLINETYPE),
    0,0,0, 70 },
  { "STEPSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, STEPSIZE),
    0,0,0, 40 },
  { "STEPSPERSEC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, STEPSPERSEC),
    0,0,0, 40 },
  { "STYLESHEET",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, STYLESHEET),
    1,1,1, 1 },
  { "STYLE_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, STYLE_CONTROL_OBJECT),
    1,0,0, 0 },
  { "SURFTAB1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFTAB1),
    0,0,0, 70 },
  { "SURFTAB2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFTAB2),
    0,0,0, 70 },
  { "SURFTYPE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFTYPE),
    0,0,0, 70 },
  { "SURFU",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFU),
    0,0,0, 70 },
  { "SURFV",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFV),
    0,0,0, 70 },
  { "TDCREATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDCREATE),
    1,0,0, 40 },
  { "TDINDWG",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDINDWG),
    1,0,0, 40 },
  { "TDUCREATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUCREATE),
    1,0,0, 40 },
  { "TDUPDATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUPDATE),
    1,0,0, 40 },
  { "TDUSRTIMER",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUSRTIMER),
    1,0,0, 40 },
  { "TDUUPDATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUUPDATE),
    1,0,0, 40 },
  { "TEXTQLTY",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TEXTQLTY),
    0,0,0, 0 },
  { "TEXTSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, TEXTSIZE),
    0,0,0, 40 },
  { "TEXTSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, TEXTSTYLE),
    1,0,0, 7 },
  { "THICKNESS",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, THICKNESS),
    0,0,0, 40 },
  { "TILEMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, TILEMODE),
    0,0,0, 70 },
  { "TILEMODELIGHTSYNCH",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, TILEMODELIGHTSYNCH),
    0,0,0, 280 },
  { "TIMEZONE",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, TIMEZONE),
    0,0,0, 70 },
  { "TRACEWID",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, TRACEWID),
    0,0,0, 40 },
  { "TREEDEPTH",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TREEDEPTH),
    0,0,0, 70 },
  { "TSTACKALIGN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TSTACKALIGN),
    0,0,0, 0 },
  { "TSTACKSIZE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TSTACKSIZE),
    0,0,0, 0 },
  { "UCSBASE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCSBASE),
    1,0,0, 2 },
  { "UCSNAME",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCSNAME),
    1,0,0, 2 },
  { "UCSORG",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORG),
    1,0,0, 30 },
  { "UCSORGBACK",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGBACK),
    1,0,0, 30 },
  { "UCSORGBOTTOM",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGBOTTOM),
    1,0,0, 30 },
  { "UCSORGFRONT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGFRONT),
    1,0,0, 30 },
  { "UCSORGLEFT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGLEFT),
    1,0,0, 30 },
  { "UCSORGRIGHT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGRIGHT),
    1,0,0, 30 },
  { "UCSORGTOP",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGTOP),
    1,0,0, 30 },
  { "UCSORTHOREF",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCSORTHOREF),
    1,0,0, 2 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, UCSORTHOVIEW),
    0,0,0, 70 },
  { "UCSXDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSXDIR),
    1,0,0, 30 },
  { "UCSYDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSYDIR),
    1,0,0, 30 },
  { "UCS_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCS_CONTROL_OBJECT),
    1,0,0, 0 },
  { "UNITMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, UNITMODE),
    0,0,0, 70 },
  { "USERI1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI1),
    0,0,0, 70 },
  { "USERI2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI2),
    0,0,0, 70 },
  { "USERI3",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI3),
    0,0,0, 70 },
  { "USERI4",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI4),
    0,0,0, 70 },
  { "USERI5",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI5),
    0,0,0, 70 },
  { "USERR1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR1),
    0,0,0, 40 },
  { "USERR2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR2),
    0,0,0, 40 },
  { "USERR3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR3),
    0,0,0, 40 },
  { "USERR4",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR4),
    0,0,0, 40 },
  { "USERR5",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR5),
    0,0,0, 40 },
  { "USRTIMER",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, USRTIMER),
    0,0,0, 70 },
  { "VERSIONGUID",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, VERSIONGUID),
    1,1,1, 2 },
  { "VIEWCTR",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, VIEWCTR),
    1,0,0, 0 },
  { "VIEWSIZE",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_header_variables, VIEWSIZE),
    0,0,0, 0 },
  { "VIEW_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VIEW_CONTROL_OBJECT),
    1,0,0, 0 },
  { "VISRETAIN",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, VISRETAIN),
    0,0,0, 70 },
  { "VPORT_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VPORT_CONTROL_OBJECT),
    1,0,0, 0 },
  { "VPORT_ENTITY_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VPORT_ENTITY_CONTROL_OBJECT),
    1,0,0, 0 },
  { "VPORT_ENTITY_HEADER",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VPORT_ENTITY_HEADER),
    1,0,0, 0 },
  { "WIREFRAME",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, WIREFRAME),
    0,0,0, 0 },
  { "WORLDVIEW",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, WORLDVIEW),
    0,0,0, 70 },
  { "XCLIPFRAME",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, XCLIPFRAME),
    0,0,0, 290 },
  { "XEDIT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, XEDIT),
    0,0,0, 290 },
  { "_3DDWFPREC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, _3DDWFPREC),
    0,0,0, 40 },
  { "bitsize",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_header_variables, bitsize),
    0,0,0, 0 },
  { "bitsize_hi",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_header_variables, bitsize_hi),
    0,0,0, 0 },
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_header_variables, size),
    0,0,0, 0 },
  { "unknown_0",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_0),
    0,0,0, 0 },
  { "unknown_1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_1),
    0,0,0, 0 },
  { "unknown_10",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_10),
    0,0,0, 0 },
  { "unknown_11",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, unknown_11),
    0,0,0, 0 },
  { "unknown_12",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_12),
    0,0,0, 0 },
  { "unknown_13",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_13),
    0,0,0, 0 },
  { "unknown_14",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_14),
    0,0,0, 0 },
  { "unknown_14b",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_14b),
    0,0,0, 0 },
  { "unknown_15",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_15),
    0,0,0, 0 },
  { "unknown_16",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_16),
    0,0,0, 0 },
  { "unknown_17",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_17),
    0,0,0, 0 },
  { "unknown_2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_2),
    0,0,0, 0 },
  { "unknown_20",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, unknown_20),
    1,0,0, 0 },
  { "unknown_21",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_21),
    0,0,0, 0 },
  { "unknown_22",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_22),
    0,0,0, 0 },
  { "unknown_23",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_23),
    0,0,0, 0 },
  { "unknown_3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_3),
    0,0,0, 0 },
  { "unknown_54",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_54),
    0,0,0, 0 },
  { "unknown_55",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_55),
    0,0,0, 0 },
  { "unknown_56",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_56),
    0,0,0, 0 },
  { "unknown_57",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_57),
    0,0,0, 0 },
  { "unknown_8",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_8),
    0,0,0, 0 },
  { "unknown_9",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_9),
    0,0,0, 0 },
  { "unknown_text1",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text1),
    1,1,1, 0 },
  { "unknown_text2",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text2),
    1,1,1, 0 },
  { "unknown_text3",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text3),
    1,1,1, 0 },
  { "unknown_text4",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text4),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_entity_3DFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_3DFACE, parent),
    1,1,0, 0 },
  { "has_no_flags",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DFACE, has_no_flags),
    0,0,0, 0 },
  { "z_is_zero",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DFACE, z_is_zero),
    0,0,0, 0 },
  { "corner1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner1),
    1,0,0, 10 },
  { "corner2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner2),
    1,0,0, 11 },
  { "corner3",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner3),
    1,0,0, 12 },
  { "corner4",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner4),
    1,0,0, 13 },
  { "invis_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_3DFACE, invis_flags),
    0,0,0, 70 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_3DSOLID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_3DSOLID, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_3DSOLID, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_3DSOLID, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_3DSOLID, encr_sat_data),
    1,1,0, 1 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_3DSOLID, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DSOLID, point),
    1,0,0, 0 },
  { "num_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_3DSOLID, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_3DSOLID, silhouettes),
    1,1,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_3DSOLID, extra_acis_data),
    1,1,0, 0 },
  { "unknown_2007",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, unknown_2007),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_3DSOLID, history_id),
    1,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, acis_empty_bit),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ARC: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ARC_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ARC, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC, radius),
    0,0,0, 40 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_ARC, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_ARC, extrusion),
    0,0,0, 210 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC, start_angle),
    0,0,0, 50 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC, end_angle),
    0,0,0, 51 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ARC_DIMENSION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ARC_DIMENSION_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ARC_DIMENSION, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ARC_DIMENSION, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_ARC_DIMENSION, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ARC_DIMENSION, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARC_DIMENSION, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARC_DIMENSION, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_ARC_DIMENSION, clone_ins_pt),
    1,0,0, 12 },
  { "_13_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, _13_pt),
    1,0,0, 13 },
  { "_14_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, _14_pt),
    1,0,0, 14 },
  { "_15_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, _15_pt),
    1,0,0, 15 },
  { "unknown_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, unknown_pt),
    1,0,0, 0 },
  { "_16_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, _16_pt),
    1,0,0, 16 },
  { "_17_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, _17_pt),
    1,0,0, 17 },
  { "leader_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, leader_len),
    0,0,0, 40 },
  { "flag2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, flag2),
    0,0,0, 71 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ARC_DIMENSION, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ARC_DIMENSION, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ATTDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ATTDEF_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ATTDEF, parent),
    1,1,0, 0 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ATTDEF, elevation),
    0,0,0, 30 },
  { "insertion_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTDEF, insertion_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTDEF, alignment_pt),
    1,0,0, 11 },
  { "extrusion",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_ATTDEF, extrusion),
    1,0,0, 210 },
  { "thickness",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, thickness),
    0,0,0, 39 },
  { "oblique_ang",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, oblique_ang),
    0,0,0, 51 },
  { "rotation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, rotation),
    0,0,0, 50 },
  { "height",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, height),
    0,0,0, 40 },
  { "width_factor",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, width_factor),
    0,0,0, 41 },
  { "default_value",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ATTDEF, default_value),
    1,1,1, 1 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, generation),
    0,0,0, 71 },
  { "horiz_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, horiz_alignment),
    0,0,0, 72 },
  { "vert_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, vert_alignment),
    0,0,0, 74 },
  { "dataflags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, dataflags),
    0,0,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, class_version),
    0,0,0, 280 },
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, type),
    0,0,0, 70 },
  { "tag",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ATTDEF, tag),
    1,1,1, 2 },
  { "field_length",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, field_length),
    0,0,0, 0 },
  { "flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, flags),
    0,0,0, 70 },
  { "lock_position_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ATTDEF, lock_position_flag),
    0,0,0, 70 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTDEF, style),
    1,0,0, 7 },
  { "mtext_handles",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTDEF, mtext_handles),
    1,0,0, 340 },
  { "annotative_data_size",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, annotative_data_size),
    0,0,0, 70 },
  { "annotative_data_bytes",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, annotative_data_bytes),
    0,0,0, 0 },
  { "annotative_app",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTDEF, annotative_app),
    1,0,0, 0 },
  { "annotative_short",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, annotative_short),
    0,0,0, 0 },
  { "attdef_class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, attdef_class_version),
    0,0,0, 280 },
  { "prompt",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ATTDEF, prompt),
    1,1,1, 3 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ATTRIB: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ATTRIB_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ATTRIB, parent),
    1,1,0, 0 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ATTRIB, elevation),
    0,0,0, 30 },
  { "insertion_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTRIB, insertion_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTRIB, alignment_pt),
    1,0,0, 11 },
  { "extrusion",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_ATTRIB, extrusion),
    1,0,0, 210 },
  { "thickness",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, thickness),
    0,0,0, 39 },
  { "oblique_ang",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, oblique_ang),
    0,0,0, 51 },
  { "rotation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, rotation),
    0,0,0, 50 },
  { "height",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, height),
    0,0,0, 40 },
  { "width_factor",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, width_factor),
    0,0,0, 41 },
  { "text_value",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ATTRIB, text_value),
    1,1,1, 1 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, generation),
    0,0,0, 71 },
  { "horiz_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, horiz_alignment),
    0,0,0, 72 },
  { "vert_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, vert_alignment),
    0,0,0, 74 },
  { "dataflags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, dataflags),
    0,0,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, class_version),
    0,0,0, 280 },
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, type),
    0,0,0, 70 },
  { "tag",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ATTRIB, tag),
    1,1,1, 2 },
  { "field_length",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, field_length),
    0,0,0, 73 },
  { "flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, flags),
    0,0,0, 70 },
  { "lock_position_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ATTRIB, lock_position_flag),
    0,0,0, 0 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTRIB, style),
    1,0,0, 7 },
  { "mtext_handles",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTRIB, mtext_handles),
    1,0,0, 340 },
  { "annotative_data_size",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, annotative_data_size),
    0,0,0, 70 },
  { "annotative_data_bytes",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, annotative_data_bytes),
    0,0,0, 0 },
  { "annotative_app",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTRIB, annotative_app),
    1,0,0, 0 },
  { "annotative_short",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, annotative_short),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_BLOCK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCK_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_BLOCK, parent),
    1,1,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_BLOCK, name),
    1,1,1, 2 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_CAMERA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CAMERA_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_CAMERA, parent),
    1,1,0, 0 },
  { "view",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_CAMERA, view),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_CIRCLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CIRCLE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_CIRCLE, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_CIRCLE, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_CIRCLE, radius),
    0,0,0, 40 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_CIRCLE, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_CIRCLE, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ALIGNED: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ALIGNED_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, clone_ins_pt),
    1,0,0, 12 },
  { "_13_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, _13_pt),
    1,0,0, 13 },
  { "_14_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, _14_pt),
    1,0,0, 14 },
  { "ext_line_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, ext_line_rotation),
    0,0,0, 0 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ANG2LN: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ANG2LN_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, clone_ins_pt),
    1,0,0, 12 },
  { "_16_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, _16_pt),
    1,0,0, 16 },
  { "_13_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, _13_pt),
    1,0,0, 13 },
  { "_14_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, _14_pt),
    1,0,0, 14 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, first_arc_pt),
    1,0,0, 15 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ANG3PT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ANG3PT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, clone_ins_pt),
    1,0,0, 12 },
  { "_13_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, _13_pt),
    1,0,0, 13 },
  { "_14_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, _14_pt),
    1,0,0, 14 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, first_arc_pt),
    1,0,0, 15 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_DIAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_DIAMETER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, clone_ins_pt),
    1,0,0, 12 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, first_arc_pt),
    1,0,0, 15 },
  { "leader_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, leader_len),
    0,0,0, 40 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_LINEAR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_LINEAR_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_LINEAR, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_LINEAR, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_LINEAR, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_LINEAR, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_LINEAR, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_LINEAR, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_LINEAR, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, clone_ins_pt),
    1,0,0, 12 },
  { "_13_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, _13_pt),
    1,0,0, 13 },
  { "_14_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, _14_pt),
    1,0,0, 14 },
  { "ext_line_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, ext_line_rotation),
    0,0,0, 52 },
  { "dim_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, dim_rotation),
    0,0,0, 50 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_LINEAR, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_LINEAR, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ORDINATE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ORDINATE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, clone_ins_pt),
    1,0,0, 12 },
  { "feature_location_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, feature_location_pt),
    1,0,0, 13 },
  { "leader_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, leader_endpt),
    1,0,0, 14 },
  { "flag2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flag2),
    0,0,0, 70 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_RADIUS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_RADIUS_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_RADIUS, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_RADIUS, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_RADIUS, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_RADIUS, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_RADIUS, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_RADIUS, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_RADIUS, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, clone_ins_pt),
    1,0,0, 12 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, first_arc_pt),
    1,0,0, 15 },
  { "leader_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, leader_len),
    0,0,0, 40 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_RADIUS, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_RADIUS, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ELLIPSE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ELLIPSE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ELLIPSE, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ELLIPSE, center),
    1,0,0, 10 },
  { "sm_axis",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ELLIPSE, sm_axis),
    1,0,0, 11 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ELLIPSE, extrusion),
    1,0,0, 210 },
  { "axis_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ELLIPSE, axis_ratio),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ELLIPSE, start_angle),
    0,0,0, 41 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ELLIPSE, end_angle),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ENDBLK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ENDBLK_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ENDBLK, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_EXTRUDEDSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EXTRUDEDSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, version),
    0,0,0, 0 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, encr_sat_data),
    1,1,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, point),
    1,0,0, 0 },
  { "num_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, silhouettes),
    1,1,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "unknown_2007",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, unknown_2007),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, history_id),
    1,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, modeler_format_version),
    0,0,0, 0 },
  { "size_bindata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, size_bindata),
    0,0,0, 0 },
  { "bindata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, bindata),
    1,1,0, 0 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, class_version),
    0,0,0, 90 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, height),
    0,0,0, 0 },
  { "sweep_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_vector),
    1,0,0, 10 },
  { "sweep_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_transmatrix),
    1,1,0, 40 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, draft_angle),
    0,0,0, 42 },
  { "draft_start_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, draft_start_distance),
    0,0,0, 43 },
  { "draft_end_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, draft_end_distance),
    0,0,0, 44 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, twist_angle),
    0,0,0, 45 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, scale_factor),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, align_angle),
    0,0,0, 49 },
  { "sweep_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_entity_transmatrix),
    1,1,0, 46 },
  { "path_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_entity_transmatrix),
    1,1,0, 47 },
  { "solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, solid),
    0,0,0, 290 },
  { "sweep_alignment_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_alignment_flags),
    0,0,0, 290 },
  { "align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, align_start),
    0,0,0, 292 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, bank),
    0,0,0, 293 },
  { "base_point_set",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, base_point_set),
    0,0,0, 294 },
  { "sweep_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_entity_transform_computed),
    0,0,0, 295 },
  { "path_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_entity_transform_computed),
    0,0,0, 296 },
  { "reference_vector_for_controlling_twist",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, reference_vector_for_controlling_twist),
    1,0,0, 11 },
  { "sweep_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_entity),
    1,0,0, 0 },
  { "path_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_entity),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_GEOPOSITIONMARKER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEOPOSITIONMARKER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, type),
    0,0,0, 0 },
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, position),
    1,0,0, 10 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, extrusion),
    1,0,0, 210 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, radius),
    0,0,0, 40 },
  { "landing_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, landing_gap),
    0,0,0, 0 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, text),
    1,1,1, 1 },
  { "text_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, text_alignment),
    0,0,0, 0 },
  { "mtext_visible",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, mtext_visible),
    0,0,0, 0 },
  { "enable_frame_text",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, enable_frame_text),
    0,0,0, 0 },
  { "notes",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, notes),
    1,1,1, 0 },
  { "mtext_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, mtext_handle),
    1,0,0, 0 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, text_style),
    1,0,0, 7 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_HATCH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_HATCH, parent),
    1,1,0, 0 },
  { "is_gradient_fill",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, is_gradient_fill),
    0,0,0, 450 },
  { "reserved",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, reserved),
    0,0,0, 451 },
  { "gradient_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, gradient_angle),
    0,0,0, 460 },
  { "gradient_shift",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, gradient_shift),
    0,0,0, 461 },
  { "single_color_gradient",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, single_color_gradient),
    0,0,0, 452 },
  { "gradient_tint",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, gradient_tint),
    0,0,0, 462 },
  { "num_colors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_colors),
    0,0,0, 453 },
  { "colors",	"Dwg_HATCH_Color*", sizeof (Dwg_HATCH_Color*),  OFF (struct _dwg_entity_HATCH, colors),
    1,1,0, 0 },
  { "gradient_name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_HATCH, gradient_name),
    1,1,1, 470 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, elevation),
    0,0,0, 30 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HATCH, extrusion),
    1,0,0, 210 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_HATCH, name),
    1,1,1, 2 },
  { "solid_fill",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, solid_fill),
    0,0,0, 70 },
  { "associative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, associative),
    0,0,0, 71 },
  { "num_paths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_paths),
    0,0,0, 91 },
  { "paths",	"Dwg_HATCH_Path*", sizeof (Dwg_HATCH_Path*),  OFF (struct _dwg_entity_HATCH, paths),
    1,1,0, 0 },
  { "style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HATCH, style),
    0,0,0, 75 },
  { "pattern_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HATCH, pattern_type),
    0,0,0, 76 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, angle),
    0,0,0, 52 },
  { "scale_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, scale_spacing),
    0,0,0, 41 },
  { "double_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, double_flag),
    0,0,0, 77 },
  { "num_deflines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HATCH, num_deflines),
    0,0,0, 78 },
  { "deflines",	"Dwg_HATCH_DefLine*", sizeof (Dwg_HATCH_DefLine*),  OFF (struct _dwg_entity_HATCH, deflines),
    1,1,0, 0 },
  { "has_derived",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, has_derived),
    0,0,0, 0 },
  { "pixel_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, pixel_size),
    0,0,0, 47 },
  { "num_seeds",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_seeds),
    0,0,0, 98 },
  { "seeds",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_HATCH, seeds),
    1,1,0, 10 },
  { "num_boundary_handles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_boundary_handles),
    0,0,0, 0 },
  { "boundary_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_HATCH, boundary_handles),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_HELIX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HELIX_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_HELIX, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, flag),
    0,0,0, 70 },
  { "scenario",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, scenario),
    0,0,0, 0 },
  { "degree",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, degree),
    0,0,0, 71 },
  { "splineflags1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, splineflags1),
    0,0,0, 0 },
  { "knotparam",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, knotparam),
    0,0,0, 0 },
  { "fit_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, fit_tol),
    0,0,0, 44 },
  { "beg_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, beg_tan_vec),
    1,0,0, 12 },
  { "end_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, end_tan_vec),
    1,0,0, 13 },
  { "rational",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, rational),
    0,0,0, 0 },
  { "closed_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, closed_b),
    0,0,0, 0 },
  { "periodic",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, periodic),
    0,0,0, 0 },
  { "weighted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, weighted),
    0,0,0, 0 },
  { "knot_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, knot_tol),
    0,0,0, 42 },
  { "ctrl_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, ctrl_tol),
    0,0,0, 43 },
  { "num_fit_pts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, num_fit_pts),
    0,0,0, 74 },
  { "fit_pts",	"Dwg_SPLINE_point*", sizeof (Dwg_SPLINE_point*),  OFF (struct _dwg_entity_HELIX, fit_pts),
    1,1,0, 0 },
  { "num_knots",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, num_knots),
    0,0,0, 72 },
  { "knots",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_HELIX, knots),
    1,1,0, 40 },
  { "num_ctrl_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, num_ctrl_pts),
    0,0,0, 73 },
  { "ctrl_pts",	"Dwg_SPLINE_control_point*", sizeof (Dwg_SPLINE_control_point*),  OFF (struct _dwg_entity_HELIX, ctrl_pts),
    1,1,0, 0 },
  { "major_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, major_version),
    0,0,0, 90 },
  { "maint_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, maint_version),
    0,0,0, 91 },
  { "axis_base_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, axis_base_pt),
    1,0,0, 10 },
  { "start_pt",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, start_pt),
    1,0,0, 11 },
  { "axis_vector",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, axis_vector),
    1,0,0, 12 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, radius),
    0,0,0, 40 },
  { "num_turns",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, num_turns),
    0,0,0, 41 },
  { "turn_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, turn_height),
    0,0,0, 43 },
  { "handedness",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, handedness),
    0,0,0, 290 },
  { "constraint_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, constraint_type),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_IMAGE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_IMAGE, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_IMAGE, class_version),
    0,0,0, 90 },
  { "pt0",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_IMAGE, pt0),
    1,0,0, 10 },
  { "uvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_IMAGE, uvec),
    1,0,0, 11 },
  { "vvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_IMAGE, vvec),
    1,0,0, 12 },
  { "size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_IMAGE, size),
    1,0,0, 13 },
  { "display_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_IMAGE, display_props),
    0,0,0, 70 },
  { "clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_IMAGE, clipping),
    0,0,0, 280 },
  { "brightness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_IMAGE, brightness),
    0,0,0, 281 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_IMAGE, contrast),
    0,0,0, 282 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_IMAGE, fade),
    0,0,0, 283 },
  { "clip_mode",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_IMAGE, clip_mode),
    0,0,0, 290 },
  { "clip_boundary_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_IMAGE, clip_boundary_type),
    0,0,0, 71 },
  { "num_clip_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_IMAGE, num_clip_verts),
    0,0,0, 91 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_IMAGE, clip_verts),
    1,1,0, 14 },
  { "imagedef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_IMAGE, imagedef),
    1,0,0, 340 },
  { "imagedefreactor",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_IMAGE, imagedefreactor),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_INSERT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_INSERT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_INSERT, parent),
    1,1,0, 0 },
  { "ins_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_INSERT, ins_pt),
    1,0,0, 10 },
  { "scale_flag",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_entity_INSERT, scale_flag),
    0,0,0, 0 },
  { "scale",	"3BD_1", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_INSERT, scale),
    1,0,0, 41 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_INSERT, rotation),
    0,0,0, 50 },
  { "extrusion",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_INSERT, extrusion),
    1,0,0, 210 },
  { "has_attribs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_INSERT, has_attribs),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_INSERT, num_owned),
    0,0,0, 0 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, block_header),
    1,0,0, 2 },
  { "first_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, first_attrib),
    1,0,0, 0 },
  { "last_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, last_attrib),
    1,0,0, 0 },
  { "attrib_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_INSERT, attrib_handles),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, seqend),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LEADER, parent),
    1,1,0, 0 },
  { "unknown_bit_1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_1),
    0,0,0, 0 },
  { "path_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, path_type),
    0,0,0, 72 },
  { "annot_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, annot_type),
    0,0,0, 73 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LEADER, num_points),
    0,0,0, 76 },
  { "points",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_entity_LEADER, points),
    1,1,0, 10 },
  { "origin",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, origin),
    1,0,0, 0 },
  { "extrusion",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, extrusion),
    1,0,0, 210 },
  { "x_direction",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, x_direction),
    1,0,0, 211 },
  { "offset_to_block_ins_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, offset_to_block_ins_pt),
    1,0,0, 212 },
  { "endptproj",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, endptproj),
    1,0,0, 0 },
  { "dimgap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, dimgap),
    0,0,0, 0 },
  { "box_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, box_height),
    0,0,0, 40 },
  { "box_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, box_width),
    0,0,0, 0 },
  { "hookline_dir",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, hookline_dir),
    0,0,0, 74 },
  { "arrowhead_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, arrowhead_on),
    0,0,0, 71 },
  { "arrowhead_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, arrowhead_type),
    0,0,0, 0 },
  { "dimasz",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, dimasz),
    0,0,0, 0 },
  { "unknown_bit_2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_2),
    0,0,0, 0 },
  { "unknown_bit_3",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_3),
    0,0,0, 0 },
  { "unknown_short_1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, unknown_short_1),
    0,0,0, 0 },
  { "byblock_color",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, byblock_color),
    0,0,0, 77 },
  { "hookline_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, hookline_on),
    0,0,0, 75 },
  { "unknown_bit_5",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_5),
    0,0,0, 0 },
  { "associated_annotation",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LEADER, associated_annotation),
    1,0,0, 340 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LEADER, dimstyle),
    1,0,0, 3 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LIGHT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LIGHT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LIGHT, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LIGHT, class_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_LIGHT, name),
    1,1,1, 1 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, type),
    0,0,0, 70 },
  { "status",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, status),
    0,0,0, 290 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_LIGHT, color),
    1,0,0, 63 },
  { "plot_glyph",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, plot_glyph),
    0,0,0, 291 },
  { "intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, intensity),
    0,0,0, 40 },
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LIGHT, position),
    1,0,0, 10 },
  { "target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LIGHT, target),
    1,0,0, 11 },
  { "attenuation_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, attenuation_type),
    0,0,0, 72 },
  { "use_attenuation_limits",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, use_attenuation_limits),
    0,0,0, 292 },
  { "attenuation_start_limit",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, attenuation_start_limit),
    0,0,0, 41 },
  { "attenuation_end_limit",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, attenuation_end_limit),
    0,0,0, 42 },
  { "hotspot_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, hotspot_angle),
    0,0,0, 50 },
  { "falloff_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, falloff_angle),
    0,0,0, 51 },
  { "cast_shadows",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, cast_shadows),
    0,0,0, 293 },
  { "shadow_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, shadow_type),
    0,0,0, 73 },
  { "shadow_map_size",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, shadow_map_size),
    0,0,0, 91 },
  { "shadow_map_softness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LIGHT, shadow_map_softness),
    0,0,0, 280 },
  { "lights_layer",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LIGHT, lights_layer),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LINE, parent),
    1,1,0, 0 },
  { "z_is_zero",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LINE, z_is_zero),
    0,0,0, 0 },
  { "start",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LINE, start),
    1,0,0, 10 },
  { "end",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LINE, end),
    1,0,0, 11 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_LINE, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_LINE, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LOFTEDSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LOFTEDSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LOFTEDSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, version),
    0,0,0, 0 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_LOFTEDSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_LOFTEDSURFACE, encr_sat_data),
    1,1,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, point),
    1,0,0, 0 },
  { "num_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_LOFTEDSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_LOFTEDSURFACE, silhouettes),
    1,1,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_LOFTEDSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "unknown_2007",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, unknown_2007),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LOFTEDSURFACE, history_id),
    1,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, v_isolines),
    0,0,0, 72 },
  { "loft_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_LOFTEDSURFACE, loft_entity_transmatrix),
    1,1,0, 40 },
  { "plane_normal_lofting_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, plane_normal_lofting_type),
    0,0,0, 70 },
  { "start_draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, start_draft_angle),
    0,0,0, 41 },
  { "end_draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, end_draft_angle),
    0,0,0, 42 },
  { "start_draft_magnitude",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, start_draft_magnitude),
    0,0,0, 43 },
  { "end_draft_magnitude",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, end_draft_magnitude),
    0,0,0, 44 },
  { "arc_length_parameterization",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, arc_length_parameterization),
    0,0,0, 290 },
  { "no_twist",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, no_twist),
    0,0,0, 291 },
  { "align_direction",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, align_direction),
    0,0,0, 292 },
  { "simple_surfaces",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, simple_surfaces),
    0,0,0, 293 },
  { "closed_surfaces",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, closed_surfaces),
    0,0,0, 294 },
  { "solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, solid),
    0,0,0, 295 },
  { "ruled_surface",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, ruled_surface),
    0,0,0, 296 },
  { "virtual_guide",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, virtual_guide),
    0,0,0, 297 },
  { "num_cross_sections",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_cross_sections),
    0,0,0, 0 },
  { "num_guide_curves",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_guide_curves),
    0,0,0, 0 },
  { "cross_sections",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_LOFTEDSURFACE, cross_sections),
    1,1,0, 310 },
  { "guide_curves",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_LOFTEDSURFACE, guide_curves),
    1,1,0, 310 },
  { "path_curve",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LOFTEDSURFACE, path_curve),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LWPOLYLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LWPOLYLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LWPOLYLINE, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LWPOLYLINE, flag),
    0,0,0, 70 },
  { "const_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LWPOLYLINE, const_width),
    0,0,0, 43 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LWPOLYLINE, elevation),
    0,0,0, 38 },
  { "thickness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LWPOLYLINE, thickness),
    0,0,0, 39 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LWPOLYLINE, extrusion),
    1,0,0, 210 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_points),
    0,0,0, 90 },
  { "points",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_LWPOLYLINE, points),
    1,1,0, 10 },
  { "num_bulges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_bulges),
    0,0,0, 0 },
  { "bulges",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_LWPOLYLINE, bulges),
    1,1,0, 42 },
  { "num_vertexids",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_vertexids),
    0,0,0, 0 },
  { "vertexids",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_LWPOLYLINE, vertexids),
    1,1,0, 91 },
  { "num_widths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_widths),
    0,0,0, 0 },
  { "widths",	"Dwg_LWPOLYLINE_width*", sizeof (Dwg_LWPOLYLINE_width*),  OFF (struct _dwg_entity_LWPOLYLINE, widths),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MESH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MESH_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MESH, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, class_version),
    0,0,0, 90 },
  { "dlevel",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_MESH, dlevel),
    0,0,0, 71 },
  { "is_watertight",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_MESH, is_watertight),
    0,0,0, 72 },
  { "num_subdiv_vertex",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_subdiv_vertex),
    0,0,0, 91 },
  { "subdiv_vertex",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_entity_MESH, subdiv_vertex),
    1,1,0, 10 },
  { "num_vertex",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_vertex),
    0,0,0, 92 },
  { "vertex",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_entity_MESH, vertex),
    1,1,0, 10 },
  { "num_faces",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_faces),
    0,0,0, 93 },
  { "faces",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_MESH, faces),
    1,1,0, 90 },
  { "num_edges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_edges),
    0,0,0, 94 },
  { "edges",	"Dwg_MESH_edge*", sizeof (Dwg_MESH_edge*),  OFF (struct _dwg_entity_MESH, edges),
    1,1,0, 0 },
  { "num_crease",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_crease),
    0,0,0, 95 },
  { "crease",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_MESH, crease),
    1,1,0, 140 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MINSERT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MINSERT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MINSERT, parent),
    1,1,0, 0 },
  { "ins_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_MINSERT, ins_pt),
    1,0,0, 10 },
  { "scale_flag",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_entity_MINSERT, scale_flag),
    0,0,0, 0 },
  { "scale",	"3BD_1", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_MINSERT, scale),
    1,0,0, 41 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MINSERT, rotation),
    0,0,0, 50 },
  { "extrusion",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_MINSERT, extrusion),
    1,0,0, 210 },
  { "has_attribs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MINSERT, has_attribs),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MINSERT, num_owned),
    0,0,0, 0 },
  { "num_cols",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MINSERT, num_cols),
    0,0,0, 70 },
  { "num_rows",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MINSERT, num_rows),
    0,0,0, 71 },
  { "col_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MINSERT, col_spacing),
    0,0,0, 44 },
  { "row_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MINSERT, row_spacing),
    0,0,0, 45 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, block_header),
    1,0,0, 2 },
  { "first_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, first_attrib),
    1,0,0, 0 },
  { "last_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, last_attrib),
    1,0,0, 0 },
  { "attrib_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_MINSERT, attrib_handles),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, seqend),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MLINE, parent),
    1,1,0, 0 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MLINE, scale),
    0,0,0, 40 },
  { "justification",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_MLINE, justification),
    0,0,0, 70 },
  { "base_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MLINE, base_point),
    1,0,0, 10 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MLINE, extrusion),
    1,0,0, 210 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MLINE, flags),
    0,0,0, 71 },
  { "num_lines",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_MLINE, num_lines),
    0,0,0, 73 },
  { "num_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MLINE, num_verts),
    0,0,0, 72 },
  { "verts",	"Dwg_MLINE_vertex*", sizeof (Dwg_MLINE_vertex*),  OFF (struct _dwg_entity_MLINE, verts),
    1,1,0, 0 },
  { "mlinestyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MLINE, mlinestyle),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MTEXT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MTEXT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MTEXT, parent),
    1,1,0, 0 },
  { "insertion_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MTEXT, insertion_pt),
    1,0,0, 10 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MTEXT, extrusion),
    1,0,0, 210 },
  { "x_axis_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MTEXT, x_axis_dir),
    1,0,0, 11 },
  { "rect_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, rect_height),
    0,0,0, 46 },
  { "rect_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, rect_width),
    0,0,0, 41 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, text_height),
    0,0,0, 40 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, attachment),
    0,0,0, 71 },
  { "drawing_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, drawing_dir),
    0,0,0, 72 },
  { "extents_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, extents_height),
    0,0,0, 43 },
  { "extents_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, extents_width),
    0,0,0, 42 },
  { "text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_MTEXT, text),
    1,1,1, 1 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MTEXT, style),
    1,0,0, 7 },
  { "linespace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, linespace_style),
    0,0,0, 73 },
  { "linespace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, linespace_factor),
    0,0,0, 44 },
  { "unknown_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, unknown_bit),
    0,0,0, 0 },
  { "bg_fill_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, bg_fill_flag),
    0,0,0, 90 },
  { "bg_fill_scale",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, bg_fill_scale),
    0,0,0, 45 },
  { "bg_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MTEXT, bg_fill_color),
    1,0,0, 63 },
  { "bg_fill_trans",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, bg_fill_trans),
    0,0,0, 441 },
  { "annotative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, annotative),
    0,0,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, class_version),
    0,0,0, 0 },
  { "default_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, default_flag),
    0,0,0, 0 },
  { "appid",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MTEXT, appid),
    1,0,0, 0 },
  { "column_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, column_type),
    0,0,0, 75 },
  { "column_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, column_width),
    0,0,0, 48 },
  { "gutter",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, gutter),
    0,0,0, 49 },
  { "auto_height",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, auto_height),
    0,0,0, 79 },
  { "flow_reversed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, flow_reversed),
    0,0,0, 74 },
  { "num_column_heights",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, num_column_heights),
    0,0,0, 76 },
  { "column_heights",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_MTEXT, column_heights),
    1,1,0, 50 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MULTILEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MULTILEADER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MULTILEADER, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, class_version),
    0,0,0, 270 },
  { "ctx",	"Dwg_MLEADER_AnnotContext", sizeof (Dwg_MLEADER_AnnotContext),  OFF (struct _dwg_entity_MULTILEADER, ctx),
    0,0,0, 0 },
  { "mleaderstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, mleaderstyle),
    1,0,0, 340 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MULTILEADER, flags),
    0,0,0, 90 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, type),
    0,0,0, 170 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MULTILEADER, color),
    1,0,0, 91 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, ltype),
    1,0,0, 341 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_entity_MULTILEADER, linewt),
    0,0,0, 171 },
  { "has_landing",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, has_landing),
    0,0,0, 290 },
  { "has_dogleg",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, has_dogleg),
    0,0,0, 291 },
  { "landing_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, landing_dist),
    0,0,0, 41 },
  { "arrow_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, arrow_handle),
    1,0,0, 342 },
  { "arrow_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, arrow_size),
    0,0,0, 42 },
  { "style_content",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, style_content),
    0,0,0, 172 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, text_style),
    1,0,0, 343 },
  { "text_left",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_left),
    0,0,0, 173 },
  { "text_right",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_right),
    0,0,0, 95 },
  { "text_angletype",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_angletype),
    0,0,0, 174 },
  { "attach_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_type),
    0,0,0, 175 },
  { "text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MULTILEADER, text_color),
    1,0,0, 92 },
  { "has_text_frame",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, has_text_frame),
    0,0,0, 292 },
  { "block_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, block_style),
    1,0,0, 344 },
  { "block_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MULTILEADER, block_color),
    1,0,0, 93 },
  { "block_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MULTILEADER, block_scale),
    1,0,0, 10 },
  { "block_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, block_rotation),
    0,0,0, 43 },
  { "style_attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, style_attachment),
    0,0,0, 176 },
  { "is_annotative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, is_annotative),
    0,0,0, 293 },
  { "num_arrowheads",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MULTILEADER, num_arrowheads),
    0,0,0, 0 },
  { "arrowheads",	"Dwg_LEADER_ArrowHead*", sizeof (Dwg_LEADER_ArrowHead*),  OFF (struct _dwg_entity_MULTILEADER, arrowheads),
    1,1,0, 0 },
  { "num_blocklabels",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MULTILEADER, num_blocklabels),
    0,0,0, 0 },
  { "blocklabels",	"Dwg_LEADER_BlockLabel*", sizeof (Dwg_LEADER_BlockLabel*),  OFF (struct _dwg_entity_MULTILEADER, blocklabels),
    1,1,0, 0 },
  { "neg_textdir",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, neg_textdir),
    0,0,0, 294 },
  { "ipe_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, ipe_alignment),
    0,0,0, 178 },
  { "justification",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, justification),
    0,0,0, 179 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, scale_factor),
    0,0,0, 45 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_dir),
    0,0,0, 271 },
  { "attach_top",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_top),
    0,0,0, 273 },
  { "attach_bottom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_bottom),
    0,0,0, 272 },
  { "text_extended",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, text_extended),
    0,0,0, 295 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_OLE2FRAME: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OLE2FRAME_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_OLE2FRAME, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLE2FRAME, type),
    0,0,0, 71 },
  { "mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLE2FRAME, mode),
    0,0,0, 72 },
  { "lock_aspect",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_OLE2FRAME, lock_aspect),
    0,0,0, 73 },
  { "data_length",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_OLE2FRAME, data_length),
    0,0,0, 90 },
  { "data",	"TV", sizeof (char*),  OFF (struct _dwg_entity_OLE2FRAME, data),
    1,1,1, 310 },
  { "oleversion",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLE2FRAME, oleversion),
    0,0,0, 70 },
  { "oleclient",	"TV", sizeof (char*),  OFF (struct _dwg_entity_OLE2FRAME, oleclient),
    1,1,1, 3 },
  { "pt1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_OLE2FRAME, pt1),
    1,0,0, 10 },
  { "pt2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_OLE2FRAME, pt2),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_OLEFRAME: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OLEFRAME_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_OLEFRAME, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLEFRAME, flag),
    0,0,0, 70 },
  { "mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLEFRAME, mode),
    0,0,0, 0 },
  { "data_length",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_OLEFRAME, data_length),
    0,0,0, 90 },
  { "data",	"TV", sizeof (char*),  OFF (struct _dwg_entity_OLEFRAME, data),
    1,1,1, 310 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_PLANESURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PLANESURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_PLANESURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, version),
    0,0,0, 0 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_PLANESURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_PLANESURFACE, encr_sat_data),
    1,1,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_PLANESURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_PLANESURFACE, point),
    1,0,0, 0 },
  { "num_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_PLANESURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_PLANESURFACE, silhouettes),
    1,1,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_PLANESURFACE, extra_acis_data),
    1,1,0, 0 },
  { "unknown_2007",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, unknown_2007),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_PLANESURFACE, history_id),
    1,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, class_version),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POINT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POINT, parent),
    1,1,0, 0 },
  { "x",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, x),
    0,0,0, 10 },
  { "y",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, y),
    0,0,0, 20 },
  { "z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, z),
    0,0,0, 30 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_POINT, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_POINT, extrusion),
    0,0,0, 210 },
  { "x_ang",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, x_ang),
    0,0,0, 50 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_2D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_2D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_2D, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_2D, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_2D, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_2D, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_2D, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_2D, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_2D, seqend),
    1,0,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_2D, flag),
    0,0,0, 70 },
  { "curve_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_2D, curve_type),
    0,0,0, 75 },
  { "start_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POLYLINE_2D, start_width),
    0,0,0, 40 },
  { "end_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POLYLINE_2D, end_width),
    0,0,0, 41 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_POLYLINE_2D, thickness),
    0,0,0, 39 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POLYLINE_2D, elevation),
    0,0,0, 30 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_POLYLINE_2D, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_3D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_3D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_3D, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_3D, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_3D, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_3D, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_3D, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_3D, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_3D, seqend),
    1,0,0, 0 },
  { "curve_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_POLYLINE_3D, curve_type),
    0,0,0, 75 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_POLYLINE_3D, flag),
    0,0,0, 70 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_MESH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_MESH_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_MESH, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_MESH, has_vertex),
    0,0,0, 0 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_MESH, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_MESH, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_MESH, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_MESH, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_MESH, seqend),
    1,0,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, flag),
    0,0,0, 70 },
  { "curve_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, curve_type),
    0,0,0, 75 },
  { "num_m_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, num_m_verts),
    0,0,0, 71 },
  { "num_n_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, num_n_verts),
    0,0,0, 72 },
  { "m_density",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, m_density),
    0,0,0, 73 },
  { "n_density",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, n_density),
    0,0,0, 74 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_PFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_PFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_PFACE, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_PFACE, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_PFACE, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_PFACE, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_PFACE, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_PFACE, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_PFACE, seqend),
    1,0,0, 0 },
  { "numverts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_PFACE, numverts),
    0,0,0, 71 },
  { "numfaces",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_PFACE, numfaces),
    0,0,0, 72 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_PROXY_ENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PROXY_ENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_PROXY_ENTITY, parent),
    1,1,0, 0 },
  { "class_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, class_id),
    0,0,0, 91 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, version),
    0,0,0, 71 },
  { "maint_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, maint_version),
    0,0,0, 97 },
  { "from_dxf",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PROXY_ENTITY, from_dxf),
    0,0,0, 70 },
  { "data",	"TV", sizeof (char*),  OFF (struct _dwg_entity_PROXY_ENTITY, data),
    1,1,1, 0 },
  { "objid_object_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_PROXY_ENTITY, objid_object_handles),
    1,1,0, 0 },
  { "size",	"MS", sizeof (BITCODE_MS),  OFF (struct _dwg_entity_PROXY_ENTITY, size),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_PROXY_LWPOLYLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PROXY_LWPOLYLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, parent),
    1,1,0, 0 },
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, size),
    0,0,0, 0 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, flags),
    0,0,0, 0 },
  { "const_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, const_width),
    0,0,0, 43 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, elevation),
    0,0,0, 38 },
  { "thickness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, thickness),
    0,0,0, 39 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, extrusion),
    1,0,0, 210 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, num_points),
    0,0,0, 90 },
  { "points",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, points),
    1,1,0, 0 },
  { "num_bulges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, num_bulges),
    0,0,0, 0 },
  { "bulges",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, bulges),
    1,1,0, 0 },
  { "num_widths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, num_widths),
    0,0,0, 0 },
  { "widths",	"Dwg_LWPOLYLINE_width*", sizeof (Dwg_LWPOLYLINE_width*),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, widths),
    1,1,0, 0 },
  { "unknown_1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, unknown_1),
    0,0,0, 0 },
  { "unknown_2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, unknown_2),
    0,0,0, 0 },
  { "unknown_3",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_PROXY_LWPOLYLINE, unknown_3),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_RAY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RAY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_RAY, parent),
    1,1,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_RAY, point),
    1,0,0, 10 },
  { "vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_RAY, vector),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_REVOLVEDSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_REVOLVEDSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_REVOLVEDSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, version),
    0,0,0, 0 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_REVOLVEDSURFACE, encr_sat_data),
    1,1,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, point),
    1,0,0, 0 },
  { "num_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, silhouettes),
    1,1,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_REVOLVEDSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "unknown_2007",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, unknown_2007),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_REVOLVEDSURFACE, history_id),
    1,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, class_version),
    0,0,0, 90 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, id),
    0,0,0, 90 },
  { "axis_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, axis_point),
    1,0,0, 10 },
  { "axis_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, axis_vector),
    1,0,0, 11 },
  { "revolve_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revolve_angle),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, start_angle),
    0,0,0, 41 },
  { "revolved_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revolved_entity_transmatrix),
    1,1,0, 42 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, draft_angle),
    0,0,0, 43 },
  { "draft_start_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, draft_start_distance),
    0,0,0, 44 },
  { "draft_end_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, draft_end_distance),
    0,0,0, 45 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, twist_angle),
    0,0,0, 46 },
  { "solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, solid),
    0,0,0, 290 },
  { "close_to_axis",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, close_to_axis),
    0,0,0, 291 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SEQEND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SEQEND_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SEQEND, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SHAPE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SHAPE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SHAPE, parent),
    1,1,0, 0 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SHAPE, ins_pt),
    1,0,0, 10 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, scale),
    0,0,0, 40 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, rotation),
    0,0,0, 50 },
  { "width_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, width_factor),
    0,0,0, 41 },
  { "oblique",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, oblique),
    0,0,0, 51 },
  { "thickness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, thickness),
    0,0,0, 39 },
  { "shape_no",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SHAPE, shape_no),
    0,0,0, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SHAPE, extrusion),
    1,0,0, 210 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SHAPE, style),
    1,0,0, 7 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SOLID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SOLID_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SOLID, parent),
    1,1,0, 0 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_SOLID, thickness),
    0,0,0, 39 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SOLID, elevation),
    0,0,0, 38 },
  { "corner1",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner1),
    1,0,0, 10 },
  { "corner2",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner2),
    1,0,0, 11 },
  { "corner3",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner3),
    1,0,0, 12 },
  { "corner4",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner4),
    1,0,0, 13 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_SOLID, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SPLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SPLINE, parent),
    1,1,0, 0 },
  { "flag",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_entity_SPLINE, flag),
    0,0,0, 70 },
  { "scenario",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SPLINE, scenario),
    0,0,0, 0 },
  { "degree",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SPLINE, degree),
    0,0,0, 71 },
  { "splineflags1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, splineflags1),
    0,0,0, 0 },
  { "knotparam",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, knotparam),
    0,0,0, 0 },
  { "fit_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SPLINE, fit_tol),
    0,0,0, 44 },
  { "beg_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SPLINE, beg_tan_vec),
    1,0,0, 12 },
  { "end_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SPLINE, end_tan_vec),
    1,0,0, 13 },
  { "closed_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, closed_b),
    0,0,0, 0 },
  { "periodic",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, periodic),
    0,0,0, 0 },
  { "rational",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, rational),
    0,0,0, 0 },
  { "weighted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, weighted),
    0,0,0, 0 },
  { "knot_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SPLINE, knot_tol),
    0,0,0, 42 },
  { "ctrl_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SPLINE, ctrl_tol),
    0,0,0, 43 },
  { "num_fit_pts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SPLINE, num_fit_pts),
    0,0,0, 74 },
  { "fit_pts",	"Dwg_SPLINE_point*", sizeof (Dwg_SPLINE_point*),  OFF (struct _dwg_entity_SPLINE, fit_pts),
    1,1,0, 0 },
  { "num_knots",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, num_knots),
    0,0,0, 72 },
  { "knots",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SPLINE, knots),
    1,1,0, 40 },
  { "num_ctrl_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, num_ctrl_pts),
    0,0,0, 73 },
  { "ctrl_pts",	"Dwg_SPLINE_control_point*", sizeof (Dwg_SPLINE_control_point*),  OFF (struct _dwg_entity_SPLINE, ctrl_pts),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SWEPTSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SWEPTSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SWEPTSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, version),
    0,0,0, 0 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_SWEPTSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_SWEPTSURFACE, encr_sat_data),
    1,1,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SWEPTSURFACE, point),
    1,0,0, 0 },
  { "num_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_SWEPTSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_SWEPTSURFACE, silhouettes),
    1,1,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_SWEPTSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "unknown_2007",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, unknown_2007),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SWEPTSURFACE, history_id),
    1,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, class_version),
    0,0,0, 90 },
  { "sweep_entity_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_id),
    0,0,0, 90 },
  { "size_sweepdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, size_sweepdata),
    0,0,0, 90 },
  { "sweepdata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_SWEPTSURFACE, sweepdata),
    1,1,0, 310 },
  { "path_entity_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_id),
    0,0,0, 90 },
  { "size_pathdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, size_pathdata),
    0,0,0, 90 },
  { "pathdata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_SWEPTSURFACE, pathdata),
    1,1,0, 310 },
  { "sweep_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_transmatrix),
    1,1,0, 40 },
  { "path_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_transmatrix),
    1,1,0, 41 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, draft_angle),
    0,0,0, 42 },
  { "draft_start_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, draft_start_distance),
    0,0,0, 43 },
  { "draft_end_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, draft_end_distance),
    0,0,0, 44 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, twist_angle),
    0,0,0, 45 },
  { "sweep_entity_transmatrix1",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_transmatrix1),
    1,1,0, 46 },
  { "path_entity_transmatrix1",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_transmatrix1),
    1,1,0, 47 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, scale_factor),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, align_angle),
    0,0,0, 49 },
  { "solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, solid),
    0,0,0, 290 },
  { "sweep_alignment",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_alignment),
    0,0,0, 70 },
  { "align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, align_start),
    0,0,0, 292 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, bank),
    0,0,0, 293 },
  { "base_point_set",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, base_point_set),
    0,0,0, 294 },
  { "sweep_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_transform_computed),
    0,0,0, 295 },
  { "path_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_transform_computed),
    0,0,0, 296 },
  { "reference_vector_for_controlling_twist",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SWEPTSURFACE, reference_vector_for_controlling_twist),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TABLE, parent),
    1,1,0, 0 },
  { "ldata",	"Dwg_LinkedData", sizeof (Dwg_LinkedData),  OFF (struct _dwg_entity_TABLE, ldata),
    0,0,0, 0 },
  { "tdata",	"Dwg_LinkedTableData", sizeof (Dwg_LinkedTableData),  OFF (struct _dwg_entity_TABLE, tdata),
    0,0,0, 0 },
  { "fdata",	"Dwg_FormattedTableData", sizeof (Dwg_FormattedTableData),  OFF (struct _dwg_entity_TABLE, fdata),
    0,0,0, 0 },
  { "table_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, table_style),
    1,0,0, 342 },
  { "unknown_rc",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_TABLE, unknown_rc),
    0,0,0, 0 },
  { "unknown_h",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, unknown_h),
    1,0,0, 0 },
  { "unknown_bl",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, unknown_bl),
    0,0,0, 0 },
  { "unknown_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, unknown_b),
    0,0,0, 0 },
  { "unknown_bl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, unknown_bl1),
    0,0,0, 0 },
  { "insertion_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, insertion_point),
    1,0,0, 10 },
  { "scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, scale),
    1,0,0, 41 },
  { "data_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_entity_TABLE, data_flags),
    0,0,0, 0 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, rotation),
    0,0,0, 50 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, extrusion),
    1,0,0, 210 },
  { "has_attribs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_attribs),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_owned),
    0,0,0, 0 },
  { "flag_for_table_value",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, flag_for_table_value),
    0,0,0, 90 },
  { "horiz_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, horiz_direction),
    1,0,0, 11 },
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_cols),
    0,0,0, 92 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_rows),
    0,0,0, 91 },
  { "num_cells",	"unsigned long", sizeof (unsigned long),  OFF (struct _dwg_entity_TABLE, num_cells),
    0,0,0, 0 },
  { "col_widths",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_TABLE, col_widths),
    1,1,0, 142 },
  { "row_heights",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_TABLE, row_heights),
    1,1,0, 141 },
  { "cells",	"Dwg_TABLE_Cell*", sizeof (Dwg_TABLE_Cell*),  OFF (struct _dwg_entity_TABLE, cells),
    1,1,0, 0 },
  { "has_table_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_table_overrides),
    0,0,0, 0 },
  { "table_flag_override",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, table_flag_override),
    0,0,0, 93 },
  { "title_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, title_suppressed),
    0,0,0, 280 },
  { "header_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, header_suppressed),
    0,0,0, 281 },
  { "flow_direction",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, flow_direction),
    0,0,0, 70 },
  { "horiz_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, horiz_cell_margin),
    0,0,0, 40 },
  { "vert_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, vert_cell_margin),
    0,0,0, 41 },
  { "title_row_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_row_color),
    1,0,0, 64 },
  { "header_row_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_row_color),
    1,0,0, 64 },
  { "data_row_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_row_color),
    1,0,0, 64 },
  { "title_row_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, title_row_fill_none),
    0,0,0, 283 },
  { "header_row_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, header_row_fill_none),
    0,0,0, 283 },
  { "data_row_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, data_row_fill_none),
    0,0,0, 283 },
  { "title_row_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_row_fill_color),
    1,0,0, 63 },
  { "header_row_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_row_fill_color),
    1,0,0, 63 },
  { "data_row_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_row_fill_color),
    1,0,0, 63 },
  { "title_row_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_row_alignment),
    0,0,0, 170 },
  { "header_row_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_row_alignment),
    0,0,0, 170 },
  { "data_row_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_row_alignment),
    0,0,0, 170 },
  { "title_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, title_text_style),
    1,0,0, 7 },
  { "header_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, header_text_style),
    1,0,0, 7 },
  { "data_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, data_text_style),
    1,0,0, 7 },
  { "title_row_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, title_row_height),
    0,0,0, 140 },
  { "header_row_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, header_row_height),
    0,0,0, 140 },
  { "data_row_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, data_row_height),
    0,0,0, 140 },
  { "has_border_color_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_border_color_overrides),
    0,0,0, 0 },
  { "border_color_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, border_color_overrides_flag),
    0,0,0, 94 },
  { "title_horiz_top_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_horiz_top_color),
    1,0,0, 64 },
  { "title_horiz_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_horiz_ins_color),
    1,0,0, 65 },
  { "title_horiz_bottom_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_horiz_bottom_color),
    1,0,0, 66 },
  { "title_vert_left_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_vert_left_color),
    1,0,0, 63 },
  { "title_vert_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_vert_ins_color),
    1,0,0, 68 },
  { "title_vert_right_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_vert_right_color),
    1,0,0, 69 },
  { "header_horiz_top_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_horiz_top_color),
    1,0,0, 64 },
  { "header_horiz_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_horiz_ins_color),
    1,0,0, 65 },
  { "header_horiz_bottom_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_horiz_bottom_color),
    1,0,0, 66 },
  { "header_vert_left_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_vert_left_color),
    1,0,0, 63 },
  { "header_vert_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_vert_ins_color),
    1,0,0, 68 },
  { "header_vert_right_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_vert_right_color),
    1,0,0, 69 },
  { "data_horiz_top_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_horiz_top_color),
    1,0,0, 64 },
  { "data_horiz_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_horiz_ins_color),
    1,0,0, 65 },
  { "data_horiz_bottom_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_horiz_bottom_color),
    1,0,0, 66 },
  { "data_vert_left_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_vert_left_color),
    1,0,0, 63 },
  { "data_vert_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_vert_ins_color),
    1,0,0, 68 },
  { "data_vert_right_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_vert_right_color),
    1,0,0, 69 },
  { "has_border_lineweight_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_border_lineweight_overrides),
    0,0,0, 0 },
  { "border_lineweight_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, border_lineweight_overrides_flag),
    0,0,0, 95 },
  { "title_horiz_top_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_top_linewt),
    0,0,0, 0 },
  { "title_horiz_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_ins_linewt),
    0,0,0, 0 },
  { "title_horiz_bottom_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_bottom_linewt),
    0,0,0, 0 },
  { "title_vert_left_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_left_linewt),
    0,0,0, 0 },
  { "title_vert_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_ins_linewt),
    0,0,0, 0 },
  { "title_vert_right_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_right_linewt),
    0,0,0, 0 },
  { "header_horiz_top_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_top_linewt),
    0,0,0, 0 },
  { "header_horiz_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_ins_linewt),
    0,0,0, 0 },
  { "header_horiz_bottom_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_bottom_linewt),
    0,0,0, 0 },
  { "header_vert_left_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_left_linewt),
    0,0,0, 0 },
  { "header_vert_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_ins_linewt),
    0,0,0, 0 },
  { "header_vert_right_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_right_linewt),
    0,0,0, 0 },
  { "data_horiz_top_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_top_linewt),
    0,0,0, 0 },
  { "data_horiz_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_ins_linewt),
    0,0,0, 0 },
  { "data_horiz_bottom_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_bottom_linewt),
    0,0,0, 0 },
  { "data_vert_left_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_left_linewt),
    0,0,0, 0 },
  { "data_vert_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_ins_linewt),
    0,0,0, 0 },
  { "data_vert_right_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_right_linewt),
    0,0,0, 0 },
  { "has_border_visibility_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_border_visibility_overrides),
    0,0,0, 0 },
  { "border_visibility_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, border_visibility_overrides_flag),
    0,0,0, 96 },
  { "title_horiz_top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_top_visibility),
    0,0,0, 0 },
  { "title_horiz_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_ins_visibility),
    0,0,0, 0 },
  { "title_horiz_bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_bottom_visibility),
    0,0,0, 0 },
  { "title_vert_left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_left_visibility),
    0,0,0, 0 },
  { "title_vert_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_ins_visibility),
    0,0,0, 0 },
  { "title_vert_right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_right_visibility),
    0,0,0, 0 },
  { "header_horiz_top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_top_visibility),
    0,0,0, 0 },
  { "header_horiz_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_ins_visibility),
    0,0,0, 0 },
  { "header_horiz_bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_bottom_visibility),
    0,0,0, 0 },
  { "header_vert_left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_left_visibility),
    0,0,0, 0 },
  { "header_vert_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_ins_visibility),
    0,0,0, 0 },
  { "header_vert_right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_right_visibility),
    0,0,0, 0 },
  { "data_horiz_top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_top_visibility),
    0,0,0, 0 },
  { "data_horiz_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_ins_visibility),
    0,0,0, 0 },
  { "data_horiz_bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_bottom_visibility),
    0,0,0, 0 },
  { "data_vert_left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_left_visibility),
    0,0,0, 0 },
  { "data_vert_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_ins_visibility),
    0,0,0, 0 },
  { "data_vert_right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_right_visibility),
    0,0,0, 0 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, block_header),
    1,0,0, 2 },
  { "first_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, first_attrib),
    1,0,0, 0 },
  { "last_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, last_attrib),
    1,0,0, 0 },
  { "attrib_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_TABLE, attrib_handles),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, seqend),
    1,0,0, 0 },
  { "title_row_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, title_row_style_override),
    1,0,0, 7 },
  { "header_row_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, header_row_style_override),
    1,0,0, 7 },
  { "data_row_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, data_row_style_override),
    1,0,0, 7 },
  { "unknown_bs",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, unknown_bs),
    0,0,0, 0 },
  { "hor_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, hor_dir),
    1,0,0, 11 },
  { "has_break_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, has_break_data),
    0,0,0, 0 },
  { "break_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_flag),
    0,0,0, 0 },
  { "break_flow_direction",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_flow_direction),
    0,0,0, 0 },
  { "break_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, break_spacing),
    0,0,0, 0 },
  { "break_unknown1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_unknown1),
    0,0,0, 0 },
  { "break_unknown2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_unknown2),
    0,0,0, 0 },
  { "num_break_heights",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_break_heights),
    0,0,0, 0 },
  { "break_heights",	"Dwg_TABLE_BreakHeight*", sizeof (Dwg_TABLE_BreakHeight*),  OFF (struct _dwg_entity_TABLE, break_heights),
    1,1,0, 0 },
  { "num_break_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_break_rows),
    0,0,0, 0 },
  { "break_rows",	"Dwg_TABLE_BreakRow*", sizeof (Dwg_TABLE_BreakRow*),  OFF (struct _dwg_entity_TABLE, break_rows),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TEXT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TEXT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TEXT, parent),
    1,1,0, 0 },
  { "dataflags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_TEXT, dataflags),
    0,0,0, 0 },
  { "elevation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, elevation),
    0,0,0, 30 },
  { "insertion_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_TEXT, insertion_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_TEXT, alignment_pt),
    1,0,0, 11 },
  { "extrusion",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_TEXT, extrusion),
    1,0,0, 210 },
  { "thickness",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, thickness),
    0,0,0, 39 },
  { "oblique_ang",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, oblique_ang),
    0,0,0, 51 },
  { "rotation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, rotation),
    0,0,0, 50 },
  { "height",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, height),
    0,0,0, 40 },
  { "width_factor",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, width_factor),
    0,0,0, 41 },
  { "text_value",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_TEXT, text_value),
    1,1,1, 1 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TEXT, generation),
    0,0,0, 71 },
  { "horiz_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TEXT, horiz_alignment),
    0,0,0, 72 },
  { "vert_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TEXT, vert_alignment),
    0,0,0, 73 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TEXT, style),
    1,0,0, 7 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TOLERANCE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TOLERANCE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TOLERANCE, parent),
    1,1,0, 0 },
  { "unknown_short",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TOLERANCE, unknown_short),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TOLERANCE, height),
    0,0,0, 0 },
  { "dimgap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TOLERANCE, dimgap),
    0,0,0, 0 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TOLERANCE, ins_pt),
    1,0,0, 10 },
  { "x_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TOLERANCE, x_direction),
    1,0,0, 11 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TOLERANCE, extrusion),
    1,0,0, 0 },
  { "text_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_TOLERANCE, text_string),
    1,1,1, 1 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TOLERANCE, dimstyle),
    1,0,0, 3 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TRACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TRACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TRACE, parent),
    1,1,0, 0 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_TRACE, thickness),
    0,0,0, 39 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TRACE, elevation),
    0,0,0, 38 },
  { "corner1",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner1),
    1,0,0, 10 },
  { "corner2",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner2),
    1,0,0, 11 },
  { "corner3",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner3),
    1,0,0, 12 },
  { "corner4",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner4),
    1,0,0, 13 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_TRACE, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_UNDERLAY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNDERLAY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_UNDERLAY, parent),
    1,1,0, 0 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_UNDERLAY, extrusion),
    1,0,0, 210 },
  { "insertion_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_UNDERLAY, insertion_pt),
    1,0,0, 10 },
  { "scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_UNDERLAY, scale),
    1,0,0, 41 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_UNDERLAY, angle),
    0,0,0, 50 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_UNDERLAY, flag),
    0,0,0, 280 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_UNDERLAY, contrast),
    0,0,0, 281 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_UNDERLAY, fade),
    0,0,0, 282 },
  { "num_clip_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_UNDERLAY, num_clip_verts),
    0,0,0, 0 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_UNDERLAY, clip_verts),
    1,1,0, 11 },
  { "underlay_layer",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_UNDERLAY, underlay_layer),
    1,0,0, 0 },
  { "definition_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_UNDERLAY, definition_id),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_UNKNOWN_ENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNKNOWN_ENT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_UNKNOWN_ENT, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VERTEX_2D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VERTEX_2D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VERTEX_2D, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VERTEX_2D, flag),
    0,0,0, 70 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VERTEX_2D, point),
    1,0,0, 10 },
  { "start_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, start_width),
    0,0,0, 40 },
  { "end_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, end_width),
    0,0,0, 41 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_VERTEX_2D, id),
    0,0,0, 91 },
  { "bulge",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, bulge),
    0,0,0, 42 },
  { "tangent_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, tangent_dir),
    0,0,0, 50 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VERTEX_3D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VERTEX_3D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VERTEX_3D, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VERTEX_3D, flag),
    0,0,0, 70 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VERTEX_3D, point),
    1,0,0, 10 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VERTEX_PFACE_FACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VERTEX_PFACE_FACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VERTEX_PFACE_FACE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VERTEX_PFACE_FACE, flag),
    0,0,0, 70 },
  { "vertind[4]",	"BS", 4 * sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VERTEX_PFACE_FACE, vertind),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VIEWPORT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VIEWPORT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VIEWPORT, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, center),
    1,0,0, 10 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, width),
    0,0,0, 40 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, height),
    0,0,0, 41 },
  { "on_off",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_entity_VIEWPORT, on_off),
    0,0,0, 68 },
  { "id",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_entity_VIEWPORT, id),
    0,0,0, 69 },
  { "view_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, view_target),
    1,0,0, 17 },
  { "view_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, view_direction),
    1,0,0, 16 },
  { "view_twist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, view_twist),
    0,0,0, 51 },
  { "view_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, view_height),
    0,0,0, 45 },
  { "lens_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, lens_length),
    0,0,0, 42 },
  { "front_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, front_clip_z),
    0,0,0, 43 },
  { "back_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, back_clip_z),
    0,0,0, 44 },
  { "snap_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, snap_angle),
    0,0,0, 50 },
  { "view_center",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, view_center),
    1,0,0, 12 },
  { "snap_base",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, snap_base),
    1,0,0, 13 },
  { "snap_spacing",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, snap_spacing),
    1,0,0, 14 },
  { "grid_spacing",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, grid_spacing),
    1,0,0, 15 },
  { "circle_zoom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, circle_zoom),
    0,0,0, 72 },
  { "grid_major",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, grid_major),
    0,0,0, 61 },
  { "num_frozen_layers",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_VIEWPORT, num_frozen_layers),
    0,0,0, 0 },
  { "status_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_VIEWPORT, status_flag),
    0,0,0, 90 },
  { "style_sheet",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_VIEWPORT, style_sheet),
    1,1,1, 1 },
  { "render_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VIEWPORT, render_mode),
    0,0,0, 281 },
  { "ucs_at_origin",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_VIEWPORT, ucs_at_origin),
    0,0,0, 74 },
  { "ucs_per_viewport",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_VIEWPORT, ucs_per_viewport),
    0,0,0, 71 },
  { "ucs_origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, ucs_origin),
    1,0,0, 110 },
  { "ucs_x_axis",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, ucs_x_axis),
    1,0,0, 111 },
  { "ucs_y_axis",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, ucs_y_axis),
    1,0,0, 112 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, ucs_elevation),
    0,0,0, 146 },
  { "ucs_ortho_view_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, ucs_ortho_view_type),
    0,0,0, 79 },
  { "shadeplot_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, shadeplot_mode),
    0,0,0, 170 },
  { "use_default_lights",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_VIEWPORT, use_default_lights),
    0,0,0, 292 },
  { "default_lighting_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VIEWPORT, default_lighting_type),
    0,0,0, 282 },
  { "brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, brightness),
    0,0,0, 141 },
  { "contrast",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, contrast),
    0,0,0, 142 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_VIEWPORT, ambient_color),
    1,0,0, 63 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_WIPEOUT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_WIPEOUT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_WIPEOUT, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_WIPEOUT, class_version),
    0,0,0, 90 },
  { "pt0",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_WIPEOUT, pt0),
    1,0,0, 10 },
  { "uvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_WIPEOUT, uvec),
    1,0,0, 11 },
  { "vvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_WIPEOUT, vvec),
    1,0,0, 12 },
  { "size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_WIPEOUT, size),
    1,0,0, 13 },
  { "display_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_WIPEOUT, display_props),
    0,0,0, 70 },
  { "clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_WIPEOUT, clipping),
    0,0,0, 280 },
  { "brightness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_WIPEOUT, brightness),
    0,0,0, 281 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_WIPEOUT, contrast),
    0,0,0, 282 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_WIPEOUT, fade),
    0,0,0, 283 },
  { "clip_mode",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_WIPEOUT, clip_mode),
    0,0,0, 290 },
  { "clip_boundary_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_WIPEOUT, clip_boundary_type),
    0,0,0, 71 },
  { "num_clip_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_WIPEOUT, num_clip_verts),
    0,0,0, 91 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_WIPEOUT, clip_verts),
    1,1,0, 14 },
  { "imagedef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_WIPEOUT, imagedef),
    1,0,0, 340 },
  { "imagedefreactor",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_WIPEOUT, imagedefreactor),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_object_ACSH_SWEEP_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_SWEEP_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, class_version),
    0,0,0, 90 },
  { "ee_bl98",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, ee_bl98),
    0,0,0, 98 },
  { "ee_bl99",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, ee_bl99),
    0,0,0, 99 },
  { "shhn_bl98",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shhn_bl98),
    0,0,0, 98 },
  { "shhn_bl99",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shhn_bl99),
    0,0,0, 99 },
  { "shhn_pts",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shhn_pts),
    1,1,0, 40 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, color),
    1,0,0, 62 },
  { "shhn_b92",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shhn_b92),
    0,0,0, 92 },
  { "shhn_bl347",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shhn_bl347),
    0,0,0, 347 },
  { "shsw_bl90",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_bl90),
    0,0,0, 90 },
  { "shsw_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_bl91),
    0,0,0, 91 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, basept),
    1,0,0, 10 },
  { "shsw_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_bl92),
    0,0,0, 92 },
  { "shsw_size_text",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_size_text),
    0,0,0, 90 },
  { "shsw_text",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_text),
    1,1,0, 310 },
  { "shsw_bl93",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_bl93),
    0,0,0, 93 },
  { "shsw_size_text2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_size_text2),
    0,0,0, 90 },
  { "shsw_text2",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_text2),
    1,1,0, 310 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, draft_angle),
    0,0,0, 42 },
  { "start_draft_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, start_draft_dist),
    0,0,0, 43 },
  { "end_draft_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, end_draft_dist),
    0,0,0, 44 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, scale_factor),
    0,0,0, 45 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, twist_angle),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, align_angle),
    0,0,0, 49 },
  { "sweepentity_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, sweepentity_transform),
    1,1,0, 46 },
  { "pathentity_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, pathentity_transform),
    1,1,0, 47 },
  { "align_option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, align_option),
    0,0,0, 70 },
  { "miter_option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, miter_option),
    0,0,0, 71 },
  { "has_align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, has_align_start),
    0,0,0, 290 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, bank),
    0,0,0, 292 },
  { "check_intersections",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, check_intersections),
    0,0,0, 293 },
  { "shsw_b294",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_b294),
    0,0,0, 294 },
  { "shsw_b295",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_b295),
    0,0,0, 295 },
  { "shsw_b296",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_b296),
    0,0,0, 296 },
  { "pt2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, pt2),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ANNOTSCALEOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "has_file",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, has_file),
    0,0,0, 290 },
  { "defaultflag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, defaultflag),
    0,0,0, 0 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_APPID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_APPID_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_APPID, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_APPID, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_APPID, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_APPID, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_APPID, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_APPID, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_APPID, xrefdep),
    0,0,0, 0 },
  { "unknown",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_APPID, unknown),
    0,0,0, 71 },
  { "null_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_APPID, null_handle),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_APPID_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_APPID_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_APPID_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_APPID_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_APPID_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_APPID_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOC2DCONSTRAINTGROUP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOC2DCONSTRAINTGROUP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, parent),
    1,1,0, 0 },
  { "solution_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, solution_status),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, geometry_status),
    0,0,0, 90 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, readdep),
    1,0,0, 330 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, writedep),
    1,0,0, 360 },
  { "constraint_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, constraint_status),
    0,0,0, 90 },
  { "dof",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, dof),
    0,0,0, 90 },
  { "is_body_a_proxy",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, is_body_a_proxy),
    0,0,0, 90 },
  { "l5",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, l5),
    0,0,0, 90 },
  { "b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, b1),
    0,0,0, 70 },
  { "workplane[3]",	"3BD", 3 * sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, workplane),
    1,0,0, 0 },
  { "l6",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, l6),
    0,0,0, 90 },
  { "l7",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, l7),
    0,0,0, 90 },
  { "l8",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, l8),
    0,0,0, 90 },
  { "cl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, cl1),
    0,0,0, 90 },
  { "cs1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, cs1),
    0,0,0, 70 },
  { "cl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, cl2),
    0,0,0, 90 },
  { "cl3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, cl3),
    0,0,0, 90 },
  { "cl4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, cl4),
    0,0,0, 90 },
  { "c1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, c1),
    1,0,0, 10 },
  { "c2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, c2),
    1,0,0, 10 },
  { "c3",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, c3),
    1,0,0, 10 },
  { "w1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, w1),
    0,0,0, 40 },
  { "w2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, w2),
    0,0,0, 40 },
  { "w3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, w3),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCACTION, parent),
    1,1,0, 0 },
  { "solution_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, solution_status),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, geometry_status),
    0,0,0, 90 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, readdep),
    1,0,0, 330 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, writedep),
    1,0,0, 360 },
  { "constraint_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, constraint_status),
    0,0,0, 90 },
  { "dof",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, dof),
    0,0,0, 90 },
  { "is_body_a_proxy",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCACTION, is_body_a_proxy),
    0,0,0, 90 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, num_deps),
    0,0,0, 90 },
  { "body",	"Dwg_ACTIONBODY", sizeof (Dwg_ACTIONBODY),  OFF (struct _dwg_object_ASSOCACTION, body),
    0,0,0, 0 },
  { "status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, status),
    0,0,0, 90 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, actionbody),
    1,0,0, 0 },
  { "callback",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, callback),
    1,0,0, 0 },
  { "owningnetwork",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, owningnetwork),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCALIGNEDDIMACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, aab_status),
    0,0,0, 90 },
  { "pab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab_status),
    0,0,0, 90 },
  { "pab_l2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab_l2),
    0,0,0, 90 },
  { "pab_l3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab_l3),
    0,0,0, 90 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, writedep),
    1,0,0, 360 },
  { "pab_l4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab_l4),
    0,0,0, 90 },
  { "pab_l5",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab_l5),
    0,0,0, 90 },
  { "pab_l6",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab_l6),
    0,0,0, 0 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, readdep),
    1,0,0, 330 },
  { "dcm_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, dcm_status),
    0,0,0, 90 },
  { "d_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, d_node),
    1,0,0, 330 },
  { "r_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, r_node),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCDEPENDENCY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCDEPENDENCY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCDEPENDENCY, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCDEPENDENCY, class_version),
    0,0,0, 90 },
  { "status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCDEPENDENCY, status),
    0,0,0, 90 },
  { "isread_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, isread_dep),
    0,0,0, 290 },
  { "iswrite_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, iswrite_dep),
    0,0,0, 290 },
  { "isobjectstate_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, isobjectstate_dep),
    0,0,0, 290 },
  { "unknown_b4",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, unknown_b4),
    0,0,0, 290 },
  { "order",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCDEPENDENCY, order),
    0,0,0, 90 },
  { "unknown_b5",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, unknown_b5),
    0,0,0, 290 },
  { "depbodyid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCDEPENDENCY, depbodyid),
    0,0,0, 90 },
  { "owner",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, owner),
    1,0,0, 0 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, readdep),
    1,0,0, 330 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, writedep),
    1,0,0, 360 },
  { "node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, node),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCNETWORK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCNETWORK_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCNETWORK, parent),
    1,1,0, 0 },
  { "solution_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, solution_status),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, geometry_status),
    0,0,0, 90 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCNETWORK, readdep),
    1,0,0, 330 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCNETWORK, writedep),
    1,0,0, 360 },
  { "constraint_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, constraint_status),
    0,0,0, 90 },
  { "dof",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, dof),
    0,0,0, 90 },
  { "is_body_a_proxy",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCNETWORK, is_body_a_proxy),
    0,0,0, 90 },
  { "unknown_assoc",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, unknown_assoc),
    0,0,0, 0 },
  { "unknown_n1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, unknown_n1),
    0,0,0, 90 },
  { "unknown_n2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, unknown_n2),
    0,0,0, 90 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, num_actions),
    0,0,0, 90 },
  { "actions",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCNETWORK, actions),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCOSNAPPOINTREFACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, parent),
    1,1,0, 0 },
  { "unknown",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, unknown),
    0,0,0, 0 },
  { "unknown1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, unknown1),
    0,0,0, 0 },
  { "status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, status),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, name),
    1,1,1, 1 },
  { "flags",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, flags),
    0,0,0, 90 },
  { "unknown3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, unknown3),
    0,0,0, 40 },
  { "num_params",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, num_params),
    0,0,0, 90 },
  { "actionparam",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, actionparam),
    1,0,0, 330 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, writedep),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPERSSUBENTMANAGER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPERSSUBENTMANAGER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, class_version),
    0,0,0, 90 },
  { "unknown_bl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl1),
    0,0,0, 90 },
  { "unknown_bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl2),
    0,0,0, 90 },
  { "unknown_bl3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl3),
    0,0,0, 90 },
  { "unknown_bl4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl4),
    0,0,0, 90 },
  { "unknown_bl5",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl5),
    0,0,0, 90 },
  { "unknown_bl6",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl6),
    0,0,0, 90 },
  { "unknown_bl6a",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl6a),
    0,0,0, 90 },
  { "unknown_bl7a",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl7a),
    0,0,0, 90 },
  { "unknown_bl7",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl7),
    0,0,0, 90 },
  { "unknown_bl8",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl8),
    0,0,0, 90 },
  { "unknown_bl9",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl9),
    0,0,0, 90 },
  { "unknown_bl10",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl10),
    0,0,0, 90 },
  { "unknown_bl11",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl11),
    0,0,0, 90 },
  { "unknown_bl12",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl12),
    0,0,0, 90 },
  { "unknown_bl13",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl13),
    0,0,0, 90 },
  { "unknown_bl14",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl14),
    0,0,0, 90 },
  { "unknown_bl15",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl15),
    0,0,0, 90 },
  { "unknown_bl16",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl16),
    0,0,0, 90 },
  { "unknown_bl17",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl17),
    0,0,0, 90 },
  { "unknown_bl18",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl18),
    0,0,0, 90 },
  { "unknown_bl19",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl19),
    0,0,0, 90 },
  { "unknown_bl20",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl20),
    0,0,0, 90 },
  { "unknown_bl21",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl21),
    0,0,0, 90 },
  { "unknown_bl22",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl22),
    0,0,0, 90 },
  { "unknown_bl23",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl23),
    0,0,0, 90 },
  { "unknown_bl24",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl24),
    0,0,0, 90 },
  { "unknown_bl25",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl25),
    0,0,0, 90 },
  { "unknown_bl26",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl26),
    0,0,0, 90 },
  { "unknown_bl27",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl27),
    0,0,0, 90 },
  { "unknown_bl28",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl28),
    0,0,0, 90 },
  { "unknown_bl29",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl29),
    0,0,0, 90 },
  { "unknown_bl30",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl30),
    0,0,0, 90 },
  { "unknown_bl31",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl31),
    0,0,0, 90 },
  { "unknown_bl32",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl32),
    0,0,0, 90 },
  { "unknown_bl33",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl33),
    0,0,0, 90 },
  { "unknown_bl34",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl34),
    0,0,0, 90 },
  { "unknown_bl35",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl35),
    0,0,0, 90 },
  { "unknown_bl36",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl36),
    0,0,0, 90 },
  { "unknown_b37",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_b37),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPLANESURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPLANESURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, aab_status),
    0,0,0, 90 },
  { "pab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pab_status),
    0,0,0, 90 },
  { "pab_l2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pab_l2),
    0,0,0, 90 },
  { "pab_l3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pab_l3),
    0,0,0, 90 },
  { "writedep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, writedep),
    1,0,0, 360 },
  { "pab_l4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pab_l4),
    0,0,0, 90 },
  { "pab_l5",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pab_l5),
    0,0,0, 90 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, readdep),
    1,0,0, 330 },
  { "sab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, sab_status),
    0,0,0, 90 },
  { "sab_b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, sab_b1),
    0,0,0, 290 },
  { "sab_l2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, sab_l2),
    0,0,0, 90 },
  { "sab_b2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, sab_b2),
    0,0,0, 290 },
  { "sab_s1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, sab_s1),
    0,0,0, 70 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "psab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, psab_status),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCK_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCK_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCK_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCK_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCK_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_CONTROL, objid),
    0,0,0, 0 },
  { "model_space",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_CONTROL, model_space),
    1,0,0, 0 },
  { "paper_space",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_CONTROL, paper_space),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCK_HEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCK_HEADER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCK_HEADER, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_BLOCK_HEADER, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCK_HEADER, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_BLOCK_HEADER, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCK_HEADER, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, xrefdep),
    0,0,0, 0 },
  { "__iterator",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_HEADER, __iterator),
    0,0,0, 0 },
  { "flag2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_BLOCK_HEADER, flag2),
    0,0,0, 0 },
  { "flag3",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_BLOCK_HEADER, flag3),
    0,0,0, 0 },
  { "anonymous",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, anonymous),
    0,0,0, 0 },
  { "hasattrs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, hasattrs),
    0,0,0, 0 },
  { "blkisxref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, blkisxref),
    0,0,0, 0 },
  { "xrefoverlaid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, xrefoverlaid),
    0,0,0, 0 },
  { "loaded_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, loaded_bit),
    0,0,0, 0 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_HEADER, num_owned),
    0,0,0, 0 },
  { "base_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_BLOCK_HEADER, base_pt),
    1,0,0, 10 },
  { "xref_pname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCK_HEADER, xref_pname),
    1,1,1, 1 },
  { "num_inserts",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_object_BLOCK_HEADER, num_inserts),
    0,0,0, 0 },
  { "description",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCK_HEADER, description),
    1,1,1, 4 },
  { "preview_data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_HEADER, preview_data_size),
    0,0,0, 0 },
  { "preview_data",	"TV", sizeof (char*),  OFF (struct _dwg_object_BLOCK_HEADER, preview_data),
    1,1,1, 310 },
  { "insert_units",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCK_HEADER, insert_units),
    0,0,0, 70 },
  { "explodable",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, explodable),
    0,0,0, 280 },
  { "block_scaling",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_BLOCK_HEADER, block_scaling),
    0,0,0, 281 },
  { "null_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, null_handle),
    1,0,0, 0 },
  { "block_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, block_entity),
    1,0,0, 0 },
  { "first_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, first_entity),
    1,0,0, 0 },
  { "last_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, last_entity),
    1,0,0, 0 },
  { "entities",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCK_HEADER, entities),
    1,1,0, 0 },
  { "endblk_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, endblk_entity),
    1,0,0, 0 },
  { "inserts",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCK_HEADER, inserts),
    1,1,0, 0 },
  { "layout",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, layout),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_CELLSTYLEMAP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CELLSTYLEMAP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_CELLSTYLEMAP, parent),
    1,1,0, 0 },
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_CELLSTYLEMAP, num_cells),
    0,0,0, 90 },
  { "cells",	"Dwg_CELLSTYLEMAP_Cell*", sizeof (Dwg_CELLSTYLEMAP_Cell*),  OFF (struct _dwg_object_CELLSTYLEMAP, cells),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DATATABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DATATABLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DATATABLE, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DBCOLOR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DBCOLOR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DBCOLOR, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DBCOLOR, class_version),
    0,0,0, 90 },
  { "unknown1",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_DBCOLOR, unknown1),
    0,0,0, 0 },
  { "rgb",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_object_DBCOLOR, rgb),
    0,0,0, 420 },
  { "unknown2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DBCOLOR, unknown2),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DBCOLOR, name),
    1,1,1, 0 },
  { "catalog",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DBCOLOR, catalog),
    1,1,1, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DBCOLOR, color),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DICTIONARY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DICTIONARY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DICTIONARY, parent),
    1,1,0, 0 },
  { "numitems",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DICTIONARY, numitems),
    0,0,0, 0 },
  { "cloning",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DICTIONARY, cloning),
    0,0,0, 281 },
  { "hard_owner",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARY, hard_owner),
    0,0,0, 280 },
  { "texts",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_object_DICTIONARY, texts),
    1,1,0, 3 },
  { "itemhandles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DICTIONARY, itemhandles),
    1,1,0, 350 },
  { "cloning_r14",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARY, cloning_r14),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DICTIONARYVAR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DICTIONARYVAR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DICTIONARYVAR, parent),
    1,1,0, 0 },
  { "intval",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARYVAR, intval),
    0,0,0, 280 },
  { "str",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_DICTIONARYVAR, str),
    1,1,1, 1 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DICTIONARYWDFLT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DICTIONARYWDFLT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DICTIONARYWDFLT, parent),
    1,1,0, 0 },
  { "numitems",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DICTIONARYWDFLT, numitems),
    0,0,0, 0 },
  { "cloning",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DICTIONARYWDFLT, cloning),
    0,0,0, 281 },
  { "hard_owner",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARYWDFLT, hard_owner),
    0,0,0, 280 },
  { "texts",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_object_DICTIONARYWDFLT, texts),
    1,1,0, 3 },
  { "itemhandles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DICTIONARYWDFLT, itemhandles),
    1,1,0, 350 },
  { "cloning_r14",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_object_DICTIONARYWDFLT, cloning_r14),
    0,0,0, 0 },
  { "defaultid",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DICTIONARYWDFLT, defaultid),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DIMASSOC: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMASSOC_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DIMASSOC, parent),
    1,1,0, 0 },
  { "associativity",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DIMASSOC, associativity),
    0,0,0, 90 },
  { "trans_space_flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DIMASSOC, trans_space_flag),
    0,0,0, 70 },
  { "ref",	"Dwg_DIMASSOC_Ref*", sizeof (Dwg_DIMASSOC_Ref*),  OFF (struct _dwg_object_DIMASSOC, ref),
    1,1,0, 0 },
  { "intsect_gsmarker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DIMASSOC, intsect_gsmarker),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DIMSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DIMSTYLE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DIMSTYLE, flag),
    0,0,0, 70 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_DIMSTYLE, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, xrefdep),
    0,0,0, 0 },
  { "DIMTOL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTOL),
    0,0,0, 71 },
  { "DIMLIM",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMLIM),
    0,0,0, 72 },
  { "DIMTIH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTIH),
    0,0,0, 73 },
  { "DIMTOH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTOH),
    0,0,0, 74 },
  { "DIMSE1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSE1),
    0,0,0, 75 },
  { "DIMSE2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSE2),
    0,0,0, 76 },
  { "DIMALT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMALT),
    0,0,0, 170 },
  { "DIMTOFL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTOFL),
    0,0,0, 172 },
  { "DIMSAH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSAH),
    0,0,0, 173 },
  { "DIMTIX",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTIX),
    0,0,0, 174 },
  { "DIMSOXD",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSOXD),
    0,0,0, 175 },
  { "DIMALTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTD),
    0,0,0, 171 },
  { "DIMZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMZIN),
    0,0,0, 78 },
  { "DIMSD1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSD1),
    0,0,0, 281 },
  { "DIMSD2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSD2),
    0,0,0, 282 },
  { "DIMTOLJ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTOLJ),
    0,0,0, 283 },
  { "DIMJUST",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMJUST),
    0,0,0, 280 },
  { "DIMFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMFIT),
    0,0,0, 289 },
  { "DIMUPT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMUPT),
    0,0,0, 288 },
  { "DIMTZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTZIN),
    0,0,0, 284 },
  { "DIMMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMMALTZ),
    0,0,0, 285 },
  { "DIMMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMMALTTZ),
    0,0,0, 286 },
  { "DIMTAD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTAD),
    0,0,0, 77 },
  { "DIMUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMUNIT),
    0,0,0, 270 },
  { "DIMAUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMAUNIT),
    0,0,0, 275 },
  { "DIMDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMDEC),
    0,0,0, 271 },
  { "DIMTDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTDEC),
    0,0,0, 272 },
  { "DIMALTU",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTU),
    0,0,0, 273 },
  { "DIMALTTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTTD),
    0,0,0, 274 },
  { "DIMSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMSCALE),
    0,0,0, 40 },
  { "DIMASZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMASZ),
    0,0,0, 41 },
  { "DIMEXO",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMEXO),
    0,0,0, 42 },
  { "DIMDLI",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMDLI),
    0,0,0, 43 },
  { "DIMEXE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMEXE),
    0,0,0, 44 },
  { "DIMRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMRND),
    0,0,0, 45 },
  { "DIMDLE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMDLE),
    0,0,0, 46 },
  { "DIMTP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTP),
    0,0,0, 47 },
  { "DIMTM",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTM),
    0,0,0, 48 },
  { "DIMFXL",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMFXL),
    0,0,0, 49 },
  { "DIMJOGANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMJOGANG),
    0,0,0, 50 },
  { "DIMTFILL",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTFILL),
    0,0,0, 69 },
  { "DIMTFILLCLR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMTFILLCLR),
    1,0,0, 70 },
  { "DIMAZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMAZIN),
    0,0,0, 79 },
  { "DIMARCSYM",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMARCSYM),
    0,0,0, 90 },
  { "DIMTXT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTXT),
    0,0,0, 140 },
  { "DIMCEN",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMCEN),
    0,0,0, 141 },
  { "DIMTSZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTSZ),
    0,0,0, 142 },
  { "DIMALTF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMALTF),
    0,0,0, 143 },
  { "DIMLFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMLFAC),
    0,0,0, 144 },
  { "DIMTVP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTVP),
    0,0,0, 145 },
  { "DIMTFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTFAC),
    0,0,0, 146 },
  { "DIMGAP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMGAP),
    0,0,0, 147 },
  { "DIMPOST",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMPOST),
    1,1,1, 3 },
  { "DIMAPOST",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMAPOST),
    1,1,1, 4 },
  { "DIMBLK_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK_T),
    1,1,1, 5 },
  { "DIMBLK1_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK1_T),
    1,1,1, 6 },
  { "DIMBLK2_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK2_T),
    1,1,1, 7 },
  { "DIMALTRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMALTRND),
    0,0,0, 148 },
  { "DIMCLRD_N",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRD_N),
    0,0,0, 176 },
  { "DIMCLRE_N",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRE_N),
    0,0,0, 177 },
  { "DIMCLRT_N",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRT_N),
    0,0,0, 178 },
  { "DIMCLRD",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRD),
    1,0,0, 176 },
  { "DIMCLRE",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRE),
    1,0,0, 177 },
  { "DIMCLRT",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRT),
    1,0,0, 178 },
  { "DIMADEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMADEC),
    0,0,0, 179 },
  { "DIMFRAC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMFRAC),
    0,0,0, 276 },
  { "DIMLUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMLUNIT),
    0,0,0, 277 },
  { "DIMDSEP",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMDSEP),
    0,0,0, 278 },
  { "DIMTMOVE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTMOVE),
    0,0,0, 279 },
  { "DIMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTZ),
    0,0,0, 285 },
  { "DIMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTTZ),
    0,0,0, 286 },
  { "DIMATFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMATFIT),
    0,0,0, 0 },
  { "DIMFXLON",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMFXLON),
    0,0,0, 290 },
  { "DIMTXTDIRECTION",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTXTDIRECTION),
    0,0,0, 295 },
  { "DIMALTMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMALTMZF),
    0,0,0, 0 },
  { "DIMALTMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMALTMZS),
    1,1,1, 0 },
  { "DIMMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMMZF),
    0,0,0, 0 },
  { "DIMMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMMZS),
    1,1,1, 0 },
  { "DIMLWD",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_object_DIMSTYLE, DIMLWD),
    0,0,0, 371 },
  { "DIMLWE",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_object_DIMSTYLE, DIMLWE),
    0,0,0, 372 },
  { "extref_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, extref_handle),
    1,0,0, 0 },
  { "DIMTXSTY",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMTXSTY),
    1,0,0, 340 },
  { "DIMLDRBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLDRBLK),
    1,0,0, 341 },
  { "DIMBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK),
    1,0,0, 342 },
  { "DIMBLK1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK1),
    1,0,0, 343 },
  { "DIMBLK2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK2),
    1,0,0, 344 },
  { "DIMLTYPE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLTYPE),
    1,0,0, 345 },
  { "DIMLTEX1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLTEX1),
    1,0,0, 346 },
  { "DIMLTEX2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLTEX2),
    1,0,0, 347 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DIMSTYLE_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMSTYLE_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, objid),
    0,0,0, 0 },
  { "num_morehandles",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, num_morehandles),
    0,0,0, 71 },
  { "morehandles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, morehandles),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DUMMY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DUMMY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DUMMY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DYNAMICBLOCKPURGEPREVENTER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER, flag),
    0,0,0, 70 },
  { "unknown_rs1",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER, unknown_rs1),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_EVALUATION_GRAPH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EVALUATION_GRAPH_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_EVALUATION_GRAPH, parent),
    1,1,0, 0 },
  { "has_graph",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, has_graph),
    0,0,0, 96 },
  { "unknown1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, unknown1),
    0,0,0, 97 },
  { "unknown2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, unknown2),
    0,0,0, 0 },
  { "nodeid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, nodeid),
    0,0,0, 91 },
  { "edge_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, edge_flags),
    0,0,0, 93 },
  { "num_evalexpr",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, num_evalexpr),
    0,0,0, 95 },
  { "node_edge1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, node_edge1),
    0,0,0, 92 },
  { "node_edge2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, node_edge2),
    0,0,0, 92 },
  { "node_edge3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, node_edge3),
    0,0,0, 92 },
  { "node_edge4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, node_edge4),
    0,0,0, 92 },
  { "evalexpr",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_EVALUATION_GRAPH, evalexpr),
    1,1,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_FIELD: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FIELD_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_FIELD, parent),
    1,1,0, 0 },
  { "id",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, id),
    1,1,1, 1 },
  { "code",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, code),
    1,1,1, 2 },
  { "num_childs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, num_childs),
    0,0,0, 90 },
  { "childs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_FIELD, childs),
    1,1,0, 360 },
  { "num_objects",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, num_objects),
    0,0,0, 97 },
  { "objects",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_FIELD, objects),
    1,1,0, 331 },
  { "format",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, format),
    1,1,1, 4 },
  { "evaluation_option",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, evaluation_option),
    0,0,0, 91 },
  { "filing_option",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, filing_option),
    0,0,0, 92 },
  { "field_state",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, field_state),
    0,0,0, 94 },
  { "evaluation_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, evaluation_status),
    0,0,0, 95 },
  { "evaluation_error_code",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, evaluation_error_code),
    0,0,0, 96 },
  { "evaluation_error_msg",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, evaluation_error_msg),
    1,1,1, 300 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_object_FIELD, value),
    0,0,0, 0 },
  { "value_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, value_string),
    1,1,1, 301 },
  { "value_string_length",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, value_string_length),
    0,0,0, 98 },
  { "num_childval",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, num_childval),
    0,0,0, 93 },
  { "childval",	"Dwg_FIELD_ChildValue*", sizeof (Dwg_FIELD_ChildValue*),  OFF (struct _dwg_object_FIELD, childval),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_FIELDLIST: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FIELDLIST_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_FIELDLIST, parent),
    1,1,0, 0 },
  { "num_fields",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELDLIST, num_fields),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_FIELDLIST, unknown),
    0,0,0, 0 },
  { "fields",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_FIELDLIST, fields),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GEODATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEODATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GEODATA, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, class_version),
    0,0,0, 90 },
  { "host_block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_GEODATA, host_block),
    1,0,0, 330 },
  { "coord_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEODATA, coord_type),
    0,0,0, 70 },
  { "design_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, design_pt),
    1,0,0, 10 },
  { "ref_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, ref_pt),
    1,0,0, 11 },
  { "obs_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, obs_pt),
    1,0,0, 0 },
  { "unit_scale_horiz",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, unit_scale_horiz),
    0,0,0, 40 },
  { "units_value_horiz",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, units_value_horiz),
    0,0,0, 91 },
  { "unit_scale_vert",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, unit_scale_vert),
    0,0,0, 41 },
  { "units_value_vert",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, units_value_vert),
    0,0,0, 92 },
  { "up_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, up_dir),
    1,0,0, 210 },
  { "north_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, north_dir),
    1,0,0, 12 },
  { "scale_est",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, scale_est),
    0,0,0, 95 },
  { "user_scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, user_scale_factor),
    0,0,0, 141 },
  { "sea_level_corr",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, sea_level_corr),
    0,0,0, 294 },
  { "sea_level_elev",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, sea_level_elev),
    0,0,0, 142 },
  { "coord_proj_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, coord_proj_radius),
    0,0,0, 143 },
  { "coord_system_def",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, coord_system_def),
    1,1,1, 0 },
  { "geo_rss_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, geo_rss_tag),
    1,1,1, 302 },
  { "coord_system_datum",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, coord_system_datum),
    1,1,1, 0 },
  { "coord_system_wkt",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, coord_system_wkt),
    1,1,1, 0 },
  { "observation_from_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, observation_from_tag),
    1,1,1, 305 },
  { "observation_to_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, observation_to_tag),
    1,1,1, 306 },
  { "observation_coverage_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, observation_coverage_tag),
    1,1,1, 0 },
  { "num_geomesh_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, num_geomesh_pts),
    0,0,0, 93 },
  { "geomesh_pts",	"Dwg_GEODATA_meshpt*", sizeof (Dwg_GEODATA_meshpt*),  OFF (struct _dwg_object_GEODATA, geomesh_pts),
    1,1,0, 0 },
  { "num_geomesh_faces",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, num_geomesh_faces),
    0,0,0, 96 },
  { "geomesh_faces",	"Dwg_GEODATA_meshface*", sizeof (Dwg_GEODATA_meshface*),  OFF (struct _dwg_object_GEODATA, geomesh_faces),
    1,1,0, 0 },
  { "has_civil_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, has_civil_data),
    0,0,0, 0 },
  { "obsolete_false",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, obsolete_false),
    0,0,0, 0 },
  { "north_dir_angle_deg",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, north_dir_angle_deg),
    0,0,0, 0 },
  { "north_dir_angle_rad",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, north_dir_angle_rad),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GEOMAPIMAGE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEOMAPIMAGE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GEOMAPIMAGE, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEOMAPIMAGE, class_version),
    0,0,0, 90 },
  { "pt0",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEOMAPIMAGE, pt0),
    1,0,0, 10 },
  { "size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_GEOMAPIMAGE, size),
    1,0,0, 13 },
  { "display_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, display_props),
    0,0,0, 70 },
  { "clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEOMAPIMAGE, clipping),
    0,0,0, 280 },
  { "brightness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_GEOMAPIMAGE, brightness),
    0,0,0, 281 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_GEOMAPIMAGE, contrast),
    0,0,0, 282 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_GEOMAPIMAGE, fade),
    0,0,0, 283 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, rotation),
    0,0,0, 0 },
  { "image_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_width),
    0,0,0, 0 },
  { "image_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_height),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEOMAPIMAGE, name),
    1,1,1, 0 },
  { "image_file",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_file),
    0,0,0, 0 },
  { "image_visibility",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_visibility),
    0,0,0, 0 },
  { "transparency",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, transparency),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, height),
    0,0,0, 0 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, width),
    0,0,0, 0 },
  { "show_rotation",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEOMAPIMAGE, show_rotation),
    0,0,0, 0 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, scale_factor),
    0,0,0, 0 },
  { "geoimage_brightness",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_brightness),
    0,0,0, 0 },
  { "geoimage_contrast",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_contrast),
    0,0,0, 0 },
  { "geoimage_fade",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_fade),
    0,0,0, 0 },
  { "geoimage_position",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_position),
    0,0,0, 0 },
  { "geoimage_width",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_width),
    0,0,0, 0 },
  { "geoimage_height",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_height),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GROUP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GROUP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GROUP, parent),
    1,1,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_GROUP, name),
    1,1,1, 300 },
  { "unnamed",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GROUP, unnamed),
    0,0,0, 70 },
  { "selectable",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GROUP, selectable),
    0,0,0, 71 },
  { "num_groups",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GROUP, num_groups),
    0,0,0, 0 },
  { "groups",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_GROUP, groups),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IDBUFFER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IDBUFFER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IDBUFFER, parent),
    1,1,0, 0 },
  { "unknown",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_IDBUFFER, unknown),
    0,0,0, 0 },
  { "num_obj_ids",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IDBUFFER, num_obj_ids),
    0,0,0, 0 },
  { "obj_ids",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_IDBUFFER, obj_ids),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IMAGEDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGEDEF_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IMAGEDEF, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IMAGEDEF, class_version),
    0,0,0, 90 },
  { "image_size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_IMAGEDEF, image_size),
    1,0,0, 10 },
  { "file_path",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_IMAGEDEF, file_path),
    1,1,1, 1 },
  { "is_loaded",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IMAGEDEF, is_loaded),
    0,0,0, 280 },
  { "resunits",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_IMAGEDEF, resunits),
    0,0,0, 281 },
  { "pixel_size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_IMAGEDEF, pixel_size),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IMAGEDEF_REACTOR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGEDEF_REACTOR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IMAGEDEF_REACTOR, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IMAGEDEF_REACTOR, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYER, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYER, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYER, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_LAYER, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYER, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, xrefdep),
    0,0,0, 0 },
  { "frozen",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, frozen),
    0,0,0, 0 },
  { "on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, on),
    0,0,0, 0 },
  { "frozen_in_new",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, frozen_in_new),
    0,0,0, 0 },
  { "locked",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, locked),
    0,0,0, 0 },
  { "plotflag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, plotflag),
    0,0,0, 290 },
  { "linewt",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LAYER, linewt),
    0,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_LAYER, color),
    1,0,0, 62 },
  { "color_rs",	"short", sizeof (short),  OFF (struct _dwg_object_LAYER, color_rs),
    0,0,0, 62 },
  { "ltype_rs",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_LAYER, ltype_rs),
    0,0,0, 7 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, xref),
    1,0,0, 0 },
  { "plotstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, plotstyle),
    1,0,0, 390 },
  { "material",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, material),
    1,0,0, 347 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, ltype),
    1,0,0, 6 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYER_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYER_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYER_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LAYER_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYER_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYER_INDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_INDEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYER_INDEX, parent),
    1,1,0, 0 },
  { "timestamp1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYER_INDEX, timestamp1),
    0,0,0, 40 },
  { "timestamp2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYER_INDEX, timestamp2),
    0,0,0, 40 },
  { "num_entries",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYER_INDEX, num_entries),
    0,0,0, 0 },
  { "entries",	"Dwg_LAYER_entry*", sizeof (Dwg_LAYER_entry*),  OFF (struct _dwg_object_LAYER_INDEX, entries),
    1,1,0, 0 },
  { "layer_entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LAYER_INDEX, layer_entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYOUT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYOUT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYOUT, parent),
    1,1,0, 0 },
  { "page_setup_name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYOUT, page_setup_name),
    1,1,1, 1 },
  { "printer_or_config",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYOUT, printer_or_config),
    1,1,1, 2 },
  { "plot_layout_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, plot_layout_flags),
    0,0,0, 70 },
  { "left_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, left_margin),
    0,0,0, 40 },
  { "bottom_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, bottom_margin),
    0,0,0, 41 },
  { "right_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, right_margin),
    0,0,0, 42 },
  { "top_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, top_margin),
    0,0,0, 43 },
  { "paper_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, paper_width),
    0,0,0, 44 },
  { "paper_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, paper_height),
    0,0,0, 45 },
  { "paper_size",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYOUT, paper_size),
    1,1,1, 4 },
  { "plot_origin",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_LAYOUT, plot_origin),
    1,0,0, 46 },
  { "paper_units",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, paper_units),
    0,0,0, 72 },
  { "plot_rotation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, plot_rotation),
    0,0,0, 73 },
  { "plot_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, plot_type),
    0,0,0, 74 },
  { "window_min",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_LAYOUT, window_min),
    1,0,0, 48 },
  { "window_max",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_LAYOUT, window_max),
    1,0,0, 140 },
  { "plot_view_name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYOUT, plot_view_name),
    1,1,1, 6 },
  { "real_world_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, real_world_units),
    0,0,0, 142 },
  { "drawing_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, drawing_units),
    0,0,0, 143 },
  { "current_style_sheet",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYOUT, current_style_sheet),
    1,1,1, 7 },
  { "scale_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, scale_type),
    0,0,0, 75 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, scale_factor),
    0,0,0, 147 },
  { "paper_image_origin",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_LAYOUT, paper_image_origin),
    1,0,0, 148 },
  { "shade_plot_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, shade_plot_mode),
    0,0,0, 76 },
  { "shade_plot_res_level",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, shade_plot_res_level),
    0,0,0, 77 },
  { "shade_plot_custom_dpi",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, shade_plot_custom_dpi),
    0,0,0, 78 },
  { "layout_name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYOUT, layout_name),
    1,1,1, 1 },
  { "tab_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, tab_order),
    0,0,0, 71 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, flag),
    0,0,0, 70 },
  { "ucs_origin",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, ucs_origin),
    1,0,0, 13 },
  { "minimum_limits",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_object_LAYOUT, minimum_limits),
    1,0,0, 10 },
  { "maximum_limits",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_object_LAYOUT, maximum_limits),
    1,0,0, 11 },
  { "ins_point",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, ins_point),
    1,0,0, 12 },
  { "ucs_x_axis",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, ucs_x_axis),
    1,0,0, 16 },
  { "ucs_y_axis",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, ucs_y_axis),
    1,0,0, 17 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, elevation),
    0,0,0, 146 },
  { "orthoview_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, orthoview_type),
    0,0,0, 76 },
  { "extent_min",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, extent_min),
    1,0,0, 14 },
  { "extent_max",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, extent_max),
    1,0,0, 15 },
  { "plot_view",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, plot_view),
    1,0,0, 6 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, visualstyle),
    1,0,0, 0 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, block_header),
    1,0,0, 330 },
  { "active_viewport",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, active_viewport),
    1,0,0, 331 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, base_ucs),
    1,0,0, 346 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, named_ucs),
    1,0,0, 345 },
  { "num_viewports",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYOUT, num_viewports),
    0,0,0, 0 },
  { "viewports",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LAYOUT, viewports),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LIGHTLIST: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LIGHTLIST_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LIGHTLIST, parent),
    1,1,0, 0 },
  { "dictionary",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LIGHTLIST, dictionary),
    1,0,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LIGHTLIST, class_version),
    0,0,0, 0 },
  { "num_lights",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LIGHTLIST, num_lights),
    0,0,0, 0 },
  { "lights_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LIGHTLIST, lights_handles),
    1,1,0, 0 },
  { "lights_names",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_object_LIGHTLIST, lights_names),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LONG_TRANSACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LONG_TRANSACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LONG_TRANSACTION, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LTYPE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LTYPE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LTYPE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LTYPE, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LTYPE, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_LTYPE, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LTYPE, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LTYPE, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LTYPE, xrefdep),
    0,0,0, 0 },
  { "description",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LTYPE, description),
    1,1,1, 3 },
  { "pattern_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LTYPE, pattern_len),
    0,0,0, 40 },
  { "alignment",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LTYPE, alignment),
    0,0,0, 72 },
  { "num_dashes",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LTYPE, num_dashes),
    0,0,0, 73 },
  { "dashes",	"Dwg_LTYPE_dash*", sizeof (Dwg_LTYPE_dash*),  OFF (struct _dwg_object_LTYPE, dashes),
    1,1,0, 0 },
  { "dashes_r11",	"RD*", sizeof (BITCODE_RD*),  OFF (struct _dwg_object_LTYPE, dashes_r11),
    1,1,0, 0 },
  { "text_area_is_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LTYPE, text_area_is_present),
    0,0,0, 0 },
  { "strings_area",	"TV", sizeof (char*),  OFF (struct _dwg_object_LTYPE, strings_area),
    1,1,1, 3 },
  { "extref_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LTYPE, extref_handle),
    1,0,0, 0 },
  { "styles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LTYPE, styles),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LTYPE_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LTYPE_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LTYPE_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LTYPE_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LTYPE_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LTYPE_CONTROL, objid),
    0,0,0, 0 },
  { "bylayer",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LTYPE_CONTROL, bylayer),
    1,0,0, 0 },
  { "byblock",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LTYPE_CONTROL, byblock),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MATERIAL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MATERIAL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MATERIAL, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, name),
    1,1,1, 1 },
  { "desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, desc),
    1,1,1, 2 },
  { "ambient_color_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, ambient_color_flag),
    0,0,0, 70 },
  { "ambient_color_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, ambient_color_factor),
    0,0,0, 40 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MATERIAL, ambient_color),
    1,0,0, 90 },
  { "diffuse_color_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, diffuse_color_flag),
    0,0,0, 71 },
  { "diffuse_color_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, diffuse_color_factor),
    0,0,0, 41 },
  { "diffuse_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MATERIAL, diffuse_color),
    1,0,0, 91 },
  { "diffusemap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, diffusemap_source),
    0,0,0, 72 },
  { "diffusemap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, diffusemap_filename),
    1,1,1, 3 },
  { "diffusemap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, diffusemap_blendfactor),
    0,0,0, 42 },
  { "diffusemap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, diffusemap_projection),
    0,0,0, 73 },
  { "diffusemap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, diffusemap_tiling),
    0,0,0, 74 },
  { "diffusemap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, diffusemap_autotransform),
    0,0,0, 75 },
  { "diffusemap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, diffusemap_transmatrix),
    1,1,0, 43 },
  { "specular_gloss_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, specular_gloss_factor),
    0,0,0, 44 },
  { "specular_color_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, specular_color_flag),
    0,0,0, 76 },
  { "specular_color_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, specular_color_factor),
    0,0,0, 45 },
  { "specular_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MATERIAL, specular_color),
    1,0,0, 92 },
  { "specularmap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, specularmap_source),
    0,0,0, 77 },
  { "specularmap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, specularmap_filename),
    1,1,1, 4 },
  { "specularmap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, specularmap_blendfactor),
    0,0,0, 46 },
  { "specularmap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, specularmap_projection),
    0,0,0, 78 },
  { "specularmap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, specularmap_tiling),
    0,0,0, 79 },
  { "specularmap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, specularmap_autotransform),
    0,0,0, 170 },
  { "specularmap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, specularmap_transmatrix),
    1,1,0, 47 },
  { "reflectionmap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, reflectionmap_source),
    0,0,0, 171 },
  { "reflectionmap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, reflectionmap_filename),
    1,1,1, 6 },
  { "reflectionmap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, reflectionmap_blendfactor),
    0,0,0, 48 },
  { "reflectionmap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, reflectionmap_projection),
    0,0,0, 172 },
  { "reflectionmap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, reflectionmap_tiling),
    0,0,0, 173 },
  { "reflectionmap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, reflectionmap_autotransform),
    0,0,0, 174 },
  { "reflectionmap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, reflectionmap_transmatrix),
    1,1,0, 49 },
  { "opacity_percent",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, opacity_percent),
    0,0,0, 140 },
  { "opacitymap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, opacitymap_source),
    0,0,0, 175 },
  { "opacitymap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, opacitymap_filename),
    1,1,1, 7 },
  { "opacitymap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, opacitymap_blendfactor),
    0,0,0, 141 },
  { "opacitymap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, opacitymap_projection),
    0,0,0, 176 },
  { "opacitymap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, opacitymap_tiling),
    0,0,0, 177 },
  { "opacitymap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, opacitymap_autotransform),
    0,0,0, 178 },
  { "opacitymap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, opacitymap_transmatrix),
    1,1,0, 142 },
  { "bumpmap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, bumpmap_source),
    0,0,0, 179 },
  { "bumpmap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, bumpmap_filename),
    1,1,1, 8 },
  { "bumpmap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, bumpmap_blendfactor),
    0,0,0, 143 },
  { "bumpmap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, bumpmap_projection),
    0,0,0, 270 },
  { "bumpmap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, bumpmap_tiling),
    0,0,0, 271 },
  { "bumpmap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, bumpmap_autotransform),
    0,0,0, 272 },
  { "bumpmap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, bumpmap_transmatrix),
    1,1,0, 144 },
  { "refraction_index",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, refraction_index),
    0,0,0, 145 },
  { "refractionmap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, refractionmap_source),
    0,0,0, 273 },
  { "refractionmap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, refractionmap_filename),
    1,1,1, 9 },
  { "refractionmap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, refractionmap_blendfactor),
    0,0,0, 146 },
  { "refractionmap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, refractionmap_projection),
    0,0,0, 274 },
  { "refractionmap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, refractionmap_tiling),
    0,0,0, 275 },
  { "refractionmap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, refractionmap_autotransform),
    0,0,0, 276 },
  { "refractionmap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, refractionmap_transmatrix),
    1,1,0, 147 },
  { "color_bleed_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, color_bleed_scale),
    0,0,0, 460 },
  { "indirect_dump_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, indirect_dump_scale),
    0,0,0, 461 },
  { "reflectance_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, reflectance_scale),
    0,0,0, 462 },
  { "transmittance_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, transmittance_scale),
    0,0,0, 463 },
  { "two_sided_material",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, two_sided_material),
    0,0,0, 290 },
  { "luminance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, luminance),
    0,0,0, 464 },
  { "luminance_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, luminance_mode),
    0,0,0, 270 },
  { "normalmap_method",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, normalmap_method),
    0,0,0, 271 },
  { "normalmap_strength",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, normalmap_strength),
    0,0,0, 465 },
  { "normalmap_source",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, normalmap_source),
    0,0,0, 72 },
  { "normalmap_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, normalmap_filename),
    1,1,1, 3 },
  { "normalmap_blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, normalmap_blendfactor),
    0,0,0, 42 },
  { "normalmap_projection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, normalmap_projection),
    0,0,0, 73 },
  { "normalmap_tiling",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, normalmap_tiling),
    0,0,0, 74 },
  { "normalmap_autotransform",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, normalmap_autotransform),
    0,0,0, 75 },
  { "normalmap_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MATERIAL, normalmap_transmatrix),
    1,1,0, 43 },
  { "materials_anonymous",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, materials_anonymous),
    0,0,0, 293 },
  { "global_illumination_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, global_illumination_mode),
    0,0,0, 272 },
  { "final_gather_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, final_gather_mode),
    0,0,0, 273 },
  { "genprocname",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, genprocname),
    1,1,1, 300 },
  { "genprocvalbool",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, genprocvalbool),
    0,0,0, 291 },
  { "genprocvalint",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, genprocvalint),
    0,0,0, 271 },
  { "genprocvalreal",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, genprocvalreal),
    0,0,0, 469 },
  { "genprocvaltext",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, genprocvaltext),
    1,1,1, 301 },
  { "genproctableend",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, genproctableend),
    0,0,0, 292 },
  { "genprocvalcolorindex",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MATERIAL, genprocvalcolorindex),
    1,0,0, 62 },
  { "genprocvalcolorrgb",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, genprocvalcolorrgb),
    0,0,0, 420 },
  { "genprocvalcolorname",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, genprocvalcolorname),
    1,1,1, 430 },
  { "map_utile",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, map_utile),
    0,0,0, 270 },
  { "translucence",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, translucence),
    0,0,0, 148 },
  { "self_illumination",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MATERIAL, self_illumination),
    0,0,0, 90 },
  { "reflectivity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, reflectivity),
    0,0,0, 468 },
  { "illumination_model",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MATERIAL, illumination_model),
    0,0,0, 93 },
  { "channel_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MATERIAL, channel_flags),
    0,0,0, 94 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MLEADERSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADERSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MLEADERSTYLE, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, class_version),
    0,0,0, 179 },
  { "content_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, content_type),
    0,0,0, 170 },
  { "mleader_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, mleader_order),
    0,0,0, 171 },
  { "leader_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, leader_order),
    0,0,0, 172 },
  { "max_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MLEADERSTYLE, max_points),
    0,0,0, 90 },
  { "first_seg_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, first_seg_angle),
    0,0,0, 40 },
  { "second_seg_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, second_seg_angle),
    0,0,0, 41 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, type),
    0,0,0, 173 },
  { "line_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLEADERSTYLE, line_color),
    1,0,0, 91 },
  { "line_type",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, line_type),
    1,0,0, 340 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_MLEADERSTYLE, linewt),
    0,0,0, 92 },
  { "has_landing",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, has_landing),
    0,0,0, 290 },
  { "has_dogleg",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, has_dogleg),
    0,0,0, 291 },
  { "landing_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, landing_gap),
    0,0,0, 42 },
  { "landing_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, landing_dist),
    0,0,0, 43 },
  { "description",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLEADERSTYLE, description),
    1,1,1, 3 },
  { "arrow_head",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, arrow_head),
    1,0,0, 341 },
  { "arrow_head_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, arrow_head_size),
    0,0,0, 44 },
  { "text_default",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLEADERSTYLE, text_default),
    1,1,1, 300 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, text_style),
    1,0,0, 342 },
  { "attach_left",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_left),
    0,0,0, 174 },
  { "attach_right",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_right),
    0,0,0, 178 },
  { "text_angle_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, text_angle_type),
    0,0,0, 175 },
  { "text_align_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, text_align_type),
    0,0,0, 176 },
  { "text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLEADERSTYLE, text_color),
    1,0,0, 93 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, text_height),
    0,0,0, 45 },
  { "text_frame",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, text_frame),
    0,0,0, 292 },
  { "is_new_format",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, is_new_format),
    0,0,0, 0 },
  { "text_always_left",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, text_always_left),
    0,0,0, 297 },
  { "align_space",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, align_space),
    0,0,0, 46 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, block),
    1,0,0, 343 },
  { "block_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLEADERSTYLE, block_color),
    1,0,0, 94 },
  { "block_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_MLEADERSTYLE, block_scale),
    1,0,0, 0 },
  { "use_block_scale",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, use_block_scale),
    0,0,0, 293 },
  { "block_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, block_rotation),
    0,0,0, 141 },
  { "use_block_rotation",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, use_block_rotation),
    0,0,0, 294 },
  { "block_connection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, block_connection),
    0,0,0, 177 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, scale),
    0,0,0, 142 },
  { "changed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, changed),
    0,0,0, 295 },
  { "is_annotative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, is_annotative),
    0,0,0, 296 },
  { "break_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, break_size),
    0,0,0, 143 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_dir),
    0,0,0, 271 },
  { "attach_top",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_top),
    0,0,0, 273 },
  { "attach_bottom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_bottom),
    0,0,0, 272 },
  { "text_extended",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, text_extended),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MLINESTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINESTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MLINESTYLE, parent),
    1,1,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLINESTYLE, name),
    1,1,1, 2 },
  { "desc",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLINESTYLE, desc),
    1,1,1, 3 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLINESTYLE, flag),
    0,0,0, 70 },
  { "fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLINESTYLE, fill_color),
    1,0,0, 62 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLINESTYLE, start_angle),
    0,0,0, 51 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLINESTYLE, end_angle),
    0,0,0, 52 },
  { "num_lines",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_MLINESTYLE, num_lines),
    0,0,0, 71 },
  { "lines",	"Dwg_MLINESTYLE_line*", sizeof (Dwg_MLINESTYLE_line*),  OFF (struct _dwg_object_MLINESTYLE, lines),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_NAVISWORKSMODELDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_NAVISWORKSMODELDEF_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, parent),
    1,1,0, 0 },
  { "path",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, path),
    1,1,1, 1 },
  { "status",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, status),
    0,0,0, 290 },
  { "min_extent",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, min_extent),
    1,0,0, 10 },
  { "max_extent",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, max_extent),
    1,0,0, 11 },
  { "host_drawing_visibility",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, host_drawing_visibility),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_OBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_OBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_OBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "has_file",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_OBJECTCONTEXTDATA, has_file),
    0,0,0, 290 },
  { "defaultflag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_OBJECTCONTEXTDATA, defaultflag),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_OBJECT_PTR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OBJECT_PTR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_OBJECT_PTR, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PERSSUBENTMANAGER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PERSSUBENTMANAGER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PERSSUBENTMANAGER, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, class_version),
    0,0,0, 90 },
  { "unknown_bl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, unknown_bl1),
    0,0,0, 90 },
  { "unknown_bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, unknown_bl2),
    0,0,0, 90 },
  { "unknown_bl3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, unknown_bl3),
    0,0,0, 90 },
  { "unknown_bl4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, unknown_bl4),
    0,0,0, 90 },
  { "unknown_bl5",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, unknown_bl5),
    0,0,0, 90 },
  { "unknown_bl6",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSSUBENTMANAGER, unknown_bl6),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PLACEHOLDER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PLACEHOLDER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PLACEHOLDER, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PLOTSETTINGS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PLOTSETTINGS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PLOTSETTINGS, parent),
    1,1,0, 0 },
  { "page_setup_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, page_setup_name),
    1,1,1, 1 },
  { "printer_cfg_file",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, printer_cfg_file),
    1,1,1, 2 },
  { "paper_size",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, paper_size),
    1,1,1, 4 },
  { "plotview",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_PLOTSETTINGS, plotview),
    1,0,0, 6 },
  { "left_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, left_margin),
    0,0,0, 40 },
  { "bottom_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, bottom_margin),
    0,0,0, 41 },
  { "right_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, right_margin),
    0,0,0, 42 },
  { "top_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, top_margin),
    0,0,0, 43 },
  { "paper_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, paper_width),
    0,0,0, 44 },
  { "paper_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, paper_height),
    0,0,0, 45 },
  { "plot_origin",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, plot_origin),
    1,0,0, 46 },
  { "plot_window_ll",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, plot_window_ll),
    1,0,0, 48 },
  { "plot_window_ur",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, plot_window_ur),
    1,0,0, 140 },
  { "num_custom_print_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, num_custom_print_scale),
    0,0,0, 142 },
  { "den_custom_print_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, den_custom_print_scale),
    0,0,0, 143 },
  { "plot_layout",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_layout),
    0,0,0, 70 },
  { "plot_paper_units",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_paper_units),
    0,0,0, 72 },
  { "plot_rotation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_rotation),
    0,0,0, 73 },
  { "plot_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_type),
    0,0,0, 74 },
  { "stylesheet",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_PLOTSETTINGS, stylesheet),
    1,0,0, 7 },
  { "use_std_scale",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_PLOTSETTINGS, use_std_scale),
    0,0,0, 0 },
  { "std_scale_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, std_scale_type),
    0,0,0, 75 },
  { "std_scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, std_scale_factor),
    0,0,0, 147 },
  { "shade_plot_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, shade_plot_mode),
    0,0,0, 76 },
  { "shade_plot_res_level",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, shade_plot_res_level),
    0,0,0, 77 },
  { "shade_plot_custom_dpi",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, shade_plot_custom_dpi),
    0,0,0, 78 },
  { "paper_image_origin",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, paper_image_origin),
    1,0,0, 148 },
  { "shade_plot_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_PLOTSETTINGS, shade_plot_id),
    1,0,0, 333 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PROXY_OBJECT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PROXY_OBJECT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PROXY_OBJECT, parent),
    1,1,0, 0 },
  { "class_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, class_id),
    0,0,0, 91 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, version),
    0,0,0, 71 },
  { "maint_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, maint_version),
    0,0,0, 97 },
  { "from_dxf",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_PROXY_OBJECT, from_dxf),
    0,0,0, 70 },
  { "data",	"TV", sizeof (char*),  OFF (struct _dwg_object_PROXY_OBJECT, data),
    1,1,1, 0 },
  { "objid_object_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_PROXY_OBJECT, objid_object_handles),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RASTERVARIABLES: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RASTERVARIABLES_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RASTERVARIABLES, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RASTERVARIABLES, class_version),
    0,0,0, 90 },
  { "display_frame",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RASTERVARIABLES, display_frame),
    0,0,0, 70 },
  { "display_quality",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RASTERVARIABLES, display_quality),
    0,0,0, 71 },
  { "units",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RASTERVARIABLES, units),
    0,0,0, 72 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RENDERENVIRONMENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RENDERENVIRONMENT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RENDERENVIRONMENT, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENVIRONMENT, class_version),
    0,0,0, 90 },
  { "fog_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_enabled),
    0,0,0, 290 },
  { "fog_background_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_background_enabled),
    0,0,0, 290 },
  { "fog_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_color),
    1,0,0, 0 },
  { "fog_density_near",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_density_near),
    0,0,0, 40 },
  { "fog_density_far",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_density_far),
    0,0,0, 40 },
  { "fog_distance_near",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_distance_near),
    0,0,0, 40 },
  { "fog_distance_far",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_distance_far),
    0,0,0, 40 },
  { "environ_image_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERENVIRONMENT, environ_image_enabled),
    0,0,0, 290 },
  { "environ_image_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERENVIRONMENT, environ_image_filename),
    1,1,1, 1 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RENDERGLOBAL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RENDERGLOBAL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RENDERGLOBAL, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, class_version),
    0,0,0, 90 },
  { "procedure",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, procedure),
    0,0,0, 90 },
  { "destination",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, destination),
    0,0,0, 90 },
  { "save_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERGLOBAL, save_enabled),
    0,0,0, 290 },
  { "save_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERGLOBAL, save_filename),
    1,1,1, 1 },
  { "image_width",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, image_width),
    0,0,0, 90 },
  { "image_height",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, image_height),
    0,0,0, 90 },
  { "predef_presets_first",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERGLOBAL, predef_presets_first),
    0,0,0, 290 },
  { "highlevel_info",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERGLOBAL, highlevel_info),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SCALE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SCALE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SCALE, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SCALE, flag),
    0,0,0, 70 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_SCALE, name),
    1,1,1, 300 },
  { "paper_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SCALE, paper_units),
    0,0,0, 140 },
  { "drawing_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SCALE, drawing_units),
    0,0,0, 141 },
  { "has_unit_scale",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SCALE, has_unit_scale),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SORTENTSTABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SORTENTSTABLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SORTENTSTABLE, parent),
    1,1,0, 0 },
  { "num_ents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SORTENTSTABLE, num_ents),
    0,0,0, 0 },
  { "sort_ents",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_SORTENTSTABLE, sort_ents),
    1,1,0, 5 },
  { "dictionary",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SORTENTSTABLE, dictionary),
    1,0,0, 0 },
  { "ents",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_SORTENTSTABLE, ents),
    1,1,0, 331 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SPATIAL_FILTER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPATIAL_FILTER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SPATIAL_FILTER, parent),
    1,1,0, 0 },
  { "num_points",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, num_points),
    0,0,0, 70 },
  { "points",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_object_SPATIAL_FILTER, points),
    1,1,0, 10 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_SPATIAL_FILTER, extrusion),
    1,0,0, 210 },
  { "clip_bound_origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_SPATIAL_FILTER, clip_bound_origin),
    1,0,0, 10 },
  { "display_boundary",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, display_boundary),
    0,0,0, 71 },
  { "front_clip_on",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, front_clip_on),
    0,0,0, 72 },
  { "front_clip_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SPATIAL_FILTER, front_clip_dist),
    0,0,0, 40 },
  { "back_clip_on",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, back_clip_on),
    0,0,0, 73 },
  { "back_clip_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SPATIAL_FILTER, back_clip_dist),
    0,0,0, 41 },
  { "inverse_block_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_SPATIAL_FILTER, inverse_block_transform),
    1,1,0, 40 },
  { "clip_bound_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_SPATIAL_FILTER, clip_bound_transform),
    1,1,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SPATIAL_INDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPATIAL_INDEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SPATIAL_INDEX, parent),
    1,1,0, 0 },
  { "timestamp1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SPATIAL_INDEX, timestamp1),
    0,0,0, 0 },
  { "timestamp2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SPATIAL_INDEX, timestamp2),
    0,0,0, 0 },
  { "unknown",	"TV", sizeof (char*),  OFF (struct _dwg_object_SPATIAL_INDEX, unknown),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_STYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_STYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_STYLE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_STYLE, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_STYLE, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_STYLE, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_STYLE, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, xrefdep),
    0,0,0, 0 },
  { "vertical",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, vertical),
    0,0,0, 0 },
  { "shape_file",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, shape_file),
    0,0,0, 0 },
  { "fixed_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, fixed_height),
    0,0,0, 40 },
  { "width_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, width_factor),
    0,0,0, 41 },
  { "oblique_ang",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, oblique_ang),
    0,0,0, 50 },
  { "generation",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_STYLE, generation),
    0,0,0, 71 },
  { "last_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, last_height),
    0,0,0, 42 },
  { "font_name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_STYLE, font_name),
    1,1,1, 3 },
  { "bigfont_name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_STYLE, bigfont_name),
    1,1,1, 4 },
  { "extref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_STYLE, extref),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_STYLE_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_STYLE_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_STYLE_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_STYLE_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_STYLE_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_STYLE_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SUN: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SUN_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SUN, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, class_version),
    0,0,0, 90 },
  { "is_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUN, is_on),
    0,0,0, 290 },
  { "unknown",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SUN, unknown),
    0,0,0, 421 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SUN, color),
    1,0,0, 63 },
  { "intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SUN, intensity),
    0,0,0, 40 },
  { "julian_day",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, julian_day),
    0,0,0, 91 },
  { "time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, time),
    0,0,0, 92 },
  { "is_dst",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUN, is_dst),
    0,0,0, 292 },
  { "has_shadow",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUN, has_shadow),
    0,0,0, 291 },
  { "shadow_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SUN, shadow_type),
    0,0,0, 70 },
  { "shadow_mapsize",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SUN, shadow_mapsize),
    0,0,0, 71 },
  { "shadow_softness",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SUN, shadow_softness),
    0,0,0, 280 },
  { "skyparams",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUN, skyparams),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SUNSTUDY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SUNSTUDY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SUNSTUDY, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, class_version),
    0,0,0, 90 },
  { "setup_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, setup_name),
    1,1,1, 1 },
  { "desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, desc),
    1,1,1, 2 },
  { "output_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, output_type),
    0,0,0, 70 },
  { "sheet_set_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, sheet_set_name),
    1,1,1, 3 },
  { "use_subset",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, use_subset),
    0,0,0, 290 },
  { "sheet_subset_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, sheet_subset_name),
    1,1,1, 4 },
  { "select_dates_from_calendar",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, select_dates_from_calendar),
    0,0,0, 291 },
  { "num_dates",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, num_dates),
    0,0,0, 91 },
  { "dates",	"Dwg_SUNSTUDY_Dates*", sizeof (Dwg_SUNSTUDY_Dates*),  OFF (struct _dwg_object_SUNSTUDY, dates),
    1,1,0, 0 },
  { "select_range_of_dates",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, select_range_of_dates),
    0,0,0, 292 },
  { "start_time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, start_time),
    0,0,0, 93 },
  { "end_time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, end_time),
    0,0,0, 94 },
  { "interval",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, interval),
    0,0,0, 95 },
  { "num_hours",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, num_hours),
    0,0,0, 91 },
  { "hours",	"B*", sizeof (BITCODE_B*),  OFF (struct _dwg_object_SUNSTUDY, hours),
    1,1,0, 290 },
  { "shade_plot_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, shade_plot_type),
    0,0,0, 74 },
  { "numvports",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, numvports),
    0,0,0, 75 },
  { "numrows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, numrows),
    0,0,0, 76 },
  { "numcols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, numcols),
    0,0,0, 77 },
  { "spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SUNSTUDY, spacing),
    0,0,0, 40 },
  { "lock_viewports",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, lock_viewports),
    0,0,0, 293 },
  { "label_viewports",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, label_viewports),
    0,0,0, 294 },
  { "page_setup_wizard",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, page_setup_wizard),
    1,0,0, 340 },
  { "view",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, view),
    1,0,0, 341 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, visualstyle),
    1,0,0, 342 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, text_style),
    1,0,0, 343 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TABLECONTENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLECONTENT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TABLECONTENT, parent),
    1,1,0, 0 },
  { "ldata",	"Dwg_LinkedData", sizeof (Dwg_LinkedData),  OFF (struct _dwg_object_TABLECONTENT, ldata),
    0,0,0, 0 },
  { "tdata",	"Dwg_LinkedTableData", sizeof (Dwg_LinkedTableData),  OFF (struct _dwg_object_TABLECONTENT, tdata),
    0,0,0, 0 },
  { "fdata",	"Dwg_FormattedTableData", sizeof (Dwg_FormattedTableData),  OFF (struct _dwg_object_TABLECONTENT, fdata),
    0,0,0, 0 },
  { "table_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_TABLECONTENT, table_style),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TABLEGEOMETRY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLEGEOMETRY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TABLEGEOMETRY, parent),
    1,1,0, 0 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLEGEOMETRY, num_rows),
    0,0,0, 90 },
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLEGEOMETRY, num_cols),
    0,0,0, 91 },
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLEGEOMETRY, num_cells),
    0,0,0, 92 },
  { "cells",	"Dwg_TABLEGEOMETRY_Cell*", sizeof (Dwg_TABLEGEOMETRY_Cell*),  OFF (struct _dwg_object_TABLEGEOMETRY, cells),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TABLESTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TABLESTYLE, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TABLESTYLE, class_version),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_TABLESTYLE, name),
    1,1,1, 3 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TABLESTYLE, flags),
    0,0,0, 71 },
  { "flow_direction",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TABLESTYLE, flow_direction),
    0,0,0, 70 },
  { "horiz_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TABLESTYLE, horiz_cell_margin),
    0,0,0, 40 },
  { "vert_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TABLESTYLE, vert_cell_margin),
    0,0,0, 41 },
  { "title_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_TABLESTYLE, title_suppressed),
    0,0,0, 280 },
  { "header_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_TABLESTYLE, header_suppressed),
    0,0,0, 281 },
  { "num_rowstyles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, num_rowstyles),
    0,0,0, 0 },
  { "rowstyles",	"Dwg_TABLESTYLE_rowstyles*", sizeof (Dwg_TABLESTYLE_rowstyles*),  OFF (struct _dwg_object_TABLESTYLE, rowstyles),
    1,1,0, 0 },
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, num_cells),
    0,0,0, 0 },
  { "cells",	"Dwg_TABLESTYLE_Cell*", sizeof (Dwg_TABLESTYLE_Cell*),  OFF (struct _dwg_object_TABLESTYLE, cells),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UCS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UCS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UCS, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_UCS, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_UCS, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_UCS, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_UCS, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_UCS, xrefdep),
    0,0,0, 0 },
  { "origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_UCS, origin),
    1,0,0, 10 },
  { "x_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_UCS, x_direction),
    1,0,0, 11 },
  { "y_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_UCS, y_direction),
    1,0,0, 12 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_UCS, elevation),
    0,0,0, 146 },
  { "orthographic_view_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS, orthographic_view_type),
    0,0,0, 71 },
  { "orthographic_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS, orthographic_type),
    0,0,0, 71 },
  { "null_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_UCS, null_handle),
    1,0,0, 0 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_UCS, base_ucs),
    1,0,0, 346 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_UCS, named_ucs),
    1,0,0, 345 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UCS_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UCS_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UCS_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_UCS_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_UCS_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UNDERLAYDEFINITION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNDERLAYDEFINITION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UNDERLAYDEFINITION, parent),
    1,1,0, 0 },
  { "filename",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_UNDERLAYDEFINITION, filename),
    1,1,1, 1 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_UNDERLAYDEFINITION, name),
    1,1,1, 2 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UNKNOWN_OBJ: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNKNOWN_OBJ_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UNKNOWN_OBJ, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VBA_PROJECT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VBA_PROJECT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VBA_PROJECT, parent),
    1,1,0, 0 },
  { "num_bytes",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_object_VBA_PROJECT, num_bytes),
    0,0,0, 0 },
  { "bytes",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_VBA_PROJECT, bytes),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VIEW: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VIEW_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VIEW, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VIEW, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VIEW, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_VIEW, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VIEW, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, xrefdep),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, height),
    0,0,0, 40 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, width),
    0,0,0, 41 },
  { "center",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VIEW, center),
    1,0,0, 20 },
  { "target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, target),
    1,0,0, 12 },
  { "direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, direction),
    1,0,0, 11 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, twist_angle),
    0,0,0, 50 },
  { "lens_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, lens_length),
    0,0,0, 42 },
  { "front_clip",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, front_clip),
    0,0,0, 43 },
  { "back_clip",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, back_clip),
    0,0,0, 44 },
  { "VIEWMODE",	"4BITS", sizeof (BITCODE_4BITS),  OFF (struct _dwg_object_VIEW, VIEWMODE),
    0,0,0, 71 },
  { "render_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VIEW, render_mode),
    0,0,0, 281 },
  { "use_default_lights",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, use_default_lights),
    0,0,0, 292 },
  { "default_lightning_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VIEW, default_lightning_type),
    0,0,0, 282 },
  { "brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, brightness),
    0,0,0, 141 },
  { "contrast",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, contrast),
    0,0,0, 142 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VIEW, ambient_color),
    1,0,0, 63 },
  { "pspace_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, pspace_flag),
    0,0,0, 0 },
  { "associated_ucs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, associated_ucs),
    0,0,0, 72 },
  { "origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, origin),
    1,0,0, 110 },
  { "x_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, x_direction),
    1,0,0, 111 },
  { "y_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, y_direction),
    1,0,0, 112 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, elevation),
    0,0,0, 146 },
  { "orthographic_view_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VIEW, orthographic_view_type),
    0,0,0, 79 },
  { "camera_plottable",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, camera_plottable),
    0,0,0, 73 },
  { "null_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, null_handle),
    1,0,0, 0 },
  { "background",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, background),
    1,0,0, 332 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, visualstyle),
    1,0,0, 348 },
  { "sun",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, sun),
    1,0,0, 361 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, base_ucs),
    1,0,0, 346 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, named_ucs),
    1,0,0, 345 },
  { "livesection",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, livesection),
    1,0,0, 334 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VIEW_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VIEW_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VIEW_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VIEW_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_VIEW_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VIEW_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VISUALSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VISUALSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VISUALSTYLE, parent),
    1,1,0, 0 },
  { "desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_VISUALSTYLE, desc),
    1,1,1, 2 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, type),
    0,0,0, 70 },
  { "face_lighting_model",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_lighting_model),
    0,0,0, 71 },
  { "face_lighting_quality",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_lighting_quality),
    0,0,0, 72 },
  { "face_color_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_color_mode),
    0,0,0, 73 },
  { "face_opacity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, face_opacity),
    0,0,0, 40 },
  { "face_specular",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, face_specular),
    0,0,0, 41 },
  { "face_modifier",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_modifier),
    0,0,0, 90 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, color),
    1,0,0, 62 },
  { "face_mono_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, face_mono_color),
    1,0,0, 63 },
  { "edge_model",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_model),
    0,0,0, 74 },
  { "edge_style",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_style),
    0,0,0, 91 },
  { "edge_intersection_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_intersection_color),
    1,0,0, 64 },
  { "edge_obscured_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_obscured_color),
    1,0,0, 65 },
  { "edge_obscured_line_pattern",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_obscured_line_pattern),
    0,0,0, 75 },
  { "edge_intersection_line_pattern",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_intersection_line_pattern),
    0,0,0, 175 },
  { "edge_crease_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, edge_crease_angle),
    0,0,0, 42 },
  { "edge_modifier",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_modifier),
    0,0,0, 92 },
  { "edge_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_color),
    1,0,0, 66 },
  { "edge_opacity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, edge_opacity),
    0,0,0, 43 },
  { "edge_width",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_width),
    0,0,0, 76 },
  { "edge_overhang",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_overhang),
    0,0,0, 77 },
  { "edge_jitter",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_jitter),
    0,0,0, 78 },
  { "edge_silhouette_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_silhouette_color),
    1,0,0, 67 },
  { "edge_silhouette_width",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_silhouette_width),
    0,0,0, 79 },
  { "edge_halo_gap",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_halo_gap),
    0,0,0, 170 },
  { "num_edge_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, num_edge_isolines),
    0,0,0, 171 },
  { "edge_hide_precision_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_hide_precision_flag),
    0,0,0, 290 },
  { "edge_style_apply_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_style_apply_flag),
    0,0,0, 174 },
  { "display_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, display_style),
    0,0,0, 93 },
  { "display_brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, display_brightness),
    0,0,0, 44 },
  { "display_shadow_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, display_shadow_type),
    0,0,0, 173 },
  { "is_internal_use_only",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, is_internal_use_only),
    0,0,0, 291 },
  { "unknown_float45",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, unknown_float45),
    0,0,0, 45 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VPORT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VPORT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VPORT, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VPORT, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_VPORT, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, xrefdep),
    0,0,0, 0 },
  { "VIEWSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, VIEWSIZE),
    0,0,0, 40 },
  { "viewwidth",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, viewwidth),
    0,0,0, 0 },
  { "aspect_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, aspect_ratio),
    0,0,0, 41 },
  { "VIEWCTR",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, VIEWCTR),
    1,0,0, 12 },
  { "view_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, view_target),
    1,0,0, 17 },
  { "VIEWDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, VIEWDIR),
    1,0,0, 16 },
  { "view_twist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, view_twist),
    0,0,0, 51 },
  { "lens_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, lens_length),
    0,0,0, 42 },
  { "front_clip",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, front_clip),
    0,0,0, 43 },
  { "back_clip",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, back_clip),
    0,0,0, 44 },
  { "VIEWMODE",	"4BITS", sizeof (BITCODE_4BITS),  OFF (struct _dwg_object_VPORT, VIEWMODE),
    0,0,0, 71 },
  { "render_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, render_mode),
    0,0,0, 281 },
  { "use_default_lights",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, use_default_lights),
    0,0,0, 292 },
  { "default_lightning_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, default_lightning_type),
    0,0,0, 282 },
  { "brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, brightness),
    0,0,0, 141 },
  { "contrast",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, contrast),
    0,0,0, 142 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VPORT, ambient_color),
    1,0,0, 63 },
  { "lower_left",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, lower_left),
    1,0,0, 10 },
  { "upper_right",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, upper_right),
    1,0,0, 11 },
  { "UCSFOLLOW",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, UCSFOLLOW),
    0,0,0, 71 },
  { "circle_zoom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, circle_zoom),
    0,0,0, 72 },
  { "FASTZOOM",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, FASTZOOM),
    0,0,0, 73 },
  { "UCSICON",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, UCSICON),
    0,0,0, 74 },
  { "GRIDMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, GRIDMODE),
    0,0,0, 76 },
  { "GRIDUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, GRIDUNIT),
    1,0,0, 15 },
  { "SNAPMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, SNAPMODE),
    0,0,0, 75 },
  { "SNAPSTYLE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, SNAPSTYLE),
    0,0,0, 77 },
  { "SNAPISOPAIR",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, SNAPISOPAIR),
    0,0,0, 78 },
  { "SNAPANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, SNAPANG),
    0,0,0, 50 },
  { "SNAPBASE",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, SNAPBASE),
    1,0,0, 13 },
  { "SNAPUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, SNAPUNIT),
    1,0,0, 14 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, unknown),
    0,0,0, 0 },
  { "UCSVP",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, UCSVP),
    0,0,0, 65 },
  { "ucs_origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, ucs_origin),
    1,0,0, 110 },
  { "ucs_x_axis",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, ucs_x_axis),
    1,0,0, 111 },
  { "ucs_y_axis",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, ucs_y_axis),
    1,0,0, 112 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, ucs_elevation),
    0,0,0, 146 },
  { "ucs_orthografic_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, ucs_orthografic_type),
    0,0,0, 79 },
  { "grid_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, grid_flags),
    0,0,0, 60 },
  { "grid_major",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, grid_major),
    0,0,0, 61 },
  { "null_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, null_handle),
    1,0,0, 0 },
  { "background",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, background),
    1,0,0, 332 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, visualstyle),
    1,0,0, 348 },
  { "sun",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, sun),
    1,0,0, 361 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, named_ucs),
    1,0,0, 345 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, base_ucs),
    1,0,0, 346 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VPORT_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VPORT_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VPORT_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_VPORT_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VPORT_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VPORT_ENTITY_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VPORT_ENTITY_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VPORT_ENTITY_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT_ENTITY_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_VPORT_ENTITY_CONTROL, entries),
    1,1,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VPORT_ENTITY_CONTROL, objid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VPORT_ENTITY_HEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VPORT_ENTITY_HEADER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, used),
    0,0,0, 0 },
  { "xrefref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, xrefref),
    0,0,0, 0 },
  { "xrefindex_plus1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, xrefindex_plus1),
    0,0,0, 0 },
  { "xrefdep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, xrefdep),
    0,0,0, 0 },
  { "flag1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, flag1),
    0,0,0, 70 },
  { "xref_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, xref_handle),
    1,0,0, 0 },
  { "vport_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT_ENTITY_HEADER, vport_entity),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_WIPEOUTVARIABLES: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_WIPEOUTVARIABLES_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_WIPEOUTVARIABLES, parent),
    1,1,0, 0 },
  { "display_frame",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_WIPEOUTVARIABLES, display_frame),
    0,0,0, 70 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_XRECORD: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_XRECORD_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_XRECORD, parent),
    1,1,0, 0 },
  { "num_databytes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_XRECORD, num_databytes),
    0,0,0, 0 },
  { "cloning_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_XRECORD, cloning_flags),
    0,0,0, 280 },
  { "num_xdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_XRECORD, num_xdata),
    0,0,0, 0 },
  { "xdata",	"Dwg_Resbuf*", sizeof (Dwg_Resbuf*),  OFF (struct _dwg_object_XRECORD, xdata),
    1,1,0, 0 },
  { "num_objid_handles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_XRECORD, num_objid_handles),
    0,0,0, 0 },
  { "objid_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_XRECORD, objid_handles),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_3DSOLID_silhouette: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_silhouette_fields[] = {
  { "parent",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_3DSOLID_silhouette, parent),
    1,1,0, 0 },
  { "vp_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_silhouette, vp_id),
    0,0,0, 0 },
  { "vp_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_silhouette, vp_target),
    1,0,0, 0 },
  { "vp_dir_from_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_silhouette, vp_dir_from_target),
    1,0,0, 0 },
  { "vp_up_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_silhouette, vp_up_dir),
    1,0,0, 0 },
  { "vp_perspective",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_silhouette, vp_perspective),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_silhouette, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_3DSOLID_silhouette, wires),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_3DSOLID_wire: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_wire_fields[] = {
  { "parent",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_3DSOLID_wire, parent),
    1,1,0, 0 },
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_3DSOLID_wire, type),
    0,0,0, 0 },
  { "selection_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_wire, selection_marker),
    0,0,0, 0 },
  { "color",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_3DSOLID_wire, color),
    0,0,0, 0 },
  { "acis_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_wire, acis_index),
    0,0,0, 0 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_wire, num_points),
    0,0,0, 0 },
  { "points",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_3DSOLID_wire, points),
    1,1,0, 0 },
  { "transform_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, transform_present),
    0,0,0, 0 },
  { "axis_x",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, axis_x),
    1,0,0, 0 },
  { "axis_y",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, axis_y),
    1,0,0, 0 },
  { "axis_z",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, axis_z),
    1,0,0, 0 },
  { "translation",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, translation),
    1,0,0, 0 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_3DSOLID_wire, scale),
    0,0,0, 0 },
  { "has_rotation",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, has_rotation),
    0,0,0, 0 },
  { "has_reflection",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, has_reflection),
    0,0,0, 0 },
  { "has_shear",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, has_shear),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_ASSOCNETWORK*", sizeof (void *),  OFF (struct _dwg_ACTIONBODY, parent),
    1,1,0, 0 },
  { "evaluatorid",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_ACTIONBODY, evaluatorid),
    1,1,1, 0 },
  { "expression",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_ACTIONBODY, expression),
    1,1,1, 0 },
  { "value",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACTIONBODY, value),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BorderStyle: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BorderStyle_fields[] = {
  { "edge_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BorderStyle, edge_flags),
    0,0,0, 95 },
  { "border_property_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BorderStyle, border_property_overrides_flag),
    0,0,0, 90 },
  { "border_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BorderStyle, border_type),
    0,0,0, 91 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_BorderStyle, color),
    1,0,0, 0 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_BorderStyle, linewt),
    0,0,0, 92 },
  { "line_type",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_BorderStyle, line_type),
    1,0,0, 0 },
  { "invisible",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_BorderStyle, invisible),
    0,0,0, 93 },
  { "double_line_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_BorderStyle, double_line_spacing),
    0,0,0, 93 },
  { "parent",	"struct _dwg_CellStyle*", sizeof (void *),  OFF (struct _dwg_BorderStyle, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CELLSTYLEMAP_Cell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CELLSTYLEMAP_Cell_fields[] = {
  { "style",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_CELLSTYLEMAP_Cell, style),
    0,0,0, 0 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CELLSTYLEMAP_Cell, id),
    0,0,0, 90 },
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CELLSTYLEMAP_Cell, type),
    0,0,0, 91 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_CELLSTYLEMAP_Cell, name),
    1,1,1, 300 },
  { "parent",	"struct _dwg_object_CELLSTYLEMAP*", sizeof (void *),  OFF (struct _dwg_CELLSTYLEMAP_Cell, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CellContentGeometry: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CellContentGeometry_fields[] = {
  { "dist_top_left",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_CellContentGeometry, dist_top_left),
    1,0,0, 0 },
  { "dist_center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_CellContentGeometry, dist_center),
    1,0,0, 0 },
  { "content_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, content_width),
    0,0,0, 0 },
  { "content_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, content_height),
    0,0,0, 0 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, width),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, height),
    0,0,0, 0 },
  { "unknown",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, unknown),
    0,0,0, 0 },
  { "cell_parent",	"struct _dwg_TableCell*", sizeof (void *),  OFF (struct _dwg_CellContentGeometry, cell_parent),
    1,1,0, 0 },
  { "geom_parent",	"struct _dwg_TABLEGEOMETRY_Cell*", sizeof (void *),  OFF (struct _dwg_CellContentGeometry, geom_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CellStyle: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CellStyle_fields[] = {
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, type),
    0,0,0, 0 },
  { "data_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_CellStyle, data_flags),
    0,0,0, 0 },
  { "property_override_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, property_override_flags),
    0,0,0, 0 },
  { "merge_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, merge_flags),
    0,0,0, 0 },
  { "background_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_CellStyle, background_color),
    1,0,0, 0 },
  { "content_layout",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, content_layout),
    0,0,0, 0 },
  { "content_format",	"Dwg_ContentFormat", sizeof (Dwg_ContentFormat),  OFF (struct _dwg_CellStyle, content_format),
    0,0,0, 0 },
  { "margin_override_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_CellStyle, margin_override_flags),
    0,0,0, 0 },
  { "vert_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, vert_margin),
    0,0,0, 0 },
  { "horiz_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, horiz_margin),
    0,0,0, 0 },
  { "bottom_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, bottom_margin),
    0,0,0, 0 },
  { "right_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, right_margin),
    0,0,0, 0 },
  { "margin_horiz_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, margin_horiz_spacing),
    0,0,0, 0 },
  { "margin_vert_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, margin_vert_spacing),
    0,0,0, 0 },
  { "num_borders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, num_borders),
    0,0,0, 0 },
  { "border",	"Dwg_BorderStyle*", sizeof (Dwg_BorderStyle*),  OFF (struct _dwg_CellStyle, border),
    1,1,0, 0 },
  { "tablerow_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_CellStyle, tablerow_parent),
    1,1,0, 0 },
  { "tabledatacolumn_parent",	"struct _dwg_TableDataColumn*", sizeof (void *),  OFF (struct _dwg_CellStyle, tabledatacolumn_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ContentFormat: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ContentFormat_fields[] = {
  { "property_override_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, property_override_flags),
    0,0,0, 0 },
  { "property_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, property_flags),
    0,0,0, 0 },
  { "value_data_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, value_data_type),
    0,0,0, 0 },
  { "value_unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, value_unit_type),
    0,0,0, 0 },
  { "value_format_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_ContentFormat, value_format_string),
    1,1,1, 0 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_ContentFormat, rotation),
    0,0,0, 0 },
  { "block_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_ContentFormat, block_scale),
    0,0,0, 0 },
  { "cell_alignment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, cell_alignment),
    0,0,0, 0 },
  { "content_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_ContentFormat, content_color),
    1,0,0, 0 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ContentFormat, text_style),
    1,0,0, 0 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_ContentFormat, text_height),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DIMASSOC_ref: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMASSOC_ref_fields[] = {
  { "parent",	"struct _dwg_object_DIMASSOC*", sizeof (void *),  OFF (struct _dwg_DIMASSOC_ref, parent),
    1,1,0, 0 },
  { "rotated_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMASSOC_ref, rotated_type),
    0,0,0, 0 },
  { "osnap_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMASSOC_ref, osnap_type),
    0,0,0, 0 },
  { "classname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_DIMASSOC_ref, classname),
    1,1,1, 0 },
  { "main_subent_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMASSOC_ref, main_subent_type),
    0,0,0, 0 },
  { "intsect_subent_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMASSOC_ref, intsect_subent_type),
    0,0,0, 0 },
  { "main_gsmarker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_DIMASSOC_ref, main_gsmarker),
    0,0,0, 0 },
  { "osnap_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMASSOC_ref, osnap_dist),
    0,0,0, 0 },
  { "osnap_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMASSOC_ref, osnap_pt),
    1,0,0, 0 },
  { "has_lastpt_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMASSOC_ref, has_lastpt_ref),
    0,0,0, 0 },
  { "mainobj",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_DIMASSOC_ref, mainobj),
    1,0,0, 0 },
  { "intsectobj",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_DIMASSOC_ref, intsectobj),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DIMENSION_common: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_common_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_DIMENSION_common, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMENSION_common, class_version),
    0,0,0, 280 },
  { "blockname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_DIMENSION_common, blockname),
    1,1,1, 2 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMENSION_common, extrusion),
    1,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMENSION_common, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_DIMENSION_common, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMENSION_common, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMENSION_common, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_DIMENSION_common, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMENSION_common, ins_scale),
    1,0,0, 41 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMENSION_common, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMENSION_common, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMENSION_common, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMENSION_common, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMENSION_common, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_DIMENSION_common, clone_ins_pt),
    1,0,0, 12 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_EVAL_Node: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EVAL_Node_fields[] = {
  { "parent",	"struct _dwg_object_EVALUATION_GRAPH*", sizeof (void *),  OFF (struct _dwg_EVAL_Node, parent),
    1,1,0, 0 },
  { "edge[4]",	"BL", 4 * sizeof (BITCODE_BL),  OFF (struct _dwg_EVAL_Node, edge),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FIELD_ChildValue: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FIELD_ChildValue_fields[] = {
  { "key",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_FIELD_ChildValue, key),
    1,1,1, 6 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_FIELD_ChildValue, value),
    0,0,0, 0 },
  { "parent",	"struct _dwg_object_FIELD*", sizeof (void *),  OFF (struct _dwg_FIELD_ChildValue, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FormattedTableData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FormattedTableData_fields[] = {
  { "cellstyle",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_FormattedTableData, cellstyle),
    0,0,0, 0 },
  { "num_merged_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableData, num_merged_cells),
    0,0,0, 0 },
  { "merged_cells",	"Dwg_FormattedTableMerged*", sizeof (Dwg_FormattedTableMerged*),  OFF (struct _dwg_FormattedTableData, merged_cells),
    1,1,0, 0 },
  { "parent",	"struct _dwg_object_TABLECONTENT*", sizeof (void *),  OFF (struct _dwg_FormattedTableData, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FormattedTableMerged: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FormattedTableMerged_fields[] = {
  { "top_row",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, top_row),
    0,0,0, 91 },
  { "left_col",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, left_col),
    0,0,0, 92 },
  { "bottom_row",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, bottom_row),
    0,0,0, 93 },
  { "right_col",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, right_col),
    0,0,0, 94 },
  { "parent",	"struct _dwg_FormattedTableData*", sizeof (void *),  OFF (struct _dwg_FormattedTableMerged, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_GEODATA_meshface: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEODATA_meshface_fields[] = {
  { "face1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face1),
    0,0,0, 0 },
  { "face2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face2),
    0,0,0, 0 },
  { "face3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face3),
    0,0,0, 0 },
  { "face4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face4),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_GEODATA_meshpt: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEODATA_meshpt_fields[] = {
  { "source_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_GEODATA_meshpt, source_pt),
    1,0,0, 0 },
  { "dest_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_GEODATA_meshpt, dest_pt),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_Color: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_Color_fields[] = {
  { "parent",	"struct _dwg_entity_HATCH*", sizeof (void *),  OFF (struct _dwg_HATCH_Color, parent),
    1,1,0, 0 },
  { "shift_value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_Color, shift_value),
    0,0,0, 463 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_HATCH_Color, color),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_ControlPoint: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_ControlPoint_fields[] = {
  { "parent",	"struct _dwg_HATCH_PathSeg*", sizeof (void *),  OFF (struct _dwg_HATCH_ControlPoint, parent),
    1,1,0, 0 },
  { "point",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_ControlPoint, point),
    1,0,0, 10 },
  { "weight",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_ControlPoint, weight),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_DefLine: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_DefLine_fields[] = {
  { "parent",	"struct _dwg_entity_HATCH*", sizeof (void *),  OFF (struct _dwg_HATCH_DefLine, parent),
    1,1,0, 0 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_DefLine, angle),
    0,0,0, 53 },
  { "pt0",	"2BD", sizeof (BITCODE_2BD),  OFF (struct _dwg_HATCH_DefLine, pt0),
    1,0,0, 43 },
  { "offset",	"2BD", sizeof (BITCODE_2BD),  OFF (struct _dwg_HATCH_DefLine, offset),
    1,0,0, 45 },
  { "num_dashes",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_HATCH_DefLine, num_dashes),
    0,0,0, 79 },
  { "dashes",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_HATCH_DefLine, dashes),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_Path: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_Path_fields[] = {
  { "parent",	"struct _dwg_entity_HATCH*", sizeof (void *),  OFF (struct _dwg_HATCH_Path, parent),
    1,1,0, 0 },
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_Path, flag),
    0,0,0, 92 },
  { "num_segs_or_paths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_Path, num_segs_or_paths),
    0,0,0, 93 },
  { "segs",	"Dwg_HATCH_PathSeg*", sizeof (Dwg_HATCH_PathSeg*),  OFF (struct _dwg_HATCH_Path, segs),
    1,1,0, 0 },
  { "bulges_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_Path, bulges_present),
    0,0,0, 72 },
  { "closed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_Path, closed),
    0,0,0, 73 },
  { "polyline_paths",	"Dwg_HATCH_PolylinePath*", sizeof (Dwg_HATCH_PolylinePath*),  OFF (struct _dwg_HATCH_Path, polyline_paths),
    1,1,0, 0 },
  { "num_boundary_handles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_Path, num_boundary_handles),
    0,0,0, 97 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_PathSeg: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_PathSeg_fields[] = {
  { "parent",	"struct _dwg_HATCH_Path*", sizeof (void *),  OFF (struct _dwg_HATCH_PathSeg, parent),
    1,1,0, 0 },
  { "type_status",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_HATCH_PathSeg, type_status),
    0,0,0, 72 },
  { "first_endpoint",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, first_endpoint),
    1,0,0, 10 },
  { "second_endpoint",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, second_endpoint),
    1,0,0, 11 },
  { "center",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, radius),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, start_angle),
    0,0,0, 50 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, end_angle),
    0,0,0, 51 },
  { "is_ccw",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_PathSeg, is_ccw),
    0,0,0, 73 },
  { "endpoint",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, endpoint),
    1,0,0, 11 },
  { "minor_major_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, minor_major_ratio),
    0,0,0, 40 },
  { "degree",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, degree),
    0,0,0, 94 },
  { "is_rational",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_PathSeg, is_rational),
    0,0,0, 73 },
  { "is_periodic",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_PathSeg, is_periodic),
    0,0,0, 74 },
  { "num_knots",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, num_knots),
    0,0,0, 95 },
  { "num_control_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, num_control_points),
    0,0,0, 96 },
  { "knots",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_HATCH_PathSeg, knots),
    1,1,0, 0 },
  { "control_points",	"Dwg_HATCH_ControlPoint*", sizeof (Dwg_HATCH_ControlPoint*),  OFF (struct _dwg_HATCH_PathSeg, control_points),
    1,1,0, 0 },
  { "num_fitpts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, num_fitpts),
    0,0,0, 97 },
  { "fitpts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_HATCH_PathSeg, fitpts),
    1,1,0, 0 },
  { "start_tangent",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, start_tangent),
    1,0,0, 0 },
  { "end_tangent",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, end_tangent),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_PolylinePath: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_PolylinePath_fields[] = {
  { "parent",	"struct _dwg_HATCH_Path*", sizeof (void *),  OFF (struct _dwg_HATCH_PolylinePath, parent),
    1,1,0, 0 },
  { "point",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PolylinePath, point),
    1,0,0, 0 },
  { "bulge",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PolylinePath, bulge),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LAYER_entry: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_entry_fields[] = {
  { "idxlong",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LAYER_entry, idxlong),
    0,0,0, 0 },
  { "layername",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_LAYER_entry, layername),
    1,1,1, 8 },
  { "parent",	"struct _dwg_object_LAYER_INDEX*", sizeof (void *),  OFF (struct _dwg_LAYER_entry, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_ArrowHead: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_ArrowHead_fields[] = {
  { "parent",	"struct _dwg_entity_MULTILEADER*", sizeof (void *),  OFF (struct _dwg_LEADER_ArrowHead, parent),
    1,1,0, 0 },
  { "is_default",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_ArrowHead, is_default),
    0,0,0, 94 },
  { "arrowhead",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_ArrowHead, arrowhead),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_BlockLabel: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_BlockLabel_fields[] = {
  { "parent",	"struct _dwg_entity_MULTILEADER*", sizeof (void *),  OFF (struct _dwg_LEADER_BlockLabel, parent),
    1,1,0, 0 },
  { "attdef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_BlockLabel, attdef),
    1,0,0, 0 },
  { "label_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_LEADER_BlockLabel, label_text),
    1,1,1, 302 },
  { "ui_index",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LEADER_BlockLabel, ui_index),
    0,0,0, 177 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LEADER_BlockLabel, width),
    0,0,0, 44 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_Break: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_Break_fields[] = {
  { "parent",	"struct _dwg_LEADER_Line*", sizeof (void *),  OFF (struct _dwg_LEADER_Break, parent),
    1,1,0, 0 },
  { "start",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Break, start),
    1,0,0, 11 },
  { "end",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Break, end),
    1,0,0, 12 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_Line: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_Line_fields[] = {
  { "parent",	"struct _dwg_LEADER_Node*", sizeof (void *),  OFF (struct _dwg_LEADER_Line, parent),
    1,1,0, 0 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, num_points),
    0,0,0, 0 },
  { "points",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_LEADER_Line, points),
    1,1,0, 0 },
  { "num_breaks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, num_breaks),
    0,0,0, 0 },
  { "breaks",	"Dwg_LEADER_Break*", sizeof (Dwg_LEADER_Break*),  OFF (struct _dwg_LEADER_Line, breaks),
    1,1,0, 0 },
  { "line_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, line_index),
    0,0,0, 91 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LEADER_Line, type),
    0,0,0, 170 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_LEADER_Line, color),
    1,0,0, 0 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_Line, ltype),
    1,0,0, 340 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_LEADER_Line, linewt),
    0,0,0, 171 },
  { "arrow_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LEADER_Line, arrow_size),
    0,0,0, 40 },
  { "arrow_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_Line, arrow_handle),
    1,0,0, 341 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, flags),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_Node: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_Node_fields[] = {
  { "parent",	"struct _dwg_entity_MULTILEADER*", sizeof (void *),  OFF (struct _dwg_LEADER_Node, parent),
    1,1,0, 0 },
  { "has_lastleaderlinepoint",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_LEADER_Node, has_lastleaderlinepoint),
    0,0,0, 290 },
  { "has_dogleg",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_LEADER_Node, has_dogleg),
    0,0,0, 291 },
  { "lastleaderlinepoint",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Node, lastleaderlinepoint),
    1,0,0, 10 },
  { "dogleg_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Node, dogleg_vector),
    1,0,0, 11 },
  { "branch_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Node, branch_index),
    0,0,0, 90 },
  { "dogleg_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LEADER_Node, dogleg_length),
    0,0,0, 40 },
  { "num_lines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Node, num_lines),
    0,0,0, 0 },
  { "lines",	"Dwg_LEADER_Line*", sizeof (Dwg_LEADER_Line*),  OFF (struct _dwg_LEADER_Node, lines),
    1,1,0, 0 },
  { "num_breaks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Node, num_breaks),
    0,0,0, 0 },
  { "breaks",	"Dwg_LEADER_Break*", sizeof (Dwg_LEADER_Break*),  OFF (struct _dwg_LEADER_Node, breaks),
    1,1,0, 0 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LEADER_Node, attach_dir),
    0,0,0, 271 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LTYPE_dash: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LTYPE_dash_fields[] = {
  { "parent",	"struct _dwg_object_LTYPE*", sizeof (void *),  OFF (struct _dwg_LTYPE_dash, parent),
    1,1,0, 0 },
  { "length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LTYPE_dash, length),
    0,0,0, 49 },
  { "complex_shapecode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LTYPE_dash, complex_shapecode),
    0,0,0, 74 },
  { "x_offset",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_LTYPE_dash, x_offset),
    0,0,0, 44 },
  { "y_offset",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_LTYPE_dash, y_offset),
    0,0,0, 45 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LTYPE_dash, scale),
    0,0,0, 46 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LTYPE_dash, rotation),
    0,0,0, 50 },
  { "shape_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LTYPE_dash, shape_flag),
    0,0,0, 75 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LWPOLYLINE_width: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LWPOLYLINE_width_fields[] = {
  { "start",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LWPOLYLINE_width, start),
    0,0,0, 40 },
  { "end",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LWPOLYLINE_width, end),
    0,0,0, 41 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LinkedData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LinkedData_fields[] = {
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_LinkedData, name),
    1,1,1, 0 },
  { "desc",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_LinkedData, desc),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LinkedTableData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LinkedTableData_fields[] = {
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LinkedTableData, num_cols),
    0,0,0, 0 },
  { "cols",	"Dwg_TableDataColumn*", sizeof (Dwg_TableDataColumn*),  OFF (struct _dwg_LinkedTableData, cols),
    1,1,0, 0 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LinkedTableData, num_rows),
    0,0,0, 0 },
  { "rows",	"Dwg_TableRow*", sizeof (Dwg_TableRow*),  OFF (struct _dwg_LinkedTableData, rows),
    1,1,0, 0 },
  { "num_field_refs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LinkedTableData, num_field_refs),
    0,0,0, 0 },
  { "field_refs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_LinkedTableData, field_refs),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MESH_edge: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MESH_edge_fields[] = {
  { "parent",	"struct _dwg_entity_MESH*", sizeof (void *),  OFF (struct _dwg_MESH_edge, parent),
    1,1,0, 0 },
  { "from",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MESH_edge, from),
    0,0,0, 90 },
  { "to",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MESH_edge, to),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLEADER_AnnotContext: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADER_AnnotContext_fields[] = {
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, class_version),
    0,0,0, 0 },
  { "has_xdic_file",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, has_xdic_file),
    0,0,0, 0 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, is_default),
    0,0,0, 0 },
  { "scale_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_MLEADER_AnnotContext, scale_handle),
    1,0,0, 0 },
  { "num_leaders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MLEADER_AnnotContext, num_leaders),
    0,0,0, 0 },
  { "leaders",	"Dwg_LEADER_Node*", sizeof (Dwg_LEADER_Node*),  OFF (struct _dwg_MLEADER_AnnotContext, leaders),
    1,1,0, 0 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, attach_dir),
    0,0,0, 0 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, scale),
    0,0,0, 0 },
  { "content_base",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, content_base),
    1,0,0, 0 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, text_height),
    0,0,0, 0 },
  { "arrow_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, arrow_size),
    0,0,0, 0 },
  { "landing_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, landing_gap),
    0,0,0, 0 },
  { "text_left",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_left),
    0,0,0, 0 },
  { "text_right",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_right),
    0,0,0, 0 },
  { "text_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_alignment),
    0,0,0, 0 },
  { "attach_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, attach_type),
    0,0,0, 0 },
  { "has_content_txt",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, has_content_txt),
    0,0,0, 0 },
  { "has_content_blk",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, has_content_blk),
    0,0,0, 0 },
  { "content",	"Dwg_MLEADER_Content", sizeof (Dwg_MLEADER_Content),  OFF (struct _dwg_MLEADER_AnnotContext, content),
    0,0,0, 0 },
  { "base",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, base),
    1,0,0, 0 },
  { "base_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, base_dir),
    1,0,0, 0 },
  { "base_vert",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, base_vert),
    1,0,0, 0 },
  { "is_normal_reversed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, is_normal_reversed),
    0,0,0, 0 },
  { "text_top",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_top),
    0,0,0, 0 },
  { "text_bottom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_bottom),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLINESTYLE_line: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINESTYLE_line_fields[] = {
  { "parent",	"struct _dwg_object_MLINESTYLE*", sizeof (void *),  OFF (struct _dwg_MLINESTYLE_line, parent),
    1,1,0, 0 },
  { "offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLINESTYLE_line, offset),
    0,0,0, 49 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_MLINESTYLE_line, color),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLINE_line: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINE_line_fields[] = {
  { "parent",	"struct _dwg_MLINE_vertex*", sizeof (void *),  OFF (struct _dwg_MLINE_line, parent),
    1,1,0, 0 },
  { "num_segparms",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLINE_line, num_segparms),
    0,0,0, 74 },
  { "segparms",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MLINE_line, segparms),
    1,1,0, 0 },
  { "num_areafillparms",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLINE_line, num_areafillparms),
    0,0,0, 75 },
  { "areafillparms",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MLINE_line, areafillparms),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLINE_vertex: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINE_vertex_fields[] = {
  { "parent",	"struct _dwg_entity_MLINE*", sizeof (void *),  OFF (struct _dwg_MLINE_vertex, parent),
    1,1,0, 0 },
  { "vertex",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLINE_vertex, vertex),
    1,0,0, 11 },
  { "vertex_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLINE_vertex, vertex_direction),
    1,0,0, 12 },
  { "miter_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLINE_vertex, miter_direction),
    1,0,0, 13 },
  { "num_lines",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MLINE_vertex, num_lines),
    0,0,0, 0 },
  { "lines",	"Dwg_MLINE_line*", sizeof (Dwg_MLINE_line*),  OFF (struct _dwg_MLINE_vertex, lines),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SPLINE_control_point: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPLINE_control_point_fields[] = {
  { "parent",	"struct _dwg_entity_SPLINE*", sizeof (void *),  OFF (struct _dwg_SPLINE_control_point, parent),
    1,1,0, 0 },
  { "x",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, x),
    0,0,0, 0 },
  { "y",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, y),
    0,0,0, 0 },
  { "z",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, z),
    0,0,0, 0 },
  { "w",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, w),
    0,0,0, 41 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SPLINE_point: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPLINE_point_fields[] = {
  { "parent",	"struct _dwg_entity_SPLINE*", sizeof (void *),  OFF (struct _dwg_SPLINE_point, parent),
    1,1,0, 0 },
  { "x",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_point, x),
    0,0,0, 0 },
  { "y",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_point, y),
    0,0,0, 0 },
  { "z",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_point, z),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SUNSTUDY_Dates: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SUNSTUDY_Dates_fields[] = {
  { "julian_day",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SUNSTUDY_Dates, julian_day),
    0,0,0, 90 },
  { "time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SUNSTUDY_Dates, time),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SummaryInfo_Property: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SummaryInfo_Property_fields[] = {
  { "key",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SummaryInfo_Property, key),
    1,1,1, 0 },
  { "value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SummaryInfo_Property, value),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLEGEOMETRY_Cell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLEGEOMETRY_Cell_fields[] = {
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLEGEOMETRY_Cell, flag),
    0,0,0, 93 },
  { "width_w_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLEGEOMETRY_Cell, width_w_gap),
    0,0,0, 40 },
  { "height_w_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLEGEOMETRY_Cell, height_w_gap),
    0,0,0, 41 },
  { "unknown",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLEGEOMETRY_Cell, unknown),
    1,0,0, 330 },
  { "num_geom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLEGEOMETRY_Cell, num_geom_data),
    0,0,0, 94 },
  { "geom_data",	"Dwg_CellContentGeometry*", sizeof (Dwg_CellContentGeometry*),  OFF (struct _dwg_TABLEGEOMETRY_Cell, geom_data),
    1,1,0, 0 },
  { "parent",	"struct _dwg_object_TABLEGEOMETRY*", sizeof (void *),  OFF (struct _dwg_TABLEGEOMETRY_Cell, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLESTYLE_Cell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_Cell_fields[] = {
  { "cell",	"Dwg_TABLE_Cell", sizeof (Dwg_TABLE_Cell),  OFF (struct _dwg_TABLESTYLE_Cell, cell),
    0,0,0, 0 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_Cell, id),
    0,0,0, 0 },
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_Cell, type),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLESTYLE_Cell, name),
    1,1,1, 0 },
  { "parent",	"struct _dwg_object_TABLESTYLE*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_Cell, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLESTYLE_border: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_border_fields[] = {
  { "linewt",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_TABLESTYLE_border, linewt),
    0,0,0, 0 },
  { "visible",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLESTYLE_border, visible),
    0,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_border, color),
    1,0,0, 0 },
  { "parent",	"struct _dwg_TABLESTYLE_rowstyles*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_border, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLESTYLE_rowstyles: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_rowstyles_fields[] = {
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_style),
    1,0,0, 7 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_height),
    0,0,0, 140 },
  { "text_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_alignment),
    0,0,0, 170 },
  { "text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_color),
    1,0,0, 0 },
  { "fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_rowstyles, fill_color),
    1,0,0, 0 },
  { "has_bgcolor",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLESTYLE_rowstyles, has_bgcolor),
    0,0,0, 283 },
  { "num_borders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_rowstyles, num_borders),
    0,0,0, 0 },
  { "borders",	"Dwg_TABLESTYLE_border*", sizeof (Dwg_TABLESTYLE_border*),  OFF (struct _dwg_TABLESTYLE_rowstyles, borders),
    1,1,0, 0 },
  { "data_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_rowstyles, data_type),
    0,0,0, 90 },
  { "unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_rowstyles, unit_type),
    0,0,0, 91 },
  { "format_string",	"TU", sizeof (BITCODE_TU),  OFF (struct _dwg_TABLESTYLE_rowstyles, format_string),
    1,1,1, 1 },
  { "parent",	"struct _dwg_object_TABLESTYLE*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_rowstyles, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_BreakHeight: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_BreakHeight_fields[] = {
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_TABLE_BreakHeight, position),
    1,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_BreakHeight, height),
    0,0,0, 0 },
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_BreakHeight, flag),
    0,0,0, 0 },
  { "parent",	"struct _dwg_entity_TABLE*", sizeof (void *),  OFF (struct _dwg_TABLE_BreakHeight, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_BreakRow: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_BreakRow_fields[] = {
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_TABLE_BreakRow, position),
    1,0,0, 0 },
  { "start",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_BreakRow, start),
    0,0,0, 0 },
  { "end",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_BreakRow, end),
    0,0,0, 0 },
  { "parent",	"struct _dwg_entity_TABLE*", sizeof (void *),  OFF (struct _dwg_TABLE_BreakRow, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_Cell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_Cell_fields[] = {
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, type),
    0,0,0, 171 },
  { "flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_TABLE_Cell, flags),
    0,0,0, 172 },
  { "merged_value",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, merged_value),
    0,0,0, 173 },
  { "autofit_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, autofit_flag),
    0,0,0, 174 },
  { "merged_width_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, merged_width_flag),
    0,0,0, 175 },
  { "merged_height_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, merged_height_flag),
    0,0,0, 176 },
  { "rotation_value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_Cell, rotation_value),
    0,0,0, 145 },
  { "text_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLE_Cell, text_string),
    1,1,1, 1 },
  { "block_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_Cell, block_scale),
    0,0,0, 144 },
  { "additional_data_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, additional_data_flag),
    0,0,0, 0 },
  { "attr_def_index",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, attr_def_index),
    0,0,0, 0 },
  { "attr_def_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLE_Cell, attr_def_text),
    1,1,1, 300 },
  { "additional_data_flag2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, additional_data_flag2),
    0,0,0, 0 },
  { "cell_flag_override",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, cell_flag_override),
    0,0,0, 177 },
  { "virtual_edge_flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_TABLE_Cell, virtual_edge_flag),
    0,0,0, 178 },
  { "cell_alignment",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_TABLE_Cell, cell_alignment),
    0,0,0, 170 },
  { "background_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, background_fill_none),
    0,0,0, 283 },
  { "background_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, background_color),
    1,0,0, 0 },
  { "content_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, content_color),
    1,0,0, 0 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_Cell, text_style),
    1,0,0, 0 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_Cell, text_height),
    0,0,0, 140 },
  { "top_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, top_grid_color),
    1,0,0, 0 },
  { "top_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, top_grid_linewt),
    0,0,0, 279 },
  { "top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, top_visibility),
    0,0,0, 289 },
  { "right_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, right_grid_color),
    1,0,0, 0 },
  { "right_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, right_grid_linewt),
    0,0,0, 275 },
  { "right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, right_visibility),
    0,0,0, 285 },
  { "bottom_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, bottom_grid_color),
    1,0,0, 0 },
  { "bottom_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, bottom_grid_linewt),
    0,0,0, 276 },
  { "bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, bottom_visibility),
    0,0,0, 286 },
  { "left_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, left_grid_color),
    1,0,0, 0 },
  { "left_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, left_grid_linewt),
    0,0,0, 278 },
  { "left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, left_visibility),
    0,0,0, 288 },
  { "unknown",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, unknown),
    0,0,0, 0 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_TABLE_Cell, value),
    0,0,0, 0 },
  { "cell_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_Cell, cell_handle),
    1,0,0, 0 },
  { "num_attr_defs",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, num_attr_defs),
    0,0,0, 179 },
  { "attr_def_id",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_TABLE_Cell, attr_def_id),
    1,1,0, 0 },
  { "text_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_Cell, text_style_override),
    1,0,0, 0 },
  { "parent",	"struct _dwg_entity_TABLE*", sizeof (void *),  OFF (struct _dwg_TABLE_Cell, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_CustomDataItem: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_CustomDataItem_fields[] = {
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLE_CustomDataItem, name),
    1,1,1, 300 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_TABLE_CustomDataItem, value),
    0,0,0, 0 },
  { "cell_parent",	"struct _dwg_TableCell*", sizeof (void *),  OFF (struct _dwg_TABLE_CustomDataItem, cell_parent),
    1,1,0, 0 },
  { "row_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_TABLE_CustomDataItem, row_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_value: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_value_fields[] = {
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, flags),
    0,0,0, 0 },
  { "data_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, data_type),
    0,0,0, 0 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, data_size),
    0,0,0, 0 },
  { "data_long",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, data_long),
    0,0,0, 0 },
  { "data_double",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_value, data_double),
    0,0,0, 0 },
  { "data_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLE_value, data_string),
    1,1,1, 0 },
  { "data_date",	"TV", sizeof (char*),  OFF (struct _dwg_TABLE_value, data_date),
    1,1,1, 0 },
  { "data_point",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_TABLE_value, data_point),
    1,0,0, 0 },
  { "data_3dpoint",	"3RD", sizeof (BITCODE_3RD),  OFF (struct _dwg_TABLE_value, data_3dpoint),
    1,0,0, 0 },
  { "unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, unit_type),
    0,0,0, 0 },
  { "format_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLE_value, format_string),
    1,1,1, 0 },
  { "value_string",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TABLE_value, value_string),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableCell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableCell_fields[] = {
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, flag),
    0,0,0, 90 },
  { "tooltip",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TableCell, tooltip),
    1,1,1, 300 },
  { "customdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, customdata),
    0,0,0, 91 },
  { "num_customdata_items",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_customdata_items),
    0,0,0, 90 },
  { "customdata_items",	"Dwg_TABLE_CustomDataItem*", sizeof (Dwg_TABLE_CustomDataItem*),  OFF (struct _dwg_TableCell, customdata_items),
    1,1,0, 0 },
  { "has_linked_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, has_linked_data),
    0,0,0, 0 },
  { "data_link",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCell, data_link),
    1,0,0, 0 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_rows),
    0,0,0, 0 },
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_cols),
    0,0,0, 0 },
  { "unknown",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, unknown),
    0,0,0, 0 },
  { "num_cell_contents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_cell_contents),
    0,0,0, 0 },
  { "cell_contents",	"Dwg_TableCellContent*", sizeof (Dwg_TableCellContent*),  OFF (struct _dwg_TableCell, cell_contents),
    1,1,0, 0 },
  { "style_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, style_id),
    0,0,0, 0 },
  { "has_geom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, has_geom_data),
    0,0,0, 0 },
  { "geom_data_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, geom_data_flag),
    0,0,0, 0 },
  { "unknown_d40",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TableCell, unknown_d40),
    0,0,0, 0 },
  { "unknown_d41",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TableCell, unknown_d41),
    0,0,0, 0 },
  { "has_cell_geom",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, has_cell_geom),
    0,0,0, 0 },
  { "cell_geom_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCell, cell_geom_handle),
    1,0,0, 0 },
  { "geom_data",	"Dwg_CellContentGeometry*", sizeof (Dwg_CellContentGeometry*),  OFF (struct _dwg_TableCell, geom_data),
    1,1,0, 0 },
  { "style_parent",	"struct _dwg_CellStyle*", sizeof (void *),  OFF (struct _dwg_TableCell, style_parent),
    1,1,0, 0 },
  { "row_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_TableCell, row_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableCellContent: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableCellContent_fields[] = {
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCellContent, type),
    0,0,0, 90 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_TableCellContent, value),
    0,0,0, 0 },
  { "handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCellContent, handle),
    1,0,0, 340 },
  { "num_attrs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCellContent, num_attrs),
    0,0,0, 91 },
  { "attrs",	"Dwg_TableCellContent_Attr*", sizeof (Dwg_TableCellContent_Attr*),  OFF (struct _dwg_TableCellContent, attrs),
    1,1,0, 0 },
  { "has_content_format_overrides",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TableCellContent, has_content_format_overrides),
    0,0,0, 0 },
  { "content_format",	"Dwg_ContentFormat", sizeof (Dwg_ContentFormat),  OFF (struct _dwg_TableCellContent, content_format),
    0,0,0, 0 },
  { "parent",	"struct _dwg_TableCell*", sizeof (void *),  OFF (struct _dwg_TableCellContent, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableCellContent_Attr: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableCellContent_Attr_fields[] = {
  { "attdef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCellContent_Attr, attdef),
    1,0,0, 330 },
  { "value",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TableCellContent_Attr, value),
    1,1,1, 301 },
  { "index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCellContent_Attr, index),
    0,0,0, 92 },
  { "parent",	"struct _dwg_TableCellContent*", sizeof (void *),  OFF (struct _dwg_TableCellContent_Attr, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableDataColumn: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableDataColumn_fields[] = {
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TableDataColumn, name),
    1,1,1, 300 },
  { "custom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableDataColumn, custom_data),
    0,0,0, 91 },
  { "cellstyle",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_TableDataColumn, cellstyle),
    0,0,0, 0 },
  { "cellstyle_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableDataColumn, cellstyle_id),
    0,0,0, 0 },
  { "width",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableDataColumn, width),
    0,0,0, 0 },
  { "parent",	"struct _dwg_LinkedTableData*", sizeof (void *),  OFF (struct _dwg_TableDataColumn, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableRow: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableRow_fields[] = {
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, num_cells),
    0,0,0, 0 },
  { "cells",	"Dwg_TableCell*", sizeof (Dwg_TableCell*),  OFF (struct _dwg_TableRow, cells),
    1,1,0, 0 },
  { "custom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, custom_data),
    0,0,0, 0 },
  { "num_customdata_items",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, num_customdata_items),
    0,0,0, 0 },
  { "customdata_items",	"Dwg_TABLE_CustomDataItem*", sizeof (Dwg_TABLE_CustomDataItem*),  OFF (struct _dwg_TableRow, customdata_items),
    1,1,0, 0 },
  { "cellstyle",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_TableRow, cellstyle),
    0,0,0, 0 },
  { "style_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, style_id),
    0,0,0, 0 },
  { "height",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, height),
    0,0,0, 0 },
  { "parent",	"struct _dwg_LinkedTableData*", sizeof (void *),  OFF (struct _dwg_TableRow, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};


/* common fields: */
/* from typedef struct _dwg_object_entity: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_object_entity_fields[] = {
  { "__iterator",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, __iterator),
    0,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_entity, color),
    1,0,0, 62 },
  { "color_r11",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, color_r11),
    0,0,0, 62 },
  { "dwg",	"struct _dwg_struct*", sizeof (void *),  OFF (struct _dwg_object_entity, dwg),
    1,1,0, 0 },
  { "edge_visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, edge_visualstyle),
    1,0,0, 348 },
  { "eed",	"Dwg_Eed*", sizeof (Dwg_Eed*),  OFF (struct _dwg_object_entity, eed),
    1,1,0, 0 },
  { "elevation_r11",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_object_entity, elevation_r11),
    0,0,0, 0 },
  { "entmode",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, entmode),
    0,0,0, 0 },
  { "extra_r11",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, extra_r11),
    0,0,0, 0 },
  { "face_visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, face_visualstyle),
    1,0,0, 348 },
  { "flag_r11",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, flag_r11),
    0,0,0, 0 },
  { "full_visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, full_visualstyle),
    1,0,0, 348 },
  { "has_ds_binary_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_ds_binary_data),
    0,0,0, 0 },
  { "has_edge_visualstyle",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_edge_visualstyle),
    0,0,0, 0 },
  { "has_face_visualstyle",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_face_visualstyle),
    0,0,0, 0 },
  { "has_full_visualstyle",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_full_visualstyle),
    0,0,0, 0 },
  { "invisible",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_entity, invisible),
    0,0,0, 60 },
  { "isbylayerlt",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, isbylayerlt),
    0,0,0, 0 },
  { "kind_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, kind_r11),
    0,0,0, 0 },
  { "layer",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, layer),
    1,0,0, 8 },
  { "layer_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, layer_r11),
    0,0,0, 0 },
  { "linewt",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, linewt),
    0,0,0, 370 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, ltype),
    1,0,0, 6 },
  { "ltype_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, ltype_flags),
    0,0,0, 0 },
  { "ltype_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, ltype_r11),
    0,0,0, 0 },
  { "ltype_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_entity, ltype_scale),
    0,0,0, 48 },
  { "material",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, material),
    1,0,0, 347 },
  { "material_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, material_flags),
    0,0,0, 0 },
  { "next_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, next_entity),
    1,0,0, 0 },
  { "nolinks",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, nolinks),
    0,0,0, 0 },
  { "num_eed",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, num_eed),
    0,0,0, 0 },
  { "num_reactors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, num_reactors),
    0,0,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, objid),
    0,0,0, 0 },
  { "opts_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, opts_r11),
    0,0,0, 0 },
  { "ownerhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, ownerhandle),
    1,0,0, 330 },
  { "paper_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, paper_r11),
    0,0,0, 67 },
  { "plotstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, plotstyle),
    1,0,0, 390 },
  { "plotstyle_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, plotstyle_flags),
    0,0,0, 0 },
  { "prev_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, prev_entity),
    1,0,0, 0 },
  { "preview",	"TV", sizeof (char*),  OFF (struct _dwg_object_entity, preview),
    1,1,1, 310 },
  { "preview_exists",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, preview_exists),
    0,0,0, 0 },
  { "preview_size",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_object_entity, preview_size),
    0,0,0, 160 },
  { "reactors",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_entity, reactors),
    1,1,0, 330 },
  { "shadow",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, shadow),
    1,0,0, 0 },
  { "shadow_flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, shadow_flags),
    0,0,0, 284 },
  { "thickness_r11",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_object_entity, thickness_r11),
    0,0,0, 0 },
  { "xdic_missing_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, xdic_missing_flag),
    0,0,0, 0 },
  { "xdicobjhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, xdicobjhandle),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_object_object: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_object_object_fields[] = {
  { "dwg",	"struct _dwg_struct*", sizeof (void *),  OFF (struct _dwg_object_object, dwg),
    1,1,0, 0 },
  { "eed",	"Dwg_Eed*", sizeof (Dwg_Eed*),  OFF (struct _dwg_object_object, eed),
    1,1,0, 0 },
  { "handleref",	"Dwg_Handle*", sizeof (Dwg_Handle*),  OFF (struct _dwg_object_object, handleref),
    1,1,0, 0 },
  { "has_ds_binary_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_object, has_ds_binary_data),
    0,0,0, 0 },
  { "num_eed",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_object, num_eed),
    0,0,0, 0 },
  { "num_reactors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_object, num_reactors),
    0,0,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_object, objid),
    0,0,0, 0 },
  { "ownerhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_object, ownerhandle),
    1,0,0, 330 },
  { "reactors",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_object, reactors),
    1,1,0, 330 },
  { "xdic_missing_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_object, xdic_missing_flag),
    0,0,0, 0 },
  { "xdicobjhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_object, xdicobjhandle),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};


/* from typedef struct Dwg_SummaryInfo: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_SummaryInfo_fields[] = {
  { "AUTHOR",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, AUTHOR),
    1,1,1, 1 },
  { "COMMENTS",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, COMMENTS),
    1,1,1, 1 },
  { "HYPERLINKBASE",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, HYPERLINKBASE),
    1,1,1, 1 },
  { "KEYWORDS",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, KEYWORDS),
    1,1,1, 1 },
  { "LASTSAVEDBY",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, LASTSAVEDBY),
    1,1,1, 1 },
  { "REVISIONNUMBER",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, REVISIONNUMBER),
    1,1,1, 1 },
  { "SUBJECT",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, SUBJECT),
    1,1,1, 1 },
  { "TDCREATE",	"TIMERLL", sizeof (BITCODE_TIMERLL),  OFF (struct Dwg_SummaryInfo, TDCREATE),
    1,0,0, 0 },
  { "TDINDWG",	"TIMERLL", sizeof (BITCODE_TIMERLL),  OFF (struct Dwg_SummaryInfo, TDINDWG),
    1,0,0, 0 },
  { "TDUPDATE",	"TIMERLL", sizeof (BITCODE_TIMERLL),  OFF (struct Dwg_SummaryInfo, TDUPDATE),
    1,0,0, 0 },
  { "TITLE",	"TV", sizeof (BITCODE_TV),  OFF (struct Dwg_SummaryInfo, TITLE),
    1,1,1, 1 },
  { "num_props",	"RS", sizeof (BITCODE_RS),  OFF (struct Dwg_SummaryInfo, num_props),
    0,0,0, 0 },
  { "props",	"Dwg_SummaryInfo_Property*", sizeof (Dwg_SummaryInfo_Property*),  OFF (struct Dwg_SummaryInfo, props),
    1,1,0, 0 },
  { "unknown1",	"RL", sizeof (BITCODE_RL),  OFF (struct Dwg_SummaryInfo, unknown1),
    0,0,0, 0 },
  { "unknown2",	"RL", sizeof (BITCODE_RL),  OFF (struct Dwg_SummaryInfo, unknown2),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};


struct _name_type_fields {
  const char *const name;
  const enum DWG_OBJECT_TYPE type;
  const Dwg_DYNAPI_field *const fields;
};

struct _name_subclass_fields {
  const char *const name;
  const int type;
  const char *const subclass;
  const Dwg_DYNAPI_field *const fields;
};

/* Fields for all the objects, sorted for bsearch. from enum DWG_OBJECT_TYPE: */
static const struct _name_type_fields dwg_name_types[] = {
  { "3DFACE",	DWG_TYPE__3DFACE /*(28)*/,	_dwg_3DFACE_fields },	/* 0 */
  { "3DSOLID",	DWG_TYPE__3DSOLID /*(38)*/,	_dwg_3DSOLID_fields },	/* 1 */
  { "ACSH_HISTORY_CLASS",	DWG_TYPE_ACSH_HISTORY_CLASS /*(512)*/,	NULL },	/* 2 */
  { "ACSH_SWEEP_CLASS",	DWG_TYPE_ACSH_SWEEP_CLASS /*(513)*/,	_dwg_ACSH_SWEEP_CLASS_fields },	/* 3 */
  { "ANNOTSCALEOBJECTCONTEXTDATA",	DWG_TYPE_ANNOTSCALEOBJECTCONTEXTDATA /*(514)*/,	_dwg_ANNOTSCALEOBJECTCONTEXTDATA_fields },	/* 4 */
  { "APPID",	DWG_TYPE_APPID /*(67)*/,	_dwg_APPID_fields },	/* 5 */
  { "APPID_CONTROL",	DWG_TYPE_APPID_CONTROL /*(66)*/,	_dwg_APPID_CONTROL_fields },	/* 6 */
  { "ARC",	DWG_TYPE_ARC /*(17)*/,	_dwg_ARC_fields },	/* 7 */
  { "ARCALIGNEDTEXT",	DWG_TYPE_ARCALIGNEDTEXT /*(515)*/,	NULL },	/* 8 */
  { "ARC_DIMENSION",	DWG_TYPE_ARC_DIMENSION /*(516)*/,	_dwg_ARC_DIMENSION_fields },	/* 9 */
  { "ASSOC2DCONSTRAINTGROUP",	DWG_TYPE_ASSOC2DCONSTRAINTGROUP /*(517)*/,	_dwg_ASSOC2DCONSTRAINTGROUP_fields },	/* 10 */
  { "ASSOCACTION",	DWG_TYPE_ASSOCACTION /*(518)*/,	_dwg_ASSOCACTION_fields },	/* 11 */
  { "ASSOCALIGNEDDIMACTIONBODY",	DWG_TYPE_ASSOCALIGNEDDIMACTIONBODY /*(519)*/,	_dwg_ASSOCALIGNEDDIMACTIONBODY_fields },	/* 12 */
  { "ASSOCDEPENDENCY",	DWG_TYPE_ASSOCDEPENDENCY /*(520)*/,	_dwg_ASSOCDEPENDENCY_fields },	/* 13 */
  { "ASSOCGEOMDEPENDENCY",	DWG_TYPE_ASSOCGEOMDEPENDENCY /*(521)*/,	NULL },	/* 14 */
  { "ASSOCNETWORK",	DWG_TYPE_ASSOCNETWORK /*(522)*/,	_dwg_ASSOCNETWORK_fields },	/* 15 */
  { "ASSOCOSNAPPOINTREFACTIONPARAM",	DWG_TYPE_ASSOCOSNAPPOINTREFACTIONPARAM /*(523)*/,	_dwg_ASSOCOSNAPPOINTREFACTIONPARAM_fields },	/* 16 */
  { "ASSOCPERSSUBENTMANAGER",	DWG_TYPE_ASSOCPERSSUBENTMANAGER /*(524)*/,	_dwg_ASSOCPERSSUBENTMANAGER_fields },	/* 17 */
  { "ASSOCPLANESURFACEACTIONBODY",	DWG_TYPE_ASSOCPLANESURFACEACTIONBODY /*(525)*/,	_dwg_ASSOCPLANESURFACEACTIONBODY_fields },	/* 18 */
  { "ASSOCVERTEXACTIONPARAM",	DWG_TYPE_ASSOCVERTEXACTIONPARAM /*(526)*/,	NULL },	/* 19 */
  { "ATTDEF",	DWG_TYPE_ATTDEF /*(3)*/,	_dwg_ATTDEF_fields },	/* 20 */
  { "ATTRIB",	DWG_TYPE_ATTRIB /*(2)*/,	_dwg_ATTRIB_fields },	/* 21 */
  { "BLOCK",	DWG_TYPE_BLOCK /*(4)*/,	_dwg_BLOCK_fields },	/* 22 */
  { "BLOCK_CONTROL",	DWG_TYPE_BLOCK_CONTROL /*(48)*/,	_dwg_BLOCK_CONTROL_fields },	/* 23 */
  { "BLOCK_HEADER",	DWG_TYPE_BLOCK_HEADER /*(49)*/,	_dwg_BLOCK_HEADER_fields },	/* 24 */
  { "BODY",	DWG_TYPE_BODY /*(39)*/,	_dwg_3DSOLID_fields },	/* 25 */
  { "CAMERA",	DWG_TYPE_CAMERA /*(527)*/,	_dwg_CAMERA_fields },	/* 26 */
  { "CELLSTYLEMAP",	DWG_TYPE_CELLSTYLEMAP /*(528)*/,	_dwg_CELLSTYLEMAP_fields },	/* 27 */
  { "CIRCLE",	DWG_TYPE_CIRCLE /*(18)*/,	_dwg_CIRCLE_fields },	/* 28 */
  { "DATATABLE",	DWG_TYPE_DATATABLE /*(529)*/,	_dwg_DATATABLE_fields },	/* 29 */
  { "DBCOLOR",	DWG_TYPE_DBCOLOR /*(530)*/,	_dwg_DBCOLOR_fields },	/* 30 */
  { "DETAILVIEWSTYLE",	DWG_TYPE_DETAILVIEWSTYLE /*(531)*/,	NULL },	/* 31 */
  { "DICTIONARY",	DWG_TYPE_DICTIONARY /*(42)*/,	_dwg_DICTIONARY_fields },	/* 32 */
  { "DICTIONARYVAR",	DWG_TYPE_DICTIONARYVAR /*(532)*/,	_dwg_DICTIONARYVAR_fields },	/* 33 */
  { "DICTIONARYWDFLT",	DWG_TYPE_DICTIONARYWDFLT /*(533)*/,	_dwg_DICTIONARYWDFLT_fields },	/* 34 */
  { "DIMASSOC",	DWG_TYPE_DIMASSOC /*(534)*/,	_dwg_DIMASSOC_fields },	/* 35 */
  { "DIMENSION_ALIGNED",	DWG_TYPE_DIMENSION_ALIGNED /*(22)*/,	_dwg_DIMENSION_ALIGNED_fields },	/* 36 */
  { "DIMENSION_ANG2LN",	DWG_TYPE_DIMENSION_ANG2LN /*(24)*/,	_dwg_DIMENSION_ANG2LN_fields },	/* 37 */
  { "DIMENSION_ANG3PT",	DWG_TYPE_DIMENSION_ANG3PT /*(23)*/,	_dwg_DIMENSION_ANG3PT_fields },	/* 38 */
  { "DIMENSION_DIAMETER",	DWG_TYPE_DIMENSION_DIAMETER /*(26)*/,	_dwg_DIMENSION_DIAMETER_fields },	/* 39 */
  { "DIMENSION_LINEAR",	DWG_TYPE_DIMENSION_LINEAR /*(21)*/,	_dwg_DIMENSION_LINEAR_fields },	/* 40 */
  { "DIMENSION_ORDINATE",	DWG_TYPE_DIMENSION_ORDINATE /*(20)*/,	_dwg_DIMENSION_ORDINATE_fields },	/* 41 */
  { "DIMENSION_RADIUS",	DWG_TYPE_DIMENSION_RADIUS /*(25)*/,	_dwg_DIMENSION_RADIUS_fields },	/* 42 */
  { "DIMSTYLE",	DWG_TYPE_DIMSTYLE /*(69)*/,	_dwg_DIMSTYLE_fields },	/* 43 */
  { "DIMSTYLE_CONTROL",	DWG_TYPE_DIMSTYLE_CONTROL /*(68)*/,	_dwg_DIMSTYLE_CONTROL_fields },	/* 44 */
  { "DOCUMENTOPTIONS",	DWG_TYPE_DOCUMENTOPTIONS /*(535)*/,	NULL },	/* 45 */
  { "DUMMY",	DWG_TYPE_DUMMY /*(75)*/,	_dwg_DUMMY_fields },	/* 46 */
  { "DYNAMICBLOCKPURGEPREVENTER",	DWG_TYPE_DYNAMICBLOCKPURGEPREVENTER /*(536)*/,	_dwg_DYNAMICBLOCKPURGEPREVENTER_fields },	/* 47 */
  { "ELLIPSE",	DWG_TYPE_ELLIPSE /*(35)*/,	_dwg_ELLIPSE_fields },	/* 48 */
  { "ENDBLK",	DWG_TYPE_ENDBLK /*(5)*/,	_dwg_ENDBLK_fields },	/* 49 */
  { "EVALUATION_GRAPH",	DWG_TYPE_EVALUATION_GRAPH /*(537)*/,	_dwg_EVALUATION_GRAPH_fields },	/* 50 */
  { "EXTRUDEDSURFACE",	DWG_TYPE_EXTRUDEDSURFACE /*(579)*/,	_dwg_EXTRUDEDSURFACE_fields },	/* 51 */
  { "FIELD",	DWG_TYPE_FIELD /*(538)*/,	_dwg_FIELD_fields },	/* 52 */
  { "FIELDLIST",	DWG_TYPE_FIELDLIST /*(539)*/,	_dwg_FIELDLIST_fields },	/* 53 */
  { "FREED",	DWG_TYPE_FREED /*(65533)*/,	NULL },	/* 54 */
  { "GEODATA",	DWG_TYPE_GEODATA /*(540)*/,	_dwg_GEODATA_fields },	/* 55 */
  { "GEOMAPIMAGE",	DWG_TYPE_GEOMAPIMAGE /*(541)*/,	_dwg_GEOMAPIMAGE_fields },	/* 56 */
  { "GEOPOSITIONMARKER",	DWG_TYPE_GEOPOSITIONMARKER /*(542)*/,	_dwg_GEOPOSITIONMARKER_fields },	/* 57 */
  { "GROUP",	DWG_TYPE_GROUP /*(72)*/,	_dwg_GROUP_fields },	/* 58 */
  { "HATCH",	DWG_TYPE_HATCH /*(78)*/,	_dwg_HATCH_fields },	/* 59 */
  { "HELIX",	DWG_TYPE_HELIX /*(543)*/,	_dwg_HELIX_fields },	/* 60 */
  { "IDBUFFER",	DWG_TYPE_IDBUFFER /*(544)*/,	_dwg_IDBUFFER_fields },	/* 61 */
  { "IMAGE",	DWG_TYPE_IMAGE /*(545)*/,	_dwg_IMAGE_fields },	/* 62 */
  { "IMAGEDEF",	DWG_TYPE_IMAGEDEF /*(546)*/,	_dwg_IMAGEDEF_fields },	/* 63 */
  { "IMAGEDEF_REACTOR",	DWG_TYPE_IMAGEDEF_REACTOR /*(547)*/,	_dwg_IMAGEDEF_REACTOR_fields },	/* 64 */
  { "INSERT",	DWG_TYPE_INSERT /*(7)*/,	_dwg_INSERT_fields },	/* 65 */
  { "LAYER",	DWG_TYPE_LAYER /*(51)*/,	_dwg_LAYER_fields },	/* 66 */
  { "LAYER_CONTROL",	DWG_TYPE_LAYER_CONTROL /*(50)*/,	_dwg_LAYER_CONTROL_fields },	/* 67 */
  { "LAYER_FILTER",	DWG_TYPE_LAYER_FILTER /*(548)*/,	NULL },	/* 68 */
  { "LAYER_INDEX",	DWG_TYPE_LAYER_INDEX /*(549)*/,	_dwg_LAYER_INDEX_fields },	/* 69 */
  { "LAYOUT",	DWG_TYPE_LAYOUT /*(82)*/,	_dwg_LAYOUT_fields },	/* 70 */
  { "LAYOUTPRINTCONFIG",	DWG_TYPE_LAYOUTPRINTCONFIG /*(550)*/,	NULL },	/* 71 */
  { "LEADER",	DWG_TYPE_LEADER /*(45)*/,	_dwg_LEADER_fields },	/* 72 */
  { "LIGHT",	DWG_TYPE_LIGHT /*(551)*/,	_dwg_LIGHT_fields },	/* 73 */
  { "LIGHTLIST",	DWG_TYPE_LIGHTLIST /*(552)*/,	_dwg_LIGHTLIST_fields },	/* 74 */
  { "LINE",	DWG_TYPE_LINE /*(19)*/,	_dwg_LINE_fields },	/* 75 */
  { "LOFTEDSURFACE",	DWG_TYPE_LOFTEDSURFACE /*(580)*/,	_dwg_LOFTEDSURFACE_fields },	/* 76 */
  { "LONG_TRANSACTION",	DWG_TYPE_LONG_TRANSACTION /*(76)*/,	_dwg_LONG_TRANSACTION_fields },	/* 77 */
  { "LTYPE",	DWG_TYPE_LTYPE /*(57)*/,	_dwg_LTYPE_fields },	/* 78 */
  { "LTYPE_CONTROL",	DWG_TYPE_LTYPE_CONTROL /*(56)*/,	_dwg_LTYPE_CONTROL_fields },	/* 79 */
  { "LWPOLYLINE",	DWG_TYPE_LWPOLYLINE /*(77)*/,	_dwg_LWPOLYLINE_fields },	/* 80 */
  { "MATERIAL",	DWG_TYPE_MATERIAL /*(553)*/,	_dwg_MATERIAL_fields },	/* 81 */
  { "MENTALRAYRENDERSETTINGS",	DWG_TYPE_MENTALRAYRENDERSETTINGS /*(567)*/,	NULL },	/* 82 */
  { "MESH",	DWG_TYPE_MESH /*(554)*/,	_dwg_MESH_fields },	/* 83 */
  { "MINSERT",	DWG_TYPE_MINSERT /*(8)*/,	_dwg_MINSERT_fields },	/* 84 */
  { "MLEADERSTYLE",	DWG_TYPE_MLEADERSTYLE /*(555)*/,	_dwg_MLEADERSTYLE_fields },	/* 85 */
  { "MLINE",	DWG_TYPE_MLINE /*(47)*/,	_dwg_MLINE_fields },	/* 86 */
  { "MLINESTYLE",	DWG_TYPE_MLINESTYLE /*(73)*/,	_dwg_MLINESTYLE_fields },	/* 87 */
  { "MTEXT",	DWG_TYPE_MTEXT /*(44)*/,	_dwg_MTEXT_fields },	/* 88 */
  { "MULTILEADER",	DWG_TYPE_MULTILEADER /*(556)*/,	_dwg_MULTILEADER_fields },	/* 89 */
  { "NAVISWORKSMODELDEF",	DWG_TYPE_NAVISWORKSMODELDEF /*(557)*/,	_dwg_NAVISWORKSMODELDEF_fields },	/* 90 */
  { "NPOCOLLECTION",	DWG_TYPE_NPOCOLLECTION /*(558)*/,	NULL },	/* 91 */
  { "OBJECTCONTEXTDATA",	DWG_TYPE_OBJECTCONTEXTDATA /*(559)*/,	_dwg_OBJECTCONTEXTDATA_fields },	/* 92 */
  { "OBJECT_PTR",	DWG_TYPE_OBJECT_PTR /*(560)*/,	_dwg_OBJECT_PTR_fields },	/* 93 */
  { "OLE2FRAME",	DWG_TYPE_OLE2FRAME /*(74)*/,	_dwg_OLE2FRAME_fields },	/* 94 */
  { "OLEFRAME",	DWG_TYPE_OLEFRAME /*(43)*/,	_dwg_OLEFRAME_fields },	/* 95 */
  { "PERSSUBENTMANAGER",	DWG_TYPE_PERSSUBENTMANAGER /*(561)*/,	_dwg_PERSSUBENTMANAGER_fields },	/* 96 */
  { "PLACEHOLDER",	DWG_TYPE_PLACEHOLDER /*(80)*/,	_dwg_PLACEHOLDER_fields },	/* 97 */
  { "PLANESURFACE",	DWG_TYPE_PLANESURFACE /*(578)*/,	_dwg_PLANESURFACE_fields },	/* 98 */
  { "PLOTSETTINGS",	DWG_TYPE_PLOTSETTINGS /*(562)*/,	_dwg_PLOTSETTINGS_fields },	/* 99 */
  { "POINT",	DWG_TYPE_POINT /*(27)*/,	_dwg_POINT_fields },	/* 100 */
  { "POINTCLOUD",	DWG_TYPE_POINTCLOUD /*(563)*/,	NULL },	/* 101 */
  { "POLYLINE_2D",	DWG_TYPE_POLYLINE_2D /*(15)*/,	_dwg_POLYLINE_2D_fields },	/* 102 */
  { "POLYLINE_3D",	DWG_TYPE_POLYLINE_3D /*(16)*/,	_dwg_POLYLINE_3D_fields },	/* 103 */
  { "POLYLINE_MESH",	DWG_TYPE_POLYLINE_MESH /*(30)*/,	_dwg_POLYLINE_MESH_fields },	/* 104 */
  { "POLYLINE_PFACE",	DWG_TYPE_POLYLINE_PFACE /*(29)*/,	_dwg_POLYLINE_PFACE_fields },	/* 105 */
  { "PROXY_ENTITY",	DWG_TYPE_PROXY_ENTITY /*(498)*/,	_dwg_PROXY_ENTITY_fields },	/* 106 */
  { "PROXY_OBJECT",	DWG_TYPE_PROXY_OBJECT /*(499)*/,	_dwg_PROXY_OBJECT_fields },	/* 107 */
  { "RAPIDRTRENDERENVIRONMENT",	DWG_TYPE_RAPIDRTRENDERENVIRONMENT /*(568)*/,	NULL },	/* 108 */
  { "RAPIDRTRENDERSETTINGS",	DWG_TYPE_RAPIDRTRENDERSETTINGS /*(569)*/,	NULL },	/* 109 */
  { "RASTERVARIABLES",	DWG_TYPE_RASTERVARIABLES /*(564)*/,	_dwg_RASTERVARIABLES_fields },	/* 110 */
  { "RAY",	DWG_TYPE_RAY /*(40)*/,	_dwg_RAY_fields },	/* 111 */
  { "REGION",	DWG_TYPE_REGION /*(37)*/,	_dwg_3DSOLID_fields },	/* 112 */
  { "RENDERENVIRONMENT",	DWG_TYPE_RENDERENVIRONMENT /*(565)*/,	_dwg_RENDERENVIRONMENT_fields },	/* 113 */
  { "RENDERGLOBAL",	DWG_TYPE_RENDERGLOBAL /*(566)*/,	_dwg_RENDERGLOBAL_fields },	/* 114 */
  { "REVOLVEDSURFACE",	DWG_TYPE_REVOLVEDSURFACE /*(581)*/,	_dwg_REVOLVEDSURFACE_fields },	/* 115 */
  { "RTEXT",	DWG_TYPE_RTEXT /*(570)*/,	NULL },	/* 116 */
  { "SCALE",	DWG_TYPE_SCALE /*(571)*/,	_dwg_SCALE_fields },	/* 117 */
  { "SECTIONVIEWSTYLE",	DWG_TYPE_SECTIONVIEWSTYLE /*(572)*/,	NULL },	/* 118 */
  { "SEQEND",	DWG_TYPE_SEQEND /*(6)*/,	_dwg_SEQEND_fields },	/* 119 */
  { "SHAPE",	DWG_TYPE_SHAPE /*(33)*/,	_dwg_SHAPE_fields },	/* 120 */
  { "SOLID",	DWG_TYPE_SOLID /*(31)*/,	_dwg_SOLID_fields },	/* 121 */
  { "SORTENTSTABLE",	DWG_TYPE_SORTENTSTABLE /*(573)*/,	_dwg_SORTENTSTABLE_fields },	/* 122 */
  { "SPATIAL_FILTER",	DWG_TYPE_SPATIAL_FILTER /*(574)*/,	_dwg_SPATIAL_FILTER_fields },	/* 123 */
  { "SPATIAL_INDEX",	DWG_TYPE_SPATIAL_INDEX /*(575)*/,	_dwg_SPATIAL_INDEX_fields },	/* 124 */
  { "SPLINE",	DWG_TYPE_SPLINE /*(36)*/,	_dwg_SPLINE_fields },	/* 125 */
  { "STYLE",	DWG_TYPE_STYLE /*(53)*/,	_dwg_STYLE_fields },	/* 126 */
  { "STYLE_CONTROL",	DWG_TYPE_STYLE_CONTROL /*(52)*/,	_dwg_STYLE_CONTROL_fields },	/* 127 */
  { "SUN",	DWG_TYPE_SUN /*(576)*/,	_dwg_SUN_fields },	/* 128 */
  { "SUNSTUDY",	DWG_TYPE_SUNSTUDY /*(577)*/,	_dwg_SUNSTUDY_fields },	/* 129 */
  { "SWEPTSURFACE",	DWG_TYPE_SWEPTSURFACE /*(582)*/,	_dwg_SWEPTSURFACE_fields },	/* 130 */
  { "TABLE",	DWG_TYPE_TABLE /*(583)*/,	_dwg_TABLE_fields },	/* 131 */
  { "TABLECONTENT",	DWG_TYPE_TABLECONTENT /*(584)*/,	_dwg_TABLECONTENT_fields },	/* 132 */
  { "TABLEGEOMETRY",	DWG_TYPE_TABLEGEOMETRY /*(585)*/,	_dwg_TABLEGEOMETRY_fields },	/* 133 */
  { "TABLESTYLE",	DWG_TYPE_TABLESTYLE /*(586)*/,	_dwg_TABLESTYLE_fields },	/* 134 */
  { "TEXT",	DWG_TYPE_TEXT /*(1)*/,	_dwg_TEXT_fields },	/* 135 */
  { "TOLERANCE",	DWG_TYPE_TOLERANCE /*(46)*/,	_dwg_TOLERANCE_fields },	/* 136 */
  { "TRACE",	DWG_TYPE_TRACE /*(32)*/,	_dwg_TRACE_fields },	/* 137 */
  { "UCS",	DWG_TYPE_UCS /*(63)*/,	_dwg_UCS_fields },	/* 138 */
  { "UCS_CONTROL",	DWG_TYPE_UCS_CONTROL /*(62)*/,	_dwg_UCS_CONTROL_fields },	/* 139 */
  { "UNDERLAY",	DWG_TYPE_UNDERLAY /*(587)*/,	_dwg_UNDERLAY_fields },	/* 140 */
  { "UNDERLAYDEFINITION",	DWG_TYPE_UNDERLAYDEFINITION /*(588)*/,	_dwg_UNDERLAYDEFINITION_fields },	/* 141 */
  { "UNKNOWN_ENT",	DWG_TYPE_UNKNOWN_ENT /*(65534)*/,	_dwg_UNKNOWN_ENT_fields },	/* 142 */
  { "UNKNOWN_OBJ",	DWG_TYPE_UNKNOWN_OBJ /*(65535)*/,	_dwg_UNKNOWN_OBJ_fields },	/* 143 */
  { "UNUSED",	DWG_TYPE_UNUSED /*(0)*/,	NULL },	/* 144 */
  { "VBA_PROJECT",	DWG_TYPE_VBA_PROJECT /*(81)*/,	_dwg_VBA_PROJECT_fields },	/* 145 */
  { "VERTEX_2D",	DWG_TYPE_VERTEX_2D /*(10)*/,	_dwg_VERTEX_2D_fields },	/* 146 */
  { "VERTEX_3D",	DWG_TYPE_VERTEX_3D /*(11)*/,	_dwg_VERTEX_3D_fields },	/* 147 */
  { "VERTEX_MESH",	DWG_TYPE_VERTEX_MESH /*(12)*/,	_dwg_VERTEX_3D_fields },	/* 148 */
  { "VERTEX_PFACE",	DWG_TYPE_VERTEX_PFACE /*(13)*/,	_dwg_VERTEX_3D_fields },	/* 149 */
  { "VERTEX_PFACE_FACE",	DWG_TYPE_VERTEX_PFACE_FACE /*(14)*/,	_dwg_VERTEX_PFACE_FACE_fields },	/* 150 */
  { "VIEW",	DWG_TYPE_VIEW /*(61)*/,	_dwg_VIEW_fields },	/* 151 */
  { "VIEWPORT",	DWG_TYPE_VIEWPORT /*(34)*/,	_dwg_VIEWPORT_fields },	/* 152 */
  { "VIEW_CONTROL",	DWG_TYPE_VIEW_CONTROL /*(60)*/,	_dwg_VIEW_CONTROL_fields },	/* 153 */
  { "VISUALSTYLE",	DWG_TYPE_VISUALSTYLE /*(589)*/,	_dwg_VISUALSTYLE_fields },	/* 154 */
  { "VPORT",	DWG_TYPE_VPORT /*(65)*/,	_dwg_VPORT_fields },	/* 155 */
  { "VPORT_CONTROL",	DWG_TYPE_VPORT_CONTROL /*(64)*/,	_dwg_VPORT_CONTROL_fields },	/* 156 */
  { "VPORT_ENTITY_CONTROL",	DWG_TYPE_VPORT_ENTITY_CONTROL /*(70)*/,	_dwg_VPORT_ENTITY_CONTROL_fields },	/* 157 */
  { "VPORT_ENTITY_HEADER",	DWG_TYPE_VPORT_ENTITY_HEADER /*(71)*/,	_dwg_VPORT_ENTITY_HEADER_fields },	/* 158 */
  { "WIPEOUT",	DWG_TYPE_WIPEOUT /*(590)*/,	_dwg_WIPEOUT_fields },	/* 159 */
  { "WIPEOUTVARIABLES",	DWG_TYPE_WIPEOUTVARIABLES /*(591)*/,	_dwg_WIPEOUTVARIABLES_fields },	/* 160 */
  { "XLINE",	DWG_TYPE_XLINE /*(41)*/,	_dwg_RAY_fields },	/* 161 */
  { "XRECORD",	DWG_TYPE_XRECORD /*(79)*/,	_dwg_XRECORD_fields },	/* 162 */
  { "XREFPANELOBJECT",	DWG_TYPE_XREFPANELOBJECT /*(592)*/,	NULL },	/* 163 */

};

/* Fields for all the subclasses, sorted for bsearch */
static const struct _name_subclass_fields dwg_list_subclasses[] = {
  { "3DSOLID_silhouette",	(int)DWG_TYPE__3DSOLID,	NULL,	_dwg_3DSOLID_silhouette_fields },	/* 0 */
  { "3DSOLID_wire",	(int)DWG_TYPE__3DSOLID,	NULL,	_dwg_3DSOLID_wire_fields },	/* 1 */
  { "ACTIONBODY",	0,	"AcDbAssocActionBody",	_dwg_ACTIONBODY_fields },	/* 2 */
  { "BorderStyle",	0,	NULL,	_dwg_BorderStyle_fields },	/* 3 */
  { "CELLSTYLEMAP_Cell",	(int)DWG_TYPE_CELLSTYLEMAP,	NULL,	_dwg_CELLSTYLEMAP_Cell_fields },	/* 4 */
  { "CellContentGeometry",	0,	NULL,	_dwg_CellContentGeometry_fields },	/* 5 */
  { "CellStyle",	0,	NULL,	_dwg_CellStyle_fields },	/* 6 */
  { "ContentFormat",	0,	NULL,	_dwg_ContentFormat_fields },	/* 7 */
  { "DIMASSOC_ref",	(int)DWG_TYPE_DIMASSOC,	NULL,	_dwg_DIMASSOC_ref_fields },	/* 8 */
  { "DIMENSION_common",	0,	"AcDbDimension",	_dwg_DIMENSION_common_fields },	/* 9 */
  { "EVAL_Node",	0,	NULL,	_dwg_EVAL_Node_fields },	/* 10 */
  { "FIELD_ChildValue",	(int)DWG_TYPE_FIELD,	NULL,	_dwg_FIELD_ChildValue_fields },	/* 11 */
  { "FormattedTableData",	0,	NULL,	_dwg_FormattedTableData_fields },	/* 12 */
  { "FormattedTableMerged",	0,	NULL,	_dwg_FormattedTableMerged_fields },	/* 13 */
  { "GEODATA_meshface",	(int)DWG_TYPE_GEODATA,	NULL,	_dwg_GEODATA_meshface_fields },	/* 14 */
  { "GEODATA_meshpt",	(int)DWG_TYPE_GEODATA,	NULL,	_dwg_GEODATA_meshpt_fields },	/* 15 */
  { "HATCH_Color",	(int)DWG_TYPE_HATCH,	NULL,	_dwg_HATCH_Color_fields },	/* 16 */
  { "HATCH_ControlPoint",	(int)DWG_TYPE_HATCH,	NULL,	_dwg_HATCH_ControlPoint_fields },	/* 17 */
  { "HATCH_DefLine",	(int)DWG_TYPE_HATCH,	NULL,	_dwg_HATCH_DefLine_fields },	/* 18 */
  { "HATCH_Path",	(int)DWG_TYPE_HATCH,	NULL,	_dwg_HATCH_Path_fields },	/* 19 */
  { "HATCH_PathSeg",	(int)DWG_TYPE_HATCH,	NULL,	_dwg_HATCH_PathSeg_fields },	/* 20 */
  { "HATCH_PolylinePath",	(int)DWG_TYPE_HATCH,	NULL,	_dwg_HATCH_PolylinePath_fields },	/* 21 */
  { "LAYER_entry",	(int)DWG_TYPE_LAYER,	NULL,	_dwg_LAYER_entry_fields },	/* 22 */
  { "LEADER_ArrowHead",	(int)DWG_TYPE_LEADER,	NULL,	_dwg_LEADER_ArrowHead_fields },	/* 23 */
  { "LEADER_BlockLabel",	(int)DWG_TYPE_LEADER,	NULL,	_dwg_LEADER_BlockLabel_fields },	/* 24 */
  { "LEADER_Break",	(int)DWG_TYPE_LEADER,	NULL,	_dwg_LEADER_Break_fields },	/* 25 */
  { "LEADER_Line",	(int)DWG_TYPE_LEADER,	NULL,	_dwg_LEADER_Line_fields },	/* 26 */
  { "LEADER_Node",	(int)DWG_TYPE_LEADER,	NULL,	_dwg_LEADER_Node_fields },	/* 27 */
  { "LTYPE_dash",	(int)DWG_TYPE_LTYPE,	NULL,	_dwg_LTYPE_dash_fields },	/* 28 */
  { "LWPOLYLINE_width",	(int)DWG_TYPE_LWPOLYLINE,	NULL,	_dwg_LWPOLYLINE_width_fields },	/* 29 */
  { "LinkedData",	0,	NULL,	_dwg_LinkedData_fields },	/* 30 */
  { "LinkedTableData",	0,	NULL,	_dwg_LinkedTableData_fields },	/* 31 */
  { "MESH_edge",	(int)DWG_TYPE_MESH,	NULL,	_dwg_MESH_edge_fields },	/* 32 */
  { "MLEADER_AnnotContext",	0,	NULL,	_dwg_MLEADER_AnnotContext_fields },	/* 33 */
  { "MLINESTYLE_line",	(int)DWG_TYPE_MLINESTYLE,	NULL,	_dwg_MLINESTYLE_line_fields },	/* 34 */
  { "MLINE_line",	(int)DWG_TYPE_MLINE,	NULL,	_dwg_MLINE_line_fields },	/* 35 */
  { "MLINE_vertex",	(int)DWG_TYPE_MLINE,	NULL,	_dwg_MLINE_vertex_fields },	/* 36 */
  { "SPLINE_control_point",	(int)DWG_TYPE_SPLINE,	NULL,	_dwg_SPLINE_control_point_fields },	/* 37 */
  { "SPLINE_point",	(int)DWG_TYPE_SPLINE,	NULL,	_dwg_SPLINE_point_fields },	/* 38 */
  { "SUNSTUDY_Dates",	(int)DWG_TYPE_SUNSTUDY,	NULL,	_dwg_SUNSTUDY_Dates_fields },	/* 39 */
  { "SummaryInfo_Property",	0,	NULL,	_dwg_SummaryInfo_Property_fields },	/* 40 */
  { "TABLEGEOMETRY_Cell",	(int)DWG_TYPE_TABLEGEOMETRY,	NULL,	_dwg_TABLEGEOMETRY_Cell_fields },	/* 41 */
  { "TABLESTYLE_Cell",	(int)DWG_TYPE_TABLESTYLE,	NULL,	_dwg_TABLESTYLE_Cell_fields },	/* 42 */
  { "TABLESTYLE_border",	(int)DWG_TYPE_TABLESTYLE,	NULL,	_dwg_TABLESTYLE_border_fields },	/* 43 */
  { "TABLESTYLE_rowstyles",	(int)DWG_TYPE_TABLESTYLE,	NULL,	_dwg_TABLESTYLE_rowstyles_fields },	/* 44 */
  { "TABLE_BreakHeight",	(int)DWG_TYPE_TABLE,	NULL,	_dwg_TABLE_BreakHeight_fields },	/* 45 */
  { "TABLE_BreakRow",	(int)DWG_TYPE_TABLE,	NULL,	_dwg_TABLE_BreakRow_fields },	/* 46 */
  { "TABLE_Cell",	(int)DWG_TYPE_TABLE,	NULL,	_dwg_TABLE_Cell_fields },	/* 47 */
  { "TABLE_CustomDataItem",	(int)DWG_TYPE_TABLE,	NULL,	_dwg_TABLE_CustomDataItem_fields },	/* 48 */
  { "TABLE_value",	(int)DWG_TYPE_TABLE,	NULL,	_dwg_TABLE_value_fields },	/* 49 */
  { "TableCell",	0,	NULL,	_dwg_TableCell_fields },	/* 50 */
  { "TableCellContent",	0,	NULL,	_dwg_TableCellContent_fields },	/* 51 */
  { "TableCellContent_Attr",	0,	NULL,	_dwg_TableCellContent_Attr_fields },	/* 52 */
  { "TableDataColumn",	0,	NULL,	_dwg_TableDataColumn_fields },	/* 53 */
  { "TableRow",	0,	NULL,	_dwg_TableRow_fields },	/* 54 */

};

#line 1222 "gen-dynapi.pl"
static int
_name_inl_cmp (const void *restrict key, const void *restrict elem)
{
  //https://en.cppreference.com/w/c/algorithm/bsearch
  return strcmp ((const char *)key, (const char *)elem); //inlined
}

struct _name
{
  const char *const name;
};

static int
_name_struct_cmp (const void *restrict key, const void *restrict elem)
{
  //https://en.cppreference.com/w/c/algorithm/bsearch
  const struct _name *f = (struct _name *)elem;
  return strcmp ((const char *)key, f->name); //deref
}

#define ARRAY_SIZE(arr) (sizeof (arr) / sizeof (arr[0]))
#define NUM_ENTITIES    ARRAY_SIZE(dwg_entity_names)
#define NUM_OBJECTS     ARRAY_SIZE(dwg_object_names)
#define NUM_NAME_TYPES  ARRAY_SIZE(dwg_name_types)
#define NUM_SUBCLASSES  ARRAY_SIZE(dwg_list_subclasses)

EXPORT bool
is_dwg_entity (const char *name)
{
  return bsearch (name, dwg_entity_names, NUM_ENTITIES, MAXLEN_ENTITIES,
                  _name_inl_cmp)
             ? true
             : false;
}

EXPORT bool
is_dwg_object (const char *name)
{
  return bsearch (name, dwg_object_names, NUM_OBJECTS, MAXLEN_OBJECTS,
                  _name_inl_cmp)
             ? true
             : false;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_entity_fields (const char *name)
{
  const char *p = bsearch (name, dwg_name_types, NUM_NAME_TYPES,
                           sizeof (dwg_name_types[0]),
                           _name_struct_cmp);
  if (p)
    {
      const int i = (p - (char *)dwg_name_types) / sizeof (dwg_name_types[0]);
      const struct _name_type_fields *f = &dwg_name_types[i];
      return f->fields;
    }
  else
    return NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_subclass_fields (const char *restrict name)
{
  const char *p = bsearch (name, dwg_list_subclasses, NUM_SUBCLASSES,
                           sizeof (dwg_list_subclasses[0]),
                           _name_struct_cmp);
  if (p)
    {
      const int i = (p - (char *)dwg_list_subclasses) / sizeof (dwg_list_subclasses[0]);
      const struct _name_subclass_fields *f = &dwg_list_subclasses[i];
      return f->fields;
    }
  else
    return NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_entity_fields (void)
{
  return _dwg_object_entity_fields;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_object_fields (void)
{
  return _dwg_object_object_fields;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_entity_field (const char *restrict name, const char *restrict field)
{
  const Dwg_DYNAPI_field *fields = dwg_dynapi_entity_fields (name);
  if (fields)
    { /* linear search (unsorted) */
      Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)fields;
      for (; f->name; f++)
        {
          if (strEQ (f->name, field))
            return f;
        }
    }
  return NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_header_field (const char *restrict fieldname)
{
  return (Dwg_DYNAPI_field *)bsearch (
              fieldname, _dwg_header_variables_fields,
              ARRAY_SIZE (_dwg_header_variables_fields) - 1, /* NULL terminated */
              sizeof (_dwg_header_variables_fields[0]), _name_struct_cmp);
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_entity_field (const char *restrict fieldname)
{
  return (Dwg_DYNAPI_field *)bsearch (
              fieldname, _dwg_object_entity_fields,
              ARRAY_SIZE (_dwg_object_entity_fields) - 1, /* NULL terminated */
              sizeof (_dwg_object_entity_fields[0]), _name_struct_cmp);
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_object_field (const char *restrict fieldname)
{
  return (Dwg_DYNAPI_field *)bsearch (
              fieldname, _dwg_object_object_fields,
              ARRAY_SIZE (_dwg_object_object_fields) - 1, /* NULL terminated */
              sizeof (_dwg_object_object_fields[0]), _name_struct_cmp);
}

/* generic field getters */
EXPORT bool
dwg_dynapi_entity_value (void *restrict _obj, const char *restrict name,
                         const char *restrict fieldname,
                         void *restrict out, Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!_obj || !name || !fieldname || !out)
    return false;
#endif
  {
    int error;
    const Dwg_Object* obj = dwg_obj_generic_to_object (_obj, &error);
    if (obj && strNE (obj->name, name)) // objid may be 0
      {
        const int loglevel = obj->parent->opts & 0xf;
        LOG_ERROR ("%s: Invalid entity type %s, wanted %s", __FUNCTION__,
                   obj->name, name);
        return false;
      }
    {
      const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (name, fieldname);
      if (!f)
        {
          int loglevel;
          if (obj)
            loglevel = obj->parent->opts & 0xf;
          else
            loglevel = DWG_LOGLEVEL_ERROR;
          LOG_ERROR ("%s: Invalid %s field %s", __FUNCTION__, name, fieldname);
          return false;
        }
      if (fp)
        memcpy (fp, f, sizeof (Dwg_DYNAPI_field));
      memcpy (out, &((char *)_obj)[f->offset], f->size);
      return true;
    }
  }
}

EXPORT bool
dwg_dynapi_entity_utf8text (void *restrict _obj, const char *restrict name,
                            const char *restrict fieldname,
                            char **restrict out, Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!_obj || !name || !fieldname || !out)
    return false;
#endif
  {
    int error;
    const Dwg_Object* obj = dwg_obj_generic_to_object (_obj, &error);
    if (obj && strNE (obj->name, name)) // objid may be 0
      {
        const int loglevel = obj->parent->opts & 0xf;
        LOG_ERROR ("%s: Invalid entity type %s, wanted %s", __FUNCTION__,
                   obj->name, name);
        return false;
      }
    {
      const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (name, fieldname);
      const Dwg_Version_Type dwg_version
          = obj ? obj->parent->header.version : R_INVALID;
      if (!f || !f->is_string)
        {
          int loglevel;
          if (obj)
            loglevel = obj->parent->opts & 0xf;
          else
            loglevel = DWG_LOGLEVEL_ERROR;
          LOG_ERROR ("%s: Invalid %s text field %s", __FUNCTION__, name, fieldname);
          return false;
        }
      if (fp)
        memcpy (fp, f, sizeof (Dwg_DYNAPI_field));

      if (dwg_version >= R_2007 && strNE (f->type, "TF")) /* not TF */
        {
          BITCODE_TU wstr = *(BITCODE_TU*)((char*)_obj + f->offset);
          char *utf8 = bit_convert_TU (wstr);
          if (!utf8) // some conversion error, invalid wchar (nyi)
            return false;
          *out = utf8;
        }
      else
        {
          char *utf8 = *(char **)((char*)_obj + f->offset);
          *out = utf8;
        }

      return true;
    }
  }
}

EXPORT bool
dwg_dynapi_header_value (const Dwg_Data *restrict dwg,
                         const char *restrict fieldname, void *restrict out,
                         Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!dwg || !fieldname || !out)
    return false;
#endif
  {
    const Dwg_DYNAPI_field *f = dwg_dynapi_header_field (fieldname);
    if (f)
      {
        const Dwg_Header_Variables *const _obj = &dwg->header_vars;
        if (fp)
          memcpy (fp, f, sizeof (Dwg_DYNAPI_field));
        memcpy (out, &((char*)_obj)[f->offset], f->size);
        return true;
      }
    else
      {
        const int loglevel = dwg->opts & 0xf;
        LOG_ERROR ("%s: Invalid header field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_header_utf8text (const Dwg_Data *restrict dwg,
                            const char *restrict fieldname,
                            char **restrict out,
                            Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!dwg || !fieldname || !out)
    return false;
#endif
  {
    const Dwg_DYNAPI_field *f = dwg_dynapi_header_field (fieldname);
    if (f && f->is_string)
      {
        const Dwg_Header_Variables *const _obj = &dwg->header_vars;
        const Dwg_Version_Type dwg_version = dwg->header.version;
        
        if (fp)
          memcpy (fp, f, sizeof (Dwg_DYNAPI_field));

        if (dwg_version >= R_2007 && strNE (f->type, "TF")) /* not TF */
          {
            BITCODE_TU wstr = *(BITCODE_TU*)((char*)_obj + f->offset);
            char *utf8 = bit_convert_TU (wstr);
            if (!utf8) // some conversion error, invalid wchar (nyi)
              return false;
            *out = utf8;
          }
        else
          {
            char *utf8 = *(char **)((char*)_obj + f->offset);
            *out = utf8;
          }

        return true;
      }
    else
      {
        const int loglevel = dwg->opts & 0xf;
        LOG_ERROR ("%s: Invalid header text field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_common_value(void *restrict _obj, const char *restrict fieldname,
                        void *restrict out, Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !out)
    return false;
#endif
  {
    const Dwg_DYNAPI_field *f;
    int error;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    if (!obj)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }

    if (obj->supertype == DWG_SUPERTYPE_ENTITY)
      {
        f = dwg_dynapi_common_entity_field (fieldname);
        _obj = obj->tio.entity;
      }
    else if (obj->supertype == DWG_SUPERTYPE_OBJECT)
      {
        f = dwg_dynapi_common_object_field (fieldname);
        _obj = obj->tio.object;
      }
    else
      {
        const int loglevel = obj->parent->opts & 0xf; // DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Unhandled %s.supertype ", __FUNCTION__, obj->name);
        return false;
      }

    if (f)
      {
        if (fp)
          memcpy (fp, f, sizeof(Dwg_DYNAPI_field));
        memcpy (out, &((char *)_obj)[f->offset], f->size);
        return true;
      }
    else
      {
        const int loglevel = obj->parent->opts & 0xf;
        LOG_ERROR ("%s: Invalid common field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_common_utf8text(void *restrict _obj, const char *restrict fieldname,
                           char **restrict out, Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !out)
    return false;
#endif
  {
    Dwg_DYNAPI_field *f;
    int error;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    Dwg_Data *dwg;

    if (!obj)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }
    if (obj->supertype == DWG_SUPERTYPE_ENTITY)
      {
        dwg = obj ? obj->parent : ((Dwg_Entity_UNKNOWN_ENT *)_obj)->parent->dwg;
        _obj = obj->tio.entity;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_entity_fields,
            ARRAY_SIZE (_dwg_object_entity_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_entity_fields[0]), _name_struct_cmp);
      }
    else if (obj->supertype == DWG_SUPERTYPE_OBJECT)
      {
        dwg = obj ? obj->parent : ((Dwg_Object_UNKNOWN_OBJ *)_obj)->parent->dwg;
        _obj = obj->tio.object;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_object_fields,
            ARRAY_SIZE (_dwg_object_object_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_object_fields[0]), _name_struct_cmp);
      }
    else
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Unhandled %s.supertype ", __FUNCTION__, obj->name);
        return false;
      }

    if (f && f->is_string)
      {
        const Dwg_Version_Type dwg_version = dwg->header.version;

        if (fp)
          memcpy (fp, f, sizeof(Dwg_DYNAPI_field));

        if (dwg_version >= R_2007 && strNE (f->type, "TF")) /* not TF */
          {
            BITCODE_TU wstr = *(BITCODE_TU*)((char*)_obj + f->offset);
            char *utf8 = bit_convert_TU (wstr);
            if (!utf8) // some conversion error, invalid wchar (nyi)
              return false;
            *out = utf8;
          }
        else
          {
            char *utf8 = *(char **)((char*)_obj + f->offset);
            *out = utf8;
          }

        return true;
      }
    else
      {
        const int loglevel = dwg->opts & 0xf;
        LOG_ERROR ("%s: Invalid common text field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

// create a fresh string
static void
dynapi_set_helper (void *restrict old, const Dwg_DYNAPI_field *restrict f,
                   const Dwg_Version_Type dwg_version,
                   const void *restrict value, const bool is_utf8)
{
  // TODO: sanity checks
  // if text strcpy or wcscpy, or do utf8 conversion.
  //if ((char*)old && f->is_malloc)
  //  free (old);
  if (f->is_string)
    {
      //ascii or wide?
      if (strEQc (f->type, "TF") || dwg_version < R_2007)
        {
          char *str = malloc (strlen (*(char**)value)+1);
          strcpy (str, *(char**)value);
          memcpy (old, &str, f->size); // size of ptr
        }
      else if (strNE (f->type, "TF") && dwg_version >= R_2007)
        {
          BITCODE_TU wstr;
          if (is_utf8)
            wstr = bit_utf8_to_TU (*(char **)value);
          else // source is already TU
            {
#if defined(HAVE_WCHAR_H) && defined(SIZEOF_WCHAR_T) && SIZEOF_WCHAR_T == 2
              wstr = malloc (2 * (wcslen (*(wchar_t **)value) + 1));
              wcscpy ((wchar_t *)wstr, *(wchar_t **)value);
#else
              int length = 0;
              for (; (*(BITCODE_TU*)value)[length]; length++)
                ;
              length++;
              wstr = malloc (2 * length);
              memcpy (wstr, value, length * 2);
#endif
            }
          memcpy (old, &wstr, f->size); // size of ptr
        }
    }
  else
    memcpy (old, value, f->size);
}

/* generic field setters */
EXPORT bool
dwg_dynapi_entity_set_value (void *restrict _obj, const char *restrict name,
                             const char *restrict fieldname,
                             const void *restrict value, const bool is_utf8)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !value) // cannot set NULL value
    return false;
#endif
  {
    int error;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    if (obj && strNE (obj->name, name))
      {
        const int loglevel = obj->parent->opts & 0xf;
        LOG_ERROR ("%s: Invalid entity type %s, wanted %s", __FUNCTION__,
                   obj->name, name);
        return false;
      }
    {
      void *old;
      const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (name, fieldname);
      const Dwg_Data *dwg
        = obj ? obj->parent
              : ((Dwg_Object_UNKNOWN_OBJ *)_obj)->parent->dwg;
      const Dwg_Version_Type dwg_version = dwg->header.version;

      if (!f)
        {
          const int loglevel = dwg->opts & 0xf;
          LOG_ERROR ("%s: Invalid %s field %s", __FUNCTION__, name, fieldname);
          return false;
        }

      old = &((char*)_obj)[f->offset];
      dynapi_set_helper (old, f, dwg_version, value, is_utf8);
      return true;
    }
  }
}

EXPORT bool
dwg_dynapi_header_set_value (const Dwg_Data *restrict dwg,
                             const char *restrict fieldname,
                             const void *restrict value, const bool is_utf8)
{
#ifndef HAVE_NONNULL
  if (!dwg || !fieldname || !value) // cannot set NULL value
    return false;
#endif
  {
    Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)bsearch (
        fieldname, _dwg_header_variables_fields,
        ARRAY_SIZE (_dwg_header_variables_fields) - 1, /* NULL terminated */
        sizeof (_dwg_header_variables_fields[0]), _name_struct_cmp);
    if (f)
      {
        void *old;
        // there are no malloc'd fields in the HEADER, so no need to free().
        const Dwg_Header_Variables *const _obj = &dwg->header_vars;

        old = &((char*)_obj)[f->offset];
        dynapi_set_helper (old, f, dwg->header.version, value, is_utf8);
        return true;
      }
    else
      {
        const int loglevel = dwg->opts & 0xf;
        LOG_ERROR ("%s: Invalid header field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_common_set_value (void *restrict _obj,
                             const char *restrict fieldname,
                             const void *restrict value, const bool is_utf8)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !value)
    return false;
#endif
  {
    Dwg_DYNAPI_field *f;
    int error;
    void *old;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    if (!obj)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }
    if (obj->supertype == DWG_SUPERTYPE_ENTITY)
      {
        _obj = obj->tio.entity;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_entity_fields,
            ARRAY_SIZE (_dwg_object_entity_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_entity_fields[0]), _name_struct_cmp);
      }
    else if (obj->supertype == DWG_SUPERTYPE_OBJECT)
      {
        _obj = obj->tio.object;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_object_fields,
            ARRAY_SIZE (_dwg_object_object_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_object_fields[0]), _name_struct_cmp);
      }
    else
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Unhandled %s.supertype ", __FUNCTION__, obj->name);
        return false;
      }

    if (!f)
      {
        const int loglevel = obj->parent->opts & 0xf;
        LOG_ERROR ("%s: Invalid %s common field %s", __FUNCTION__, obj->name, fieldname);
        return false;
      }

    old = &((char*)_obj)[f->offset];
    dynapi_set_helper (old, f, obj->parent->header.version, value, is_utf8);
    return true;
  }
}

// check if the handle points to an object with a name.
// see also dwg_obj_table_get_name, which only supports tables.
EXPORT char*
dwg_dynapi_handle_name (const Dwg_Data *restrict dwg, Dwg_Object_Ref *restrict hdl)
{
  const Dwg_Version_Type dwg_version = dwg->header.version;
  Dwg_Object *obj;

#ifndef HAVE_NONNULL
  if (!dwg || !hdl)
    return NULL;
#endif

  obj = dwg_ref_object_silent (dwg, hdl);
  if (!obj)
    return NULL;
  {
    const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (obj->name, "name");
    // just some random type is enough.
    Dwg_Object_STYLE *_obj = obj->tio.object->tio.STYLE;

    if (!f || !f->is_string)
      return NULL;
    if (dwg_version >= R_2007 && strNE (f->type, "TF")) /* not TF */
      {
        BITCODE_TU wstr = *(BITCODE_TU *)((char *)_obj + f->offset);
        return bit_convert_TU (wstr);
      }
    else
      {
        return *(char **)((char *)_obj + f->offset);
      }
  }
}

/* Local Variables: */
/* mode: c */
/* End: */
