/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */



var stubListenerHTML = {
    originalListener: {
	dataAvailableTriggered: false,
	stopRequestTriggered: false,
	onDataAvailable: function () { this.dataAvailableTriggered = true; },
	onStopRequest: function () { this.stopRequestTriggered = true; }
    },
    receivedData: ['<!doctype><html>',
	   '<body><h1>Hello World!</h1></body>',
	   '</html>']
};

var stubResInfoHTML = {
    request: {
	contentType: 'text/html',
	URI: {spec: 'http://www.example.org'},
	referrer: {spec: ''},
	contentCharset: 'UTF-8',
	cancel: function () { }
    },
    statusCode: 200
};

var stubListenerJS = {
    originalListener: {
	dataAvailableTriggered: false,
	stopRequestTriggered: false,
	onDataAvailable: function () { this.dataAvailableTriggered = true; },
	onStopRequest: function () { this.stopRequestTriggered = true; }
    },
    receivedData: ['var g = 100; var t = 0; for (; t < g; t++) { doSomething(t); }']
};

var stubResInfoJS = {
    request: {
	contentType: 'application/javascript',
	URI: {spec: 'http://www.example.com/test.js'},
	referrer: {spec: 'http://www.example.com/'},
	contentCharset: 'UTF-8',
	cancel: function () { }
    },
    statusCode: 200
};

var responseModule = require('http_observer/process_response.js');

exports.testProcessHtml = function (assert, done) {
    var obj = responseModule.ProcessResponse(stubListenerHTML, stubResInfoHTML);
    obj.processHTML();
    require("timer").setTimeout(function () {
	assert.equal(obj.listener.originalListener.dataAvailableTriggered, true);
	done();
    }, 500);
};

exports.testProcessJS = function (assert, done) {
    var obj = responseModule.ProcessResponse(stubListenerJS, stubResInfoJS);
    obj.processJS();
    assert.equal(obj.data, 'var g = 100; var t = 0; for (; t < g; t++) { doSomething(t); }');
    done();
};

exports.testProcessAllTypes = function (assert, done) {
    stubListenerHTML.originalListener.dataAvailableTriggered = false;
    stubListenerHTML.originalListener.stopRequestTriggered = false;
    var obj = responseModule.ProcessResponse(stubListenerHTML, stubResInfoHTML);
    obj.processAllTypes();
    require("timer").setTimeout(function () {
	assert.equal(obj.listener.originalListener.dataAvailableTriggered, true);
	done();
    }, 500);
};


require("test").run(exports);