/*
 A JavaScript implementation of the SHA family of hashes, as
 defined in FIPS PUB 180-4 and FIPS PUB 202, as well as the corresponding
 HMAC implementation as defined in FIPS PUB 198a

 Copyright 2008-2020 Brian Turek, 1998-2009 Paul Johnston & Contributors
 Distributed under the BSD License
 See http://caligatio.github.com/jsSHA/ for more information
*/
'use strict';(function(K){function w(d,a,c){var h=0,b=[],e=0,f,k,n,g,l,q,y,p,m=!1,t=[],r=[],u,z=!1;c=c||{};f=c.encoding||"UTF8";u=c.numRounds||1;if(u!==parseInt(u,10)||1>u)throw Error("numRounds must a integer >= 1");if(0===d.lastIndexOf("SHA-",0))if(q=function(a,b){return A(a,b,d)},y=function(a,b,h,e){var c,f;if("SHA-224"===d||"SHA-256"===d)c=(b+65>>>9<<4)+15,f=16;else throw Error("Unexpected error in SHA-2 implementation");for(;a.length<=c;)a.push(0);a[b>>>5]|=128<<24-b%32;b=b+h;a[c]=b&4294967295;
a[c-1]=b/4294967296|0;h=a.length;for(b=0;b<h;b+=f)e=A(a.slice(b,b+f),e,d);if("SHA-224"===d)a=[e[0],e[1],e[2],e[3],e[4],e[5],e[6]];else if("SHA-256"===d)a=e;else throw Error("Unexpected error in SHA-2 implementation");return a},p=function(b){return b.slice()},"SHA-224"===d)l=512,g=224;else if("SHA-256"===d)l=512,g=256;else throw Error("Chosen SHA variant is not supported");else throw Error("Chosen SHA variant is not supported");n=B(a,f);k=x(d);this.setHMACKey=function(b,a,e){var c;if(!0===m)throw Error("HMAC key already set");
if(!0===z)throw Error("Cannot set HMAC key after calling update");f=(e||{}).encoding||"UTF8";a=B(a,f)(b);b=a.binLen;a=a.value;c=l>>>3;e=c/4-1;if(c<b/8){for(a=y(a,b,0,x(d));a.length<=e;)a.push(0);a[e]&=4294967040}else if(c>b/8){for(;a.length<=e;)a.push(0);a[e]&=4294967040}for(b=0;b<=e;b+=1)t[b]=a[b]^909522486,r[b]=a[b]^1549556828;k=q(t,k);h=l;m=!0};this.update=function(a){var d,c,f,g=0,p=l>>>5;d=n(a,b,e);a=d.binLen;c=d.value;d=a>>>5;for(f=0;f<d;f+=p)g+l<=a&&(k=q(c.slice(f,f+p),k),g+=l);h+=g;b=c.slice(g>>>
5);e=a%l;z=!0};this.getHash=function(a,c){var f,l,n,q;if(!0===m)throw Error("Cannot call getHash after setting HMAC key");n=C(c);switch(a){case "HEX":f=function(a){return D(a,g,n)};break;case "B64":f=function(a){return E(a,g,n)};break;case "BYTES":f=function(a){return F(a,g)};break;case "ARRAYBUFFER":try{l=new ArrayBuffer(0)}catch(v){throw Error("ARRAYBUFFER not supported by this environment");}f=function(a){return G(a,g)};break;case "UINT8ARRAY":try{l=new Uint8Array(0)}catch(v){throw Error("UINT8ARRAY not supported by this environment");
}f=function(a){return H(a,g)};break;default:throw Error("format must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}q=y(b.slice(),e,h,p(k));for(l=1;l<u;l+=1)q=y(q,g,0,x(d));return f(q)};this.getHMAC=function(a,f){var c,n,t,u;if(!1===m)throw Error("Cannot call getHMAC without first setting HMAC key");t=C(f);switch(a){case "HEX":c=function(a){return D(a,g,t)};break;case "B64":c=function(a){return E(a,g,t)};break;case "BYTES":c=function(a){return F(a,g)};break;case "ARRAYBUFFER":try{c=new ArrayBuffer(0)}catch(v){throw Error("ARRAYBUFFER not supported by this environment");
}c=function(a){return G(a,g)};break;case "UINT8ARRAY":try{c=new Uint8Array(0)}catch(v){throw Error("UINT8ARRAY not supported by this environment");}c=function(a){return H(a,g)};break;default:throw Error("outputFormat must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}n=y(b.slice(),e,h,p(k));u=q(r,x(d));u=y(n,g,l,u);return c(u)}}function m(){}function I(d,a,c){var h,b,e,f;a=a||[0];c=c||0;b=c>>>3;for(h=0;h<d.length;h+=1)f=h+b,e=f>>>2,a.length<=e&&a.push(0),a[e]|=d[h]<<8*(3+f%4*-1);return{value:a,
binLen:8*d.length+c}}function D(d,a,c){var h="";a/=8;var b,e;for(b=0;b<a;b+=1)e=d[b>>>2]>>>8*(3+b%4*-1),h+="0123456789abcdef".charAt(e>>>4&15)+"0123456789abcdef".charAt(e&15);return c.outputUpper?h.toUpperCase():h}function E(d,a,c){var h="",b=a/8,e,f,k;for(e=0;e<b;e+=3)for(f=e+1<b?d[e+1>>>2]:0,k=e+2<b?d[e+2>>>2]:0,k=(d[e>>>2]>>>8*(3+e%4*-1)&255)<<16|(f>>>8*(3+(e+1)%4*-1)&255)<<8|k>>>8*(3+(e+2)%4*-1)&255,f=0;4>f;f+=1)8*e+6*f<=a?h+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(k>>>
6*(3-f)&63):h+=c.b64Pad;return h}function F(d,a){var c="",h=a/8,b,e;for(b=0;b<h;b+=1)e=d[b>>>2]>>>8*(3+b%4*-1)&255,c+=String.fromCharCode(e);return c}function G(d,a){var c=a/8,h,b=new ArrayBuffer(c),e;e=new Uint8Array(b);for(h=0;h<c;h+=1)e[h]=d[h>>>2]>>>8*(3+h%4*-1)&255;return b}function H(d,a){var c=a/8,h,b=new Uint8Array(c);for(h=0;h<c;h+=1)b[h]=d[h>>>2]>>>8*(3+h%4*-1)&255;return b}function C(d){var a={outputUpper:!1,b64Pad:"=",shakeLen:-1};d=d||{};a.outputUpper=d.outputUpper||!1;!0===d.hasOwnProperty("b64Pad")&&
(a.b64Pad=d.b64Pad);if("boolean"!==typeof a.outputUpper)throw Error("Invalid outputUpper formatting option");if("string"!==typeof a.b64Pad)throw Error("Invalid b64Pad formatting option");return a}function B(d,a){var c;switch(a){case "UTF8":case "UTF16BE":case "UTF16LE":break;default:throw Error("encoding must be UTF8, UTF16BE, or UTF16LE");}switch(d){case "HEX":c=function(a,b,e){var d=a.length,c,n,g,l,q;if(0!==d%2)throw Error("String of HEX type must be in byte increments");b=b||[0];e=e||0;q=e>>>
3;for(c=0;c<d;c+=2){n=parseInt(a.substr(c,2),16);if(isNaN(n))throw Error("String of HEX type contains invalid characters");l=(c>>>1)+q;for(g=l>>>2;b.length<=g;)b.push(0);b[g]|=n<<8*(3+l%4*-1)}return{value:b,binLen:4*d+e}};break;case "TEXT":c=function(c,b,d){var f,k,n=0,g,l,q,m,p,r;b=b||[0];d=d||0;q=d>>>3;if("UTF8"===a)for(r=3,g=0;g<c.length;g+=1)for(f=c.charCodeAt(g),k=[],128>f?k.push(f):2048>f?(k.push(192|f>>>6),k.push(128|f&63)):55296>f||57344<=f?k.push(224|f>>>12,128|f>>>6&63,128|f&63):(g+=1,f=
65536+((f&1023)<<10|c.charCodeAt(g)&1023),k.push(240|f>>>18,128|f>>>12&63,128|f>>>6&63,128|f&63)),l=0;l<k.length;l+=1){p=n+q;for(m=p>>>2;b.length<=m;)b.push(0);b[m]|=k[l]<<8*(r+p%4*-1);n+=1}else if("UTF16BE"===a||"UTF16LE"===a)for(r=2,k="UTF16LE"===a&&!0||"UTF16LE"!==a&&!1,g=0;g<c.length;g+=1){f=c.charCodeAt(g);!0===k&&(l=f&255,f=l<<8|f>>>8);p=n+q;for(m=p>>>2;b.length<=m;)b.push(0);b[m]|=f<<8*(r+p%4*-1);n+=2}return{value:b,binLen:8*n+d}};break;case "B64":c=function(a,b,c){var d=0,k,n,g,l,q,m,p;if(-1===
a.search(/^[a-zA-Z0-9=+\/]+$/))throw Error("Invalid character in base-64 string");n=a.indexOf("=");a=a.replace(/\=/g,"");if(-1!==n&&n<a.length)throw Error("Invalid '=' found in base-64 string");b=b||[0];c=c||0;m=c>>>3;for(n=0;n<a.length;n+=4){q=a.substr(n,4);for(g=l=0;g<q.length;g+=1)k="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(q.charAt(g)),l|=k<<18-6*g;for(g=0;g<q.length-1;g+=1){p=d+m;for(k=p>>>2;b.length<=k;)b.push(0);b[k]|=(l>>>16-8*g&255)<<8*(3+p%4*-1);d+=1}}return{value:b,
binLen:8*d+c}};break;case "BYTES":c=function(a,b,c){var d,k,n,g,l;b=b||[0];c=c||0;n=c>>>3;for(k=0;k<a.length;k+=1)d=a.charCodeAt(k),l=k+n,g=l>>>2,b.length<=g&&b.push(0),b[g]|=d<<8*(3+l%4*-1);return{value:b,binLen:8*a.length+c}};break;case "ARRAYBUFFER":try{c=new ArrayBuffer(0)}catch(h){throw Error("ARRAYBUFFER not supported by this environment");}c=function(a,b,c){return I(new Uint8Array(a),b,c)};break;case "UINT8ARRAY":try{c=new Uint8Array(0)}catch(h){throw Error("UINT8ARRAY not supported by this environment");
}c=function(a,b,c){return I(a,b,c)};break;default:throw Error("format must be HEX, TEXT, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}return c}function r(d,a){return d>>>a|d<<32-a}function L(d,a,c){return d&a^~d&c}function M(d,a,c){return d&a^d&c^a&c}function N(d){return r(d,2)^r(d,13)^r(d,22)}function O(d){return r(d,6)^r(d,11)^r(d,25)}function P(d){return r(d,7)^r(d,18)^d>>>3}function Q(d){return r(d,17)^r(d,19)^d>>>10}function R(d,a){var c=(d&65535)+(a&65535);return((d>>>16)+(a>>>16)+(c>>>16)&65535)<<
16|c&65535}function S(d,a,c,h){var b=(d&65535)+(a&65535)+(c&65535)+(h&65535);return((d>>>16)+(a>>>16)+(c>>>16)+(h>>>16)+(b>>>16)&65535)<<16|b&65535}function T(d,a,c,h,b){var e=(d&65535)+(a&65535)+(c&65535)+(h&65535)+(b&65535);return((d>>>16)+(a>>>16)+(c>>>16)+(h>>>16)+(b>>>16)+(e>>>16)&65535)<<16|e&65535}function x(d){var a=[],c;if(0===d.lastIndexOf("SHA-",0))switch(a=[3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428],c=[1779033703,3144134277,1013904242,2773480762,
1359893119,2600822924,528734635,1541459225],d){case "SHA-224":break;case "SHA-256":a=c;break;case "SHA-384":a=[new m,new m,new m,new m,new m,new m,new m,new m];break;case "SHA-512":a=[new m,new m,new m,new m,new m,new m,new m,new m];break;default:throw Error("Unknown SHA variant");}else throw Error("No SHA variants supported");return a}function A(d,a,c){var h,b,e,f,k,n,g,l,m,r,p,w,t,x,u,z,A,B,C,D,E,F,v=[],G;if("SHA-224"===c||"SHA-256"===c)r=64,w=1,F=Number,t=R,x=S,u=T,z=P,A=Q,B=N,C=O,E=M,D=L,G=J;
else throw Error("Unexpected error in SHA-2 implementation");c=a[0];h=a[1];b=a[2];e=a[3];f=a[4];k=a[5];n=a[6];g=a[7];for(p=0;p<r;p+=1)16>p?(m=p*w,l=d.length<=m?0:d[m],m=d.length<=m+1?0:d[m+1],v[p]=new F(l,m)):v[p]=x(A(v[p-2]),v[p-7],z(v[p-15]),v[p-16]),l=u(g,C(f),D(f,k,n),G[p],v[p]),m=t(B(c),E(c,h,b)),g=n,n=k,k=f,f=t(e,l),e=b,b=h,h=c,c=t(l,m);a[0]=t(c,a[0]);a[1]=t(h,a[1]);a[2]=t(b,a[2]);a[3]=t(e,a[3]);a[4]=t(f,a[4]);a[5]=t(k,a[5]);a[6]=t(n,a[6]);a[7]=t(g,a[7]);return a}var J;J=[1116352408,1899447441,
3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,
506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];"function"===typeof define&&define.amd?define(function(){return w}):"undefined"!==typeof exports?("undefined"!==typeof module&&module.exports&&(module.exports=w),exports=w):K.jsSHA=w})(this);
