# stack-direction.m4 serial 2 (libsigsegv-2.11)
dnl Copyright (C) 2002-2009, 2013-2014 Bruno Haible <bruno@clisp.org>
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# Determine the stack direction. Define the C macro STACK_DIRECTION.
AC_DEFUN([SV_STACK_DIRECTION],
[
  AC_CACHE_CHECK([for stack direction], [sv_cv_stack_direction_msg], [
    case "$host_cpu" in
      dnl See the #define STACK_GROWS_DOWNWARD in gcc-3.1/gcc/config/*/*.h.
      a29k | \
      aarch64* | \
      alpha* | \
      arc | \
      arm* | strongarm* | xscale* | \
      avr | avr32 | \
      bfin | \
      c1 | c2 | c32 | c34 | c38 | \
      clipper | \
      cris | \
      d30v | \
      elxsi | \
      fr30 | \
      h8300 | \
      i?86 | x86_64 | \
      i860 | \
      ia64 | \
      m32r | \
      m68* | \
      m88k | \
      mcore | \
      microblaze | \
      mips* | \
      mmix | \
      mn10200 | \
      mn10300 | \
      nios2 | \
      ns32k | \
      pdp11 | \
      pj* | \
      powerpc* | rs6000 | \
      romp | \
      s390* | \
      sh* | \
      sparc* | \
      v850 | \
      vax | \
      xtensa)
        sv_cv_stack_direction=-1 ;;
      c4x | \
      dsp16xx | \
      i960 | \
      hppa* | parisc* | \
      stormy16 | \
      we32k)
        sv_cv_stack_direction=1 ;;
      *)
        if test $cross_compiling = no; then
          cat > conftest.c <<EOF
#include <stdio.h>
int
get_stack_direction ()
{
  auto char dummy;
  static char *dummyaddr = (char *)0;
  if (dummyaddr != (char *)0)
    return &dummy > dummyaddr ? 1 : &dummy < dummyaddr ? -1 : 0;
  else
    {
      dummyaddr = &dummy;
      {
        int result = get_stack_direction ();
        /* The next assignment avoids tail recursion elimination
           (IRIX 6.4 CC).  */
        dummyaddr = (char *)0;
        return result;
      }
    }
}
int
main ()
{
  printf ("%d\n", get_stack_direction ());
  return 0;
}
EOF
          AC_TRY_EVAL([ac_link])
          sv_cv_stack_direction=`./conftest`
        else
          sv_cv_stack_direction=0
        fi
        ;;
    esac
    case $sv_cv_stack_direction in
      1)  sv_cv_stack_direction_msg="grows up";;
      -1) sv_cv_stack_direction_msg="grows down";;
      *)  sv_cv_stack_direction_msg="unknown";;
    esac
  ])
  AC_DEFINE_UNQUOTED([STACK_DIRECTION], [$sv_cv_stack_direction],
    [Define as the direction of stack growth for your system.
     STACK_DIRECTION > 0 => grows toward higher addresses
     STACK_DIRECTION < 0 => grows toward lower addresses
     STACK_DIRECTION = 0 => spaghetti stack.])
])
