/* rsa-md5-verify.c
 *
 * Verifying signatures created with RSA and MD5.
 */

/* nettle, low-level cryptographics library
 *
 * Copyright (C) 2001, 2003 Niels Mller
 *  
 * The nettle library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * The nettle library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with the nettle library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#if WITH_PUBLIC_KEY

#include <assert.h>

#include "rsa.h"

#include "bignum.h"
#include "pkcs1.h"

int
rsa_md5_verify(const struct rsa_public_key *key,
               struct md5_ctx *hash,
               const mpz_t s)
{
  int res;
  mpz_t m;

  assert(key->size >= RSA_MINIMUM_N_OCTETS);
  mpz_init(m);
  
  pkcs1_rsa_md5_encode(m, key->size - 1, hash);
  res = _rsa_verify(key, m, s);

  mpz_clear(m);

  return res;
}

int
rsa_md5_verify_digest(const struct rsa_public_key *key,
		      const uint8_t *digest,
		      const mpz_t s)
{
  int res;
  mpz_t m;

  assert(key->size >= RSA_MINIMUM_N_OCTETS);
  
  mpz_init(m);
  
  pkcs1_rsa_md5_encode_digest(m, key->size - 1, digest);
  res = _rsa_verify(key, m, s);

  mpz_clear(m);

  return res;
}

#endif /* WITH_PUBLIC_KEY */
