/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2003 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

/* MH whatnow command */

#include <mh.h>

const char *argp_program_version = "whatnow (" PACKAGE_STRING ")";
static char doc[] = "GNU MH whatnow";
static char args_doc[] = N_("[FILE]");

/* GNU options */
static struct argp_option options[] = {
  {"draftfolder", ARG_DRAFTFOLDER, N_("FOLDER"), 0,
   N_("Specify the folder for message drafts")},
  {"nodraftfolder", ARG_NODRAFTFOLDER, 0, 0,
   N_("Undo the effect of the last --draftfolder option")},
  {"draftmessage" , ARG_DRAFTMESSAGE, N_("MSG"), 0,
   N_("Invoke the draftmessage facility")},
  {"editor",  ARG_EDITOR, N_("PROG"), 0, N_("Set the editor program to use")},
  {"noedit", ARG_NOEDIT, 0, 0, N_("Suppress the initial edit")},
  {"prompt", ARG_PROMPT, N_("STRING"), 0, N_("Set the prompt")},
  { NULL }
};

/* Traditional MH options */
struct mh_option mh_option[] = {
  {"draftfolder", 6, MH_OPT_ARG, "folder"},
  {"nodraftfolder", 3, },
  {"draftmessage", 6, },
  {"editor", 1, MH_OPT_ARG, "program"},
  {"noedit", 3, },
  {"prompt", 1 },
  { 0 }
};

struct mh_whatnow_env wh_env = { 0 };
static int initial_edit = 1;

static int
opt_handler (int key, char *arg, void *unused, struct argp_state *state)
{
  switch (key)
    {
    case ARG_DRAFTFOLDER:
      wh_env.draftfolder = arg;
      break;
      
    case ARG_EDITOR:
      wh_env.editor = arg;
      break;
      
    case ARG_NODRAFTFOLDER:
      wh_env.draftfolder = NULL;
      break;

    case ARG_NOEDIT:
      initial_edit = 0;
      break;

    case ARG_DRAFTMESSAGE:
      wh_env.draftmessage = arg;
      break;

    case ARG_PROMPT:
      wh_env.prompt = arg;
      break;
      
    default:
      return 1;
    }
  return 0;
}

int
main (int argc, char **argv)
{
  int index;
  
  mu_init_nls ();

  mh_argp_parse (argc, argv, 0, options, mh_option, args_doc, doc,
		 opt_handler, NULL, &index);

  wh_env.msg = getenv ("mhaltmsg");
  return mh_whatnow (&wh_env, initial_edit);
}
  
