#line 2 "mh_alias.l"
/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2003, 2005-2007, 2009-2012, 2014-2017 Free Software
   Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#line 26 "mh_alias_lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 37
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define ali_yyconst const
#else
#define ali_yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (ali_yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((ali_yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE ali_yyrestart(ali_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(ali_yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct ali_yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t ali_yy_size_t;
#endif

extern ali_yy_size_t ali_yyleng;

extern FILE *ali_yyin, *ali_yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define ali_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up ali_yytext. */ \
        int ali_yyless_macro_arg = (n); \
        YY_LESS_LINENO(ali_yyless_macro_arg);\
		*ali_yy_cp = (ali_yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(ali_yy_c_buf_p) = ali_yy_cp = ali_yy_bp + ali_yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up ali_yytext again */ \
		} \
	while ( 0 )

#define unput(c) ali_yyunput( c, (ali_yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct ali_yy_buffer_state
	{
	FILE *ali_yy_input_file;

	char *ali_yy_ch_buf;		/* input buffer */
	char *ali_yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	ali_yy_size_t ali_yy_buf_size;

	/* Number of characters read into ali_yy_ch_buf, not including EOB
	 * characters.
	 */
	ali_yy_size_t ali_yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int ali_yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int ali_yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int ali_yy_at_bol;

    int ali_yy_bs_lineno; /**< The line count. */
    int ali_yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int ali_yy_fill_buffer;

	int ali_yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via ali_yyrestart()), so that the user can continue scanning by
	 * just pointing ali_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t ali_yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t ali_yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * ali_yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (ali_yy_buffer_stack) \
                          ? (ali_yy_buffer_stack)[(ali_yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (ali_yy_buffer_stack)[(ali_yy_buffer_stack_top)]

/* ali_yy_hold_char holds the character lost when ali_yytext is formed. */
static char ali_yy_hold_char;
static ali_yy_size_t ali_yy_n_chars;		/* number of characters read into ali_yy_ch_buf */
ali_yy_size_t ali_yyleng;

/* Points to current character in buffer. */
static char *ali_yy_c_buf_p = (char *) 0;
static int ali_yy_init = 0;		/* whether we need to initialize */
static int ali_yy_start = 0;	/* start state number */

/* Flag which is used to allow ali_yywrap()'s to do buffer switches
 * instead of setting up a fresh ali_yyin.  A bit of a hack ...
 */
static int ali_yy_did_buffer_switch_on_eof;

void ali_yyrestart (FILE *input_file  );
void ali_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE ali_yy_create_buffer (FILE *file,int size  );
void ali_yy_delete_buffer (YY_BUFFER_STATE b  );
void ali_yy_flush_buffer (YY_BUFFER_STATE b  );
void ali_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void ali_yypop_buffer_state (void );

static void ali_yyensure_buffer_stack (void );
static void ali_yy_load_buffer_state (void );
static void ali_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER ali_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE ali_yy_scan_buffer (char *base,ali_yy_size_t size  );
YY_BUFFER_STATE ali_yy_scan_string (ali_yyconst char *ali_yy_str  );
YY_BUFFER_STATE ali_yy_scan_bytes (ali_yyconst char *bytes,ali_yy_size_t len  );

void *ali_yyalloc (ali_yy_size_t  );
void *ali_yyrealloc (void *,ali_yy_size_t  );
void ali_yyfree (void *  );

#define ali_yy_new_buffer ali_yy_create_buffer

#define ali_yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        ali_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            ali_yy_create_buffer(ali_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->ali_yy_is_interactive = is_interactive; \
	}

#define ali_yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        ali_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            ali_yy_create_buffer(ali_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->ali_yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->ali_yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *ali_yyin = (FILE *) 0, *ali_yyout = (FILE *) 0;

typedef int ali_yy_state_type;

extern int ali_yylineno;

int ali_yylineno = 1;

extern char *ali_yytext;
#define ali_yytext_ptr ali_yytext

static ali_yy_state_type ali_yy_get_previous_state (void );
static ali_yy_state_type ali_yy_try_NUL_trans (ali_yy_state_type current_state  );
static int ali_yy_get_next_buffer (void );
static void ali_yy_fatal_error (ali_yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up ali_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(ali_yytext_ptr) = ali_yy_bp; \
	ali_yyleng = (size_t) (ali_yy_cp - ali_yy_bp); \
	(ali_yy_hold_char) = *ali_yy_cp; \
	*ali_yy_cp = '\0'; \
	(ali_yy_c_buf_p) = ali_yy_cp;

#define YY_NUM_RULES 11
#define YY_END_OF_BUFFER 12
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct ali_yy_trans_info
	{
	flex_int32_t ali_yy_verify;
	flex_int32_t ali_yy_nxt;
	};
static ali_yyconst flex_int16_t ali_yy_accept[43] =
    {   0,
        0,    0,    0,    0,   12,    6,    5,    2,    8,   10,
        6,    6,    5,    8,   10,    6,    6,    9,    6,    6,
        9,    6,    6,    5,    1,    6,    4,    0,    5,    0,
        0,    0,    3,    7,    0,    6,    9,    6,    4,    7,
        9,    0
    } ;

static ali_yyconst flex_int32_t ali_yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    5,    7,    8,
        5,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    9,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static ali_yyconst flex_int32_t ali_yy_meta[10] =
    {   0,
        1,    2,    3,    4,    5,    3,    5,    5,    1
    } ;

static ali_yyconst flex_int16_t ali_yy_base[49] =
    {   0,
        0,    9,   18,   27,   49,    0,   40,  104,  104,  104,
       38,   36,   36,   36,   32,   43,   47,    0,   56,   65,
       74,   30,    0,   30,  104,   27,  104,   26,    0,   26,
       23,   21,  104,   21,    0,   19,    0,    0,    0,   19,
        0,  104,   19,   83,   87,   92,   94,   99
    } ;

static ali_yyconst flex_int16_t ali_yy_def[49] =
    {   0,
       42,   42,    1,    2,   42,   43,   42,   42,   42,   42,
       43,   44,   42,   45,   46,   44,   47,   47,   47,   47,
       47,   20,   43,   42,   42,   44,   42,   48,   13,   45,
       46,   45,   42,   46,   31,   19,   47,   20,   47,   21,
       21,    0,   42,   42,   42,   42,   42,   42
    } ;

static ali_yyconst flex_int16_t ali_yy_nxt[114] =
    {   0,
        6,    7,    8,    9,    9,    9,    9,   10,   11,   12,
       13,    8,    9,    9,    9,   14,   15,   16,   17,   23,
       37,   42,   42,   33,   35,   18,   19,   20,   33,   27,
       27,   24,   25,   35,   21,   22,   28,   29,   33,   27,
       25,   24,   30,   31,   28,   25,   27,   36,   42,   42,
       42,   42,   42,   42,   42,   36,   36,   42,   25,   42,
       42,   42,   42,   42,   36,   38,   42,   42,   39,   42,
       42,   42,   42,   38,   40,   41,   42,   42,   42,   42,
       42,   42,   40,   26,   42,   42,   26,   32,   32,   32,
       32,   32,   34,   34,   37,   37,   42,   37,   37,   28,

       42,   42,   28,    5,   42,   42,   42,   42,   42,   42,
       42,   42,   42
    } ;

static ali_yyconst flex_int16_t ali_yy_chk[114] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    3,   43,
       40,   36,   34,   32,   31,    3,    3,    4,   30,   28,
       26,   24,   22,   15,    4,    4,   13,   13,   14,   12,
       11,    7,   13,   13,   13,   16,   16,   17,    5,    0,
        0,    0,    0,    0,    0,   17,   19,    0,   19,    0,
        0,    0,    0,    0,   19,   20,    0,    0,   20,    0,
        0,    0,    0,   20,   21,   21,    0,    0,    0,    0,
        0,    0,   21,   44,    0,    0,   44,   45,   45,   45,
       45,   45,   46,   46,   47,   47,    0,   47,   47,   48,

        0,    0,   48,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42
    } ;

static ali_yy_state_type ali_yy_last_accepting_state;
static char *ali_yy_last_accepting_cpos;

extern int ali_yy_flex_debug;
int ali_yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define ali_yymore() ali_yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *ali_yytext;
#line 1 "mh_alias.l"

#line 25 "mh_alias.l"
#include <mh.h>
#include <mh_alias.h>
#include <sys/stat.h>
#include <mailutils/cctype.h>
#include <mailutils/io.h>
  
char *ali_filename;  
size_t ali_line_num;  
ino_t ali_source_inode;

void
va_ali_parse_error_loc (const char *name, size_t line,
			      const char *fmt, va_list ap)
{
  char *buf = NULL;
  size_t size = 0;

  mu_vasnprintf (&buf, &size, fmt, ap);
  if (name)
    mu_error ("%s:%lu: %s", name, (unsigned long) line,  buf);
  else
    mu_error ("%s", buf);
  free (buf);
}

void
ali_parse_error_loc (const char *name, size_t line, const char *fmt, ...)
{
  va_list ap;

  va_start (ap, fmt);
  va_ali_parse_error_loc (name, line, fmt, ap);
  va_end (ap);
}

void
ali_parse_error (const char *fmt, ...)
{
  va_list ap;

  va_start (ap, fmt);
  va_ali_parse_error_loc (ali_filename, ali_line_num, fmt, ap);
  va_end (ap);
}

int
ali_yyerror (char *s)
{
  ali_parse_error ("%s", s);
  return 0;
}
 
#ifdef FLEX_SCANNER
#define xinput() (ali_yyin ? getc(ali_yyin) : EOF)
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size)  do { \
        int i;                                  \
        for (i = 0; i < max_size; i++) {        \
                int ch = xinput();              \
                if (ch == EOF)                  \
                        break;                  \
                buf[i] = ch;                    \
        }                                       \
        result = i;                             \
} while (0) 
#define LEX_BUFFER_STATE YY_BUFFER_STATE
#define SET_BUFFER_STATE(s) do { \
        (s) = YY_CURRENT_BUFFER; \
        ali_yy_switch_to_buffer(ali_yy_create_buffer(ali_yyin,YY_BUF_SIZE)); \
} while (0)
#define RESTORE_BUFFER_STATE(s) do { \
        ali_yy_delete_buffer(YY_CURRENT_BUFFER); \
        ali_yy_switch_to_buffer(s); \
} while (0)

#else
/* AT&T Lex */
                                               
static void lex_set_buffer (FILE *fp);
static void lex_delete_buffer (LEX_BUFFER_STATE buf);
static int xinput (void); 
static int xunput (void);
        
#undef unput
#define unput(c) xunput(c)
#undef input
#define input() xinput()

#define LEX_BUF_SIZE 16384
#define LEX_PUTBACK_SIZE 32
                                               
typedef struct {
  FILE *ali_yyin;
  char *buffer;
  size_t bufsize;
  size_t level;
  char *ptr;
  char *putback;
  size_t pb_size;
  size_t pb_level;
} LEX_BUFFER_STATE;
LEX_BUFFER_STATE current_buffer;
 
#define SET_BUFFER_STATE(s) do { \
        (s) = current_buffer;    \
        lex_set_buffer(ali_yyin);    \
} while (0)
#define RESTORE_BUFFER_STATE(s) do { \
        lex_delete_buffer(current_buffer); \
        current_buffer = (s); \
        ali_yyin = current_buffer.ali_yyin;  \
} while (0)
                                    
void
lex_set_buffer (FILE *fp)
{
  char *buf;
  size_t size;
        
  for (size = LEX_BUF_SIZE; size > 1; size /= 2)
    if (buf = malloc (size))
      break;
  
  if (!buf)
    {
      ali_parse_error (_("not enough memory"));
      abort ();
    }

  current_buffer.ali_yyin = ali_yyin;
  current_buffer.buffer = buf;
  current_buffer.bufsize = size;
  current_buffer.level = 0;
  current_buffer.ptr = current_buffer.buffer;
  current_buffer.pb_size = current_buffer.pb_level = 0;
  current_buffer.putback = NULL;
}
                
void
lex_delete_buffer (LEX_BUFFER_STATE buf)
{
  free (buf.buffer);
  if (buf.putback)
    free (buf.putback);
}

int
xinput ()
{
  if (!ali_yyin)
    return EOF;
  
  if (current_buffer.pb_level) 
    return current_buffer.putback[--current_buffer.pb_level];

  if (current_buffer.level <= 0)
    {
      int n;

      if (feof (ali_yyin))
	return 0;
      n = fread (current_buffer.buffer, 1,
		 current_buffer.bufsize, ali_yyin);
      if (n <= 0)
	return 0;
      current_buffer.level = n;
      current_buffer.ptr = current_buffer.buffer;
    }
  current_buffer.level--;
  return *current_buffer.ptr++;
}

int
xunput (int c)
{
  if (current_buffer.pb_level == current_buffer.pb_size)
    {
      char *putback;
      current_buffer.pb_size += LEX_PUTBACK_SIZE;
      putback = mu_alloc (current_buffer.pb_size);
      memcpy (putback, current_buffer.putback,
	      current_buffer.pb_level);
      free (current_buffer.putback);
      current_buffer.putback = putback;
    }
  current_buffer.putback[current_buffer.pb_level++] = c;
  return c;
}
                
#endif                                         

struct buffer_ctx {
  struct buffer_ctx *prev;
  char *filename;
  int line;
  ino_t i_node;
  FILE *ali_yyin;
  int exec_p;
  LEX_BUFFER_STATE state;
};

static struct buffer_ctx *context_stack;
static int exec_p;

static struct buffer_ctx *
ctx_lookup (ino_t ino)
{
  struct buffer_ctx *ctx;

  for (ctx = context_stack; ctx; ctx = ctx->prev)
    if (ctx->i_node == ino)
      break;
  return ctx;
}
        
static int
push_source (const char *name, int fail)
{
  FILE *fp;
  struct buffer_ctx *ctx;
  struct stat st;
  char *filename;
  int ex = 0;
  
  filename = mh_expand_name (NULL, name, NAME_ANY);
  if (stat (filename, &st))
    {
      if (fail)
	ali_parse_error (_("can't stat `%s': %s"), filename, strerror (errno));
      free (filename);
      return 1;
    }
    
  if (ali_filename && st.st_ino == ali_source_inode)
    {
      ali_parse_error (_("recursive inclusion"));
      free (filename);
      return 1;
    }
  if ((ctx = ctx_lookup (st.st_ino)))
    {
      ali_parse_error (_("recursive inclusion"));
      if (ctx->prev)
	ali_parse_error_loc (ctx->prev->filename, ctx->prev->line,
                             _("`%s' already included here"),
                             filename);
      else
	ali_parse_error (_("`%s' already included at top level"),
			 filename);
      free (filename);
      return 1;
    }
                
  fp = fopen (filename, "r");
  if (!fp)
    {
      ali_parse_error (_("can't open `%s': %s"), filename, strerror (errno));
      free (filename);
      return 1;
    }
  if (access (filename, X_OK) == 0)
    {
      char sig[4];

      if (fread (sig, sizeof(sig), 1, fp) == 1 &&
	  (memcmp(sig, "#!/", 3) == 0 ||
	   memcmp(sig, "#! /", 4) == 0))
	{
	  ex = 1;
	  fclose (fp);
	  fp = popen (filename, "r");
	  if (!fp)
	    {
	      ali_parse_error (_("can't execute `%s': %s"),
			       filename, strerror (errno));
	      free (filename);
	      return 1;
	    }
	}
      else
	rewind (fp);
    }
  
  /* Push current context */
  if (ali_filename)
    {
      ctx = mu_alloc (sizeof (*ctx));
      ctx->filename = ali_filename;
      ctx->exec_p = exec_p;
      ctx->line = ali_line_num;
      ctx->i_node = ali_source_inode;
      ctx->ali_yyin = ali_yyin;
      ctx->prev = context_stack;
      context_stack = ctx;
      
      /* Switch to the new context */
      ali_yyin = fp;
      SET_BUFFER_STATE (ctx->state);
    }
  else
    {
#ifdef FLEX_SCANNER
      ali_yyrestart (fp);
#else           
      ali_yyin = fp;
      lex_set_buffer (ali_yyin);
#endif
    }
  ali_filename = filename;
  ali_line_num = 1;
  ali_source_inode = st.st_ino;
  exec_p = ex;
  return 0;
}

static int
pop_source ()
{
  struct buffer_ctx *ctx;

  if (ali_yyin)
    (exec_p ? pclose : fclose) (ali_yyin);
#ifndef FLEX_SCANNER
  lex_delete_buffer (current_buffer);
#endif
  if (ali_filename)
    free (ali_filename);
  ali_filename = NULL;
  if (!context_stack)
    {
      ali_yyin = NULL;
      return 1;
    }
  /* Restore previous context */
  ali_filename = context_stack->filename;
  ali_line_num = context_stack->line + 1; /* < line did not increment it */
  ali_source_inode = context_stack->i_node;
  exec_p = context_stack->exec_p;
  RESTORE_BUFFER_STATE (context_stack->state);
  ctx = context_stack->prev;
  free (context_stack);
  context_stack = ctx;
  return 0;
}

extern int ali_yyparse (void);

#define YY_NO_INPUT 1

#line 860 "mh_alias_lex.c"

#define INITIAL 0
#define VERBATIM 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int ali_yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int ali_yylex_destroy (void );

int ali_yyget_debug (void );

void ali_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE ali_yyget_extra (void );

void ali_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *ali_yyget_in (void );

void ali_yyset_in  (FILE * in_str  );

FILE *ali_yyget_out (void );

void ali_yyset_out  (FILE * out_str  );

ali_yy_size_t ali_yyget_leng (void );

char *ali_yyget_text (void );

int ali_yyget_lineno (void );

void ali_yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int ali_yywrap (void );
#else
extern int ali_yywrap (void );
#endif
#endif

#ifndef ali_yytext_ptr
static void ali_yy_flex_strncpy (char *,ali_yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int ali_yy_flex_strlen (ali_yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int ali_yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( ali_yytext, ali_yyleng, 1, ali_yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->ali_yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( ali_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( ali_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, ali_yyin))==0 && ferror(ali_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(ali_yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "ali_yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef ali_yyterminate
#define ali_yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) ali_yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int ali_yylex (void);

#define YY_DECL int ali_yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after ali_yytext and ali_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( ali_yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->ali_yy_at_bol = \
				(ali_yytext[ali_yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register ali_yy_state_type ali_yy_current_state;
	register char *ali_yy_cp, *ali_yy_bp;
	register int ali_yy_act;
    
#line 380 "mh_alias.l"

#line 1046 "mh_alias_lex.c"

	if ( !(ali_yy_init) )
		{
		(ali_yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (ali_yy_start) )
			(ali_yy_start) = 1;	/* first start state */

		if ( ! ali_yyin )
			ali_yyin = stdin;

		if ( ! ali_yyout )
			ali_yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			ali_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				ali_yy_create_buffer(ali_yyin,YY_BUF_SIZE );
		}

		ali_yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		ali_yy_cp = (ali_yy_c_buf_p);

		/* Support of ali_yytext. */
		*ali_yy_cp = (ali_yy_hold_char);

		/* ali_yy_bp points to the position in ali_yy_ch_buf of the start of
		 * the current run.
		 */
		ali_yy_bp = ali_yy_cp;

		ali_yy_current_state = (ali_yy_start);
		ali_yy_current_state += YY_AT_BOL();
ali_yy_match:
		do
			{
			register YY_CHAR ali_yy_c = ali_yy_ec[YY_SC_TO_UI(*ali_yy_cp)];
			if ( ali_yy_accept[ali_yy_current_state] )
				{
				(ali_yy_last_accepting_state) = ali_yy_current_state;
				(ali_yy_last_accepting_cpos) = ali_yy_cp;
				}
			while ( ali_yy_chk[ali_yy_base[ali_yy_current_state] + ali_yy_c] != ali_yy_current_state )
				{
				ali_yy_current_state = (int) ali_yy_def[ali_yy_current_state];
				if ( ali_yy_current_state >= 43 )
					ali_yy_c = ali_yy_meta[(unsigned int) ali_yy_c];
				}
			ali_yy_current_state = ali_yy_nxt[ali_yy_base[ali_yy_current_state] + (unsigned int) ali_yy_c];
			++ali_yy_cp;
			}
		while ( ali_yy_base[ali_yy_current_state] != 104 );

ali_yy_find_action:
		ali_yy_act = ali_yy_accept[ali_yy_current_state];
		if ( ali_yy_act == 0 )
			{ /* have to back up */
			ali_yy_cp = (ali_yy_last_accepting_cpos);
			ali_yy_current_state = (ali_yy_last_accepting_state);
			ali_yy_act = ali_yy_accept[ali_yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( ali_yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*ali_yy_cp = (ali_yy_hold_char);
			ali_yy_cp = (ali_yy_last_accepting_cpos);
			ali_yy_current_state = (ali_yy_last_accepting_state);
			goto ali_yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 381 "mh_alias.l"
{ ali_line_num++; }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 382 "mh_alias.l"
{ ali_line_num++; return '\n';}
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 383 "mh_alias.l"
ali_line_num++; 
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 384 "mh_alias.l"
{ char *p;
                   for (p = ali_yytext; p < ali_yytext + ali_yyleng; p++)
		     if (!mu_isspace (*p))
		       break;
		   ali_yylval.string = mu_strdup (p);
		   return STRING;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 390 "mh_alias.l"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 391 "mh_alias.l"
{ ali_yylval.string = mu_strdup (ali_yytext); return STRING;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 392 "mh_alias.l"
{
                 char *p;
                 for (p = ali_yytext; p < ali_yytext + ali_yyleng && mu_isblank(*p); p++)
		   ;
                 for (p++; p < ali_yytext + ali_yyleng; p++)
		   if (!mu_isspace (*p))
		     break;
                 push_source (p, 1); }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 400 "mh_alias.l"
return ali_yytext[0];
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 401 "mh_alias.l"
{
                    ali_yylval.string = mu_alloc (ali_yyleng + 1);
 		    memcpy(ali_yylval.string, ali_yytext, ali_yyleng);
		    ali_yylval.string[ali_yyleng] = 0;
		    return STRING;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 406 "mh_alias.l"
{ char *p;
                 mu_asprintf (&p,
			      _("Stray character %03o in alias file"), 
                              ali_yytext[0]);
                 ali_yyerror (p);
		 free (p); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 412 "mh_alias.l"
ECHO;
	YY_BREAK
#line 1209 "mh_alias_lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(VERBATIM):
	ali_yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int ali_yy_amount_of_matched_text = (int) (ali_yy_cp - (ali_yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*ali_yy_cp = (ali_yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->ali_yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed ali_yyin at a new source and called
			 * ali_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(ali_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->ali_yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->ali_yy_input_file = ali_yyin;
			YY_CURRENT_BUFFER_LVALUE->ali_yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for ali_yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since ali_yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (ali_yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[(ali_yy_n_chars)] )
			{ /* This was really a NUL. */
			ali_yy_state_type ali_yy_next_state;

			(ali_yy_c_buf_p) = (ali_yytext_ptr) + ali_yy_amount_of_matched_text;

			ali_yy_current_state = ali_yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * ali_yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			ali_yy_next_state = ali_yy_try_NUL_trans( ali_yy_current_state );

			ali_yy_bp = (ali_yytext_ptr) + YY_MORE_ADJ;

			if ( ali_yy_next_state )
				{
				/* Consume the NUL. */
				ali_yy_cp = ++(ali_yy_c_buf_p);
				ali_yy_current_state = ali_yy_next_state;
				goto ali_yy_match;
				}

			else
				{
				ali_yy_cp = (ali_yy_c_buf_p);
				goto ali_yy_find_action;
				}
			}

		else switch ( ali_yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(ali_yy_did_buffer_switch_on_eof) = 0;

				if ( ali_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * ali_yy_get_next_buffer() to have set up
					 * ali_yytext, we can now set up
					 * ali_yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(ali_yy_c_buf_p) = (ali_yytext_ptr) + YY_MORE_ADJ;

					ali_yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (ali_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(ali_yy_c_buf_p) =
					(ali_yytext_ptr) + ali_yy_amount_of_matched_text;

				ali_yy_current_state = ali_yy_get_previous_state(  );

				ali_yy_cp = (ali_yy_c_buf_p);
				ali_yy_bp = (ali_yytext_ptr) + YY_MORE_ADJ;
				goto ali_yy_match;

			case EOB_ACT_LAST_MATCH:
				(ali_yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[(ali_yy_n_chars)];

				ali_yy_current_state = ali_yy_get_previous_state(  );

				ali_yy_cp = (ali_yy_c_buf_p);
				ali_yy_bp = (ali_yytext_ptr) + YY_MORE_ADJ;
				goto ali_yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of ali_yylex */

/* ali_yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int ali_yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf;
	register char *source = (ali_yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (ali_yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[(ali_yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->ali_yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (ali_yy_c_buf_p) - (ali_yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((ali_yy_c_buf_p) - (ali_yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->ali_yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->ali_yy_n_chars = (ali_yy_n_chars) = 0;

	else
		{
			ali_yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->ali_yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int ali_yy_c_buf_p_offset =
				(int) ((ali_yy_c_buf_p) - b->ali_yy_ch_buf);

			if ( b->ali_yy_is_our_buffer )
				{
				ali_yy_size_t new_size = b->ali_yy_buf_size * 2;

				if ( new_size <= 0 )
					b->ali_yy_buf_size += b->ali_yy_buf_size / 8;
				else
					b->ali_yy_buf_size *= 2;

				b->ali_yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					ali_yyrealloc((void *) b->ali_yy_ch_buf,b->ali_yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->ali_yy_ch_buf = 0;

			if ( ! b->ali_yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(ali_yy_c_buf_p) = &b->ali_yy_ch_buf[ali_yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->ali_yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[number_to_move]),
			(ali_yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->ali_yy_n_chars = (ali_yy_n_chars);
		}

	if ( (ali_yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			ali_yyrestart(ali_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->ali_yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((ali_yy_size_t) ((ali_yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->ali_yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		ali_yy_size_t new_size = (ali_yy_n_chars) + number_to_move + ((ali_yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf = (char *) ali_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in ali_yy_get_next_buffer()" );
	}

	(ali_yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[(ali_yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[(ali_yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(ali_yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[0];

	return ret_val;
}

/* ali_yy_get_previous_state - get the state just before the EOB char was reached */

    static ali_yy_state_type ali_yy_get_previous_state (void)
{
	register ali_yy_state_type ali_yy_current_state;
	register char *ali_yy_cp;
    
	ali_yy_current_state = (ali_yy_start);
	ali_yy_current_state += YY_AT_BOL();

	for ( ali_yy_cp = (ali_yytext_ptr) + YY_MORE_ADJ; ali_yy_cp < (ali_yy_c_buf_p); ++ali_yy_cp )
		{
		register YY_CHAR ali_yy_c = (*ali_yy_cp ? ali_yy_ec[YY_SC_TO_UI(*ali_yy_cp)] : 1);
		if ( ali_yy_accept[ali_yy_current_state] )
			{
			(ali_yy_last_accepting_state) = ali_yy_current_state;
			(ali_yy_last_accepting_cpos) = ali_yy_cp;
			}
		while ( ali_yy_chk[ali_yy_base[ali_yy_current_state] + ali_yy_c] != ali_yy_current_state )
			{
			ali_yy_current_state = (int) ali_yy_def[ali_yy_current_state];
			if ( ali_yy_current_state >= 43 )
				ali_yy_c = ali_yy_meta[(unsigned int) ali_yy_c];
			}
		ali_yy_current_state = ali_yy_nxt[ali_yy_base[ali_yy_current_state] + (unsigned int) ali_yy_c];
		}

	return ali_yy_current_state;
}

/* ali_yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = ali_yy_try_NUL_trans( current_state );
 */
    static ali_yy_state_type ali_yy_try_NUL_trans  (ali_yy_state_type ali_yy_current_state )
{
	register int ali_yy_is_jam;
    	register char *ali_yy_cp = (ali_yy_c_buf_p);

	register YY_CHAR ali_yy_c = 1;
	if ( ali_yy_accept[ali_yy_current_state] )
		{
		(ali_yy_last_accepting_state) = ali_yy_current_state;
		(ali_yy_last_accepting_cpos) = ali_yy_cp;
		}
	while ( ali_yy_chk[ali_yy_base[ali_yy_current_state] + ali_yy_c] != ali_yy_current_state )
		{
		ali_yy_current_state = (int) ali_yy_def[ali_yy_current_state];
		if ( ali_yy_current_state >= 43 )
			ali_yy_c = ali_yy_meta[(unsigned int) ali_yy_c];
		}
	ali_yy_current_state = ali_yy_nxt[ali_yy_base[ali_yy_current_state] + (unsigned int) ali_yy_c];
	ali_yy_is_jam = (ali_yy_current_state == 42);

		return ali_yy_is_jam ? 0 : ali_yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int ali_yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(ali_yy_c_buf_p) = (ali_yy_hold_char);

	if ( *(ali_yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* ali_yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (ali_yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->ali_yy_ch_buf[(ali_yy_n_chars)] )
			/* This was really a NUL. */
			*(ali_yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			ali_yy_size_t offset = (ali_yy_c_buf_p) - (ali_yytext_ptr);
			++(ali_yy_c_buf_p);

			switch ( ali_yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because ali_yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					ali_yyrestart(ali_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( ali_yywrap( ) )
						return EOF;

					if ( ! (ali_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return ali_yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(ali_yy_c_buf_p) = (ali_yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (ali_yy_c_buf_p);	/* cast for 8-bit char's */
	*(ali_yy_c_buf_p) = '\0';	/* preserve ali_yytext */
	(ali_yy_hold_char) = *++(ali_yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->ali_yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void ali_yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        ali_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            ali_yy_create_buffer(ali_yyin,YY_BUF_SIZE );
	}

	ali_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	ali_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void ali_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		ali_yypop_buffer_state();
	 *		ali_yypush_buffer_state(new_buffer);
     */
	ali_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(ali_yy_c_buf_p) = (ali_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->ali_yy_buf_pos = (ali_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->ali_yy_n_chars = (ali_yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	ali_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (ali_yywrap()) processing, but the only time this flag
	 * is looked at is after ali_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(ali_yy_did_buffer_switch_on_eof) = 1;
}

static void ali_yy_load_buffer_state  (void)
{
    	(ali_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->ali_yy_n_chars;
	(ali_yytext_ptr) = (ali_yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->ali_yy_buf_pos;
	ali_yyin = YY_CURRENT_BUFFER_LVALUE->ali_yy_input_file;
	(ali_yy_hold_char) = *(ali_yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE ali_yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) ali_yyalloc(sizeof( struct ali_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in ali_yy_create_buffer()" );

	b->ali_yy_buf_size = size;

	/* ali_yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->ali_yy_ch_buf = (char *) ali_yyalloc(b->ali_yy_buf_size + 2  );
	if ( ! b->ali_yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in ali_yy_create_buffer()" );

	b->ali_yy_is_our_buffer = 1;

	ali_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with ali_yy_create_buffer()
 * 
 */
    void ali_yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->ali_yy_is_our_buffer )
		ali_yyfree((void *) b->ali_yy_ch_buf  );

	ali_yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a ali_yyrestart() or at EOF.
 */
    static void ali_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	ali_yy_flush_buffer(b );

	b->ali_yy_input_file = file;
	b->ali_yy_fill_buffer = 1;

    /* If b is the current buffer, then ali_yy_init_buffer was _probably_
     * called from ali_yyrestart() or through ali_yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->ali_yy_bs_lineno = 1;
        b->ali_yy_bs_column = 0;
    }

        b->ali_yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void ali_yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->ali_yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->ali_yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->ali_yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->ali_yy_buf_pos = &b->ali_yy_ch_buf[0];

	b->ali_yy_at_bol = 1;
	b->ali_yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		ali_yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void ali_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	ali_yyensure_buffer_stack();

	/* This block is copied from ali_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(ali_yy_c_buf_p) = (ali_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->ali_yy_buf_pos = (ali_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->ali_yy_n_chars = (ali_yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(ali_yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from ali_yy_switch_to_buffer. */
	ali_yy_load_buffer_state( );
	(ali_yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void ali_yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	ali_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((ali_yy_buffer_stack_top) > 0)
		--(ali_yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		ali_yy_load_buffer_state( );
		(ali_yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void ali_yyensure_buffer_stack (void)
{
	ali_yy_size_t num_to_alloc;
    
	if (!(ali_yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(ali_yy_buffer_stack) = (struct ali_yy_buffer_state**)ali_yyalloc
								(num_to_alloc * sizeof(struct ali_yy_buffer_state*)
								);
		if ( ! (ali_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in ali_yyensure_buffer_stack()" );
								  
		memset((ali_yy_buffer_stack), 0, num_to_alloc * sizeof(struct ali_yy_buffer_state*));
				
		(ali_yy_buffer_stack_max) = num_to_alloc;
		(ali_yy_buffer_stack_top) = 0;
		return;
	}

	if ((ali_yy_buffer_stack_top) >= ((ali_yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (ali_yy_buffer_stack_max) + grow_size;
		(ali_yy_buffer_stack) = (struct ali_yy_buffer_state**)ali_yyrealloc
								((ali_yy_buffer_stack),
								num_to_alloc * sizeof(struct ali_yy_buffer_state*)
								);
		if ( ! (ali_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in ali_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((ali_yy_buffer_stack) + (ali_yy_buffer_stack_max), 0, grow_size * sizeof(struct ali_yy_buffer_state*));
		(ali_yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE ali_yy_scan_buffer  (char * base, ali_yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) ali_yyalloc(sizeof( struct ali_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in ali_yy_scan_buffer()" );

	b->ali_yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->ali_yy_buf_pos = b->ali_yy_ch_buf = base;
	b->ali_yy_is_our_buffer = 0;
	b->ali_yy_input_file = 0;
	b->ali_yy_n_chars = b->ali_yy_buf_size;
	b->ali_yy_is_interactive = 0;
	b->ali_yy_at_bol = 1;
	b->ali_yy_fill_buffer = 0;
	b->ali_yy_buffer_status = YY_BUFFER_NEW;

	ali_yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to ali_yylex() will
 * scan from a @e copy of @a str.
 * @param ali_yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       ali_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE ali_yy_scan_string (ali_yyconst char * ali_yystr )
{
    
	return ali_yy_scan_bytes(ali_yystr,strlen(ali_yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to ali_yylex() will
 * scan from a @e copy of @a bytes.
 * @param ali_yybytes the byte buffer to scan
 * @param _ali_yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE ali_yy_scan_bytes  (ali_yyconst char * ali_yybytes, ali_yy_size_t  _ali_yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	ali_yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _ali_yybytes_len + 2;
	buf = (char *) ali_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in ali_yy_scan_bytes()" );

	for ( i = 0; i < _ali_yybytes_len; ++i )
		buf[i] = ali_yybytes[i];

	buf[_ali_yybytes_len] = buf[_ali_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = ali_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in ali_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->ali_yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void ali_yy_fatal_error (ali_yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine ali_yyless() so it works in section 3 code. */

#undef ali_yyless
#define ali_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up ali_yytext. */ \
        int ali_yyless_macro_arg = (n); \
        YY_LESS_LINENO(ali_yyless_macro_arg);\
		ali_yytext[ali_yyleng] = (ali_yy_hold_char); \
		(ali_yy_c_buf_p) = ali_yytext + ali_yyless_macro_arg; \
		(ali_yy_hold_char) = *(ali_yy_c_buf_p); \
		*(ali_yy_c_buf_p) = '\0'; \
		ali_yyleng = ali_yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int ali_yyget_lineno  (void)
{
        
    return ali_yylineno;
}

/** Get the input stream.
 * 
 */
FILE *ali_yyget_in  (void)
{
        return ali_yyin;
}

/** Get the output stream.
 * 
 */
FILE *ali_yyget_out  (void)
{
        return ali_yyout;
}

/** Get the length of the current token.
 * 
 */
ali_yy_size_t ali_yyget_leng  (void)
{
        return ali_yyleng;
}

/** Get the current token.
 * 
 */

char *ali_yyget_text  (void)
{
        return ali_yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void ali_yyset_lineno (int  line_number )
{
    
    ali_yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see ali_yy_switch_to_buffer
 */
void ali_yyset_in (FILE *  in_str )
{
        ali_yyin = in_str ;
}

void ali_yyset_out (FILE *  out_str )
{
        ali_yyout = out_str ;
}

int ali_yyget_debug  (void)
{
        return ali_yy_flex_debug;
}

void ali_yyset_debug (int  bdebug )
{
        ali_yy_flex_debug = bdebug ;
}

static int ali_yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from ali_yylex_destroy(), so don't allocate here.
     */

    (ali_yy_buffer_stack) = 0;
    (ali_yy_buffer_stack_top) = 0;
    (ali_yy_buffer_stack_max) = 0;
    (ali_yy_c_buf_p) = (char *) 0;
    (ali_yy_init) = 0;
    (ali_yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    ali_yyin = stdin;
    ali_yyout = stdout;
#else
    ali_yyin = (FILE *) 0;
    ali_yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * ali_yylex_init()
     */
    return 0;
}

/* ali_yylex_destroy is for both reentrant and non-reentrant scanners. */
int ali_yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		ali_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		ali_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	ali_yyfree((ali_yy_buffer_stack) );
	(ali_yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * ali_yylex() is called, initialization will occur. */
    ali_yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef ali_yytext_ptr
static void ali_yy_flex_strncpy (char* s1, ali_yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int ali_yy_flex_strlen (ali_yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *ali_yyalloc (ali_yy_size_t  size )
{
	return (void *) malloc( size );
}

void *ali_yyrealloc  (void * ptr, ali_yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void ali_yyfree (void * ptr )
{
	free( (char *) ptr );	/* see ali_yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "ali_yytables"

#line 412 "mh_alias.l"


		 
int
ali_yywrap ()
{
  return pop_source();
}

/* Parses the named alias file */
int
mh_alias_read (char const *name, int fail)
{
  extern int ali_yydebug;
  char *p = getenv("ALI_YYDEBUG");

  if (p && *p > '0' && *p < '9')
    ali_yydebug = 1;
  
  if (push_source (name, fail))
    return 1;
  if (ali_yydebug)
    fprintf (stderr, "Starting parse of %s\n", name);
  return ali_yyparse ();
}

void
ali_verbatim (int enable)
{
  if (enable)
    BEGIN(VERBATIM);
  else
    BEGIN(INITIAL);
}
  

