/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Computer Science Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/


#include "mavlib_cvcomp.h"

/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	BindableNode.h
*
******************************************************************/

#ifndef _BINDABLENODE_H_
#define _BINDABLENODE_H_

#include "vrmlfields.h"
#include "Node.h"

class BindableNode : public Node {

public:

	BindableNode() {
		// set_bind
		SFBool *setBind = new SFBool(true);
		addEventIn(setBindFieldString, setBind);

		// cybleInterval exposed field
		SFTime *bindTime = new SFTime(1.0);
		addEventOut(bindTimeFieldString, bindTime);

		// isBind
		SFBool *isBound = new SFBool(true);
		addEventOut(isBoundFieldString, isBound);
	}

	virtual ~BindableNode() {
	}

	////////////////////////////////////////////////
	//	bind
	////////////////////////////////////////////////

	void setBind(bool value) {
		SFBool *bind = (SFBool *)getEventIn(setBindFieldString);
		bind->setValue(value);
	}
	bool  getBind() {
		SFBool *bind = (SFBool *)getEventIn(setBindFieldString);
		return bind->getValue();
	}
	Field *getBindField() {
		return getEventIn(setBindFieldString);
	}

	////////////////////////////////////////////////
	//	bindTime
	////////////////////////////////////////////////
	
	void setBindTime(double value) {
		SFTime *cycle = (SFTime *)getEventOut(bindTimeFieldString);
		cycle->setValue(value);
	}
	double getBindTime() {
		SFTime *cycle = (SFTime *)getEventOut(bindTimeFieldString);
		return cycle->getValue();
	}
	Field *getBindTimeField() {
		return getEventOut(bindTimeFieldString);
	}

	////////////////////////////////////////////////
	//	isBound
	////////////////////////////////////////////////

	void setIsBound(bool  value) {
		SFBool *isBound = (SFBool *)getEventOut(isBoundFieldString);
		isBound->setValue(value);
	}
	bool  getIsBound() {
		SFBool *isBound = (SFBool *)getEventOut(isBoundFieldString);
		return isBound->getValue();
	}
	bool  isBound() {
		return getIsBound();
	}
	Field *getIsBoundField() {
		return getEventOut(isBoundFieldString);
	}
};

#endif

