#ifndef _PROTO_H_
#define _PROTO_H_
/* This file is automatically generated with "make proto". DO NOT EDIT */


/*The following definitions come from  client/client.c  */

void do_list(const char *mask,uint16 attribute,void (*fn)(file_info *),BOOL rec, BOOL dirs);
struct cli_state *do_connect(char *server, char *share);

/*The following definitions come from  client/clitar.c  */

void cmd_block(void);
void cmd_tarmode(void);
void cmd_setmode(void);
void cmd_tar(void);
int process_tar(void);
int tar_parseargs(int argc, char *argv[], char *Optarg, int Optind);

/*The following definitions come from  lib/access.c  */

BOOL allow_access(char *deny_list,char *allow_list,
		  char *cname,char *caddr);
BOOL check_access(int sock, char *allow_list, char *deny_list);

/*The following definitions come from  lib/bitmap.c  */

struct bitmap *bitmap_allocate(int n);
BOOL bitmap_set(struct bitmap *bm, unsigned i);
BOOL bitmap_clear(struct bitmap *bm, unsigned i);
BOOL bitmap_query(struct bitmap *bm, unsigned i);
int bitmap_find(struct bitmap *bm, unsigned ofs);

/*The following definitions come from  lib/charcnv.c  */

char *unix2dos_format(char *str,BOOL overwrite);
char *dos2unix_format(char *str, BOOL overwrite);
void interpret_character_set(char *str);

/*The following definitions come from  lib/charset.c  */

void codepage_initialise(int client_codepage);
void add_char_string(char *s);

/*The following definitions come from  lib/crc32.c  */

uint32 crc32_calc_buffer( char *buffer, uint32 count);

/*The following definitions come from  lib/debug.c  */

void sig_usr2( int sig );
void sig_usr1( int sig );
void setup_logging( char *pname, BOOL interactive );
void reopen_logs( void );
void force_check_log_size( void );
void dbgflush( void );
BOOL dbghdr( int level, char *file, char *func, int line );

/*The following definitions come from  lib/doscalls.c  */

int dos_unlink(char *fname);
int dos_open(char *fname,int flags,mode_t mode);
DIR *dos_opendir(char *dname);
char *dos_readdirname(DIR *p);
int dos_chown(char *fname, uid_t uid, gid_t gid);
int dos_stat(char *fname,SMB_STRUCT_STAT *sbuf);
int dos_lstat(char *fname,SMB_STRUCT_STAT *sbuf);
int dos_mkdir(char *dname,mode_t mode);
int dos_rmdir(char *dname);
int dos_chdir(char *dname);
int dos_utime(char *fname,struct utimbuf *times);
int dos_rename(char *from, char *to);
int dos_chmod(char *fname,mode_t mode);
char *dos_getwd(char *unix_path);
BOOL dos_file_exist(char *fname,SMB_STRUCT_STAT *sbuf);
BOOL dos_directory_exist(char *dname,SMB_STRUCT_STAT *st);
time_t dos_file_modtime(char *fname);
SMB_OFF_T dos_file_size(char *file_name);
int dos_ChDir(char *path);
char *dos_GetWd(char *path);

/*The following definitions come from  lib/fault.c  */

void fault_setup(void (*fn)(void *));

/*The following definitions come from  lib/genrand.c  */

void generate_random_buffer( unsigned char *out, int len, BOOL re_seed);

/*The following definitions come from  lib/getsmbpass.c  */

char *getsmbpass(char *prompt)    ;

/*The following definitions come from  lib/interface.c  */

void load_interfaces(void);
void iface_set_default(char *ip,char *bcast,char *nmask);
BOOL ismyip(struct in_addr ip);
BOOL is_local_net(struct in_addr from);
int iface_count(void);
BOOL we_are_multihomed(void);
struct interface *get_interface(int n);
struct in_addr *iface_n_ip(int n);
unsigned iface_hash(void);
struct in_addr *iface_bcast(struct in_addr ip);
struct in_addr *iface_ip(struct in_addr ip);

/*The following definitions come from  lib/kanji.c  */

void interpret_coding_system(char *str);
BOOL is_multibyte_codepage(void);
void initialize_multibyte_vectors( int client_codepage);

/*The following definitions come from  lib/md4.c  */

void mdfour(unsigned char *out, unsigned char *in, int n);

/*The following definitions come from  lib/netmask.c  */

int get_netmask(struct in_addr *ipaddr, struct in_addr *nmask);

/*The following definitions come from  lib/pidfile.c  */

pid_t pidfile_pid(char *name);
void pidfile_create(char *name);

/*The following definitions come from  lib/replace.c  */

char *rep_inet_ntoa(struct in_addr ip);

/*The following definitions come from  lib/signal.c  */

void BlockSignals(BOOL block,int signum);
void CatchSignal(int signum,void (*handler)(int ));
void CatchChild(void);
void CatchChildLeaveStatus(void);

/*The following definitions come from  lib/slprintf.c  */

int vslprintf(char *str, int n, char *format, va_list ap);

/*The following definitions come from  lib/smbrun.c  */

int smbrun(char *cmd,char *outfile,BOOL shared);

/*The following definitions come from  lib/snprintf.c  */


/*The following definitions come from  lib/system.c  */

int sys_select(int maxfd, fd_set *fds,struct timeval *tval);
int sys_usleep(long usecs);
int sys_stat(const char *fname,SMB_STRUCT_STAT *sbuf);
int sys_fstat(int fd,SMB_STRUCT_STAT *sbuf);
int sys_lstat(const char *fname,SMB_STRUCT_STAT *sbuf);
int sys_ftruncate(int fd, SMB_OFF_T offset);
SMB_OFF_T sys_lseek(int fd, SMB_OFF_T offset, int whence);
int sys_fseek(FILE *fp, SMB_OFF_T offset, int whence);
SMB_OFF_T sys_ftell(FILE *fp);
int sys_creat(const char *path, mode_t mode);
int sys_open(const char *path, int oflag, mode_t mode);
FILE *sys_fopen(const char *path, const char *type);
void *sys_mmap(void *addr, size_t len, int prot, int flags, int fd, SMB_OFF_T offset);
SMB_STRUCT_DIRENT *sys_readdir(DIR *dirp);
int sys_waitpid(pid_t pid,int *status,int options);
char *sys_getwd(char *s);
int sys_chown(const char *fname,uid_t uid,gid_t gid);
int sys_chroot(const char *dname);
struct hostent *sys_gethostbyname(const char *name);
BOOL set_process_capability( uint32 cap_flag, BOOL enable );
BOOL set_inherited_process_capability( uint32 cap_flag, BOOL enable );
long sys_random(void);
void sys_srandom(unsigned int seed);
int sys_getgroups(int setlen, gid_t *gidset);
int sys_setgroups(int setlen, gid_t *gidset);

/*The following definitions come from  lib/time.c  */

void GetTimeOfDay(struct timeval *tval);
void TimeInit(void);
int TimeDiff(time_t t);
struct tm *LocalTime(time_t *t);
time_t nt_time_to_unix(NTTIME *nt);
time_t interpret_long_date(char *p);
void unix_to_nt_time(NTTIME *nt, time_t t);
void put_long_date(char *p,time_t t);
BOOL null_mtime(time_t mtime);
void put_dos_date(char *buf,int offset,time_t unixdate);
void put_dos_date2(char *buf,int offset,time_t unixdate);
void put_dos_date3(char *buf,int offset,time_t unixdate);
time_t make_unix_date(void *date_ptr);
time_t make_unix_date2(void *date_ptr);
time_t make_unix_date3(void *date_ptr);
char *http_timestring(time_t t);
char *timestring(void );
time_t get_create_time(SMB_STRUCT_STAT *st,BOOL fake_dirs);

/*The following definitions come from  lib/ufc.c  */

char *ufc_crypt(char *key,char *salt);

/*The following definitions come from  lib/username.c  */

char *get_home_dir(char *user);
BOOL map_username(char *user);
struct passwd *Get_Pwnam(char *user,BOOL allow_change);
BOOL user_in_list(char *user,char *list);

/*The following definitions come from  lib/util.c  */

char *tmpdir(void);
BOOL in_group(gid_t group, gid_t current_gid, int ngroups, gid_t *groups);
char *Atoic(char *p, int *n, char *c);
char *get_numlist(char *p, uint32 **num, int *count);
void putip(void *dest,void *src);
char *dns_to_netbios_name(char *dns_name);
int name_mangle( char *In, char *Out, char name_type );
BOOL file_exist(char *fname,SMB_STRUCT_STAT *sbuf);
time_t file_modtime(char *fname);
BOOL directory_exist(char *dname,SMB_STRUCT_STAT *st);
SMB_OFF_T file_size(char *file_name);
char *attrib_string(uint16 mode);
void unix_format(char *fname);
void dos_format(char *fname);
void show_msg(char *buf);
int smb_len(char *buf);
void _smb_setlen(char *buf,int len);
void smb_setlen(char *buf,int len);
int set_message(char *buf,int num_words,int num_bytes,BOOL zero);
int smb_buflen(char *buf);
char *smb_buf(char *buf);
int smb_offset(char *p,char *buf);
void dos_clean_name(char *s);
void unix_clean_name(char *s);
BOOL reduce_name(char *s,char *dir,BOOL widelinks);
void expand_mask(char *Mask,BOOL doext);
void make_dir_struct(char *buf,char *mask,char *fname,SMB_OFF_T size,int mode,time_t date);
void close_low_fds(void);
int set_blocking(int fd, BOOL set);
int TvalDiff(struct timeval *tvalold,struct timeval *tvalnew);
SMB_OFF_T transfer_file(int infd,int outfd,SMB_OFF_T n,char *header,int headlen,int align);
int name_extract(char *buf,int ofs,char *name);
int name_len(char *s1);
void msleep(int t);
BOOL do_match(char *str, char *regexp, int case_sig);
BOOL mask_match(char *str, char *regexp, int case_sig,BOOL trans2);
void become_daemon(void);
BOOL yesno(char *p);
int set_filelen(int fd, SMB_OFF_T len);
void *Realloc(void *p,size_t size);
BOOL get_myname(char *my_name,struct in_addr *ip);
BOOL ip_equal(struct in_addr ip1,struct in_addr ip2);
int interpret_protocol(char *str,int def);
uint32 interpret_addr(char *str);
struct in_addr *interpret_addr2(char *str);
BOOL zero_ip(struct in_addr ip);
BOOL matchname(char *remotehost,struct in_addr  addr);
void standard_sub_basic(char *str);
void standard_sub(connection_struct *conn,char *str);
BOOL same_net(struct in_addr ip1,struct in_addr ip2,struct in_addr mask);
struct hostent *Get_Hostbyname(const char *name);
BOOL process_exists(int pid);
char *uidtoname(uid_t uid);
char *gidtoname(gid_t gid);
uid_t nametouid(const char *name);
void smb_panic(char *why);
char *readdirname(DIR *p);
BOOL is_in_path(char *name, name_compare_entry *namelist);
void set_namearray(name_compare_entry **ppname_array, char *namelist);
void free_namearray(name_compare_entry *name_array);
BOOL fcntl_lock(int fd, int op, SMB_OFF_T offset, SMB_OFF_T count, int type);
BOOL is_myname(char *s);
void set_remote_arch(enum remote_arch_types type);
enum remote_arch_types get_remote_arch(void);
char *align2(char *q, char *base);
void out_ascii(FILE *f, unsigned char *buf,int len);
void out_data(FILE *f,char *buf1,int len, int per_line);
void print_asc(int level, unsigned char *buf,int len);
void dump_data(int level,char *buf1,int len);
char *tab_depth(int depth);
int str_checksum(const char *s);
void zero_free(void *p, size_t size);
int set_maxfiles(int requested_max);
void reg_get_subkey(char *full_keyname, char *key_name, char *subkey_name);
BOOL reg_split_key(char *full_keyname, uint32 *reg_type, char *key_name);

/*The following definitions come from  lib/util_file.c  */

BOOL do_file_lock(int fd, int waitsecs, int type);
BOOL file_lock(int fd, int type, int secs, int *plock_depth);
BOOL file_unlock(int fd, int *plock_depth);
void *startfilepwent(char *pfile, char *s_readbuf, int bufsize,
				int *file_lock_depth, BOOL update);
void endfilepwent(void *vp, int *file_lock_depth);
SMB_BIG_UINT getfilepwpos(void *vp);
BOOL setfilepwpos(void *vp, SMB_BIG_UINT tok);
int getfileline(void *vp, char *linebuf, int linebuf_size);
char *fgets_slash(char *s2,int maxlen,FILE *f);

/*The following definitions come from  lib/util_sec.c  */

int trapdoor_set_effective_uid(uid_t uid);
int trapdoor_set_real_uid(uid_t uid);
int trapdoor_set_effective_gid(gid_t gid);
void gain_root_privilege(void);
void gain_root_group_privilege(void);
int set_effective_uid(uid_t uid);
int set_effective_gid(gid_t gid);
int set_real_uid(uid_t uid);
BOOL become_user_permanently(uid_t uid, gid_t gid);

/*The following definitions come from  lib/util_sid.c  */

void generate_wellknown_sids(void);
BOOL map_domain_sid_to_name(DOM_SID *sid, char *nt_domain);
BOOL lookup_known_rid(DOM_SID *sid, uint32 rid, char *name, uint8 *psid_name_use);
BOOL map_domain_name_to_sid(DOM_SID *sid, char *nt_domain);
void split_domain_name(const char *fullname, char *domain, char *name);
char *sid_to_string(pstring sidstr_out, DOM_SID *sid);
BOOL string_to_sid(DOM_SID *sidout, char *sidstr);
BOOL sid_append_rid(DOM_SID *sid, uint32 rid);
BOOL sid_split_rid(DOM_SID *sid, uint32 *rid);
void sid_copy(DOM_SID *dst, DOM_SID *src);
DOM_SID *sid_dup(DOM_SID *src);
BOOL sid_linearize(char *outbuf, size_t len, DOM_SID *sid);
BOOL sid_equal(DOM_SID *sid1, DOM_SID *sid2);
size_t sid_size(DOM_SID *sid);

/*The following definitions come from  lib/util_sock.c  */

BOOL is_a_socket(int fd);
void set_socket_options(int fd, char *options);
void close_sockets(void );
ssize_t write_socket(int fd,char *buf,size_t len);
ssize_t read_udp_socket(int fd,char *buf,size_t len);
ssize_t read_with_timeout(int fd,char *buf,size_t mincnt,size_t maxcnt,unsigned int time_out);
BOOL send_keepalive(int client);
ssize_t read_data(int fd,char *buffer,size_t N);
ssize_t write_data(int fd,char *buffer,size_t N);
ssize_t read_smb_length(int fd,char *inbuf,unsigned int timeout);
BOOL receive_smb(int fd,char *buffer, unsigned int timeout);
BOOL client_receive_smb(int fd,char *buffer, unsigned int timeout);
BOOL send_null_session_msg(int fd);
BOOL send_smb(int fd,char *buffer);
BOOL send_one_packet(char *buf,int len,struct in_addr ip,int port,int type);
int open_socket_in(int type, int port, int dlevel,uint32 socket_addr, BOOL rebind);
int open_socket_out(int type, struct in_addr *addr, int port ,int timeout);
void reset_globals_after_fork(void);
char *client_name(int fd);
char *client_addr(int fd);

/*The following definitions come from  lib/util_str.c  */

void set_first_token(char *ptr);
BOOL next_token(char **ptr,char *buff,char *sep, size_t bufsize);
char **toktocliplist(int *ctok, char *sep);
int StrCaseCmp(const char *s, const char *t);
int StrnCaseCmp(const char *s, const char *t, size_t n);
BOOL strequal(const char *s1, const char *s2);
BOOL strnequal(const char *s1,const char *s2,size_t n);
BOOL strcsequal(const char *s1,const char *s2);
void strlower(char *s);
void strupper(char *s);
void strnorm(char *s);
BOOL strisnormal(char *s);
void string_replace(char *s,char oldc,char newc);
char *skip_string(char *buf,size_t n);
size_t str_charnum(const char *s);
BOOL trim_string(char *s,const char *front,const char *back);
BOOL strhasupper(const char *s);
BOOL strhaslower(const char *s);
size_t count_chars(const char *s,char c);
char *safe_strcpy(char *dest,const char *src, size_t maxlength);
char *safe_strcat(char *dest, const char *src, size_t maxlength);
char *StrCpy(char *dest,const char *src);
char *StrnCpy(char *dest,const char *src,size_t n);
char *strncpyn(char *dest, const char *src,size_t n, char c);
size_t strhex_to_str(char *p, size_t len, const char *strhex);
BOOL in_list(char *s,char *list,BOOL casesensitive);
BOOL string_init(char **dest,const char *src);
void string_free(char **s);
BOOL string_set(char **dest,const char *src);
void string_sub(char *s,const char *pattern,const char *insert);
void all_string_sub(char *s,const char *pattern,const char *insert);
void split_at_last_component(char *path, char *front, char sep, char *back);

/*The following definitions come from  lib/util_unistr.c  */

int PutUniCode(char *dst,char *src);
char *skip_unicode_string(char *buf,int n);
char *unistrn2(uint16 *src, int len);
char *unistr2(uint16 *src);
char *unistr2_to_str(UNISTR2 *str);
uint32 buffer2_to_uint32(BUFFER2 *str);
char *buffer2_to_str(BUFFER2 *str);
char *buffer2_to_multistr(BUFFER2 *str);
int struni2(char *dst, const char *src);
char *unistr(char *buf);
int unistrcpy(char *dst, char *src);

/*The following definitions come from  libsmb/clientgen.c  */

int cli_set_port(struct cli_state *cli, int port);
char *cli_errstr(struct cli_state *cli);
BOOL cli_api_pipe(struct cli_state *cli, char *pipe_name, int pipe_name_len,
                  uint16 *setup, uint32 setup_count, uint32 max_setup_count,
                  char *params, uint32 param_count, uint32 max_param_count,
                  char *data, uint32 data_count, uint32 max_data_count,
                  char **rparam, uint32 *rparam_count,
                  char **rdata, uint32 *rdata_count);
BOOL cli_api(struct cli_state *cli,
	     char *param, int prcnt, int mprcnt,
	     char *data, int drcnt, int mdrcnt,
	     char **rparam, int *rprcnt,
	     char **rdata, int *rdrcnt);
BOOL cli_NetWkstaUserLogon(struct cli_state *cli,char *user, char *workstation);
int cli_RNetShareEnum(struct cli_state *cli, void (*fn)(const char *, uint32, const char *, void *), void *state);
BOOL cli_NetServerEnum(struct cli_state *cli, char *workgroup, uint32 stype,
		       void (*fn)(const char *, uint32, const char *, void *),
		       void *state);
BOOL cli_session_setup(struct cli_state *cli, 
		       char *user, 
		       char *pass, int passlen,
		       char *ntpass, int ntpasslen,
		       char *workgroup);
BOOL cli_ulogoff(struct cli_state *cli);
BOOL cli_send_tconX(struct cli_state *cli, 
		    char *share, char *dev, char *pass, int passlen);
BOOL cli_tdis(struct cli_state *cli);
BOOL cli_rename(struct cli_state *cli, char *fname_src, char *fname_dst);
BOOL cli_unlink(struct cli_state *cli, char *fname);
BOOL cli_mkdir(struct cli_state *cli, char *dname);
BOOL cli_rmdir(struct cli_state *cli, char *dname);
int cli_nt_create(struct cli_state *cli, char *fname);
int cli_open(struct cli_state *cli, char *fname, int flags, int share_mode);
BOOL cli_close(struct cli_state *cli, int fnum);
BOOL cli_lock(struct cli_state *cli, int fnum, uint32 offset, uint32 len, int timeout);
BOOL cli_unlock(struct cli_state *cli, int fnum, uint32 offset, uint32 len, int timeout);
size_t cli_read(struct cli_state *cli, int fnum, char *buf, off_t offset, size_t size);
ssize_t cli_write(struct cli_state *cli,
		  int fnum, uint16 write_mode,
		  char *buf, off_t offset, size_t size);
ssize_t cli_smbwrite(struct cli_state *cli,
		     int fnum, char *buf, off_t offset, size_t size);
BOOL cli_getattrE(struct cli_state *cli, int fd, 
		  uint16 *attr, size_t *size, 
		  time_t *c_time, time_t *a_time, time_t *m_time);
BOOL cli_getatr(struct cli_state *cli, char *fname, 
		uint16 *attr, size_t *size, time_t *t);
BOOL cli_setatr(struct cli_state *cli, char *fname, uint16 attr, time_t t);
BOOL cli_qpathinfo(struct cli_state *cli, const char *fname, 
		   time_t *c_time, time_t *a_time, time_t *m_time, 
		   size_t *size, uint16 *mode);
BOOL cli_qpathinfo2(struct cli_state *cli, const char *fname, 
		    time_t *c_time, time_t *a_time, time_t *m_time, 
		    time_t *w_time, size_t *size, uint16 *mode,
		    SMB_INO_T *ino);
BOOL cli_qfileinfo(struct cli_state *cli, int fnum, 
		   uint16 *mode, size_t *size,
		   time_t *c_time, time_t *a_time, time_t *m_time, 
		   time_t *w_time, SMB_INO_T *ino);
int cli_list(struct cli_state *cli,const char *Mask,uint16 attribute, 
	     void (*fn)(file_info *, const char *, void *), void *state);
BOOL cli_oem_change_password(struct cli_state *cli, const char *user, const char *new_password,
                             const char *old_password);
BOOL cli_negprot(struct cli_state *cli);
BOOL cli_session_request(struct cli_state *cli,
			 struct nmb_name *calling, struct nmb_name *called);
BOOL cli_connect(struct cli_state *cli, const char *host, struct in_addr *ip);
struct cli_state *cli_initialise(struct cli_state *cli);
void cli_shutdown(struct cli_state *cli);
int cli_error(struct cli_state *cli, uint8 *eclass, uint32 *num, uint32 *nt_rpc_error);
void cli_sockopt(struct cli_state *cli, char *options);
uint16 cli_setpid(struct cli_state *cli, uint16 pid);
BOOL cli_reestablish_connection(struct cli_state *cli);
BOOL cli_establish_connection(struct cli_state *cli, 
				char *dest_host, struct in_addr *dest_ip,
				struct nmb_name *calling, struct nmb_name *called,
				char *service, char *service_type,
				BOOL do_shutdown, BOOL do_tcon);
int cli_printjob_del(struct cli_state *cli, int job);
int cli_print_queue(struct cli_state *cli, 
		    void (*fn)(struct print_job_info *));
BOOL cli_chkpath(struct cli_state *cli, char *path);
BOOL cli_message_start(struct cli_state *cli, char *host, char *username, 
			      int *grp);
BOOL cli_message_text(struct cli_state *cli, char *msg, int len, int grp);
BOOL cli_message_end(struct cli_state *cli, int grp);
BOOL cli_dskattr(struct cli_state *cli, int *bsize, int *total, int *avail);

/*The following definitions come from  libsmb/credentials.c  */

char *credstr(uchar *cred);
void cred_session_key(DOM_CHAL *clnt_chal, DOM_CHAL *srv_chal, char *pass, 
		      uchar session_key[8]);
void cred_create(uchar session_key[8], DOM_CHAL *stor_cred, UTIME timestamp, 
		 DOM_CHAL *cred);
int cred_assert(DOM_CHAL *cred, uchar session_key[8], DOM_CHAL *stored_cred,
		UTIME timestamp);
BOOL clnt_deal_with_creds(uchar sess_key[8],
			  DOM_CRED *sto_clnt_cred, DOM_CRED *rcv_srv_cred);
BOOL deal_with_creds(uchar sess_key[8],
		     DOM_CRED *sto_clnt_cred, 
		     DOM_CRED *rcv_clnt_cred, DOM_CRED *rtn_srv_cred);

/*The following definitions come from  libsmb/namequery.c  */

BOOL name_status(int fd,char *name,int name_type,BOOL recurse,
		 struct in_addr to_ip,char *master,char *rname,
		 void (*fn)(struct packet_struct *));
struct in_addr *name_query(int fd,const char *name,int name_type, BOOL bcast,BOOL recurse,
         struct in_addr to_ip, int *count, void (*fn)(struct packet_struct *));
FILE *startlmhosts(char *fname);
BOOL getlmhostsent( FILE *fp, pstring name, int *name_type, struct in_addr *ipaddr);
void endlmhosts(FILE *fp);
BOOL resolve_name(const char *name, struct in_addr *return_ip, int name_type);
BOOL find_master_ip(char *group, struct in_addr *master_ip);

/*The following definitions come from  libsmb/nmblib.c  */

void debug_nmb_packet(struct packet_struct *p);
char *nmb_namestr(struct nmb_name *n);
struct packet_struct *copy_packet(struct packet_struct *packet);
void free_packet(struct packet_struct *packet);
struct packet_struct *read_packet(int fd,enum packet_type packet_type);
void make_nmb_name( struct nmb_name *n, const char *name, int type);
BOOL nmb_name_equal(struct nmb_name *n1, struct nmb_name *n2);
BOOL send_packet(struct packet_struct *p);
struct packet_struct *receive_packet(int fd,enum packet_type type,int t);
void sort_query_replies(char *data, int n, struct in_addr ip);

/*The following definitions come from  libsmb/nterr.c  */

const char *get_nt_error_msg(uint32 nt_code);

/*The following definitions come from  libsmb/passchange.c  */

BOOL remote_password_change(const char *remote_machine, const char *user_name, 
			    const char *old_passwd, const char *new_passwd,
			    char *err_str, size_t err_str_len);

/*The following definitions come from  libsmb/pwd_cache.c  */

void pwd_init(struct pwd_info *pwd);
void pwd_obfuscate_key(struct pwd_info *pwd, uint32 int_key, char *str_key);
void pwd_read(struct pwd_info *pwd, char *passwd_report, BOOL do_encrypt);
void pwd_set_nullpwd(struct pwd_info *pwd);
void pwd_set_cleartext(struct pwd_info *pwd, char *clr);
void pwd_get_cleartext(struct pwd_info *pwd, char *clr);
void pwd_set_lm_nt_16(struct pwd_info *pwd, uchar lm_pwd[16], uchar nt_pwd[16]);
void pwd_get_lm_nt_16(struct pwd_info *pwd, uchar lm_pwd[16], uchar nt_pwd[16]);
void pwd_make_lm_nt_16(struct pwd_info *pwd, char *clr);
void pwd_make_lm_nt_owf(struct pwd_info *pwd, uchar cryptkey[8]);
void pwd_get_lm_nt_owf(struct pwd_info *pwd, uchar lm_owf[24], uchar nt_owf[24]);

/*The following definitions come from  libsmb/smbdes.c  */

void E_P16(unsigned char *p14,unsigned char *p16);
void E_P24(unsigned char *p21, unsigned char *c8, unsigned char *p24);
void D_P16(unsigned char *p14, unsigned char *in, unsigned char *out);
void E_old_pw_hash( unsigned char *p14, unsigned char *in, unsigned char *out);
void cred_hash1(unsigned char *out,unsigned char *in,unsigned char *key);
void cred_hash2(unsigned char *out,unsigned char *in,unsigned char *key);
void cred_hash3(unsigned char *out,unsigned char *in,unsigned char *key, int forw);
void SamOEMhash( unsigned char *data, unsigned char *key, int val);

/*The following definitions come from  libsmb/smbencrypt.c  */

void SMBencrypt(uchar *passwd, uchar *c8, uchar *p24);
void E_md4hash(uchar *passwd, uchar *p16);
void nt_lm_owf_gen(char *pwd, uchar nt_p16[16], uchar p16[16]);
void SMBOWFencrypt(uchar passwd[16], uchar *c8, uchar p24[24]);
void NTLMSSPOWFencrypt(uchar passwd[8], uchar *ntlmchalresp, uchar p24[24]);
void SMBNTencrypt(uchar *passwd, uchar *c8, uchar *p24);
BOOL make_oem_passwd_hash(char data[516], const char *passwd, uchar old_pw_hash[16], BOOL unicode);

/*The following definitions come from  libsmb/smberr.c  */

char *smb_errstr(char *inbuf);

/*The following definitions come from  locking/locking.c  */

BOOL is_locked(files_struct *fsp,connection_struct *conn,
	       SMB_OFF_T count,SMB_OFF_T offset, int lock_type);
BOOL do_lock(files_struct *fsp,connection_struct *conn,
             SMB_OFF_T count,SMB_OFF_T offset,int lock_type,
             int *eclass,uint32 *ecode);
BOOL do_unlock(files_struct *fsp,connection_struct *conn,
               SMB_OFF_T count,SMB_OFF_T offset,int *eclass,uint32 *ecode);
BOOL locking_init(int read_only);
BOOL locking_end(void);
BOOL lock_share_entry(connection_struct *conn,
		      SMB_DEV_T dev, SMB_INO_T inode, int *ptok);
BOOL unlock_share_entry(connection_struct *conn,
			SMB_DEV_T dev, SMB_INO_T inode, int token);
int get_share_modes(connection_struct *conn, 
		    int token, SMB_DEV_T dev, SMB_INO_T inode, 
		    share_mode_entry **shares);
void del_share_mode(int token, files_struct *fsp);
BOOL set_share_mode(int token, files_struct *fsp, uint16 port, uint16 op_type);
BOOL remove_share_oplock(int token, files_struct *fsp);
BOOL modify_share_mode(int token, files_struct *fsp, int new_mode);
int share_mode_forall(void (*fn)(share_mode_entry *, char *));
void share_status(FILE *f);

/*The following definitions come from  locking/locking_shm.c  */

struct share_ops *locking_shm_init(int ronly);

/*The following definitions come from  locking/locking_slow.c  */

struct share_ops *locking_slow_init(int ronly);

/*The following definitions come from  locking/shmem.c  */

struct shmem_ops *smb_shm_open(int ronly);

/*The following definitions come from  locking/shmem_sysv.c  */

struct shmem_ops *sysv_shm_open(int ronly);

/*The following definitions come from  param/loadparm.c  */

char *lp_logfile(void);
char *lp_smbrun(void);
char *lp_configfile(void);
char *lp_smb_passwd_file(void);
char *lp_serverstring(void);
char *lp_printcapname(void);
char *lp_lockdir(void);
char *lp_rootdir(void);
char *lp_defaultservice(void);
char *lp_msg_command(void);
char *lp_hosts_equiv(void);
char *lp_auto_services(void);
char *lp_passwd_program(void);
char *lp_passwd_chat(void);
char *lp_passwordserver(void);
char *lp_name_resolve_order(void);
char *lp_workgroup(void);
char *lp_username_map(void);
char *lp_groupname_map(void);
char *lp_logon_script(void);
char *lp_logon_path(void);
char *lp_logon_drive(void);
char *lp_logon_home(void);
char *lp_remote_announce(void);
char *lp_remote_browse_sync(void);
char *lp_wins_server(void);
char *lp_interfaces(void);
char *lp_socket_address(void);
char *lp_nis_home_map_name(void);
char *lp_netbios_aliases(void);
char *lp_driverfile(void);
char *lp_panic_action(void);
char *lp_adduser_script(void);
char *lp_deluser_script(void);
char *lp_domain_groups(void);
char *lp_domain_admin_group(void);
char *lp_domain_guest_group(void);
char *lp_domain_admin_users(void);
char *lp_domain_guest_users(void);
char *lp_ldap_server(void);
char *lp_ldap_suffix(void);
char *lp_ldap_filter(void);
char *lp_ldap_root(void);
char *lp_ldap_rootpasswd(void);
int lp_ssl_version(void);
char *lp_ssl_hosts(void);
char *lp_ssl_hosts_resign(void);
char *lp_ssl_cacertdir(void);
char *lp_ssl_cacertfile(void);
char *lp_ssl_cert(void);
char *lp_ssl_privkey(void);
char *lp_ssl_client_cert(void);
char *lp_ssl_client_privkey(void);
char *lp_ssl_ciphers(void);
BOOL lp_ssl_enabled(void);
BOOL lp_ssl_reqClientCert(void);
BOOL lp_ssl_reqServerCert(void);
BOOL lp_ssl_compatibility(void);
BOOL lp_dns_proxy(void);
BOOL lp_wins_support(void);
BOOL lp_we_are_a_wins_server(void);
BOOL lp_wins_proxy(void);
BOOL lp_local_master(void);
BOOL lp_domain_master(void);
BOOL lp_domain_logons(void);
BOOL lp_preferred_master(void);
BOOL lp_load_printers(void);
BOOL lp_use_rhosts(void);
BOOL lp_readprediction(void);
BOOL lp_readbmpx(void);
BOOL lp_readraw(void);
BOOL lp_writeraw(void);
BOOL lp_null_passwords(void);
BOOL lp_strip_dot(void);
BOOL lp_encrypted_passwords(void);
BOOL lp_update_encrypted(void);
BOOL lp_syslog_only(void);
BOOL lp_timestamp_logs(void);
BOOL lp_browse_list(void);
BOOL lp_unix_realname(void);
BOOL lp_nis_home_map(void);
BOOL lp_bind_interfaces_only(void);
BOOL lp_unix_password_sync(void);
BOOL lp_passwd_chat_debug(void);
BOOL lp_ole_locking_compat(void);
BOOL lp_nt_smb_support(void);
BOOL lp_nt_pipe_support(void);
BOOL lp_nt_acl_support(void);
BOOL lp_stat_cache(void);
BOOL lp_allow_trusted_domains(void);
BOOL lp_restrict_anonymous(void);
int lp_os_level(void);
int lp_max_ttl(void);
int lp_max_wins_ttl(void);
int lp_min_wins_ttl(void);
int lp_max_log_size(void);
int lp_max_open_files(void);
int lp_maxxmit(void);
int lp_maxmux(void);
int lp_passwordlevel(void);
int lp_usernamelevel(void);
int lp_readsize(void);
int lp_shmem_size(void);
int lp_deadtime(void);
int lp_maxprotocol(void);
int lp_security(void);
int lp_maxdisksize(void);
int lp_lpqcachetime(void);
int lp_syslog(void);
int lp_client_code_page(void);
int lp_lm_announce(void);
int lp_lm_interval(void);
int lp_machine_password_timeout(void);
int lp_change_notify_timeout(void);
int lp_stat_cache_size(void);
int lp_map_to_guest(void);
int lp_min_passwd_length(void);
int lp_oplock_break_wait_time(void);
int lp_ldap_port(void);
char *lp_preexec(int );
char *lp_postexec(int );
char *lp_rootpreexec(int );
char *lp_rootpostexec(int );
char *lp_servicename(int );
char *lp_pathname(int );
char *lp_dontdescend(int );
char *lp_username(int );
char *lp_guestaccount(int );
char *lp_invalid_users(int );
char *lp_valid_users(int );
char *lp_admin_users(int );
char *lp_printcommand(int );
char *lp_lpqcommand(int );
char *lp_lprmcommand(int );
char *lp_lppausecommand(int );
char *lp_lpresumecommand(int );
char *lp_queuepausecommand(int );
char *lp_queueresumecommand(int );
char *lp_printername(int );
char *lp_printerdriver(int );
char *lp_hostsallow(int );
char *lp_hostsdeny(int );
char *lp_magicscript(int );
char *lp_magicoutput(int );
char *lp_comment(int );
char *lp_force_user(int );
char *lp_force_group(int );
char *lp_readlist(int );
char *lp_writelist(int );
char *lp_fstype(int );
char *lp_mangled_map(int );
char *lp_veto_files(int );
char *lp_hide_files(int );
char *lp_veto_oplocks(int );
char *lp_driverlocation(int );
BOOL lp_revalidate(int );
BOOL lp_casesensitive(int );
BOOL lp_preservecase(int );
BOOL lp_shortpreservecase(int );
BOOL lp_casemangle(int );
BOOL lp_status(int );
BOOL lp_hide_dot_files(int );
BOOL lp_browseable(int );
BOOL lp_readonly(int );
BOOL lp_no_set_dir(int );
BOOL lp_guest_ok(int );
BOOL lp_guest_only(int );
BOOL lp_print_ok(int );
BOOL lp_postscript(int );
BOOL lp_map_hidden(int );
BOOL lp_map_archive(int );
BOOL lp_locking(int );
BOOL lp_strict_locking(int );
BOOL lp_share_modes(int );
BOOL lp_oplocks(int );
BOOL lp_onlyuser(int );
BOOL lp_manglednames(int );
BOOL lp_widelinks(int );
BOOL lp_symlinks(int );
BOOL lp_syncalways(int );
BOOL lp_strict_sync(int );
BOOL lp_map_system(int );
BOOL lp_delete_readonly(int );
BOOL lp_fake_oplocks(int );
BOOL lp_recursive_veto_delete(int );
BOOL lp_dos_filetimes(int );
BOOL lp_dos_filetime_resolution(int );
BOOL lp_fake_dir_create_times(int );
BOOL lp_blocking_locks(int );
BOOL lp_mangle_locks(int );
int lp_create_mode(int );
int lp_force_create_mode(int );
int lp_dir_mode(int );
int lp_force_dir_mode(int );
int lp_max_connections(int );
int lp_defaultcase(int );
int lp_minprintspace(int );
int lp_printing(int );
int lp_oplock_contention_limit(int );
char lp_magicchar(int );
BOOL lp_add_home(char *pszHomename, int iDefaultService, char *pszHomedir);
int lp_add_service(char *pszService, int iDefaultService);
BOOL lp_add_printer(char *pszPrintername, int iDefaultService);
BOOL lp_file_list_changed(void);
void *lp_local_ptr(int snum, void *ptr);
BOOL lp_do_parameter(int snum, char *pszParmName, char *pszParmValue);
BOOL lp_is_default(int snum, struct parm_struct *parm);
struct parm_struct *lp_next_parameter(int snum, int *i, int allparameters);
BOOL lp_snum_ok(int iService);
void lp_add_one_printer(char *name,char *comment);
BOOL lp_loaded(void);
void lp_killunused(BOOL (*snumused)(int ));
BOOL lp_load(char *pszFname,BOOL global_only, BOOL save_defaults, BOOL add_ipc);
void lp_resetnumservices(void);
int lp_numservices(void);
void lp_dump(FILE *f, BOOL show_defaults, int maxtoprint);
void lp_dump_one(FILE *f, BOOL show_defaults, int snum);
int lp_servicenumber(char *pszServiceName);
char *volume_label(int snum);
void lp_remove_service(int snum);
void lp_copy_service(int snum, char *new_name);
int lp_default_server_announce(void);
int lp_major_announce_version(void);
int lp_minor_announce_version(void);
void lp_set_name_resolve_order(char *new_order);
void lp_set_kernel_oplocks(BOOL val);
BOOL lp_kernel_oplocks(void);

/*The following definitions come from  param/params.c  */

BOOL pm_process( char *FileName,
                 BOOL (*sfunc)(char *),
                 BOOL (*pfunc)(char *, char *) );

/*The following definitions come from  passdb/ldap.c  */

struct passdb_ops *ldap_initialize_password_db(void);

/*The following definitions come from  passdb/nispass.c  */

struct passdb_ops *nisplus_initialize_password_db(void);

/*The following definitions come from  passdb/pass_check.c  */

void dfs_unlogin(void);
BOOL pass_check(char *user,char *password, int pwlen, struct passwd *pwd,
		BOOL (*fn)(char *, char *));

/*The following definitions come from  passdb/passdb.c  */

BOOL initialize_password_db(void);
struct smb_passwd *iterate_getsmbpwrid(uint32 user_rid);
struct smb_passwd *iterate_getsmbpwuid(uid_t smb_userid);
struct smb_passwd *iterate_getsmbpwnam(char *name);
void *startsmbpwent(BOOL update);
void endsmbpwent(void *vp);
struct smb_passwd *getsmbpwent(void *vp);
BOOL add_smbpwd_entry(struct smb_passwd *newpwd);
BOOL mod_smbpwd_entry(struct smb_passwd* pwd, BOOL override);
struct smb_passwd *getsmbpwnam(char *name);
struct smb_passwd *getsmbpwrid(uint32 user_rid);
struct smb_passwd *getsmbpwuid(uid_t smb_userid);
struct sam_passwd *iterate_getsam21pwnam(char *name);
struct sam_passwd *iterate_getsam21pwrid(uint32 rid);
struct sam_passwd *iterate_getsam21pwuid(uid_t uid);
struct sam_disp_info *getsamdisprid(uint32 rid);
struct sam_passwd *getsam21pwent(void *vp);
struct sam_passwd *getsam21pwnam(char *name);
struct sam_passwd *getsam21pwrid(uint32 rid);
void pdb_init_smb(struct smb_passwd *user);
void pdb_init_sam(struct sam_passwd *user);
struct sam_disp_info *pdb_sam_to_dispinfo(struct sam_passwd *user);
struct smb_passwd *pdb_sam_to_smb(struct sam_passwd *user);
struct sam_passwd *pdb_smb_to_sam(struct smb_passwd *user);
char *pdb_encode_acct_ctrl(uint16 acct_ctrl, size_t length);
uint16 pdb_decode_acct_ctrl(const char *p);
time_t pdb_get_last_set_time(const char *p);
void pdb_set_logon_time(char *p, int max_len, time_t t);
void pdb_set_logoff_time(char *p, int max_len, time_t t);
void pdb_set_kickoff_time(char *p, int max_len, time_t t);
void pdb_set_can_change_time(char *p, int max_len, time_t t);
void pdb_set_must_change_time(char *p, int max_len, time_t t);
void pdb_set_last_set_time(char *p, int max_len, time_t t);
void pdb_sethexpwd(char *p, char *pwd, uint16 acct_ctrl);
BOOL pdb_gethexpwd(char *p, char *pwd);
BOOL pdb_name_to_rid(char *user_name, uint32 *u_rid, uint32 *g_rid);
BOOL pdb_generate_sam_sid(void);
uid_t pdb_user_rid_to_uid(uint32 user_rid);
gid_t pdb_user_rid_to_gid(uint32 user_rid);
uint32 pdb_uid_to_user_rid(uid_t uid);
uint32 pdb_gid_to_group_rid(gid_t gid);
BOOL pdb_rid_is_user(uint32 rid);
BOOL lookup_local_rid(uint32 rid, char *name, uint8 *psid_name_use);
BOOL lookup_local_name(char *domain, char *user, DOM_SID *psid, uint8 *psid_name_use);

/*The following definitions come from  passdb/smbpass.c  */

struct passdb_ops *file_initialize_password_db(void);

/*The following definitions come from  passdb/smbpasschange.c  */

BOOL local_password_change(char *user_name, BOOL trust_account, BOOL add_user,
			   BOOL enable_user, BOOL disable_user, BOOL set_no_password,
			   char *new_passwd, 
			   char *err_str, size_t err_str_len,
			   char *msg_str, size_t msg_str_len);

/*The following definitions come from  passdb/smbpassfile.c  */

BOOL pw_file_lock(int fd, int type, int secs, int *plock_depth);
BOOL pw_file_unlock(int fd, int *plock_depth);
BOOL trust_password_lock( char *domain, char *name, BOOL update);
BOOL trust_password_unlock(void);
BOOL trust_password_delete( char *domain, char *name );
BOOL get_trust_account_password( unsigned char *ret_pwd, time_t *pass_last_set_time);
BOOL set_trust_account_password( unsigned char *md4_new_pwd);
BOOL trust_get_passwd( unsigned char trust_passwd[16], char *domain, char *myname);

/*The following definitions come from  printing/pcap.c  */

BOOL pcap_printername_ok(char *pszPrintername, char *pszPrintcapname);
void pcap_printer_fn(void (*fn)(char *, char *));

/*The following definitions come from  printing/print_svid.c  */

void sysv_printer_fn(void (*fn)(char *, char *));
int sysv_printername_ok(char *name);

/*The following definitions come from  printing/printing.c  */

void lpq_reset(int snum);
void print_file(connection_struct *conn, files_struct *file);
int get_printqueue(int snum, 
		   connection_struct *conn,print_queue_struct **queue,
		   print_status_struct *status);
void del_printqueue(connection_struct *conn,int snum,int jobid);
void status_printjob(connection_struct *conn,int snum,int jobid,int status);
int printjob_encode(int snum, int job);
void printjob_decode(int jobid, int *snum, int *job);
void status_printqueue(connection_struct *conn,int snum,int status);
void load_printers(void);

/*The following definitions come from  rpc_client/cli_login.c  */

BOOL cli_nt_setup_creds(struct cli_state *cli, unsigned char mach_pwd[16]);
BOOL cli_nt_srv_pwset(struct cli_state *cli, unsigned char *new_hashof_mach_pwd);
BOOL cli_nt_login_interactive(struct cli_state *cli, char *domain, char *username, 
                              uint32 smb_userid_low, char *password,
                              NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3);
BOOL cli_nt_login_network(struct cli_state *cli, char *domain, char *username, 
                          uint32 smb_userid_low, char lm_chal[8], char lm_chal_resp[24],
                          char nt_chal_resp[24],
                          NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3);
BOOL cli_nt_logoff(struct cli_state *cli, NET_ID_INFO_CTR *ctr);

/*The following definitions come from  rpc_client/cli_lsarpc.c  */

BOOL do_lsa_open_policy(struct cli_state *cli,
			char *server_name, POLICY_HND *hnd,
			BOOL sec_qos);
BOOL do_lsa_lookup_sids(struct cli_state *cli,
			POLICY_HND *hnd,
			int num_sids,
			DOM_SID **sids,
			char ***names,
			int *num_names);
BOOL do_lsa_query_info_pol(struct cli_state *cli,
			POLICY_HND *hnd, uint16 info_class,
			fstring domain_name, DOM_SID *domain_sid);
BOOL do_lsa_close(struct cli_state *cli, POLICY_HND *hnd);

/*The following definitions come from  rpc_client/cli_netlogon.c  */

BOOL cli_net_logon_ctrl2(struct cli_state *cli, uint32 status_level);
BOOL cli_net_auth2(struct cli_state *cli, uint16 sec_chan, 
                   uint32 neg_flags, DOM_CHAL *srv_chal);
BOOL cli_net_req_chal(struct cli_state *cli, DOM_CHAL *clnt_chal, DOM_CHAL *srv_chal);
BOOL cli_net_srv_pwset(struct cli_state *cli, uint8 hashed_mach_pwd[16]);
BOOL cli_net_sam_logon(struct cli_state *cli, NET_ID_INFO_CTR *ctr, 
                       NET_USER_INFO_3 *user_info3);
BOOL cli_net_sam_logoff(struct cli_state *cli, NET_ID_INFO_CTR *ctr);
BOOL change_trust_account_password( char *domain, char *remote_machine_list);

/*The following definitions come from  rpc_client/cli_pipe.c  */

BOOL rpc_api_pipe_req(struct cli_state *cli, uint8 op_num,
                      prs_struct *data, prs_struct *rdata);
void cli_nt_set_ntlmssp_flgs(struct cli_state *cli, uint32 ntlmssp_flgs);
BOOL cli_nt_session_open(struct cli_state *cli, char *pipe_name);
void cli_nt_session_close(struct cli_state *cli);

/*The following definitions come from  rpc_client/cli_reg.c  */

BOOL do_reg_connect(struct cli_state *cli, char *full_keyname, char *key_name,
				POLICY_HND *reg_hnd);
BOOL do_reg_open_hklm(struct cli_state *cli, uint16 unknown_0, uint32 level,
				POLICY_HND *hnd);
BOOL do_reg_open_hku(struct cli_state *cli, uint16 unknown_0, uint32 level,
				POLICY_HND *hnd);
BOOL do_reg_flush_key(struct cli_state *cli, POLICY_HND *hnd);
BOOL do_reg_query_key(struct cli_state *cli, POLICY_HND *hnd,
				char *class, uint32 *class_len,
				uint32 *num_subkeys, uint32 *max_subkeylen,
				uint32 *max_subkeysize, uint32 *num_values,
				uint32 *max_valnamelen, uint32 *max_valbufsize,
				uint32 *sec_desc, NTTIME *mod_time);
BOOL do_reg_unknown_1a(struct cli_state *cli, POLICY_HND *hnd, uint32 *unk);
BOOL do_reg_query_info(struct cli_state *cli, POLICY_HND *hnd,
				char *type, uint32 *unk_0, uint32 *unk_1);
BOOL do_reg_set_key_sec(struct cli_state *cli, POLICY_HND *hnd, SEC_DESC_BUF *sec_desc_buf);
BOOL do_reg_get_key_sec(struct cli_state *cli, POLICY_HND *hnd, uint32 *sec_buf_size, SEC_DESC_BUF **ppsec_desc_buf);
BOOL do_reg_delete_val(struct cli_state *cli, POLICY_HND *hnd, char *val_name);
BOOL do_reg_delete_key(struct cli_state *cli, POLICY_HND *hnd, char *key_name);
BOOL do_reg_create_key(struct cli_state *cli, POLICY_HND *hnd,
				char *key_name, char *key_class,
				SEC_ACCESS *sam_access,
				POLICY_HND *key);
BOOL do_reg_enum_key(struct cli_state *cli, POLICY_HND *hnd,
				int key_index, char *key_name,
				uint32 *unk_1, uint32 *unk_2,
				time_t *mod_time);
BOOL do_reg_create_val(struct cli_state *cli, POLICY_HND *hnd,
				char *val_name, uint32 type, BUFFER3 *data);
BOOL do_reg_enum_val(struct cli_state *cli, POLICY_HND *hnd,
				int val_index, int max_valnamelen, int max_valbufsize,
				fstring val_name,
				uint32 *val_type, BUFFER2 *value);
BOOL do_reg_open_entry(struct cli_state *cli, POLICY_HND *hnd,
				char *key_name, uint32 unk_0,
				POLICY_HND *key_hnd);
BOOL do_reg_close(struct cli_state *cli, POLICY_HND *hnd);

/*The following definitions come from  rpc_client/cli_samr.c  */

BOOL get_samr_query_usergroups(struct cli_state *cli, 
				POLICY_HND *pol_open_domain, uint32 user_rid,
				uint32 *num_groups, DOM_GID *gid);
BOOL get_samr_query_userinfo(struct cli_state *cli, 
				POLICY_HND *pol_open_domain,
				uint32 info_level,
				uint32 user_rid, SAM_USER_INFO_21 *usr);
BOOL do_samr_chgpasswd_user(struct cli_state *cli,
		char *srv_name, char *user_name,
		char nt_newpass[516], uchar nt_oldhash[16],
		char lm_newpass[516], uchar lm_oldhash[16]);
BOOL do_samr_unknown_38(struct cli_state *cli, char *srv_name);
BOOL do_samr_query_dom_info(struct cli_state *cli, 
				POLICY_HND *domain_pol, uint16 switch_value);
BOOL do_samr_enum_dom_users(struct cli_state *cli, 
				POLICY_HND *pol, uint16 num_entries, uint16 unk_0,
				uint16 acb_mask, uint16 unk_1, uint32 size,
				struct acct_info **sam,
				int *num_sam_users);
BOOL do_samr_connect(struct cli_state *cli, 
				char *srv_name, uint32 unknown_0,
				POLICY_HND *connect_pol);
BOOL do_samr_open_user(struct cli_state *cli, 
				POLICY_HND *pol, uint32 unk_0, uint32 rid, 
				POLICY_HND *user_pol);
BOOL do_samr_open_domain(struct cli_state *cli, 
				POLICY_HND *connect_pol, uint32 rid, DOM_SID *sid,
				POLICY_HND *domain_pol);
BOOL do_samr_query_unknown_12(struct cli_state *cli, 
				POLICY_HND *pol, uint32 rid, uint32 num_gids, uint32 *gids,
				uint32 *num_aliases,
				fstring als_names    [MAX_LOOKUP_SIDS],
				uint32  num_als_users[MAX_LOOKUP_SIDS]);
BOOL do_samr_query_usergroups(struct cli_state *cli, 
				POLICY_HND *pol, uint32 *num_groups, DOM_GID *gid);
BOOL do_samr_query_userinfo(struct cli_state *cli, 
				POLICY_HND *pol, uint16 switch_value, void* usr);
BOOL do_samr_close(struct cli_state *cli, POLICY_HND *hnd);

/*The following definitions come from  rpc_client/cli_srvsvc.c  */

BOOL do_srv_net_srv_conn_enum(struct cli_state *cli,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_CONN_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_sess_enum(struct cli_state *cli,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_SESS_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_share_enum(struct cli_state *cli,
			char *server_name, 
			uint32 switch_value, SRV_R_NET_SHARE_ENUM *r_o,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_file_enum(struct cli_state *cli,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_FILE_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_get_info(struct cli_state *cli,
			char *server_name, uint32 switch_value, SRV_INFO_CTR *ctr);

/*The following definitions come from  rpc_client/cli_wkssvc.c  */

BOOL do_wks_query_info(struct cli_state *cli, 
			char *server_name, uint32 switch_value,
			WKS_INFO_100 *wks100);

/*The following definitions come from  rpc_parse/parse_lsa.c  */

void init_lsa_trans_name(LSA_TRANS_NAME *trn, UNISTR2 *uni_name,
			uint32 sid_name_use, char *name, uint32 idx);
void init_lsa_sec_qos(LSA_SEC_QOS *qos, uint16 imp_lev, uint8 ctxt, uint8 eff,
				uint32 unknown);
void init_lsa_obj_attr(LSA_OBJ_ATTR *attr, uint32 attributes, LSA_SEC_QOS *qos);
void init_q_open_pol(LSA_Q_OPEN_POL *r_q, uint16 system_name,
			uint32 attributes,
			uint32 desired_access,
			LSA_SEC_QOS *qos);
BOOL lsa_io_q_open_pol(char *desc, LSA_Q_OPEN_POL *r_q, prs_struct *ps, int depth);
BOOL lsa_io_r_open_pol(char *desc, LSA_R_OPEN_POL *r_p, prs_struct *ps, int depth);
void init_q_open_pol2(LSA_Q_OPEN_POL2 *r_q, char *server_name,
			uint32 attributes,
			uint32 desired_access,
			LSA_SEC_QOS *qos);
BOOL lsa_io_q_open_pol2(char *desc, LSA_Q_OPEN_POL2 *r_q, prs_struct *ps, int depth);
BOOL lsa_io_r_open_pol2(char *desc, LSA_R_OPEN_POL2 *r_p, prs_struct *ps, int depth);
void init_q_query(LSA_Q_QUERY_INFO *q_q, POLICY_HND *hnd, uint16 info_class);
BOOL lsa_io_q_query(char *desc, LSA_Q_QUERY_INFO *q_q, prs_struct *ps, int depth);
BOOL lsa_io_q_enum_trust_dom(char *desc, LSA_Q_ENUM_TRUST_DOM *q_e, prs_struct *ps, int depth);
void init_r_enum_trust_dom(LSA_R_ENUM_TRUST_DOM *r_e,
                           uint32 enum_context, char *domain_name, DOM_SID *domain_sid,
                           uint32 status);
BOOL lsa_io_r_enum_trust_dom(char *desc,  LSA_R_ENUM_TRUST_DOM *r_e, prs_struct *ps, int depth);
BOOL lsa_io_r_query(char *desc, LSA_R_QUERY_INFO *r_q, prs_struct *ps, int depth);
void init_lsa_sid_enum(LSA_SID_ENUM *sen, int num_entries, DOM_SID **sids);
void init_q_lookup_sids(LSA_Q_LOOKUP_SIDS *q_l, POLICY_HND *hnd,
				int num_sids, DOM_SID **sids,
				uint16 level);
BOOL lsa_io_q_lookup_sids(char *desc, LSA_Q_LOOKUP_SIDS *q_s, prs_struct *ps, int depth);
BOOL lsa_io_r_lookup_sids(char *desc, LSA_R_LOOKUP_SIDS *r_s, prs_struct *ps, int depth);
void init_q_lookup_names(LSA_Q_LOOKUP_NAMES *q_l, POLICY_HND *hnd,
                int num_names, char **names);
BOOL lsa_io_q_lookup_names(char *desc, LSA_Q_LOOKUP_NAMES *q_r, prs_struct *ps, int depth);
BOOL lsa_io_r_lookup_names(char *desc, LSA_R_LOOKUP_NAMES *r_r, prs_struct *ps, int depth);
void init_lsa_q_close(LSA_Q_CLOSE *q_c, POLICY_HND *hnd);
BOOL lsa_io_q_close(char *desc, LSA_Q_CLOSE *q_c, prs_struct *ps, int depth);
BOOL lsa_io_r_close(char *desc,  LSA_R_CLOSE *r_c, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_misc.c  */

BOOL smb_io_time(char *desc, NTTIME *nttime, prs_struct *ps, int depth);
BOOL smb_io_lookup_level(char *desc, LOOKUP_LEVEL *level, prs_struct *ps, int depth);
uint32 get_enum_hnd(ENUM_HND *enh);
void init_enum_hnd(ENUM_HND *enh, uint32 hnd);
BOOL smb_io_enum_hnd(char *desc, ENUM_HND *hnd, prs_struct *ps, int depth);
BOOL smb_io_dom_sid(char *desc, DOM_SID *sid, prs_struct *ps, int depth);
void init_dom_sid(DOM_SID *sid, char *str_sid);
void init_dom_sid2(DOM_SID2 *sid2, DOM_SID *sid);
BOOL smb_io_dom_sid2(char *desc, DOM_SID2 *sid, prs_struct *ps, int depth);
void init_str_hdr(STRHDR *hdr, int max_len, int len, uint32 buffer);
BOOL smb_io_strhdr(char *desc,  STRHDR *hdr, prs_struct *ps, int depth);
void init_uni_hdr(UNIHDR *hdr, int len);
BOOL smb_io_unihdr(char *desc, UNIHDR *hdr, prs_struct *ps, int depth);
void init_buf_hdr(BUFHDR *hdr, int max_len, int len);
BOOL smb_io_hdrbuf_pre(char *desc, BUFHDR *hdr, prs_struct *ps, int depth, uint32 *offset);
BOOL smb_io_hdrbuf_post(char *desc, BUFHDR *hdr, prs_struct *ps, int depth, 
				uint32 ptr_hdrbuf, uint32 max_len, uint32 len);
BOOL smb_io_hdrbuf(char *desc, BUFHDR *hdr, prs_struct *ps, int depth);
void init_uni_hdr2(UNIHDR2 *hdr, int len);
BOOL smb_io_unihdr2(char *desc, UNIHDR2 *hdr2, prs_struct *ps, int depth);
void init_unistr(UNISTR *str, char *buf);
BOOL smb_io_unistr(char *desc, UNISTR *uni, prs_struct *ps, int depth);
void init_buffer3_uint32(BUFFER3 *str, uint32 val);
void init_buffer3_str(BUFFER3 *str, char *buf, int len);
void init_buffer3_hex(BUFFER3 *str, char *buf);
void init_buffer3_bytes(BUFFER3 *str, uint8 *buf, int len);
BOOL smb_io_buffer3(char *desc, BUFFER3 *buf3, prs_struct *ps, int depth);
void init_buffer2(BUFFER2 *str, uint8 *buf, int len);
BOOL smb_io_buffer2(char *desc, BUFFER2 *buf2, uint32 buffer, prs_struct *ps, int depth);
void init_buf_unistr2(UNISTR2 *str, uint32 *ptr, char *buf);
void copy_unistr2(UNISTR2 *str, UNISTR2 *from);
void init_string2(STRING2 *str, char *buf, int len);
BOOL smb_io_string2(char *desc, STRING2 *str2, uint32 buffer, prs_struct *ps, int depth);
void init_unistr2(UNISTR2 *str, char *buf, int len);
BOOL smb_io_unistr2(char *desc, UNISTR2 *uni2, uint32 buffer, prs_struct *ps, int depth);
void init_dom_rid2(DOM_RID2 *rid2, uint32 rid, uint8 type, uint32 idx);
BOOL smb_io_dom_rid2(char *desc, DOM_RID2 *rid2, prs_struct *ps, int depth);
void init_dom_rid3(DOM_RID3 *rid3, uint32 rid, uint8 type);
BOOL smb_io_dom_rid3(char *desc, DOM_RID3 *rid3, prs_struct *ps, int depth);
void init_dom_rid4(DOM_RID4 *rid4, uint16 unknown, uint16 attr, uint32 rid);
void init_log_info(DOM_LOG_INFO *log, char *logon_srv, char *acct_name,
		uint16 sec_chan, char *comp_name);
BOOL smb_io_log_info(char *desc, DOM_LOG_INFO *log, prs_struct *ps, int depth);
BOOL smb_io_chal(char *desc, DOM_CHAL *chal, prs_struct *ps, int depth);
BOOL smb_io_cred(char *desc,  DOM_CRED *cred, prs_struct *ps, int depth);
void init_clnt_info2(DOM_CLNT_INFO2 *clnt,
				char *logon_srv, char *comp_name,
				DOM_CRED *clnt_cred);
BOOL smb_io_clnt_info2(char *desc, DOM_CLNT_INFO2 *clnt, prs_struct *ps, int depth);
void init_clnt_info(DOM_CLNT_INFO *clnt,
		char *logon_srv, char *acct_name,
		uint16 sec_chan, char *comp_name,
				DOM_CRED *cred);
BOOL smb_io_clnt_info(char *desc,  DOM_CLNT_INFO *clnt, prs_struct *ps, int depth);
void init_logon_id(DOM_LOGON_ID *log, uint32 log_id_low, uint32 log_id_high);
BOOL smb_io_logon_id(char *desc, DOM_LOGON_ID *log, prs_struct *ps, int depth);
void init_owf_info(OWF_INFO *hash, uint8 data[16]);
BOOL smb_io_owf_info(char *desc, OWF_INFO *hash, prs_struct *ps, int depth);
BOOL smb_io_gid(char *desc,  DOM_GID *gid, prs_struct *ps, int depth);
BOOL smb_io_pol_hnd(char *desc, POLICY_HND *pol, prs_struct *ps, int depth);
BOOL smb_io_dom_query_3(char *desc, DOM_QUERY_3 *d_q, prs_struct *ps, int depth);
BOOL smb_io_dom_query_5(char *desc, DOM_QUERY_3 *d_q, prs_struct *ps, int depth);
BOOL smb_io_unistr3(char *desc, UNISTR3 *name, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_net.c  */

BOOL net_io_q_logon_ctrl2(char *desc, NET_Q_LOGON_CTRL2 *q_l, prs_struct *ps, int depth);
void init_r_logon_ctrl2(NET_R_LOGON_CTRL2 *r_l, uint32 query_level,
				uint32 flags, uint32 pdc_status, uint32 logon_attempts,
				uint32 tc_status, char *trusted_domain_name);
BOOL net_io_r_logon_ctrl2(char *desc, NET_R_LOGON_CTRL2 *r_l, prs_struct *ps, int depth);
void init_r_trust_dom(NET_R_TRUST_DOM_LIST *r_t,
			uint32 num_doms, char *dom_name);
BOOL net_io_r_trust_dom(char *desc, NET_R_TRUST_DOM_LIST *r_t, prs_struct *ps, int depth);
BOOL net_io_q_trust_dom(char *desc, NET_Q_TRUST_DOM_LIST *q_l, prs_struct *ps, int depth);
void init_q_req_chal(NET_Q_REQ_CHAL *q_c,
				char *logon_srv, char *logon_clnt,
				DOM_CHAL *clnt_chal);
BOOL net_io_q_req_chal(char *desc,  NET_Q_REQ_CHAL *q_c, prs_struct *ps, int depth);
BOOL net_io_r_req_chal(char *desc, NET_R_REQ_CHAL *r_c, prs_struct *ps, int depth);
void init_q_auth_2(NET_Q_AUTH_2 *q_a,
		char *logon_srv, char *acct_name, uint16 sec_chan, char *comp_name,
		DOM_CHAL *clnt_chal, uint32 clnt_flgs);
BOOL net_io_q_auth_2(char *desc, NET_Q_AUTH_2 *q_a, prs_struct *ps, int depth);
BOOL net_io_r_auth_2(char *desc, NET_R_AUTH_2 *r_a, prs_struct *ps, int depth);
void init_q_srv_pwset(NET_Q_SRV_PWSET *q_s, char *logon_srv, char *acct_name, 
                uint16 sec_chan, char *comp_name, DOM_CRED *cred, char nt_cypher[16]);
BOOL net_io_q_srv_pwset(char *desc, NET_Q_SRV_PWSET *q_s, prs_struct *ps, int depth);
BOOL net_io_r_srv_pwset(char *desc, NET_R_SRV_PWSET *r_s, prs_struct *ps, int depth);
void init_id_info1(NET_ID_INFO_1 *id, char *domain_name,
				uint32 param_ctrl, uint32 log_id_low, uint32 log_id_high,
				char *user_name, char *wksta_name,
				char sess_key[16],
				unsigned char lm_cypher[16], unsigned char nt_cypher[16]);
void init_id_info2(NET_ID_INFO_2 *id, char *domain_name,
				uint32 param_ctrl, uint32 log_id_low, uint32 log_id_high,
				char *user_name, char *wksta_name,
				unsigned char lm_challenge[8],
				unsigned char lm_chal_resp[24],
				unsigned char nt_chal_resp[24]);
void init_sam_info(DOM_SAM_INFO *sam,
				char *logon_srv, char *comp_name, DOM_CRED *clnt_cred,
				DOM_CRED *rtn_cred, uint16 logon_level,
				NET_ID_INFO_CTR *ctr);
void init_net_user_info3(NET_USER_INFO_3 *usr,

	NTTIME *logon_time,
	NTTIME *logoff_time,
	NTTIME *kickoff_time,
	NTTIME *pass_last_set_time,
	NTTIME *pass_can_change_time,
	NTTIME *pass_must_change_time,

	char *user_name,
	char *full_name,
	char *logon_script,
	char *profile_path,
	char *home_dir,
	char *dir_drive,

	uint16 logon_count,
	uint16 bad_pw_count,

	uint32 user_id,
	uint32 group_id,
	uint32 num_groups,
	DOM_GID *gids,
	uint32 user_flgs,

	char sess_key[16],

	char *logon_srv,
	char *logon_dom,

	DOM_SID *dom_sid,
	char *other_sids);
BOOL net_io_q_sam_logon(char *desc, NET_Q_SAM_LOGON *q_l, prs_struct *ps, int depth);
BOOL net_io_r_sam_logon(char *desc, NET_R_SAM_LOGON *r_l, prs_struct *ps, int depth);
BOOL net_io_q_sam_logoff(char *desc,  NET_Q_SAM_LOGOFF *q_l, prs_struct *ps, int depth);
BOOL net_io_r_sam_logoff(char *desc, NET_R_SAM_LOGOFF *r_l, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_prs.c  */

void prs_debug(prs_struct *ps, int depth, char *desc, char *fn_name);
BOOL prs_init(prs_struct *ps, uint32 size, uint8 align, BOOL io);
void prs_mem_free(prs_struct *ps);
void prs_give_memory(prs_struct *ps, char *buf, uint32 size, BOOL is_dynamic);
char *prs_take_memory(prs_struct *ps, uint32 *psize);
BOOL prs_grow(prs_struct *ps, uint32 extra_space);
BOOL prs_force_grow(prs_struct *ps, uint32 extra_space);
char *prs_data_p(prs_struct *ps);
uint32 prs_data_size(prs_struct *ps);
uint32 prs_offset(prs_struct *ps);
BOOL prs_set_offset(prs_struct *ps, uint32 offset);
BOOL prs_append_prs_data(prs_struct *dst, prs_struct *src);
BOOL prs_append_data(prs_struct *dst, char *src, uint32 len);
void prs_set_bigendian_data(prs_struct *ps);
BOOL prs_align(prs_struct *ps);
char *prs_mem_get(prs_struct *ps, uint32 extra_size);
BOOL prs_uint8(char *name, prs_struct *ps, int depth, uint8 *data8);
BOOL prs_uint16(char *name, prs_struct *ps, int depth, uint16 *data16);
BOOL prs_uint32(char *name, prs_struct *ps, int depth, uint32 *data32);
BOOL prs_uint8s(BOOL charmode, char *name, prs_struct *ps, int depth, uint8 *data8s, int len);
BOOL prs_uint32s(BOOL charmode, char *name, prs_struct *ps, int depth, uint32 *data32s, int len);
BOOL prs_buffer2(BOOL charmode, char *name, prs_struct *ps, int depth, BUFFER2 *str);
BOOL prs_string2(BOOL charmode, char *name, prs_struct *ps, int depth, STRING2 *str);
BOOL prs_unistr2(BOOL charmode, char *name, prs_struct *ps, int depth, UNISTR2 *str);
BOOL prs_unistr3(BOOL charmode, char *name, UNISTR3 *str, prs_struct *ps, int depth);
BOOL prs_unistr(char *name, prs_struct *ps, int depth, UNISTR *str);
BOOL prs_string(char *name, prs_struct *ps, int depth, char *str, uint16 len, uint16 max_buf_size);
BOOL prs_uint16_pre(char *name, prs_struct *ps, int depth, uint16 *data16, uint32 *offset);
BOOL prs_uint16_post(char *name, prs_struct *ps, int depth, uint16 *data16,
				uint32 ptr_uint16, uint32 start_offset);
BOOL prs_uint32_pre(char *name, prs_struct *ps, int depth, uint32 *data32, uint32 *offset);
BOOL prs_uint32_post(char *name, prs_struct *ps, int depth, uint32 *data32,
				uint32 ptr_uint32, uint32 data_size);

/*The following definitions come from  rpc_parse/parse_reg.c  */

void init_reg_q_open_hklm(REG_Q_OPEN_HKLM *q_o,
				uint16 unknown_0, uint32 level);
BOOL reg_io_q_open_hklm(char *desc,  REG_Q_OPEN_HKLM *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_open_hklm(char *desc,  REG_R_OPEN_HKLM *r_r, prs_struct *ps, int depth);
void init_reg_q_flush_key(REG_Q_FLUSH_KEY *q_u, POLICY_HND *pol);
BOOL reg_io_q_flush_key(char *desc,  REG_Q_FLUSH_KEY *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_flush_key(char *desc,  REG_R_FLUSH_KEY *r_r, prs_struct *ps, int depth);
void init_reg_q_create_key(REG_Q_CREATE_KEY *q_c, POLICY_HND *hnd,
				char *name, char *class, SEC_ACCESS *sam_access,
				SEC_DESC_BUF *sec_buf);
BOOL reg_io_q_create_key(char *desc,  REG_Q_CREATE_KEY *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_create_key(char *desc,  REG_R_CREATE_KEY *r_r, prs_struct *ps, int depth);
void init_reg_q_delete_val(REG_Q_DELETE_VALUE *q_c, POLICY_HND *hnd,
				char *name);
BOOL reg_io_q_delete_val(char *desc,  REG_Q_DELETE_VALUE *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_delete_val(char *desc,  REG_R_DELETE_VALUE *r_r, prs_struct *ps, int depth);
void init_reg_q_delete_key(REG_Q_DELETE_KEY *q_c, POLICY_HND *hnd,
				char *name);
BOOL reg_io_q_delete_key(char *desc,  REG_Q_DELETE_KEY *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_delete_key(char *desc,  REG_R_DELETE_KEY *r_r, prs_struct *ps, int depth);
void init_reg_q_query_key(REG_Q_QUERY_KEY *q_o, POLICY_HND *hnd,
				uint32 max_class_len);
BOOL reg_io_q_query_key(char *desc,  REG_Q_QUERY_KEY *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_query_key(char *desc,  REG_R_QUERY_KEY *r_r, prs_struct *ps, int depth);
void init_reg_q_unk_1a(REG_Q_UNK_1A *q_o, POLICY_HND *hnd);
BOOL reg_io_q_unk_1a(char *desc,  REG_Q_UNK_1A *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_unk_1a(char *desc,  REG_R_UNK_1A *r_r, prs_struct *ps, int depth);
void init_reg_q_open_hku(REG_Q_OPEN_HKU *q_o,
				uint16 unknown_0, uint32 level);
BOOL reg_io_q_open_hku(char *desc,  REG_Q_OPEN_HKU *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_open_hku(char *desc,  REG_R_OPEN_HKU *r_r, prs_struct *ps, int depth);
void init_reg_q_close(REG_Q_CLOSE *q_c, POLICY_HND *hnd);
BOOL reg_io_q_close(char *desc,  REG_Q_CLOSE *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_close(char *desc,  REG_R_CLOSE *r_u, prs_struct *ps, int depth);
void init_reg_q_set_key_sec(REG_Q_SET_KEY_SEC *q_i, POLICY_HND *pol, SEC_DESC_BUF *sec_desc_buf);
BOOL reg_io_q_set_key_sec(char *desc,  REG_Q_SET_KEY_SEC *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_set_key_sec(char *desc, REG_R_SET_KEY_SEC *r_q, prs_struct *ps, int depth);
void init_reg_q_get_key_sec(REG_Q_GET_KEY_SEC *q_i, POLICY_HND *pol, 
				uint32 sec_buf_size, SEC_DESC_BUF *psdb);
BOOL reg_io_q_get_key_sec(char *desc,  REG_Q_GET_KEY_SEC *r_q, prs_struct *ps, int depth);
BOOL reg_io_r_get_key_sec(char *desc,  REG_R_GET_KEY_SEC *r_q, prs_struct *ps, int depth);
void init_reg_q_info(REG_Q_INFO *q_i, POLICY_HND *pol, char *product_type,
				time_t unix_time, uint8 major, uint8 minor);
BOOL reg_io_q_info(char *desc,  REG_Q_INFO *r_q, prs_struct *ps, int depth);
void init_reg_r_info(REG_R_INFO *r_r,
				uint32 level, char *os_type,
				uint32 unknown_0, uint32 unknown_1,
				uint32 status);
BOOL reg_io_r_info(char *desc, REG_R_INFO *r_r, prs_struct *ps, int depth);
void init_reg_q_enum_val(REG_Q_ENUM_VALUE *q_i, POLICY_HND *pol,
				uint32 val_idx, uint32 max_val_len,
				uint32 max_buf_len);
BOOL reg_io_q_enum_val(char *desc,  REG_Q_ENUM_VALUE *q_q, prs_struct *ps, int depth);
BOOL reg_io_r_enum_val(char *desc,  REG_R_ENUM_VALUE *r_q, prs_struct *ps, int depth);
void init_reg_q_create_val(REG_Q_CREATE_VALUE *q_i, POLICY_HND *pol,
				char *val_name, uint32 type,
				BUFFER3 *val);
BOOL reg_io_q_create_val(char *desc,  REG_Q_CREATE_VALUE *q_q, prs_struct *ps, int depth);
BOOL reg_io_r_create_val(char *desc,  REG_R_CREATE_VALUE *r_q, prs_struct *ps, int depth);
void init_reg_q_enum_key(REG_Q_ENUM_KEY *q_i, POLICY_HND *pol, uint32 key_idx);
BOOL reg_io_q_enum_key(char *desc,  REG_Q_ENUM_KEY *q_q, prs_struct *ps, int depth);
BOOL reg_io_r_enum_key(char *desc,  REG_R_ENUM_KEY *r_q, prs_struct *ps, int depth);
void init_reg_q_open_entry(REG_Q_OPEN_ENTRY *r_q, POLICY_HND *pol,
				char *key_name, uint32 unk);
BOOL reg_io_q_open_entry(char *desc,  REG_Q_OPEN_ENTRY *r_q, prs_struct *ps, int depth);
void init_reg_r_open_entry(REG_R_OPEN_ENTRY *r_r,
				POLICY_HND *pol, uint32 status);
BOOL reg_io_r_open_entry(char *desc,  REG_R_OPEN_ENTRY *r_r, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_rpc.c  */

void init_rpc_hdr(RPC_HDR *hdr, enum RPC_PKT_TYPE pkt_type, uint8 flags,
				uint32 call_id, int data_len, int auth_len);
BOOL smb_io_rpc_hdr(char *desc,  RPC_HDR *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_rb(RPC_HDR_RB *rpc, 
				uint16 max_tsize, uint16 max_rsize, uint32 assoc_gid,
				uint32 num_elements, uint16 context_id, uint8 num_syntaxes,
				RPC_IFACE *abstract, RPC_IFACE *transfer);
BOOL smb_io_rpc_hdr_rb(char *desc, RPC_HDR_RB *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_ba(RPC_HDR_BA *rpc, 
				uint16 max_tsize, uint16 max_rsize, uint32 assoc_gid,
				char *pipe_addr,
				uint8 num_results, uint16 result, uint16 reason,
				RPC_IFACE *transfer);
BOOL smb_io_rpc_hdr_ba(char *desc, RPC_HDR_BA *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_req(RPC_HDR_REQ *hdr, uint32 alloc_hint, uint16 opnum);
BOOL smb_io_rpc_hdr_req(char *desc, RPC_HDR_REQ *rpc, prs_struct *ps, int depth);
BOOL smb_io_rpc_hdr_resp(char *desc, RPC_HDR_RESP *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_autha(RPC_HDR_AUTHA *rai,
				uint16 max_tsize, uint16 max_rsize,
				uint8 auth_type, uint8 auth_level,
				uint8 stub_type_len);
BOOL smb_io_rpc_hdr_autha(char *desc, RPC_HDR_AUTHA *rai, prs_struct *ps, int depth);
BOOL rpc_hdr_auth_chk(RPC_HDR_AUTH *rai);
void init_rpc_hdr_auth(RPC_HDR_AUTH *rai,
				uint8 auth_type, uint8 auth_level,
				uint8 stub_type_len,
				uint32 ptr);
BOOL smb_io_rpc_hdr_auth(char *desc, RPC_HDR_AUTH *rai, prs_struct *ps, int depth);
BOOL rpc_auth_verifier_chk(RPC_AUTH_VERIFIER *rav,
				char *signature, uint32 msg_type);
void init_rpc_auth_verifier(RPC_AUTH_VERIFIER *rav,
				char *signature, uint32 msg_type);
BOOL smb_io_rpc_auth_verifier(char *desc, RPC_AUTH_VERIFIER *rav, prs_struct *ps, int depth);
void init_rpc_auth_ntlmssp_neg(RPC_AUTH_NTLMSSP_NEG *neg,
				uint32 neg_flgs,
				fstring myname, fstring domain);
BOOL smb_io_rpc_auth_ntlmssp_neg(char *desc, RPC_AUTH_NTLMSSP_NEG *neg, prs_struct *ps, int depth);
void init_rpc_auth_ntlmssp_chal(RPC_AUTH_NTLMSSP_CHAL *chl,
				uint32 neg_flags,
				uint8 challenge[8]);
BOOL smb_io_rpc_auth_ntlmssp_chal(char *desc, RPC_AUTH_NTLMSSP_CHAL *chl, prs_struct *ps, int depth);
void init_rpc_auth_ntlmssp_resp(RPC_AUTH_NTLMSSP_RESP *rsp,
				uchar lm_resp[24], uchar nt_resp[24],
				char *domain, char *user, char *wks,
				uint32 neg_flags);
BOOL smb_io_rpc_auth_ntlmssp_resp(char *desc, RPC_AUTH_NTLMSSP_RESP *rsp, prs_struct *ps, int depth);
BOOL rpc_auth_ntlmssp_chk(RPC_AUTH_NTLMSSP_CHK *chk, uint32 crc32, uint32 seq_num);
void init_rpc_auth_ntlmssp_chk(RPC_AUTH_NTLMSSP_CHK *chk,
				uint32 ver, uint32 crc32, uint32 seq_num);
BOOL smb_io_rpc_auth_ntlmssp_chk(char *desc, RPC_AUTH_NTLMSSP_CHK *chk, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_samr.c  */

void init_samr_q_close_hnd(SAMR_Q_CLOSE_HND *q_c, POLICY_HND *hnd);
BOOL samr_io_q_close_hnd(char *desc,  SAMR_Q_CLOSE_HND *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_close_hnd(char *desc,  SAMR_R_CLOSE_HND *r_u, prs_struct *ps, int depth);
void init_samr_q_open_domain(SAMR_Q_OPEN_DOMAIN *q_u,
				POLICY_HND *connect_pol, uint32 rid,
				DOM_SID *sid);
BOOL samr_io_q_open_domain(char *desc, SAMR_Q_OPEN_DOMAIN *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_open_domain(char *desc, SAMR_R_OPEN_DOMAIN *r_u, prs_struct *ps, int depth);
void init_samr_q_unknown_2c(SAMR_Q_UNKNOWN_2C *q_u, POLICY_HND *user_pol);
BOOL samr_io_q_unknown_2c(char *desc,  SAMR_Q_UNKNOWN_2C *q_u, prs_struct *ps, int depth);
void init_samr_r_unknown_2c(SAMR_R_UNKNOWN_2C *q_u, uint32 status);
BOOL samr_io_r_unknown_2c(char *desc,  SAMR_R_UNKNOWN_2C *r_u, prs_struct *ps, int depth);
void init_samr_q_unknown_3(SAMR_Q_UNKNOWN_3 *q_u,
				POLICY_HND *user_pol, uint16 switch_value);
BOOL samr_io_q_unknown_3(char *desc,  SAMR_Q_UNKNOWN_3 *q_u, prs_struct *ps, int depth);
void init_samr_q_query_dom_info(SAMR_Q_QUERY_DOMAIN_INFO *q_u,
				POLICY_HND *domain_pol, uint16 switch_value);
BOOL samr_io_q_query_dom_info(char *desc,  SAMR_Q_QUERY_DOMAIN_INFO *q_u, prs_struct *ps, int depth);
void init_unk_info2(SAM_UNK_INFO_2 *u_2, char *domain, char *server);
BOOL sam_io_unk_info2(char *desc, SAM_UNK_INFO_2 *u_2, prs_struct *ps, int depth);
void init_samr_r_query_dom_info(SAMR_R_QUERY_DOMAIN_INFO *r_u, 
				uint16 switch_value, SAM_UNK_CTR *ctr,
				uint32 status);
BOOL samr_io_r_query_dom_info(char *desc, SAMR_R_QUERY_DOMAIN_INFO *r_u, prs_struct *ps, int depth);
void init_dom_sid3(DOM_SID3 *sid3, uint16 unk_0, uint16 unk_1, DOM_SID *sid);
void init_samr_r_unknown_3(SAMR_R_UNKNOWN_3 *r_u,
				uint16 unknown_2, uint16 unknown_3,
				uint32 unknown_4, uint16 unknown_6, uint16 unknown_7,
				int num_sid3s, DOM_SID3 sid3[MAX_SAM_SIDS],
				uint32 status);
BOOL samr_io_r_unknown_3(char *desc,  SAMR_R_UNKNOWN_3 *r_u, prs_struct *ps, int depth);
void init_samr_q_enum_dom_users(SAMR_Q_ENUM_DOM_USERS *q_e, POLICY_HND *pol,
				uint16 req_num_entries, uint16 unk_0,
				uint16 acb_mask, uint16 unk_1, uint32 size);
BOOL samr_io_q_enum_dom_users(char *desc,  SAMR_Q_ENUM_DOM_USERS *q_e, prs_struct *ps, int depth);
void init_samr_r_enum_dom_users(SAMR_R_ENUM_DOM_USERS *r_u,
		uint16 total_num_entries, uint16 unk_0,
		uint32 num_sam_entries, SAM_USER_INFO_21 pass[MAX_SAM_ENTRIES], uint32 status);
BOOL samr_io_r_enum_dom_users(char *desc,  SAMR_R_ENUM_DOM_USERS *r_u, prs_struct *ps, int depth);
void init_samr_q_enum_dom_aliases(SAMR_Q_ENUM_DOM_ALIASES *q_e, POLICY_HND *pol, uint32 size);
BOOL samr_io_q_enum_dom_aliases(char *desc,  SAMR_Q_ENUM_DOM_ALIASES *q_e, prs_struct *ps, int depth);
void init_samr_r_enum_dom_aliases(SAMR_R_ENUM_DOM_ALIASES *r_u,
		uint32 num_sam_entries, SAM_USER_INFO_21 grps[MAX_SAM_ENTRIES],
		uint32 status);
BOOL samr_io_r_enum_dom_aliases(char *desc,  SAMR_R_ENUM_DOM_ALIASES *r_u, prs_struct *ps, int depth);
void init_samr_q_query_dispinfo(SAMR_Q_QUERY_DISPINFO *q_e, POLICY_HND *pol,
				uint16 switch_level, uint32 start_idx, uint32 size);
BOOL samr_io_q_query_dispinfo(char *desc,  SAMR_Q_QUERY_DISPINFO *q_e, prs_struct *ps, int depth);
void init_sam_info_2(SAM_INFO_2 *sam, uint32 acb_mask,
		uint32 start_idx, uint32 num_sam_entries,
		SAM_USER_INFO_21 pass[MAX_SAM_ENTRIES]);
void init_sam_info_1(SAM_INFO_1 *sam, uint32 acb_mask,
		uint32 start_idx, uint32 num_sam_entries,
		SAM_USER_INFO_21 pass[MAX_SAM_ENTRIES]);
void init_samr_r_query_dispinfo(SAMR_R_QUERY_DISPINFO *r_u,
		uint16 switch_level, SAM_INFO_CTR *ctr, uint32 status);
BOOL samr_io_r_query_dispinfo(char *desc,  SAMR_R_QUERY_DISPINFO *r_u, prs_struct *ps, int depth);
void init_samr_q_enum_dom_groups(SAMR_Q_ENUM_DOM_GROUPS *q_e, POLICY_HND *pol,
				uint16 switch_level, uint32 start_idx, uint32 size);
BOOL samr_io_q_enum_dom_groups(char *desc,  SAMR_Q_ENUM_DOM_GROUPS *q_e, prs_struct *ps, int depth);
void init_samr_r_enum_dom_groups(SAMR_R_ENUM_DOM_GROUPS *r_u,
		uint32 start_idx, uint32 num_sam_entries,
		SAM_USER_INFO_21 pass[MAX_SAM_ENTRIES],
		uint32 status);
BOOL samr_io_r_enum_dom_groups(char *desc,  SAMR_R_ENUM_DOM_GROUPS *r_u, prs_struct *ps, int depth);
void init_samr_q_query_aliasinfo(SAMR_Q_QUERY_ALIASINFO *q_e,
				POLICY_HND *pol,
				uint16 switch_level);
BOOL samr_io_q_query_aliasinfo(char *desc,  SAMR_Q_QUERY_ALIASINFO *q_e, prs_struct *ps, int depth);
void init_samr_r_query_aliasinfo(SAMR_R_QUERY_ALIASINFO *r_u,
		uint16 switch_value, char *acct_desc,
		uint32 status);
BOOL samr_io_r_query_aliasinfo(char *desc,  SAMR_R_QUERY_ALIASINFO *r_u, prs_struct *ps, int depth);
BOOL samr_io_q_lookup_ids(char *desc,  SAMR_Q_LOOKUP_IDS *q_u, prs_struct *ps, int depth);
void init_samr_r_lookup_ids(SAMR_R_LOOKUP_IDS *r_u,
		uint32 num_rids, uint32 *rid, uint32 status);
BOOL samr_io_r_lookup_ids(char *desc,  SAMR_R_LOOKUP_IDS *r_u, prs_struct *ps, int depth);
BOOL samr_io_q_lookup_names(char *desc,  SAMR_Q_LOOKUP_NAMES *q_u, prs_struct *ps, int depth);
void init_samr_r_lookup_names(SAMR_R_LOOKUP_NAMES *r_u,
			uint32 num_rids, uint32 *rid, uint8 *type, uint32 status);
BOOL samr_io_r_lookup_names(char *desc,  SAMR_R_LOOKUP_NAMES *r_u, prs_struct *ps, int depth);
BOOL samr_io_q_unknown_12(char *desc,  SAMR_Q_UNKNOWN_12 *q_u, prs_struct *ps, int depth);
void init_samr_r_unknown_12(SAMR_R_UNKNOWN_12 *r_u,
		uint32 num_aliases, fstring *als_name, uint32 *num_als_usrs,
		uint32 status);
BOOL samr_io_r_unknown_12(char *desc,  SAMR_R_UNKNOWN_12 *r_u, prs_struct *ps, int depth);
void init_samr_q_open_user(SAMR_Q_OPEN_USER *q_u,
				POLICY_HND *pol,
				uint32 unk_0, uint32 rid);
BOOL samr_io_q_open_user(char *desc,  SAMR_Q_OPEN_USER *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_open_user(char *desc,  SAMR_R_OPEN_USER *r_u, prs_struct *ps, int depth);
void init_samr_q_query_usergroups(SAMR_Q_QUERY_USERGROUPS *q_u,
				POLICY_HND *hnd);
BOOL samr_io_q_query_usergroups(char *desc,  SAMR_Q_QUERY_USERGROUPS *q_u, prs_struct *ps, int depth);
void init_samr_r_query_usergroups(SAMR_R_QUERY_USERGROUPS *r_u,
		uint32 num_gids, DOM_GID *gid, uint32 status);
BOOL samr_io_r_query_usergroups(char *desc,  SAMR_R_QUERY_USERGROUPS *r_u, prs_struct *ps, int depth);
void init_samr_q_query_userinfo(SAMR_Q_QUERY_USERINFO *q_u,
				POLICY_HND *hnd, uint16 switch_value);
BOOL samr_io_q_query_userinfo(char *desc,  SAMR_Q_QUERY_USERINFO *q_u, prs_struct *ps, int depth);
void init_sam_user_info10(SAM_USER_INFO_10 *usr,
				uint32 acb_info);
BOOL sam_io_user_info10(char *desc,  SAM_USER_INFO_10 *usr, prs_struct *ps, int depth);
void init_sam_user_info11(SAM_USER_INFO_11 *usr,
				NTTIME *expiry,
				char *mach_acct,
				uint32 rid_user,
				uint32 rid_group,
				uint16 acct_ctrl);
BOOL sam_io_user_info11(char *desc,  SAM_USER_INFO_11 *usr, prs_struct *ps, int depth);
void init_sam_user_info21(SAM_USER_INFO_21 *usr,
	NTTIME *logon_time,
	NTTIME *logoff_time,
	NTTIME *kickoff_time,
	NTTIME *pass_last_set_time,
	NTTIME *pass_can_change_time,
	NTTIME *pass_must_change_time,

	char *user_name,
	char *full_name,
	char *home_dir,
	char *dir_drive,
	char *logon_script,
	char *profile_path,
	char *description,
	char *workstations,
	char *unknown_str,
	char *munged_dial,

	uint32 user_rid,
	uint32 group_rid,
	uint16 acb_info, 

	uint32 unknown_3,
	uint16 logon_divs,
	LOGON_HRS *hrs,
	uint32 unknown_5,
	uint32 unknown_6);
void init_samr_r_query_userinfo(SAMR_R_QUERY_USERINFO *r_u,
				uint16 switch_value, void *info, uint32 status);
BOOL samr_io_r_query_userinfo(char *desc,  SAMR_R_QUERY_USERINFO *r_u, prs_struct *ps, int depth);
BOOL samr_io_q_unknown_32(char *desc,  SAMR_Q_UNKNOWN_32 *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_unknown_32(char *desc,  SAMR_R_UNKNOWN_32 *r_u, prs_struct *ps, int depth);
void init_samr_q_connect(SAMR_Q_CONNECT *q_u,
				char *srv_name, uint32 unknown_0);
BOOL samr_io_q_connect(char *desc,  SAMR_Q_CONNECT *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_connect(char *desc,  SAMR_R_CONNECT *r_u, prs_struct *ps, int depth);
void init_samr_q_connect_anon(SAMR_Q_CONNECT_ANON *q_u);
BOOL samr_io_q_connect_anon(char *desc,  SAMR_Q_CONNECT_ANON *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_connect_anon(char *desc,  SAMR_R_CONNECT_ANON *r_u, prs_struct *ps, int depth);
void init_samr_q_open_alias(SAMR_Q_OPEN_ALIAS *q_u,
				uint32 unknown_0, uint32 rid);
BOOL samr_io_q_open_alias(char *desc,  SAMR_Q_OPEN_ALIAS *q_u, prs_struct *ps, int depth);
BOOL samr_io_r_open_alias(char *desc,  SAMR_R_OPEN_ALIAS *r_u, prs_struct *ps, int depth);
void init_samr_q_unknown_12(SAMR_Q_UNKNOWN_12 *q_u,
		POLICY_HND *pol, uint32 rid,
		uint32 num_gids, uint32 *gid);
void init_samr_q_unknown_21(SAMR_Q_UNKNOWN_21 *q_c,
				POLICY_HND *hnd, uint16 unk_1, uint16 unk_2);
void init_samr_q_unknown_13(SAMR_Q_UNKNOWN_13 *q_c,
				POLICY_HND *hnd, uint16 unk_1, uint16 unk_2);
void init_samr_q_unknown_38(SAMR_Q_UNKNOWN_38 *q_u, char *srv_name);
BOOL samr_io_q_unknown_38(char *desc,  SAMR_Q_UNKNOWN_38 *q_u, prs_struct *ps, int depth);
void init_samr_r_unknown_38(SAMR_R_UNKNOWN_38 *r_u);
BOOL samr_io_r_unknown_38(char *desc,  SAMR_R_UNKNOWN_38 *r_u, prs_struct *ps, int depth);
void init_enc_passwd(SAMR_ENC_PASSWD *pwd, char pass[512]);
BOOL samr_io_enc_passwd(char *desc, SAMR_ENC_PASSWD *pwd, prs_struct *ps, int depth);
void init_enc_hash(SAMR_ENC_HASH *hsh, uchar hash[16]);
BOOL samr_io_enc_hash(char *desc, SAMR_ENC_HASH *hsh, prs_struct *ps, int depth);
void init_samr_q_chgpasswd_user(SAMR_Q_CHGPASSWD_USER *q_u,
				char *dest_host, char *user_name,
				char nt_newpass[516], uchar nt_oldhash[16],
				char lm_newpass[516], uchar lm_oldhash[16]);
BOOL samr_io_q_chgpasswd_user(char *desc, SAMR_Q_CHGPASSWD_USER *q_u, prs_struct *ps, int depth);
void init_samr_r_chgpasswd_user(SAMR_R_CHGPASSWD_USER *r_u, uint32 status);
BOOL samr_io_r_chgpasswd_user(char *desc, SAMR_R_CHGPASSWD_USER *r_u, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_sec.c  */

void init_sec_access(SEC_ACCESS *t, uint32 mask);
BOOL sec_io_access(char *desc, SEC_ACCESS *t, prs_struct *ps, int depth);
void init_sec_ace(SEC_ACE *t, DOM_SID *sid, uint8 type, SEC_ACCESS mask, uint8 flag);
BOOL sec_io_ace(char *desc, SEC_ACE *psa, prs_struct *ps, int depth);
SEC_ACL *make_sec_acl(uint16 revision, int num_aces, SEC_ACE *ace_list);
SEC_ACL *dup_sec_acl( SEC_ACL *src);
void free_sec_acl(SEC_ACL **ppsa);
BOOL sec_io_acl(char *desc, SEC_ACL **ppsa, prs_struct *ps, int depth);
SEC_DESC *make_sec_desc(uint16 revision, uint16 type,
			DOM_SID *owner_sid, DOM_SID *grp_sid,
			SEC_ACL *sacl, SEC_ACL *dacl, size_t *sec_desc_size);
SEC_DESC *dup_sec_desc( SEC_DESC *src);
void free_sec_desc(SEC_DESC **ppsd);
SEC_DESC *make_standard_sec_desc(DOM_SID *owner_sid, DOM_SID *grp_sid,
				 SEC_ACL *dacl, size_t *sec_desc_size);
BOOL sec_io_desc(char *desc, SEC_DESC **ppsd, prs_struct *ps, int depth);
SEC_DESC_BUF *make_sec_desc_buf(int len, SEC_DESC *sec_desc);
SEC_DESC_BUF *dup_sec_desc_buf(SEC_DESC_BUF *src);
void free_sec_desc_buf(SEC_DESC_BUF **ppsdb);
BOOL sec_io_desc_buf(char *desc, SEC_DESC_BUF **ppsdb, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_srv.c  */

void init_srv_share_info1_str(SH_INFO_1_STR *sh1, char *net_name, char *remark);
void init_srv_share_info1(SH_INFO_1 *sh1, char *net_name, uint32 type, char *remark);
void free_srv_share_info_1(SRV_SHARE_INFO_1 *sh1);
void init_srv_share_info2_str(SH_INFO_2_STR *sh2,
				char *net_name, char *remark,
				char *path, char *passwd);
void init_srv_share_info2(SH_INFO_2 *sh2,
				char *net_name, uint32 type, char *remark,
				uint32 perms, uint32 max_uses, uint32 num_uses,
				char *path, char *passwd);
void free_srv_share_info_2(SRV_SHARE_INFO_2 *sh2);
void free_srv_share_info_ctr(SRV_SHARE_INFO_CTR *ctr);
void free_srv_q_net_share_enum(SRV_Q_NET_SHARE_ENUM *q_n);
void free_srv_r_net_share_enum(SRV_R_NET_SHARE_ENUM *r_n);
void init_srv_q_net_share_enum(SRV_Q_NET_SHARE_ENUM *q_n, 
				char *srv_name, 
				uint32 share_level, SRV_SHARE_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd);
BOOL srv_io_q_net_share_enum(char *desc, SRV_Q_NET_SHARE_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_share_enum(char *desc, SRV_R_NET_SHARE_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_sess_info0_str(SESS_INFO_0_STR *ss0, char *name);
void init_srv_sess_info0(SESS_INFO_0 *ss0, char *name);
void init_srv_sess_info1_str(SESS_INFO_1_STR *ss1, char *name, char *user);
void init_srv_sess_info1(SESS_INFO_1 *ss1, 
				char *name, char *user,
				uint32 num_opens, uint32 open_time, uint32 idle_time,
				uint32 user_flags);
void init_srv_q_net_sess_enum(SRV_Q_NET_SESS_ENUM *q_n, 
				char *srv_name, char *qual_name,
				uint32 sess_level, SRV_SESS_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd);
BOOL srv_io_q_net_sess_enum(char *desc, SRV_Q_NET_SESS_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_sess_enum(char *desc, SRV_R_NET_SESS_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_conn_info0(CONN_INFO_0 *ss0, uint32 id);
void init_srv_conn_info1_str(CONN_INFO_1_STR *ss1, char *usr_name, char *net_name);
void init_srv_conn_info1(CONN_INFO_1 *ss1, 
				uint32 id, uint32 type,
				uint32 num_opens, uint32 num_users, uint32 open_time,
				char *usr_name, char *net_name);
void init_srv_q_net_conn_enum(SRV_Q_NET_CONN_ENUM *q_n, 
				char *srv_name, char *qual_name,
				uint32 conn_level, SRV_CONN_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd);
BOOL srv_io_q_net_conn_enum(char *desc, SRV_Q_NET_CONN_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_conn_enum(char *desc,  SRV_R_NET_CONN_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_file_info3_str(FILE_INFO_3_STR *fi3, char *user_name, char *path_name);
void init_srv_file_info3(FILE_INFO_3 *fl3,
				uint32 id, uint32 perms, uint32 num_locks,
				char *path_name, char *user_name);
void init_srv_q_net_file_enum(SRV_Q_NET_FILE_ENUM *q_n, 
				char *srv_name, char *qual_name,
				uint32 file_level, SRV_FILE_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd);
BOOL srv_io_q_net_file_enum(char *desc, SRV_Q_NET_FILE_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_file_enum(char *desc, SRV_R_NET_FILE_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_info_101(SRV_INFO_101 *sv101, uint32 platform_id, char *name,
				uint32 ver_major, uint32 ver_minor,
				uint32 srv_type, char *comment);
void init_srv_info_102(SRV_INFO_102 *sv102, uint32 platform_id, char *name,
				char *comment, uint32 ver_major, uint32 ver_minor,
				uint32 srv_type, uint32 users, uint32 disc, uint32 hidden,
				uint32 announce, uint32 ann_delta, uint32 licenses,
				char *usr_path);
void init_srv_q_net_srv_get_info(SRV_Q_NET_SRV_GET_INFO *srv,
				char *server_name, uint32 switch_value);
BOOL srv_io_q_net_srv_get_info(char *desc, SRV_Q_NET_SRV_GET_INFO *q_n, prs_struct *ps, int depth);
void init_srv_r_net_srv_get_info(SRV_R_NET_SRV_GET_INFO *srv,
				uint32 switch_value, SRV_INFO_CTR *ctr, uint32 status);
BOOL srv_io_r_net_srv_get_info(char *desc, SRV_R_NET_SRV_GET_INFO *r_n, prs_struct *ps, int depth);
BOOL srv_io_q_net_remote_tod(char *desc, SRV_Q_NET_REMOTE_TOD *q_n, prs_struct *ps, int depth);
void init_time_of_day_info(TIME_OF_DAY_INFO *tod, uint32 elapsedt, uint32 msecs,
                           uint32 hours, uint32 mins, uint32 secs, uint32 hunds,
			   uint32 zone, uint32 tintervals, uint32 day,
			   uint32 month, uint32 year, uint32 weekday);
BOOL srv_io_r_net_remote_tod(char *desc, SRV_R_NET_REMOTE_TOD *r_n, prs_struct *ps, int depth);

/*The following definitions come from  rpc_parse/parse_wks.c  */

void init_wks_q_query_info(WKS_Q_QUERY_INFO *q_u,
				char *server, uint16 switch_value)  ;
BOOL wks_io_q_query_info(char *desc, WKS_Q_QUERY_INFO *q_u, prs_struct *ps, int depth);
void init_wks_info_100(WKS_INFO_100 *inf,
				uint32 platform_id, uint32 ver_major, uint32 ver_minor,
				char *my_name, char *domain_name);
void init_wks_r_query_info(WKS_R_QUERY_INFO *r_u,
				uint32 switch_value, WKS_INFO_100 *wks100,
				int status)  ;
BOOL wks_io_r_query_info(char *desc, WKS_R_QUERY_INFO *r_u, prs_struct *ps, int depth);

/*The following definitions come from  rpc_server/srv_lsa.c  */

BOOL api_ntlsa_rpc(pipes_struct *p, prs_struct *data);

/*The following definitions come from  rpc_server/srv_lsa_hnd.c  */

void init_lsa_policy_hnd(void);
BOOL open_lsa_policy_hnd(POLICY_HND *hnd);
int find_lsa_policy_by_hnd(POLICY_HND *hnd);
BOOL set_lsa_policy_samr_rid(POLICY_HND *hnd, uint32 rid);
BOOL set_lsa_policy_samr_pol_status(POLICY_HND *hnd, uint32 pol_status);
BOOL set_lsa_policy_samr_sid(POLICY_HND *hnd, DOM_SID *sid);
BOOL get_lsa_policy_samr_sid(POLICY_HND *hnd, DOM_SID *sid);
uint32 get_lsa_policy_samr_rid(POLICY_HND *hnd);
BOOL set_lsa_policy_reg_name(POLICY_HND *hnd, fstring name);
BOOL close_lsa_policy_hnd(POLICY_HND *hnd);

/*The following definitions come from  rpc_server/srv_netlog.c  */

BOOL api_netlog_rpc(pipes_struct *p, prs_struct *data);

/*The following definitions come from  rpc_server/srv_pipe.c  */

BOOL create_next_pdu(pipes_struct *p);
BOOL rpc_command(pipes_struct *p, char *input_data, int data_len);
BOOL api_rpcTNP(pipes_struct *p, char *rpc_name, struct api_struct *api_rpc_cmds,
				prs_struct *rpc_in);

/*The following definitions come from  rpc_server/srv_pipe_hnd.c  */

void set_pipe_handle_offset(int max_open_files);
void reset_chain_p(void);
void init_rpc_pipe_hnd(void);
BOOL pipe_init_outgoing_data( pipes_struct *p);
pipes_struct *open_rpc_pipe_p(char *pipe_name, 
			      connection_struct *conn, uint16 vuid);
ssize_t write_to_pipe(pipes_struct *p, char *data, size_t n);
int read_from_pipe(pipes_struct *p, char *data, int n);
BOOL wait_rpc_pipe_hnd_state(pipes_struct *p, uint16 priority);
BOOL set_rpc_pipe_hnd_state(pipes_struct *p, uint16 device_state);
BOOL close_rpc_pipe_hnd(pipes_struct *p, connection_struct *conn);
pipes_struct *get_rpc_pipe_p(char *buf, int where);
pipes_struct *get_rpc_pipe(int pnum);

/*The following definitions come from  rpc_server/srv_reg.c  */

BOOL api_reg_rpc(pipes_struct *p, prs_struct *data);

/*The following definitions come from  rpc_server/srv_samr.c  */

BOOL api_samr_rpc(pipes_struct *p, prs_struct *data);

/*The following definitions come from  rpc_server/srv_srvsvc.c  */

BOOL api_srvsvc_rpc(pipes_struct *p, prs_struct *data);

/*The following definitions come from  rpc_server/srv_util.c  */

int make_dom_gids(char *gids_str, DOM_GID **ppgids);
void get_domain_user_groups(char *domain_groups, char *user);
uint32 lookup_group_name(uint32 rid, char *group_name, uint32 *type);
uint32 lookup_alias_name(uint32 rid, char *alias_name, uint32 *type);
uint32 lookup_user_name(uint32 rid, char *user_name, uint32 *type);
uint32 lookup_group_rid(char *group_name, uint32 *rid);
uint32 lookup_alias_rid(char *alias_name, uint32 *rid);
uint32 lookup_user_rid(char *user_name, uint32 *rid);

/*The following definitions come from  rpc_server/srv_wkssvc.c  */

BOOL api_wkssvc_rpc(pipes_struct *p, prs_struct *data);

/*The following definitions come from  rpcclient/cmd_lsarpc.c  */

void cmd_lsa_query_info(struct client_info *info);
void cmd_lsa_lookup_sids(struct client_info *info);

/*The following definitions come from  rpcclient/cmd_netlogon.c  */

void cmd_netlogon_login_test(struct client_info *info);

/*The following definitions come from  rpcclient/cmd_reg.c  */

void cmd_reg_enum(struct client_info *info);
void cmd_reg_query_key(struct client_info *info);
void cmd_reg_create_val(struct client_info *info);
void cmd_reg_delete_val(struct client_info *info);
void cmd_reg_delete_key(struct client_info *info);
void cmd_reg_create_key(struct client_info *info);
void cmd_reg_test_key_sec(struct client_info *info);
void cmd_reg_get_key_sec(struct client_info *info);

/*The following definitions come from  rpcclient/cmd_samr.c  */

void cmd_sam_ntchange_pwd(struct client_info *info);
void cmd_sam_test(struct client_info *info);
void cmd_sam_enum_users(struct client_info *info);
void cmd_sam_query_user(struct client_info *info);
void cmd_sam_query_groups(struct client_info *info);
void cmd_sam_enum_aliases(struct client_info *info);

/*The following definitions come from  rpcclient/cmd_srvsvc.c  */

void cmd_srv_query_info(struct client_info *info);
void cmd_srv_enum_conn(struct client_info *info);
void cmd_srv_enum_shares(struct client_info *info);
void cmd_srv_enum_sess(struct client_info *info);
void cmd_srv_enum_files(struct client_info *info);

/*The following definitions come from  rpcclient/cmd_wkssvc.c  */

void cmd_wks_query_info(struct client_info *info);

/*The following definitions come from  rpcclient/display.c  */

char *get_file_mode_str(uint32 share_mode);
char *get_file_oplock_str(uint32 op_type);
char *get_share_type_str(uint32 type);
char *get_server_type_str(uint32 type);
void display_srv_info_101(FILE *out_hnd, enum action_type action,
		SRV_INFO_101 *sv101);
void display_srv_info_102(FILE *out_hnd, enum action_type action,SRV_INFO_102 *sv102);
void display_srv_info_ctr(FILE *out_hnd, enum action_type action,SRV_INFO_CTR *ctr);
void display_conn_info_0(FILE *out_hnd, enum action_type action,
		CONN_INFO_0 *info0);
void display_conn_info_1(FILE *out_hnd, enum action_type action,
		CONN_INFO_1 *info1, CONN_INFO_1_STR *str1);
void display_srv_conn_info_0_ctr(FILE *out_hnd, enum action_type action,
				SRV_CONN_INFO_0 *ctr);
void display_srv_conn_info_1_ctr(FILE *out_hnd, enum action_type action,
				SRV_CONN_INFO_1 *ctr);
void display_srv_conn_info_ctr(FILE *out_hnd, enum action_type action,
				SRV_CONN_INFO_CTR *ctr);
void display_share_info_1(FILE *out_hnd, enum action_type action,
		SH_INFO_1 *info1, SH_INFO_1_STR *str1);
void display_share_info_2(FILE *out_hnd, enum action_type action,
		SH_INFO_2 *info2, SH_INFO_2_STR *str2);
void display_srv_share_info_1_ctr(FILE *out_hnd, enum action_type action,
				SRV_SHARE_INFO_1 *ctr);
void display_srv_share_info_2_ctr(FILE *out_hnd, enum action_type action,
				SRV_SHARE_INFO_2 *ctr);
void display_srv_share_info_ctr(FILE *out_hnd, enum action_type action,
				SRV_SHARE_INFO_CTR *ctr);
void display_file_info_3(FILE *out_hnd, enum action_type action,
		FILE_INFO_3 *info3, FILE_INFO_3_STR *str3);
void display_srv_file_info_3_ctr(FILE *out_hnd, enum action_type action,
				SRV_FILE_INFO_3 *ctr);
void display_srv_file_info_ctr(FILE *out_hnd, enum action_type action,
				SRV_FILE_INFO_CTR *ctr);
void display_server(FILE *out_hnd, enum action_type action,
				char *sname, uint32 type, char *comment);
void display_share(FILE *out_hnd, enum action_type action,
				char *sname, uint32 type, char *comment);
void display_share2(FILE *out_hnd, enum action_type action,
				char *sname, uint32 type, char *comment,
				uint32 perms, uint32 max_uses, uint32 num_uses,
				char *path, char *passwd);
void display_name(FILE *out_hnd, enum action_type action,
				char *sname);
void display_group_rid_info(FILE *out_hnd, enum action_type action,
				uint32 num_gids, DOM_GID *gid);
void display_alias_name_info(FILE *out_hnd, enum action_type action,
				uint32 num_aliases, fstring *alias_name, uint32 *num_als_usrs);
void display_sam_user_info_21(FILE *out_hnd, enum action_type action, SAM_USER_INFO_21 *usr);
char *get_sec_mask_str(uint32 type);
void display_sec_access(FILE *out_hnd, enum action_type action, SEC_ACCESS *info);
void display_sec_ace(FILE *out_hnd, enum action_type action, SEC_ACE *ace);
void display_sec_acl(FILE *out_hnd, enum action_type action, SEC_ACL *sec_acl);
void display_sec_desc(FILE *out_hnd, enum action_type action, SEC_DESC *sec);
char *get_reg_val_type_str(uint32 type);
void display_reg_value_info(FILE *out_hnd, enum action_type action,
				char *val_name, uint32 val_type, BUFFER2 *value);
void display_reg_key_info(FILE *out_hnd, enum action_type action,
				char *key_name, time_t key_mod_time);

/*The following definitions come from  rpcclient/rpcclient.c  */

void rpcclient_init(void);

/*The following definitions come from  smbd/blocking.c  */

BOOL push_blocking_lock_request( char *inbuf, int length, int lock_timeout, int lock_num);
void remove_pending_lock_requests_by_fid(files_struct *fsp);
void remove_pending_lock_requests_by_mid(int mid);
BOOL blocking_locks_pending(void);
void process_blocking_lock_queue(time_t t);

/*The following definitions come from  smbd/chgpasswd.c  */

BOOL chgpasswd(char *name,char *oldpass,char *newpass, BOOL as_root);
BOOL check_lanman_password(char *user, uchar *pass1, 
                           uchar *pass2, struct smb_passwd **psmbpw);
BOOL change_lanman_password(struct smb_passwd *smbpw, uchar *pass1, uchar *pass2);
BOOL pass_oem_change(char *user,
			uchar *lmdata, uchar *lmhash,
			uchar *ntdata, uchar *nthash);
BOOL check_oem_password(char *user,
			uchar *lmdata, uchar *lmhash,
			uchar *ntdata, uchar *nthash,
                        struct smb_passwd **psmbpw, char *new_passwd,
                        int new_passwd_size);
BOOL change_oem_password(struct smb_passwd *smbpw, char *new_passwd, BOOL override);

/*The following definitions come from  smbd/close.c  */

int close_file(files_struct *fsp, BOOL normal_close);

/*The following definitions come from  smbd/conn.c  */

void conn_init(void);
int conn_num_open(void);
BOOL conn_snum_used(int snum);
connection_struct *conn_find(int cnum);
connection_struct *conn_new(void);
void conn_close_all(void);
BOOL conn_idle_all(time_t t, int deadtime);
void conn_free(connection_struct *conn);

/*The following definitions come from  smbd/connection.c  */

BOOL yield_connection(connection_struct *conn,char *name,int max_connections);
BOOL claim_connection(connection_struct *conn,char *name,int max_connections,BOOL Clear);

/*The following definitions come from  smbd/dfree.c  */

SMB_BIG_UINT sys_disk_free(char *path, BOOL small_query, 
                           SMB_BIG_UINT *bsize,SMB_BIG_UINT *dfree,SMB_BIG_UINT *dsize);

/*The following definitions come from  smbd/dir.c  */

void init_dptrs(void);
char *dptr_path(int key);
char *dptr_wcard(int key);
BOOL dptr_set_wcard(int key, char *wcard);
BOOL dptr_set_attr(int key, uint16 attr);
uint16 dptr_attr(int key);
void dptr_close(int *key);
void dptr_closecnum(connection_struct *conn);
void dptr_idlecnum(connection_struct *conn);
void dptr_closepath(char *path,int pid);
int dptr_create(connection_struct *conn,char *path, BOOL old_handle, BOOL expect_close,int pid);
BOOL dptr_fill(char *buf1,unsigned int key);
BOOL dptr_zero(char *buf);
void *dptr_fetch(char *buf,int *num);
void *dptr_fetch_lanman2(int dptr_num);
BOOL dir_check_ftype(connection_struct *conn,int mode,SMB_STRUCT_STAT *st,int dirtype);
BOOL get_dir_entry(connection_struct *conn,char *mask,int dirtype,char *fname,
                   SMB_OFF_T *size,int *mode,time_t *date,BOOL check_descend);
void *OpenDir(connection_struct *conn, char *name, BOOL use_veto);
void CloseDir(void *p);
char *ReadDirName(void *p);
BOOL SeekDir(void *p,int pos);
int TellDir(void *p);
void DirCacheAdd( char *path, char *name, char *dname, int snum );
char *DirCacheCheck( char *path, char *name, int snum );
void DirCacheFlush(int snum);

/*The following definitions come from  smbd/dosmode.c  */

mode_t unix_mode(connection_struct *conn,int dosmode);
int dos_mode(connection_struct *conn,char *path,SMB_STRUCT_STAT *sbuf);
int file_chmod(connection_struct *conn,char *fname,int dosmode,SMB_STRUCT_STAT *st);
int file_utime(connection_struct *conn, char *fname, struct utimbuf *times);
BOOL set_filetime(connection_struct *conn, char *fname, time_t mtime);

/*The following definitions come from  smbd/error.c  */

int cached_error_packet(char *inbuf,char *outbuf,files_struct *fsp,int line);
int unix_error_packet(char *inbuf,char *outbuf,int def_class,uint32 def_code,int line);
int error_packet(char *inbuf,char *outbuf,int error_class,uint32 error_code,int line);

/*The following definitions come from  smbd/fileio.c  */

SMB_OFF_T seek_file(files_struct *fsp,SMB_OFF_T pos);
ssize_t read_file(files_struct *fsp,char *data,SMB_OFF_T pos,size_t n);
ssize_t write_file(files_struct *fsp,char *data,size_t n);
void sync_file(connection_struct *conn, files_struct *fsp);

/*The following definitions come from  smbd/filename.c  */

void print_stat_cache_statistics(void);
BOOL unix_convert(char *name,connection_struct *conn,char *saved_last_component, 
                  BOOL *bad_path, SMB_STRUCT_STAT *pst);
BOOL check_name(char *name,connection_struct *conn);

/*The following definitions come from  smbd/files.c  */

files_struct *file_new(void );
file_fd_struct *fd_get_already_open(SMB_STRUCT_STAT *sbuf);
file_fd_struct *fd_get_new(void);
void file_close_conn(connection_struct *conn);
void file_init(void);
void file_close_user(int vuid);
files_struct *file_find_dit(SMB_DEV_T dev, SMB_INO_T inode, struct timeval *tval);
files_struct *file_find_di_first(SMB_DEV_T dev, SMB_INO_T inode);
files_struct *file_find_di_next(files_struct *start_fsp);
files_struct *file_find_print(void);
void file_sync_all(connection_struct *conn);
void fd_ptr_free(file_fd_struct *fd_ptr);
void file_free(files_struct *fsp);
files_struct *file_fsp(char *buf, int where);
void file_chain_reset(void);
void file_chain_save(void);
void file_chain_restore(void);

/*The following definitions come from  smbd/ipc.c  */

int reply_trans(connection_struct *conn, char *inbuf,char *outbuf, int size, int bufsize);

/*The following definitions come from  smbd/mangle.c  */

BOOL is_mangled( char *s );
BOOL is_8_3( char *fname, BOOL check_case );
void reset_mangled_cache( void );
BOOL check_mangled_cache( char *s );
void mangle_name_83( char *s);
BOOL name_map_mangle(char *OutName, BOOL need83, BOOL cache83, int snum);

/*The following definitions come from  smbd/message.c  */

int reply_sends(connection_struct *conn,
		char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sendstrt(connection_struct *conn,
		   char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sendtxt(connection_struct *conn,
		  char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sendend(connection_struct *conn,
		  char *inbuf,char *outbuf, int dum_size, int dum_buffsize);

/*The following definitions come from  smbd/negprot.c  */

int reply_negprot(connection_struct *conn, 
		  char *inbuf,char *outbuf, int dum_size, 
		  int dum_buffsize);

/*The following definitions come from  smbd/noquotas.c  */

BOOL disk_quotas(char *path,SMB_BIG_UINT *bsize,SMB_BIG_UINT *dfree,SMB_BIG_UINT *dsize);

/*The following definitions come from  smbd/nttrans.c  */

void fail_next_srvsvc_open(void);
BOOL should_fail_next_srvsvc_open(const char *pipename);
int reply_ntcreate_and_X(connection_struct *conn,
			 char *inbuf,char *outbuf,int length,int bufsize);
int reply_ntcancel(connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize);
int reply_nttranss(connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize);
void remove_pending_change_notify_requests_by_fid(files_struct *fsp);
void remove_pending_change_notify_requests_by_filename(files_struct *fsp);
void process_pending_change_notify_queue(time_t t);
int reply_nttrans(connection_struct *conn,
		  char *inbuf,char *outbuf,int length,int bufsize);

/*The following definitions come from  smbd/open.c  */

void fd_add_to_uid_cache(file_fd_struct *fd_ptr, uid_t u);
uint16 fd_attempt_close(file_fd_struct *fd_ptr, int *err_ret);
void open_file_shared(files_struct *fsp,connection_struct *conn,char *fname,int share_mode,int ofun,
		      mode_t mode,int oplock_request, int *Access,int *action);
int open_file_stat(files_struct *fsp,connection_struct *conn,
		   char *fname, int smb_ofun, SMB_STRUCT_STAT *pst, int *action);
int open_directory(files_struct *fsp,connection_struct *conn,
		   char *fname, int smb_ofun, mode_t unixmode, int *action);
BOOL check_file_sharing(connection_struct *conn,char *fname, BOOL rename_op);

/*The following definitions come from  smbd/oplock.c  */

int32 get_number_of_open_oplocks(void);
BOOL setup_kernel_oplock_pipe(void);
BOOL open_oplock_ipc(void);
BOOL receive_local_message(fd_set *fds, char *buffer, int buffer_len, int timeout);
BOOL set_file_oplock(files_struct *fsp);
void release_file_oplock(files_struct *fsp);
int setup_oplock_select_set( fd_set *fds);
BOOL process_local_message(char *buffer, int buf_size);
BOOL request_oplock_break(share_mode_entry *share_entry, 
                          SMB_DEV_T dev, SMB_INO_T inode);
BOOL attempt_close_oplocked_file(files_struct *fsp);
void check_kernel_oplocks(void);

/*The following definitions come from  smbd/password.c  */

void generate_next_challenge(char *challenge);
BOOL set_challenge(unsigned char *challenge);
user_struct *get_valid_user_struct(uint16 vuid);
void invalidate_vuid(uint16 vuid);
char *validated_username(uint16 vuid);
int setup_groups(char *user, uid_t uid, gid_t gid, int *p_ngroups, gid_t **p_groups);
uint16 register_vuid(uid_t uid,gid_t gid, char *unix_name, char *requested_name, BOOL guest);
void add_session_user(char *user);
BOOL smb_password_check(char *password, unsigned char *part_passwd, unsigned char *c8);
BOOL smb_password_ok(struct smb_passwd *smb_pass, uchar chal[8],
                     uchar lm_pass[24], uchar nt_pass[24]);
BOOL pass_check_smb(char *user, char *domain,
		uchar *chal, uchar *lm_pwd, uchar *nt_pwd,
		struct passwd *pwd);
BOOL password_ok(char *user, char *password, int pwlen, struct passwd *pwd);
BOOL user_ok(char *user,int snum);
BOOL authorise_login(int snum,char *user,char *password, int pwlen, 
		     BOOL *guest,BOOL *force,uint16 vuid);
BOOL check_hosts_equiv(char *user);
struct cli_state *server_client(void);
struct cli_state *server_cryptkey(void);
BOOL server_validate(char *user, char *domain, 
		     char *pass, int passlen,
		     char *ntpass, int ntpasslen);
BOOL domain_client_validate( char *user, char *domain, 
                             char *smb_apasswd, int smb_apasslen, 
                             char *smb_ntpasswd, int smb_ntpasslen,
                             BOOL *user_exists);

/*The following definitions come from  smbd/pipes.c  */

int reply_open_pipe_and_X(connection_struct *conn,
			  char *inbuf,char *outbuf,int length,int bufsize);
int reply_pipe_write_and_X(char *inbuf,char *outbuf,int length,int bufsize);
int reply_pipe_read_and_X(char *inbuf,char *outbuf,int length,int bufsize);
int reply_pipe_close(connection_struct *conn, char *inbuf,char *outbuf);

/*The following definitions come from  smbd/predict.c  */

ssize_t read_predict(int fd,SMB_OFF_T offset,char *buf,char **ptr,size_t num);
void do_read_prediction(void);
void invalidate_read_prediction(int fd);

/*The following definitions come from  smbd/process.c  */

BOOL push_oplock_pending_smb_message(char *buf, int msg_len);
BOOL receive_next_smb(char *inbuf, int bufsize, int timeout);
void respond_to_all_remaining_local_messages(void);
void process_smb(char *inbuf, char *outbuf);
char *smb_fn_name(int type);
void construct_reply_common(char *inbuf,char *outbuf);
int chain_reply(char *inbuf,char *outbuf,int size,int bufsize);
void smbd_process(void);

/*The following definitions come from  smbd/reply.c  */

int reply_special(char *inbuf,char *outbuf);
int reply_tcon(connection_struct *conn,
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_tcon_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_unknown(char *inbuf,char *outbuf);
int reply_ioctl(connection_struct *conn,
		char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sesssetup_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_chkpth(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_getatr(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_setatr(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_dskattr(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_search(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_fclose(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_open(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_open_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_ulogoffX(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_mknew(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_ctemp(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_unlink(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_readbraw(connection_struct *conn, char *inbuf, char *outbuf, int dum_size, int dum_buffsize);
int reply_lockread(connection_struct *conn, char *inbuf,char *outbuf, int length, int dum_buffsiz);
int reply_read(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_read_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_writebraw(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_writeunlock(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_write(connection_struct *conn, char *inbuf,char *outbuf,int size,int dum_buffsize);
int reply_write_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_lseek(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_flush(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_exit(connection_struct *conn, 
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_close(connection_struct *conn, char *inbuf,char *outbuf, int size,
                int dum_buffsize);
int reply_writeclose(connection_struct *conn,
		     char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_lock(connection_struct *conn,
	       char *inbuf,char *outbuf, int length, int dum_buffsize);
int reply_unlock(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_tdis(connection_struct *conn, 
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_echo(connection_struct *conn,
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printopen(connection_struct *conn, 
		    char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printclose(connection_struct *conn,
		     char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printqueue(connection_struct *conn,
		     char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printwrite(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_mkdir(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
BOOL rmdir_internals(connection_struct *conn, char *directory);
int reply_rmdir(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int rename_internals(connection_struct *conn, 
		     char *inbuf, char *outbuf, char *name, 
		     char *newname, BOOL replace_if_exists);
int reply_mv(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_copy(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_setdir(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
SMB_OFF_T get_lock_count( char *data, int data_offset, BOOL large_file_format, BOOL mangle_locks, BOOL *err);
uint32 map_lock_offset(uint32 high, uint32 low);
SMB_OFF_T get_lock_offset( char *data, int data_offset, BOOL large_file_format, BOOL mangle_locks, BOOL *err);
int reply_lockingX(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_readbmpx(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_writebmpx(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_writebs(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_setattrE(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_getattrE(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);

/*The following definitions come from  smbd/server.c  */

BOOL reload_services(BOOL test);
void exit_server(char *reason);

/*The following definitions come from  smbd/service.c  */

BOOL become_service(connection_struct *conn,BOOL do_chdir);
int find_service(char *service);
connection_struct *make_connection(char *service,char *user,char *password, int pwlen, char *dev,uint16 vuid, int *ecode);
void close_cnum(connection_struct *conn, uint16 vuid);

/*The following definitions come from  smbd/ssl.c  */

int sslutil_init(int isServer);
int sslutil_accept(int fd);
int sslutil_fd_is_ssl(int fd);
int sslutil_connect(int fd);
int sslutil_disconnect(int fd);
int sslutil_negotiate_ssl(int fd, int msg_type);

/*The following definitions come from  smbd/trans2.c  */

void mask_convert( char *mask);
int reply_findclose(connection_struct *conn,
		    char *inbuf,char *outbuf,int length,int bufsize);
int reply_findnclose(connection_struct *conn, 
		     char *inbuf,char *outbuf,int length,int bufsize);
int reply_transs2(connection_struct *conn,
		  char *inbuf,char *outbuf,int length,int bufsize);
int reply_trans2(connection_struct *conn,
		 char *inbuf,char *outbuf,int length,int bufsize);

/*The following definitions come from  smbd/uid.c  */

void init_uid(void);
BOOL become_guest(void);
BOOL become_user(connection_struct *conn, uint16 vuid);
BOOL unbecome_user(void );
BOOL become_authenticated_pipe_user(pipes_struct *p);
BOOL unbecome_authenticated_pipe_user(pipes_struct *p);
void become_root(BOOL save_dir) ;
void unbecome_root(BOOL restore_dir);

/*The following definitions come from  smbwrapper/realcalls.c  */

int real_utime(const char *name, struct utimbuf *buf);
int real_utimes(const char *name, struct timeval tv[2]);

/*The following definitions come from  smbwrapper/shared.c  */

void smbw_setup_shared(void);
char *smbw_getshared(const char *name);
void smbw_setshared(const char *name, const char *val);
int smbw_setenv(const char *name, const char *value);
int smbw_shared_fd(int fd);

/*The following definitions come from  smbwrapper/smbw.c  */

void smbw_init(void);
int smbw_fd(int fd);
int smbw_local_fd(int fd);
ino_t smbw_inode(const char *name);
void clean_fname(char *name);
char *smbw_parse_path(const char *fname, char *server, char *share, char *path);
int smbw_path(const char *path);
int smbw_errno(struct cli_state *c);
struct smbw_server *smbw_server(char *server, char *share);
struct smbw_file *smbw_file(int fd);
int smbw_open(const char *fname, int flags, mode_t mode);
ssize_t smbw_pread(int fd, void *buf, size_t count, off_t ofs);
ssize_t smbw_read(int fd, void *buf, size_t count);
ssize_t smbw_write(int fd, void *buf, size_t count);
ssize_t smbw_pwrite(int fd, void *buf, size_t count, off_t ofs);
int smbw_close(int fd);
int smbw_fcntl(int fd, int cmd, long arg);
int smbw_access(const char *name, int mode);
int smbw_readlink(const char *path, char *buf, size_t bufsize);
int smbw_unlink(const char *fname);
int smbw_rename(const char *oldname, const char *newname);
int smbw_utime(const char *fname, void *buf);
int smbw_utimes(const char *fname, void *buf);
int smbw_chown(const char *fname, uid_t owner, gid_t group);
int smbw_chmod(const char *fname, mode_t newmode);
off_t smbw_lseek(int fd, off_t offset, int whence);
int smbw_dup(int fd);
int smbw_dup2(int fd, int fd2);
int smbw_fork(void);

/*The following definitions come from  smbwrapper/smbw_dir.c  */

struct smbw_dir *smbw_dir(int fd);
int smbw_dirp(DIR *dirp);
int smbw_dir_open(const char *fname);
int smbw_dir_fstat(int fd, struct stat *st);
int smbw_dir_close(int fd);
int smbw_getdents(unsigned int fd, struct dirent *dirp, int count);
int smbw_chdir(const char *name);
off_t smbw_dir_lseek(int fd, off_t offset, int whence);
int smbw_mkdir(const char *fname, mode_t mode);
int smbw_rmdir(const char *fname);
char *smbw_getcwd(char *buf, size_t size);
int smbw_fchdir(unsigned int fd);
DIR *smbw_opendir(const char *fname);
struct dirent *smbw_readdir(DIR *dirp);
int smbw_closedir(DIR *dirp);
void smbw_seekdir(DIR *dirp, off_t offset);
off_t smbw_telldir(DIR *dirp);

/*The following definitions come from  smbwrapper/smbw_stat.c  */

void smbw_setup_stat(struct stat *st, char *fname, size_t size, int mode);
BOOL smbw_getatr(struct smbw_server *srv, char *path, 
		 uint16 *mode, size_t *size, 
		 time_t *c_time, time_t *a_time, time_t *m_time,
		 SMB_INO_T *ino);
int smbw_stat_printjob(struct smbw_server *srv,char *path,
		       size_t *size, time_t *m_time);
int smbw_fstat(int fd, struct stat *st);
int smbw_stat(const char *fname, struct stat *st);

/*The following definitions come from  utils/nbio.c  */

void nb_setup(struct cli_state *cli);
void nb_unlink(char *fname);
void nb_open(char *fname, int handle, int size);
void nb_write(int handle, int size, int offset);
void nb_read(int handle, int size, int offset);
void nb_close(int handle);
void nb_mkdir(char *fname);
void nb_rmdir(char *fname);
void nb_rename(char *old, char *new);
void nb_stat(char *fname, int size);
void nb_create(char *fname, int size);

/*The following definitions come from  utils/torture.c  */


/*The following definitions come from  web/cgi.c  */

void cgi_load_variables(FILE *f1);
char *cgi_variable(char *name);
BOOL am_root(void);
char *cgi_user_name(void);
void cgi_setup(char *rootdir, int auth_required);
char *cgi_baseurl(void);
char *cgi_pathinfo(void);
char *cgi_remote_host(void);
char *cgi_remote_addr(void);
BOOL cgi_waspost(void);

/*The following definitions come from  web/diagnose.c  */

BOOL nmbd_running(void);
BOOL smbd_running(void);

/*The following definitions come from  web/startstop.c  */

void start_smbd(void);
void start_nmbd(void);
void stop_smbd(void);
void stop_nmbd(void);
void kill_pid(pid_t pid);

/*The following definitions come from  web/statuspage.c  */

void status_page(void);

/*The following definitions come from  web/swat.c  */

#endif /* _PROTO_H_ */
