/* -*-c-*- ---------------- mixgtk_mixal.h :
 * Declarations for functions displaying the mixal source file
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: <01/03/31 01:02:31 jose>
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#ifndef MIXGTK_MIXAL_H
#define MIXGTK_MIXAL_H

#include <gtk/gtk.h>
#include <mixlib/mix_vm.h>

/* initialise the mixal widget */
extern gboolean
mixgtk_mixal_init (mix_vm_t *vm);

/* set the location pointer and break colors */
extern void
mixgtk_mixal_set_loc_color (GdkColor *bg, GdkColor *fg);

extern void
mixgtk_mixal_set_break_color (GdkColor *bg, GdkColor *fg);


/* load the corresponding mixal file */
extern void
mixgtk_mixal_load_file (void);

/* update the widget */
extern void
mixgtk_mixal_update (void);

/* breakpoints */
extern void
mixgtk_mixal_update_bp_at_address (guint addr);

extern void
mixgtk_mixal_update_bp_at_line (guint line);

extern void
mixgtk_mixal_update_bp_all (void);


/* callbacks */
extern void
on_mixal_select_row (GtkWidget *w, gint row, gint col, GdkEventButton *e,
		     gpointer data);

#endif /* MIXGTK_MIXAL_H */

