/* -*-c-*- -------------- mixgtk_gen_handlers.c :
 * Implementation of the functions declared in mixgtk_gen_handlers.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "01/03/16 00:30:40 jose"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <mixlib/mix_vm_command.h>
#include "mixgtk_gen_handlers.h"
#include "mixgtk_cmd_dispatcher.h"

void
on_main_window_destroy (GtkWidget *w, gpointer data)
{
  gtk_main_quit ();
}

static void
on_file_open_ok_ (GtkWidget *w, gpointer fs)
{
  const gchar *file = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  gchar *command = g_strdup_printf ("%s %s",
				    mix_vm_command_to_string (MIX_CMD_LOAD),
				    file);
  gtk_widget_destroy (GTK_WIDGET (fs));
  mixgtk_cmd_dispatcher_dispatch (command);
  g_free (command);
}

static void
on_file_open_destroy_ (GtkWidget *w, gpointer data)
{
  gtk_grab_remove (GTK_WIDGET (w));
}
  
void
on_file_open_activate (GtkWidget *w, gpointer data)
{
  GtkWidget *file = gtk_file_selection_new ("Open program");
  gtk_signal_connect (GTK_OBJECT (file), "destroy",
		      (GtkSignalFunc) on_file_open_destroy_,
		      GTK_OBJECT (file));
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file)->ok_button),
		      "clicked", (GtkSignalFunc) on_file_open_ok_,
		      GTK_OBJECT (file));
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (file)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (file));
  gtk_widget_show (file);
  gtk_grab_add (file);
}

void
on_debug_run_activate (GtkWidget *w, gpointer p)
{
  mixgtk_cmd_dispatcher_dispatch (mix_vm_command_to_string (MIX_CMD_RUN));
}

void
on_debug_next_activate (GtkWidget *w, gpointer p)
{
  mixgtk_cmd_dispatcher_dispatch (mix_vm_command_to_string (MIX_CMD_NEXT));
}


void
on_file_exit_activate (GtkWidget *w, gpointer data)
{
  gtk_main_quit ();
}


void
on_clear_breakpoints_activate (GtkWidget *w, gpointer data)
{
  mixgtk_cmd_dispatcher_dispatch (mix_vm_command_to_string (MIX_CMD_CABP));
}

