/* GNU moe - My Own Editor
   Copyright (C) 2005-2021 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Block {

Buffer * bufferp();
Point & anchor();		// anchor for marking
Point & begin();
Point & end();

bool in_block( const Buffer & buffer, const Point & p );
bool in_block_or_end( const Buffer & buffer, const Point & p );
bool valid();

void save_block_position();
void restore_block_position();
void reset();
void set_block( Buffer & buffer, const Point & p1, const Point & p2 );
void set_begin( Buffer & buffer, const Point & p );
void set_end( Buffer & buffer, const Point & p );

void disable_marking();
bool follow_marking( const Buffer & buffer, const Point & p );
const char * toggle_marking( Buffer & buffer, const Point & p );

bool copy_block( Buffer & buffer, const Point & p, const bool move = false );
bool delete_block();

} // end namespace Block
